/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

public interface MongoDBAuthenticationMixins {
    @SetFromFlag("mongodbKeyfileContents")
    ConfigKey<String> MONGODB_KEYFILE_CONTENTS = ConfigKeys.newStringConfigKey(
            "mongodb.keyfile.contents", "Contents of the keyfile used for authentication. If mongodb.keyfile.contents and mongodb.keyfile.url are both set, mongodb.keyfile.contents will take precedence");

    @SetFromFlag("mongodbKeyfileUrl")
    ConfigKey<String> MONGODB_KEYFILE_URL = ConfigKeys.newStringConfigKey(
            "mongodb.keyfile.url", "Location of the keyfile used for authentication. If mongodb.keyfile.contents and mongodb.keyfile.url are both set, mongodb.keyfile.contents will take precedence");

    @SetFromFlag("rootUsername")
    BasicAttributeSensorAndConfigKey<String> ROOT_USERNAME =
            new BasicAttributeSensorAndConfigKey<>(String.class, "mongodb.root.username", "Username of the initial admin user", "superuser");

    @SetFromFlag("rootPassword")
    BasicAttributeSensorAndConfigKey<String> ROOT_PASSWORD =
            new BasicAttributeSensorAndConfigKey<>(String.class, "mongodb.root.password", "Password for the initial admin user, auto-generated if not set");

    @SetFromFlag("authenticationDatabase")
    BasicAttributeSensorAndConfigKey<String> AUTHENTICATION_DATABASE =
            new BasicAttributeSensorAndConfigKey<>(String.class, "mongodb.authentication.database", "Database to be used to store authentication details (if used)", "admin");

    AttributeSensor<String> MONGODB_KEYFILE_DESTINATION = Sensors.newStringSensor("mongodb.keyfile.destination",
            "Destination of the keyfile used for authentication on the target server");
}
