/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class RegionToCDNEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> endpointsSupplier;

    @Inject
    public RegionToCDNEndpoint(@ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
        this.endpointsSupplier = factory.createForApiTypeAndVersion("rax:object-cdn", apiVersion);
    }

    public URI apply(@Nullable Object from) {
        Preconditions.checkArgument((from != null && from instanceof String ? 1 : 0) != 0, (Object)"you must specify a region, as a String argument");
        Map regionToEndpoint = (Map)this.endpointsSupplier.get();
        Preconditions.checkState((!regionToEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no region name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)regionToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object[])new Object[]{from, regionToEndpoint});
        return (URI)((Supplier)regionToEndpoint.get(from)).get();
    }
}

