/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.base.Functions;
import com.google.common.net.HostAndPort;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseSyncGateway;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseSyncGatewayDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;

public class CouchbaseSyncGatewayImpl
extends SoftwareProcessImpl
implements CouchbaseSyncGateway {
    private HttpFeed httpFeed;

    public Class<CouchbaseSyncGatewayDriver> getDriverInterface() {
        return CouchbaseSyncGatewayDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
    }

    protected void connectServiceUpIsRunning() {
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)CouchbaseSyncGateway.ADMIN_REST_API_PORT)));
        String managementUri = String.format("http://%s:%s", hp.getHostText(), hp.getPort());
        this.sensors().set(MANAGEMENT_URL, (Object)managementUri);
        this.httpFeed = HttpFeed.builder().entity((Entity)this).period(200L).baseUri(managementUri).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    protected void disconnectServiceUpIsRunning() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }

    static {
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

