/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.huc;

import java.io.IOException;
import okhttp3.Request;
import okhttp3.internal.huc.OutputStreamRequestBody;
import okio.Buffer;
import okio.BufferedSink;

final class BufferedRequestBody
extends OutputStreamRequestBody {
    final Buffer buffer = new Buffer();
    long contentLength = -1L;

    BufferedRequestBody(long expectedContentLength) {
        this.initOutputStream((BufferedSink)this.buffer, expectedContentLength);
    }

    @Override
    public long contentLength() throws IOException {
        return this.contentLength;
    }

    @Override
    public Request prepareToSendRequest(Request request) throws IOException {
        if (request.header("Content-Length") != null) {
            return request;
        }
        this.outputStream().close();
        this.contentLength = this.buffer.size();
        return request.newBuilder().removeHeader("Transfer-Encoding").header("Content-Length", Long.toString(this.buffer.size())).build();
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        this.buffer.copyTo(sink.buffer(), 0L, this.buffer.size());
    }
}

