/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.pdp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.camp.spi.pdp.ArtifactContent;
import org.apache.brooklyn.camp.spi.pdp.ArtifactRequirement;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.yaml.Yamls;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Artifact {
    String name;
    String description;
    String artifactType;
    ArtifactContent content;
    List<ArtifactRequirement> requirements;
    Map<String, Object> customAttributes;

    public static Artifact of(Map<String, Object> artifact) {
        MutableMap fields = MutableMap.copyOf(artifact);
        Artifact result = new Artifact();
        result.name = (String)fields.remove("name");
        result.description = (String)fields.remove("description");
        result.artifactType = (String)Yamls.removeMultinameAttribute((Map)fields, (String[])new String[]{"artifactType", "type"});
        result.content = ArtifactContent.of(fields.remove("content"));
        result.requirements = new ArrayList<ArtifactRequirement>();
        Object reqs = fields.remove("requirements");
        if (reqs instanceof Iterable) {
            for (Object req : (Iterable)reqs) {
                if (req instanceof Map) {
                    result.requirements.add(ArtifactRequirement.of((Map)req));
                    continue;
                }
                throw new IllegalArgumentException("requirement should be a map, not " + req.getClass());
            }
        } else if (reqs != null) {
            throw new IllegalArgumentException("artifacts body should be iterable, not " + reqs.getClass());
        }
        result.customAttributes = fields;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public ArtifactContent getContent() {
        return this.content;
    }

    public List<ArtifactRequirement> getRequirements() {
        return ImmutableList.copyOf(this.requirements);
    }

    public Map<String, Object> getCustomAttributes() {
        return ImmutableMap.copyOf(this.customAttributes);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

