/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserMetadataStringOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(UserMetadataStringOption.class);

    UserMetadataStringOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (t instanceof EC2TemplateOptions) {
            if (v == null) {
                return;
            }
            String data = v.toString();
            if (!data.startsWith("<script>") && !data.startsWith("<powershell>")) {
                data = "<script> " + data + " </script>";
            }
            ((EC2TemplateOptions)t).userData(data.getBytes());
        } else if (t instanceof SoftLayerTemplateOptions) {
            ((SoftLayerTemplateOptions)t).userData(Strings.toString((Object)v));
        } else {
            Class<?> clazz = t.getClass();
            Method userDataMethod = null;
            try {
                userDataMethod = clazz.getMethod("userData", String.class);
            }
            catch (SecurityException e) {
                LOG.info("Problem reflectively inspecting methods of " + t.getClass() + " for setting userData", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                try {
                    userDataMethod = clazz.getMethod("guestCustomizationScript", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (userDataMethod != null) {
                try {
                    userDataMethod.invoke((Object)t, Strings.toString((Object)v));
                }
                catch (InvocationTargetException e) {
                    LOG.info("Problem invoking " + userDataMethod.getName() + " of " + t.getClass() + ", for setting userData (rethrowing)", (Throwable)e);
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.debug("Unable to reflectively invoke " + userDataMethod.getName() + " of " + t.getClass() + ", for setting userData (rethrowing)", (Throwable)e);
                    throw Exceptions.propagate((Throwable)e);
                }
            } else {
                LOG.info("ignoring userDataString({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
            }
        }
    }
}

