/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.softlayer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.VirtualGuestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SoftLayerSameVlanLocationCustomizer
extends BasicJcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(SoftLayerSameVlanLocationCustomizer.class);
    @SetFromFlag(value="scopeUid")
    public static final ConfigKey<String> SCOPE_UID = ConfigKeys.newStringConfigKey((String)"softlayer.vlan.scopeUid", (String)"The unique identifier for a Softlayer location scope that will have VMs created in the same VLAN");
    @SetFromFlag(value="scopeTimeout")
    public static final ConfigKey<Duration> SCOPE_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"softlayer.vlan.timeout", (String)"The length of time to wait for a Softlayer VLAN ID", (Duration)Duration.minutes((Number)15));
    public static final ConfigKey<Map<String, CountDownLatch>> COUNTDOWN_LATCH_MAP = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, CountDownLatch>>(){}, (String)"softLayerSameVlanLocationCustomizer.map.latches", (String)"A mapping from scope identifiers to CountDownLatches; used to synchronize threads");
    public static final ConfigKey<Map<String, Integer>> PUBLIC_VLAN_ID_MAP = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Integer>>(){}, (String)"softLayerSameVlanLocationCustomizer.map.publicVlanIds", (String)"A mapping from scope identifiers to public VLAN numbers");
    public static final ConfigKey<Map<String, Integer>> PRIVATE_VLAN_ID_MAP = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Integer>>(){}, (String)"softLayerSameVlanLocationCustomizer.map.privateVlanIds", (String)"A mapping from scope identifiers to private VLAN numbers");
    public static final AttributeSensor<Integer> PUBLIC_VLAN_ID = Sensors.newIntegerSensor((String)"softLayer.vlan.publicId", (String)"The public VLAN ID for this entity");
    public static final AttributeSensor<Integer> PRIVATE_VLAN_ID = Sensors.newIntegerSensor((String)"softLayer.vlan.privateId", (String)"The private VLAN ID for this entity");
    private static final transient Object lock = new Object[0];

    public static SoftLayerSameVlanLocationCustomizer forScope(String scopeUid) {
        SoftLayerSameVlanLocationCustomizer customizer = new SoftLayerSameVlanLocationCustomizer();
        customizer.config().set(SCOPE_UID, (Object)scopeUid);
        return customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateOptions templateOptions) {
        String provider = location.getProvider();
        if (!provider.equals("softlayer") || !(templateOptions instanceof SoftLayerTemplateOptions)) {
            String message = String.format("Invalid location provider or template options: %s/%s", provider, templateOptions.getClass().getSimpleName());
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        String scopeUid = this.getScopeUid(location);
        SoftLayerTemplateOptions softLayerOptions = (SoftLayerTemplateOptions)templateOptions;
        Integer publicVlanId = softLayerOptions.getPrimaryNetworkComponentNetworkVlanId();
        Integer privateVlanId = softLayerOptions.getPrimaryBackendNetworkComponentNetworkVlanId();
        if (publicVlanId != null && privateVlanId != null) {
            LOG.debug("SoftLayer VLANs private {} and public {} already configured in template options for scope: {}", new Object[]{privateVlanId, publicVlanId, scopeUid});
            return;
        }
        LOG.debug("Looking up saved VLAN details {}", (Object)scopeUid);
        publicVlanId = this.lookupPublicVlanId(location, scopeUid);
        privateVlanId = this.lookupPrivateVlanId(location, scopeUid);
        if (publicVlanId != null && privateVlanId != null) {
            this.saveVlanTemplateOptions(scopeUid, softLayerOptions, publicVlanId, privateVlanId);
            return;
        }
        CountDownLatch latch = null;
        Object object = lock;
        synchronized (object) {
            latch = this.lookupCountDownLatch(location, scopeUid);
            if (latch == null) {
                LOG.debug("Creating new latch for scope: {}", (Object)scopeUid);
                latch = this.createCountDownLatch(location, scopeUid);
                return;
            }
        }
        Duration timeout = this.getTimeout(location);
        Tasks.setBlockingDetails((String)"Waiting for VLAN details");
        try {
            LOG.debug("Waiting for VLAN details for scope: {}", (Object)scopeUid);
            if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS)) {
                latch.countDown();
                this.removeCountDownLatch(location, scopeUid);
                throw new IllegalStateException("Timeout waiting on VLAN info in " + location + " for scope: " + scopeUid);
            }
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        LOG.debug("Looking up saved VLAN details {}", (Object)scopeUid);
        publicVlanId = this.lookupPublicVlanId(location, scopeUid);
        privateVlanId = this.lookupPrivateVlanId(location, scopeUid);
        if (privateVlanId == null && publicVlanId == null) {
            String message = String.format("Saved VLAN configuration not available for location %s scope %s", location, scopeUid);
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        this.saveVlanTemplateOptions(scopeUid, softLayerOptions, publicVlanId, privateVlanId);
    }

    private void saveVlanTemplateOptions(String scopeUid, SoftLayerTemplateOptions softLayerOptions, Integer publicVlanId, Integer privateVlanId) {
        LOG.debug("Setting VLAN template options private {} and public {} for scope: {}", new Object[]{privateVlanId, publicVlanId, scopeUid});
        softLayerOptions.primaryNetworkComponentNetworkVlanId(publicVlanId);
        softLayerOptions.primaryBackendNetworkComponentNetworkVlanId(privateVlanId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
        String provider = location.getProvider();
        if (!provider.equals("softlayer")) {
            String message = String.format("Invalid location provider: %s", provider);
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        String scopeUid = this.getScopeUid(location);
        CountDownLatch latch = null;
        Object object = lock;
        synchronized (object) {
            latch = this.lookupCountDownLatch(location, scopeUid);
            if (latch == null) {
                throw new IllegalStateException("No latch available for scope: " + scopeUid);
            }
        }
        try {
            LOG.debug("Looking up saved VLAN details {}", (Object)scopeUid);
            Integer publicVlanId = this.lookupPublicVlanId(location, scopeUid);
            Integer privateVlanId = this.lookupPrivateVlanId(location, scopeUid);
            if (privateVlanId != null && publicVlanId != null) {
                LOG.warn("SoftLayer VLANs private {} and public {} already configured for location {} scope {}", new Object[]{privateVlanId, publicVlanId, location, scopeUid});
                this.saveVlanDetails(machine, scopeUid, privateVlanId, publicVlanId);
                return;
            }
            LOG.debug("Requesting VLAN details from API for scope: {}", (Object)scopeUid);
            VirtualGuestApi api = ((SoftLayerApi)computeService.getContext().unwrapApi(SoftLayerApi.class)).getVirtualGuestApi();
            Long serverId = Long.parseLong(machine.getJcloudsId());
            VirtualGuest guest = api.getVirtualGuestFiltered(serverId.longValue(), "primaryNetworkComponent;primaryNetworkComponent.networkVlan;primaryBackendNetworkComponent;primaryBackendNetworkComponent.networkVlan");
            publicVlanId = guest.getPrimaryNetworkComponent().getNetworkVlan().getId();
            privateVlanId = guest.getPrimaryBackendNetworkComponent().getNetworkVlan().getId();
            LOG.debug("Saving VLAN details private {} and public {} for location {} scope {}", new Object[]{privateVlanId, publicVlanId, location, scopeUid});
            this.savePublicVlanId(location, scopeUid, publicVlanId);
            this.savePrivateVlanId(location, scopeUid, privateVlanId);
            this.saveVlanDetails(machine, scopeUid, privateVlanId, publicVlanId);
        }
        finally {
            latch.countDown();
        }
    }

    private void saveVlanDetails(JcloudsMachineLocation machine, String scopeUid, Integer privateVlanId, Integer publicVlanId) {
        Object context = this.config().get(LocationConfigKeys.CALLER_CONTEXT);
        if (context == null) {
            context = machine.config().get(LocationConfigKeys.CALLER_CONTEXT);
        }
        if (!(context instanceof Entity)) {
            throw new IllegalStateException("Invalid location context: " + context);
        }
        Entity entity = (Entity)context;
        entity.sensors().set(PUBLIC_VLAN_ID, (Object)publicVlanId);
        entity.sensors().set(PRIVATE_VLAN_ID, (Object)privateVlanId);
        entity.tags().addTag((Object)("softlayer-vlan-scopeUid-" + scopeUid));
    }

    private Duration getTimeout(JcloudsLocation location) {
        Duration timeout = (Duration)this.config().get(SCOPE_TIMEOUT);
        if (timeout == null) {
            timeout = (Duration)location.config().get(SCOPE_TIMEOUT);
        }
        return timeout;
    }

    private String getScopeUid(JcloudsLocation location) {
        String scopeUid = (String)this.config().get(SCOPE_UID);
        if (Strings.isEmpty((CharSequence)scopeUid)) {
            scopeUid = (String)location.config().get(SCOPE_UID);
        }
        return (String)Preconditions.checkNotNull((Object)scopeUid, (Object)"scopeUid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch lookupCountDownLatch(JcloudsLocation location, String scopeUid) {
        Object object = lock;
        synchronized (object) {
            Map map = (Map)location.config().get(COUNTDOWN_LATCH_MAP);
            return map != null ? (CountDownLatch)map.get(scopeUid) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch createCountDownLatch(JcloudsLocation location, String scopeUid) {
        Object object = lock;
        synchronized (object) {
            MutableMap map = MutableMap.copyOf((Map)((Map)location.config().get(COUNTDOWN_LATCH_MAP)));
            if (!map.containsKey(scopeUid)) {
                map.put(scopeUid, new CountDownLatch(1));
                this.saveAndPersist(location, (ConfigKey)COUNTDOWN_LATCH_MAP, (Map)map);
            }
            return (CountDownLatch)map.get(scopeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCountDownLatch(JcloudsLocation location, String scopeUid) {
        Object object = lock;
        synchronized (object) {
            MutableMap map = MutableMap.copyOf((Map)((Map)location.config().get(COUNTDOWN_LATCH_MAP)));
            map.remove(scopeUid);
            this.saveAndPersist(location, (ConfigKey)COUNTDOWN_LATCH_MAP, (Map)map);
        }
    }

    private <T> void saveAndPersist(JcloudsLocation location, ConfigKey<Map<String, T>> key, Map<String, T> map) {
        location.config().set(key, (Object)ImmutableMap.copyOf(map));
        location.getManagementContext().getRebindManager().forcePersistNow(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer lookupPublicVlanId(JcloudsLocation location, String scopeUid) {
        Object object = lock;
        synchronized (object) {
            Map map = (Map)location.config().get(PUBLIC_VLAN_ID_MAP);
            if (map == null) {
                map = MutableMap.copyOf((Map)map);
                this.saveAndPersist(location, PUBLIC_VLAN_ID_MAP, map);
            }
            return (Integer)map.get(scopeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePublicVlanId(JcloudsLocation location, String scopeUid, Integer publicVlanId) {
        Object object = lock;
        synchronized (object) {
            MutableMap map = MutableMap.copyOf((Map)((Map)location.config().get(PUBLIC_VLAN_ID_MAP)));
            map.put(scopeUid, publicVlanId);
            this.saveAndPersist(location, (ConfigKey)PUBLIC_VLAN_ID_MAP, (Map)map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer lookupPrivateVlanId(JcloudsLocation location, String scopeUid) {
        Object object = lock;
        synchronized (object) {
            Map map = (Map)location.config().get(PRIVATE_VLAN_ID_MAP);
            if (map == null) {
                map = MutableMap.copyOf((Map)map);
                this.saveAndPersist(location, PRIVATE_VLAN_ID_MAP, map);
            }
            return (Integer)map.get(scopeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePrivateVlanId(JcloudsLocation location, String scopeUid, Integer privateVlanId) {
        Object object = lock;
        synchronized (object) {
            MutableMap map = MutableMap.copyOf((Map)((Map)location.config().get(PRIVATE_VLAN_ID_MAP)));
            map.put(scopeUid, privateVlanId);
            this.saveAndPersist(location, (ConfigKey)PRIVATE_VLAN_ID_MAP, (Map)map);
        }
    }
}

