/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.rest.Binder;

public class BindToHeaders
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, (Object)"request");
        Preconditions.checkArgument((boolean)(input instanceof Map), (Object)"input must be a non-null java.util.Map!");
        Map headers = (Map)Map.class.cast(input);
        if (request.getPayload() == null) {
            request.setPayload("");
        }
        MutableContentMetadata contentMetadata = request.getPayload().getContentMetadata();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry keyVal : headers.entrySet()) {
            String keyInLowercase = ((String)keyVal.getKey()).toLowerCase();
            if (keyInLowercase.equals("content-type")) {
                contentMetadata.setContentType((String)keyVal.getValue());
                continue;
            }
            if (keyInLowercase.equals("content-disposition")) {
                contentMetadata.setContentDisposition((String)keyVal.getValue());
                continue;
            }
            if (keyInLowercase.equals("content-encoding")) {
                contentMetadata.setContentEncoding((String)keyVal.getValue());
                continue;
            }
            if (keyInLowercase.equals("content-language")) {
                contentMetadata.setContentLanguage((String)keyVal.getValue());
                continue;
            }
            if (keyInLowercase.equals("content-length")) {
                contentMetadata.setContentLength(Long.valueOf(Long.parseLong((String)keyVal.getValue())));
                continue;
            }
            builder.put((Object)keyInLowercase, keyVal.getValue());
        }
        request.getPayload().setContentMetadata(contentMetadata);
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)builder.build())).build();
    }
}

