/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.core.catalog.internal.CatalogApplicationItemDto;
import org.apache.brooklyn.core.catalog.internal.CatalogEnricherItemDto;
import org.apache.brooklyn.core.catalog.internal.CatalogEntityItemDto;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.catalog.internal.CatalogLocationItemDto;
import org.apache.brooklyn.core.catalog.internal.CatalogPolicyItemDto;
import org.apache.brooklyn.core.catalog.internal.CatalogTemplateItemDto;

public class CatalogItemBuilder<CIConcreteType extends CatalogItemDtoAbstract<?, ?>> {
    private CIConcreteType dto;

    public static CatalogItemBuilder<?> newItem(CatalogItem.CatalogItemType itemType, String symbolicName, String version) {
        Preconditions.checkNotNull((Object)itemType, (Object)"itemType required");
        switch (itemType) {
            case ENTITY: {
                return CatalogItemBuilder.newEntity(symbolicName, version);
            }
            case APPLICATION: {
                return CatalogItemBuilder.newApplication(symbolicName, version);
            }
            case TEMPLATE: {
                return CatalogItemBuilder.newTemplate(symbolicName, version);
            }
            case POLICY: {
                return CatalogItemBuilder.newPolicy(symbolicName, version);
            }
            case ENRICHER: {
                return CatalogItemBuilder.newEnricher(symbolicName, version);
            }
            case LOCATION: {
                return CatalogItemBuilder.newLocation(symbolicName, version);
            }
        }
        throw new IllegalStateException("Unexpected itemType: " + itemType);
    }

    public static CatalogItemBuilder<CatalogEntityItemDto> newEntity(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogEntityItemDto>(new CatalogEntityItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogApplicationItemDto> newApplication(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogApplicationItemDto>(new CatalogApplicationItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogTemplateItemDto> newTemplate(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogTemplateItemDto>(new CatalogTemplateItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogPolicyItemDto> newPolicy(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogPolicyItemDto>(new CatalogPolicyItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogEnricherItemDto> newEnricher(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogEnricherItemDto>(new CatalogEnricherItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogLocationItemDto> newLocation(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogLocationItemDto>(new CatalogLocationItemDto()).symbolicName(symbolicName).version(version);
    }

    public CatalogItemBuilder(CIConcreteType dto) {
        this.dto = dto;
        ((CatalogItemDtoAbstract)this.dto).setLibraries(Collections.emptyList());
    }

    public CatalogItemBuilder<CIConcreteType> symbolicName(String symbolicName) {
        ((CatalogItemDtoAbstract)this.dto).setSymbolicName(symbolicName);
        return this;
    }

    @Deprecated
    public CatalogItemBuilder<CIConcreteType> javaType(String javaType) {
        ((CatalogItemDtoAbstract)this.dto).setJavaType(javaType);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> displayName(String displayName) {
        ((CatalogItemDtoAbstract)this.dto).setDisplayName(displayName);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> description(String description) {
        ((CatalogItemDtoAbstract)this.dto).setDescription(description);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> iconUrl(String iconUrl) {
        ((CatalogItemDtoAbstract)this.dto).setIconUrl(iconUrl);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> version(String version) {
        ((CatalogItemDtoAbstract)this.dto).setVersion(version);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> deprecated(boolean deprecated) {
        ((CatalogItemDtoAbstract)this.dto).setDeprecated(deprecated);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> disabled(boolean disabled) {
        ((CatalogItemDtoAbstract)this.dto).setDisabled(disabled);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> libraries(Collection<CatalogItem.CatalogBundle> libraries) {
        ((CatalogItemDtoAbstract)this.dto).setLibraries(libraries);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> plan(String yaml) {
        ((CatalogItemDtoAbstract)this.dto).setPlanYaml(yaml);
        return this;
    }

    public CatalogItemBuilder<CIConcreteType> tag(Object tag) {
        ((CatalogItemDtoAbstract)this.dto).tags().addTag(tag);
        return this;
    }

    public CIConcreteType build() {
        Preconditions.checkNotNull((Object)((CatalogItemDtoAbstract)this.dto).getSymbolicName());
        Preconditions.checkNotNull((Object)((CatalogItemDtoAbstract)this.dto).getVersion());
        if (((CatalogItemDtoAbstract)this.dto).getLibraries() == null) {
            ((CatalogItemDtoAbstract)this.dto).setLibraries(Collections.emptyList());
        }
        CIConcreteType ret = this.dto;
        this.dto = null;
        return ret;
    }
}

