/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import java.util.Map;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

public interface UsesJavaMXBeans {
    @SetFromFlag(value="mxbeanStatsEnabled")
    public static final ConfigKey<Boolean> MXBEAN_STATS_ENABLED = ConfigKeys.newBooleanConfigKey((String)"java.metrics.mxbeanStatsEnabled", (String)"Enables collection of JVM stats from the MXBeans, such as memory and thread usage (default is true)", (Boolean)true);
    public static final AttributeSensor<Long> USED_HEAP_MEMORY = Sensors.newLongSensor((String)"java.metrics.heap.used", (String)"Current heap size (bytes)");
    public static final AttributeSensor<Long> INIT_HEAP_MEMORY = Sensors.newLongSensor((String)"java.metrics.heap.init", (String)"Initial heap size (bytes)");
    public static final AttributeSensor<Long> COMMITTED_HEAP_MEMORY = Sensors.newLongSensor((String)"java.metrics.heap.committed", (String)"Commited heap size (bytes)");
    public static final AttributeSensor<Long> MAX_HEAP_MEMORY = Sensors.newLongSensor((String)"java.metrics.heap.max", (String)"Max heap size (bytes)");
    public static final AttributeSensor<Long> NON_HEAP_MEMORY_USAGE = Sensors.newLongSensor((String)"java.metrics.nonheap.used", (String)"Current non-heap size (bytes)");
    public static final AttributeSensor<Integer> CURRENT_THREAD_COUNT = Sensors.newIntegerSensor((String)"java.metrics.threads.current", (String)"Current number of threads");
    public static final AttributeSensor<Integer> PEAK_THREAD_COUNT = Sensors.newIntegerSensor((String)"java.metrics.threads.max", (String)"Peak number of threads");
    public static final AttributeSensor<Long> START_TIME = Sensors.newLongSensor((String)"java.metrics.starttime", (String)"Start time of Java process (UTC)");
    public static final AttributeSensor<Long> UP_TIME = Sensors.newLongSensor((String)"java.metrics.uptime", (String)"Uptime of Java process (millis, elapsed since start)");
    public static final AttributeSensor<Double> PROCESS_CPU_TIME = Sensors.newDoubleSensor((String)"java.metrics.processCpuTime.total", (String)"Process CPU time (total millis since start)");
    public static final AttributeSensor<Double> PROCESS_CPU_TIME_FRACTION_LAST = Sensors.newDoubleSensor((String)"java.metrics.processCpuTime.fraction.last", (String)"Fraction of CPU time used, reported by JVM (percentage, last datapoint)");
    public static final AttributeSensor<Double> PROCESS_CPU_TIME_FRACTION_IN_WINDOW = Sensors.newDoubleSensor((String)"java.metrics.processCpuTime.fraction.windowed", (String)"Fraction of CPU time used, reported by JVM (percentage, over time window)");
    public static final AttributeSensor<Integer> AVAILABLE_PROCESSORS = Sensors.newIntegerSensor((String)"java.metrics.processors.available", (String)"number of processors available to the Java virtual machine");
    public static final AttributeSensor<Double> SYSTEM_LOAD_AVERAGE = Sensors.newDoubleSensor((String)"java.metrics.systemload.average", (String)"average system load");
    public static final AttributeSensor<Long> TOTAL_PHYSICAL_MEMORY_SIZE = Sensors.newLongSensor((String)"java.metrics.physicalmemory.total", (String)"The physical memory available to the operating system");
    public static final AttributeSensor<Long> FREE_PHYSICAL_MEMORY_SIZE = Sensors.newLongSensor((String)"java.metrics.physicalmemory.free", (String)"The free memory available to the operating system");
    public static final AttributeSensor<Map> GARBAGE_COLLECTION_TIME = new BasicAttributeSensor(Map.class, "java.metrics.gc.time", "garbage collection time");
}

