/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.internal.Primitives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessDriver;
import org.apache.brooklyn.entity.java.JmxSupport;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaSoftwareProcessSshDriver
extends AbstractSoftwareProcessSshDriver
implements JavaSoftwareProcessDriver {
    public static final Logger log = LoggerFactory.getLogger(JavaSoftwareProcessSshDriver.class);
    public static final List<List<String>> MUTUALLY_EXCLUSIVE_OPTS = ImmutableList.of((Object)ImmutableList.of((Object)"-client", (Object)"-server"));
    public static final List<String> KEY_VAL_OPT_PREFIXES = ImmutableList.of((Object)"-Xmx", (Object)"-Xms", (Object)"-Xss");

    public JavaSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFileLocation());
    }

    protected abstract String getLogFileLocation();

    @Override
    public boolean isJmxEnabled() {
        return this.entity instanceof UsesJmx && (Boolean)this.entity.getConfig(UsesJmx.USE_JMX) != false;
    }

    public boolean isJmxSslEnabled() {
        return this.isJmxEnabled() && JavaGroovyEquivalents.groovyTruth((Object)this.entity.getConfig(UsesJmx.JMX_SSL_ENABLED));
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        List<String> javaOpts = this.getJavaOpts();
        for (String it : javaOpts) {
            StringEscapes.BashStringEscapes.assertValidForDoubleQuotingInBash((String)it);
        }
        String sJavaOpts = Joiner.on((char)' ').join(javaOpts);
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"JAVA_OPTS", (Object)sJavaOpts).build();
    }

    public List<String> getJavaOpts() {
        Iterable sysprops = Iterables.transform(this.getJavaSystemProperties().entrySet(), (Function)new Function<Map.Entry<String, ?>, String>(){

            public String apply(Map.Entry<String, ?> entry) {
                String k = entry.getKey();
                Object v = entry.getValue();
                try {
                    if (v != null && Primitives.isWrapperType(v.getClass())) {
                        v = "" + v;
                    } else if ((v = Tasks.resolveValue(v, Object.class, (ExecutionContext)((EntityInternal)JavaSoftwareProcessSshDriver.this.entity).getExecutionContext())) != null && !(v instanceof CharSequence)) {
                        if (TypeCoercions.isPrimitiveOrBoxer(v.getClass())) {
                            v = "" + v;
                        } else {
                            throw new IllegalArgumentException("cannot convert value " + v + " of type " + v.getClass() + " to string to pass as JVM property; use a post-processor");
                        }
                    }
                    return "-D" + k + (v != null ? "=" + v : "");
                }
                catch (Exception e) {
                    log.warn("Error resolving java option key {}, propagating: {}", (Object)k, (Object)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        MutableSet result = MutableSet.builder().addAll(this.getJmxJavaConfigOptions()).addAll(this.getCustomJavaConfigOptions()).addAll(sysprops).build();
        for (String customOpt : (Set)this.entity.getConfig(UsesJava.JAVA_OPTS)) {
            for (List<String> mutuallyExclusiveOpt : MUTUALLY_EXCLUSIVE_OPTS) {
                if (!mutuallyExclusiveOpt.contains(customOpt)) continue;
                result.removeAll(mutuallyExclusiveOpt);
            }
            for (String keyValOptPrefix : KEY_VAL_OPT_PREFIXES) {
                if (!customOpt.startsWith(keyValOptPrefix)) continue;
                Iterator iter = result.iterator();
                while (iter.hasNext()) {
                    String existingOpt = (String)iter.next();
                    if (!existingOpt.startsWith(keyValOptPrefix)) continue;
                    iter.remove();
                }
            }
            if (customOpt.contains("=")) {
                String customOptPrefix = customOpt.substring(0, customOpt.indexOf("="));
                Iterator iter = result.iterator();
                while (iter.hasNext()) {
                    String existingOpt = (String)iter.next();
                    if (!existingOpt.startsWith(customOptPrefix)) continue;
                    iter.remove();
                }
            }
            result.add(customOpt);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    protected Map<String, ?> getJavaSystemProperties() {
        return MutableMap.builder().putAll(this.getCustomJavaSystemProperties()).putAll(this.isJmxEnabled() ? this.getJmxJavaSystemProperties() : Collections.emptyMap()).putAll((Map)this.entity.getConfig(UsesJava.JAVA_SYSPROPS)).build();
    }

    protected Map getCustomJavaSystemProperties() {
        return Maps.newLinkedHashMap();
    }

    protected List<String> getCustomJavaConfigOptions() {
        return Lists.newArrayList();
    }

    @Deprecated
    public Integer getJmxPort() {
        return !this.isJmxEnabled() ? Integer.valueOf(-1) : (Integer)this.entity.getAttribute((AttributeSensor)UsesJmx.JMX_PORT);
    }

    @Deprecated
    public Integer getRmiRegistryPort() {
        return !this.isJmxEnabled() ? Integer.valueOf(-1) : (Integer)this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT);
    }

    @Deprecated
    public String getJmxContext() {
        return !this.isJmxEnabled() ? null : (String)this.entity.getAttribute(UsesJmx.JMX_CONTEXT);
    }

    protected Map<String, ?> getJmxJavaSystemProperties() {
        MutableMap.Builder result = MutableMap.builder();
        if (this.isJmxEnabled()) {
            new JmxSupport((Entity)this.getEntity(), this.getRunDir()).applyJmxJavaSystemProperties((MutableMap.Builder<String, Object>)result);
        }
        return result.build();
    }

    protected List<String> getJmxJavaConfigOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isJmxEnabled()) {
            result.addAll(new JmxSupport((Entity)this.getEntity(), this.getRunDir()).getJmxJavaConfigOptions());
        }
        return result;
    }

    protected boolean checkForAndInstallJava(String requiredVersion) {
        int requiredJavaMinor = this.getJavaMinorVersion(requiredVersion);
        Optional<String> installedJavaVersion = this.getInstalledJavaVersion();
        if (installedJavaVersion.isPresent()) {
            List installedVersionParts = Splitter.on((String)".").splitToList((CharSequence)installedJavaVersion.get());
            int javaMajor = Integer.valueOf((String)installedVersionParts.get(0));
            int javaMinor = Integer.valueOf((String)installedVersionParts.get(1));
            if (javaMajor == 1 && javaMinor >= requiredJavaMinor) {
                log.debug("Java {} already installed at {}@{}", new Object[]{installedJavaVersion.get(), this.getEntity(), this.getLocation()});
                return true;
            }
        }
        return this.tryJavaInstall(requiredVersion, BashCommands.installJava((int)requiredJavaMinor)) == 0;
    }

    private int getJavaMinorVersion(String requiredVersion) {
        int requiredJavaMinor;
        if (requiredVersion.contains(".")) {
            List requiredVersionParts = Splitter.on((String)".").splitToList((CharSequence)requiredVersion);
            requiredJavaMinor = Integer.valueOf((String)requiredVersionParts.get(1));
        } else if (requiredVersion.length() == 1) {
            requiredJavaMinor = Integer.valueOf(requiredVersion);
        } else {
            log.error("java version required {} is not supported", (Object)requiredVersion);
            throw new IllegalArgumentException("Required java version " + requiredVersion + " not supported");
        }
        return requiredJavaMinor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryJavaInstall(String version, String command) {
        this.getLocation().acquireMutex("installing", "installing Java at " + this.getLocation());
        try {
            log.debug("Installing Java {} at {}@{}", new Object[]{version, this.getEntity(), this.getLocation()});
            ProcessTaskFactory taskFactory = SshTasks.newSshExecTaskFactory((SshMachineLocation)this.getLocation(), (String[])new String[]{command}).summary("install java (" + version + ")").configure(ShellTool.PROP_EXEC_ASYNC, (Object)true);
            ProcessTaskWrapper installCommand = (ProcessTaskWrapper)Entities.submit((Entity)this.getEntity(), (TaskFactory)taskFactory);
            int result = (Integer)installCommand.get();
            if (result != 0) {
                log.warn("Installation of Java {} failed at {}@{}: {}", new Object[]{version, this.getEntity(), this.getLocation(), installCommand.getStderr()});
            }
            int n = result;
            return n;
        }
        finally {
            this.getLocation().releaseMutex("installing");
        }
    }

    protected Optional<String> getInstalledJavaVersion() {
        log.debug("Checking Java version at {}@{}", (Object)this.getEntity(), (Object)this.getLocation());
        ProcessTaskWrapper versionCommand = (ProcessTaskWrapper)Entities.submit((Entity)this.getEntity(), (TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)this.getLocation(), (String[])new String[]{"java -version 2>&1 | grep \" version\" | sed 's/.*\"\\(.*\\).*\"/\\1/'"}));
        versionCommand.get();
        String stdOut = versionCommand.getStdout().trim();
        if (!Strings.isBlank((CharSequence)stdOut)) {
            log.debug("Found Java version at {}@{}: {}", new Object[]{this.getEntity(), this.getLocation(), stdOut});
            return Optional.of((Object)stdOut);
        }
        log.debug("Found no Java installed at {}@{}", (Object)this.getEntity(), (Object)this.getLocation());
        return Optional.absent();
    }

    protected Optional<String> getCurrentJavaVendor() {
        log.debug("Checking Java vendor at {}@{}", (Object)this.getEntity(), (Object)this.getLocation());
        ProcessTaskWrapper versionCommand = (ProcessTaskWrapper)Entities.submit((Entity)this.getEntity(), (TaskFactory)SshTasks.newSshExecTaskFactory((SshMachineLocation)this.getLocation(), (String[])new String[]{"java -version 2>&1 | awk 'NR==2 {print $1}'"}));
        versionCommand.get();
        String stdOut = versionCommand.getStdout().trim();
        if (Strings.isBlank((CharSequence)stdOut)) {
            log.debug("Found no Java installed at {}@{}", (Object)this.getEntity(), (Object)this.getLocation());
            return Optional.absent();
        }
        if ("Java(TM)".equals(stdOut)) {
            log.debug("Found Java version at {}@{}: {}", new Object[]{this.getEntity(), this.getLocation(), stdOut});
            return Optional.of((Object)"Oracle");
        }
        return Optional.of((Object)stdOut);
    }

    public boolean installJava() {
        if (this.entity instanceof UsesJava) {
            String version = (String)this.entity.getConfig(UsesJava.JAVA_VERSION_REQUIRED);
            if (this.checkForAndInstallJava(version)) {
                return true;
            }
            String incrementedVersion = String.valueOf(this.getJavaMinorVersion(version) + 1);
            log.warn("Java {} install failed, trying Java {}", (Object)version, (Object)incrementedVersion);
            return this.checkForAndInstallJava(incrementedVersion);
        }
        if (this.checkForAndInstallJava("1.7")) {
            return true;
        }
        log.warn("Java 1.7 install failed, trying Java 1.8");
        return this.checkForAndInstallJava("1.8");
    }

    public void installJmxSupport() {
        if (this.isJmxEnabled()) {
            this.newScript((String)"JMX_SETUP_PREINSTALL").body.append((CharSequence)("mkdir -p " + this.getRunDir())).execute();
            new JmxSupport((Entity)this.getEntity(), this.getRunDir()).install();
        }
    }

    public void checkJavaHostnameBug() {
        this.checkNoHostnameBug();
        try {
            ProcessTaskWrapper hostnameTask = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"echo FOREMARKER; hostname -f; echo AFTMARKER"}))).block();
            String stdout = Strings.getFragmentBetween((String)hostnameTask.getStdout(), (String)"FOREMARKER", (String)"AFTMARKER");
            if (hostnameTask.getExitCode() == 0 && Strings.isNonBlank((CharSequence)stdout)) {
                String hostname = stdout.trim();
                Integer len = hostname.length();
                if (len > 63) {
                    String newHostname = "br-" + this.getEntity().getId().toLowerCase();
                    log.info("Detected likelihood of Java hostname bug with hostname length " + len + " for " + this.getEntity() + "; renaming " + this.getMachine() + "  to hostname " + newHostname);
                    ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((List)BashCommands.setHostname((String)newHostname, null)))).block();
                }
            } else {
                log.debug("Hostname length could not be determined for location " + EffectorTasks.findSshMachine() + "; not doing Java hostname bug check");
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error checking/fixing Java hostname bug (continuing): " + e, (Throwable)e);
        }
    }

    @Override
    public void setup() {
        DynamicTasks.queue((String)"install java", (Runnable)new Runnable(){

            @Override
            public void run() {
                JavaSoftwareProcessSshDriver.this.installJava();
            }
        });
        if (((Boolean)this.getEntity().getConfig(UsesJava.CHECK_JAVA_HOSTNAME_BUG)).booleanValue()) {
            DynamicTasks.queue((String)"check java hostname bug", (Runnable)new Runnable(){

                @Override
                public void run() {
                    JavaSoftwareProcessSshDriver.this.checkJavaHostnameBug();
                }
            });
        }
    }

    @Override
    public void copyRuntimeResources() {
        super.copyRuntimeResources();
        if (this.isJmxEnabled()) {
            DynamicTasks.queue((String)"install jmx", (Runnable)new Runnable(){

                @Override
                public void run() {
                    JavaSoftwareProcessSshDriver.this.installJmxSupport();
                }
            });
        }
    }
}

