@q file: enum.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>

@** Enumeration of Alphabets --- Terminals and Rules.
@ Enumeration.\fbreak
The terminal alphabet is represented by the positive integers
starting at zero.
Lr constant terminals (meta terminals) are indicators of parsing situations 
like end-of-token stream reached,
parallel parsing to take place, to different wild type shifts.
None of these meta-terminals are found within the input language being parsed.

Raw characters represent the mapping from the 8 bit ASCII character into its
raw character terminal.
Both the meta and raw characters terminals are fixed and will never expand.
They are therefore constant in their positions.
Error terminals are internally generated situations produced by the parsing grammars
manufactured by the grammar writer. They indicate the appropriate faulty situation detected
and will grow in numbers as new error situations are developed.
Regular terminals are composites that get created by the grammars from streams of other
raw character terminals or composite terminals. 
They are evolutionary and come into existance from various passes made on
the token streams: lexical to syntactic. Consequently, both errors and regular terminals
are variable in their numbers as the grammar system is being developed.\

To help speed up bottom-up parsing, the enumerate value of
each terminal is computed to its
compressed set key.
This will be used in the various set operations like reduce, shift, and accept against the
lookahead sets. The following |Set handling| section describes the details.

  
