\def\title{SP\_webfiles.ch}
\def\cee{\eightrm C}
\def\leftarrow{ = }

@* Introduction.

 This is a 
 changefile to make Spidery \.{weave} somewhat more compatible with
 \.{cweave} 3.1, at least to work with the webfiles style option.

@* Embedded program texts.

 This change makes embedded program texts be tagged with \.{\\PB}, in 
 documentation,
 in comments and in module names. (In documentation state, embedded program
 text is also tagged with \.{\\CD ... \\DC.)}.
 The lines with ``/* CWEB3.1 */'' are copied from \.{cweave} version 3.1 .


@x
@ @<Copy comment, including embedded program text@>=
      small_app(break_space); app_str("\\C{");
@.\\cee@>
      bal=copy_comment(1); next_control=vertical_bar;
      while (bal>0) {
 p=text_ptr; freeze_text; q=C_translate();
         /* at this point we have |tok_ptr+6<=max_toks| */ /* spider */
        small_app(tok_flag+p-tok_start); small_app(inner_tok_flag+q-tok_start);
        if (next_control==vertical_bar) bal=copy_comment(bal);
        else bal=0; /* an error has been reported */
      }
      small_app(force); 
      app_scrap(SP_ignore_scrap,no_math);
		 /* the full comment becomes a scrap */
@y

@ @<Copy comment, including embedded program text@>=
      small_app(break_space); app_str("\\C{");
@.\\cee@>
      bal=copy_comment(1); next_control=vertical_bar;
      while (bal>0) {
          p=text_ptr; 
          freeze_text; 
          q=C_translate();
          /* at this point we have |tok_ptr+6<=max_toks| */ /* spider */
          small_app(tok_flag+p-tok_start); 
          app_str("\\PB{"); @.\\PB@>         /* CWEB3.1 */
          small_app(inner_tok_flag+q-tok_start);
          app_tok('}');                      /* CWEB3.1 */
          if (next_control==vertical_bar) bal=copy_comment(bal);
          else bal=0; /* an error has been reported */
      }
      small_app(force); 
      app_scrap(SP_ignore_scrap,no_math);
		 /* the full comment becomes a scrap */

@z

@x
@u
output_C() /* outputs the current token list */
{
  token_pointer save_tok_ptr;
  text_pointer save_text_ptr;
  sixteen_bits save_next_control; /* values to be restored */
  text_pointer p; /* translation of the \cee\ text */
  save_tok_ptr=tok_ptr; save_text_ptr=text_ptr;
  save_next_control=next_control; next_control=vertical_bar; p=C_translate();
  small_app(p-tok_start+inner_tok_flag);
  make_output(); /* output the list */
#ifdef STAT
  if (text_ptr>max_text_ptr) max_text_ptr=text_ptr;
  if (tok_ptr>max_tok_ptr) max_tok_ptr=tok_ptr;
#endif STAT
  text_ptr=save_text_ptr; tok_ptr=save_tok_ptr; /* forget the tokens */
  next_control=save_next_control; /* restore |next_control| to original state */
}
@y

@u
output_C() /* outputs the current token list */
{
  token_pointer save_tok_ptr;
  text_pointer save_text_ptr;
  sixteen_bits save_next_control; /* values to be restored */
  text_pointer p; /* translation of the \cee\ text */
  save_tok_ptr=tok_ptr; 
  save_text_ptr=text_ptr;
  save_next_control=next_control; 
  next_control=vertical_bar; 
  p=C_translate();
  small_app(inner_tok_flag + p-tok_start);
  out_str("\\PB{"); @.\\PB@>              /* CWEB3.1 */
  make_output(); /* output the list */
  out('}');                               /* CWEB3.1 */
#ifdef STAT
  if (text_ptr>max_text_ptr) max_text_ptr=text_ptr;
  if (tok_ptr>max_tok_ptr) max_tok_ptr=tok_ptr;
#endif STAT
  text_ptr=save_text_ptr; tok_ptr=save_tok_ptr; /* forget the tokens */
  next_control=save_next_control; /* restore |next_control| to original state */
}

@z

@* Multilingual Xref information.

 Here, in the original Spider, the 
 footnote procedure outputs the word ``section'' after \.{\\U}, and
 in \.{webkernel} \.{\\U} is defined as ``This code is used in''.
 This makes output in other languages impossible, so we leave out the 
 \item  |out_str(" section");|
 
 \medskip\noindent
 and append ``section'' to the definition of \.{\\U} in \.{webkernel.tex}.
 @.webkernel.tex@>
 
 The \.{`s'} that is output if the code is multiply used or defined will now 
 be appended after `\.{\\U}' or `\.{\\A}', respectively, making `\.{\\Us}' or 
 `\.{\\As}' as in \.{CWEB} 3.0.
 In \.{webkernel.tex} \.{\\Us} and \.{\\As} will be defined to be the plural
 equivalents of \.{\\U} and \.{\\A}, respectively.
 

@x
@ The |footnote| procedure gives cross-reference information about
multiply defined module names (if the |flag| parameter is |def_flag|), or about
the uses of a module name (if the |flag| parameter is zero). It assumes that
|cur_xref| points to the first cross-reference entry of interest, and it
leaves |cur_xref| pointing to the first element not printed.  Typical outputs:
`\.{\\A\ section 101.}'; `\.{\\U\ sections 370 and 1009.}';
`\.{\\A\ sections 8, 27\\*, and 64.}'.

@u footnote(flag) /* outputs module cross-references */
sixteen_bits flag;
{
  xref_pointer q; /* cross-reference pointer variable */
  if (cur_xref->num<=flag) return;
  finish_line(); out('\\');
@.\\A@>
@.\\U@>
  if (flag==0) out('U')@;@+else out('A');
  out_str(" section");
  @<Output all the module numbers on the reference list |cur_xref|@>;
  out('.');
}
@y
@ The |footnote| procedure gives cross-reference information about
multiply defined module names (if the |flag| parameter is |def_flag|), or about
the uses of a module name (if the |flag| parameter is zero). It assumes that
|cur_xref| points to the first cross-reference entry of interest, and it
leaves |cur_xref| pointing to the first element not printed.  Typical outputs:
`\.{\\A\ 101.}'; `\.{\\Us\ 370 and 1009.}';
`\.{\\As\ 8, 27\\*, and 64.}'.
Note that the output of \.{weave} is not English-specific; users may supply
new definitions for the macros \.{\\A}. \.{\\As} etc.

@u footnote(flag) /* outputs module cross-references */
sixteen_bits flag;
{
  xref_pointer q; /* cross-reference pointer variable */
  if (cur_xref->num<=flag) return;
  finish_line(); out('\\');
@.\\A@>
@.\\U@>
@.\\As@>
@.\\Us@>
  if (flag==0) @+ out('U') @;
  else @+ out('A');
  @<Output all the module numbers on the reference list |cur_xref|@>;
  out('.');
}
@z


Furthermore, the word ``and'' will be replaced by ``\.{\\ET}''
if there are two xrefs or ``\.{\\ETs}'' if there are more than two.
No comma is appended before ``\.{\\Ets}''.
This is exactly the same as in \.{CWEAVE} 3, and it is necessary for
languages in which there should not be a comma before the equivalent of ``and''
(e.g., Dutch, German).


@x
@ The following code distinguishes three cases, according as the number
of cross-references is one, two, or more than two. Variable |q| points
to the first cross-reference, and the last link is a zero.

@<Output all the module numbers...@>=
q=cur_xref; if (q->xlink->num>flag) out('s'); /* plural */
out('~');
while (1) {
  out_mod(cur_xref->num-flag);
  cur_xref=cur_xref->xlink; /* point to the next cross-reference to output */
  if (cur_xref->num<=flag) break;
  if (cur_xref->xlink->num>flag || cur_xref!=q->xlink) out(',');
    /* not the last of two */
  out(' ');
  if (cur_xref->xlink->num<=flag) out_str("and~"); /* the last */
}
@y
@ The following code distinguishes three cases, according as the number
of cross-references is one, two, or more than two. Variable |q| points
to the first cross-reference, and the last link is a zero.

@<Output all the module numbers...@>=
q=cur_xref; 
if (q->xlink->num>flag) out('s'); /* plural */
while (1) {
  out_mod(cur_xref->num-flag);
  cur_xref=cur_xref->xlink; /* point to the next cross-reference to output */
  if (cur_xref->num<=flag) break;
  if (cur_xref->xlink->num>flag)  out_str(", ");     /* not the last */
  else{
    out_str("\\ET");
    if (cur_xref!=q->xlink)  out('s') @; /* the last of more than two */
  }
}
@.\\ET@>
@.\\ETs@>
@.\\As@>
@.\\Us@>
@z
