{$N-,E-,V-}

Unit bibdisp;

Interface

uses
  bibwindo, Dos, bibCrt, BibStrg, BibMouse, bibtext, objects, rc_strng;
  
Const
  MaxMenu          = 22;  { Max number of pulldown menu items }
  MaxTopLine       = 11;  { Max number of Topline  menu items }
  MaxMenuStack     = 4;   { Max submenu depth                 }
  MaxMenuItemWidth = 64;  { Max width of a mouse menu item    }

  { TopLine constants }
  
  CTop_F1      = 20;
  CTop_Scroll  = 23;
  CTop_CHome   = 25;
  CTop_CEnd    = 26;
  CTop_BS      = 28;
  CTop_Space   = 29;
  CTop_Tab     = 30;
  CTop_SCTab   = 31;
  CTop_Outside = 127;

type
  EventType = record
    mpress,Shift,Ctrl,Alt,LeftButton,RightButton,MiddleButton: boolean;
    ch: char;
    x,y,ScanCode: byte;
  end;
  ItemStringType = string[MaxMenuItemWidth];
  MouseMenuRecPtr = ^MouseMenuRec;
  MouseMenuRec = record
    item: array[1..MaxMenu] of ^ItemStringType;
    nitems,startpos,curntpos,bartype: integer;
    flon: boolean;
    fchars : string[MaxMenu];
    width: byte;
    SubMenu: array[1..MaxMenu] of MouseMenuRecPtr;
    ToMenu: array[1..MaxMenu] of boolean;
    retrn: array[1..MaxMenu] of byte;
  end;
  TopMenuType = record
    nitems: byte;
    item: array[1..MaxTopLine] of string[20];
    ipos,retrn : array[1..MaxTopLine] of byte;
    fchars: string[MaxTopLine];
    ToMenu: array[1..MaxTopLine] of boolean;
    currentpos: integer;
    AltExpect: string;
    SubMenu: array[1..MaxTopLine] of MouseMenuRecPtr;
  end;

  CharSet = set of char;
  SelectionType = array[0..MaxMenuStack] of byte;
  ScrBarType = record
    X,Y0,Y1,Len,Height: Byte;
    MarkBegin,MarkEnd: integer;
    Color: Byte;
    PressTime: LongInt;
    HeldDown: boolean;
    LastY: Integer;
  end;
  ScrBarPtr = ^ScrBarType;
  
var
  TimeOutOn,suspended,AbortFlag: boolean;
  Colors: array[0..15] of string[12];
  DispTimeOut: word;
  PSuspendFile: ^text;
  SuspendedPos: LongInt;
  Event: EventType;
  StringResource: PStringList;
  ResourceFile: TResourceFile;
  RStringList: TStreamRec;

  { Colors }
  
  TopMenuNorm,TopMenuRev,TopMenuBright: Byte;
  MenuNorm,MenuBright,MenuRev,MenuBorder: Byte;
  MessageNorm,MessageRev,MessageBright,ErrorNorm,ErrorRev: byte;
  Blink,Shadow,Rnorm,RRev,RBright,RBlink: byte;

procedure AltChars(var ch,chmore: char; fchars: string);
function  ReadKeyMouse: char;
procedure TrapAbort;
procedure WaitingMessage(s: string);
procedure SuspendWaiting(suspend: boolean);
procedure WaitingOff;
procedure SearchingMessage;
function  AskIf(line,title,YesStr,NoStr: string) : boolean;
function  AskIfRC(id: integer;S,title,YesStr,NoStr: string) : boolean;
function  AskIf3(line,Str1,Str2,Str3: string) : integer;
function  AskIf4(line,Str1,Str2,Str3,Str4: string) : integer;
procedure Message(line: string);  {Display message in a window}
procedure MessageRC(id: word; S: string);
procedure ErrorMessage(line: string);
procedure ErrorMessageRC(id: word; S: string);
function  YesNo(line: string) : boolean;  {Yes or No box }
function  YesNoRC(id: word; S: string) : boolean;
procedure ShowMem(s: string);
procedure FreeMemDeficit(s: string; MemoryFree: longint);
procedure ReadScrStr(Var s: string; x,y: byte; var xfirst, att: byte;
                     allow: CharSet);
procedure NewMouseMenu(var Menu: MouseMenuRecPtr);
procedure NewMenuItem(M: MouseMenuRecPtr; S: ItemStringType; HotKey: char;
                      ret: byte);
procedure NewMenuLine(M: MouseMenuRecPtr);
procedure ScrollBarMake(var ScrBar: ScrBarType; var Scroll: longint;
                        xx,yy0,yy1,hh,LastLine: longint; ScrBarColor: byte);
procedure ScrollBarClick(var ScrBar: ScrBarType; var Scroll: longint);
procedure Topline(var TopMenu: TopMenuType; var selected: SelectionType;
                  DrawOnly: boolean; var outside: boolean;
                  var Scroll: longint; LastY: longint; ScrBar: ScrBarPtr);

Implementation

Type
  TopMenuPtr = ^TopMenuType;

var
  ScrollPressStatus: byte;
  WaitingArray,CurrentWaitingMessage: array[1..132] of PixelType;
  AmWaiting,SuspendedWaiting: boolean;

procedure AltChars(var ch,chmore: char; fchars: string);
const
  Alt: string[36] = 
    #30+#48+#46+#32+#18+#33+#34+#35+#23+#36+#37+#38+#50+#49+#24+#25+#16+
    #19+#31+#20+#22+#47+#17+#45+#27+#44+
    #129+#120+#121+#122+#123+#124+#125+#126+#127+#128;
var
  chfound: char;
  pl: Byte;
begin                           { AltChars }
  chfound:=#0;
  pl:=Pos(chmore,Alt);
  if (pl>0) and (pl<27) then    { A Letter }
    chfound:=Chr(pl+Ord('A')-1)
  else                          { A Digit  }
    chfound:=Chr(pl-27+Ord('0'));
  if (chfound<>#0) and ((fchars='') or (Pos(chfound,fchars)>0)) then
  begin
    ch:=chfound; chmore:=#255;
  end;
end;                             { AltChars }

function ReadKeyMouse: char;
Var
  ok,clock: boolean;
  H, M, S100, StartSec, EndSec: Word;
  Regs: Registers;
begin                                 { ReadKeyMouse }
  with Event do
  begin
    Leftbutton:=false; RightButton:=false; MiddleButton:=false;
    mpress:=false; ch:=#0; ScanCode:=0;
    x:=0; y:=0;
    Shift:=false; Ctrl:=false; Alt:=false;
  end;
  clock:=TimeOutOn and (DispTimeout>0) and (not suspended);
  if clock then
  begin
    GetTime(H, M, StartSec, S100); StartSec:=StartSec+60*M;
  end;
  if UseMouse then
  begin
    ShowMouseCursor;
    repeat
      ok:=(ButtonPressed) or (keyPressed);
      if clock then
      begin
        GetTime(H, M, EndSec, S100); EndSec:=EndSec+60*M;
        if EndSec<StartSec then EndSec:=EndSec+3600;
        if EndSec-startSec>=disptimeout then
        begin
          SuspendedPos:=-1;
          if (PSuspendFile<>Nil) and (
             (TextRec(PSuspendFile^).Mode=fminput) or
             (TextRec(PSuspendFile^).Mode=fminout) or
             (TextRec(PSuspendFile^).Mode=fmoutput)) then
          begin
            SuspendedPos:=TextFilePos(PSuspendFile^);
            {$I-}
            close(PSuspendFile^); if IoResult<>0 then;
            {$I+}
          end;
          clock:=false; suspended:=true;
        end;
      end;
      TimeSlice;
    until ok;
  end else
  begin
    repeat
      ok:=KeyPressed;
      if clock then
      begin
        GetTime(H, M, EndSec, S100); EndSec:=EndSec+60*M;
        if EndSec<StartSec then EndSec:=EndSec+3600;
        if EndSec-startSec>=disptimeout then
        begin
          SuspendedPos:=-1;
          if (PSuspendFile<>Nil) and (
             (TextRec(PSuspendFile^).Mode=fmInput) or
             (TextRec(PSuspendFile^).Mode=fmInOut) or
             (TextRec(PSuspendFile^).Mode=fmOutput)) then
          begin
            SuspendedPos:=TextFilePos(PSuspendFile^);
            {$I-}
            close(PSuspendFile^); if IoResult<>0 then;
            {$I+}
          end;
          clock:=false; suspended:=true;
        end;
      end;
      TimeSlice;
    until ok;
  end;
  with Event do ShiftCtrlAlt(Shift,Ctrl,Alt);
  if KeyPressed then
  begin
    Regs.AH:=CheckKeyStroke; Intr($16,Regs);
    if (regs.AH=46) and IsAlt and IsCtrl then    { Ctrl-Alt-C is HALT! }
    begin
      Regs.AH:=GetKeystroke; Intr($16,Regs);
      Halt(255);
    end;
    Event.ScanCode:=Regs.AH;
    Event.ch:=ReadKey;
  end else with Event do
  begin
    mpress:=true;
    GetMouseState(LeftButton,RightButton,MiddleButton,X,Y);
    Event.ch:=#255;
  end;
  ReadKeyMouse:=Event.ch;
end;                                  { ReadKeyMouse }

procedure TrapAbort;
var
  ch: char;
  OldTimeoutOn: boolean;
begin
  if KeyPressed then
  begin
    ch:=ReadKey;
    if ch=#3 then    { Ctrl-C is Abort! }
    begin
      OldTimeoutOn:=TimeoutOn; TimeoutOn:=false;
      if YesNoRC(Str_VerifyAbort,'') {(' Abort operation? ')} then AbortFlag:=true;
      TimeoutOn:=OldTimeoutOn;
    end else if ch=#0 then ch:=ReadKey;
    Clb;
  end;
end;

procedure WaitingMessage(s: string);
var
  Origin: pointer;
  i: integer;
begin
  if (not AmWaiting) and (s='') then Exit;
  Origin:=Ptr(VideoSeg,VideoOfs+(ScrLen-1)*ScrWidth*sizeof(PixelType));
  if not AmWaiting then
  begin
    move(Origin^,WaitingArray,ScrWidth*sizeof(PixelType));
    AmWaiting:=true;
  end;
  move(WaitingArray,CurrentWaitingMessage,ScrWidth*sizeof(PixelType));
  for i:=1 to length(s) do
  begin
    CurrentWaitingMessage[ScrWidth-length(s)-2+i].ch:=s[i];
    CurrentWaitingMessage[ScrWidth-length(s)-2+i].at:=Rblink;
  end;
  Move(CurrentWaitingMessage,Origin^,ScrWidth*sizeof(PixelType));
  if s='' then AmWaiting:=false;
  if not AmWaiting then SuspendedWaiting:=false;
  if AmWaiting then AbortFlag:=false;
end;                                    { WaitingMessage }

procedure SuspendWaiting(suspend: boolean);
var
  Origin: pointer;
begin
  if not AmWaiting then Exit;
  Origin:=Ptr(VideoSeg,VideoOfs+(ScrLen-1)*ScrWidth*sizeof(PixelType));
  if SuspendedWaiting and not Suspend then
  begin
    Move(CurrentWaitingMessage,Origin^,ScrWidth*sizeof(PixelType));
    SuspendedWaiting:=false;
  end else if Suspend and not SuspendedWaiting then
  begin
    Move(WaitingArray,Origin^,ScrWidth*sizeof(PixelType));
    SuspendedWaiting:=true;
  end;
end;                             { SuspendWaiting }

procedure WaitingOff;
begin
  if AmWaiting then WaitingMessage('');
end;                             { WaitingOff }

procedure SearchingMessage;
begin
  if not AmWaiting then WaitingMessage('Searching...');
end;


function wvsprintf(form,S: string): string;
begin
  StrRepl(form,'%s',S,1,255,255);
  wvsprintf:=form;
end;

function AskIf(line,title,YesStr,NoStr : string) : boolean;
var                            
  l,fst,h,pl,yespl,nopl,i,YesLen,NoLen,MaxWidth,MinWidth : integer;
  BaseRow,Current: Byte;
  ch : char;
  top,mid,bot,tmp1,tmp2 : string;
  ans,OldAns,Finish: boolean;
begin                                    { AskIf }
  if UseMouse then WaitForRelease(255);
  ChrDelL(line,' '); ChrDelR(line,' '); line:=' '+line+' ';
  CursorOff;
  BaseRow:=6;
  ans:=true; finish:=false;
  SuspendWaiting(true);
  YesLen:=Length(YesStr); NoLen:=Length(NoStr);
  ChrFill(tmp1,#196,YesLen+2);
  ChrFill(tmp2,#196,NoLen+2);
  if NoLen=0 then
  begin
    top:=#218+tmp1+#191;
    mid:=#179+' '+YesStr+' '+#179;
    bot:=#192+tmp1+#217;
  end else
  begin
    top:=#218+tmp1+#191+'   '+#218+tmp2+#191;
    mid:=#179+' '+YesStr+' ' +#179+'   '+#179+' '+NoStr+' '+#179;
    bot:=#192+tmp1+#217+'   '+#192+tmp2+#217;
  end;
  MaxWidth:=ScrWidth-16;
  if Length(line)<=MaxWidth then MaxWidth:=Length(line);
  if MaxWidth<Length(top)+2 then MaxWidth:=Length(top)+2;
  if MaxWidth<Length(title)+2 then MaxWidth:=Length(title)+2;
  l:=MaxWidth+2;
  fst:=(ScrWidth-MaxWidth) div 2;
  h:=BaseRow + ((Length(line)-1) div MaxWidth);
  MakeWindow(BaseRow,fst,h,l,MessageNorm,MessageNorm,2,RNorm,shadow,1);
  if title<>'' then TitleWindow(2,MessageNorm,title);
  if h=BaseRow then PrtcWindow(1,line)
  else
    for i:=0 to (Length(line) div MaxWidth) do
      PrtWindow(1+i,1,Copy(line,MaxWidth*i+1,MaxWidth));
  pl:=(l-2-length(top)) div 2+1;
  PrtWindow(h-4,pl,top); PrtWindow(h-3,pl,mid); PrtWindow(h-2,pl,bot);
  yespl:=pl+pos(YesStr,mid); nopl:=pl+Pos(NoStr,mid);
  Tpwattr(BaseRow+h-3,fst+yespl-2,1,YesLen+2,MessageRev);
  CLB;
  repeat
    OldAns:=ans;
    if UseMouse then
    begin
      ShowMouseCursor; ShowMouseCursor;
    end;
    ch := ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then
    begin
      if ((Event.x>fst+yespl-4) and (Event.x<fst+yespl+YesLen+1)) and
         ((Event.y>BaseRow+h-5) and (Event.y<BaseRow+h-1)) then
      begin
        ans:=true; finish:=true;
      end else if NoLen>0 then
        if ((Event.x>fst+nopl-4) and (Event.x<fst+nopl+NoLen+1)) and
           ((Event.y>BaseRow+h-5) and (Event.y<BaseRow+h-1)) then
      begin
        ans:=false; finish:=true;
      end;
    end else if (ch=#0) and (NoLen>0) then
    begin
      ch:=readkey;
      if ch in [#75,#77] then ans:=not ans
    end else
    begin
      if ch=#13 then finish:=true
      else if UpCase(ch)=UpCase(YesStr[1]) then
      begin
        ans:=true; finish:=true;
      end else if UpCase(ch)=UpCase(NoStr[1]) then
      begin
        ans:=false; finish:=true;
      end
    end;
    if ans and (not OldAns) then
    begin
      Tpwattr(BaseRow+h-3,fst+yespl-2,1,YesLen+2,MessageRev);
      Tpwattr(BaseRow+h-3,fst+nopl-2,1,NoLen+2,MessageNorm);
      ans:=true;
    end else if (not ans) and OldAns then
    begin
      Tpwattr(BaseRow+h-3,fst+yespl-2,1,YesLen+2,MessageNorm);
      Tpwattr(BaseRow+h-3,fst+nopl-2,1,NoLen+2,MessageRev);
      ans:=false;
    end;
  until finish;
  AskIf:=ans;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(false);
end;                                              { AskIf }

function AskIfRC(id: integer; S,title,YesStr,NoStr: string): boolean;
begin
  AskIfRC:=AskIf(wvsprintf(StringResource^.Get(id),S),title,YesStr,NoStr);
end;

function AskIf3(line,Str1,Str2,Str3 : string) : integer;
var                            
  l,fst,h,pl,i,MaxWidth,MinWidth,choice,NewChoice : integer;
  Len,plc: array[1..3] of integer;
  BaseRow: Byte;
  ch : char;
  top,mid,bot,tmp1,tmp2,tmp3 : string;
begin                                    { AskIf3 }
  CursorOff;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(true);
  BaseRow:=6;
  Len[1]:=Length(Str1); Len[2]:=Length(Str2); Len[3]:=Length(Str3);
  ChrFill(tmp1,#196,Len[1]+2);
  ChrFill(tmp2,#196,Len[2]+2);
  ChrFill(tmp3,#196,Len[3]+2);
  top:=Concat(#218,tmp1,#191,'   ',#218,tmp2,#191,'   ',#218,tmp3,#191);
  mid:=Concat(#179,' ',Str1,' ',#179,'   ',#179,' ',Str2,' ',#179,'   ',
              #179,' ',Str3,' ',#179);
  bot:=Concat(#192,tmp1,#217,'   ',#192,tmp2,#217,'   ',#192,tmp3,#217);
  MaxWidth:=ScrWidth-16;
  if Length(line)<=MaxWidth then MaxWidth:=Length(line);
  if MaxWidth<Length(top)+2 then MaxWidth:=Length(top)+2;
  l:=MaxWidth+2;
  fst:=(ScrWidth-MaxWidth) div 2;
  h:=BaseRow + ((Length(line)-1) div MaxWidth);
  MakeWindow(BaseRow,fst,h,l,MessageNorm,MessageNorm,2,RNorm,shadow,1);
  if h=BaseRow then PrtcWindow(1,line)
  else
    for i:=0 to (Length(line) div MaxWidth) do
      PrtWindow(1+i,1,Copy(line,MaxWidth*i+1,MaxWidth));
  pl:=(l-2-length(top)) div 2+1;
  PrtWindow(h-4,pl,top); PrtWindow(h-3,pl,mid); PrtWindow(h-2,pl,bot);
  plc[1]:=pl+pos(Str1,mid);
  plc[2]:=pl+Pos(Str2,mid);
  plc[3]:=pl+Pos(Str3,mid);
  Tpwattr(BaseRow+h-3,fst+plc[1]-2,1,Len[1]+2,MessageRev);
  choice:=1; CLB;
  repeat
    if UseMouse then
    begin
      ShowMouseCursor; ShowMouseCursor;
    end;
    ch := ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then
    begin
      for i:=1 to 3 do
        if ((Event.x>fst+plc[i]-4) and (Event.x<fst+plc[i]+Len[i]+1)) and
           ((Event.y>BaseRow+h-5) and (Event.y<BaseRow+h-1)) then
        begin
          choice:=i; ch:=#13;
        end;
    end else if (ch=#0) then
    begin
      ch:=readkey;
      if ch in [#75,#77] then
      begin
        if (ch=#75) then newchoice:=choice-1
        else NewChoice:=choice+1;
        if Newchoice<1 then NewChoice:=3
        else if NewChoice>3 then NewChoice:=1;
        Tpwattr(BaseRow+h-3,fst+plc[Newchoice]-2,1,Len[Newchoice]+2,MessageRev);
        Tpwattr(BaseRow+h-3,fst+plc[choice]-2,1,Len[choice]+2,MessageNorm);
        choice:=NewChoice;
      end;
      ch:=#0;
    end;
  until ch=#13;
  AskIf3:=choice;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(false);
end;                                              { AskIf3 }
 
function AskIf4(line,Str1,Str2,Str3,Str4 : string) : integer;
var                            
  l,fst,h,pl,i,MaxWidth,MinWidth,choice,NewChoice : integer;
  Len,plc: array[1..4] of integer;
  BaseRow: Byte;
  ch : char;
  top,mid,bot,tmp1,tmp2,tmp3,tmp4 : string;
begin                                    { AskIf4 }
  CursorOff;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(true);
  BaseRow:=6;
  Len[1]:=Length(Str1); Len[2]:=Length(Str2); Len[3]:=Length(Str3);
  Len[4]:=Length(Str4);
  ChrFill(tmp1,#196,Len[1]+2);
  ChrFill(tmp2,#196,Len[2]+2);
  ChrFill(tmp3,#196,Len[3]+2);
  ChrFill(tmp4,#196,Len[4]+2);
  top:=Concat(#218,tmp1,#191,'   ',#218,tmp2,#191,'   ',#218,tmp3,#191,
              '   ',#218,tmp4,#191);
  mid:=Concat(#179,' ',Str1,' ',#179,'   ',#179,' ',Str2,' ',#179,'   ',
              #179,' ',Str3,' ',#179,'   ',#179,' ',Str4,' ',#179);
  bot:=Concat(#192,tmp1,#217,'   ',#192,tmp2,#217,'   ',#192,tmp3,#217,
              '   ',#192,tmp4,#217);
  MaxWidth:=ScrWidth-16;
  if Length(line)<=MaxWidth then MaxWidth:=Length(line);
  if MaxWidth<Length(top)+2 then MaxWidth:=Length(top)+2;
  l:=MaxWidth+2;
  fst:=(ScrWidth-MaxWidth) div 2;
  h:=BaseRow + ((Length(line)-1) div MaxWidth)+1;
  MakeWindow(BaseRow,fst,h,l,MessageNorm,MessageNorm,2,RNorm,shadow,1);
  if h=BaseRow+1 then PrtcWindow(1,line)
  else
    for i:=0 to (Length(line) div MaxWidth) do
      PrtWindow(1+i,1,Copy(line,MaxWidth*i+1,MaxWidth));
  pl:=(l-2-length(top)) div 2+1;
  PrtWindow(h-4,pl,top); PrtWindow(h-3,pl,mid); PrtWindow(h-2,pl,bot);
  plc[1]:=pl+pos(Str1,mid);
  plc[2]:=pl+Pos(Str2,mid);
  plc[3]:=pl+Pos(Str3,mid);
  plc[4]:=pl+Pos(Str4,mid);
  Tpwattr(BaseRow+h-3,fst+plc[1]-2,1,Len[1]+2,MessageRev);
  choice:=1;
  CLB;
  repeat
    if UseMouse then
    begin
      ShowMouseCursor; ShowMouseCursor;
    end;
    ch := ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then
    begin
      for i:=1 to 4 do
        if ((Event.x>fst+plc[i]-4) and (Event.x<fst+plc[i]+Len[i]+1)) and
           ((Event.y>BaseRow+h-5) and (Event.y<BaseRow+h-1)) then
        begin
          choice:=i; ch:=#13;
        end;
    end else if (ch=#0) then
    begin
      ch:=readkey;
      if ch in [#75,#77] then
      begin
        if (ch=#75) then newchoice:=choice-1
        else NewChoice:=choice+1;
        if Newchoice<1 then NewChoice:=4
        else if NewChoice>4 then NewChoice:=1;
        Tpwattr(BaseRow+h-3,fst+plc[Newchoice]-2,1,Len[Newchoice]+2,MessageRev);
        Tpwattr(BaseRow+h-3,fst+plc[choice]-2,1,Len[choice]+2,MessageNorm);
        choice:=NewChoice;
      end;
      ch:=#0;
    end;
  until ch=#13;
  AskIf4:=choice;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(false);
end;                                              { AskIf4 }

procedure MessageOK(line: string; Norm,Rev: Byte);
Const
  BaseRow=8;
  OkStr: string='Ok';
Var
  OkLen,l,pl,fst,i,h,MaxWidth,nlines: integer;
  top,mid,bot,tmp1: string;
  ch: char;
  ercode: byte;
begin                                     { MessageOK }
  ChrDelL(line,' '); ChrDelR(line,' '); line:=' '+line+' ';
  CursorOff;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(true);
  OkLen:=Length(OkStr);
  ChrFill(tmp1,#196,OkLen+2);
  top:=Concat(#218,tmp1,#191);
  mid:=Concat(#179,' ',OkStr,' ',#179);
  bot:=Concat(#192,tmp1,#217);
  MaxWidth:=length(top)+2;
  if MaxWidth<length(line) then MaxWidth:=length(line);
  if MaxWidth>ScrWidth-6 then MaxWidth:=ScrWidth-6;
  nlines:=1+(length(line)-1) div MaxWidth;
  fst:=(ScrWidth-MaxWidth) div 2;
  MakeWindow(BaseRow,fst,nlines+5,MaxWidth+2,Norm,Norm,2,RNorm,shadow,1);
  for i:=1 to nlines do
    PrtWindow(i,1,Copy(line,MaxWidth*(i-1)+1,MaxWidth));
  pl:=(MaxWidth-length(top)) div 2+1;
  PrtWindow(nlines+1,pl,top);
  PrtWindow(nlines+2,pl,mid);
  PrtWindow(nlines+3,pl,bot);
  Tpwattr(BaseRow+nlines+2,fst+pl+1,1,OkLen+2,Rev);
  CLB;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
  end;
  ch := ReadKeyMouse;
  if ch=#0 then ch:=ReadKey;
  if Usemouse then HideMouseCursor;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
  SuspendWaiting(false);
end;                                { MessageOK }

procedure message(line: string);
begin                               { Message }
  if CurrentWindow=0 then
  begin
    ChrDelL(line,' ');
    writeln; writeln(line);
    write('Press key to continue...'); readln;
  end else messageOK(line,MessageNorm,MessageRev);
end;                                { Message }

procedure MessageRC(id: word; S: string);
begin
  Message(wvsprintf(StringResource^.Get(id),S));
end;

procedure ErrorMessage(line: string);
begin                               { ErrorMessage }
  if CurrentWindow=0 then
  begin
    ChrDelL(line,' ');
    writeln; writeln(line);
    write('Press key to continue...'); readln;
  end else messageOK(line,ErrorNorm,ErrorRev);
end;                                { ErrorMessage }

procedure ErrorMessageRC(id: word; S: string);
begin
  ErrorMessage(wvsprintf(StringResource^.Get(id),S));
end;
 
function YesNo(line: string) : boolean;
begin                               { YesNo }
  ChrDelL(line,' '); ChrDelR(line,' '); line:=' '+line+' ';
  YesNo:=AskIf(line,'','Yes','No');
end;                                { YesNo }

function YesNoRC(id: word; S: string): boolean;
begin
  YesNoRC:=AskIf(wvsprintf(StringResource^.Get(id),S),'','Yes','No');
end;
  
procedure showmem(s: string);
var tmp: string;
begin
  Str(MaxAvail,tmp); message(s+tmp);
end;

procedure FreeMemDeficit(s: string; MemoryFree: LongInt);
var
  m: longint;
  tmp: string[10];
begin
  m:=MaxAvail;
  if m<>MemoryFree then
  begin
    Str(MemoryFree-m,tmp); message(s+' - deficit of '+tmp+' bytes. ');
  end;
end;
 
procedure ReadScrStr(Var s: string; x,y: byte; var xfirst, att: byte;
                     allow: CharSet);
var
  i,j: byte;
  ch: char;
  Pixel: PixelType;
begin                          { ReadScrStr }
  if UseMouse then HideMouseCursor;
  s:='';
  GetPixel(x,y,Pixel);
  att:=Pixel.at;
  if att=Blink then GetPixelAttr(x+1,y,att);
  ch:=Pixel.ch;
  xfirst:=0;
  if not (ch in allow) then Exit;
  i:=x;
  repeat
    i:=i-1;
    GetPixelChar(i,y,ch);
  until (i=0) or (not (ch in allow));
  xfirst:=i+1;
  i:=xfirst;
  getPixelChar(xfirst,y,ch);
  repeat
    s:=Concat(s,ch);
    i:=i+1;
    if (i<=ScrWidth) then GetPixelChar(i,y,ch);
  until (i>ScrWidth) or (not (ch in allow));
  if UseMouse then ShowMouseCursor;
end;                            { ReadScrStr }

procedure NewMouseMenu(var Menu: MouseMenuRecPtr);
var
  i: integer;
begin
  New(Menu);
  with Menu^ do
  begin
    nitems:=0;
    startpos:=1;
    curntpos:=1;
    flon:=true;
    bartype:=1;
    for i:=1 to MaxMenu do
    begin
      ToMenu[i]:=false; SubMenu[i]:=Nil; item[i]:=Nil; retrn[i]:=0;
    end;
    fchars:='';
  end;
end;

procedure NewMenuItem(M: MouseMenuRecPtr; S: ItemStringType; HotKey: char;
                      ret: byte);
begin
  with M^ do
  begin
    if nitems>=MaxMenu then Halt(255);
    inc(nitems);
    GetMem(item[nitems],length(S)+2);
    Move(S[0],item[nitems]^[0],length(S)+1);
    fchars:=fchars+HotKey;
    if ret=0 then retrn[nitems]:=nitems
    else retrn[nitems]:=ret;
  end;
end;

procedure NewMenuLine(M: MouseMenuRecPtr);
begin
  with M^ do
  begin
    if nitems>=MaxMenu then Halt(255);
    inc(nitems);
    fchars:=fchars+#1;
  end;
end;

procedure MakeMouseMenu(Var menu: MouseMenuRec; y0,x0,ylen,xlen: integer;
                        var choice: byte; T: TopMenuPtr; depth: byte);
var
  i,j,maxlen,oldpos,x,y,xfirst,yfirst,passed,origpos: integer;
  ch,ch1,chmore: char;
  bpress,ExOnFirst,MovedBar: boolean;
  CapPl: array[1..MaxMenu] of Byte;
 
procedure bar(last,next: byte);
begin                            { Bar }
  if menu.bartype=0 then Exit;
  if menu.bartype=1 then
  begin
    if (last>0) and (menu.item[last]<>Nil) then
    begin
      TpwAttr(y0+last,x0+1,1,xlen-2,MenuNorm);
      TpwAttr(y0+last,x0+2+CapPl[last],1,1,MenuBright);
    end;
    if (next>0) and (menu.item[next]<>Nil) then
                  TpwAttr(y0+next,x0+1,1,xlen-2,menuRev);
  end else if menu.bartype=2 then
  begin
    if (last>0) and (menu.item[last]<>Nil) then
    begin
      TpwAttr(y0+last,x0+2,1,length(menu.item[last]^),MenuNorm);
      TpwAttr(y0+last,x0+2+CapPl[last],1,1,MenuBright);
    end;
    if (next>0) and (menu.item[next]<>Nil) then
      TpwAttr(y0+next,x0+2,1,length(menu.item[next]^),menuRev);
  end else if menu.bartype=3 then
  begin
    if (last>0) and (menu.item[last]<>Nil) then
                       Tpwprint(y0+last,x0+1,'  ',MenuNorm);
    if (next>0) and (menu.item[next]<>Nil) then
                        Tpwprint(y0+next,x0+1,'=>',MenuRev);
  end;
end;                                 { Bar }
 
begin                                { MakeMouseMenu }
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  choice:=0;
  Tpwfill(y0+1,x0+1,ylen-2,xlen-2,' ',MenuNorm);
  for i:=1 to menu.nitems do
  begin
    if menu.item[i]=Nil then                  { line }
    begin
      CapPl[i]:=0;
      for j:=1 to xlen-2 do Tpwprint(y0+i,x0+j,#196,MenuNorm)
    end else
    begin
      CapPl[i]:=Pos(menu.fchars[i],menu.item[i]^);
      if CapPl[i]=0 then
      begin
        j:=1;
        repeat
          if menu.item[i]^[j]=' ' then Inc(j)
          else CapPl[i]:=j;
        until (CapPl[i]>0) or (j>length(menu.item[i]^));
      end;
      if CapPl[i]>0 then CapPl[i]:=CapPl[i]-1;
      if menu.bartype=3 then
      begin
        Tpwprint(y0+i,x0+4,menu.item[i]^,MenuNorm);
        Tpwattr(y0+i,x0+4+CapPl[i],1,1,MenuBright);
      end else
      begin
        Tpwprint(y0+i,x0+2,menu.item[i]^,MenuNorm);
        Tpwattr(y0+i,x0+2+CapPl[i],1,1,MenuBright);
      end;
    end;
  end;
  if (menu.curntpos<1) or (menu.curntpos>menu.nitems) then menu.curntpos:=1;
  bpress:=false; if UseMouse then bpress:=buttonpressed;
  if bpress then
  begin
    ShowMouseCursor;
    origpos:=menu.curntpos;
    xfirst:=GetMouseX div xpixels+1; yfirst:=GetMouseY div ypixels+1;
    oldpos:=0;
    MovedBar:=false;
    repeat
      x:=GetMouseX div xpixels+1; y:=GetMouseY div ypixels+1;
      if (depth=1) and (y=1) and (T<>Nil) then  { released on the menu bar }
      begin
        i:=0;
        for j:=1 to T^.nitems do
          if (x>=T^.ipos[j]) and (x<T^.ipos[j]+length(T^.item[j])) then i:=j;
        if (i>0) and (i<>T^.currentpos) {and (T^.ToMenu[i]) and (T^.SubMenu[i]<>Nil)} then
        begin
          bpress:=true; choice:=253;
        end;
      end else if ((x>=x0) and (x<x0+xlen)) and ((y>y0) and
                               (y<=y0+menu.nitems)) then
      begin
        menu.curntpos:=y-y0;
        if menu.curntpos<>oldpos then
        begin
          HideMouseCursor;
          Bar(oldpos,menu.curntpos);
          ShowMouseCursor;
          oldpos:=menu.curntpos;
        end;
        MovedBar:=true;
      end else if oldpos>0 then
      begin
        Menu.curntpos:=0;
        HideMouseCursor;
        Bar(oldpos,0);
        ShowMouseCursor;
        oldpos:=0;
      end;
    until (not ButtonPressed) or (choice=253);
    if (choice<>253) and not (((x>=x0) and (x<x0+xlen)) and ((y>y0) and
                         (y<=y0+menu.nitems))) then
    begin
      if y>1 then
      begin
        bpress:=true;
        Menu.curntpos:=0;
      end else
      begin
        bpress:=false;
        Menu.curntpos:=1;
      end; 
    end;
    HideMouseCursor;
  end;
  if not bpress then
  begin
    Bar(0,menu.curntpos);
    ExOnFirst:=false;
    repeat
      oldpos:=menu.curntpos;
      if UseMouse then ShowMouseCursor;
      ch:=ReadKeyMouse;
      if UseMouse then HideMouseCursor;
      if Event.mpress then
      begin
        if ((Event.x>=x0) and (Event.x<x0+xlen)) and ((Event.y>y0) and
              (Event.y<y0+menu.nitems+1)) and (menu.item[Event.y-y0]<>Nil) then
        begin
          ch:=#13;
          menu.curntpos:=Event.y-y0;
        end else
        begin
          menu.curntpos:=0;
          ch:=#13;
          if Event.y=1 then ExOnFirst:=true;
        end;
      end;
      if ch=#0 then chmore:=ReadKey else chmore:=#0;
      AltChars(ch,chmore,menu.fchars);
      if ch=#0 then
      begin
        ch1:=chmore;
        if ch1=#72 then    { Up }
        begin
          menu.curntpos:=menu.curntpos-1;
          if menu.curntpos<1 then menu.curntpos:=menu.nitems;
          if menu.item[menu.curntpos]=Nil then dec(menu.curntpos);
        end else if ch1=#80 then {Down}
        begin
          inc(menu.curntpos);
          if menu.curntpos>menu.nitems then menu.curntpos:=1;
          if menu.item[menu.curntpos]=Nil then inc(menu.curntpos);
        end else if (depth=1) and (ch1=#75) then    { Left }
        begin
          choice:=254; ch:=#13;
        end else if (depth=1) and (ch1=#77) then    { Right }
        begin
          choice:=255; ch:=#13;
        end;
      end;
      if ch=#27 then      { Quit }
      begin
        menu.curntpos:=0;
        ch:=#13;
      end else if menu.flon then
      for i:=1 to menu.nitems do
      if (Upcase(ch)=Upcase(menu.fchars[i])) and (menu.item[i]<>Nil) then
      begin
        menu.curntpos:=i;
        ch:=#13;
      end;
      if menu.curntpos<>oldpos then Bar(oldpos,menu.curntpos);
      if Event.mpress and (not ExOnFirst) then WaitForRelease(255);
    until ch=#13;
  end;
  if (menu.curntpos>0) and (menu.item[menu.curntpos]=Nil) then menu.curntpos:=0;
  if choice=0 then choice:=menu.curntpos
  else if choice=253 then
  begin
    menu.curntpos:=0; choice:=0;
  end;
end;                                   { MakeMouseMenu }

procedure CalcWidth(var M: MouseMenuRec);
var
  i: integer;
begin
  with M do
  begin
    width:=0;
    for i:=1 to nitems do
    if item[i]<>Nil then
    begin
      ChrDelL(item[i]^,' '); ChrDelR(item[i]^,' ');
      if width<length(item[i]^) then width:=length(item[i]^);
    end;
  end;
end;

procedure SubMenu(var M: MouseMenuRec; var selected: SelectionType; depth: byte;
                  Ox0,Oy0,OWidth,Oheight: integer);
var
  i,x01,x02,x0,y0,W,Shad: integer;
begin
  if depth>MaxMenuStack then
  begin
    ErrorMessage(' Menu stack too deep! '); Halt(1);
  end;
  if selected[depth]<>0 then Exit;
  for i:=depth to MaxMenuStack do selected[i]:=0;
  CalcWidth(M);
  W:=M.Width+4;
  y0:=Oy0+selected[depth-1];
  x01:=Ox0+OWidth-W+3;
  x02:=Ox0-3; if x02+W+2>=Ox0+OWidth then x02:=Ox0+OWidth-W-3;
  if depth mod 2=1 then
  begin
    x0:=x01; if x0+M.Width+2>ScrWidth then x0:=x02;
  end else
  begin
    x0:=x02; if x0<1 then x0:=x01;
  end;
  if x0<1 then x0:=1; if x0+W+2>ScrWidth then x0:=ScrWidth-W-2;
  if y0+M.nitems+1>=ScrLen then y0:=ScrLen-M.nitems-2;
  if y0<1 then y0:=1;
  Shad:=Shadow; if y0+M.nitems+1>=ScrLen then Shad:=0;
  MakeWindow(y0,x0,M.nitems+2,W,MenuNorm,MenuBorder,1,RNorm,shad,0);
  MakeMouseMenu(M,y0,x0,M.nitems+2,W,selected[depth],Nil,depth);
  if (selected[depth]>0) and (selected[depth]<=M.nitems)
     and (M.SubMenu[M.curntpos]<>Nil) and M.ToMenu[M.curntpos] then
  begin
    SubMenu(M.SubMenu[M.curntpos]^,selected,depth+1,x0,y0,W,M.nitems+2);
    if selected[depth+1]=0 then selected[depth]:=0;
  end;
  if (selected[depth]>0) and (Selected[depth]<=M.nitems) then
    selected[depth]:=M.retrn[selected[depth]];
  RemoveWindow;
end;                          { SubMenu }

procedure TopLineItem(var M: MouseMenuRec; var selected: SelectionType;
                      var T: TopMenuType);
var
  i,x0,y0,W,x,y,shad: integer;
begin
  if selected[1]<>0 then Exit;
  for i:=1 to MaxMenuStack do selected[i]:=0;
  CalcWidth(M);
  W:=M.Width+4;
  x0:=T.ipos[selected[0]]; y0:=2;
  if x0+W>=ScrWidth then x0:=x0-W+length(T.item[selected[0]]);
  if y0+M.nitems+1>ScrLen then y0:=ScrLen-M.nitems-1;
  if y0<1 then y0:=1;
  Shad:=Shadow; if y0+M.nitems+1>=ScrLen then Shad:=0;
  MakeWindow(2,x0,M.nitems+2,W,MenuNorm,MenuBorder,1,RNorm,shad,0);
  MakeMouseMenu(M,2,x0,M.nitems+2,W,selected[1],@T,1);
  if (selected[1]>0) and (selected[1]<=M.nitems)
     and (M.curntpos>0) and (M.SubMenu[M.curntpos]<>Nil) and M.ToMenu[M.curntpos] then
  begin
    SubMenu(M.SubMenu[M.curntpos]^,selected,2,x0,2,W,M.nitems+2);
    if selected[2]=0 then selected[1]:=0;
  end;
  if (selected[1]>0) and (Selected[1]<=M.nitems) then
    selected[1]:=M.retrn[selected[1]];
  RemoveWindow;
end;                               { TopLineItem }

procedure ScrollBarMake(var ScrBar: ScrBarType; var Scroll: longint;
                        xx,yy0,yy1,hh,LastLine: longint; ScrBarColor: byte);
var
  j,scr2: longint;
  a: real;
begin
  if LastLine<0 then LastLine:=0;
  with ScrBar do
  begin
    LastY:=LastLine; Color:=ScrBarColor;
    X:=xx; Y0:=yy0+1; Y1:=yy1-1; Len:=yy1-yy0-1; height:=hh;
    Tpwprint(YY0,X,#30,Color);
    Tpwprint(YY1,X,#31,Color);
    Scr2:=Scroll; if Scr2>LastY-Height then Scr2:=LastY-Height;
    if Scr2<0 then Scr2:=0;
    if (Scr2=0) and (height>=LastY) then
    begin
      MarkBegin:=0; MarkEnd:=Len-1;
    end else if (Scr2>0) and (Scr2<Len) and (Len>=LastY) then
    begin
      MarkBegin:=Scr2; MarkEnd:=Len-1;
    end else if LastY-Height<Len then
    begin
      MarkBegin:=Scr2; MarkEnd:=Len-(LastY-height-Scr2)-1;
      if MarkEnd>=Len then MarkEnd:=Len-1;
    end else
    begin
      if (Scr2=0) then a:=0
      else a:=Scr2 / (LastY-height);
      MarkBegin := round(a*Len);
      if MarkBegin<0 then MarkBegin:=0
      else if MarkBegin>=Len then MarkBegin:=Len-1;
      MarkEnd:=MarkBegin;
    end;
    for j:=0 to MarkBegin-1 do     TpwPrint(Y0+j,X,#177,Color);
    for j:=MarkBegin to MarkEnd do TpwPrint(Y0+j,X,#219,Color);
    for j:=MarkEnd+1 to Len-1 do   TpwPrint(Y0+j,X,#177,Color);
  end;
end;                           { ScrollBarMake }

procedure ScrollBarClick(var ScrBar: ScrBarType; var Scroll: longint);
const
  DelayTime=18;
var
  ym,OrigYm,Delta,ODelta,j: longint;
  a: real;
  Time,DTime: LongInt;
  
begin
  with ScrBar do
  begin
    ym:=GetMouseY div ypixels+1;
    if ((ym=y0-1) and (Scroll>0)) or ((ym=y1+1) and (Scroll+height<LastY)) then
                               { Up/Down }
    begin
      Time:=GetTicks;
      if HeldDown then
      begin
        DTime:=Time-PressTime; if DTime<0 then DTime:=DTime + 1573040;
        while buttonpressed and (DTime<DelayTime) do
        begin
          Time:=GetTicks;
          DTime:=Time-PressTime; if DTime<0 then DTime:=DTime + 1573040;
        end;
        if buttonpressed then
        begin
          if ym=y0-1 then Dec(Scroll)
          else inc(Scroll);
        end else HeldDown:=false;
      end else
      begin
        if ym=y0-1 then Dec(Scroll)
        else inc(Scroll);
        PressTime:=Time; HeldDown:=true;
      end;        
    end else if (ym=y0) and (Scroll>0) then                    { PgUp }
    begin
      Scroll:=Scroll-(height-1); if Scroll<0 then Scroll:=0;
      HeldDown:=false;
    end else if (ym=y1) and (Scroll+height<LastY) then         { PgDn }
    begin
      Scroll:=Scroll+(height-1);
      if Scroll>LastY-height then Scroll:=LastY-Height;
      HeldDown:=false;
    end else if (ym>=y0+MarkBegin) and (ym<=Y0+MarkEnd) then   { Drag }
    begin
      HeldDown:=false;
      OrigYM:=ym;
      while ButtonPressed do
      begin
        Ym:=GetMouseY div ypixels+1;
        Delta:=Ym-OrigYm;
        if Delta<>0 then
        begin
          MarkBegin:=MarkBegin+Delta; MarkEnd:=MarkEnd+Delta;
          if MarkBegin<0 then
          begin
            MarkEnd:=MarkEnd-MarkBegin; MarkBegin:=0;
          end else if MarkEnd>=Len then
          begin
            MarkBegin:=MarkBegin+Len-1-MarkEnd; MarkEnd:=Len-1;
          end;
          for j:=0 to MarkBegin-1 do     TpwPrint(Y0+j,X,#177,Color);
          for j:=MarkBegin to MarkEnd do TpwPrint(Y0+j,X,#219,Color);
          for j:=MarkEnd+1 to Len-1 do   TpwPrint(Y0+j,X,#177,Color);
          OrigYm:=Ym;
        end;
      end;
      if LastY-Height<Len then Scroll:=MarkBegin
      else if MarkEnd=Len-1 then Scroll:=LastY-height+1
      else begin
        a:=MarkBegin / len;
        Scroll:=round(a*(LastY-height));
      end;
    end;
  end;
end;                               { ScrollBarClick }

procedure Topline(var TopMenu : TopMenuType; var selected: SelectionType;
                  DrawOnly: boolean; var outside: boolean;
                  var Scroll: longint; LastY: LongInt; ScrBar: ScrBarPtr);
var
  i,j,nchoice,lastpos,x,y,passed,curpos : integer;
  ch,ch1,chmore : char;
  exitmenu,doublepress,waitFR,SubsDown : boolean;
  GoLeft,GoRight: boolean;
  spaces,tmp : string;
  xfirst,att: Byte;
  CapPl: array[1..MaxTopLine] of byte;
  choice: byte;
  movement: string[10];
  OldScroll: LongInt;
 
begin                       { TopLine }
  Clb;   { Clear keyboard buffer }
  AbortFlag:=false;
  for i:=0 to MaxMenuStack do selected[i]:=0;
  waitFR:=outside;
  FillChar(spaces[1],ScrWidth,' '); spaces[0]:=Chr(ScrWidth);
  exitmenu:=false;
  outside:=false;
  if UseMouse then
  begin
    ShowMouseCursor;  ShowMouseCursor;
    if not ButtonPressed then ScrollPressStatus:=0;
  end;
  with TopMenu do
  begin
    if UseMouse then HideMouseCursor;
                                          { Display top bar }
    Tpwprint(1,1,spaces,TopMenuRev);
    for i:=1 to nitems do
    begin
      CapPl[i]:=Pos(fchars[i],item[i]);
      if CapPl[i]=0 then
      begin
        j:=1;
        while (CapPl[i]=0) and (j<=length(item[i])) do
        begin
          if item[i][j]=' ' then Inc(j)
          else CapPl[i]:=j;
        end;
      end;
      if CapPl[i]>0 then CapPl[i]:=CapPl[i]-1;
      Tpwprint(1,ipos[i],item[i],TopMenuRev);
      Tpwattr(1,ipos[i]+CapPl[i],1,1,TopMenuBright);
    end;
                                       { Scroll bar }
                                       
    if ScrBar<>Nil then
      ScrollBarMake(ScrBar^,Scroll,ScrWidth,3,ScrLen-1,ScrLen-3,LastY,ScrBar^.Color);

    if (currentpos<1) or (CurrentPos>nitems) then Currentpos:=1;
    choice:=CurrentPos;
    lastpos:=currentpos;
    GoLeft:=false; GoRight:=false; SubsDown:=false;
                                         { Run }
    if not DrawOnly then
    repeat
      Tpwprint(1,ipos[currentpos],item[currentpos],TopMenuNorm);
      if UseMouse then ShowMouseCursor;
      if waitFR then ch:=#255
      else if GoLeft or GoRight then
      begin
        Event.mpress:=false; ch:=#0;
      end else ch := ReadkeyMouse;
      if UseMouse then HideMouseCursor;
      doublepress:=true;
      if (ch=#255) or Event.mpress then
      begin
        doublepress:=false; Event.mpress:=true;
        if Event.y=1 then
        begin
          ch:=#254;
          nchoice:=0;
          for i:=1 to nitems do
          if (Event.x>=ipos[i]) and (Event.x<ipos[i]+length(item[i])) then
            nchoice:=i;
          if nchoice>0 then
          begin
            doublepress:=true;
            ch:=fchars[nchoice];
          end;
        end;
      end;
      if GoLeft then chmore:=#75
      else if GoRight then chmore:=#77
      else if ch=#0 then chmore:=ReadKey else chmore:=#0;
      AltChars(ch,chmore,fchars+AltExpect);
      if (chmore=#255) and (Pos(UpCase(ch),AltExpect)>0) then  { Alt keys }
      begin
        exitmenu:=true;
        choice:=Ord(ch);
      end else if (chmore=#0) and (Event.ScanCode=14) then    { The BS key }
      begin
        Choice:=CTop_BS; ExitMenu:=true;
      end else if (chmore=#0) and (Ord(ch) in [1..26]) and
          (Pos(Chr(Ord(ch)+Ord('a')-1),AltExpect)>0) and (ch<>#13) then { Ctrl keys }
      begin
        exitmenu:=true;
        choice:=Ord(ch)+Ord('a')-1;
      end else if Pos(Upcase(ch),fchars)>0 then
      begin
        choice:=Pos(Upcase(ch),fchars); currentpos:=choice;
        if currentpos <> lastpos then
        begin
          if (lastpos>0) and (lastpos<=nitems) then
          begin
            Tpwprint(1,ipos[lastpos],item[lastpos],TopMenuRev);
            Tpwattr(1,ipos[lastpos]+CapPl[lastpos],1,1,TopMenuBright);
          end;
          Tpwprint(1,ipos[currentpos],item[currentpos],TopMenuNorm);
        end;
        exitmenu:=doublepress;
      end else if ch=#27 then       { Esc }
      begin
        choice:=nitems;
        exitmenu:=true;
      end else if ch=#32 then       { Space }
      begin
        Choice:=CTop_Space; ExitMenu:=true;
      end else if ch=#9 then        { Tab }
      begin
        Choice:=CTop_Tab; ExitMenu:=true;
      end else if ch=#255 then          { Outside }
      begin
        if (ScrBar<>Nil) and (Event.x=ScrWidth) and (Event.y>2) and
           (Event.y<ScrLen) then
        begin
          OldScroll:=Scroll;
          ScrollBarClick(ScrBar^,Scroll);
          if Scroll<>OldScroll then
          begin
            choice:=CTop_Scroll; movement:='scrollbar';
          end else choice:=0;
        end else choice:=CTop_Outside;
        outside:=(choice=CTop_Outside);
        exitmenu:=(choice<>0);
      end else
      begin
        if ch = #0 then
        begin
          ch := chmore;
          if ch=#75 then      { Left }
          begin
            LastPos:=currentpos;
            choice:=(currentpos+nitems-2) mod nitems +1; currentpos:=choice;
          end else if ch=#77 then    { Right }
          begin
            LastPos:=currentpos;
            choice:=currentpos mod nitems +1; currentpos:=choice;
          end else if ch=#59 then      { F1 }
          begin
            Choice:=CTop_F1; exitmenu:=true;
          end else if ch=#71 then      { Home }
          begin
            Choice:=CTop_Scroll; movement:='home';
          end else if ch=#79 then      { End }
          begin
            Choice:=CTop_Scroll; movement:='end';
          end else if ch=#72 then                  { Up }
          begin
            Choice:=CTop_Scroll; movement:='up';
          end else if (ch=#80) and Event.Shift then      { Shift-Down }
          begin
            Choice:=CTop_Scroll; movement:='down';
          end else if ch=#80 then                    { plain down }
          begin
            choice:=CurrentPos;
          end else if (ch=#73) then   { PgUp }
          begin
            Choice:=CTop_Scroll; movement:='pgup';
          end else if (ch=#81) then   { PgDn }
          begin
            Choice:=CTop_Scroll; movement:='pgdn';
          end else if ch=#119 then     { Ctrl-Home }
          begin
            Choice:=CTop_CHome; ExitMenu:=true;
          end else if ch=#117 then     { Ctrl-End }
          begin
            Choice:=CTop_CEnd; ExitMenu:=true;
          end else if (ch=#15) or (ch=#148) then  { Shift-TAB and Ctrl-TAB }
          begin
            Choice:=CTop_SCTab; ExitMenu:=true;
          end;
        end;
        if (CurrentPos<>Lastpos) then
        begin
          Tpwprint(1,ipos[lastpos],item[lastpos],TopMenuRev);
          TpwAttr(1,ipos[Lastpos]+CapPl[Lastpos],1,1,TopMenuBright);
          Tpwprint(1,ipos[currentpos],item[currentpos],TopMenuNorm);
        end;
        LastPos:=CurrentPos;
        if (ch=#13) or
           ((choice<=nitems) and (choice>0) and (ch=#80) and not Event.Shift
              and ToMenu[choice])
              then ExitMenu:=true;
        if (GoLeft or GoRight or SubsDown) and ((choice<=nitems) and (choice>0))
          and (ToMenu[choice]) and (SubMenu[choice]<>Nil) then
             ExitMenu:=true;
      end;
      LastPos:=CurrentPos;
      GoLeft:=false; GoRight:=false;

      if  (choice=CTop_Scroll) then          { Cursor movements }
      begin
        if (movement='up'  ) and (Scroll>0) then           { Up }
        begin
          Dec(Scroll);
        end else if (movement='down') and (LastY-Scroll>ScrLen-3) then { Down }
        begin
          Inc(Scroll);
        end else if  movement='home'  then Scroll:=0     { Home }
        else if  movement='end'   then      { End }
        begin
          Scroll:=LastY-ScrLen+3; if Scroll<0 then Scroll:=0;
        end else if (movement='pgup') and (Scroll>0) then
        begin
          Scroll:=Scroll-(ScrLen-4);  if Scroll<0 then Scroll:=0;
        end else if (movement='pgdn') and (Scroll+ScrLen-3<LastY) then
        begin
          Scroll:=Scroll+(ScrLen-4);
          if Scroll>LastY-ScrLen+3 then Scroll:=LastY-ScrLen+3;
          if Scroll<0 then Scroll:=0;
        end;
        if (ScrBar<>Nil) and (movement<>'scrollbar') then ScrBar^.HeldDown:=false;
        if UseMouse and ((ScrBar=Nil) or (not ScrBar^.HeldDown)) then
          WaitForRelease(255);
        exitmenu:=true;
      end else
      begin
        if ScrBar<>Nil then ScrBar^.HeldDown:=false;
        if outside and UseMouse then WaitForRelease(255)
        else if Event.mpress and ((choice>nitems) or (choice=0) or
           (not ToMenu[choice])) and (not waitFR) then
        begin
          if ButtonPressed then
          begin
            ShowMouseCursor;
            ExitMenu:=false;
            repeat
              x:=GetMouseX div xpixels +1; y:=GetMouseY div ypixels+1;
              choice:=0;
              if y=1 then
              begin
                nchoice:=0;
                for i:=1 to nitems do
                if (x>=ipos[i]) and (x<ipos[i]+length(item[i])) then nchoice:=i;
                if (nchoice>0) and (nchoice<>CurrentPos) then
                begin
                  HideMouseCursor;
                  Tpwprint(1,ipos[CurrentPos],item[currentpos],TopMenuRev);
                  TpwAttr(1,ipos[CurrentPos]+CapPl[CurrentPos],1,1,TopMenuBright);
                  LastPos:=CurrentPos; CurrentPos:=nchoice; 
                  Tpwprint(1,ipos[currentpos],item[currentpos],TopMenuNorm);
                  ShowMouseCursor;
                end;
                choice:=nchoice;
              end;      
            until ((choice>0) and ToMenu[nchoice] and (SubMenu[nchoice]<>Nil))
                  or not ButtonPressed;
            if (not ButtonPressed) and (choice>0) and (GetMouseY div ypixels=0)
              then ExitMenu:=true
            else choice:=0;
            HideMouseCursor;
          end
        end;
      end;
      if (choice>0) and (choice<=nitems) then
      begin
        selected[0]:=choice;
        currentpos:=choice;
        if exitmenu and ToMenu[choice] and (SubMenu[choice]<>Nil) then
        begin
          TopLineItem(SubMenu[choice]^,selected,TopMenu);
          if selected[1]=0 then
          begin
            exitmenu:=false; selected[0]:=0;
          end else if selected[1]=254 then
          begin
            GoLeft:=true; exitmenu:=false; selected[0]:=0; selected[1]:=0;
          end else if selected[1]=255 then
          begin
            GoRight:=true; exitmenu:=false; selected[0]:=0; selected[1]:=0;
          end;
          SubsDown:=GoLeft or GoRight;
        end;
      end;
    until exitmenu;
    if (choice>0) and (choice<=nitems) then selected[0]:=retrn[choice]
    else selected[0]:=choice;
  end;
end;                     { TopLine }

begin
  Colors[0]:='black';
  Colors[1]:='blue';
  Colors[2]:='green';
  Colors[3]:='cyan';
  Colors[4]:='red';
  Colors[5]:='magenta';
  Colors[6]:='brown';
  Colors[7]:='lightgray';
  Colors[8]:='darkgray';
  Colors[9]:='lightblue';
  Colors[10]:='lightgreen';
  Colors[11]:='lightcyan';
  Colors[12]:='lightred';
  Colors[13]:='lightmagenta';
  Colors[14]:='yellow';
  Colors[15]:='white';
  Blink:=Attr(0,15);
  RNorm:=Attr(7,0);
  RRev:=Attr(0,7);
  RBlink:=Attr(0,15);
  RBright:=Attr(15,0);
  DispTimeout:=0;
  TimeOutOn:=false;
  suspended:=false;
  ScrollPressStatus:=0;
  AmWaiting:=false; SuspendedWaiting:=false;
  PSuspendFile:=Nil;
  AbortFlag:=false;

{ String resource }
  With RStringList do
  begin
    ObjType := 52;
    VmtLink := Ofs(Typeof(TStringList)^);
    Store   := Nil;
    Load    := @TStringList.Load;
  end;
  RegisterType(RStringList);

  ResourceFile.Init(New(PDosStream,init(ParamStr(0),stOpenRead)));
  StringResource:=PStringList(ResourceFile.Get('StringList'));

end.
