/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.common;

import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsMessages;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValue;
import com.dickimawbooks.bibgls.common.BibGlsArgValueType;
import com.dickimawbooks.texparserlib.AbstractTeXApp;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.NoSuchFileException;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Properties;

public abstract class BibGlsTeXApp
extends AbstractTeXApp {
    protected Charset defaultCharset = Charset.defaultCharset();
    protected Locale defaultLocale = null;
    protected Bib2GlsMessages messages;
    public static final int SILENT = -1;
    public static final int NORMAL = 0;
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    protected String langTag = null;
    protected int debugLevel = 0;
    protected int verboseLevel = 0;
    protected boolean shownVersion = false;
    protected String docLocale = null;
    protected boolean argsFound = false;
    protected String logName = null;
    protected File transcriptFile = null;
    protected PrintWriter logWriter = null;
    protected int exitCode = 0;
    public static final int SYNTAX_ITEM_LINEWIDTH = 78;
    public static final int SYNTAX_ITEM_TAB = 30;
    public static final String VERSION = "4.7";
    public static final String DATE = "2025-11-13";

    protected BibGlsTeXApp() {
    }

    protected void initialise(String[] stringArray) throws Bib2GlsException, IOException {
        ArrayDeque<String> arrayDeque = this.preparse(stringArray);
        this.preInitMessages();
        this.initMessages();
        this.postInitMessages();
        this.parseArgs(arrayDeque);
        this.setDebugLevel(this.debugLevel);
    }

    protected void preInitMessages() throws Bib2GlsException, IOException {
    }

    protected void postInitMessages() throws Bib2GlsException, IOException {
    }

    protected void setDebugLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(this.getMessage("error.invalid.opt.minint.value", "--debug", n, 0));
        }
        this.debugLevel = n;
        if (n > 0) {
            this.verboseLevel = 2;
        }
    }

    protected void setDebugLevel(String ... stringArray) throws Bib2GlsSyntaxException {
        this.verboseLevel = 2;
        try {
            this.debugLevel = TeXParser.getDebugLevelFromModeList((String[])stringArray);
        }
        catch (TeXSyntaxException teXSyntaxException) {
            throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.option_syntax", "--debug-mode", teXSyntaxException.getMessage((TeXApp)this)));
        }
    }

    public boolean isSilent() {
        return this.verboseLevel == -1;
    }

    public boolean isDebuggingOn() {
        return this.debugLevel > 0 || this.verboseLevel >= 2;
    }

    public boolean isVerbose() {
        return this.verboseLevel >= 1;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void logMessageNoLn(String string) {
        if (this.logWriter != null) {
            this.logWriter.print(string);
        }
    }

    public void logMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    public void logMessage() {
        if (this.logWriter != null) {
            this.logWriter.println();
        }
    }

    protected File newTranscriptFile() throws IOException {
        return this.logName == null ? null : new File(this.logName);
    }

    protected void initTranscript() {
        try {
            this.transcriptFile = this.newTranscriptFile();
        }
        catch (IOException iOException) {
            this.transcriptFile = null;
            this.error(iOException);
        }
        if (this.transcriptFile != null) {
            try {
                this.logWriter = new PrintWriter(this.createBufferedWriter(this.transcriptFile.toPath(), this.getDefaultCharset()));
            }
            catch (IOException iOException) {
                this.logWriter = null;
                System.err.println(this.getMessage("error.cant.open.log", this.transcriptFile.toString()));
                this.error(iOException);
            }
            this.logMessage(this.getMessage("about.version", this.getApplicationName(), VERSION, DATE));
            if (this.isDebuggingOn()) {
                this.logMessage("Java " + System.getProperty("java.version"));
                this.logMessage(String.format("texparserlib.jar %s (%s)", "1.6.20251106", "2025-11-06"));
            }
        }
    }

    public void exit() {
        if (this.logWriter != null) {
            this.logWriter.close();
            this.message(this.getMessageWithFallback("message.log.file", "Transcript written to {0}.", this.transcriptFile));
            this.logWriter = null;
        }
        System.exit(this.exitCode);
    }

    public void logAndPrintMessageNoLn(String string) {
        this.logMessageNoLn(string);
        System.out.print(string);
    }

    public void logAndPrintMessage(String string) {
        this.logMessage(string);
        System.out.println(string);
    }

    public void logAndPrintMessage() {
        this.logMessage();
        System.out.println();
    }

    public void debug() {
        if (this.isDebuggingOn()) {
            System.out.println();
            this.logMessage();
        }
    }

    public void debug(String string) {
        if (this.isDebuggingOn()) {
            this.logAndPrintMessage(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.isDebuggingOn()) {
            throwable.printStackTrace();
        }
    }

    public void debugMessage(String string, Object ... objectArray) {
        if (this.isDebuggingOn()) {
            this.logAndPrintMessage(this.getMessage(string, objectArray));
        }
    }

    public void substituting(TeXParser teXParser, String string, String string2) {
        this.verboseMessage("warning.substituting", string, string2);
    }

    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.isDebuggingOn()) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    public String requestUserInput(String string) throws IOException {
        if (this.isDebuggingOn()) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.isDebuggingOn()) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.isDebuggingOn()) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void convertimage(int n, String[] stringArray, File file, String[] stringArray2, File file2) throws IOException, InterruptedException {
        if (this.isDebuggingOn()) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void progress(int n) {
    }

    public String getMessage(String string) {
        if (this.messages == null) {
            return string;
        }
        String string2 = string;
        try {
            string2 = this.messages.getMessage(string, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning(String.format("Error fetching message for label '%s': %s", string, illegalArgumentException.getMessage()), illegalArgumentException);
        }
        return string2;
    }

    public String getMessage(String string, String string2) {
        if (this.messages == null) {
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(String string, String[] stringArray) {
        if (this.messages == null) {
            String string2 = stringArray.length == 0 ? "" : stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "," + stringArray[0];
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return BibGlsTeXApp.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getMessageIfExists(String string) {
        if (this.messages == null) {
            return null;
        }
        String string2 = this.messages.getMessageIfExists(string, new Object[0]);
        if (string2 == null && this.isDebuggingOn()) {
            this.debug("No message for label '" + string + "'");
        }
        return string2;
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    public String getLocalisationText(String string, Locale locale, String string2, String string3) {
        if (locale != null) {
            String string4;
            String string5 = locale.toLanguageTag();
            String string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string5, string2));
            if (string6 != null) {
                return string6;
            }
            String string7 = locale.getCountry();
            String string8 = locale.getLanguage();
            if (!(string7 == null || string7.isEmpty() || string8 == null || string8.isEmpty() || (string4 = String.format("%s-%s", string8, string7)).equals(string5) || (string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string4, string2))) == null)) {
                return string6;
            }
            if (string8 != null && !string8.isEmpty() && !string8.equals(string5) && (string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string8, string2))) != null) {
                return string6;
            }
        }
        return string3;
    }

    public String getLocalisationText(String string, Locale locale, String string2) {
        String string3 = this.getLocalisationTextIfExists(string, locale, string2);
        if (string3 == null) {
            this.warning(String.format("Can't find message for label: %s.%s", string, string2));
            string3 = String.format("%s.%s", string, string2);
        }
        return string3;
    }

    public String getLocalisationTextIfExists(String string, Locale locale, String string2) {
        String string3;
        if (locale != null && (string3 = this.getLocalisationText(string, locale, string2, null)) != null) {
            return string3;
        }
        if (this.defaultLocale != null && !this.defaultLocale.equals(locale) && (string3 = this.getLocalisationText(string, this.defaultLocale, string2, null)) != null) {
            return string3;
        }
        if (!(this.docLocale == null || locale != null && locale.toLanguageTag().equals(this.docLocale) || (string3 = this.getMessageIfExists(String.format("%s.%s.%s", string, this.docLocale, string2))) == null)) {
            return string3;
        }
        return this.getMessageIfExists(String.format("%s.%s", string, string2));
    }

    public void message(String string) {
        if (!this.isSilent()) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    public void verboseMessage(String string, Object ... objectArray) {
        this.verbose(this.getMessage(string, objectArray));
    }

    public void verbose(String string) {
        if (this.isVerbose()) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verbose() {
        if (this.isVerbose()) {
            System.out.println();
        }
        this.logMessage();
    }

    public void verbose(TeXParser teXParser, String string) {
        if (this.isVerbose()) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n != -1 && file != null) {
                string = BibGlsTeXApp.fileLineMessage(file, n, string);
            }
            this.verbose(string);
        }
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale == null ? Locale.getDefault() : this.defaultLocale;
    }

    public Locale getDefaultLocale(Locale.Category category) {
        return this.defaultLocale == null ? Locale.getDefault(category) : this.defaultLocale;
    }

    public void warning(TeXParser teXParser, String string) {
        if (!this.isSilent()) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        if (!this.isSilent()) {
            this.warning(BibGlsTeXApp.fileLineMessage(file, n, string));
        }
    }

    public void warning(File file, int n, String string, Exception exception) {
        if (!this.isSilent()) {
            this.warning(BibGlsTeXApp.fileLineMessage(file, n, string), exception);
        }
    }

    public void warning(String string) {
        string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
        if (!this.isSilent()) {
            System.err.println(string);
        }
        this.logMessage(string);
    }

    public void warningMessage(String string, Object ... objectArray) {
        this.warning(this.getMessage(string, objectArray));
    }

    public void warning() {
        if (!this.isSilent()) {
            System.err.println();
        }
        this.logMessage();
    }

    public void warning(String string, Exception exception) {
        if (!this.isSilent()) {
            System.err.println(string);
        }
        this.logMessage(string);
        if (this.isDebuggingOn()) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
    }

    public void error(Exception exception) {
        if (exception instanceof TeXSyntaxException) {
            this.warning(((TeXSyntaxException)((Object)exception)).getMessage((TeXApp)this));
            if (this.isDebuggingOn()) {
                exception.printStackTrace();
                for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                    this.logMessage(stackTraceElement.toString());
                }
            }
        } else if (exception instanceof NoSuchFileException) {
            this.error(this.getMessage("tex.error.file.not.found", ((NoSuchFileException)exception).getFile()));
        } else {
            StackTraceElement[] stackTraceElementArray = exception.getMessage();
            if (stackTraceElementArray == null) {
                stackTraceElementArray = exception.getClass().getSimpleName();
            }
            this.error((String)stackTraceElementArray);
        }
        if (this.isDebuggingOn()) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
        this.logMessage(string);
    }

    public String getLanguageFileName(String string) {
        return String.format("/resources/bib2gls-%s.xml", string);
    }

    protected Locale initMessageLocale(Locale locale) {
        return Locale.forLanguageTag(this.langTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMessages() throws Bib2GlsException, IOException {
        Locale locale = null;
        locale = this.langTag == null || "".equals(this.langTag) ? (this.defaultLocale == null ? Locale.getDefault() : this.defaultLocale) : this.initMessageLocale(locale);
        URL uRL = this.getLanguageUrl("bib2gls", locale, "en");
        if (uRL == null) {
            throw new Bib2GlsException("Can't find language resource file.");
        }
        InputStream inputStream = null;
        try {
            this.debug("Reading " + uRL);
            inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            inputStream.close();
            inputStream = null;
            this.messages = new Bib2GlsMessages(properties);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
        }
    }

    protected String getLanguageFileName(String string, String string2) {
        return String.format("/resources/%s-%s.xml", string, string2);
    }

    protected URL getLanguageUrl(String string, Locale locale, String string2) {
        String string3 = locale.toLanguageTag();
        String string4 = this.getLanguageFileName(string, string3);
        URL uRL = ((Object)((Object)this)).getClass().getResource(string4);
        String string5 = null;
        if (this.isDebuggingOn()) {
            string5 = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            if (string5 != null) {
                this.debug(String.format("Can't find language resource: %s!%s", string5, string4));
            }
            string3 = locale.getLanguage();
            string4 = this.getLanguageFileName(string, string3);
            this.debug("Trying: " + string4);
            uRL = ((Object)((Object)this)).getClass().getResource(string4);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string5, string4));
                String string6 = locale.getScript();
                if (string6 != null && !string6.isEmpty()) {
                    string4 = this.getLanguageFileName(string, String.format("%s-%s", string3, string6));
                    this.debug("Trying: " + string4);
                    uRL = ((Object)((Object)this)).getClass().getResource(string4);
                    if (uRL == null && string2 != null && !string3.equals(string2)) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to '%s'", string5, string4, string2));
                        uRL = ((Object)((Object)this)).getClass().getResource(this.getLanguageFileName(string, string2));
                    }
                } else if (string2 != null && !string3.equals(string2)) {
                    if (this.isDebuggingOn()) {
                        this.debug(String.format("Defaulting to '%s'", string2));
                    }
                    uRL = ((Object)((Object)this)).getClass().getResource(this.getLanguageFileName(string, string2));
                }
            }
        }
        return uRL;
    }

    public void printSyntaxItem(String string) {
        String[] stringArray = string.split("\t", 2);
        if (stringArray.length == 2) {
            String string2 = stringArray[1].replaceAll(" *\\n", " ");
            int n = stringArray[0].length();
            int n2 = string2.length();
            System.out.print("  " + stringArray[0]);
            int n3 = 30 - n - 2;
            if (n3 <= 0) {
                n3 = 2;
            }
            int n4 = n + 2 + n3;
            int n5 = 78 - n4;
            for (int i = 0; i < n3; ++i) {
                System.out.print(' ');
            }
            if (n5 >= n2) {
                System.out.println(string2);
            } else {
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                breakIterator.setText(string2);
                int n6 = breakIterator.first();
                int n7 = 0;
                int n8 = 48;
                n3 = 30;
                int n9 = breakIterator.next();
                while (n9 != -1) {
                    int n10 = n9 - n6;
                    if ((n7 += n10) >= n5) {
                        System.out.println();
                        for (int i = 0; i < n3; ++i) {
                            System.out.print(' ');
                        }
                        n7 = n10;
                        n5 = n8;
                    }
                    System.out.print(string2.substring(n6, n9));
                    n6 = n9;
                    n9 = breakIterator.next();
                }
                System.out.println();
            }
        } else if (stringArray.length == 1) {
            String string3 = stringArray[0].replaceAll(" *\\n", " ");
            int n = string3.length();
            if (n <= 78) {
                System.out.println(string3);
            } else {
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                breakIterator.setText(string3);
                int n11 = breakIterator.first();
                int n12 = 0;
                int n13 = breakIterator.next();
                while (n13 != -1) {
                    int n14 = n13 - n11;
                    if ((n12 += n14) >= 78) {
                        System.out.println();
                        n12 = n14;
                    }
                    System.out.print(string3.substring(n11, n13));
                    n11 = n13;
                    n13 = breakIterator.next();
                }
                System.out.println();
            }
        }
    }

    public void version() {
        if (!this.shownVersion) {
            System.out.println(this.getMessageWithFallback("about.version", "{0} version {1} ({2})", this.getApplicationName(), VERSION, DATE));
            this.shownVersion = true;
        }
    }

    public void license() {
        System.out.println();
        System.out.format("Copyright %s Nicola Talbot%n", this.getCopyrightDate());
        System.out.println(this.getMessage("about.license"));
        System.out.println("https://github.com/nlct/bib2gls");
    }

    public void libraryVersion() {
        System.out.println();
        System.out.println(this.getMessageWithFallback("about.library.version", "Bundled with {0} version {1} ({2})", "texparserlib.jar", "1.6.20251106", "2025-11-06"));
        System.out.println("https://github.com/nlct/texparser");
        System.out.println();
        System.out.println(this.getMessageWithFallback("about.library.java_info", "Running on Java {0}", System.getProperty("java.version")));
    }

    public String getApplicationVersion() {
        return VERSION;
    }

    public abstract String getCopyrightStartYear();

    public String getCopyrightDate() {
        String string;
        String string2 = this.getCopyrightStartYear();
        if (string2.equals(string = DATE.substring(0, 4))) {
            return string;
        }
        return String.format("%s-%s", string2, string);
    }

    protected ArrayDeque<String> preparse(String[] stringArray) throws Bib2GlsSyntaxException {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(stringArray.length);
        this.verboseLevel = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            if (stringArray[i].equals("--locale") || stringArray[i].equals("-l")) {
                if (i == stringArray.length - 1) {
                    throw new Bib2GlsSyntaxException("Missing <lang tag> after " + stringArray[i]);
                }
                this.langTag = stringArray[++i];
                continue;
            }
            if (stringArray[i].startsWith("--locale=")) {
                stringArray2 = stringArray[i].split("=", 2);
                this.langTag = stringArray2[1];
                continue;
            }
            if (stringArray[i].startsWith("--debug=")) {
                stringArray2 = stringArray[i].split("=", 2);
                try {
                    this.debugLevel = Integer.parseInt(stringArray2[1]);
                    if (this.debugLevel > 0) {
                        this.verboseLevel = 2;
                        continue;
                    }
                    this.verboseLevel = 0;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Bib2GlsSyntaxException("Invalid debug level '" + stringArray2[1] + "'", numberFormatException);
                }
            }
            if (stringArray[i].equals("--debug")) {
                this.verboseLevel = 2;
                if (i + 1 >= stringArray.length) continue;
                try {
                    this.debugLevel = Integer.parseInt(stringArray[i + 1]);
                    ++i;
                    if (this.debugLevel != 0) continue;
                    this.verboseLevel = 0;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                this.debugLevel = 0;
                this.verboseLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--silent") || stringArray[i].equals("--quiet") || stringArray[i].equals("-q")) {
                this.debugLevel = 0;
                this.verboseLevel = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                this.verboseLevel = 1;
                continue;
            }
            if (stringArray[i].equals("--no-verbose") || stringArray[i].equals("--noverbose")) {
                this.verboseLevel = 0;
                continue;
            }
            arrayDeque.add(stringArray[i]);
            if (!stringArray[i].startsWith("-")) continue;
            if (stringArray[i].equals("--debug-mode")) {
                this.verboseLevel = 2;
            }
            if ((n = this.argCount((stringArray2 = stringArray[i].split("=", 2))[0])) == -1) {
                n = i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-") ? 1 : 0;
            }
            if (stringArray2.length == 2) {
                --n;
            }
            for (int j = 0; j < n; ++j) {
                if (++i >= stringArray.length) continue;
                arrayDeque.add(stringArray[i]);
            }
        }
        return arrayDeque;
    }

    protected int argCount(String string) {
        if (string.equals("--debug-mode") || string.equals("--default-encoding")) {
            return 1;
        }
        return 0;
    }

    protected boolean isArg(ArrayDeque<String> arrayDeque, String string, String string2, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, null, string2, bibGlsArgValueArray, BibGlsArgValueType.STRING);
    }

    protected boolean isArg(ArrayDeque<String> arrayDeque, String string, String string2, BibGlsArgValue[] bibGlsArgValueArray, BibGlsArgValueType bibGlsArgValueType) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, null, string2, bibGlsArgValueArray, bibGlsArgValueType);
    }

    protected boolean isArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, string2, string3, bibGlsArgValueArray, BibGlsArgValueType.STRING);
    }

    protected boolean isIntArg(ArrayDeque<String> arrayDeque, String string, String string2, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, null, string2, bibGlsArgValueArray, BibGlsArgValueType.INT);
    }

    protected boolean isIntArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, string2, string3, bibGlsArgValueArray, BibGlsArgValueType.INT);
    }

    protected boolean isListArg(ArrayDeque<String> arrayDeque, String string, String string2, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, null, string2, bibGlsArgValueArray, BibGlsArgValueType.LIST);
    }

    protected boolean isListArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, string2, string3, bibGlsArgValueArray, BibGlsArgValueType.LIST);
    }

    protected boolean isArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, BibGlsArgValue[] bibGlsArgValueArray, BibGlsArgValueType bibGlsArgValueType) throws Bib2GlsSyntaxException {
        return this.isArg(arrayDeque, string, string2, string3, null, bibGlsArgValueArray, bibGlsArgValueType);
    }

    protected boolean isArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, String string4, BibGlsArgValue[] bibGlsArgValueArray, BibGlsArgValueType bibGlsArgValueType) throws Bib2GlsSyntaxException {
        String string5;
        String[] stringArray = string.split("=", 2);
        String string6 = stringArray[0];
        int n = 0;
        if (string6.equals(string3) || string6.equals(string4)) {
            n = this.argCount(string6);
            bibGlsArgValueArray[0] = n == 0 ? null : (stringArray.length == 1 ? (n == -1 ? ((string5 = arrayDeque.peekFirst()) != null && !string5.startsWith("-") ? BibGlsArgValue.create(this, string6, arrayDeque.poll(), bibGlsArgValueType) : null) : BibGlsArgValue.create(this, string6, arrayDeque.poll(), bibGlsArgValueType)) : BibGlsArgValue.create(this, string6, stringArray[1], bibGlsArgValueType));
        } else if (string2 != null && string.equals(string2)) {
            string6 = string2;
            n = this.argCount(string2);
            bibGlsArgValueArray[0] = n == 0 ? null : (n == -1 ? ((string5 = arrayDeque.peekFirst()) != null && !string5.startsWith("-") ? BibGlsArgValue.create(this, string6, arrayDeque.poll(), bibGlsArgValueType) : null) : BibGlsArgValue.create(this, string6, arrayDeque.poll(), bibGlsArgValueType));
        } else {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            bibGlsArgValueArray[i] = BibGlsArgValue.create(this, string6, arrayDeque.poll(), bibGlsArgValueType);
        }
        this.argsFound = true;
        return true;
    }

    protected boolean isIntArg(ArrayDeque<String> arrayDeque, String string, String string2, BibGlsArgValue[] bibGlsArgValueArray, int n) throws Bib2GlsSyntaxException {
        return this.isIntArg(arrayDeque, string, null, string2, bibGlsArgValueArray, n);
    }

    protected boolean isIntArg(ArrayDeque<String> arrayDeque, String string, String string2, String string3, BibGlsArgValue[] bibGlsArgValueArray, int n) throws Bib2GlsSyntaxException {
        String[] stringArray = string.split("=", 2);
        if (stringArray[0].equals(string3)) {
            if (stringArray.length == 1) {
                String string4 = arrayDeque.peekFirst();
                if (string4 == null) {
                    bibGlsArgValueArray[0] = null;
                } else {
                    try {
                        int n2 = Integer.parseInt(string4);
                        bibGlsArgValueArray[0] = new BibGlsArgValue(arrayDeque.poll(), n2);
                        this.argsFound = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bibGlsArgValueArray[0] = null;
                    }
                }
            } else {
                this.argsFound = true;
                bibGlsArgValueArray[0] = BibGlsArgValue.create(this, stringArray[0], stringArray[1], BibGlsArgValueType.INT);
            }
        } else if (string2 != null && string.equals(string2)) {
            String string5 = arrayDeque.peekFirst();
            if (string5 == null) {
                bibGlsArgValueArray[0] = null;
            } else {
                try {
                    int n3 = Integer.parseInt(string5);
                    bibGlsArgValueArray[0] = new BibGlsArgValue(arrayDeque.poll(), n3);
                    this.argsFound = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bibGlsArgValueArray[0] = null;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected abstract void parseArg(ArrayDeque<String> var1, String var2) throws Bib2GlsSyntaxException;

    protected abstract boolean parseArg(ArrayDeque<String> var1, String var2, BibGlsArgValue[] var3) throws Bib2GlsSyntaxException;

    protected abstract void initSettings() throws Bib2GlsSyntaxException;

    protected abstract void postSettings() throws Bib2GlsSyntaxException, IOException;

    protected int maxArgParams() {
        return 1;
    }

    protected void help() {
        System.out.println(this.getMessage("syntax.usage", this.getApplicationName()));
        System.out.println();
        this.commonHelp();
        System.out.println();
        System.out.println(this.getMessage("syntax.furtherinfo"));
        System.out.println();
        this.furtherInfo();
        System.exit(0);
    }

    protected void commonHelp() {
        this.printSyntaxItem(this.getMessage("common.syntax.help", "--help", "-h"));
        this.printSyntaxItem(this.getMessage("common.syntax.version", "--version", "-v"));
        this.printSyntaxItem(this.getMessage("common.syntax.debug", "--[no-]debug"));
        this.printSyntaxItem(this.getMessage("common.syntax.debug-mode", "--debug-mode"));
        this.printSyntaxItem(this.getMessage("common.syntax.verbose", "--[no-]verbose"));
        this.printSyntaxItem(this.getMessage("common.syntax.silent", "--silent", "-q", "--quiet"));
    }

    protected void parseArgs(ArrayDeque<String> arrayDeque) throws Bib2GlsSyntaxException, IOException {
        String string;
        BibGlsArgValue[] bibGlsArgValueArray = new BibGlsArgValue[this.maxArgParams()];
        this.initSettings();
        while ((string = arrayDeque.poll()) != null) {
            if (string.equals("--help") || string.equals("-h")) {
                this.help();
                System.exit(0);
                continue;
            }
            if (string.equals("--version") || string.equals("-v")) {
                this.version();
                this.license();
                this.libraryVersion();
                System.exit(0);
                continue;
            }
            if (this.isListArg(arrayDeque, string, "--debug-mode", bibGlsArgValueArray)) {
                if (bibGlsArgValueArray[0] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                this.setDebugLevel(bibGlsArgValueArray[0].listValue());
                continue;
            }
            if (this.isArg(arrayDeque, string, "--default-encoding", bibGlsArgValueArray)) {
                if (bibGlsArgValueArray[0] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                try {
                    this.defaultCharset = Charset.forName(string);
                    continue;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", string), unsupportedCharsetException);
                }
            }
            if (string.startsWith("-")) {
                if (this.parseArg(arrayDeque, string, bibGlsArgValueArray)) continue;
                throw new Bib2GlsSyntaxException(this.getMessage("common.unknown.arg", string, "--help"));
            }
            this.parseArg(arrayDeque, string);
        }
        this.postSettings();
    }

    protected void furtherInfo() {
        System.out.println(this.getMessage("syntax.tutorial", "bib2gls", "texdoc bib2gls-begin"));
        System.out.println(this.getMessage("syntax.userguide", "bib2gls", "texdoc bib2gls"));
        System.out.println(this.getMessage("syntax.ctan", "bib2gls", "https://ctan.org/pkg/bib2gls"));
        System.out.println(this.getMessage("syntax.home", "bib2gls", "https://www.dickimaw-books.com/software/bib2gls/"));
        System.out.println(this.getMessage("syntax.faq", "bib2gls", "https://www.dickimaw-books.com/faq.php?category=bib2gls"));
    }
}

