#!/usr/bin/perl

package eBay::API::XML::DataType::AttributeRecommendationsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AttributeRecommendationsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AttributeRecommendationsType

=head1 DESCRIPTION

Item Specifics data returned from the Suggested Attributes engine.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AttributeRecommendationsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AttributeSetArrayType;


my @gaProperties = ( [ 'AttributeSetArray', 'ns:AttributeSetArrayType', ''
	     ,'eBay::API::XML::DataType::AttributeSetArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeSetArray()

A list of attribute sets containing recommended attributes and values. 
Returned from GetItemRecommendations when the Suggested Attributes engine is used 
See the eBay Web Services guide for additional details.

#    Argument: 'ns:AttributeSetArrayType'

=cut

sub setAttributeSetArray {
  my $self = shift;
  $self->{'AttributeSetArray'} = shift
}

=head2 getAttributeSetArray()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'ns:AttributeSetArrayType'

=cut

sub getAttributeSetArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AttributeSetArray'
		,'eBay::API::XML::DataType::AttributeSetArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
