/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorFromStructureData;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardPointFeatureIterator
extends PointIteratorFromStructureData {
    protected NestedTable ft;
    protected DateUnit timeUnit;
    protected Cursor cursor;

    StandardPointFeatureIterator(NestedTable ft, DateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) throws IOException {
        super(structIter, null);
        this.ft = ft;
        this.timeUnit = timeUnit;
        this.cursor = cursor;
    }

    protected PointFeature makeFeature(int recnum, StructureData sdata) throws IOException {
        this.cursor.recnum[0] = recnum;
        this.cursor.tableData[0] = sdata;
        this.cursor.currentIndex = 0;
        this.ft.addParentJoin(this.cursor);
        if (this.isMissing()) {
            return null;
        }
        double obsTime = this.ft.getObsTime(this.cursor);
        return new StandardPointFeature(this.cursor.copy(), this.timeUnit, obsTime);
    }

    protected boolean isMissing() throws IOException {
        if (this.ft.isTimeMissing(this.cursor)) {
            return true;
        }
        return this.ft.isMissing(this.cursor);
    }

    private class StandardPointFeature
    extends PointFeatureImpl
    implements StationPointFeature {
        protected Cursor cursor;

        public StandardPointFeature(Cursor cursor, DateUnit timeUnit, double obsTime) {
            super(timeUnit);
            this.cursor = cursor;
            this.obsTime = obsTime;
            this.nomTime = StandardPointFeatureIterator.this.ft.getNomTime(this.cursor);
            if (Double.isNaN(this.nomTime)) {
                this.nomTime = obsTime;
            }
            this.location = StandardPointFeatureIterator.this.ft.getEarthLocation(this.cursor);
        }

        public StructureData getData() {
            return StandardPointFeatureIterator.this.ft.makeObsStructureData(this.cursor);
        }

        public Station getStation() {
            return StandardPointFeatureIterator.this.ft.makeStation(this.cursor.getParentStructure());
        }
    }
}

