# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211819;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              00|
              2(?:
                1|
                395
              )
            )|
            9[56]
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0|
              23(?:
                [0-8]|
                9[0-46-9]
              )
            )|
            78123|
            [1-9]123
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            10(?:
              1(?:
                0|
                23
              )|
              9[56]
            )|
            2[0-57-9](?:
              1(?:
                00|
                23
              )|
              9[56]
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                1[124-9]|
                2[179]|
                [35][1-9]|
                6[47-9]|
                7\\d|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                078|
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[1-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                3\\d|
                4[13]|
                5[1-5]|
                7[0-79]|
                9[0-35-9]
              )
            )123
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0(?:
                [02-8]|
                1(?:
                  [013-9]|
                  2[0-24-9]
                )|
                9[0-47-9]
              )|
              [1-9]
            )|
            2(?:
              [0-57-9](?:
                [02-8]|
                1(?:
                  0[1-9]|
                  [13-9]|
                  2[0-24-9]
                )|
                9[0-47-9]
              )|
              6
            )|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              1[03]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              8[1-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              0(?:
                [0-689]|
                7[0-79]
              )|
              1[01459]|
              2[0-489]|
              [46]|
              50|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]|
              78|
              94
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                1[124-9]|
                2[179]|
                [35][1-9]|
                6[47-9]|
                7\\d|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                078|
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[1-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                3\\d|
                4[13]|
                5[1-5]|
                7[0-79]|
                9[0-35-9]
              )
            )(?:
              [02-9]|
              1(?:
                [013-9]|
                2[0-24-9]
              )
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0[02-8]|
              [1-9]
            )|
            2(?:
              [0-57-9][0-8]|
              6
            )|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              10|
              2[0-57-9]
            )9[0-47-9]|
            (?:
              101|
              58|
              85[23]10
            )[1-9]|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            2(?:
              [02-57-9]\\d{3}|
              1(?:
                [18](?:
                  0[1-9]|
                  [1-9]\\d
                )|
                [2-79]\\d\\d
              )
            )|
            (?:
              41[03]|
              8078|
              9(?:
                78|
                94
              )
            )\\d\\d
          )\\d{5}|
          (?:
            10|
            2[0-57-9]
          )(?:
            1(?:
              00|
              23
            )\\d\\d|
            95\\d{3,4}
          )|
          (?:
            41[03]|
            9(?:
              78|
              94
            )
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          8078123|
          (?:
            43[35]|
            754|
            851
          )\\d{7,8}|
          (?:
            43[35]|
            754|
            851
          )(?:
            1(?:
              00\\d|
              23
            )\\d|
            95\\d{3,4}
          )|
          (?:
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [13-9]\\d{6}|
              2(?:
                [0-24-9]\\d{5}|
                3\\d(?:
                  \\d{4}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[24-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              3\\d|
              4[13]|
              5[1-5]|
              7[0-79]|
              9[0-35-9]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [13-9]\\d{5}|
              2(?:
                [0-24-9]\\d{4}|
                3\\d(?:
                  \\d{3}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            2(?:
              [02-57-9]\\d{3}|
              1(?:
                [18](?:
                  0[1-9]|
                  [1-9]\\d
                )|
                [2-79]\\d\\d
              )
            )|
            (?:
              41[03]|
              8078|
              9(?:
                78|
                94
              )
            )\\d\\d
          )\\d{5}|
          (?:
            10|
            2[0-57-9]
          )(?:
            1(?:
              00|
              23
            )\\d\\d|
            95\\d{3,4}
          )|
          (?:
            41[03]|
            9(?:
              78|
              94
            )
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          8078123|
          (?:
            43[35]|
            754|
            851
          )\\d{7,8}|
          (?:
            43[35]|
            754|
            851
          )(?:
            1(?:
              00\\d|
              23
            )\\d|
            95\\d{3,4}
          )|
          (?:
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [13-9]\\d{6}|
              2(?:
                [0-24-9]\\d{5}|
                3\\d(?:
                  \\d{4}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[24-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              3\\d|
              4[13]|
              5[1-5]|
              7[0-79]|
              9[0-35-9]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [13-9]\\d{5}|
              2(?:
                [0-24-9]\\d{4}|
                3\\d(?:
                  \\d{3}
                )?
              )
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            [59][0-35-9]|
            6[25-7]|
            7[0-35-8]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          10(?:
            10\\d{4}|
            96\\d{3,4}
          )|
          400\\d{7}|
          950\\d{7,8}|
          (?:
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{zh} = {"861816950", "宁夏银川市",
"861509161", "陕西省汉中市",
"861325849", "四川省广安市",
"861370957", "宁夏银川市",
"861365859", "贵州省黔西南布依族苗族自治州",
"861324798", "江西省景德镇市",
"86147613", "江苏省连云港市",
"861504236", "辽宁省抚顺市",
"861575805", "云南省昭通市",
"861779106", "陕西省汉中市",
"861533491", "内蒙古呼伦贝尔市",
"86145021", "河北省石家庄市",
"861318469", "江西省吉安市",
"861788100", "新疆昌吉回族自治州",
"861829525", "宁夏中卫市",
"861815148", "江苏省无锡市",
"861814643", "新疆乌鲁木齐市",
"86170082", "四川省成都市",
"861780948", "甘肃省天水市",
"861868533", "贵州省毕节地区",
"861775983", "福建省莆田市",
"86150818", "河北省石家庄市",
"861586990", "湖南省怀化市",
"861853030", "河南省濮阳市",
"861800603", "福建省泉州市",
"861361326", "河北省廊坊市",
"8613439", "北京市",
"861850831", "四川省宜宾市",
"86176032", "河北省石家庄市",
"861778610", "湖北省武汉市",
"861304526", "黑龙江省大兴安岭地区",
"861341942", "四川省乐山市",
"86151811", "四川省宜宾市",
"861357618", "江西省宜春市",
"861705228", "广东省深圳市",
"861811470", "江苏省南京市",
"861582883", "四川省内江市",
"861325523", "江苏省南通市",
"861529365", "甘肃省甘南藏族自治州",
"861880732", "湖南省湘潭市",
"861320690", "黑龙江省绥化市",
"861314539", "山东省临沂市",
"861335150", "吉林省长春市",
"861337553", "山东省日照市",
"861514229", "辽宁省朝阳市",
"861331791", "江西省南昌市",
"861382486", "广东省茂名市",
"861328659", "广东省清远市",
"861560286", "广东省珠海市",
"861319120", "山西省忻州市",
"861510409", "辽宁省大连市",
"861311839", "四川省乐山市",
"861362330", "河北省石家庄市",
"861512057", "甘肃省天水市",
"861364471", "内蒙古呼和浩特市",
"861806843", "江苏省苏州市",
"861366785", "广西玉林市",
"861879406", "甘肃省临夏回族自治州",
"861821138", "广东省惠州市",
"861339336", "河北省廊坊市",
"861300164", "山东省威海市",
"861567070", "河南省洛阳市",
"86139258", "广东省东莞市",
"861770540", "山东省菏泽市",
"861576598", "黑龙江省大庆市",
"861367719", "湖北省十堰市",
"861337386", "浙江省温州市",
"861330703", "江西省上饶市",
"861760812", "四川省攀枝花市",
"861816900", "宁夏银川市",
"861313655", "浙江省台州市",
"861527272", "湖北省咸宁市",
"861521765", "广东省佛山市",
"861520669", "山东省淄博市",
"861471961", "甘肃省武威市",
"861890066", "江苏省南京市",
"861815999", "福建省泉州市",
"861898769", "云南省昆明市",
"861368911", "陕西省延安市",
"861823026", "河北省邯郸市",
"861331736", "湖南省常德市",
"861515283", "江苏省淮安市",
"861452545", "山东省青岛市",
"861857447", "湖南省张家界市",
"861700312", "河北省保定市",
"861305309", "安徽省合肥市",
"86189893", "浙江省宁波市",
"861570515", "江苏省连云港市",
"861801118", "四川省遂宁市",
"861321889", "江苏省南京市",
"861339391", "河南省周口市",
"86184898", "海南省海口市",
"861825098", "福建省南平市",
"86187869", "贵州省遵义市",
"861787629", "广东省湛江市",
"86155401", "内蒙古包头市",
"861530394", "河南省周口市",
"861880499", "内蒙古呼伦贝尔市",
"861591019", "山东省聊城市",
"861871894", "广东省梅州市",
"861562197", "内蒙古呼伦贝尔市",
"861524216", "辽宁省朝阳市",
"861550044", "吉林省四平市",
"861772859", "广东省肇庆市",
"861337503", "福建省漳州市",
"861533436", "云南省红河哈尼族彝族自治州",
"861335100", "黑龙江省哈尔滨市",
"861458780", "湖南省怀化市",
"86138673", "浙江省嘉兴市",
"861774929", "陕西省西安市",
"861332720", "湖南省岳阳市",
"861571046", "陕西省汉中市",
"861450508", "吉林省吉林市",
"861889438", "甘肃省平凉市",
"861859955", "福建省泉州市",
"861390425", "辽宁省丹东市",
"861328609", "河北省邢台市",
"861556963", "甘肃省定西市",
"861575141", "江苏省镇江市",
"861800077", "江西省赣州市",
"861822062", "陕西省榆林市",
"86138364", "黑龙江省绥化市",
"861388787", "云南省德宏傣族景颇族自治州",
"861323465", "黑龙江省哈尔滨市",
"86136757", "浙江省绍兴市",
"861347370", "河北省沧州市",
"861332974", "湖北省仙桃市",
"861538763", "四川省南充市",
"861576789", "广东省梅州市",
"861362983", "河南省安阳市",
"861833623", "河南省驻马店市",
"861369726", "湖北省荆州市",
"861879456", "甘肃省武威市",
"861369767", "山东省青岛市",
"861350872", "云南省大理白族自治州",
"861302736", "湖南省常德市",
"861522298", "安徽省阜阳市",
"861709770", "浙江省台州市",
"861809599", "新疆乌鲁木齐市",
"86152833", "四川省乐山市",
"861868562", "贵州省遵义市",
"861566218", "吉林省延边朝鲜族自治州",
"86182442", "四川省成都市",
"861707942", "河南省洛阳市",
"861589774", "湖北省孝感市",
"861858709", "云南省迪庆藏族自治州",
"861835990", "福建省福州市",
"861472878", "贵州省黔西南布依族苗族自治州",
"86182020", "广东省广州市",
"861847647", "广东省湛江市",
"86137474", "内蒙古乌兰察布市",
"861512897", "河北省保定市",
"861334906", "安徽省安庆市",
"861862515", "江苏省南京市",
"861800538", "山东省泰安市",
"86189671", "浙江省杭州市",
"861321564", "安徽省六安市",
"861800482", "内蒙古兴安盟",
"861339688", "浙江省丽水市",
"861345360", "山西省晋城市",
"861503420", "山西省大同市",
"861810412", "辽宁省鞍山市",
"861887563", "河北省承德市",
"861505464", "山东省临沂市",
"86180906", "四川省凉山彝族自治州",
"861301720", "湖南省岳阳市",
"861700182", "上海市",
"861328417", "辽宁省营口市",
"861845230", "江苏省淮安市",
"86138891", "辽宁省沈阳市",
"861813473", "河南省郑州市",
"861313461", "山西省朔州市",
"861475637", "河北省秦皇岛市",
"86153403", "重庆市",
"861538499", "新疆喀什地区",
"861301974", "黑龙江省鸡西市",
"861315109", "江苏省南京市",
"861596903", "云南省昭通市",
"861380771", "广西南宁市",
"861880763", "广东省清远市",
"861858278", "四川省甘孜藏族自治州",
"861579711", "湖北省十堰市",
"861312729", "山东省临沂市",
"861530450", "黑龙江省哈尔滨市",
"861513002", "河北省邯郸市",
"861778023", "四川省德阳市",
"861818011", "四川省攀枝花市",
"861373507", "浙江省衢州市",
"861518354", "四川省南充市",
"861310364", "河南省濮阳市",
"861518547", "贵州省黔南布依族苗族自治州",
"861308437", "四川省广元市",
"861532423", "河北省张家口市",
"86152561", "安徽省阜阳市",
"861773940", "河南省平顶山市",
"861378042", "河北省保定市",
"861334956", "黑龙江省鸡西市",
"86185687", "河南省南阳市",
"861309320", "湖北省荆门市",
"861507165", "湖北省随州市",
"861338460", "黑龙江省哈尔滨市",
"861819718", "青海省海东地区",
"861340421", "江苏省苏州市",
"861377288", "陕西省延安市",
"86182025", "天津市",
"86186024", "辽宁省沈阳市",
"86131641", "湖北省武汉市",
"861868658", "吉林省吉林市",
"86138447", "吉林省延边朝鲜族自治州",
"861819521", "宁夏银川市",
"861359195", "辽宁省葫芦岛市",
"86187504", "福建省泉州市",
"861850790", "江西省新余市",
"861590748", "湖南省永州市",
"861593318", "河北省衡水市",
"861394576", "黑龙江省鹤岗市",
"861571311", "河北省石家庄市",
"861565060", "安徽省滁州市",
"861318793", "云南省普洱市",
"861369820", "四川省攀枝花市",
"861831479", "湖北省十堰市",
"861581374", "广东省深圳市",
"861382495", "广东省阳江市",
"861556932", "新疆吐鲁番地区",
"861892670", "广东省茂名市",
"861538241", "浙江省宁波市",
"861510617", "江苏省无锡市",
"861864799", "内蒙古包头市",
"86147068", "广东省广州市",
"861363919", "贵州省六盘水市",
"86151838", "四川省德阳市",
"861598621", "广东省茂名市",
"861333862", "江苏省南京市",
"861478317", "河南省郑州市",
"861893761", "河南省信阳市",
"861538732", "湖南省湘潭市",
"861783548", "山西省长治市",
"861820721", "湖北省荆州市",
"861366796", "江西省吉安市",
"861500687", "山东省东营市",
"861337638", "山东省烟台市",
"861370441", "吉林省吉林市",
"861808146", "四川省巴中市",
"861352564", "河南省濮阳市",
"861334530", "新疆塔城地区",
"861595125", "江苏省连云港市",
"861530400", "辽宁省沈阳市",
"861831620", "广东省肇庆市",
"86156881", "河南省南阳市",
"86156650", "黑龙江省绥化市",
"861450633", "黑龙江省佳木斯市",
"861899965", "新疆和田地区",
"861594640", "黑龙江省七台河市",
"861857901", "江西省鹰潭市",
"861585297", "江苏省泰州市",
"861780321", "河北省石家庄市",
"861891240", "江苏省南通市",
"861551298", "河北省衡水市",
"861347418", "陕西省渭南市",
"861301764", "河南省洛阳市",
"861840575", "浙江省绍兴市",
"861820738", "湖南省娄底市",
"861786618", "甘肃省临夏回族自治州",
"861337621", "江苏省无锡市",
"861832049", "广东省湛江市",
"861365641", "山东省济南市",
"861397241", "湖北省恩施土家族苗族自治州",
"861347782", "湖北省荆州市",
"861351591", "福建省龙岩市",
"861351900", "甘肃省临夏回族自治州",
"861327475", "内蒙古通辽市",
"861505679", "安徽省阜阳市",
"861312353", "广西桂林市",
"861322536", "山东省潍坊市",
"861587759", "陕西省汉中市",
"86137135", "广东省深圳市",
"861354891", "湖南省岳阳市",
"861818936", "甘肃省张掖市",
"861780338", "河北省承德市",
"861776108", "四川省泸州市",
"861338548", "山东省泰安市",
"861707363", "河南省郑州市",
"861319475", "四川省自贡市",
"861516451", "黑龙江省佳木斯市",
"861534079", "山西省晋中市",
"861372697", "广东省清远市",
"861515240", "江苏省淮安市",
"861880973", "青海省黄南藏族自治州",
"861770356", "山西省晋城市",
"861380961", "广东省东莞市",
"861772919", "陕西省铜川市",
"861384792", "内蒙古锡林郭勒盟",
"86150674", "浙江省宁波市",
"861526661", "山东省潍坊市",
"861588590", "贵州省六盘水市",
"861336338", "河北省唐山市",
"861779733", "青海省黄南藏族自治州",
"861588901", "西藏拉萨市",
"861355813", "广西桂林市",
"861390532", "山东省青岛市",
"861825067", "福建省漳州市",
"861521230", "安徽省黄山市",
"861709960", "浙江省舟山市",
"861781432", "内蒙古锡林郭勒盟",
"861369977", "广东省深圳市",
"861810599", "福建省南平市",
"861390488", "黑龙江省佳木斯市",
"861308351", "江苏省无锡市",
"861315461", "四川省资阳市",
"861330618", "江苏省无锡市",
"861473637", "广西梧州市",
"861815473", "广西南宁市",
"861843230", "河北省邯郸市",
"861539194", "安徽省芜湖市",
"861760952", "宁夏石嘴山市",
"861809412", "福建省三明市",
"861301058", "广东省江门市",
"86180720", "浙江省温州市",
"861575915", "福建省南平市",
"861368851", "贵州省贵阳市",
"861580559", "安徽省黄山市",
"861885124", "江苏省宿迁市",
"861893280", "河北省衡水市",
"86150363", "河南省洛阳市",
"861530642", "山东省青岛市",
"861350553", "安徽省芜湖市",
"861511971", "广东省茂名市",
"861339946", "甘肃省兰州市",
"861328841", "广东省佛山市",
"861819482", "新疆乌鲁木齐市",
"86137970", "湖北省武汉市",
"861316062", "广东省潮州市",
"861519687", "四川省达州市",
"861558563", "吉林省松原市",
"86147961", "广西钦州市",
"861814680", "陕西省宝鸡市",
"86170827", "湖北省武汉市",
"861320923", "陕西省宝鸡市",
"861871978", "甘肃省兰州市",
"861560861", "湖北省荆州市",
"861762507", "江苏省扬州市",
"861501210", "云南省临沧市",
"861351950", "宁夏银川市",
"861352520", "河南省三门峡市",
"861771333", "黑龙江省牡丹江市",
"861802993", "广东省珠海市",
"86187304", "河北省承德市",
"861804610", "福建省福州市",
"861361681", "浙江省杭州市",
"861831664", "广东省汕头市",
"861860476", "内蒙古赤峰市",
"861502289", "新疆伊犁哈萨克自治州",
"861527687", "新疆塔城地区",
"86137130", "广东省东莞市",
"861377734", "浙江省绍兴市",
"861587709", "广西玉林市",
"861312303", "福建省泉州市",
"86183143", "云南省昆明市",
"861899775", "新疆喀什地区",
"861770306", "广东省珠海市",
"861536852", "云南省文山壮族苗族自治州",
"861379221", "山东省德州市",
"861332898", "福建省泉州市",
"86152361", "河南省洛阳市",
"861472663", "四川省凉山彝族自治州",
"861862735", "湖南省郴州市",
"861310320", "河北省邯郸市",
"861573095", "甘肃省平凉市",
"861876458", "山东省东营市",
"86145240", "辽宁省沈阳市",
"861308301", "安徽省蚌埠市",
"861338424", "辽宁省本溪市",
"861781799", "广东省茂名市",
"861309364", "安徽省芜湖市",
"861810788", "广西河池市",
"861351536", "山东省潍坊市",
"86136117", "上海市",
"86183886", "云南省文山壮族苗族自治州",
"86184658", "江西省南昌市",
"861587278", "湖北省咸宁市",
"861803348", "广东省东莞市",
"861324767", "广东省广州市",
"861770583", "浙江省嘉兴市",
"861322591", "福建省福州市",
"861818991", "西藏拉萨市",
"861813257", "河北省保定市",
"861365919", "陕西省西安市",
"861354836", "四川省泸州市",
"86180725", "浙江省台州市",
"861884870", "云南省文山壮族苗族自治州",
"861539022", "四川省泸州市",
"861370817", "四川省成都市",
"861760902", "新疆哈密地区",
"861301008", "北京市",
"861452484", "内蒙古乌兰察布市",
"861816810", "江苏省南京市",
"861537044", "江苏省无锡市",
"861848537", "贵州省黔南布依族苗族自治州",
"86137975", "湖北省荆州市",
"861863848", "河南省洛阳市",
"861370534", "山东省德州市",
"861800521", "江苏省徐州市",
"861806880", "江苏省南京市",
"861898587", "贵州省毕节地区",
"861565024", "山东省临沂市",
"861369864", "山东省济南市",
"861399782", "湖北省十堰市",
"861598395", "四川省巴中市",
"861312586", "吉林省白城市",
"861846504", "宁夏固原市",
"861771271", "江苏省宿迁市",
"861586623", "山东省枣庄市",
"861815019", "福建省宁德市",
"861531289", "江苏省盐城市",
"861373934", "甘肃省庆阳市",
"861350395", "河南省漯河市",
"86180243", "广东省东莞市",
"86156895", "山东省德州市",
"861457020", "江西省南昌市",
"861551267", "河北省衡水市",
"861479371", "甘肃省临夏回族自治州",
"861303359", "江苏省镇江市",
"861577535", "四川省遂宁市",
"861324726", "湖北省十堰市",
"861763502", "山西省忻州市",
"861535491", "内蒙古包头市",
"861377225", "陕西省延安市",
"861337872", "云南省大理白族自治州",
"861319164", "河北省保定市",
"861318101", "山东省滨州市",
"861304598", "福建省三明市",
"861315605", "山东省青岛市",
"861344065", "安徽省安庆市",
"861323849", "内蒙古锡林郭勒盟",
"861894419", "江苏省无锡市",
"861532210", "广东省江门市",
"861573805", "河南省南阳市",
"861361398", "河南省三门峡市",
"86131457", "广东省广州市",
"861889421", "甘肃省天水市",
"86138651", "安徽省安庆市",
"861363859", "贵州省黔西南布依族苗族自治州",
"861831993", "广东省肇庆市",
"861558170", "山西省忻州市",
"861360492", "辽宁省沈阳市",
"861536124", "广东省揭阳市",
"861571639", "河南省周口市",
"861570735", "湖南省郴州市",
"861330329", "河北省石家庄市",
"861332008", "江西省景德镇市",
"86145928", "重庆市",
"861840206", "广东省湛江市",
"861354051", "四川省攀枝花市",
"861312595", "黑龙江省绥化市",
"861598386", "四川省达州市",
"861830951", "宁夏银川市",
"86155499", "湖北省十堰市",
"861472994", "陕西省延安市",
"861891283", "江苏省镇江市",
"861812252", "广东省河源市",
"861333150", "吉林省吉林市",
"861453818", "四川省南充市",
"861458261", "安徽省马鞍山市",
"861390563", "安徽省宣城市",
"861318674", "浙江省丽水市",
"861890571", "浙江省杭州市",
"861819603", "新疆克拉玛依市",
"861334816", "江苏省常州市",
"861566445", "山东省泰安市",
"861812040", "湖北省武汉市",
"86156890", "山东省淄博市",
"861353953", "广东省汕尾市",
"861329471", "内蒙古呼和浩特市",
"861595470", "山东省济宁市",
"86134271", "广东省江门市",
"861391960", "甘肃省庆阳市",
"861705231", "四川省成都市",
"861857811", "广东省湛江市",
"861339625", "山东省聊城市",
"861561063", "山东省潍坊市",
"861839835", "四川省攀枝花市",
"861367539", "山东省临沂市",
"861303309", "安徽省合肥市",
"861821121", "广东省潮州市",
"86185522", "江苏省连云港市",
"861317471", "浙江省嘉兴市",
"861354730", "四川省巴中市",
"861558488", "吉林省白城市",
"861538973", "内蒙古乌海市",
"861825026", "福建省泉州市",
"861595629", "安徽省宣城市",
"861813999", "甘肃省兰州市",
"861318151", "山东省烟台市",
"861880512", "江苏省连云港市",
"861564365", "吉林省白城市",
"861316033", "江苏省宿迁市",
"861304789", "广西贵港市",
"861363809", "贵州省黔东南苗族侗族自治州",
"861509459", "黑龙江省伊春市",
"861535249", "甘肃省张掖市",
"861771362", "四川省成都市",
"861806786", "浙江省绍兴市",
"861332058", "云南省玉溪市",
"861360739", "湖南省邵阳市",
"861521975", "广东省茂名市",
"861361635", "山东省聊城市",
"861318845", "辽宁省辽阳市",
"861770468", "福建省厦门市",
"861335833", "福建省漳州市",
"861835623", "安徽省芜湖市",
"861556342", "山东省莱芜市",
"861867643", "广东省中山市",
"861830901", "新疆塔城地区",
"861302153", "山东省潍坊市",
"861882917", "陕西省宝鸡市",
"86138564", "安徽省六安市",
"86186649", "广东省深圳市",
"861535436", "河北省秦皇岛市",
"861507669", "河北省沧州市",
"861812202", "广东省广州市",
"861369798", "江西省景德镇市",
"861512868", "河北省廊坊市",
"861768047", "湖南省岳阳市",
"861705373", "安徽省合肥市",
"861350638", "山东省济宁市",
"861520474", "内蒙古乌兰察布市",
"861864525", "黑龙江省牡丹江市",
"861304715", "湖北省宜昌市",
"861334059", "福建省龙岩市",
"861816463", "云南省普洱市",
"861566229", "吉林省延边朝鲜族自治州",
"861850959", "宁夏固原市",
"861508233", "四川省眉山市",
"861317033", "湖南省衡阳市",
"861305659", "四川省雅安市",
"861557773", "广西柳州市",
"86155214", "广东省广州市",
"861314785", "辽宁省大连市",
"861587010", "贵州省遵义市",
"861803995", "河南省许昌市",
"86189591", "福建省福州市",
"861811045", "安徽省芜湖市",
"861350321", "河北省石家庄市",
"861809791", "新疆克孜勒苏柯尔克孜自治州",
"861476283", "江苏省镇江市",
"861889495", "河北省沧州市",
"861398912", "四川省泸州市",
"861532814", "四川省攀枝花市",
"861829716", "青海省玉树藏族自治州",
"861329033", "山东省济南市",
"861313305", "山西省长治市",
"861525671", "安徽省淮南市",
"861365931", "甘肃省兰州市",
"861458287", "福建省莆田市",
"861860803", "四川省成都市",
"861772996", "安徽省宣城市",
"861535425", "河北省唐山市",
"861308523", "湖北省鄂州市",
"861835709", "浙江省衢州市",
"861858990", "广西崇左市",
"861366539", "山东省临沂市",
"861339636", "山东省潍坊市",
"861572093", "江西省上饶市",
"861478409", "河南省濮阳市",
"861312521", "江西省南昌市",
"861568871", "山东省威海市",
"86150394", "河南省周口市",
"86151109", "青海省西宁市",
"861506669", "山东省济南市",
"861530932", "甘肃省定西市",
"861839826", "四川省雅安市",
"861473665", "云南省昭通市",
"861800586", "浙江省台州市",
"861550573", "浙江省嘉兴市",
"861328359", "山西省运城市",
"861301266", "山东省枣庄市",
"86152518", "江苏省南京市",
"861595703", "浙江省衢州市",
"861522970", "陕西省咸阳市",
"861362630", "山东省威海市",
"861529947", "新疆乌鲁木齐市",
"861556400", "山东省菏泽市",
"861387208", "湖北省黄石市",
"861824940", "黑龙江省双鸭山市",
"861459800", "湖北省襄樊市",
"861864950", "山西省忻州市",
"861569957", "吉林省长春市",
"861308849", "内蒙古巴彦淖尔市",
"861825035", "福建省龙岩市",
"861312718", "山东省潍坊市",
"861398160", "四川省雅安市",
"861815856", "浙江省宁波市",
"86186749", "湖南省岳阳市",
"861529665", "山西省长治市",
"861376225", "湖南省株洲市",
"861339691", "浙江省台州市",
"861336872", "云南省大理白族自治州",
"861850909", "新疆博尔塔拉蒙古自治州",
"861334009", "江西省宜春市",
"861383587", "山西省运城市",
"86187839", "四川省南充市",
"86151513", "江苏省南通市",
"861800353", "山西省阳泉市",
"861700612", "江苏省南京市",
"861867110", "湖北省鄂州市",
"861570726", "湖北省恩施土家族苗族自治州",
"86187312", "河北省保定市",
"86138751", "湖南省常德市",
"861533563", "内蒙古乌海市",
"861894485", "江苏省宿迁市",
"861840917", "陕西省宝鸡市",
"861593329", "河北省沧州市",
"861815085", "福建省宁德市",
"861337686", "浙江省台州市",
"861355460", "湖北省荆州市",
"861860853", "贵州省安顺市",
"861311901", "新疆塔城地区",
"86185386", "河南省周口市",
"861477179", "湖北省十堰市",
"861311590", "福建省福州市",
"86157977", "江西省南昌市",
"861867962", "江西省九江市",
"861369515", "广东省佛山市",
"86138071", "湖北省武汉市",
"861478459", "黑龙江省大庆市",
"861781716", "广东省惠州市",
"861389857", "辽宁省铁岭市",
"861328309", "河南省驻马店市",
"861555241", "山东省东营市",
"86152114", "湖南省衡阳市",
"861569907", "新疆阿克苏地区",
"861809736", "青海省玉树藏族自治州",
"861347429", "陕西省西安市",
"861315072", "云南省怒江傈僳族自治州",
"861862767", "湖南省衡阳市",
"861537124", "江苏省盐城市",
"861302599", "广西北海市",
"861593045", "河北省唐山市",
"861539142", "云南省曲靖市",
"861565144", "江苏省扬州市",
"861530694", "福建省南平市",
"861319083", "内蒙古鄂尔多斯市",
"861893569", "青海省海南藏族自治州",
"861534766", "广东省梅州市",
"861820529", "江苏省镇江市",
"861534727", "湖北省十堰市",
"861351525", "江苏省常州市",
"861865972", "福建省泉州市",
"861777158", "湖北省潜江市",
"86151455", "黑龙江省绥化市",
"861329062", "河北省保定市",
"861560238", "广东省广州市",
"861563879", "河南省许昌市",
"861352955", "云南省保山市",
"861890969", "安徽省合肥市",
"861363341", "山西省太原市",
"861537852", "四川省凉山彝族自治州",
"861337695", "福建省莆田市",
"861879502", "宁夏石嘴山市",
"861517401", "辽宁省本溪市",
"861776783", "吉林省延边朝鲜族自治州",
"861339388", "河南省焦作市",
"861323351", "山西省太原市",
"861839974", "新疆克孜勒苏柯尔克孜自治州",
"861317062", "云南省昆明市",
"861569299", "四川省广元市",
"861816588", "广东省云浮市",
"861887249", "湖北省荆州市",
"861315487", "内蒙古呼和浩特市",
"86184078", "江西省上饶市",
"861459706", "宁夏固原市",
"861508262", "四川省宜宾市",
"861816432", "安徽省宿州市",
"861865106", "江苏省宿迁市",
"86188459", "黑龙江省大庆市",
"861813028", "安徽省宣城市",
"861572853", "广东省深圳市",
"861529401", "甘肃省张掖市",
"861808808", "云南省丽江市",
"861593136", "河北省衡水市",
"861300040", "广东省广州市",
"86151185", "广东省东莞市",
"861894496", "湖南省永州市",
"86152863", "贵州省黔东南苗族侗族自治州",
"861305417", "湖南省长沙市",
"861575038", "云南省文山壮族苗族自治州",
"861360528", "江苏省镇江市",
"861354825", "四川省德阳市",
"861303841", "陕西省渭南市",
"861320404", "辽宁省沈阳市",
"861331599", "河北省石家庄市",
"861450980", "新疆塔城地区",
"86189380", "广东省深圳市",
"861324224", "广东省中山市",
"861470354", "山西省晋中市",
"86156583", "浙江省宁波市",
"861705219", "江苏省苏州市",
"861357629", "江西省南昌市",
"861533170", "云南省德宏傣族景颇族自治州",
"861847504", "广东省云浮市",
"861587623", "广东省河源市",
"861314242", "内蒙古包头市",
"861535712", "安徽省滁州市",
"861810153", "江苏省无锡市",
"86189753", "湖南省株洲市",
"861367728", "湖北省武汉市",
"861829810", "安徽省淮北市",
"861877458", "湖南省怀化市",
"861530963", "安徽省芜湖市",
"861570767", "广东省云浮市",
"861836896", "甘肃省白银市",
"861774026", "四川省德阳市",
"861569714", "湖北省武汉市",
"86150533", "山东省淄博市",
"861380987", "广东省中山市",
"861357470", "湖南省益阳市",
"861501814", "广东省阳江市",
"861309479", "浙江省台州市",
"861571611", "江苏省常州市",
"86151450", "黑龙江省哈尔滨市",
"86158887", "浙江省温州市",
"861840754", "广东省汕头市",
"861777108", "湖北省黄石市",
"8613916", "上海市",
"861314050", "河南省漯河市",
"861311447", "湖北省襄樊市",
"861772985", "四川省宜宾市",
"861338953", "宁夏吴忠市",
"861868427", "吉林省四平市",
"861459090", "广东省韶关市",
"861511884", "广东省深圳市",
"861537802", "甘肃省临夏回族自治州",
"861813916", "新疆和田地区",
"861865156", "江苏省无锡市",
"861324781", "江西省南昌市",
"861787618", "广东省梅州市",
"861552517", "山西省长治市",
"861504837", "内蒙古赤峰市",
"861514584", "黑龙江省鹤岗市",
"861309620", "四川省宜宾市",
"861859889", "湖南省岳阳市",
"861782889", "四川省达州市",
"861470547", "山东省济宁市",
"861825146", "江苏省扬州市",
"861801129", "四川省成都市",
"861533532", "山东省青岛市",
"861310664", "广东省湛江市",
"861398573", "贵州省安顺市",
"861533488", "内蒙古巴彦淖尔市",
"861553973", "河南省洛阳市",
"861839867", "四川省成都市",
"86151180", "广东省深圳市",
"861326475", "湖北省随州市",
"861314796", "辽宁省铁岭市",
"86152531", "山东省济南市",
"861450271", "内蒙古呼和浩特市",
"861811136", "四川省广元市",
"861518604", "贵州省铜仁地区",
"86189385", "广东省东莞市",
"861360444", "吉林省长春市",
"861320454", "黑龙江省佳木斯市",
"861815031", "福建省龙岩市",
"861560887", "云南省迪庆藏族自治州",
"861331788", "广西柳州市",
"861780621", "山东省日照市",
"861831320", "云南省文山壮族苗族自治州",
"861707878", "云南省丽江市",
"861570820", "四川省德阳市",
"861516637", "山东省济宁市",
"861470304", "河北省唐山市",
"861313593", "湖北省黄石市",
"861804143", "辽宁省本溪市",
"861550912", "陕西省榆林市",
"861361667", "浙江省台州市",
"86151868", "贵州省黔东南苗族侗族自治州",
"861598321", "四川省资阳市",
"86138593", "福建省南平市",
"86150774", "广西梧州市",
"861800595", "福建省泉州市",
"861337338", "河北省衡水市",
"861778180", "四川省内江市",
"861571198", "广东省深圳市",
"861593191", "河北省唐山市",
"861477747", "广西钦州市",
"861332266", "广东省梅州市",
"861768127", "安徽省安庆市",
"861321955", "四川省内江市",
"861510317", "河北省沧州市",
"861361945", "云南省保山市",
"861774918", "陕西省渭南市",
"86147038", "四川省成都市",
"861875293", "江苏省镇江市",
"86150861", "贵州省黔南布依族苗族自治州",
"861826538", "山东省泰安市",
"861358100", "山东省淄博市",
"861595136", "江苏省宿迁市",
"861393400", "山西省忻州市",
"861305841", "广东省广州市",
"861324260", "广东省肇庆市",
"861477844", "广东省佛山市",
"861897579", "湖南省永州市",
"861770656", "浙江省绍兴市",
"861529169", "陕西省西安市",
"861458672", "湖南省娄底市",
"861372397", "山东省烟台市",
"861303417", "甘肃省平凉市",
"861313487", "内蒙古鄂尔多斯市",
"861815028", "福建省莆田市",
"86130748", "福建省厦门市",
"861780638", "山东省泰安市",
"861513844", "河南省南阳市",
"861365341", "山西省太原市",
"861331412", "辽宁省鞍山市",
"861453543", "江苏省泰州市",
"86132941", "湖北省武汉市",
"861837959", "江西省萍乡市",
"861360596", "福建省三明市",
"861894357", "吉林省通化市",
"86185787", "广东省广州市",
"861530773", "广西桂林市",
"861590862", "湖北省武汉市",
"861570977", "青海省玉树藏族自治州",
"861376288", "湖南省邵阳市",
"861560784", "广西贺州市",
"861598338", "四川省乐山市",
"861863972", "河南省许昌市",
"861844522", "黑龙江省齐齐哈尔市",
"86159229", "重庆市",
"861531448", "山东省烟台市",
"861337321", "河北省石家庄市",
"861813096", "新疆阿克苏地区",
"861522866", "四川省遂宁市",
"861369781", "山东省临沂市",
"861367050", "广东省汕头市",
"861855509", "安徽省黄山市",
"861532904", "贵州省黔南布依族苗族自治州",
"861454746", "浙江省台州市",
"861845834", "浙江省杭州市",
"861333748", "湖北省荆门市",
"861327040", "江苏省连云港市",
"861871842", "广东省肇庆市",
"86156750", "湖南省岳阳市",
"86150333", "河北省唐山市",
"861396512", "安徽省合肥市",
"861530342", "山西省大同市",
"861597953", "江西省宜春市",
"861572572", "山东省淄博市",
"861890779", "广西北海市",
"861860913", "陕西省渭南市",
"861856901", "湖南省株洲市",
"861476052", "宁夏石嘴山市",
"861330318", "河北省衡水市",
"861306923", "吉林省延边朝鲜族自治州",
"861459162", "广西崇左市",
"861596548", "山东省泰安市",
"861368939", "甘肃省陇南市",
"86156383", "河南省驻马店市",
"861319040", "辽宁省锦州市",
"86136876", "山东省青岛市",
"861529337", "甘肃省陇南市",
"861322463", "黑龙江省牡丹江市",
"861453829", "四川省阿坝藏族羌族自治州",
"861308651", "四川省广元市",
"861783953", "河南省南阳市",
"861840857", "贵州省毕节地区",
"861528420", "河北省邯郸市",
"861591700", "广东省佛山市",
"861367796", "江西省吉安市",
"861332835", "福建省漳州市",
"861363985", "河南省周口市",
"86189580", "浙江省杭州市",
"861569817", "山东省烟台市",
"861770606", "福建省泉州市",
"86189771", "广西南宁市",
"86183822", "四川省成都市",
"861862589", "河南省三门峡市",
"861340495", "云南省大理白族自治州",
"861319252", "广东省汕尾市",
"861570864", "贵州省黔南布依族苗族自治州",
"861559982", "新疆昌吉回族自治州",
"861350686", "浙江省台州市",
"861815916", "福建省泉州市",
"861454292", "辽宁省大连市",
"86156075", "海南省海口市",
"861558249", "山西省朔州市",
"861569534", "青海省海南藏族自治州",
"861388243", "四川省雅安市",
"861314511", "江苏省苏州市",
"861311811", "四川省德阳市",
"861837909", "江西省宜春市",
"861890258", "广东省江门市",
"861314728", "湖北省十堰市",
"861814380", "西藏拉萨市",
"861341994", "河南省南阳市",
"861476240", "江苏省连云港市",
"861308174", "辽宁省阜新市",
"861301881", "浙江省舟山市",
"861521737", "广东省东莞市",
"861359121", "辽宁省鞍山市",
"861776846", "江苏省淮安市",
"86137888", "福建省泉州市",
"861531524", "山东省潍坊市",
"861880416", "辽宁省锦州市",
"861598695", "广东省惠州市",
"861323437", "吉林省辽源市",
"861855559", "安徽省黄山市",
"861532954", "贵州省黔南布依族苗族自治州",
"861586323", "山东省枣庄市",
"861820795", "江西省宜春市",
"861894544", "黑龙江省佳木斯市",
"86138393", "河南省濮阳市",
"861334217", "辽宁省丹东市",
"861310479", "广东省东莞市",
"861476002", "福建省厦门市",
"86189051", "江苏省南京市",
"861302725", "江西省九江市",
"861378804", "广西梧州市",
"861309664", "山西省临汾市",
"861850819", "四川省成都市",
"861315593", "江西省上饶市",
"861803648", "江苏省常州市",
"861471579", "广东省深圳市",
"861360531", "山东省济南市",
"861317190", "河北省保定市",
"861866680", "广东省茂名市",
"861376837", "广西南宁市",
"86189585", "浙江省台州市",
"861875882", "浙江省宁波市",
"861534824", "四川省达州市",
"861591750", "广东省清远市",
"861772341", "四川省巴中市",
"861824983", "黑龙江省佳木斯市",
"861570589", "浙江省金华市",
"861524907", "陕西省宝鸡市",
"861355548", "黑龙江省大兴安岭地区",
"861705007", "上海市",
"861829900", "新疆喀什地区",
"861876666", "山东省枣庄市",
"861361698", "福建省南平市",
"861381547", "江苏省镇江市",
"861814962", "福建省漳州市",
"861533425", "湖北省十堰市",
"86158022", "天津市",
"861878443", "四川省眉山市",
"86187275", "湖北省孝感市",
"861780503", "江苏省连云港市",
"861590833", "四川省广安市",
"86158440", "吉林省长春市",
"861862864", "陕西省汉中市",
"861332881", "福建省漳州市",
"861786629", "湖北省宜昌市",
"861315305", "山东省枣庄市",
"861579492", "福建省福州市",
"861393394", "河北省廊坊市",
"861772928", "陕西省榆林市",
"861324515", "内蒙古兴安盟",
"861303659", "四川省乐山市",
"861389754", "青海省海南藏族自治州",
"861707632", "山东省济宁市",
"86189391", "河南省焦作市",
"861340486", "内蒙古赤峰市",
"861390436", "吉林省白城市",
"861550852", "贵州省遵义市",
"861802364", "广东省肇庆市",
"861384847", "内蒙古鄂尔多斯市",
"861351799", "江西省萍乡市",
"86139479", "内蒙古锡林郭勒盟",
"861509187", "陕西省汉中市",
"861383493", "山西省晋城市",
"861322432", "吉林省吉林市",
"861589276", "四川省南充市",
"861553499", "山西省晋中市",
"861883044", "河北省承德市",
"861318374", "四川省雅安市",
"861813856", "广东省汕尾市",
"861760430", "吉林省长春市",
"861500455", "黑龙江省绥化市",
"861538416", "浙江省绍兴市",
"861580751", "广东省韶关市",
"861576715", "广东省肇庆市",
"86177121", "江苏省徐州市",
"861330470", "内蒙古呼伦贝尔市",
"86138138", "江苏省南京市",
"861390249", "广东省广州市",
"861890147", "江苏省南通市",
"86152318", "河北省邯郸市",
"861820786", "广西百色市",
"861598686", "广东省汕头市",
"861828089", "四川省遂宁市",
"86150594", "福建省福州市",
"861336503", "福建省宁德市",
"861778143", "四川省凉山彝族自治州",
"861810791", "江西省南昌市",
"861479104", "陕西省榆林市",
"861571339", "河北省邢台市",
"861768702", "云南省大理白族自治州",
"861331725", "湖北省黄冈市",
"861338813", "四川省德阳市",
"861330629", "江苏省南通市",
"861554527", "黑龙江省鸡西市",
"861459133", "广西玉林市",
"861830839", "四川省广元市",
"86138773", "广西桂林市",
"861859520", "山东省济宁市",
"861771662", "贵州省黔南布依族苗族自治州",
"861373392", "河南省平顶山市",
"861776740", "新疆乌鲁木齐市",
"86189509", "福建省三明市",
"861564947", "河南省平顶山市",
"861587990", "江西省鹰潭市",
"861599494", "广东省汕头市",
"861570798", "江西省景德镇市",
"861829950", "新疆昌吉回族自治州",
"861354888", "湖南省常德市",
"861705057", "浙江省杭州市",
"861360585", "浙江省绍兴市",
"86138978", "辽宁省锦州市",
"861457183", "浙江省温州市",
"861312538", "江西省赣州市",
"861315355", "山东省东营市",
"861391453", "江苏省泰州市",
"86158445", "吉林省通化市",
"861780553", "安徽省芜湖市",
"86187270", "湖北省襄樊市",
"861832946", "陕西省汉中市",
"861774808", "四川省成都市",
"861534976", "青海省海东地区",
"861771508", "江苏省宿迁市",
"861389704", "青海省海南藏族自治州",
"861579739", "湖北省武汉市",
"86147713", "广东省广州市",
"861308465", "浙江省金华市",
"861537160", "江苏省徐州市",
"861339325", "河北省唐山市",
"86181449", "广东省佛山市",
"861818039", "四川省广元市",
"861810736", "湖南省常德市",
"861886532", "山东省青岛市",
"861310013", "山西省晋中市",
"861351588", "浙江省宁波市",
"86151313", "河北省邢台市",
"861862977", "吉林省白山市",
"861886488", "山东省聊城市",
"861351432", "吉林省吉林市",
"861860572", "浙江省湖州市",
"861705673", "山东省青岛市",
"86150198", "广东省江门市",
"861829536", "宁夏吴忠市",
"861364033", "广东省广州市",
"861864716", "内蒙古赤峰市",
"861899937", "新疆伊犁哈萨克自治州",
"861322799", "陕西省榆林市",
"861350338", "河北省保定市",
"861367785", "广西玉林市",
"861800729", "湖北省孝感市",
"861471987", "新疆乌鲁木齐市",
"861595045", "江苏省南京市",
"86151191", "广东省中山市",
"861580701", "江西省鹰潭市",
"861572913", "河南省鹤壁市",
"861808026", "四川省绵阳市",
"861867343", "湖南省株洲市",
"86184514", "江苏省宿迁市",
"861304535", "黑龙江省鸡西市",
"861337948", "陕西省宝鸡市",
"861339049", "辽宁省辽阳市",
"86138534", "山东省德州市",
"861361335", "河北省秦皇岛市",
"861390491", "辽宁省朝阳市",
"86176400", "辽宁省沈阳市",
"861768752", "广西柳州市",
"861551760", "河南省信阳市",
"861556642", "辽宁省鞍山市",
"861336553", "安徽省芜湖市",
"861315160", "江苏省扬州市",
"861805975", "福建省莆田市",
"861380412", "辽宁省鞍山市",
"861393374", "河北省邢台市",
"861898856", "广东省中山市",
"861871981", "甘肃省兰州市",
"861707867", "云南省楚雄彝族自治州",
"861354322", "广东省梅州市",
"861362248", "广东省河源市",
"86139477", "内蒙古鄂尔多斯市",
"861351779", "广西北海市",
"861350675", "浙江省绍兴市",
"861552089", "四川省南充市",
"861361678", "浙江省宁波市",
"861521938", "广东省揭阳市",
"861329563", "安徽省宣城市",
"861597161", "湖北省荆州市",
"86155543", "山东省滨州市",
"861378074", "山东省聊城市",
"861782034", "广东省梅州市",
"861879003", "河南省焦作市",
"861773722", "河南省漯河市",
"861867439", "湖南省长沙市",
"861555664", "安徽省淮北市",
"861338459", "黑龙江省大庆市",
"861837277", "湖北省鄂州市",
"861515948", "福建省南平市",
"861858760", "广西防城港市",
"861534931", "甘肃省兰州市",
"861553620", "山西省晋中市",
"861309973", "青海省黄南藏族自治州",
"861850682", "浙江省杭州市",
"861808904", "西藏林芝地区",
"861810771", "广西南宁市",
"861318394", "四川省资阳市",
"861565059", "山东省济南市",
"861827256", "河南省安阳市",
"861867246", "湖北省荆门市",
"861589296", "四川省达州市",
"861345309", "山西省朔州市",
"861769628", "山西省临汾市",
"861508625", "贵州省毕节地区",
"86181891", "陕西省西安市",
"861383473", "山西省运城市",
"861803765", "河南省周口市",
"861355317", "山东省济南市",
"861330490", "辽宁省铁岭市",
"86180898", "海南省海口市",
"861346390", "河北省邢台市",
"861839878", "四川省广元市",
"861771288", "江苏省南京市",
"86136659", "福建省泉州市",
"861342830", "广东省汕头市",
"861898806", "云南省昆明市",
"861534996", "新疆阿勒泰地区",
"86177084", "湖南省长沙市",
"86188641", "河南省开封市",
"861343723", "湖北省荆州市",
"861774814", "四川省绵阳市",
"86133011", "北京市",
"86181447", "广东省佛山市",
"861350844", "湖南省娄底市",
"861571443", "吉林省延边朝鲜族自治州",
"86151244", "吉林省吉林市",
"861589231", "四川省资阳市",
"861550487", "内蒙古鄂尔多斯市",
"861570778", "广西河池市",
"861373372", "河南省许昌市",
"861876549", "山东省临沂市",
"86189507", "福建省莆田市",
"86135481", "四川省成都市",
"861389718", "青海省西宁市",
"8613521", "北京市",
"861589742", "湖南省怀化市",
"861867792", "广西南宁市",
"861576065", "四川省达州市",
"861356171", "山东省莱芜市",
"861530469", "黑龙江省大庆市",
"861880364", "河南省信阳市",
"86135668", "浙江省台州市",
"861338409", "河南省焦作市",
"861370313", "河北省张家口市",
"861359379", "湖北省荆门市",
"861479636", "江西省鹰潭市",
"861869489", "浙江省金华市",
"861872640", "安徽省阜阳市",
"86156266", "广东省清远市",
"861333947", "黑龙江省大庆市",
"861570209", "广东省湛江市",
"861363102", "广东省潮州市",
"861808954", "四川省广元市",
"861562434", "山东省德州市",
"861890463", "黑龙江省哈尔滨市",
"861380234", "广东省湛江市",
"861390471", "内蒙古呼和浩特市",
"861351258", "江苏省盐城市",
"861885159", "江苏省宿迁市",
"861565009", "山东省泰安市",
"861580524", "江苏省宿迁市",
"861827206", "湖北省襄樊市",
"861860592", "福建省厦门市",
"861363976", "青海省西宁市",
"861566090", "河南省商丘市",
"86159813", "吉林省延边朝鲜族自治州",
"861454361", "山东省济南市",
"861313092", "辽宁省盘锦市",
"861812495", "广东省东莞市",
"861775157", "江苏省盐城市",
"861360576", "浙江省台州市",
"861772860", "广东省惠州市",
"861364712", "湖北省孝感市",
"86135013", "北京市",
"861329532", "山东省青岛市",
"861329488", "内蒙古巴彦淖尔市",
"861590637", "山东省枣庄市",
"86159227", "重庆市",
"86137621", "湖南省湘西土家族苗族自治州",
"861575602", "安徽省铜陵市",
"86178638", "山东省泰安市",
"861570997", "新疆阿克苏地区",
"861517222", "湖北省孝感市",
"861530793", "江西省上饶市",
"861863992", "河南省鹤壁市",
"861379340", "山东省日照市",
"861308022", "内蒙古包头市",
"861519244", "山东省济宁市",
"86185789", "广西南宁市",
"861330547", "山东省济宁市",
"861538364", "山西省晋中市",
"861509424", "云南省保山市",
"861596317", "山东省聊城市",
"861539301", "甘肃省临夏回族自治州",
"86180502", "福建省福州市",
"861534985", "安徽省巢湖市",
"86189424", "广东省佛山市",
"861351147", "浙江省台州市",
"861529222", "湖南省株洲市",
"86183462", "黑龙江省哈尔滨市",
"861567254", "湖北省宜昌市",
"86182678", "浙江省温州市",
"861587235", "湖北省武汉市",
"861585112", "江苏省盐城市",
"861852420", "辽宁省大连市",
"86153122", "江苏省无锡市",
"861560640", "山东省济南市",
"861532918", "贵州省六盘水市",
"861537593", "福建省宁德市",
"861786547", "山东省济宁市",
"861471788", "山西省长治市",
"861557845", "广西崇左市",
"861898750", "云南省保山市",
"861774078", "西藏拉萨市",
"861330304", "河北省石家庄市",
"861881839", "广东省广州市",
"861870434", "吉林省四平市",
"861380725", "湖北省黄冈市",
"86136952", "广东省佛山市",
"861300421", "浙江省嘉兴市",
"861899738", "青海省西宁市",
"861812486", "广东省茂名市",
"861346404", "辽宁省沈阳市",
"8618792", "陕西省西安市",
"861332942", "黑龙江省齐齐哈尔市",
"861367776", "广西百色市",
"86139643", "山东省淄博市",
"861572592", "山东省济宁市",
"861310241", "河北省沧州市",
"861773415", "河北省沧州市",
"861871935", "广东省梅州市",
"86189706", "江西省吉安市",
"861550072", "青海省黄南藏族自治州",
"861396664", "安徽省安庆市",
"861381470", "江苏省南通市",
"86133038", "河南省郑州市",
"861310732", "湖南省湘潭市",
"861524064", "广西玉林市",
"861337747", "广西百色市",
"861528699", "河南省安阳市",
"86134648", "辽宁省阜新市",
"861890799", "江西省萍乡市",
"861822436", "四川省广安市",
"861526840", "浙江省宁波市",
"861508946", "广东省梅州市",
"86136801", "广东省中山市",
"861335169", "黑龙江省大庆市",
"861835267", "江苏省南通市",
"861775107", "江苏省宿迁市",
"861313852", "广东省肇庆市",
"861819575", "青海省玉树藏族自治州",
"861478903", "西藏山南地区",
"861805230", "江苏省连云港市",
"86156728", "湖北省荆门市",
"86159568", "安徽省阜阳市",
"861779944", "新疆巴音郭楞蒙古自治州",
"861341974", "河南省驻马店市",
"861555993", "云南省保山市",
"86186346", "山西省忻州市",
"861320782", "广西柳州市",
"861539351", "甘肃省武威市",
"861522623", "宁夏吴忠市",
"861328660", "广东省江门市",
"861595604", "安徽省六安市",
"861567204", "湖北省恩施土家族苗族自治州",
"861898031", "四川省南充市",
"861533062", "吉林省松原市",
"861767326", "湖南省衡阳市",
"861309512", "新疆伊犁哈萨克自治州",
"861317170", "河北省沧州市",
"861471599", "广东省湛江市",
"861842013", "广东省深圳市",
"861898700", "云南省昭通市",
"861315573", "江西省九江市",
"861371740", "广东省东莞市",
"861879893", "西藏山南地区",
"861589285", "四川省德阳市",
"861761294", "陕西省宝鸡市",
"861318450", "江西省景德镇市",
"861314966", "黑龙江省佳木斯市",
"861816969", "广西桂林市",
"861322147", "浙江省温州市",
"86817", "四川省南充市",
"861362157", "江苏省苏州市",
"861850453", "黑龙江省牡丹江市",
"861768545", "山东省青岛市",
"861319582", "甘肃省定西市",
"861509548", "甘肃省定西市",
"861365860", "山东省济南市",
"861330354", "山西省晋中市",
"8618376", "广西南宁市",
"861840538", "山东省泰安市",
"861820775", "广西玉林市",
"861378818", "广西河池市",
"861840482", "内蒙古乌兰察布市",
"861524279", "辽宁省盘锦市",
"861826068", "江苏省扬州市",
"861890432", "吉林省吉林市",
"861890588", "浙江省丽水市",
"861310499", "广东省茂名市",
"861557674", "湖南省衡阳市",
"861327438", "吉林省松原市",
"861840718", "湖北省恩施土家族苗族自治州",
"861319421", "辽宁省朝阳市",
"86188457", "黑龙江省哈尔滨市",
"861573568", "山西省晋城市",
"861367966", "四川省眉山市",
"861501858", "广东省湛江市",
"861569279", "贵州省黔西南布依族苗族自治州",
"861572419", "广东省韶关市",
"861760389", "河南省濮阳市",
"861528041", "福建省福州市",
"86180302", "福建省厦门市",
"86136899", "新疆昌吉回族自治州",
"861550355", "山西省长治市",
"86180658", "福建省三明市",
"861563899", "河南省南阳市",
"861700889", "广东省深圳市",
"861561427", "河北省邢台市",
"861309732", "江西省赣州市",
"861860607", "福建省福州市",
"861327421", "辽宁省朝阳市",
"861396620", "安徽省宣城市",
"86137216", "河南省洛阳市",
"861865992", "福建省泉州市",
"861811171", "四川省巴中市",
"861705774", "江西省南昌市",
"861592446", "内蒙古赤峰市",
"861787654", "广东省梅州市",
"861818884", "广东省广州市",
"861524020", "江苏省泰州市",
"861878611", "贵州省贵阳市",
"861336240", "浙江省舟山市",
"861808814", "云南省昆明市",
"861571480", "内蒙古呼伦贝尔市",
"86188187", "广东省佛山市",
"861309241", "江苏省无锡市",
"861335451", "黑龙江省哈尔滨市",
"861337675", "广东省潮州市",
"86135495", "湖南省郴州市",
"861320418", "辽宁省阜新市",
"861534341", "山西省太原市",
"861391959", "甘肃省庆阳市",
"86150421", "辽宁省朝阳市",
"861511925", "广东省河源市",
"86180161", "四川省德阳市",
"86189920", "陕西省咸阳市",
"861554091", "内蒙古巴彦淖尔市",
"86183005", "山东省烟台市",
"861336002", "广东省广州市",
"861450236", "河北省沧州市",
"861363727", "安徽省六安市",
"861872683", "安徽省黄山市",
"861560452", "黑龙江省齐齐哈尔市",
"861334879", "湖南省邵阳市",
"861847518", "广东省阳江市",
"861775415", "安徽省蚌埠市",
"86151428", "辽宁省葫芦岛市",
"861538320", "河北省邯郸市",
"861509460", "黑龙江省大兴安岭地区",
"861379113", "山东省济南市",
"861581932", "广东省肇庆市",
"861536461", "山西省太原市",
"861898028", "四川省凉山彝族自治州",
"861533190", "黑龙江省大庆市",
"86135282", "广东省中山市",
"861510424", "辽宁省朝阳市",
"861518136", "四川省广元市",
"861834430", "广东省广州市",
"861870541", "山东省济南市",
"861332363", "河南省濮阳市",
"861569708", "云南省楚雄彝族自治州",
"861539437", "浙江省金华市",
"861337844", "广东省广州市",
"86152423", "辽宁省抚顺市",
"861821464", "云南省昆明市",
"861300438", "江苏省常州市",
"861501808", "广东省惠州市",
"861362415", "辽宁省丹东市",
"861339822", "四川省遂宁市",
"861848929", "西藏那曲地区",
"861535062", "河北省保定市",
"86132182", "江苏省南通市",
"861816779", "新疆博尔塔拉蒙古自治州",
"861537487", "内蒙古包头市",
"86182163", "湖南省岳阳市",
"861510548", "山东省泰安市",
"861777114", "湖北省襄樊市",
"861314776", "吉林省吉林市",
"86186546", "山东省东营市",
"861326495", "湖北省荆门市",
"861383999", "河南省开封市",
"861886033", "河南省周口市",
"861569064", "河南省洛阳市",
"861550305", "河北省承德市",
"861398593", "贵州省六盘水市",
"861807775", "广西钦州市",
"861504662", "黑龙江省绥化市",
"861787604", "广东省湛江市",
"86184720", "湖北省武汉市",
"86158889", "浙江省金华市",
"861820647", "山东省潍坊市",
"861860657", "浙江省金华市",
"861309499", "江苏省镇江市",
"861477321", "湖南省湘潭市",
"861518191", "四川省遂宁市",
"861459070", "广东省潮州市",
"861305324", "安徽省宣城市",
"86132452", "江苏省南京市",
"861315852", "四川省南充市",
"861893925", "河南省郑州市",
"861820965", "宁夏中卫市",
"86135711", "陕西省延安市",
"86189925", "陕西省安康市",
"861303360", "浙江省杭州市",
"861800575", "浙江省绍兴市",
"861352312", "河南省周口市",
"861317712", "湖北省恩施土家族苗族自治州",
"86135490", "西藏拉萨市",
"861517748", "广西玉林市",
"861318642", "江苏省南京市",
"861873407", "安徽省阜阳市",
"861470318", "河北省衡水市",
"861333337", "河北省石家庄市",
"861336052", "广东省深圳市",
"861360061", "浙江省宁波市",
"86181564", "安徽省六安市",
"861329712", "湖北省荆门市",
"861898916", "四川省达州市",
"861364532", "山东省青岛市",
"86133171", "湖北省武汉市",
"861364488", "内蒙古呼和浩特市",
"861877414", "湖南省岳阳市",
"861569758", "广东省肇庆市",
"861708755", "江西省南昌市",
"861313573", "湖北省随州市",
"861813561", "河南省驻马店市",
"861301332", "云南省昆明市",
"861302987", "黑龙江省哈尔滨市",
"861816208", "山东省潍坊市",
"861888845", "广西玉林市",
"861811654", "四川省攀枝花市",
"861774904", "陕西省西安市",
"861357547", "浙江省杭州市",
"861810961", "安徽省淮北市",
"86155343", "山西省吕梁市",
"861505616", "安徽省淮北市",
"861858724", "云南省昆明市",
"861530151", "江苏省无锡市",
"861378958", "内蒙古巴彦淖尔市",
"861809771", "新疆博尔塔拉蒙古自治州",
"861309763", "山西省晋中市",
"861597409", "湖南省永州市",
"861523325", "河北省唐山市",
"861882353", "广东省揭阳市",
"861515686", "安徽省安庆市",
"861526883", "浙江省杭州市",
"861572657", "山东省烟台市",
"861316491", "浙江省温州市",
"861824489", "湖南省常德市",
"861326486", "湖北省孝感市",
"86183089", "海南省海口市",
"86177730", "湖南省岳阳市",
"861508391", "江西省赣州市",
"861315124", "江苏省徐州市",
"861320370", "河南省郑州市",
"861537072", "江苏省泰州市",
"861389538", "宁夏银川市",
"86130271", "湖北省武汉市",
"861890525", "江苏省扬州市",
"86135738", "山东省青岛市",
"86182814", "四川省绵阳市",
"86186747", "湖南省衡阳市",
"861554145", "辽宁省铁岭市",
"861872402", "江苏省南京市",
"86131278", "上海市",
"86186815", "广东省深圳市",
"861379556", "四川省自贡市",
"86158800", "福建省福州市",
"861893646", "江苏省扬州市",
"861313912", "青海省海东地区",
"861550593", "福建省宁德市",
"861479049", "安徽省安庆市",
"861365152", "江苏省扬州市",
"861458557", "山东省日照市",
"861387214", "湖北省黄石市",
"86151107", "山西省大同市",
"861572073", "江苏省南通市",
"861522990", "陕西省咸阳市",
"861522501", "河南省平顶山市",
"861394739", "内蒙古锡林郭勒盟",
"861476553", "浙江省杭州市",
"861589228", "四川省广元市",
"861860419", "辽宁省辽阳市",
"861368433", "四川省广元市",
"861378908", "湖南省株洲市",
"861379383", "山东省泰安市",
"861454687", "广东省东莞市",
"861891948", "甘肃省天水市",
"86132273", "湖北省黄冈市",
"861317425", "湖南省怀化市",
"861882303", "广东省梅州市",
"861342103", "广东省梅州市",
"861458344", "江西省抚州市",
"861814246", "陕西省汉中市",
"86187837", "四川省阿坝藏族羌族自治州",
"86135933", "山西省晋城市",
"861535033", "江西省吉安市",
"861572607", "山东省潍坊市",
"861568836", "新疆喀什地区",
"861580560", "安徽省合肥市",
"861532858", "四川省广元市",
"861339671", "浙江省杭州市",
"861387432", "湖南省益阳市",
"861505138", "江苏省淮安市",
"861700564", "浙江省温州市",
"861879745", "湖南省湘西土家族苗族自治州",
"861816147", "四川省成都市",
"861329425", "湖北省襄樊市",
"861322969", "广东省汕尾市",
"861370140", "江苏省南京市",
"861801233", "江苏省扬州市",
"861525636", "安徽省亳州市",
"86185926", "陕西省西安市",
"861302579", "广东省珠海市",
"861829066", "新疆昌吉回族自治州",
"861364563", "安徽省宣城市",
"86184243", "辽宁省营口市",
"861864571", "黑龙江省大兴安岭地区",
"861780892", "西藏日喀则地区",
"86177735", "湖南省郴州市",
"86189248", "广东省佛山市",
"86133918", "北京市",
"86186810", "广东省东莞市",
"86158805", "福建省漳州市",
"861379506", "辽宁省盘锦市",
"861584702", "内蒙古呼伦贝尔市",
"861373055", "河北省邢台市",
"861530674", "浙江省宁波市",
"861872452", "黑龙江省齐齐哈尔市",
"861560683", "浙江省嘉兴市",
"861321182", "云南省楚雄彝族自治州",
"861388991", "广东省深圳市",
"861377980", "新疆阿克苏地区",
"861808078", "四川省攀枝花市",
"861506546", "山东省东营市",
"861380788", "广西南宁市",
"861583382", "河北省衡水市",
"861858281", "四川省达州市",
"861707764", "云南省昆明市",
"861458507", "河南省南阳市",
"861311570", "浙江省衢州市",
"86183261", "安徽省合肥市",
"86157979", "江西省南昌市",
"861477199", "湖北省荆门市",
"86854", "贵州省黔南布依族苗族自治州",
"861518329", "四川省内江市",
"861470629", "江苏省南通市",
"861340120", "江苏省泰州市",
"861570968", "宁夏银川市",
"861587760", "陕西省宝鸡市",
"861476503", "北京市",
"861773248", "河北省沧州市",
"861335665", "山东省济南市",
"861880320", "河北省邯郸市",
"861470703", "江西省上饶市",
"86182598", "福建省三明市",
"861304578", "浙江省金华市",
"861503316", "河北省廊坊市",
"861572496", "浙江省杭州市",
"861535471", "吉林省延边朝鲜族自治州",
"861894853", "广东省阳江市",
"861306245", "福建省龙岩市",
"861337892", "湖南省怀化市",
"861331961", "湖南省怀化市",
"861528121", "四川省攀枝花市",
"86180314", "河北省承德市",
"861361378", "河南省开封市",
"86131459", "广东省深圳市",
"861500746", "湖南省永州市",
"861508049", "福建省福州市",
"861354622", "山西省晋中市",
"861854832", "内蒙古巴彦淖尔市",
"861350375", "河南省平顶山市",
"86131189", "海南省海口市",
"861514706", "内蒙古呼伦贝尔市",
"861860485", "内蒙古通辽市",
"861524140", "辽宁省本溪市",
"861301878", "广东省梅州市",
"861899786", "新疆阿克苏地区",
"861596459", "山东省潍坊市",
"861869157", "陕西省西安市",
"861507546", "河北省廊坊市",
"861810987", "辽宁省盘锦市",
"86185294", "广东省广州市",
"861529833", "江苏省宿迁市",
"861332014", "江西省景德镇市",
"861513503", "山西省忻州市",
"861840353", "山西省阳泉市",
"8617700", "北京市",
"861890900", "四川省自贡市",
"861318694", "浙江省台州市",
"86145388", "云南省昆明市",
"861531559", "山东省济南市",
"861890591", "福建省福州市",
"861769328", "甘肃省天水市",
"861539465", "江苏省连云港市",
"861855524", "安徽省宣城市",
"861532929", "贵州省黔西南布依族苗族自治州",
"861314069", "河南省驻马店市",
"861475100", "江苏省苏州市",
"861800917", "陕西省宝鸡市",
"861380153", "江苏省无锡市",
"86134206", "广东省佛山市",
"861329436", "吉林省白城市",
"861360472", "内蒙古包头市",
"861534859", "贵州省黔西南布依族苗族自治州",
"86177635", "山东省聊城市",
"861558190", "山西省忻州市",
"861898148", "四川省达州市",
"861845015", "福建省莆田市",
"861568825", "湖南省娄底市",
"861312575", "吉林省通化市",
"861705276", "广东省珠海市",
"861894803", "广东省汕尾市",
"86155841", "吉林省长春市",
"86133613", "山东省烟台市",
"861813979", "甘肃省酒泉市",
"861538993", "新疆克孜勒苏柯尔克孜自治州",
"861779012", "四川省德阳市",
"861840586", "浙江省台州市",
"861385700", "浙江省衢州市",
"86145950", "宁夏银川市",
"861880664", "广东省深圳市",
"861514090", "辽宁省阜新市",
"861890536", "山东省潍坊市",
"861327486", "内蒙古包头市",
"861820937", "甘肃省酒泉市",
"861595490", "山东省济南市",
"861855448", "山东省德州市",
"861356547", "新疆伊犁哈萨克自治州",
"861329491", "云南省昭通市",
"861865944", "福建省龙岩市",
"861514756", "内蒙古通辽市",
"861823078", "贵州省毕节地区",
"861858267", "四川省绵阳市",
"861309416", "湖北省宜昌市",
"861596409", "山东省临沂市",
"86186252", "江苏省苏州市",
"861378543", "河北省保定市",
"861348849", "陕西省咸阳市",
"861376271", "湖南省益阳市",
"861827097", "江西省赣州市",
"861839942", "新疆伊犁哈萨克自治州",
"861319486", "四川省成都市",
"861572431", "辽宁省辽阳市",
"861454661", "广东省广州市",
"86157392", "新疆阿克苏地区",
"86150286", "河北省沧州市",
"861397013", "江西省赣州市",
"861356304", "山东省聊城市",
"861531509", "山东省临沂市",
"861840303", "河北省张家口市",
"86181593", "福建省泉州市",
"861534809", "甘肃省陇南市",
"861471791", "山西省临汾市",
"861521995", "广东省中山市",
"861536072", "广东省湛江市",
"861898999", "西藏拉萨市",
"86186647", "广东省广州市",
"861878639", "贵州省黔南布依族苗族自治州",
"861830570", "浙江省衢州市",
"861453854", "甘肃省定西市",
"861378829", "广西钦州市",
"861370613", "江苏省苏州市",
"86183432", "吉林省吉林市",
"86137023", "广东省中山市",
"861454455", "江西省宜春市",
"861880993", "新疆石河子市",
"861771236", "江苏省无锡市",
"86159134", "广东省中山市",
"861458392", "福建省三明市",
"861554349", "吉林省长春市",
"861319495", "四川省凉山彝族自治州",
"861478460", "黑龙江省哈尔滨市",
"861534099", "山西省运城市",
"861361410", "辽宁省铁岭市",
"86135611", "山东省枣庄市",
"861388646", "湖北省黄石市",
"861808210", "江苏省镇江市",
"861362489", "内蒙古兴安盟",
"861817779", "广西钦州市",
"861536487", "山西省临汾市",
"861705505", "福建省福州市",
"861893550", "青海省海北藏族自治州",
"861776114", "四川省巴中市",
"861800068", "河北省邢台市",
"861774423", "四川省成都市",
"861351571", "浙江省杭州市",
"861510953", "宁夏吴忠市",
"861556469", "山东省枣庄市",
"86136503", "广东省东莞市",
"861806775", "浙江省丽水市",
"861818280", "黑龙江省哈尔滨市",
"861886471", "河南省安阳市",
"861771449", "江苏省镇江市",
"861315044", "新疆喀什地区",
"861800754", "广东省汕头市",
"86180953", "宁夏吴忠市",
"861860431", "吉林省长春市",
"861521986", "广东省潮州市",
"861815493", "新疆乌鲁木齐市",
"861511991", "广东省云浮市",
"86182802", "四川省成都市",
"861503041", "河北省邯郸市",
"861772220", "广东省广州市",
"861338317", "河北省沧州市",
"861381329", "江苏省徐州市",
"861363079", "吉林省白山市",
"861551323", "山西省忻州市",
"86157772", "广西柳州市",
"861529862", "江苏省连云港市",
"861471830", "广东省揭阳市",
"86153186", "山东省烟台市",
"861819807", "甘肃省酒泉市",
"861355459", "湖北省荆州市",
"86187036", "河南省郑州市",
"861810579", "浙江省金华市",
"861452166", "河北省衡水市",
"861369997", "新疆乌鲁木齐市",
"861560340", "山西省太原市",
"861881951", "广东省东莞市",
"861769619", "山西省大同市",
"861520350", "山西省忻州市",
"861565906", "福建省泉州市",
"861454405", "福建省宁德市",
"861328360", "山西省忻州市",
"861876741", "浙江省台州市",
"861860496", "辽宁省锦州市",
"861365220", "广东省中山市",
"861453094", "山西省阳泉市",
"861700815", "江苏省南通市",
"861588132", "四川省自贡市",
"86186473", "内蒙古乌海市",
"861343155", "广东省珠海市",
"861337240", "浙江省杭州市",
"861876232", "江苏省扬州市",
"861332878", "福建省厦门市",
"861572485", "江苏省苏州市",
"861871998", "新疆和田地区",
"86159538", "山东省泰安市",
"861760315", "河北省唐山市",
"861893500", "山西省忻州市",
"861515621", "安徽省合肥市",
"861705555", "河南省郑州市",
"861366966", "广西柳州市",
"86181751", "湖南省长沙市",
"86170829", "陕西省西安市",
"861477395", "湖南省常德市",
"861518125", "四川省攀枝花市",
"861373821", "浙江省湖州市",
"861389729", "青海省海西蒙古族藏族自治州",
"861303624", "江西省上饶市",
"861302961", "新疆石河子市",
"861770253", "江苏省淮安市",
"861567133", "湖北省襄樊市",
"861370020", "陕西省咸阳市",
"861510903", "新疆和田地区",
"861816027", "新疆巴音郭楞蒙古自治州",
"861589897", "山东省威海市",
"861889083", "新疆巴音郭楞蒙古自治州",
"861867847", "山东省临沂市",
"861884890", "河南省平顶山市",
"86159974", "湖北省武汉市",
"861800704", "江西省抚州市",
"861305660", "四川省眉山市",
"861537461", "内蒙古呼伦贝尔市",
"861304037", "吉林省通化市",
"861822563", "安徽省宣城市",
"861334060", "四川省雅安市",
"861598375", "四川省南充市",
"861771291", "江苏省南京市",
"86131100", "天津市",
"861335637", "山东省枣庄市",
"861828230", "四川省自贡市",
"861514850", "内蒙古锡林郭勒盟",
"861325194", "浙江省嘉兴市",
"861837876", "广西南宁市",
"861853173", "河北省唐山市",
"861503186", "河北省唐山市",
"861301014", "河北省衡水市",
"86136119", "上海市",
"861869248", "湖南省娄底市",
"861311084", "福建省三明市",
"861340040", "河北省邯郸市",
"861881590", "福建省南平市",
"861846518", "宁夏银川市",
"861780675", "广东省湛江市",
"861781779", "广东省广州市",
"861343841", "四川省达州市",
"861376362", "黑龙江省牡丹江市",
"861829258", "陕西省商洛市",
"861556101", "内蒙古呼和浩特市",
"861770477", "内蒙古鄂尔多斯市",
"861568237", "四川省资阳市",
"861814847", "四川省泸州市",
"861337375", "河南省新乡市",
"86136303", "吉林省松原市",
"861398461", "贵州省六盘水市",
"861399404", "山西省临汾市",
"861453914", "广东省清远市",
"861370708", "江西省南昌市",
"861767335", "湖南省常德市",
"861521648", "山东省青岛市",
"861389586", "黑龙江省双鸭山市",
"861835724", "浙江省嘉兴市",
"861809579", "青海省海西蒙古族藏族自治州",
"861378580", "河北省沧州市",
"861345105", "湖北省黄石市",
"861567850", "广西玉林市",
"861550655", "山东省菏泽市",
"861350892", "山东省聊城市",
"861322066", "山东省临沂市",
"861384962", "河南省驻马店市",
"861890810", "四川省德阳市",
"861707835", "云南省大理白族自治州",
"861811547", "江苏省南京市",
"86156628", "吉林省辽源市",
"861857132", "湖北省恩施土家族苗族自治州",
"861867744", "广西梧州市",
"861472898", "西藏拉萨市",
"861835970", "福建省厦门市",
"861776922", "湖南省怀化市",
"861589794", "湖北省黄冈市",
"861503699", "河南省洛阳市",
"861869722", "青海省海东地区",
"86181773", "广西桂林市",
"861832671", "安徽省铜陵市",
"861858298", "四川省广元市",
"861380791", "江西省南昌市",
"861300495", "福建省南平市",
"861538620", "湖南省株洲市",
"861827068", "江西省九江市",
"861454117", "安徽省宿州市",
"861353459", "广东省佛山市",
"861390062", "江苏省苏州市",
"861478424", "河南省郑州市",
"861589219", "福建省南平市",
"861806965", "浙江省嘉兴市",
"861860544", "山东省菏泽市",
"861370279", "广东省中山市",
"861873628", "河南省洛阳市",
"86181138", "四川省宜宾市",
"861359213", "河南省开封市",
"86182973", "安徽省亳州市",
"861820554", "安徽省淮南市",
"86186451", "黑龙江省哈尔滨市",
"861301994", "辽宁省盘锦市",
"861538479", "内蒙古锡林郭勒盟",
"861347454", "陕西省咸阳市",
"861559309", "甘肃省白银市",
"861813493", "山西省太原市",
"861819068", "四川省成都市",
"861537159", "江苏省泰州市",
"861348174", "广西防城港市",
"861831241", "广东省广州市",
"86180131", "江苏省苏州市",
"861850770", "广西防城港市",
"861534919", "陕西省铜川市",
"861896599", "福建省南平市",
"861316488", "福建省厦门市",
"861591493", "广东省揭阳市",
"86138449", "吉林省长春市",
"861556151", "黑龙江省七台河市",
"861558033", "湖南省衡阳市",
"861452752", "湖南省长沙市",
"861316532", "山东省青岛市",
"861380736", "湖南省常德市",
"861767111", "湖北省十堰市",
"861820347", "山西省临汾市",
"861512964", "陕西省安康市",
"86159338", "河北省衡水市",
"861318773", "云南省玉溪市",
"861346923", "湖南省岳阳市",
"86182778", "广西河池市",
"861860428", "辽宁省大连市",
"861399454", "山西省阳泉市",
"861860357", "山西省临汾市",
"861306418", "江西省九江市",
"861561608", "湖南省张家界市",
"861550605", "吉林省长春市",
"861373287", "吉林省通化市",
"861567800", "广西来宾市",
"861524183", "辽宁省沈阳市",
"86181978", "新疆和田地区",
"861871926", "广东省广州市",
"86137721", "陕西省西安市",
"861800857", "贵州省毕节地区",
"861593304", "河北省唐山市",
"861839332", "甘肃省定西市",
"861474710", "内蒙古呼和浩特市",
"86182133", "云南省大理白族自治州",
"861561562", "山东省青岛市",
"861872556", "安徽省安庆市",
"86185689", "河南省洛阳市",
"86139743", "湖南省湘西土家族苗族自治州",
"861377558", "江苏省连云港市",
"861859182", "陕西省榆林市",
"861773489", "河南省新乡市",
"861358947", "山东省聊城市",
"861345841", "四川省南充市",
"86189606", "福建省南平市",
"861835281", "江苏省连云港市",
"861551278", "河北省沧州市",
"86181534", "山东省德州市",
"861336747", "湖南省衡阳市",
"861355161", "四川省广安市",
"861894913", "安徽省滁州市",
"861820504", "江苏省镇江市",
"861536593", "江苏省淮安市",
"861787547", "广东省茂名市",
"861883072", "河北省沧州市",
"861802763", "广东省江门市",
"861470618", "江苏省无锡市",
"861333637", "山东省枣庄市",
"861861322", "四川省成都市",
"861590451", "黑龙江省哈尔滨市",
"861560275", "广东省揭阳市",
"861508388", "江西省萍乡市",
"861318342", "四川省德阳市",
"861303660", "四川省眉山市",
"861867411", "湖北省孝感市",
"861537109", "江苏省无锡市",
"861479946", "新疆巴音郭楞蒙古自治州",
"861559359", "甘肃省金昌市",
"861366776", "广西百色市",
"861347404", "陕西省咸阳市",
"861841946", "甘肃省陇南市",
"861586970", "湖南省株洲市",
"861337283", "辽宁省沈阳市",
"861809987", "新疆喀什地区",
"861504980", "内蒙古巴彦淖尔市",
"861572428", "浙江省宁波市",
"861866792", "浙江省杭州市",
"861384933", "河南省濮阳市",
"861308142", "山东省济南市",
"861840729", "湖北省武汉市",
"861324778", "江西省南昌市",
"861372282", "河北省衡水市",
"861591769", "广东省东莞市",
"861589868", "山东省菏泽市",
"86155476", "内蒙古赤峰市",
"861560556", "安徽省安庆市",
"86182398", "河南省三门峡市",
"861365413", "辽宁省抚顺市",
"861533471", "内蒙古呼和浩特市",
"861520546", "山东省东营市",
"86185600", "山东省济南市",
"861342412", "广东省广州市",
"861847529", "广东省阳江市",
"861592542", "云南省西双版纳傣族自治州",
"861802499", "广东省揭阳市",
"861555320", "山东省青岛市",
"861331771", "广西南宁市",
"861870749", "湖南省长沙市",
"861889040", "湖南省岳阳市",
"861320429", "辽宁省葫芦岛市",
"861393469", "山西省临汾市",
"861350052", "安徽省芜湖市",
"861882077", "广东省广州市",
"86135768", "江西省吉安市",
"861811490", "江苏省苏州市",
"861332632", "山东省枣庄市",
"861709896", "广东省中山市",
"861893346", "广东省梅州市",
"861348465", "陕西省延安市",
"861898019", "四川省达州市",
"861894572", "黑龙江省黑河市",
"861390033", "河北省邯郸市",
"86159311", "河北省石家庄市",
"861560930", "甘肃省临夏回族自治州",
"861320670", "黑龙江省黑河市",
"861517100", "湖北省襄樊市",
"861364436", "吉林省白城市",
"861389595", "黑龙江省齐齐哈尔市",
"86180118", "广东省广州市",
"86135963", "吉林省吉林市",
"861848918", "西藏日喀则地区",
"861561533", "山东省淄博市",
"861853448", "山西省吕梁市",
"861593490", "内蒙古鄂尔多斯市",
"86187867", "贵州省贵阳市",
"861808423", "贵州省黔南布依族苗族自治州",
"861599137", "陕西省咸阳市",
"861339371", "河南省郑州市",
"861511346", "广东省梅州市",
"861369968", "四川省南充市",
"861882603", "广东省中山市",
"861316563", "湖北省十堰市",
"861361223", "广东省珠海市",
"861818243", "陕西省西安市",
"861564833", "内蒙古兴安盟",
"861477872", "广东省湛江市",
"861801104", "四川省泸州市",
"861350240", "广东省广州市",
"861379683", "黑龙江省哈尔滨市",
"861889252", "贵州省安顺市",
"861560506", "福建省漳州市",
"861454387", "贵州省毕节地区",
"861500883", "云南省文山壮族苗族自治州",
"861850876", "云南省文山壮族苗族自治州",
"861800097", "广东省湛江市",
"861470329", "河北省邢台市",
"861826256", "江苏省镇江市",
"861471516", "广东省东莞市",
"861368566", "安徽省六安市",
"86187916", "陕西省汉中市",
"861335365", "河南省安阳市",
"86185605", "山东省临沂市",
"861350002", "广东省广州市",
"861364249", "广东省河源市",
"861332994", "湖北省黄冈市",
"861395151", "江苏省无锡市",
"861813769", "河南省周口市",
"861347390", "河北省唐山市",
"861510813", "四川省资阳市",
"86136759", "福建省泉州市",
"861324259", "广东省潮州市",
"861504271", "辽宁省营口市",
"861450514", "吉林省四平市",
"861554088", "内蒙古包头市",
"861567706", "广西桂林市",
"861871874", "广东省广州市",
"861336179", "江西省萍乡市",
"861772413", "广东省茂名市",
"861572544", "山东省德州市",
"861530374", "河南省许昌市",
"861880479", "内蒙古锡林郭勒盟",
"861301663", "广东省东莞市",
"861560383", "河南省安阳市",
"861310416", "辽宁省锦州市",
"861515553", "安徽省淮北市",
"86157592", "福建省厦门市",
"861837960", "江西省九江市",
"861853400", "山西省太原市",
"861314952", "黑龙江省齐齐哈尔市",
"861773757", "河南省郑州市",
"861563643", "黑龙江省大兴安岭地区",
"861322844", "陕西省榆林市",
"861554282", "辽宁省锦州市",
"861311763", "广西桂林市",
"861386638", "安徽省芜湖市",
"861309132", "河北省张家口市",
"861362854", "贵州省黔南布依族苗族自治州",
"861877141", "湖北省随州市",
"861886828", "浙江省温州市",
"861522487", "河南省南阳市",
"861889764", "广西柳州市",
"861508729", "云南省大理白族自治州",
"861580342", "山西省大同市",
"861364770", "广西防城港市",
"86139787", "广西南宁市",
"861302354", "江苏省淮安市",
"861380318", "河北省衡水市",
"861870981", "安徽省宿州市",
"861889058", "湖南省娄底市",
"861529999", "新疆克拉玛依市",
"861533790", "陕西省西安市",
"861705601", "上海市",
"861510039", "河北省邢台市",
"861840691", "云南省西双版纳傣族自治州",
"861339917", "陕西省宝鸡市",
"861350779", "广西北海市",
"861351675", "浙江省绍兴市",
"861700923", "山东省济南市",
"861558268", "山西省临汾市",
"861580773", "广西桂林市",
"861555447", "山东省威海市",
"861396590", "安徽省池州市",
"861308897", "陕西省西安市",
"86132827", "浙江省温州市",
"861360678", "浙江省宁波市",
"861520938", "甘肃省天水市",
"86150907", "湖北省荆州市",
"861373180", "安徽省阜阳市",
"861368397", "河南省信阳市",
"861773707", "河南省洛阳市",
"861454210", "河南省商丘市",
"861314902", "广东省清远市",
"861458481", "山东省青岛市",
"861538839", "四川省达州市",
"86135771", "云南省昆明市",
"861853450", "山西省晋城市",
"861328594", "福建省福州市",
"861340826", "四川省广安市",
"861329960", "广西柳州市",
"861827233", "湖北省十堰市",
"861377497", "山东省菏泽市",
"861840636", "山东省潍坊市",
"861381234", "江苏省连云港市",
"861373478", "内蒙古赤峰市",
"86135864", "浙江省嘉兴市",
"8670", "江西省鹰潭市",
"861879091", "河南省漯河市",
"861890686", "浙江省台州市",
"861874609", "黑龙江省绥化市",
"86130238", "福建省福州市",
"861596569", "山东省菏泽市",
"861780571", "浙江省杭州市",
"86176397", "河南省周口市",
"861861592", "山东省济宁市",
"861317960", "江苏省苏州市",
"861708841", "江西省萍乡市",
"861877086", "江西省吉安市",
"86155686", "吉林省松原市",
"861830416", "辽宁省锦州市",
"861314176", "甘肃省定西市",
"861322675", "广东省汕尾市",
"861500918", "陕西省咸阳市",
"861582954", "陕西省西安市",
"861350258", "广东省汕尾市",
"861804392", "吉林省吉林市",
"861816179", "陕西省铜川市",
"86136288", "云南省德宏傣族景颇族自治州",
"861302304", "安徽省芜湖市",
"861332421", "辽宁省朝阳市",
"861319363", "河南省周口市",
"861787771", "湖南省怀化市",
"861529148", "陕西省西安市",
"861705651", "上海市",
"861569158", "陕西省安康市",
"86132469", "广东省东莞市",
"861385222", "江苏省徐州市",
"861873535", "山西省吕梁市",
"861372088", "福建省厦门市",
"86135051", "江苏省南京市",
"861329112", "江苏省南通市",
"861822682", "安徽省滁州市",
"861898833", "云南省临沧市",
"861452413", "辽宁省抚顺市",
"861390819", "四川省成都市",
"861571778", "广西河池市",
"861335979", "黑龙江省七台河市",
"861327363", "河北省廊坊市",
"861585488", "山东省潍坊市",
"861351844", "四川省甘孜藏族自治州",
"861315235", "陕西省渭南市",
"86134329", "广东省茂名市",
"861317112", "内蒙古通辽市",
"861881364", "广东省深圳市",
"861309570", "浙江省衢州市",
"861539555", "安徽省马鞍山市",
"861336571", "安徽省芜湖市",
"861338243", "江苏省扬州市",
"861592660", "湖北省荆州市",
"861877095", "江西省宜春市",
"861387199", "湖北省黄冈市",
"861555590", "安徽省宿州市",
"861887297", "湖北省荆州市",
"861569247", "广东省佛山市",
"861470788", "广西河池市",
"861313760", "河南省信阳市",
"861561640", "湖南省邵阳市",
"861845442", "山东省淄博市",
"861556509", "河南省郑州市",
"861301421", "宁夏石嘴山市",
"861380629", "江苏省南通市",
"861773914", "河南省焦作市",
"861880839", "四川省广元市",
"861331304", "河北省石家庄市",
"861517257", "湖北省襄樊市",
"861339068", "江苏省盐城市",
"861853394", "河北省邯郸市",
"861870935", "甘肃省武威市",
"86159851", "贵州省贵阳市",
"861539276", "湖北省荆州市",
"861308057", "湖南省益阳市",
"861346905", "湖南省长沙市",
"86150325", "河北省唐山市",
"861325373", "河南省许昌市",
"861337969", "贵州省黔西南布依族苗族自治州",
"86159680", "浙江省宁波市",
"861850436", "吉林省白城市",
"861588416", "四川省泸州市",
"861329382", "山西省大同市",
"861530751", "广东省韶关市",
"861890695", "福建省漳州市",
"861567848", "广西梧州市",
"861309163", "黑龙江省佳木斯市",
"861579410", "浙江省宁波市",
"861311732", "湖南省湘潭市",
"861380470", "内蒙古呼伦贝尔市",
"861591637", "广东省惠州市",
"861339754", "湖南省郴州市",
"861806379", "福建省龙岩市",
"861303542", "安徽省六安市",
"861599230", "广东省肇庆市",
"86135113", "浙江省嘉兴市",
"861366430", "吉林省长春市",
"861894237", "江西省赣州市",
"861361576", "浙江省台州市",
"861509925", "新疆巴音郭楞蒙古自治州",
"861768928", "福建省三明市",
"861334847", "福建省漳州市",
"86181961", "新疆昌吉回族自治州",
"861325742", "湖南省常德市",
"861571997", "新疆巴音郭楞蒙古自治州",
"86157704", "云南省丽江市",
"861365752", "新疆阿克苏地区",
"861304376", "河南省信阳市",
"861315970", "吉林省吉林市",
"861850249", "辽宁省辽阳市",
"86186875", "云南省昆明市",
"86137842", "河北省邯郸市",
"861862443", "辽宁省大连市",
"861350147", "广东省广州市",
"861537551", "安徽省合肥市",
"861891214", "江苏省扬州市",
"861878864", "贵州省遵义市",
"86182874", "云南省曲靖市",
"861823687", "河南省焦作市",
"861308673", "广西桂林市",
"861822453", "河南省郑州市",
"861331547", "河北省石家庄市",
"861583425", "山西省朔州市",
"86153022", "广东省广州市",
"861364876", "云南省文山壮族苗族自治州",
"86130211", "北京市",
"86182761", "广西南宁市",
"861326014", "内蒙古赤峰市",
"861399520", "宁夏银川市",
"861539393", "云南省西双版纳傣族自治州",
"86135509", "四川省攀枝花市",
"861370740", "湖南省岳阳市",
"861529207", "湖南省益阳市",
"861389049", "四川省凉山彝族自治州",
"861820420", "辽宁省朝阳市",
"861894888", "广东省中山市",
"861893460", "湖北省襄樊市",
"861879145", "陕西省安康市",
"861331354", "山西省晋中市",
"861347520", "山东省枣庄市",
"861345123", "湖北省荆州市",
"861315281", "山西省晋中市",
"861302490", "福建省三明市",
"861373310", "河南省南阳市",
"861386553", "安徽省芜湖市",
"861398010", "四川省德阳市",
"86159685", "浙江省绍兴市",
"86150320", "河北省石家庄市",
"861346955", "宁夏吴忠市",
"861390268", "广东省汕尾市",
"861308007", "吉林省松原市",
"861598779", "云南省红河哈尼族彝族自治州",
"861576882", "广东省阳江市",
"861568913", "山东省青岛市",
"861479482", "内蒙古包头市",
"861454565", "四川省南充市",
"861813637", "江苏省徐州市",
"86132213", "浙江省嘉兴市",
"861306034", "陕西省咸阳市",
"861843600", "河南省周口市",
"861876021", "福建省宁德市",
"86130782", "广东省湛江市",
"861530701", "江西省鹰潭市",
"86180763", "广西南宁市",
"861891432", "江苏省常州市",
"861327332", "河北省衡水市",
"861359937", "福建省福州市",
"861533831", "广东省佛山市",
"861453489", "内蒙古呼伦贝尔市",
"861339704", "江西省九江市",
"861890338", "河北省唐山市",
"861871212", "安徽省宿州市",
"861814024", "四川省成都市",
"861707164", "河南省鹤壁市",
"861528880", "山东省日照市",
"861365702", "江西省九江市",
"861840388", "黑龙江省哈尔滨市",
"861522072", "广东省惠州市",
"861856973", "湖南省湘西土家族苗族自治州",
"861335587", "浙江省温州市",
"861356961", "河南省三门峡市",
"861896618", "浙江省杭州市",
"861458435", "河南省平顶山市",
"861537990", "甘肃省临夏回族自治州",
"861321782", "广西来宾市",
"861537501", "安徽省滁州市",
"861899399", "甘肃省白银市",
"86186870", "云南省昆明市",
"861850491", "内蒙古呼和浩特市",
"861846041", "江西省萍乡市",
"86139586", "浙江省台州市",
"86159902", "浙江省宁波市",
"861304293", "甘肃省庆阳市",
"861882946", "陕西省汉中市",
"86136662", "四川省成都市",
"861869042", "陕西省汉中市",
"861337208", "江苏省南通市",
"861867024", "湖南省邵阳市",
"86186683", "浙江省嘉兴市",
"861501244", "广东省广州市",
"861390959", "宁夏银川市",
"861804644", "福建省莆田市",
"861321418", "辽宁省阜新市",
"861874841", "内蒙古乌兰察布市",
"861597761", "广西百色市",
"861823361", "河北省廊坊市",
"86150525", "江苏省扬州市",
"861533828", "广东省中山市",
"861872466", "黑龙江省鸡西市",
"86135591", "福建省福州市",
"861835044", "福建省莆田市",
"86181068", "浙江省绍兴市",
"861890321", "河北省石家庄市",
"861581173", "广东省清远市",
"86139417", "辽宁省营口市",
"861858912", "西藏日喀则地区",
"861580932", "甘肃省定西市",
"861351179", "江苏省宿迁市",
"86180633", "山东省日照市",
"861330579", "浙江省金华市",
"861859670", "福建省泉州市",
"861878820", "云南省德宏傣族景颇族自治州",
"8618414", "浙江省杭州市",
"861339807", "西藏阿里地区",
"861871541", "安徽省安庆市",
"861893548", "山西省朔州市",
"861572871", "广东省东莞市",
"861450203", "河北省邯郸市",
"861379658", "黑龙江省绥化市",
"861760539", "山东省临沂市",
"861454423", "江苏省常州市",
"861398990", "西藏拉萨市",
"861768996", "福建省泉州市",
"861392195", "江苏省苏州市",
"861839495", "甘肃省陇南市",
"861479718", "山西省太原市",
"861500858", "贵州省六盘水市",
"86180854", "贵州省黔南布依族苗族自治州",
"86130626", "上海市",
"861590561", "安徽省淮北市",
"861313970", "新疆昌吉回族自治州",
"861803165", "河北省秦皇岛市",
"861551355", "山西省长治市",
"861582537", "宁夏银川市",
"861885709", "浙江省舟山市",
"86131432", "广东省东莞市",
"861310163", "黑龙江省牡丹江市",
"861334411", "北京市",
"861377468", "福建省厦门市",
"861323742", "湖南省长沙市",
"861520348", "山西省运城市",
"861564207", "辽宁省铁岭市",
"861340008", "江苏省镇江市",
"861560358", "山西省吕梁市",
"861560427", "辽宁省盘锦市",
"861305542", "福建省福州市",
"861858160", "四川省成都市",
"861570480", "内蒙古兴安盟",
"861816844", "江苏省连云港市",
"861323231", "广东省梅州市",
"861772166", "江苏省常州市",
"861315827", "贵州省毕节地区",
"861768931", "福建省宁德市",
"861390909", "四川省宜宾市",
"861801575", "四川省泸州市",
"861374986", "河南省许昌市",
"861814060", "湖北省襄樊市",
"861700690", "福建省厦门市",
"861563680", "黑龙江省哈尔滨市",
"861587124", "湖北省随州市",
"861502845", "河北省邯郸市",
"861337258", "浙江省衢州市",
"861589142", "陕西省西安市",
"861519067", "江苏省徐州市",
"861517473", "内蒙古乌海市",
"861705523", "重庆市",
"861329876", "黑龙江省佳木斯市",
"861338971", "青海省西宁市",
"861570178", "甘肃省酒泉市",
"86150520", "江苏省徐州市",
"861580694", "山东省临沂市",
"86315", "河北省唐山市",
"861584766", "内蒙古呼和浩特市",
"861313281", "广西南宁市",
"86133071", "湖北省武汉市",
"861334744", "陕西省咸阳市",
"861361061", "山西省临汾市",
"861804875", "四川省凉山彝族自治州",
"861317876", "广东省汕头市",
"861529473", "河南省信阳市",
"861308868", "浙江省温州市",
"861323296", "广东省清远市",
"861339857", "贵州省毕节地区",
"861708659", "山东省烟台市",
"86159873", "云南省红河哈尼族彝族自治州",
"861817240", "广西南宁市",
"861893424", "广东省湛江市",
"861820464", "黑龙江省七台河市",
"861581215", "云南省西双版纳傣族自治州",
"861807679", "广西桂林市",
"86180289", "广东省东莞市",
"861347564", "山东省日照市",
"861311512", "江苏省苏州市",
"861322179", "浙江省丽水市",
"861326994", "甘肃省天水市",
"861829240", "陕西省咸阳市",
"861470412", "辽宁省鞍山市",
"861363702", "安徽省滁州市",
"861560308", "广东省揭阳市",
"861336027", "广东省肇庆市",
"861516700", "浙江省绍兴市",
"861821647", "湖南省娄底市",
"861333587", "浙江省温州市",
"861564257", "辽宁省朝阳市",
"86145203", "北京市",
"861554003", "内蒙古通辽市",
"86182631", "山东省威海市",
"861373143", "河北省承德市",
"861821965", "甘肃省武威市",
"861362914", "陕西省商洛市",
"861515799", "浙江省舟山市",
"861807420", "浙江省宁波市",
"861583563", "山西省大同市",
"86182618", "江苏省苏州市",
"861528529", "贵州省黔东南苗族侗族自治州",
"861896703", "浙江省衢州市",
"861580963", "宁夏吴忠市",
"861879911", "新疆哈密地区",
"86177955", "宁夏中卫市",
"861770734", "湖南省衡阳市",
"861345574", "山东省枣庄市",
"861384899", "内蒙古赤峰市",
"861534545", "山东省德州市",
"861351747", "湖南省长沙市",
"861559080", "黑龙江省齐齐哈尔市",
"861323285", "广东省江门市",
"861330987", "辽宁省盘锦市",
"861370783", "广西桂林市",
"861536278", "广东省珠海市",
"861826104", "江苏省泰州市",
"86151007", "河北省沧州市",
"861531845", "山东省枣庄市",
"86136969", "福建省厦门市",
"861524158", "辽宁省丹东市",
"86180200", "天津市",
"861870345", "山西省长治市",
"861855400", "山东省济南市",
"861328239", "浙江省舟山市",
"861354496", "广东省江门市",
"861537623", "山东省日照市",
"861337147", "山东省聊城市",
"861837249", "湖北省十堰市",
"861311973", "青海省黄南藏族自治州",
"861550551", "安徽省合肥市",
"86135380", "广东省深圳市",
"86183459", "黑龙江省大庆市",
"86137297", "广东省云浮市",
"86155722", "湖北省随州市",
"861817892", "江西省九江市",
"8614500", "北京市",
"861476591", "重庆市",
"861458522", "河南省焦作市",
"861553447", "山西省太原市",
"861840325", "河北省唐山市",
"861889720", "青海省西宁市",
"86135753", "浙江省嘉兴市",
"861332582", "浙江省湖州市",
"861536709", "湖南省衡阳市",
"861368456", "黑龙江省黑河市",
"861332438", "吉林省松原市",
"861362707", "江西省赣州市",
"861364960", "云南省红河哈尼族彝族自治州",
"861786987", "云南省西双版纳傣族自治州",
"861388903", "西藏山南地区",
"861315866", "四川省德阳市",
"861829892", "甘肃省白银市",
"861779218", "陕西省汉中市",
"861780066", "内蒙古乌兰察布市",
"861889974", "广东省东莞市",
"86177950", "宁夏银川市",
"861847138", "湖北省恩施土家族苗族自治州",
"8618516", "上海市",
"86135958", "贵州省六盘水市",
"861582078", "广东省深圳市",
"861560466", "黑龙江省哈尔滨市",
"861800371", "河南省郑州市",
"861897188", "湖北省恩施土家族苗族自治州",
"861535885", "江苏省扬州市",
"861471470", "广东省河源市",
"861557701", "广西柳州市",
"861779584", "陕西省宝鸡市",
"861310570", "浙江省衢州市",
"86180205", "江苏省徐州市",
"861564999", "河南省周口市",
"861516806", "浙江省舟山市",
"861355787", "广西南宁市",
"861375478", "山东省淄博市",
"861884048", "陕西省西安市",
"86130412", "北京市",
"861308794", "广西梧州市",
"861881320", "广东省阳江市",
"861856241", "山东省济宁市",
"861508586", "贵州省六盘水市",
"861775707", "浙江省宁波市",
"861860871", "云南省昆明市",
"861571968", "甘肃省天水市",
"861360863", "河南省焦作市",
"861855450", "山东省威海市",
"861470725", "湖北省黄冈市",
"861471629", "广东省广州市",
"861367952", "广东省清远市",
"861535006", "江西省吉安市",
"861566513", "江苏省南通市",
"861550990", "新疆克拉玛依市",
"86135385", "广东省东莞市",
"861550501", "安徽省六安市",
"861329924", "广西玉林市",
"861348555", "安徽省马鞍山市",
"861475148", "江苏省无锡市",
"861837491", "湖南省岳阳市",
"861329770", "广西南宁市",
"861801206", "江苏省淮安市",
"861889867", "广东省揭阳市",
"861333979", "湖北省宜昌市",
"86181613", "四川省德阳市",
"861510646", "山东省烟台市",
"861317924", "吉林省吉林市",
"861536759", "湖南省怀化市",
"861473019", "河北省邢台市",
"861839486", "甘肃省庆阳市",
"861509988", "广东省佛山市",
"861319942", "黑龙江省鸡西市",
"861887268", "湖北省孝感市",
"861818187", "四川省泸州市",
"861517019", "江西省赣州市",
"861513525", "山西省吕梁市",
"861308219", "河北省沧州市",
"861879649", "江苏省宿迁市",
"861862480", "河南省南阳市",
"861317770", "江西省九江市",
"861516085", "新疆吐鲁番地区",
"86176376", "河南省信阳市",
"861352370", "河南省商丘市",
"861478346", "河南省南阳市",
"861587802", "广西玉林市",
"861867144", "湖北省宜昌市",
"861380618", "江苏省无锡市",
"861828474", "四川省泸州市",
"861302654", "山东省东营市",
"861877577", "广西北海市",
"861811987", "安徽省芜湖市",
"861773042", "安徽省宿州市",
"86183278", "湖北省黄石市",
"861473806", "河南省商丘市",
"86159415", "辽宁省丹东市",
"861378940", "内蒙古呼伦贝尔市",
"861452976", "广东省东莞市",
"861530559", "安徽省黄山市",
"861835124", "江苏省宿迁市",
"8617710", "北京市",
"861580642", "山东省青岛市",
"861389946", "新疆和田地区",
"861325897", "山东省枣庄市",
"861303446", "湖北省黄冈市",
"861894891", "广东省河源市",
"861819154", "陕西省渭南市",
"861334792", "江苏省无锡市",
"861539964", "安徽省安庆市",
"86130527", "辽宁省大连市",
"861361472", "内蒙古包头市",
"861317403", "江苏省盐城市",
"861374921", "河南省鹤壁市",
"861565962", "福建省三明市",
"861590979", "青海省海西蒙古族藏族自治州",
"861315298", "山西省吕梁市",
"861316924", "广东省梅州市",
"861556030", "内蒙古鄂尔多斯市",
"861348774", "湖南省株洲市",
"861476525", "河南省郑州市",
"861507015", "江西省赣州市",
"861768919", "西藏拉萨市",
"861514733", "内蒙古赤峰市",
"861471703", "甘肃省定西市",
"861850532", "山东省青岛市",
"86182913", "陕西省渭南市",
"861525729", "浙江省嘉兴市",
"861588512", "贵州省黔东南苗族侗族自治州",
"861501746", "广东省珠海市",
"861360378", "河南省开封市",
"861316770", "安徽省安庆市",
"861830973", "青海省黄南藏族自治州",
"861870777", "广西钦州市",
"861850488", "内蒙古巴彦淖尔市",
"861330961", "安徽省淮北市",
"861860984", "辽宁省大连市",
"861861485", "内蒙古鄂尔多斯市",
"861351375", "河南省平顶山市",
"861470736", "湖南省常德市",
"86131089", "重庆市",
"861565110", "江苏省苏州市",
"861372145", "河南省焦作市",
"861454717", "浙江省温州市",
"861882049", "广东省清远市",
"861477950", "江西省九江市",
"861803137", "河北省张家口市",
"861840391", "河南省焦作市",
"861890553", "安徽省芜湖市",
"86181713", "湖北省武汉市",
"861705301", "北京市",
"861809490", "新疆乌鲁木齐市",
"861369443", "吉林省延边朝鲜族自治州",
"861589022", "河南省漯河市",
"861329453", "山西省阳泉市",
"861869094", "新疆博尔塔拉蒙古自治州",
"861539877", "云南省玉溪市",
"861853963", "河南省周口市",
"861302604", "安徽省淮北市",
"861707040", "浙江省湖州市",
"86180911", "陕西省延安市",
"861891950", "四川省凉山彝族自治州",
"861524783", "内蒙古巴彦淖尔市",
"861530509", "福建省泉州市",
"861521494", "新疆和田地区",
"861889881", "广东省广州市",
"861459334", "四川省宜宾市",
"861322375", "河南省新乡市",
"86159410", "辽宁省铁岭市",
"861370158", "江苏省南京市",
"861533297", "内蒙古通辽市",
"86182718", "湖北省武汉市",
"861538951", "陕西省安康市",
"861529856", "江苏省盐城市",
"861317453", "福建省福州市",
"861523303", "河北省张家口市",
"86135834", "山东省德州市",
"861470791", "江西省南昌市",
"861520995", "新疆吐鲁番地区",
"861569846", "山西省长治市",
"861318173", "山东省济南市",
"861818161", "四川省内江市",
"86130268", "广东省东莞市",
"861359775", "湖北省恩施土家族苗族自治州",
"861532840", "四川省泸州市",
"86131261", "河北省石家庄市",
"861323219", "广东省茂名市",
"861815947", "福建省龙岩市",
"861337066", "山东省临沂市",
"861840336", "河北省秦皇岛市",
"861537278", "浙江省舟山市",
"86188886", "浙江省宁波市",
"861768641", "山东省济南市",
"861760728", "湖北省十堰市",
"86135653", "新疆昌吉回族自治州",
"861837425", "湖南省娄底市",
"861802163", "江苏省苏州市",
"861386695", "安徽省宣城市",
"861302171", "山东省济南市",
"861821937", "广东省惠州市",
"861336147", "山东省聊城市",
"861836249", "江苏省宿迁市",
"861778507", "贵州省毕节地区",
"861505786", "浙江省丽水市",
"861355761", "广西南宁市",
"861346889", "陕西省榆林市",
"861338569", "安徽省合肥市",
"861376583", "贵州省贵阳市",
"861894836", "广东省揭阳市",
"861885010", "福建省福州市",
"861776817", "江苏省宿迁市",
"861323794", "江西省抚州市",
"861366902", "湖北省孝感市",
"86159791", "江西省南昌市",
"86155622", "山东省枣庄市",
"861890503", "福建省宁德市",
"861705351", "山西省太原市",
"861760511", "江苏省镇江市",
"861816892", "江苏省无锡市",
"861319663", "江苏省盐城市",
"861526026", "福建省莆田市",
"861896629", "浙江省温州市",
"861305594", "福建省莆田市",
"86186355", "山西省长治市",
"861394945", "河南省平顶山市",
"861890395", "河南省漯河市",
"86182354", "山西省晋中市",
"861816002", "四川省成都市",
"86133168", "广东省深圳市",
"861590587", "浙江省温州市",
"861802570", "广东省潮州市",
"861565933", "福建省宁德市",
"86180574", "浙江省宁波市",
"861510991", "新疆乌鲁木齐市",
"86187136", "河北省沧州市",
"861314430", "吉林省长春市",
"861308742", "云南省迪庆藏族自治州",
"861857763", "广西柳州市",
"861340227", "山东省济宁市",
"861381516", "江苏省镇江市",
"861458498", "山东省烟台市",
"861504540", "黑龙江省佳木斯市",
"861809547", "宁夏银川市",
"861380329", "河北省邯郸市",
"861317682", "山东省泰安市",
"861507648", "河北省秦皇岛市",
"861877989", "江西省南昌市",
"86139141", "江苏省无锡市",
"861517031", "江西省景德镇市",
"861512849", "河北省保定市",
"861880951", "宁夏银川市",
"861847699", "广东省深圳市",
"861811579", "江苏省常州市",
"861327994", "新疆昌吉回族自治州",
"86159371", "河南省郑州市",
"861517700", "广西北海市",
"861780258", "江苏省宿迁市",
"861452824", "四川省南充市",
"86182731", "湖南省长沙市",
"861360410", "辽宁省铁岭市",
"86186988", "辽宁省沈阳市",
"86133880", "天津市",
"861806420", "湖北省咸宁市",
"861308373", "河南省新乡市",
"861839421", "甘肃省天水市",
"861808361", "贵州省贵阳市",
"861881993", "广东省汕头市",
"861527146", "湖北省宜昌市",
"861568476", "山东省泰安市",
"86178771", "广西南宁市",
"861817675", "广西河池市",
"86181931", "甘肃省兰州市",
"861380045", "黑龙江省哈尔滨市",
"861816240", "湖北省宜昌市",
"861319994", "新疆昌吉回族自治州",
"861835802", "浙江省金华市",
"861529700", "青海省海北藏族自治州",
"861395701", "浙江省衢州市",
"861370247", "广东省湛江市",
"861338884", "云南省昆明市",
"861346564", "山东省日照市",
"861592982", "陕西省榆林市",
"861386686", "安徽省宿州市",
"861372091", "山西省吕梁市",
"861368873", "云南省文山壮族苗族自治州",
"861850563", "安徽省宣城市",
"861350571", "浙江省杭州市",
"861535268", "新疆博尔塔拉蒙古自治州",
"86180938", "甘肃省天水市",
"861454954", "江苏省徐州市",
"861335076", "四川省乐山市",
"861457114", "湖北省十堰市",
"861772047", "湖北省孝感市",
"861565380", "山东省泰安市",
"861893953", "河南省漯河市",
"861510550", "安徽省滁州市",
"861575458", "黑龙江省伊春市",
"86159553", "安徽省芜湖市",
"86178580", "浙江省温州市",
"861820379", "河南省洛阳市",
"86139522", "江苏省徐州市",
"86136762", "广东省广州市",
"861586092", "福建省泉州市",
"861300014", "天津市",
"861336208", "浙江省丽水市",
"861894730", "内蒙古乌海市",
"861344457", "山东省临沂市",
"861333561", "安徽省淮北市",
"861564916", "河南省信阳市",
"861780779", "广西北海市",
"861880901", "新疆塔城地区",
"861880590", "福建省福州市",
"861785884", "浙江省杭州市",
"86136019", "上海市",
"861358979", "山东省烟台市",
"861780208", "广东省韶关市",
"861861496", "河南省郑州市",
"861830512", "江苏省连云港市",
"86145498", "浙江省湖州市",
"861572984", "四川省自贡市",
"861336779", "广西北海市",
"861509011", "河南省南阳市",
"86155929", "陕西省延安市",
"861319632", "陕西省渭南市",
"86133885", "浙江省温州市",
"861510936", "甘肃省张掖市",
"861325007", "广东省珠海市",
"861313267", "广西钦州市",
"861815401", "安徽省芜湖市",
"86151806", "江西省九江市",
"86130726", "河南省新乡市",
"861361087", "辽宁省盘锦市",
"861569740", "湖南省岳阳市",
"861533959", "贵州省黔南布依族苗族自治州",
"861870998", "新疆喀什地区",
"861787579", "广东省阳江市",
"861327632", "山东省枣庄市",
"861532746", "湖北省仙桃市",
"86187976", "湖南省永州市",
"86155387", "河南省南阳市",
"861771253", "江苏省盐城市",
"861890638", "山东省烟台市",
"861323868", "云南省昆明市",
"861889835", "广东省深圳市",
"861324480", "广东省广州市",
"861802132", "江苏省扬州市",
"861390828", "四川省广安市",
"861301495", "广西玉林市",
"86159785", "河南省信阳市",
"861826262", "江苏省南京市",
"861332486", "广西贵港市",
"861708309", "河北省石家庄市",
"861869757", "安徽省宿州市",
"861328542", "山东省青岛市",
"861829747", "安徽省六安市",
"861368552", "安徽省蚌埠市",
"861577882", "广西河池市",
"861452860", "青海省海北藏族自治州",
"861864844", "内蒙古兴安盟",
"861526808", "浙江省衢州市",
"861307034", "新疆吐鲁番地区",
"861838400", "四川省泸州市",
"86130682", "广东省惠州市",
"86180663", "浙江省温州市",
"861369480", "江西省上饶市",
"861500146", "新疆喀什地区",
"861817747", "广西贺州市",
"86181038", "河南省郑州市",
"861768809", "广东省河源市",
"861532883", "四川省宜宾市",
"861808687", "四川省乐山市",
"861528721", "云南省大理白族自治州",
"861323673", "辽宁省营口市",
"861861544", "山东省济南市",
"861830732", "湖南省湘潭市",
"86186555", "安徽省马鞍山市",
"861346520", "山东省威海市",
"861822770", "四川省阿坝藏族羌族自治州",
"861897191", "湖北省十堰市",
"861557559", "湖南省邵阳市",
"861458426", "河南省新乡市",
"861576676", "广东省揭阳市",
"86182554", "安徽省淮南市",
"861300994", "黑龙江省黑河市",
"861599517", "江苏省盐城市",
"86130905", "贵州省遵义市",
"861536990", "河北省衡水市",
"861894510", "黑龙江省哈尔滨市",
"861509991", "广东省深圳市",
"861333076", "四川省南充市",
"861520648", "山东省菏泽市",
"86181153", "江苏省无锡市",
"861813451", "安徽省合肥市",
"861535909", "福建省南平市",
"861898748", "云南省昆明市",
"861354592", "湖北省荆州市",
"861351892", "西藏日喀则地区",
"861453415", "辽宁省丹东市",
"861399905", "新疆和田地区",
"861475700", "浙江省杭州市",
"86152825", "四川省遂宁市",
"861870018", "陕西省西安市",
"86159571", "浙江省杭州市",
"861837532", "安徽省芜湖市",
"861760785", "广西贵港市",
"861810547", "山东省济宁市",
"861357961", "新疆昌吉回族自治州",
"861810354", "山西省晋中市",
"861368502", "福建省福州市",
"861839438", "甘肃省庆阳市",
"861513810", "河南省驻马店市",
"861800822", "四川省泸州市",
"861379308", "山东省聊城市",
"86133364", "广东省佛山市",
"86159780", "广西桂林市",
"861378983", "山东省东营市",
"861342188", "广东省汕头市",
"861855932", "福建省厦门市",
"86139322", "河北省保定市",
"861838450", "四川省广安市",
"861588763", "云南省西双版纳傣族自治州",
"861322892", "西藏日喀则地区",
"861350066", "内蒙古赤峰市",
"861778934", "甘肃省武威市",
"86952", "宁夏石嘴山市",
"861335561", "安徽省淮北市",
"861477810", "广东省深圳市",
"861550278", "湖北省恩施土家族苗族自治州",
"861556193", "黑龙江省牡丹江市",
"861580394", "河南省周口市",
"861591451", "广东省广州市",
"861573458", "黑龙江省伊春市",
"861471618", "广东省潮州市",
"861768859", "广东省梅州市",
"861860322", "河北省保定市",
"86135893", "山东省青岛市",
"861840946", "甘肃省定西市",
"861452727", "湖北省襄樊市",
"861899041", "四川省阿坝藏族羌族自治州",
"861316382", "福建省三明市",
"86186550", "安徽省滁州市",
"86155587", "浙江省温州市",
"861509550", "甘肃省定西市",
"861590493", "辽宁省盘锦市",
"861518412", "辽宁省铁岭市",
"861339575", "浙江省绍兴市",
"861325868", "黑龙江省齐齐哈尔市",
"86130900", "新疆昌吉回族自治州",
"86186269", "吉林省延边朝鲜族自治州",
"861560608", "福建省泉州市",
"861861357", "山西省临汾市",
"861318448", "浙江省丽水市",
"861769535", "宁夏中卫市",
"86182661", "山东省德州市",
"861813401", "河北省石家庄市",
"86152820", "四川省广元市",
"861583249", "河北省石家庄市",
"861596971", "山东省济南市",
"861399955", "新疆昌吉回族自治州",
"861475750", "浙江省温州市",
"861517028", "江西省九江市",
"861367430", "吉林省长春市",
"861847186", "湖北省十堰市",
"861308228", "辽宁省抚顺市",
"861390896", "西藏那曲地区",
"861781747", "广东省惠州市",
"861873567", "山西省运城市",
"861560562", "安徽省铜陵市",
"861473028", "河北省承德市",
"861330771", "广西南宁市",
"861533819", "广东省珠海市",
"861830763", "广东省清远市",
"861890872", "云南省大理白族自治州",
"861870967", "宁夏银川市",
"86155786", "广西百色市",
"861882691", "广东省珠海市",
"861322240", "江苏省无锡市",
"861362250", "广东省佛山市",
"861313298", "广西河池市",
"861580450", "黑龙江省哈尔滨市",
"861760731", "湖南省长沙市",
"861317277", "广东省河源市",
"861508077", "湖南省湘潭市",
"861558896", "山东省莱芜市",
"861339256", "广东省惠州市",
"861323897", "辽宁省鞍山市",
"861398709", "云南省普洱市",
"861321429", "辽宁省葫芦岛市",
"861870645", "山东省烟台市",
"861871749", "陕西省铜川市",
"861319878", "四川省内江市",
"861844743", "内蒙古通辽市",
"86135671", "浙江省杭州市",
"861343705", "江西省宜春市",
"861810490", "辽宁省沈阳市",
"861897045", "江西省吉安市",
"861315226", "陕西省商洛市",
"861826233", "江苏省泰州市",
"861321670", "浙江省杭州市",
"86130989", "海南省海口市",
"861588499", "四川省巴中市",
"861520015", "河北省邢台市",
"861775042", "福建省福州市",
"861597569", "广东省阳江市",
"8618223", "重庆市",
"861805137", "江苏省徐州市",
"861390885", "云南省昆明市",
"861452766", "广西贵港市",
"861516148", "江苏省南京市",
"861340835", "四川省雅安市",
"861840625", "辽宁省盘锦市",
"86159093", "重庆市",
"861573366", "河北省廊坊市",
"861337571", "浙江省杭州市",
"86157712", "内蒙古包头市",
"861872608", "安徽省安庆市",
"861479729", "山西省晋中市",
"861775200", "甘肃省定西市",
"861322002", "陕西省榆林市",
"861893813", "广东省云浮市",
"861324443", "吉林省长春市",
"861350027", "广东省佛山市",
"861590769", "广东省东莞市",
"861364453", "黑龙江省牡丹江市",
"861894265", "河北省石家庄市",
"861539920", "陕西省铜川市",
"861824094", "新疆阿克苏地区",
"861800154", "江苏省苏州市",
"86159709", "江西省赣州市",
"861521546", "山东省东营市",
"861569783", "江西省上饶市",
"861539774", "四川省内江市",
"861561556", "山东省潍坊市",
"86180794", "江西省抚州市",
"861881620", "江苏省无锡市",
"861879025", "河南省郑州市",
"861813947", "新疆阿克苏地区",
"861801097", "安徽省滁州市",
"861501883", "广东省中山市",
"861454814", "广东省广州市",
"86139687", "浙江省温州市",
"861535297", "青海省海北藏族自治州",
"861813665", "江苏省南京市",
"86176856", "山东省淄博市",
"861339206", "广东省江门市",
"861700404", "广东省东莞市",
"86145084", "江苏省苏州市",
"861390056", "安徽省合肥市",
"861881479", "黑龙江省大庆市",
"861800671", "浙江省杭州市",
"861332495", "云南省大理白族自治州",
"861551461", "河南省周口市",
"861870874", "云南省曲靖市",
"861301486", "广西桂林市",
"861343755", "广东省茂名市",
"861356579", "新疆阿勒泰地区",
"861390790", "江西省新余市",
"86186413", "辽宁省抚顺市",
"861311416", "云南省临沧市",
"86156349", "山西省朔州市",
"86181011", "北京市",
"861303594", "云南省德宏傣族景颇族自治州",
"861478646", "湖南省衡阳市",
"861595987", "福建省泉州市",
"861508603", "贵州省贵阳市",
"861760796", "江西省吉安市",
"861880811", "四川省绵阳市",
"861510346", "山西省太原市",
"861325794", "江西省抚州市",
"861560533", "山东省淄博市",
"861477716", "广西北海市",
"86180018", "上海市",
"861362042", "广东省广州市",
"861863445", "山西省长治市",
"86750", "广东省江门市",
"861322052", "山东省东营市",
"861857512", "广东省茂名市",
"861359965", "福建省漳州市",
"861384956", "河南省平顶山市",
"861816283", "湖北省孝感市",
"861561506", "山东省东营市",
"861388460", "山东省淄博市",
"861379466", "广东省韶关市",
"861810470", "内蒙古呼伦贝尔市",
"861774840", "四川省南充市",
"861584641", "黑龙江省七台河市",
"861358473", "江苏省南通市",
"861776708", "浙江省杭州市",
"86155500", "山东省济南市",
"861339303", "河北省石家庄市",
"861333856", "福建省泉州市",
"861588479", "四川省泸州市",
"861869908", "新疆乌鲁木齐市",
"86130987", "重庆市",
"861357153", "陕西省渭南市",
"861818813", "贵州省安顺市",
"861810629", "江苏省南通市",
"86147809", "四川省广元市",
"861313278", "广西河池市",
"861368745", "广东省揭阳市",
"861310839", "四川省广元市",
"861561286", "河北省唐山市",
"861882671", "广东省阳江市",
"861816503", "陕西省渭南市",
"861806195", "江苏省连云港市",
"861330791", "江西省南昌市",
"861552669", "吉林省白城市",
"861890892", "西藏日喀则地区",
"86130329", "陕西省西安市",
"861367615", "广东省江门市",
"861350810", "四川省绵阳市",
"86185948", "重庆市",
"861771540", "江苏省无锡市",
"861508097", "湖南省岳阳市",
"861301164", "山东省淄博市",
"861323877", "云南省玉溪市",
"861808883", "广东省佛山市",
"861317297", "广东省韶关市",
"861817199", "湖北省荆门市",
"861339586", "浙江省台州市",
"86139233", "广东省中山市",
"861824074", "河南省周口市",
"86137910", "山东省济南市",
"861868506", "贵州省黔南布依族苗族自治州",
"861331753", "湖北省襄樊市",
"861300826", "辽宁省锦州市",
"861800636", "山东省济南市",
"861556560", "河南省焦作市",
"861577941", "江西省九江市",
"861313709", "河南省南阳市",
"861334962", "湖南省常德市",
"861355936", "福建省泉州市",
"861364819", "四川省达州市",
"861893459", "江苏省苏州市",
"86134238", "广东省深圳市",
"861822896", "四川省泸州市",
"861539794", "江西省抚州市",
"861362580", "浙江省衢州市",
"86159707", "江西省赣州市",
"861510243", "辽宁省丹东市",
"861806316", "山东省临沂市",
"861500423", "辽宁省锦州市",
"861360326", "河北省廊坊市",
"861379184", "山东省青岛市",
"861361519", "江苏省泰州市",
"861478569", "贵州省遵义市",
"861572237", "青海省海西蒙古族藏族自治州",
"861340942", "河南省商丘市",
"861582035", "广东省梅州市",
"861337591", "福建省福州市",
"861522044", "广东省汕头市",
"861304319", "河北省邢台市",
"861458143", "浙江省台州市",
"861390770", "广西防城港市",
"861537226", "浙江省丽水市",
"861868930", "广东省佛山市",
"861332475", "广西贵港市",
"861820616", "江苏省无锡市",
"861800691", "福建省福州市",
"86156347", "山东省淄博市",
"861807121", "湖北省黄冈市",
"861454808", "广东省珠海市",
"861587109", "湖北省十堰市",
"861355500", "黑龙江省牡丹江市",
"861355991", "福建省宁德市",
"861869958", "新疆哈密地区",
"861333806", "江苏省南通市",
"861859454", "福建省莆田市",
"861776758", "新疆伊犁哈萨克自治州",
"861339353", "山西省阳泉市",
"86155505", "山东省东营市",
"861322621", "广东省梅州市",
"861328705", "山东省菏泽市",
"861570046", "四川省广元市",
"86187692", "山东省枣庄市",
"861533403", "湖北省荆门市",
"861572888", "广东省江门市",
"861337536", "山东省潍坊市",
"861576685", "广东省湛江市",
"861535277", "新疆阿克苏地区",
"861453630", "江苏省南京市",
"861324339", "河南省驻马店市",
"86139689", "浙江省温州市",
"86185743", "湖南省湘西土家族苗族自治州",
"861333085", "四川省德阳市",
"861331703", "江西省上饶市",
"861898947", "浙江省杭州市",
"86137915", "山东省临沂市",
"86135606", "广东省中山市",
"861336525", "江苏省宿迁市",
"861520765", "广东省佛山市",
"861470961", "宁夏银川市",
"861889332", "甘肃省平凉市",
"861893409", "广东省揭阳市",
"861824269", "辽宁省营口市",
"861313759", "河南省开封市",
"861770943", "甘肃省白银市",
"861512194", "宁夏固原市",
"86184694", "云南省保山市",
"861599921", "新疆阿克苏地区",
"861325920", "陕西省渭南市",
"861830013", "广东省清远市",
"861330736", "湖南省常德市",
"861707421", "浙江省杭州市",
"861768079", "湖南省邵阳市",
"861337950", "陕西省西安市",
"861320889", "云南省昆明市",
"861760776", "广西百色市",
"861788916", "西藏那曲地区",
"861323693", "辽宁省大连市",
"861778672", "湖北省随州市",
"861450656", "黑龙江省鹤岗市",
"861596936", "云南省丽江市",
"861526537", "山东省济宁市",
"861810318", "河北省衡水市",
"861300974", "黑龙江省齐齐哈尔市",
"861813748", "河南省商丘市",
"861800388", "河南省洛阳市",
"861868275", "四川省成都市",
"861898451", "贵州省黔东南苗族侗族自治州",
"861897171", "湖北省黄冈市",
"861822790", "四川省资阳市",
"861319764", "广西桂林市",
"861812835", "广东省茂名市",
"861316828", "广东省河源市",
"861505647", "安徽省芜湖市",
"861357516", "湖南省常德市",
"861327764", "湖北省荆门市",
"861806041", "福建省宁德市",
"861599348", "河南省驻马店市",
"861859390", "广西防城港市",
"861517561", "河北省唐山市",
"861839040", "湖南省益阳市",
"86152858", "贵州省六盘水市",
"861879462", "甘肃省平凉市",
"861860888", "云南省丽江市",
"86139600", "福建省漳州市",
"861335028", "四川省达州市",
"861508857", "浙江省温州市",
"861596550", "山东省菏泽市",
"861539868", "云南省昭通市",
"861595788", "浙江省宁波市",
"86147885", "河南省新乡市",
"861857993", "广西柳州市",
"861804838", "内蒙古鄂尔多斯市",
"86187008", "陕西省西安市",
"861304628", "广东省茂名市",
"86182120", "贵州省遵义市",
"861855101", "江苏省连云港市",
"861329959", "宁夏固原市",
"86152460", "黑龙江省大庆市",
"861371714", "广东省深圳市",
"861368282", "广东省揭阳市",
"861890052", "安徽省蚌埠市",
"861852721", "湖北省荆门市",
"861709425", "广东省江门市",
"861318030", "河北省沧州市",
"861333096", "四川省成都市",
"86186528", "江苏省镇江市",
"861306955", "河南省漯河市",
"861536970", "河北省秦皇岛市",
"861320564", "安徽省六安市",
"861387283", "湖北省十堰市",
"861510761", "广东省中山市",
"861358019", "广东省揭阳市",
"861317959", "江苏省连云港市",
"861893617", "江苏省南通市",
"861536724", "湖南省郴州市",
"861821284", "贵州省六盘水市",
"861334933", "黑龙江省双鸭山市",
"86134782", "辽宁省沈阳市",
"861524684", "黑龙江省鹤岗市",
"861811412", "江苏省泰州市",
"861319058", "内蒙古乌海市",
"86147168", "广东省广州市",
"86151634", "山东省莱芜市",
"86187999", "新疆阿克苏地区",
"861450606", "吉林省白山市",
"861519210", "山东省枣庄市",
"861580374", "河南省许昌市",
"861806186", "江苏省盐城市",
"861830479", "内蒙古锡林郭勒盟",
"861577457", "黑龙江省大兴安岭地区",
"861318751", "云南省保山市",
"861816116", "四川省广安市",
"861393448", "山西省阳泉市",
"86139982", "辽宁省沈阳市",
"861568544", "贵州省黔东南苗族侗族自治州",
"861870768", "广东省揭阳市",
"861332164", "广西贺州市",
"861471604", "广东省东莞市",
"861369611", "四川省泸州市",
"861514634", "黑龙江省大庆市",
"861476258", "江苏省南通市",
"86151446", "吉林省四平市",
"861811234", "江苏省常州市",
"861531400", "山东省日照市",
"861533682", "浙江省舟山市",
"861835593", "安徽省亳州市",
"861890240", "广东省广州市",
"861322872", "江苏省宿迁市",
"861300867", "云南省昆明市",
"86134211", "广东省揭阳市",
"861372566", "广东省河源市",
"86188231", "广东省佛山市",
"861760870", "云南省昭通市",
"861390876", "云南省文山壮族苗族自治州",
"861347312", "河北省保定市",
"861825244", "江苏省宿迁市",
"861877568", "广西柳州市",
"861596500", "山东省日照市",
"861508807", "广东省广州市",
"861335916", "陕西省汉中市",
"861571260", "浙江省嘉兴市",
"861887112", "湖北省随州市",
"86139605", "福建省三明市",
"86131822", "江苏省泰州市",
"861576631", "广东省肇庆市",
"861516587", "山东省枣庄市",
"861560614", "江苏省常州市",
"86152465", "黑龙江省绥化市",
"86150702", "江西省九江市",
"861333700", "内蒙古巴彦淖尔市",
"86147880", "云南省西双版纳傣族自治州",
"861573741", "河南省濮阳市",
"861359843", "河南省郑州市",
"861339595", "福建省泉州市",
"861306905", "吉林省松原市",
"861590473", "内蒙古乌海市",
"861334380", "河南省新乡市",
"861815222", "甘肃省定西市",
"86130844", "四川省成都市",
"86155589", "浙江省温州市",
"861302753", "河南省洛阳市",
"861452341", "河南省洛阳市",
"861831811", "广东省江门市",
"861822885", "四川省巴中市",
"861317909", "吉林省延边朝鲜族自治州",
"861570311", "河北省石家庄市",
"861576628", "广东省肇庆市",
"861341582", "广东省茂名市",
"861572825", "广东省深圳市",
"86151871", "云南省文山壮族苗族自治州",
"861847679", "广东省汕尾市",
"86151764", "河北省石家庄市",
"861373481", "内蒙古呼和浩特市",
"861811599", "江苏省连云港市",
"861780432", "吉林省吉林市",
"861475561", "安徽省合肥市",
"861337810", "四川省成都市",
"86187901", "河南省信阳市",
"861777140", "湖北省黄石市",
"86150878", "云南省临沧市",
"861503647", "河南省三门峡市",
"861780588", "浙江省丽水市",
"861516493", "内蒙古通辽市",
"861558960", "山东省烟台市",
"861834731", "内蒙古鄂尔多斯市",
"861394832", "内蒙古包头市",
"861762522", "江苏省常州市",
"861779706", "青海省海东地区",
"861890375", "河南省平顶山市",
"861320520", "江苏省常州市",
"861591222", "云南省丽江市",
"861351553", "安徽省芜湖市",
"861510971", "青海省西宁市",
"861364909", "四川省广安市",
"861536760", "湖南省娄底市",
"86152964", "广西南宁市",
"861359786", "湖北省十堰市",
"861509761", "河北省廊坊市",
"861802590", "广东省东莞市",
"861330153", "江苏省无锡市",
"861818903", "西藏山南地区",
"861319974", "新疆阿克苏地区",
"861867217", "湖北省荆门市",
"861770980", "辽宁省鞍山市",
"861304696", "福建省泉州市",
"861322503", "福建省厦门市",
"86139294", "广东省东莞市",
"861300764", "河南省开封市",
"86186328", "河北省衡水市",
"861350900", "广东省东莞市",
"861346612", "云南省曲靖市",
"861372071", "陕西省榆林市",
"861590257", "贵州省毕节地区",
"861760927", "陕西省宝鸡市",
"861355346", "广东省湛江市",
"86181106", "安徽省六安市",
"861319720", "湖北省恩施土家族苗族自治州",
"861829695", "江西省宜春市",
"861303123", "新疆巴音郭楞蒙古自治州",
"86156746", "湖南省永州市",
"861571781", "湖北省随州市",
"861827388", "湖南省岳阳市",
"861327974", "新疆伊犁哈萨克自治州",
"861358148", "湖北省宜昌市",
"861336432", "吉林省吉林市",
"861568496", "湖南省永州市",
"861308393", "浙江省温州市",
"861327720", "湖北省黄冈市",
"861877440", "湖南省益阳市",
"861336588", "湖南省衡阳市",
"861340332", "河北省保定市",
"861853845", "河南省南阳市",
"861584809", "内蒙古呼伦贝尔市",
"861457108", "江苏省徐州市",
"861535682", "浙江省湖州市",
"861304631", "广东省中山市",
"861536827", "云南省昭通市",
"86134626", "河南省南阳市",
"861868340", "四川省德阳市",
"861504082", "辽宁省抚顺市",
"861314048", "河南省洛阳市",
"86136017", "上海市",
"861350536", "山东省潍坊市",
"861779090", "辽宁省大连市",
"861780799", "江西省萍乡市",
"861539673", "江苏省盐城市",
"861880570", "浙江省衢州市",
"861896547", "福建省漳州市",
"861300008", "湖北省武汉市",
"861898169", "四川省巴中市",
"861554406", "河南省信阳市",
"86152002", "湖南省岳阳市",
"861771583", "江苏省扬州市",
"86159306", "河北省廊坊市",
"861852738", "湖北省黄冈市",
"861345542", "山东省东营市",
"861820399", "河南省郑州市",
"861324949", "广东省汕头市",
"861595412", "山东省济南市",
"861364959", "宁夏吴忠市",
"861351503", "福建省泉州市",
"861801521", "江苏省南通市",
"861787599", "广东省阳江市",
"861870978", "青海省西宁市",
"861805650", "安徽省芜湖市",
"861321923", "四川省遂宁市",
"861370384", "河南省郑州市",
"86187852", "贵州省遵义市",
"861362543", "山东省滨州市",
"86184061", "辽宁省丹东市",
"861312336", "福建省厦门市",
"861322553", "安徽省芜湖市",
"861577115", "湖北省荆州市",
"861357736", "云南省曲靖市",
"861539057", "甘肃省酒泉市",
"861896304", "山东省日照市",
"861308276", "山东省德州市",
"861317268", "河北省邢台市",
"861834050", "辽宁省葫芦岛市",
"861888289", "四川省凉山彝族自治州",
"861770333", "河北省秦皇岛市",
"861350950", "福建省南平市",
"86155389", "河南省焦作市",
"861332120", "甘肃省兰州市",
"861889942", "新疆哈密地区",
"861813222", "河北省保定市",
"861458180", "浙江省湖州市",
"861319867", "四川省绵阳市",
"861302045", "内蒙古巴彦淖尔市",
"861803442", "河北省秦皇岛市",
"86138613", "江苏省镇江市",
"861861476", "内蒙古赤峰市",
"86184633", "山东省日照市",
"861351386", "河南省驻马店市",
"861335700", "浙江省衢州市",
"861358999", "山东省东营市",
"861830664", "广东省湛江市",
"861360681", "浙江省杭州市",
"861816621", "湖南省怀化市",
"861823244", "河北省承德市",
"86155927", "陕西省宝鸡市",
"861333916", "安徽省池州市",
"861776613", "江苏省淮安市",
"861336799", "江西省萍乡市",
"861564561", "黑龙江省大庆市",
"861529076", "河南省平顶山市",
"861562797", "广东省汕尾市",
"861331329", "河北省唐山市",
"861571735", "湖南省郴州市",
"861570639", "山东省青岛市",
"861361492", "辽宁省鞍山市",
"861394863", "内蒙古赤峰市",
"86158186", "广东省深圳市",
"861535453", "吉林省延边朝鲜族自治州",
"861334772", "江苏省南京市",
"861325877", "吉林省通化市",
"861458310", "江西省萍乡市",
"861308555", "安徽省马鞍山市",
"861590999", "新疆伊犁哈萨克自治州",
"861831951", "广东省河源市",
"861315278", "山西省吕梁市",
"861319826", "四川省泸州市",
"86189611", "江苏省常州市",
"86137414", "辽宁省本溪市",
"86155300", "河北省邯郸市",
"86138068", "浙江省温州市",
"861328043", "山东省临沂市",
"861890283", "广东省深圳市",
"861358207", "河北省保定市",
"861327826", "吉林省白城市",
"86158456", "黑龙江省齐齐哈尔市",
"861452996", "内蒙古鄂尔多斯市",
"861869269", "湖南省永州市",
"861599938", "新疆和田地区",
"861781686", "浙江省杭州市",
"861356234", "山东省滨州市",
"861338646", "山东省潍坊市",
"861834785", "内蒙古巴彦淖尔市",
"861807138", "湖北省荆门市",
"861316056", "广东省清远市",
"861331045", "贵州省黔东南苗族侗族自治州",
"861351395", "河南省驻马店市",
"861532361", "广东省珠海市",
"861322638", "广东省阳江市",
"86152698", "山东省泰安市",
"861809470", "浙江省杭州市",
"861840371", "河南省郑州市",
"861340363", "山西省大同市",
"861378489", "河北省邢台市",
"861550267", "辽宁省锦州市",
"861788806", "西藏那曲地区",
"861528937", "陕西省西安市",
"861353936", "广东省潮州市",
"86188432", "吉林省吉林市",
"86134412", "广东省深圳市",
"861348794", "湖南省衡阳市",
"861895459", "山东省烟台市",
"861870797", "江西省赣州市",
"861830993", "新疆石河子市",
"861309839", "湖北省黄石市",
"861700782", "广东省汕头市",
"861360398", "河南省郑州市",
"861536866", "云南省德宏傣族景颇族自治州",
"861373435", "山东省临沂市",
"861809629", "四川省自贡市",
"861824958", "黑龙江省大庆市",
"861354093", "四川省南充市",
"861318193", "山东省淄博市",
"861308505", "安徽省合肥市",
"861535403", "河北省张家口市",
"861360635", "山东省聊城市",
"861520975", "青海省果洛藏族自治州",
"861470771", "广西南宁市",
"861361739", "湖南省邵阳市",
"861380654", "浙江省温州市",
"861860825", "四川省遂宁市",
"861533277", "内蒙古鄂尔多斯市",
"86151693", "山东省淄博市",
"861357830", "云南省临沧市",
"861387002", "江西省鹰潭市",
"861313323", "山西省阳泉市",
"861558382", "四川省德阳市",
"861317819", "福建省莆田市",
"861869074", "贵州省贵阳市",
"861800325", "河北省唐山市",
"861368003", "广东省清远市",
"861366315", "河北省唐山市",
"861508917", "广东省珠海市",
"861325964", "宁夏固原市",
"861804672", "江西省九江市",
"861763527", "山西省临汾市",
"86155305", "河北省唐山市",
"861367389", "河南省南阳市",
"861335806", "江苏省南通市",
"861819118", "陕西省延安市",
"861857479", "湖南省娄底市",
"861322395", "河南省周口市",
"861521474", "浙江省金华市",
"861351638", "山东省潍坊市",
"861885827", "浙江省杭州市",
"86136196", "云南省昆明市",
"861518987", "江苏省扬州市",
"86147891", "湖南省益阳市",
"861323774", "广西贺州市",
"861829686", "江西省赣州市",
"861855793", "浙江省绍兴市",
"861597988", "江西省新余市",
"86132437", "广东省深圳市",
"861339729", "湖北省十堰市",
"861568485", "新疆阿勒泰地区",
"861709488", "浙江省杭州市",
"861819691", "新疆哈密地区",
"861816872", "江苏省苏州市",
"861323920", "陕西省延安市",
"861390960", "安徽省滁州市",
"861884812", "内蒙古包头市",
"861895409", "山东省济宁市",
"861800049", "河北省邢台市",
"861893161", "河北省邯郸市",
"861538132", "浙江省丽水市",
"861817686", "广西南宁市",
"861500565", "安徽省合肥市",
"861556448", "山东省日照市",
"861387240", "湖北省荆州市",
"86145342", "辽宁省大连市",
"861770362", "黑龙江省齐齐哈尔市",
"861374975", "河南省信阳市",
"861588320", "四川省资阳市",
"861367315", "河北省唐山市",
"861809753", "新疆石河子市",
"861366389", "河南省洛阳市",
"86151009", "河北省邢台市",
"861583190", "河北省邢台市",
"861342171", "广东省湛江市",
"861377253", "陕西省西安市",
"861810329", "河北省邢台市",
"861329885", "吉林省通化市",
"861453983", "广东省深圳市",
"861300266", "浙江省台州市",
"861550281", "四川省成都市",
"861589437", "云南省迪庆藏族自治州",
"861814816", "四川省遂宁市",
"861826118", "江苏省常州市",
"86151793", "江西省上饶市",
"861356830", "四川省眉山市",
"86188005", "江苏省无锡市",
"86156010", "北京市",
"861332252", "西藏日喀则地区",
"861384879", "内蒙古鄂尔多斯市",
"861804886", "四川省自贡市",
"861316819", "广东省阳江市",
"86189495", "安徽省芜湖市",
"861510569", "安徽省合肥市",
"86135920", "河南省洛阳市",
"861525097", "江苏省南京市",
"861304619", "广东省韶关市",
"861323555", "湖北省武汉市",
"861801303", "江苏省南京市",
"861351321", "河北省石家庄市",
"861810045", "黑龙江省哈尔滨市",
"861535770", "安徽省巢湖市",
"861860836", "四川省甘孜藏族自治州",
"861569922", "新疆乌鲁木齐市",
"861335019", "四川省宜宾市",
"86138931", "甘肃省兰州市",
"86136816", "上海市",
"86137299", "广东省东莞市",
"86183457", "黑龙江省哈尔滨市",
"861475979", "福建省厦门市",
"861303043", "内蒙古兴安盟",
"861311993", "新疆石河子市",
"861533112", "辽宁省大连市",
"861317006", "安徽省安庆市",
"861572051", "安徽省合肥市",
"861508206", "四川省泸州市",
"86134268", "广东省江门市",
"861476571", "四川省成都市",
"86189282", "广东省东莞市",
"861333148", "吉林省延边朝鲜族自治州",
"86139263", "广东省阳江市",
"861519954", "新疆阿勒泰地区",
"8614725", "四川省成都市",
"861817872", "广西桂林市",
"861800336", "河北省廊坊市",
"861454146", "吉林省白城市",
"861502963", "陕西省渭南市",
"861308774", "广西梧州市",
"861809703", "青海省黄南藏族自治州",
"861521137", "湖南省衡阳市",
"861573823", "河南省商丘市",
"861564979", "河南省三门峡市",
"861324639", "广东省珠海市",
"861453330", "浙江省杭州市",
"861594713", "内蒙古呼和浩特市",
"861375498", "山西省临汾市",
"861310590", "福建省龙岩市",
"861310901", "新疆昌吉回族自治州",
"861815833", "浙江省温州市",
"861826636", "山东省潍坊市",
"861596039", "福建省厦门市",
"861858593", "贵州省黔西南布依族苗族自治州",
"861812058", "湖北省武汉市",
"861308920", "吉林省辽源市",
"86188000", "北京市",
"861322321", "河北省保定市",
"861373426", "山西省长治市",
"861559542", "宁夏银川市",
"861471490", "广东省深圳市",
"861353925", "广东省揭阳市",
"861800391", "河南省焦作市",
"861822959", "湖南省邵阳市",
"861820316", "河北省廊坊市",
"861323505", "福建省漳州市",
"86150991", "新疆乌鲁木齐市",
"861342654", "江西省赣州市",
"86153889", "湖南省长沙市",
"86135925", "河南省郑州市",
"861319835", "四川省眉山市",
"861573549", "山西省晋中市",
"861787516", "广东省深圳市",
"861329056", "河北省石家庄市",
"86189490", "安徽省阜阳市",
"861352390", "河南省信阳市",
"861841917", "甘肃省酒泉市",
"861537866", "四川省资阳市",
"861317790", "江西省新余市",
"861571726", "湖北省恩施土家族苗族自治州",
"86151998", "新疆喀什地区",
"861479917", "新疆克拉玛依市",
"861332040", "云南省红河哈尼族彝族自治州",
"861339077", "江苏省南京市",
"861358916", "山东省潍坊市",
"861317056", "云南省怒江傈僳族自治州",
"861389822", "辽宁省铁岭市",
"861593516", "山西省吕梁市",
"861550970", "青海省海北藏族自治州",
"861327835", "吉林省通化市",
"861838151", "四川省乐山市",
"861378415", "河北省沧州市",
"861333999", "湖北省武汉市",
"861550724", "湖北省咸宁市",
"861844934", "新疆昌吉回族自治州",
"861836033", "江苏省扬州市",
"861336716", "湖北省荆州市",
"86158341", "山西省太原市",
"861812764", "广东省梅州市",
"861835655", "安徽省芜湖市",
"861821843", "广东省湛江市",
"861897547", "湖南省邵阳市",
"861580845", "四川省宜宾市",
"861330599", "福建省南平市",
"861554697", "广东省潮州市",
"86147534", "山东省德州市",
"861321404", "内蒙古兴安盟",
"86139419", "辽宁省辽阳市",
"86717", "湖北省宜昌市",
"861312325", "福建省宁德市",
"861860730", "湖南省岳阳市",
"861301202", "河北省沧州市",
"86136540", "辽宁省沈阳市",
"861572891", "西藏拉萨市",
"861590916", "陕西省汉中市",
"86137402", "广东省广州市",
"861800688", "浙江省温州市",
"861868402", "四川省成都市",
"861571767", "河北省邢台市",
"861515258", "江苏省淮安市",
"861339482", "内蒙古兴安盟",
"861537827", "四川省宜宾市",
"861811153", "四川省南充市",
"861587072", "江西省赣州市",
"861339538", "山东省泰安市",
"86134726", "上海市",
"861452919", "广东省茂名市",
"861338550", "贵州省贵阳市",
"861773269", "河北省秦皇岛市",
"861320905", "新疆阿克苏地区",
"861355988", "福建省三明市",
"861534752", "广东省韶关市",
"861335473", "内蒙古乌海市",
"86153800", "江苏省常州市",
"861810618", "江苏省无锡市",
"861365484", "内蒙古包头市",
"861348296", "河北省邢台市",
"861570949", "甘肃省陇南市",
"861479704", "青海省西宁市",
"861768102", "安徽省宿州市",
"861586605", "山东省济宁市",
"861361711", "湖北省鄂州市",
"861459733", "湖南省长沙市",
"86133006", "上海市",
"86184733", "湖南省长沙市",
"861778743", "云南省临沧市",
"86150558", "安徽省阜阳市",
"861867530", "广东省梅州市",
"861803300", "广东省东莞市",
"861350525", "江苏省扬州市",
"86189738", "湖南省娄底市",
"861373467", "青海省海西蒙古族藏族自治州",
"861568657", "陕西省铜川市",
"861593103", "河北省邯郸市",
"86151551", "安徽省合肥市",
"861317831", "福建省漳州市",
"861777613", "广西玉林市",
"861890747", "湖南省衡阳市",
"861528647", "贵州省六盘水市",
"861337799", "湖北省荆门市",
"86152378", "河南省开封市",
"86188089", "海南省海口市",
"861353646", "广东省汕尾市",
"861863800", "河南省郑州市",
"861577189", "陕西省铜川市",
"861786599", "山东省潍坊市",
"861519717", "湖南省湘潭市",
"861340014", "河北省邢台市",
"861304457", "福建省福州市",
"861522912", "陕西省榆林市",
"86184178", "陕西省西安市",
"86134404", "上海市",
"861505504", "安徽省阜阳市",
"861839475", "甘肃省酒泉市",
"86152430", "吉林省松原市",
"861392175", "江苏省徐州市",
"861361528", "江苏省镇江市",
"861516076", "福建省泉州市",
"861313501", "湖南省长沙市",
"861888215", "四川省眉山市",
"861313990", "新疆克拉玛依市",
"861338936", "甘肃省兰州市",
"861362958", "宁夏银川市",
"86151373", "河南省新乡市",
"861385947", "福建省南平市",
"861330788", "广西河池市",
"861533382", "河南省郑州市",
"861321454", "黑龙江省佳木斯市",
"861361444", "吉林省四平市",
"861351948", "甘肃省酒泉市",
"861327881", "湖南省永州市",
"861818424", "贵州省遵义市",
"861323276", "广东省河源市",
"861558277", "山西省吕梁市",
"861388161", "四川省雅安市",
"86187572", "浙江省湖州市",
"861846420", "山东省青岛市",
"861529493", "河南省驻马店市",
"86136545", "黑龙江省哈尔滨市",
"861804895", "四川省南充市",
"861571820", "广东省中山市",
"861348373", "河北省沧州市",
"861830320", "河北省邯郸市",
"861319881", "四川省南充市",
"861879527", "宁夏银川市",
"861477969", "江西省吉安市",
"861811103", "四川省南充市",
"86189933", "甘肃省平凉市",
"861801595", "江苏省镇江市",
"861700670", "浙江省温州市",
"861773074", "陕西省汉中市",
"861868452", "湖南省娄底市",
"861360667", "浙江省台州市",
"861502932", "陕西省榆林市",
"861356791", "浙江省宁波市",
"86138918", "陕西省西安市",
"86153805", "江苏省盐城市",
"861534702", "湖北省恩施土家族苗族自治州",
"861309811", "陕西省咸阳市",
"861320955", "宁夏中卫市",
"861776140", "四川省成都市",
"861329896", "西藏那曲地区",
"861815862", "浙江省台州市",
"861570198", "新疆克拉玛依市",
"861450306", "河北省衡水市",
"861564587", "黑龙江省伊春市",
"861333257", "湖南省益阳市",
"86139926", "陕西省汉中市",
"86150484", "内蒙古乌兰察布市",
"86156646", "陕西省西安市",
"861452641", "江苏省连云港市",
"861305080", "辽宁省铁岭市",
"861570611", "江苏省常州市",
"861530560", "安徽省合肥市",
"861889663", "江苏省连云港市",
"861566634", "山东省莱芜市",
"861768152", "浙江省绍兴市",
"861500814", "四川省自贡市",
"861315010", "甘肃省定西市",
"861510884", "云南省文山壮族苗族自治州",
"861875251", "江苏省泰州市",
"861326720", "广东省深圳市",
"861500537", "山东省济宁市",
"86184574", "浙江省宁波市",
"861337588", "浙江省丽水市",
"861572836", "广东省清远市",
"861334680", "河南省鹤壁市",
"861823840", "河南省南阳市",
"861560314", "河北省承德市",
"86152435", "湖南省郴州市",
"861348742", "湖南省湘西土家族苗族自治州",
"861471547", "广东省佛山市",
"861304407", "山东省济宁市",
"861812898", "广东省阳江市",
"861450583", "辽宁省辽阳市",
"86156434", "吉林省四平市",
"861362908", "四川省遂宁市",
"86131143", "湖北省武汉市",
"86151080", "广西玉林市",
"861313551", "安徽省合肥市",
"86180287", "广东省深圳市",
"86150154", "广东省东莞市",
"861807699", "西藏拉萨市",
"86156935", "甘肃省武威市",
"861775269", "湖南省娄底市",
"861835109", "江苏省宿迁市",
"861598432", "四川省眉山市",
"86152934", "甘肃省庆阳市",
"861363484", "黑龙江省齐齐哈尔市",
"861380490", "辽宁省沈阳市",
"86185477", "内蒙古鄂尔多斯市",
"861889878", "广东省汕尾市",
"861331318", "河北省衡水市",
"861890675", "浙江省绍兴市",
"861322686", "广东省深圳市",
"861450497", "辽宁省锦州市",
"86151734", "湖南省衡阳市",
"861887277", "湖北省黄石市",
"861503347", "河北省唐山市",
"86147071", "湖北省武汉市",
"861584931", "内蒙古乌海市",
"86136340", "浙江省台州市",
"86150985", "山东省烟台市",
"861807186", "湖北省黄石市",
"861510787", "广西钦州市",
"861532405", "河北省唐山市",
"861883298", "河北省唐山市",
"861590700", "江西省南昌市",
"861886960", "云南省昭通市",
"861308693", "贵州省黔南布依族苗族自治州",
"861332083", "四川省达州市",
"861783500", "山西省忻州市",
"861362074", "吉林省吉林市",
"861315990", "黑龙江省双鸭山市",
"861340632", "山东省枣庄市",
"861302188", "河北省石家庄市",
"861390682", "浙江省湖州市",
"86156170", "河南省商丘市",
"861824580", "黑龙江省大庆市",
"861364896", "西藏那曲地区",
"86151351", "山西省太原市",
"861346312", "河北省保定市",
"861821880", "广东省深圳市",
"861375467", "山东省滨州市",
"861787830", "广西河池市",
"861330412", "辽宁省鞍山市",
"861896654", "陕西省咸阳市",
"86152578", "浙江省宁波市",
"861891208", "江苏省淮安市",
"861476027", "福建省龙岩市",
"86139705", "江西省宜春市",
"861800946", "甘肃省兰州市",
"861304396", "河南省驻马店市",
"861324311", "河南省漯河市",
"86150602", "福建省宁德市",
"861819688", "新疆阿克苏地区",
"86150358", "山西省吕梁市",
"861571977", "青海省海西蒙古族藏族自治州",
"861709491", "浙江省金华市",
"861820699", "云南省大理白族自治州",
"861453940", "广东省阳江市",
"861817638", "广西梧州市",
"861317828", "福建省宁德市",
"861814530", "黑龙江省牡丹江市",
"861881416", "广东省江门市",
"861515969", "福建省漳州市",
"861598799", "云南省普洱市",
"861835159", "江苏省宿迁市",
"861530524", "江苏省宿迁市",
"861335257", "黑龙江省大兴安岭地区",
"861813862", "广东省韶关市",
"861302629", "江西省宜春市",
"861773958", "河南省周口市",
"86189151", "江苏省淮安市",
"861326764", "广东省中山市",
"861807041", "江西省南昌市",
"861311479", "广西北海市",
"861827129", "湖北省宜昌市",
"861890844", "湖南省衡阳市",
"861470579", "浙江省金华市",
"861361531", "山东省济南市",
"861459513", "云南省临沧市",
"86187372", "河南省安阳市",
"861325276", "辽宁省抚顺市",
"861527537", "山东省济宁市",
"861388409", "甘肃省金昌市",
"861329828", "河南省三门峡市",
"86132344", "吉林省长春市",
"861539373", "河南省洛阳市",
"861452099", "安徽省马鞍山市",
"861535382", "陕西省铜川市",
"861590750", "广东省江门市",
"861304331", "吉林省长春市",
"861819129", "陕西省榆林市",
"86151573", "浙江省嘉兴市",
"861811830", "江苏省徐州市",
"861532455", "安徽省安庆市",
"861330234", "广东省韶关市",
"86189668", "陕西省西安市",
"861816321", "广东省清远市",
"861307955", "宁夏吴忠市",
"861539231", "福建省三明市",
"861814956", "福建省福州市",
"861316959", "广东省惠州市",
"861846464", "山东省潍坊市",
"861537724", "湖北省恩施土家族苗族自治州",
"861304273", "湖北省鄂州市",
"861539742", "浙江省温州市",
"86156175", "河南省郑州市",
"861580469", "黑龙江省双鸭山市",
"861351686", "浙江省台州市",
"861360381", "河南省三门峡市",
"861350463", "黑龙江省牡丹江市",
"861850471", "内蒙古呼和浩特市",
"861571864", "贵州省黔南布依族苗族自治州",
"861566012", "河南省新乡市",
"86139700", "江西省南昌市",
"861770633", "山东省日照市",
"861313010", "辽宁省本溪市",
"861781116", "宁夏石嘴山市",
"861595153", "江苏省宿迁市",
"86184374", "河南省许昌市",
"861370684", "浙江省宁波市",
"861520737", "湖南省益阳市",
"861306520", "辽宁省铁岭市",
"861522092", "广东省中山市",
"861860510", "江苏省无锡市",
"86183641", "山东省济南市",
"861477779", "广西南宁市",
"861339521", "江苏省淮安市",
"861303080", "福建省三明市",
"86138011", "北京市",
"861761430", "吉林省长春市",
"861809045", "四川省遂宁市",
"86189013", "北京市",
"861550827", "四川省巴中市",
"86147593", "福建省宁德市",
"86187792", "江西省九江市",
"861331470", "内蒙古呼伦贝尔市",
"861509569", "甘肃省天水市",
"86138038", "河南省郑州市",
"861336536", "山东省潍坊市",
"86177021", "上海市",
"861568592", "贵州省毕节地区",
"861774244", "陕西省榆林市",
"861392679", "广东省汕头市",
"861576619", "广东省深圳市",
"861364790", "江西省抚州市",
"861459106", "广西柳州市",
"861501455", "广东省梅州市",
"861816948", "湖南省娄底市",
"86139789", "广西北海市",
"861869543", "宁夏吴忠市",
"861582918", "陕西省咸阳市",
"861500954", "宁夏固原市",
"861378107", "河南省平顶山市",
"86754", "广东省汕头市\、潮阳市",
"861846213", "山东省济宁市",
"861391249", "江苏省无锡市",
"861829553", "宁夏吴忠市",
"861831839", "广东省河源市",
"861330725", "湖北省黄冈市",
"861811791", "四川省成都市",
"861826049", "江苏省常州市",
"861458610", "湖北省荆门市",
"861780950", "宁夏银川市",
"861360698", "福建省漳州市",
"861380547", "山东省济宁市",
"86184794", "江西省抚州市",
"861554552", "黑龙江省绥化市",
"861479097", "安徽省蚌埠市",
"861833605", "河南省商丘市",
"861335148", "黑龙江省伊春市",
"861825292", "江苏省盐城市",
"861319266", "广东省佛山市",
"861571589", "浙江省湖州市",
"861368377", "河南省南阳市",
"86138483", "内蒙古乌海市",
"861309951", "宁夏银川市",
"861359738", "广西玉林市",
"861320815", "四川省资阳市",
"861805494", "福建省三明市",
"861336950", "宁夏银川市",
"861810753", "广东省梅州市",
"86150909", "湖北省宜昌市",
"861708360", "河南省郑州市",
"861840671", "广西梧州市",
"861341486", "广东省湛江市",
"861533770", "浙江省舟山市",
"861770558", "安徽省阜阳市",
"861529979", "新疆克拉玛依市",
"861369639", "山东省临沂市",
"86138153", "江苏省徐州市",
"86135706", "广东省珠海市",
"861869829", "辽宁省葫芦岛市",
"861337525", "江苏省盐城市",
"861333019", "江西省宜春市",
"861780536", "山东省潍坊市",
"86132829", "浙江省金华市",
"861338346", "山西省晋城市",
"861365545", "山东省烟台市",
"861325555", "山东省青岛市",
"861580793", "江西省上饶市",
"861396570", "安徽省阜阳市",
"861350799", "江西省萍乡市",
"861391436", "江苏省南通市",
"861590806", "山东省日照市",
"861532661", "黑龙江省哈尔滨市",
"8618876", "海南省海口市",
"861351338", "河北省石家庄市",
"861522852", "四川省广安市",
"861314196", "湖南省邵阳市",
"861807195", "湖北省十堰市",
"861815100", "江苏省南京市",
"861362818", "四川省乐山市",
"861459156", "广西北海市",
"861825746", "浙江省金华市",
"861375426", "浙江省丽水市",
"861804372", "吉林省吉林市",
"861367689", "浙江省绍兴市",
"861313623", "浙江省嘉兴市",
"861829503", "宁夏吴忠市",
"861377477", "福建省宁德市",
"861357788", "云南省大理白族自治州",
"861328574", "浙江省宁波市",
"861865090", "福建省泉州市",
"861558682", "湖北省襄樊市",
"861500904", "新疆和田地区",
"861864872", "内蒙古呼和浩特市",
"861705022", "河北省石家庄市",
"861360335", "河北省秦皇岛市",
"861879071", "河南省三门峡市",
"861380354", "江西省南昌市",
"861361585", "浙江省绍兴市",
"861358700", "浙江省衢州市",
"861335999", "黑龙江省哈尔滨市",
"861571798", "江西省景德镇市",
"86158541", "山东省济南市",
"861554502", "黑龙江省齐齐哈尔市",
"861889014", "湖南省郴州市",
"861314315", "河北省廊坊市",
"861770662", "浙江省宁波市",
"86150714", "湖北省武汉市",
"861810703", "江西省上饶市",
"861336900", "新疆昌吉回族自治州",
"861336591", "福建省福州市",
"861304385", "辽宁省朝阳市",
"861309901", "山西省运城市",
"861859923", "新疆石河子市",
"861390453", "黑龙江省牡丹江市",
"86134327", "广东省汕尾市",
"861583062", "河北省廊坊市",
"861452859", "甘肃省兰州市",
"861301083", "重庆市",
"861303705", "山西省阳泉市",
"861383401", "山西省吕梁市",
"86132467", "广东省深圳市",
"861770508", "福建省泉州市",
"861576941", "甘肃省兰州市",
"861350432", "吉林省长春市",
"861590856", "贵州省铜仁地区",
"861325505", "福建省福州市",
"861350588", "浙江省宁波市",
"86159607", "福建省泉州市",
"86137201", "湖北省武汉市",
"861554598", "黑龙江省哈尔滨市",
"861894540", "黑龙江省佳木斯市",
"861560895", "西藏昌都地区",
"861360652", "浙江省杭州市",
"861853182", "河北省廊坊市",
"861390301", "广东省广州市",
"861569956", "吉林省长春市",
"86835", "四川省雅安市",
"861571702", "江西省九江市",
"861865248", "江苏省无锡市",
"861825258", "江苏省镇江市",
"861538841", "四川省雅安市",
"861529946", "新疆乌鲁木齐市",
"861847011", "江西省鹰潭市",
"861815857", "浙江省宁波市",
"861338379", "河南省洛阳市",
"861531520", "山东省淄博市",
"861520618", "江苏省无锡市",
"861812160", "江苏省连云港市",
"861302975", "黑龙江省齐齐哈尔市",
"861532950", "贵州省贵阳市",
"86186660", "广东省广州市",
"861837228", "湖北省襄樊市",
"861453445", "辽宁省朝阳市",
"861770592", "福建省厦门市",
"861800587", "浙江省温州市",
"861534820", "四川省泸州市",
"861339637", "山东省枣庄市",
"861503903", "河南省开封市",
"861839827", "四川省雅安市",
"861500395", "河南省漯河市",
"861591754", "广东省肇庆市",
"861309660", "山西省朔州市",
"86159574", "浙江省宁波市",
"861378800", "广西防城港市",
"861801169", "四川省南充市",
"861553359", "河北省唐山市",
"86136708", "广东省梅州市",
"861301267", "山东省枣庄市",
"861866684", "广东省茂名市",
"861399793", "湖北省荆门市",
"861317194", "河北省廊坊市",
"86181430", "吉林省长春市",
"861570860", "贵州省贵阳市",
"861353175", "广东省中山市",
"861569530", "青海省海北藏族自治州",
"86185627", "山东省青岛市",
"861519621", "四川省阿坝藏族羌族自治州",
"86159938", "河南省安阳市",
"861780661", "广东省韶关市",
"861372619", "广东省江门市",
"861596679", "山东省威海市",
"861458286", "福建省莆田市",
"861528548", "贵州省黔西南布依族苗族自治州",
"861802982", "广东省肇庆市",
"861772997", "安徽省六安市",
"861341990", "河南省南阳市",
"861814384", "西藏山南地区",
"861879189", "陕西省渭南市",
"861314978", "辽宁省锦州市",
"861766549", "广东省深圳市",
"861817717", "广西崇左市",
"861476244", "江苏省南京市",
"861535651", "浙江省温州市",
"861818965", "甘肃省兰州市",
"86180371", "河南省郑州市",
"861537475", "内蒙古通辽市",
"861308170", "辽宁省营口市",
"861322565", "安徽省合肥市",
"861872005", "江西省南昌市",
"86181378", "河南省郑州市",
"861373402", "山西省太原市",
"86130499", "浙江省金华市",
"86182551", "安徽省合肥市",
"861777792", "广西北海市",
"86159178", "广东省江门市",
"861308532", "云南省普洱市",
"861809737", "青海省海西蒙古族藏族自治州",
"861370899", "山东省青岛市",
"861571752", "湖南省娄底市",
"861569906", "新疆阿勒泰地区",
"861390351", "山西省太原市",
"861308488", "陕西省汉中市",
"861862766", "湖南省衡阳市",
"861475129", "江苏省宿迁市",
"861827493", "湖南省永州市",
"86133102", "重庆市",
"86186665", "广东省佛山市",
"861318418", "山东省威海市",
"861845830", "浙江省杭州市",
"861367054", "广东省汕头市",
"861351565", "安徽省合肥市",
"861534767", "广东省梅州市",
"861532900", "贵州省贵阳市",
"861327044", "江苏省南京市",
"861329022", "山东省枣庄市",
"86159733", "湖南省株洲市",
"861528424", "河北省唐山市",
"861591704", "广东省韶关市",
"861472709", "浙江省绍兴市",
"861360568", "安徽省亳州市",
"86182373", "河南省新乡市",
"861508222", "四川省乐山市",
"861380995", "新疆乌鲁木齐市",
"861319044", "辽宁省锦州市",
"861389856", "辽宁省阜新市",
"861781717", "广东省茂名市",
"861317022", "安徽省蚌埠市",
"861813068", "安徽省阜阳市",
"861819493", "新疆伊犁哈萨克自治州",
"861378850", "广西南宁市",
"86180553", "安徽省芜湖市",
"86133361", "浙江省杭州市",
"861357669", "江西省赣州市",
"861513840", "河南省南阳市",
"861500638", "山东省聊城市",
"861393404", "山西省太原市",
"861477840", "广东省东莞市",
"861324264", "河北省唐山市",
"861337687", "浙江省温州市",
"861383586", "山西省运城市",
"861471648", "广东省深圳市",
"861560780", "广西南宁市",
"861306342", "安徽省六安市",
"86158439", "吉林省白山市",
"86134343", "广东省广州市",
"861315495", "四川省眉山市",
"861840916", "陕西省汉中市",
"861884029", "陕西省西安市",
"861509699", "云南省德宏傣族景颇族自治州",
"861570727", "湖北省恩施土家族苗族自治州",
"861373452", "黑龙江省佳木斯市",
"86182793", "江西省上饶市",
"861570766", "广东省云浮市",
"861836897", "甘肃省临夏回族自治州",
"861533523", "江苏省无锡市",
"86187316", "河北省廊坊市",
"861700701", "广东省佛山市",
"861800979", "青海省海西蒙古族藏族自治州",
"861396723", "浙江省舟山市",
"861380986", "广东省深圳市",
"861774027", "四川省南充市",
"861893843", "广东省肇庆市",
"86181993", "新疆和田地区",
"861551764", "河南省驻马店市",
"861365778", "广西河池市",
"86130202", "上海市",
"861522008", "广东省深圳市",
"86180415", "辽宁省大连市",
"861520329", "河北省邢台市",
"861593369", "河北省邢台市",
"861333233", "辽宁省辽阳市",
"861865107", "江苏省南通市",
"861533849", "广东省茂名市",
"861315486", "内蒙古赤峰市",
"861763331", "河北省保定市",
"861459707", "宁夏固原市",
"861776744", "新疆和田地区",
"861305416", "湖南省长沙市",
"861894497", "湖南省永州市",
"861500553", "安徽省芜湖市",
"86185382", "河南省郑州市",
"861587994", "江西省新余市",
"861859448", "福建省泉州市",
"861599490", "广东省汕头市",
"861593137", "河北省衡水市",
"861333371", "河南省郑州市",
"861829954", "新疆吐鲁番地区",
"861363968", "河南省濮阳市",
"861870615", "江苏省无锡市",
"86135674", "浙江省宁波市",
"861844713", "内蒙古乌海市",
"861454675", "广东省珠海市",
"861820569", "安徽省合肥市",
"861534726", "湖北省荆州市",
"861893529", "山西省晋城市",
"861897015", "江西省鹰潭市",
"861347469", "陕西省渭南市",
"861321289", "黑龙江省大庆市",
"861558351", "四川省雅安市",
"861370009", "辽宁省大连市",
"861389700", "青海省海北藏族自治州",
"861537164", "江苏省徐州市",
"861705828", "浙江省杭州市",
"861850373", "河南省新乡市",
"861330474", "内蒙古兴安盟",
"861360483", "黑龙江省牡丹江市",
"861512959", "陕西省延安市",
"861510316", "河北省廊坊市",
"861880841", "四川省遂宁市",
"861883040", "河北省承德市",
"861477746", "广西百色市",
"861896938", "浙江省金华市",
"861776411", "湖北省黄冈市",
"861768126", "安徽省安庆市",
"861332267", "广东省汕尾市",
"861760434", "吉林省四平市",
"861700751", "广东省惠州市",
"861318370", "四川省攀枝花市",
"861514829", "内蒙古兴安盟",
"861863415", "河北省唐山市",
"861560886", "云南省怒江傈僳族自治州",
"861811137", "四川省达州市",
"861479100", "陕西省咸阳市",
"861308563", "浙江省嘉兴市",
"861859524", "山东省济南市",
"861535465", "吉林省通化市",
"861394855", "内蒙古通辽市",
"861502520", "云南省红河哈尼族彝族自治州",
"861331975", "新疆塔城地区",
"86180410", "辽宁省铁岭市",
"861522058", "广东省惠州市",
"861882999", "广东省广州市",
"861474313", "吉林省延边朝鲜族自治州",
"861516636", "山东省潍坊市",
"861470546", "山东省东营市",
"861707551", "安徽省合肥市",
"86180791", "江西省南昌市",
"861325249", "浙江省台州市",
"861825147", "江苏省镇江市",
"861865157", "江苏省无锡市",
"861813917", "新疆和田地区",
"861811369", "四川省广元市",
"861862860", "陕西省宝鸡市",
"861575205", "云南省西双版纳傣族自治州",
"861552516", "山西省长治市",
"861504836", "内蒙古呼和浩特市",
"861568633", "陕西省渭南市",
"861839866", "四川省成都市",
"86187157", "四川省泸州市",
"861312561", "辽宁省营口市",
"861829904", "新疆吐鲁番地区",
"861314797", "辽宁省朝阳市",
"861345013", "广东省茂名市",
"86145081", "江苏省南京市",
"86181798", "江西省景德镇市",
"86170022", "天津市",
"861802360", "广东省肇庆市",
"861304433", "吉林省延边朝鲜族自治州",
"861772778", "广东省云浮市",
"86187487", "贵州省六盘水市",
"861850742", "湖南省常德市",
"861340355", "山西省长治市",
"861393390", "河北省秦皇岛市",
"861389750", "青海省海北藏族自治州",
"861876111", "江苏省宿迁市",
"861336455", "吉林省四平市",
"861831982", "广东省潮州市",
"861558301", "四川省南充市",
"861370059", "山西省运城市",
"861539471", "内蒙古呼和浩特市",
"861311446", "湖北省宜昌市",
"861868426", "吉林省四平市",
"861880155", "江苏省苏州市",
"861816565", "广东省江门市",
"861519553", "江苏省盐城市",
"861529336", "甘肃省陇南市",
"861560372", "河南省安阳市",
"861318245", "江苏省泰州市",
"861335233", "辽宁省辽阳市",
"861768949", "福建省泉州市",
"861311594", "福建省莆田市",
"861538659", "四川省泸州市",
"861807569", "湖南省娄底市",
"861521791", "广东省佛山市",
"861516049", "福建省莆田市",
"86186498", "福建省福州市",
"86184607", "江西省南昌市",
"861840856", "贵州省铜仁地区",
"861367797", "江西省赣州市",
"861565140", "江苏省镇江市",
"861889593", "云南省保山市",
"861812802", "广东省东莞市",
"861530690", "福建省南平市",
"861882019", "广东省深圳市",
"861522867", "四川省遂宁市",
"861454747", "浙江省温州市",
"861399151", "陕西省安康市",
"861372115", "安徽省淮南市",
"861832451", "黑龙江省哈尔滨市",
"861537120", "江苏省盐城市",
"861308425", "河南省漯河市",
"861339365", "广西玉林市",
"86187516", "江苏省徐州市",
"861362992", "新疆乌鲁木齐市",
"861535523", "浙江省金华市",
"861353679", "广东省河源市",
"861477883", "广东省湛江市",
"861819979", "新疆哈密地区",
"861894356", "吉林省通化市",
"861867114", "湖北省恩施土家族苗族自治州",
"861380648", "山东省淄博市",
"861360597", "福建省三明市",
"861550475", "内蒙古通辽市",
"861800769", "广东省东莞市",
"861378910", "湖南省郴州市",
"861813097", "新疆阿克苏地区",
"861857211", "湖北省孝感市",
"86177546", "山东省东营市",
"861376891", "广西桂林市",
"861839235", "陕西省西安市",
"861580612", "江苏省常州市",
"861570976", "青海省玉树藏族自治州",
"861323491", "黑龙江省大庆市",
"86185582", "浙江省嘉兴市",
"861770657", "浙江省台州市",
"861829078", "新疆阿克苏地区",
"861563313", "河北省张家口市",
"861303416", "甘肃省白银市",
"86135563", "广东省汕头市",
"861515292", "江苏省镇江市",
"861372396", "山东省烟台市",
"861567829", "广西柳州市",
"861365968", "广西南宁市",
"861335371", "河南省郑州市",
"861595137", "江苏省宿迁市",
"861520753", "广东省梅州市",
"861586332", "山东省德州市",
"861363209", "广东省江门市",
"86138825", "四川省遂宁市",
"861534798", "江西省景德镇市",
"861313486", "内蒙古鄂尔多斯市",
"861560743", "湖南省湘西土家族苗族自治州",
"86158026", "湖南省长沙市",
"86178394", "河南省周口市",
"861786669", "山东省菏泽市",
"86938", "甘肃省天水市",
"861590671", "浙江省杭州市",
"861768198", "浙江省温州市",
"861582892", "四川省巴中市",
"861328763", "山东省泰安市",
"861522974", "陕西省安康市",
"861362634", "山东省莱芜市",
"861522720", "河北省沧州市",
"86145988", "广东省东莞市",
"861763328", "河北省沧州市",
"861376836", "广西百色市",
"861832401", "新疆乌鲁木齐市",
"861323436", "吉林省白城市",
"861880417", "辽宁省营口市",
"861372331", "宁夏银川市",
"861398164", "四川省雅安市",
"86159794", "江西省萍乡市",
"861776847", "江苏省连云港市",
"861556404", "山东省济宁市",
"861760541", "山东省济南市",
"861824944", "黑龙江省哈尔滨市",
"861884935", "河北省秦皇岛市",
"861864954", "山西省长治市",
"861871539", "安徽省滁州市",
"861334216", "辽宁省丹东市",
"86145355", "安徽省合肥市",
"861531889", "山东省青岛市",
"86131127", "广东省佛山市",
"861587014", "贵州省遵义市",
"861348471", "内蒙古呼和浩特市",
"861396309", "山东省滨州市",
"86180914", "陕西省商洛市",
"861301298", "山东省济南市",
"861521736", "广东省东莞市",
"861557923", "江西省九江市",
"86135831", "山东省济南市",
"861475625", "河北省邢台市",
"861478121", "四川省雅安市",
"861569816", "山东省青岛市",
"861858994", "广西桂林市",
"861331765", "广西玉林市",
"861306932", "河南省开封市",
"861770607", "福建省泉州市",
"861323249", "广东省清远市",
"86131264", "广东省广州市",
"86138820", "四川省成都市",
"86159018", "上海市",
"861532810", "四川省德阳市",
"861815917", "福建省泉州市",
"861520703", "江西省上饶市",
"861534589", "浙江省金华市",
"861350687", "浙江省温州市",
"861847550", "广东省汕尾市",
"861820787", "广西钦州市",
"861831324", "云南省西双版纳傣族自治州",
"861883083", "河北省衡水市",
"86159374", "河南省许昌市",
"861598687", "广东省汕头市",
"861801401", "江苏省苏州市",
"861570824", "四川省德阳市",
"86186735", "湖南省郴州市",
"861881705", "湖南省衡阳市",
"861470300", "河北省邯郸市",
"861890146", "江苏省南通市",
"86182734", "湖南省衡阳市",
"86135818", "北京市",
"861554526", "黑龙江省哈尔滨市",
"861360440", "吉林省长春市",
"861518600", "贵州省铜仁地区",
"861505903", "福建省三明市",
"861320450", "黑龙江省哈尔滨市",
"86177810", "四川省泸州市",
"86183826", "四川省广安市",
"861454179", "浙江省温州市",
"86181934", "甘肃省庆阳市",
"86157699", "云南省临沧市",
"861813857", "广东省韶关市",
"861859173", "陕西省宝鸡市",
"86180785", "广西玉林市",
"861376051", "广东省江门市",
"861359161", "辽宁省铁岭市",
"861509186", "陕西省西安市",
"861358104", "山东省淄博市",
"861589277", "四川省南充市",
"861328499", "黑龙江省哈尔滨市",
"861816210", "江西省南昌市",
"861806280", "湖北省襄樊市",
"861538417", "浙江省绍兴市",
"861839281", "陕西省渭南市",
"861314768", "吉林省松原市",
"861856239", "山东省东营市",
"861778184", "四川省广元市",
"861394915", "河南省信阳市",
"861340487", "内蒙古赤峰市",
"861886849", "浙江省金华市",
"861524172", "辽宁省盘锦市",
"86181578", "浙江省丽水市",
"861375402", "内蒙古包头市",
"861882473", "广东省中山市",
"861511880", "广东省珠海市",
"861302765", "河南省焦作市",
"861459094", "广东省茂名市",
"861770419", "辽宁省辽阳市",
"861382461", "广东省肇庆市",
"861560261", "广东省东莞市",
"86182351", "山西省太原市",
"861501810", "广东省潮州市",
"861840750", "广东省江门市",
"861384846", "内蒙古赤峰市",
"861529688", "广西河池市",
"861390437", "吉林省辽源市",
"861889355", "甘肃省甘南藏族自治州",
"861314054", "河南省商丘市",
"86180571", "浙江省杭州市",
"861876667", "山东省滨州市",
"861308712", "内蒙古呼和浩特市",
"861381546", "江苏省连云港市",
"861310660", "广东省湛江市",
"861473688", "云南省迪庆藏族自治州",
"861524906", "陕西省西安市",
"861848799", "云南省临沧市",
"861705006", "北京市",
"861536252", "广东省江门市",
"861332298", "广东省深圳市",
"861858663", "贵州省铜仁地区",
"861582002", "山东省青岛市",
"861514580", "黑龙江省伊春市",
"861309624", "四川省攀枝花市",
"861876945", "山东省德州市",
"86187840", "四川省绵阳市",
"861575061", "内蒙古乌兰察布市",
"861355175", "四川省攀枝花市",
"861470350", "山西省忻州市",
"86180353", "山西省阳泉市",
"86186730", "湖南省岳阳市",
"861830542", "山东省青岛市",
"861801451", "江苏省泰州市",
"861847500", "广东省江门市",
"861700193", "广东省深圳市",
"861815068", "福建省漳州市",
"861320400", "辽宁省沈阳市",
"861450984", "新疆塔城地区",
"86182573", "浙江省嘉兴市",
"861764043", "辽宁省沈阳市",
"861324220", "广东省中山市",
"861576462", "黑龙江省齐齐哈尔市",
"861899936", "新疆昌吉回族自治州",
"861590822", "四川省绵阳市",
"86180780", "广西玉林市",
"861569710", "湖北省襄樊市",
"861864717", "内蒙古鄂尔多斯市",
"861829537", "宁夏银川市",
"861844562", "黑龙江省黑河市",
"861357474", "湖南省益阳市",
"861471986", "新疆乌鲁木齐市",
"861478399", "河南省新乡市",
"861890081", "广东省湛江市",
"861808027", "四川省广安市",
"86178533", "山东省淄博市",
"86145090", "江苏省常州市",
"861893880", "广东省潮州市",
"861328241", "浙江省杭州市",
"861894468", "黑龙江省鹤岗市",
"861806971", "浙江省湖州市",
"861459122", "广西梧州市",
"861372385", "湖南省长沙市",
"86139548", "山东省泰安市",
"861306963", "黑龙江省齐齐哈尔市",
"861534977", "青海省海西蒙古族藏族自治州",
"861375452", "河北省保定市",
"861839970", "新疆阿克苏地区",
"861862976", "吉林省白山市",
"861889305", "甘肃省天水市",
"861533601", "甘肃省天水市",
"86134543", "浙江省丽水市",
"861884981", "云南省保山市",
"861810737", "湖南省益阳市",
"861705056", "北京市",
"861300044", "广东省广州市",
"861564946", "河南省平顶山市",
"861848588", "贵州省六盘水市",
"86130401", "江苏省泰州市",
"861800493", "辽宁省抚顺市",
"86187845", "四川省乐山市",
"861872743", "湖北省荆州市",
"861832947", "陕西省宝鸡市",
"861898538", "贵州省六盘水市",
"86131408", "江苏省苏州市",
"861582052", "广东省中山市",
"86133561", "浙江省温州市",
"86187717", "湖北省宜昌市",
"861322423", "辽宁省沈阳市",
"861840473", "内蒙古乌海市",
"861479748", "山西省运城市",
"861340461", "吉林省四平市",
"861338420", "辽宁省铁岭市",
"861309360", "安徽省宣城市",
"86180680", "江苏省苏州市",
"861382487", "广东省茂名市",
"861560287", "广东省珠海市",
"86180851", "贵州省贵阳市",
"861526638", "山东省日照市",
"8615801", "北京市",
"86181858", "贵州省六盘水市",
"861310324", "河北省承德市",
"861300852", "陕西省渭南市",
"861879407", "甘肃省陇南市",
"861339337", "河北省沧州市",
"861520318", "河北省衡水市",
"861370530", "山东省菏泽市",
"861315438", "吉林省松原市",
"861565020", "山东省临沂市",
"861806884", "江苏省南京市",
"861369860", "山东省济南市",
"861846500", "宁夏银川市",
"861315582", "江西省南昌市",
"861846991", "云南省文山壮族苗族自治州",
"861319573", "青海省海东地区",
"861768639", "山东省滨州市",
"861819561", "青海省西宁市",
"861305512", "湖南省株洲市",
"861360352", "山西省大同市",
"861320342", "山西省大同市",
"861824992", "广西河池市",
"861700509", "福建省厦门市",
"861585285", "江苏省扬州市",
"861816814", "江苏省连云港市",
"861537040", "江苏省无锡市",
"861875893", "浙江省金华市",
"861452480", "内蒙古呼伦贝尔市",
"861577462", "黑龙江省齐齐哈尔市",
"861820761", "广东省东莞市",
"861361327", "河北省沧州市",
"861501214", "云南省西双版纳傣族自治州",
"861320773", "广西桂林市",
"861361458", "黑龙江省伊春市",
"861869012", "新疆塔城地区",
"861333822", "福建省宁德市",
"861351954", "宁夏固原市",
"861837868", "广西玉林市",
"861352524", "河南省三门峡市",
"861559993", "新疆和田地区",
"861814684", "陕西省榆林市",
"861454283", "辽宁省大连市",
"86187617", "江苏省南通市",
"861858942", "西藏阿里地区",
"861504237", "辽宁省抚顺市",
"861843412", "山西省太原市",
"861379895", "广东省珠海市",
"861782289", "贵州省六盘水市",
"861836231", "江苏省泰州市",
"861370956", "宁夏石嘴山市",
"861372319", "河南省焦作市",
"861831660", "广东省茂名市",
"86177195", "陕西省西安市",
"86181460", "福建省泉州市",
"861779107", "陕西省汉中市",
"861350455", "黑龙江省绥化市",
"861377730", "浙江省绍兴市",
"861892469", "广东省湛江市",
"861380938", "甘肃省天水市",
"86151120", "广东省广州市",
"861534260", "湖北省武汉市",
"861708590", "福建省福州市",
"86157799", "江西省上饶市",
"861380089", "海南省海口市",
"861808779", "云南省玉溪市",
"861388786", "云南省德宏傣族景颇族自治州",
"861709964", "浙江省舟山市",
"861884645", "黑龙江省哈尔滨市",
"861800076", "江西省吉安市",
"861550083", "宁夏吴忠市",
"86180685", "江苏省常州市",
"861379780", "湖北省咸宁市",
"861571047", "陕西省宝鸡市",
"861879457", "甘肃省武威市",
"86159763", "广东省潮州市",
"861369727", "湖北省宜昌市",
"861501432", "广东省汕头市",
"861300802", "山西省临汾市",
"861705819", "江苏省南京市",
"8618600", "北京市",
"861857239", "湖北省宜昌市",
"861588594", "贵州省六盘水市",
"861311542", "黑龙江省大庆市",
"861524217", "辽宁省朝阳市",
"861503460", "山西省晋城市",
"86186635", "山东省聊城市",
"86182634", "山东省莱芜市",
"861893284", "河北省张家口市",
"861885120", "江苏省常州市",
"861562196", "内蒙古赤峰市",
"861843234", "河北省唐山市",
"861539190", "安徽省安庆市",
"861390651", "浙江省杭州市",
"861533437", "云南省红河哈尼族彝族自治州",
"861313421", "辽宁省朝阳市",
"861351904", "甘肃省庆阳市",
"86182853", "贵州省安顺市",
"861506618", "山东省青岛市",
"861554535", "黑龙江省双鸭山市",
"861361408", "辽宁省大连市",
"861331737", "湖南省益阳市",
"861589112", "陕西省榆林市",
"86131293", "广东省广州市",
"861857446", "湖南省永州市",
"861301760", "河南省新乡市",
"86188129", "天津市",
"861389148", "陕西省咸阳市",
"861306642", "广东省江门市",
"861452178", "吉林省吉林市",
"86158469", "黑龙江省大庆市",
"861882031", "广东省东莞市",
"861569899", "辽宁省锦州市",
"861303732", "湖南省湘潭市",
"861500338", "河北省衡水市",
"861770485", "内蒙古鄂尔多斯市",
"8622", "天津市",
"861515244", "江苏省南通市",
"86135198", "海南省海口市",
"861337387", "浙江省宁波市",
"861394989", "河南省漯河市",
"861478041", "四川省成都市",
"861707759", "江西省景德镇市",
"861325532", "山东省青岛市",
"861890067", "江苏省南京市",
"861572253", "江苏省连云港市",
"861808208", "江苏省镇江市",
"861880723", "湖北省黄石市",
"861823027", "河北省秦皇岛市",
"86151125", "广东省深圳市",
"86181465", "北京市",
"861354225", "广东省韶关市",
"861593669", "河南省安阳市",
"861836285", "江苏省连云港市",
"86159694", "云南省昆明市",
"861898729", "云南省昆明市",
"861562185", "山东省济南市",
"861346845", "山东省烟台市",
"861521725", "广东省东莞市",
"861598405", "四川省广元市",
"861520629", "江苏省南通市",
"861510138", "甘肃省金昌市",
"86133318", "上海市",
"861527199", "湖北省襄樊市",
"861373506", "浙江省衢州市",
"861564691", "新疆和田地区",
"861569009", "河北省承德市",
"861889159", "陕西省商洛市",
"861555841", "浙江省宁波市",
"861308491", "广西南宁市",
"861328416", "辽宁省锦州市",
"861780272", "湖北省武汉市",
"861787669", "广东省肇庆市",
"861520470", "内蒙古呼伦贝尔市",
"86186203", "广东省深圳市",
"86157379", "河南省洛阳市",
"86155748", "湖南省长沙市",
"861532432", "河北省唐山市",
"861458238", "安徽省滁州市",
"861865489", "山东省烟台市",
"861519199", "陕西省榆林市",
"861532588", "浙江省杭州市",
"861475636", "河北省承德市",
"861376825", "广西玉林市",
"861558651", "湖北省黄冈市",
"86177473", "内蒙古乌海市",
"861876635", "山东省聊城市",
"861457192", "浙江省嘉兴市",
"861307932", "甘肃省嘉峪关市",
"861534515", "江苏省盐城市",
"861812044", "湖北省武汉市",
"861450622", "黑龙江省齐齐哈尔市",
"86189907", "四川省南充市",
"861454375", "山东省潍坊市",
"861595474", "山东省日照市",
"861346151", "河南省信阳市",
"861348033", "广东省揭阳市",
"861300092", "辽宁省本溪市",
"861369766", "山东省青岛市",
"861870315", "河北省唐山市",
"861538723", "湖北省黄石市",
"861333671", "浙江省绍兴市",
"861302737", "湖南省益阳市",
"861847646", "广东省中山市",
"861397309", "湖南省怀化市",
"861332760", "青海省海西蒙古族藏族自治州",
"861334907", "安徽省安庆市",
"861354734", "四川省泸州市",
"861512896", "河北省保定市",
"861323425", "辽宁省丹东市",
"861852459", "辽宁省营口市",
"861770431", "吉林省长春市",
"861890918", "陕西省西安市",
"861568271", "甘肃省平凉市",
"861598455", "四川省攀枝花市",
"861372189", "河南省平顶山市",
"861821459", "云南省昆明市",
"861327912", "陕西省榆林市",
"861829565", "宁夏中卫市",
"861472990", "陕西省榆林市",
"861383538", "山西省临汾市",
"861318429", "浙江省温州市",
"861558174", "山西省晋中市",
"861569059", "河北省张家口市",
"861509121", "陕西省延安市",
"861536120", "广东省揭阳市",
"861585296", "江苏省泰州市",
"861529049", "河南省安阳市",
"861506045", "福建省泉州市",
"86176036", "黑龙江省哈尔滨市",
"861510616", "江苏省无锡市",
"861318670", "浙江省衢州市",
"861808147", "四川省雅安市",
"86184707", "江西省赣州市",
"861876398", "山东省济南市",
"861478316", "河南省郑州市",
"861309982", "云南省楚雄彝族自治州",
"861333154", "吉林省长春市",
"861500686", "山东省东营市",
"861366797", "江西省赣州市",
"861555105", "安徽省马鞍山市",
"861457024", "江西省抚州市",
"86155943", "陕西省延安市",
"861778032", "四川省内江市",
"861803771", "河南省南阳市",
"86183027", "湖北省武汉市",
"861373930", "甘肃省临夏回族自治州",
"861705268", "上海市",
"861394577", "黑龙江省双鸭山市",
"861325563", "山东省东营市",
"86510", "江苏省无锡市",
"86878", "云南省楚雄彝族自治州",
"861476883", "山东省德州市",
"861308436", "四川省凉山彝族自治州",
"861886301", "山东省聊城市",
"861532214", "广东省惠州市",
"861506329", "山东省临沂市",
"861518546", "贵州省黔南布依族苗族自治州",
"861816078", "江西省抚州市",
"861319160", "河北省邢台市",
"861852409", "辽宁省葫芦岛市",
"861809975", "新疆和田地区",
"861856211", "山东省东营市",
"86180609", "福建省厦门市",
"861810765", "广东省茂名市",
"861575472", "内蒙古包头市",
"861334957", "黑龙江省鸡西市",
"861397359", "湖南省邵阳市",
"861381442", "江苏省徐州市",
"86159200", "广东省深圳市",
"861335104", "黑龙江省双鸭山市",
"861473636", "广西玉林市",
"861458784", "湖南省永州市",
"861358262", "河北省保定市",
"861863489", "山西省吕梁市",
"861583373", "河北省邢台市",
"861530390", "河南省周口市",
"861339947", "甘肃省嘉峪关市",
"861871890", "广东省广州市",
"86157579", "浙江省金华市",
"861890098", "辽宁省大连市",
"861550040", "吉林省四平市",
"861847988", "江西省景德镇市",
"861506703", "浙江省衢州市",
"861868435", "吉林省通化市",
"861502955", "陕西省西安市",
"861538359", "山西省运城市",
"861332970", "湖北省武汉市",
"86145870", "广东省广州市",
"861817423", "湖南省怀化市",
"861560672", "浙江省湖州市",
"861332724", "湖南省张家界市",
"861320932", "甘肃省定西市",
"86185526", "江苏省淮安市",
"861369976", "广东省深圳市",
"861595669", "安徽省淮南市",
"861319092", "内蒙古赤峰市",
"861825066", "福建省漳州市",
"861586632", "山东省淄博市",
"861509138", "陕西省咸阳市",
"861768135", "安徽省阜阳市",
"861322537", "山东省济宁市",
"861804063", "湖北省荆州市",
"861818937", "甘肃省酒泉市",
"861770428", "辽宁省葫芦岛市",
"861539033", "四川省雅安市",
"861372696", "广东省清远市",
"861770357", "山西省临汾市",
"861816904", "宁夏石嘴山市",
"86136092", "陕西省西安市",
"86180691", "浙江省宁波市",
"861850868", "湖北省孝感市",
"861580312", "河北省保定市",
"861379372", "山东省枣庄市",
"861884998", "云南省临沧市",
"861507629", "河北省保定市",
"861380348", "山西省吕梁市",
"861554422", "河南省洛阳市",
"86181698", "广东省佛山市",
"861550202", "广东省深圳市",
"861529118", "陕西省西安市",
"861370816", "四川省眉山市",
"861320694", "黑龙江省黑河市",
"861848536", "贵州省黔南布依族苗族自治州",
"861572082", "江苏省南京市",
"861335154", "吉林省长春市",
"861324766", "广东省广州市",
"861354837", "四川省泸州市",
"861813256", "河北省保定市",
"861303973", "黑龙江省鹤岗市",
"861312587", "吉林省辽源市",
"861872821", "四川省阿坝藏族羌族自治州",
"861839298", "陕西省西安市",
"861811474", "江苏省苏州市",
"861329142", "浙江省杭州市",
"861898586", "贵州省铜仁地区",
"86182693", "广西玉林市",
"861390849", "湖南省长沙市",
"861452443", "黑龙江省齐齐哈尔市",
"86177451", "黑龙江省哈尔滨市",
"861567074", "河南省洛阳市",
"861874951", "河南省商丘市",
"861300160", "山东省烟台市",
"861810975", "青海省果洛藏族自治州",
"861537083", "江苏省南通市",
"861538309", "河北省邢台市",
"861770544", "山东省德州市",
"861570413", "辽宁省抚顺市",
"861559479", "陕西省汉中市",
"861389473", "吉林省白山市",
"861351537", "山东省济宁市",
"861534735", "湖南省郴州市",
"861317142", "内蒙古呼和浩特市",
"861319124", "山西省运城市",
"861362334", "河北省秦皇岛市",
"861473118", "河北省保定市",
"861590371", "河南省郑州市",
"86135774", "云南省曲靖市",
"861527686", "新疆乌鲁木齐市",
"861350387", "河南省南阳市",
"861573472", "内蒙古包头市",
"861768311", "四川省广安市",
"861860477", "内蒙古鄂尔多斯市",
"861816954", "宁夏固原市",
"861774258", "湖南省娄底市",
"86135861", "浙江省台州市",
"861330369", "黑龙江省大庆市",
"861514908", "内蒙古赤峰市",
"861770307", "广东省清远市",
"861332281", "广东省广州市",
"861396609", "安徽省淮北市",
"861778614", "湖北省武汉市",
"861323563", "湖北省宜昌市",
"861519686", "四川省达州市",
"861500948", "甘肃省酒泉市",
"861310982", "辽宁省大连市",
"861855612", "江苏省泰州市",
"861390523", "江苏省淮安市",
"861866922", "云南省昆明市",
"861526872", "浙江省湖州市",
"861853034", "河南省三门峡市",
"861529691", "宁夏银川市",
"861300912", "吉林省长春市",
"861586994", "湖南省怀化市",
"861762506", "江苏省扬州市",
"861524009", "安徽省阜阳市",
"861840999", "新疆伊犁哈萨克自治州",
"861303512", "湖北省武汉市",
"86137828", "河南省焦作市",
"861873893", "河南省平顶山市",
"861334534", "新疆喀什地区",
"861352560", "河南省濮阳市",
"861581370", "广东省深圳市",
"861313438", "吉林省松原市",
"861325712", "湖北省孝感市",
"861334817", "江苏省常州市",
"86181964", "新疆伊犁哈萨克自治州",
"861558523", "贵州省遵义市",
"861316022", "江苏省镇江市",
"861560821", "四川省成都市",
"861313582", "湖北省宜昌市",
"861892674", "广东省茂名市",
"86157701", "新疆喀什地区",
"861320963", "宁夏吴忠市",
"861820971", "青海省西宁市",
"861594644", "黑龙江省七台河市",
"861862413", "辽宁省抚顺市",
"86182871", "云南省昆明市",
"861891244", "江苏省南通市",
"861598387", "四川省达州市",
"861530404", "辽宁省大连市",
"86189525", "江苏省扬州市",
"861880309", "河北省邢台市",
"86186765", "广东省佛山市",
"861500321", "河北省石家庄市",
"861831624", "广东省阳江市",
"861898595", "贵州省黔西南布依族苗族自治州",
"86182764", "广西梧州市",
"861840207", "广东省茂名市",
"861338464", "黑龙江省七台河市",
"861309324", "湖北省恩施土家族苗族自治州",
"861339401", "福建省三明市",
"86773", "广西桂林市",
"86183882", "云南省昆明市",
"861519695", "四川省宜宾市",
"861813575", "河南省周口市",
"861776439", "安徽省六安市",
"861310360", "河南省商丘市",
"861558849", "山东省枣庄市",
"861305499", "山东省济宁市",
"861773944", "河南省濮阳市",
"86176867", "山东省济南市",
"861565064", "安徽省六安市",
"86159854", "贵州省毕节地区",
"861800561", "安徽省淮北市",
"861527695", "新疆喀什地区",
"86186946", "安徽省阜阳市",
"861327852", "吉林省四平市",
"86134841", "浙江省嘉兴市",
"861533351", "山西省太原市",
"861356669", "浙江省台州市",
"861890858", "贵州省六盘水市",
"86135394", "广东省广州市",
"861528903", "西藏山南地区",
"861529388", "甘肃省临夏回族自治州",
"861369824", "四川省自贡市",
"86975", "青海省果洛藏族自治州",
"861895721", "浙江省舟山市",
"861567818", "广西崇左市",
"861346793", "湖南省湘潭市",
"861324727", "湖北省襄樊市",
"861476840", "山东省临沂市",
"861551266", "河北省衡水市",
"861539062", "甘肃省甘南藏族自治州",
"861850794", "江西省抚州市",
"861763319", "河北省邢台市",
"861322078", "山东省枣庄市",
"861845234", "江苏省南京市",
"861535437", "河北省沧州市",
"861565708", "浙江省舟山市",
"861871242", "安徽省阜阳市",
"861532525", "浙江省绍兴市",
"861301970", "黑龙江省哈尔滨市",
"861505460", "山东省东营市",
"861301724", "湖南省常德市",
"86136352", "福建省福州市",
"861768046", "湖南省岳阳市",
"861337661", "广东省汕头市",
"861760749", "湖南省永州市",
"86156323", "河北省石家庄市",
"861896648", "浙江省杭州市",
"861380921", "广东省佛山市",
"861453229", "浙江省衢州市",
"861518350", "四川省雅安市",
"861521788", "广东省珠海市",
"861332235", "辽宁省铁岭市",
"861882916", "陕西省汉中市",
"86189520", "江苏省南京市",
"861880359", "山西省运城市",
"861530454", "黑龙江省佳木斯市",
"861319802", "四川省内江市",
"861709920", "浙江省衢州市",
"861825027", "福建省泉州市",
"861589770", "湖北省孝感市",
"861552599", "山西省长治市",
"861323532", "山东省青岛市",
"861339451", "黑龙江省哈尔滨市",
"861879115", "陕西省商洛市",
"861892151", "江苏省无锡市",
"861559013", "吉林省吉林市",
"861536475", "山西省长治市",
"861323488", "内蒙古巴彦淖尔市",
"861587942", "江西省吉安市",
"861806787", "浙江省绍兴市",
"861373340", "湖北省武汉市",
"861776792", "吉林省吉林市",
"861503424", "山西省大同市",
"861528953", "广西南宁市",
"861345364", "山西省晋城市",
"861533301", "山西省太原市",
"861590262", "贵州省遵义市",
"861321560", "安徽省合肥市",
"861315421", "辽宁省朝阳市",
"861342995", "湖北省十堰市",
"861597679", "广东省汕尾市",
"861329437", "吉林省辽源市",
"861590688", "浙江省丽水市",
"861521579", "浙江省衢州市",
"861304851", "贵州省遵义市",
"861898575", "贵州省黔南布依族苗族自治州",
"861705277", "广东省广州市",
"861862859", "陕西省咸阳市",
"861811350", "四川省广安市",
"861302921", "辽宁省丹东市",
"861389769", "青海省海东地区",
"861303664", "四川省达州市",
"86151354", "山西省吕梁市",
"861346342", "河北省保定市",
"861559763", "青海省海南藏族自治州",
"861507547", "河北省沧州市",
"861809648", "安徽省阜阳市",
"861810986", "辽宁省盘锦市",
"86130343", "天津市",
"861301551", "河南省郑州市",
"861330442", "吉林省吉林市",
"861820500", "江苏省徐州市",
"861820991", "新疆乌鲁木齐市",
"861324341", "河南省鹤壁市",
"861515661", "安徽省淮南市",
"861530418", "辽宁省阜新市",
"861800916", "陕西省汉中市",
"861581390", "广东省汕尾市",
"861364351", "山西省太原市",
"861512960", "陕西省榆林市",
"861514707", "内蒙古呼伦贝尔市",
"861367935", "甘肃省武威市",
"861399450", "山西省阳泉市",
"86152931", "甘肃省兰州市",
"861300593", "广西柳州市",
"861348488", "陕西省榆林市",
"861899787", "新疆阿克苏地区",
"861850774", "广西梧州市",
"861869156", "陕西省西安市",
"86137855", "河北省唐山市",
"86156788", "广西南宁市",
"861821953", "广东省肇庆市",
"861331348", "山西省运城市",
"861537421", "江西省九江市",
"861398582", "贵州省黔东南苗族侗族自治州",
"861346773", "湖南省株洲市",
"861519675", "四川省南充市",
"861316651", "河北省秦皇岛市",
"86151731", "湖南省长沙市",
"861474714", "内蒙古乌兰察布市",
"861593300", "河北省邯郸市",
"861338041", "广东省汕头市",
"86189558", "安徽省阜阳市",
"861572497", "浙江省杭州市",
"861503317", "河北省沧州市",
"861500747", "湖南省邵阳市",
"86176869", "山东省临沂市",
"861454872", "四川省绵阳市",
"86150738", "湖南省娄底市",
"86184553", "安徽省芜湖市",
"861538624", "湖南省株洲市",
"861557245", "湖北省襄樊市",
"861339748", "湖南省长沙市",
"86150933", "河南省郑州市",
"861478420", "河南省郑州市",
"861872692", "安徽省淮北市",
"86183436", "吉林省白城市",
"861479337", "甘肃省平凉市",
"861301501", "内蒙古呼和浩特市",
"861301990", "辽宁省辽阳市",
"861566042", "山东省济宁市",
"861347450", "陕西省西安市",
"861856705", "河南省焦作市",
"861310841", "四川省德阳市",
"861322098", "山东省德州市",
"86184371", "河南省郑州市",
"861348170", "广西防城港市",
"861594895", "吉林省辽源市",
"861860540", "山东省菏泽市",
"86184034", "山西省朔州市",
"861510379", "河南省洛阳市",
"861800028", "江西省抚州市",
"86137468", "黑龙江省佳木斯市",
"861838905", "西藏昌都地区",
"86183644", "山东省烟台市",
"861820550", "安徽省滁州市",
"861310155", "黑龙江省绥化市",
"86182806", "四川省凉山彝族自治州",
"861453910", "广东省广州市",
"861399400", "山西省临汾市",
"861514757", "内蒙古通辽市",
"861356546", "新疆克拉玛依市",
"861523169", "河北省承德市",
"861309417", "湖北省宜昌市",
"861858266", "四川省绵阳市",
"861854549", "黑龙江省鸡西市",
"861818738", "云南省红河哈尼族彝族自治州",
"861807011", "江西省南昌市",
"861319487", "四川省成都市",
"86189154", "江苏省苏州市",
"861342975", "陕西省安康市",
"861827096", "江西省吉安市",
"861583505", "山西省晋中市",
"861821903", "广东省河源市",
"86137850", "河北省邯郸市",
"86185729", "湖北省咸宁市",
"861840587", "浙江省温州市",
"861890814", "四川省攀枝花市",
"861536495", "山西省长治市",
"861459543", "青海省黄南藏族自治州",
"86138798", "江西省景德镇市",
"861570099", "新疆克孜勒苏柯尔克孜自治州",
"861835974", "福建省厦门市",
"861593350", "河北省秦皇岛市",
"861552579", "山西省吕梁市",
"861589790", "湖北省黄冈市",
"861865983", "福建省泉州市",
"861867740", "广西梧州市",
"861882561", "广东省阳江市",
"861335388", "河南省驻马店市",
"861479169", "陕西省咸阳市",
"861820936", "甘肃省张掖市",
"861529822", "四川省南充市",
"86157776", "广西百色市",
"861835720", "浙江省嘉兴市",
"861381369", "江苏省常州市",
"861567854", "广西贵港市",
"86153182", "山东省威海市",
"861327487", "内蒙古鄂尔多斯市",
"861890537", "山东省济宁市",
"861325062", "广东省惠州市",
"861335118", "黑龙江省大庆市",
"861819806", "甘肃省张掖市",
"861567122", "湖北省黄石市",
"861334613", "浙江省台州市",
"861332501", "山东省青岛市",
"86184791", "江西省南昌市",
"861813353", "河北省秦皇岛市",
"861332990", "湖北省孝感市",
"861559732", "青海省玉树藏族自治州",
"861315083", "内蒙古乌兰察布市",
"861320845", "黑龙江省大庆市",
"861565907", "福建省泉州市",
"861321193", "云南省临沧市",
"861570809", "西藏昌都地区",
"861535142", "四川省巴中市",
"861452167", "河北省衡水市",
"861369996", "新疆乌鲁木齐市",
"861560692", "福建省厦门市",
"861354558", "湖北省咸宁市",
"861580905", "新疆克拉玛依市",
"861351858", "贵州省六盘水市",
"86186256", "河南省南阳市",
"861521987", "广东省潮州市",
"861333049", "云南省昆明市",
"861837964", "江西省抚州市",
"861450510", "吉林省四平市",
"861365515", "江苏省淮安市",
"861358129", "湖北省黄石市",
"861338316", "河北省廊坊市",
"861588123", "四川省雅安市",
"861871870", "广东省肇庆市",
"861572540", "山东省菏泽市",
"861530370", "河南省商丘市",
"86158148", "广东省广州市",
"861379392", "山东省临沂市",
"861536486", "山西省晋城市",
"861809015", "四川省泸州市",
"861593494", "内蒙古通辽市",
"86138378", "河南省开封市",
"861368598", "福建省龙岩市",
"861388647", "湖北省黄石市",
"861894134", "辽宁省大连市",
"86177024", "辽宁省沈阳市",
"861816918", "宁夏固原市",
"86150282", "河北省保定市",
"861576649", "广东省深圳市",
"861350244", "广东省广州市",
"861801100", "四川省攀枝花市",
"861304091", "湖北省荆州市",
"861582948", "陕西省咸阳市",
"86150495", "内蒙古呼伦贝尔市",
"861348563", "安徽省宣城市",
"861378869", "广西南宁市",
"861336883", "云南省临沧市",
"861309609", "四川省攀枝花市",
"861391219", "江苏省泰州市",
"86135421", "广东省江门市",
"861333325", "河北省唐山市",
"861360141", "江苏省盐城市",
"86151913", "陕西省渭南市",
"86138430", "吉林省长春市",
"861771237", "江苏省无锡市",
"861452339", "河南省濮阳市",
"861515405", "山东省枣庄市",
"861503187", "河北省唐山市",
"861837877", "广西玉林市",
"861774432", "四川省南充市",
"861332551", "新疆阿克苏地区",
"861889044", "湖南省岳阳市",
"861810995", "新疆吐鲁番地区",
"86158544", "山东省潍坊市",
"861525665", "安徽省池州市",
"86151718", "湖北省宜昌市",
"861590391", "河南省焦作市",
"861570859", "贵州省黔西南布依族苗族自治州",
"86150711", "湖北省武汉市",
"861587881", "广西南宁市",
"861555324", "山东省青岛市",
"861304036", "吉林省白城市",
"861550582", "浙江省湖州市",
"86152918", "陕西省西安市",
"861576911", "陕西省延安市",
"861589896", "山东省烟台市",
"861550438", "吉林省松原市",
"861599703", "青海省海东地区",
"861580955", "宁夏中卫市",
"861560934", "甘肃省庆阳市",
"861320674", "黑龙江省哈尔滨市",
"861856080", "山东省济南市",
"861811494", "江苏省扬州市",
"861335636", "山东省潍坊市",
"861354662", "山西省晋城市",
"86137204", "陕西省西安市",
"861303993", "黑龙江省大兴安岭地区",
"861771888", "广东省惠州市",
"861300305", "安徽省合肥市",
"861812159", "江苏省苏州市",
"861778562", "贵州省贵阳市",
"861504984", "内蒙古巴彦淖尔市",
"861476272", "江苏省淮安市",
"861839709", "青海省海西蒙古族藏族自治州",
"861532969", "贵州省黔西南布依族苗族自治州",
"861366967", "广西南宁市",
"861508365", "江西省鹰潭市",
"861368789", "广西玉林市",
"861840979", "青海省海西蒙古族藏族自治州",
"861325033", "广东省广州市",
"861816026", "新疆阿克苏地区",
"861369931", "新疆和田地区",
"861586974", "湖南省株洲市",
"861860497", "辽宁省营口市",
"861309659", "山西省大同市",
"861363735", "湖南省郴州市",
"861473671", "云南省玉溪市",
"86150490", "内蒙古呼伦贝尔市",
"86189991", "新疆乌鲁木齐市",
"861517671", "河北省唐山市",
"861320101", "新疆昌吉回族自治州",
"86134202", "广东省中山市",
"86138435", "吉林省通化市",
"861302348", "江苏省盐城市",
"86153273", "湖北省武汉市",
"86185986", "重庆市",
"861356300", "山东省聊城市",
"86157377", "河南省南阳市",
"861890954", "宁夏固原市",
"861304649", "山东省潍坊市",
"861780292", "陕西省西安市",
"861822651", "安徽省淮北市",
"861308471", "内蒙古呼和浩特市",
"86145237", "重庆市",
"861810015", "浙江省温州市",
"86138934", "甘肃省兰州市",
"86153251", "浙江省丽水市",
"861335049", "四川省广元市",
"861803736", "河南省洛阳市",
"861303013", "广东省韶关市",
"861870902", "新疆哈密地区",
"861830574", "浙江省宁波市",
"861453850", "甘肃省酒泉市",
"861705682", "湖北省咸宁市",
"861860583", "浙江省嘉兴市",
"861533142", "云南省文山壮族苗族自治州",
"861346932", "湖南省怀化市",
"86150013", "北京市",
"861528459", "云南省楚雄彝族自治州",
"861316523", "山东省德州市",
"861361263", "广东省佛山市",
"861576091", "陕西省榆林市",
"861891455", "江苏省镇江市",
"861454116", "安徽省池州市",
"861899569", "湖北省孝感市",
"86177942", "甘肃省兰州市",
"861564671", "山东省济宁市",
"861324931", "广东省惠州市",
"861311705", "湖北省荆门市",
"86137695", "云南省曲靖市",
"861310609", "浙江省衢州市",
"8615311", "北京市",
"861367345", "河南省信阳市",
"861322067", "山东省淄博市",
"86156418", "辽宁省阜新市",
"861389587", "黑龙江省双鸭山市",
"861813729", "河南省安阳市",
"861331938", "江西省景德镇市",
"861335325", "吉林省延边朝鲜族自治州",
"86187912", "陕西省榆林市",
"861539563", "安徽省宣城市",
"861880660", "广东省汕尾市",
"861811546", "江苏省南京市",
"861814846", "四川省宜宾市",
"861826148", "江苏省徐州市",
"861319355", "河南省濮阳市",
"86157596", "福建省漳州市",
"861568236", "四川省巴中市",
"8615123", "重庆市",
"861770476", "内蒙古赤峰市",
"861532258", "广东省汕头市",
"861865940", "福建省泉州市",
"861454395", "贵州省黔东南苗族侗族自治州",
"861595494", "山东省聊城市",
"86189909", "四川省宜宾市",
"861554201", "辽宁省锦州市",
"861459580", "陕西省咸阳市",
"86138578", "浙江省宁波市",
"861550421", "辽宁省朝阳市",
"861333636", "山东省潍坊市",
"861776933", "湖南省长沙市",
"861572468", "辽宁省抚顺市",
"861822601", "安徽省宿州市",
"861869733", "河南省郑州市",
"861318690", "浙江省台州市",
"861890904", "四川省阿坝藏族羌族自治州",
"861479665", "江西省吉安市",
"861855520", "安徽省滁州市",
"861840769", "广东省东莞市",
"861787546", "广东省深圳市",
"861577025", "云南省昭通市",
"861454638", "宁夏中卫市",
"861475104", "江苏省常州市",
"861366777", "广西钦州市",
"861532779", "湖北省荆州市",
"861841947", "甘肃省天水市",
"861332010", "江西省鹰潭市",
"86184709", "江西省南昌市",
"861479947", "新疆喀什地区",
"861597195", "湖北省荆门市",
"861358946", "山东省聊城市",
"861530245", "广东省广州市",
"861453800", "四川省德阳市",
"861331089", "广东省广州市",
"861870952", "宁夏石嘴山市",
"86147518", "江苏省南京市",
"861336746", "湖南省永州市",
"861310659", "广东省佛山市",
"861311755", "湖南省郴州市",
"861378445", "河北省承德市",
"861821813", "广东省梅州市",
"86155472", "内蒙古包头市",
"86158344", "吉林省四平市",
"861523665", "河南省洛阳市",
"861528409", "四川省泸州市",
"861815303", "河南省周口市",
"861327305", "河南省漯河市",
"86188408", "辽宁省大连市",
"861393429", "山西省长治市",
"861320469", "黑龙江省双鸭山市",
"861373286", "吉林省通化市",
"861594743", "内蒙古通辽市",
"861365735", "湖南省长沙市",
"861377871", "四川省遂宁市",
"86180607", "福建省福州市",
"861872557", "安徽省宿州市",
"861847569", "广东省阳江市",
"861800856", "贵州省铜仁地区",
"861871927", "广东省深圳市",
"861831723", "河南省南阳市",
"861809995", "新疆吐鲁番地区",
"861458402", "河南省商丘市",
"861380737", "湖南省益阳市",
"861524144", "辽宁省本溪市",
"861862919", "陕西省西安市",
"861860356", "山西省晋城市",
"861820346", "山西省晋城市",
"86183029", "陕西省西安市",
"861893347", "广东省惠州市",
"861346963", "宁夏吴忠市",
"861513661", "河南省商丘市",
"861846971", "云南省红河哈尼族彝族自治州",
"861334064", "四川省遂宁市",
"861567757", "广西玉林市",
"861361741", "湖南省株洲市",
"86152038", "河南省南阳市",
"861302089", "河北省承德市",
"8618429", "陕西省西安市",
"861454553", "新疆伊犁哈萨克自治州",
"861321751", "广东省韶关市",
"861709897", "广东省中山市",
"861338699", "福建省南平市",
"861860468", "黑龙江省鹤岗市",
"861882076", "广东省广州市",
"861800700", "江西省南昌市",
"861305664", "四川省宜宾市",
"861884894", "河南省平顶山市",
"861309105", "河北省唐山市",
"861777643", "广西玉林市",
"861319593", "甘肃省武威市",
"861808432", "贵州省黔东南苗族侗族自治州",
"861562952", "湖北省十堰市",
"861340044", "河北省保定市",
"861881594", "福建省南平市",
"861522942", "陕西省榆林市",
"861840493", "山西省长治市",
"861561522", "山东省滨州市",
"861599191", "陕西省延安市",
"861325190", "浙江省宁波市",
"861514854", "内蒙古锡林郭勒盟",
"861327593", "福建省宁德市",
"861322918", "广东省揭阳市",
"861330650", "浙江省杭州市",
"861386565", "安徽省马鞍山市",
"861888245", "四川省绵阳市",
"861301010", "北京市",
"861580815", "四川省雅安市",
"86152483", "内蒙古通辽市",
"86181825", "陕西省西安市",
"861337244", "浙江省宁波市",
"861303479", "内蒙古赤峰市",
"861479451", "黑龙江省哈尔滨市",
"861599618", "江苏省淮安市",
"861576851", "广东省深圳市",
"86132122", "天津市",
"86184353", "山西省阳泉市",
"861328364", "山西省阳泉市",
"861520547", "山东省济宁市",
"861453090", "山西省阳泉市",
"861560557", "安徽省宿州市",
"861365224", "广东省珠海市",
"86189602", "福建省泉州市",
"86158829", "四川省达州市",
"861334758", "广西贺州市",
"861303620", "江西省南昌市",
"861800031", "河北省石家庄市",
"861320793", "江西省上饶市",
"861804562", "黑龙江省哈尔滨市",
"861585555", "安徽省安庆市",
"861563441", "山东省威海市",
"861893504", "山西省临汾市",
"86187619", "江苏省苏州市",
"861452949", "广东省梅州市",
"861315252", "广西柳州市",
"861570919", "陕西省铜川市",
"861809986", "新疆喀什地区",
"861861362", "山东省日照市",
"861772224", "广东省肇庆市",
"861452611", "江苏省无锡市",
"861454503", "湖南省怀化市",
"861321701", "江西省鹰潭市",
"86155253", "山西省长治市",
"86189980", "广东省东莞市",
"861537438", "江西省上饶市",
"861570641", "山东省济南市",
"861567707", "广西桂林市",
"861582695", "湖北省黄石市",
"861506171", "江苏省徐州市",
"861309155", "黑龙江省绥化市",
"861315040", "新疆石河子市",
"861310417", "辽宁省营口市",
"8615021", "上海市",
"861334279", "广东省潮州市",
"861800750", "广东省江门市",
"86151488", "内蒙古巴彦淖尔市",
"86184571", "浙江省杭州市",
"86151158", "湖南省娄底市",
"861471517", "广东省肇庆市",
"861384922", "河南省鹤壁市",
"861572583", "山东省泰安市",
"861560344", "山西省晋中市",
"861368567", "安徽省阜阳市",
"861869762", "安徽省六安市",
"861800096", "广东省潮州市",
"86156431", "吉林省长春市",
"861520354", "山西省晋中市",
"861850877", "云南省玉溪市",
"861826257", "江苏省扬州市",
"861776962", "浙江省嘉兴市",
"861808799", "云南省普洱市",
"86157797", "江西省赣州市",
"861347642", "湖北省襄樊市",
"861812655", "广东省肇庆市",
"861816858", "江苏省镇江市",
"861365781", "广西南宁市",
"86150151", "广东省东莞市",
"861471834", "广东省河源市",
"861592839", "四川省巴中市",
"86147863", "湖南省永州市",
"861805153", "江苏省苏州市",
"861323062", "河北省保定市",
"86188264", "广东省广州市",
"861576801", "广东省江门市",
"861829929", "新疆吐鲁番地区",
"861478464", "黑龙江省七台河市",
"861569879", "辽宁省葫芦岛市",
"861390022", "广东省肇庆市",
"861361414", "辽宁省本溪市",
"86181820", "湖南省长沙市",
"861454386", "贵州省铜仁地区",
"861560507", "福建省南平市",
"861333388", "河南省洛阳市",
"861332623", "山东省日照市",
"861530782", "广西柳州市",
"861329351", "山西省太原市",
"861509379", "河南省平顶山市",
"861458683", "湖南省常德市",
"861364437", "吉林省辽源市",
"861334708", "内蒙古包头市",
"86150668", "山东省青岛市",
"861819028", "四川省资阳市",
"861818284", "黑龙江省佳木斯市",
"86158467", "黑龙江省牡丹江市",
"861302938", "辽宁省鞍山市",
"861511347", "广东省梅州市",
"861599136", "陕西省咸阳市",
"861808214", "江苏省宿迁市",
"86151661", "山东省威海市",
"861776110", "四川省德阳市",
"86188127", "天津市",
"861309841", "湖北省宜昌市",
"861893554", "青海省玉树藏族自治州",
"861589297", "四川省达州市",
"861867247", "湖北省鄂州市",
"861367149", "广东省湛江市",
"861328479", "内蒙古巴彦淖尔市",
"86130476", "浙江省杭州市",
"861827257", "河南省安阳市",
"86139291", "广东省佛山市",
"861327159", "河南省郑州市",
"86157697", "天津市",
"861303364", "浙江省台州市",
"861335129", "黑龙江省大庆市",
"861355316", "山东省济南市",
"861596041", "福建省泉州市",
"861343732", "广东省江门市",
"861319159", "内蒙古兴安盟",
"861599125", "陕西省商洛市",
"861358118", "山东省聊城市",
"861536438", "湖南省张家界市",
"861811650", "四川省甘孜藏族自治州",
"861774900", "陕西省西安市",
"861332709", "内蒙古锡林郭勒盟",
"86186342", "山西省晋中市",
"861507171", "湖北省黄冈市",
"861869848", "内蒙古呼伦贝尔市",
"86137375", "广西玉林市",
"861454199", "山西省运城市",
"861587898", "广西北海市",
"861590388", "河南省新乡市",
"861588755", "云南省德宏傣族景颇族自治州",
"861522663", "河北省沧州市",
"861829858", "甘肃省张掖市",
"861877410", "湖南省岳阳市",
"86151874", "云南省曲靖市",
"861816929", "湖南省怀化市",
"86147361", "广西南宁市",
"861569060", "河南省安阳市",
"861573531", "山西省阳泉市",
"8624", "辽宁省沈阳市\、铁岭市\、抚顺市",
"861899971", "新疆伊犁哈萨克自治州",
"861399963", "新疆喀什地区",
"861821460", "云南省昆明市",
"861355195", "四川省广安市",
"861337840", "广东省深圳市",
"861316351", "黑龙江省佳木斯市",
"86151761", "河北省石家庄市",
"861876832", "浙江省嘉兴市",
"861358691", "浙江省宁波市",
"861777110", "湖北省襄樊市",
"861332278", "广东省潮州市",
"86187904", "河南省信阳市",
"861898857", "广东省中山市",
"861305320", "安徽省马鞍山市",
"861459074", "广东省河源市",
"86170889", "广东省汕头市",
"861524192", "辽宁省本溪市",
"861839551", "安徽省宣城市",
"861787600", "广东省中山市",
"861770853", "贵州省安顺市",
"861707866", "云南省楚雄彝族自治州",
"86152961", "广西防城港市",
"861362513", "江苏省盐城市",
"861511775", "贵州省安顺市",
"861367998", "新疆塔城地区",
"861827207", "湖北省襄樊市",
"861364601", "福建省厦门市",
"861857043", "湖南省湘西土家族苗族自治州",
"861577145", "内蒙古乌兰察布市",
"861773733", "河南省焦作市",
"86137438", "吉林省松原市",
"861363977", "青海省海西蒙古族藏族自治州",
"861478379", "河南省洛阳市",
"861479637", "江西省鹰潭市",
"861332759", "山西省运城市",
"861533194", "黑龙江省哈尔滨市",
"861510420", "辽宁省朝阳市",
"861803412", "河北省保定市",
"861360038", "广东省湛江市",
"86183466", "黑龙江省大庆市",
"861834434", "广东省广州市",
"86153126", "江苏省徐州市",
"861354333", "广东省深圳市",
"86180506", "福建省漳州市",
"861454948", "福建省泉州市",
"861813538", "山西省太原市",
"861538324", "河北省石家庄市",
"86150963", "湖南省株洲市",
"861333946", "黑龙江省黑河市",
"86137370", "广西南宁市",
"861550486", "内蒙古赤峰市",
"861300461", "浙江省绍兴市",
"861800473", "内蒙古乌海市",
"86184680", "云南省昆明市",
"861551663", "河南省濮阳市",
"86137083", "重庆市",
"86187062", "江苏省苏州市",
"861512403", "辽宁省锦州市",
"86187719", "湖北省武汉市",
"861788129", "新疆阿克苏地区",
"861335688", "山东省青岛市",
"861524024", "江苏省南京市",
"861839501", "宁夏银川市",
"861534997", "新疆克孜勒苏柯尔克孜自治州",
"861808810", "云南省西双版纳傣族自治州",
"861350883", "云南省红河哈尼族彝族自治州",
"861571484", "内蒙古乌兰察布市",
"861898807", "云南省昆明市",
"861313475", "内蒙古通辽市",
"86189702", "江西省九江市",
"861787650", "广东省佛山市",
"861818880", "广东省广州市",
"861705770", "福建省福州市",
"861300655", "山东省潍坊市",
"861301759", "河南省许昌市",
"861322081", "山东省济宁市",
"861530670", "浙江省衢州市",
"861337746", "广西百色市",
"861353699", "广东省肇庆市",
"86170805", "江苏省南通市",
"86514", "江苏省扬州市",
"861340124", "江苏省泰州市",
"861587764", "陕西省渭南市",
"861560392", "河南省鹤壁市",
"861831609", "广东省阳江市",
"861830705", "江西省宜春市",
"861880324", "河北省承德市",
"861856123", "山东省东营市",
"861530429", "辽宁省葫芦岛市",
"86138858", "贵州省六盘水市",
"861786546", "山东省东营市",
"861367777", "广西钦州市",
"861377984", "新疆喀什地区",
"861813653", "江苏省南通市",
"861812487", "广东省云浮市",
"861334313", "河北省张家口市",
"861521771", "广东省广州市",
"86184609", "江西省南昌市",
"861707760", "云南省昆明市",
"861311574", "浙江省宁波市",
"861894203", "湖南省湘西土家族苗族自治州",
"861335391", "河南省焦作市",
"861810938", "甘肃省天水市",
"86156262", "广东省广州市",
"861351146", "浙江省台州市",
"861596316", "山东省聊城市",
"861458340", "江西省抚州市",
"861452639", "江苏省淮安市",
"861890423", "辽宁省抚顺市",
"861359953", "福建省厦门市",
"861330546", "山东省东营市",
"861323471", "内蒙古呼和浩特市",
"86138460", "黑龙江省鸡西市",
"861589959", "广东省佛山市",
"861829098", "新疆伊犁哈萨克自治州",
"86189614", "江苏省常州市",
"861333625", "山东省聊城市",
"861700560", "浙江省温州市",
"861326305", "江西省宜春市",
"86137411", "辽宁省大连市",
"861399932", "新疆石河子市",
"861590636", "山东省潍坊市",
"861550495", "辽宁省大连市",
"861454321", "内蒙古呼和浩特市",
"861360577", "浙江省温州市",
"861775156", "江苏省盐城市",
"861819999", "新疆乌鲁木齐市",
"861370144", "江苏省扬州市",
"861832748", "湖北省宜昌市",
"861369809", "江西省南昌市",
"861570996", "新疆巴音郭楞蒙古自治州",
"861379692", "黑龙江省鸡西市",
"861376871", "广西桂林市",
"861838889", "云南省临沧市",
"861580564", "安徽省六安市",
"861527283", "湖北省孝感市",
"861368535", "山东省烟台市",
"861301709", "贵州省安顺市",
"861315120", "江苏省徐州市",
"861855905", "福建省泉州市",
"861317523", "浙江省湖州市",
"86170800", "北京市",
"861320374", "河南省郑州市",
"86137795", "新疆伊犁哈萨克自治州",
"861582872", "四川省内江市",
"861773762", "河南省安阳市",
"861509175", "陕西省西安市",
"861306151", "山东省聊城市",
"861522994", "陕西省汉中市",
"861800019", "江苏省连云港市",
"861881542", "广西玉林市",
"861308033", "山西省阳泉市",
"861314967", "黑龙江省鸡西市",
"861830755", "广东省深圳市",
"861831659", "广东省东莞市",
"861534259", "湖北省鄂州市",
"861767327", "湖南省衡阳市",
"861892450", "广东省中山市",
"861570931", "甘肃省兰州市",
"861362156", "江苏省苏州市",
"861556418", "山东省烟台市",
"861387210", "湖北省黄石市",
"861810089", "云南省昆明市",
"861322146", "浙江省台州市",
"861329523", "江苏省泰州市",
"861813603", "江苏省徐州市",
"861589909", "新疆昌吉回族自治州",
"861591653", "广东省梅州市",
"861882769", "湖北省黄石市",
"861775972", "福建省龙岩市",
"861390142", "江苏省泰州市",
"861364465", "黑龙江省绥化市",
"861302648", "四川省绵阳市",
"861587008", "江西省萍乡市",
"861337292", "辽宁省朝阳市",
"861310723", "湖南省湘西土家族苗族自治州",
"861309359", "安徽省宿州市",
"861502612", "新疆克拉玛依市",
"861317849", "广东省清远市",
"861858720", "云南省大理白族自治州",
"861769502", "宁夏石嘴山市",
"861508947", "广东省梅州市",
"861366345", "山西省长治市",
"861348491", "陕西省西安市",
"861775106", "江苏省宿迁市",
"861835266", "江苏省南通市",
"861819148", "陕西省宝鸡市",
"861551632", "河南省三门峡市",
"86131129", "广东省中山市",
"861529371", "甘肃省庆阳市",
"861372293", "河北省邢台市",
"861822437", "四川省广安市",
"861326355", "黑龙江省哈尔滨市",
"861329849", "河南省三门峡市",
"861301278", "山东省聊城市",
"861803725", "河南省周口市",
"86147894", "湖南省株洲市",
"861579805", "江西省萍乡市",
"861369859", "贵州省六盘水市",
"861815653", "安徽省合肥市",
"861317465", "福建省莆田市",
"861310309", "河北省邢台市",
"861808950", "四川省成都市",
"861577911", "江西省抚州市",
"861562430", "山东省日照市",
"861816035", "新疆伊犁哈萨克自治州",
"861380230", "广东省潮州市",
"861539436", "浙江省金华市",
"861598292", "四川省德阳市",
"861809938", "新疆昌吉回族自治州",
"861365798", "江西省景德镇市",
"861802841", "广东省湛江市",
"861807039", "江西省南昌市",
"861518137", "四川省广元市",
"861872644", "安徽省蚌埠市",
"861705382", "重庆市",
"861321559", "安徽省黄山市",
"86145267", "陕西省西安市",
"861566094", "河南省商丘市",
"861883438", "山西省晋城市",
"861886022", "河南省南阳市",
"861769873", "河南省信阳市",
"86151618", "江苏省扬州市",
"861329465", "山西省吕梁市",
"861361549", "山东省临沂市",
"861839623", "福建省泉州市",
"861450237", "河北省沧州市",
"861580520", "江苏省徐州市",
"861345763", "广西玉林市",
"861339833", "四川省达州市",
"861800999", "新疆伊犁哈萨克自治州",
"861458113", "安徽省宿州市",
"861363726", "安徽省六安市",
"861766627", "广东省珠海市",
"861454695", "广东省惠州市",
"861539249", "福建省福州市",
"861592447", "内蒙古通辽市",
"861505459", "山东省淄博市",
"861561426", "河北省邢台市",
"861774810", "四川省泸州市",
"861538982", "内蒙古呼和浩特市",
"861860606", "福建省福州市",
"861301323", "河北省石家庄市",
"861815077", "福建省福州市",
"86178222", "天津市",
"861342834", "广东省汕头市",
"86185922", "陕西省西安市",
"861452181", "吉林省吉林市",
"861881211", "河北省石家庄市",
"861364523", "江苏省淮安市",
"861570928", "陕西省西安市",
"861368715", "湖北省荆州市",
"861707970", "浙江省丽水市",
"861521961", "广东省揭阳市",
"861818843", "四川省南充市",
"861880360", "河南省濮阳市",
"86139280", "广东省珠海市",
"861335625", "山东省聊城市",
"861367967", "四川省泸州市",
"861771510", "江苏省扬州市",
"861350840", "湖南省益阳市",
"861889852", "广东省湛江市",
"861802155", "江苏省无锡市",
"861333391", "河南省焦作市",
"861518369", "四川省德阳市",
"861709742", "广东省广州市",
"861310359", "山西省运城市",
"861808900", "西藏拉萨市",
"861590325", "河北省唐山市",
"861344071", "湖北省武汉市",
"861898917", "四川省达州市",
"8617638", "河南省郑州市",
"861770913", "陕西省渭南市",
"861859701", "青海省西宁市",
"861309723", "江西省景德镇市",
"861882979", "陕西省铜川市",
"861365589", "浙江省金华市",
"861302986", "黑龙江省哈尔滨市",
"861553624", "山西省晋中市",
"861331995", "新疆吐鲁番地区",
"861599188", "陕西省咸阳市",
"861858764", "广西百色市",
"861330494", "辽宁省本溪市",
"861584949", "内蒙古包头市",
"86184691", "云南省昆明市",
"861571545", "山东省烟台市",
"861850393", "河南省濮阳市",
"861346394", "河北省邢台市",
"861321509", "福建省龙岩市",
"861873406", "安徽省阜阳市",
"861318390", "四川省广安市",
"861871069", "陕西省商洛市",
"861333336", "河北省沧州市",
"861454338", "内蒙古巴彦淖尔市",
"861800148", "江苏省南通市",
"861764542", "黑龙江省佳木斯市",
"861503161", "河北省廊坊市",
"86187489", "贵州省黔西南布依族苗族自治州",
"861860656", "浙江省金华市",
"861391285", "江苏省南通市",
"861337883", "云南省临沧市",
"861820646", "山东省潍坊市",
"861581923", "广东省韶关市",
"86139492", "河南省洛阳市",
"861315164", "江苏省苏州市",
"861539491", "云南省大理白族自治州",
"861351929", "宁夏银川市",
"861890565", "安徽省巢湖市",
"861393370", "河北省邢台市",
"861319605", "吉林省辽源市",
"861587867", "广西河池市",
"861582553", "浙江省杭州市",
"861378070", "山东省聊城市",
"861537486", "内蒙古锡林郭勒盟",
"86139285", "广东省佛山市",
"861782030", "广东省中山市",
"861589268", "四川省雅安市",
"861555660", "安徽省安庆市",
"86152613", "江苏省连云港市",
"861327605", "福建省三明市",
"861819019", "四川省遂宁市",
"861812593", "广东省湛江市",
"861889802", "西藏日喀则地区",
"861314777", "吉林省吉林市",
"861328993", "新疆石河子市",
"861773972", "河南省信阳市",
"861500375", "河南省平顶山市",
"861889092", "新疆伊犁哈萨克自治州",
"86186542", "安徽省阜阳市",
"86137575", "浙江省绍兴市",
"861346450", "辽宁省葫芦岛市",
"861527052", "江西省上饶市",
"861857705", "广西防城港市",
"861770572", "浙江省湖州市",
"861330350", "山西省忻州市",
"861365864", "山东省济南市",
"861458556", "山东省日照市",
"861399773", "湖北省宜昌市",
"861317174", "河北省衡水市",
"861339862", "河北省保定市",
"861551878", "河南省安阳市",
"861899761", "新疆巴音郭楞蒙古自治州",
"861898704", "云南省昭通市",
"861592901", "陕西省榆林市",
"861371744", "广东省东莞市",
"86132186", "江苏省常州市",
"861535022", "江西省九江市",
"861761290", "陕西省咸阳市",
"861318454", "江西省赣州市",
"861519052", "江苏省常州市",
"86132456", "浙江省宁波市",
"86557", "安徽省宿州市",
"861557670", "湖南省衡阳市",
"861560875", "云南省保山市",
"861554578", "黑龙江省双鸭山市",
"86184873", "云南省昆明市",
"861379557", "四川省自贡市",
"861893647", "江苏省扬州市",
"861338399", "河南省平顶山市",
"861811442", "江苏省苏州市",
"861302995", "黑龙江省牡丹江市",
"861452135", "河北省沧州市",
"86187400", "辽宁省沈阳市",
"861368422", "四川省达州市",
"861805234", "江苏省连云港市",
"861564262", "辽宁省朝阳市",
"86138698", "山东省青岛市",
"861810348", "山西省运城市",
"861341970", "河南省驻马店市",
"861572656", "山东省烟台市",
"861317601", "山东省济南市",
"861779940", "新疆昌吉回族自治州",
"861850505", "福建省莆田市",
"861864808", "内蒙古锡林郭勒盟",
"861457059", "新疆伊犁哈萨克自治州",
"861526844", "浙江省宁波市",
"86130497", "广东省东莞市",
"861326487", "湖北省孝感市",
"861576939", "甘肃省兰州市",
"861328664", "河北省邢台市",
"861362733", "湖南省株洲市",
"861567200", "湖北省黄石市",
"861813521", "山西省晋城市",
"861595600", "安徽省宿州市",
"861357546", "浙江省杭州市",
"86132843", "河北省保定市",
"861505617", "安徽省淮北市",
"861861508", "山东省潍坊市",
"86137781", "四川省绵阳市",
"861300159", "山东省枣庄市",
"861806011", "福建省福州市",
"861596699", "山东省淄博市",
"861360021", "广东省韶关市",
"86185629", "山东省东营市",
"861834541", "黑龙江省大庆市",
"861458506", "河南省南阳市",
"861330300", "河北省邯郸市",
"861347342", "河北省保定市",
"861870430", "吉林省长春市",
"86180306", "四川省成都市",
"861527002", "江西省南昌市",
"861506547", "山东省济宁市",
"861858898", "广东省深圳市",
"861815482", "新疆乌鲁木齐市",
"861346400", "辽宁省沈阳市",
"86137570", "浙江省衢州市",
"861817067", "江西省赣州市",
"861508169", "河北省廊坊市",
"861560644", "山东省济南市",
"861805412", "甘肃省酒泉市",
"861591521", "广东省佛山市",
"861819473", "青海省海北藏族自治州",
"861592951", "陕西省安康市",
"861898754", "云南省保山市",
"861380975", "广东省湛江市",
"861381474", "江苏省南通市",
"861373238", "浙江省湖州市",
"861829067", "新疆昌吉回族自治州",
"861391231", "江苏省常州市",
"861359813", "河南省安阳市",
"861340573", "江苏省南通市",
"861591718", "广东省潮州市",
"861840561", "安徽省淮北市",
"861524060", "广西玉林市",
"86130841", "辽宁省大连市",
"861525637", "安徽省亳州市",
"861826031", "江苏省盐城市",
"861570341", "山西省太原市",
"861311123", "山西省阳泉市",
"861532571", "浙江省杭州市",
"861396660", "安徽省安庆市",
"861831841", "广东省云浮市",
"861327461", "黑龙江省哈尔滨市",
"861315475", "内蒙古通辽市",
"861572606", "山东省潍坊市",
"861343512", "广东省韶关市",
"861317651", "山东省青岛市",
"86151631", "山东省威海市",
"86158437", "吉林省辽源市",
"861568837", "新疆喀什地区",
"861814247", "陕西省西安市",
"861593442", "山西省晋中市",
"861519240", "山东省烟台市",
"861379344", "山东省日照市",
"861393418", "山西省晋中市",
"861816146", "四川省南充市",
"861458383", "福建省漳州市",
"861772864", "广东省江门市",
"86150638", "山东省烟台市",
"861850555", "安徽省马鞍山市",
"861457009", "山东省滨州市",
"861454686", "广东省深圳市",
"86135286", "广东省东莞市",
"861332323", "河北省张家口市",
"861567250", "湖北省宜昌市",
"861333688", "浙江省宁波市",
"861862928", "陕西省西安市",
"861852424", "辽宁省沈阳市",
"86147833", "河南省信阳市",
"86134214", "广东省中山市",
"861804358", "吉林省长春市",
"861509420", "云南省保山市",
"861538360", "山西省忻州市",
"86156688", "辽宁省沈阳市",
"86188234", "广东省深圳市",
"861347773", "湖北省黄石市",
"861536421", "湖南省长沙市",
"861454716", "浙江省台州市",
"861301593", "福建省厦门市",
"8615317", "上海市",
"861527779", "广西桂林市",
"861530312", "河北省保定市",
"861396542", "安徽省合肥市",
"861893379", "广东省湛江市",
"861871812", "广东省梅州市",
"861470737", "湖南省益阳市",
"861333718", "内蒙古包头市",
"861834998", "四川省自贡市",
"861330348", "山西省运城市",
"861524411", "山东省泰安市",
"861364393", "河南省濮阳市",
"861509554", "甘肃省平凉市",
"861860943", "甘肃省白银市",
"861820953", "宁夏吴忠市",
"861346448", "辽宁省铁岭市",
"861803136", "河北省石家庄市",
"861350098", "吉林省吉林市",
"861596721", "浙江省湖州市",
"861500969", "宁夏中卫市",
"861336081", "广东省汕头市",
"861870776", "广西百色市",
"86136766", "浙江省台州市",
"86139526", "江苏省泰州市",
"861367434", "吉林省四平市",
"861475754", "浙江省温州市",
"86157317", "河北省沧州市",
"861357938", "新疆阿克苏地区",
"861501747", "广东省惠州市",
"861333521", "山东省淄博市",
"86131744", "吉林省长春市",
"861838454", "四川省广安市",
"861573681", "河南省许昌市",
"861303447", "湖北省黄冈市",
"86184538", "山东省泰安市",
"861894288", "四川省广元市",
"861325896", "山东省枣庄市",
"861819862", "贵州省贵阳市",
"861477814", "广东省东莞市",
"86150753", "河北省张家口市",
"86156330", "河北省石家庄市",
"861778930", "甘肃省临夏回族自治州",
"861373032", "河北省张家口市",
"861779958", "新疆昌吉回族自治州",
"861872435", "黑龙江省绥化市",
"86189533", "山东省淄博市",
"861332305", "河北省唐山市",
"861315881", "四川省自贡市",
"861810350", "山西省忻州市",
"861308909", "黑龙江省黑河市",
"861513814", "河南省驻马店市",
"861520579", "浙江省金华市",
"861365311", "河北省石家庄市",
"861331442", "贵州省遵义市",
"861453513", "山东省济南市",
"861818399", "云南省临沧市",
"861811986", "安徽省蚌埠市",
"86150380", "河南省郑州市",
"86187972", "青海省海东地区",
"861856659", "广东省佛山市",
"861390868", "湖北省鄂州市",
"861823638", "河南省商丘市",
"86132944", "吉林省吉林市",
"861323828", "辽宁省铁岭市",
"861533373", "河南省新乡市",
"861580390", "河南省平顶山市",
"861527208", "湖北省咸宁市",
"861389947", "新疆和田地区",
"861473807", "河南省驻马店市",
"861531418", "山东省聊城市",
"86130722", "天津市",
"86151802", "江西省赣州市",
"861821991", "甘肃省兰州市",
"861452977", "广东省东莞市",
"86156478", "内蒙古巴彦淖尔市",
"86155412", "辽宁省鞍山市",
"861591129", "云南省普洱市",
"861776816", "江苏省宿迁市",
"861336146", "山东省聊城市",
"86152751", "山东省济南市",
"861894837", "广东省揭阳市",
"861505787", "浙江省丽水市",
"861778506", "贵州省铜仁地区",
"861526027", "福建省莆田市",
"861894514", "黑龙江省鸡西市",
"861820903", "新疆和田地区",
"861508561", "贵州省遵义市",
"86151951", "江苏省盐城市",
"861803618", "江苏省南通市",
"861857723", "广西来宾市",
"86187132", "河北省保定市",
"861475704", "浙江省嘉兴市",
"861380369", "黑龙江省双鸭山市",
"86150958", "重庆市",
"861560481", "黑龙江省哈尔滨市",
"861821936", "广东省梅州市",
"86189774", "广西梧州市",
"86156335", "河北省石家庄市",
"861864840", "内蒙古巴彦淖尔市",
"861569847", "山西省运城市",
"861529857", "江苏省盐城市",
"861307030", "新疆塔城地区",
"861533296", "内蒙古赤峰市",
"861890387", "河南省周口市",
"861838404", "四川省泸州市",
"861839461", "甘肃省庆阳市",
"861369484", "江西省抚州市",
"861808321", "贵州省铜仁地区",
"86152334", "河北省承德市",
"86134300", "广东省揭阳市",
"861339473", "内蒙古乌海市",
"861359988", "福建省莆田市",
"861892173", "江苏省泰州市",
"86152071", "湖北省武汉市",
"861840337", "河北省沧州市",
"861337067", "山东省淄博市",
"861815946", "福建省龙岩市",
"861335482", "内蒙古兴安盟",
"86189861", "湖北省武汉市",
"861803191", "河北省石家庄市",
"861308959", "黑龙江省伊春市",
"861452864", "青海省海南藏族自治州",
"861314541", "山东省济南市",
"861883878", "河南省商丘市",
"861332355", "宁夏吴忠市",
"861866708", "浙江省温州市",
"861335538", "山东省泰安市",
"861779908", "新疆克孜勒苏柯尔克孜自治州",
"861346524", "山东省威海市",
"861478775", "云南省玉溪市",
"861368631", "山东省威海市",
"861311841", "四川省资阳市",
"861822774", "四川省自贡市",
"861539876", "云南省文山壮族苗族自治州",
"86183848", "四川省达州市",
"861804340", "吉林省四平市",
"861535228", "甘肃省甘南藏族自治州",
"86150385", "河南省洛阳市",
"86136940", "吉林省辽源市",
"861300990", "黑龙江省大庆市",
"861395612", "安徽省六安市",
"861850523", "江苏省泰州市",
"86159620", "江苏省盐城市",
"86147934", "甘肃省庆阳市",
"861567248", "湖北省宜昌市",
"861889298", "新疆克拉玛依市",
"861511379", "广东省云浮市",
"861861540", "山东省济南市",
"861370246", "广东省中山市",
"861536663", "江苏省淮安市",
"861599791", "湖北省随州市",
"861325790", "江西省新余市",
"861839655", "福建省南平市",
"861576745", "广东省惠州市",
"861335077", "四川省达州市",
"861808948", "甘肃省张掖市",
"861853923", "河南省鹤壁市",
"861303901", "吉林省长春市",
"861522438", "山东省滨州市",
"861303590", "云南省红河哈尼族彝族自治州",
"861386687", "安徽省宿州市",
"861388464", "山东省烟台市",
"861309705", "江西省宜春市",
"86778", "广西河池市",
"86177267", "新疆乌鲁木齐市",
"86151598", "福建省泉州市",
"861315835", "贵州省黔东南苗族侗族自治州",
"861780035", "河北省唐山市",
"861321151", "广西柳州市",
"86150591", "福建省福州市",
"861872481", "云南省怒江傈僳族自治州",
"861527147", "湖北省宜昌市",
"861568477", "山东省泰安市",
"861815625", "安徽省宿州市",
"861338843", "浙江省杭州市",
"861454810", "广东省广州市",
"861381517", "江苏省镇江市",
"861304053", "新疆伊犁哈萨克自治州",
"861340226", "山东省潍坊市",
"86187679", "浙江省金华市",
"861774695", "河南省濮阳市",
"861452589", "福建省南平市",
"861700400", "广东省深圳市",
"861878413", "四川省宜宾市",
"861361855", "贵州省黔东南苗族侗族自治州",
"861832028", "广东省湛江市",
"861561692", "湖南省怀化市",
"861760768", "广东省潮州市",
"861881624", "江苏省徐州市",
"861370439", "吉林省白山市",
"861320193", "陕西省咸阳市",
"861772181", "四川省南充市",
"861846409", "山东省日照市",
"861334158", "吉林省长春市",
"861335653", "广东省湛江市",
"861321845", "江苏省苏州市",
"861319623", "吉林省吉林市",
"861324545", "山东省东营市",
"86155626", "山东省济南市",
"861590586", "浙江省台州市",
"861350858", "贵州省六盘水市",
"861364555", "安徽省马鞍山市",
"86189394", "河南省周口市",
"861533285", "内蒙古鄂尔多斯市",
"86158048", "内蒙古鄂尔多斯市",
"861338529", "湖北省孝感市",
"861355721", "广西南宁市",
"86136228", "广东省广州市",
"861870870", "云南省昭通市",
"861390794", "江西省抚州市",
"861803329", "广东省梅州市",
"861858202", "四川省自贡市",
"861361086", "辽宁省大连市",
"861313266", "广西贵港市",
"861775204", "甘肃省平凉市",
"861817883", "广西柳州市",
"861479979", "新疆昌吉回族自治州",
"861303951", "内蒙古呼和浩特市",
"861572943", "河南省漯河市",
"861532747", "湖北省襄樊市",
"861477078", "江西省抚州市",
"861366749", "湖南省益阳市",
"861841979", "甘肃省白银市",
"86150309", "河北省邢台市",
"861595015", "江苏省苏州市",
"861874973", "河南省洛阳市",
"861332593", "浙江省嘉兴市",
"861565922", "福建省泉州市",
"861374961", "河南省驻马店市",
"861800150", "江苏省常州市",
"861337918", "陕西省西安市",
"861539770", "四川省眉山市",
"86184511", "江苏省连云港市",
"861309755", "山西省晋城市",
"86138531", "山东省济南市",
"861586475", "山东省泰安市",
"861861497", "河南省郑州市",
"861786921", "云南省德宏傣族景颇族自治州",
"86177528", "湖南省长沙市",
"861339019", "辽宁省本溪市",
"861325006", "广东省珠海市",
"861887057", "江西省萍乡市",
"861510937", "甘肃省酒泉市",
"861590353", "山西省阳泉市",
"861537942", "甘肃省白银市",
"861321101", "广东省东莞市",
"861824090", "新疆伊犁哈萨克自治州",
"861539924", "陕西省咸阳市",
"861564917", "河南省信阳市",
"861811995", "安徽省马鞍山市",
"861302442", "江苏省常州市",
"861452798", "新疆克孜勒苏柯尔克孜自治州",
"861503569", "山西省太原市",
"861476565", "海南省海口市",
"861322244", "江苏省南京市",
"861846459", "山东省威海市",
"861571859", "贵州省黔西南布依族苗族自治州",
"861370792", "江西省九江市",
"861362254", "广东省珠海市",
"861830359", "山西省运城市",
"861573398", "河北省唐山市",
"861560435", "吉林省通化市",
"861580454", "黑龙江省佳木斯市",
"861321674", "浙江省宁波市",
"861350808", "四川省南充市",
"861551438", "河南省郑州市",
"861772046", "湖北省孝感市",
"861582525", "云南省昆明市",
"861325885", "吉林省通化市",
"861785843", "浙江省嘉兴市",
"861301305", "安徽省淮南市",
"861770888", "云南省丽江市",
"86152593", "福建省宁德市",
"86139727", "湖北省黄冈市",
"861310043", "广西桂林市",
"861810494", "辽宁省本溪市",
"861813625", "江苏省扬州市",
"861329505", "福建省泉州市",
"86150391", "河南省焦作市",
"861595995", "福建省泉州市",
"861301072", "江西省南昌市",
"861760978", "青海省西宁市",
"86147798", "江西省上饶市",
"861810546", "山东省东营市",
"861886742", "湖南省长沙市",
"86151398", "河南省三门峡市",
"861815391", "甘肃省陇南市",
"861330938", "甘肃省天水市",
"861576053", "四川省绵阳市",
"861860333", "河北省张家口市",
"861333077", "四川省南充市",
"861822693", "安徽省芜湖市",
"86153827", "广东省中山市",
"861599516", "江苏省盐城市",
"861305590", "福建省福州市",
"861318889", "山东省济南市",
"861305901", "黑龙江省哈尔滨市",
"861339999", "新疆伊犁哈萨克自治州",
"861866613", "广东省珠海市",
"861308819", "四川省南充市",
"861300623", "江西省鹰潭市",
"861885014", "福建省福州市",
"861337098", "山东省枣庄市",
"86158941", "新疆伊犁哈萨克自治州",
"861323790", "江西省新余市",
"861388679", "湖北省恩施土家族苗族自治州",
"861801085", "安徽省合肥市",
"861707044", "浙江省台州市",
"861304745", "山东省聊城市",
"861891954", "四川省甘孜藏族自治州",
"861808686", "四川省自贡市",
"861459330", "四川省宜宾市",
"861817746", "广西贺州市",
"861500147", "新疆喀什地区",
"861521490", "新疆和田地区",
"861458427", "河南省新乡市",
"861576677", "广东省揭阳市",
"861458358", "山东省济南市",
"861864883", "广西玉林市",
"861340298", "陕西省西安市",
"861535285", "内蒙古呼和浩特市",
"86155211", "广东省广州市",
"861302600", "安徽省安庆市",
"861869090", "新疆博尔塔拉蒙古自治州",
"861398942", "浙江省金华市",
"861532844", "四川省南充市",
"861829746", "安徽省六安市",
"861332487", "广西钦州市",
"861333653", "广东省茂名市",
"861814313", "吉林省延边朝鲜族自治州",
"861871902", "广东省中山市",
"861869756", "安徽省宿州市",
"861310705", "湖南省郴州市",
"861890455", "黑龙江省绥化市",
"861843490", "山西省运城市",
"861786938", "云南省怒江傈僳族自治州",
"861321469", "黑龙江省双鸭山市",
"861369545", "山东省烟台市",
"861390897", "西藏阿里地区",
"861568253", "四川省成都市",
"861847187", "湖北省孝感市",
"861316774", "安徽省合肥市",
"861783529", "山西省吕梁市",
"86135320", "广东省中山市",
"861528243", "四川省乐山市",
"861860980", "辽宁省鞍山市",
"861329555", "安徽省马鞍山市",
"861556034", "内蒙古鄂尔多斯市",
"86184311", "河北省石家庄市",
"861823872", "河南省商丘市",
"861576003", "四川省成都市",
"861316920", "广东省梅州市",
"861830723", "湖北省随州市",
"861563922", "河南省鹤壁市",
"861781746", "广东省湛江市",
"86177328", "河北省石家庄市",
"86138331", "河北省石家庄市",
"861365639", "山东省青岛市",
"861873566", "山西省运城市",
"861355738", "广西南宁市",
"861477954", "江西省九江市",
"86152111", "湖南省长沙市",
"861317555", "浙江省嘉兴市",
"861804556", "黑龙江省哈尔滨市",
"861597529", "广东省肇庆市",
"86150509", "江苏省宿迁市",
"861809494", "新疆伊犁哈萨克自治州",
"861453762", "广西南宁市",
"861892448", "广东省梅州市",
"861565114", "江苏省泰州市",
"861861356", "山西省晋城市",
"861840665", "广东省梅州市",
"86152393", "河南省濮阳市",
"861378944", "内蒙古乌兰察布市",
"861479769", "青海省海南藏族自治州",
"861835120", "江苏省常州市",
"861803753", "河南省驻马店市",
"861837523", "贵州省黔南布依族苗族自治州",
"861554293", "辽宁省葫芦岛市",
"861589190", "云南省文山壮族苗族自治州",
"861302650", "山东省青岛市",
"861828470", "四川省泸州市",
"8610", "北京市",
"861700642", "浙江省杭州市",
"861840947", "甘肃省酒泉市",
"861458308", "江西省新余市",
"86138754", "湖南省娄底市",
"861532675", "内蒙古通辽市",
"861827150", "湖北省武汉市",
"861452726", "湖北省武汉市",
"861536878", "云南省楚雄彝族自治州",
"861871952", "甘肃省甘南藏族自治州",
"861597843", "河南省郑州市",
"86189198", "甘肃省兰州市",
"861531245", "江苏省苏州市",
"861818138", "四川省巴中市",
"861377419", "湖北省宜昌市",
"861350067", "内蒙古鄂尔多斯市",
"861590729", "湖北省孝感市",
"861805045", "福建省龙岩市",
"861819150", "陕西省渭南市",
"86147993", "新疆乌鲁木齐市",
"861539960", "安徽省安庆市",
"861310755", "青海省西宁市",
"861894225", "江西省九江市",
"861809350", "甘肃省金昌市",
"86139326", "河北省廊坊市",
"861572980", "四川省德阳市",
"861840451", "黑龙江省哈尔滨市",
"861500208", "广东省深圳市",
"861350026", "广东省佛山市",
"861367541", "山东省济南市",
"86180229", "广东省江门市",
"861561557", "山东省济宁市",
"861336929", "陕西省延安市",
"861521547", "山东省济宁市",
"861562927", "湖北省武汉市",
"86147435", "广东省广州市",
"861800862", "湖北省武汉市",
"861327551", "安徽省合肥市",
"861321793", "江西省上饶市",
"861452767", "广西柳州市",
"861805136", "江苏省徐州市",
"861324484", "广东省广州市",
"861869850", "浙江省嘉兴市",
"861868838", "广东省广州市",
"861573367", "河北省廊坊市",
"861584515", "黑龙江省佳木斯市",
"861860362", "黑龙江省齐齐哈尔市",
"861319551", "安徽省合肥市",
"861571919", "陕西省铜川市",
"861569744", "湖南省张家界市",
"861535231", "甘肃省兰州市",
"861304282", "湖北省襄樊市",
"86151973", "湖南省株洲市",
"861815129", "江苏省徐州市",
"861510554", "安徽省淮南市",
"861315227", "陕西省铜川市",
"861338795", "江西省宜春市",
"861539382", "云南省西双版纳傣族自治州",
"861770825", "广东省中山市",
"86152138", "甘肃省庆阳市",
"861360741", "湖南省怀化市",
"861337858", "贵州省六盘水市",
"861457110", "湖北省武汉市",
"86150580", "浙江省宁波市",
"861363311", "河北省石家庄市",
"86135907", "广东省中山市",
"861535373", "陕西省西安市",
"861582588", "甘肃省陇南市",
"861874499", "贵州省黔西南布依族苗族自治州",
"86187803", "四川省绵阳市",
"861560522", "江苏省徐州市",
"861313881", "广东省东莞市",
"86189333", "广东省中山市",
"861880594", "福建省莆田市",
"861887219", "湖北省黄石市",
"8615680", "四川省成都市",
"861870966", "宁夏中卫市",
"861473068", "河北省石家庄市",
"861479493", "内蒙古鄂尔多斯市",
"86152773", "广西桂林市",
"861785880", "浙江省舟山市",
"861512425", "辽宁省葫芦岛市",
"86138318", "河北省衡水市",
"861300010", "北京市",
"86134505", "广东省佛山市",
"861894734", "内蒙古巴彦淖尔市",
"861317276", "广东省河源市",
"861450853", "江苏省扬州市",
"861501675", "广东省东莞市",
"861303811", "四川省泸州市",
"861500779", "广西北海市",
"861390007", "广东省广州市",
"86156530", "山东省菏泽市",
"861308268", "山东省威海市",
"861517068", "江西省吉安市",
"861780929", "陕西省西安市",
"861323896", "辽宁省盘锦市",
"861850465", "黑龙江省哈尔滨市",
"861558897", "山东省青岛市",
"861339257", "广东省中山市",
"861392459", "广东省深圳市",
"861839159", "陕西省铜川市",
"861508076", "湖南省湘潭市",
"861360414", "辽宁省本溪市",
"86132445", "黑龙江省哈尔滨市",
"861815688", "安徽省淮南市",
"86873", "云南省红河哈尼族彝族自治州",
"861453733", "湖南省株洲市",
"861350918", "陕西省西安市",
"861806424", "湖北省宜昌市",
"86130686", "广东省佛山市",
"861379467", "广东省韶关市",
"861327501", "福建省福州市",
"861327990", "新疆喀什地区",
"86147430", "四川省成都市",
"86151133", "广东省中山市",
"861472912", "陕西省榆林市",
"861550942", "甘肃省张掖市",
"861561507", "山东省聊城市",
"861384957", "河南省平顶山市",
"861452820", "四川省宜宾市",
"86152978", "江西省赣州市",
"861478647", "湖南省永州市",
"86147378", "四川省成都市",
"861595986", "福建省泉州市",
"861338880", "云南省昆明市",
"861346560", "山东省烟台市",
"861454950", "江苏省泰州市",
"861332072", "四川省攀枝花市",
"86150771", "广西南宁市",
"86188027", "湖北省武汉市",
"86151778", "广西河池市",
"861477717", "广西南宁市",
"86150864", "贵州省六盘水市",
"861319501", "宁夏银川市",
"861760797", "江西省赣州市",
"861823621", "河南省漯河市",
"861816244", "湖北省黄冈市",
"861319990", "新疆克拉玛依市",
"861528761", "云南省临沧市",
"861529704", "青海省海南藏族自治州",
"861890661", "浙江省宁波市",
"861774948", "河南省商丘市",
"861510347", "山西省临汾市",
"861390673", "浙江省嘉兴市",
"861361915", "陕西省安康市",
"86184475", "内蒙古呼和浩特市",
"861593648", "河南省安阳市",
"861571641", "河南省南阳市",
"861802574", "广东省潮州市",
"861337808", "湖南省株洲市",
"861788521", "贵州省安顺市",
"861342669", "江西省萍乡市",
"861320701", "江西省鹰潭市",
"861301487", "广西柳州市",
"861311417", "云南省文山壮族苗族自治州",
"86150585", "浙江省金华市",
"861533228", "陕西省宝鸡市",
"861808695", "四川省成都市",
"861787648", "广东省广州市",
"861801096", "安徽省阜阳市",
"861813946", "新疆喀什地区",
"861333538", "陕西省西安市",
"861805191", "江苏省徐州市",
"861339207", "广东省江门市",
"861314434", "吉林省四平市",
"861390057", "浙江省金华市",
"861329393", "山西省忻州市",
"86156535", "山东省烟台市",
"86150051", "江苏省南京市",
"861572271", "江苏省苏州市",
"861569411", "辽宁省大连市",
"86134500", "广东省东莞市",
"86152534", "山东省德州市",
"861535296", "青海省海西蒙古族藏族自治州",
"861590482", "内蒙古兴安盟",
"86136736", "河南省郑州市",
"861315008", "甘肃省陇南市",
"861347560", "山东省淄博市",
"861590538", "山东省泰安市",
"86150671", "浙江省杭州市",
"861536332", "广东省肇庆市",
"861361989", "河南省周口市",
"861368396", "河南省驻马店市",
"86151678", "浙江省温州市",
"861355843", "广西桂林市",
"86155989", "内蒙古兴安盟",
"861817244", "广西柳州市",
"861893420", "广东省云浮市",
"861820460", "黑龙江省哈尔滨市",
"861325909", "陕西省渭南市",
"861809442", "江苏省常州市",
"861364693", "福建省龙岩市",
"861807424", "浙江省宁波市",
"861362910", "陕西省咸阳市",
"861330648", "山东省青岛市",
"861575945", "福建省泉州市",
"86130786", "广东省中山市",
"861827222", "湖北省荆州市",
"861516704", "浙江省绍兴市",
"86155327", "河北省沧州市",
"861328811", "广东省揭阳市",
"861454525", "广西玉林市",
"861323268", "广东省湛江市",
"861339916", "陕西省汉中市",
"861308896", "陕西省西安市",
"861530612", "江苏省常州市",
"861893679", "江苏省泰州市",
"861580690", "山东省临沂市",
"861378992", "湖北省咸宁市",
"861882451", "广东省中山市",
"861365611", "江苏省常州市",
"861818699", "湖北省黄冈市",
"861700694", "广东省东莞市",
"861898822", "云南省德宏傣族景颇族自治州",
"861814064", "湖北省黄石市",
"861563684", "黑龙江省绥化市",
"861587120", "湖北省黄石市",
"861338721", "湖北省襄樊市",
"861533673", "浙江省衢州市",
"861340760", "山东省青岛市",
"861770891", "西藏拉萨市",
"86139582", "浙江省宁波市",
"861452781", "新疆乌鲁木齐市",
"861773756", "河南省平顶山市",
"86186723", "湖北省武汉市",
"86189563", "安徽省宣城市",
"861338518", "贵州省黔南布依族苗族自治州",
"86159906", "浙江省台州市",
"861538542", "安徽省黄山市",
"86187599", "福建省泉州市",
"861573381", "河北省保定市",
"861591388", "广东省惠州市",
"861522486", "河南省南阳市",
"86156360", "黑龙江省哈尔滨市",
"861334740", "陕西省西安市",
"86184568", "安徽省合肥市",
"861387272", "湖北省恩施土家族苗族自治州",
"861813388", "河北省张家口市",
"861800748", "湖南省长沙市",
"86157040", "吉林省辽源市",
"861313974", "新疆阿克苏地区",
"861550663", "山东省烟台市",
"861780858", "贵州省六盘水市",
"861315058", "云南省楚雄彝族自治州",
"861801473", "江苏省南京市",
"861380669", "浙江省温州市",
"861772611", "湖南省常德市",
"86186928", "湖南省娄底市",
"86133820", "江苏省南京市",
"861517575", "河北省保定市",
"861803318", "广东省韶关市",
"861354583", "湖北省宜昌市",
"861872498", "云南省大理白族自治州",
"861313720", "河南省安阳市",
"861570484", "内蒙古兴安盟",
"861816840", "江苏省南京市",
"861775162", "江苏省泰州市",
"861325959", "宁夏中卫市",
"861366541", "山东省济南市",
"861339028", "辽宁省铁岭市",
"86137453", "黑龙江省牡丹江市",
"861535868", "江苏省淮安市",
"861326551", "广东省广州市",
"861595348", "山东省济宁市",
"861314177", "内蒙古鄂尔多斯市",
"861830417", "辽宁省营口市",
"86147964", "江西省抚州市",
"861768968", "福建省泉州市",
"86152673", "浙江省金华市",
"861887285", "湖北省荆门市",
"86735", "湖南省郴州市",
"861877087", "江西省赣州市",
"861835040", "福建省莆田市",
"861510775", "广西玉林市",
"861856309", "山东省滨州市",
"861501240", "广东省广州市",
"861867020", "湖南省湘潭市",
"861804640", "福建省福州市",
"86187301", "河北省石家庄市",
"861516068", "福建省龙岩市",
"861807548", "安徽省黄山市",
"861340827", "四川省巴中市",
"861377496", "山东省菏泽市",
"861840637", "山东省济宁市",
"86153026", "广东省深圳市",
"861525561", "安徽省合肥市",
"86933", "甘肃省平凉市",
"861700932", "甘肃省兰州市",
"861361038", "广东省湛江市",
"861773706", "河南省商丘市",
"861398994", "西藏林芝地区",
"861336858", "贵州省六盘水市",
"861332655", "广东省清远市",
"86137846", "河北省唐山市",
"861805125", "江苏省连云港市",
"86156365", "黑龙江省绥化市",
"861526969", "山东省泰安市",
"861808621", "湖北省恩施土家族苗族自治州",
"861772198", "四川省泸州市",
"861878824", "云南省德宏傣族景颇族自治州",
"861859674", "福建省福州市",
"861308831", "四川省泸州市",
"861890687", "浙江省温州市",
"861329774", "广西梧州市",
"861452735", "湖南省郴州市",
"861331546", "河北省石家庄市",
"861519571", "江苏省连云港市",
"861823686", "河南省焦作市",
"861316555", "河北省衡水市",
"861593089", "河北省唐山市",
"861350146", "广东省清远市",
"861596529", "山东省东营市",
"86186240", "辽宁省沈阳市",
"86189818", "四川省成都市",
"861534443", "湖南省湘西土家族苗族自治州",
"861560498", "辽宁省阜新市",
"861333729", "湖南省邵阳市",
"861550994", "新疆昌吉回族自治州",
"86184813", "四川省自贡市",
"861813691", "江苏省常州市",
"861364877", "云南省玉溪市",
"861329920", "广西南宁市",
"861361577", "浙江省温州市",
"861894236", "江西省赣州市",
"861317774", "江西省赣州市",
"861832473", "安徽省合肥市",
"861591636", "广东省惠州市",
"861899161", "陕西省汉中市",
"861862484", "河南省洛阳市",
"861332461", "陕西省榆林市",
"861598035", "福建省莆田市",
"861527571", "山东省德州市",
"861352374", "河南省许昌市",
"861345132", "内蒙古包头市",
"86155682", "吉林省吉林市",
"861317920", "吉林省松原市",
"861453848", "四川省南充市",
"861304377", "河南省南阳市",
"861334846", "福建省漳州市",
"861571996", "新疆克拉玛依市",
"861569439", "吉林省白山市",
"861815049", "福建省泉州市",
"861348403", "浙江省杭州市",
"861471474", "广东省湛江市",
"861300759", "河南省安阳市",
"861517256", "湖北省襄樊市",
"861372201", "内蒙古呼伦贝尔市",
"861539277", "湖北省襄樊市",
"861896369", "江苏省苏州市",
"861588417", "四川省泸州市",
"861850437", "吉林省辽源市",
"861353795", "广东省阳江市",
"861531429", "山东省淄博市",
"861359991", "福建省厦门市",
"861881324", "广东省中山市",
"86157616", "贵州省贵阳市",
"86155905", "吉林省长春市",
"861335353", "山西省阳泉市",
"861777172", "湖北省宜昌市",
"861569246", "广东省东莞市",
"861887296", "湖北省荆州市",
"861836523", "安徽省淮北市",
"861898671", "湖北省荆州市",
"861310574", "浙江省宁波市",
"861398663", "湖北省咸宁市",
"861894449", "江苏省扬州市",
"861323819", "辽宁省鞍山市",
"861520771", "广西南宁市",
"861470975", "青海省西宁市",
"861803188", "河北省衡水市",
"861308790", "广西南宁市",
"861318815", "辽宁省朝阳市",
"861311723", "湖北省襄樊市",
"86137272", "广东省肇庆市",
"86186245", "辽宁省盘锦市",
"861882665", "广东省佛山市",
"86182244", "四川省成都市",
"861882947", "陕西省宝鸡市",
"861336098", "广东省河源市",
"86138561", "安徽省淮北市",
"861363339", "河北省张家口市",
"861359936", "福建省三明市",
"86131029", "河北省保定市",
"861550632", "山东省枣庄市",
"861888612", "贵州省贵阳市",
"86147698", "山东省德州市",
"861887231", "湖北省黄石市",
"861889970", "广东省汕尾市",
"86137510", "广东省深圳市",
"861569792", "江西省九江市",
"86152447", "黑龙江省哈尔滨市",
"861368385", "河南省洛阳市",
"861803629", "江苏省盐城市",
"861889724", "青海省西宁市",
"861300278", "山东省潍坊市",
"861335586", "浙江省台州市",
"861364964", "云南省红河哈尼族彝族自治州",
"86185548", "山东省青岛市",
"861308006", "吉林省白城市",
"861345570", "山东省东营市",
"861559084", "黑龙江省双鸭山市",
"861847161", "湖北省咸宁市",
"861372251", "河北省唐山市",
"861700963", "安徽省合肥市",
"86134274", "广东省江门市",
"861503243", "河北省唐山市",
"861808872", "黑龙江省齐齐哈尔市",
"861857841", "广东省佛山市",
"861522495", "河南省周口市",
"861821988", "甘肃省天水市",
"861813636", "江苏省徐州市",
"861770730", "湖南省岳阳市",
"86155900", "吉林省长春市",
"861894291", "湖北省武汉市",
"86414", "辽宁省本溪市",
"86130587", "浙江省台州市",
"861880542", "山东省青岛市",
"861529206", "湖南省益阳市",
"861358538", "江苏省徐州市",
"861826100", "江苏省苏州市",
"861535219", "甘肃省嘉峪关市",
"861811089", "安徽省亳州市",
"861571931", "甘肃省兰州市",
"861868372", "四川省成都市",
"861354540", "湖北省鄂州市",
"861393182", "河北省衡水市",
"861560426", "辽宁省大连市",
"861868005", "广东省东莞市",
"861357648", "江西省上饶市",
"86137315", "河北省唐山市",
"861876255", "江苏省淮安市",
"861772167", "江苏省常州市",
"861536942", "河北省衡水市",
"861319759", "广西北海市",
"861572558", "山东省聊城市",
"861358521", "江苏省南通市",
"86159243", "浙江省宁波市",
"861335729", "湖南省邵阳市",
"861309574", "浙江省宁波市",
"861881360", "广东省茂名市",
"861520961", "宁夏银川市",
"861860633", "山东省日照市",
"861768997", "福建省福州市",
"861705532", "山东省青岛市",
"861592664", "湖北省荆州市",
"861571928", "陕西省西安市",
"861360823", "四川省成都市",
"861582536", "宁夏石嘴山市",
"861367749", "湖南省长沙市",
"86130416", "上海市",
"861351840", "四川省眉山市",
"861770510", "江苏省盐城市",
"861381230", "江苏省宿迁市",
"861804683", "江西省上饶市",
"861311309", "广东省东莞市",
"861454214", "河南省信阳市",
"86139627", "江苏省南通市",
"861500571", "浙江省杭州市",
"861814613", "福建省莆田市",
"861328901", "新疆和田地区",
"861853454", "山西省忻州市",
"861339806", "西藏那曲地区",
"861328590", "福建省龙岩市",
"861333353", "山西省阳泉市",
"861386661", "安徽省安庆市",
"861812501", "广东省茂名市",
"861329964", "广西柳州市",
"861360549", "山东省临沂市",
"861780918", "陕西省西安市",
"861302300", "安徽省合肥市",
"861355795", "广西玉林市",
"86176372", "河南省安阳市",
"861320559", "安徽省黄山市",
"861558373", "四川省内江市",
"861813049", "安徽省阜阳市",
"861539403", "甘肃省甘南藏族自治州",
"861317964", "江苏省苏州市",
"861872467", "黑龙江省鸡西市",
"861582950", "陕西省宝鸡市",
"861341912", "四川省南充市",
"861333586", "浙江省台州市",
"861564256", "辽宁省朝阳市",
"861821646", "湖南省娄底市",
"861396594", "安徽省池州市",
"861454432", "江苏省南京市",
"861850351", "山西省太原市",
"861776899", "江苏省连云港市",
"861336026", "广东省肇庆市",
"861454588", "甘肃省兰州市",
"861528569", "贵州省毕节地区",
"861319709", "湖北省黄冈市",
"861332159", "吉林省白山市",
"861700773", "广西南宁市",
"861899459", "江苏省淮安市",
"861350929", "广东省广州市",
"861533794", "甘肃省兰州市",
"861893213", "湖南省株洲市",
"861373184", "安徽省黄山市",
"861537663", "山东省枣庄市",
"86138361", "黑龙江省哈尔滨市",
"861365339", "河北省邢台市",
"861575111", "江苏省盐城市",
"861894865", "广东省肇庆市",
"861572508", "山东省滨州市",
"861511175", "青海省海东地区",
"861890272", "广东省汕头市",
"86155726", "湖北省荆门市",
"861322840", "四川省眉山市",
"861705170", "北京市",
"861362850", "贵州省贵阳市",
"861311359", "内蒙古兴安盟",
"861458562", "山东省枣庄市",
"861330995", "新疆吐鲁番地区",
"861333303", "河北省张家口市",
"861317877", "广东省汕头市",
"861339856", "贵州省铜仁地区",
"861771913", "河南省漯河市",
"861863908", "河南省安阳市",
"861328951", "宁夏银川市",
"861323297", "广东省清远市",
"861873433", "山西省阳泉市",
"861368941", "甘肃省天水市",
"861811921", "新疆伊犁哈萨克自治州",
"86152809", "四川省绵阳市",
"861575698", "四川省阿坝藏族羌族自治州",
"86130387", "甘肃省兰州市",
"861319278", "广东省清远市",
"861320509", "福建省泉州市",
"861334783", "江苏省南京市",
"861374987", "河南省许昌市",
"861364774", "广西梧州市",
"861700342", "海南省海口市",
"861519066", "江苏省徐州市",
"861452515", "山东省烟台市",
"861302350", "江苏省徐州市",
"861570545", "山东省烟台市",
"861315826", "贵州省铜仁地区",
"861508979", "广东省湛江市",
"86187779", "广西北海市",
"861344697", "青海省海南藏族自治州",
"861458608", "湖北省随州市",
"861889760", "广西百色市",
"86130929", "陕西省咸阳市",
"861584767", "内蒙古呼和浩特市",
"861847409", "湖南省怀化市",
"861329877", "黑龙江省大庆市",
"861505243", "江苏省无锡市",
"861870069", "陕西省铜川市",
"861539453", "福建省福州市",
"86155527", "山东省东营市",
"861707160", "河南省南阳市",
"861528884", "山东省济南市",
"861362706", "江西省九江市",
"861860662", "浙江省宁波市",
"861368457", "黑龙江省哈尔滨市",
"861811348", "四川省广安市",
"861705563", "福建省福州市",
"861867279", "湖北省武汉市",
"861895679", "安徽省亳州市",
"861553446", "山西省太原市",
"861325268", "吉林省辽源市",
"86138894", "辽宁省大连市",
"861786986", "云南省西双版纳傣族自治州",
"861306701", "福建省三明市",
"861856723", "河南省鹤壁市",
"861780067", "内蒙古包头市",
"861315867", "四川省德阳市",
"861323909", "新疆博尔塔拉蒙古自治州",
"861339700", "江西省南昌市",
"861814020", "四川省成都市",
"861573945", "新疆乌鲁木齐市",
"861860508", "福建省福州市",
"861579741", "湖北省襄樊市",
"86152880", "云南省曲靖市",
"861337146", "山东省聊城市",
"86152651", "山东省临沂市",
"861808638", "湖北省宜昌市",
"861308828", "四川省自贡市",
"861313008", "辽宁省鞍山市",
"861537994", "甘肃省临夏回族自治州",
"861301159", "河北省石家庄市",
"86156259", "广东省佛山市",
"861802043", "江苏省常州市",
"861347524", "山东省枣庄市",
"861331350", "山西省忻州市",
"861771572", "四川省泸州市",
"861373314", "河南省南阳市",
"861302494", "福建省南平市",
"861599412", "河南省安阳市",
"86159720", "湖北省武汉市",
"86156560", "安徽省合肥市",
"861354497", "广东省江门市",
"861707912", "浙江省宁波市",
"861370744", "湖南省张家界市",
"861566248", "山东省潍坊市",
"86139382", "河南省郑州市",
"861399448", "山西省阳泉市",
"86137471", "内蒙古呼和浩特市",
"861322292", "江苏省无锡市",
"861820424", "辽宁省朝阳市",
"861564575", "黑龙江省鹤岗市",
"861893464", "湖北省黄冈市",
"861550878", "云南省楚雄彝族自治州",
"86189674", "浙江省金华市",
"861363611", "湖北省黄冈市",
"861821925", "广东省中山市",
"861862545", "河南省开封市",
"861339031", "辽宁省鞍山市",
"861586083", "福建省福州市",
"861822555", "安徽省马鞍山市",
"861306030", "陕西省渭南市",
"861583523", "山西省阳泉市",
"861535673", "浙江省嘉兴市",
"861539682", "江苏省徐州市",
"861558285", "山西省晋城市",
"861398014", "四川省绵阳市",
"861810442", "吉林省吉林市",
"861330986", "辽宁省大连市",
"861867708", "广西南宁市",
"86152168", "上海市",
"861351746", "湖南省永州市",
"861537632", "山东省枣庄市",
"86155268", "吉林省长春市",
"861818186", "四川省泸州市",
"861890361", "黑龙江省哈尔滨市",
"861338738", "湖南省娄底市",
"861510647", "山东省济宁市",
"861390373", "河南省新乡市",
"861533868", "贵州省毕节地区",
"861538211", "辽宁省沈阳市",
"861839487", "甘肃省庆阳市",
"861510965", "宁夏中卫市",
"861478347", "河南省南阳市",
"861363949", "山东省德州市",
"86136666", "浙江省杭州市",
"861339750", "湖南省岳阳市",
"861323959", "宁夏银川市",
"861881982", "广东省广州市",
"861366434", "吉林省四平市",
"861370411", "辽宁省大连市",
"86151163", "湖南省长沙市",
"861820548", "山东省泰安市",
"86156884", "山东省济南市",
"861572633", "山东省日照市",
"861535007", "江西省赣州市",
"861454463", "陕西省西安市",
"86181423", "陕西省西安市",
"86152885", "云南省楚雄彝族自治州",
"861399524", "宁夏固原市",
"861860558", "安徽省阜阳市",
"861889866", "广东省湛江市",
"861801207", "江苏省淮安市",
"861315974", "吉林省长春市",
"861815388", "湖南省长沙市",
"861878860", "贵州省遵义市",
"861347448", "陕西省榆林市",
"861891210", "江苏省镇江市",
"861313058", "辽宁省营口市",
"861329693", "内蒙古包头市",
"861803125", "河北省秦皇岛市",
"86156565", "安徽省合肥市",
"861773910", "河南省焦作市",
"861331300", "河北省邯郸市",
"861355786", "广西南宁市",
"861516807", "浙江省舟山市",
"861585465", "山东省威海市",
"86152564", "安徽省六安市",
"86457", "黑龙江省大兴安岭地区",
"861864244", "辽宁省阜新市",
"861819748", "青海省玉树藏族自治州",
"861808395", "新疆昌吉回族自治州",
"861555594", "安徽省宿州市",
"861832999", "陕西省铜川市",
"861590521", "江苏省徐州市",
"861313764", "河南省信阳市",
"86130622", "福建省龙岩市",
"861561644", "湖南省长沙市",
"861775706", "浙江省宁波市",
"861508587", "贵州省六盘水市",
"86186021", "上海市",
"861523561", "山西省晋城市",
"86131644", "重庆市",
"861458533", "河南省濮阳市",
"861317693", "山东省烟台市",
"861341573", "广东省佛山市",
"861768209", "安徽省阜阳市",
"861380474", "内蒙古呼和浩特市",
"861390231", "广东省深圳市",
"86187501", "福建省福州市",
"861390742", "湖南省常德市",
"861830841", "四川省德阳市",
"861476537", "内蒙古呼和浩特市",
"861853390", "河北省唐山市",
"861560467", "黑龙江省鸡西市",
"861372065", "陕西省西安市",
"861317007", "安徽省宿州市",
"861537720", "湖北省咸宁市",
"861390276", "广东省揭阳市",
"86187576", "浙江省金华市",
"861846460", "山东省潍坊市",
"861508207", "四川省泸州市",
"861333575", "浙江省绍兴市",
"86130300", "黑龙江省哈尔滨市",
"861571860", "贵州省贵阳市",
"861526588", "山东省日照市",
"861577502", "广东省茂名市",
"861800337", "河北省沧州市",
"86156257", "广东省东莞市",
"86181863", "湖北省黄冈市",
"861454147", "吉林省辽源市",
"861700469", "北京市",
"861399751", "湖北省咸宁市",
"861306524", "辽宁省铁岭市",
"861370680", "浙江省舟山市",
"861876531", "山东省济南市",
"861525096", "江苏省南京市",
"861860514", "江苏省扬州市",
"86182455", "黑龙江省绥化市",
"861558555", "吉林省延边朝鲜族自治州",
"861589249", "四川省绵阳市",
"86186454", "黑龙江省佳木斯市",
"861588982", "广东省茂名市",
"861303084", "福建省厦门市",
"86155529", "山东省临沂市",
"861315632", "山东省枣庄市",
"861313014", "辽宁省本溪市",
"861534611", "河南省三门峡市",
"861831211", "广东省阳江市",
"861360627", "江苏省南通市",
"861860837", "四川省阿坝藏族羌族自治州",
"861326760", "广东省中山市",
"861321642", "浙江省湖州市",
"861878341", "四川省凉山彝族自治州",
"861560143", "江苏省泰州市",
"861570702", "江西省九江市",
"861391301", "江苏省南京市",
"861373308", "安徽省宿州市",
"861814817", "四川省内江市",
"861453944", "广东省江门市",
"861804887", "四川省凉山彝族自治州",
"86139922", "陕西省榆林市",
"861814534", "黑龙江省哈尔滨市",
"861530520", "江苏省徐州市",
"861389833", "辽宁省抚顺市",
"861536881", "云南省西双版纳傣族自治州",
"86159953", "江苏省无锡市",
"861590754", "广东省汕头市",
"861472655", "四川省雅安市",
"8613442", "上海市",
"861771592", "江苏省盐城市",
"861330230", "广东省广州市",
"861843618", "河南省南阳市",
"861890840", "湖南省岳阳市",
"861589436", "云南省迪庆藏族自治州",
"861855245", "江苏省镇江市",
"861300267", "浙江省丽水市",
"861593517", "山西省吕梁市",
"861312365", "贵州省黔东南苗族侗族自治州",
"861339076", "江苏省南京市",
"861511041", "山西省太原市",
"861503991", "河南省周口市",
"861503500", "山西省忻州市",
"861539268", "山西省晋中市",
"861345811", "四川省攀枝花市",
"861317057", "云南省昭通市",
"861358917", "山东省潍坊市",
"861804238", "浙江省台州市",
"861783504", "山西省忻州市",
"86159758", "广东省清远市",
"861362070", "吉林省延边朝鲜族自治州",
"861336717", "湖北省宜昌市",
"861368882", "广东省深圳市",
"861592973", "陕西省西安市",
"861501638", "广东省肇庆市",
"861315994", "黑龙江省大庆市",
"861556815", "吉林省辽源市",
"861340551", "江苏省淮安市",
"861787517", "广东省河源市",
"86186588", "浙江省杭州市",
"861459415", "云南省迪庆藏族自治州",
"861894943", "安徽省芜湖市",
"861390393", "河南省濮阳市",
"861329057", "河北省邯郸市",
"861318312", "河南省焦作市",
"86182450", "黑龙江省哈尔滨市",
"861470648", "山东省青岛市",
"861479916", "新疆克拉玛依市",
"861308382", "河南省新乡市",
"861571727", "湖北省襄樊市",
"861768798", "江西省景德镇市",
"86137406", "辽宁省锦州市",
"861821884", "广东省湛江市",
"861896650", "陕西省宝鸡市",
"86134722", "河北省保定市",
"861841916", "甘肃省兰州市",
"861537867", "四川省资阳市",
"861532553", "浙江省温州市",
"861380494", "辽宁省大连市",
"861534949", "甘肃省陇南市",
"861570752", "广东省惠州市",
"861317673", "山东省潍坊市",
"861373427", "山西省运城市",
"86182868", "贵州省六盘水市",
"861528925", "陕西省安康市",
"861478721", "云南省大理白族自治州",
"861516538", "山东省泰安市",
"861820317", "河北省沧州市",
"861552191", "广东省揭阳市",
"861891929", "甘肃省甘南藏族自治州",
"861350565", "安徽省合肥市",
"861306448", "河南省平顶山市",
"861363480", "黑龙江省哈尔滨市",
"861478518", "贵州省六盘水市",
"861361568", "安徽省阜阳市",
"861579408", "广东省深圳市",
"861569933", "新疆石河子市",
"861521136", "湖南省衡阳市",
"861590704", "江西省抚州市",
"86137724", "陕西省西安市",
"861304368", "湖南省娄底市",
"861347751", "湖北省武汉市",
"861826637", "山东省枣庄市",
"861808375", "江苏省宿迁市",
"861344893", "西藏拉萨市",
"861314168", "江苏省南京市",
"861709351", "河南省南阳市",
"861344003", "四川省广元市",
"861524343", "河北省唐山市",
"861342442", "广东省深圳市",
"861336904", "新疆伊犁哈萨克自治州",
"861519716", "湖南省湘潭市",
"861376572", "贵州省六盘水市",
"861308960", "黑龙江省伊春市",
"861304456", "福建省泉州市",
"861871615", "四川省宜宾市",
"861573863", "河南省周口市",
"861338937", "甘肃省酒泉市",
"861378733", "湖南省株洲市",
"861824869", "浙江省台州市",
"861516077", "福建省泉州市",
"861889010", "湖南省郴州市",
"861507791", "安徽省合肥市",
"861869445", "陕西省榆林市",
"861774052", "湖北省武汉市",
"861454779", "山东省青岛市",
"861769851", "河南省洛阳市",
"861890746", "湖南省永州市",
"861353647", "广东省汕尾市",
"86135878", "浙江省温州市",
"861528646", "贵州省六盘水市",
"861568656", "陕西省铜川市",
"861373466", "青海省西宁市",
"861532638", "吉林省松原市",
"861322361", "山西省朔州市",
"861537826", "四川省广元市",
"861822742", "四川省资阳市",
"861508148", "河北省衡水市",
"861318182", "山东省泰安市",
"861355775", "广西玉林市",
"861847813", "湖南省常德市",
"861862752", "湖南省岳阳市",
"861571766", "河北省廊坊市",
"861390505", "福建省泉州市",
"861538043", "江苏省南京市",
"861848199", "四川省巴中市",
"861454208", "河南省洛阳市",
"861348297", "河北省秦皇岛市",
"861308112", "河北省石家庄市",
"861558393", "四川省资阳市",
"861450428", "辽宁省大连市",
"861815104", "江苏省徐州市",
"861380350", "江西省南昌市",
"861302165", "山东省威海市",
"861365443", "吉林省延边朝鲜族自治州",
"861766021", "山东省青岛市",
"861590917", "陕西省安康市",
"861572288", "江苏省徐州市",
"861328570", "浙江省衢州市",
"861500900", "新疆乌鲁木齐市",
"86188744", "湖南省张家界市",
"861827665", "广西百色市",
"86139629", "江苏省南通市",
"86181518", "江苏省徐州市",
"861304406", "山东省临沂市",
"861525085", "江苏省淮安市",
"861805490", "福建省南平市",
"861336954", "宁夏固原市",
"861517729", "广西南宁市",
"861817405", "江西省宜春市",
"861471546", "广东省云浮市",
"86185209", "广东省佛山市",
"861501503", "广东省江门市",
"861328132", "四川省乐山市",
"861776879", "江苏省镇江市",
"86182513", "江苏省南通市",
"861829405", "甘肃省平凉市",
"861899813", "广东省惠州市",
"861769801", "河南省许昌市",
"861396574", "安徽省阜阳市",
"861572837", "广东省湛江市",
"861700793", "江西省九江市",
"861533774", "江苏省南京市",
"861500536", "山东省潍坊市",
"861361483", "内蒙古阿拉善盟",
"861569962", "黑龙江省齐齐哈尔市",
"861331474", "内蒙古兴安盟",
"861470015", "江苏省连云港市",
"861351361", "山西省太原市",
"86187777", "广西钦州市",
"861360666", "浙江省台州市",
"861879526", "宁夏中卫市",
"861774240", "陕西省西安市",
"861364794", "江西省抚州市",
"861510529", "江苏省镇江市",
"861853418", "山西省晋中市",
"86566", "安徽省池州市",
"861761434", "吉林省四平市",
"861564586", "黑龙江省鸡西市",
"861333256", "湖南省常德市",
"861450307", "河北省衡水市",
"861582571", "浙江省嘉兴市",
"861390555", "安徽省马鞍山市",
"861881841", "广东省广州市",
"861867907", "江西省赣州市",
"86189286", "广东省佛山市",
"861837142", "湖北省黄石市",
"861385946", "福建省南平市",
"861760935", "甘肃省武威市",
"861780954", "宁夏固原市",
"861707593", "福建省泉州市",
"861865122", "江苏省常州市",
"86130389", "陕西省榆林市",
"861500950", "宁夏银川市",
"861558276", "山西省吕梁市",
"861808283", "新疆伊犁哈萨克自治州",
"861323277", "广东省河源市",
"861358068", "广东省云浮市",
"861330975", "青海省果洛藏族自治州",
"861800665", "浙江省宁波市",
"861352394", "河南省周口市",
"861832493", "安徽省宿州市",
"861317794", "江西省抚州市",
"861476026", "福建省龙岩市",
"861854302", "吉林省通化市",
"861375466", "山东省滨州市",
"861889551", "安徽省阜阳市",
"861332044", "云南省怒江傈僳族自治州",
"86185291", "广东省广州市",
"861571976", "青海省西宁市",
"861342650", "江西省上饶市",
"861581612", "广东省湛江市",
"861355965", "福建省漳州市",
"861304397", "河南省郑州市",
"861800947", "甘肃省嘉峪关市",
"861550720", "湖北省宜昌市",
"861524962", "河南省安阳市",
"861705062", "陕西省西安市",
"861844930", "新疆阿克苏地区",
"8613540", "四川省成都市",
"861812760", "广东省云浮市",
"861561743", "河南省郑州市",
"861813671", "江苏省常州市",
"861364897", "西藏阿里地区",
"861459248", "四川省攀枝花市",
"861313663", "黑龙江省齐齐哈尔市",
"861560478", "内蒙古巴彦淖尔市",
"861550974", "青海省海南藏族自治州",
"861521753", "广东省东莞市",
"861503346", "河北省唐山市",
"861887276", "湖北省黄石市",
"861807187", "湖北省咸宁市",
"861363443", "吉林省延边朝鲜族自治州",
"861510786", "广西百色市",
"861777192", "湖北省十堰市",
"861306215", "福建省莆田市",
"861308924", "吉林省吉林市",
"86145473", "浙江省宁波市",
"861322687", "广东省深圳市",
"861323453", "黑龙江省牡丹江市",
"861586438", "山东省聊城市",
"861450496", "辽宁省锦州市",
"861556955", "新疆喀什地区",
"861880080", "四川省遂宁市",
"86180311", "河北省石家庄市",
"861308770", "广西防城港市",
"861504572", "黑龙江省双鸭山市",
"861576456", "黑龙江省黑河市",
"861453334", "浙江省杭州市",
"861470995", "新疆吐鲁番地区",
"861520791", "江西省南昌市",
"861898691", "湖北省十堰市",
"861879789", "江西省萍乡市",
"861310594", "福建省龙岩市",
"861539297", "湖北省宜昌市",
"861529303", "甘肃省临夏回族自治州",
"861471494", "广东省佛山市",
"861376853", "广西桂林市",
"861454969", "黑龙江省黑河市",
"861535774", "安徽省巢湖市",
"861386244", "江苏省镇江市",
"861889501", "宁夏银川市",
"861530889", "云南省昆明市",
"861781117", "宁夏吴忠市",
"86182313", "河北省张家口市",
"8618557", "浙江省杭州市",
"86187796", "江西省吉安市",
"861520736", "湖南省常德市",
"861528039", "福建省龙岩市",
"861569772", "广西来宾市",
"861766038", "山东省枣庄市",
"861814957", "福建省泉州市",
"861519950", "新疆阿勒泰地区",
"861475729", "浙江省温州市",
"861336078", "广东省揭阳市",
"861598423", "四川省资阳市",
"861351687", "浙江省杭州市",
"861309239", "江苏省连云港市",
"861370643", "山东省淄博市",
"861527536", "山东省潍坊市",
"861323403", "辽宁省沈阳市",
"86155844", "吉林省长春市",
"861824445", "四川省内江市",
"86188466", "黑龙江省大庆市",
"861779042", "四川省成都市",
"861534339", "湖南省邵阳市",
"861509843", "山东省聊城市",
"861325277", "辽宁省朝阳市",
"861780078", "青海省西宁市",
"861588324", "四川省资阳市",
"861315878", "四川省资阳市",
"861335256", "黑龙江省黑河市",
"861855418", "山东省泰安市",
"861356517", "新疆阿勒泰地区",
"861890883", "云南省临沧市",
"861532621", "辽宁省丹东市",
"861529353", "甘肃省金昌市",
"861347193", "广西玉林市",
"861783937", "河南省洛阳市",
"861881417", "广东省河源市",
"861345901", "福建省厦门市",
"861592241", "安徽省合肥市",
"861870539", "山东省临沂市",
"861840833", "四川省凉山彝族自治州",
"861340623", "山东省滨州市",
"861337565", "山东省枣庄市",
"861839912", "新疆喀什地区",
"861376803", "广西桂林市",
"861346509", "山东省滨州市",
"861808892", "云南省玉溪市",
"861522475", "河南省商丘市",
"861356834", "四川省达州市",
"86180475", "内蒙古通辽市",
"861561261", "河北省廊坊市",
"861315014", "甘肃省张掖市",
"861326724", "广东省深圳市",
"861771419", "江苏省南京市",
"861510880", "云南省文山壮族苗族自治州",
"861575832", "云南省楚雄彝族自治州",
"861705033", "重庆市",
"861864661", "黑龙江省齐齐哈尔市",
"861334684", "河南省周口市",
"861513081", "河北省沧州市",
"861882748", "湖北省襄樊市",
"861341487", "广东省湛江市",
"861364673", "浙江省嘉兴市",
"861590807", "山东省日照市",
"861391437", "江苏省南通市",
"861477081", "江西省赣州市",
"861305084", "辽宁省铁岭市",
"86155329", "河北省邢台市",
"861780537", "山东省济宁市",
"861500810", "四川省自贡市",
"861530564", "安徽省六安市",
"861566630", "山东省威海市",
"861338347", "山西省临汾市",
"861319267", "广东省佛山市",
"861847903", "江西省上饶市",
"861316742", "湖南省株洲市",
"861380546", "山东省东营市",
"861479096", "安徽省芜湖市",
"861560310", "河北省邯郸市",
"861823844", "河南省南阳市",
"86187376", "河南省信阳市",
"861584778", "内蒙古呼和浩特市",
"86155987", "内蒙古鄂尔多斯市",
"86130500", "辽宁省鞍山市",
"861329868", "湖南省长沙市",
"861335575", "浙江省绍兴市",
"861368376", "河南省信阳市",
"861804221", "浙江省金华市",
"861846424", "山东省青岛市",
"861571824", "广东省深圳市",
"86186950", "湖北省恩施土家族苗族自治州",
"861880705", "江西省宜春市",
"861378106", "河南省平顶山市",
"861350423", "辽宁省抚顺市",
"861899953", "新疆石河子市",
"861800401", "辽宁省沈阳市",
"861596965", "山东省烟台市",
"861830324", "河北省邯郸市",
"861501621", "广东省河源市",
"861580429", "辽宁省葫芦岛市",
"86134686", "陕西省西安市",
"861321450", "黑龙江省哈尔滨市",
"86159131", "广东省广州市",
"861361440", "吉林省长春市",
"861818420", "贵州省遵义市",
"861859932", "新疆哈密地区",
"861550826", "四川省广安市",
"861378972", "内蒙古包头市",
"861776144", "四川省成都市",
"861339561", "安徽省淮北市",
"861770871", "云南省昆明市",
"861700674", "浙江省温州市",
"861533693", "浙江省金华市",
"861459107", "广西柳州市",
"861773070", "陕西省渭南市",
"861818679", "湖北省宜昌市",
"861375308", "山西省朔州市",
"861814441", "广东省潮州市",
"861336537", "山东省济宁市",
"86178558", "浙江省宁波市",
"861823675", "河南省郑州市",
"861808052", "四川省巴中市",
"86180470", "内蒙古呼伦贝尔市",
"861479700", "青海省西宁市",
"86186388", "河南省洛阳市",
"86183293", "陕西省渭南市",
"861857982", "广西柳州市",
"861590857", "贵州省毕节地区",
"861867534", "广东省中山市",
"861803304", "广东省东莞市",
"861801493", "江苏省无锡市",
"861700151", "江苏省无锡市",
"86181331", "安徽省阜阳市",
"861313994", "新疆昌吉回族自治州",
"861301044", "江苏省常州市",
"861387292", "湖北省荆门市",
"861340010", "河北省邯郸市",
"861863804", "河南省商丘市",
"86130505", "辽宁省大连市",
"861505500", "安徽省滁州市",
"86180338", "河北省石家庄市",
"861505991", "福建省龙岩市",
"861532872", "四川省内江市",
"861831542", "山东省青岛市",
"861899903", "新疆哈密地区",
"861800451", "黑龙江省哈尔滨市",
"861769911", "新疆乌鲁木齐市",
"861860734", "湖南省衡阳市",
"861323682", "辽宁省鞍山市",
"861880755", "广东省深圳市",
"861377476", "福建省漳州市",
"861850142", "江苏省泰州市",
"861700845", "浙江省绍兴市",
"861772178", "江苏省徐州市",
"86184229", "上海市",
"861357975", "新疆石河子市",
"861840862", "宁夏石嘴山市",
"861338554", "贵州省黔南布依族苗族自治州",
"861510795", "江西省宜春市",
"861760345", "山西省长治市",
"861450485", "辽宁省鞍山市",
"861365480", "内蒙古兴安盟",
"861479031", "安徽省六安市",
"861314197", "湖南省邵阳市",
"861375427", "浙江省丽水市",
"861834842", "河南省郑州市",
"861459157", "广西北海市",
"861825747", "浙江省金华市",
"86139986", "辽宁省大连市",
"86150424", "辽宁省大连市",
"861896300", "山东省德州市",
"861534311", "河北省石家庄市",
"861834054", "辽宁省葫芦岛市",
"861350954", "福建省南平市",
"861332124", "甘肃省甘南藏族自治州",
"861360458", "黑龙江省双鸭山市",
"861806317", "山东省滨州市",
"861870728", "湖北省十堰市",
"86180164", "上海市",
"861454571", "四川省达州市",
"861321773", "广西桂林市",
"86159502", "江苏省盐城市",
"861360327", "河北省沧州市",
"861805654", "安徽省合肥市",
"861875851", "浙江省绍兴市",
"861370380", "河南省驻马店市",
"861572236", "青海省玉树藏族自治州",
"861315332", "山东省枣庄市",
"861823240", "河北省承德市",
"86181833", "四川省乐山市",
"861300827", "辽宁省铁岭市",
"861369702", "江西省九江市",
"861800637", "山东省滨州市",
"861339587", "浙江省温州市",
"861868507", "贵州省黔南布依族苗族自治州",
"861379143", "山东省枣庄市",
"861822897", "四川省泸州市",
"861458184", "浙江省湖州市",
"86151020", "广东省广州市",
"861856982", "河南省焦作市",
"86180227", "广东省佛山市",
"861870511", "江苏省盐城市",
"861335704", "浙江省金华市",
"861348831", "陕西省西安市",
"861830660", "广东省汕尾市",
"86151442", "吉林省吉林市",
"861355937", "福建省泉州市",
"86181654", "陕西省西安市",
"861576873", "广东省惠州市",
"86150706", "江西省吉安市",
"861823002", "河北省保定市",
"861561287", "河北省唐山市",
"861779094", "辽宁省沈阳市",
"861479473", "内蒙古鄂尔多斯市",
"861450419", "辽宁省辽阳市",
"86131826", "江苏省苏州市",
"861880574", "浙江省宁波市",
"861572449", "辽宁省阜新市",
"861323876", "云南省文山壮族苗族自治州",
"861508096", "湖南省岳阳市",
"861500799", "江西省萍乡市",
"861317296", "广东省韶关市",
"861868344", "四川省成都市",
"8615811", "北京市",
"861319281", "广东省惠州市",
"861304552", "安徽省六安市",
"861338775", "广西玉林市",
"861889323", "甘肃省定西市",
"861874479", "贵州省黔南布依族苗族自治州",
"861535393", "陕西省安康市",
"86135909", "广东省中山市",
"861321342", "河南省鹤壁市",
"861878641", "贵州省黔东南苗族侗族自治州",
"861361352", "山西省大同市",
"861523473", "山西省运城市",
"861875145", "江苏省盐城市",
"861815262", "湖南省岳阳市",
"861333857", "福建省泉州市",
"861332092", "四川省乐山市",
"861360408", "辽宁省大连市",
"861330737", "湖南省益阳市",
"861350904", "广东省揭阳市",
"861317742", "湖北省咸宁市",
"861364228", "广东省云浮市",
"861508031", "福建省厦门市",
"861390693", "福建省福州市",
"861760777", "广西钦州市",
"861319970", "新疆昌吉回族自治州",
"861470348", "山西省吕梁市",
"86145815", "浙江省绍兴市",
"86188029", "陕西省西安市",
"861300760", "河南省郑州市",
"861898946", "浙江省杭州市",
"861327724", "湖北省荆门市",
"86181561", "安徽省淮北市",
"861505925", "福建省宁德市",
"86183408", "辽宁省大连市",
"861877444", "湖南省娄底市",
"861879422", "甘肃省兰州市",
"861316868", "广东省珠海市",
"86177090", "四川省绵阳市",
"861550835", "四川省雅安市",
"861476081", "江苏省徐州市",
"861351405", "福建省莆田市",
"861888815", "江苏省苏州市",
"86151025", "河北省唐山市",
"861327970", "新疆喀什地区",
"86180568", "安徽省亳州市",
"861570047", "四川省广元市",
"861362445", "吉林省通化市",
"861805171", "江苏省盐城市",
"861337814", "四川省德阳市",
"861322455", "黑龙江省绥化市",
"861535276", "新疆巴音郭楞蒙古自治州",
"861500588", "浙江省丽水市",
"861310542", "山东省青岛市",
"861335068", "四川省自贡市",
"861500432", "吉林省吉林市",
"861329373", "山西省阳泉市",
"861572291", "江苏省南京市",
"861337537", "山东省济宁市",
"861820617", "江苏省无锡市",
"861536764", "湖南省邵阳市",
"861537227", "浙江省丽水市",
"86157103", "河北省石家庄市",
"86134786", "辽宁省大连市",
"861802594", "广东省东莞市",
"861333807", "江苏省南通市",
"861899548", "宁夏中卫市",
"861510721", "湖北省荆州市",
"86182838", "四川省德阳市",
"861305570", "福建省南平市",
"861340709", "江西省南昌市",
"861807161", "江苏省南通市",
"861308453", "河北省秦皇岛市",
"861769939", "新疆伊犁哈萨克自治州",
"861390964", "安徽省淮南市",
"861333097", "四川省凉山彝族自治州",
"861323770", "广西南宁市",
"86182811", "四川省泸州市",
"861374736", "内蒙古乌海市",
"861874013", "辽宁省本溪市",
"861893616", "江苏省南通市",
"861339979", "新疆和田地区",
"861530815", "四川省凉山彝族自治州",
"861387244", "湖北省荆州市",
"861508856", "浙江省温州市",
"86410", "辽宁省铁岭市",
"861479019", "安徽省六安市",
"861313942", "甘肃省定西市",
"861760998", "新疆喀什地区",
"861301092", "辽宁省丹东市",
"861327235", "湖南省郴州市",
"861595975", "福建省南平市",
"861525148", "江苏省徐州市",
"861815371", "湖南省益阳市",
"86187696", "山东省滨州市",
"861873649", "河南省三门峡市",
"861565158", "江苏省无锡市",
"861505646", "安徽省芜湖市",
"86177350", "山西省忻州市",
"861520725", "湖北省黄冈市",
"861521629", "江西省吉安市",
"861357517", "湖南省常德市",
"861895121", "江苏省常州市",
"861346193", "河南省鹤壁市",
"861843470", "山西省忻州市",
"861815233", "宁夏吴忠市",
"86135358", "广东省佛山市",
"861380650", "浙江省杭州市",
"861336565", "安徽省巢湖市",
"86135602", "广东省广州市",
"861347509", "山东省滨州市",
"861859642", "福建省厦门市",
"861526536", "山东省潍坊市",
"861875091", "福建省厦门市",
"861521470", "浙江省金华市",
"861788917", "西藏那曲地区",
"861596937", "云南省丽江市",
"861388699", "湖北省武汉市",
"861450657", "黑龙江省鹤岗市",
"861869070", "贵州省黔南布依族苗族自治州",
"861843629", "河南省新乡市",
"861312451", "黑龙江省哈尔滨市",
"861552188", "广东省揭阳市",
"861325960", "宁夏银川市",
"861576697", "广东省湛江市",
"861892701", "广东省河源市",
"861809474", "浙江省宁波市",
"861308403", "安徽省六安市",
"861858421", "四川省南充市",
"86150507", "江苏省扬州市",
"861340759", "江苏省常州市",
"86135980", "河南省郑州市",
"861335917", "陕西省宝鸡市",
"861390877", "云南省玉溪市",
"861370962", "广东省茂名市",
"861508806", "广东省广州市",
"861893138", "河北省保定市",
"861871131", "湖南省湘潭市",
"86189222", "广东省广州市",
"861399509", "宁夏银川市",
"861478843", "河南省洛阳市",
"86170843", "吉林省长春市",
"861882833", "四川省成都市",
"861348790", "湖南省常德市",
"861452968", "广东省肇庆市",
"861580782", "广西柳州市",
"861516586", "山东省枣庄市",
"861334922", "安徽省蚌埠市",
"861860449", "吉林省吉林市",
"861820459", "黑龙江省大庆市",
"86177355", "山西省长治市",
"861374791", "内蒙古锡林郭勒盟",
"861372567", "广东省河源市",
"86180813", "四川省乐山市",
"861475653", "河北省唐山市",
"861556520", "河南省鹤壁市",
"861300866", "云南省昆明市",
"861476035", "福建省南平市",
"861458314", "江西省萍乡市",
"861550881", "云南省西双版纳傣族自治州",
"861450607", "吉林省白山市",
"861806187", "江苏省常州市",
"861587582", "广东省肇庆市",
"861776192", "江苏省苏州市",
"86136369", "福建省泉州市",
"861356230", "山东省滨州市",
"861317285", "广东省汕尾市",
"861351661", "广东省佛山市",
"861536898", "云南省大理白族自治州",
"861508085", "湖南省湘西土家族苗族自治州",
"861478529", "贵州省铜仁地区",
"861577456", "黑龙江省黑河市",
"861312401", "福建省福州市",
"861554273", "辽宁省鞍山市",
"861816117", "四川省成都市",
"861313363", "江西省九江市",
"86177269", "甘肃省兰州市",
"861512190", "宁夏银川市",
"861315942", "福建省福州市",
"861879535", "宁夏中卫市",
"861568497", "湖南省永州市",
"861854568", "黑龙江省黑河市",
"861860865", "湖北省鄂州市",
"861452259", "浙江省金华市",
"861337954", "陕西省西安市",
"86136192", "陕西省西安市",
"861304697", "福建省泉州市",
"861867216", "湖北省襄樊市",
"861551202", "河北省唐山市",
"861590256", "贵州省铜仁地区",
"861800365", "黑龙江省哈尔滨市",
"861760926", "陕西省汉中市",
"861355347", "广东省湛江市",
"861303570", "广东省河源市",
"861533555", "内蒙古呼和浩特市",
"861807409", "浙江省嘉兴市",
"861381348", "江苏省徐州市",
"861325924", "陕西省宝鸡市",
"861779707", "青海省海西蒙古族藏族自治州",
"861339769", "湖南省邵阳市",
"861345839", "四川省资阳市",
"861355504", "黑龙江省鸡西市",
"861836142", "江苏省扬州市",
"861554328", "吉林省长春市",
"861859450", "福建省宁德市",
"861323960", "甘肃省庆阳市",
"861380442", "吉林省吉林市",
"861359787", "湖北省十堰市",
"861379478", "广东省阳江市",
"861390774", "广西梧州市",
"861580418", "辽宁省阜新市",
"86187677", "浙江省温州市",
"861500525", "江苏省扬州市",
"861813233", "河北省邯郸市",
"86135558", "辽宁省沈阳市",
"861770322", "河北省保定市",
"861453634", "江苏省南京市",
"861575223", "云南省曲靖市",
"861503646", "河南省三门峡市",
"86177550", "安徽省滁州市",
"861561672", "湖南省湘潭市",
"861321932", "四川省巴中市",
"861861477", "内蒙古鄂尔多斯市",
"861351387", "河南省周口市",
"861523999", "河南省濮阳市",
"861586495", "山东省淄博市",
"86133798", "海南省海口市",
"861539790", "江西省新余市",
"861319866", "四川省绵阳市",
"861332573", "浙江省嘉兴市",
"861370343", "河南省新乡市",
"861874993", "河南省濮阳市",
"861362584", "浙江省宁波市",
"861824070", "河南省周口市",
"861470938", "甘肃省天水市",
"861333917", "安徽省亳州市",
"861562796", "广东省潮州市",
"861529077", "河南省平顶山市",
"86138423", "辽宁省抚顺市",
"861895138", "江苏省南通市",
"861537835", "四川省自贡市",
"86158182", "广东省东莞市",
"86158452", "黑龙江省齐齐哈尔市",
"861519463", "河南省开封市",
"861816455", "浙江省绍兴市",
"861311982", "广东省汕尾市",
"861312337", "福建省厦门市",
"861357737", "云南省曲靖市",
"861522040", "广东省东莞市",
"86136250", "福建省福州市",
"861780423", "辽宁省锦州市",
"861841999", "甘肃省定西市",
"86150307", "河北省沧州市",
"861854652", "黑龙江省哈尔滨市",
"861379180", "山东省青岛市",
"861477098", "江西省上饶市",
"861533505", "江苏省南通市",
"861301912", "吉林省长春市",
"861308277", "山东省泰安市",
"861539056", "甘肃省庆阳市",
"861808179", "四川省内江市",
"861870785", "广西玉林市",
"861340323", "河北省张家口市",
"861554407", "河南省郑州市",
"861896546", "福建省漳州市",
"861336423", "辽宁省抚顺市",
"861598078", "福建省厦门市",
"86177081", "四川省成都市",
"861810474", "内蒙古乌兰察布市",
"861774844", "四川省乐山市",
"861708479", "内蒙古包头市",
"861303132", "新疆石河子市",
"861532321", "广东省揭阳市",
"86188644", "河南省濮阳市",
"861826665", "山东省青岛市",
"86151241", "辽宁省鞍山市",
"861452778", "广西河池市",
"861878809", "云南省昆明市",
"861771544", "江苏省常州市",
"861571413", "辽宁省抚顺市",
"861350814", "四川省乐山市",
"861301160", "山东省淄博市",
"861831239", "广东省云浮市",
"86188436", "吉林省白城市",
"861370772", "广西柳州市",
"86177555", "安徽省马鞍山市",
"86150248", "内蒙古兴安盟",
"861350537", "山东省济宁市",
"861560610", "江苏省镇江市",
"861532948", "贵州省六盘水市",
"861353937", "广东省潮州市",
"861539831", "云南省文山壮族苗族自治州",
"861528936", "陕西省西安市",
"861333704", "内蒙古通辽市",
"861788807", "西藏拉萨市",
"861361075", "吉林省吉林市",
"861866441", "广东省中山市",
"861804861", "四川省绵阳市",
"861825240", "江苏省淮安市",
"86157319", "河北省邢台市",
"86134622", "河南省新乡市",
"861870796", "江西省吉安市",
"86187443", "吉林省延边朝鲜族自治州",
"861332912", "安徽省铜陵市",
"861894558", "黑龙江省七台河市",
"861536867", "云南省德宏傣族景颇族自治州",
"861571264", "浙江省嘉兴市",
"861356765", "浙江省舟山市",
"8615644", "河南省郑州市",
"861510738", "湖南省娄底市",
"861709849", "浙江省温州市",
"861450592", "辽宁省朝阳市",
"861338647", "山东省东营市",
"861773445", "河北省廊坊市",
"861316057", "广东省清远市",
"861313332", "山西省大同市",
"861300281", "四川省攀枝花市",
"86159658", "山东省菏泽市",
"861550266", "辽宁省锦州市",
"86159302", "河北省保定市",
"861364373", "河南省新乡市",
"86152006", "湖南省常德市",
"861364742", "湖南省常德市",
"861530905", "四川省内江市",
"861533393", "河南省濮阳市",
"861358206", "河北省保定市",
"861477808", "广东省中山市",
"861568540", "贵州省黔南布依族苗族自治州",
"861332160", "广西南宁市",
"86132800", "山东省济宁市",
"861818379", "云南省普洱市",
"86187856", "贵州省铜仁地区",
"861821971", "甘肃省兰州市",
"861452997", "内蒙古鄂尔多斯市",
"861529482", "河南省信阳市",
"861321963", "四川省自贡市",
"861781687", "浙江省杭州市",
"86137624", "湖南省衡阳市",
"861364231", "广东省广州市",
"861580370", "河南省商丘市",
"861327827", "吉林省白城市",
"86153148", "浙江省温州市",
"861507412", "湖南省长沙市",
"86159161", "广东省佛山市",
"86150920", "山东省青岛市",
"861325876", "吉林省通化市",
"86189421", "湖北省黄冈市",
"861760874", "云南省曲靖市",
"861341109", "广东省汕尾市",
"861471600", "广东省茂名市",
"861514630", "黑龙江省牡丹江市",
"861555755", "浙江省温州市",
"861319827", "四川省德阳市",
"861811230", "江苏省常州市",
"861531404", "山东省威海市",
"86177413", "辽宁省沈阳市",
"861842043", "广东省湛江市",
"861571079", "广东省深圳市",
"861866299", "江苏省淮安市",
"861817687", "广西南宁市",
"861309542", "安徽省阜阳市",
"861593230", "河北省衡水市",
"861519432", "山东省枣庄市",
"861371710", "广东省深圳市",
"86181361", "江苏省苏州市",
"861572865", "广东省中山市",
"861576668", "广东省惠州市",
"861596554", "山东省淄博市",
"861768515", "贵州省黔东南苗族侗族自治州",
"861536720", "湖南省湘西土家族苗族自治州",
"861378848", "广西柳州市",
"861821280", "贵州省毕节地区",
"861524680", "黑龙江省哈尔滨市",
"861889709", "青海省海西蒙古族藏族自治州",
"861352963", "云南省大理白族自治州",
"861829687", "江西省赣州市",
"861509721", "甘肃省酒泉市",
"861576502", "黑龙江省牡丹江市",
"861318034", "河北省廊坊市",
"861475718", "浙江省宁波市",
"861536974", "河北省秦皇岛市",
"861372789", "广东省珠海市",
"861320560", "安徽省合肥市",
"861300970", "黑龙江省哈尔滨市",
"861324702", "江西省九江市",
"861763526", "山西省临汾市",
"86132805", "山东省临沂市",
"861477858", "广东省梅州市",
"861335807", "江苏省南通市",
"861319760", "广西防城港市",
"861581182", "广东省深圳市",
"861822794", "四川省资阳市",
"861508916", "广东省珠海市",
"8614754", "广东省广州市",
"86136804", "广东省江门市",
"861530955", "宁夏中卫市",
"861885826", "浙江省杭州市",
"861760645", "山东省烟台市",
"861513858", "河南省商丘市",
"861511399", "广东省潮州市",
"861518986", "江苏省扬州市",
"861870731", "湖南省长沙市",
"861889278", "四川省内江市",
"861327760", "湖北省随州市",
"861892193", "江苏省扬州市",
"861339493", "新疆石河子市",
"861333068", "四川省资阳市",
"861859394", "广西玉林市",
"861533276", "内蒙古赤峰市",
"86135991", "福建省泉州市",
"861839044", "湖南省益阳市",
"86150925", "山东省德州市",
"861348828", "陕西省延安市",
"861590575", "浙江省绍兴市",
"861323382", "河南省新乡市",
"861898688", "湖北省十堰市",
"861881359", "广东省汕尾市",
"861865042", "福建省厦门市",
"861520788", "广西河池市",
"86156742", "湖南省常德市",
"861825052", "福建省莆田市",
"861855429", "山东省威海市",
"861888090", "四川省泸州市",
"86151776", "广西梧州市",
"861780576", "浙江省台州市",
"861879096", "河南省濮阳市",
"861808627", "湖北省荆门市",
"861532823", "四川省绵阳市",
"861890681", "浙江省杭州市",
"861308837", "四川省凉山彝族自治州",
"861322378", "河南省开封市",
"86147376", "广东省广州市",
"861340821", "四川省宜宾市",
"861533730", "湖北省恩施土家族苗族自治州",
"86136638", "河南省郑州市",
"861308514", "湖北省武汉市",
"861338860", "浙江省杭州市",
"861840631", "山东省威海市",
"861306804", "山西省太原市",
"861529939", "新疆阿勒泰地区",
"861594573", "黑龙江省牡丹江市",
"86138157", "江苏省宿迁市",
"861369679", "安徽省合肥市",
"861458486", "山东省淄博市",
"861359778", "湖北省恩施土家族苗族自治州",
"861536640", "江苏省扬州市",
"861332426", "辽宁省锦州市",
"86182290", "陕西省西安市",
"86152976", "河北省衡水市",
"861537275", "浙江省舟山市",
"861509641", "云南省怒江傈僳族自治州",
"86131850", "浙江省杭州市",
"861370155", "江苏省苏州市",
"861830411", "辽宁省大连市",
"861314171", "湖南省郴州市",
"861366304", "河南省周口市",
"861520998", "新疆喀什地区",
"861879750", "湖南省张家界市",
"861534953", "宁夏吴忠市",
"86130688", "广东省广州市",
"861877081", "江西省南昌市",
"861708846", "江西省新余市",
"861855944", "福建省厦门市",
"861570379", "河南省洛阳市",
"861532549", "浙江省湖州市",
"861366547", "山东省济宁市",
"861386698", "安徽省合肥市",
"861831879", "广东省中山市",
"861778942", "甘肃省白银市",
"86185252", "辽宁省沈阳市",
"861760725", "湖北省黄冈市",
"861373040", "河北省邯郸市",
"861589203", "福建省漳州市",
"861554100", "辽宁省铁岭市",
"861300644", "四川省德阳市",
"861837428", "湖南省湘西土家族苗族自治州",
"861787776", "湖南省张家界市",
"861705656", "广东省深圳市",
"86156841", "山东省烟台市",
"861871300", "河北省廊坊市",
"861336576", "安徽省安庆市",
"861812692", "广东省汕尾市",
"861331430", "吉林省长春市",
"86189017", "上海市",
"861761470", "内蒙古呼伦贝尔市",
"86634", "山东省莱芜市",
"861566793", "陕西省商洛市",
"861772617", "湖南省益阳市",
"861573387", "河北省衡水市",
"861350472", "吉林省延边朝鲜族自治州",
"861873595", "山西省临汾市",
"861304262", "辽宁省鞍山市",
"861380615", "江苏省无锡市",
"861306854", "广东省阳江市",
"861452787", "新疆阿克苏地区",
"86182482", "内蒙古兴安盟",
"86157731", "湖南省长沙市",
"86131855", "浙江省绍兴市",
"861837544", "山东省潍坊市",
"861839522", "宁夏石嘴山市",
"861365617", "江苏省无锡市",
"861397217", "湖北省武汉市",
"861338727", "湖北省宜昌市",
"86186294", "陕西省西安市",
"861378923", "湖南省永州市",
"861315295", "山西省长治市",
"86182152", "甘肃省定西市",
"86134323", "广东省茂名市",
"861800882", "云南省德宏傣族景颇族自治州",
"861770897", "西藏阿里地区",
"86139328", "河北省衡水市",
"861572960", "四川省南充市",
"861534903", "甘肃省白银市",
"861879700", "青海省西宁市",
"861560159", "江苏省南京市",
"861373252", "浙江省舟山市",
"861366354", "山西省晋中市",
"86138316", "河北省廊坊市",
"861364622", "江苏省苏州市",
"861505864", "浙江省台州市",
"861864832", "内蒙古赤峰市",
"861360375", "河南省平顶山市",
"861309024", "辽宁省沈阳市",
"861847126", "湖北省荆州市",
"861308288", "浙江省衢州市",
"861328817", "广东省惠州市",
"861850485", "内蒙古通辽市",
"861705606", "广东省东莞市",
"861328534", "山东省德州市",
"861476528", "河南省郑州市",
"861840696", "云南省保山市",
"861507018", "江西省赣州市",
"861870986", "安徽省合肥市",
"861530850", "贵州省贵阳市",
"861527989", "江西省宜春市",
"861804332", "吉林省吉林市",
"861861488", "内蒙古巴彦淖尔市",
"861351378", "河南省开封市",
"86183471", "内蒙古呼和浩特市",
"861508422", "辽宁省朝阳市",
"861861532", "山东省青岛市",
"861372148", "河南省焦作市",
"861830744", "湖南省张家界市",
"861365409", "辽宁省大连市",
"861575455", "黑龙江省绥化市",
"861322410", "辽宁省铁岭市",
"861833184", "河北省衡水市",
"861572382", "广西柳州市",
"861571937", "甘肃省酒泉市",
"861315286", "山西省晋城市",
"861809952", "新疆伊犁哈萨克自治州",
"861760412", "辽宁省鞍山市",
"861366490", "广东省江门市",
"861599290", "广东省东莞市",
"86135119", "贵州省贵阳市",
"861513492", "内蒙古鄂尔多斯市",
"861894297", "湖北省荆州市",
"861475349", "山东省青岛市",
"861857847", "广东省东莞市",
"861876026", "福建省三明市",
"861771194", "西藏林芝地区",
"861530706", "江西省吉安市",
"86183310", "河北省保定市",
"86145291", "广东省广州市",
"861454302", "黑龙江省齐齐哈尔市",
"861321489", "内蒙古巴彦淖尔市",
"861362034", "广东省佛山市",
"861336205", "浙江省丽水市",
"861372257", "河北省秦皇岛市",
"861847167", "湖北省武汉市",
"861860960", "安徽省滁州市",
"861350087", "吉林省辽源市",
"861871494", "安徽省阜阳市",
"861356966", "河南省鹤壁市",
"861842710", "湖北省襄樊市",
"861539980", "湖南省怀化市",
"86131204", "北京市",
"861874783", "内蒙古通辽市",
"861533836", "广东省东莞市",
"861569723", "湖北省黄石市",
"861518890", "河北省邯郸市",
"861780205", "广东省茂名市",
"86189196", "安徽省合肥市",
"861577104", "湖北省武汉市",
"861887237", "湖北省荆门市",
"861311792", "江西省九江市",
"861882941", "陕西省延安市",
"861510859", "贵州省黔西南布依族苗族自治州",
"861324213", "广东省佛山市",
"861890635", "山东省聊城市",
"861323865", "云南省保山市",
"861850496", "内蒙古呼和浩特市",
"861889838", "广东省中山市",
"86185473", "内蒙古乌海市",
"861390825", "重庆市",
"861846046", "江西省宜春市",
"861597152", "湖北省黄石市",
"861587614", "广东省佛山市",
"861479789", "江西省萍乡市",
"86178659", "山东省淄博市",
"861598472", "四川省阿坝藏族羌族自治州",
"861537506", "安徽省芜湖市",
"861870995", "新疆吐鲁番地区",
"861301426", "宁夏银川市",
"861809902", "新疆哈密地区",
"861898677", "湖北省宜昌市",
"861520777", "广西钦州市",
"861594912", "江苏省盐城市",
"861477739", "广西河池市",
"861359997", "福建省福州市",
"861504523", "黑龙江省齐齐哈尔市",
"861770673", "浙江省嘉兴市",
"861882619", "广东省江门市",
"861394948", "河南省平顶山市",
"861890398", "河南省三门峡市",
"861550340", "山西省运城市",
"86170042", "辽宁省大连市",
"861327392", "河南省鹤壁市",
"861318869", "辽宁省铁岭市",
"861881680", "广东省广州市",
"861454352", "山东省菏泽市",
"86183315", "河北省唐山市",
"86151396", "河南省驻马店市",
"861850431", "吉林省长春市",
"861516649", "山东省临沂市",
"861530756", "广东省珠海市",
"861588411", "四川省宜宾市",
"861347074", "安徽省芜湖市",
"861555172", "安徽省芜湖市",
"861319392", "河南省漯河市",
"861372207", "内蒙古鄂尔多斯市",
"861458495", "山东省烟台市",
"861899339", "甘肃省白银市",
"861539271", "湖北省黄冈市",
"861537930", "甘肃省临夏回族自治州",
"861507645", "河北省唐山市",
"86151577", "浙江省温州市",
"861304371", "河南省郑州市",
"861862379", "河南省洛阳市",
"861816223", "江西省宜春市",
"861470539", "山东省临沂市",
"861361571", "浙江省杭州市",
"861332467", "陕西省商洛市",
"861780255", "江苏省宿迁市",
"86135503", "四川省成都市",
"861539333", "甘肃省平凉市",
"861772409", "广东省阳江市",
"861379072", "广东省中山市",
"861775034", "福建省莆田市",
"861864863", "内蒙古包头市",
"86132219", "浙江省宁波市",
"861364871", "云南省昆明市",
"861813697", "江苏省苏州市",
"861535265", "新疆克拉玛依市",
"861537556", "安徽省安庆市",
"861817678", "广西梧州市",
"861519577", "江苏省南京市",
"861564349", "吉林省长春市",
"861380048", "内蒙古兴安盟",
"86180012", "北京市",
"861888800", "江苏省南京市",
"86136611", "北京市",
"861351410", "辽宁省铁岭市",
"861342185", "广东省汕头市",
"861584761", "内蒙古赤峰市",
"861530910", "陕西省咸阳市",
"861326692", "广东省东莞市",
"861329871", "黑龙江省齐齐哈尔市",
"861338976", "青海省玉树藏族自治州",
"861829863", "甘肃省陇南市",
"861550275", "湖北省恩施土家族苗族自治州",
"861374981", "河南省三门峡市",
"861529349", "甘肃省酒泉市",
"861839435", "甘肃省平凉市",
"861768936", "福建省泉州市",
"861379305", "山东省聊城市",
"861362612", "江苏省扬州市",
"861317871", "广东省梅州市",
"861328957", "宁夏中卫市",
"861323291", "广东省江门市",
"861368947", "甘肃省平凉市",
"86183272", "湖北省武汉市",
"86138717", "湖北省襄樊市",
"861876098", "云南省丽江市",
"861573455", "黑龙江省绥化市",
"861470719", "湖北省十堰市",
"861459773", "新疆乌鲁木齐市",
"861361066", "山西省晋城市",
"861313286", "广西百色市",
"861865173", "江苏省连云港市",
"86184737", "湖南省益阳市",
"86138845", "甘肃省武威市",
"861560605", "福建省漳州市",
"861318445", "浙江省绍兴市",
"86131690", "广东省汕头市",
"861370659", "浙江省嘉兴市",
"861557800", "广西南宁市",
"86182281", "四川省眉山市",
"861769538", "宁夏银川市",
"861335433", "吉林省延边朝鲜族自治州",
"861459342", "四川省乐山市",
"861810952", "宁夏石嘴山市",
"861575117", "江苏省泰州市",
"861587032", "贵州省六盘水市",
"861339578", "浙江省丽水市",
"861325865", "黑龙江省大庆市",
"86186689", "山东省济南市",
"861760599", "福建省南平市",
"861476585", "宁夏银川市",
"861860770", "广西防城港市",
"861842906", "陕西省汉中市",
"861316984", "广东省江门市",
"861553530", "山西省阳泉市",
"861568033", "四川省广安市",
"861473025", "河北省承德市",
"86180639", "广东省珠海市",
"861397059", "江西省萍乡市",
"861860924", "陕西省渭南市",
"861399958", "新疆伊犁哈萨克自治州",
"861517025", "江西省九江市",
"861308225", "辽宁省鞍山市",
"861580992", "新疆伊犁哈萨克自治州",
"861306914", "吉林省长春市",
"861520874", "云南省曲靖市",
"861850357", "山西省临汾市",
"861850544", "山东省德州市",
"861823366", "河北省沧州市",
"861872461", "黑龙江省哈尔滨市",
"861596413", "山东省济宁市",
"861526805", "浙江省衢州市",
"86182712", "湖北省襄樊市",
"861890326", "河北省廊坊市",
"861346543", "山东省滨州市",
"861376849", "广西南宁市",
"86185451", "黑龙江省哈尔滨市",
"86180283", "广东省中山市",
"861597766", "广西南宁市",
"861301498", "广西南宁市",
"861388484", "山东省聊城市",
"861569309", "甘肃省临夏回族自治州",
"861874846", "内蒙古呼伦贝尔市",
"8615723", "重庆市",
"861500577", "浙江省温州市",
"861535891", "江苏省盐城市",
"861398506", "贵州省黔南布依族苗族自治州",
"861871546", "安徽省合肥市",
"861328907", "新疆和田地区",
"861812507", "广东省珠海市",
"861589082", "河南省驻马店市",
"861572876", "广东省广州市",
"861386667", "安徽省马鞍山市",
"86181912", "陕西省西安市",
"861894819", "广东省深圳市",
"861355079", "四川省遂宁市",
"861536683", "江苏省常州市",
"861566674", "山东省潍坊市",
"861326934", "甘肃省张掖市",
"861509809", "湖北省十堰市",
"861363459", "黑龙江省大庆市",
"861521749", "广东省东莞市",
"861520645", "山东省聊城市",
"861346829", "山东省青岛市",
"86136226", "广东省东莞市",
"861898745", "云南省昆明市",
"861370609", "福建省莆田市",
"861360892", "山东省济南市",
"861580634", "山东省莱芜市",
"861700630", "山东省青岛市",
"861534813", "四川省乐山市",
"86189937", "甘肃省酒泉市",
"861358527", "江苏省宿迁市",
"86155628", "山东省聊城市",
"861590566", "安徽省池州市",
"861768991", "福建省宁德市",
"861857744", "广西梧州市",
"861502972", "陕西省榆林市",
"861520967", "宁夏银川市",
"861815697", "安徽省马鞍山市",
"861812344", "四川省甘孜藏族自治州",
"861773034", "安徽省阜阳市",
"86147777", "广西钦州市",
"861558237", "山西省临汾市",
"861760788", "广西南宁市",
"861374270", "江西省南昌市",
"861840319", "河北省邢台市",
"861348333", "河北省张家口市",
"861531513", "山东省济南市",
"86170924", "辽宁省沈阳市",
"861453418", "辽宁省沈阳市",
"861399908", "新疆喀什地区",
"861525598", "安徽省黄山市",
"86151377", "河南省南阳市",
"861334416", "吉林省长春市",
"861452569", "贵州省黔西南布依族苗族自治州",
"861830847", "四川省绵阳市",
"861557706", "广西来宾市",
"861476531", "辽宁省沈阳市",
"861813668", "江苏省南京市",
"861317622", "山东省淄博市",
"861560461", "黑龙江省哈尔滨市",
"861800376", "河南省信阳市",
"861319644", "江苏省常州市",
"861777594", "湖南省长沙市",
"86178899", "海南省海口市",
"861310192", "江苏省镇江市",
"86183453", "黑龙江省哈尔滨市",
"861879028", "河南省郑州市",
"861390237", "广东省云浮市",
"861813502", "山西省忻州市",
"861860876", "云南省文山壮族苗族自治州",
"86147576", "浙江省台州市",
"861327644", "山东省济南市",
"861802144", "江苏省无锡市",
"861590527", "江苏省扬州市",
"861856246", "山东省临沂市",
"86186605", "山东省烟台市",
"861523567", "山西省运城市",
"86158610", "江苏省泰州市",
"86133162", "广东省广州市",
"861508581", "贵州省毕节地区",
"86157033", "河北省秦皇岛市",
"861354249", "广东省清远市",
"861332498", "云南省西双版纳傣族自治州",
"861536452", "山西省大同市",
"861559140", "陕西省商洛市",
"861343758", "广东省茂名市",
"861881643", "江西省九江市",
"86187820", "四川省成都市",
"861516801", "浙江省丽水市",
"86135759", "浙江省金华市",
"861801201", "江苏省徐州市",
"861509099", "湖北省鄂州市",
"861581229", "云南省文山壮族苗族自治州",
"861884629", "黑龙江省大庆市",
"86145280", "四川省成都市",
"861554833", "内蒙古呼和浩特市",
"861837496", "湖南省长沙市",
"861384839", "内蒙古兴安盟",
"861592922", "陕西省榆林市",
"861338824", "四川省眉山市",
"861770794", "江西省抚州市",
"861535001", "江西省南昌市",
"861356870", "四川省遂宁市",
"86183846", "四川省乐山市",
"86151797", "江西省赣州市",
"86180932", "甘肃省定西市",
"861320250", "广东省广州市",
"861478341", "河南省安阳市",
"861589477", "新疆昌吉回族自治州",
"861452884", "云南省昆明市",
"861816410", "湖北省武汉市",
"861370417", "辽宁省营口市",
"861848414", "贵州省贵阳市",
"861863448", "山西省吕梁市",
"861571504", "福建省漳州市",
"86133301", "江西省赣州市",
"861510641", "山东省淄博市",
"861890367", "黑龙江省大庆市",
"861369464", "黑龙江省牡丹江市",
"861839481", "甘肃省兰州市",
"861359968", "福建省漳州市",
"861336061", "广东省珠海市",
"861844974", "新疆巴音郭楞蒙古自治州",
"86181619", "陕西省西安市",
"86139528", "江苏省镇江市",
"861870648", "山东省青岛市",
"861557756", "广西贵港市",
"861510919", "陕西省铜川市",
"861339037", "辽宁省锦州市",
"861500989", "辽宁省锦州市",
"861844720", "内蒙古锡林郭勒盟",
"861313295", "广西玉林市",
"861310024", "湖南省张家界市",
"861550930", "甘肃省临夏回族自治州",
"861785824", "浙江省台州市",
"861354491", "广东省珠海市",
"86158615", "江苏省无锡市",
"86186600", "山东省烟台市",
"861520018", "河北省邢台市",
"861813552", "山西省长治市",
"861319875", "四川省达州市",
"861899949", "新疆塔城地区",
"86187825", "四川省遂宁市",
"861537340", "河北省沧州市",
"861343708", "江西省南昌市",
"861360052", "浙江省杭州市",
"861340838", "四川省德阳市",
"861840628", "辽宁省葫芦岛市",
"861476596", "吉林省长春市",
"86156476", "内蒙古赤峰市",
"861872605", "安徽省安庆市",
"861579747", "湖北省黄冈市",
"861550556", "安徽省安庆市",
"861874740", "内蒙古呼伦贝尔市",
"861535051", "河北省邯郸市",
"861390888", "云南省丽江市",
"861324420", "吉林省吉林市",
"861563364", "河北省唐山市",
"861516145", "江苏省南京市",
"861809812", "广东省潮州市",
"861826676", "山东省济宁市",
"861315861", "四川省泸州市",
"86157554", "安徽省淮南市",
"861780061", "内蒙古兴安盟",
"861815873", "浙江省绍兴市",
"861357274", "陕西省渭南市",
"861379593", "四川省巴中市",
"861572770", "江西省萍乡市",
"861533510", "江苏省徐州市",
"861856792", "福建省莆田市",
"861368451", "黑龙江省哈尔滨市",
"861308734", "湖南省衡阳市",
"861572924", "河南省濮阳市",
"86145492", "上海市",
"861867163", "湖北省黄石市",
"86184536", "山东省潍坊市",
"861894268", "河北省秦皇岛市",
"861819882", "广东省东莞市",
"861571554", "安徽省淮南市",
"861564939", "河南省南阳市",
"861373475", "内蒙古通辽市",
"861889886", "广东省湛江市",
"86158715", "湖北省宜昌市",
"86186700", "湖南省长沙市",
"861501414", "广东省深圳市",
"861878880", "安徽省宣城市",
"861555009", "山东省日照市",
"86182919", "陕西省西安市",
"861850592", "福建省厦门市",
"861514793", "内蒙古巴彦淖尔市",
"861390510", "江苏省盐城市",
"861311847", "四川省宜宾市",
"861536340", "广东省佛山市",
"861368637", "山东省济宁市",
"86153921", "福建省泉州市",
"861454483", "湖北省武汉市",
"861337061", "山东省泰安市",
"861840331", "河北省石家庄市",
"861809430", "江苏省盐城市",
"861768646", "山东省潍坊市",
"86136668", "浙江省台州市",
"861881962", "广东省茂名市",
"861314547", "山东省济南市",
"861369379", "河南省洛阳市",
"861803197", "河北省邢台市",
"861569841", "山西省太原市",
"861807178", "湖北省襄樊市",
"861887891", "广西柳州市",
"86181062", "江苏省苏州市",
"861538956", "陕西省延安市",
"861322678", "广东省肇庆市",
"861529851", "江苏省泰州市",
"861572403", "广东省佛山市",
"861534460", "黑龙江省齐齐哈尔市",
"861500915", "陕西省安康市",
"861350255", "广东省潮州市",
"86151140", "四川省成都市",
"861892269", "广东省汕尾市",
"861808327", "贵州省黔西南布依族苗族自治州",
"861839467", "甘肃省兰州市",
"861470796", "江西省吉安市",
"861873538", "山西省太原市",
"861360844", "河南省驻马店市",
"861560487", "黑龙江省鸡西市",
"861372085", "福建省泉州市",
"861302176", "山东省德州市",
"861882189", "湖南省岳阳市",
"861320854", "贵州省六盘水市",
"861479581", "广西南宁市",
"861529145", "陕西省西安市",
"861871600", "河北省秦皇岛市",
"861314304", "河北省石家庄市",
"861569155", "陕西省安康市",
"861589134", "陕西省宝鸡市",
"861398640", "湖北省鄂州市",
"861392339", "广东省珠海市",
"861532263", "广东省汕头市",
"861315238", "陕西省渭南市",
"861526021", "福建省厦门市",
"861302902", "吉林省四平市",
"861539558", "安徽省阜阳市",
"861506149", "江苏省镇江市",
"861760516", "江苏省徐州市",
"861705356", "河北省石家庄市",
"861313784", "河南省开封市",
"861819676", "安徽省马鞍山市",
"861300344", "江苏省镇江市",
"861508567", "贵州省黔东南苗族侗族自治州",
"861571775", "广西玉林市",
"861559613", "陕西省安康市",
"861570679", "浙江省温州市",
"86131438", "广东省深圳市",
"861452280", "山西省运城市",
"861505781", "浙江省金华市",
"861355766", "广西桂林市",
"861334732", "湖南省湘潭市",
"86182704", "江西省上饶市",
"861470000", "福建省福州市",
"861343183", "广东省梅州市",
"861555059", "山东省聊城市",
"861389941", "新疆阿勒泰地区",
"861326644", "广东省湛江市",
"861386635", "安徽省芜湖市",
"861473801", "河南省南阳市",
"861366654", "浙江省湖州市",
"86186705", "湖南省郴州市",
"86158710", "湖北省襄樊市",
"861886825", "浙江省温州市",
"861452971", "广东省湛江市",
"861821997", "甘肃省酒泉市",
"86159001", "广东省湛江市",
"861365317", "河北省沧州市",
"861300557", "广东省肇庆市",
"861537452", "湖北省黄石市",
"86188149", "浙江省温州市",
"861393133", "河北省张家口市",
"86135659", "新疆乌鲁木齐市",
"86157761", "黑龙江省大庆市",
"861380315", "河北省唐山市",
"861315887", "四川省绵阳市",
"86181904", "四川省德阳市",
"861515444", "山东省青岛市",
"861868760", "云南省昆明市",
"86151145", "黑龙江省哈尔滨市",
"861573687", "河南省开封市",
"861860682", "浙江省湖州市",
"861323734", "湖南省衡阳市",
"861705583", "广东省广州市",
"861303441", "湖北省黄石市",
"861894896", "广东省江门市",
"861351678", "浙江省宁波市",
"861320804", "浙江省杭州市",
"861330966", "安徽省安庆市",
"861817410", "广西南宁市",
"861333527", "山东省泰安市",
"86152166", "上海市",
"861501741", "广东省佛山市",
"861807480", "广西南宁市",
"861596727", "浙江省丽水市",
"861314354", "广东省广州市",
"861586063", "福建省漳州市",
"861304822", "广东省肇庆市",
"861857439", "湖南省长沙市",
"861804632", "福建省厦门市",
"861840396", "河南省驻马店市",
"861301522", "内蒙古呼和浩特市",
"861705306", "上海市",
"861524417", "山东省淄博市",
"861302952", "内蒙古呼和浩特市",
"861700940", "广东省佛山市",
"861893484", "广西梧州市",
"86133803", "广东省深圳市",
"861580944", "甘肃省平凉市",
"861364322", "河北省保定市",
"86151697", "山东省菏泽市",
"86158491", "内蒙古呼和浩特市",
"861520935", "甘肃省金昌市",
"861470731", "湖南省长沙市",
"861361779", "广西北海市",
"861360675", "浙江省绍兴市",
"861336472", "新疆阿克苏地区",
"861340372", "河南省安阳市",
"861537683", "山东省聊城市",
"861454602", "青海省海东地区",
"861894885", "广东省中山市",
"861879148", "陕西省西安市",
"86182612", "江苏省盐城市",
"861345140", "河北省衡水市",
"861475649", "河北省邢台市",
"861377849", "四川省资阳市",
"861347543", "山东省滨州市",
"861880906", "新疆阿勒泰地区",
"861333566", "安徽省池州市",
"86159265", "湖北省荆州市",
"861346958", "宁夏银川市",
"861564911", "河南省郑州市",
"861390265", "广东省惠州市",
"861572682", "浙江省宁波市",
"861860453", "黑龙江省牡丹江市",
"861370723", "湖北省黄石市",
"861454568", "四川省德阳市",
"861837419", "湖南省永州市",
"861565993", "福建省福州市",
"861332522", "山东省淄博市",
"861889780", "广西柳州市",
"861510931", "甘肃省兰州市",
"86185346", "山西省太原市",
"861840385", "黑龙江省黑河市",
"861509016", "河南省洛阳市",
"861321107", "河北省邢台市",
"86136994", "四川省成都市",
"861334763", "广西桂林市",
"861394872", "内蒙古包头市",
"861778014", "四川省自贡市",
"861760153", "江苏省常州市",
"861707310", "河北省邯郸市",
"861890335", "河北省秦皇岛市",
"861861491", "河南省三门峡市",
"861786927", "云南省丽江市",
"861780472", "内蒙古包头市",
"861303957", "内蒙古包头市",
"861847639", "广东省深圳市",
"861459450", "陕西省商洛市",
"861896615", "浙江省杭州市",
"861815406", "安徽省安庆市",
"861458438", "河南省平顶山市",
"86155728", "湖北省武汉市",
"861340743", "湖南省湘西土家族苗族自治州",
"861856744", "河南省信阳市",
"86155923", "陕西省渭南市",
"861595069", "江苏省徐州市",
"861355727", "广西桂林市",
"861816863", "江苏省连云港市",
"861510996", "新疆巴音郭楞蒙古自治州",
"86130418", "江苏省苏州市",
"86138617", "江苏省无锡市",
"861877098", "江西省景德镇市",
"86131411", "北京市",
"861454652", "云南省玉溪市",
"861881380", "广东省江门市",
"861470785", "广西玉林市",
"861520981", "安徽省安庆市",
"861310144", "福建省泉州市",
"861866570", "广东省广州市",
"861341180", "广东省佛山市",
"86184637", "山东省济宁市",
"861879999", "新疆克拉玛依市",
"861770373", "河南省新乡市",
"861517036", "江西省上饶市",
"861882319", "广东省深圳市",
"861890698", "福建省三明市",
"861880956", "宁夏石嘴山市",
"861550640", "山东省菏泽市",
"861567845", "广西贵港市",
"861772187", "四川省成都市",
"861802192", "江苏省淮安市",
"861327692", "福建省莆田市",
"861472610", "四川省遂宁市",
"861870938", "甘肃省天水市",
"86135952", "贵州省遵义市",
"861346908", "湖南省长沙市",
"861381511", "江苏省无锡市",
"86159260", "湖北省武汉市",
"861321157", "广西贵港市",
"861509928", "新疆阿克苏地区",
"861821259", "贵州省毕节地区",
"861768925", "福建省福州市",
"861331902", "新疆哈密地区",
"861399543", "宁夏吴忠市",
"861808366", "贵州省毕节地区",
"861839426", "甘肃省定西市",
"861317984", "新疆乌鲁木齐市",
"861527141", "湖北省十堰市",
"861872487", "云南省普洱市",
"861567151", "湖北省恩施土家族苗族自治州",
"86598", "福建省三明市",
"86159559", "安徽省六安市",
"861476519", "河北省石家庄市",
"86132990", "陕西省西安市",
"86180739", "湖南省邵阳市",
"861770742", "湖南省长沙市",
"861862420", "辽宁省鞍山市",
"861350576", "浙江省台州市",
"861459400", "云南省红河哈尼族彝族自治州",
"86136013", "北京市",
"861354712", "四川省绵阳市",
"861335071", "四川省眉山市",
"861829378", "甘肃省甘南藏族自治州",
"861303907", "吉林省白山市",
"861880530", "山东省菏泽市",
"861372096", "山西省长治市",
"861386681", "安徽省池州市",
"861329984", "青海省海南藏族自治州",
"861805168", "江苏省盐城市",
"861804663", "江西省上饶市",
"861308449", "四川省绵阳市",
"861862679", "吉林省白城市",
"86186789", "山东省青岛市",
"861518539", "贵州省安顺市",
"86158984", "湖南省益阳市",
"861583428", "山西省忻州市",
"861894790", "内蒙古锡林郭勒盟",
"861570175", "甘肃省兰州市",
"861350061", "内蒙古呼和浩特市",
"861335566", "安徽省池州市",
"861354532", "湖北省襄樊市",
"86181159", "江苏省泰州市",
"861558730", "山东省济宁市",
"861374777", "内蒙古鄂尔多斯市",
"861334973", "湖北省荆州市",
"861509931", "新疆阿勒泰地区",
"86158485", "内蒙古通辽市",
"861507270", "湖北省孝感市",
"861559758", "青海省海南藏族自治州",
"861318070", "吉林省白山市",
"861801578", "四川省甘孜藏族自治州",
"861502848", "河北省邯郸市",
"86147696", "云南省文山壮族苗族自治州",
"861473649", "云南省昆明市",
"861536930", "河北省张家口市",
"861375164", "广东省阳江市",
"861899046", "四川省甘孜藏族自治州",
"86158292", "陕西省西安市",
"861804878", "四川省眉山市",
"861362312", "河北省保定市",
"861840941", "甘肃省甘南藏族自治州",
"861308865", "浙江省温州市",
"861593274", "河北省沧州市",
"861583431", "山西省朔州市",
"86158155", "广东省深圳市",
"86181489", "广东省广州市",
"861591456", "广东省佛山市",
"861351832", "四川省广元市",
"861326392", "江西省九江市",
"861381242", "江苏省宿迁市",
"861813406", "河北省廊坊市",
"861378390", "河南省开封市",
"86180669", "陕西省西安市",
"861850657", "浙江省杭州市",
"861305957", "广东省清远市",
"86136711", "北京市",
"861581218", "云南省大理白族自治州",
"861888254", "四川省成都市",
"861821968", "甘肃省天水市",
"861450194", "山西省运城市",
"861300934", "辽宁省锦州市",
"861853012", "河南省开封市",
"861802060", "福建省莆田市",
"861596976", "山东省德州市",
"861370359", "山西省运城市",
"86185546", "山东省东营市",
"861847181", "湖北省黄石市",
"861560305", "广东省广州市",
"861778632", "湖北省十堰市",
"861830792", "江西省九江市",
"861563993", "河南省郑州市",
"861390891", "西藏拉萨市",
"861355824", "广西梧州市",
"861459642", "甘肃省陇南市",
"861454440", "江西省新余市",
"861533825", "广东省中山市",
"861860277", "湖北省襄樊市",
"861536383", "广东省佛山市",
"86151857", "贵州省黔东南苗族侗族自治州",
"861848549", "贵州省黔东南苗族侗族自治州",
"86136282", "重庆市",
"861337205", "江苏省宿迁市",
"86186263", "江苏省无锡市",
"861852968", "广东省揭阳市",
"861332481", "广西南宁市",
"861321415", "辽宁省丹东市",
"861590433", "吉林省延边朝鲜族自治州",
"861559708", "青海省海南藏族自治州",
"86158150", "广东省汕头市",
"861458421", "河南省安阳市",
"861320914", "陕西省商洛市",
"861893545", "山西省晋中市",
"861576671", "广东省湛江市",
"861379655", "黑龙江省绥化市",
"861897196", "湖北省孝感市",
"861528726", "云南省西双版纳傣族自治州",
"861550452", "黑龙江省齐齐哈尔市",
"861593069", "河北省邢台市",
"86130232", "上海市",
"861322832", "四川省宜宾市",
"861398683", "湖北省宜昌市",
"861778994", "西藏林芝地区",
"861383893", "河南省焦作市",
"861551358", "山西省吕梁市",
"861813456", "安徽省宣城市",
"861760830", "四川省泸州市",
"861309144", "黑龙江省哈尔滨市",
"861509996", "广东省广州市",
"861333071", "四川省攀枝花市",
"861392198", "江苏省苏州市",
"861839498", "甘肃省甘南藏族自治州",
"861479715", "山西省太原市",
"861500855", "贵州省黔东南苗族侗族自治州",
"861300692", "广西柳州市",
"861348633", "浙江省嘉兴市",
"86157618", "贵州省贵阳市",
"861330870", "云南省昭通市",
"861565013", "山东省威海市",
"861452243", "浙江省宁波市",
"861357966", "新疆哈密地区",
"861896389", "新疆和田地区",
"861815397", "甘肃省兰州市",
"861354170", "四川省德阳市",
"861888204", "四川省自贡市",
"861377465", "福建省厦门市",
"861520345", "山西省长治市",
"861385282", "江苏省宿迁市",
"861340005", "江苏省南京市",
"861830439", "吉林省白山市",
"861858314", "四川省宜宾市",
"861560355", "山西省长治市",
"861556133", "内蒙古通辽市",
"861580334", "河北省承德市",
"86159359", "山西省运城市",
"861370309", "广东省江门市",
"861558051", "湖南省湘西土家族苗族自治州",
"861338413", "辽宁省抚顺市",
"861836544", "江西省九江市",
"861582075", "广东省深圳市",
"861339201", "广东省惠州市",
"861569417", "辽宁省营口市",
"861338264", "江苏省盐城市",
"861390051", "江苏省南京市",
"861897185", "湖北省荆门市",
"861881343", "广东省茂名市",
"861847135", "湖北省咸宁市",
"861767900", "江西省南昌市",
"861327344", "河北省石家庄市",
"861570464", "黑龙江省七台河市",
"861351863", "山东省淄博市",
"861305299", "江苏省泰州市",
"861367354", "河南省新乡市",
"861805197", "江苏省南京市",
"861470511", "江苏省盐城市",
"86186926", "湖南省株洲市",
"861311411", "云南省曲靖市",
"861854571", "黑龙江省七台河市",
"861571965", "甘肃省庆阳市",
"86159703", "江西省上饶市",
"861470728", "湖北省十堰市",
"861571647", "河南省新乡市",
"86139237", "广东省深圳市",
"861375475", "山东省淄博市",
"861788527", "贵州省黔南布依族苗族自治州",
"86157631", "山东省威海市",
"86185810", "重庆市",
"861320707", "江西省赣州市",
"861550683", "广西柳州市",
"861884045", "陕西省西安市",
"861800676", "浙江省台州市",
"861319344", "河南省许昌市",
"861317322", "山东省青岛市",
"861551466", "河南省驻马店市",
"861301481", "广西贵港市",
"861397172", "湖北省黄冈市",
"861818702", "云南省昆明市",
"861477711", "广西南宁市",
"86137848", "河北省衡水市",
"86181405", "湖北省武汉市",
"861528767", "云南省普洱市",
"861823627", "河南省信阳市",
"861760791", "江西省南昌市",
"861319507", "宁夏吴忠市",
"861510341", "山西省太原市",
"861880816", "四川省雅安市",
"861398452", "贵州省遵义市",
"861890667", "浙江省温州市",
"861310879", "云南省普洱市",
"861478641", "湖南省张家界市",
"861890945", "甘肃省武威市",
"86153028", "广东省佛山市",
"861399580", "湖北省鄂州市",
"861348558", "安徽省阜阳市",
"861882631", "广东省佛山市",
"861513528", "山西省吕梁市",
"861879473", "甘肃省酒泉市",
"861850419", "辽宁省辽阳市",
"861327507", "福建省泉州市",
"86158409", "辽宁省大连市",
"861588439", "四川省乐山市",
"861379461", "广东省佛山市",
"861378404", "河北省邢台市",
"861384951", "河南省焦作市",
"861561501", "山东省威海市",
"861891444", "江苏省泰州市",
"861306042", "陕西省西安市",
"861516088", "新疆乌鲁木齐市",
"861344129", "江苏省泰州市",
"861810430", "吉林省长春市",
"861826293", "江苏省宿迁市",
"861769303", "甘肃省平凉市",
"861509985", "广东省珠海市",
"861887265", "湖北省孝感市",
"86131570", "浙江省衢州市",
"861534424", "内蒙古兴安盟",
"861842059", "广东省阳江市",
"861355152", "四川省内江市",
"861560593", "福建省宁德市",
"861325734", "湖南省衡阳市",
"861537640", "山东省济南市",
"861393800", "河南省鹤壁市",
"861534548", "山东省日照市",
"861760736", "湖南省常德市",
"861390001", "辽宁省沈阳市",
"861303817", "四川省内江市",
"861323288", "广东省江门市",
"861576822", "广东省茂名市",
"861558891", "山东省临沂市",
"861339251", "广东省江门市",
"861536275", "广东省清远市",
"861768039", "湖南省邵阳市",
"861313887", "广东省深圳市",
"861367304", "河南省安阳市",
"861330776", "广西百色市",
"86130788", "广东省广州市",
"861882696", "广东省东莞市",
"861334512", "山东省济南市",
"861338079", "广东省深圳市",
"861331812", "广东省梅州市",
"861889372", "甘肃省兰州市",
"861363317", "河北省沧州市",
"86151676", "浙江省台州市",
"861395133", "江苏省南通市",
"861771142", "四川省泸州市",
"861820480", "内蒙古兴安盟",
"86132981", "河南省郑州市",
"861590462", "黑龙江省齐齐哈尔市",
"861315221", "陕西省宝鸡市",
"861523422", "山西省大同市",
"861531848", "山东省菏泽市",
"861360747", "湖南省邵阳市",
"86185815", "四川省成都市",
"861524155", "辽宁省丹东市",
"861870348", "山西省吕梁市",
"861475801", "浙江省舟山市",
"861321722", "湖北省随州市",
"861573361", "河北省邯郸市",
"861337576", "浙江省台州市",
"861319557", "安徽省宿州市",
"86181400", "四川省成都市",
"861818752", "云南省昆明市",
"861453670", "陕西省宝鸡市",
"86184566", "安徽省池州市",
"861535237", "甘肃省武威市",
"861871442", "黑龙江省牡丹江市",
"861452761", "广西南宁市",
"861348508", "江苏省宿迁市",
"861895484", "山东省青岛市",
"861889743", "湖南省湘西土家族苗族自治州",
"86551", "安徽省合肥市\、巢湖市",
"86159908", "浙江省丽水市",
"861367547", "山东省济宁市",
"861835614", "安徽省合肥市",
"861561551", "山东省济南市",
"86156343", "山东省威海市",
"861814084", "新疆哈密地区",
"861563664", "黑龙江省绥化市",
"861521541", "山东省济南市",
"861327557", "安徽省宿州市",
"86186419", "辽宁省辽阳市",
"861311744", "湖南省张家界市",
"861842009", "广东省阳江市",
"861840328", "河北省衡水市",
"861804014", "辽宁省大连市",
"86131575", "浙江省绍兴市",
"861840457", "黑龙江省大兴安岭地区",
"861390730", "湖南省岳阳市",
"861332435", "吉林省通化市",
"861833032", "河北省唐山市",
"861526440", "山东省菏泽市",
"861322626", "广东省湛江市",
"861330000", "广西南宁市",
"861510727", "湖北省襄樊市",
"861807126", "湖北省咸宁市",
"861812055", "湖北省武汉市",
"861313452", "黑龙江省齐齐哈尔市",
"86155115", "河北省唐山市",
"86180336", "河北省廊坊市",
"861347042", "辽宁省营口市",
"861355996", "福建省龙岩市",
"861820611", "江苏省常州市",
"861832789", "湖北省孝感市",
"861800696", "福建省漳州市",
"86139239", "广东省汕头市",
"861375495", "山西省临汾市",
"86186386", "河南省郑州市",
"861857962", "江西省吉安市",
"861308943", "吉林省延边朝鲜族自治州",
"861572297", "江苏省无锡市",
"861829367", "甘肃省天水市",
"861353928", "广东省揭阳市",
"861315640", "山东省济南市",
"861337531", "山东省济南市",
"86153581", "江苏省南京市",
"861570041", "四川省遂宁市",
"861894382", "吉林省松原市",
"86187435", "吉林省通化市",
"861573840", "河南省郑州市",
"861821820", "广东省潮州市",
"86151601", "福建省宁德市",
"861318850", "辽宁省葫芦岛市",
"861476087", "江苏省常州市",
"861879493", "甘肃省庆阳市",
"86152572", "浙江省湖州市",
"861470966", "宁夏固原市",
"86158407", "辽宁省营口市",
"861346854", "陕西省延安市",
"861323508", "福建省莆田市",
"86150608", "福建省泉州市",
"861319838", "四川省攀枝花市",
"861826273", "江苏省淮安市",
"86153775", "湖北省武汉市",
"861850853", "贵州省安顺市",
"86150352", "山西省大同市",
"861378418", "河北省衡水市",
"861508037", "福建省莆田市",
"861760771", "广西南宁市",
"861860909", "新疆博尔塔拉蒙古自治州",
"86130323", "重庆市",
"861330242", "广东省佛山市",
"861707426", "浙江省宁波市",
"861397192", "湖北省十堰市",
"861347200", "河北省邯郸市",
"861835658", "安徽省芜湖市",
"861855513", "安徽省芜湖市",
"861599926", "新疆伊犁哈萨克自治州",
"861330731", "湖南省长沙市",
"861857110", "湖北省鄂州市",
"86147803", "四川省资阳市",
"861327838", "吉林省辽源市",
"861566400", "河南省商丘市",
"861301610", "湖南省郴州市",
"86155110", "河北省邯郸市",
"861878647", "贵州省毕节地区",
"861313402", "江西省赣州市",
"86187378", "河南省开封市",
"861512134", "贵州省安顺市",
"861584646", "黑龙江省牡丹江市",
"861809119", "陕西省西安市",
"861329888", "吉林省长春市",
"861333851", "福建省莆田市",
"861889392", "甘肃省定西市",
"861374978", "河南省南阳市",
"861819189", "陕西省西安市",
"861319287", "广东省韶关市",
"861535322", "陕西省铜川市",
"861367318", "河北省石家庄市",
"861311680", "浙江省舟山市",
"86185749", "湖南省益阳市",
"861340644", "山东省烟台市",
"861507842", "广西玉林市",
"861853733", "河南省新乡市",
"861560573", "浙江省嘉兴市",
"861530584", "浙江省宁波市",
"861561281", "河北省衡水市",
"861882676", "广东省汕头市",
"861872912", "陕西省榆林市",
"861338099", "广东省江门市",
"86133443", "天津市",
"861330796", "江西省吉安市",
"861826115", "江苏省常州市",
"86187430", "吉林省长春市",
"861510860", "云南省德宏傣族景颇族自治州",
"861302689", "广东省广州市",
"861588343", "四川省德阳市",
"861334664", "河南省安阳市",
"861352630", "河南省商丘市",
"86186417", "辽宁省营口市",
"861588772", "云南省红河哈尼族彝族自治州",
"861810048", "吉林省长春市",
"861822891", "四川省遂宁市",
"861355931", "福建省龙岩市",
"861316510", "山东省济南市",
"861348837", "陕西省延安市",
"861300821", "辽宁省阜新市",
"86153770", "湖北省武汉市",
"861800631", "山东省威海市",
"861783919", "河南省焦作市",
"861577946", "江西省萍乡市",
"861881439", "广东省中山市",
"861586533", "山东省淄博市",
"861869564", "福建省泉州市",
"861339581", "浙江省杭州市",
"861356539", "新疆喀什地区",
"861323558", "湖北省咸宁市",
"861598444", "四川省广元市",
"861399042", "四川省阿坝藏族羌族自治州",
"861333145", "吉林省通化市",
"86139683", "浙江省宁波市",
"861875857", "浙江省杭州市",
"861324399", "辽宁省葫芦岛市",
"861820949", "甘肃省陇南市",
"861709419", "广东省汕头市",
"861860959", "宁夏固原市",
"861556229", "山东省济宁市",
"861337596", "福建省漳州市",
"861534317", "河北省沧州市",
"861839310", "甘肃省兰州市",
"861567773", "广西防城港市",
"861806311", "山东省威海市",
"86156214", "山东省青岛市",
"861360321", "河北省石家庄市",
"86134688", "陕西省西安市",
"861454577", "四川省眉山市",
"861593294", "江西省上饶市",
"861351667", "广东省惠州市",
"861804898", "四川省宜宾市",
"861312407", "福建省厦门市",
"86159116", "云南省昆明市",
"861857933", "江西省上饶市",
"861318756", "云南省德宏傣族景颇族自治州",
"861816111", "四川省宜宾市",
"861554169", "辽宁省朝阳市",
"861310059", "广西桂林市",
"861785859", "浙江省衢州市",
"861326372", "广西柳州市",
"861450601", "吉林省松原市",
"861330785", "广西玉林市",
"86188850", "贵州省贵阳市",
"861806181", "江苏省南通市",
"861351945", "甘肃省武威市",
"86181487", "广东省广州市",
"861839180", "陕西省咸阳市",
"86188681", "浙江省杭州市",
"861863559", "山西省太原市",
"861372561", "广东省阳江市",
"86151284", "河北省廊坊市",
"861830343", "山西省阳泉市",
"861350444", "吉林省四平市",
"861332610", "浙江省衢州市",
"861571843", "广东省东莞市",
"861320958", "宁夏银川市",
"861846443", "山东省聊城市",
"86135441", "广东省深圳市",
"861599874", "山东省泰安市",
"861550887", "云南省迪庆藏族自治州",
"861801598", "江苏省镇江市",
"861318090", "吉林省延边朝鲜族自治州",
"861369616", "四川省乐山市",
"861530869", "湖北省荆门市",
"861560912", "陕西省榆林市",
"861507290", "湖北省十堰市",
"861336519", "江苏省盐城市",
"861590349", "山西省朔州市",
"861337585", "浙江省绍兴市",
"861576636", "广东省梅州市",
"861551314", "山西省长治市",
"861335911", "陕西省延安市",
"861890863", "湖北省武汉市",
"861830772", "广西柳州市",
"861390871", "云南省昆明市",
"861323633", "江苏省连云港市",
"861871137", "湖南省株洲市",
"861823823", "河南省开封市",
"861509152", "陕西省西安市",
"861562834", "内蒙古通辽市",
"861362905", "四川省南充市",
"86379", "河南省洛阳市",
"861831816", "广东省茂名市",
"861572959", "宁夏银川市",
"861570316", "河北省廊坊市",
"861518274", "四川省攀枝花市",
"861452346", "河南省焦作市",
"861571529", "江苏省镇江市",
"86180667", "陕西省西安市",
"861378370", "河南省商丘市",
"861858427", "四川省攀枝花市",
"86188468", "黑龙江省鹤岗市",
"86153390", "陕西省西安市",
"86158128", "广东省东莞市",
"861812895", "广东省河源市",
"861897176", "湖北省黄石市",
"861312328", "福建省莆田市",
"861310009", "山西省运城市",
"861312457", "黑龙江省大兴安岭地区",
"861579872", "云南省红河哈尼族彝族自治州",
"861892707", "广东省揭阳市",
"861894960", "安徽省马鞍山市",
"861380812", "四川省广元市",
"861898456", "贵州省贵阳市",
"861863509", "山西省晋中市",
"861807339", "湖南省长沙市",
"861786890", "云南省玉溪市",
"861705082", "山东省青岛市",
"861875097", "福建省南平市",
"861580848", "四川省泸州市",
"861788911", "西藏拉萨市",
"86188855", "贵州省黔东南苗族侗族自治州",
"861367470", "内蒙古呼伦贝尔市",
"861450651", "黑龙江省黑河市",
"861328140", "四川省绵阳市",
"861596931", "云南省玉溪市",
"861335649", "广东省东莞市",
"861320908", "新疆克孜勒苏柯尔克孜自治州",
"86150092", "陕西省西安市",
"861355985", "福建省南平市",
"861810615", "江苏省无锡市",
"861806046", "福建省莆田市",
"861517566", "河北省廊坊市",
"861800685", "浙江省绍兴市",
"861515255", "江苏省淮安市",
"861304049", "新疆和田地区",
"86155583", "浙江省宁波市",
"861895127", "江苏省镇江市",
"861775905", "福建省福州市",
"861339535", "山东省烟台市",
"861867839", "山东省济南市",
"86151859", "贵州省铜仁地区",
"86158524", "江苏省徐州市",
"861855106", "江苏省无锡市",
"861509102", "陕西省榆林市",
"861586608", "山东省济宁市",
"86159357", "山西省临汾市",
"86187993", "新疆和田地区",
"861350528", "江苏省镇江市",
"861855972", "福建省龙岩市",
"861361525", "江苏省扬州市",
"861572909", "河南省洛阳市",
"861888218", "四川省眉山市",
"861366703", "江西省上饶市",
"861362955", "宁夏中卫市",
"861778720", "云南省大理白族自治州",
"861807167", "江苏省宿迁市",
"861586562", "山东省烟台市",
"861510766", "广东省云浮市",
"861330890", "西藏拉萨市",
"86181316", "河北省廊坊市",
"861333091", "四川省乐山市",
"861576118", "贵州省安顺市",
"861858308", "四川省遂宁市",
"861839478", "甘肃省天水市",
"861392178", "江苏省徐州市",
"861773955", "河南省漯河市",
"861311643", "贵州省黔南布依族苗族自治州",
"861830962", "宁夏石嘴山市",
"86137264", "广东省东莞市",
"861868623", "内蒙古鄂尔多斯市",
"861860819", "四川省南充市",
"861350531", "山东省济南市",
"861768884", "广东省广州市",
"861817635", "广西桂林市",
"861317825", "福建省厦门市",
"86170830", "河北省邯郸市",
"861304636", "广东省珠海市",
"861340392", "河南省鹤壁市",
"86155755", "湖南省衡阳市",
"861844942", "新疆克孜勒苏柯尔克孜自治州",
"861801526", "江苏省镇江市",
"861800319", "河北省邢台市",
"861336492", "新疆吐鲁番地区",
"861532458", "安徽省六安市",
"861366329", "河北省唐山市",
"861308333", "安徽省滁州市",
"861458252", "安徽省合肥市",
"861554401", "河南省安阳市",
"861810389", "河南省焦作市",
"861803749", "河南省郑州市",
"86176651", "广东省广州市",
"861708384", "河南省焦作市",
"861308271", "山东省淄博市",
"86134262", "北京市",
"86184283", "四川省成都市",
"861470870", "云南省昭通市",
"861307958", "宁夏银川市",
"861357731", "云南省红河哈尼族彝族自治州",
"86189288", "广东省广州市",
"861333911", "安徽省六安市",
"861529071", "河南省漯河市",
"861816626", "湖南省常德市",
"861325633", "山东省日照市",
"861535984", "福建省泉州市",
"861361463", "黑龙江省牡丹江市",
"861861471", "内蒙古呼和浩特市",
"861478413", "河南省商丘市",
"861814839", "内蒙古呼和浩特市",
"861351381", "河南省焦作市",
"861360686", "浙江省台州市",
"86155075", "广东省深圳市",
"861568249", "四川省乐山市",
"861394892", "内蒙古包头市",
"86155383", "河南省郑州市",
"861327672", "浙江省宁波市",
"86135876", "浙江省温州市",
"861802172", "江苏省扬州市",
"861373486", "内蒙古赤峰市",
"861320269", "广东省东莞市",
"861331315", "河北省唐山市",
"861475566", "安徽省池州市",
"861770393", "河南省濮阳市",
"861890678", "浙江省丽水市",
"861312396", "新疆喀什地区",
"86170835", "山西省太原市",
"861597809", "广西百色市",
"86133696", "新疆乌鲁木齐市",
"861787539", "广东省深圳市",
"861458202", "安徽省淮北市",
"861359781", "湖北省恩施土家族苗族自治州",
"861509766", "河北省邯郸市",
"861532408", "河北省衡水市",
"861336739", "湖南省邵阳市",
"861824889", "江苏省苏州市",
"861510976", "青海省海南藏族自治州",
"86155750", "湖南省岳阳市",
"861315683", "山东省滨州市",
"86184639", "山东省菏泽市",
"861879979", "新疆伊犁哈萨克自治州",
"861850913", "陕西省渭南市",
"861779701", "青海省西宁市",
"861593539", "山西省阳泉市",
"86183049", "内蒙古赤峰市",
"861334013", "江西省上饶市",
"861834736", "内蒙古通辽市",
"86138619", "江苏省南通市",
"861308980", "黑龙江省鸡西市",
"861346914", "湖南省常德市",
"861372076", "陕西省西安市",
"86153595", "福建省泉州市",
"861302185", "河北省邢台市",
"861780739", "湖南省邵阳市",
"861355341", "广东省惠州市",
"861894924", "安徽省巢湖市",
"861335091", "四川省广安市",
"861779030", "四川省达州市",
"86181516", "江苏省南京市",
"86186787", "山东省济宁市",
"861550784", "广西梧州市",
"86152792", "江西省九江市",
"861374894", "黑龙江省牡丹江市",
"861304691", "河南省平顶山市",
"86159557", "安徽省宿州市",
"861576049", "四川省南充市",
"861819685", "新疆阿克苏地区",
"861771351", "四川省内江市",
"861568491", "湖南省岳阳市",
"861820339", "河北省沧州市",
"861837803", "广西柳州市",
"86155070", "江西省赣州市",
"861318162", "山东省烟台市",
"861891205", "江苏省淮安市",
"86180737", "湖南省益阳市",
"86151992", "新疆和田地区",
"861571786", "湖北省襄樊市",
"861362815", "四川省雅安市",
"861308362", "河南省洛阳市",
"861339422", "辽宁省抚顺市",
"86181845", "贵州省黔东南苗族侗族自治州",
"861369399", "河南省三门峡市",
"861812743", "广东省广州市",
"861303279", "湖北省恩施土家族苗族自治州",
"861821864", "广东省湛江市",
"861800628", "江苏省南通市",
"86137408", "辽宁省大连市",
"86181717", "湖北省黄冈市",
"861837093", "江西省萍乡市",
"861575840", "云南省临沧市",
"861470776", "广西百色市",
"861351335", "河北省秦皇岛市",
"861478079", "四川省广元市",
"86186586", "浙江省台州市",
"861322698", "广东省佛山市",
"861566642", "山东省青岛市",
"861807198", "湖北省武汉市",
"861365424", "辽宁省大连市",
"861313640", "浙江省舟山市",
"861875754", "浙江省绍兴市",
"861557869", "广西南宁市",
"861355928", "福建省漳州市",
"86182917", "陕西省宝鸡市",
"861850572", "浙江省湖州市",
"861830933", "甘肃省平凉市",
"861870737", "湖南省益阳市",
"861338919", "陕西省铜川市",
"861368862", "山东省济南市",
"861360338", "河北省唐山市",
"861452550", "山东省聊城市",
"861357785", "云南省大理白族自治州",
"861348734", "湖南省衡阳市",
"861556070", "内蒙古呼伦贝尔市",
"861895702", "浙江省衢州市",
"86180536", "山东省潍坊市",
"861538024", "江苏省镇江市",
"861315452", "黑龙江省齐齐哈尔市",
"861325662", "山东省烟台市",
"861868010", "广东省汕头市",
"861304388", "辽宁省葫芦岛市",
"861316001", "江苏省淮安市",
"861361588", "浙江省宁波市",
"861571795", "江西省宜春市",
"861570699", "云南省德宏傣族景颇族自治州",
"861314318", "广东省佛山市",
"861361432", "吉林省吉林市",
"861509727", "甘肃省天水市",
"861829681", "江西省景德镇市",
"861859940", "新疆昌吉回族自治州",
"861325508", "福建省南平市",
"861808232", "江苏省淮安市",
"861350585", "浙江省绍兴市",
"86150552", "安徽省蚌埠市",
"861705203", "福建省福州市",
"861363460", "黑龙江省哈尔滨市",
"861893166", "河北省廊坊市",
"861303708", "山西省吕梁市",
"861817681", "广西钦州市",
"86189732", "湖南省湘潭市",
"861770505", "福建省泉州市",
"86182866", "贵州省铜仁地区",
"861502944", "陕西省咸阳市",
"86152372", "河南省安阳市",
"86188690", "云南省丽江市",
"861392443", "广东省揭阳市",
"861839143", "陕西省渭南市",
"86139875", "云南省保山市",
"861319821", "四川省自贡市",
"861450849", "江苏省常州市",
"861572819", "广东省广州市",
"861378782", "湖南省株洲市",
"86181840", "重庆市",
"861831956", "广东省广州市",
"861501458", "广东省揭阳市",
"861816945", "湖南省怀化市",
"861875704", "浙江省衢州市",
"86138912", "陕西省榆林市",
"861809048", "四川省广元市",
"861330511", "江苏省盐城市",
"86132521", "浙江省绍兴市",
"861351111", "湖南省益阳市",
"861869520", "宁夏石嘴山市",
"861303064", "安徽省亳州市",
"861828212", "四川省巴中市",
"861452500", "山东省济南市",
"861821977", "甘肃省金昌市",
"861533322", "河北省保定市",
"861330728", "湖北省十堰市",
"861700489", "广东省广州市",
"861563499", "山西省太原市",
"861781681", "浙江省温州市",
"861327821", "吉林省吉林市",
"861364237", "广东省东莞市",
"861582915", "陕西省渭南市",
"861315402", "陕西省榆林市",
"86187578", "浙江省金华市",
"861830380", "河南省安阳市",
"861335851", "福建省莆田市",
"861300287", "四川省内江市",
"861359735", "广西玉林市",
"861450523", "吉林省白城市",
"861840376", "河南省信阳市",
"861569360", "甘肃省张掖市",
"861361799", "江西省萍乡市",
"861360695", "福建省漳州市",
"861560852", "贵州省遵义市",
"861532366", "广东省汕头市",
"86187934", "甘肃省庆阳市",
"86151699", "山东省滨州市",
"861833608", "河南省新乡市",
"861335145", "黑龙江省绥化市",
"861338641", "山东省济南市",
"861318133", "山东省济宁市",
"861316051", "广东省阳江市",
"861705253", "云南省昆明市",
"861804867", "四川省南充市",
"861599149", "陕西省渭南市",
"861365548", "山东省泰安市",
"861866447", "广东省中山市",
"861325558", "山东省青岛市",
"861536861", "云南省西双版纳傣族自治州",
"861380902", "江苏省南京市",
"861786511", "山东省菏泽市",
"861326780", "广东省梅州市",
"86188695", "云南省昭通市",
"861770555", "安徽省马鞍山市",
"861598531", "贵州省安顺市",
"861788801", "西藏拉萨市",
"861334620", "山东省菏泽市",
"861539837", "云南省昆明市",
"861353931", "广东省佛山市",
"861500352", "山西省大同市",
"861337528", "江苏省扬州市",
"861834830", "河南省商丘市",
"86157125", "河北省保定市",
"861762582", "江苏省无锡市",
"861454805", "广东省广州市",
"861894682", "青海省海东地区",
"861889934", "新疆喀什地区",
"861869955", "新疆昌吉回族自治州",
"861772903", "陕西省渭南市",
"861826631", "山东省威海市",
"861347757", "湖北省荆门市",
"861320580", "浙江省舟山市",
"861372769", "广东省汕头市",
"861776755", "新疆喀什地区",
"86187465", "黑龙江省绥化市",
"861519602", "四川省自贡市",
"86135757", "浙江省杭州市",
"861310906", "新疆伊犁哈萨克自治州",
"861899178", "陕西省延安市",
"861352983", "云南省红河哈尼族彝族自治州",
"861332478", "广西河池市",
"861582989", "陕西省铜川市",
"861527568", "山东省聊城市",
"861315340", "山东省威海市",
"861882293", "广东省揭阳市",
"861800396", "河南省驻马店市",
"861478727", "云南省普洱市",
"861552197", "广东省梅州市",
"861572885", "广东省肇庆市",
"861823232", "河北省张家口市",
"861820311", "河北省石家庄市",
"861576688", "广东省揭阳市",
"861581910", "广东省汕尾市",
"86139269", "广东省珠海市",
"861322326", "河北省邢台市",
"861373421", "山西省大同市",
"861803434", "河北省唐山市",
"861806949", "浙江省台州市",
"86180366", "江苏省连云港市",
"86137293", "广东省揭阳市",
"861310172", "河南省安阳市",
"861834412", "广东省揭阳市",
"861311933", "甘肃省平凉市",
"861571721", "湖北省荆州市",
"861520768", "广东省潮州市",
"861390322", "河北省保定市",
"861303183", "河北省衡水市",
"861537861", "四川省内江市",
"861787511", "广东省揭阳市",
"861340557", "江苏省扬州市",
"86188795", "江西省宜春市",
"861333088", "四川省绵阳市",
"861329051", "河北省石家庄市",
"86139550", "安徽省滁州市",
"861365953", "西藏拉萨市",
"861336528", "江苏省徐州市",
"86152999", "新疆石河子市",
"861585803", "浙江省温州市",
"861309710", "江西省景德镇市",
"861355809", "广西北海市",
"861838156", "四川省资阳市",
"861336711", "湖北省鄂州市",
"861321330", "河南省周口市",
"86186322", "河北省保定市",
"861775889", "黑龙江省伊春市",
"86151799", "江西省萍乡市",
"861319780", "江西省鹰潭市",
"861770774", "广西梧州市",
"861581162", "广东省河源市",
"861503997", "河南省安阳市",
"861508251", "四川省阿坝藏族羌族自治州",
"861358911", "山东省济南市",
"861317051", "云南省楚雄彝族自治州",
"861345817", "四川省达州市",
"861811511", "江苏省扬州市",
"861776705", "浙江省杭州市",
"86187460", "黑龙江省哈尔滨市",
"861300261", "浙江省湖州市",
"861550286", "四川省宜宾市",
"861772953", "陕西省延安市",
"861869905", "新疆乌鲁木齐市",
"861334364", "河南省驻马店市",
"861342176", "广东省阳江市",
"861352330", "河南省安阳市",
"86152008", "湖南省长沙市",
"861317730", "湖北省黄石市",
"86157120", "广东省深圳市",
"861312319", "福建省福州市",
"861361810", "四川省德阳市",
"86133376", "海南省海口市",
"861519652", "四川省广安市",
"861367618", "广东省江门市",
"861329730", "湖南省岳阳市",
"861336444", "吉林省吉林市",
"861364510", "江苏省盐城市",
"861804881", "四川省乐山市",
"861333939", "黑龙江省大庆市",
"861520004", "河北省石家庄市",
"86188411", "辽宁省大连市",
"861340344", "山西省晋中市",
"861844994", "新疆伊犁哈萨克自治州",
"861878347", "四川省广元市",
"861313275", "广西玉林市",
"861368748", "广东省揭阳市",
"861301310", "安徽省马鞍山市",
"861567642", "广西贺州市",
"861806198", "江苏省泰州市",
"861459469", "陕西省安康市",
"861814811", "四川省南充市",
"861391307", "江苏省苏州市",
"861580513", "江苏省连云港市",
"861379573", "四川省资阳市",
"861458120", "安徽省安庆市",
"861831217", "广东省河源市",
"861596099", "福建省南平市",
"861351326", "河北省廊坊市",
"861815893", "安徽省阜阳市",
"861806611", "江苏省南京市",
"861860831", "四川省宜宾市",
"861876537", "山东省济宁市",
"861365903", "四川省宜宾市",
"861453390", "内蒙古阿拉善盟",
"86139555", "安徽省马鞍山市",
"86189632", "山东省枣庄市",
"861310530", "山东省菏泽市",
"86188790", "江西省新余市",
"86187858", "贵州省六盘水市",
"861800331", "河北省石家庄市",
"861529462", "河南省郑州市",
"861321983", "四川省宜宾市",
"861370324", "河北省唐山市",
"861383397", "河北省沧州市",
"861399757", "湖北省荆州市",
"861582038", "广东省肇庆市",
"861576129", "贵州省黔东南苗族侗族自治州",
"861454141", "吉林省长春市",
"861355859", "四川省阿坝藏族羌族自治州",
"861834234", "辽宁省盘锦市",
"86153146", "浙江省杭州市",
"861888229", "四川省成都市",
"861394844", "内蒙古乌兰察布市",
"861317001", "安徽省合肥市",
"861572056", "安徽省安庆市",
"861508201", "四川省内江市",
"861899480", "江苏省盐城市",
"86138062", "江苏省苏州市",
"861824815", "内蒙古包头市",
"86155881", "山东省临沂市",
"861337739", "广西北海市",
"861393445", "山西省大同市",
"861356050", "广东省湛江市",
"861323271", "广东省湛江市",
"861709544", "江苏省苏州市",
"861823263", "河北省承德市",
"861870765", "广东省佛山市",
"861388166", "四川省巴中市",
"86184739", "湖南省邵阳市",
"861519483", "河北省石家庄市",
"861332310", "河北省邯郸市",
"861867590", "广东省梅州市",
"861830643", "山东省淄博市",
"861459793", "新疆喀什地区",
"861309816", "陕西省宝鸡市",
"861313930", "甘肃省临夏回族自治州",
"861450301", "河北省廊坊市",
"861331389", "福建省泉州市",
"861582577", "浙江省金华市",
"861881847", "广东省清远市",
"861556584", "河南省周口市",
"861353919", "广东省梅州市",
"861351367", "山西省大同市",
"861356796", "浙江省湖州市",
"861348449", "陕西省咸阳市",
"861476255", "江苏省苏州市",
"861786539", "山东省临沂市",
"861319886", "四川省泸州市",
"861362564", "安徽省合肥市",
"861572831", "广东省揭阳市",
"861311110", "山西省忻州市",
"86188438", "吉林省松原市",
"861502634", "新疆喀什地区",
"86150246", "浙江省丽水市",
"861875256", "江苏省扬州市",
"861760579", "浙江省金华市",
"861860790", "江西省新余市",
"861809689", "新疆博尔塔拉蒙古自治州",
"861580972", "青海省海东地区",
"861555060", "山东省滨州市",
"861570616", "江苏省常州市",
"861836803", "浙江省杭州市",
"861700722", "湖南省长沙市",
"861379912", "福建省南平市",
"86139413", "辽宁省抚顺市",
"861859630", "山东省烟台市",
"861330539", "山东省临沂市",
"861452646", "江苏省泰州市",
"86180637", "福建省南平市",
"861534409", "内蒙古阿拉善盟",
"861822888", "四川省巴中市",
"861323333", "山西省晋城市",
"861313556", "安徽省安庆市",
"86188370", "河南省商丘市",
"86186687", "浙江省温州市",
"861590649", "浙江省温州市",
"861339598", "福建省三明市",
"86152692", "山东省青岛市",
"861306908", "吉林省延边朝鲜族自治州",
"861551614", "河南省濮阳市",
"861868759", "云南省保山市",
"861378429", "河北省石家庄市",
"861453454", "安徽省合肥市",
"861766027", "山东省淄博市",
"86155655", "河南省信阳市",
"861572896", "西藏那曲地区",
"861813745", "河南省濮阳市",
"861363813", "贵州省铜仁地区",
"861590911", "陕西省延安市",
"861894453", "黑龙江省牡丹江市",
"861367329", "河北省唐山市",
"861809128", "陕西省西安市",
"861335349", "山西省朔州市",
"86147059", "福建省泉州市",
"861566694", "山东省泰安市",
"861776080", "安徽省宿州市",
"86145207", "上海市",
"861355099", "四川省广安市",
"861810315", "河北省唐山市",
"861872044", "江西省景德镇市",
"861348291", "河北省沧州市",
"861599345", "河南省驻马店市",
"861303313", "安徽省宣城市",
"861860885", "云南省大理白族自治州",
"86131149", "天津市",
"861812838", "广东省茂名市",
"861313383", "江西省南昌市",
"861300743", "湖南省长沙市",
"861316825", "广东省汕头市",
"86182067", "云南省昆明市",
"861558322", "四川省内江市",
"861595785", "浙江省宁波市",
"86176071", "湖北省武汉市",
"861304625", "广东省茂名市",
"861353641", "广东省湛江市",
"861529433", "甘肃省金昌市",
"86147779", "广东省广州市",
"861317836", "福建省泉州市",
"861322367", "山西省晋城市",
"861335025", "四川省南充市",
"861507797", "安徽省淮北市",
"86135556", "广东省江门市",
"861769857", "河南省商丘市",
"86151379", "河南省洛阳市",
"861361716", "湖北省荆州市",
"861360872", "云南省大理白族自治州",
"861313506", "湖南省常德市",
"861338931", "甘肃省兰州市",
"861892250", "广东省东莞市",
"861356242", "山东省济宁市",
"861516071", "福建省厦门市",
"861858562", "贵州省贵阳市",
"861842024", "广东省梅州市",
"861534459", "黑龙江省大庆市",
"861815677", "安徽省亳州市",
"861556218", "山东省临沂市",
"861709428", "广东省汕头市",
"861339789", "广西南宁市",
"861868709", "云南省昭通市",
"861306958", "河南省漯河市",
"861323980", "新疆和田地区",
"86188375", "河南省平顶山市",
"861314045", "河南省开封市",
"861889344", "甘肃省庆阳市",
"861539449", "福建省南平市",
"861592247", "安徽省宿州市",
"861347122", "广西柳州市",
"861807046", "江西省吉安市",
"861771174", "湖南省张家界市",
"861580762", "广东省河源市",
"86185942", "广东省深圳市",
"861853848", "河南省洛阳市",
"861457105", "江苏省扬州市",
"861315930", "福建省龙岩市",
"861308633", "四川省达州市",
"861532627", "辽宁省朝阳市",
"861800619", "江苏省无锡市",
"861345907", "福建省莆田市",
"861881411", "广东省广州市",
"861852735", "湖北省武汉市",
"86170860", "山东省青岛市",
"861304336", "吉林省延边朝鲜族自治州",
"86137234", "广东省深圳市",
"861311343", "广东省珠海市",
"861361536", "山东省潍坊市",
"861366470", "内蒙古呼伦贝尔市",
"861325271", "辽宁省沈阳市",
"86135117", "江苏省扬州市",
"861317265", "广东省珠海市",
"861351681", "浙江省杭州市",
"861360386", "河南省郑州市",
"861850476", "内蒙古赤峰市",
"861367703", "江西省上饶市",
"861311772", "广西柳州市",
"861836130", "江苏省扬州市",
"861539236", "福建省龙岩市",
"861598492", "四川省德阳市",
"861814951", "福建省厦门市",
"861870975", "青海省果洛藏族自治州",
"86178657", "山东省济宁市",
"861315556", "安徽省安庆市",
"861577118", "湖北省黄石市",
"861510413", "辽宁省抚顺市",
"861568563", "贵州省六盘水市",
"861885784", "浙江省温州市",
"861332143", "吉林省四平市",
"86133777", "广东省东莞市",
"861880879", "云南省普洱市",
"861871474", "黑龙江省齐齐哈尔市",
"861889507", "宁夏银川市",
"861302048", "内蒙古巴彦淖尔市",
"86188212", "上海市",
"861584500", "黑龙江省哈尔滨市",
"861584991", "内蒙古锡林郭勒盟",
"861361950", "宁夏银川市",
"861321940", "四川省南充市",
"861362520", "江苏省扬州市",
"861781111", "宁夏银川市",
"86134232", "广东省东莞市",
"861347094", "安徽省宿州市",
"861315383", "山东省莱芜市",
"86187698", "山东省泰安市",
"861780585", "浙江省绍兴市",
"861576625", "广东省肇庆市",
"861320543", "山东省滨州市",
"861572828", "广东省汕头市",
"861319372", "河南省驻马店市",
"861555192", "安徽省阜阳市",
"861360553", "安徽省芜湖市",
"861305313", "安徽省合肥市",
"861333349", "山西省朔州市",
"861777123", "湖北省襄樊市",
"86170865", "山东省潍坊市",
"861340934", "河南省平顶山市",
"861520797", "江西省赣州市",
"861856933", "湖南省娄底市",
"861769704", "青海省海南藏族自治州",
"861898697", "湖北省荆门市",
"861327372", "河南省新乡市",
"861365813", "四川省绵阳市",
"861807181", "湖北省黄冈市",
"861322681", "广东省汕头市",
"861770693", "福建省宁德市",
"861890378", "河南省开封市",
"861390984", "辽宁省大连市",
"861342812", "广东省湛江市",
"861877423", "湖南省衡阳市",
"861367753", "新疆石河子市",
"861364891", "西藏拉萨市",
"861813677", "江苏省苏州市",
"86188575", "浙江省绍兴市",
"861327743", "湖北省黄冈市",
"861379092", "广东省茂名市",
"861306074", "广东省梅州市",
"861393869", "河南省安阳市",
"861820639", "山东省临沂市",
"861320829", "四川省绵阳市",
"861303140", "河北省承德市",
"861814590", "黑龙江省鸡西市",
"86135356", "广东省佛山市",
"861319743", "湖北省鄂州市",
"861709496", "浙江省台州市",
"861862399", "河南省南阳市",
"861811890", "江苏省无锡市",
"861337519", "江苏省苏州市",
"861800941", "甘肃省甘南藏族自治州",
"861304391", "河南省焦作市",
"861336585", "湖南省郴州市",
"86159896", "广东省东莞市",
"86151579", "浙江省金华市",
"861324316", "河南省平顶山市",
"861829698", "江西省抚州市",
"861388752", "云南省文山壮族苗族自治州",
"861591003", "山东省烟台市",
"861361900", "四川省内江市",
"861827385", "湖南省怀化市",
"861889557", "安徽省马鞍山市",
"861358145", "湖北省孝感市",
"861375421", "浙江省湖州市",
"86150903", "河南省新乡市",
"861459151", "广西河池市",
"861825741", "浙江省宁波市",
"86180566", "安徽省池州市",
"861308508", "安徽省淮南市",
"86135096", "广东省深圳市",
"86183406", "辽宁省营口市",
"861360638", "山东省烟台市",
"861520978", "青海省西宁市",
"861860828", "四川省宜宾市",
"861314191", "江苏省盐城市",
"861854525", "黑龙江省双鸭山市",
"861479037", "安徽省合肥市",
"861567400", "湖南省岳阳市",
"861858713", "云南省文山壮族苗族自治州",
"861580733", "湖南省株洲市",
"861322398", "河南省濮阳市",
"861770964", "安徽省淮南市",
"861879076", "河南省安阳市",
"861882882", "四川省攀枝花市",
"861350739", "湖南省邵阳市",
"861351635", "山东省聊城市",
"861313340", "山西省忻州市",
"86138159", "江苏省泰州市",
"861800328", "河北省衡水市",
"861310710", "湖南省岳阳市",
"861800457", "黑龙江省大兴安岭地区",
"861769917", "新疆阿克苏地区",
"861366318", "河北省衡水市",
"861819115", "陕西省汉中市",
"86186522", "江苏省徐州市",
"861568488", "新疆昌吉回族自治州",
"86139783", "广西桂林市",
"861709485", "浙江省杭州市",
"861364730", "湖南省岳阳市",
"861557229", "湖北省武汉市",
"861505997", "福建省南平市",
"86182836", "四川省甘孜藏族自治州",
"861568532", "贵州省遵义市",
"861336596", "福建省泉州市",
"86147599", "福建省南平市",
"861700157", "江苏省苏州市",
"861596919", "云南省西双版纳傣族自治州",
"86183724", "湖北省荆门市",
"86189019", "上海市",
"86134788", "辽宁省沈阳市",
"861500568", "安徽省阜阳市",
"861556445", "山东省淄博市",
"861323943", "甘肃省白银市",
"86155890", "山东省临沂市",
"861363953", "宁夏吴忠市",
"861831899", "广东省阳江市",
"861590851", "贵州省贵阳市",
"86139350", "山西省忻州市",
"861315113", "江苏省扬州市",
"861570399", "河南省濮阳市",
"861309172", "黑龙江省哈尔滨市",
"861317510", "浙江省杭州市",
"86187002", "陕西省榆林市",
"861576946", "甘肃省金昌市",
"861587533", "广东省广州市",
"861357539", "浙江省丽水市",
"861811242", "江苏省徐州市",
"861383406", "山西省晋城市",
"861770877", "云南省玉溪市",
"861459101", "广西防城港市",
"861315275", "山西省长治市",
"861856962", "湖南省长沙市",
"861519440", "河南省洛阳市",
"861336531", "山东省济南市",
"861814447", "广东省江门市",
"861593242", "河北省衡水市",
"861585572", "安徽省宿州市",
"861571738", "湖南省娄底市",
"861898873", "广东省东莞市",
"861533622", "陕西省榆林市",
"861339567", "安徽省亳州市",
"861768243", "浙江省湖州市",
"861335939", "甘肃省酒泉市",
"861308558", "安徽省阜阳市",
"861811796", "四川省泸州市",
"861596641", "山东省临沂市",
"86133576", "浙江省台州市",
"861526302", "山东省枣庄市",
"861599935", "新疆昌吉回族自治州",
"861346042", "河南省新乡市",
"86139988", "辽宁省沈阳市",
"861890410", "辽宁省铁岭市",
"861804227", "浙江省湖州市",
"861800407", "辽宁省营口市",
"86152901", "河南省驻马店市",
"861301143", "河北省唐山市",
"861816139", "四川省内江市",
"861500652", "山东省东营市",
"861334320", "河北省邯郸市",
"861309956", "宁夏石嘴山市",
"861834788", "内蒙古巴彦淖尔市",
"861319261", "广东省云浮市",
"861807135", "湖北省十堰市",
"86176393", "河南省濮阳市",
"861856110", "山东省烟台市",
"861331048", "贵州省遵义市",
"861459674", "新疆阿克苏地区",
"861351398", "河南省驻马店市",
"861322635", "河北省石家庄市",
"861360395", "河南省漯河市",
"86139355", "山西省长治市",
"861864945", "广西贵港市",
"861391431", "江苏省常州市",
"861373438", "山东省临沂市",
"861590801", "山东省潍坊市",
"861532666", "黑龙江省哈尔滨市",
"861780531", "山东省济南市",
"86155895", "山东省烟台市",
"861477087", "江西省九江市",
"861824955", "黑龙江省大庆市",
"861338341", "山西省太原市",
"861593000", "河北省邯郸市",
"86130821", "河北省邯郸市",
"861538879", "云南省普洱市",
"86150708", "江西省南昌市",
"861561267", "河北省承德市",
"86131828", "江苏省南京市",
"861840676", "广西南宁市",
"861827273", "河南省焦作市",
"861813893", "广东省佛山市",
"861341481", "广东省揭阳市",
"861864667", "黑龙江省大庆市",
"86131724", "广东省深圳市",
"861390073", "湖南省湘潭市",
"861471966", "甘肃省庆阳市",
"861890061", "江苏省苏州市",
"861823021", "河北省邯郸市",
"861894532", "黑龙江省牡丹江市",
"861368916", "陕西省汉中市",
"861893860", "广东省清远市",
"861560970", "青海省海北藏族自治州",
"861320630", "山东省威海市",
"861826581", "山东省菏泽市",
"861894488", "江苏省宿迁市",
"861560724", "湖北省咸宁市",
"861376228", "湖南省娄底市",
"861882037", "广东省潮州市",
"861880792", "江西省九江市",
"861459559", "青海省海西蒙古族藏族自治州",
"861337381", "浙江省金华市",
"861844582", "黑龙江省伊春市",
"861478047", "四川省绵阳市",
"861535307", "陕西省渭南市",
"86159645", "山东省济南市",
"861331242", "贵州省黔东南苗族侗族自治州",
"86136925", "广东省茂名市",
"861450964", "新疆博尔塔拉蒙古自治州",
"86132924", "河北省唐山市",
"861339396", "河南省驻马店市",
"861576482", "内蒙古兴安盟",
"861377673", "江苏省淮安市",
"861835113", "江苏省苏州市",
"861510752", "广东省惠州市",
"861313427", "辽宁省盘锦市",
"861362390", "河南省新乡市",
"86134259", "广东省佛山市",
"861331731", "湖南省长沙市",
"86130742", "广东省佛山市",
"861815088", "福建省厦门市",
"86155015", "江苏省苏州市",
"86134560", "浙江省温州市",
"861898462", "贵州省黔东南苗族侗族自治州",
"861453889", "云南省丽江市",
"861533431", "云南省保山市",
"861887592", "广东省深圳市",
"861524211", "辽宁省鞍山市",
"861595119", "江苏省宿迁市",
"861528480", "四川省自贡市",
"86147619", "江苏省苏州市",
"861369518", "广东省佛山市",
"86187531", "山东省济南市",
"861369721", "湖北省襄樊市",
"861879451", "甘肃省临夏回族自治州",
"861316913", "广东省湛江市",
"861554979", "湖北省荆门市",
"861884961", "云南省西双版纳傣族自治州",
"861384973", "河南省信阳市",
"861830710", "湖北省襄樊市",
"86159197", "广东省深圳市",
"861306983", "黑龙江省牡丹江市",
"861833340", "河北省张家口市",
"86139546", "山东省东营市",
"861575146", "江苏省盐城市",
"861868593", "贵州省遵义市",
"861571041", "陕西省延安市",
"861593048", "河北省保定市",
"861473552", "山西省忻州市",
"861308540", "湖南省张家界市",
"86138679", "浙江省金华市",
"861314788", "辽宁省鞍山市",
"861504742", "内蒙古乌兰察布市",
"861339273", "广东省东莞市",
"861803998", "河南省三门峡市",
"861811048", "安徽省六安市",
"861778164", "四川省自贡市",
"861304718", "湖北省荆门市",
"861845842", "浙江省杭州市",
"86941", "甘肃省甘南藏族自治州",
"861504231", "辽宁省盘锦市",
"861814320", "西藏日喀则地区",
"861880439", "吉林省白山市",
"861359181", "辽宁省大连市",
"861530334", "河北省秦皇岛市",
"861509166", "陕西省榆林市",
"861871834", "广东省湛江市",
"861854503", "黑龙江省佳木斯市",
"861333893", "江苏省盐城市",
"861821949", "广东省茂名市",
"86136920", "广东省汕头市",
"861535428", "河北省衡水市",
"861367412", "辽宁省鞍山市",
"861862529", "江苏省常州市",
"86183828", "四川省巴中市",
"861820767", "广东省深圳市",
"861802772", "广东省梅州市",
"861361321", "河北省石家庄市",
"861883063", "河北省廊坊市",
"861889498", "河北省沧州市",
"861557944", "江西省宜春市",
"861850836", "四川省甘孜藏族自治州",
"861313308", "山西省吕梁市",
"86135816", "北京市",
"861510702", "江西省九江市",
"861819567", "青海省玉树藏族自治州",
"861373014", "河北省承德市",
"861390607", "福建省龙岩市",
"861514560", "黑龙江省黑河市",
"861815939", "福建省莆田市",
"861866620", "广东省深圳市",
"861331050", "湖北省荆门市",
"861802343", "广东省中山市",
"86134565", "浙江省绍兴市",
"86155010", "北京市",
"861366830", "四川省德阳市",
"861318762", "云南省文山壮族苗族自治州",
"861310680", "广东省珠海市",
"861473668", "云南省文山壮族苗族自治州",
"861824923", "黑龙江省佳木斯市",
"861846997", "云南省德宏傣族景颇族自治州",
"861477832", "广东省广州市",
"861306330", "安徽省滁州市",
"861561573", "山东省淄博市",
"861825038", "福建省龙岩市",
"861862843", "陕西省渭南市",
"86135967", "吉林省白山市",
"861356389", "山东省菏泽市",
"861879401", "甘肃省甘南藏族自治州",
"861529668", "山西省吕梁市",
"861339331", "河北省石家庄市",
"861586383", "山东省烟台市",
"861340467", "吉林省吉林市",
"861387205", "湖北省黄石市",
"861364476", "内蒙古赤峰市",
"86181576", "浙江省台州市",
"861336367", "河北省沧州市",
"861331796", "江西省吉安市",
"861382481", "广东省湛江市",
"861772988", "四川省南充市",
"861538439", "广东省汕尾市",
"861550314", "河北省承德市",
"861470902", "新疆哈密地区",
"861856217", "山东省烟台市",
"861334951", "黑龙江省哈尔滨市",
"861340426", "江苏省无锡市",
"861886307", "山东省滨州市",
"861580204", "广东省广州市",
"86150569", "安徽省合肥市",
"861777105", "湖北省黄石市",
"861309643", "四川省德阳市",
"86182977", "安徽省安庆市",
"861846209", "山东省淄博市",
"861570529", "江苏省镇江市",
"861875154", "江苏省无锡市",
"861533485", "内蒙古兴安盟",
"861394571", "黑龙江省黑河市",
"861571316", "河北省廊坊市",
"861326478", "湖北省襄樊市",
"861576603", "广东省清远市",
"861556634", "辽宁省营口市",
"86158028", "四川省成都市",
"861787615", "广东省江门市",
"86139810", "四川省德阳市",
"86187114", "湖南省衡阳市",
"861819526", "宁夏吴忠市",
"861803777", "河南省郑州市",
"861370446", "吉林省延边朝鲜族自治州",
"86152312", "河北省保定市",
"861707875", "云南省丽江市",
"861311059", "福建省厦门市",
"861808141", "四川省成都市",
"861502584", "甘肃省定西市",
"86159016", "上海市",
"861598626", "广东省阳江市",
"861893766", "河南省信阳市",
"861835930", "福建省龙岩市",
"861534569", "安徽省合肥市",
"861820726", "湖北省荆门市",
"861366791", "江西省南昌市",
"861538246", "浙江省金华市",
"86152839", "四川省广元市",
"861333003", "江西省九江市",
"861322711", "湖北省鄂州市",
"861331785", "广西玉林市",
"861330689", "浙江省金华市",
"861571195", "广东省深圳市",
"861390419", "辽宁省辽阳市",
"861886544", "山东省烟台市",
"861780326", "河北省廊坊市",
"86150250", "云南省保山市",
"861321958", "四川省内江市",
"861509127", "陕西省渭南市",
"861452813", "四川省自贡市",
"861361948", "云南省楚雄彝族自治州",
"861351444", "吉林省吉林市",
"861857906", "江西省南昌市",
"861302050", "山东省济宁市",
"861831343", "云南省玉溪市",
"861826535", "山东省烟台市",
"861770437", "吉林省辽源市",
"861561912", "陕西省榆林市",
"861359311", "山西省晋中市",
"861800598", "福建省三明市",
"861337335", "河北省秦皇岛市",
"86147912", "陕西省榆林市",
"861895152", "江苏省宿迁市",
"861337698", "福建省厦门市",
"861334590", "浙江省金华市",
"861334901", "安徽省合肥市",
"861300023", "上海市",
"861339385", "河南省焦作市",
"861470952", "宁夏石嘴山市",
"86187518", "江苏省南京市",
"861538792", "江西省九江市",
"861351528", "江苏省宿迁市",
"861322444", "吉林省四平市",
"861777155", "湖北省荆门市",
"861864739", "内蒙古呼和浩特市",
"861829519", "宁夏银川市",
"861822093", "陕西省渭南市",
"861560235", "广东省清远市",
"861302731", "湖南省长沙市",
"861352958", "云南省曲靖市",
"861362454", "黑龙江省佳木斯市",
"861883032", "河北省张家口市",
"861351711", "湖北省武汉市",
"861807589", "湖南省衡阳市",
"861551238", "河北省承德市",
"86186496", "福建省厦门市",
"86138972", "青海省西宁市",
"861360525", "江苏省扬州市",
"861857530", "广东省梅州市",
"861354828", "四川省达州市",
"86139747", "湖南省衡阳市",
"861331890", "广东省云浮市",
"86139815", "四川省凉山彝族自治州",
"861839743", "湖南省衡阳市",
"861595389", "山东省威海市",
"861813025", "安徽省宣城市",
"861858402", "四川省泸州市",
"861839372", "甘肃省定西市",
"861775404", "安徽省宣城市",
"861313466", "山西省晋城市",
"86182137", "云南省曲靖市",
"861308497", "广西钦州市",
"861555847", "浙江省台州市",
"861333053", "云南省昆明市",
"861318733", "湖南省衡阳市",
"861818016", "四川省绵阳市",
"861810719", "湖北省十堰市",
"861584548", "黑龙江省鹤岗市",
"861564697", "新疆阿克苏地区",
"861513863", "河南省南阳市",
"86150192", "广东省深圳市",
"86150255", "重庆市",
"861477863", "广东省清远市",
"861367725", "湖北省荆门市",
"861877455", "湖南省怀化市",
"861850730", "湖南省岳阳市",
"861337111", "山东省枣庄市",
"861380776", "广西百色市",
"861813349", "安徽省六安市",
"861709622", "山东省济宁市",
"861772039", "湖北省宜昌市",
"861707644", "山东省青岛市",
"861579716", "湖北省随州市",
"861471927", "甘肃省白银市",
"861800789", "广西梧州市",
"861824690", "黑龙江省双鸭山市",
"861760604", "福建省宁德市",
"861529697", "宁夏银川市",
"861810539", "山东省临沂市",
"861708534", "山东省烟台市",
"861390592", "福建省福州市",
"861339619", "湖北省恩施土家族苗族自治州",
"861850510", "江苏省无锡市",
"861560866", "湖北省随州市",
"861588530", "贵州省毕节地区",
"861532352", "广东省东莞市",
"861308583", "广东省珠海市",
"861340498", "云南省大理白族自治州",
"86176068", "浙江省宁波市",
"861565132", "江苏省南通市",
"861770301", "广东省江门市",
"861379226", "山东省滨州市",
"861399489", "山西省运城市",
"861332287", "广东省珠海市",
"861594759", "内蒙古鄂尔多斯市",
"86155175", "河南省郑州市",
"861843290", "河北省邯郸市",
"861539134", "云南省昆明市",
"861361686", "浙江省台州市",
"861855850", "福建省三明市",
"861890255", "广东省江门市",
"861860471", "内蒙古呼和浩特市",
"861314725", "湖北省荆门市",
"861360463", "黑龙江省牡丹江市",
"861768317", "四川省南充市",
"86152270", "河北省保定市",
"861351531", "山东省济南市",
"86182996", "新疆喀什地区",
"861831962", "广东省惠州市",
"861308306", "安徽省合肥市",
"861310643", "浙江省绍兴市",
"861590377", "河南省南阳市",
"86136507", "广东省广州市",
"861874957", "河南省许昌市",
"861837891", "广西北海市",
"861598698", "广东省惠州市",
"861858640", "贵州省遵义市",
"861321074", "山东省潍坊市",
"861820798", "江西省景德镇市",
"861803967", "河南省郑州市",
"861312581", "吉林省长春市",
"861872827", "四川省资阳市",
"861771276", "江苏省常州市",
"861800526", "江苏省泰州市",
"86181796", "江西省吉安市",
"86155930", "甘肃省临夏回族自治州",
"861335003", "四川省广元市",
"86152512", "江苏省连云港市",
"861586340", "山东省莱芜市",
"861304603", "山东省济南市",
"861803645", "江苏省南通市",
"861322596", "福建省厦门市",
"861811389", "四川省雅安市",
"861818996", "西藏那曲地区",
"861354831", "四川省内江市",
"861351596", "福建省厦门市",
"861365646", "山东省潍坊市",
"861397246", "湖北省十堰市",
"861781739", "广东省佛山市",
"861593389", "河北省邯郸市",
"861780635", "山东省聊城市",
"861760654", "浙江省杭州市",
"861530944", "甘肃省庆阳市",
"861337626", "江苏省常州市",
"86177207", "福建省福州市",
"861532302", "广东省梅州市",
"861551784", "河南省平顶山市",
"861770351", "山西省太原市",
"861376285", "湖南省邵阳市",
"861380966", "广东省惠州市",
"861598335", "四川省乐山市",
"861885032", "福建省厦门市",
"861809719", "青海省海西蒙古族藏族自治州",
"861764060", "辽宁省锦州市",
"861322531", "山东省济南市",
"86155170", "河南省商丘市",
"861354896", "湖南省长沙市",
"86187318", "河北省衡水市",
"861818931", "甘肃省兰州市",
"861594709", "内蒙古锡林郭勒盟",
"86156274", "广东省深圳市",
"861347489", "内蒙古鄂尔多斯市",
"861771393", "四川省凉山彝族自治州",
"861321269", "湖南省衡阳市",
"861330315", "河北省唐山市",
"861308356", "江苏省南通市",
"861596545", "山东省东营市",
"861474132", "辽宁省沈阳市",
"861567173", "湖北省黄冈市",
"861528443", "云南省玉溪市",
"86135340", "广东省深圳市",
"86152275", "河北省沧州市",
"861817492", "广西河池市",
"861588906", "西藏那曲地区",
"861820589", "浙江省金华市",
"861319023", "辽宁省丹东市",
"86155935", "甘肃省武威市",
"861335053", "四川省眉山市",
"861339941", "甘肃省甘南藏族自治州",
"861511976", "广东省清远市",
"861328846", "广东省广州市",
"861833383", "河北省衡水市",
"861368856", "贵州省铜仁地区",
"861863374", "河北省沧州市",
"861332838", "福建省南平市",
"861876272", "江苏省连云港市",
"861353484", "广东省江门市",
"86183149", "浙江省金华市",
"861315466", "四川省自贡市",
"86186477", "内蒙古鄂尔多斯市",
"861897870", "广西玉林市",
"861773404", "河北省石家庄市",
"861312535", "江西省吉安市",
"861591939", "广东省惠州市",
"861376296", "湖南省永州市",
"861315358", "山东省滨州市",
"86155493", "湖北省宜昌市",
"861315427", "辽宁省盘锦市",
"861813088", "新疆乌鲁木齐市",
"861774805", "四川省绵阳市",
"861857816", "广东省河源市",
"86187754", "广西梧州市",
"861329476", "内蒙古赤峰市",
"861533307", "山西省临汾市",
"861571699", "河北省邢台市",
"861570795", "江西省宜春市",
"861354885", "湖南省常德市",
"861360588", "浙江省宁波市",
"861874299", "新疆伊犁哈萨克自治州",
"861537314", "河北省承德市",
"861839780", "江西省新余市",
"861368700", "江西省南昌市",
"861351585", "浙江省绍兴市",
"861886485", "山东省聊城市",
"861806781", "浙江省嘉兴市",
"861526627", "山东省枣庄市",
"861825021", "福建省漳州市",
"861318156", "山东省菏泽市",
"861771505", "江苏省泰州市",
"861821126", "广东省肇庆市",
"861892157", "江苏省镇江市",
"861869923", "新疆伊犁哈萨克自治州",
"861805149", "江苏省连云港市",
"861392259", "广东省韶关市",
"861339457", "黑龙江省佳木斯市",
"861317476", "浙江省台州市",
"861308468", "浙江省台州市",
"861339328", "河北省衡水市",
"861367788", "广西南宁市",
"86139346", "山西省太原市",
"861707392", "河南省鹤壁市",
"861475552", "安徽省池州市",
"86132420", "广东省深圳市",
"861595048", "江苏省南京市",
"861830906", "新疆阿勒泰地区",
"86187331", "河北省石家庄市",
"861380927", "广东省东莞市",
"861373994", "内蒙古通辽市",
"861350335", "河北省秦皇岛市",
"861314412", "广东省佛山市",
"861361338", "河北省秦皇岛市",
"861831933", "广东省湛江市",
"861533544", "山东省德州市",
"861470812", "四川省成都市",
"861777609", "广西桂林市",
"861851572", "四川省泸州市",
"861337667", "广东省清远市",
"86134360", "重庆市",
"861304538", "黑龙江省七台河市",
"861337945", "陕西省安康市",
"861304482", "湖北省孝感市",
"861535431", "河北省石家庄市",
"861309680", "贵州省黔西南布依族苗族自治州",
"86186643", "广东省深圳市",
"861324721", "湖北省孝感市",
"861479376", "甘肃省白银市",
"86136706", "广东省佛山市",
"861452953", "广东省珠海市",
"861830530", "山东省菏泽市",
"861589633", "江苏省宿迁市",
"861866664", "广东省潮州市",
"861782829", "四川省内江市",
"861859829", "广东省中山市",
"861315308", "山东省菏泽市",
"861335893", "辽宁省朝阳市",
"861811119", "四川省泸州市",
"861355545", "黑龙江省双鸭山市",
"861822572", "安徽省安庆市",
"861800567", "安徽省亳州市",
"861533357", "山西省临汾市",
"861319610", "吉林省白城市",
"861536032", "广东省阳江市",
"861803926", "河南省三门峡市",
"86153984", "云南省昆明市",
"861360799", "江西省萍乡市",
"861361695", "福建省三明市",
"861533428", "湖北省黄石市",
"861889426", "甘肃省张掖市",
"861350698", "福建省福州市",
"861843842", "河南省漯河市",
"861328740", "山东省日照市",
"861812180", "四川省南充市",
"86181597", "福建省漳州市",
"86593", "福建省宁德市",
"861878420", "四川省广安市",
"861327610", "江苏省盐城市",
"861772925", "陕西省安康市",
"861392209", "广东省湛江市",
"861339407", "福建省泉州市",
"861324518", "内蒙古乌兰察布市",
"86189952", "宁夏石嘴山市",
"861535496", "内蒙古包头市",
"861454823", "广东省江门市",
"861805998", "福建省泉州市",
"861318106", "山东省聊城市",
"861802110", "江苏省南京市",
"861500458", "黑龙江省大庆市",
"861806224", "湖北省襄樊市",
"861598381", "四川省德阳市",
"861830956", "宁夏固原市",
"86151862", "贵州省六盘水市",
"861576718", "广东省梅州市",
"86132425", "广东省韶关市",
"861500327", "河北省沧州市",
"861778120", "四川省南充市",
"861840201", "广东省广州市",
"861814364", "吉林省四平市",
"861823038", "河北省张家口市",
"861879169", "陕西省渭南市",
"861856059", "山东省聊城市",
"861322585", "安徽省合肥市",
"861777659", "广西河池市",
"861890576", "浙江省台州市",
"86159936", "河南省许昌市",
"861334811", "江苏省无锡市",
"861509702", "甘肃省金昌市",
"861560827", "四川省南充市",
"861331728", "湖北省十堰市",
"861458266", "安徽省芜湖市",
"861820977", "青海省海西蒙古族藏族自治州",
"861813939", "新疆伊犁哈萨克自治州",
"861570880", "云南省昭通市",
"861454549", "新疆伊犁哈萨克自治州",
"861393992", "河南省洛阳市",
"861816444", "安徽省淮南市",
"861364913", "陕西省渭南市",
"861313658", "浙江省台州市",
"861362690", "福建省莆田市",
"861836001", "江苏省泰州市",
"861570721", "湖北省襄樊市",
"86147400", "辽宁省沈阳市",
"861339696", "浙江省温州市",
"861530992", "新疆伊犁哈萨克自治州",
"86178540", "山东省菏泽市",
"86151103", "山西省太原市",
"861505480", "山东省泰安市",
"861344857", "山东省日照市",
"861801115", "四川省广元市",
"861370542", "山东省青岛市",
"861332372", "河南省安阳市",
"861825095", "福建省南平市",
"861771920", "河南省郑州市",
"861867664", "广东省云浮市",
"861337681", "浙江省杭州市",
"861452548", "山东省泰安市",
"861771774", "河北省唐山市",
"861570518", "江苏省南京市",
"861781711", "广东省佛山市",
"861376868", "广西柳州市",
"861833640", "河南省安阳市",
"86188272", "湖北省宜昌市",
"86157025", "山西省晋中市",
"86133717", "北京市",
"86187561", "安徽省淮北市",
"861317093", "江西省上饶市",
"861311906", "新疆阿勒泰地区",
"861332743", "山西省太原市",
"861893220", "江苏省南通市",
"861379970", "福建省漳州市",
"861561044", "山东省潍坊市",
"861534761", "广东省河源市",
"861858930", "云南省曲靖市",
"861580910", "陕西省咸阳市",
"861821311", "云南省怒江傈僳族自治州",
"861806767", "浙江省绍兴市",
"861322519", "江苏省常州市",
"86155347", "山西省临汾市",
"86134530", "山西省忻州市",
"861450505", "吉林省吉林市",
"861857059", "湖南省岳阳市",
"861869454", "浙江省嘉兴市",
"861700914", "陕西省西安市",
"861555246", "山东省烟台市",
"861379724", "湖北省咸宁市",
"861889435", "甘肃省金昌市",
"861859958", "福建省莆田市",
"861390428", "辽宁省大连市",
"861809731", "青海省西宁市",
"861390357", "山西省临汾市",
"861323468", "黑龙江省鹤岗市",
"861329093", "福建省福州市",
"861390544", "山东省德州市",
"861350326", "河北省廊坊市",
"861351519", "江苏省无锡市",
"861809050", "四川省广安市",
"861829528", "宁夏银川市",
"861815145", "江苏省宿迁市",
"86139451", "黑龙江省哈尔滨市",
"861501440", "广东省湛江市",
"86178545", "山东省烟台市",
"861808038", "四川省眉山市",
"86147405", "辽宁省丹东市",
"861311530", "黑龙江省哈尔滨市",
"861324795", "江西省宜春市",
"861575808", "云南省昭通市",
"86153046", "黑龙江省哈尔滨市",
"861377296", "陕西省安康市",
"861470430", "吉林省长春市",
"861313562", "湖北省孝感市",
"861780667", "广东省珠海市",
"861772991", "安徽省芜湖市",
"861320983", "山西省大同市",
"861511220", "广东省广州市",
"861566560", "安徽省合肥市",
"861530634", "山东省莱芜市",
"86137826", "河南省焦作市",
"861780945", "甘肃省武威市",
"861302539", "广东省云浮市",
"861365936", "甘肃省酒泉市",
"86184247", "辽宁省葫芦岛市",
"861352580", "河南省安阳市",
"86157020", "广东省广州市",
"861848352", "四川省泸州市",
"861770523", "江苏省淮安市",
"861452424", "辽宁省沈阳市",
"861776609", "江苏省南京市",
"861810511", "江苏省盐城市",
"861705225", "浙江省杭州市",
"861565084", "安徽省阜阳市",
"861357615", "江西省宜春市",
"86135937", "湖北省十堰市",
"861535073", "河北省张家口市",
"861898527", "贵州省黔东南苗族侗族自治州",
"861806820", "江苏省宿迁市",
"861800581", "浙江省杭州市",
"86187833", "四川省眉山市",
"86151519", "江苏省常州市",
"86186948", "浙江省杭州市",
"861360810", "四川省德阳市",
"861339631", "山东省威海市",
"861319143", "内蒙古呼和浩特市",
"861312526", "江西省吉安市",
"861568876", "山东省莱芜市",
"861529368", "甘肃省平凉市",
"861775690", "安徽省滁州市",
"861341344", "广东省汕头市",
"861366788", "广西南宁市",
"861815851", "浙江省杭州市",
"861821135", "广东省阳江市",
"861847017", "江西省抚州市",
"861310380", "河南省新乡市",
"861303740", "湖南省湘西土家族苗族自治州",
"8615683", "重庆市",
"861576595", "黑龙江省大庆市",
"861375332", "山西省阳泉市",
"86156500", "山东省济南市",
"861338484", "内蒙古包头市",
"861868461", "湖南省常德市",
"861390307", "广东省广州市",
"861368473", "内蒙古锡林郭勒盟",
"861869404", "湖北省武汉市",
"861325540", "山东省菏泽市",
"861365550", "安徽省滁州市",
"86184652", "宁夏银川市",
"861538847", "四川省达州市",
"86132277", "陕西省西安市",
"86134535", "山西省长治市",
"861802643", "广东省广州市",
"861369843", "江西省上饶市",
"861507168", "湖北省黄冈市",
"861819715", "青海省海东地区",
"861377285", "陕西省延安市",
"861323306", "山西省临汾市",
"861539477", "内蒙古鄂尔多斯市",
"861376219", "湖南省张家界市",
"861876117", "江苏省常州市",
"861558307", "四川省阿坝藏族羌族自治州",
"861834470", "江苏省南通市",
"86156589", "浙江省金华市",
"861329853", "湖南省湘潭市",
"861331539", "河北省秦皇岛市",
"861300180", "河北省石家庄市",
"86138301", "甘肃省酒泉市",
"861556334", "山东省日照市",
"861571616", "江苏省无锡市",
"861521894", "广东省佛山市",
"861593315", "河北省唐山市",
"86150539", "山东省临沂市",
"861314791", "辽宁省锦州市",
"861312567", "辽宁省辽阳市",
"861450276", "内蒙古赤峰市",
"861317853", "广东省佛山市",
"861855254", "江苏省镇江市",
"861518902", "江苏省连云港市",
"861309343", "安徽省六安市",
"861334839", "福建省厦门市",
"861773923", "河南省南阳市",
"86185124", "辽宁省沈阳市",
"861868655", "吉林省吉林市",
"861532440", "安徽省巢湖市",
"861825141", "江苏省连云港市",
"861359198", "辽宁省葫芦岛市",
"861572062", "江苏省南京市",
"861707557", "安徽省阜阳市",
"861457080", "江苏省泰州市",
"861813911", "新疆阿克苏地区",
"86155464", "黑龙江省哈尔滨市",
"861865151", "江苏省无锡市",
"861324786", "江西省南昌市",
"861590745", "湖南省怀化市",
"861591649", "广东省潮州市",
"86189759", "湖南省邵阳市",
"861870669", "山东省潍坊市",
"861783545", "山西省长治市",
"861337635", "山东省聊城市",
"86153610", "广东省深圳市",
"861877272", "湖北省荆门市",
"861595128", "江苏省镇江市",
"861376794", "江西省景德镇市",
"861586452", "山东省济南市",
"861382498", "广东省阳江市",
"861534243", "湖北省黄冈市",
"861309772", "广西柳州市",
"861831643", "广东省阳江市",
"861323583", "浙江省嘉兴市",
"86176931", "甘肃省兰州市",
"861811131", "四川省甘孜藏族自治州",
"861310962", "陕西省咸阳市",
"861880847", "四川省巴中市",
"861593196", "河北省邢台市",
"861330389", "河南省焦作市",
"861700757", "广东省佛山市",
"861332261", "广东省东莞市",
"86145922", "四川省成都市",
"86170981", "浙江省杭州市",
"86188453", "黑龙江省牡丹江市",
"861558544", "吉林省四平市",
"861569239", "山东省临沂市",
"861598326", "四川省内江市",
"861899968", "新疆哈密地区",
"861517406", "辽宁省锦州市",
"861329803", "内蒙古赤峰市",
"861301372", "江苏省扬州市",
"861558357", "四川省乐山市",
"861313533", "湖南省株洲市",
"861323356", "山西省晋城市",
"861472875", "贵州省黔西南布依族苗族自治州",
"86185528", "江苏省徐州市",
"861363346", "山西省晋城市",
"861304729", "湖南省怀化市",
"861583510", "山西省太原市",
"861364572", "浙江省湖州市",
"861522295", "安徽省马鞍山市",
"861568770", "云南省玉溪市",
"861894491", "湖南省益阳市",
"861557012", "江西省赣州市",
"861303846", "陕西省汉中市",
"861317803", "福建省福州市",
"861333377", "河南省南阳市",
"861529406", "甘肃省陇南市",
"861361872", "云南省大理白族自治州",
"861862518", "江苏省南京市",
"861800535", "山东省烟台市",
"861867993", "江西省南昌市",
"861535419", "河北省邢台市",
"861865101", "江苏省无锡市",
"861359949", "福建省莆田市",
"861337398", "河南省三门峡市",
"861763337", "河北省张家口市",
"861766052", "山东省威海市",
"861458764", "广东省汕头市",
"861459701", "宁夏吴忠市",
"861345114", "湖北省武汉市",
"861339685", "浙江省绍兴市",
"861358282", "河北省保定市",
"861863469", "山西省运城市",
"86138599", "福建省厦门市",
"86153615", "广东省深圳市",
"861778040", "四川省广元市",
"861813649", "江苏省南京市",
"861564397", "吉林省白山市",
"861373942", "四川省资阳市",
"861869390", "甘肃省陇南市",
"861803270", "河北省沧州市",
"861586402", "山东省济南市",
"861769822", "河南省新乡市",
"861552894", "四川省巴中市",
"861533592", "湖北省襄樊市",
"861774021", "四川省成都市",
"861856710", "河南省漯河市",
"861300478", "浙江省台州市",
"861858275", "四川省眉山市",
"861836891", "甘肃省兰州市",
"861301743", "贵州省贵阳市",
"86182167", "贵州省六盘水市",
"861804083", "新疆石河子市",
"861816739", "浙江省温州市",
"86150812", "河北省保定市",
"861310772", "浙江省杭州市",
"861775923", "福建省福州市",
"861309962", "云南省西双版纳傣族自治州",
"861350681", "浙江省杭州市",
"861368999", "新疆克拉玛依市",
"861815911", "福建省莆田市",
"861454414", "福建省厦门市",
"86150339", "河北省唐山市",
"861818809", "贵州省黔西南布依族苗族自治州",
"86139647", "山东省潍坊市",
"861478127", "四川省攀枝花市",
"86145044", "辽宁省大连市",
"861770601", "福建省厦门市",
"861845894", "浙江省台州市",
"861816519", "陕西省榆林市",
"861899778", "新疆阿勒泰地区",
"861582549", "浙江省台州市",
"861332895", "福建省宁德市",
"86138501", "福建省福州市",
"861532652", "黑龙江省齐齐哈尔市",
"861870474", "内蒙古乌兰察布市",
"861881879", "广东省深圳市",
"861359126", "辽宁省锦州市",
"861339319", "河北省邢台市",
"861539203", "福建省厦门市",
"861320940", "甘肃省酒泉市",
"861311816", "四川省绵阳市",
"861348477", "内蒙古鄂尔多斯市",
"861319180", "河北省秦皇岛市",
"861395944", "福建省宁德市",
"861586640", "山东省潍坊市",
"861760547", "山东省济宁市",
"861810785", "广西玉林市",
"861811689", "新疆伊犁哈萨克自治州",
"861304303", "河南省平顶山市",
"861803345", "广东省东莞市",
"861880411", "辽宁省大连市",
"86139252", "广东省深圳市",
"861801619", "四川省宜宾市",
"861862738", "湖南省娄底市",
"861399107", "陕西省榆林市",
"861830059", "山东省菏泽市",
"861573098", "甘肃省兰州市",
"861336111", "山东省枣庄市",
"861876455", "山东省滨州市",
"861372337", "宁夏银川市",
"861371982", "广东省云浮市",
"861776841", "江苏省苏州市",
"861317572", "浙江省衢州市",
"861309110", "河北省邯郸市",
"86155960", "陕西省榆林市",
"861863845", "河南省南阳市",
"86159223", "安徽省安庆市",
"861772346", "四川省攀枝花市",
"861325583", "浙江省嘉兴市",
"861858340", "四川省雅安市",
"861598398", "四川省巴中市",
"861575026", "云南省普洱市",
"86135017", "上海市",
"861329572", "浙江省湖州市",
"861360536", "山东省潍坊市",
"861310343", "山西省太原市",
"861590677", "浙江省温州市",
"861814993", "新疆石河子市",
"86133157", "河北省沧州市",
"86155746", "湖南省永州市",
"861533419", "湖北省咸宁市",
"861890472", "内蒙古包头市",
"861580850", "贵州省贵阳市",
"861327478", "内蒙古巴彦淖尔市",
"861577603", "黑龙江省绥化市",
"861305846", "广东省潮州市",
"861770651", "浙江省杭州市",
"86181677", "新疆昌吉回族自治州",
"861323497", "黑龙江省哈尔滨市",
"861840578", "浙江省丽水市",
"861820735", "湖南省郴州市",
"86188471", "内蒙古呼和浩特市",
"861786615", "甘肃省陇南市",
"861700854", "贵州省黔南布依族苗族自治州",
"861787689", "广东省广州市",
"861818859", "贵州省黔西南布依族苗族自治州",
"861880744", "湖南省张家界市",
"861329130", "江苏省常州市",
"861595131", "江苏省南通市",
"861335377", "河南省南阳市",
"86133316", "吉林省长春市",
"861319478", "四川省资阳市",
"861337326", "河北省廊坊市",
"861357119", "陕西省宝鸡市",
"861813091", "新疆乌鲁木齐市",
"861857217", "湖北省武汉市",
"861376897", "广西玉林市",
"861810890", "西藏拉萨市",
"861315533", "安徽省芜湖市",
"861360591", "福建省龙岩市",
"861317130", "内蒙古兴安盟",
"861780335", "河北省秦皇岛市",
"861593689", "河南省三门峡市",
"861539253", "山西省阳泉市",
"861760354", "山西省晋中市",
"861705514", "浙江省台州市",
"861896927", "浙江省湖州市",
"861776105", "四川省南充市",
"861338545", "山东省烟台市",
"861365346", "山西省晋城市",
"861569594", "福建省莆田市",
"861332780", "江苏省南京市",
"861774989", "河北省保定市",
"861889522", "宁夏石嘴山市",
"861568960", "山东省临沂市",
"861390485", "黑龙江省绥化市",
"861361553", "安徽省芜湖市",
"86155965", "陕西省榆林市",
"861830009", "广东省东莞市",
"861522861", "四川省自贡市",
"861832457", "黑龙江省伊春市",
"861336335", "河北省秦皇岛市",
"86187894", "陕西省西安市",
"861399157", "陕西省宝鸡市",
"861362923", "陕西省渭南市",
"861454741", "浙江省温州市",
"861576729", "广东省清远市",
"861893413", "广东省东莞市",
"861805270", "江苏省常州市",
"861521797", "广东省深圳市",
"861341934", "四川省雅安市",
"861364853", "贵州省安顺市",
"861367791", "江西省南昌市",
"861330615", "江苏省无锡市",
"861308656", "四川省宜宾市",
"861301055", "广东省中山市",
"861575918", "福建省南平市",
"861538744", "湖南省张家界市",
"861832941", "陕西省延安市",
"861804202", "浙江省杭州市",
"86159740", "湖南省怀化市",
"861339628", "山东省滨州市",
"861839838", "四川省甘孜藏族自治州",
"861800422", "辽宁省鞍山市",
"861513410", "辽宁省抚顺市",
"861566448", "山东省潍坊市",
"86170990", "贵州省贵阳市",
"861537614", "山东省菏泽市",
"861383433", "山西省临汾市",
"861533607", "甘肃省定西市",
"861571399", "河南省驻马店市",
"86138779", "广西北海市",
"861807260", "浙江省湖州市",
"861309933", "甘肃省平凉市",
"861589980", "广东省佛山市",
"861597484", "云南省昆明市",
"861810731", "湖南省长沙市",
"861380069", "浙江省杭州市",
"861806977", "浙江省杭州市",
"86182448", "湖南省怀化市",
"861314153", "江苏省连云港市",
"861558485", "吉林省白城市",
"861534971", "青海省西宁市",
"861564368", "吉林省白城市",
"86187102", "北京市",
"861337139", "山东省烟台市",
"861890087", "广东省佛山市",
"861782074", "广东省深圳市",
"861580706", "江西省吉安市",
"86155547", "山东省济宁市",
"86134330", "广东省东莞市",
"86152304", "河北省保定市",
"861808021", "四川省内江市",
"86156305", "河北省唐山市",
"86188310", "河北省邯郸市",
"861518812", "云南省曲靖市",
"861332055", "云南省大理白族自治州",
"861810000", "北京市",
"861361638", "山东省聊城市",
"861521978", "广东省中山市",
"861778083", "四川省内江市",
"861770465", "福建省泉州市",
"861318848", "辽宁省辽阳市",
"86135196", "甘肃省兰州市",
"861337367", "江苏省扬州市",
"861394969", "河南省焦作市",
"861829531", "宁夏银川市",
"861512865", "河北省廊坊市",
"86187361", "河南省周口市",
"861804040", "四川省德阳市",
"861867620", "广东省河源市",
"861771964", "陕西省榆林市",
"861350635", "山东省聊城市",
"861351739", "湖南省邵阳市",
"861390496", "辽宁省锦州市",
"8628", "四川省成都市\、资阳市\、眉山市",
"861864528", "黑龙江省佳木斯市",
"861367830", "四川省泸州市",
"861850825", "四川省遂宁市",
"861801457", "江苏省宿迁市",
"861311710", "湖北省十堰市",
"86147904", "安徽省合肥市",
"86138059", "福建省泉州市",
"861369795", "江西省宜春市",
"86159745", "云南省曲靖市",
"861577538", "四川省遂宁市",
"861332886", "福建省福州市",
"86159817", "新疆乌鲁木齐市",
"861804252", "浙江省宁波市",
"861300143", "河北省廊坊市",
"861577482", "内蒙古兴安盟",
"861376673", "黑龙江省伊春市",
"861592613", "湖北省恩施土家族苗族自治州",
"861876661", "山东省东营市",
"861594990", "山东省淄博市",
"861350398", "河南省三门峡市",
"86170995", "宁夏银川市",
"861824454", "河北省廊坊市",
"861315562", "安徽省铜陵市",
"86130642", "云南省昆明市",
"86132296", "广东省汕头市",
"86181856", "贵州省铜仁地区",
"861390431", "吉林省长春市",
"861573808", "河南省南阳市",
"861809728", "青海省玉树藏族自治州",
"861361395", "河南省漯河市",
"861562474", "内蒙古乌兰察布市",
"861377228", "陕西省延安市",
"861340481", "内蒙古呼和浩特市",
"861817596", "湖南省长沙市",
"861382467", "广东省云浮市",
"861304595", "福建省泉州市",
"861315608", "山东省威海市",
"861560267", "广东省汕尾市",
"861359339", "山西省吕梁市",
"861344068", "福建省泉州市",
"861323540", "湖北省鄂州市",
"861831680", "广东省河源市",
"86156300", "河北省邯郸市",
"86188315", "河北省唐山市",
"861317913", "吉林省长春市",
"861312598", "黑龙江省哈尔滨市",
"861839287", "陕西省西安市",
"861580756", "广东省珠海市",
"861538411", "浙江省嘉兴市",
"86134335", "广东省惠州市",
"861534280", "湖北省随州市",
"861363550", "安徽省滁州市",
"86159966", "江苏省南通市",
"861813851", "广东省佛山市",
"861344754", "山东省济南市",
"86130257", "广东省惠州市",
"86189503", "福建省福州市",
"861376057", "广东省揭阳市",
"861373332", "河北省保定市",
"861570738", "湖南省娄底市",
"861810050", "安徽省合肥市",
"861589271", "四川省眉山市",
"861332005", "江西省宜春市",
"861398032", "四川省广安市",
"861453815", "四川省绵阳市",
"861845004", "福建省厦门市",
"86151319", "河北省邢台市",
"861351492", "安徽省阜阳市",
"861814664", "江西省宜春市",
"86181443", "四川省成都市",
"861773690", "河北省石家庄市",
"86147062", "江苏省苏州市",
"861454263", "西藏山南地区",
"861810796", "江西省吉安市",
"861500627", "江苏省南通市",
"861820781", "广西南宁市",
"861579799", "江西省抚州市",
"861801407", "江苏省镇江市",
"861598681", "广东省深圳市",
"861837888", "广西河池市",
"861835784", "浙江省温州市",
"86138777", "广西钦州市",
"861830879", "云南省普洱市",
"861459173", "内蒙古包头市",
"861378520", "河北省石家庄市",
"861340610", "山东省东营市",
"861571379", "河南省洛阳市",
"861839507", "宁夏银川市",
"86151156", "湖南省常德市",
"86139942", "山西省太原市",
"861534500", "福建省福州市",
"861534991", "新疆乌鲁木齐市",
"861869782", "青海省海西蒙古族藏族自治州",
"861899864", "广东省阳江市",
"861760629", "山东省枣庄市",
"861768813", "广东省中山市",
"861898801", "云南省丽江市",
"861338702", "江西省九江市",
"861356176", "山东省泰安市",
"861346330", "河北省张家口市",
"861302274", "山东省烟台市",
"861330430", "吉林省长春市",
"8613444", "上海市",
"861870300", "新疆乌鲁木齐市",
"86151486", "内蒙古锡林郭勒盟",
"861855445", "山东省济南市",
"861589236", "四川省广安市",
"861808652", "湖北省武汉市",
"861300467", "浙江省金华市",
"861322472", "内蒙古包头市",
"861708313", "河北省唐山市",
"861823075", "贵州省毕节地区",
"861537562", "安徽省铜陵市",
"861760470", "内蒙古呼伦贝尔市",
"861318334", "河南省平顶山市",
"86181132", "四川省凉山彝族自治州",
"861348540", "山西省忻州市",
"86136834", "四川省成都市",
"861390476", "内蒙古赤峰市",
"861598410", "四川省宜宾市",
"861700269", "广东省广州市",
"861805842", "浙江省杭州市",
"86138057", "浙江省杭州市",
"861458663", "湖南省邵阳市",
"861316544", "山东省淄博市",
"861526741", "浙江省金华市",
"861839344", "甘肃省天水市",
"861589449", "云南省普洱市",
"861454366", "山东省威海市",
"86155549", "山东省临沂市",
"861859094", "陕西省安康市",
"861363971", "青海省西宁市",
"861530762", "广东省河源市",
"861590873", "云南省红河哈尼族彝族自治州",
"861827201", "湖北省武汉市",
"861538680", "山西省忻州市",
"861521998", "广东省惠州市",
"861356952", "河南省开封市",
"861882422", "广东省东莞市",
"86130560", "江苏省连云港市",
"861361375", "河南省平顶山市",
"861898851", "广东省佛山市",
"861304575", "浙江省绍兴市",
"861311060", "福建省龙岩市",
"86181972", "青海省海东地区",
"861534550", "安徽省滁州市",
"861537658", "山东省烟台市",
"861306248", "福建省三明市",
"861839557", "安徽省马鞍山市",
"861566030", "新疆阿克苏地区",
"861594724", "内蒙古赤峰市",
"861870350", "山西省忻州市",
"861316357", "黑龙江省绥化市",
"86159819", "河南省郑州市",
"86183575", "浙江省绍兴市",
"861301875", "广东省中山市",
"861573814", "河南省商丘市",
"861358697", "浙江省金华市",
"86137744", "上海市",
"861334084", "四川省资阳市",
"861705633", "贵州省贵阳市",
"86152036", "海南省海口市",
"861860532", "山东省青岛市",
"861302069", "山东省济宁市",
"861350378", "河南省开封市",
"861594970", "山东省济南市",
"86182772", "广西柳州市",
"861860488", "内蒙古呼和浩特市",
"861879862", "贵州省贵阳市",
"861899977", "新疆博尔塔拉蒙古自治州",
"861810776", "广西百色市",
"861383349", "河北省保定市",
"861553343", "河北省廊坊市",
"861351472", "内蒙古包头市",
"861539468", "江苏省盐城市",
"861533093", "辽宁省阜新市",
"86151317", "河北省沧州市",
"861843149", "河北省邢台市",
"861472743", "贵州省黔南布依族苗族自治州",
"861534936", "甘肃省张掖市",
"861853869", "河南省平顶山市",
"861550713", "湖北省荆州市",
"861503198", "河北省保定市",
"86183781", "广西南宁市",
"861804582", "黑龙江省双鸭山市",
"861773429", "河北省石家庄市",
"861857144", "湖北省襄樊市",
"861845018", "福建省莆田市",
"861568828", "湖南省怀化市",
"861312578", "吉林省松原市",
"861596047", "福建省宁德市",
"861867241", "湖北省荆门市",
"861589291", "四川省泸州市",
"861827251", "河南省鹤壁市",
"861898145", "四川省达州市",
"861343158", "广东省珠海市",
"861502850", "河北省张家口市",
"861881899", "广东省深圳市",
"861332875", "福建省厦门市",
"861559740", "青海省海北藏族自治州",
"861348497", "陕西省延安市",
"861454408", "福建省三明市",
"861508941", "广东省河源市",
"86182392", "河南省鹤壁市",
"86158670", "浙江省台州市",
"861450228", "河北省保定市",
"861535130", "四川省乐山市",
"861822431", "四川省内江市",
"861700818", "浙江省台州市",
"861331069", "山东省枣庄市",
"861766638", "广东省中山市",
"86147516", "江苏省南京市",
"861368979", "吉林省吉林市",
"861898036", "四川省眉山市",
"861376964", "云南省文山壮族苗族自治州",
"861890739", "湖南省邵阳市",
"861511859", "广东省佛山市",
"861310792", "福建省福州市",
"861337223", "江苏省徐州市",
"861539356", "甘肃省金昌市",
"861871995", "新疆和田地区",
"861572488", "江苏省南京市",
"861705558", "四川省成都市",
"861760318", "河北省衡水市",
"861365243", "广东省深圳市",
"861533803", "广东省东莞市",
"861572532", "山东省青岛市",
"86150337", "河北省保定市",
"86139649", "山东省济宁市",
"861840789", "江西省萍乡市",
"861477398", "湖南省常德市",
"861518128", "四川省攀枝花市",
"861598378", "四川省南充市",
"861761412", "辽宁省鞍山市",
"861342242", "广东省惠州市",
"861570937", "甘肃省酒泉市",
"861530733", "湖南省株洲市",
"86185783", "广东省佛山市",
"861856024", "山东省济南市",
"861590697", "云南省文山壮族苗族自治州",
"861314961", "黑龙江省哈尔滨市",
"861329592", "福建省厦门市",
"86135019", "上海市",
"861869245", "湖南省郴州市",
"861847589", "广东省湛江市",
"861877883", "广西桂林市",
"86157194", "四川省成都市",
"861846515", "宁夏中卫市",
"861555380", "山东省泰安市",
"86185350", "山西省忻州市",
"861780678", "广东省茂名市",
"861512943", "陕西省渭南市",
"86133489", "四川省成都市",
"86188406", "辽宁省沈阳市",
"861458632", "湖北省襄樊市",
"861320489", "内蒙古兴安盟",
"861810870", "云南省昆明市",
"861376877", "广西玉林市",
"861582666", "湖北省恩施土家族苗族自治州",
"861331274", "云南省大理白族自治州",
"861899589", "湖北省宜昌市",
"861319498", "四川省成都市",
"861379623", "黑龙江省哈尔滨市",
"861360571", "浙江省杭州市",
"861471539", "广东省湛江市",
"861454327", "内蒙古通辽市",
"861705662", "湖南省长沙市",
"86158675", "浙江省宁波市",
"861860563", "安徽省宣城市",
"861454458", "江西省景德镇市",
"861310439", "吉林省白山市",
"86138397", "河南省信阳市",
"861818413", "贵州省安顺市",
"861500549", "山东省临沂市",
"861890492", "辽宁省鞍山市",
"861806778", "浙江省温州市",
"86185988", "湖南省郴州市",
"861350410", "辽宁省铁岭市",
"861335397", "河南省洛阳市",
"861533853", "贵州省安顺市",
"861705508", "江苏省苏州市",
"861355047", "四川省巴中市",
"861323477", "内蒙古鄂尔多斯市",
"861539306", "甘肃省天水市",
"861800065", "河北省石家庄市",
"86181679", "新疆乌鲁木齐市",
"861812481", "广东省佛山市",
"861367771", "广西南宁市",
"86138576", "浙江省台州市",
"861459560", "陕西省渭南市",
"861308134", "辽宁省抚顺市",
"861300426", "浙江省湖州市",
"861364419", "辽宁省辽阳市",
"861572170", "贵州省黔南布依族苗族自治州",
"86157598", "福建省泉州市",
"861306107", "山东省聊城市",
"86185355", "山西省长治市",
"861539583", "浙江省杭州市",
"861880680", "浙江省舟山市",
"861569574", "浙江省宁波市",
"861310246", "河北省廊坊市",
"861535572", "浙江省湖州市",
"861322087", "山东省青岛市",
"86156416", "辽宁省锦州市",
"861555933", "新疆昌吉回族自治州",
"861575904", "福建省龙岩市",
"861879150", "陕西省咸阳市",
"861314771", "吉林省长春市",
"861860425", "辽宁省丹东市",
"86150537", "山东省济宁市",
"861306415", "江西省九江市",
"861560709", "江西省新余市",
"861561605", "湖南省怀化市",
"861550562", "安徽省铜陵市",
"86152916", "陕西省汉中市",
"861811952", "安徽省淮南市",
"861774602", "福建省泉州市",
"861316485", "福建省莆田市",
"861317419", "江苏省连云港市",
"861812522", "广东省中山市",
"86156587", "浙江省温州市",
"86182592", "福建省厦门市",
"861539497", "云南省昆明市",
"861346940", "湖南省益阳市",
"861533130", "重庆市",
"861477326", "湖南省永州市",
"861861770", "河北省沧州市",
"861518196", "四川省泸州市",
"861521874", "广东省深圳市",
"861581992", "广东省江门市",
"86183795", "江西省宜春市",
"861550608", "吉林省松原市",
"861318944", "广东省江门市",
"861882535", "广东省江门市",
"86151716", "湖北省黄冈市",
"861832293", "江西省宜春市",
"861593176", "河北省保定市",
"86152867", "贵州省铜仁地区",
"861472780", "陕西省西安市",
"861476335", "山东省东营市",
"861816472", "云南省红河哈尼族彝族自治州",
"861553380", "河北省衡水市",
"861376920", "云南省大理白族自治州",
"861839934", "新疆喀什地区",
"861593902", "河南省郑州市",
"861859707", "青海省海西蒙古族藏族自治州",
"861813566", "河南省洛阳市",
"861356812", "四川省泸州市",
"861778582", "贵州省贵阳市",
"861865932", "福建省漳州市",
"861309792", "广西贵港市",
"861360066", "浙江省温州市",
"861471719", "甘肃省白银市",
"861470615", "江苏省无锡市",
"861768903", "西藏山南地区",
"861560278", "广东省梅州市",
"861855584", "安徽省马鞍山市",
"861898911", "四川省内江市",
"861532989", "贵州省黔西南布依族苗族自治州",
"861344077", "内蒙古呼和浩特市",
"861508385", "江西省宜春市",
"861323203", "广东省阳江市",
"861361892", "西藏日喀则地区",
"861333397", "河南省信阳市",
"861370705", "江西省宜春市",
"861528046", "福建省泉州市",
"861459524", "云南省玉溪市",
"861898649", "湖北省孝感市",
"861767338", "湖南省娄底市",
"861892330", "广东省中山市",
"861521645", "山东省聊城市",
"861520749", "湖南省长沙市",
"86158146", "广东省深圳市",
"86138597", "福建省泉州市",
"861523319", "河北省邢台市",
"86186258", "河南省安阳市",
"861521967", "广东省云浮市",
"861319426", "辽宁省大连市",
"861811902", "新疆哈密地区",
"861337378", "河南省洛阳市",
"861367961", "四川省乐山市",
"861530513", "江苏省连云港市",
"861707838", "云南省大理白族自治州",
"861584617", "黑龙江省大庆市",
"861309246", "江苏省宿迁市",
"861335456", "黑龙江省黑河市",
"861881217", "河北省沧州市",
"861878616", "贵州省遵义市",
"861452187", "吉林省松原市",
"861472895", "西藏昌都地区",
"861301392", "江苏省宿迁市",
"861327426", "辽宁省锦州市",
"861811176", "四川省遂宁市",
"861568790", "云南省西双版纳傣族自治州",
"861592441", "内蒙古呼和浩特市",
"861345108", "湖北省咸宁市",
"861550658", "山东省烟台市",
"861780863", "贵州省毕节地区",
"861315063", "云南省大理白族自治州",
"861827065", "江西省九江市",
"861398533", "贵州省铜仁地区",
"861897294", "湖北省武汉市",
"861533572", "湖北省宜昌市",
"861450231", "河北省张家口市",
"861552874", "四川省宜宾市",
"861886093", "江苏省苏州市",
"86183411", "辽宁省大连市",
"8618328", "四川省成都市",
"861527549", "山东省临沂市",
"86182169", "贵州省六盘水市",
"861809870", "安徽省宿州市",
"86135632", "山东省枣庄市",
"861336863", "贵州省安顺市",
"861378889", "福建省福州市",
"861348583", "安徽省宿州市",
"861567559", "安徽省黄山市",
"861572712", "湖北省孝感市",
"86152429", "辽宁省葫芦岛市",
"861534346", "山西省晋中市",
"861300498", "福建省龙岩市",
"861870546", "山东省东营市",
"861516053", "福建省漳州市",
"861802847", "广东省惠州市",
"86157398", "新疆巴音郭楞蒙古自治州",
"861392260", "广东省清远市",
"861518131", "四川省自贡市",
"861536466", "山西省晋城市",
"861768953", "西藏山南地区",
"861806968", "浙江省嘉兴市",
"861873625", "河南省洛阳市",
"861309439", "云南省临沧市",
"861869370", "甘肃省酒泉市",
"861803290", "河北省石家庄市",
"861577917", "江西省吉安市",
"861537713", "湖北省黄冈市",
"86138376", "河南省信阳市",
"861564377", "吉林省辽源市",
"861519549", "江苏省徐州市",
"86158883", "浙江省嘉兴市",
"861846224", "山东省潍坊市",
"861848915", "西藏昌都地区",
"861853445", "山西省长治市",
"86137466", "黑龙江省伊春市",
"861332392", "河南省鹤壁市",
"861536427", "湖南省郴州市",
"861369965", "四川省广安市",
"861362429", "辽宁省葫芦岛市",
"861867512", "广东省韶关市",
"861872759", "湖北省荆门市",
"86183370", "河南省商丘市",
"861590552", "安徽省蚌埠市",
"861389598", "黑龙江省齐齐哈尔市",
"861361240", "广东省汕头市",
"86183438", "吉林省松原市",
"861814732", "内蒙古乌海市",
"861362670", "浙江省衢州市",
"861554806", "内蒙古通辽市",
"861317657", "山东省淄博市",
"861530972", "青海省海东地区",
"861886803", "浙江省嘉兴市",
"861568831", "新疆吐鲁番地区",
"861339676", "浙江省台州市",
"861550533", "山东省淄博市",
"861814241", "陕西省西安市",
"861380539", "山东省临沂市",
"861479189", "陕西省商洛市",
"86157778", "广西河池市",
"861561461", "山东省潍坊市",
"861826037", "江苏省徐州市",
"861398658", "湖北省黄石市",
"861388996", "广东省汕头市",
"861366579", "浙江省台州市",
"861863342", "河北省唐山市",
"861570347", "山西省临汾市",
"861532577", "浙江省温州市",
"861327467", "黑龙江省鸡西市",
"861876244", "江苏省苏州市",
"861831847", "广东省肇庆市",
"861325082", "浙江省杭州市",
"861379990", "福建省宁德市",
"861391237", "江苏省无锡市",
"861829061", "新疆阿克苏地区",
"861329073", "福建省福州市",
"861864576", "黑龙江省牡丹江市",
"861840567", "安徽省阜阳市",
"86138796", "江西省吉安市",
"861588144", "四川省达州市",
"861335368", "河南省新乡市",
"86155349", "山西省朔州市",
"861899820", "广东省汕头市",
"86133062", "江苏省苏州市",
"861764059", "辽宁省盘锦市",
"861591527", "广东省茂名市",
"861592957", "陕西省延安市",
"861834547", "黑龙江省佳木斯市",
"861554085", "内蒙古包头市",
"861772280", "广东省深圳市",
"861880643", "山东省淄博市",
"86139024", "广东省深圳市",
"861506541", "山东省济南市",
"861317073", "云南省保山市",
"861508273", "四川省巴中市",
"86133719", "上海市",
"861858286", "四川省成都市",
"861479628", "广西北海市",
"861772971", "河南省濮阳市",
"86159532", "山东省青岛市",
"861572425", "浙江省宁波市",
"861780832", "四川省内江市",
"861530156", "江苏省苏州市",
"861315032", "新疆乌鲁木齐市",
"86184249", "辽宁省沈阳市",
"861303684", "广西梧州市",
"861809776", "新疆乌鲁木齐市",
"861816087", "安徽省滁州市",
"86180752", "安徽省滁州市",
"861810966", "安徽省安庆市",
"861370080", "河南省濮阳市",
"86183375", "河南省平顶山市",
"861505611", "安徽省滁州市",
"861394588", "黑龙江省伊春市",
"861365280", "广东省潮州市",
"861326481", "湖北省黄冈市",
"861316496", "浙江省宁波市",
"861847820", "湖南省娄底市",
"861324775", "江西省宜春市",
"86130360", "海南省海口市",
"861875129", "江苏省淮安市",
"861570554", "安徽省淮南市",
"861317607", "山东省临沂市",
"861379551", "四川省眉山市",
"861511919", "广东省韶关市",
"861597702", "广西钦州市",
"86136671", "湖北省武汉市",
"861893641", "江苏省宿迁市",
"86150736", "湖南省常德市",
"861551930", "贵州省安顺市",
"86189556", "安徽省安庆市",
"861508396", "江西省新余市",
"861899767", "新疆阿克苏地区",
"861889023", "湖南省长沙市",
"861594760", "内蒙古赤峰市",
"861592907", "陕西省延安市",
"86156786", "广西玉林市",
"861504693", "黑龙江省双鸭山市",
"861522506", "河南省郑州市",
"861502910", "陕西省咸阳市",
"861855869", "福建省泉州市",
"861555343", "山东省烟台市",
"861700958", "广东省湛江市",
"861512980", "陕西省西安市",
"86151517", "江苏省苏州市",
"861348468", "陕西省延安市",
"861321042", "山东省临沂市",
"861535093", "辽宁省铁岭市",
"86135939", "湖北省武汉市",
"861818824", "贵州省黔西南布依族苗族自治州",
"861396680", "安徽省阜阳市",
"861361844", "湖南省衡阳市",
"861890531", "山东省济南市",
"861327481", "内蒙古呼和浩特市",
"861572249", "江苏省淮安市",
"861476139", "江苏省苏州市",
"861840581", "浙江省杭州市",
"861882567", "广东省揭阳市",
"861571420", "辽宁省朝阳市",
"861807017", "江西省鹰潭市",
"861301344", "云南省大理白族自治州",
"861319481", "四川省广安市",
"861576068", "四川省达州市",
"861868852", "广东省江门市",
"86181301", "安徽省淮南市",
"86158590", "福建省福州市",
"861336410", "辽宁省铁岭市",
"861364544", "山东省烟台市",
"86180308", "四川省成都市",
"861874279", "新疆伊犁哈萨克自治州",
"861815462", "广西南宁市",
"861329496", "云南省昆明市",
"861340310", "河北省邯郸市",
"86180652", "福建省泉州市",
"861570775", "广西玉林市",
"861571679", "河南省许昌市",
"861514751", "内蒙古鄂尔多斯市",
"861309411", "湖北省襄樊市",
"86130535", "山东省烟台市",
"861389715", "青海省果洛藏族自治州",
"86136051", "江苏省南京市",
"861538380", "河北省邯郸市",
"86150444", "吉林省四平市",
"86156686", "辽宁省大连市",
"86177280", "广东省广州市",
"861700543", "山东省烟台市",
"861500414", "辽宁省本溪市",
"861897242", "湖北省恩施土家族苗族自治州",
"861576754", "广东省深圳市",
"861510484", "内蒙古兴安盟",
"861454666", "广东省深圳市",
"861301507", "内蒙古鄂尔多斯市",
"861337832", "四川省自贡市",
"861839644", "福建省宁德市",
"86135288", "广东省深圳市",
"861310847", "陕西省渭南市",
"861572436", "辽宁省盘锦市",
"861394810", "内蒙古呼和浩特市",
"861880962", "宁夏石嘴山市",
"861855070", "江苏省扬州市",
"86150636", "山东省潍坊市",
"861863450", "山西省忻州市",
"861707372", "河南省安阳市",
"861812498", "广东省中山市",
"861471796", "山西省运城市",
"86136864", "广东省深圳市",
"861351255", "江苏省泰州市",
"861342539", "广东省肇庆市",
"86181162", "上海市",
"86180247", "广东省东莞市",
"861500741", "湖南省湘西土家族苗族自治州",
"861705333", "广东省深圳市",
"86181599", "福建省南平市",
"861362245", "广东省韶关市",
"86159362", "河南省郑州市",
"861331966", "湖南省永州市",
"861528126", "四川省雅安市",
"861520434", "吉林省四平市",
"861350678", "浙江省宁波市",
"861853229", "河北省张家口市",
"861316657", "河北省衡水市",
"86132458", "江苏省南京市",
"861535476", "吉林省松原市",
"861338047", "广东省潮州市",
"861805978", "福建省龙岩市",
"861472672", "四川省泸州市",
"861503311", "河北省石家庄市",
"861572491", "浙江省金华市",
"86136580", "四川省成都市",
"86153324", "陕西省西安市",
"861339882", "云南省德宏傣族景颇族自治州",
"86158595", "福建省泉州市",
"861899781", "新疆昌吉回族自治州",
"861868802", "广东省汕头市",
"861300522", "广东省汕头市",
"861537427", "江西省吉安市",
"861874064", "陕西省西安市",
"861324504", "湖南省常德市",
"861390913", "陕西省渭南市",
"861521935", "广东省阳江市",
"861360779", "广西北海市",
"861361675", "浙江省绍兴市",
"861514701", "内蒙古通辽市",
"861822592", "安徽省宣城市",
"861335873", "辽宁省营口市",
"861883533", "山西省阳泉市",
"8614732", "四川省成都市",
"861324347", "河南省驻马店市",
"861576704", "广东省云浮市",
"861820997", "新疆阿克苏地区",
"861895341", "山东省莱芜市",
"861515667", "安徽省阜阳市",
"861364357", "山西省临汾市",
"861890596", "福建省漳州市",
"861538933", "陕西省宝鸡市",
"861302927", "辽宁省铁岭市",
"861354770", "四川省宜宾市",
"861507541", "河北省石家庄市",
"86133619", "上海市",
"86159101", "山东省临沂市",
"861515945", "福建省南平市",
"861301557", "河南省洛阳市",
"861304857", "贵州省遵义市",
"861705271", "辽宁省大连市",
"861863400", "河北省唐山市",
"861839875", "四川省广元市",
"861771285", "江苏省南京市",
"86132860", "广东省珠海市",
"861333552", "安徽省蚌埠市",
"861309744", "云南省丽江市",
"86138696", "山东省潍坊市",
"861329431", "吉林省长春市",
"861769625", "山西省运城市",
"861508628", "贵州省铜仁地区",
"86151045", "黑龙江省哈尔滨市",
"861803768", "河南省郑州市",
"861819578", "青海省西宁市",
"861320107", "新疆哈密地区",
"861330952", "宁夏石嘴山市",
"86150367", "河南省洛阳市",
"861860491", "辽宁省朝阳市",
"861815433", "湖北省武汉市",
"861843270", "河北省邯郸市",
"861473677", "云南省西双版纳傣族自治州",
"86183690", "山东省菏泽市",
"861876746", "浙江省温州市",
"861707261", "湖北省咸宁市",
"861390572", "浙江省湖州市",
"861775782", "浙江省丽水市",
"861373826", "浙江省嘉兴市",
"861369937", "新疆乌鲁木齐市",
"861365569", "安徽省合肥市",
"861302966", "新疆乌鲁木齐市",
"861858784", "广西柳州市",
"861471890", "西藏拉萨市",
"861872010", "江西省赣州市",
"861355702", "广西柳州市",
"861779773", "河南省郑州市",
"861366961", "广西南宁市",
"861768548", "山东省烟台市",
"861880933", "甘肃省平凉市",
"861509545", "甘肃省金昌市",
"861458332", "江西省上饶市",
"861308253", "江苏省连云港市",
"861537466", "内蒙古赤峰市",
"86137029", "广东省佛山市",
"861505639", "安徽省蚌埠市",
"861576917", "陕西省宝鸡市",
"861473053", "河北省张家口市",
"861589288", "四川省德阳市",
"861303922", "吉林省长春市",
"86136509", "广东省广州市",
"861826065", "江苏省扬州市",
"861590397", "河南省信阳市",
"861399940", "新疆乌鲁木齐市",
"861890585", "浙江省绍兴市",
"861565951", "福建省泉州市",
"861327435", "吉林省通化市",
"861887093", "江西省上饶市",
"861569043", "河北省保定市",
"861587887", "广西玉林市",
"861840535", "山东省烟台市",
"861820778", "广西河池市",
"861321094", "山东省烟台市",
"861526549", "山东省临沂市",
"861371723", "广东省肇庆市",
"861378815", "广西玉林市",
"86135732", "山东省青岛市",
"86158381", "河南省郑州市",
"861337863", "广东省佛山市",
"861566559", "安徽省黄山市",
"861360147", "江苏省泰州市",
"86185875", "广西南宁市",
"861370574", "浙江省宁波市",
"861771231", "江苏省常州市",
"861347940", "江西省抚州市",
"861330902", "四川省德阳市",
"861476326", "山东省青岛市",
"861304097", "湖北省宜昌市",
"86183695", "山东省临沂市",
"861709510", "江苏省无锡市",
"86151616", "江苏省无锡市",
"861329485", "内蒙古通辽市",
"861306489", "江苏省扬州市",
"861881530", "山东省菏泽市",
"861886476", "河南省焦作市",
"861587238", "湖北省武汉市",
"86136113", "北京市",
"861351576", "浙江省台州市",
"861454627", "宁夏吴忠市",
"861705362", "江苏省南京市",
"86189657", "福建省泉州市",
"861388641", "湖北省黄冈市",
"861534988", "安徽省阜阳市",
"861355752", "广西柳州市",
"861561072", "山东省德州市",
"861308203", "河北省邢台市",
"861583322", "河北省保定市",
"861380728", "湖北省十堰市",
"861899735", "青海省西宁市",
"861377920", "新疆石河子市",
"861863394", "河北省石家庄市",
"861503046", "河北省廊坊市",
"86131515", "江苏省南京市",
"861532915", "贵州省黔东南苗族侗族自治州",
"861473003", "河北省张家口市",
"861508319", "河南省周口市",
"861868124", "四川省绵阳市",
"861860436", "吉林省白城市",
"86186479", "内蒙古锡林郭勒盟",
"861829472", "甘肃省陇南市",
"861471785", "山西省晋中市",
"861521981", "广东省韶关市",
"861557848", "广西南宁市",
"861588192", "四川省遂宁市",
"861774075", "西藏昌都地区",
"861880380", "河南省漯河市",
"861889143", "陕西省渭南市",
"861567193", "湖北省十堰市",
"861565901", "福建省龙岩市",
"861786902", "云南省大理白族自治州",
"861803894", "广东省韶关市",
"861452161", "河北省廊坊市",
"861771373", "四川省遂宁市",
"861818152", "四川省乐山市",
"86170823", "重庆市",
"86133912", "上海市",
"861380511", "江苏省盐城市",
"86189242", "广东省广州市",
"861332507", "山东省临沂市",
"861773418", "河北省邢台市",
"861871938", "广东省广州市",
"861538962", "陕西省渭南市",
"861845029", "福建省厦门市",
"861362782", "广西柳州市",
"861326498", "湖北省武汉市",
"861552029", "四川省达州市",
"861810069", "江苏省苏州市",
"861767116", "湖北省襄樊市",
"861380242", "广东省广州市",
"861807778", "广西南宁市",
"861562442", "山东省德州市",
"861773782", "河南省濮阳市",
"861300435", "江苏省镇江市",
"861314987", "辽宁省大连市",
"861501805", "广东省湛江市",
"861362418", "辽宁省阜新市",
"861380731", "湖南省长沙市",
"861363569", "安徽省合肥市",
"861510545", "山东省烟台市",
"86181779", "广西北海市",
"861813433", "河北省保定市",
"861845270", "江苏省南通市",
"86145326", "上海市",
"861872551", "安徽省合肥市",
"861377877", "四川省巴中市",
"861514193", "辽宁省辽阳市",
"861893928", "河南省鹤壁市",
"861871921", "广东省佛山市",
"861515698", "安徽省合肥市",
"861820968", "宁夏银川市",
"861354382", "广东省中山市",
"86182979", "安徽省合肥市",
"861831792", "江西省九江市",
"861355166", "四川省泸州市",
"861334132", "湖南省湘潭市",
"861470315", "河北省唐山市",
"86158581", "浙江省杭州市",
"86180892", "陕西省西安市",
"861345846", "四川省达州市",
"86136309", "吉林省四平市",
"861800578", "浙江省丽水市",
"861452459", "黑龙江省大庆市",
"861771228", "江苏省扬州市",
"861390853", "贵州省安顺市",
"861568297", "甘肃省定西市",
"861569755", "广东省深圳市",
"861708758", "江西省南昌市",
"861589734", "湖南省衡阳市",
"861366771", "广西南宁市",
"861841941", "甘肃省平凉市",
"861816205", "山东省济宁市",
"861867416", "湖北省荆州市",
"861888848", "广西玉林市",
"861857192", "湖北省仙桃市",
"861479941", "新疆阿克苏地区",
"86131310", "河北省邯郸市",
"861882789", "江西省萍乡市",
"861590456", "黑龙江省黑河市",
"861551402", "河南省安阳市",
"86316", "河北省廊坊市",
"86152837", "四川省眉山市",
"861364485", "内蒙古通辽市",
"861554207", "辽宁省铁岭市",
"861394950", "河南省安阳市",
"861550358", "山西省吕梁市",
"861769129", "陕西省铜川市",
"861398466", "贵州省黔西南布依族苗族自治州",
"861550427", "辽宁省盘锦市",
"861524043", "江苏省苏州市",
"861840715", "湖北省咸宁市",
"861573565", "山西省太原市",
"861396643", "安徽省安庆市",
"861301692", "江苏省连云港市",
"861479619", "广西柳州市",
"86139749", "湖南省长沙市",
"861501855", "广东省湛江市",
"861556106", "内蒙古通辽市",
"86138856", "贵州省铜仁地区",
"861538772", "江西省九江市",
"861872990", "陕西省西安市",
"861334570", "浙江省衢州市",
"861337678", "广东省河源市",
"861556972", "甘肃省庆阳市",
"861322061", "山东省泰安市",
"861764530", "黑龙江省牡丹江市",
"861389581", "黑龙江省哈尔滨市",
"861343783", "广东省广州市",
"861576097", "陕西省宝鸡市",
"861838869", "云南省昭通市",
"861876883", "河南省许昌市",
"861868912", "西藏日喀则地区",
"861324937", "广东省中山市",
"861847515", "广东省阳江市",
"861775418", "安徽省淮北市",
"861580584", "浙江省宁波市",
"861527263", "湖北省荆州市",
"861700580", "浙江省舟山市",
"861320415", "辽宁省丹东市",
"86138443", "吉林省延边朝鲜族自治州",
"861316592", "浙江省宁波市",
"861380796", "江西省吉安市",
"861511928", "广东省湛江市",
"861538343", "山西省太原市",
"861896539", "福建省南平市",
"861782042", "广东省湛江市",
"86182139", "云南省昆明市",
"86135662", "浙江省温州市",
"861831246", "广东省深圳市",
"86185683", "河南省洛阳市",
"861857024", "湖南省邵阳市",
"861380050", "内蒙古兴安盟",
"861379759", "湖北省襄樊市",
"861869429", "河北省邢台市",
"86158050", "福建省泉州市",
"861569705", "云南省昆明市",
"861839392", "甘肃省定西市",
"861862647", "江苏省淮安市",
"861898025", "四川省泸州市",
"861453612", "江苏省镇江市",
"86131315", "河北省唐山市",
"861308477", "内蒙古鄂尔多斯市",
"861822657", "安徽省蚌埠市",
"86180508", "福建省泉州市",
"861317428", "湖南省娄底市",
"861511341", "广东省韶关市",
"861339376", "河南省平顶山市",
"861509484", "山东省日照市",
"861309847", "湖北省恩施土家族苗族自治州",
"861813462", "安徽省阜阳市",
"861347983", "江西省景德镇市",
"861568959", "山东省临沂市",
"86183468", "黑龙江省佳木斯市",
"861529282", "新疆和田地区",
"86158390", "河南省商丘市",
"861364431", "吉林省长春市",
"861891945", "甘肃省武威市",
"86153128", "江苏省扬州市",
"861852480", "辽宁省辽阳市",
"86181501", "福建省厦门市",
"86134257", "广东省佛山市",
"861528949", "陕西省咸阳市",
"861362370", "河南省商丘市",
"86182672", "浙江省湖州市",
"861311879", "云南省普洱市",
"861556513", "河南省开封市",
"861505135", "江苏省淮安市",
"861318012", "河北省秦皇岛市",
"861357952", "新疆克拉玛依市",
"861560501", "福建省莆田市",
"86451", "黑龙江省哈尔滨市",
"861890444", "吉林省四平市",
"86150940", "陕西省西安市",
"861879748", "湖南省湘西土家族苗族自治州",
"861560990", "新疆克拉玛依市",
"861329428", "湖北省荆门市",
"861329357", "山西省临汾市",
"861390093", "甘肃省临夏回族自治州",
"861302870", "甘肃省兰州市",
"86178632", "山东省枣庄市",
"861880772", "广西柳州市",
"861576807", "广东省深圳市",
"86137436", "吉林省白城市",
"861811430", "江苏省常州市",
"861532855", "四川省广安市",
"861395156", "江苏省无锡市",
"86159199", "广东省深圳市",
"861880343", "山西省阳泉市",
"861365787", "广西南宁市",
"861458942", "广东省清远市",
"861779932", "新疆乌鲁木齐市",
"861373058", "河北省沧州市",
"861853070", "河南省新乡市",
"861471511", "广东省深圳市",
"861825440", "山东省滨州市",
"861369504", "福建省厦门市",
"861368561", "安徽省淮北市",
"861838584", "贵州省黔东南苗族侗族自治州",
"861350863", "湖北省孝感市",
"86187423", "辽宁省盘锦市",
"861571464", "黑龙江省七台河市",
"861850871", "云南省昆明市",
"861580869", "云南省临沧市",
"86134642", "辽宁省朝阳市",
"861826251", "江苏省南通市",
"861760753", "广东省梅州市",
"861887572", "河北省邢台市",
"861570965", "宁夏中卫市",
"861372100", "安徽省滁州市",
"861335668", "山东省济南市",
"861310411", "辽宁省大连市",
"8618616", "上海市",
"861452617", "江苏省苏州市",
"861808075", "四川省广元市",
"86136958", "浙江省温州市",
"861380785", "广西玉林市",
"86183850", "贵州省遵义市",
"861801676", "福建省宁德市",
"861321707", "江西省赣州市",
"861504276", "辽宁省盘锦市",
"86147617", "江苏省苏州市",
"861889180", "陕西省咸阳市",
"86183681", "浙江省杭州市",
"861570647", "山东省济宁市",
"861567701", "广西南宁市",
"861830060", "河南省焦作市",
"861523328", "河北省衡水市",
"861317307", "山东省临沂市",
"861354960", "湖南省常德市",
"861332934", "黑龙江省双鸭山市",
"861320722", "湖北省宜昌市",
"861536562", "江苏省泰州市",
"861380890", "山东省烟台市",
"86158395", "河南省漯河市",
"861800037", "河北省沧州市",
"861378955", "内蒙古通辽市",
"861310744", "湖南省张家界市",
"861533476", "内蒙古赤峰市",
"861520541", "山东省济南市",
"861339293", "广东省中山市",
"86150945", "黑龙江省鹤岗市",
"86138677", "浙江省温州市",
"861560551", "安徽省合肥市",
"861357902", "新疆巴音郭楞蒙古自治州",
"86131471", "湖北省武汉市",
"861479457", "黑龙江省大兴安岭地区",
"86156722", "湖北省襄樊市",
"86180104", "北京市",
"861576857", "广东省惠州市",
"861855229", "江苏省南通市",
"861313314", "山西省运城市",
"861599197", "陕西省宝鸡市",
"861335552", "安徽省蚌埠市",
"861555643", "安徽省六安市",
"861554148", "辽宁省葫芦岛市",
"86135969", "吉林省松原市",
"861593430", "山西省忻州市",
"861561593", "山东省淄博市",
"861395106", "江苏省宿迁市",
"861329544", "山东省聊城市",
"861865400", "安徽省亳州市",
"861822419", "四川省雅安市",
"861327522", "江苏省常州市",
"861331776", "广西百色市",
"86189897", "浙江省温州市",
"861389535", "宁夏吴忠市",
"861369554", "安徽省淮南市",
"861890528", "江苏省镇江市",
"861821480", "安徽省亳州市",
"861770142", "江苏省泰州市",
"861372150", "贵州省毕节地区",
"861874020", "辽宁省辽阳市",
"861589225", "四川省广元市",
"861330812", "四川省广元市",
"861360969", "广东省东莞市",
"861760703", "江西省上饶市",
"861513667", "河南省南阳市",
"861846977", "云南省大理白族自治州",
"861893341", "广东省中山市",
"861569080", "河南省三门峡市",
"861361747", "湖南省衡阳市",
"861321757", "广东省佛山市",
"86183855", "贵州省黔南布依族苗族自治州",
"861317544", "浙江省金华市",
"861319522", "贵州省遵义市",
"86150766", "河北省廊坊市",
"861709891", "广东省广州市",
"861705357", "浙江省温州市",
"861760517", "江苏省淮安市",
"861586610", "山东省菏泽市",
"861335789", "江苏省常州市",
"861517578", "河北省石家庄市",
"861508566", "贵州省黔东南苗族侗族自治州",
"861819677", "安徽省马鞍山市",
"86189539", "山东省临沂市",
"86177417", "辽宁省营口市",
"861330874", "云南省曲靖市",
"861803315", "广东省肇庆市",
"861360883", "云南省红河哈尼族彝族自治州",
"861458109", "安徽省宣城市",
"861473578", "山西省临汾市",
"861336141", "山东省东营市",
"861813385", "河北省秦皇岛市",
"861800745", "湖南省怀化市",
"861778990", "西藏拉萨市",
"861816823", "江苏省徐州市",
"86150759", "河北省邢台市",
"861355767", "广西玉林市",
"861778501", "贵州省贵阳市",
"861760834", "四川省凉山彝族自治州",
"861780855", "贵州省黔东南苗族侗族自治州",
"861315055", "云南省曲靖市",
"861309140", "黑龙江省大庆市",
"861776811", "江苏省南京市",
"86135956", "贵州省铜仁地区",
"861770959", "宁夏固原市",
"861302177", "山东省泰安市",
"861313743", "河南省许昌市",
"861560486", "黑龙江省大庆市",
"861561663", "湖南省常德市",
"861339025", "辽宁省营口市",
"861821931", "广东省茂名市",
"861580330", "河北省邯郸市",
"861535865", "江苏省淮安市",
"861858310", "四川省宜宾市",
"861354174", "四川省绵阳市",
"861818339", "四川省泸州市",
"861575199", "甘肃省金昌市",
"861888200", "四川省自贡市",
"861310313", "河北省张家口市",
"861803196", "河北省秦皇岛市",
"861314546", "山东省东营市",
"861815941", "福建省莆田市",
"86176378", "河南省郑州市",
"861516065", "福建省龙岩市",
"861364333", "河北省张家口市",
"861768647", "山东省潍坊市",
"861807545", "安徽省淮南市",
"861595345", "山东省济宁市",
"861538957", "陕西省榆林市",
"861533291", "内蒙古呼和浩特市",
"861454444", "江西省抚州市",
"861839466", "甘肃省兰州市",
"861808326", "贵州省黔西南布依族苗族自治州",
"861470797", "江西省赣州市",
"861768965", "福建省莆田市",
"861313372", "江西省抚州市",
"861887288", "湖北省鄂州市",
"861510778", "广西河池市",
"861301533", "山西省晋中市",
"861339349", "山西省朔州市",
"861805128", "江苏省镇江市",
"86138504", "福建省漳州市",
"861582519", "云南省红河哈尼族彝族自治州",
"861501223", "云南省丽江市",
"861772195", "四川省成都市",
"861867043", "湖南省湘西土家族苗族自治州",
"861889887", "广东省肇庆市",
"861320910", "陕西省咸阳市",
"861368636", "山东省潍坊市",
"861336855", "贵州省黔东南苗族侗族自治州",
"861332658", "广东省阳江市",
"861539871", "云南省昆明市",
"861311846", "四川省内江市",
"861803131", "河北省唐山市",
"861504491", "内蒙古鄂尔多斯市",
"861840397", "河南省信阳市",
"861524416", "山东省淄博市",
"861705307", "上海市",
"861315005", "甘肃省甘南藏族自治州",
"861378394", "河南省周口市",
"861454711", "浙江省杭州市",
"861590535", "山东省烟台市",
"861778551", "贵州省黔东南苗族侗族自治州",
"861576150", "贵州省六盘水市",
"861893443", "贵州省安顺市",
"861333526", "山东省潍坊市",
"861805689", "安徽省马鞍山市",
"861355820", "广西防城港市",
"861454528", "广西河池市",
"861323265", "广东省湛江市",
"861330967", "安徽省亳州市",
"861370763", "河南省南阳市",
"861870771", "广西南宁市",
"861770909", "四川省德阳市",
"861855630", "安徽省芜湖市",
"861450190", "山西省运城市",
"86182616", "江苏省苏州市",
"861888250", "四川省成都市",
"861330645", "山东省烟台市",
"861300930", "辽宁省营口市",
"861331749", "湖南省长沙市",
"861596726", "浙江省丽水市",
"861575948", "福建省泉州市",
"861802064", "福建省宁德市",
"861350989", "广东省潮州市",
"861533449", "云南省昭通市",
"861819003", "四川省泸州市",
"861318074", "吉林省长春市",
"861334723", "湖南省株洲市",
"861536934", "河北省张家口市",
"861315886", "四川省绵阳市",
"861568142", "四川省内江市",
"86188474", "内蒙古乌兰察布市",
"86185342", "山西省晋中市",
"861325891", "山东省滨州市",
"861894897", "广东省江门市",
"861332562", "新疆乌鲁木齐市",
"861573686", "河南省开封市",
"861528152", "四川省阿坝藏族羌族自治州",
"861558734", "山东省济宁市",
"861357149", "陕西省西安市",
"861591385", "广东省惠州市",
"861821996", "甘肃省张掖市",
"861869193", "陕西省铜川市",
"861354651", "山西省长治市",
"86158277", "湖北省荆州市",
"86176435", "吉林省通化市",
"861375160", "广东省阳江市",
"861377563", "江苏省常州市",
"861300556", "广东省肇庆市",
"861365316", "河北省廊坊市",
"861338515", "贵州省黔东南苗族侗族自治州",
"861811981", "安徽省滁州市",
"861593270", "河北省沧州市",
"86152301", "河北省石家庄市",
"861561632", "湖南省衡阳市",
"861321972", "四川省乐山市",
"861895480", "山东省枣庄市",
"861518842", "河南省漯河市",
"861370499", "辽宁省辽阳市",
"861336095", "广东省汕尾市",
"861303956", "内蒙古包头市",
"861318818", "辽宁省朝阳市",
"86187673", "浙江省嘉兴市",
"861313261", "广西南宁市",
"861302749", "湖南省长沙市",
"861815407", "安徽省阜阳市",
"861453674", "陕西省渭南市",
"861882668", "广东省湛江市",
"861359859", "河南省信阳市",
"861538299", "广东省肇庆市",
"861361081", "辽宁省沈阳市",
"861804010", "辽宁省大连市",
"86139955", "湖北省武汉市",
"861368388", "河南省驻马店市",
"861390734", "湖南省衡阳市",
"861509017", "河南省洛阳市",
"861321106", "广东省肇庆市",
"861300275", "山东省烟台市",
"861325001", "广东省江门市",
"861379582", "四川省宜宾市",
"861345879", "四川省凉山彝族自治州",
"861375573", "江西省上饶市",
"861786926", "云南省丽江市",
"861378450", "河北省秦皇岛市",
"861868720", "云南省昆明市",
"861563660", "黑龙江省绥化市",
"861311740", "湖南省岳阳市",
"861882502", "广东省中山市",
"861303530", "湖北省荆州市",
"861586023", "福建省漳州市",
"861367300", "河南省驻马店市",
"861821985", "甘肃省武威市",
"861522498", "河南省周口市",
"861598989", "广东省深圳市",
"861880907", "新疆阿克苏地区",
"861597224", "湖北省襄樊市",
"861366442", "吉林省吉林市",
"861304862", "江苏省淮安市",
"861537644", "山东省临沂市",
"861476302", "山东省烟台市",
"861599731", "湖北省襄樊市",
"861325730", "湖南省岳阳市",
"86182422", "辽宁省鞍山市",
"861333567", "安徽省亳州市",
"86182040", "辽宁省沈阳市",
"861364362", "山西省大同市",
"86139388", "河南省洛阳市",
"861772041", "湖北省宜昌市",
"861831758", "河南省新乡市",
"861820484", "内蒙古兴安盟",
"861370732", "湖南省湘潭市",
"861303906", "吉林省白城市",
"861560495", "辽宁省丹东市",
"861831279", "广东省肇庆市",
"861372097", "山西省阳泉市",
"861534679", "甘肃省陇南市",
"861350577", "浙江省温州市",
"861399584", "湖北省鄂州市",
"861317943", "江苏省泰州市",
"861846702", "青海省海北藏族自治州",
"861452738", "湖南省娄底市",
"861316558", "河北省石家庄市",
"861370241", "广东省江门市",
"861857108", "湖北省黄石市",
"861810434", "吉林省四平市",
"86155262", "湖南省郴州市",
"861453845", "四川省巴中市",
"861329943", "广西桂林市",
"86152599", "福建省南平市",
"861839427", "甘肃省定西市",
"861808367", "贵州省毕节地区",
"861321156", "广西玉林市",
"861872486", "云南省玉溪市",
"861534420", "内蒙古呼伦贝尔市",
"861303172", "山东省济南市",
"86181066", "浙江省宁波市",
"8618192", "陕西省西安市",
"861832649", "安徽省六安市",
"861378400", "河北省邯郸市",
"861891440", "江苏省泰州市",
"861598038", "福建省宁德市",
"86176014", "江苏省苏州市",
"861327340", "河北省石家庄市",
"861767904", "江西省抚州市",
"861858180", "四川省达州市",
"86150303", "河北省张家口市",
"861570460", "黑龙江省哈尔滨市",
"861880957", "宁夏银川市",
"861517037", "江西省上饶市",
"86134755", "山东省淄博市",
"861550392", "河南省鹤壁市",
"861808139", "四川省宜宾市",
"861353798", "广东省阳江市",
"861866123", "江苏省常州市",
"861772186", "四川省成都市",
"861367350", "河南省新乡市",
"861310183", "江苏省徐州市",
"861340221", "山东省济南市",
"861836540", "江西省赣州市",
"861338260", "江苏省盐城市",
"861301658", "江苏省淮安市",
"86186044", "吉林省长春市",
"861330018", "上海市",
"861591273", "云南省文山壮族苗族自治州",
"86138427", "辽宁省盘锦市",
"861470978", "青海省西宁市",
"861803185", "河北省石家庄市",
"861319340", "河南省商丘市",
"861355726", "广西百色市",
"861457013", "山东省临沂市",
"861510997", "新疆阿克苏地区",
"861352972", "云南省大理白族自治州",
"861332533", "陕西省渭南市",
"86130628", "上海市",
"861590581", "浙江省杭州市",
"861781741", "广东省茂名市",
"861807484", "广西桂林市",
"861314350", "广东省广州市",
"861343879", "四川省阿坝藏族羌族自治州",
"861873561", "山西省晋城市",
"86482", "内蒙古兴安盟",
"861320800", "浙江省杭州市",
"86187564", "安徽省六安市",
"861390288", "广东省江门市",
"861332713", "内蒙古阿拉善盟",
"861817414", "广西南宁市",
"861576862", "广东省湛江市",
"861596977", "山东省德州市",
"861454585", "甘肃省金昌市",
"861479462", "黑龙江省齐齐哈尔市",
"861580940", "甘肃省天水市",
"861861351", "山西省太原市",
"861590422", "辽宁省阜新市",
"861815273", "湖南省怀化市",
"861511178", "青海省西宁市",
"861813407", "河北省沧州市",
"861818949", "甘肃省酒泉市",
"86151672", "浙江省湖州市",
"861322549", "山东省临沂市",
"861362559", "安徽省六安市",
"86150119", "广东省广州市",
"861894868", "广东省中山市",
"861893480", "广西桂林市",
"861700944", "江苏省徐州市",
"861572505", "山东省日照市",
"861815331", "湖南省长沙市",
"86170710", "北京市",
"861330998", "新疆喀什地区",
"861556122", "内蒙古兴安盟",
"861860393", "河南省濮阳市",
"861364943", "广西桂林市",
"861452721", "湖北省荆州市",
"861863905", "河南省商丘市",
"86139588", "浙江省温州市",
"861899047", "四川省甘孜藏族自治州",
"861575695", "四川省攀枝花市",
"861591457", "广东省佛山市",
"861470004", "福建省福州市",
"861326640", "广东省湛江市",
"861321762", "广东省河源市",
"86184562", "安徽省铜陵市",
"861366650", "浙江省湖州市",
"861513652", "河南省安阳市",
"861370512", "江苏省连云港市",
"861323730", "湖南省岳阳市",
"861339939", "甘肃省陇南市",
"861800893", "西藏山南地区",
"861335567", "安徽省亳州市",
"861319275", "广东省清远市",
"86187885", "云南省昆明市",
"861305530", "福建省莆田市",
"861452518", "山东省潍坊市",
"861453469", "黑龙江省鸡西市",
"861570548", "山东省泰安市",
"861322823", "四川省绵阳市",
"861338781", "辽宁省辽阳市",
"861868764", "云南省迪庆藏族自治州",
"861458605", "湖北省鄂州市",
"861515440", "山东省菏泽市",
"861351823", "四川省乐山市",
"861876258", "江苏省宿迁市",
"861329362", "山西省忻州市",
"861815396", "甘肃省兰州市",
"861871604", "河北省秦皇岛市",
"861309183", "黑龙江省牡丹江市",
"861810541", "山东省济南市",
"86145220", "浙江省杭州市",
"861589130", "陕西省西安市",
"861398644", "湖北省随州市",
"861357967", "新疆哈密地区",
"86133136", "黑龙江省哈尔滨市",
"861360840", "河南省商丘市",
"861868008", "广东省东莞市",
"861357645", "江西省萍乡市",
"861319113", "山西省阳泉市",
"861320850", "贵州省安顺市",
"861813457", "安徽省淮北市",
"86147999", "新疆伊犁哈萨克自治州",
"861452284", "山西省晋中市",
"861328899", "广东省茂名市",
"86180745", "湖南省怀化市",
"861325510", "江苏省无锡市",
"861572555", "山东省聊城市",
"861599511", "江苏省扬州市",
"86186922", "湖南省长沙市",
"861327113", "河南省信阳市",
"861313780", "河南省开封市",
"861584529", "黑龙江省大庆市",
"861509997", "广东省广州市",
"861571925", "陕西省渭南市",
"861566782", "陕西省榆林市",
"861300340", "江苏省南京市",
"861330149", "江苏省常州市",
"861536344", "广东省佛山市",
"861324903", "广东省中山市",
"861897197", "湖北省孝感市",
"861886449", "河南省信阳市",
"861397299", "湖北省随州市",
"861365699", "福建省莆田市",
"86139454", "黑龙江省佳木斯市",
"861863955", "河南省郑州市",
"861815115", "江苏省泰州市",
"861882873", "四川省成都市",
"861351549", "山东省临沂市",
"861778623", "湖北省荆门市",
"86170715", "江苏省南京市",
"861817741", "广西梧州市",
"861501410", "广东省深圳市",
"861890627", "江苏省南通市",
"861528727", "云南省丽江市",
"861502489", "内蒙古巴彦淖尔市",
"86153463", "河南省驻马店市",
"861534464", "黑龙江省七台河市",
"861354849", "四川省广安市",
"86150503", "江苏省苏州市",
"86187651", "山东省潍坊市",
"861869751", "安徽省蚌埠市",
"861809434", "江苏省盐城市",
"861780915", "陕西省安康市",
"86180966", "安徽省合肥市",
"861355798", "广西南宁市",
"86187880", "云南省保山市",
"861829741", "安徽省安庆市",
"861510968", "宁夏银川市",
"861334309", "河北省保定市",
"86136286", "湖北省武汉市",
"86187809", "四川省广元市",
"861327506", "福建省三明市",
"861862424", "辽宁省抚顺市",
"861360292", "广东省清远市",
"861523433", "山西省阳泉市",
"86145948", "陕西省西安市",
"861395122", "江苏省常州市",
"861317980", "新疆乌鲁木齐市",
"86155688", "吉林省长春市",
"861338735", "湖南省郴州市",
"86151979", "湖南省邵阳市",
"861533865", "贵州省黔东南苗族侗族自治州",
"861831613", "广东省阳江市",
"861319506", "宁夏石嘴山市",
"861823626", "河南省信阳市",
"861528766", "云南省普洱市",
"861890666", "浙江省温州市",
"861815385", "湖南省郴州市",
"861880817", "四川省南充市",
"861347445", "陕西省渭南市",
"86189812", "四川省广元市",
"86130236", "浙江省杭州市",
"861313055", "辽宁省营口市",
"861894794", "内蒙古兴安盟",
"861459404", "云南省红河哈尼族彝族自治州",
"861820545", "山东省烟台市",
"861333789", "江苏省常州市",
"86152779", "广西玉林市",
"861576833", "广东省汕头市",
"861841433", "内蒙古乌兰察布市",
"861595981", "福建省三明市",
"861329980", "青海省西宁市",
"86189339", "广东省广州市",
"861880534", "山东省德州市",
"86188975", "广西玉林市",
"861860555", "安徽省马鞍山市",
"861819745", "青海省玉树藏族自治州",
"861808398", "新疆巴音郭楞蒙古自治州",
"861881384", "广东省中山市",
"861531489", "浙江省丽水市",
"861369813", "四川省绵阳市",
"861341184", "广东省佛山市",
"861310140", "福建省福州市",
"861866574", "广东省广州市",
"861376249", "湖南省邵阳市",
"86180223", "广东省广州市",
"86138304", "甘肃省庆阳市",
"861800677", "浙江省温州市",
"861320706", "江西省吉安市",
"861551467", "河南省鹤壁市",
"861327383", "河南省商丘市",
"861571646", "河南省新乡市",
"861788526", "贵州省黔南布依族苗族自治州",
"861512607", "云南省丽江市",
"861585468", "山东省枣庄市",
"861535291", "青海省西宁市",
"86188130", "北京市",
"861309313", "江苏省无锡市",
"861559192", "陕西省汉中市",
"86152059", "福建省莆田市",
"861372068", "陕西省榆林市",
"861569416", "辽宁省锦州市",
"861550644", "山东省聊城市",
"86185121", "上海市",
"861319383", "河南省南阳市",
"861532410", "河北省邯郸市",
"861805196", "江苏省南京市",
"861894219", "湖北省十堰市",
"861321733", "湖南省株洲市",
"861801091", "安徽省滁州市",
"86155461", "黑龙江省哈尔滨市",
"861813941", "新疆巴音郭楞蒙古自治州",
"861472614", "四川省眉山市",
"861317333", "山东省德州市",
"861327556", "安徽省安庆市",
"861367546", "山东省东营市",
"861778010", "四川省泸州市",
"86147692", "云南省文山壮族苗族自治州",
"861573948", "新疆喀什地区",
"861707314", "河北省保定市",
"861334359", "湖北省十堰市",
"861895443", "山东省淄博市",
"861803689", "江苏省无锡市",
"861889784", "广西柳州市",
"861373912", "江苏省连云港市",
"861350021", "广东省阳江市",
"861811345", "四川省遂宁市",
"861325265", "吉林省通化市",
"861840456", "黑龙江省黑河市",
"861814043", "四川省凉山彝族自治州",
"861313005", "辽宁省鞍山市",
"861535236", "甘肃省武威市",
"861311783", "江西省上饶市",
"861856740", "河南省安阳市",
"861337577", "浙江省温州市",
"861319556", "安徽省安庆市",
"861500472", "内蒙古包头市",
"861860505", "福建省宁德市",
"861805131", "江苏省南通市",
"86158296", "陕西省西安市",
"861808635", "湖北省荆州市",
"861308825", "四川省绵阳市",
"861301713", "湖南省株洲市",
"861459454", "陕西省商洛市",
"861373160", "河北省廊坊市",
"861572393", "广西柳州市",
"861564578", "黑龙江省双鸭山市",
"861363316", "河北省廊坊市",
"861550875", "云南省保山市",
"861811029", "安徽省芜湖市",
"861360746", "湖南省永州市",
"861453793", "新疆昌吉回族自治州",
"861358422", "江苏省无锡市",
"861317271", "广东省惠州市",
"861319930", "黑龙江省黑河市",
"861303816", "四川省资阳市",
"861558288", "山西省晋中市",
"861760737", "湖南省益阳市",
"861323891", "辽宁省朝阳市",
"86134115", "广东省珠海市",
"861508071", "湖南省益阳市",
"861867705", "广西南宁市",
"861870961", "宁夏银川市",
"861359919", "福建省宁德市",
"861330777", "广西钦州市",
"861821928", "广东省佛山市",
"861535449", "河北省石家庄市",
"861509259", "山东省威海市",
"861862548", "河南省驻马店市",
"861882697", "广东省东莞市",
"861822558", "安徽省阜阳市",
"861313886", "广东省深圳市",
"861345144", "河北省邯郸市",
"861821859", "广东省湛江市",
"861700634", "山东省日照市",
"861398692", "湖北省武汉市",
"861336577", "安徽省宿州市",
"861857740", "广西梧州市",
"861318829", "辽宁省抚顺市",
"861818639", "湖北省黄石市",
"861773030", "安徽省芜湖市",
"861812340", "四川省巴中市",
"861502722", "湖北省恩施土家族苗族自治州",
"861378932", "湖南省湘潭市",
"861772616", "湖南省衡阳市",
"861580630", "山东省威海市",
"861801349", "江苏省苏州市",
"861505102", "江苏省宿迁市",
"86176858", "山东省青岛市",
"861366546", "山东省东营市",
"86187593", "福建省宁德市",
"86147792", "广东省广州市",
"861586310", "山东省威海市",
"861705657", "湖北省武汉市",
"861787777", "湖南省湘西土家族苗族自治州",
"86189569", "安徽省安庆市",
"86186729", "湖北省武汉市",
"86151392", "河南省鹤壁市",
"861822943", "湖南省邵阳市",
"86155983", "内蒙古包头市",
"861388480", "山东省威海市",
"861318543", "浙江省嘉兴市",
"8613122", "上海市",
"861536392", "广东省茂名市",
"861332358", "宁夏银川市",
"861866705", "浙江省温州市",
"861335535", "山东省烟台市",
"861566429", "河南省洛阳市",
"86189250", "广东省广州市",
"861779905", "新疆和田地区",
"861332427", "辽宁省盘锦市",
"861850540", "山东省菏泽市",
"861708847", "江西省新余市",
"861339649", "山东省滨州市",
"861359985", "福建省莆田市",
"861808626", "湖北省随州市",
"861879097", "河南省濮阳市",
"861567245", "湖北省黄冈市",
"861308836", "四川省攀枝花市",
"861889295", "新疆乌鲁木齐市",
"861566670", "山东省淄博市",
"861313672", "黑龙江省齐齐哈尔市",
"861780577", "浙江省温州市",
"86180016", "上海市",
"861773701", "河南省南阳市",
"861873979", "河南省周口市",
"861478778", "云南省玉溪市",
"861458487", "山东省淄博市",
"861524973", "河南省新乡市",
"861364633", "山东省日照市",
"861377491", "山东省日照市",
"861535225", "甘肃省临夏回族自治州",
"861864823", "内蒙古兴安盟",
"861834995", "四川省自贡市",
"861330345", "山西省长治市",
"86156271", "广东省云浮市",
"861528413", "四川省广元市",
"861815319", "贵州省黔西南布依族苗族自治州",
"861346445", "辽宁省锦州市",
"861368391", "河南省南阳市",
"861350095", "吉林省通化市",
"86134890", "福建省福州市",
"861821809", "广东省中山市",
"86152679", "浙江省金华市",
"861557804", "广西百色市",
"861303059", "江西省抚州市",
"861333715", "内蒙古赤峰市",
"861328816", "广东省惠州市",
"861847127", "湖北省荆州市",
"861339911", "陕西省延安市",
"861308891", "陕西省宝鸡市",
"861860920", "陕西省咸阳市",
"861357935", "新疆阿克苏地区",
"861520870", "云南省昭通市",
"861306910", "吉林省长春市",
"861700992", "浙江省金华市",
"861860774", "广西梧州市",
"861361098", "辽宁省鞍山市",
"861870987", "安徽省亳州市",
"861830783", "广西南宁市",
"861316980", "广东省江门市",
"86155788", "广西南宁市",
"861532832", "四川省泸州市",
"861705607", "广东省东莞市",
"861553534", "山西省阳泉市",
"86177322", "河北省保定市",
"861840697", "云南省保山市",
"861779955", "新疆喀什地区",
"861872438", "黑龙江省绥化市",
"861338726", "湖北省宜昌市",
"86189255", "广东省东莞市",
"861332308", "河北省衡水市",
"861569763", "广东省清远市",
"861770896", "西藏那曲地区",
"861365616", "江苏省无锡市",
"861530914", "陕西省商洛市",
"861590789", "广西北海市",
"861389502", "宁夏石嘴山市",
"861894285", "四川省成都市",
"86183297", "陕西省西安市",
"86137459", "黑龙江省大庆市",
"861527205", "湖北省黄石市",
"861573386", "河北省衡水市",
"861531415", "山东省聊城市",
"861522481", "河南省平顶山市",
"861809749", "青海省海西蒙古族藏族自治州",
"861390865", "湖北省武汉市",
"861452786", "新疆巴音郭楞蒙古自治州",
"8614749", "广东省广州市",
"861823635", "河南省商丘市",
"861326383", "广西桂林市",
"861323825", "辽宁省丹东市",
"861773751", "河南省郑州市",
"861850497", "内蒙古呼和浩特市",
"861846047", "江西省宜春市",
"861874744", "内蒙古通辽市",
"86187071", "湖北省武汉市",
"861324424", "吉林省四平市",
"861477075", "江西省吉安市",
"861316362", "黑龙江省牡丹江市",
"861595018", "江苏省苏州市",
"86180645", "福建省漳州市",
"861563360", "河北省唐山市",
"861300402", "安徽省阜阳市",
"861501832", "广东省珠海市",
"861537507", "安徽省宿州市",
"86187334", "河北省秦皇岛市",
"861877258", "湖北省荆州市",
"86132028", "广东省佛山市",
"861308730", "湖南省岳阳市",
"861593149", "河北省邢台市",
"861572920", "河南省商丘市",
"861571550", "安徽省滁州市",
"861356967", "河南省漯河市",
"861335581", "浙江省杭州市",
"861882368", "广东省河源市",
"861504532", "黑龙江省牡丹江市",
"861839562", "河北省石家庄市",
"861337915", "陕西省安康市",
"861887236", "湖北省荆门市",
"861357270", "陕西省渭南市",
"861309758", "山西省吕梁市",
"861586478", "山东省济南市",
"861533837", "广东省东莞市",
"861359931", "福建省南平市",
"86182156", "四川省成都市",
"861572774", "江西省赣州市",
"861338767", "湖北省孝感市",
"861336989", "新疆喀什地区",
"861378963", "内蒙古赤峰市",
"861833143", "河北省承德市",
"861813631", "江苏省宿迁市",
"861560582", "浙江省湖州市",
"861876027", "福建省三明市",
"861857846", "广东省东莞市",
"861844724", "内蒙古包头市",
"861550934", "甘肃省庆阳市",
"86184819", "四川省达州市",
"861785820", "浙江省衢州市",
"861573395", "河北省承德市",
"861560438", "吉林省松原市",
"861310020", "湖南省岳阳市",
"861570903", "新疆和田地区",
"861530707", "江西省赣州市",
"861844970", "新疆巴音郭楞蒙古自治州",
"861866080", "山东省济南市",
"86187751", "广西柳州市",
"86138312", "河北省保定市",
"861811998", "安徽省阜阳市",
"861308001", "吉林省长春市",
"861847166", "湖北省孝感市",
"861372256", "河北省秦皇岛市",
"861452795", "新疆乌鲁木齐市",
"861301308", "安徽省合肥市",
"861770885", "云南省昆明市",
"861539322", "甘肃省定西市",
"861537344", "河北省石家庄市",
"861569499", "河北省邯郸市",
"861315287", "山西省临汾市",
"861571936", "甘肃省金昌市",
"861816741", "新疆巴音郭楞蒙古自治州",
"861350805", "四川省内江市",
"861551435", "河南省郑州市",
"861529201", "湖南省岳阳市",
"861345192", "江苏省南京市",
"861325888", "吉林省长春市",
"861582528", "云南省昆明市",
"861805119", "江苏省宿迁市",
"861894296", "湖北省咸宁市",
"861813696", "江苏省苏州市",
"861338820", "四川省达州市",
"861576748", "广东省广州市",
"86180640", "湖北省武汉市",
"861870579", "浙江省金华市",
"861859513", "宁夏吴忠市",
"861840873", "云南省红河哈尼族彝族自治州",
"86147372", "广东省广州市",
"861770790", "江西省新余市",
"861808945", "甘肃省天水市",
"861356874", "四川省雅安市",
"861320254", "广东省广州市",
"86136421", "天津市",
"861350141", "广东省汕头市",
"86151772", "广西柳州市",
"861839658", "福建省南平市",
"86181036", "黑龙江省哈尔滨市",
"861537557", "安徽省宿州市",
"861519576", "江苏省南京市",
"861331541", "河北省保定市",
"861823681", "河南省许昌市",
"861315838", "贵州省六盘水市",
"861848410", "贵州省贵阳市",
"861334841", "福建省宁德市",
"861780038", "河北省衡水市",
"861894742", "内蒙古兴安盟",
"861571991", "新疆石河子市",
"861815628", "安徽省铜陵市",
"861571500", "福建省宁德市",
"861369460", "黑龙江省大庆市",
"861826282", "江苏省淮安市",
"861591631", "广东省珠海市",
"861454519", "湖南省永州市",
"861332466", "陕西省商洛市",
"861309708", "江西省上饶市",
"861816414", "湖北省咸宁市",
"861452880", "云南省大理白族自治州",
"86152972", "青海省海东地区",
"86392", "河南省鹤壁市",
"861534379", "河南省洛阳市",
"861570953", "宁夏吴忠市",
"861530757", "广东省佛山市",
"861361858", "贵州省贵阳市",
"861363399", "河南省南阳市",
"861760765", "广东省东莞市",
"861309279", "湖北省黄石市",
"86185256", "辽宁省大连市",
"861336038", "广东省揭阳市",
"861334155", "吉林省松原市",
"861321848", "江苏省南京市",
"861372206", "内蒙古赤峰市",
"861517251", "湖北省武汉市",
"861811149", "四川省广安市",
"861521812", "广东省汕尾市",
"861766078", "山东省东营市",
"86153981", "安徽省阜阳市",
"861774698", "河南省漯河市",
"861319640", "江苏省无锡市",
"861777590", "湖南省岳阳市",
"861586180", "江苏省南京市",
"86150899", "广东省中山市",
"86182317", "河北省沧州市",
"861328710", "山东省莱芜市",
"861559144", "陕西省汉中市",
"861569732", "湖南省湘潭市",
"861528079", "福建省南平市",
"861898676", "湖北省宜昌市",
"861301427", "宁夏银川市",
"861301358", "山东省威海市",
"861520776", "广西百色市",
"861324548", "山东省莱芜市",
"861569241", "广东省广州市",
"861327640", "山东省济南市",
"861887291", "湖北省十堰市",
"861359996", "福建省福州市",
"861367650", "浙江省丽水市",
"861802140", "江苏省南京市",
"861350855", "贵州省黔东南苗族侗族自治州",
"861533288", "内蒙古巴彦淖尔市",
"861364558", "安徽省阜阳市",
"861550692", "福建省厦门市",
"86131023", "重庆市",
"861328530", "山东省菏泽市",
"86147215", "四川省成都市",
"861569512", "江苏省苏州市",
"861842907", "陕西省宝鸡市",
"861369548", "山东省泰安市",
"861595149", "江苏省连云港市",
"861850356", "山西省晋城市",
"861891302", "江苏省南京市",
"861336021", "广东省江门市",
"861505860", "浙江省台州市",
"861333581", "浙江省杭州市",
"861821641", "湖南省长沙市",
"861329558", "安徽省阜阳市",
"861892445", "广东省韶关市",
"86187534", "山东省德州市",
"861459690", "新疆吐鲁番地区",
"861830740", "湖南省怀化市",
"861316943", "河北省保定市",
"861355735", "广西玉林市",
"8613910", "北京市",
"861575116", "江苏省泰州市",
"861317558", "浙江省嘉兴市",
"861530854", "贵州省黔南布依族苗族自治州",
"861306850", "广东省茂名市",
"861368946", "甘肃省平凉市",
"86150801", "福建省莆田市",
"861343192", "广东省珠海市",
"861319402", "福建省南平市",
"86131721", "河北省廊坊市",
"861458305", "江西省新余市",
"861576222", "山东省烟台市",
"861532678", "内蒙古巴彦淖尔市",
"861339851", "贵州省贵阳市",
"861883392", "河北省石家庄市",
"861536875", "云南省保山市",
"861328956", "宁夏吴忠市",
"861899752", "新疆阿勒泰地区",
"861313287", "广西贺州市",
"861813189", "河北省承德市",
"861454739", "浙江省金华市",
"861840668", "广东省湛江市",
"86138270", "广东省江门市",
"86156472", "内蒙古包头市",
"861888122", "四川省攀枝花市",
"86151808", "贵州省贵阳市",
"86130728", "四川省成都市",
"861361067", "山西省临汾市",
"861572964", "四川省内江市",
"861338977", "青海省海西蒙古族藏族自治州",
"861378773", "湖南省衡阳市",
"861805048", "福建省漳州市",
"861878761", "云南省文山壮族苗族自治州",
"86138512", "江苏省连云港市",
"861879704", "青海省海东地区",
"861890408", "辽宁省大连市",
"86134655", "山东省烟台市",
"861310758", "青海省西宁市",
"861894228", "江西省赣州市",
"86184532", "山东省青岛市",
"861366350", "山西省忻州市",
"86132921", "河北省邢台市",
"861768937", "福建省泉州市",
"861860693", "福建省福州市",
"861315821", "贵州省遵义市",
"861837540", "山东省菏泽市",
"861834648", "黑龙江省牡丹江市",
"861835143", "江苏省常州市",
"861531248", "江苏省无锡市",
"86159249", "云南省曲靖市",
"861818135", "四川省成都市",
"861519061", "江苏省泰州市",
"861373044", "河北省保定市",
"86147210", "上海市",
"861554104", "辽宁省朝阳市",
"861524499", "四川省凉山彝族自治州",
"861330935", "甘肃省武威市",
"861300640", "四川省乐山市",
"861802313", "广东省河源市",
"861558236", "山西省临汾市",
"861813628", "江苏省泰州市",
"86187138", "河北省唐山市",
"861310279", "河北省衡水市",
"861329508", "河南省开封市",
"861595998", "福建省泉州市",
"861855940", "福建省宁德市",
"861760975", "青海省果洛藏族自治州",
"861560421", "辽宁省朝阳市",
"86150952", "山东省潍坊市",
"861317662", "山东省东营市",
"861591189", "云南省临沧市",
"861761474", "内蒙古乌兰察布市",
"86155418", "辽宁省葫芦岛市",
"86130923", "江苏省徐州市",
"861337095", "山东省聊城市",
"861582531", "宁夏银川市",
"861520966", "宁夏石嘴山市",
"861871304", "河北省廊坊市",
"86187773", "广西桂林市",
"861826893", "浙江省丽水市",
"861331434", "吉林省四平市",
"861358526", "江苏省宿迁市",
"86133166", "广东省东莞市",
"861590567", "安徽省亳州市",
"861533734", "湖北省襄樊市",
"861328906", "新疆阿勒泰地区",
"861899702", "青海省海东地区",
"861871547", "安徽省池州市",
"861339801", "西藏拉萨市",
"861338864", "浙江省嘉兴市",
"861868881", "广东省东莞市",
"861572877", "广东省梅州市",
"861592962", "陕西省西安市",
"861386666", "安徽省合肥市",
"861308510", "湖北省荆州市",
"861812506", "广东省珠海市",
"861458355", "山东省济南市",
"861850583", "浙江省嘉兴市",
"861340295", "陕西省西安市",
"861319452", "黑龙江省齐齐哈尔市",
"861535288", "内蒙古鄂尔多斯市",
"861500576", "浙江省台州市",
"86183842", "四川省成都市",
"861504712", "内蒙古鄂尔多斯市",
"86180936", "甘肃省张掖市",
"861398507", "贵州省黔南布依族苗族自治州",
"861306800", "山西省太原市",
"861888094", "四川省泸州市",
"861801088", "安徽省合肥市",
"861581269", "广东省潮州市",
"86182517", "江苏省徐州市",
"861568022", "四川省自贡市",
"861304748", "山东省济南市",
"861776839", "江苏省常州市",
"86138275", "广东省肇庆市",
"861305899", "浙江省金华市",
"861318580", "浙江省舟山市",
"861454492", "湖北省恩施土家族苗族自治州",
"861366300", "河南省郑州市",
"861310708", "湖南省郴州市",
"86186986", "辽宁省大连市",
"861327452", "黑龙江省齐齐哈尔市",
"861597767", "广西南宁市",
"861823367", "河北省沧州市",
"861890458", "黑龙江省伊春市",
"861890327", "河北省沧州市",
"861367442", "吉林省吉林市",
"86134881", "陕西省西安市",
"861786935", "云南省临沧市",
"861821919", "广东省汕尾市",
"861536644", "江苏省宿迁市",
"861477302", "湖南省湘潭市",
"861365399", "河南省漯河市",
"861335422", "辽宁省沈阳市",
"861840552", "安徽省蚌埠市",
"861874847", "内蒙古呼伦贝尔市",
"861589476", "新疆昌吉回族自治州",
"861370416", "辽宁省锦州市",
"86151592", "福建省厦门市",
"86189369", "江苏省宿迁市",
"861843952", "河南省新乡市",
"86188888", "北京市",
"861890366", "黑龙江省哈尔滨市",
"86182716", "湖北省黄石市",
"861815685", "安徽省阜阳市",
"861350915", "陕西省安康市",
"86187393", "河南省濮阳市",
"86177141", "江苏省连云港市",
"86130266", "广东省深圳市",
"861837497", "湖南省长沙市",
"861452843", "甘肃省白银市",
"861390449", "吉林省白山市",
"861889861", "广东省深圳市",
"861389873", "辽宁省盘锦市",
"861831313", "云南省玉溪市",
"861774945", "河南省信阳市",
"861351414", "辽宁省本溪市",
"861888804", "江苏省无锡市",
"861700012", "北京市",
"861361918", "陕西省咸阳市",
"861570813", "四川省自贡市",
"861359341", "山西省吕梁市",
"861334609", "浙江省温州市",
"86153995", "安徽省宿州市",
"86181916", "陕西省汉中市",
"861521952", "广东省清远市",
"861775030", "福建省福州市",
"861339091", "江苏省南京市",
"861853983", "河南省焦作市",
"861356149", "山东省聊城市",
"861856247", "山东省临沂市",
"861590526", "江苏省泰州市",
"861775701", "浙江省衢州市",
"861875979", "福建省漳州市",
"861550344", "山西省太原市",
"861319683", "江苏省连云港市",
"861523566", "山西省运城市",
"861533225", "陕西省渭南市",
"861860877", "云南省玉溪市",
"86155431", "吉林省长春市",
"861869509", "湖北省孝感市",
"86188160", "山东省菏泽市",
"861593645", "河南省安阳市",
"86136222", "广东省广州市",
"861337805", "湖南省郴州市",
"861355781", "广西南宁市",
"861338589", "浙江省金华市",
"861346869", "陕西省汉中市",
"86158420", "辽宁省鞍山市",
"861391203", "江苏省徐州市",
"861309613", "四川省南充市",
"861802183", "江苏省徐州市",
"86156253", "广东省中山市",
"861800377", "河南省南阳市",
"861830846", "四川省绵阳市",
"861452529", "山东省泰安市",
"861537934", "甘肃省武威市",
"861557707", "广西玉林市",
"861327683", "浙江省嘉兴市",
"861808698", "四川省广安市",
"861881684", "广东省汕头市",
"861787645", "广东省河源市",
"861390236", "广东省肇庆市",
"861333535", "陕西省渭南市",
"86187111", "湖南省长沙市",
"861347070", "安徽省滁州市",
"861786270", "山东省威海市",
"861565982", "福建省厦门市",
"861577100", "湖北省襄樊市",
"861786981", "云南省昆明市",
"861826677", "山东省济宁市",
"861871490", "安徽省宿州市",
"861553441", "山西省晋中市",
"861842714", "湖北省黄石市",
"861539984", "湖南省永州市",
"861329633", "山东省日照市",
"861785589", "浙江省金华市",
"861599719", "湖北省襄樊市",
"861500205", "广东省深圳市",
"861362701", "江西省鹰潭市",
"861829823", "安徽省马鞍山市",
"861868835", "广东省阳江市",
"861810749", "湖南省长沙市",
"861584518", "黑龙江省佳木斯市",
"861587610", "广东省佛山市",
"861476597", "吉林省长春市",
"861337141", "山东省东营市",
"861317633", "山东省日照市",
"861521902", "广东省韶关市",
"86150659", "山东省临沂市",
"86153990", "陕西省西安市",
"861550557", "安徽省宿州市",
"861579746", "湖北省武汉市",
"861334659", "广东省云浮市",
"861458593", "山东省泰安市",
"86183276", "湖北省孝感市",
"861599294", "广东省东莞市",
"861366494", "广东省江门市",
"861866043", "山东省济南市",
"861582585", "甘肃省平凉市",
"861829549", "宁夏银川市",
"86158425", "辽宁省丹东市",
"861338798", "江西省景德镇市",
"861770828", "广东省中山市",
"861322414", "辽宁省本溪市",
"861833180", "河北省衡水市",
"861337855", "贵州省黔东南苗族侗族自治州",
"861537692", "山东省临沂市",
"86188165", "上海市",
"861512428", "辽宁省盘锦市",
"861362030", "广东省佛山市",
"861351741", "湖南省株洲市",
"861501678", "广东省东莞市",
"861592933", "陕西省渭南市",
"861308265", "山东省临沂市",
"861517065", "江西省吉安市",
"861850468", "黑龙江省鹤岗市",
"861860964", "安徽省六安市",
"861330981", "辽宁省沈阳市",
"861554822", "内蒙古鄂尔多斯市",
"861771190", "西藏拉萨市",
"86181429", "辽宁省葫芦岛市",
"861473065", "河北省石家庄市",
"861817549", "安徽省池州市",
"861506069", "福建省福州市",
"86151169", "北京市",
"861839713", "青海省海东地区",
"861339036", "辽宁省丹东市",
"861572693", "浙江省嘉兴市",
"861828902", "西藏日喀则地区",
"861338259", "江苏省泰州市",
"861838157", "四川省资阳市",
"861886662", "山东省青岛市",
"861809168", "陕西省渭南市",
"861470345", "山西省长治市",
"86158584", "浙江省宁波市",
"861303144", "河北省石家庄市",
"861339071", "江苏省盐城市",
"861503996", "河南省安阳市",
"861570459", "黑龙江省大庆市",
"861345816", "四川省遂宁市",
"861306070", "广东省梅州市",
"861364225", "广东省肇庆市",
"861841911", "甘肃省定西市",
"861316865", "广东省珠海市",
"861550838", "四川省德阳市",
"861479911", "新疆喀什地区",
"861351408", "福建省福州市",
"861888818", "江苏省苏州市",
"861361904", "四川省泸州市",
"861867446", "湖南省长沙市",
"861771532", "江苏省常州市",
"861811894", "江苏省盐城市",
"861505928", "福建省宁德市",
"86132590", "陕西省咸阳市",
"861340556", "江苏省扬州市",
"86135552", "黑龙江省黑河市",
"861500585", "浙江省绍兴市",
"86185635", "山东省聊城市",
"861335065", "四川省南充市",
"861800397", "河南省信阳市",
"861478726", "云南省普洱市",
"861470029", "安徽省宿州市",
"861552196", "广东省河源市",
"86183201", "广东省广州市",
"861347090", "安徽省黄山市",
"861362448", "吉林省松原市",
"861322327", "河北省邢台市",
"861893181", "河北省衡水市",
"861322458", "黑龙江省大庆市",
"861347756", "湖北省荆门市",
"861899545", "宁夏中卫市",
"86158865", "湖南省郴州市",
"861390980", "辽宁省鞍山市",
"861340930", "河南省平顶山市",
"86155523", "山东省菏泽市",
"861521131", "湖南省常德市",
"861310907", "新疆伊犁哈萨克自治州",
"8618500", "北京市",
"861769700", "青海省海北藏族自治州",
"861868942", "广东省广州市",
"861476577", "云南省昆明市",
"86158458", "黑龙江省大庆市",
"861312552", "辽宁省抚顺市",
"861399756", "湖北省荆州市",
"861458573", "山东省济宁市",
"861572057", "安徽省宿州市",
"861890263", "广东省河源市",
"861707562", "安徽省芜湖市",
"861360455", "黑龙江省绥化市",
"86150657", "山东省烟台市",
"861870725", "湖北省黄冈市",
"861380434", "吉林省四平市",
"861538313", "河北省张家口市",
"86133792", "陕西省西安市",
"861351327", "河北省沧州市",
"861831216", "广东省湛江市",
"861782012", "广东省中山市",
"861361954", "宁夏固原市",
"861584504", "黑龙江省哈尔滨市",
"861362524", "江苏省宿迁市",
"861321944", "四川省乐山市",
"861885780", "浙江省丽水市",
"86136594", "甘肃省兰州市",
"86158188", "广东省广州市",
"861453642", "江苏省苏州市",
"861394883", "内蒙古阿拉善盟",
"861876536", "山东省潍坊市",
"861525091", "江苏省徐州市",
"861871470", "黑龙江省哈尔滨市",
"861700762", "广东省中山市",
"861315934", "福建省宁德市",
"861524013", "安徽省宣城市",
"861572673", "西藏山南地区",
"861889340", "甘肃省庆阳市",
"861391306", "江苏省苏州市",
"861350352", "山西省大同市",
"861840745", "湖南省怀化市",
"86151167", "湖南省益阳市",
"86181427", "辽宁省盘锦市",
"861878346", "四川省广元市",
"86150242", "广东省佛山市",
"861771170", "湖南省湘西土家族苗族自治州",
"86152696", "山东省潍坊市",
"861523649", "河南省新乡市",
"861342177", "广东省云浮市",
"86158860", "吉林省四平市",
"861340383", "河南省安阳市",
"861875148", "江苏省扬州市",
"861336483", "新疆塔城地区",
"861366474", "内蒙古呼和浩特市",
"861550287", "四川省资阳市",
"861563659", "黑龙江省七台河市",
"861390333", "河北省秦皇岛市",
"861338778", "广西河池市",
"861507890", "广西北海市",
"861780652", "广东省梅州市",
"861313557", "安徽省宿州市",
"861880313", "河北省张家口市",
"861558333", "四川省达州市",
"86130755", "安徽省合肥市",
"861471541", "广东省肇庆市",
"861304401", "山东省泰安市",
"861334324", "河北省石家庄市",
"861504062", "辽宁省大连市",
"861565105", "江苏省扬州市",
"861500531", "山东省济南市",
"861875257", "江苏省徐州市",
"861375159", "广东省惠州市",
"861886633", "山东省日照市",
"861459429", "云南省怒江傈僳族自治州",
"861386823", "浙江省舟山市",
"861598352", "四川省雅安市",
"861452647", "江苏省泰州市",
"861535662", "浙江省嘉兴市",
"861570617", "江苏省镇江市",
"86183684", "浙江省宁波市",
"86134628", "河南省焦作市",
"861893135", "河北省秦皇岛市",
"861593004", "河北省保定市",
"861582576", "浙江省金华市",
"861881846", "广东省清远市",
"861511311", "广东省汕头市",
"861309817", "陕西省铜川市",
"861333251", "湖南省长沙市",
"861564581", "黑龙江省鸡西市",
"861476038", "福建省南平市",
"861378793", "湖南省湘西土家族苗族自治州",
"861879521", "宁夏银川市",
"861319887", "四川省广元市",
"86159247", "云南省曲靖市",
"861519444", "河南省洛阳市",
"861528919", "西藏拉萨市",
"861705572", "重庆市",
"861860673", "浙江省嘉兴市",
"861351366", "山西省大同市",
"861356797", "浙江省湖州市",
"861360661", "浙江省杭州市",
"861558271", "山西省临汾市",
"861317288", "广东省汕尾市",
"861536895", "云南省德宏傣族景颇族自治州",
"861890414", "辽宁省本溪市",
"861386549", "安徽省宣城市",
"861508088", "湖南省湘西土家族苗族自治州",
"861318042", "河北省唐山市",
"861888269", "四川省广安市",
"861388167", "四川省巴中市",
"861556543", "河南省新乡市",
"861385941", "福建省三明市",
"861529422", "甘肃省兰州市",
"86153142", "山东省青岛市",
"8617791", "陕西省西安市",
"86183060", "重庆市",
"861555613", "安徽省淮北市",
"861821220", "贵州省遵义市",
"86130750", "安徽省阜阳市",
"861313507", "湖南省益阳市",
"861329837", "河南省焦作市",
"861524620", "黑龙江省绥化市",
"861519711", "湖南省岳阳市",
"861364734", "湖南省衡阳市",
"861304451", "河南省郑州市",
"861826873", "浙江省舟山市",
"861815676", "安徽省亳州市",
"861354142", "四川省雅安市",
"861508939", "广东省揭阳市",
"861862459", "辽宁省营口市",
"861535558", "浙江省丽水市",
"861598302", "四川省泸州市",
"861525145", "江苏省徐州市",
"861373461", "青海省西宁市",
"861322366", "山西省晋中市",
"861317837", "福建省漳州市",
"861890741", "湖南省株洲市",
"86130383", "重庆市",
"861524479", "黑龙江省佳木斯市",
"86150876", "云南省西双版纳傣族自治州",
"86180362", "江苏省扬州市",
"861528641", "贵州省铜仁地区",
"861565155", "江苏省盐城市",
"861361717", "湖北省宜昌市",
"861530818", "四川省成都市",
"861769856", "河南省商丘市",
"861890232", "广东省广州市",
"861893311", "广东省揭阳市",
"861707533", "山东省烟台市",
"861760995", "新疆吐鲁番地区",
"861507796", "安徽省淮南市",
"861317514", "浙江省杭州市",
"861327238", "湖南省郴州市",
"861595978", "福建省三明市",
"861870412", "辽宁省鞍山市",
"861336568", "安徽省六安市",
"861390362", "黑龙江省齐齐哈尔市",
"861520728", "湖北省十堰市",
"86156748", "湖南省长沙市",
"861571761", "河北省张家口市",
"861537821", "四川省绵阳市",
"86130070", "山西省太原市",
"861365379", "河南省洛阳市",
"861520511", "江苏省盐城市",
"86186326", "河北省廊坊市",
"861310714", "湖南省张家界市",
"861572897", "西藏阿里地区",
"86131474", "河北省石家庄市",
"861766026", "山东省泰安市",
"86181108", "安徽省宣城市",
"861700733", "湖南省衡阳市",
"861454472", "陕西省榆林市",
"86183065", "山东省临沂市",
"861567404", "湖南省怀化市",
"861770960", "安徽省滁州市",
"86180101", "北京市",
"86182519", "江苏省南京市",
"861313344", "山西省晋中市",
"861559009", "吉林省吉林市",
"861453394", "内蒙古乌兰察布市",
"861470935", "甘肃省武威市",
"861520731", "湖南省长沙市",
"86150441", "吉林省长春市",
"861310534", "山东省德州市",
"861895135", "江苏省徐州市",
"861537838", "四川省南充市",
"861700513", "江苏省南通市",
"86133210", "北京市",
"86189940", "江苏省南京市",
"861856922", "湖南省张家界市",
"861373159", "河北省邢台市",
"861560252", "广东省阳江市",
"86145479", "浙江省宁波市",
"861458124", "安徽省安庆市",
"861382452", "广东省佛山市",
"861586498", "山东省临沂市",
"86151448", "内蒙古乌兰察布市",
"861889506", "宁夏吴忠市",
"861310817", "四川省南充市",
"861394840", "内蒙古呼伦贝尔市",
"861509260", "山东省菏泽市",
"861477095", "江西省宜春市",
"861533508", "江苏省南通市",
"861360387", "河南省周口市",
"861501667", "广东省清远市",
"86159508", "江苏省南通市",
"861850477", "内蒙古鄂尔多斯市",
"861870788", "广西河池市",
"86132775", "湖北省恩施土家族苗族自治州",
"861899484", "江苏省盐城市",
"86147166", "广东省广州市",
"861370320", "河北省邯郸市",
"861315557", "安徽省宿州市",
"861816458", "浙江省金华市",
"86136861", "广东省东莞市",
"861539237", "福建省龙岩市",
"861834230", "辽宁省盘锦市",
"861304337", "吉林省延边朝鲜族自治州",
"861841801", "甘肃省临夏回族自治州",
"861450249", "河北省石家庄市",
"861572219", "贵州省安顺市",
"861479801", "黑龙江省哈尔滨市",
"861889383", "甘肃省甘南藏族自治州",
"861569479", "内蒙古锡林郭勒盟",
"861361814", "四川省阿坝藏族羌族自治州",
"861826668", "山东省枣庄市",
"861361537", "山东省济宁市",
"861352334", "河南省焦作市",
"86132581", "四川省成都市",
"861598075", "福建省厦门市",
"861372303", "河南省南阳市",
"861527531", "山东省济南市",
"861334360", "河南省商丘市",
"861317734", "湖北省黄冈市",
"861518149", "四川省宜宾市",
"86184817", "四川省南充市",
"861301314", "安徽省宣城市",
"861807047", "江西省赣州市",
"861592246", "安徽省宿州市",
"86180199", "安徽省合肥市",
"861327221", "湖南省衡阳市",
"86184745", "湖南省怀化市",
"861874680", "黑龙江省鹤岗市",
"861532626", "辽宁省铁岭市",
"861452775", "广西玉林市",
"861345906", "福建省莆田市",
"861329734", "湖南省衡阳市",
"861336440", "吉林省吉林市",
"861359152", "辽宁省丹东市",
"861335251", "黑龙江省哈尔滨市",
"861337302", "河北省保定市",
"861340340", "山西省太原市",
"861844990", "新疆塔城地区",
"861520000", "河北省石家庄市",
"861877432", "湖南省湘西土家族苗族自治州",
"861879538", "宁夏银川市",
"861324317", "河南省平顶山市",
"861571971", "青海省西宁市",
"861709497", "浙江省台州市",
"861854565", "黑龙江省哈尔滨市",
"861860868", "湖北省咸宁市",
"86183402", "辽宁省朝阳市",
"861534399", "河南省三门峡市",
"861375461", "山东省威海市",
"861889556", "安徽省马鞍山市",
"86180562", "安徽省宿州市",
"861476021", "福建省漳州市",
"861554049", "内蒙古呼伦贝尔市",
"86130583", "广东省湛江市",
"861373109", "河北省石家庄市",
"861308622", "青海省海西蒙古族藏族自治州",
"861321334", "河南省周口市",
"86132770", "湖北省武汉市",
"861800368", "黑龙江省佳木斯市",
"861808832", "云南省昆明市",
"861870599", "福建省南平市",
"861533558", "内蒙古呼和浩特市",
"861840893", "西藏山南地区",
"861770770", "广西防城港市",
"861397183", "湖北省荆门市",
"861319784", "江西省新余市",
"861705803", "上海市",
"861813676", "江苏省苏州市",
"861381345", "江苏省徐州市",
"861309714", "江西省吉安市",
"861379475", "广东省阳江市",
"861576451", "黑龙江省哈尔滨市",
"861520796", "江西省吉安市",
"86152443", "山东省临沂市",
"861898696", "湖北省荆门市",
"861580415", "辽宁省丹东市",
"861315344", "山东省枣庄市",
"86182319", "河北省邢台市",
"861550672", "广西来宾市",
"86186526", "江苏省泰州市",
"861450491", "辽宁省本溪市",
"861801462", "江苏省连云港市",
"86153321", "天津市",
"861320584", "浙江省宁波市",
"861503341", "河北省石家庄市",
"861889930", "新疆哈密地区",
"861887271", "湖北省黄冈市",
"86182832", "四川省内江市",
"861510781", "广西南宁市",
"86187006", "陕西省汉中市",
"861803430", "河北省张家口市",
"861363379", "河南省洛阳市",
"861853489", "山西省吕梁市",
"86150897", "广东省清远市",
"861390943", "甘肃省白银市",
"861337352", "河北省保定市",
"861775173", "江苏省徐州市",
"861500528", "江苏省镇江市",
"861572868", "广东省东莞市",
"861576665", "广东省惠州市",
"861768518", "贵州省六盘水市",
"861383407", "山西省临汾市",
"861536743", "湖南省湘西土家族苗族自治州",
"861576947", "甘肃省酒泉市",
"861336597", "福建省泉州市",
"861505996", "福建省南平市",
"861398672", "湖北省荆州市",
"861569013", "河北省廊坊市",
"861533633", "山东省日照市",
"861323984", "新疆阿克苏地区",
"861777163", "湖北省荆州市",
"861378845", "广西玉林市",
"861859992", "四川省巴中市",
"861892254", "广东省东莞市",
"861842020", "广东省河源市",
"861589428", "云南省玉溪市",
"861700156", "江苏省苏州市",
"86158384", "河南省南阳市",
"86155323", "河北省张家口市",
"861760648", "山东省青岛市",
"861313692", "黑龙江省绥化市",
"861513855", "河南省商丘市",
"861566690", "山东省烟台市",
"861893639", "江苏省淮安市",
"861776084", "安徽省蚌埠市",
"861889275", "四川省内江市",
"861320869", "吉林省辽源市",
"861879077", "河南省安阳市",
"861377471", "福建省三明市",
"861524993", "安徽省宣城市",
"861477855", "广东省梅州市",
"861800456", "黑龙江省黑河市",
"861769916", "新疆巴音郭楞蒙古自治州",
"86185760", "广东省中山市",
"861873999", "河南省开封市",
"861530958", "宁夏银川市",
"861898685", "湖北省恩施土家族苗族自治州",
"861520785", "广西玉林市",
"861824289", "辽宁省阜新市",
"861872040", "江西省新余市",
"861832462", "黑龙江省伊春市",
"861399162", "陕西省汉中市",
"861333065", "四川省宜宾市",
"861479036", "安徽省合肥市",
"86159892", "广东省广州市",
"86135608", "广东省东莞市",
"861348825", "陕西省延安市",
"861590578", "浙江省丽水市",
"861477086", "江西省九江市",
"86185946", "福建省福州市",
"861357842", "云南省临沧市",
"861859634", "山东省莱芜市",
"861532667", "黑龙江省大庆市",
"86976", "青海省玉树藏族自治州",
"861311114", "山西省晋城市",
"861840677", "广西南宁市",
"861508349", "河南省信阳市",
"861864666", "黑龙江省大庆市",
"861502630", "新疆喀什地区",
"86189228", "广东省深圳市",
"861532945", "贵州省黔东南苗族侗族自治州",
"861580722", "湖北省武汉市",
"861561266", "河北省承德市",
"861860794", "江西省抚州市",
"861700972", "浙江省嘉兴市",
"861868363", "四川省德阳市",
"861309957", "宁夏银川市",
"861368371", "河南省郑州市",
"86130110", "北京市",
"861551610", "河南省濮阳市",
"861453450", "安徽省合肥市",
"861356768", "浙江省舟山市",
"861380541", "山东省济南市",
"861479091", "安徽省合肥市",
"861510735", "湖南省郴州市",
"861773448", "河北省沧州市",
"86152677", "浙江省温州市",
"861332314", "河北省承德市",
"861306229", "福建省莆田市",
"861852413", "辽宁省抚顺市",
"861867594", "广东省广州市",
"861811797", "四川省泸州市",
"86137457", "黑龙江省黑河市",
"86185765", "广东省佛山市",
"861530908", "四川省泸州市",
"861314369", "广东省广州市",
"861378101", "河南省三门峡市",
"861771712", "河北省保定市",
"861800406", "辽宁省锦州市",
"861356054", "广东省湛江市",
"861525649", "安徽省阜阳市",
"861477805", "广东省云浮市",
"861597259", "湖北省十堰市",
"861804226", "浙江省衢州市",
"861709540", "江苏省徐州市",
"861478589", "贵州省黔南布依族苗族自治州",
"86188216", "陕西省西安市",
"861555758", "浙江省温州市",
"861334982", "湖北省黄石市",
"861814446", "广东省江门市",
"861770876", "云南省文山壮族苗族自治州",
"86134236", "广东省广州市",
"861362560", "安徽省池州市",
"861339566", "安徽省池州市",
"861313934", "甘肃省庆阳市",
"861506539", "山东省临沂市",
"861801433", "江苏省常州市",
"861550821", "四川省达州市",
"861556580", "河南省鹤壁市",
"861707427", "浙江省宁波市",
"861804235", "浙江省湖州市",
"861550780", "广西南宁市",
"861508036", "福建省莆田市",
"861374890", "黑龙江省牡丹江市",
"861501635", "广东省阳江市",
"861500739", "湖南省邵阳市",
"861375072", "浙江省舟山市",
"861312368", "贵州省六盘水市",
"861894920", "安徽省巢湖市",
"861539265", "山西省大同市",
"861779034", "四川省绵阳市",
"861599927", "新疆伊犁哈萨克自治州",
"861476086", "江苏省南通市",
"861768795", "江西省宜春市",
"861470967", "宁夏银川市",
"86187807", "四川省南充市",
"861356842", "四川省绵阳市",
"861535333", "陕西省宝鸡市",
"86135903", "广东省深圳市",
"861556818", "吉林省辽源市",
"861459418", "云南省迪庆藏族自治州",
"86151977", "湖南省益阳市",
"861898941", "浙江省金华市",
"861471749", "江西省赣州市",
"861470645", "山东省烟台市",
"861528928", "陕西省西安市",
"861516535", "山东省烟台市",
"861572296", "江苏省扬州市",
"86177705", "江西省宜春市",
"861350568", "安徽省阜阳市",
"861535271", "新疆伊犁哈萨克自治州",
"861306445", "河南省平顶山市",
"86130890", "黑龙江省大庆市",
"861801071", "安徽省安庆市",
"86158835", "四川省广元市",
"861807127", "湖北省荆州市",
"861510726", "湖北省荆门市",
"861586522", "山东省滨州市",
"861355997", "福建省龙岩市",
"861304365", "江苏省无锡市",
"861808378", "江苏省扬州市",
"861346910", "湖南省衡阳市",
"861322627", "广东省茂名市",
"86181312", "河北省保定市",
"861583082", "河北省沧州市",
"86185665", "广东省东莞市",
"861478515", "贵州省黔东南苗族侗族自治州",
"861361565", "安徽省合肥市",
"861369459", "黑龙江省大庆市",
"861879729", "青海省海西蒙古族藏族自治州",
"86157513", "江苏省淮安市",
"861708933", "广东省湛江市",
"861800697", "福建省龙岩市",
"861579405", "广东省深圳市",
"861770682", "浙江省湖州市",
"861572231", "青海省西宁市",
"861470874", "云南省曲靖市",
"861890549", "山东省临沂市",
"861337597", "福建省三明市",
"86183414", "辽宁省本溪市",
"861875856", "浙江省杭州市",
"861475789", "浙江省金华市",
"861776163", "河南省鹤壁市",
"861882053", "广东省肇庆市",
"861836203", "江苏省镇江市",
"861454576", "四川省资阳市",
"861769207", "河北省衡水市",
"861333578", "浙江省绍兴市",
"861534316", "河北省廊坊市",
"861885838", "浙江省舟山市",
"861572742", "湖南省邵阳市",
"861526585", "山东省聊城市",
"861565723", "浙江省丽水市",
"861348836", "陕西省宝鸡市",
"861559530", "宁夏银川市",
"861530829", "四川省巴中市",
"86186627", "江苏省宿迁市",
"86157109", "河北省秦皇岛市",
"861558558", "吉林省延边朝鲜族自治州",
"86185084", "湖南省长沙市",
"861537743", "湖南省湘西土家族苗族自治州",
"861577947", "江西省景德镇市",
"861535980", "福建省莆田市",
"861768880", "广东省佛山市",
"86188023", "重庆市",
"86155821", "山西省晋中市",
"861537372", "河北省衡水市",
"861323871", "云南省昆明市",
"861390633", "山东省日照市",
"861508091", "湖南省邵阳市",
"86177700", "江西省九江市",
"861317291", "广东省清远市",
"861532681", "内蒙古兴安盟",
"861890823", "四川省成都市",
"86158830", "四川省泸州市",
"861340683", "山东省济宁市",
"86135708", "广东省深圳市",
"861882677", "广东省汕头市",
"861373305", "安徽省黄山市",
"861330797", "江西省赣州市",
"861370993", "新疆伊犁哈萨克自治州",
"861584647", "黑龙江省牡丹江市",
"861567690", "广西来宾市",
"861855248", "江苏省徐州市",
"861530543", "山东省滨州市",
"861572373", "广西桂林市",
"86836", "四川省甘孜藏族自治州",
"861708380", "河南省新乡市",
"861878646", "贵州省毕节地区",
"861501398", "广东省惠州市",
"861472658", "四川省德阳市",
"861377033", "江苏省南京市",
"861319286", "广东省韶关市",
"861571569", "安徽省合肥市",
"86185660", "广东省佛山市",
"861843615", "河南省新乡市",
"861452347", "河南省焦作市",
"86132670", "广东省深圳市",
"861771249", "江苏省苏州市",
"861831817", "广东省阳江市",
"861815293", "新疆克拉玛依市",
"861570317", "河北省沧州市",
"861533943", "甘肃省白银市",
"861525088", "江苏省淮安市",
"861860742", "湖南省常德市",
"86150117", "广东省广州市",
"861820752", "广东省惠州市",
"861569364", "甘肃省张掖市",
"861817408", "江西省赣州市",
"861858426", "四川省广元市",
"861576637", "广东省梅州市",
"861326784", "河北省石家庄市",
"861516581", "山东省聊城市",
"861334624", "山东省威海市",
"861855157", "江苏省苏州市",
"861780352", "山西省大同市",
"861888829", "山东省济南市",
"861880613", "江苏省苏州市",
"861558633", "湖北省武汉市",
"861508801", "广东省佛山市",
"861829408", "甘肃省庆阳市",
"861871136", "湖南省株洲市",
"861388639", "湖北省孝感市",
"861596997", "山东省济宁市",
"86139021", "天津市",
"861459370", "贵州省铜仁地区",
"861853415", "山西省临汾市",
"861875700", "浙江省衢州市",
"861300861", "云南省红河哈尼族彝族自治州",
"861550886", "云南省怒江傈僳族自治州",
"861800873", "云南省红河哈尼族彝族自治州",
"861374796", "河南省信阳市",
"86183030", "河北省邯郸市",
"861390558", "安徽省阜阳市",
"861303060", "安徽省淮北市",
"861869524", "宁夏石嘴山市",
"86157180", "四川省成都市",
"861776570", "广东省珠海市",
"861369617", "四川省广安市",
"861532398", "广东省珠海市",
"861336352", "山西省大同市",
"861470018", "江苏省徐州市",
"86153823", "浙江省杭州市",
"861340452", "吉林省通化市",
"861318757", "云南省德宏傣族景颇族自治州",
"861312406", "福建省莆田市",
"861577451", "黑龙江省哈尔滨市",
"861860373", "河南省新乡市",
"861351666", "广东省惠州市",
"861830384", "河南省安阳市",
"861358065", "广东省云浮市",
"861330978", "青海省西宁市",
"861350483", "黑龙江省牡丹江市",
"8618822", "天津市",
"861452504", "山东省济南市",
"86189666", "陕西省西安市",
"861760938", "甘肃省天水市",
"861871618", "四川省宜宾市",
"861511949", "广东省阳江市",
"861328879", "河北省邯郸市",
"861374731", "内蒙古乌海市",
"86132675", "广东省东莞市",
"86180819", "四川省成都市",
"861868014", "广东省揭阳市",
"861820702", "江西省宜春市",
"861314165", "江苏省南京市",
"861598602", "广东省河源市",
"861510767", "广东省云浮市",
"861807166", "江苏省连云港市",
"861855107", "江苏省常州市",
"861536838", "云南省曲靖市",
"861502940", "陕西省榆林市",
"861532635", "吉林省通化市",
"861561058", "山东省潍坊市",
"861857922", "江西省九江市",
"861598568", "贵州省六盘水市",
"86152397", "河南省焦作市",
"86136363", "上海市",
"861869448", "陕西省安康市",
"86186382", "河南省郑州市",
"861859944", "新疆乌鲁木齐市",
"86133901", "辽宁省沈阳市",
"861508851", "浙江省绍兴市",
"861776132", "四川省凉山彝族自治州",
"861363464", "黑龙江省双鸭山市",
"861390508", "福建省泉州市",
"861517567", "河北省廊坊市",
"861512853", "河北省秦皇岛市",
"861454205", "河南省新乡市",
"861806047", "福建省福州市",
"861819668", "安徽省阜阳市",
"86150356", "山西省晋中市",
"861450425", "辽宁省丹东市",
"861365420", "辽宁省大连市",
"861875750", "浙江省绍兴市",
"861313644", "浙江省舟山市",
"861340402", "四川省广元市",
"861895126", "江苏省淮安市",
"861821860", "广东省茂名市",
"861508145", "河北省唐山市",
"861355778", "广西河池市",
"861505641", "安徽省六安市",
"86152576", "浙江省台州市",
"861819502", "宁夏石嘴山市",
"861302168", "山东省青岛市",
"861572285", "江苏省徐州市",
"861898457", "贵州省贵阳市",
"861390662", "浙江省宁波市",
"861348730", "湖南省岳阳市",
"861556074", "内蒙古呼和浩特市",
"861892706", "广东省揭阳市",
"861365679", "浙江省台州市",
"861397279", "湖北省黄石市",
"861897177", "湖北省黄石市",
"861312456", "黑龙江省黑河市",
"86170849", "广东省佛山市",
"861538020", "江苏省镇江市",
"861827668", "广西河池市",
"861770453", "黑龙江省牡丹江市",
"861893198", "河北省石家庄市",
"861332063", "四川省遂宁市",
"861594582", "黑龙江省鹤岗市",
"861832071", "广东省广州市",
"861526531", "山东省济南市",
"861452554", "山东省枣庄市",
"861875096", "福建省南平市",
"861816627", "湖南省永州市",
"86138916", "陕西省汉中市",
"861869560", "福建省福州市",
"861562791", "广东省汕尾市",
"861815882", "安徽省阜阳市",
"861598440", "四川省绵阳市",
"861319861", "四川省攀枝花市",
"861768529", "贵州省黔西南布依族苗族自治州",
"861360687", "浙江省温州市",
"861316514", "山东省济南市",
"861345899", "四川省德阳市",
"861336075", "广东省茂名市",
"861370479", "内蒙古兴安盟",
"861539051", "甘肃省武威市",
"861523088", "河北省承德市",
"861321992", "四川省广元市",
"86130650", "山东省济南市",
"861839314", "甘肃省陇南市",
"861766035", "山东省东营市",
"861533362", "山西省大同市",
"861800552", "安徽省蚌埠市",
"861327861", "云南省保山市",
"861813293", "河北省邢台市",
"861895949", "福建省龙岩市",
"861780075", "青海省果洛藏族自治州",
"861315875", "四川省广元市",
"861340640", "山东省济南市",
"861311684", "浙江省衢州市",
"861337602", "江苏省泰州市",
"861801527", "江苏省常州市",
"861301614", "湖南省益阳市",
"861896541", "福建省福州市",
"861566404", "河南省郑州市",
"861824448", "四川省广元市",
"861512130", "贵州省安顺市",
"86177263", "四川省南充市",
"861510864", "云南省德宏傣族景颇族自治州",
"861337568", "山东省临沂市",
"86131160", "天津市",
"861836082", "江苏省常州市",
"861352634", "河南省商丘市",
"861787842", "广西梧州市",
"861522478", "河南省商丘市",
"861334660", "河南省商丘市",
"86139928", "陕西省西安市",
"861804827", "内蒙古鄂尔多斯市",
"86156648", "陕西省西安市",
"861304637", "广东省珠海市",
"861708343", "山西省大同市",
"861855415", "山东省潍坊市",
"861509820", "山东省菏泽市",
"861530580", "浙江省舟山市",
"861553313", "河北省张家口市",
"861303192", "河北省邢台市",
"861773289", "河北省承德市",
"86186582", "浙江省宁波市",
"861814542", "黑龙江省伊春市",
"86139723", "湖北省荆州市",
"86152597", "福建省泉州市",
"861453932", "广东省佛山市",
"861887633", "福建省漳州市",
"861355968", "福建省漳州市",
"861557829", "广西南宁市",
"861821824", "广东省湛江市",
"861800668", "浙江省温州市",
"86178352", "山西省大同市",
"861472713", "浙江省杭州市",
"861571787", "湖北省黄冈市",
"861339462", "黑龙江省齐齐哈尔市",
"861308322", "安徽省黄山市",
"861380749", "湖南省长沙市",
"86183784", "广西梧州市",
"861318854", "辽宁省葫芦岛市",
"861550743", "湖南省湘西土家族苗族自治州",
"86134728", "上海市",
"861857114", "湖北省孝感市",
"861534699", "甘肃省白银市",
"861459245", "四川省攀枝花市",
"861831299", "浙江省宁波市",
"86130655", "浙江省绍兴市",
"861590251", "贵州省贵阳市",
"861560475", "内蒙古通辽市",
"861372077", "陕西省西安市",
"86180532", "山东省青岛市",
"861760921", "陕西省延安市",
"861800502", "福建省厦门市",
"861867211", "湖北省荆州市",
"861368822", "四川省南充市",
"861868632", "吉林省吉林市",
"861347204", "河北省石家庄市",
"861510977", "青海省海西蒙古族藏族自治州",
"861337652", "广东省揭阳市",
"861894693", "广东省汕尾市",
"861509767", "河北省邯郸市",
"861470998", "新疆乌鲁木齐市",
"86138429", "辽宁省葫芦岛市",
"861591293", "云南省楚雄彝族自治州",
"861577169", "陕西省宝鸡市",
"861526444", "山东省潍坊市",
"861834737", "内蒙古通辽市",
"861306218", "福建省宁德市",
"861586435", "山东省聊城市",
"861363679", "陕西省榆林市",
"861556958", "新疆喀什地区",
"861352992", "云南省大理白族自治州",
"86189736", "湖南省常德市",
"861373487", "内蒙古鄂尔多斯市",
"861372653", "广东省汕头市",
"86131165", "浙江省台州市",
"861475567", "安徽省阜阳市",
"861550372", "河南省安阳市",
"86132883", "广东省佛山市",
"861573844", "河南省新乡市",
"861841939", "甘肃省天水市",
"86152376", "河南省信阳市",
"861807702", "广西南宁市",
"861503641", "河南省周口市",
"86182862", "贵州省遵义市",
"86185498", "江苏省苏州市",
"861379202", "山东省日照市",
"861315644", "山东省济南市",
"861312397", "浙江省温州市",
"86133008", "上海市",
"86150556", "安徽省安庆市",
"861761442", "吉林省吉林市",
"86135872", "浙江省湖州市",
"861575179", "江苏省常州市",
"861886943", "云南省昭通市",
"861324409", "吉林省四平市",
"861893167", "河北省廊坊市",
"861533333", "河北省秦皇岛市",
"861320229", "广东省深圳市",
"861823678", "河南省郑州市",
"861330894", "西藏林芝地区",
"86189537", "山东省济宁市",
"86177419", "辽宁省辽阳市",
"861373072", "四川省资阳市",
"861512913", "陕西省渭南市",
"861520539", "山东省临沂市",
"861502983", "陕西省渭南市",
"861509726", "甘肃省天水市",
"86150757", "河北省沧州市",
"86152796", "江西省吉安市",
"861786894", "云南省昭通市",
"861370013", "辽宁省抚顺市",
"861870736", "湖南省常德市",
"861589073", "河南省驻马店市",
"861772175", "江苏省徐州市",
"861885821", "浙江省宁波市",
"861357978", "新疆塔城地区",
"86157313", "河北省张家口市",
"861367474", "内蒙古呼和浩特市",
"861518981", "江苏省南京市",
"861328144", "四川省乐山市",
"861536672", "江苏省泰州市",
"861508911", "广东省汕头市",
"861844709", "内蒙古通辽市",
"861766081", "山东省德州市",
"861880758", "广东省肇庆市",
"86181512", "江苏省常州市",
"861763521", "山西省大同市",
"861585082", "江苏省苏州市",
"861700848", "浙江省杭州市",
"861894964", "安徽省马鞍山市",
"861318122", "山东省临沂市",
"86139245", "广东省佛山市",
"86183915", "陕西省安康市",
"861831907", "广东省广州市",
"86151996", "新疆昌吉回族自治州",
"861821152", "广东省珠海市",
"86185730", "湖南省岳阳市",
"86181270", "广东省深圳市",
"861450532", "辽宁省营口市",
"861510798", "江西省景德镇市",
"861760348", "山西省吕梁市",
"861313392", "江西省九江市",
"861470777", "广西钦州市",
"861450488", "辽宁省抚顺市",
"861533271", "内蒙古呼和浩特市",
"861889402", "甘肃省兰州市",
"861870791", "江西省南昌市",
"861562830", "内蒙古呼和浩特市",
"861866446", "广东省汕头市",
"861804866", "四川省南充市",
"861539836", "云南省昭通市",
"861528931", "陕西省咸阳市",
"861364449", "吉林省白山市",
"861324459", "黑龙江省大庆市",
"861882745", "湖北省荆州市",
"861551310", "山西省长治市",
"861504471", "内蒙古包头市",
"861584775", "内蒙古呼和浩特市",
"861840377", "河南省南阳市",
"861329865", "湖南省长沙市",
"861300286", "四川省泸州市",
"861335578", "浙江省杭州市",
"861550261", "辽宁省沈阳市",
"861532367", "广东省汕头市",
"861339433", "吉林省延边朝鲜族自治州",
"861378374", "河南省许昌市",
"861518270", "四川省攀枝花市",
"861366369", "山西省朔州市",
"861364236", "广东省深圳市",
"861839184", "陕西省咸阳市",
"861821976", "甘肃省白银市",
"861803952", "河南省周口市",
"861593290", "江西省上饶市",
"861519492", "河北省邢台市",
"861880708", "江西省南昌市",
"861877900", "江西省新余市",
"861596968", "山东省济南市",
"861358201", "河北省石家庄市",
"861866239", "江苏省扬州市",
"861459782", "新疆喀什地区",
"861818443", "贵州省毕节地区",
"86181275", "广东省江门市",
"86185735", "湖南省郴州市",
"861871753", "陕西省延安市",
"861831957", "广东省广州市",
"861361423", "辽宁省抚顺市",
"86139240", "广东省广州市",
"86183910", "陕西省咸阳市",
"861318094", "吉林省长春市",
"86136818", "上海市",
"861889452", "甘肃省临夏回族自治州",
"861332614", "浙江省杭州市",
"861510589", "浙江省金华市",
"861599870", "山东省聊城市",
"861771382", "四川省南充市",
"861806766", "浙江省绍兴市",
"861569590", "福建省福州市",
"861569901", "新疆塔城地区",
"861555247", "山东省临沂市",
"861362773", "广西桂林市",
"861390356", "山西省晋城市",
"861884648", "黑龙江省大庆市",
"861351302", "河北省沧州市",
"861568964", "山东省日照市",
"861862761", "湖南省娄底市",
"861885143", "江苏省扬州市",
"861332784", "江苏省宿迁市",
"86180265", "广东省惠州市",
"861304769", "江苏省宿迁市",
"861853042", "河南省安阳市",
"861389851", "辽宁省丹东市",
"86130493", "广东省深圳市",
"861311907", "新疆巴音郭楞蒙古自治州",
"861805274", "江苏省常州市",
"861341930", "四川省广安市",
"861302842", "陕西省西安市",
"861512888", "河北省邯郸市",
"861389145", "陕西省渭南市",
"861700850", "贵州省贵阳市",
"86136098", "辽宁省沈阳市",
"861344856", "山东省德州市",
"861452175", "吉林省通化市",
"861329134", "江苏省常州市",
"861359752", "湖北省襄樊市",
"861507689", "河北省承德市",
"86184877", "云南省普洱市",
"861580854", "贵州省黔南布依族苗族自治州",
"861554538", "黑龙江省鹤岗市",
"861571459", "黑龙江省大庆市",
"861768399", "湖北省荆州市",
"861808205", "江苏省连云港市",
"861322352", "山西省大同市",
"861529619", "广西玉林市",
"861350408", "辽宁省大连市",
"861399733", "青海省西宁市",
"861317134", "内蒙古巴彦淖尔市",
"861760350", "山西省忻州市",
"861705510", "北京市",
"861840911", "陕西省延安市",
"861354228", "广东省韶关市",
"861362342", "山西省大同市",
"861474043", "辽宁省沈阳市",
"861339697", "浙江省温州市",
"861500335", "河北省秦皇岛市",
"861770488", "内蒙古呼和浩特市",
"861774061", "湖北省荆门市",
"861770532", "山东省青岛市",
"861810894", "西藏林芝地区",
"861309114", "河北省沧州市",
"861347733", "湖北省随州市",
"861847016", "江西省上饶市",
"861586644", "山东省临沂市",
"861538846", "四川省德阳市",
"861479745", "山西省运城市",
"861529941", "新疆阿勒泰地区",
"861319184", "河北省石家庄市",
"861395940", "福建省宁德市",
"86180260", "广东省揭阳市",
"86136909", "广东省河源市",
"861840649", "山西省运城市",
"86151067", "山东省济宁市",
"861390306", "广东省广州市",
"861351352", "山西省大同市",
"86132710", "河南省商丘市",
"861569951", "吉林省吉林市",
"861526635", "山东省聊城市",
"861881183", "广东省肇庆市",
"861773963", "河南省许昌市",
"861585288", "江苏省扬州市",
"861568877", "山东省莱芜市",
"861312527", "江西省赣州市",
"861520315", "河北省唐山市",
"86131910", "山西省太原市",
"86158433", "吉林省延边朝鲜族自治州",
"86134349", "广东省揭阳市",
"861338443", "吉林省延边朝鲜族自治州",
"861858344", "四川省资阳市",
"861780666", "广东省梅州市",
"861359702", "广西柳州市",
"861458281", "福建省宁德市",
"861454410", "福建省福州市",
"861390583", "浙江省嘉兴市",
"861377297", "陕西省安康市",
"861845890", "浙江省舟山市",
"861571409", "辽宁省辽阳市",
"861340533", "山东省淄博市",
"861361455", "黑龙江省绥化市",
"861870629", "江苏省南通市",
"861848519", "贵州省遵义市",
"861321445", "吉林省通化市",
"861369569", "安徽省合肥市",
"861365937", "甘肃省酒泉市",
"861308592", "甘肃省张掖市",
"86145926", "重庆市",
"86180559", "安徽省黄山市",
"861320944", "甘肃省陇南市",
"861510181", "甘肃省定西市",
"861350458", "黑龙江省鹤岗市",
"861380935", "甘肃省武威市",
"86132491", "广东省广州市",
"861350327", "河北省沧州市",
"861870470", "内蒙古呼伦贝尔市",
"86158088", "云南省昆明市",
"86182379", "河南省洛阳市",
"861379898", "广东省珠海市",
"86159739", "湖南省邵阳市",
"861593197", "河北省邢台市",
"861477741", "广西钦州市",
"861768121", "安徽省淮北市",
"861700756", "广东省珠海市",
"861377909", "新疆伊犁哈萨克自治州",
"861510311", "河北省石家庄市",
"861880846", "四川省广安市",
"861810054", "福建省泉州市",
"861831684", "广东省河源市",
"861890915", "陕西省安康市",
"861323544", "湖北省恩施土家族苗族自治州",
"861598458", "四川省攀枝花市",
"861817602", "广西钦州市",
"861598327", "四川省内江市",
"861829568", "宁夏银川市",
"861363554", "安徽省淮南市",
"86137822", "河南省许昌市",
"861516631", "山东省威海市",
"861850449", "吉林省白山市",
"861876395", "山东省德州市",
"861306012", "四川省德阳市",
"861845000", "福建省厦门市",
"861506048", "福建省泉州市",
"861814660", "江西省九江市",
"861773694", "河北省石家庄市",
"86153420", "天津市",
"861313522", "湖南省永州市",
"861560881", "云南省西双版纳傣族自治州",
"861594994", "山东省枣庄市",
"861341113", "广东省韶关市",
"86130930", "江苏省无锡市",
"861705265", "江苏省南京市",
"861824450", "河北省邯郸市",
"861839861", "四川省乐山市",
"861529328", "甘肃省酒泉市",
"861339873", "云南省红河哈尼族彝族自治州",
"861399762", "湖北省荆州市",
"861312566", "辽宁省阜新市",
"861450277", "内蒙古鄂尔多斯市",
"861324787", "江西省赣州市",
"861845242", "江苏省常州市",
"861770563", "安徽省宣城市",
"861555108", "安徽省马鞍山市",
"861504831", "内蒙古阿拉善盟",
"861552511", "山西省晋中市",
"861335882", "辽宁省葫芦岛市",
"861470541", "山东省济南市",
"86182799", "江西省萍乡市",
"861769833", "河南省安阳市",
"861707556", "安徽省安庆市",
"861452464", "黑龙江省七台河市",
"861809978", "新疆克孜勒苏柯尔克孜自治州",
"861876116", "江苏省常州市",
"861558306", "四川省阿坝藏族羌族自治州",
"861323307", "山西省临汾市",
"861539476", "内蒙古赤峰市",
"861311441", "湖北省孝感市",
"861868421", "吉林省吉林市",
"861810768", "广东省潮州市",
"86150345", "山西省运城市",
"861807079", "广西钦州市",
"86157634", "山东省莱芜市",
"861472683", "四川省广安市",
"861571617", "江苏省无锡市",
"861816075", "江西省宜春市",
"861380270", "广东省深圳市",
"861562470", "内蒙古呼伦贝尔市",
"861510135", "甘肃省金昌市",
"861707383", "河南省商丘市",
"861810004", "北京市",
"861377959", "新疆石河子市",
"86152617", "江苏省淮安市",
"861773932", "河南省周口市",
"861380981", "广东省佛山市",
"861782070", "广东省广州市",
"861554077", "内蒙古鄂尔多斯市",
"861378030", "河北省石家庄市",
"861570761", "广东省惠州市",
"861836288", "江苏省镇江市",
"861562188", "山东省济南市",
"861346848", "山东省潍坊市",
"861598408", "四川省广元市",
"861521728", "广东省汕头市",
"861458235", "安徽省滁州市",
"861311714", "湖北省恩施土家族苗族自治州",
"861532585", "浙江省绍兴市",
"86153425", "湖北省孝感市",
"86136358", "湖北省黄冈市",
"861804044", "四川省南充市",
"861771960", "陕西省宝鸡市",
"861867624", "广东省中山市",
"861869642", "湖北省黄冈市",
"861367834", "四川省凉山彝族自治州",
"861304493", "江西省上饶市",
"861534518", "江苏省南京市",
"861333376", "河南省信阳市",
"861529407", "甘肃省陇南市",
"861537610", "山东省菏泽市",
"861893260", "河北省廊坊市",
"861305411", "湖南省株洲市",
"861454378", "山东省济宁市",
"861303847", "陕西省汉中市",
"861315481", "内蒙古呼和浩特市",
"861376828", "广西河池市",
"861763336", "河北省秦皇岛市",
"861538740", "湖南省岳阳市",
"861876638", "山东省烟台市",
"861340608", "山东省东营市",
"861334542", "新疆吐鲁番地区",
"861384659", "黑龙江省大兴安岭地区",
"86188276", "湖北省武汉市",
"861513414", "辽宁省本溪市",
"861554653", "黑龙江省哈尔滨市",
"861363347", "山西省太原市",
"861331842", "广东省中山市",
"86150340", "山西省太原市",
"861323428", "辽宁省盘锦市",
"861517407", "辽宁省锦州市",
"861479282", "安徽省阜阳市",
"861882939", "陕西省延安市",
"861323357", "山西省临汾市",
"861390468", "黑龙江省佳木斯市",
"861558356", "四川省乐山市",
"861534721", "湖北省黄冈市",
"861807264", "浙江省舟山市",
"861589984", "广东省佛山市",
"861597480", "云南省昆明市",
"861891232", "江苏省常州市",
"861344031", "江苏省淮安市",
"861870318", "河北省衡水市",
"861531818", "山东省济宁市",
"861806824", "江苏省宿迁市",
"861565080", "安徽省宿州市",
"861376831", "广西南宁市",
"861360814", "四川省凉山彝族自治州",
"86132485", "浙江省宁波市",
"861839295", "陕西省西安市",
"86130646", "浙江省金华市",
"86136484", "重庆市",
"861772347", "四川省雅安市",
"861775694", "安徽省宣城市",
"861820079", "广东省河源市",
"861590676", "浙江省台州市",
"861399972", "新疆伊犁哈萨克自治州",
"861452420", "辽宁省大连市",
"861575027", "云南省普洱市",
"861360537", "山东省济宁市",
"861534738", "湖南省娄底市",
"861338480", "内蒙古鄂尔多斯市",
"861869400", "湖北省恩施土家族苗族自治州",
"861325544", "山东省德州市",
"86130434", "广东省深圳市",
"861334211", "辽宁省鞍山市",
"861344028", "江苏省盐城市",
"861365554", "安徽省淮南市",
"861760546", "山东省东营市",
"861473115", "河北省秦皇岛市",
"861506119", "江苏省盐城市",
"86181852", "贵州省遵义市",
"861341340", "广东省汕头市",
"861559643", "陕西省西安市",
"861339552", "安徽省蚌埠市",
"86132292", "广东省佛山市",
"861810978", "青海省西宁市",
"861303744", "湖南省张家界市",
"861399106", "陕西省榆林市",
"861323431", "吉林省长春市",
"861372336", "宁夏石嘴山市",
"86135569", "广东省江门市",
"861501444", "广东省肇庆市",
"861774255", "湖南省郴州市",
"861552050", "四川省甘孜藏族自治州",
"86159962", "江苏省南京市",
"861514905", "内蒙古赤峰市",
"861311534", "黑龙江省佳木斯市",
"86135250", "河南省新乡市",
"861359127", "辽宁省锦州市",
"861521731", "广东省广州市",
"861859229", "陕西省商洛市",
"861390540", "山东省菏泽市",
"861521242", "安徽省合肥市",
"861311817", "四川省绵阳市",
"861348476", "内蒙古赤峰市",
"86150545", "山东省烟台市",
"861333882", "江苏省南通市",
"861843242", "河北省邯郸市",
"861362932", "甘肃省定西市",
"861361387", "河南省南阳市",
"861352584", "河南省安阳市",
"861470434", "吉林省四平市",
"861478126", "四川省阿坝藏族羌族自治州",
"861569811", "山东省青岛市",
"861511224", "广东省广州市",
"861566564", "安徽省六安市",
"861500945", "甘肃省金昌市",
"861530630", "山东省威海市",
"86147066", "广东省广州市",
"861816302", "湖北省黄冈市",
"861840851", "贵州省贵阳市",
"861887583", "浙江省温州市",
"86132480", "上海市",
"861893224", "江苏省南通市",
"861890095", "辽宁省大连市",
"861521796", "广东省深圳市",
"861833644", "河南省新乡市",
"861308657", "四川省资阳市",
"861800462", "黑龙江省齐齐哈尔市",
"861529331", "甘肃省平凉市",
"861550023", "吉林省白山市",
"861380029", "陕西省西安市",
"861700910", "陕西省西安市",
"861869450", "浙江省嘉兴市",
"861379720", "湖北省孝感市",
"861561040", "山东省泰安市",
"861580914", "陕西省商洛市",
"861868438", "吉林省松原市",
"861306992", "黑龙江省佳木斯市",
"861502958", "陕西省渭南市",
"861858934", "云南省昆明市",
"861399156", "陕西省商洛市",
"861832456", "黑龙江省黑河市",
"861339502", "福建省厦门市",
"86158494", "内蒙古乌兰察布市",
"861376896", "广西玉林市",
"86135255", "河南省郑州市",
"86182701", "江西省上饶市",
"861570971", "青海省西宁市",
"861857216", "湖北省武汉市",
"861337327", "河北省秦皇岛市",
"861896926", "浙江省湖州市",
"86150540", "山东省菏泽市",
"861880783", "广西桂林市",
"861517273", "湖北省咸宁市",
"861365347", "山西省晋城市",
"861362694", "福建省南平市",
"861509135", "陕西省咸阳市",
"861768138", "安徽省六安市",
"861525282", "江苏省连云港市",
"861884995", "云南省德宏傣族景颇族自治州",
"861771770", "河北省保定市",
"861313481", "内蒙古巴彦淖尔市",
"861871599", "河北省张家口市",
"861505484", "山东省潍坊市",
"861335376", "河南省信阳市",
"86180908", "四川省泸州市",
"861850865", "湖北省武汉市",
"861323496", "黑龙江省哈尔滨市",
"861305847", "广东省潮州市",
"861558497", "吉林省辽源市",
"861303411", "甘肃省天水市",
"861372391", "山东省德州市",
"861867660", "广东省云浮市",
"861390497", "辽宁省营口市",
"861803274", "河北省沧州市",
"861869394", "甘肃省兰州市",
"861837449", "湖南省长沙市",
"86136991", "北京市",
"861801456", "江苏省宿迁市",
"861322075", "山东省潍坊市",
"86155742", "湖南省常德市",
"861532528", "浙江省嘉兴市",
"861811168", "四川省甘孜藏族自治州",
"861865429", "安徽省六安市",
"861520689", "山东省滨州市",
"861521785", "广东省珠海市",
"861471981", "新疆伊犁哈萨克自治州",
"861890086", "广东省佛山市",
"861332238", "辽宁省盘锦市",
"861898789", "云南省昆明市",
"86135804", "广东省广州市",
"861580707", "江西省赣州市",
"861573571", "山西省朔州市",
"861552890", "四川省雅安市",
"86133312", "河北省保定市",
"861896645", "浙江省舟山市",
"861899931", "新疆克拉玛依市",
"861856714", "河南省漯河市",
"861583514", "山西省长治市",
"861862971", "吉林省松原市",
"861576769", "广东省茂名市",
"861538783", "江西省上饶市",
"861568774", "云南省玉溪市",
"861533606", "甘肃省定西市",
"861806976", "浙江省杭州市",
"861879118", "陕西省商洛市",
"861536478", "山西省吕梁市",
"861556983", "甘肃省天水市",
"861398023", "四川省自贡市",
"861323485", "内蒙古通辽市",
"861373323", "河北省张家口市",
"861597443", "湖南省张家界市",
"861376885", "广西柳州市",
"861342998", "湖北省武汉市",
"861458760", "广东省中山市",
"861377819", "四川省南充市",
"861347513", "山东省威海市",
"861475619", "河北省沧州市",
"861345110", "湖北省咸宁市",
"861564941", "河南省开封市",
"861820413", "辽宁省抚顺市",
"861705051", "福建省厦门市",
"861709943", "浙江省丽水市",
"861773342", "河北省秦皇岛市",
"861527111", "湖北省襄樊市",
"861812032", "湖北省黄冈市",
"861313435", "吉林省通化市",
"86134549", "浙江省金华市",
"861376790", "江西省景德镇市",
"861399513", "宁夏吴忠市",
"861810797", "江西省赣州市",
"861554521", "黑龙江省齐齐哈尔市",
"861476549", "福建省福州市",
"861890141", "江苏省盐城市",
"861375709", "浙江省丽水市",
"861775963", "福建省泉州市",
"861801406", "江苏省扬州市",
"861770712", "湖北省孝感市",
"861583288", "河北省承德市",
"861580757", "广东省佛山市",
"861839286", "陕西省西安市",
"861383422", "山西省太原市",
"861372129", "安徽省宿州市",
"861349846", "江苏省淮安市",
"861318489", "广东省汕尾市",
"861898598", "贵州省黔西南布依族苗族自治州",
"861558540", "吉林省通化市",
"861874059", "陕西省西安市",
"861376056", "广东省揭阳市",
"861509181", "陕西省延安市",
"861800433", "吉林省延边朝鲜族自治州",
"86158981", "辽宁省大连市",
"86137087", "云南省昆明市",
"861813578", "河南省郑州市",
"86182579", "浙江省金华市",
"861384841", "内蒙古呼和浩特市",
"861579423", "江苏省无锡市",
"861300184", "河北省唐山市",
"86139256", "广东省揭阳市",
"861556330", "山东省日照市",
"861521890", "广东省佛山市",
"86150967", "云南省玉溪市",
"86131414", "北京市",
"86180359", "山西省运城市",
"861382466", "广东省云浮市",
"861560266", "广东省惠州市",
"861700133", "广东省深圳市",
"861519698", "四川省宜宾市",
"861834474", "江苏省连云港市",
"861817597", "湖南省长沙市",
"86130010", "北京市",
"861882349", "广东省佛山市",
"861457084", "江苏省南京市",
"861550610", "江苏省宿迁市",
"861532444", "安徽省淮南市",
"861523677", "河南省焦作市",
"861363937", "甘肃省酒泉市",
"86178539", "山东省临沂市",
"861332887", "福建省泉州市",
"861593168", "河北省石家庄市",
"861524901", "陕西省榆林市",
"861527698", "新疆塔城地区",
"861510639", "山东省临沂市",
"861328792", "山东省菏泽市",
"861773773", "河南省洛阳市",
"861855250", "江苏省镇江市",
"861890855", "贵州省黔东南苗族侗族自治州",
"861381541", "江苏省南京市",
"861318415", "山东省聊城市",
"861351568", "安徽省阜阳市",
"861539572", "浙江省湖州市",
"861459312", "四川省达州市",
"86152157", "浙江省丽水市",
"861389939", "新疆塔城地区",
"86182284", "四川省资阳市",
"861535583", "浙江省嘉兴市",
"861388781", "云南省保山市",
"861800071", "江西省南昌市",
"861308485", "陕西省延安市",
"861575147", "江苏省淮安市",
"861380998", "新疆克孜勒苏柯尔克孜自治州",
"861351602", "辽宁省鞍山市",
"861377790", "浙江省金华市",
"861897874", "广西玉林市",
"861312462", "贵州省遵义市",
"861773400", "河北省邯郸市",
"86180235", "广东省梅州市",
"86186492", "天津市",
"861562191", "内蒙古呼和浩特市",
"86152487", "内蒙古呼伦贝尔市",
"861863370", "河北省沧州市",
"861360565", "安徽省合肥市",
"86138976", "青海省西宁市",
"861353480", "广东省江门市",
"86184357", "山西省临汾市",
"861530940", "甘肃省平凉市",
"861501739", "广东省湛江市",
"861500635", "山东省聊城市",
"861339397", "河南省驻马店市",
"86185588", "福建省福州市",
"861551780", "河南省开封市",
"861535306", "陕西省渭南市",
"861378559", "河北省廊坊市",
"861348853", "内蒙古包头市",
"861526698", "山东省威海市",
"861322652", "广东省韶关市",
"861857441", "湖南省张家界市",
"861313426", "辽宁省大连市",
"861362642", "山东省青岛市",
"861760650", "浙江省杭州市",
"861374128", "广东省深圳市",
"861764064", "辽宁省葫芦岛市",
"861477823", "广东省汕头市",
"861471967", "甘肃省庆阳市",
"86130547", "山东省潍坊市",
"861368917", "陕西省宝鸡市",
"861709662", "浙江省嘉兴市",
"86150196", "广东省佛山市",
"861470749", "湖南省长沙市",
"861471645", "广东省深圳市",
"861478046", "四川省绵阳市",
"861846931", "云南省玉溪市",
"861882036", "广东省肇庆市",
"861315498", "四川省乐山市",
"861520615", "江苏省无锡市",
"861521719", "广东省广州市",
"861302978", "黑龙江省佳木斯市",
"86158463", "黑龙江省哈尔滨市",
"86188123", "云南省曲靖市",
"861858644", "贵州省铜仁地区",
"861321070", "山东省滨州市",
"86186280", "四川省成都市",
"861554595", "黑龙江省哈尔滨市",
"861371993", "广东省汕头市",
"861560898", "西藏拉萨市",
"861336366", "河北省沧州市",
"861331797", "江西省赣州市",
"86182859", "贵州省黔西南布依族苗族自治州",
"861534843", "湖南省湘西土家族苗族自治州",
"86131299", "湖北省武汉市",
"861865245", "江苏省无锡市",
"861825255", "江苏省扬州市",
"861340466", "吉林省吉林市",
"861364477", "内蒙古鄂尔多斯市",
"86180230", "广东省珠海市",
"861380149", "江苏省常州市",
"861773450", "河北省邢台市",
"861586344", "山东省青岛市",
"861550143", "江苏省徐州市",
"861804912", "陕西省榆林市",
"861599902", "新疆巴音郭楞蒙古自治州",
"861531543", "山东省滨州市",
"861819566", "青海省玉树藏族自治州",
"861325592", "河南省郑州市",
"861344999", "新疆哈密地区",
"861390606", "福建省漳州市",
"861332861", "福建省南平市",
"861453448", "辽宁省葫芦岛市",
"86147867", "湖南省娄底市",
"861570569", "安徽省合肥市",
"86170921", "上海市",
"861846996", "云南省德宏傣族景颇族自治州",
"86155642", "山东省临沂市",
"861303792", "宁夏吴忠市",
"861569839", "山西省晋中市",
"861500398", "河南省三门峡市",
"861814982", "新疆昌吉回族自治州",
"861596443", "山东省菏泽市",
"861378509", "河北省唐山市",
"861348803", "陕西省榆林市",
"861850514", "江苏省扬州市",
"861857299", "湖北省武汉市",
"86185454", "黑龙江省佳木斯市",
"861346513", "山东省威海市",
"861376819", "广西北海市",
"861528545", "贵州省黔西南布依族苗族自治州",
"861501492", "广东省珠海市",
"86159769", "广东省珠海市",
"861824694", "黑龙江省大庆市",
"861760600", "福建省泉州市",
"86152316", "河北省廊坊市",
"861350627", "江苏省南通市",
"86157793", "江西省上饶市",
"861353178", "广东省中山市",
"861820766", "广东省云浮市",
"861534529", "江苏省盐城市",
"861708530", "山东省济南市",
"861850837", "四川省阿坝藏族羌族自治州",
"861872008", "江西省南昌市",
"861870329", "河北省邢台市",
"861508053", "福建省南平市",
"861317253", "广东省汕头市",
"86147916", "陕西省汉中市",
"861855854", "福建省宁德市",
"861843294", "河北省秦皇岛市",
"861539130", "云南省楚雄彝族自治州",
"861334239", "辽宁省葫芦岛市",
"861509167", "陕西省西安市",
"861894849", "广东省潮州市",
"861323419", "辽宁省辽阳市",
"861314975", "辽宁省阜新市",
"861370951", "宁夏银川市",
"861818968", "甘肃省兰州市",
"861537478", "内蒙古巴彦淖尔市",
"861557983", "江西省宜春市",
"861322568", "安徽省阜阳市",
"861814360", "吉林省长春市",
"861585291", "江苏省南京市",
"86183130", "云南省德宏傣族景颇族自治州",
"861312433", "吉林省延边朝鲜族自治州",
"861857907", "江西省赣州市",
"861829302", "甘肃省临夏回族自治州",
"861780327", "河北省沧州市",
"861896935", "浙江省金华市",
"861509126", "陕西省宝鸡市",
"861806220", "湖北省黄冈市",
"861770436", "吉林省白城市",
"861778124", "四川省乐山市",
"86177479", "内蒙古锡林郭勒盟",
"861893767", "河南省郑州市",
"861570884", "云南省怒江傈僳族自治州",
"861815251", "宁夏银川市",
"861478311", "河南省三门峡市",
"861598627", "广东省阳江市",
"861351483", "内蒙古阿拉善盟",
"861331978", "新疆阿克苏地区",
"861500681", "山东省莱芜市",
"861820727", "湖北省襄樊市",
"861861373", "河南省新乡市",
"861370447", "吉林省松原市",
"861575779", "浙江省温州市",
"861816440", "安徽省芜湖市",
"861771403", "江苏省盐城市",
"861863418", "河北省保定市",
"861300032", "江苏省南京市",
"861804573", "黑龙江省鹤岗市",
"861538247", "浙江省金华市",
"861394858", "内蒙古通辽市",
"861535468", "吉林省松原市",
"861510611", "江苏省常州市",
"861571317", "河北省沧州市",
"861573969", "新疆哈密地区",
"861319614", "吉林省通化市",
"861527139", "湖北省十堰市",
"861309684", "贵州省黔南布依族苗族自治州",
"86181210", "上海市",
"861803776", "河南省商丘市",
"861819527", "宁夏吴忠市",
"861323607", "江苏省南通市",
"86150017", "上海市",
"861318722", "湖南省湘潭市",
"861346972", "湖北省恩施土家族苗族自治州",
"861861742", "河北省邢台市",
"861830534", "山东省德州市",
"861575208", "云南省曲靖市",
"861398143", "四川省内江市",
"861866660", "广东省惠州市",
"86183975", "湖南省益阳市",
"86181572", "浙江省湖州市",
"861327614", "江苏省盐城市",
"861340358", "山西省吕梁市",
"86182601", "江苏省苏州市",
"861554303", "吉林省吉林市",
"861340427", "江苏省无锡市",
"861336458", "吉林省四平市",
"861856216", "山东省烟台市",
"861802114", "江苏省南京市",
"861880158", "江苏省南京市",
"861504959", "内蒙古鄂尔多斯市",
"861518541", "贵州省安顺市",
"86157373", "河南省新乡市",
"861812184", "四川省成都市",
"861328744", "山东省烟台市",
"861878424", "四川省巴中市",
"861886306", "山东省威海市",
"861308431", "四川省达州市",
"861529628", "广西南宁市",
"861772775", "广东省广州市",
"861590882", "云南省德宏傣族景颇族自治州",
"861818017", "四川省南充市",
"86183135", "云南省曲靖市",
"861373501", "浙江省舟山市",
"861373990", "内蒙古巴彦淖尔市",
"861564696", "新疆阿克苏地区",
"861778092", "四川省南充市",
"861380777", "广西钦州市",
"861874710", "内蒙古包头市",
"861890021", "福建省厦门市",
"861471926", "甘肃省白银市",
"861832697", "安徽省宿州市",
"861579717", "湖北省随州市",
"861539913", "陕西省渭南市",
"86155949", "陕西省西安市",
"86157551", "安徽省合肥市",
"86180603", "福建省宁德市",
"861475631", "河北省张家口市",
"861365775", "广西玉林市",
"861313467", "山西省临汾市",
"861809842", "安徽省淮北市",
"861522005", "广东省深圳市",
"86130746", "浙江省温州市",
"861394808", "内蒙古呼伦贝尔市",
"861533540", "山东省菏泽市",
"861555846", "浙江省丽水市",
"861308496", "广西玉林市",
"861529189", "陕西省商洛市",
"861328411", "辽宁省大连市",
"861859445", "福建省莆田市",
"861510949", "甘肃省陇南市",
"861363965", "河南省驻马店市",
"861870618", "江苏省无锡市",
"861879946", "新疆阿克苏地区",
"86131402", "重庆市",
"861322483", "内蒙古兴安盟",
"861344257", "山东省日照市",
"86711", "湖北省鄂州市",
"86139542", "山东省青岛市",
"861847641", "广东省茂名市",
"861512891", "河北省邯郸市",
"861537310", "河北省邯郸市",
"861369761", "山东省烟台市",
"861839784", "江西省抚州市",
"861869773", "河南省信阳市",
"861368704", "江西省抚州市",
"861776973", "浙江省绍兴市",
"861454678", "广东省东莞市",
"861897018", "江西省鹰潭市",
"861800527", "江苏省扬州市",
"861310684", "广东省珠海市",
"861898581", "贵州省黔东南苗族侗族自治州",
"861855914", "福建省龙岩市",
"86135539", "广东省清远市",
"861803966", "河南省郑州市",
"861771277", "江苏省常州市",
"861872826", "四川省资阳市",
"86151917", "陕西省宝鸡市",
"861373010", "河北省石家庄市",
"861322597", "福建省南平市",
"861324761", "广东省深圳市",
"861818997", "西藏山南地区",
"861370811", "四川省绵阳市",
"861866624", "广东省阳江市",
"861782869", "四川省乐山市",
"861331054", "湖北省恩施土家族苗族自治州",
"861366834", "四川省内江市",
"861848531", "贵州省安顺市",
"861768195", "浙江省杭州市",
"86136702", "广东省深圳市",
"86189956", "湖北省武汉市",
"861308307", "安徽省淮南市",
"86131060", "浙江省台州市",
"86156844", "山东省潍坊市",
"86152717", "湖北省荆门市",
"861590376", "河南省信阳市",
"861884938", "河北省秦皇岛市",
"861454863", "河南省南阳市",
"861306334", "安徽省滁州市",
"861375551", "江西省萍乡市",
"861874956", "河南省许昌市",
"861379227", "山东省滨州市",
"86157573", "浙江省嘉兴市",
"861301295", "山东省青岛市",
"861814324", "西藏林芝地区",
"861332286", "广东省珠海市",
"861530330", "河北省邯郸市",
"86147036", "四川省成都市",
"861327032", "江苏省镇江市",
"861871830", "广东省韶关市",
"861361687", "浙江省温州市",
"861500367", "青海省海西蒙古族藏族自治州",
"861308544", "湖南省永州市",
"861768316", "四川省南充市",
"86151866", "贵州省遵义市",
"861527681", "新疆克孜勒苏柯尔克孜自治州",
"861778160", "四川省雅安市",
"86131684", "广东省东莞市",
"861555783", "浙江省丽水市",
"861557940", "江西省上饶市",
"861762501", "江苏省无锡市",
"861576561", "黑龙江省黑河市",
"861319032", "辽宁省盘锦市",
"861380874", "云南省曲靖市",
"861529696", "宁夏固原市",
"861386141", "江苏省盐城市",
"86159932", "河南省周口市",
"861519681", "四川省资阳市",
"861475628", "河北省邢台市",
"861559772", "贵州省贵阳市",
"861560867", "湖北省襄樊市",
"861331768", "广西河池市",
"861368857", "贵州省毕节地区",
"861537143", "江苏省连云港市",
"861528484", "四川省自贡市",
"86153277", "湖北省黄冈市",
"861518212", "四川省内江市",
"861328847", "广东省广州市",
"861511977", "广东省清远市",
"861317082", "江西省九江市",
"861816568", "广东省清远市",
"861473631", "广西桂林市",
"861315467", "四川省自贡市",
"86157351", "山西省太原市",
"861508282", "四川省广元市",
"861318248", "江苏省南通市",
"861565123", "江苏省常州市",
"861509949", "新疆巴音郭楞蒙古自治州",
"861833344", "河北省沧州市",
"861840939", "甘肃省陇南市",
"86159172", "广东省中山市",
"861825061", "福建省泉州市",
"861551372", "山西省阳泉市",
"861776763", "新疆昌吉回族自治州",
"861308428", "河南省周口市",
"861376909", "云南省普洱市",
"86131065", "河北省石家庄市",
"861308357", "江苏省南通市",
"861395630", "安徽省滁州市",
"861369971", "广东省广州市",
"86183474", "内蒙古乌兰察布市",
"861816602", "江西省宜春市",
"861329082", "河南省安阳市",
"861588907", "西藏拉萨市",
"861830714", "湖北省黄石市",
"861890989", "辽宁省葫芦岛市",
"861372118", "安徽省蚌埠市",
"861560720", "湖北省宜昌市",
"861804802", "四川省成都市",
"861372691", "广东省湛江市",
"861380967", "广东省汕头市",
"861839238", "陕西省西安市",
"86157734", "湖南省衡阳市",
"861354897", "湖南省长沙市",
"86132046", "黑龙江省哈尔滨市",
"861380645", "山东省烟台市",
"861320634", "山东省莱芜市",
"861560974", "青海省海南藏族自治州",
"861550478", "内蒙古巴彦淖尔市",
"861530983", "辽宁省大连市",
"861397247", "湖北省十堰市",
"861365647", "山东省东营市",
"861362394", "河南省周口市",
"861864302", "吉林省通化市",
"861351597", "福建省厦门市",
"861534795", "江西省宜春市",
"861829075", "新疆石河子市",
"861337627", "江苏省常州市",
"861365965", "广西玉林市",
"86182699", "安徽省阜阳市",
"861450960", "新疆博尔塔拉蒙古自治州",
"861768041", "湖南省衡阳市",
"861454832", "广东省广州市",
"861305439", "黑龙江省绥化市",
"861337666", "广东省清远市",
"861515549", "安徽省安庆市",
"86131201", "北京市",
"86184557", "安徽省宿州市",
"861775400", "安徽省淮南市",
"861899859", "广东省肇庆市",
"861815065", "福建省莆田市",
"861536023", "广东省汕尾市",
"861324243", "广东省深圳市",
"861882911", "陕西省延安市",
"86185955", "河南省郑州市",
"861850734", "湖南省衡阳市",
"861870703", "江西省上饶市",
"861830907", "新疆吐鲁番地区",
"861346733", "湖南省株洲市",
"861860142", "江苏省苏州市",
"861835692", "安徽省黄山市",
"861364253", "广东省清远市",
"861707640", "山东省济南市",
"86150177", "广东省佛山市",
"861894465", "黑龙江省哈尔滨市",
"861380926", "广东省东莞市",
"861348572", "安徽省合肥市",
"861344019", "四川省凉山彝族自治州",
"861804092", "新疆乌鲁木齐市",
"861322440", "吉林省四平市",
"861889308", "甘肃省天水市",
"861526626", "山东省枣庄市",
"861893589", "新疆阿勒泰地区",
"861760442", "吉林省吉林市",
"861319063", "内蒙古乌兰察布市",
"861313498", "内蒙古乌海市",
"861362450", "黑龙江省哈尔滨市",
"861339456", "黑龙江省黑河市",
"861892156", "江苏省镇江市",
"861372388", "湖南省长沙市",
"861821127", "广东省湛江市",
"861334594", "浙江省金华市",
"861317477", "浙江省台州市",
"861318157", "山东省菏泽市",
"861475319", "山东省青岛市",
"86159639", "山东省临沂市",
"861327063", "内蒙古通辽市",
"861898535", "贵州省毕节地区",
"86138997", "新疆伊犁哈萨克自治州",
"861521539", "山东省临沂市",
"861857817", "广东省河源市",
"861376297", "湖南省永州市",
"861331894", "广东省珠海市",
"861315426", "辽宁省大连市",
"86185388", "河南省洛阳市",
"861867982", "江西省南昌市",
"861848585", "贵州省六盘水市",
"861847809", "湖南省郴州市",
"861877503", "广西梧州市",
"861329477", "内蒙古鄂尔多斯市",
"861533306", "山西省运城市",
"861458267", "安徽省芜湖市",
"861869932", "新疆石河子市",
"861560826", "四川省绵阳市",
"86133427", "广东省汕头市",
"861776732", "浙江省宁波市",
"861820976", "青海省玉树藏族自治州",
"861890577", "浙江省温州市",
"861476263", "江苏省宿迁市",
"861502580", "甘肃省临夏回族自治州",
"861881708", "湖南省常德市",
"861323592", "福建省厦门市",
"861778573", "贵州省贵阳市",
"861835934", "福建省龙岩市",
"861504819", "内蒙古包头市",
"861870753", "广东省梅州市",
"861830957", "宁夏银川市",
"861360423", "辽宁省盘锦市",
"86185950", "宁夏银川市",
"861314765", "吉林省长春市",
"861806413", "湖北省襄樊市",
"861500326", "河北省廊坊市",
"861886540", "山东省菏泽市",
"861302054", "山东省滨州市",
"861510339", "河北省邢台市",
"861580200", "广东省广州市",
"861889427", "甘肃省临夏回族自治州",
"861529685", "广西玉林市",
"861594942", "内蒙古包头市",
"861889358", "甘肃省酒泉市",
"861394918", "河南省信阳市",
"861550310", "河北省邯郸市",
"861535497", "内蒙古包头市",
"86182992", "新疆伊犁哈萨克自治州",
"861897777", "广西南宁市",
"861318107", "山东省聊城市",
"861302768", "河南省漯河市",
"861523377", "河北省沧州市",
"861339406", "福建省厦门市",
"861831922", "广东省云浮市",
"861332295", "广东省云浮市",
"861551261", "河北省廊坊市",
"86152516", "江苏省无锡市",
"861479377", "甘肃省白银市",
"861876948", "山东省德州市",
"8613588", "浙江省杭州市",
"861354673", "山西省晋中市",
"861854661", "黑龙江省哈尔滨市",
"861355178", "四川省巴中市",
"861516619", "山东省日照市",
"861533356", "山西省晋城市",
"861473685", "云南省临沧市",
"861875150", "江苏省徐州市",
"86156329", "河北省邢台市",
"86170028", "四川省成都市",
"86181792", "江西省九江市",
"861556630", "辽宁省抚顺市",
"861800566", "安徽省池州市",
"86150179", "广东省深圳市",
"861700584", "浙江省宁波市",
"861322989", "河北省邢台市",
"86151612", "江苏省宿迁市",
"861886082", "江苏省盐城市",
"861511778", "贵州省安顺市",
"861300533", "广东省汕头市",
"86155365", "山西省太原市",
"861804072", "新疆伊犁哈萨克自治州",
"861471797", "山西省朔州市",
"861577148", "内蒙古巴彦淖尔市",
"861580580", "浙江省舟山市",
"861893259", "河北省秦皇岛市",
"861348592", "安徽省宣城市",
"861899413", "江苏省南京市",
"861454945", "福建省厦门市",
"86170050", "福建省福州市",
"86184559", "安徽省黄山市",
"861772843", "广东省汕头市",
"86736", "湖南省常德市",
"861310846", "陕西省汉中市",
"861866309", "山东省滨州市",
"861380054", "山东省滨州市",
"861857020", "湖南省湘潭市",
"861360035", "广东省江门市",
"861572437", "辽宁省盘锦市",
"861301506", "内蒙古包头市",
"86133867", "辽宁省鞍山市",
"861454667", "广东省深圳市",
"861705322", "广东省深圳市",
"861355949", "福建省厦门市",
"861539419", "陕西省铜川市",
"861361883", "云南省临沧市",
"861585943", "福建省福州市",
"86138999", "新疆乌鲁木齐市",
"861335685", "山东省青岛市",
"861807016", "江西省鹰潭市",
"861827091", "江西省南昌市",
"861377960", "新疆克孜勒苏柯尔克孜自治州",
"861588279", "四川省绵阳市",
"861356541", "新疆乌鲁木齐市",
"861329497", "云南省昆明市",
"861858261", "四川省广安市",
"861881441", "广东省清远市",
"861394954", "河南省安阳市",
"861800649", "山东省临沂市",
"86189246", "广东省深圳市",
"86133916", "北京市",
"861313478", "内蒙古巴彦淖尔市",
"861820931", "甘肃省兰州市",
"861764534", "黑龙江省七台河市",
"861560663", "浙江省温州市",
"86185928", "陕西省西安市",
"861882566", "广东省揭阳市",
"86159637", "山东省济宁市",
"86130349", "海南省海口市",
"86170770", "广西南宁市",
"861533253", "陕西省汉中市",
"861599689", "江苏省徐州市",
"861364583", "浙江省嘉兴市",
"861872994", "陕西省榆林市",
"861334574", "浙江省宁波市",
"861304856", "贵州省六盘水市",
"861327713", "湖北省黄冈市",
"861893209", "贵州省黔西南布依族苗族自治州",
"861573463", "黑龙江省牡丹江市",
"86155360", "山西省太原市",
"861824469", "河北省邢台市",
"861587895", "广西钦州市",
"861337549", "山东省临沂市",
"861319713", "湖北省荆门市",
"861890597", "福建省龙岩市",
"861364356", "山西省晋城市",
"861820996", "新疆巴音郭楞蒙古自治州",
"861366921", "陕西省延安市",
"861324346", "河南省周口市",
"86170055", "安徽省合肥市",
"86133429", "广东省深圳市",
"861515666", "安徽省阜阳市",
"861590385", "河南省新乡市",
"861588758", "云南省怒江傈僳族自治州",
"861800911", "陕西省延安市",
"861829855", "甘肃省武威市",
"861323572", "浙江省湖州市",
"861778593", "贵州省贵阳市",
"861589730", "湖南省岳阳市",
"861810981", "辽宁省朝阳市",
"861301556", "河南省洛阳市",
"861599128", "陕西省咸阳市",
"861358115", "山东省滨州市",
"861380004", "辽宁省沈阳市",
"861302926", "辽宁省抚顺市",
"861365529", "江苏省镇江市",
"861536435", "湖南省娄底市",
"861570039", "四川省内江市",
"861309783", "广西贺州市",
"861355198", "四川省甘孜藏族自治州",
"861584699", "黑龙江省佳木斯市",
"861537426", "江西省宜春市",
"861809029", "四川省广安市",
"861332275", "广东省揭阳市",
"861847413", "湖南省益阳市",
"86156327", "河北省沧州市",
"86150939", "河南省安阳市",
"861771909", "河南省郑州市",
"86135736", "山东省潍坊市",
"861331967", "湖南省郴州市",
"861333319", "河北省邢台市",
"86131276", "上海市",
"861528127", "四川省雅安市",
"861337823", "四川省巴中市",
"861845274", "江苏省无锡市",
"861581983", "广东省珠海市",
"86170775", "江西省上饶市",
"861325853", "黑龙江省鸡西市",
"861330749", "湖南省长沙市",
"861316656", "河北省沧州市",
"86188784", "广西梧州市",
"861897797", "广西南宁市",
"861374952", "河南省焦作市",
"861535477", "吉林省松原市",
"861338046", "广东省潮州市",
"861329540", "山东省菏泽市",
"861865404", "安徽省阜阳市",
"861855908", "福建省南平市",
"861587886", "广西河池市",
"861590396", "河南省驻马店市",
"861369550", "安徽省滁州市",
"861368538", "山东省泰安市",
"86182140", "云南省普洱市",
"86152062", "江苏省苏州市",
"861368482", "江西省九江市",
"861853269", "河北省保定市",
"861379332", "山东省淄博市",
"86183721", "湖北省武汉市",
"861839402", "甘肃省兰州市",
"861323913", "陕西省渭南市",
"861801282", "江苏省镇江市",
"861452399", "西藏拉萨市",
"86135537", "广东省潮州市",
"861539073", "江西省赣州市",
"861568228", "四川省达州市",
"861569084", "河南省郑州市",
"861317540", "浙江省金华市",
"861395722", "浙江省舟山市",
"861315143", "江苏省扬州市",
"861504682", "黑龙江省双鸭山市",
"861335631", "山东省威海市",
"861509178", "陕西省榆林市",
"861576916", "陕西省汉中市",
"861821484", "安徽省蚌埠市",
"861589891", "山东省济南市",
"861514612", "黑龙江省哈尔滨市",
"861372154", "贵州省安顺市",
"861830758", "广东省肇庆市",
"861304031", "吉林省白城市",
"861535082", "河北省衡水市",
"861811212", "江苏省扬州市",
"861537467", "内蒙古乌兰察布市",
"861874024", "辽宁省营口市",
"861300562", "广东省湛江市",
"861322577", "安徽省宿州市",
"861369936", "新疆乌鲁木齐市",
"861373827", "浙江省嘉兴市",
"861380894", "山东省淄博市",
"861776013", "四川省乐山市",
"861304700", "广东省潮州市",
"861560632", "山东省枣庄市",
"861302967", "新疆乌鲁木齐市",
"861320972", "青海省海东地区",
"861816021", "新疆乌鲁木齐市",
"861830064", "河南省焦作市",
"86134170", "广东省汕头市",
"861559792", "贵州省铜仁地区",
"861364468", "黑龙江省佳木斯市",
"861587005", "江西省景德镇市",
"861302645", "四川省德阳市",
"861332930", "黑龙江省哈尔滨市",
"861354964", "湖南省长沙市",
"86138692", "山东省德州市",
"86185245", "辽宁省锦州市",
"861858743", "广西贺州市",
"861803728", "河南省安阳市",
"861301275", "山东省莱芜市",
"861579808", "江西省萍乡市",
"86139730", "湖南省岳阳市",
"861320106", "新疆哈密地区",
"861313310", "山西省忻州市",
"861366348", "山西省临汾市",
"861310740", "湖南省常德市",
"861876747", "浙江省温州市",
"861583333", "河北省保定市",
"861473676", "云南省西双版纳傣族自治州",
"861326358", "黑龙江省大庆市",
"861825444", "山东省临沂市",
"861369500", "福建省厦门市",
"861369991", "新疆吐鲁番地区",
"861853074", "河南省新乡市",
"861551392", "山西省朔州市",
"861838580", "贵州省黔东南苗族侗族自治州",
"861571460", "黑龙江省哈尔滨市",
"86188910", "陕西省咸阳市",
"86156905", "河北省唐山市",
"861392152", "江苏省无锡市",
"861839452", "甘肃省兰州市",
"861300658", "山东省济南市",
"861375970", "陕西省咸阳市",
"861819801", "甘肃省兰州市",
"861332506", "山东省东营市",
"861311183", "四川省雅安市",
"861503047", "河北省沧州市",
"86153279", "湖北省十堰市",
"86187961", "江苏省南通市",
"86130824", "辽宁省沈阳市",
"861889184", "陕西省安康市",
"861338311", "河北省石家庄市",
"86180656", "福建省漳州市",
"861815422", "安徽省合肥市",
"86151704", "江西省南昌市",
"861860437", "吉林省辽源市",
"861830708", "江西省景德镇市",
"86147304", "河北省石家庄市",
"861454626", "宁夏石嘴山市",
"861351577", "浙江省温州市",
"861590331", "河北省石家庄市",
"861593212", "河北省保定市",
"861814417", "福建省宁德市",
"861333628", "山东省滨州市",
"861362374", "河南省许昌市",
"861886477", "河南省焦作市",
"861810935", "甘肃省武威市",
"86156682", "山东省菏泽市",
"861509480", "山东省泰安市",
"86182697", "安徽省合肥市",
"861536481", "山西省太原市",
"86134175", "广东省深圳市",
"861829095", "新疆吐鲁番地区",
"86181166", "四川省成都市",
"861453193", "山西省晋中市",
"861302874", "甘肃省白银市",
"861476327", "山东省青岛市",
"861303933", "吉林省延边朝鲜族自治州",
"861360146", "江苏省南京市",
"86151426", "辽宁省锦州市",
"861811434", "江苏省宿迁市",
"861326308", "江西省抚州市",
"861458323", "江西省九江市",
"861560994", "新疆昌吉回族自治州",
"861890440", "吉林省长春市",
"861550498", "辽宁省锦州市",
"861304096", "湖北省宜昌市",
"86150632", "山东省枣庄市",
"861832745", "湖北省黄冈市",
"861867417", "湖北省十堰市",
"861861393", "湖南省张家界市",
"861331998", "新疆喀什地区",
"861599185", "陕西省西安市",
"861533082", "辽宁省大连市",
"861576700", "广东省深圳市",
"861325913", "陕西省渭南市",
"861787541", "广东省阳江市",
"861333631", "山东省威海市",
"861590328", "河北省衡水市",
"861590457", "黑龙江省大兴安岭地区",
"861523368", "河北省廊坊市",
"861309740", "云南省玉溪市",
"86156726", "湖北省黄冈市",
"861336741", "湖南省株洲市",
"861454335", "内蒙古乌兰察布市",
"861800145", "江苏省扬州市",
"86189903", "四川省眉山市",
"861355167", "四川省乐山市",
"861855269", "江苏省泰州市",
"86177477", "内蒙古鄂尔多斯市",
"861571548", "山东省泰安市",
"861863404", "河北省唐山市",
"861345847", "四川省宜宾市",
"861358941", "山东省滨州市",
"861335189", "黑龙江省大庆市",
"861800851", "贵州省贵阳市",
"861327562", "安徽省铜陵市",
"861532472", "河南省郑州市",
"861890568", "安徽省亳州市",
"861355339", "广东省汕头市",
"861377876", "四川省雅安市",
"861319608", "吉林省吉林市",
"861391288", "江苏省南通市",
"861373281", "吉林省辽源市",
"861840462", "黑龙江省七台河市",
"861520430", "吉林省长春市",
"861820341", "山西省太原市",
"861767117", "湖北省襄樊市",
"861324500", "湖南省常德市",
"861577473", "内蒙古乌海市",
"861327608", "福建省福州市",
"861510178", "甘肃省定西市",
"86152405", "江苏省南通市",
"861319562", "安徽省铜陵市",
"861860351", "山西省太原市",
"86139665", "安徽省阜阳市",
"86150019", "上海市",
"861346992", "湖北省黄冈市",
"861834442", "广东省东莞市",
"861314986", "辽宁省大连市",
"861874060", "陕西省西安市",
"861350549", "山东省临沂市",
"861510480", "内蒙古赤峰市",
"861534647", "河南省平顶山市",
"861580543", "山东省滨州市",
"861839640", "福建省宁德市",
"861809935", "新疆昌吉回族自治州",
"86182676", "浙江省台州市",
"861365795", "江西省宜春市",
"861831247", "广东省深圳市",
"861538384", "河北省秦皇岛市",
"861308476", "内蒙古赤峰市",
"861822656", "安徽省蚌埠市",
"861813422", "河北省保定市",
"861500410", "辽宁省铁岭市",
"861816038", "新疆哈密地区",
"861576750", "广东省茂名市",
"861454111", "安徽省合肥市",
"861324936", "广东省惠州市",
"86183023", "重庆市",
"86178636", "山东省潍坊市",
"861587372", "湖南省益阳市",
"86137432", "吉林省吉林市",
"861576096", "陕西省汉中市",
"86155947", "陕西省延安市",
"861394814", "内蒙古通辽市",
"861855074", "江苏省宿迁市",
"861883435", "山西省晋城市",
"861863454", "山西省运城市",
"861853958", "河南省洛阳市",
"861458759", "广东省湛江市",
"861329468", "山西省临汾市",
"861323093", "河北省秦皇岛市",
"861380797", "江西省赣州市",
"86184703", "江西省上饶市",
"861811541", "江苏省无锡市",
"861850633", "山东省日照市",
"861580829", "四川省凉山彝族自治州",
"86134646", "辽宁省锦州市",
"861571424", "辽宁省本溪市",
"861350823", "四川省攀枝花市",
"861305933", "广东省云浮市",
"861321850", "江苏省盐城市",
"861454698", "广东省湛江市",
"861818820", "贵州省黔西南布依族苗族自治州",
"86189708", "江西省南昌市",
"861587743", "陕西省渭南市",
"861396684", "安徽省阜阳市",
"861312349", "广西北海市",
"861361840", "湖南省岳阳市",
"861890652", "浙江省杭州市",
"861398467", "贵州省黔西南布依族苗族自治州",
"861336414", "辽宁省本溪市",
"861364540", "山东省菏泽市",
"861395248", "江苏省无锡市",
"861802158", "江苏省镇江市",
"861550426", "辽宁省大连市",
"861340314", "河北省承德市",
"86187068", "陕西省西安市",
"86188414", "辽宁省本溪市",
"861554206", "辽宁省铁岭市",
"861301340", "云南省红河哈尼族彝族自治州",
"861368718", "湖北省黄石市",
"861570925", "陕西省安康市",
"861568231", "四川省泸州市",
"861770471", "内蒙古呼和浩特市",
"861556107", "内蒙古包头市",
"861814841", "四川省绵阳市",
"861335628", "山东省滨州市",
"861334123", "山东省青岛市",
"861868120", "四川省攀枝花市",
"861311140", "河北省秦皇岛市",
"861530489", "黑龙江省大庆市",
"86138852", "贵州省遵义市",
"861880384", "河南省平顶山市",
"861380978", "广东省茂名市",
"861586287", "江苏省扬州市",
"86184359", "山西省运城市",
"861504277", "辽宁省盘锦市",
"861379942", "福建省福州市",
"8618322", "天津市",
"861863390", "河北省石家庄市",
"861570646", "山东省潍坊市",
"861377924", "新疆巴音郭楞蒙古自治州",
"861596339", "山东省德州市",
"861858895", "广东省深圳市",
"861550467", "黑龙江省鸡西市",
"861708192", "福建省莆田市",
"861452616", "江苏省苏州市",
"86152489", "海南省海口市",
"861321706", "江西省吉安市",
"861801677", "福建省宁德市",
"86155565", "安徽省阜阳市",
"86134010", "北京市",
"86152159", "浙江省绍兴市",
"86187613", "江苏省连云港市",
"861539592", "福建省厦门市",
"861395157", "江苏省无锡市",
"861302149", "河北省石家庄市",
"861365786", "广西桂林市",
"861800091", "广东省茂名市",
"861320733", "湖南省株洲市",
"861590619", "江苏省无锡市",
"861591715", "广东省云浮市",
"861803890", "广东省韶关市",
"86185021", "上海市",
"86158823", "四川省成都市",
"861393415", "山西省太原市",
"861319533", "安徽省芜湖市",
"861329356", "山西省晋城市",
"861850558", "安徽省阜阳市",
"861454381", "贵州省贵阳市",
"861535253", "新疆伊犁哈萨克自治州",
"861576806", "广东省肇庆市",
"861830613", "江苏省苏州市",
"861315478", "内蒙古巴彦淖尔市",
"861370570", "浙江省衢州市",
"861338639", "山东省青岛市",
"861347944", "江西省抚州市",
"861804355", "吉林省通化市",
"86156268", "广东省东莞市",
"861309846", "湖北省襄樊市",
"861339377", "河南省平顶山市",
"861599131", "陕西省安康市",
"861890483", "内蒙古阿拉善盟",
"861327533", "山东省淄博市",
"861881534", "山东省德州市",
"861840433", "吉林省延边朝鲜族自治州",
"861598549", "贵州省黔西南布依族苗族自治州",
"861808492", "四川省德阳市",
"861333685", "浙江省湖州市",
"861780263", "江苏省徐州市",
"861862925", "陕西省西安市",
"86151039", "甘肃省陇南市",
"861325572", "浙江省湖州市",
"861552069", "四川省遂宁市",
"861321756", "广东省珠海市",
"861500378", "河南省开封市",
"861303772", "四川省攀枝花市",
"861882071", "广东省东莞市",
"861857708", "广西南宁市",
"861818726", "云南省德宏傣族景颇族自治州",
"861513666", "河南省南阳市",
"861846976", "云南省大理白族自治州",
"861329583", "浙江省嘉兴市",
"861361746", "湖南省永州市",
"86147869", "湖南省常德市",
"861810029", "广东省深圳市",
"861597181", "湖北省恩施土家族苗族自治州",
"861877892", "广西柳州市",
"861575463", "黑龙江省牡丹江市",
"861321090", "山东省威海市",
"861867609", "广东省潮州市",
"86134015", "江苏省常州市",
"861599196", "陕西省汉中市",
"861302998", "黑龙江省佳木斯市",
"86155560", "安徽省六安市",
"861452138", "河北省邢台市",
"861364497", "辽宁省沈阳市",
"861317583", "浙江省舟山市",
"861399944", "新疆哈密地区",
"861315180", "江苏省宿迁市",
"86131297", "广东省肇庆市",
"861560878", "云南省楚雄彝族自治州",
"861331777", "广西钦州市",
"861554575", "黑龙江省佳木斯市",
"86182857", "贵州省毕节地区",
"861363843", "湖南省株洲市",
"861535203", "甘肃省定西市",
"861850508", "福建省龙岩市",
"861864805", "内蒙古兴安盟",
"86180896", "贵州省遵义市",
"861843274", "河北省邯郸市",
"861533477", "内蒙古鄂尔多斯市",
"861323853", "贵州省六盘水市",
"861335319", "吉林省长春市",
"86157007", "湖南省长沙市",
"86138901", "四川省绵阳市",
"861537498", "内蒙古锡林郭勒盟",
"861810345", "山西省长治市",
"861479456", "黑龙江省黑河市",
"86155259", "山西省临汾市",
"861803785", "河南省驻马店市",
"861576856", "广东省深圳市",
"861317306", "山东省枣庄市",
"861471894", "西藏林芝地区",
"861501472", "广东省佛山市",
"861809981", "新疆伊犁哈萨克自治州",
"861850662", "广东省阳江市",
"861857279", "湖北省武汉市",
"861303343", "山西省晋中市",
"861800036", "河北省廊坊市",
"861808739", "云南省红河哈尼族彝族自治州",
"861858780", "广西河池市",
"861809874", "安徽省六安市",
"861860523", "江苏省泰州市",
"861705622", "黑龙江省哈尔滨市",
"861454367", "山东省枣庄市",
"861557248", "湖北省荆门市",
"861897290", "湖北省荆门市",
"861865690", "安徽省六安市",
"861552870", "四川省宜宾市",
"861339745", "湖南省怀化市",
"861594898", "吉林省辽源市",
"861333941", "黑龙江省哈尔滨市",
"861800025", "江西省宜春市",
"861803294", "河北省石家庄市",
"861839383", "甘肃省天水市",
"861838908", "西藏日喀则地区",
"861869374", "甘肃省兰州市",
"861390477", "内蒙古鄂尔多斯市",
"86170883", "重庆市",
"861524132", "辽宁省抚顺市",
"86147275", "贵州省贵阳市",
"861856708", "河南省焦作市",
"861322095", "山东省聊城市",
"861568219", "四川省南充市",
"861392264", "广东省肇庆市",
"861882433", "广东省东莞市",
"861860849", "湖南省邵阳市",
"861818735", "云南省红河哈尼族彝族自治州",
"86159667", "山东省枣庄市",
"861342978", "陕西省宝鸡市",
"861356177", "山东省泰安市",
"861820859", "贵州省黔西南布依族苗族自治州",
"861310158", "黑龙江省哈尔滨市",
"861550481", "内蒙古呼和浩特市",
"861892334", "广东省中山市",
"861300466", "浙江省金华市",
"861378173", "河南省漯河市",
"861589237", "四川省广安市",
"861459520", "云南省德宏傣族景颇族自治州",
"86138572", "浙江省湖州市",
"861560363", "黑龙江省牡丹江市",
"861301683", "江苏省镇江市",
"86156412", "辽宁省鞍山市",
"861568794", "云南省临沧市",
"861454139", "河北省邢台市",
"861800349", "山西省朔州市",
"861500863", "宁夏中卫市",
"861536498", "山西省运城市",
"861899152", "陕西省安康市",
"861839506", "宁夏固原市",
"861343792", "江西省九江市",
"86187918", "陕西省榆林市",
"86176654", "广东省广州市",
"861335385", "河南省周口市",
"86189092", "陕西省西安市",
"861355311", "山东省烟台市",
"861596046", "福建省宁德市",
"86182396", "河南省驻马店市",
"861898578", "贵州省黔南布依族苗族自治州",
"861826649", "山东省滨州市",
"86147512", "江苏省南京市",
"86187713", "湖北省随州市",
"861553384", "河北省衡水市",
"86919", "陕西省铜川市",
"861847152", "湖北省黄石市",
"861590685", "浙江省绍兴市",
"86155478", "内蒙古巴彦淖尔市",
"861472784", "陕西省西安市",
"861576019", "四川省内江市",
"861530415", "辽宁省丹东市",
"861810777", "广西钦州市",
"86155330", "河北省邯郸市",
"861328343", "河北省邯郸市",
"86134547", "浙江省宁波市",
"861855580", "安徽省马鞍山市",
"861376924", "云南省大理白族自治州",
"861597339", "湖南省衡阳市",
"86158321", "河北省石家庄市",
"861809645", "安徽省安庆市",
"861839930", "新疆伊犁哈萨克自治州",
"861534937", "甘肃省酒泉市",
"86178537", "山东省济宁市",
"861820809", "西藏日喀则地区",
"861358696", "浙江省金华市",
"861331345", "山西省长治市",
"861316356", "黑龙江省鸡西市",
"861879154", "陕西省榆林市",
"861899976", "新疆博尔塔拉蒙古自治州",
"861814359", "贵州省黔南布依族苗族自治州",
"861367938", "甘肃省天水市",
"861348485", "陕西省汉中市",
"861524570", "黑龙江省哈尔滨市",
"861318940", "广东省江门市",
"861521870", "广东省深圳市",
"86150969", "云南省大理白族自治州",
"86177743", "湖南省湘西土家族苗族自治州",
"861393489", "山西省运城市",
"86182577", "浙江省温州市",
"861305643", "四川省南充市",
"861514182", "辽宁省阜新市",
"861519678", "四川省南充市",
"861850943", "甘肃省白银市",
"861839556", "安徽省马鞍山市",
"861346944", "湖南省长沙市",
"861533134", "四川省成都市",
"861334043", "福建省厦门市",
"86180357", "山西省临汾市",
"861861774", "河北省沧州市",
"861360098", "福建省龙岩市",
"86181976", "新疆喀什地区",
"861571903", "新疆博尔塔拉蒙古自治州",
"86151290", "陕西省西安市",
"861868040", "广东省东莞市",
"86177225", "广东省深圳市",
"861561582", "山东省东营市",
"861452699", "陕西省铜川市",
"86135567", "广东省东莞市",
"861314348", "河北省石家庄市",
"861810998", "新疆喀什地区",
"861525668", "安徽省滁州市",
"861322141", "浙江省杭州市",
"861512984", "陕西省渭南市",
"861818781", "云南省昆明市",
"861570936", "甘肃省张掖市",
"86182776", "广西百色市",
"861362151", "江苏省无锡市",
"861771885", "广东省湛江市",
"861300308", "安徽省合肥市",
"861379632", "黑龙江省齐齐哈尔市",
"861564882", "内蒙古赤峰市",
"861594764", "内蒙古赤峰市",
"861550435", "吉林省通化市",
"861502914", "陕西省西安市",
"861580958", "宁夏银川市",
"861820099", "广东省广州市",
"861303680", "广西贵港市",
"861812713", "广东省佛山市",
"86187171", "湖北省武汉市",
"861353639", "广东省湛江市",
"861898037", "四川省眉山市",
"861370084", "河南省郑州市",
"861539357", "甘肃省金昌市",
"861301402", "安徽省六安市",
"861508368", "江西省鹰潭市",
"86136520", "天津市",
"861566612", "山东省滨州市",
"86184603", "江西省赣州市",
"861847824", "湖南省娄底市",
"861570550", "安徽省滁州市",
"861302345", "江苏省镇江市",
"861338949", "甘肃省陇南市",
"861471842", "广东省茂名市",
"86137000", "辽宁省沈阳市",
"861568868", "山东省威海市",
"861859162", "陕西省汉中市",
"861363738", "湖南省娄底市",
"86189352", "山西省大同市",
"861773469", "陕西省渭南市",
"861348496", "陕西省延安市",
"86189608", "福建省福州市",
"861335273", "广东省揭阳市",
"861775101", "江苏省南京市",
"861835261", "江苏省泰州市",
"861320848", "黑龙江省大庆市",
"861384982", "河南省三门峡市",
"86139946", "山西省长治市",
"86156626", "山东省济南市",
"86151152", "湖南省怀化市",
"86177220", "广东省珠海市",
"861337741", "广西梧州市",
"861588140", "四川省泸州市",
"861760669", "广东省东莞市",
"861899824", "广东省汕头市",
"861571953", "宁夏吴忠市",
"861335115", "黑龙江省绥化市",
"86187931", "甘肃省兰州市",
"861337232", "浙江省嘉兴市",
"861306972", "黑龙江省哈尔滨市",
"861810149", "江苏省常州市",
"861310247", "河北省廊坊市",
"861876240", "江苏省南京市",
"861322086", "山东省青岛市",
"861365518", "江苏省南京市",
"861599119", "陕西省安康市",
"861300427", "浙江省湖州市",
"861772284", "广东省深圳市",
"861804109", "辽宁省沈阳市",
"861580908", "新疆克孜勒苏柯尔克孜自治州",
"86131123", "广东省珠海市",
"861351855", "贵州省黔东南苗族侗族自治州",
"861372233", "河北省张家口市",
"861525552", "安徽省马鞍山市",
"861786541", "山东省济南市",
"861458623", "湖北省黄冈市",
"861576473", "内蒙古乌海市",
"861816915", "宁夏吴忠市",
"86150662", "山东省青岛市",
"861361244", "广东省潮州市",
"861572849", "广东省广州市",
"86136525", "广东省东莞市",
"861529293", "新疆喀什地区",
"861846220", "山东省潍坊市",
"861596311", "山东省济南市",
"861809018", "四川省泸州市",
"861330541", "山东省济南市",
"861539307", "甘肃省天水市",
"861323476", "内蒙古赤峰市",
"861355046", "四川省巴中市",
"861335396", "河南省驻马店市",
"861368595", "福建省龙岩市",
"861887253", "湖北省宜昌市",
"861351141", "浙江省衢州市",
"861570500", "内蒙古兴安盟",
"861868252", "四川省遂宁市",
"861570991", "新疆乌鲁木齐市",
"861390082", "重庆市",
"861582667", "湖北省恩施土家族苗族自治州",
"861376876", "广西玉林市",
"861829989", "新疆喀什地区",
"861515408", "山东省枣庄市",
"861454326", "内蒙古呼伦贝尔市",
"861775151", "江苏省无锡市",
"861582945", "陕西省安康市",
"861362674", "浙江省宁波市",
"861530722", "湖北省武汉市",
"861332683", "广东省江门市",
"861590631", "山东省威海市",
"861523873", "河南省焦作市",
"861333328", "河北省秦皇岛市",
"861308093", "陕西省西安市",
"861813567", "河南省郑州市",
"861859706", "青海省玉树藏族自治州",
"861302981", "黑龙江省大庆市",
"86153865", "四川省乐山市",
"861523502", "山西省忻州市",
"86180756", "湖南省常德市",
"861572465", "辽宁省铁岭市",
"86159536", "山东省潍坊市",
"861360067", "浙江省温州市",
"861344076", "上海市",
"861479668", "江西省赣州市",
"861577028", "云南省保山市",
"861454635", "宁夏吴忠市",
"861311758", "湖南省娄底市",
"861378448", "河北省衡水市",
"861873401", "安徽省安庆市",
"861523668", "河南省洛阳市",
"861590628", "江苏省南通市",
"861593177", "河北省保定市",
"861857140", "湖北省荆州市",
"861597198", "湖北省武汉市",
"861479502", "宁夏石嘴山市",
"861855543", "安徽省淮北市",
"861530248", "广东省广州市",
"861709291", "陕西省榆林市",
"86189552", "安徽省蚌埠市",
"861807099", "广西玉林市",
"861365738", "湖南省娄底市",
"86139635", "山东省聊城市",
"861311064", "福建省福州市",
"861477327", "湖南省永州市",
"861518197", "四川省泸州市",
"8614758", "广东省广州市",
"861534554", "安徽省淮南市",
"861809998", "新疆喀什地区",
"861539496", "云南省普洱市",
"861327308", "河南省三门峡市",
"861820641", "山东省济南市",
"861453509", "山东省日照市",
"861890302", "广东省深圳市",
"861860651", "浙江省杭州市",
"86150732", "湖南省湘潭市",
"861334080", "四川省自贡市",
"861308913", "吉林省长春市",
"861800939", "甘肃省陇南市",
"86153584", "江苏省苏州市",
"861594974", "山东省淄博市",
"861870354", "山西省晋中市",
"861889063", "湖南省湘西土家族苗族自治州",
"861594720", "内蒙古呼伦贝尔市",
"861566034", "新疆阿克苏地区",
"86182797", "江西省赣州市",
"861537481", "内蒙古兴安盟",
"861318983", "广东省湛江市",
"861573810", "河南省商丘市",
"861802846", "广东省惠州市",
"86153860", "湖南省衡阳市",
"861810018", "浙江省杭州市",
"861556489", "山东省青岛市",
"861316540", "山东省聊城市",
"861539431", "浙江省宁波市",
"861870547", "山东省济宁市",
"861304473", "河南省洛阳市",
"861577916", "江西省吉安市",
"861348544", "山西省吕梁市",
"861587672", "广东省梅州市",
"861564376", "吉林省辽源市",
"861350263", "广东省潮州市",
"86187483", "内蒙古呼伦贝尔市",
"861598414", "四川省宜宾市",
"861362469", "黑龙江省双鸭山市",
"861536467", "山西省临汾市",
"86137462", "黑龙江省齐齐哈尔市",
"861820919", "陕西省铜川市",
"861538684", "山西省晋中市",
"861873451", "山西省长治市",
"861891458", "江苏省镇江市",
"861363721", "安徽省宣城市",
"86152619", "江苏省盐城市",
"861311708", "湖北省黄冈市",
"861839340", "甘肃省临夏回族自治州",
"861859090", "陕西省汉中市",
"86183621", "江苏省南通市",
"861806341", "山东省济南市",
"86156211", "山东省青岛市",
"86138792", "江西省九江市",
"861452186", "吉林省延边朝鲜族自治州",
"861878617", "贵州省遵义市",
"861881216", "河北省廊坊市",
"861331935", "江西省宜春市",
"861534504", "福建省福州市",
"861899860", "广东省清远市",
"861335328", "吉林省吉林市",
"861335457", "黑龙江省大兴安岭地区",
"861809149", "陕西省宝鸡市",
"861309247", "江苏省宿迁市",
"861584616", "黑龙江省大庆市",
"861367348", "河南省信阳市",
"861561421", "河北省保定市",
"861835780", "浙江省温州市",
"861890352", "山西省大同市",
"861860601", "福建省福州市",
"861513408", "辽宁省辽阳市",
"86153188", "山东省济南市",
"861327427", "辽宁省盘锦市",
"861340614", "山东省东营市",
"86187038", "河南省郑州市",
"861811177", "四川省广元市",
"861454398", "贵州省六盘水市",
"861528047", "福建省泉州市",
"861777013", "江西省赣州市",
"86136325", "广东省深圳市",
"861318330", "河南省南阳市",
"861760474", "内蒙古乌兰察布市",
"861333396", "河南省驻马店市",
"861346334", "河北省承德市",
"861302270", "山东省淄博市",
"861319427", "辽宁省盘锦市",
"861872942", "陕西省榆林市",
"86133066", "浙江省宁波市",
"861319358", "河南省濮阳市",
"861330434", "吉林省四平市",
"861521966", "广东省云浮市",
"861870304", "新疆塔城地区",
"861532255", "广东省汕头市",
"861592956", "陕西省西安市",
"861386652", "安徽省滁州市",
"861582698", "湖北省黄石市",
"861590319", "河北省邢台市",
"861309158", "黑龙江省鸡西市",
"861336549", "山东省临沂市",
"861778109", "四川省凉山彝族自治州",
"861876283", "江苏省常州市",
"861572174", "贵州省毕节地区",
"861591526", "广东省茂名市",
"861858287", "四川省成都市",
"86155535", "山东省烟台市",
"861339053", "辽宁省大连市",
"86158142", "广东省东莞市",
"861834546", "黑龙江省佳木斯市",
"861458501", "河南省信阳市",
"861308130", "辽宁省抚顺市",
"861537435", "江西省宜春市",
"861459564", "陕西省渭南市",
"86188060", "福建省三明市",
"861570346", "山西省晋城市",
"861532576", "浙江省台州市",
"861567182", "湖北省咸宁市",
"86185623", "山东省泰安市",
"861831846", "广东省韶关市",
"861812658", "广东省肇庆市",
"861327466", "黑龙江省齐齐哈尔市",
"861816855", "江苏省泰州市",
"861519863", "云南省文山壮族苗族自治州",
"861575900", "福建省龙岩市",
"861315023", "新疆巴音郭楞蒙古自治州",
"861780823", "四川省遂宁市",
"861596639", "山东省滨州市",
"861388997", "广东省东莞市",
"861826036", "江苏省徐州市",
"861450959", "江苏省宿迁市",
"861864577", "黑龙江省牡丹江市",
"861362793", "江西省上饶市",
"861576999", "云南省保山市",
"861391236", "江苏省无锡市",
"861569570", "浙江省衢州市",
"861840566", "安徽省池州市",
"861880684", "浙江省宁波市",
"86135636", "山东省潍坊市",
"861554807", "内蒙古通辽市",
"861816141", "四川省内江市",
"861810874", "云南省曲靖市",
"861331270", "云南省西双版纳傣族自治州",
"861585662", "安徽省池州市",
"861317656", "山东省淄博市",
"861572601", "山东省菏泽市",
"861339677", "浙江省温州市",
"861708879", "广东省茂名市",
"861302935", "辽宁省锦州市",
"861571813", "广东省东莞市",
"861350414", "辽宁省本溪市",
"861338339", "河北省邢台市",
"86151281", "河北省石家庄市",
"861806928", "浙江省舟山市",
"861830313", "河北省张家口市",
"861536426", "湖南省衡阳市",
"861780549", "山东省临沂市",
"861391449", "江苏省南京市",
"86138372", "河南省安阳市",
"86135444", "广东省广州市",
"861768379", "湖北省孝感市",
"86184879", "云南省西双版纳傣族自治州",
"861520952", "宁夏石嘴山市",
"861454681", "广东省广州市",
"861560942", "甘肃省定西市",
"861334705", "内蒙古通辽市",
"86150288", "河北省邢台市",
"861819025", "四川省阿坝藏族羌族自治州",
"861522507", "河南省郑州市",
"86152912", "陕西省榆林市",
"861550522", "江苏省宿迁市",
"861777479", "广西北海市",
"861899766", "新疆阿克苏地区",
"861778159", "四川省乐山市",
"861328962", "陕西省汉中市",
"861309108", "河北省唐山市",
"861592906", "陕西省延安市",
"86158521", "江苏省徐州市",
"86188065", "浙江省台州市",
"861856020", "山东省济南市",
"861458551", "山东省聊城市",
"86155530", "山东省菏泽市",
"86134347", "广东省深圳市",
"861390253", "广东省珠海市",
"861860465", "黑龙江省绥化市",
"861322915", "广东省惠州市",
"861386568", "安徽省蚌埠市",
"86151712", "湖北省孝感市",
"861888248", "四川省绵阳市",
"861508397", "江西省新余市",
"86182596", "福建省漳州市",
"861350232", "广东省河源市",
"86151069", "山东省济南市",
"861555384", "山东省东营市",
"861576148", "贵州省六盘水市",
"861807809", "广西梧州市",
"86180557", "安徽省宿州市",
"861782850", "四川省阿坝藏族羌族自治州",
"861535134", "四川省广安市",
"861580818", "四川省达州市",
"861502854", "河北省承德市",
"86134208", "广东省佛山市",
"861572651", "山东省聊城市",
"861317606", "山东省潍坊市",
"861599615", "江苏省淮安市",
"86159737", "湖南省益阳市",
"86182377", "河南省南阳市",
"861303643", "四川省泸州市",
"861316497", "浙江省宁波市",
"86145386", "云南省昆明市",
"861368729", "湖北省襄樊市",
"861308572", "广东省清远市",
"861376960", "云南省文山壮族苗族自治州",
"861304019", "江苏省淮安市",
"861816086", "安徽省滁州市",
"861357541", "浙江省温州市",
"861334755", "广西玉林市",
"861810967", "安徽省阜阳市",
"861530157", "江苏省苏州市",
"861520902", "新疆哈密地区",
"861809777", "新疆阿克苏地区",
"861585558", "安徽省阜阳市",
"861317949", "江苏省镇江市",
"861580577", "浙江省温州市",
"861897875", "广西河池市",
"861534673", "甘肃省平凉市",
"861331261", "云南省楚雄彝族自治州",
"861831273", "广东省湛江市",
"861319048", "辽宁省本溪市",
"861509082", "湖北省荆州市",
"861452301", "河南省商丘市",
"861360564", "安徽省六安市",
"861830581", "浙江省杭州市",
"86182528", "江苏省南通市",
"861591708", "广东省阳江市",
"861528428", "河北省邢台市",
"861328282", "浙江省杭州市",
"861327048", "江苏省徐州市",
"861369959", "江西省抚州市",
"861318414", "山东省青岛市",
"861329949", "广西柳州市",
"861367058", "广东省揭阳市",
"861805402", "安徽省安庆市",
"86138262", "广东省广州市",
"86137571", "浙江省杭州市",
"861308484", "陕西省榆林市",
"861869321", "甘肃省定西市",
"861559406", "甘肃省张掖市",
"861538376", "河北省廊坊市",
"861596540", "山东省滨州市",
"861458516", "河南省洛阳市",
"861330310", "河北省邯郸市",
"861527012", "江西省鹰潭市",
"861832643", "安徽省宣城市",
"861866129", "江苏省无锡市",
"861884942", "河北省保定市",
"861380392", "河南省鹤壁市",
"861311567", "黑龙江省大庆市",
"86137785", "四川省自贡市",
"86156858", "贵州省六盘水市",
"861764065", "辽宁省鞍山市",
"861705102", "上海市",
"861847622", "广东省河源市",
"861376280", "湖南省娄底市",
"861598330", "四川省眉山市",
"861505657", "安徽省合肥市",
"861822046", "陕西省汉中市",
"861707927", "浙江省舟山市",
"861471644", "广东省广州市",
"861310189", "江苏省南京市",
"861810287", "广东省汕尾市",
"861569561", "安徽省淮北市",
"86150046", "黑龙江省哈尔滨市",
"861524076", "广西百色市",
"861813758", "河南省平顶山市",
"861457019", "山东省聊城市",
"861898441", "贵州省六盘水市",
"861324268", "广东省珠海市",
"861393408", "山西省晋中市",
"861570831", "四川省宜宾市",
"861500634", "山东省莱芜市",
"861591279", "云南省西双版纳傣族自治州",
"861780630", "山东省威海市",
"861450646", "黑龙江省伊春市",
"861332539", "陕西省铜川市",
"861839796", "江西省吉安市",
"861470467", "黑龙江省鸡西市",
"86151630", "山东省菏泽市",
"861314867", "广东省阳江市",
"861317198", "河北省沧州市",
"861866688", "广东省东莞市",
"861452351", "河南省周口市",
"861370493", "辽宁省抚顺市",
"861803640", "江苏省宿迁市",
"861586345", "山东省青岛市",
"861359853", "河南省焦作市",
"861573751", "河南省周口市",
"861538293", "广东省汕头市",
"86130717", "河南省平顶山市",
"861591758", "广东省湛江市",
"861818362", "云南省临沧市",
"86182267", "安徽省芜湖市",
"861302743", "湖南省长沙市",
"861310628", "浙江省丽水市",
"86131536", "山东省潍坊市",
"86152464", "黑龙江省佳木斯市",
"861502597", "甘肃省天水市",
"861805452", "山东省济宁市",
"861858645", "贵州省铜仁地区",
"861855141", "江苏省南京市",
"86182124", "贵州省黔东南苗族侗族自治州",
"861520614", "江苏省常州市",
"861836767", "浙江省台州市",
"861592911", "陕西省延安市",
"861825254", "江苏省扬州市",
"861865244", "江苏省苏州市",
"861554594", "黑龙江省鹤岗市",
"861345873", "四川省泸州市",
"861375579", "江西省南昌市",
"86139604", "福建省泉州市",
"861890250", "广东省湛江市",
"861314720", "湖北省鄂州市",
"861855855", "福建省莆田市",
"861705152", "安徽省合肥市",
"861843295", "河北省秦皇岛市",
"861362872", "云南省大理白族自治州",
"861598983", "广东省汕头市",
"86137780", "四川省绵阳市",
"86147560", "河北省邯郸市",
"861586029", "福建省福州市",
"86188639", "山东省青岛市",
"86157322", "河北省保定市",
"861476248", "江苏省盐城市",
"861861518", "山东省济南市",
"861314974", "辽宁省锦州市",
"861378027", "河北省沧州市",
"861567210", "湖北省十堰市",
"86134619", "河南省南阳市",
"861814388", "西藏拉萨市",
"861500992", "新疆伊犁哈萨克自治州",
"861318741", "云南省昆明市",
"86137353", "浙江省绍兴市",
"861320367", "湖南省益阳市",
"861528544", "贵州省铜仁地区",
"861850515", "江苏省盐城市",
"861343552", "广东省河源市",
"861317611", "山东省菏泽市",
"86151635", "山东省聊城市",
"861824695", "黑龙江省大庆市",
"861812196", "四川省成都市",
"86155869", "湖北省十堰市",
"86150615", "江苏省无锡市",
"861340952", "宁夏石嘴山市",
"861802396", "广东省茂名市",
"861570885", "云南省怒江傈僳族自治州",
"861859528", "山东省泰安市",
"86137093", "福建省漳州市",
"861459067", "广东省云浮市",
"86184690", "云南省曲靖市",
"861760438", "吉林省松原市",
"861370769", "河南省洛阳市",
"861896934", "浙江省嘉兴市",
"861760582", "浙江省湖州市",
"861893449", "贵州省毕节地区",
"861350983", "广东省东莞市",
"861330478", "内蒙古巴彦淖尔市",
"861580989", "辽宁省葫芦岛市",
"86137709", "江苏省南京市",
"861806891", "江苏省泰州市",
"861778125", "四川省乐山市",
"861898907", "西藏阿里地区",
"861331743", "湖南省湘西土家族苗族自治州",
"861534897", "西藏阿里地区",
"861705824", "北京市",
"861817908", "江西省赣州市",
"861331372", "福建省宁德市",
"861889812", "河南省开封市",
"861802115", "江苏省无锡市",
"861334729", "湖南省邵阳市",
"861772920", "陕西省延安市",
"861533443", "云南省曲靖市",
"861327615", "江苏省镇江市",
"861819009", "四川省德阳市",
"861772774", "广东省东莞市",
"861570006", "浙江省杭州市",
"861878425", "四川省巴中市",
"861812185", "四川省德阳市",
"861328745", "山东省烟台市",
"86155108", "天津市",
"861361690", "福建省龙岩市",
"86135277", "广东省广州市",
"861843286", "河北省廊坊市",
"861333846", "福建省厦门市",
"861319615", "吉林省通化市",
"86131737", "浙江省台州市",
"861869199", "陕西省榆林市",
"861829908", "新疆石河子市",
"861454848", "广东省深圳市",
"861355540", "黑龙江省牡丹江市",
"861357143", "陕西省安康市",
"861808162", "四川省凉山彝族自治州",
"861830535", "山东省烟台市",
"861377569", "江苏省泰州市",
"86151203", "贵州省遵义市",
"861893236", "江苏省扬州市",
"861309685", "贵州省黔东南苗族侗族自治州",
"861522004", "广东省广州市",
"861360889", "云南省玉溪市",
"861458103", "安徽省亳州市",
"861470426", "辽宁省盘锦市",
"861814636", "青海省海西蒙古族藏族自治州",
"861365774", "广西梧州市",
"861375987", "陕西省西安市",
"861335783", "江苏省南京市",
"861337940", "陕西省咸阳市",
"861340902", "山东省日照市",
"861588581", "贵州省黔东南苗族侗族自治州",
"86150610", "江苏省泰州市",
"86184695", "云南省丽江市",
"861896692", "陕西省西安市",
"861899871", "广东省湛江市",
"861339772", "广西柳州市",
"861476107", "江苏省常州市",
"861551768", "河南省濮阳市",
"861816829", "江苏省扬州市",
"861769241", "河北省石家庄市",
"861594938", "广西桂林市",
"861350330", "河北省邯郸市",
"86152208", "广东省韶关市",
"861561669", "湖南省衡阳市",
"86158956", "江苏省苏州市",
"861880376", "河南省信阳市",
"861302261", "浙江省湖州市",
"861313749", "河南省三门峡市",
"861770953", "宁夏吴忠市",
"86170899", "广东省珠海市",
"861310319", "河北省邢台市",
"861575193", "甘肃省白银市",
"861893291", "河北省石家庄市",
"861868546", "贵州省铜仁地区",
"861311526", "江苏省盐城市",
"861537168", "江苏省连云港市",
"861364339", "河北省保定市",
"861771500", "江苏省南通市",
"861802331", "广东省清远市",
"861509477", "山东省泰安市",
"861771991", "河南省许昌市",
"861818271", "黑龙江省哈尔滨市",
"861301539", "山西省大同市",
"861886480", "山东省泰安市",
"86139281", "广东省中山市",
"861351580", "浙江省舟山市",
"861368705", "江西省宜春市",
"861570056", "四川省广元市",
"861839785", "江西省宜春市",
"861833981", "河南省郑州市",
"861363964", "河南省驻马店市",
"861362621", "江苏省盐城市",
"861881201", "河北省石家庄市",
"861354880", "湖南省娄底市",
"861867049", "湖南省长沙市",
"861525246", "江苏省南京市",
"861501229", "云南省昭通市",
"861829958", "新疆阿克苏地区",
"861570790", "江西省新余市",
"861582513", "云南省玉溪市",
"861859444", "福建省宁德市",
"861587998", "江西省景德镇市",
"861776748", "新疆哈密地区",
"861857422", "河南省信阳市",
"861339343", "山西省太原市",
"86155504", "山东省济南市",
"861774800", "四川省达州市",
"861860616", "江苏省徐州市",
"861312530", "江西省上饶市",
"861334353", "湖北省宜昌市",
"861864958", "山西省吕梁市",
"861317339", "山东省菏泽市",
"861824948", "黑龙江省鸡西市",
"861556408", "山东省滨州市",
"861387200", "湖北省黄冈市",
"861880882", "云南省昭通市",
"861398168", "四川省巴中市",
"861808706", "云南省昆明市",
"861505592", "安徽省淮南市",
"861895449", "山东省聊城市",
"861803683", "江苏省苏州市",
"861328677", "广东省梅州市",
"861306335", "安徽省淮北市",
"861311789", "江西省赣州市",
"861310685", "广东省东莞市",
"86156698", "浙江省温州市",
"86170801", "北京市",
"861814049", "四川省资阳市",
"861366835", "四川省内江市",
"861479792", "江西省九江市",
"861768194", "浙江省金华市",
"861301719", "湖南省长沙市",
"861522978", "陕西省汉中市",
"861362638", "山东省淄博市",
"861316046", "江苏省南京市",
"861866625", "广东省阳江市",
"861331055", "湖北省恩施土家族苗族自治州",
"861857581", "广东省肇庆市",
"861457207", "四川省绵阳市",
"861344132", "江苏省南京市",
"861572399", "广西防城港市",
"861829269", "陕西省商洛市",
"861367826", "四川省广安市",
"861867636", "广东省深圳市",
"861858998", "广西柳州市",
"861335846", "福建省南平市",
"86137415", "辽宁省丹东市",
"861588422", "四川省资阳市",
"86187202", "江西省九江市",
"861811023", "安徽省蚌埠市",
"86130316", "山东省烟台市",
"861769512", "宁夏石嘴山市",
"861831941", "广东省深圳市",
"861301294", "山东省青岛市",
"861814325", "西藏昌都地区",
"861850781", "广西南宁市",
"861317167", "河北省保定市",
"861365877", "云南省玉溪市",
"861587018", "贵州省铜仁地区",
"861705860", "广东省广州市",
"861535443", "河北省保定市",
"861370979", "青海省海西蒙古族藏族自治州",
"861308545", "湖南省湘西土家族苗族自治州",
"861523439", "山西省吕梁市",
"861556458", "山东省威海市",
"86130487", "广东省惠州市",
"861589641", "江苏省扬州市",
"861833345", "河北省邢台市",
"861334303", "河北省石家庄市",
"861831619", "广东省肇庆市",
"861830715", "湖北省咸宁市",
"861510477", "内蒙古鄂尔多斯市",
"861700576", "浙江省台州市",
"86137791", "新疆伊犁哈萨克自治州",
"861772877", "广东省阳江市",
"861528485", "四川省广元市",
"861311598", "福建省三明市",
"861347678", "湖北省黄石市",
"861841439", "内蒙古兴安盟",
"861576839", "广东省深圳市",
"861333783", "江苏省南京市",
"86130157", "福建省福州市",
"86153812", "浙江省嘉兴市",
"861859531", "河南省驻马店市",
"861534794", "江西省抚州市",
"861339962", "安徽省铜陵市",
"861369819", "四川省德阳市",
"861362395", "河南省漯河市",
"861358247", "河北省沧州市",
"861327389", "河南省平顶山市",
"861365964", "广西梧州市",
"86152547", "山东省济宁市",
"861453432", "辽宁省鞍山市",
"86137410", "辽宁省铁岭市",
"86155304", "河北省沧州市",
"861334586", "浙江省台州市",
"861829074", "新疆石河子市",
"861309319", "江苏省常州市",
"861596306", "山东省济宁市",
"86170952", "江苏省无锡市",
"86131667", "辽宁省沈阳市",
"861760421", "辽宁省朝阳市",
"861320635", "山东省聊城市",
"861560975", "青海省果洛藏族自治州",
"861321739", "湖南省邵阳市",
"86138461", "黑龙江省佳木斯市",
"861380644", "山东省青岛市",
"861867118", "湖北省十堰市",
"861319389", "河南省信阳市",
"861801680", "新疆博尔塔拉蒙古自治州",
"86159123", "云南省文山壮族苗族自治州",
"861771346", "四川省广元市",
"861894464", "黑龙江省七台河市",
"86137371", "广西南宁市",
"861309189", "黑龙江省哈尔滨市",
"861367720", "湖北省荆州市",
"861850735", "湖南省郴州市",
"861877450", "湖南省邵阳市",
"86176253", "江苏省苏州市",
"86139482", "内蒙古兴安盟",
"86189463", "黑龙江省牡丹江市",
"861351829", "四川省南充市",
"861357478", "湖南省衡阳市",
"861319119", "山西省运城市",
"861458791", "湖南省张家界市",
"861803402", "河北省保定市",
"86152746", "湖南省永州市",
"861889902", "新疆伊犁哈萨克自治州",
"861450988", "新疆阿勒泰地区",
"861328893", "河北省保定市",
"861590247", "辽宁省辽阳市",
"861575701", "浙江省杭州市",
"86182328", "河北省沧州市",
"861530627", "江苏省南通市",
"861815064", "福建省福州市",
"861533178", "云南省西双版纳傣族自治州",
"86139152", "江苏省无锡市",
"861827217", "湖北省黄石市",
"86139295", "广东省广州市",
"861705766", "上海市",
"861327119", "河南省许昌市",
"861342692", "广东省潮州市",
"861364611", "江苏省常州市",
"861778629", "湖北省孝感市",
"861813020", "安徽省淮北市",
"861882879", "四川省泸州市",
"861351543", "山东省滨州市",
"861552861", "四川省南充市",
"861331895", "广东省珠海市",
"86152965", "广西南宁市",
"861397293", "湖北省武汉市",
"861365693", "福建省龙岩市",
"861370587", "浙江省温州市",
"861324909", "广东省深圳市",
"861345502", "山东省日照市",
"861898534", "贵州省铜仁地区",
"861330143", "江苏省泰州市",
"861360520", "江苏省徐州市",
"861575030", "云南省普洱市",
"861888666", "四川省广元市",
"861366881", "山东省济南市",
"861848584", "贵州省毕节地区",
"861452437", "辽宁省鞍山市",
"86188012", "北京市",
"861300048", "北京市",
"861839511", "宁夏银川市",
"861808800", "云南省丽江市",
"86151765", "河北省唐山市",
"861560230", "广东省广州市",
"861344163", "河北省邯郸市",
"861777150", "湖北省咸宁市",
"861503657", "河南省洛阳市",
"86184850", "贵州省贵阳市",
"86147365", "云南省昆明市",
"861339380", "河南省开封市",
"861334595", "浙江省宁波市",
"86184681", "云南省昆明市",
"861354843", "四川省绵阳市",
"861569076", "河南省商丘市",
"861778188", "四川省宜宾市",
"861524561", "黑龙江省哈尔滨市",
"861337330", "河北省邯郸市",
"861314764", "吉林省长春市",
"861519992", "新疆巴音郭楞蒙古自治州",
"861343873", "四川省乐山市",
"861310696", "广东省江门市",
"861826530", "山东省菏泽市",
"861358108", "山东省临沂市",
"861302055", "山东省聊城市",
"861821476", "安徽省淮南市",
"861538882", "云南省德宏傣族景颇族自治州",
"861332719", "内蒙古包头市",
"861571190", "广东省广州市",
"861539047", "四川省凉山彝族自治州",
"861331780", "广西南宁市",
"861575751", "浙江省杭州市",
"861815279", "湖南省娄底市",
"861889952", "新疆乌鲁木齐市",
"861559397", "甘肃省白银市",
"861835935", "福建省宁德市",
"861385216", "江苏省扬州市",
"86139290", "广东省江门市",
"861362553", "安徽省芜湖市",
"861367867", "山东省济宁市",
"861322543", "山东省滨州市",
"861329126", "江苏省南京市",
"861570828", "四川省自贡市",
"861361923", "陕西省渭南市",
"861707870", "云南省红河哈尼族彝族自治州",
"861831328", "云南省普洱市",
"861818943", "甘肃省白银市",
"861802941", "广东省江门市",
"86152960", "广西河池市",
"861309628", "四川省德阳市",
"861860399", "河南省许昌市",
"861787610", "广东省惠州市",
"861364949", "广西玉林市",
"861830422", "辽宁省葫芦岛市",
"861332294", "广东省云浮市",
"861528431", "河北省石家庄市",
"861896557", "福建省莆田市",
"86137553", "江西省上饶市",
"861779746", "青海省海西蒙古族藏族自治州",
"861533480", "内蒙古呼伦贝尔市",
"861473684", "云南省临沧市",
"861314058", "河南省新乡市",
"861339933", "甘肃省平凉市",
"861777100", "湖北省襄樊市",
"861586981", "湖南省郴州市",
"861800899", "西藏拉萨市",
"861529684", "广西玉林市",
"86132017", "陕西省西安市",
"861340812", "四川省攀枝花市",
"86151760", "河北省邯郸市",
"861585589", "安徽省亳州市",
"861322829", "陕西省渭南市",
"861453463", "黑龙江省大兴安岭地区",
"861459098", "广东省梅州市",
"86147360", "广西百色市",
"86184855", "贵州省黔东南苗族侗族自治州",
"861369831", "四川省内江市",
"861322958", "广东省惠州市",
"861538676", "山西省晋城市",
"861869621", "湖北省襄樊市",
"861552887", "四川省达州市",
"861370561", "安徽省淮北市",
"861870573", "浙江省嘉兴市",
"861859519", "宁夏固原市",
"861840879", "云南省普洱市",
"86151084", "四川省成都市",
"861301050", "海南省海口市",
"861843238", "河北省衡水市",
"861330610", "江苏省镇江市",
"86156430", "吉林省长春市",
"861304447", "山西省阳泉市",
"861532869", "四川省德阳市",
"861366867", "山东省济宁市",
"861893288", "河北省承德市",
"861471507", "广东省湛江市",
"86134405", "上海市",
"861348702", "湖北省黄冈市",
"861805275", "江苏省镇江市",
"861310407", "黑龙江省哈尔滨市",
"861588598", "贵州省黔西南布依族苗族自治州",
"861336330", "河北省衡水市",
"86156378", "河南省开封市",
"86184570", "浙江省衢州市",
"861309331", "安徽省滁州市",
"861534373", "河南省新乡市",
"861390480", "黑龙江省哈尔滨市",
"861707069", "辽宁省沈阳市",
"861824638", "黑龙江省佳木斯市",
"861709968", "浙江省宁波市",
"861568965", "山东省日照市",
"861332785", "江苏省宿迁市",
"861454513", "湖南省衡阳市",
"861321711", "湖北省鄂州市",
"861778753", "云南省保山市",
"86150480", "内蒙古呼伦贝尔市",
"861338540", "山东省菏泽市",
"861780330", "河北省邯郸市",
"861309273", "湖北省黄冈市",
"861534742", "广东省广州市",
"861317135", "内蒙古赤峰市",
"861363393", "河南省濮阳市",
"861760486", "内蒙古赤峰市",
"861808204", "江苏省连云港市",
"861570959", "宁夏银川市",
"86151660", "山东省青岛市",
"861518467", "黑龙江省双鸭山市",
"861810895", "西藏昌都地区",
"861334718", "内蒙古包头市",
"861515248", "江苏省泰州市",
"861534231", "湖北省襄樊市",
"861894379", "吉林省白城市",
"861539166", "湖北省咸宁市",
"861500334", "河北省秦皇岛市",
"861811143", "四川省自贡市",
"861806237", "湖北省宜昌市",
"861331821", "广东省佛山市",
"861334521", "山东省淄博市",
"861329135", "江苏省盐城市",
"861303893", "陕西省西安市",
"861528073", "福建省三明市",
"861452174", "吉林省通化市",
"861708566", "安徽省安庆市",
"861820730", "湖南省岳阳市",
"861786610", "甘肃省定西市",
"861389144", "陕西省渭南市",
"861576811", "广东省深圳市",
"861589996", "广东省广州市",
"861351908", "甘肃省天水市",
"861580855", "贵州省黔东南苗族侗族自治州",
"86147535", "山东省烟台市",
"86181821", "湖南省常德市",
"861816818", "江苏省苏州市",
"86150292", "陕西省西安市",
"861804191", "辽宁省辽阳市",
"861301000", "上海市",
"86185977", "福建省福州市",
"861313541", "安徽省阜阳市",
"861536197", "广东省梅州市",
"86150155", "广东省佛山市",
"861322908", "广东省江门市",
"861348752", "湖南省郴州市",
"861858345", "四川省资阳市",
"861471557", "广东省佛山市",
"861534296", "湖北省荆州市",
"86131566", "安徽省池州市",
"861315434", "吉林省四平市",
"861831696", "广东省佛山市",
"861806888", "江苏省盐城市",
"86156435", "吉林省通化市",
"861863840", "河南省商丘市",
"861520314", "河北省承德市",
"861309115", "河北省沧州市",
"861875241", "江苏省淮安市",
"861890707", "江西省赣州市",
"861588789", "云南省玉溪市",
"86184575", "浙江省绍兴市",
"861876450", "山东省菏泽市",
"861593143", "河北省保定市",
"861310328", "河北省衡水市",
"861310457", "黑龙江省大兴安岭地区",
"861378969", "内蒙古赤峰市",
"861803340", "广东省深圳市",
"86150485", "内蒙古通辽市",
"861336983", "新疆博尔塔拉蒙古自治州",
"861376787", "江西省萍乡市",
"861344084", "广西南宁市",
"861778703", "云南省西双版纳傣族自治州",
"861526634", "山东省莱芜市",
"861452651", "江西省南昌市",
"861810780", "广西防城港市",
"861477722", "广西柳州市",
"861586645", "山东省烟台市",
"86152646", "山东省潍坊市",
"861479744", "山西省吕梁市",
"861319185", "河北省石家庄市",
"861570909", "新疆博尔塔拉蒙古自治州",
"861524587", "黑龙江省伊春市",
"86151665", "山东省聊城市",
"861380934", "甘肃省庆阳市",
"861320945", "甘肃省金昌市",
"861882060", "广东省东莞市",
"861833149", "河北省衡水市",
"861594986", "山东省潍坊市",
"861893837", "广东省茂名市",
"861850726", "湖北省荆门市",
"861819906", "新疆阿勒泰地区",
"861827172", "湖北省恩施土家族苗族自治州",
"86155312", "河北省保定市",
"861332890", "福建省三明市",
"861470522", "江苏省徐州市",
"86188669", "山东省临沂市",
"861329311", "河北省邢台市",
"861569493", "河北省张家口市",
"861814688", "陕西省西安市",
"861817580", "湖南省郴州市",
"861805113", "江苏省苏州市",
"861819172", "陕西省渭南市",
"861367881", "山东省济南市",
"861321444", "吉林省四平市",
"861352528", "河南省濮阳市",
"861361454", "黑龙江省佳木斯市",
"86147530", "山东省菏泽市",
"861351958", "宁夏银川市",
"861301731", "湖南省长沙市",
"861501218", "云南省文山壮族苗族自治州",
"861897507", "湖南省怀化市",
"861333158", "吉林省长春市",
"861821803", "广东省东莞市",
"861876394", "山东省德州市",
"861528419", "四川省宜宾市",
"861815313", "贵州省安顺市",
"86137691", "云南省昆明市",
"861303053", "江西省吉安市",
"861773695", "河北省承德市",
"861319196", "河北省廊坊市",
"861805383", "山东省日照市",
"861453810", "四川省成都市",
"86132816", "四川省泸州市",
"861332000", "江西省新余市",
"861874071", "陕西省延安市",
"861810055", "福建省厦门市",
"86153192", "陕西省宝鸡市",
"86153255", "浙江省台州市",
"861558178", "山西省太原市",
"861869872", "辽宁省大连市",
"861317181", "河北省唐山市",
"861850767", "广东省云浮市",
"861565097", "青海省西宁市",
"861363555", "安徽省马鞍山市",
"861573509", "山西省忻州市",
"861822611", "安徽省亳州市",
"861831685", "广东省深圳市",
"861830789", "广西河池市",
"861890914", "陕西省商洛市",
"861323545", "湖北省恩施土家族苗族自治州",
"86138788", "广西南宁市",
"861304590", "福建省龙岩市",
"861569769", "广东省东莞市",
"861597306", "湖南省常德市",
"86134159", "广东省东莞市",
"861361390", "河南省新乡市",
"861816074", "江西省南昌市",
"861532218", "广东省云浮市",
"861590783", "广西桂林市",
"861586926", "浙江省金华市",
"861303677", "湖南省永州市",
"86188004", "黑龙江省哈尔滨市",
"861332731", "湖南省长沙市",
"861594995", "山东省枣庄市",
"861705264", "山东省济南市",
"861814391", "河南省焦作市",
"861857567", "广东省深圳市",
"861326389", "广西贵港市",
"861809743", "青海省西宁市",
"86132967", "浙江省杭州市",
"861457028", "江西省景德镇市",
"861838141", "四川省资阳市",
"861369790", "江西省赣州市",
"861454106", "安徽省安庆市",
"861311715", "湖北省咸宁市",
"861318823", "辽宁省本溪市",
"861532584", "浙江省宁波市",
"861458234", "安徽省淮南市",
"86156798", "江西省景德镇市",
"861821853", "广东省河源市",
"861367835", "四川省雅安市",
"861508246", "四川省宜宾市",
"861317046", "湖南省永州市",
"861867625", "广东省河源市",
"861350630", "山东省威海市",
"861880676", "浙江省台州市",
"861804045", "四川省宜宾市",
"861870912", "陕西省榆林市",
"861853021", "河南省新乡市",
"861332796", "江苏省淮安市",
"861300689", "广东省广州市",
"861512860", "河北省承德市",
"861896392", "湖北省恩施土家族苗族自治州",
"861572186", "云南省大理白族自治州",
"861539127", "内蒙古鄂尔多斯市",
"86153250", "浙江省温州市",
"861770460", "福建省福州市",
"861518426", "辽宁省盘锦市",
"861510134", "甘肃省兰州市",
"861810005", "上海市",
"861454972", "浙江省嘉兴市",
"861801343", "江苏省镇江市",
"861332050", "云南省昆明市",
"861814336", "湖南省衡阳市",
"86135924", "河南省郑州市",
"861329046", "河北省廊坊市",
"86150409", "辽宁省葫芦岛市",
"861860316", "河北省廊坊市",
"861566423", "河南省平顶山市",
"861306326", "安徽省芜湖市",
"861558480", "吉林省通化市",
"861318549", "浙江省湖州市",
"861304951", "贵州省安顺市",
"861354738", "四川省自贡市",
"86188962", "云南省文山壮族苗族自治州",
"861861529", "山东省菏泽市",
"861554211", "辽宁省朝阳市",
"861822949", "湖南省长沙市",
"861589985", "广东省深圳市",
"861362321", "河北省石家庄市",
"86153569", "浙江省金华市",
"861314266", "江苏省南通市",
"861339643", "山东省淄博市",
"861807265", "浙江省舟山市",
"861319131", "内蒙古呼伦贝尔市",
"861595478", "山东省济南市",
"861812048", "湖北省黄石市",
"861866636", "广东省佛山市",
"861800816", "四川省绵阳市",
"861864829", "内蒙古赤峰市",
"861513415", "辽宁省锦州市",
"861810886", "云南省德宏傣族景颇族自治州",
"861364639", "山东省青岛市",
"861524979", "河南省商丘市",
"861302821", "辽宁省阜新市",
"861873973", "河南省安阳市",
"861391968", "甘肃省定西市",
"861473114", "河北省秦皇岛市",
"861338356", "山西省晋城市",
"861365555", "安徽省合肥市",
"861362338", "河北省衡水市",
"861325545", "山东省烟台市",
"861319128", "山西省大同市",
"861852572", "辽宁省葫芦岛市",
"86136829", "广东省汕头市",
"861829829", "安徽省安庆市",
"861576590", "黑龙江省大庆市",
"861329639", "山东省青岛市",
"861599713", "湖北省黄石市",
"861770548", "山东省泰安市",
"861354721", "四川省乐山市",
"861567078", "河南省安阳市",
"861383441", "山西省晋中市",
"861303745", "湖南省怀化市",
"861821130", "广东省深圳市",
"861367266", "广东省珠海市",
"861775695", "安徽省宣城市",
"861811478", "江苏省徐州市",
"861345406", "浙江省舟山市",
"861360815", "四川省自贡市",
"861839294", "陕西省渭南市",
"861336940", "甘肃省武威市",
"861328377", "河南省南阳市",
"861810743", "湖南省湘西土家族苗族自治州",
"861806825", "江苏省无锡市",
"861778191", "四川省巴中市",
"861705220", "云南省昆明市",
"861357610", "江西省南昌市",
"86150710", "湖北省武汉市",
"861380557", "安徽省宿州市",
"861458599", "山东省威海市",
"86184795", "江西省宜春市",
"861554542", "黑龙江省佳木斯市",
"861334653", "广东省韶关市",
"861335158", "吉林省四平市",
"861477107", "湖北省恩施土家族苗族自治州",
"861317639", "山东省青岛市",
"861320698", "黑龙江省佳木斯市",
"861352585", "河南省三门峡市",
"861866049", "山东省烟台市",
"86151498", "内蒙古巴彦淖尔市",
"861381522", "江苏省南通市",
"861853038", "河南省三门峡市",
"861320111", "新疆伊犁哈萨克自治州",
"861586998", "湖南省永州市",
"861878491", "四川省广元市",
"861780940", "甘肃省兰州市",
"861511225", "广东省深圳市",
"861566565", "安徽省芜湖市",
"861869553", "宁夏银川市",
"861500944", "甘肃省金昌市",
"861810372", "河南省安阳市",
"86135425", "广东省佛山市",
"861861786", "河北省唐山市",
"861778618", "湖北省黄冈市",
"861470435", "吉林省通化市",
"861829543", "宁夏吴忠市",
"86150491", "内蒙古呼和浩特市",
"861324790", "江西省赣州市",
"861514904", "内蒙古兴安盟",
"861592939", "陕西省榆林市",
"861311535", "黑龙江省佳木斯市",
"861774254", "湖南省衡阳市",
"861501445", "广东省肇庆市",
"861816958", "宁夏银川市",
"861457096", "江苏省南通市",
"861839719", "青海省黄南藏族自治州",
"861850977", "青海省海西蒙古族藏族自治州",
"861572699", "浙江省衢州市",
"861815140", "江苏省镇江市",
"861562802", "贵州省黔南布依族苗族自治州",
"861506063", "福建省泉州市",
"861776862", "江苏省泰州市",
"861817543", "安徽省阜阳市",
"86157787", "广西钦州市",
"86145806", "浙江省嘉兴市",
"861334077", "四川省南充市",
"861590846", "四川省泸州市",
"861889430", "甘肃省白银市",
"861450500", "吉林省延边朝鲜族自治州",
"861338306", "河北省沧州市",
"861801962", "江苏省盐城市",
"861450991", "新疆乌鲁木齐市",
"861869386", "甘肃省庆阳市",
"861332728", "湖南省娄底市",
"861878436", "四川省阿坝藏族羌族自治州",
"86137609", "广东省佛山市",
"861580915", "陕西省安康市",
"86152493", "甘肃省平凉市",
"861858935", "云南省昆明市",
"861576951", "宁夏银川市",
"861890094", "辽宁省沈阳市",
"861893225", "江苏省盐城市",
"861373771", "广西桂林市",
"861570819", "四川省内江市",
"86150715", "湖北省襄樊市",
"861389879", "辽宁省葫芦岛市",
"861831319", "云南省大理白族自治州",
"861830526", "江苏省泰州市",
"861390443", "吉林省延边朝鲜族自治州",
"861457031", "广东省广州市",
"86150847", "湖南省长沙市",
"861452849", "甘肃省陇南市",
"861853989", "河南省商丘市",
"861556627", "辽宁省鞍山市",
"861478477", "内蒙古鄂尔多斯市",
"861458788", "湖南省衡阳市",
"861803930", "河南省南阳市",
"861833645", "河南省南阳市",
"861335108", "黑龙江省伊春市",
"861334603", "浙江省绍兴市",
"86139612", "江苏省常州市",
"861332511", "山东省济南市",
"86138431", "吉林省长春市",
"861596606", "山东省济南市",
"86131637", "广东省深圳市",
"861319689", "江苏省宿迁市",
"861375961", "陕西省商洛市",
"861597497", "云南省保山市",
"861875973", "福建省三明市",
"861824872", "江苏省泰州市",
"861884994", "云南省德宏傣族景颇族自治州",
"861356143", "山东省潍坊市",
"861380344", "山西省忻州市",
"8618428", "上海市",
"861391209", "江苏省泰州市",
"861309619", "四川省达州市",
"861571471", "内蒙古呼和浩特市",
"861850864", "湖北省武汉市",
"861709997", "广东省中山市",
"86135420", "广东省湛江市",
"861825090", "福建省宁德市",
"861338583", "浙江省嘉兴市",
"861346863", "陕西省宝鸡市",
"861801110", "四川省绵阳市",
"861505485", "山东省济宁市",
"86153369", "浙江省湖州市",
"861816908", "宁夏银川市",
"861327689", "浙江省金华市",
"861459146", "广西钦州市",
"861452523", "山东省临沂市",
"861778136", "四川省德阳市",
"861454762", "山东省东营市",
"861362695", "福建省南平市",
"861509134", "陕西省咸阳市",
"861562852", "西藏日喀则地区",
"861530366", "黑龙江省哈尔滨市",
"86183957", "河北省承德市",
"861871866", "广东省惠州市",
"861800956", "宁夏中卫市",
"861802319", "广东省汕尾市",
"861871827", "广东省湛江市",
"861530458", "黑龙江省伊春市",
"861882192", "湖南省衡阳市",
"861521784", "广东省惠州市",
"861530327", "河北省沧州市",
"861524493", "四川省遂宁市",
"861364311", "河北省石家庄市",
"861858270", "四川省凉山彝族自治州",
"861377971", "新疆喀什地区",
"861856715", "河南省南阳市",
"86184370", "河南省商丘市",
"86156578", "浙江省宁波市",
"861301511", "内蒙古呼伦贝尔市",
"861896644", "浙江省舟山市",
"861321596", "福建省漳州市",
"861310273", "河北省沧州市",
"86139704", "江西省抚州市",
"861512152", "贵州省毕节地区",
"861867688", "广东省广州市",
"86184438", "吉林省松原市",
"861569587", "浙江省金华市",
"861352531", "河南省驻马店市",
"86152170", "广东省深圳市",
"861301728", "湖南省长沙市",
"861803275", "河北省石家庄市",
"861869395", "甘肃省陇南市",
"86138418", "辽宁省阜新市",
"861591183", "云南省昭通市",
"86130617", "上海市",
"86189433", "吉林省延边朝鲜族自治州",
"861322074", "山东省潍坊市",
"861826899", "浙江省衢州市",
"861845238", "江苏省南京市",
"861339680", "浙江省舟山市",
"861850589", "浙江省金华市",
"861383907", "河南省新乡市",
"861556666", "辽宁省大连市",
"861800530", "山东省菏泽市",
"861305893", "浙江省湖州市",
"861830567", "安徽省亳州市",
"86151735", "湖南省郴州市",
"861776833", "江苏省无锡市",
"861581263", "广东省珠海市",
"86139426", "辽宁省大连市",
"861503428", "山西省吕梁市",
"861362686", "浙江省绍兴市",
"861345368", "山西省临汾市",
"861821913", "广东省肇庆市",
"861513248", "河北省石家庄市",
"861589928", "新疆伊犁哈萨克自治州",
"86137851", "河北省石家庄市",
"861568775", "云南省昆明市",
"861879360", "甘肃省武威市",
"861522290", "安徽省滁州市",
"861807001", "江西省鹰潭市",
"861583515", "山西省长治市",
"86188739", "湖南省邵阳市",
"86156934", "甘肃省庆阳市",
"861323484", "内蒙古鄂尔多斯市",
"861870852", "贵州省遵义市",
"861309407", "新疆巴音郭楞蒙古自治州",
"861523847", "河南省周口市",
"861310331", "河北省石家庄市",
"861472870", "贵州省铜仁地区",
"861365393", "河南省濮阳市",
"861512976", "陕西省汉中市",
"861708071", "湖南省长沙市",
"861820510", "江苏省盐城市",
"861831628", "广东省东莞市",
"861560737", "湖南省益阳市",
"861530408", "辽宁省阜新市",
"861800906", "四川省绵阳市",
"861891248", "江苏省无锡市",
"86139919", "陕西省西安市",
"861857598", "广东省东莞市",
"861595143", "江苏省扬州市",
"861594648", "黑龙江省齐齐哈尔市",
"861854690", "黑龙江省双鸭山市",
"86184375", "河南省平顶山市",
"861316949", "广东省汕尾市",
"86131366", "黑龙江省哈尔滨市",
"861322269", "江苏省扬州市",
"861892678", "广东省深圳市",
"861313434", "吉林省四平市",
"861334538", "新疆和田地区",
"86157586", "云南省临沧市",
"861337630", "山东省威海市",
"861783540", "山西省晋中市",
"861310396", "河南省驻马店市",
"861876642", "山东省青岛市",
"861700472", "内蒙古包头市",
"8613052", "上海市",
"861590740", "湖南省张家界市",
"861850798", "江西省景德镇市",
"861457085", "江苏省徐州市",
"861868650", "吉林省长春市",
"861532445", "安徽省宿州市",
"861890854", "贵州省黔南布依族苗族自治州",
"861369828", "四川省南充市",
"861365276", "广东省惠州市",
"86151730", "湖南省岳阳市",
"861565068", "安徽省阜阳市",
"861593310", "河北省邯郸市",
"861813183", "河北省衡水市",
"861773948", "河南省驻马店市",
"861395627", "安徽省黄山市",
"861367227", "江西省宜春市",
"861807051", "江西省南昌市",
"861300185", "河北省邢台市",
"861370076", "河南省信阳市",
"86155512", "安徽省芜湖市",
"861378779", "湖南省长沙市",
"861834475", "江苏省徐州市",
"861377280", "陕西省汉中市",
"861835149", "江苏省连云港市",
"861309457", "四川省雅安市",
"861819710", "青海省西宁市",
"861870802", "西藏日喀则地区",
"861845887", "浙江省杭州市",
"86147478", "内蒙古巴彦淖尔市",
"861338468", "黑龙江省鹤岗市",
"861309328", "湖北省随州市",
"861860699", "福建省福州市",
"861858981", "广西玉林市",
"861589766", "湖北省孝感市",
"861374562", "北京市",
"861803295", "河北省邢台市",
"861800024", "江西省九江市",
"86186761", "广东省中山市",
"86189521", "江苏省徐州市",
"861370031", "河北省石家庄市",
"861869375", "甘肃省嘉峪关市",
"861873620", "河南省周口市",
"861555619", "安徽省蚌埠市",
"861324876", "浙江省温州市",
"861392265", "广东省云浮市",
"861332927", "安徽省亳州市",
"86186874", "云南省曲靖市",
"861850259", "江苏省常州市",
"861350157", "广东省深圳市",
"861508933", "广东省惠州市",
"861322094", "山东省烟台市",
"86177513", "江苏省扬州市",
"861379986", "福建省泉州市",
"861826879", "浙江省绍兴市",
"861819060", "四川省宜宾市",
"86159065", "浙江省宁波市",
"86182875", "云南省保山市",
"86130619", "上海市",
"861515630", "安徽省芜湖市",
"861377991", "福建省漳州市",
"861325752", "广东省惠州市",
"861809875", "安徽省六安市",
"86157705", "江西省宜春市",
"861365742", "湖南省常德市",
"861337722", "广西柳州市",
"861339744", "湖南省张家界市",
"861303552", "贵州省遵义市",
"861763309", "河北省邯郸市",
"861707539", "山东省临沂市",
"861538628", "湖南省怀化市",
"861827060", "江西省宜春市",
"861530741", "湖南省株洲市",
"861567858", "广西玉林市",
"861568795", "云南省临沧市",
"861301966", "辽宁省抚顺市",
"861369382", "河南省洛阳市",
"8615654", "海南省海口市",
"861327812", "吉林省四平市",
"861365373", "河南省新乡市",
"86134717", "广西钦州市",
"861453571", "福建省厦门市",
"861335384", "河南省周口市",
"861865361", "山东省聊城市",
"861472890", "西藏拉萨市",
"861835978", "福建省福州市",
"861311251", "广东省潮州市",
"861308047", "河北省沧州市",
"861890818", "四川省成都市",
"86188737", "湖南省益阳市",
"861530232", "广东省佛山市",
"86134845", "陕西省西安市",
"861533311", "河北省石家庄市",
"86151342", "辽宁省营口市",
"861330522", "江苏省徐州市",
"861512931", "陕西省西安市",
"861818734", "云南省临沧市",
"861521640", "山东省济南市",
"86133530", "广东省肇庆市",
"861892335", "广东省江门市",
"86187543", "山东省滨州市",
"861370700", "江西省宜春市",
"861319812", "四川省巴中市",
"861805861", "浙江省嘉兴市",
"861816707", "浙江省台州市",
"861508380", "江西省南昌市",
"861470610", "江苏省镇江市",
"861530414", "辽宁省本溪市",
"861558339", "四川省德阳市",
"861880319", "河北省邢台市",
"861824052", "河南省信阳市",
"86189142", "江苏省无锡市",
"861879841", "贵州省黔南布依族苗族自治州",
"86182870", "云南省昭通市",
"861771569", "江苏省无锡市",
"86159060", "福建省泉州市",
"861809644", "安徽省马鞍山市",
"861310376", "河南省信阳市",
"861361782", "广西柳州市",
"861376925", "云南省楚雄彝族自治州",
"861322122", "浙江省湖州市",
"861303668", "四川省成都市",
"861459423", "云南省楚雄彝族自治州",
"861386829", "浙江省湖州市",
"861553385", "河北省唐山市",
"86157700", "新疆阿克苏地区",
"861886639", "山东省青岛市",
"8614744", "广东省广州市",
"861375153", "广东省佛山市",
"86153636", "广东省佛山市",
"861325702", "江西省九江市",
"861334807", "江苏省南通市",
"861568880", "山东省德州市",
"861512996", "陕西省安康市",
"861312144", "内蒙古鄂尔多斯市",
"861522981", "陕西省延安市",
"861472785", "陕西省安康市",
"861590684", "浙江省宁波市",
"861303502", "安徽省蚌埠市",
"861367332", "河南省安阳市",
"86139917", "陕西省宝鸡市",
"861378799", "湖南省岳阳市",
"86131932", "重庆市",
"861370096", "四川省绵阳市",
"86136213", "北京市",
"86159684", "浙江省宁波市",
"861860679", "浙江省金华市",
"861861775", "河北省保定市",
"861533135", "四川省绵阳市",
"861346945", "湖南省长沙市",
"861528913", "西藏山南地区",
"861471821", "广东省河源市",
"861474718", "内蒙古巴彦淖尔市",
"861867262", "湖北省荆门市",
"861331344", "山西省晋中市",
"861377936", "新疆哈密地区",
"861563538", "山西省太原市",
"86139866", "湖北省荆州市",
"861888263", "四川省内江市",
"861556549", "河南省漯河市",
"861316480", "福建省福州市",
"86132732", "河北省保定市",
"861386543", "安徽省六安市",
"861700492", "上海市",
"861558167", "湖南省邵阳市",
"861850778", "广西河池市",
"861561600", "湖南省长沙市",
"861348484", "陕西省榆林市",
"861816757", "新疆伊犁哈萨克自治州",
"861306410", "江西省南昌市",
"861365296", "广东省揭阳市",
"86183308", "河北省衡水市",
"861860420", "辽宁省鞍山市",
"861555941", "新疆和田地区",
"861569207", "广东省阳江市",
"861879155", "陕西省安康市",
"861339411", "辽宁省大连市",
"861538189", "浙江省宁波市",
"861771884", "广东省湛江市",
"861778171", "四川省遂宁市",
"861328397", "河南省信阳市",
"861512985", "陕西省宝鸡市",
"861811498", "江苏省徐州市",
"86181262", "广东省深圳市",
"861550434", "吉林省四平市",
"861538319", "河北省邢台市",
"861502915", "陕西省商洛市",
"861320678", "黑龙江省双鸭山市",
"861560938", "甘肃省天水市",
"861472796", "陕西省汉中市",
"861890269", "广东省东莞市",
"86131283", "广东省揭阳市",
"861865272", "江苏省泰州市",
"861594765", "内蒙古鄂尔多斯市",
"861458579", "山东省菏泽市",
"86136827", "广东省揭阳市",
"861555328", "山东省聊城市",
"86135188", "海南省海口市",
"861346626", "云南省红河哈尼族彝族自治州",
"861394889", "内蒙古兴安盟",
"861889048", "湖南省邵阳市",
"86130912", "河北省保定市",
"861571436", "吉林省白城市",
"861508962", "广东省茂名市",
"861762516", "江苏省徐州市",
"861302344", "江苏省镇江市",
"861524019", "安徽省合肥市",
"861884867", "贵州省六盘水市",
"861847825", "湖南省邵阳市",
"861300902", "吉林省四平市",
"861324770", "江西省南昌市",
"86180695", "浙江省绍兴市",
"861334097", "四川省凉山彝族自治州",
"861479643", "江西省上饶市",
"861450280", "内蒙古鄂尔多斯市",
"86157789", "海南省海口市",
"861708801", "四川省成都市",
"861572679", "西藏拉萨市",
"861850997", "新疆阿克苏地区",
"861396619", "安徽省宣城市",
"861580352", "山西省大同市",
"861562487", "内蒙古兴安盟",
"861336489", "新疆和田地区",
"861300176", "山东省德州市",
"861370085", "河南省郑州市",
"861770317", "河北省沧州市",
"861874649", "黑龙江省七台河市",
"861380287", "广东省惠州市",
"861586978", "湖南省益阳市",
"861340389", "河南省周口市",
"861523643", "河南省信阳市",
"86135860", "浙江省台州市",
"861855568", "安徽省合肥市",
"861390339", "河北省石家庄市",
"861768301", "四川省绵阳市",
"861572420", "浙江省温州市",
"861834486", "江苏省盐城市",
"861810392", "河南省鹤壁市",
"861881567", "安徽省阜阳市",
"861504988", "内蒙古鄂尔多斯市",
"861376646", "江西省上饶市",
"861773747", "河南省洛阳市",
"86150849", "湖南省长沙市",
"861777401", "浙江省杭州市",
"861554080", "内蒙古巴彦淖尔市",
"861772285", "广东省广州市",
"861373791", "广西南宁市",
"861559893", "内蒙古呼伦贝尔市",
"861338253", "江苏省苏州市",
"861837968", "江西省吉安市",
"86177455", "黑龙江省大庆市",
"86145871", "广东省广州市",
"861535639", "浙江省丽水市",
"86134516", "江苏省苏州市",
"86188536", "山东省潍坊市",
"861570453", "黑龙江省牡丹江市",
"861351854", "贵州省黔南布依族苗族自治州",
"861333922", "安徽省阜阳市",
"861517158", "湖北省宜昌市",
"861862682", "浙江省温州市",
"861899825", "广东省揭阳市",
"861880628", "江苏省南通市",
"861450971", "新疆哈密地区",
"861533181", "黑龙江省双鸭山市",
"861370856", "贵州省铜仁地区",
"861301927", "吉林省吉林市",
"861529158", "陕西省汉中市",
"86137607", "广东省广州市",
"861813216", "河北省石家庄市",
"861302557", "广东省肇庆市",
"861335114", "黑龙江省七台河市",
"861470023", "安徽省六安市",
"861300952", "内蒙古呼和浩特市",
"861888232", "四川省南充市",
"861553331", "河北省邯郸市",
"86158552", "安徽省六安市",
"86132288", "江苏省南通市",
"86153367", "浙江省绍兴市",
"86183959", "浙江省金华市",
"861362675", "浙江省绍兴市",
"861575289", "云南省昆明市",
"861582944", "陕西省咸阳市",
"861350248", "广东省汕头市",
"86180690", "浙江省宁波市",
"86135865", "浙江省宁波市",
"861824892", "江苏省淮安市",
"861361245", "广东省潮州市",
"861816914", "宁夏固原市",
"86131639", "福建省泉州市",
"861568786", "云南省昆明市",
"861332966", "贵州省铜仁地区",
"861369960", "四川省绵阳市",
"861368594", "福建省泉州市",
"861593498", "内蒙古鄂尔多斯市",
"861853440", "山西省忻州市",
"861709977", "广东省珠海市",
"861571491", "新疆克孜勒苏柯尔克孜自治州",
"861589727", "青海省海西蒙古族藏族自治州",
"861848910", "西藏拉萨市",
"86138523", "江苏省淮安市",
"861898140", "四川省内江市",
"861866671", "广东省湛江市",
"861874091", "甘肃省临夏回族自治州",
"861350722", "湖北省武汉市",
"861802676", "广东省江门市",
"861328456", "黑龙江省黑河市",
"861811426", "江苏省宿迁市",
"861319902", "黑龙江省绥化市",
"861508343", "河南省南阳市",
"861368446", "四川省雅安市",
"86159299", "陕西省西安市",
"861801246", "江苏省无锡市",
"861889119", "陕西省铜川市",
"861868369", "四川省成都市",
"861327902", "新疆哈密地区",
"861337157", "山东省淄博市",
"861454634", "宁夏石嘴山市",
"861475108", "江苏省南京市",
"861319176", "河北省唐山市",
"861769320", "甘肃省定西市",
"861550541", "山东省济南市",
"861890908", "四川省泸州市",
"861814233", "陕西省渭南市",
"861338477", "内蒙古鄂尔多斯市",
"861535046", "江西省九江市",
"861572464", "辽宁省鞍山市",
"861359307", "山西省晋中市",
"861594975", "山东省潍坊市",
"861852419", "辽宁省辽阳市",
"861357522", "湖南省常德市",
"861868137", "四川省成都市",
"861848756", "云南省丽江市",
"861478583", "贵州省安顺市",
"861301870", "广东省清远市",
"861565653", "安徽省马鞍山市",
"861597253", "湖北省黄石市",
"861524148", "辽宁省大连市",
"861870355", "山西省长治市",
"861814371", "甘肃省天水市",
"861566035", "新疆喀什地区",
"861314363", "河北省石家庄市",
"86131012", "重庆市",
"861508772", "云南省玉溪市",
"861534555", "安徽省马鞍山市",
"861351757", "广西钦州市",
"861311065", "福建省漳州市",
"861304570", "浙江省衢州市",
"861318666", "江苏省常州市",
"861380821", "四川省成都市",
"861303697", "广西钦州市",
"861801439", "江苏省南通市",
"861558611", "湖北省荆州市",
"861880631", "山东省威海市",
"861386580", "安徽省合肥市",
"861361370", "河南省商丘市",
"861506533", "山东省淄博市",
"86153228", "广东省东莞市",
"86177954", "宁夏固原市",
"86186618", "山东省青岛市",
"861558949", "山东省聊城市",
"861538685", "山西省长治市",
"861896372", "安徽省亳州市",
"861478356", "河南省许昌市",
"861815216", "甘肃省白银市",
"861362747", "湖南省邵阳市",
"861536749", "湖南省长沙市",
"861830578", "浙江省丽水市",
"861592462", "云南省红河哈尼族彝族自治州",
"861328406", "黑龙江省黑河市",
"861533639", "山东省青岛市",
"86134316", "广东省佛山市",
"861569019", "河北省衡水市",
"86188336", "河北省廊坊市",
"861332776", "江苏省镇江市",
"861359357", "山西省运城市",
"861880696", "云南省临沧市",
"861598415", "四川省自贡市",
"86135384", "广东省东莞市",
"861348545", "山西省吕梁市",
"861777169", "湖北省潜江市",
"861588037", "福建省龙岩市",
"861320863", "吉林省松原市",
"861760475", "内蒙古通辽市",
"861893633", "江苏省盐城市",
"86138323", "河北省石家庄市",
"861334917", "安徽省亳州市",
"861874036", "陕西省汉中市",
"861823070", "贵州省黔东南苗族侗族自治州",
"861855440", "山东省菏泽市",
"861595498", "山东省烟台市",
"861873993", "河南省郑州市",
"861870305", "新疆哈密地区",
"861532254", "广东省湛江市",
"861330435", "吉林省四平市",
"861524999", "安徽省滁州市",
"861346335", "河北省秦皇岛市",
"861824283", "辽宁省辽阳市",
"861593426", "山西省忻州市",
"861331934", "江西省宜春市",
"861534505", "福建省三明市",
"861351707", "江西省赣州市",
"86150407", "辽宁省鞍山市",
"861853652", "山西省晋中市",
"861340615", "山东省滨州市",
"861555331", "山东省淄博市",
"861360312", "河北省保定市",
"861305552", "福建省福州市",
"861806322", "山东省枣庄市",
"861471838", "广东省茂名市",
"861816854", "江苏省泰州市",
"86158092", "陕西省西安市",
"861588578", "贵州省铜仁地区",
"861554043", "内蒙古乌兰察布市",
"861373103", "河北省邯郸市",
"861520427", "辽宁省盘锦市",
"861323752", "江西省南昌市",
"861880685", "浙江省绍兴市",
"861520358", "山西省吕梁市",
"861301776", "浙江省嘉兴市",
"861560348", "山西省运城市",
"861534393", "河南省濮阳市",
"86177313", "河北省张家口市",
"861705809", "河北省石家庄市",
"861397189", "湖北省恩施土家族苗族自治州",
"861865687", "安徽省阜阳市",
"861897287", "湖北省荆门市",
"861840899", "西藏昌都地区",
"861870593", "福建省宁德市",
"861572175", "贵州省毕节地区",
"861502086", "山东省莱芜市",
"861866822", "浙江省杭州市",
"861366632", "山东省枣庄市",
"861538696", "山西省晋城市",
"861537434", "江西省抚州市",
"861459565", "陕西省宝鸡市",
"861310882", "云南省德宏傣族景颇族自治州",
"86180855", "贵州省黔东南苗族侗族自治州",
"861566081", "河南省安阳市",
"861772228", "广东省广州市",
"86177191", "河南省驻马店市",
"861800060", "河北省石家庄市",
"861871551", "安徽省合肥市",
"861893558", "青海省西宁市",
"861379648", "黑龙江省伊春市",
"861828887", "云南省丽江市",
"861808218", "江苏省盐城市",
"861302934", "辽宁省锦州市",
"861350415", "辽宁省丹东市",
"861843452", "山西省阳泉市",
"861819024", "四川省自贡市",
"861818288", "黑龙江省伊春市",
"86170757", "安徽省合肥市",
"861817042", "江西省九江市",
"86151542", "山东省青岛市",
"861334704", "内蒙古呼伦贝尔市",
"861380672", "浙江省嘉兴市",
"861370916", "陕西省汉中市",
"861589976", "广东省深圳市",
"861853483", "山西省晋中市",
"861863361", "河北省廊坊市",
"861309293", "陕西省宝鸡市",
"861363373", "河南省新乡市",
"861521452", "黑龙江省绥化市",
"861535311", "陕西省西安市",
"861361418", "辽宁省阜新市",
"861475247", "江苏省宿迁市",
"861589102", "陕西省榆林市",
"861869052", "陕西省延安市",
"861478468", "黑龙江省鹤岗市",
"86182683", "浙江省嘉兴市",
"861775179", "江苏省南京市",
"861837997", "江西省南昌市",
"861810875", "云南省昆明市",
"86132662", "广东省东莞市",
"861700519", "江苏省常州市",
"861322914", "广东省江门市",
"861305502", "湖南省常德市",
"861390611", "江苏省常州市",
"861514858", "内蒙古呼伦贝尔市",
"86186631", "山东省威海市",
"861318627", "陕西省安康市",
"861846510", "宁夏银川市",
"861555385", "山东省东营市",
"86130032", "上海市",
"861818837", "四川省内江市",
"861881598", "福建省泉州市",
"861340048", "河北省衡水市",
"861522029", "广东省东莞市",
"861564247", "辽宁省鞍山市",
"861764526", "黑龙江省双鸭山市",
"861552452", "辽宁省沈阳市",
"861855597", "安徽省宣城市",
"861323702", "江西省九江市",
"861869240", "湖南省长沙市",
"861536177", "广东省广州市",
"861396331", "山东省日照市",
"86181688", "江苏省无锡市",
"861305668", "四川省成都市",
"861884898", "河南省洛阳市",
"86185979", "湖南省长沙市",
"861330481", "黑龙江省哈尔滨市",
"861860464", "黑龙江省七台河市",
"861831676", "广东省梅州市",
"86180850", "贵州省贵阳市",
"861817250", "广西梧州市",
"861534276", "湖北省黄石市",
"86180681", "江苏省南通市",
"861334068", "四川省资阳市",
"861779117", "陕西省安康市",
"86151121", "广东省广州市",
"86183508", "福建省三明市",
"861572213", "贵州省贵阳市",
"861889389", "甘肃省武威市",
"861569473", "内蒙古乌海市",
"861450243", "河北省承德市",
"861479680", "江西省新余市",
"86188667", "山东省潍坊市",
"861893508", "山西省运城市",
"861339847", "四川省凉山彝族自治州",
"861708649", "江苏省苏州市",
"861871990", "新疆阿勒泰地区",
"861321061", "山东省泰安市",
"861372309", "河南省驻马店市",
"861325166", "黑龙江省大庆市",
"861819192", "陕西省渭南市",
"861567067", "河南省南阳市",
"8613693", "北京市",
"86150128", "广东省深圳市",
"861334754", "广西贺州市",
"861843402", "山西省太原市",
"861535135", "四川省宜宾市",
"861811467", "江苏省泰州市",
"861365228", "广东省佛山市",
"86155837", "四川省达州市",
"861598722", "云南省楚雄彝族自治州",
"861320832", "四川省内江市",
"861328368", "山西省大同市",
"861538631", "湖南省永州市",
"861518143", "四川省广元市",
"861332870", "福建省漳州市",
"861559745", "青海省海东地区",
"861599614", "江苏省连云港市",
"861338082", "广东省茂名市",
"861502855", "河北省承德市",
"861869002", "陕西省宝鸡市",
"861337248", "浙江省丽水市",
"861589152", "陕西省商洛市",
"861302692", "广西柳州市",
"86145091", "江苏省泰州市",
"861898020", "四川省内江市",
"861328873", "广东省云浮市",
"861839966", "新疆乌鲁木齐市",
"861813534", "山西省运城市",
"861538328", "河北省衡水市",
"861511943", "广东省汕尾市",
"861532706", "湖北省孝感市",
"861454944", "福建省厦门市",
"861538457", "陕西省宝鸡市",
"861569700", "云南省昭通市",
"861815441", "湖北省武汉市",
"861887181", "湖北省恩施土家族苗族自治州",
"861834438", "广东省广州市",
"861347381", "河北省衡水市",
"861380055", "安徽省滁州市",
"861360034", "广东省中山市",
"861592071", "广东省佛山市",
"86180781", "广西南宁市",
"861533198", "黑龙江省哈尔滨市",
"861370257", "广东省珠海市",
"861325047", "广东省江门市",
"861831882", "广东省惠州市",
"861320410", "辽宁省铁岭市",
"86182988", "甘肃省庆阳市",
"861700585", "浙江省绍兴市",
"86186731", "湖南省长沙市",
"861847510", "广东省揭阳市",
"861458771", "湖南省岳阳市",
"861535126", "四川省南充市",
"861775283", "湖南省岳阳市",
"861586290", "江苏省连云港市",
"861764535", "黑龙江省鸡西市",
"86133560", "浙江省嘉兴市",
"861512859", "河北省承德市",
"861880941", "甘肃省甘南藏族自治州",
"861311037", "陕西省汉中市",
"86130400", "河北省唐山市",
"861826192", "江苏省南京市",
"861872995", "陕西省安康市",
"861571488", "内蒙古巴彦淖尔市",
"861334575", "浙江省绍兴市",
"861838568", "贵州省黔东南苗族侗族自治州",
"861524028", "江苏省镇江市",
"861571532", "山东省青岛市",
"861365673", "浙江省嘉兴市",
"861501850", "广东省深圳市",
"861897261", "湖北省武汉市",
"861335684", "山东省德州市",
"861533611", "陕西省咸阳市",
"86180575", "浙江省绍兴市",
"861573560", "山西省晋城市",
"861840710", "湖北省襄樊市",
"861394955", "河南省驻马店市",
"86186354", "山西省晋中市",
"86182355", "山西省长治市",
"861332069", "四川省内江市",
"861770459", "黑龙江省大庆市",
"861560986", "辽宁省大连市",
"861838602", "贵州省铜仁地区",
"861568738", "云南省昆明市",
"861590384", "河南省商丘市",
"861852431", "辽宁省鞍山市",
"861364480", "内蒙古呼伦贝尔市",
"861829854", "甘肃省武威市",
"861532756", "湖北省孝感市",
"861815299", "新疆喀什地区",
"861771243", "江苏省徐州市",
"861867822", "山东省淄博市",
"861367632", "山东省枣庄市",
"86185392", "河南省郑州市",
"861587894", "广西钦州市",
"861536434", "湖南省娄底市",
"861358114", "山东省泰安市",
"861786467", "山东省莱芜市",
"861816200", "山东省威海市",
"861380005", "辽宁省沈阳市",
"861567081", "河南省驻马店市",
"861569750", "广东省江门市",
"861846237", "山东省菏泽市",
"861533949", "甘肃省酒泉市",
"86159030", "河南省新乡市",
"86177811", "四川省南充市",
"861811481", "江苏省镇江市",
"861303368", "浙江省丽水市",
"861500762", "广东省河源市",
"861569096", "内蒙古赤峰市",
"861522777", "河北省唐山市",
"86184828", "四川省南充市",
"861470310", "河北省邯郸市",
"86189823", "四川省攀枝花市",
"861388633", "湖北省鄂州市",
"861558639", "湖北省襄樊市",
"861801411", "江苏省盐城市",
"861880619", "江苏省无锡市",
"861888823", "山东省德州市",
"86132019", "陕西省渭南市",
"861800879", "云南省普洱市",
"861582012", "广东省韶关市",
"861524916", "陕西省汉中市",
"86180212", "江苏省苏州市",
"861809507", "四川省雅安市",
"861705016", "辽宁省大连市",
"86182783", "广西桂林市",
"861459078", "广东省揭阳市",
"861308702", "河南省商丘市",
"86132762", "江苏省无锡市",
"861510540", "山东省菏泽市",
"861350489", "黑龙江省大庆市",
"86180570", "浙江省衢州市",
"861860379", "河南省洛阳市",
"861580483", "内蒙古兴安盟",
"86137306", "四川省成都市",
"861501800", "广东省中山市",
"86181983", "贵州省遵义市",
"861330467", "黑龙江省七台河市",
"861770409", "广东省肇庆市",
"861816042", "新疆乌鲁木齐市",
"86182350", "山西省忻州市",
"861386269", "江苏省常州市",
"861346367", "河北省承德市",
"861341796", "广东省云浮市",
"861375412", "内蒙古包头市",
"861475783", "浙江省台州市",
"861569085", "河南省郑州市",
"861890543", "山东省滨州市",
"861330426", "辽宁省大连市",
"861366942", "广西柳州市",
"8615791", "北京市",
"861459537", "西藏阿里地区",
"861589220", "四川省自贡市",
"861874025", "辽宁省营口市",
"861372155", "贵州省安顺市",
"861836209", "江苏省南京市",
"861479772", "广西柳州市",
"861522998", "陕西省商洛市",
"861821485", "安徽省宿州市",
"861776169", "河南省濮阳市",
"861389530", "宁夏银川市",
"86185772", "广西柳州市",
"86181232", "四川省成都市",
"861530823", "四川省成都市",
"861320378", "河南省南阳市",
"86186913", "陕西省渭南市",
"86155036", "山西省太原市",
"861840816", "四川省绵阳市",
"861865405", "安徽省安庆市",
"861328697", "广东省湛江市",
"861537749", "湖南省长沙市",
"861505572", "安徽省宿州市",
"861342821", "广东省汕尾市",
"861890829", "四川省巴中市",
"861301274", "山东省泰安市",
"861390639", "山东省青岛市",
"861376346", "黑龙江省齐齐哈尔市",
"861700531", "山东省济南市",
"86138821", "四川省成都市",
"861810692", "福建省福州市",
"861370999", "新疆伊犁哈萨克自治州",
"86158708", "江西省九江市",
"861303456", "山东省威海市",
"861569806", "山东省淄博市",
"861321472", "内蒙古包头市",
"861770617", "江苏省无锡市",
"86135830", "山东省菏泽市",
"861340689", "山东省德州市",
"861365897", "西藏阿里地区",
"86159414", "辽宁省本溪市",
"861857251", "湖北省十堰市",
"861378950", "内蒙古呼伦贝尔市",
"861572379", "广西北海市",
"861530549", "山东省临沂市",
"861380895", "山东省青岛市",
"861389956", "新疆克拉玛依市",
"861302644", "陕西省宝鸡市",
"861587004", "江西省赣州市",
"861354965", "湖南省长沙市",
"861571563", "安徽省宣城市",
"86183112", "北京市",
"86151256", "云南省普洱市",
"861377039", "江苏省淮安市",
"861773052", "河北省唐山市",
"861830065", "河南省濮阳市",
"861509306", "河南省郑州市",
"861347335", "河北省石家庄市",
"861500733", "湖南省株洲市",
"861311578", "浙江省丽水市",
"861347698", "湖北省荆州市",
"861566026", "湖南省邵阳市",
"861344590", "陕西省商洛市",
"861889185", "陕西省安康市",
"861772897", "广东省茂名市",
"861334256", "湖南省常德市",
"861808070", "四川省遂宁市",
"861380780", "广西南宁市",
"861377988", "新疆喀什地区",
"861880328", "河北省衡水市",
"861336157", "山东省潍坊市",
"861388662", "湖北省荆州市",
"861880457", "黑龙江省大兴安岭地区",
"861587768", "陕西省渭南市",
"861570960", "宁夏银川市",
"861340128", "江苏省南通市",
"861812812", "广东省珠海市",
"861535339", "陕西省渭南市",
"86158903", "河南省开封市",
"861862382", "河南省安阳市",
"86188566", "安徽省池州市",
"861825445", "山东省枣庄市",
"861853075", "河南省商丘市",
"86130489", "广东省深圳市",
"861471743", "江西省南昌市",
"861532850", "四川省遂宁市",
"861580568", "安徽省阜阳市",
"861811435", "江苏省苏州市",
"861474729", "内蒙古呼和浩特市",
"86170876", "江苏省扬州市",
"861452142", "河北省承德市",
"861895333", "山东省日照市",
"861815957", "福建省漳州市",
"861768651", "山东省菏泽市",
"861302875", "甘肃省酒泉市",
"861370148", "江苏省常州市",
"861529846", "江苏省扬州市",
"861832744", "湖北省恩施土家族苗族自治州",
"86135835", "山东省烟台市",
"861555189", "安徽省阜阳市",
"861560995", "新疆吐鲁番地区",
"861569856", "山西省太原市",
"861303406", "安徽省阜阳市",
"86186718", "湖北省恩施土家族苗族自治州",
"861505130", "江苏省宿迁市",
"86131669", "吉林省吉林市",
"861362375", "河南省平顶山市",
"861881422", "广东省深圳市",
"861709781", "浙江省台州市",
"861891940", "甘肃省临夏回族自治州",
"861378591", "河北省秦皇岛市",
"861857201", "湖北省黄石市",
"861872986", "陕西省西安市",
"861708939", "广东省肇庆市",
"861829094", "新疆阿勒泰地区",
"861553631", "山西省太原市",
"861369453", "黑龙江省牡丹江市",
"86152549", "山东省临沂市",
"861879723", "青海省黄南藏族自治州",
"861839927", "新疆伊犁哈萨克自治州",
"86145351", "山东省青岛市",
"861810934", "甘肃省庆阳市",
"861800144", "江苏省扬州市",
"861769620", "山西省吕梁市",
"861521556", "安徽省安庆市",
"86159910", "陕西省咸阳市",
"861884881", "河南省安阳市",
"861454334", "内蒙古阿拉善盟",
"861862876", "吉林省四平市",
"861561546", "山东省东营市",
"86180411", "辽宁省大连市",
"861534877", "云南省玉溪市",
"861771280", "江苏省淮安市",
"86181418", "辽宁省阜新市",
"861839870", "四川省自贡市",
"861346398", "河北省石家庄市",
"861364443", "吉林省延边朝鲜族自治州",
"861806871", "江苏省徐州市",
"86137707", "江苏省南京市",
"861863405", "河北省沧州市",
"861330498", "辽宁省阜新市",
"861553628", "山西省运城市",
"861562461", "内蒙古锡林郭勒盟",
"861515940", "福建省宁德市",
"861599184", "陕西省咸阳市",
"861858768", "广西南宁市",
"861453969", "广东省珠海市",
"861802376", "广东省云浮市",
"861380261", "广东省江门市",
"861772219", "广东省湛江市",
"861342287", "广东省深圳市",
"861564846", "内蒙古赤峰市",
"861366363", "山西省阳泉市",
"861478606", "贵州省黔西南布依族苗族自治州",
"861339439", "吉林省白山市",
"8618623", "重庆市",
"861876101", "江苏省淮安市",
"861880331", "河北省石家庄市",
"861596477", "山东省聊城市",
"861841962", "甘肃省定西市",
"86131739", "浙江省绍兴市",
"86135279", "广东省东莞市",
"861521930", "广东省汕尾市",
"861361670", "浙江省衢州市",
"861512641", "云南省红河哈尼族彝族自治州",
"861892367", "广东省汕头市",
"861308127", "辽宁省锦州市",
"861474586", "黑龙江省齐齐哈尔市",
"861318366", "四川省眉山市",
"86145080", "江苏省南京市",
"861500513", "江苏省连云港市",
"861339246", "广东省广州市",
"861871759", "陕西省铜川市",
"861814671", "江西省南昌市",
"861363897", "西藏阿里地区",
"861315168", "江苏省镇江市",
"861361429", "辽宁省葫芦岛市",
"861818449", "贵州省遵义市",
"861331392", "福建省龙岩市",
"861886611", "山东省济南市",
"8613530", "广东省深圳市",
"861813907", "新疆巴音郭楞蒙古自治州",
"861577132", "内蒙古乌海市",
"861362240", "广东省茂名市",
"861510583", "浙江省嘉兴市",
"861590922", "陕西省延安市",
"86180790", "江西省新余市",
"861880396", "河南省驻马店市",
"861351250", "江苏省南京市",
"86159915", "陕西省延安市",
"861320223", "广东省揭阳市",
"861883434", "山西省长治市",
"861566098", "河南省南阳市",
"861893271", "河北省邯郸市",
"861863455", "山西省长治市",
"861847836", "湖南省湘西土家族苗族自治州",
"861533339", "河北省邢台市",
"861855075", "江苏省宿迁市",
"86158872", "云南省昆明市",
"861324403", "吉林省吉林市",
"861394815", "内蒙古通辽市",
"861700528", "江苏省南京市",
"861322042", "甘肃省平凉市",
"861575173", "江苏省徐州市",
"861886949", "云南省红河哈尼族彝族自治州",
"86170897", "广东省中山市",
"861872648", "安徽省合肥市",
"861512919", "陕西省铜川市",
"861510356", "山西省晋城市",
"861520533", "山东省淄博市",
"861365794", "江西省抚州市",
"861379921", "福建省泉州市",
"861809934", "新疆哈密地区",
"861339792", "江西省九江市",
"861538385", "河北省唐山市",
"861502989", "陕西省商洛市",
"861389710", "青海省海北藏族自治州",
"86152349", "山西省朔州市",
"861707728", "江西省宜春市",
"861340315", "河北省唐山市",
"861570770", "广西防城港市",
"861555631", "安徽省宣城市",
"86182413", "辽宁省抚顺市",
"861589079", "河南省安阳市",
"861336415", "辽宁省丹东市",
"861782061", "广东省佛山市",
"861370019", "辽宁省葫芦岛市",
"861588251", "四川省遂宁市",
"861844703", "内蒙古呼伦贝尔市",
"861377646", "江苏省宿迁市",
"861570924", "陕西省西安市",
"861571425", "辽宁省丹东市",
"861771971", "陕西省汉中市",
"861503130", "河北省承德市",
"861342838", "广东省佛山市",
"861305406", "湖南省衡阳市",
"861777637", "广西玉林市",
"861390046", "福建省福州市",
"86180795", "江西省宜春市",
"861396685", "安徽省亳州市",
"861533167", "云南省大理白族自治州",
"861459717", "山东省威海市",
"861552556", "山西省晋中市",
"86157689", "广东省广州市",
"861813957", "新疆喀什地区",
"861865117", "江苏省泰州市",
"8613452", "重庆市",
"861557823", "广西柳州市",
"86176206", "广东省佛山市",
"861887639", "福建省泉州市",
"861551967", "贵州省六盘水市",
"861477330", "湖南省株洲市",
"86153736", "河北省石家庄市",
"861810557", "安徽省宿州市",
"861553319", "河北省邢台市",
"861781707", "广东省阳江市",
"861533126", "河南省开封市",
"861550749", "湖南省长沙市",
"861375788", "浙江省温州市",
"861380743", "湖南省永州市",
"861591714", "广东省汕尾市",
"861366332", "河北省保定市",
"861538396", "河北省廊坊市",
"861531989", "陕西省铜川市",
"861472719", "浙江省湖州市",
"861381478", "江苏省常州市",
"861813441", "河南省郑州市",
"861831293", "浙江省温州市",
"861880385", "河南省焦作市",
"861898758", "云南省昆明市",
"861774070", "西藏日喀则地区",
"861471780", "山西省太原市",
"861573524", "山西省太原市",
"861534693", "甘肃省平凉市",
"861318408", "山东省菏泽市",
"861580597", "福建省泉州市",
"861560648", "山东省青岛市",
"861532910", "贵州省贵阳市",
"861806622", "浙江省金华市",
"861858894", "广东省广州市",
"861360612", "江苏省常州市",
"861899730", "青海省海东地区",
"861377925", "新疆昌吉回族自治州",
"861594737", "内蒙古鄂尔多斯市",
"86186554", "安徽省淮南市",
"861591299", "云南省普洱市",
"86132632", "北京市",
"861840906", "新疆阿勒泰地区",
"86182555", "安徽省马鞍山市",
"861524096", "云南省丽江市",
"861804354", "吉林省长春市",
"861894699", "广东省汕头市",
"861333684", "浙江省湖州市",
"861500156", "新疆巴音郭楞蒙古自治州",
"861862924", "陕西省西安市",
"861817757", "广西贵港市",
"861363673", "陕西省咸阳市",
"861852428", "辽宁省阜新市",
"861582992", "陕西省西安市",
"861881535", "山东省烟台市",
"861577163", "陕西省渭南市",
"861329480", "内蒙古呼和浩特市",
"86182081", "四川省成都市",
"861841933", "甘肃省白银市",
"86187476", "内蒙古赤峰市",
"861458961", "广东省阳江市",
"861772868", "广东省潮州市",
"861380372", "河南省安阳市",
"861393414", "山西省太原市",
"861372659", "广东省韶关市",
"86133360", "浙江省杭州市",
"861379348", "山东省德州市",
"861347945", "江西省赣州市",
"861869747", "内蒙古呼伦贝尔市",
"861328552", "安徽省蚌埠市",
"861829757", "安徽省宣城市",
"861368542", "山东省青岛市",
"861811522", "江苏省宿迁市",
"861781757", "广东省佛山市",
"861596082", "福建省厦门市",
"861810507", "福建省泉州市",
"861570876", "云南省文山壮族苗族自治州",
"861520562", "安徽省池州市",
"86155916", "陕西省汉中市",
"861378810", "广西防城港市",
"861524031", "江苏省连云港市",
"861801847", "江苏省徐州市",
"861840530", "山东省菏泽市",
"861345893", "四川省乐山市",
"861554574", "黑龙江省鸡西市",
"861327430", "吉林省长春市",
"861890580", "浙江省舟山市",
"861396631", "安徽省六安市",
"861768523", "贵州省安顺市",
"861399945", "新疆阿勒泰地区",
"86156820", "四川省成都市",
"861819879", "广东省珠海市",
"861826060", "江苏省镇江市",
"861318458", "江西省南昌市",
"861371748", "广东省佛山市",
"861318327", "河南省开封市",
"86180083", "重庆市",
"86594", "福建省莆田市",
"861535949", "福建省泉州市",
"861898708", "云南省大理白族自治州",
"861317178", "河北省邯郸市",
"861787522", "广东省河源市",
"861558181", "山西省太原市",
"861308166", "山东省潍坊市",
"861370473", "内蒙古包头市",
"861804547", "黑龙江省哈尔滨市",
"861813299", "河北省沧州市",
"861365868", "山东省青岛市",
"861509540", "甘肃省兰州市",
"861536541", "江苏省徐州市",
"86185592", "福建省厦门市",
"861390311", "河北省石家庄市",
"861569028", "河北省沧州市",
"86130719", "浙江省宁波市",
"86182550", "安徽省滁州市",
"861840956", "宁夏固原市",
"861834421", "广东省阳江市",
"861373412", "山西省临汾市",
"861895943", "福建省宁德市",
"861471895", "西藏昌都地区",
"86155867", "湖北省随州市",
"861812176", "江苏省徐州市",
"861527762", "广西玉林市",
"86180370", "河南省商丘市",
"861538331", "河北省石家庄市",
"861820322", "河北省石家庄市",
"86137506", "浙江省台州市",
"861893362", "广东省梅州市",
"861328668", "广东省深圳市",
"861362892", "西藏日喀则地区",
"86158246", "河南省安阳市",
"861526848", "浙江省绍兴市",
"861514146", "辽宁省铁岭市",
"861843275", "河北省唐山市",
"86136026", "广东省深圳市",
"861864804", "内蒙古锡林郭勒盟",
"86134617", "河南省濮阳市",
"861500972", "青海省海东地区",
"861522967", "陕西省宝鸡市",
"861803784", "河南省驻马店市",
"861810344", "山西省运城市",
"861829707", "青海省海西蒙古族藏族自治州",
"861805238", "江苏省淮安市",
"861328502", "福建省福州市",
"861708349", "山西省长治市",
"86188637", "山东省济宁市",
"861812902", "新疆哈密地区",
"861453283", "山西省忻州市",
"861550981", "辽宁省沈阳市",
"861576512", "黑龙江省佳木斯市",
"861805032", "福建省福州市",
"861337757", "广东省佛山市",
"861475708", "浙江省台州市",
"861319776", "广西百色市",
"861707389", "河南省平顶山市",
"861303527", "湖北省十堰市",
"861531232", "江苏省淮安市",
"861889719", "青海省海西蒙古族藏族自治州",
"861310251", "河北省秦皇岛市",
"861316017", "江苏省盐城市",
"861325727", "湖北省襄樊市",
"86152923", "新疆阿克苏地区",
"861533260", "陕西省榆林市",
"861806496", "四川省成都市",
"861894518", "黑龙江省双鸭山市",
"861332952", "黑龙江省齐齐哈尔市",
"861865210", "江苏省连云港市",
"861700635", "山东省聊城市",
"861560650", "浙江省杭州市",
"861304499", "江西省萍乡市",
"86151723", "湖北省武汉市",
"861898740", "云南省曲靖市",
"861520640", "山东省菏泽市",
"86186678", "浙江省宁波市",
"861567244", "湖北省黄冈市",
"861889294", "新疆吐鲁番地区",
"861330557", "安徽省宿州市",
"861535224", "甘肃省陇南市",
"861554659", "黑龙江省鹤岗市",
"86135990", "福建省福州市",
"861874282", "新疆喀什地区",
"861384653", "黑龙江省黑河市",
"86189425", "湖南省长沙市",
"861822778", "四川省攀枝花市",
"861557141", "湖北省十堰市",
"861351157", "江苏省南通市",
"861571682", "河北省邯郸市",
"861346528", "山东省东营市",
"861779904", "新疆和田地区",
"861882933", "陕西省渭南市",
"861452868", "青海省西宁市",
"861847476", "湖南省永州市",
"861866704", "浙江省杭州市",
"861335534", "山东省德州市",
"861369488", "江西省南昌市",
"861370862", "云南省德宏傣族景颇族自治州",
"861390977", "青海省海西蒙古族藏族自治州",
"861359984", "福建省宁德市",
"861508906", "西藏那曲地区",
"861838408", "四川省南充市",
"861369532", "山东省青岛市",
"861526800", "浙江省舟山市",
"861320576", "浙江省台州市",
"861335817", "江苏省常州市",
"86158369", "河南省平顶山市",
"861308220", "辽宁省朝阳市",
"861375191", "广东省汕尾市",
"86159888", "浙江省杭州市",
"861337707", "广西柳州市",
"861377903", "新疆克孜勒苏柯尔克孜自治州",
"861517020", "江西省南昌市",
"861475758", "浙江省绍兴市",
"861367438", "吉林省松原市",
"861357934", "新疆喀什地区",
"861332176", "广西百色市",
"861899476", "江苏省常州市",
"861473020", "河北省沧州市",
"861553535", "山西省太原市",
"86134376", "广东省惠州市",
"861314421", "广东省江门市",
"861860775", "广西玉林市",
"86188957", "安徽省宿州市",
"861871487", "安徽省马鞍山市",
"861350094", "吉林省松原市",
"861325860", "黑龙江省佳木斯市",
"861304241", "辽宁省沈阳市",
"861346444", "辽宁省朝阳市",
"861332902", "安徽省蚌埠市",
"861850443", "吉林省长春市",
"861509558", "甘肃省庆阳市",
"861538567", "安徽省亳州市",
"861834994", "四川省成都市",
"861330344", "山西省晋中市",
"861333714", "内蒙古兴安盟",
"86177793", "江西省上饶市",
"861557805", "广西百色市",
"861786507", "山东省临沂市",
"861318440", "浙江省衢州市",
"861560600", "福建省厦门市",
"861535781", "安徽省铜陵市",
"86151928", "山东省临沂市",
"861339879", "云南省普洱市",
"861531414", "山东省日照市",
"861816722", "浙江省宁波市",
"861880526", "江苏省泰州市",
"861341119", "广东省广州市",
"861527204", "湖北省黄石市",
"861471610", "广东省珠海市",
"861825012", "福建省龙岩市",
"861573450", "黑龙江省哈尔滨市",
"861323824", "辽宁省营口市",
"861700398", "河南省三门峡市",
"861390864", "湖北省武汉市",
"861769839", "河南省南阳市",
"861506340", "山东省莱芜市",
"861360782", "广西柳州市",
"861823634", "河南省周口市",
"861539341", "甘肃省庆阳市",
"86182346", "山西省晋城市",
"86159160", "广东省佛山市",
"86150921", "山东省青岛市",
"861770569", "安徽省合肥市",
"861330507", "福建省泉州市",
"861557086", "湖南省长沙市",
"86187686", "贵州省六盘水市",
"861379300", "山东省菏泽市",
"861807073", "广西南宁市",
"861534437", "吉林省长春市",
"861513818", "河南省三门峡市",
"861518261", "四川省自贡市",
"861839430", "甘肃省白银市",
"861779954", "新疆喀什地区",
"861477818", "广东省茂名市",
"861550270", "湖北省襄樊市",
"86134597", "福建省龙岩市",
"86132801", "山东省潍坊市",
"861894284", "四川省成都市",
"861530915", "陕西省安康市",
"861838458", "四川省广元市",
"861508956", "广东省阳江市",
"861862436", "辽宁省大连市",
"861809467", "浙江省绍兴市",
"861342180", "广东省深圳市",
"861313842", "广东省汕头市",
"861472689", "四川省南充市",
"861809426", "江苏省苏州市",
"861301902", "黑龙江省鹤岗市",
"86132659", "广东省广州市",
"861539928", "陕西省榆林市",
"861347739", "湖北省荆门市",
"86183739", "湖南省邵阳市",
"861572775", "江西省赣州市",
"861459687", "新疆石河子市",
"861840643", "山西省临汾市",
"861827246", "湖北省孝感市",
"861867256", "湖北省荆州市",
"861337914", "陕西省商洛市",
"861516140", "江苏省扬州市",
"861305071", "辽宁省阜新市",
"861324425", "吉林省通化市",
"861477074", "江西省吉安市",
"861333907", "安徽省宿州市",
"861874745", "内蒙古锡林郭勒盟",
"861881189", "广东省揭阳市",
"861301176", "山东省德州市",
"861775208", "甘肃省庆阳市",
"861872600", "安徽省马鞍山市",
"861334671", "河南省平顶山市",
"861880567", "安徽省阜阳市",
"861811392", "四川省南充市",
"86134796", "江西省吉安市",
"86170017", "上海市",
"861338449", "吉林省长春市",
"861390589", "浙江省金华市",
"861810498", "辽宁省阜新市",
"861537345", "河北省石家庄市",
"861563691", "黑龙江省绥化市",
"861589702", "青海省海东地区",
"861319870", "四川省眉山市",
"861770884", "云南省临沧市",
"861882962", "陕西省榆林市",
"86133418", "上海市",
"861876509", "山东省滨州市",
"861824066", "河南省新乡市",
"861594669", "黑龙江省鸡西市",
"861369563", "安徽省宣城市",
"861848513", "贵州省贵阳市",
"861571403", "辽宁省铁岭市",
"861321678", "浙江省绍兴市",
"861340539", "山东省临沂市",
"861350804", "四川省资阳市",
"861551434", "河南省周口市",
"861550935", "甘肃省武威市",
"861573394", "河北省承德市",
"861313290", "广西南宁市",
"861580458", "黑龙江省伊春市",
"861399492", "山西省朔州市",
"861580327", "河北省沧州市",
"861566292", "吉林省辽源市",
"861362258", "广东省汕头市",
"861327870", "云南省昭通市",
"861844725", "内蒙古包头市",
"861322248", "江苏省泰州市",
"86177080", "四川省成都市",
"861452794", "新疆巴音郭楞蒙古自治州",
"861570436", "吉林省白城市",
"861302522", "广东省汕头市",
"861563636", "黑龙江省牡丹江市",
"861323976", "新疆和田地区",
"861374930", "河南省濮阳市",
"861347492", "内蒙古包头市",
"861886781", "浙江省丽水市",
"861539016", "四川省甘孜藏族自治州",
"861301952", "内蒙古呼伦贝尔市",
"86185919", "陕西省西安市",
"861345349", "山西省临汾市",
"861816415", "湖北省黄冈市",
"861885149", "江苏省连云港市",
"861362779", "广西北海市",
"861388468", "山东省德州市",
"861320255", "广东省揭阳市",
"861356875", "四川省雅安市",
"861338291", "江苏省宿迁市",
"861559851", "内蒙古兴安盟",
"861333957", "黑龙江省鸡西市",
"861502741", "河北省石家庄市",
"861808944", "甘肃省天水市",
"861518372", "四川省阿坝藏族羌族自治州",
"861566746", "陕西省汉中市",
"861390798", "江西省景德镇市",
"861559145", "陕西省汉中市",
"86177551", "安徽省合肥市",
"861350854", "贵州省黔南布依族苗族自治州",
"861768393", "湖北省襄樊市",
"861571453", "黑龙江省牡丹江市",
"86151245", "黑龙江省哈尔滨市",
"861507683", "河北省衡水市",
"861325766", "广东省云浮市",
"861855627", "江苏省宿迁市",
"861334154", "吉林省吉林市",
"861355837", "广西钦州市",
"861399739", "青海省海西蒙古族藏族自治州",
"861760764", "广东省东莞市",
"861881628", "江苏省苏州市",
"86188249", "广东省中山市",
"861300927", "辽宁省铁岭市",
"861866917", "云南省昆明市",
"861474049", "辽宁省葫芦岛市",
"861476543", "山东省济南市",
"861565118", "江苏省苏州市",
"861399519", "宁夏银川市",
"861776561", "广东省佛山市",
"861892444", "广东省揭阳市",
"861562990", "湖北省黄石市",
"861528891", "山东省泰安市",
"861809498", "新疆伊犁哈萨克自治州",
"861303071", "辽宁省抚顺市",
"861539996", "湖南省永州市",
"861458547", "河南省三门峡市",
"861508816", "广东省潮州市",
"861330692", "福建省福州市",
"861530855", "贵州省黔东南苗族侗族自治州",
"861355734", "广西梧州市",
"861325152", "黑龙江省齐齐哈尔市",
"861477958", "江西省宜春市",
"861335907", "安徽省宿州市",
"861537981", "甘肃省酒泉市",
"86182815", "四川省绵阳市",
"861874053", "陕西省渭南市",
"861318483", "广东省揭阳市",
"86130679", "浙江省杭州市",
"86186814", "广东省深圳市",
"861372123", "安徽省马鞍山市",
"86182747", "湖南省衡阳市",
"861350757", "福建省三明市",
"86177573", "浙江省嘉兴市",
"861556038", "内蒙古赤峰市",
"861893656", "江苏省连云港市",
"861850480", "内蒙古呼伦贝尔市",
"861316778", "安徽省六安市",
"861360370", "河南省商丘市",
"861589166", "陕西省汉中市",
"861881631", "山东省威海市",
"861800439", "吉林省白山市",
"861700367", "广东省东莞市",
"861312411", "辽宁省大连市",
"861816107", "四川省宜宾市",
"861879705", "青海省海东地区",
"861366486", "内蒙古赤峰市",
"861572965", "四川省内江市",
"861579429", "江苏省南京市",
"86139137", "江苏省苏州市",
"861864489", "吉林省通化市",
"861315290", "山西省忻州市",
"861810426", "辽宁省大连市",
"861818134", "四川省成都市",
"861572647", "山东省东营市",
"861700139", "四川省成都市",
"861814206", "浙江省温州市",
"861566883", "辽宁省丹东市",
"861536874", "云南省曲靖市",
"861459361", "贵州省黔南布依族苗族自治州",
"861458304", "江西省鹰潭市",
"861380610", "江苏省镇江市",
"861773779", "河南省郑州市",
"861873901", "河南省南阳市",
"861822017", "陕西省西安市",
"861551541", "河南省漯河市",
"861510633", "山东省日照市",
"861530141", "江苏省盐城市",
"861378948", "内蒙古巴彦淖尔市",
"861337094", "山东省烟台市",
"86183669", "山东省东营市",
"861885018", "福建省厦门市",
"861359322", "山西省忻州市",
"861837443", "湖南省张家界市",
"861761475", "内蒙古通辽市",
"861452897", "云南省昆明市",
"861821871", "广东省深圳市",
"861321863", "江苏省盐城市",
"861522541", "河南省洛阳市",
"861335957", "黑龙江省齐齐哈尔市",
"861325102", "浙江省杭州市",
"861843466", "山西省朔州市",
"861331435", "吉林省通化市",
"861871305", "河北省沧州市",
"86138742", "湖南省邵阳市",
"861893606", "江苏省无锡市",
"861898783", "云南省楚雄彝族自治州",
"861521466", "黑龙江省佳木斯市",
"86158804", "福建省福州市",
"861520683", "山东省临沂市",
"861350707", "江西省赣州市",
"861322722", "湖北省随州市",
"861330934", "甘肃省庆阳市",
"861373045", "河北省保定市",
"861554105", "辽宁省朝阳市",
"86182810", "四川省德阳市",
"861760720", "湖北省宜昌市",
"861319927", "黑龙江省伊春市",
"861770787", "广西钦州市",
"861800792", "江西省九江市",
"861760974", "青海省海南藏族自治州",
"86177734", "湖南省衡阳市",
"861597236", "湖北省黄石市",
"861786934", "云南省临沧市",
"861332812", "江苏省扬州市",
"861538789", "江西省宜春市",
"861892711", "广东省潮州市",
"861576763", "广东省深圳市",
"861816157", "宁夏银川市",
"861370150", "江苏省常州市",
"861537270", "浙江省衢州市",
"861539931", "陕西省渭南市",
"861814256", "四川省绵阳市",
"861390726", "湖北省恩施土家族苗族自治州",
"861788907", "西藏阿里地区",
"861556989", "甘肃省陇南市",
"861398029", "四川省巴中市",
"861323766", "江西省赣州市",
"861536645", "江苏省盐城市",
"861532848", "四川省宜宾市",
"861475613", "河北省石家庄市",
"861347519", "山东省德州市",
"861340294", "陕西省西安市",
"861338865", "浙江省金华市",
"861458354", "山东省东营市",
"861533735", "湖北省十堰市",
"861597449", "湖南省常德市",
"861373329", "河北省邢台市",
"861709949", "浙江省嘉兴市",
"86177351", "山西省太原市",
"861891958", "青海省海西蒙古族藏族自治州",
"861888095", "四川省达州市",
"861820419", "辽宁省辽阳市",
"861707048", "浙江省衢州市",
"861774944", "河南省焦作市",
"861529708", "青海省西宁市",
"861351415", "辽宁省丹东市",
"861888805", "江苏省南通市",
"861453892", "云南省大理白族自治州",
"861816248", "湖北省黄石市",
"861887589", "浙江省嘉兴市",
"861870551", "安徽省合肥市",
"861535260", "新疆石河子市",
"86147523", "江苏省淮安市",
"86187722", "湖北省十堰市",
"86184406", "新疆乌鲁木齐市",
"86181560", "安徽省合肥市",
"861780250", "江苏省无锡市",
"861520452", "黑龙江省齐齐哈尔市",
"861558726", "云南省大理白族自治州",
"861517708", "广西南宁市",
"861323727", "湖北省荆门市",
"861380023", "重庆市",
"861550029", "吉林省白城市",
"86135494", "广东省东莞市",
"861534351", "山西省太原市",
"861806428", "湖北省荆门市",
"861305527", "福建省福州市",
"861778771", "云南省玉溪市",
"861360418", "辽宁省沈阳市",
"861302435", "江苏省镇江市",
"861815684", "安徽省阜阳市",
"86183004", "山东省临沂市",
"861350914", "陕西省商洛市",
"861537935", "甘肃省武威市",
"861507640", "河北省石家庄市",
"861773147", "河北省唐山市",
"861458490", "山东省淄博市",
"861333817", "江苏省常州市",
"861314438", "吉林省松原市",
"861361312", "河北省保定市",
"861335441", "山东省淄博市",
"861333534", "陕西省渭南市",
"861367421", "辽宁省辽阳市",
"861820607", "福建省厦门市",
"861300776", "青海省西宁市",
"861517279", "湖北省随州市",
"861888086", "四川省德阳市",
"861592456", "内蒙古赤峰市",
"861881685", "广东省深圳市",
"861880789", "广西北海市",
"861787644", "广东省湛江市",
"861598707", "云南省玉溪市",
"861528051", "福建省南平市",
"861301812", "四川省南充市",
"861533224", "陕西省渭南市",
"861576499", "内蒙古乌兰察布市",
"861843427", "山西省运城市",
"861871593", "河北省承德市",
"861550345", "山西省太原市",
"861388497", "山东省青岛市",
"861373136", "河北省衡水市",
"861593644", "河南省南阳市",
"861337804", "湖南省衡阳市",
"861802578", "广东省汕尾市",
"861569748", "湖南省长沙市",
"861870990", "新疆克拉玛依市",
"861316997", "广东省佛山市",
"861533781", "广东省茂名市",
"861868834", "广东省惠州市",
"86151021", "上海市",
"861346531", "山东省济南市",
"861390820", "四川省成都市",
"861324488", "广东省深圳市",
"86170937", "河南省郑州市",
"861323860", "云南省昭通市",
"861396581", "安徽省安庆市",
"86150028", "四川省成都市",
"861890630", "山东省威海市",
"861369712", "湖北省孝感市",
"861324532", "山东省青岛市",
"861820073", "广东省肇庆市",
"861506113", "江苏省常州市",
"861321832", "江苏省淮安市",
"861780200", "广东省广州市",
"861810467", "黑龙江省鸡西市",
"861336042", "广东省惠州市",
"86189924", "陕西省商洛市",
"861373191", "安徽省宣城市",
"861539985", "湖南省永州市",
"86158569", "安徽省合肥市",
"861500204", "广东省广州市",
"861842715", "湖北省咸宁市",
"861534301", "湖南省长沙市",
"861559649", "陕西省铜川市",
"861517064", "江西省赣州市",
"861700326", "河北省石家庄市",
"861860965", "安徽省合肥市",
"86158250", "云南省曲靖市",
"861308264", "山东省临沂市",
"861315842", "四川省达州市",
"861894738", "内蒙古巴彦淖尔市",
"861336200", "浙江省衢州市",
"861598757", "云南省德宏傣族景颇族自治州",
"861592406", "浙江省衢州市",
"861473064", "河北省唐山市",
"861568186", "四川省自贡市",
"861820657", "山东省滨州市",
"861328462", "黑龙江省哈尔滨市",
"861880598", "福建省三明市",
"861860647", "山东省济宁市",
"861888141", "四川省内江市",
"861556577", "河南省南阳市",
"861582584", "甘肃省平凉市",
"861576732", "广东省肇庆市",
"861599295", "广东省韶关市",
"861348341", "河北省邯郸市",
"861760826", "四川省广安市",
"86182546", "山东省东营市",
"861366495", "广东省阳江市",
"861337854", "贵州省黔南布依族苗族自治州",
"86136182", "重庆市",
"861823012", "河北省保定市",
"861322415", "辽宁省丹东市",
"861575450", "黑龙江省哈尔滨市",
"861331481", "内蒙古呼伦贝尔市",
"861510558", "安徽省阜阳市",
"861450409", "辽宁省大连市",
"86156423", "辽宁省大连市",
"861310037", "湖南省益阳市",
"861399596", "湖北省黄石市",
"861785837", "浙江省湖州市",
"861525906", "福建省宁德市",
"861560350", "山西省忻州市",
"861535864", "江苏省南通市",
"861338288", "江苏省无锡市",
"861339024", "辽宁省沈阳市",
"861340000", "江苏省无锡市",
"861520340", "山西省太原市",
"861377460", "福建省福州市",
"861570532", "山东省青岛市",
"861354175", "四川省绵阳市",
"86138949", "吉林省松原市",
"861539919", "陕西省铜川市",
"861570488", "内蒙古鄂尔多斯市",
"861550777", "广西钦州市",
"861569862", "山西省临汾市",
"86181330", "安徽省安庆市",
"861330875", "云南省保山市",
"861803314", "广东省江门市",
"861317997", "新疆阿克苏地区",
"861479710", "山西省朔州市",
"861500850", "贵州省黔东南苗族侗族自治州",
"86131104", "陕西省西安市",
"86181478", "内蒙古鄂尔多斯市",
"86145313", "天津市",
"861347531", "山东省济南市",
"86186802", "广东省广州市",
"861561986", "陕西省延安市",
"861760835", "四川省雅安市",
"861820431", "吉林省长春市",
"861780854", "贵州省黔南布依族苗族自治州",
"861315054", "云南省曲靖市",
"86180471", "内蒙古呼和浩特市",
"861800744", "湖南省张家界市",
"861313978", "新疆塔城地区",
"861813384", "河北省石家庄市",
"86189296", "广东省汕头市",
"861878828", "云南省红河哈尼族彝族自治州",
"861859678", "福建省福州市",
"861772194", "四川省南充市",
"861510943", "甘肃省白银市",
"861398998", "西藏拉萨市",
"861388656", "湖北省荆州市",
"861336854", "贵州省黔南布依族苗族自治州",
"861322489", "内蒙古巴彦淖尔市",
"861379650", "黑龙江省伊春市",
"861893540", "山西省晋中市",
"861516064", "福建省三明市",
"86159135", "广东省湛江市",
"861807544", "安徽省铜陵市",
"861321410", "辽宁省铁岭市",
"861572937", "河南省郑州市",
"861308727", "湖南省益阳市",
"861390781", "广西南宁市",
"861337200", "江苏省南京市",
"861830882", "云南省曲靖市",
"861533820", "广东省惠州市",
"861340731", "湖南省长沙市",
"861776979", "浙江省舟山市",
"861768964", "福建省三明市",
"861555526", "安徽省亳州市",
"861595344", "山东省德州市",
"861769901", "新疆塔城地区",
"861869779", "河南省洛阳市",
"861454445", "江西省宜春市",
"861869258", "湖南省湘西土家族苗族自治州",
"86130501", "辽宁省抚顺市",
"861595557", "安徽省宿州市",
"861565946", "福建省厦门市",
"861323264", "广东省河源市",
"861516708", "浙江省衢州市",
"861560300", "广东省广州市",
"861312439", "吉林省白山市",
"861343851", "四川省自贡市",
"861802065", "福建省漳州市",
"861807428", "浙江省丽水市",
"861330644", "山东省济南市",
"861537926", "甘肃省庆阳市",
"861306576", "浙江省绍兴市",
"861575773", "浙江省杭州市",
"861535977", "福建省莆田市",
"861301430", "河北省保定市",
"861817248", "广西钦州市",
"861861379", "河南省洛阳市",
"86139448", "吉林省长春市",
"861351489", "内蒙古包头市",
"861362571", "浙江省杭州市",
"861518821", "河南省南阳市",
"861862563", "河南省濮阳市",
"861590534", "山东省德州市",
"86158339", "河北省石家庄市",
"861340796", "江西省吉安市",
"86159975", "湖北省宜昌市",
"86187622", "江苏省徐州市",
"861315004", "甘肃省临夏回族自治州",
"861378395", "河南省漯河市",
"861804579", "黑龙江省鸡西市",
"861771409", "江苏省苏州市",
"861331467", "黑龙江省鸡西市",
"861399531", "宁夏银川市",
"861527133", "湖北省随州市",
"861573963", "新疆昌吉回族自治州",
"861533767", "浙江省温州市",
"861772022", "湖北省武汉市",
"861338837", "四川省内江市",
"861591384", "广东省东莞市",
"861459117", "广西桂林市",
"861398149", "四川省达州市",
"861396567", "安徽省合肥市",
"861308860", "浙江省台州市",
"861338514", "贵州省贵阳市",
"861536935", "河北省石家庄市",
"861501762", "广东省深圳市",
"861814068", "湖北省武汉市",
"861563688", "黑龙江省鸡西市",
"861700698", "广东省中山市",
"861302426", "浙江省湖州市",
"861810481", "内蒙古鄂尔多斯市",
"861318075", "吉林省吉林市",
"861554309", "吉林省长春市",
"86159130", "广东省潮州市",
"861708377", "河南省南阳市",
"86182473", "内蒙古乌海市",
"86186951", "宁夏银川市",
"861800411", "辽宁省大连市",
"861558735", "山东省烟台市",
"861325220", "浙江省湖州市",
"861820496", "内蒙古通辽市",
"861570170", "甘肃省庆阳市",
"861332430", "吉林省长春市",
"861364968", "云南省昭通市",
"861847572", "广东省中山市",
"861334371", "河南省郑州市",
"861521713", "广东省东莞市",
"861390735", "湖南省郴州市",
"861300274", "山东省烟台市",
"861889728", "青海省西宁市",
"86185482", "内蒙古兴安盟",
"86135463", "山西省太原市",
"861893497", "广西南宁市",
"861535798", "安徽省淮南市",
"861771617", "四川省宜宾市",
"861534849", "湖南省张家界市",
"861302467", "浙江省金华市",
"861320472", "内蒙古包头市",
"861369436", "吉林省白城市",
"86177634", "山东省莱芜市",
"861371999", "广东省梅州市",
"861336094", "广东省汕尾市",
"861459387", "贵州省黔西南布依族苗族自治州",
"861531549", "山东省临沂市",
"861550149", "江苏省苏州市",
"861380143", "江苏省泰州市",
"861894529", "黑龙江省大庆市",
"861453675", "陕西省延安市",
"861569833", "山西省太原市",
"861889511", "宁夏银川市",
"86185295", "广东省深圳市",
"861570563", "安徽省宣城市",
"86138642", "山东省青岛市",
"861839902", "新疆哈密地区",
"861331426", "辽宁省大连市",
"861524150", "辽宁省锦州市",
"861376813", "广西桂林市",
"861346519", "山东省德州市",
"861857293", "湖北省荆州市",
"861596449", "山东省淄博市",
"861806592", "福建省厦门市",
"861587197", "湖北省襄樊市",
"861348809", "陕西省汉中市",
"861869147", "陕西省延安市",
"861820485", "内蒙古包头市",
"86187416", "辽宁省锦州市",
"861760881", "云南省怒江傈僳族自治州",
"861580627", "江苏省南通市",
"861881407", "广东省梅州市",
"861534523", "江苏省泰州市",
"861840772", "广西柳州市",
"861334233", "辽宁省辽阳市",
"861597225", "湖北省襄樊市",
"86180315", "河北省唐山市",
"86155136", "山西省太原市",
"861537967", "宁夏固原市",
"861317259", "广东省潮州市",
"861817157", "湖北省恩施土家族苗族自治州",
"861500756", "广东省珠海市",
"861568121", "四川省绵阳市",
"861531823", "山东省临沂市",
"861392476", "广东省汕头市",
"861508059", "福建省三明市",
"861870323", "河北省张家口市",
"861821984", "甘肃省庆阳市",
"861536270", "广东省中山市",
"861557989", "江西省赣州市",
"861559088", "黑龙江省哈尔滨市",
"86138257", "广东省东莞市",
"861537645", "山东省烟台市",
"861323413", "辽宁省抚顺市",
"861894843", "广东省揭阳市",
"861700381", "河南省洛阳市",
"86177853", "贵州省贵阳市",
"861559939", "贵州省黔西南布依族苗族自治州",
"861536981", "河北省沧州市",
"861389933", "新疆哈密地区",
"861887260", "湖北省武汉市",
"86130779", "江西省南昌市",
"861509980", "广东省汕尾市",
"86182647", "山东省济宁市",
"861453844", "四川省巴中市",
"861313797", "河南省三门峡市",
"861810435", "吉林省通化市",
"861300069", "广西南宁市",
"861352378", "河南省开封市",
"861317778", "江西省南昌市",
"861535589", "浙江省金华市",
"861862488", "河南省安阳市",
"861308766", "陕西省咸阳市",
"861814917", "陕西省宝鸡市",
"861862532", "河南省驻马店市",
"861393141", "河北省承德市",
"861895306", "山东省东营市",
"861399585", "湖北省孝感市",
"861560494", "辽宁省本溪市",
"861550998", "新疆喀什地区",
"861880422", "辽宁省鞍山市",
"861513543", "山西省晋中市",
"86187387", "河南省南阳市",
"86185290", "广东省揭阳市",
"861329778", "广西河池市",
"861589047", "河南省濮阳市",
"861348859", "内蒙古赤峰市",
"861884040", "陕西省西安市",
"861375470", "山东省临沂市",
"86131892", "广东省中山市",
"861803184", "河北省石家庄市",
"861839952", "新疆和田地区",
"86182252", "重庆市",
"861501733", "广东省中山市",
"861310578", "浙江省丽水市",
"861787692", "广东省东莞市",
"861356557", "新疆伊犁哈萨克自治州",
"861514746", "内蒙古乌兰察布市",
"861335216", "辽宁省丹东市",
"861571960", "甘肃省临夏回族自治州",
"861881457", "黑龙江省大兴安岭地区",
"861863078", "河北省唐山市",
"861881328", "广东省河源市",
"861860937", "甘肃省酒泉市",
"861573932", "新疆石河子市",
"861367486", "内蒙古赤峰市",
"86180310", "河北省邯郸市",
"861527162", "湖北省黄冈市",
"861477829", "广东省湛江市",
"861857376", "湖南省衡阳市",
"861767905", "江西省宜春市",
"861847130", "湖北省黄冈市",
"861897180", "湖北省咸宁市",
"861471478", "广东省潮州市",
"861770761", "广东省汕尾市",
"861470743", "湖南省湘西土家族苗族自治州",
"861582070", "广东省惠州市",
"861511497", "陕西省宝鸡市",
"861341131", "广东省阳江市",
"861520930", "甘肃省临夏回族自治州",
"861360670", "浙江省杭州市",
"861840962", "宁夏石嘴山市",
"861345036", "广东省广州市",
"861700667", "山东省临沂市",
"861881331", "广东省梅州市",
"861774012", "四川省泸州市",
"861504813", "内蒙古呼伦贝尔市",
"861572504", "山东省日照市",
"861700945", "江苏省南京市",
"861567746", "广西贺州市",
"861532972", "贵州省遵义市",
"861889796", "江西省吉安市",
"861373188", "安徽省宣城市",
"861330392", "河南省鹤壁市",
"861806419", "湖北省黄石市",
"861314486", "广东省东莞市",
"861470886", "云南省怒江傈僳族自治州",
"861870759", "广东省湛江市",
"861533798", "新疆伊犁哈萨克自治州",
"861360429", "辽宁省葫芦岛市",
"861350042", "辽宁省鞍山市",
"861807485", "广西玉林市",
"861454584", "甘肃省庆阳市",
"861817415", "广西桂林市",
"861592552", "云南省昭通市",
"861396598", "安徽省滁州市",
"861324491", "广东省江门市",
"861560546", "山东省东营市",
"861590957", "宁夏固原市",
"86186398", "河南省三门峡市",
"861510333", "河北省张家口市",
"861520556", "安徽省安庆市",
"861868765", "云南省文山壮族苗族自治州",
"861458604", "湖北省鄂州市",
"86139224", "广东省广州市",
"86180515", "江苏省无锡市",
"861331498", "福建省泉州市",
"861459661", "新疆喀什地区",
"861818203", "湖南省岳阳市",
"861380310", "河北省邯郸市",
"861319274", "广东省河源市",
"861557021", "江西省九江市",
"861364778", "广西河池市",
"861354679", "山西省朔州市",
"861575694", "四川省攀枝花市",
"861530577", "浙江省温州市",
"861511306", "广东省汕头市",
"861584673", "黑龙江省哈尔滨市",
"861308152", "内蒙古呼和浩特市",
"861863904", "河南省商丘市",
"861450317", "河北省沧州市",
"861886820", "浙江省湖州市",
"861453747", "湖南省衡阳市",
"861386630", "安徽省淮南市",
"861880581", "浙江省杭州市",
"861470005", "福建省厦门市",
"861517140", "湖北省十堰市",
"861515543", "安徽省淮南市",
"861452285", "山西省长治市",
"86187587", "浙江省温州市",
"861571770", "广西防城港市",
"861305433", "黑龙江省牡丹江市",
"861592668", "湖北省荆门市",
"861571924", "陕西省商洛市",
"861899853", "广东省江门市",
"861500162", "新疆石河子市",
"861893306", "广东省潮州市",
"861309578", "浙江省丽水市",
"861572554", "山东省烟台市",
"86177871", "云南省昆明市",
"861364259", "广东省韶关市",
"861533589", "湖北省武汉市",
"861894786", "内蒙古乌兰察布市",
"861569150", "陕西省宝鸡市",
"861346739", "湖南省邵阳市",
"861398645", "湖北省孝感市",
"861870709", "江西省萍乡市",
"861871605", "河北省唐山市",
"861770971", "青海省西宁市",
"861529140", "陕西省西安市",
"861395141", "江苏省南通市",
"861324249", "广东省江门市",
"861362027", "广东省揭阳市",
"861536029", "广东省河源市",
"86183639", "山东省青岛市",
"861328566", "安徽省宿州市",
"861372080", "福建省漳州市",
"861826246", "江苏省徐州市",
"861357644", "江西省萍乡市",
"861550926", "陕西省安康市",
"861378872", "广西柳州市",
"861344013", "四川省雅安市",
"86185604", "山东省青岛市",
"861350250", "广东省潮州市",
"861813922", "新疆伊犁哈萨克自治州",
"861500910", "陕西省咸阳市",
"861534465", "黑龙江省绥化市",
"861567292", "湖北省十堰市",
"861893583", "新疆克拉玛依市",
"861319069", "内蒙古包头市",
"861308976", "黑龙江省黑河市",
"861317968", "江苏省无锡市",
"861590907", "新疆阿克苏地区",
"861881396", "广东省广州市",
"861886767", "浙江省嘉兴市",
"861575932", "福建省宁德市",
"861475313", "山东省济南市",
"861889731", "青海省海北藏族自治州",
"861809435", "江苏省南通市",
"861780914", "陕西省商洛市",
"86180510", "江苏省南京市",
"861333216", "辽宁省丹东市",
"861329968", "广西玉林市",
"861853458", "山西省长治市",
"861536345", "广东省惠州市",
"86180272", "广东省广州市",
"861511356", "广东省湛江市",
"861521533", "山东省淄博市",
"861454218", "河南省周口市",
"86155997", "新疆阿克苏地区",
"861877509", "广西玉林市",
"861847803", "湖南省衡阳市",
"861358299", "河北省保定市",
"861858197", "四川省成都市",
"861373470", "内蒙古呼伦贝尔市",
"861324436", "吉林省白城市",
"861313054", "辽宁省丹东市",
"861534651", "河南省驻马店市",
"861894795", "内蒙古呼和浩特市",
"861841906", "甘肃省兰州市",
"861347444", "陕西省榆林市",
"86185069", "福建省厦门市",
"861479906", "新疆伊犁哈萨克自治州",
"861815384", "湖南省郴州市",
"861537149", "江苏省苏州市",
"861315978", "吉林省四平市",
"861318302", "河南省许昌市",
"861399528", "宁夏银川市",
"861565129", "江苏省宿迁市",
"861880535", "山东省烟台市",
"861860554", "安徽省淮南市",
"861509943", "新疆伊犁哈萨克自治州",
"86182451", "黑龙江省哈尔滨市",
"861597837", "河南省信阳市",
"861505051", "江苏省宿迁市",
"861787507", "广东省肇庆市",
"86185712", "湖北省恩施土家族苗族自治州",
"86130599", "浙江省湖州市",
"861459405", "云南省昭通市",
"861820544", "山东省滨州市",
"861862425", "辽宁省抚顺市",
"861363022", "陕西省西安市",
"861452296", "山西省太原市",
"861376903", "云南省丽江市",
"861336707", "江西省赣州市",
"861366438", "吉林省松原市",
"861808992", "西藏日喀则地区",
"861776769", "新疆乌鲁木齐市",
"861840933", "甘肃省平凉市",
"861890983", "辽宁省沈阳市",
"861533864", "贵州省铜仁地区",
"861810522", "江苏省徐州市",
"861886726", "湖南省张家界市",
"8618180", "四川省成都市",
"861523906", "河南省驻马店市",
"861338734", "湖南省衡阳市",
"861593507", "山西省晋城市",
"861768920", "福建省厦门市",
"86187786", "广西百色市",
"861398926", "四川省凉山彝族自治州",
"861556086", "内蒙古赤峰市",
"861829722", "青海省海东地区",
"861550967", "宁夏吴忠市",
"86152628", "江苏省南通市",
"861379442", "广东省广州市",
"861328527", "江苏省宿迁市",
"861380478", "内蒙古巴彦淖尔市",
"861362066", "山西省晋中市",
"861472615", "四川省成都市",
"861530989", "辽宁省沈阳市",
"861567840", "广西玉林市",
"861584897", "内蒙古赤峰市",
"861550645", "山东省聊城市",
"861561648", "湖南省常德市",
"86189277", "广东省佛山市",
"861341185", "广东省深圳市",
"861470780", "广西柳州市",
"861313768", "河南省周口市",
"861866575", "广东省湛江市",
"861881385", "广东省惠州市",
"861555598", "安徽省阜阳市",
"861819744", "青海省黄南藏族自治州",
"86132303", "河北省秦皇岛市",
"861361612", "江苏省常州市",
"861771161", "湖南省郴州市",
"86158539", "山东省临沂市",
"861831201", "广东省广州市",
"861450187", "山西省长治市",
"861326776", "广东省汕头市",
"861479956", "新疆博尔塔拉蒙古自治州",
"861807496", "广西梧州市",
"861559349", "甘肃省酒泉市",
"861537998", "甘肃省白银市",
"861841956", "甘肃省张掖市",
"861896610", "浙江省台州市",
"861313004", "辽宁省大连市",
"861534601", "河南省漯河市",
"861308824", "四川省资阳市",
"861329017", "山东省威海市",
"861459455", "陕西省宝鸡市",
"861533977", "甘肃省酒泉市",
"861787557", "广东省广州市",
"861782863", "四川省广安市",
"861552658", "吉林省四平市",
"861359871", "河南省新乡市",
"86151623", "江苏省苏州市",
"861808634", "湖北省黄石市",
"86180846", "海南省海口市",
"86183932", "甘肃省定西市",
"861860504", "福建省泉州市",
"861318352", "四川省巴中市",
"86170967", "湖南省长沙市",
"861454869", "河南省三门峡市",
"861587168", "湖北省武汉市",
"861707315", "河北省唐山市",
"861890330", "河北省邯郸市",
"86181535", "山东省烟台市",
"861336757", "广西贵港市",
"86131308", "辽宁省朝阳市",
"861325264", "吉林省长春市",
"861593557", "山西省运城市",
"861317017", "安徽省亳州市",
"861840380", "黑龙江省鸡西市",
"861781722", "广东省湛江市",
"861811344", "四川省乐山市",
"861889785", "广西玉林市",
"861809481", "新疆巴音郭楞蒙古自治州",
"861528888", "山东省东营市",
"861508217", "四川省绵阳市",
"861390260", "广东省东莞市",
"861867704", "广西防城港市",
"861846476", "山东省枣庄市",
"861521562", "安徽省铜陵市",
"861571876", "云南省昆明市",
"861872546", "云南省曲靖市",
"861830376", "河南省信阳市",
"861398018", "四川省遂宁市",
"86180453", "黑龙江省牡丹江市",
"861843608", "河南省洛阳市",
"861345145", "河北省邯郸市",
"861452231", "浙江省衢州市",
"861820357", "山西省临汾市",
"861893468", "湖北省咸宁市",
"861871461", "黑龙江省哈尔滨市",
"861550874", "云南省曲靖市",
"861894880", "广东省梅州市",
"86131247", "北京市",
"861820428", "辽宁省葫芦岛市",
"86186778", "广西河池市",
"861370748", "湖南省长沙市",
"86180183", "江苏省无锡市",
"861538581", "安徽省阜阳市",
"861364997", "新疆阿克苏地区",
"861555789", "浙江省宁波市",
"86130162", "海南省海口市",
"861523530", "山西省阳泉市",
"861373318", "河南省郑州市",
"861814807", "四川省成都市",
"861302498", "福建省龙岩市",
"861474129", "辽宁省锦州市",
"86170816", "江苏省无锡市",
"861452742", "湖南省湘潭市",
"861347528", "山东省东营市",
"861891200", "江苏省徐州市",
"861325099", "浙江省金华市",
"861768794", "江西省鹰潭市",
"861857941", "广西柳州市",
"861801217", "江苏省连云港市",
"861821888", "广东省广州市",
"861452276", "山西省晋城市",
"861311189", "四川省成都市",
"861470644", "山东省烟台市",
"861535017", "江西省抚州市",
"861811287", "江苏省常州市",
"86156654", "安徽省合肥市",
"861819680", "新疆喀什地区",
"86152655", "山东省聊城市",
"861570062", "四川省成都市",
"861528322", "四川省资阳市",
"861501634", "广东省阳江市",
"861315998", "黑龙江省佳木斯市",
"861571831", "广东省茂名市",
"861846431", "山东省淄博市",
"86185067", "浙江省嘉兴市",
"861783508", "山西省临汾市",
"86150146", "广东省佛山市",
"861804234", "浙江省温州市",
"861539264", "山西省吕梁市",
"861368417", "四川省宜宾市",
"86130597", "浙江省衢州市",
"861779035", "四川省绵阳市",
"861471467", "广东省中山市",
"861824588", "黑龙江省大庆市",
"861538201", "辽宁省葫芦岛市",
"861824432", "四川省眉山市",
"861302180", "河北省石家庄市",
"861332389", "河南省焦作市",
"861330261", "广东省东莞市",
"861882847", "四川省成都市",
"861304364", "湖南省娄底市",
"86189279", "广东省汕尾市",
"861579404", "广东省广州市",
"861352367", "河南省南阳市",
"861590708", "江西省南昌市",
"861317767", "江西省抚州市",
"86187500", "福建省莆田市",
"861361564", "安徽省六安市",
"86130376", "河南省南阳市",
"861323641", "江苏省南京市",
"861478514", "贵州省黔南布依族苗族自治州",
"86150883", "浙江省湖州市",
"861505622", "安徽省合肥市",
"861306444", "河南省安阳市",
"86186020", "广东省广州市",
"861303939", "吉林省白山市",
"861847657", "广东省深圳市",
"861872669", "安徽省亳州市",
"86137475", "内蒙古通辽市",
"86186442", "上海市",
"861453199", "山西省晋城市",
"861516534", "山东省德州市",
"86157948", "四川省成都市",
"861584877", "内蒙古通辽市",
"8618930", "上海市",
"861773900", "河南省商丘市",
"861889870", "广东省东莞市",
"861331310", "河北省邯郸市",
"861366252", "广东省广州市",
"861458329", "江西省吉安市",
"861329767", "湖北省咸宁市",
"861380498", "辽宁省沈阳市",
"861859626", "山东省德州市",
"861594650", "黑龙江省齐齐哈尔市",
"86157743", "吉林省松原市",
"861313018", "辽宁省鞍山市",
"86170969", "新疆乌鲁木齐市",
"861303088", "福建省厦门市",
"861501992", "广东省珠海市",
"86152650", "山东省菏泽市",
"861853263", "河北省张家口市",
"861860518", "江苏省连云港市",
"86152881", "云南省昆明市",
"861306528", "辽宁省盘锦市",
"861815247", "宁夏中卫市",
"861315149", "江苏省苏州市",
"861807476", "广西百色市",
"861860721", "湖北省荆州市",
"861326796", "广东省珠海市",
"861370451", "黑龙江省哈尔滨市",
"861452393", "西藏山南地区",
"861539079", "江西省吉安市",
"86546", "山东省东营市",
"861306711", "福建省福州市",
"861470875", "云南省保山市",
"861323919", "陕西省铜川市",
"86158537", "山东省济宁市",
"861526584", "山东省聊城市",
"861533997", "山东省临沂市",
"861359891", "河南省驻马店市",
"861362716", "湖北省荆州市",
"861364977", "青海省海南藏族自治州",
"861707176", "江西省鹰潭市",
"861340966", "湖北省随州市",
"86131249", "广东省湛江市",
"861776019", "四川省自贡市",
"861343527", "广东省清远市",
"86137338", "河南省郑州市",
"86187505", "福建省泉州市",
"861302478", "浙江省台州市",
"861590758", "广东省肇庆市",
"861830396", "河南省驻马店市",
"861593287", "江西省萍乡市",
"861334946", "黑龙江省黑河市",
"861378052", "河北省保定市",
"86137470", "内蒙古呼伦贝尔市",
"861847607", "广东省湛江市",
"86182024", "辽宁省沈阳市",
"86186025", "江苏省南京市",
"861858749", "广西北海市",
"861846496", "山东省日照市",
"86155692", "新疆伊犁哈萨克自治州",
"861317820", "福建省泉州市",
"861814538", "黑龙江省双鸭山市",
"861817630", "广西柳州市",
"861453948", "广东省惠州市",
"861518557", "贵州省黔东南苗族侗族自治州",
"861373304", "安徽省六安市",
"861599402", "河南省平顶山市",
"861583339", "河北省邢台市",
"86156561", "安徽省淮北市",
"86159721", "湖北省武汉市",
"86183366", "河南省南阳市",
"861773950", "河南省南阳市",
"861705166", "陕西省西安市",
"861327719", "湖北省十堰市",
"861334625", "山东省聊城市",
"861770550", "安徽省滁州市",
"861533778", "江苏省南京市",
"861330372", "河南省安阳市",
"861326785", "广东省湛江市",
"86138360", "黑龙江省哈尔滨市",
"861824463", "河北省张家口市",
"861575101", "江苏省镇江市",
"861396578", "安徽省亳州市",
"861895477", "山东省菏泽市",
"861572518", "山东省东营市",
"861573469", "黑龙江省双鸭山市",
"861512047", "甘肃省临夏回族自治州",
"861760332", "河北省唐山市",
"861893203", "贵州省黔南布依族苗族自治州",
"861880251", "广东省茂名市",
"861308931", "吉林省延边朝鲜族自治州",
"861572721", "湖北省荆州市",
"861335140", "黑龙江省哈尔滨市",
"861337543", "山东省滨州市",
"861360690", "福建省厦门市",
"861569365", "甘肃省白银市",
"861766612", "广东省深圳市",
"861309789", "广西北海市",
"861700832", "浙江省杭州市",
"861570033", "四川省广安市",
"861532992", "贵州省遵义市",
"861365523", "江苏省淮安市",
"861336958", "宁夏银川市",
"861889776", "广西百色市",
"861359730", "广西桂林市",
"861340927", "河南省南阳市",
"86137311", "河北省石家庄市",
"861358064", "广东省肇庆市",
"861847419", "湖南省娄底市",
"861551197", "河北省邢台市",
"861809023", "四川省阿坝藏族羌族自治州",
"861770936", "甘肃省张掖市",
"861830385", "河南省开封市",
"861530597", "福建省龙岩市",
"861582910", "陕西省西安市",
"861780958", "宁夏银川市",
"861321326", "河南省安阳市",
"861392357", "广东省汕尾市",
"861779081", "辽宁省沈阳市",
"861857407", "河南省新乡市",
"86137193", "广东省广州市",
"861818356", "云南省曲靖市",
"861452505", "山东省日照市",
"861337829", "四川省内江市",
"861869525", "宁夏银川市",
"861535968", "福建省漳州市",
"86157225", "江苏省盐城市",
"861333313", "河北省张家口市",
"86158736", "湖南省常德市",
"861853414", "山西省临汾市",
"861815158", "江苏省苏州市",
"861771903", "河南省商丘市",
"861761438", "吉林省松原市",
"861816940", "湖南省岳阳市",
"86177806", "四川省成都市",
"861364798", "江西省景德镇市",
"861325859", "黑龙江省七台河市",
"861330743", "湖南省湘西土家族苗族自治州",
"861581989", "广东省惠州市",
"861331478", "内蒙古巴彦淖尔市",
"861329726", "湖北省随州市",
"861898922", "四川省宜宾市",
"861782667", "江苏省镇江市",
"861322983", "广东省清远市",
"861770991", "新疆乌鲁木齐市",
"861770500", "福建省福州市",
"861532634", "吉林省通化市",
"861851260", "广东省深圳市",
"86153246", "河南省洛阳市",
"861555037", "山东省莱芜市",
"86132757", "安徽省安庆市",
"861879446", "甘肃省天水市",
"861363465", "黑龙江省佳木斯市",
"861356821", "四川省德阳市",
"861893253", "河北省石家庄市",
"861350580", "浙江省舟山市",
"861859945", "新疆乌鲁木齐市",
"86183637", "山东省枣庄市",
"86138365", "黑龙江省鸡西市",
"861300539", "广东省云浮市",
"861772849", "广东省中山市",
"861571790", "江西省新余市",
"861853741", "河南省焦作市",
"861317726", "湖北省孝感市",
"861352326", "河南省平顶山市",
"861899419", "江苏省南通市",
"86139592", "福建省厦门市",
"861588331", "四川省眉山市",
"861850311", "河北省石家庄市",
"861336908", "新疆克孜勒苏柯尔克孜自治州",
"861853232", "河北省廊坊市",
"861868015", "广东省中山市",
"861314164", "湖南省湘西土家族苗族自治州",
"861866303", "山东省日照市",
"861341902", "四川省德阳市",
"861883842", "河南省漯河市",
"861572284", "江苏省镇江市",
"861585949", "福建省泉州市",
"861556075", "内蒙古通辽市",
"861539413", "陕西省渭南市",
"861361889", "云南省玉溪市",
"861357780", "云南省楚雄彝族自治州",
"861355943", "福建省福州市",
"861452555", "山东省青岛市",
"861373490", "四川省眉山市",
"861800643", "山东省淄博市",
"861812728", "广东省云浮市",
"861586541", "山东省滨州市",
"861392307", "广东省江门市",
"861858177", "四川省资阳市",
"861358279", "河北省廊坊市",
"861777700", "广西防城港市",
"861588273", "四川省巴中市",
"861328911", "陕西省延安市",
"861450424", "辽宁省本溪市",
"861815108", "江苏省苏州市",
"861881376", "广东省梅州市",
"861313645", "浙江省台州市",
"861339816", "四川省成都市",
"861308996", "黑龙江省绥化市",
"861560669", "浙江省宁波市",
"861345071", "广东省梅州市",
"86157220", "天津市",
"861454204", "河南省郑州市",
"861351330", "河北省邯郸市",
"861386722", "浙江省舟山市",
"86130796", "黑龙江省齐齐哈尔市",
"861599683", "江苏省镇江市",
"861364589", "浙江省金华市",
"861533259", "陕西省榆林市",
"861325809", "山东省潍坊市",
"861508144", "河北省石家庄市",
"861802581", "广东省江门市",
"861362810", "四川省德阳市",
"86137511", "广东省深圳市",
"861839315", "甘肃省武威市",
"861336074", "广东省茂名市",
"861810023", "广东省东莞市",
"861329589", "浙江省金华市",
"861766034", "山东省东营市",
"861333140", "吉林省白城市",
"861552063", "四川省宜宾市",
"861893477", "广西桂林市",
"86138560", "安徽省合肥市",
"861334391", "河南省焦作市",
"861830941", "甘肃省甘南藏族自治州",
"861867603", "广东省中山市",
"861811672", "四川省巴中市",
"861575469", "黑龙江省双鸭山市",
"861316515", "山东省青岛市",
"86170732", "河北省保定市",
"861320492", "湖南省怀化市",
"861317589", "浙江省台州市",
"861535778", "安徽省池州市",
"861386248", "江苏省南通市",
"861323859", "贵州省黔西南布依族苗族自治州",
"861352635", "河南省驻马店市",
"861356838", "四川省广安市",
"861321398", "河南省开封市",
"861510865", "云南省曲靖市",
"861818497", "西藏林芝地区",
"861826110", "江苏省宿迁市",
"861363849", "湖南省邵阳市",
"861535209", "甘肃省庆阳市",
"861803466", "甘肃省白银市",
"86138259", "广东省梅州市",
"861855414", "山东省潍坊市",
"861335313", "吉林省延边朝鲜族自治州",
"861303349", "山西省大同市",
"861364726", "湖北省十堰市",
"861857273", "湖北省随州市",
"861357261", "陕西省汉中市",
"861311685", "浙江省绍兴市",
"861780074", "青海省海东地区",
"861889966", "新疆昌吉回族自治州",
"861588328", "四川省内江市",
"861315874", "四川省广元市",
"861705702", "广东省深圳市",
"861842037", "广东省阳江市",
"861840792", "江西省九江市",
"861808733", "云南省丽江市",
"861812000", "江苏省无锡市",
"861308016", "河南省许昌市",
"86156894", "山东省青岛市",
"861301615", "湖南省益阳市",
"861566405", "河南省郑州市",
"861392431", "广东省广州市",
"861768057", "湖南省常德市",
"861560474", "内蒙古乌兰察布市",
"861550978", "青海省西宁市",
"861530483", "黑龙江省牡丹江市",
"861857115", "湖北省孝感市",
"861459244", "四川省眉山市",
"861806130", "江苏省南通市",
"86139392", "河南省鹤壁市",
"861347205", "河北省石家庄市",
"861838549", "贵州省黔南布依族苗族自治州",
"861562267", "广东省揭阳市",
"861596333", "山东省临沂市",
"861354186", "四川省广安市",
"861309526", "云南省红河哈尼族彝族自治州",
"861302143", "河北省廊坊市",
"861313777", "河南省南阳市",
"86182649", "山东省临沂市",
"86138565", "安徽省合肥市",
"86130777", "广西南宁市",
"861573151", "四川省成都市",
"861330886", "云南省怒江傈僳族自治州",
"861332048", "云南省西双版纳傣族自治州",
"86135823", "河北省石家庄市",
"861518692", "贵州省黔东南苗族侗族自治州",
"861318855", "辽宁省盘锦市",
"861317798", "江西省景德镇市",
"861320739", "湖南省邵阳市",
"861590613", "江苏省苏州市",
"861821825", "广东省湛江市",
"861886997", "浙江省台州市",
"861761421", "辽宁省朝阳市",
"861352398", "河南省三门峡市",
"861899592", "湖北省恩施土家族苗族自治州",
"861535259", "新疆塔城地区",
"861573845", "河南省许昌市",
"861319539", "安徽省六安市",
"861786886", "陕西省西安市",
"861315967", "吉林省松原市",
"86185836", "四川省成都市",
"861315645", "山东省烟台市",
"861527229", "湖北省十堰市",
"861822781", "四川省眉山市",
"861502627", "新疆阿克苏地区",
"861471498", "广东省中山市",
"861338633", "山东省日照市",
"861318141", "山东省东营市",
"861830619", "江苏省无锡市",
"861327539", "山东省临沂市",
"861588407", "四川省阿坝藏族羌族自治州",
"861890489", "黑龙江省大庆市",
"861310598", "福建省南平市",
"861763542", "山西省晋中市",
"861375490", "山西省大同市",
"861453338", "浙江省衢州市",
"861334336", "河北省廊坊市",
"861355362", "广东省韶关市",
"86130057", "广东省惠州市",
"861586434", "山东省枣庄市",
"8617615", "辽宁省大连市",
"861369471", "内蒙古呼和浩特市",
"861780269", "江苏省盐城市",
"861372211", "内蒙古呼和浩特市",
"861812050", "湖北省荆州市",
"861308928", "吉林省四平市",
"861840439", "吉林省白山市",
"861787672", "广东省湛江市",
"861705752", "江苏省苏州市",
"86158666", "山东省济南市",
"861526445", "山东省潍坊市",
"861311631", "贵州省贵阳市",
"861371587", "广东省汕头市",
"861580549", "山东省临沂市",
"861330895", "西藏昌都地区",
"861317977", "江苏省扬州市",
"861350543", "山东省滨州市",
"861339956", "安徽省安庆市",
"861863808", "河南省周口市",
"861362950", "宁夏银川市",
"861313998", "新疆喀什地区",
"861760942", "甘肃省酒泉市",
"861301048", "福建省泉州市",
"86134132", "广东省佛山市",
"861870267", "江西省抚州市",
"861361520", "江苏省南通市",
"861867538", "广东省东莞市",
"861803308", "广东省深圳市",
"861329977", "青海省海东地区",
"86139772", "广西柳州市",
"861865067", "福建省泉州市",
"86133821", "江苏省苏州市",
"861357372", "山东省威海市",
"861323099", "河北省邢台市",
"861458753", "广东省梅州市",
"861566661", "山东省日照市",
"861550797", "江西省赣州市",
"861374887", "河南省郑州市",
"86150675", "浙江省绍兴市",
"861350829", "四川省甘孜藏族自治州",
"861339530", "山东省菏泽市",
"861580823", "四川省自贡市",
"861775900", "福建省福州市",
"861850639", "山东省青岛市",
"861515250", "江苏省徐州市",
"861770346", "山西省太原市",
"861800680", "浙江省绍兴市",
"86159023", "重庆市",
"861306531", "辽宁省阜新市",
"861312343", "广西桂林市",
"861587749", "陕西省安康市",
"86137134", "广东省东莞市",
"861810610", "江苏省镇江市",
"861355980", "福建省莆田市",
"861309567", "浙江省绍兴市",
"861338558", "贵州省六盘水市",
"861305939", "广东省肇庆市",
"861362536", "山东省潍坊市",
"86187300", "河北省邯郸市",
"861328145", "四川省成都市",
"861367475", "内蒙古呼和浩特市",
"861365651", "浙江省温州市",
"861772174", "江苏省盐城市",
"861786895", "云南省昭通市",
"861325641", "山东省济南市",
"861859698", "福建省南平市",
"861380426", "辽宁省大连市",
"86130576", "江苏省南京市",
"861762547", "江苏省淮安市",
"861334129", "山东省潍坊市",
"861846307", "山东省潍坊市",
"861894965", "安徽省淮南市",
"861860738", "湖南省娄底市",
"861370337", "河北省唐山市",
"86137974", "湖北省荆州市",
"861831422", "云南省普洱市",
"861339906", "新疆阿勒泰地区",
"861861399", "湖南省长沙市",
"861812890", "广东省韶关市",
"861530602", "福建省福州市",
"861329864", "湖南省邵阳市",
"861584774", "内蒙古呼伦贝尔市",
"861823848", "河南省周口市",
"861535997", "福建省泉州市",
"86182942", "甘肃省天水市",
"861813247", "河北省唐山市",
"861378375", "河南省平顶山市",
"861889927", "新疆和田地区",
"86180724", "浙江省金华市",
"861325919", "陕西省铜川市",
"861340776", "广西河池市",
"86156102", "山东省潍坊市",
"861362591", "福建省漳州市",
"861362900", "四川省内江市",
"861530568", "安徽省阜阳市",
"86132117", "云南省昆明市",
"861305088", "辽宁省盘锦市",
"861803427", "河北省沧州市",
"861892472", "广东省潮州市",
"861334688", "河南省驻马店市",
"861335183", "黑龙江省牡丹江市",
"861882744", "湖北省武汉市",
"86150670", "浙江省金华市",
"861337580", "浙江省舟山市",
"861326728", "广东省东莞市",
"861772651", "四川省德阳市",
"861315018", "甘肃省平凉市",
"861453686", "陕西省渭南市",
"861769132", "陕西省延安市",
"861311696", "云南省丽江市",
"86156361", "黑龙江省哈尔滨市",
"861347576", "山东省济宁市",
"861355333", "广东省佛山市",
"861318095", "吉林省辽源市",
"861700678", "浙江省宁波市",
"86183566", "安徽省池州市",
"861338508", "福建省三明市",
"861776148", "四川省巴中市",
"861332615", "浙江省湖州市",
"861820476", "内蒙古赤峰市",
"861869432", "甘肃省白银市",
"861708397", "河南省信阳市",
"861321681", "浙江省杭州市",
"861351940", "甘肃省兰州市",
"861839185", "陕西省西安市",
"86137538", "山西省吕梁市",
"861577479", "内蒙古乌兰察布市",
"861397201", "湖北省宜昌市",
"861365601", "福建省厦门市",
"861330780", "广西防城港市",
"86187305", "河北省唐山市",
"861830328", "河北省沧州市",
"861386157", "江苏省淮安市",
"861571828", "广东省惠州市",
"861360923", "陕西省渭南市",
"861830457", "黑龙江省鹤岗市",
"861846428", "山东省滨州市",
"861319511", "贵州省贵阳市",
"861358140", "湖北省随州市",
"861571959", "宁夏银川市",
"861761486", "内蒙古赤峰市",
"861529714", "青海省海南藏族自治州",
"861827380", "湖南省娄底市",
"861760663", "广东省揭阳市",
"86181642", "湖北省武汉市",
"861361905", "四川省南充市",
"861572529", "山东省临沂市",
"861554982", "湖北省孝感市",
"861316864", "广东省惠州市",
"861477707", "广西钦州市",
"861330821", "四川省成都市",
"861890722", "湖北省武汉市",
"861810143", "江苏省泰州市",
"861778791", "云南省玉溪市",
"861830631", "山东省威海市",
"861877448", "湖南省邵阳市",
"86150770", "广西南宁市",
"861336580", "湖南省岳阳市",
"861327728", "湖北省武汉市",
"861309581", "浙江省舟山市",
"861811895", "江苏省镇江市",
"861561517", "山东省临沂市",
"861303145", "河北省邯郸市",
"861470344", "山西省晋中市",
"861327511", "江苏省镇江市",
"86147431", "吉林省长春市",
"86152583", "浙江省宁波市",
"861599113", "陕西省渭南市",
"861840411", "辽宁省大连市",
"861364224", "广东省汕头市",
"861372239", "河北省邯郸市",
"861350908", "广东省惠州市",
"861572843", "广东省珠海市",
"86181257", "广东省佛山市",
"86151184", "广东省东莞市",
"86156863", "陕西省商洛市",
"86132897", "陕西省榆林市",
"861339217", "广东省深圳市",
"861839119", "陕西省渭南市",
"861859326", "广西柳州市",
"861576479", "内蒙古乌兰察布市",
"86150050", "福建省福州市",
"861899544", "宁夏固原市",
"861458629", "湖北省咸宁市",
"861569401", "四川省成都市",
"861303851", "陕西省商洛市",
"861802598", "广东省佛山市",
"861887259", "湖北省襄樊市",
"861536768", "湖南省张家界市",
"861772437", "广东省河源市",
"861388477", "山东省枣庄市",
"861585046", "江苏省镇江市",
"861529299", "新疆和田地区",
"861363351", "山西省太原市",
"861537842", "四川省巴中市",
"861346576", "山东省聊城市",
"861829983", "新疆巴音郭楞蒙古自治州",
"861865081", "福建省厦门市",
"861335064", "四川省南充市",
"861500584", "浙江省宁波市",
"861323341", "山西省太原市",
"861576620", "广东省深圳市",
"861308099", "陕西省商洛市",
"861780580", "浙江省舟山市",
"861523879", "河南省周口市",
"861332689", "广东省东莞市",
"861863929", "河南省洛阳市",
"861300796", "宁夏银川市",
"861566687", "山东省临沂市",
"86151454", "黑龙江省佳木斯市",
"861337818", "四川省南充市",
"86633", "山东省日照市",
"861335708", "浙江省丽水市",
"861365437", "吉林省长春市",
"86139672", "浙江省湖州市",
"861362525", "江苏省宿迁市",
"861321945", "四川省眉山市",
"861361955", "宁夏吴忠市",
"861584505", "黑龙江省绥化市",
"861571909", "新疆伊犁哈萨克自治州",
"861458188", "浙江省丽水市",
"86153608", "广东省广州市",
"861310422", "辽宁省鞍山市",
"86150775", "广西玉林市",
"86158567", "安徽省亳州市",
"861452693", "陕西省渭南市",
"861316977", "广东省茂名市",
"861384917", "河南省郑州市",
"861870970", "青海省海北藏族自治州",
"861471522", "广东省东莞市",
"861805658", "安徽省芜湖市",
"861820093", "广东省梅州市",
"861520887", "云南省迪庆藏族自治州",
"861350958", "福建省宁德市",
"861332128", "甘肃省兰州市",
"861300731", "湖南省长沙市",
"86132441", "陕西省延安市",
"861360454", "黑龙江省佳木斯市",
"861870724", "湖北省咸宁市",
"861834058", "辽宁省朝阳市",
"861317260", "广东省肇庆市",
"861569451", "黑龙江省哈尔滨市",
"861303801", "山西省运城市",
"861366475", "内蒙古锡林郭勒盟",
"86156531", "山东省聊城市",
"861353633", "广东省惠州市",
"861454162", "浙江省湖州市",
"861300000", "山东省济南市",
"861812719", "广东省云浮市",
"86183336", "河北省廊坊市",
"861865146", "江苏省徐州市",
"861802789", "广东省汕尾市",
"861470557", "安徽省宿州市",
"861825156", "江苏省无锡市",
"861887209", "湖北省孝感市",
"861364781", "广西南宁市",
"861852730", "湖北省宜昌市",
"861868348", "四川省凉山彝族自治州",
"861311457", "黑龙江省大兴安岭地区",
"861378747", "湖南省益阳市",
"861338943", "甘肃省酒泉市",
"86137368", "浙江省嘉兴市",
"861315935", "福建省宁德市",
"861457100", "江苏省盐城市",
"861879542", "江苏省徐州市",
"86150581", "浙江省杭州市",
"861335279", "广东省惠州市",
"861524337", "河北省承德市",
"861880578", "浙江省丽水市",
"86151588", "浙江省杭州市",
"861773463", "陕西省西安市",
"861779098", "辽宁省沈阳市",
"861840744", "湖南省张家界市",
"861314040", "河南省安阳市",
"861453621", "江苏省盐城市",
"861308859", "内蒙古乌兰察布市",
"861883978", "河南省郑州市",
"86182749", "湖南省长沙市",
"861815846", "浙江省宁波市",
"86130677", "浙江省杭州市",
"86158945", "云南省大理白族自治州",
"861826643", "山东省淄博市",
"861565104", "江苏省扬州市",
"861529957", "新疆阿克苏地区",
"861893134", "河北省秦皇岛市",
"861593005", "河北省邢台市",
"861539102", "内蒙古包头市",
"861824950", "黑龙江省哈尔滨市",
"86138478", "内蒙古巴彦淖尔市",
"861360390", "河南省平顶山市",
"861864940", "广西贵港市",
"86152110", "湖南省长沙市",
"861569947", "新疆喀什地区",
"86134059", "福建省福州市",
"861328349", "河北省秦皇岛市",
"861562970", "湖北省黄石市",
"861322630", "广东省惠州市",
"86138330", "河北省保定市",
"86184310", "河北省邯郸市",
"861760632", "山东省枣庄市",
"861576013", "四川省乐山市",
"861807130", "湖北省宜昌市",
"86156518", "江苏省南京市",
"861334325", "河北省唐山市",
"86135321", "广东省惠州市",
"86150395", "河南省漯河市",
"861777207", "广西梧州市",
"861330672", "浙江省湖州市",
"861558017", "湖南省湘潭市",
"861868921", "广东省深圳市",
"861882792", "江西省九江市",
"861528871", "山东省菏泽市",
"861809478", "浙江省杭州市",
"861539976", "湖南省邵阳市",
"861311941", "甘肃省兰州市",
"86134779", "湖北省恩施土家族苗族自治州",
"861890415", "辽宁省丹东市",
"861866077", "山东省济南市",
"861536894", "云南省保山市",
"861820803", "西藏山南地区",
"861599930", "新疆喀什地区",
"861325931", "陕西省延安市",
"861597271", "湖北省宜昌市",
"861348766", "湖南省常德市",
"861377409", "湖北省随州市",
"861814353", "贵州省黔东南苗族侗族自治州",
"86158766", "广东省珠海市",
"861458318", "江西省宜春市",
"861393483", "山西省朔州市",
"861305649", "四川省巴中市",
"861821836", "广东省深圳市",
"86155215", "广东省中山市",
"861818656", "湖北省荆州市",
"86153092", "陕西省西安市",
"861836046", "江苏省南京市",
"861334049", "福建省莆田市",
"861519445", "河南省信阳市",
"861315270", "山西省忻州市",
"861850949", "甘肃省陇南市",
"86139139", "江苏省南京市",
"861860529", "江苏省淮安市",
"861565154", "江苏省盐城市",
"861783980", "河南省三门峡市",
"86158940", "新疆喀什地区",
"861866603", "广东省汕尾市",
"861315981", "黑龙江省大庆市",
"861525144", "江苏省无锡市",
"86152115", "湖南省怀化市",
"861317515", "浙江省宁波市",
"861819962", "新疆阿勒泰地区",
"861760994", "新疆昌吉回族自治州",
"861800772", "广西柳州市",
"861556440", "山东省德州市",
"861395597", "安徽省黄山市",
"861387248", "湖北省宜昌市",
"861529907", "新疆乌鲁木齐市",
"86188508", "福建省龙岩市",
"861452877", "宁夏石嘴山市",
"861821891", "广东省阳江市",
"86184315", "河北省唐山市",
"861839389", "甘肃省张掖市",
"86183667", "山东省济宁市",
"86138335", "河北省秦皇岛市",
"861708552", "安徽省合肥市",
"861390968", "安徽省阜阳市",
"861882439", "广东省深圳市",
"861568213", "四川省成都市",
"861859367", "福建省福州市",
"861517907", "江西省赣州市",
"861364735", "湖南省郴州市",
"861811886", "江苏省无锡市",
"861709480", "浙江省宁波市",
"861807572", "湖南省岳阳市",
"861820853", "贵州省安顺市",
"861819110", "陕西省西安市",
"861858541", "贵州省贵阳市",
"86147418", "四川省成都市",
"861310715", "湖南省怀化市",
"861860843", "湖南省湘西土家族苗族自治州",
"861560369", "黑龙江省大庆市",
"86155572", "浙江省湖州市",
"861380481", "黑龙江省牡丹江市",
"861773432", "河北省邯郸市",
"861836181", "江苏省镇江市",
"861871912", "广东省茂名市",
"861313345", "山西省长治市",
"861881676", "广东省深圳市",
"861378179", "河南省南阳市",
"861351630", "山东省德州市",
"861567405", "湖南省怀化市",
"861595372", "山东省济宁市",
"861800343", "山西省太原市",
"861854520", "黑龙江省齐齐哈尔市",
"86155210", "广东省广州市",
"861818606", "湖北省武汉市",
"861454133", "河北省秦皇岛市",
"861827110", "湖北省鄂州市",
"861303036", "河南省三门峡市",
"861500869", "宁夏中卫市",
"861301196", "河北省秦皇岛市",
"86150595", "福建省泉州市",
"861899485", "江苏省扬州市",
"861321111", "广东省清远市",
"861778153", "四川省成都市",
"86170762", "山东省济南市",
"861380522", "江苏省徐州市",
"861305091", "辽宁省朝阳市",
"861477094", "江西省宜春市",
"861777473", "广西梧州市",
"861325016", "广东省广州市",
"8613880", "四川省成都市",
"86138530", "山东省菏泽市",
"861390259", "广东省中山市",
"861890157", "江苏省苏州市",
"861779067", "黑龙江省佳木斯市",
"861339009", "辽宁省鞍山市",
"861860786", "广西玉林市",
"861811372", "四川省广元市",
"86156318", "河北省衡水市",
"861334691", "河南省三门峡市",
"86184510", "江苏省南通市",
"861580741", "湖南省怀化市",
"861895134", "江苏省徐州市",
"861310535", "山东省烟台市",
"861453395", "内蒙古乌兰察布市",
"861470934", "甘肃省兰州市",
"86132657", "广东省深圳市",
"861362588", "浙江省丽水市",
"861857631", "广东省清远市",
"861458125", "安徽省六安市",
"861362432", "吉林省吉林市",
"86183737", "湖南省益阳市",
"861583311", "河北省石家庄市",
"861813846", "广东省佛山市",
"861550842", "四川省泸州市",
"861384857", "内蒙古鄂尔多斯市",
"861399472", "山西省晋城市",
"861301315", "安徽省铜陵市",
"861313270", "广西河池市",
"86130696", "黑龙江省大庆市",
"861303649", "四川省宜宾市",
"861771548", "江苏省南通市",
"861350818", "四川省宜宾市",
"861329735", "湖南省郴州市",
"861452774", "广西梧州市",
"861539766", "四川省乐山市",
"861774848", "四川省成都市",
"861323931", "甘肃省兰州市",
"861563671", "黑龙江省黑河市",
"861368723", "湖北省武汉市",
"861361815", "四川省雅安市",
"861877173", "湖北省孝感市",
"861810478", "内蒙古巴彦淖尔市",
"861317735", "湖北省黄冈市",
"861352335", "河南省焦作市",
"861355558", "黑龙江省佳木斯市",
"861598074", "福建省福州市",
"861869900", "新疆克拉玛依市",
"861869591", "河南省新乡市",
"861776700", "浙江省舟山市",
"861381344", "江苏省盐城市",
"861887017", "江西省鹰潭市",
"861325928", "陕西省汉中市",
"861319785", "江西省宜春市",
"861768742", "广西柳州市",
"861876289", "江苏省苏州市",
"861336543", "山东省滨州市",
"861321335", "河南省许昌市",
"861590313", "河北省张家口市",
"86184515", "江苏省徐州市",
"86135142", "辽宁省沈阳市",
"861337958", "陕西省榆林市",
"861339059", "辽宁省沈阳市",
"86188652", "山东省聊城市",
"861570471", "内蒙古呼和浩特市",
"861768231", "浙江省杭州市",
"861309715", "江西省宜春市",
"86138535", "山东省烟台市",
"861450953", "江苏省连云港市",
"861303911", "吉林省长春市",
"861771424", "江苏省宿迁市",
"861596633", "山东省济南市",
"861780829", "四川省广元市",
"861323996", "新疆巴音郭楞蒙古自治州",
"861854564", "黑龙江省黑河市",
"861347472", "内蒙古包头市",
"861315029", "新疆喀什地区",
"861519869", "云南省西双版纳傣族自治州",
"861870866", "贵州省六盘水市",
"861362799", "江西省萍乡市",
"86137813", "河南省濮阳市",
"861313981", "新疆博尔塔拉蒙古自治州",
"861820572", "浙江省湖州市",
"861802567", "广东省中山市",
"861776096", "四川省成都市",
"861859681", "福建省三明市",
"861318577", "浙江省温州市",
"861562827", "新疆伊犁哈萨克自治州",
"861800962", "安徽省蚌埠市",
"86158636", "山东省潍坊市",
"861384807", "内蒙古呼伦贝尔市",
"861453638", "江苏省无锡市",
"861708873", "广东省江门市",
"861572880", "广东省汕尾市",
"861334636", "山东省潍坊市",
"861315345", "山东省德州市",
"86158444", "吉林省四平市",
"861391443", "江苏省泰州市",
"86155372", "河南省安阳市",
"861306492", "江苏省淮安市",
"861780543", "山东省滨州市",
"861593372", "河北省邢台市",
"861580414", "辽宁省本溪市",
"861832956", "陕西省西安市",
"861830319", "河北省邢台市",
"861379474", "广东省河源市",
"861338333", "河北省张家口市",
"861390778", "广西河池市",
"861571819", "广东省惠州市",
"861776750", "新疆阿克苏地区",
"861594546", "黑龙江省哈尔滨市",
"861564957", "河南省驻马店市",
"861320585", "浙江省绍兴市",
"861700410", "辽宁省大连市",
"861869950", "新疆吐鲁番地区",
"861454800", "广东省深圳市",
"861355508", "黑龙江省大兴安岭地区",
"861768373", "湖北省荆州市",
"861840847", "宁夏固原市",
"861323985", "新疆巴音郭楞蒙古自治州",
"861330287", "广东省珠海市",
"861806476", "浙江省温州市",
"861556483", "山东省泰安市",
"861536978", "河北省沧州市",
"86189458", "黑龙江省鸡西市",
"861318038", "河北省廊坊市",
"861352381", "河南省商丘市",
"861879211", "安徽省六安市",
"861862471", "河南省新乡市",
"861892255", "广东省清远市",
"861803608", "江苏省苏州市",
"86184453", "黑龙江省牡丹江市",
"861362463", "黑龙江省牡丹江市",
"861308641", "四川省绵阳市",
"86151950", "江苏省常州市",
"86152383", "河南省郑州市",
"861378844", "广西柳州市",
"861304479", "河南省平顶山市",
"86147983", "重庆市",
"861319796", "江西省吉安市",
"86157643", "吉林省长春市",
"861596558", "山东省青岛市",
"861568679", "陕西省汉中市",
"86184183", "甘肃省兰州市",
"861576664", "广东省揭阳市",
"861335020", "四川省遂宁市",
"86134162", "广东省广州市",
"861820913", "陕西省渭南市",
"86152750", "山东省菏泽市",
"861871852", "广东省深圳市",
"861304620", "广东省湛江市",
"861804830", "内蒙古阿拉善盟",
"861595780", "浙江省丽水市",
"861530352", "山西省大同市",
"861329781", "广西南宁市",
"861354616", "山西省长治市",
"861520784", "广西梧州市",
"86155792", "江西省上饶市",
"861370637", "山东省滨州市",
"861316820", "广东省汕尾市",
"861310581", "浙江省杭州市",
"861898684", "湖北省恩施土家族苗族自治州",
"861348824", "陕西省延安市",
"861320596", "福建省漳州市",
"86136941", "辽宁省沈阳市",
"86137227", "河北省沧州市",
"861860880", "云南省昆明市",
"861839048", "湖南省郴州市",
"861365351", "山西省太原市",
"861453553", "安徽省芜湖市",
"861859398", "广西南宁市",
"861599340", "河南省商丘市",
"86184846", "贵州省毕节地区",
"861390997", "新疆阿克苏地区",
"861894347", "吉林省辽源市",
"861514661", "黑龙江省哈尔滨市",
"861333064", "四川省遂宁市",
"861810310", "河北省邯郸市",
"861558209", "山西省吕梁市",
"861889274", "四川省广安市",
"861776085", "安徽省安庆市",
"861332131", "甘肃省兰州市",
"861583046", "河北省廊坊市",
"861777019", "江西省鹰潭市",
"861513854", "河南省濮阳市",
"86189860", "湖北省武汉市",
"861569169", "陕西省铜川市",
"86134301", "广东省梅州市",
"861822798", "四川省广安市",
"861471481", "广东省广州市",
"861800380", "河南省新乡市",
"861477854", "广东省深圳市",
"861770646", "浙江省宁波市",
"861813740", "河南省驻马店市",
"86189584", "浙江省金华市",
"861334388", "河南省洛阳市",
"861453386", "内蒙古通辽市",
"861320531", "山东省济南市",
"861510734", "湖南省衡阳市",
"861803658", "江苏省连云港市",
"861539727", "浙江省嘉兴市",
"861593261", "河北省廊坊市",
"861571268", "浙江省台州市",
"861899496", "江苏省宿迁市",
"861859635", "山东省聊城市",
"861524401", "山东省威海市",
"86158367", "河南省驻马店市",
"861860795", "江西省宜春市",
"861776856", "江苏省扬州市",
"861530302", "广东省清远市",
"86156754", "湖南省衡阳市",
"861327000", "江苏省扬州市",
"861871802", "广东省肇庆市",
"861333708", "内蒙古巴彦淖尔市",
"861363437", "吉林省辽源市",
"861454706", "浙江省台州市",
"861532944", "贵州省黔南布依族苗族自治州",
"861855549", "安徽省宿州市",
"86152755", "山东省烟台市",
"861311115", "山西省长治市",
"86151388", "河南省焦作市",
"861338362", "河北省保定市",
"861309422", "湖北省荆州市",
"861531408", "山东省泰安市",
"861830628", "江苏省南通市",
"861333279", "广东省潮州市",
"861833177", "河北省沧州市",
"861476250", "江苏省淮安市",
"861807093", "广西南宁市",
"861760878", "云南省楚雄彝族自治州",
"861365301", "广东省清远市",
"861453503", "山东省聊城市",
"861837198", "湖北省武汉市",
"86150381", "河南省郑州市",
"861313935", "甘肃省武威市",
"86134599", "福建省南平市",
"86189865", "湖北省黄冈市",
"861319731", "湖北省宜昌市",
"861558259", "山西省晋城市",
"861779026", "四川省成都市",
"861800933", "甘肃省平凉市",
"861867595", "广东省广州市",
"861332315", "河北省唐山市",
"861308919", "吉林省通化市",
"861870760", "广东省中山市",
"861585639", "安徽省合肥市",
"861477804", "广东省佛山市",
"861318989", "广东省江门市",
"861316767", "安徽省亳州市",
"861311396", "广东省广州市",
"86183536", "山东省潍坊市",
"861393440", "山西省朔州市",
"861356055", "广东省汕尾市",
"861559071", "吉林省松原市",
"861824810", "内蒙古呼和浩特市",
"861700378", "河南省开封市",
"861889069", "湖南省张家界市",
"861383922", "河南省鹤壁市",
"861319242", "广东省韶关市",
"861529817", "四川省宜宾市",
"861509288", "山东省临沂市",
"86188817", "四川省南充市",
"861867665", "广东省深圳市",
"861708567", "安徽省阜阳市",
"861477733", "广西桂林市",
"861825094", "福建省宁德市",
"861850860", "湖北省宜昌市",
"861368570", "浙江省宁波市",
"861801114", "四川省绵阳市",
"861583079", "河北省保定市",
"861853061", "河南省安阳市",
"86188745", "湖南省怀化市",
"861531492", "浙江省嘉兴市",
"861818871", "广东省佛山市",
"861705781", "四川省成都市",
"861318863", "辽宁省辽阳市",
"86139221", "广东省广州市",
"861777262", "河北省邢台市",
"86157627", "山东省烟台市",
"861882613", "广东省广州市",
"861589997", "广东省广州市",
"861770679", "浙江省金华市",
"861771775", "河北省唐山市",
"861859352", "福建省宁德市",
"861884990", "云南省丽江市",
"861516643", "山东省淄博市",
"861760487", "内蒙古鄂尔多斯市",
"861509130", "陕西省渭南市",
"86151749", "内蒙古包头市",
"861539167", "湖北省咸宁市",
"861822752", "四川省内江市",
"861806236", "湖北省荆州市",
"861518466", "黑龙江省双鸭山市",
"861862742", "湖南省常德市",
"86147349", "广东省广州市",
"861862373", "河南省新乡市",
"861332978", "湖北省荆门市",
"861310406", "黑龙江省双鸭山市",
"86159315", "河北省唐山市",
"861561045", "山东省青岛市",
"86158503", "江苏省苏州市",
"861700915", "陕西省西安市",
"861869455", "浙江省杭州市",
"861772403", "广东省广州市",
"861379725", "湖北省咸宁市",
"861889434", "甘肃省庆阳市",
"861774042", "河南省洛阳市",
"861539339", "甘肃省白银市",
"861470533", "山东省淄博市",
"861450504", "吉林省延边朝鲜族自治州",
"861816229", "江西省九江市",
"861769841", "河南省南阳市",
"86137243", "广东省深圳市",
"861864869", "内蒙古鄂尔多斯市",
"861538677", "山西省临汾市",
"861373921", "安徽省滁州市",
"861350012", "广东省梅州市",
"861552886", "四川省资阳市",
"861550048", "吉林省白山市",
"861890090", "辽宁省沈阳市",
"861817445", "湖南省长沙市",
"861709341", "广东省广州市",
"861871898", "广东省云浮市",
"861333792", "江苏省无锡市",
"861530398", "河南省三门峡市",
"861366866", "山东省潍坊市",
"861304446", "山西省阳泉市",
"861889212", "陕西省榆林市",
"861500940", "甘肃省临夏回族自治州",
"861530635", "山东省聊城市",
"861825122", "江苏省常州市",
"861884551", "黑龙江省绥化市",
"861859302", "甘肃省张掖市",
"861837152", "湖北省咸宁市",
"86158119", "广东省惠州市",
"861780944", "甘肃省临夏回族自治州",
"861815144", "江苏省扬州市",
"86132339", "河南省洛阳市",
"861594987", "山东省烟台市",
"861524586", "黑龙江省伊春市",
"861390545", "山东省烟台市",
"861881851", "广东省肇庆市",
"86562", "安徽省铜陵市",
"861324794", "江西省抚州市",
"86153196", "陕西省榆林市",
"861819907", "新疆阿克苏地区",
"861514591", "黑龙江省双鸭山市",
"86132812", "四川省成都市",
"861514900", "内蒙古呼和浩特市",
"861850727", "湖北省襄樊市",
"861774250", "湖南省岳阳市",
"861893836", "广东省茂名市",
"86181115", "四川省成都市",
"861321483", "内蒙古鄂尔多斯市",
"861874789", "内蒙古乌海市",
"861509572", "甘肃省天水市",
"861310456", "黑龙江省黑河市",
"861300168", "山东省青岛市",
"861341345", "广东省清远市",
"861890706", "江西省吉安市",
"861821134", "广东省茂名市",
"861473110", "河北省石家庄市",
"861869405", "湖北省武汉市",
"861376786", "江西省萍乡市",
"861507180", "湖北省宜昌市",
"86186513", "江苏省南通市",
"861569729", "湖北省咸宁市",
"861338485", "内蒙古包头市",
"861559628", "陕西省商洛市",
"861536196", "广东省梅州市",
"861452425", "辽宁省大连市",
"861324219", "广东省江门市",
"861510853", "贵州省安顺市",
"861529110", "陕西省西安市",
"861395111", "江苏省苏州市",
"861831697", "广东省佛山市",
"861806291", "湖北省黄石市",
"861479783", "江西省上饶市",
"861839290", "陕西省商洛市",
"86185601", "山东省济南市",
"861565085", "安徽省阜阳市",
"861705224", "内蒙古包头市",
"861357614", "江西省南昌市",
"861471556", "广东省韶关市",
"86131562", "山东省青岛市",
"861890850", "贵州省贵阳市",
"861855255", "江苏省扬州市",
"861379412", "广东省汕头市",
"861871058", "陕西省商洛市",
"861362272", "广东省佛山市",
"86137720", "陕西省西安市",
"861580472", "内蒙古包头市",
"861593314", "河北省承德市",
"86185859", "贵州省铜仁地区",
"861590744", "湖南省张家界市",
"861885131", "江苏省南通市",
"861868654", "吉林省长春市",
"861378929", "湖南省怀化市",
"861502739", "湖北省咸宁市",
"861819714", "青海省西宁市",
"861767101", "湖北省武汉市",
"86152642", "山东省青岛市",
"861377284", "陕西省汉中市",
"861477762", "广西玉林市",
"861586927", "浙江省金华市",
"861521895", "广东省汕头市",
"861809784", "新疆博尔塔拉蒙古自治州",
"861303676", "湖南省张家界市",
"861556335", "山东省济南市",
"861560153", "江苏省无锡市",
"861818622", "湖北省武汉市",
"861597307", "湖南省益阳市",
"861534909", "甘肃省甘南藏族自治州",
"861310368", "河南省南阳市",
"861361642", "山东省青岛市",
"861318832", "辽宁省阜新市",
"86133965", "浙江省杭州市",
"861347414", "陕西省渭南市",
"861850766", "广东省云浮市",
"86180135", "江苏省苏州市",
"86155316", "河北省廊坊市",
"861311462", "黑龙江省齐齐哈尔市",
"86182454", "黑龙江省佳木斯市",
"861589259", "四川省绵阳市",
"861558545", "吉林省四平市",
"86186455", "黑龙江省绥化市",
"861565096", "青海省西宁市",
"86183603", "江苏省连云港市",
"861352568", "河南省南阳市",
"861839842", "四川省遂宁市",
"861337634", "山东省莱芜市",
"861527983", "江西省吉安市",
"861399741", "青海省西宁市",
"861783544", "山西省晋中市",
"86152257", "河南省周口市",
"861474031", "辽宁省鞍山市",
"861319197", "河北省廊坊市",
"861470562", "安徽省铜陵市",
"861566432", "河南省濮阳市",
"861313430", "吉林省长春市",
"861376795", "江西省南昌市",
"861581378", "广东省江门市",
"861845261", "江苏省无锡市",
"861532829", "四川省巴中市",
"861800817", "四川省南充市",
"861866637", "广东省佛山市",
"861365682", "浙江省舟山市",
"861397282", "湖北省咸宁市",
"861339684", "浙江省宁波市",
"861345115", "湖北省武汉市",
"861369673", "安徽省马鞍山市",
"861594579", "黑龙江省哈尔滨市",
"861529933", "新疆伊犁哈萨克自治州",
"861347232", "河北省保定市",
"86439", "吉林省白山市",
"861458765", "广东省珠海市",
"86155157", "河南省郑州市",
"861565031", "山东省莱芜市",
"86153017", "上海市",
"861321568", "安徽省阜阳市",
"861800534", "山东省德州市",
"861810887", "云南省玉溪市",
"861370521", "江苏省徐州市",
"861323480", "内蒙古包头市",
"861589778", "湖北省黄石市",
"861860317", "河北省沧州市",
"86155487", "内蒙古呼和浩特市",
"861472874", "贵州省铜仁地区",
"861306327", "安徽省安庆市",
"86133960", "湖北省武汉市",
"861391341", "江苏省镇江市",
"861534959", "宁夏固原市",
"861570742", "湖南省怀化市",
"86186868", "黑龙江省哈尔滨市",
"861338431", "吉林省长春市",
"861522294", "安徽省淮南市",
"861452712", "湖北省孝感市",
"861314267", "江苏省南通市",
"861556111", "内蒙古呼和浩特市",
"861518358", "四川省达州市",
"861865675", "安徽省合肥市",
"861518427", "辽宁省盘锦市",
"861896640", "浙江省衢州市",
"861331861", "广东省清远市",
"861572187", "云南省昆明市",
"861831873", "广东省中山市",
"861552895", "四川省宜宾市",
"861532543", "浙江省舟山市",
"861570373", "河南省新乡市",
"861539126", "内蒙古鄂尔多斯市",
"861775272", "湖南省常德市",
"861836220", "江苏省苏州市",
"861340541", "山东省济南市",
"861521780", "广东省惠州市",
"86186450", "黑龙江省哈尔滨市",
"861329047", "河北省沧州市",
"861589209", "福建省莆田市",
"861814337", "湖南省衡阳市",
"861858274", "四川省眉山市",
"861590411", "辽宁省大连市",
"86182588", "浙江省杭州市",
"861301978", "黑龙江省齐齐哈尔市",
"861819441", "甘肃省张掖市",
"861328882", "广东省广州市",
"861530681", "浙江省杭州市",
"861454107", "安徽省六安市",
"861322070", "山东省滨州市",
"861577542", "四川省泸州市",
"861880677", "浙江省温州市",
"861566799", "陕西省铜川市",
"861334561", "安徽省淮北市",
"861332797", "江苏省淮安市",
"861508247", "四川省南充市",
"861505468", "山东省菏泽市",
"861317047", "湖南省长沙市",
"861353592", "广东省茂名市",
"861510913", "陕西省渭南市",
"861457097", "江苏省南通市",
"861598992", "广东省东莞市",
"861332894", "福建省宁德市",
"861870475", "内蒙古通辽市",
"861534268", "湖北省十堰市",
"861334076", "四川省南充市",
"861380930", "甘肃省白银市",
"861377738", "浙江省杭州市",
"861500983", "辽宁省营口市",
"861850976", "青海省玉树藏族自治州",
"861831668", "广东省汕尾市",
"86181750", "安徽省六安市",
"86157582", "云南省普洱市",
"86135615", "山东省滨州市",
"861361450", "黑龙江省哈尔滨市",
"86181383", "广东省佛山市",
"861845895", "浙江省衢州市",
"861861787", "河北省唐山市",
"861454415", "福建省泉州市",
"861899943", "新疆和田地区",
"861328376", "河南省信阳市",
"861505540", "安徽省淮南市",
"861846508", "宁夏固原市",
"861345407", "浙江省舟山市",
"861881911", "广东省东莞市",
"861370482", "黑龙江省齐齐哈尔市",
"861369868", "山东省青岛市",
"86150277", "河北省石家庄市",
"861843261", "河北省石家庄市",
"861565028", "山东省潍坊市",
"861863844", "河南省南阳市",
"861520310", "河北省邯郸市",
"861370538", "山东省泰安市",
"861452488", "内蒙古兴安盟",
"861472777", "陕西省宝鸡市",
"861537048", "江苏省南通市",
"861452532", "山东省青岛市",
"861380556", "安徽省安庆市",
"861477106", "湖北省宜昌市",
"861539949", "陕西省咸阳市",
"861526630", "山东省潍坊市",
"861597431", "湖南省湘西土家族苗族自治州",
"861803344", "广东省深圳市",
"861810784", "广西梧州市",
"861513972", "河南省商丘市",
"861379599", "四川省南充市",
"861815879", "浙江省金华市",
"861309368", "安徽省池州市",
"861338428", "辽宁省阜新市",
"861479740", "山西省临汾市",
"861395945", "福建省龙岩市",
"86131101", "重庆市",
"861338357", "山西省临汾市",
"86180474", "内蒙古乌兰察布市",
"861564933", "河南省郑州市",
"861325178", "吉林省松原市",
"861367267", "广东省珠海市",
"861867169", "湖北省恩施土家族苗族自治州",
"861876454", "山东省滨州市",
"861709931", "浙江省台州市",
"86155516", "安徽省阜阳市",
"861882758", "湖北省随州市",
"861375348", "山西省太原市",
"861778137", "四川省德阳市",
"861459147", "广西钦州市",
"861500330", "河北省邯郸市",
"86181755", "湖南省郴州市",
"861338544", "山东省德州市",
"861530367", "黑龙江省鸡西市",
"861780334", "河北省秦皇岛市",
"861871867", "广东省深圳市",
"861705515", "江苏省无锡市",
"861760355", "山西省长治市",
"861599481", "广东省深圳市",
"861776104", "四川省南充市",
"861808200", "江苏省南通市",
"861597496", "云南省保山市",
"86135610", "山东省东营市",
"861874567", "黑龙江省哈尔滨市",
"861872791", "湖北省鄂州市",
"861539611", "福建省福州市",
"861596607", "山东省潍坊市",
"86159846", "四川省绵阳市",
"86158759", "广东省湛江市",
"861452170", "吉林省四平市",
"861880745", "湖南省怀化市",
"861820734", "湖南省衡阳市",
"861786614", "甘肃省临夏回族自治州",
"861363682", "陕西省宝鸡市",
"861700855", "贵州省黔东南苗族侗族自治州",
"861516680", "山东省滨州市",
"861301768", "河南省郑州市",
"861354243", "广东省云浮市",
"861389140", "陕西省商洛市",
"861709996", "广东省东莞市",
"86159183", "广东省东莞市",
"86139040", "辽宁省沈阳市",
"861830527", "江苏省扬州市",
"861554839", "内蒙古赤峰市",
"86130504", "辽宁省锦州市",
"861885128", "江苏省镇江市",
"861341935", "四川省雅安市",
"861884623", "黑龙江省伊春市",
"861829218", "陕西省西安市",
"861776671", "四川省雅安市",
"86139422", "辽宁省鞍山市",
"861581223", "云南省丽江市",
"86133464", "广东省中山市",
"861819817", "贵州省毕节地区",
"86187648", "山东省泰安市",
"861700141", "江苏省盐城市",
"861556626", "辽宁省鞍山市",
"861301054", "广东省深圳市",
"861478476", "内蒙古赤峰市",
"861330614", "江苏省常州市",
"861539198", "安徽省巢湖市",
"861338307", "河北省沧州市",
"861390484", "黑龙江省牡丹江市",
"861379788", "湖北省随州市",
"861878437", "四川省攀枝花市",
"861869387", "甘肃省酒泉市",
"861590847", "四川省南充市",
"86182388", "河南省洛阳市",
"861569595", "福建省泉州市",
"861336334", "河北省衡水市",
"86134066", "山东省潍坊市",
"861340434", "吉林省四平市",
"86159453", "黑龙江省牡丹江市",
"861376843", "广西桂林市",
"861346549", "山东省临沂市",
"861597485", "云南省昭通市",
"861596419", "山东省德州市",
"861523846", "河南省周口市",
"861569303", "甘肃省甘南藏族自治州",
"861558484", "吉林省通化市",
"861309406", "新疆伊犁哈萨克自治州",
"861383906", "河南省新乡市",
"861556667", "辽宁省大连市",
"861560791", "江西省南昌市",
"86139616", "江苏省无锡市",
"861538745", "湖南省怀化市",
"861559631", "陕西省渭南市",
"861362687", "浙江省绍兴市",
"861509803", "湖北省黄冈市",
"861363453", "黑龙江省牡丹江市",
"861536689", "江苏省扬州市",
"861355073", "四川省宜宾市",
"861894813", "广东省河源市",
"861537615", "山东省济南市",
"86155840", "吉林省吉林市",
"861830566", "安徽省池州市",
"861771965", "陕西省榆林市",
"861350634", "山东省莱芜市",
"861370603", "福建省宁德市",
"861520478", "内蒙古巴彦淖尔市",
"861569586", "浙江省宁波市",
"861335792", "江苏省无锡市",
"861512864", "河北省承德市",
"861521743", "广东省汕头市",
"861346823", "山东省莱芜市",
"861369794", "江西省抚州市",
"861532580", "浙江省舟山市",
"86177631", "山东省威海市",
"861458230", "安徽省淮南市",
"861534819", "四川省成都市",
"861564962", "河南省新乡市",
"861375921", "云南省德宏傣族景颇族自治州",
"86138628", "江苏省南通市",
"861531519", "山东省济宁市",
"861348339", "河北省秦皇岛市",
"861840313", "河北省张家口市",
"861454722", "浙江省杭州市",
"86158303", "河北省张家口市",
"86185699", "河南省郑州市",
"861871826", "广东省揭阳市",
"861800957", "宁夏银川市",
"861530326", "河北省邯郸市",
"861782075", "广东省汕头市",
"861452563", "贵州省安顺市",
"86183879", "云南省普洱市",
"861321597", "福建省福州市",
"861770464", "福建省泉州市",
"861332054", "云南省昆明市",
"861889541", "安徽省阜阳市",
"861510130", "甘肃省兰州市",
"861562475", "内蒙古通辽市",
"861370077", "河南省南阳市",
"861816070", "江西省鹰潭市",
"861829869", "甘肃省白银市",
"861361394", "河南省周口市",
"861395626", "安徽省黄山市",
"861367226", "江西省九江市",
"861354761", "四川省攀枝花市",
"861510572", "浙江省湖州市",
"861309456", "四川省攀枝花市",
"861569353", "甘肃省金昌市",
"86132539", "河南省三门峡市",
"861304594", "福建省莆田市",
"861845886", "浙江省杭州市",
"86133347", "云南省普洱市",
"861802502", "广东省清远市",
"861319168", "河北省保定市",
"861341981", "河南省三门峡市",
"86571", "浙江省杭州市",
"861865179", "江苏省徐州市",
"861365277", "广东省惠州市",
"86155845", "吉林省松原市",
"861824455", "河北省承德市",
"861705260", "黑龙江省哈尔滨市",
"861779052", "四川省南充市",
"861459779", "新疆伊犁哈萨克自治州",
"861373938", "甘肃省天水市",
"86155717", "湖北省宜昌市",
"861335439", "吉林省白山市",
"861318678", "浙江省舟山市",
"861557681", "湖南省益阳市",
"861370653", "浙江省湖州市",
"861814665", "江西省宜春市",
"861453814", "四川省资阳市",
"861310397", "河南省信阳市",
"861519940", "新疆阿克苏地区",
"861876390", "山东省青岛市",
"861568039", "四川省宜宾市",
"861776822", "江苏省盐城市",
"861472998", "陕西省西安市",
"861800907", "四川省绵阳市",
"861560736", "湖南省常德市",
"861512977", "陕西省宝鸡市",
"86145802", "江苏省南通市",
"86186313", "河北省张家口市",
"861384862", "内蒙古包头市",
"861890910", "陕西省咸阳市",
"861760593", "福建省宁德市",
"861805692", "安徽省安庆市",
"861332004", "江西省抚州市",
"86159510", "江苏省南京市",
"861344755", "山东省菏泽市",
"861350992", "广东省茂名市",
"861536128", "广东省广州市",
"861525783", "浙江省丽水市",
"861450965", "新疆克孜勒苏柯尔克孜自治州",
"861312441", "河南省安阳市",
"861365960", "广西南宁市",
"861524077", "广西钦州市",
"86138923", "陕西省渭南市",
"861829070", "新疆伊犁哈萨克自治州",
"861816869", "江苏省徐州市",
"861554811", "内蒙古包头市",
"861595063", "江苏省宿迁市",
"861470466", "黑龙江省鹤岗市",
"861839797", "江西省赣州市",
"861534790", "江西省新余市",
"861314866", "广东省阳江市",
"86155617", "黑龙江省鸡西市",
"861338592", "福建省厦门市",
"861450647", "黑龙江省伊春市",
"861380640", "山东省济南市",
"861311566", "黑龙江省齐齐哈尔市",
"861770379", "河南省洛阳市",
"861859652", "福建省泉州市",
"861822047", "陕西省宝鸡市",
"861505656", "安徽省合肥市",
"861810286", "广东省汕尾市",
"861707926", "浙江省舟山市",
"86134867", "浙江省温州市",
"861860409", "辽宁省大连市",
"86158952", "江苏省徐州市",
"861561629", "湖南省湘潭市",
"861560725", "湖北省黄冈市",
"861709641", "山东省济南市",
"861476513", "广东省广州市",
"861530698", "福建省厦门市",
"861399549", "宁夏银川市",
"861565148", "江苏省盐城市",
"861821253", "贵州省铜仁地区",
"861458517", "河南省洛阳市",
"861313952", "宁夏石嘴山市",
"86183260", "安徽省合肥市",
"861537128", "江苏省扬州市",
"861538377", "河北省沧州市",
"861526940", "山东省济宁市",
"861559407", "甘肃省张掖市",
"861580576", "浙江省台州市",
"86186811", "广东省东莞市",
"86188936", "甘肃省酒泉市",
"861518533", "贵州省遵义市",
"861862673", "吉林省吉林市",
"861804669", "江西省赣州市",
"861332842", "福建省泉州市",
"861320366", "湖南省益阳市",
"861812197", "四川省泸州市",
"861537689", "山东省青岛市",
"861532818", "四川省成都市",
"861708422", "云南省临沧市",
"861557945", "江西省宜春市",
"861778165", "四川省自贡市",
"861347549", "山东省临沂市",
"861377843", "四川省德阳市",
"861475643", "河北省张家口市",
"861871835", "广东省茂名市",
"861378026", "河北省廊坊市",
"861860459", "黑龙江省大庆市",
"861370729", "湖北省孝感市",
"861530335", "河北省秦皇岛市",
"861594771", "内蒙古呼和浩特市",
"861301290", "山东省东营市",
"86177354", "山西省晋中市",
"861863892", "河南省郑州市",
"861836766", "浙江省台州市",
"861837413", "湖南省娄底市",
"861565999", "福建省福州市",
"861502596", "甘肃省陇南市",
"861760159", "江苏省苏州市",
"86183265", "安徽省六安市",
"861313902", "青海省海西蒙古族藏族自治州",
"861334769", "广西北海市",
"861387204", "湖北省黄冈市",
"86158801", "福建省福州市",
"861768190", "浙江省金华市",
"861847633", "广东省深圳市",
"861373015", "河北省保定市",
"861872412", "江苏省徐州市",
"86130270", "山西省太原市",
"861340749", "湖南省邵阳市",
"86177731", "湖南省长沙市",
"861556635", "辽宁省营口市",
"861533484", "内蒙古兴安盟",
"86135710", "陕西省咸阳市",
"861310668", "广东省佛山市",
"861361342", "山西省大同市",
"861875155", "江苏省无锡市",
"861473680", "云南省楚雄彝族自治州",
"861335411", "辽宁省大连市",
"861843287", "河北省沧州市",
"861343189", "广东省惠州市",
"861559941", "贵州省黔南布依族苗族自治州",
"861333847", "福建省泉州市",
"861893237", "江苏省扬州市",
"86158659", "山东省德州市",
"86177718", "湖北省武汉市",
"861787614", "广东省深圳市",
"861514588", "黑龙江省双鸭山市",
"861304542", "黑龙江省佳木斯市",
"861517680", "河北省承德市",
"861332290", "广东省中山市",
"861595032", "江苏省盐城市",
"861511888", "广东省广州市",
"861568011", "四川省德阳市",
"861845821", "浙江省杭州市",
"861868354", "四川省绵阳市",
"861550315", "河北省唐山市",
"86181655", "广东省珠海市",
"861504721", "内蒙古包头市",
"86131532", "山东省青岛市",
"861529680", "广西桂林市",
"861395681", "安徽省阜阳市",
"861840758", "广东省肇庆市",
"861777104", "湖北省襄樊市",
"861580205", "广东省汕头市",
"861501818", "广东省珠海市",
"861570007", "浙江省杭州市",
"861826534", "山东省德州市",
"86157326", "河北省廊坊市",
"861351445", "吉林省吉林市",
"86177094", "甘肃省兰州市",
"86139517", "江苏省南京市",
"861571194", "广东省广州市",
"861886545", "山东省烟台市",
"861862897", "四川省成都市",
"861337334", "河北省石家庄市",
"861314760", "吉林省白城市",
"8618520", "广东省广州市",
"861534896", "西藏那曲地区",
"861586069", "福建省宁德市",
"861898906", "西藏那曲地区",
"861856071", "山东省淄博市",
"861560412", "辽宁省鞍山市",
"861802397", "广东省茂名市",
"861470308", "河北省廊坊市",
"861502585", "甘肃省定西市",
"86185379", "河南省洛阳市",
"861847558", "广东省阳江市",
"861707874", "云南省红河哈尼族彝族自治州",
"861331784", "广西梧州市",
"86150425", "辽宁省阜新市",
"861459066", "广东省云浮市",
"861361773", "广西桂林市",
"861846943", "云南省普洱市",
"861320458", "黑龙江省伊春市",
"86187748", "湖南省长沙市",
"861317702", "湖北省荆州市",
"86135491", "广东省梅州市",
"861518608", "贵州省毕节地区",
"861360448", "吉林省松原市",
"86180165", "福建省泉州市",
"861360524", "江苏省宿迁市",
"86187943", "甘肃省白银市",
"86186838", "四川省德阳市",
"861836860", "浙江省衢州市",
"861848580", "贵州省毕节地区",
"861809861", "安徽省马鞍山市",
"861525247", "江苏省南京市",
"861315812", "贵州省遵义市",
"861813024", "安徽省淮北市",
"861534831", "湖南省长沙市",
"861454489", "湖北省襄樊市",
"861471452", "广东省广州市",
"861898530", "贵州省安顺市",
"861860617", "江苏省徐州市",
"861839978", "新疆巴音郭楞蒙古自治州",
"861869361", "甘肃省张掖市",
"861339384", "河南省开封市",
"861369373", "河南省新乡市",
"861531531", "山东省济南市",
"86153345", "重庆市",
"8618210", "北京市",
"861892263", "广东省肇庆市",
"861570057", "四川省广元市",
"861362455", "黑龙江省绥化市",
"861572409", "广东省深圳市",
"861560234", "广东省韶关市",
"861777154", "湖北省咸宁市",
"8613962", "江苏省苏州市",
"861823042", "河北省保定市",
"86138266", "广东省梅州市",
"861322445", "吉林省通化市",
"861527630", "新疆石河子市",
"861882183", "湖南省衡阳市",
"861596431", "山东省潍坊市",
"861847662", "广东省佛山市",
"861880377", "河南省南阳市",
"861569718", "湖北省武汉市",
"861707967", "浙江省温州市",
"861524482", "四川省眉山市",
"861707645", "山东省青岛市",
"861894460", "黑龙江省哈尔滨市",
"861476972", "山东省济南市",
"861530381", "河南省郑州市",
"861329752", "湖北省孝感市",
"861868547", "贵州省毕节地区",
"861599467", "广西桂林市",
"861311527", "江苏省常州市",
"861871881", "广东省梅州市",
"861367724", "湖北省荆门市",
"861877454", "湖南省张家界市",
"861815060", "福建省泉州市",
"861375986", "陕西省咸阳市",
"861847508", "广东省汕尾市",
"861775405", "安徽省滁州市",
"861506143", "江苏省盐城市",
"861470358", "山西省吕梁市",
"861519630", "四川省甘孜藏族自治州",
"861336012", "广东省湛江市",
"861874581", "黑龙江省伊春市",
"861814637", "青海省黄南藏族自治州",
"861470427", "辽宁省盘锦市",
"861324228", "广东省揭阳市",
"86189921", "陕西省延安市",
"86180160", "上海市",
"861569521", "江苏省南京市",
"861320408", "辽宁省大连市",
"861559619", "陕西省延安市",
"861570673", "浙江省嘉兴市",
"861317752", "江西省上饶市",
"86150420", "辽宁省铁岭市",
"861768033", "湖南省长沙市",
"861308178", "辽宁省辽阳市",
"861317166", "河北省张家口市",
"861314970", "辽宁省锦州市",
"861865002", "福建省厦门市",
"861341998", "河南省信阳市",
"861560599", "福建省南平市",
"861890254", "广东省茂名市",
"861338073", "广东省韶关市",
"861314724", "湖北省咸宁市",
"861780992", "新疆伊犁哈萨克自治州",
"861539135", "云南省昆明市",
"861365876", "云南省文山壮族苗族自治州",
"861367827", "四川省巴中市",
"861324231", "广东省广州市",
"861708535", "山东省烟台市",
"86137625", "湖南省郴州市",
"861569538", "青海省西宁市",
"861395139", "江苏省宿迁市",
"861867637", "广东省深圳市",
"861346741", "湖南省怀化市",
"861569482", "河北省沧州市",
"861570868", "贵州省六盘水市",
"861760605", "福建省漳州市",
"861815192", "江苏省南京市",
"86183908", "湖南省长沙市",
"861528540", "贵州省铜仁地区",
"861335847", "福建省宁德市",
"861568550", "贵州省贵阳市",
"861534828", "四川省广安市",
"861331238", "贵州省黔南布依族苗族自治州",
"861472981", "陕西省延安市",
"861457206", "四川省绵阳市",
"861551890", "河南省信阳市",
"861873841", "河南省洛阳市",
"861803644", "江苏省南通市",
"861889749", "湖南省邵阳市",
"861830462", "黑龙江省哈尔滨市",
"861378808", "广西河池市",
"861316047", "江苏省南京市",
"861309668", "山西省大同市",
"861866451", "广东省广州市",
"861358792", "浙江省湖州市",
"861825250", "江苏省南通市",
"861865240", "江苏省扬州市",
"861554901", "湖北省荆州市",
"861894548", "黑龙江省绥化市",
"861554590", "黑龙江省鹤岗市",
"861321075", "山东省潍坊市",
"86157526", "云南省红河哈尼族彝族自治州",
"861328676", "广东省梅州市",
"861336992", "新疆伊犁哈萨克自治州",
"861532958", "贵州省六盘水市",
"861520610", "江苏省镇江市",
"861309502", "新疆乌鲁木齐市",
"861531528", "山东省泰安市",
"861842003", "广东省东莞市",
"86139317", "河北省沧州市",
"861881349", "广东省茂名市",
"861572161", "山西省朔州市",
"861853472", "山西省忻州市",
"861825042", "福建省泉州市",
"86152742", "湖南省常德市",
"861560788", "广西河池市",
"861376284", "湖南省娄底市",
"861598334", "四川省眉山市",
"861471640", "广东省广州市",
"861459571", "陕西省榆林市",
"861305293", "江苏省镇江市",
"861351869", "山东省临沂市",
"861776233", "湖北省武汉市",
"861596307", "山东省滨州市",
"86150924", "山东省青岛市",
"86139156", "江苏省苏州市",
"861780634", "山东省莱芜市",
"861760655", "浙江省宁波市",
"861513848", "河南省郑州市",
"86151942", "山东省青岛市",
"861815024", "福建省漳州市",
"86184023", "重庆市",
"86137620", "湖南省岳阳市",
"86178046", "黑龙江省哈尔滨市",
"861334587", "浙江省温州市",
"861477848", "广东省汕头市",
"861551785", "河南省平顶山市",
"861550689", "广西玉林市",
"861313812", "广东省珠海市",
"861358246", "河北省廊坊市",
"86136805", "广东省阳江市",
"861530945", "甘肃省金昌市",
"861500630", "山东省滨州市",
"861364702", "江西省九江市",
"861772876", "广东省云浮市",
"86183703", "江西省上饶市",
"861353485", "广东省茂名市",
"861360560", "安徽省合肥市",
"861863375", "河北省廊坊市",
"86133646", "吉林省长春市",
"86188016", "上海市",
"861700577", "浙江省温州市",
"861773405", "河北省唐山市",
"861813060", "安徽省芜湖市",
"861778669", "湖北省十堰市",
"861310873", "云南省红河哈尼族彝族自治州",
"861308480", "陕西省安康市",
"861811032", "安徽省淮北市",
"86133434", "湖北省武汉市",
"861330314", "河北省承德市",
"861596544", "山东省菏泽市",
"861588433", "四川省眉山市",
"861850413", "辽宁省抚顺市",
"861879479", "甘肃省兰州市",
"861842053", "广东省茂名市",
"861510476", "内蒙古赤峰市",
"861309552", "安徽省蚌埠市",
"861532908", "贵州省六盘水市",
"861845838", "浙江省嘉兴市",
"861318410", "山东省德州市",
"861826299", "江苏省常州市",
"861769309", "甘肃省陇南市",
"861314281", "江苏省南京市",
"861886484", "山东省泰安市",
"861362387", "河南省焦作市",
"861536389", "广东省惠州市",
"861872788", "湖北省鄂州市",
"861559331", "甘肃省平凉市",
"861503656", "河南省洛阳市",
"861351584", "浙江省宁波市",
"861537315", "河北省唐山市",
"86183359", "山西省运城市",
"8618422", "天津市",
"861590439", "吉林省白山市",
"86135480", "四川省成都市",
"861389708", "青海省海西蒙古族藏族自治州",
"861771504", "江苏省南通市",
"861848543", "贵州省黔南布依族苗族自治州",
"86188640", "河南省商丘市",
"861370586", "浙江省台州市",
"861774804", "四川省泸州市",
"86133010", "北京市",
"861707998", "浙江省嘉兴市",
"861312534", "江西省吉安市",
"861363960", "河南省商丘市",
"861354884", "湖南省常德市",
"861599498", "广东省潮州市",
"861859440", "福建省南平市",
"861570794", "江西省抚州市",
"861562252", "广东省东莞市",
"861898816", "云南省昆明市",
"861888667", "四川省广元市",
"861708581", "福建省泉州市",
"861590246", "辽宁省辽阳市",
"861383899", "河南省南阳市",
"861533545", "山东省烟台市",
"861479158", "陕西省西安市",
"861398689", "湖北省十堰市",
"861705767", "上海市",
"861827216", "湖北省黄石市",
"861522000", "广东省广州市",
"861348639", "浙江省杭州市",
"86153816", "浙江省绍兴市",
"86181895", "甘肃省兰州市",
"861337944", "陕西省渭南市",
"861365770", "广西防城港市",
"861339922", "陕西省榆林市",
"861315952", "吉林省长春市",
"861760461", "黑龙江省哈尔滨市",
"861528497", "四川省资阳市",
"861896383", "新疆昌吉回族自治州",
"86170956", "江苏省徐州市",
"861771347", "四川省成都市",
"861452249", "浙江省舟山市",
"861539181", "安徽省安庆市",
"861373995", "内蒙古乌兰察布市",
"861386133", "江苏省苏州市",
"861338419", "辽宁省辽阳市",
"861350334", "河北省承德市",
"861370303", "广东省中山市",
"861830433", "吉林省延边朝鲜族自治州",
"86158899", "广东省广州市",
"861555282", "山东省泰安市",
"861334979", "湖北省十堰市",
"861772770", "广东省东莞市",
"861537131", "江苏省扬州市",
"86177554", "安徽省淮南市",
"86151649", "内蒙古锡林郭勒盟",
"861802368", "广东省韶关市",
"861473643", "云南省保山市",
"861393398", "河北省沧州市",
"861772924", "陕西省安康市",
"86135485", "湖南省长沙市",
"861389758", "青海省西宁市",
"861773661", "广西南宁市",
"861590792", "江西省九江市",
"861394559", "黑龙江省七台河市",
"861866665", "广东省河源市",
"86132569", "山东省烟台市",
"861862868", "陕西省榆林市",
"86135292", "云南省昆明市",
"86188645", "河南省南阳市",
"861361694", "福建省三明市",
"861562202", "广东省阳江市",
"86157727", "贵州省毕节地区",
"861355544", "黑龙江省双鸭山市",
"861896556", "福建省莆田市",
"861779747", "青海省海西蒙古族藏族自治州",
"861559396", "甘肃省白银市",
"861479108", "陕西省西安市",
"861311071", "福建省泉州市",
"861539046", "四川省乐山市",
"86187206", "江西省宜春市",
"86136889", "广东省东莞市",
"861816445", "安徽省安庆市",
"861329127", "江苏省南京市",
"861501958", "广东省汕尾市",
"861367866", "山东省潍坊市",
"861385217", "江苏省扬州市",
"861310697", "广东省江门市",
"86188197", "广东省东莞市",
"861569077", "河南省商丘市",
"861806225", "湖北省襄樊市",
"861864070", "辽宁省辽阳市",
"861705820", "江苏省苏州市",
"861846980", "云南省玉溪市",
"861318378", "四川省绵阳市",
"861896930", "浙江省嘉兴市",
"861883048", "河北省秦皇岛市",
"861563999", "河南省平顶山市",
"861370353", "山西省阳泉市",
"861814365", "吉林省吉林市",
"861452491", "内蒙古包头市",
"861821477", "安徽省宣城市",
"861597130", "湖北省孝感市",
"861880368", "河南省南阳市",
"861313689", "黑龙江省牡丹江市",
"86132228", "江苏省无锡市",
"861570920", "陕西省西安市",
"861310003", "山西省阳泉市",
"861301345", "云南省曲靖市",
"861389714", "青海省海南藏族自治州",
"861303619", "湖北省咸宁市",
"861560987", "辽宁省盘锦市",
"861570774", "广西梧州市",
"861350848", "湖南省长沙市",
"861364545", "山东省烟台市",
"861863503", "山西省忻州市",
"861807333", "湖南省株洲市",
"86187271", "湖北省襄樊市",
"86153969", "江苏省淮安市",
"861361845", "湖南省郴州市",
"861774818", "四川省达州市",
"861311036", "陕西省汉中市",
"861818825", "贵州省六盘水市",
"861521692", "广东省河源市",
"861315131", "江苏省淮安市",
"861335643", "广东省江门市",
"861867833", "山东省滨州市",
"861304043", "浙江省宁波市",
"86188562", "安徽省铜陵市",
"861302402", "安徽省亳州市",
"86183357", "山西省临汾市",
"86138583", "浙江省宁波市",
"861587511", "广东省韶关市",
"861321141", "广西柳州市",
"861883430", "山西省长治市",
"861528477", "四川省雅安市",
"861325046", "广东省江门市",
"86176401", "辽宁省沈阳市",
"86158897", "广东省深圳市",
"861535127", "四川省南充市",
"86170872", "江西省九江市",
"861580528", "江苏省镇江市",
"861351254", "江苏省南京市",
"861380238", "广东省东莞市",
"861879763", "湖南省怀化市",
"861839967", "新疆乌鲁木齐市",
"86151190", "广东省惠州市",
"861576755", "广东省惠州市",
"861538456", "陕西省汉中市",
"861366709", "江西省南昌市",
"861572903", "河南省三门峡市",
"861532707", "湖北省孝感市",
"861500415", "辽宁省丹东市",
"861808958", "四川省攀枝花市",
"861562438", "山东省济南市",
"861519157", "陕西省西安市",
"861370256", "广东省佛山市",
"861881462", "黑龙江省齐齐哈尔市",
"861365790", "江西省新余市",
"861583341", "河北省邯郸市",
"861839645", "福建省漳州市",
"861809930", "新疆塔城地区",
"861858242", "四川省乐山市",
"861510485", "内蒙古兴安盟",
"861356562", "新疆昌吉回族自治州",
"861555668", "安徽省芜湖市",
"861785853", "浙江省绍兴市",
"861874065", "陕西省安康市",
"861310053", "广西桂林市",
"861554163", "辽宁省锦州市",
"861782038", "广东省肇庆市",
"86132567", "山东省济南市",
"861378078", "山东省东营市",
"861346366", "河北省承德市",
"861341797", "广东省云浮市",
"86189390", "河南省三门峡市",
"861453081", "安徽省合肥市",
"86157729", "贵州省黔西南布依族苗族自治州",
"861324505", "江苏省苏州市",
"861361674", "浙江省绍兴市",
"861521934", "广东省阳江市",
"861520435", "吉林省通化市",
"86158441", "吉林省长春市",
"861322254", "湖南省邵阳市",
"86151647", "内蒙古乌兰察布市",
"861846449", "山东省莱芜市",
"861571849", "广东省中山市",
"861362244", "广东省云浮市",
"861830349", "山西省朔州市",
"861342861", "广东省东莞市",
"861590772", "广西柳州市",
"861530863", "湖北省武汉市",
"86181236", "广东省深圳市",
"86185776", "广西百色市",
"861393378", "河北省张家口市",
"861809506", "四川省自贡市",
"861524917", "陕西省宝鸡市",
"86155032", "河北省衡水市",
"861705017", "山东省青岛市",
"861771284", "江苏省镇江市",
"861768712", "云南省昆明市",
"861887047", "江西省南昌市",
"861569097", "内蒙古鄂尔多斯市",
"861839874", "四川省自贡市",
"861522776", "河北省唐山市",
"861590343", "山西省太原市",
"861537952", "宁夏石嘴山市",
"861310677", "广东省阳江市",
"861336513", "江苏省扬州市",
"861769624", "山西省运城市",
"861800140", "江苏省淮安市",
"861452471", "黑龙江省大庆市",
"861823829", "河南省信阳市",
"861323639", "江苏省镇江市",
"861454330", "内蒙古兴安盟",
"861552692", "吉林省白山市",
"861890869", "湖北省荆门市",
"861309745", "云南省昭通市",
"861318398", "四川省德阳市",
"86177120", "江苏省徐州市",
"86151252", "云南省大理白族自治州",
"86183116", "贵州省遵义市",
"861571523", "江苏省淮安市",
"861311091", "福建省南平市",
"861303941", "新疆昌吉回族自治州",
"861532757", "湖北省孝感市",
"861572953", "宁夏吴忠市",
"861808908", "西藏拉萨市",
"861366759", "新疆克孜勒苏柯尔克孜自治州",
"861576705", "广东省梅州市",
"86151195", "广东省湛江市",
"861325181", "吉林省长春市",
"861515944", "福建省宁德市",
"86135128", "天津市",
"861599180", "陕西省西安市",
"861894187", "辽宁省葫芦岛市",
"861846236", "山东省菏泽市",
"861786466", "山东省莱芜市",
"861815172", "江苏省常州市",
"861858785", "广西南宁市",
"861389957", "新疆克拉玛依市",
"86153662", "江苏省苏州市",
"861567208", "湖北省黄冈市",
"861595608", "安徽省滁州市",
"861331452", "黑龙江省齐齐哈尔市",
"861509307", "河南省郑州市",
"861311801", "四川省宜宾市",
"86185396", "河南省驻马店市",
"861510431", "吉林省长春市",
"861819183", "陕西省渭南市",
"861779948", "新疆喀什地区",
"861376347", "黑龙江省齐齐哈尔市",
"861341978", "河南省开封市",
"861560579", "浙江省金华市",
"861810340", "山西省晋城市",
"861853739", "河南省开封市",
"861595562", "安徽省安庆市",
"861772831", "广东省佛山市",
"861458938", "广东省清远市",
"861365896", "西藏那曲地区",
"861588349", "四川省凉山彝族自治州",
"861303457", "山东省威海市",
"861569807", "山东省东营市",
"861500722", "湖北省武汉市",
"861770616", "江苏省无锡市",
"861338093", "广东省河源市",
"861864800", "内蒙古鄂尔多斯市",
"861780972", "青海省海东地区",
"86189770", "广西防城港市",
"861378537", "河北省承德市",
"861554570", "黑龙江省鸡西市",
"861890584", "浙江省宁波市",
"861557678", "湖南省永州市",
"861327434", "吉林省四平市",
"861840817", "四川省绵阳市",
"861318681", "浙江省温州市",
"86132766", "江苏省南京市",
"861826064", "江苏省镇江市",
"86139319", "河北省邢台市",
"86147175", "江西省赣州市",
"861586539", "山东省临沂市",
"861783913", "河南省许昌市",
"861881433", "广东省东莞市",
"861328696", "广东省湛江市",
"861378814", "广西梧州市",
"861336972", "青海省海东地区",
"861308611", "江西省上饶市",
"861840534", "山东省德州市",
"861321095", "山东省聊城市",
"861476012", "福建省莆田市",
"861330358", "山西省吕梁市",
"861533752", "福建省厦门市",
"861330427", "辽宁省盘锦市",
"861860953", "宁夏吴忠市",
"861509544", "甘肃省临夏回族自治州",
"861709413", "广东省深圳市",
"861324393", "辽宁省营口市",
"861820943", "甘肃省白银市",
"861319434", "吉林省四平市",
"861761298", "陕西省榆林市",
"86185577", "浙江省台州市",
"861567779", "广西钦州市",
"861396552", "安徽省黄山市",
"86137302", "河北省保定市",
"861459536", "西藏那曲地区",
"86147935", "甘肃省天水市",
"861333680", "浙江省绍兴市",
"861862920", "陕西省咸阳市",
"861567258", "湖北省荆州市",
"861528082", "福建省龙岩市",
"861327212", "湖南省株洲市",
"86132940", "河北省张家口市",
"861311851", "贵州省贵阳市",
"861872987", "陕西省西安市",
"861568971", "山东省济南市",
"861804350", "吉林省通化市",
"86150384", "河南省驻马店市",
"861509428", "云南省昭通市",
"861538368", "山西省吕梁市",
"861530832", "四川省绵阳市",
"861839926", "新疆和田地区",
"861331402", "辽宁省沈阳市",
"861815956", "福建省漳州市",
"861309282", "四川省南充市",
"861519248", "山东省青岛市",
"861308949", "吉林省吉林市",
"861370575", "浙江省绍兴市",
"861314551", "安徽省合肥市",
"86156071", "湖北省武汉市",
"86189775", "广西玉林市",
"861329484", "内蒙古通辽市",
"86156334", "河北省唐山市",
"861569857", "山西省太原市",
"861303407", "安徽省阜阳市",
"861529847", "江苏省扬州市",
"861319212", "广东省潮州市",
"86152335", "河北省秦皇岛市",
"861393410", "山西省运城市",
"861879499", "甘肃省陇南市",
"861803895", "广东省茂名市",
"86189581", "浙江省杭州市",
"861524068", "广西南宁市",
"861591710", "广东省茂名市",
"861850859", "贵州省黔西南布依族苗族自治州",
"861396668", "安徽省合肥市",
"861826279", "江苏省连云港市",
"861534382", "河南省郑州市",
"86151473", "内蒙古乌海市",
"861870582", "浙江省湖州市",
"861334257", "湖南省益阳市",
"861858890", "广东省阳江市",
"861346408", "辽宁省铁岭市",
"861870438", "吉林省松原市",
"861860903", "新疆和田地区",
"861533702", "甘肃省庆阳市",
"861899734", "青海省海南藏族自治州",
"861863395", "河北省唐山市",
"861772896", "广东省韶关市",
"861330308", "河北省邯郸市",
"861566027", "湖南省邵阳市",
"861865621", "安徽省铜陵市",
"86156751", "湖南省长沙市",
"861774074", "西藏林芝地区",
"861336156", "山东省潍坊市",
"861471784", "山西省阳泉市",
"861532914", "贵州省黔南布依族苗族自治州",
"861855519", "安徽省滁州市",
"861880456", "黑龙江省黑河市",
"861868125", "四川省成都市",
"861363896", "西藏那曲地区",
"86151181", "广东省深圳市",
"861336762", "广西柳州市",
"86152530", "山东省菏泽市",
"861572813", "广东省东莞市",
"86134504", "广东省广州市",
"861305328", "安徽省安庆市",
"861339247", "广东省广州市",
"861392449", "广东省汕尾市",
"861839149", "陕西省铜川市",
"861358962", "山东省枣庄市",
"86156773", "广西桂林市",
"861813906", "新疆巴音郭楞蒙古自治州",
"861593562", "山西省太原市",
"861787608", "广东省揭阳市",
"861520522", "江苏省徐州市",
"86155912", "陕西省榆林市",
"861537812", "四川省乐山市",
"861323311", "山西省临汾市",
"861320232", "广东省惠州市",
"861569068", "河南省漯河市",
"861700483", "广东省深圳市",
"861596476", "山东省济宁市",
"86185596", "福建省厦门市",
"861318367", "四川省内江市",
"861510544", "山东省潍坊市",
"861777118", "湖北省黄石市",
"861320741", "湖南省长沙市",
"86130066", "广东省深圳市",
"86156138", "河北省唐山市",
"86158657", "山东省聊城市",
"861308126", "辽宁省丹东市",
"861892366", "广东省汕头市",
"861501804", "广东省湛江市",
"861870421", "辽宁省朝阳市",
"861787562", "广东省茂名市",
"861360751", "福建省莆田市",
"861571601", "福建省三明市",
"861474587", "黑龙江省齐齐哈尔市",
"861337848", "广东省佛山市",
"861821468", "云南省保山市",
"86151451", "黑龙江省哈尔滨市",
"861774908", "陕西省渭南市",
"861811658", "四川省成都市",
"861536430", "湖南省益阳市",
"861816204", "山东省济宁市",
"861450529", "吉林省辽源市",
"861319541", "安徽省亳州市",
"861397368", "湖南省益阳市",
"86185377", "河南省南阳市",
"861342286", "广东省深圳市",
"861358110", "山东省枣庄市",
"861893322", "广东省广州市",
"86137502", "广东省河源市",
"861569754", "广东省汕头市",
"861802377", "广东省云浮市",
"861589735", "湖南省郴州市",
"861509431", "江苏省南京市",
"861364484", "内蒙古呼和浩特市",
"861834461", "江苏省无锡市",
"861877418", "湖南省株洲市",
"861829850", "甘肃省临夏回族自治州",
"861590380", "河南省商丘市",
"861318139", "山东省德州市",
"861564847", "内蒙古赤峰市",
"861587890", "广西防城港市",
"861361793", "江西省上饶市",
"861478607", "贵州省黔西南布依族苗族自治州",
"861780762", "广东省河源市",
"861367551", "安徽省合肥市",
"861470314", "河北省承德市",
"861862877", "吉林省四平市",
"86139519", "江苏省南京市",
"861550902", "新疆哈密地区",
"861561547", "山东省济宁市",
"861521557", "安徽省宿州市",
"861599143", "陕西省西安市",
"86147434", "广东省广州市",
"861705259", "河南省郑州市",
"861327541", "山东省济南市",
"86136440", "辽宁省沈阳市",
"861534876", "云南省文山壮族苗族自治州",
"86136022", "广东省广州市",
"86158242", "浙江省宁波市",
"861305407", "湖南省岳阳市",
"861390047", "内蒙古包头市",
"861777636", "广西玉林市",
"86156534", "山东省潍坊市",
"861303273", "湖北省宜昌市",
"861808818", "云南省德宏傣族景颇族自治州",
"861369393", "河南省濮阳市",
"86152535", "山东省烟台市",
"861812749", "广东省潮州市",
"861803261", "河北省廊坊市",
"861705778", "北京市",
"861787658", "广东省河源市",
"861818888", "广东省广州市",
"861552557", "山西省晋中市",
"861865116", "江苏省泰州市",
"861813956", "新疆喀什地区",
"861533166", "云南省普洱市",
"861478073", "四川省南充市",
"861459716", "山东省威海市",
"86153732", "河北省廊坊市",
"861517411", "辽宁省本溪市",
"861338913", "陕西省渭南市",
"861830939", "甘肃省陇南市",
"861889168", "陕西省安康市",
"86150584", "浙江省宁波市",
"86135849", "江苏省苏州市",
"861879512", "宁夏石嘴山市",
"861571651", "河南省许昌市",
"861335680", "山东省威海市",
"861377647", "江苏省镇江市",
"861360701", "江西省鹰潭市",
"861501854", "广东省深圳市",
"861840714", "湖北省黄石市",
"861573564", "山西省太原市",
"861569704", "云南省昆明市",
"861591172", "云南省昆明市",
"861852468", "辽宁省阜新市",
"861332981", "湖北省宜昌市",
"86150865", "贵州省黔西南布依族苗族自治州",
"861857025", "湖南省邵阳市",
"861510428", "辽宁省盘锦市",
"861360030", "广东省佛山市",
"861510357", "山西省临汾市",
"86183756", "重庆市",
"861570693", "云南省德宏傣族景颇族自治州",
"861898024", "四川省泸州市",
"861814862", "广东省广州市",
"861813530", "山西省阳泉市",
"861535702", "安徽省芜湖市",
"861454940", "福建省福州市",
"86132636", "黑龙江省哈尔滨市",
"861829800", "安徽省合肥市",
"861580585", "浙江省绍兴市",
"861705209", "黑龙江省哈尔滨市",
"861847514", "广东省阳江市",
"861550952", "宁夏吴忠市",
"861384947", "河南省漯河市",
"861811562", "江苏省南京市",
"861880397", "河南省郑州市",
"861303331", "云南省普洱市",
"86189381", "广东省东莞市",
"861320414", "辽宁省本溪市",
"861847837", "湖南省湘西土家族苗族自治州",
"86187472", "内蒙古包头市",
"861832740", "湖北省襄樊市",
"861770399", "河南省许昌市",
"861320263", "广东省肇庆市",
"861890445", "吉林省通化市",
"86183557", "安徽省宿州市",
"86138383", "河南省郑州市",
"861505134", "江苏省盐城市",
"861700568", "浙江省杭州市",
"86158876", "云南省保山市",
"861829756", "安徽省宣城市",
"861532854", "四川省广安市",
"86134869", "浙江省金华市",
"861787533", "广东省梅州市",
"861869746", "内蒙古乌海市",
"861829090", "新疆阿勒泰地区",
"861768532", "贵州省遵义市",
"86138750", "湖南省常德市",
"861524097", "云南省丽江市",
"861840907", "新疆石河子市",
"861458348", "江西省景德镇市",
"861824883", "江苏省常州市",
"861336733", "湖南省株洲市",
"861509485", "山东省日照市",
"86189595", "福建省莆田市",
"861810930", "甘肃省临夏回族自治州",
"861334019", "江西省抚州市",
"861338572", "浙江省湖州市",
"861561490", "河北省邯郸市",
"861891944", "甘肃省陇南市",
"861593533", "山西省临汾市",
"861534770", "广西南宁市",
"861817756", "广西贵港市",
"861500157", "新疆巴音郭楞蒙古自治州",
"861879973", "新疆石河子市",
"861850919", "陕西省铜川市",
"861315689", "山东省青岛市",
"861580596", "福建省泉州市",
"861570964", "宁夏固原市",
"861559882", "内蒙古鄂尔多斯市",
"861780733", "湖南省长沙市",
"861707768", "云南省玉溪市",
"861594736", "内蒙古鄂尔多斯市",
"861782021", "广东省深圳市",
"861862693", "吉林省长春市",
"861808074", "四川省广元市",
"861380784", "广西梧州市",
"861886752", "浙江省杭州市",
"861820333", "河北省衡水市",
"861810556", "安徽省安庆市",
"861301981", "辽宁省锦州市",
"861530678", "浙江省丽水市",
"861533127", "山东省济南市",
"861781706", "广东省河源市",
"86170903", "北京市",
"861576043", "四川省绵阳市",
"86897", "西藏阿里地区\、普兰县\、扎达县",
"861538397", "河北省沧州市",
"861571465", "黑龙江省伊春市",
"861838585", "贵州省铜仁地区",
"861837809", "广西桂林市",
"861369505", "福建省南平市",
"86138070", "江西省南昌市",
"861514147", "辽宁省铁岭市",
"861580531", "山东省济南市",
"861868629", "内蒙古赤峰市",
"861860813", "四川省自贡市",
"861311649", "贵州省贵阳市",
"861310745", "湖南省怀化市",
"861313315", "山西省长治市",
"861871942", "广东省湛江市",
"861301270", "山东省淄博市",
"861522966", "陕西省汉中市",
"861398902", "西藏日喀则地区",
"861829706", "青海省玉树藏族自治州",
"86170708", "广东省广州市",
"861308339", "安徽省阜阳市",
"861366323", "河北省张家口市",
"861332935", "黑龙江省绥化市",
"861587000", "江西省南昌市",
"861302640", "陕西省榆林市",
"86189590", "福建省龙岩市",
"861800313", "河北省张家口市",
"861700652", "江苏省无锡市",
"861840957", "宁夏中卫市",
"86138755", "湖南省郴州市",
"861858728", "云南省丽江市",
"861562421", "山东省潍坊市",
"861378954", "内蒙古乌兰察布市",
"861812177", "江苏省徐州市",
"86156393", "河南省濮阳市",
"861803743", "河南省驻马店市",
"861557832", "广西南宁市",
"861892458", "广东省深圳市",
"861587242", "湖北省武汉市",
"86187253", "云南省保山市",
"861308167", "山东省潍坊市",
"861589224", "四川省自贡市",
"861850641", "山东省济南市",
"861312708", "山东省烟台市",
"861318326", "河南省开封市",
"861479922", "新疆阿克苏地区",
"861317545", "浙江省台州市",
"861387218", "湖北省咸宁市",
"861587731", "陕西省延安市",
"861841922", "甘肃省兰州市",
"861325639", "山东省青岛市",
"861801846", "江苏省徐州市",
"86185797", "江西省赣州市",
"861781756", "广东省珠海市",
"861570877", "云南省玉溪市",
"861590962", "宁夏石嘴山市",
"861810506", "福建省泉州市",
"861389534", "宁夏固原市",
"861369555", "安徽省蚌埠市",
"86138075", "海南省海口市",
"861568243", "四川省南充市",
"861478419", "河南省信阳市",
"861814833", "内蒙古鄂尔多斯市",
"861315128", "江苏省常州市",
"861361469", "黑龙江省佳木斯市",
"861329545", "山东省烟台市",
"861532250", "广东省湛江市",
"861367323", "河北省石家庄市",
"861894459", "黑龙江省大庆市",
"861363819", "贵州省毕节地区",
"861560771", "广西南宁市",
"861333962", "贵州省遵义市",
"86188532", "山东省青岛市",
"861302275", "山东省烟台市",
"861816706", "浙江省台州市",
"861880502", "福建省福州市",
"861318335", "河南省平顶山市",
"86155904", "吉林省四平市",
"861335343", "山西省太原市",
"861459432", "西藏日喀则地区",
"861855444", "山东省济南市",
"861865948", "福建省莆田市",
"861823074", "贵州省黔东南苗族侗族自治州",
"861301967", "辽宁省本溪市",
"861303319", "安徽省安庆市",
"861835785", "浙江省丽水市",
"861857801", "广东省江门市",
"861880668", "广东省茂名市",
"861503203", "河北省邯郸市",
"861899865", "广东省韶关市",
"86134270", "广东省中山市",
"861300749", "湖南省长沙市",
"861331930", "江西省上饶市",
"861308046", "河北省石家庄市",
"86156891", "山东省潍坊市",
"861313389", "江西省景德镇市",
"861529439", "甘肃省天水市",
"861859095", "陕西省安康市",
"861802282", "广东省茂名市",
"861772297", "广东省揭阳市",
"861453858", "甘肃省平凉市",
"861839345", "甘肃省天水市",
"86137514", "广东省东莞市",
"86183877", "云南省普洱市",
"86158556", "安徽省安庆市",
"861335772", "江苏省南京市",
"861534453", "黑龙江省牡丹江市",
"861324877", "浙江省温州市",
"861589767", "湖北省孝感市",
"861356308", "山东省滨州市",
"861830911", "陕西省延安市",
"86182240", "四川省成都市",
"861316545", "山东省烟台市",
"861350156", "广东省深圳市",
"861332926", "安徽省安庆市",
"861339783", "广西桂林市",
"861379987", "福建省泉州市",
"861573815", "河南省平顶山市",
"861301874", "广东省中山市",
"861823269", "河北省廊坊市",
"86138650", "安徽省蚌埠市",
"86181266", "广东省佛山市",
"861308181", "河北省衡水市",
"86155062", "江苏省苏州市",
"861337733", "广西桂林市",
"861377937", "新疆哈密地区",
"861594725", "内蒙古通辽市",
"861569206", "广东省东莞市",
"86155719", "湖北省十堰市",
"861459799", "新疆乌鲁木齐市",
"861830649", "山东省滨州市",
"861880552", "安徽省蚌埠市",
"861816756", "新疆伊犁哈萨克自治州",
"861519489", "河北省保定市",
"861318111", "山东省威海市",
"861365297", "广东省揭阳市",
"861334085", "四川省德阳市",
"861854793", "内蒙古锡林郭勒盟",
"861857851", "广东省茂名市",
"861331383", "福建省泉州市",
"861361374", "河南省许昌市",
"861370097", "四川省南充市",
"861555368", "山东省聊城市",
"861372241", "河北省承德市",
"861786533", "山东省淄博市",
"861304574", "浙江省嘉兴市",
"861348443", "陕西省渭南市",
"86134275", "广东省广州市",
"861815009", "福建省厦门市",
"861353913", "广东省河源市",
"861510592", "福建省莆田市",
"861760573", "浙江省嘉兴市",
"861512997", "陕西省榆林市",
"861334806", "江苏省南通市",
"861529792", "江西省九江市",
"861707842", "云南省保山市",
"861857145", "湖北省武汉市",
"861330533", "山东省淄博市",
"861898144", "四川省内江市",
"861350972", "山西省大同市",
"861836809", "浙江省舟山市",
"861809683", "新疆昌吉回族自治州",
"861454630", "宁夏银川市",
"861767342", "湖南省永州市",
"861517792", "广西南宁市",
"861855528", "安徽省六安市",
"861318698", "浙江省杭州市",
"861881527", "浙江省宁波市",
"861534403", "内蒙古鄂尔多斯市",
"861572460", "辽宁省鞍山市",
"861332018", "江西省抚州市",
"86137118", "广东省东莞市",
"861590643", "浙江省丽水市",
"861310377", "河南省南阳市",
"861538552", "安徽省蚌埠市",
"861516411", "辽宁省铁岭市",
"86189146", "江苏省盐城市",
"861807662", "广西南宁市",
"86152360", "河南省南阳市",
"861303628", "江西省新余市",
"861770316", "河北省廊坊市",
"861300177", "山东省泰安市",
"861562486", "内蒙古赤峰市",
"861334750", "广西南宁市",
"861376965", "云南省曲靖市",
"86359", "山西省运城市",
"861380286", "广东省惠州市",
"861881566", "安徽省池州市",
"86137131", "广东省东莞市",
"861834487", "江苏省淮安市",
"861376647", "江西省上饶市",
"861773746", "河南省洛阳市",
"861312313", "福建省泉州市",
"861539480", "云南省德宏傣族景颇族自治州",
"861871994", "新疆吐鲁番地区",
"861332874", "福建省龙岩市",
"861598972", "广东省汕头市",
"861362883", "云南省临沧市",
"861333933", "黑龙江省双鸭山市",
"861457077", "江苏省泰州市",
"861762517", "江苏省淮安市",
"861599610", "江苏省连云港市",
"861884866", "贵州省六盘水市",
"861478431", "河南省许昌市",
"861459463", "陕西省延安市",
"861850996", "新疆巴音郭楞蒙古自治州",
"861453098", "山西省长治市",
"861334096", "四川省成都市",
"86147960", "广西桂林市",
"86153632", "广东省韶关市",
"861595308", "山东省日照市",
"861882441", "广东省东莞市",
"861815899", "安徽省宣城市",
"861846514", "宁夏固原市",
"861596093", "福建省龙岩市",
"861311088", "福建省福州市",
"861379579", "四川省阿坝藏族羌族自治州",
"861350513", "江苏省连云港市",
"861858539", "贵州省安顺市",
"861869244", "湖南省郴州市",
"861571437", "吉林省辽源市",
"861760912", "陕西省榆林市",
"861301018", "河北省石家庄市",
"861345882", "四川省宜宾市",
"861322910", "广东省中山市",
"861346627", "云南省红河哈尼族彝族自治州",
"861477992", "江西省赣州市",
"861365909", "四川省广安市",
"861325198", "浙江省丽水市",
"861860460", "黑龙江省哈尔滨市",
"861355853", "四川省达州市",
"86150279", "河北省邯郸市",
"861576123", "贵州省黔南布依族苗族自治州",
"861308311", "安徽省马鞍山市",
"861856025", "山东省淄博市",
"861328396", "河南省驻马店市",
"861321989", "四川省德阳市",
"86183656", "山东省潍坊市",
"86139862", "湖北省武汉市",
"86157044", "吉林省长春市",
"861800708", "江西省南昌市",
"861472797", "陕西省宝鸡市",
"861888223", "四川省乐山市",
"861819020", "四川省遂宁市",
"861332967", "贵州省毕节地区",
"861334700", "内蒙古呼伦贝尔市",
"861372763", "广东省梅州市",
"861568787", "云南省昆明市",
"86156364", "黑龙江省佳木斯市",
"861772909", "陕西省西安市",
"86152365", "河南省安阳市",
"861800064", "河北省保定市",
"861582983", "陕西省渭南市",
"861589726", "青海省海南藏族自治州",
"861352989", "云南省曲靖市",
"86158757", "广东省佛山市",
"861302930", "辽宁省营口市",
"861337762", "广东省河源市",
"861897861", "广西百色市",
"861538668", "四川省德阳市",
"861331275", "云南省怒江傈僳族自治州",
"861807558", "湖南省怀化市",
"861328331", "河北省张家口市",
"861882299", "广东省东莞市",
"861311939", "甘肃省庆阳市",
"86147965", "江西省宜春市",
"861333380", "河南省新乡市",
"861806943", "浙江省杭州市",
"86156673", "陕西省渭南市",
"861366551", "安徽省合肥市",
"861569575", "浙江省绍兴市",
"861708578", "江苏省淮安市",
"86181728", "江西省南昌市",
"86137971", "湖北省孝感市",
"861303189", "河北省沧州市",
"861365959", "西藏林芝地区",
"861302556", "广东省肇庆市",
"861813217", "河北省秦皇岛市",
"861857091", "湖南省衡阳市",
"861575905", "福建省三明市",
"861816850", "江苏省宿迁市",
"861330608", "福建省三明市",
"861809402", "福建省龙岩市",
"861301926", "吉林省吉林市",
"86180721", "浙江省温州市",
"861370857", "贵州省毕节地区",
"861831282", "广东省茂名市",
"861537430", "江西省鹰潭市",
"861308135", "辽宁省本溪市",
"861341842", "广东省佛山市",
"861355803", "广西桂林市",
"86182928", "陕西省西安市",
"861534682", "甘肃省定西市",
"861585809", "浙江省舟山市",
"861539178", "安徽省马鞍山市",
"861351162", "江苏省苏州市",
"8613438", "四川省成都市",
"861800758", "广东省肇庆市",
"861850931", "甘肃省兰州市",
"86151346", "黑龙江省哈尔滨市",
"861780848", "贵州省毕节地区",
"861505082", "江苏省徐州市",
"861315048", "新疆阿克苏地区",
"861775883", "黑龙江省佳木斯市",
"861330562", "安徽省铜陵市",
"86156168", "湖南省郴州市",
"86130036", "浙江省杭州市",
"861810452", "黑龙江省齐齐哈尔市",
"861318667", "江苏省常州市",
"861593308", "河北省保定市",
"861571301", "河北省石家庄市",
"861830801", "西藏拉萨市",
"861351756", "广西百色市",
"861390702", "江西省九江市",
"86186428", "辽宁省大连市",
"86189675", "浙江省绍兴市",
"861335933", "甘肃省平凉市",
"861768249", "浙江省嘉兴市",
"861882534", "广东省江门市",
"861303696", "广西百色市",
"861355572", "辽宁省辽阳市",
"86131640", "天津市",
"861898879", "广东省深圳市",
"861521875", "广东省东莞市",
"861323611", "江苏省盐城市",
"861318945", "广东省湛江市",
"861306414", "江西省南昌市",
"861348480", "陕西省西安市",
"861561604", "湖南省湘潭市",
"86185857", "贵州省遵义市",
"861362292", "广东省汕尾市",
"86137953", "上海市",
"861860424", "辽宁省本溪市",
"861399458", "山西省晋中市",
"861512968", "陕西省安康市",
"86152560", "安徽省合肥市",
"861331340", "山西省忻州市",
"861848757", "云南省丽江市",
"861316484", "福建省漳州市",
"86152259", "河南省新乡市",
"861839935", "新疆喀什地区",
"861809640", "安徽省合肥市",
"861347408", "陕西省咸阳市",
"861301149", "河北省邯郸市",
"861801247", "江苏省无锡市",
"861855585", "安徽省六安市",
"861508384", "江西省南昌市",
"861359306", "山西省晋中市",
"861470614", "江苏省常州市",
"861535047", "江西省上饶市",
"861338476", "内蒙古赤峰市",
"861337156", "山东省淄博市",
"861530410", "辽宁省铁岭市",
"86156880", "贵州省铜仁地区",
"861820508", "江苏省南京市",
"861319177", "河北省唐山市",
"86138895", "辽宁省大连市",
"861590680", "浙江省舟山市",
"86180023", "重庆市",
"861813899", "广东省江门市",
"86150830", "河南省安阳市",
"861811427", "江苏省连云港市",
"861394560", "黑龙江省大庆市",
"861811358", "四川省德阳市",
"861368447", "四川省巴中市",
"861827279", "河南省南阳市",
"861820662", "广东省阳江市",
"861328457", "黑龙江省大兴安岭地区",
"861802677", "广东省江门市",
"861393832", "河南省濮阳市",
"861538873", "云南省红河哈尼族彝族自治州",
"861598762", "云南省大理白族自治州",
"861351706", "江西省吉安市",
"861335380", "河南省郑州市",
"861593427", "山西省忻州市",
"861830851", "贵州省贵阳市",
"861867748", "广西贺州市",
"86155489", "内蒙古赤峰市",
"861472894", "西藏林芝地区",
"861571351", "山西省太原市",
"861589798", "湖北省襄樊市",
"861810402", "辽宁省沈阳市",
"86131645", "辽宁省大连市",
"861835728", "浙江省湖州市",
"86189670", "浙江省丽水市",
"861864254", "辽宁省朝阳市",
"86182021", "上海市",
"861819758", "新疆博尔塔拉蒙古自治州",
"861521644", "山东省济南市",
"861459525", "云南省玉溪市",
"861874037", "陕西省宝鸡市",
"861334916", "安徽省巢湖市",
"861399408", "山西省忻州市",
"861453918", "广东省珠海市",
"861350733", "湖南省株洲市",
"861370704", "江西省抚州市",
"861588036", "福建省龙岩市",
"861580739", "湖南省邵阳市",
"861858719", "云南省昆明市",
"86159724", "湖北省恩施土家族苗族自治州",
"86156564", "安徽省六安市",
"861848707", "云南省昆明市",
"86153019", "上海市",
"86155159", "河南省郑州市",
"861818730", "云南省昆明市",
"861836919", "山东省威海市",
"86152565", "安徽省合肥市",
"86151546", "山东省东营市",
"861322090", "山东省威海市",
"861348178", "广西柳州市",
"861347458", "陕西省咸阳市",
"861301998", "辽宁省葫芦岛市",
"86137758", "江苏省徐州市",
"861820558", "安徽省阜阳市",
"86156885", "山东省烟台市",
"861800020", "江西省南昌市",
"861873624", "河南省周口市",
"861596913", "云南省曲靖市",
"861359356", "山西省运城市",
"861332777", "江苏省镇江市",
"86152884", "云南省昆明市",
"861880697", "云南省临沧市",
"861860548", "山东省泰安市",
"861478428", "河南省周口市",
"861570393", "河南省濮阳市",
"861815217", "甘肃省白银市",
"861478357", "河南省许昌市",
"861315119", "江苏省苏州市",
"861556678", "辽宁省朝阳市",
"861831893", "广东省深圳市",
"861363959", "宁夏银川市",
"861552875", "四川省乐山市",
"861339740", "湖南省岳阳市",
"861868191", "陕西省榆林市",
"861323949", "甘肃省酒泉市",
"861897295", "湖北省鄂州市",
"86132666", "广东省深圳市",
"861827064", "江西省宜春市",
"86159406", "辽宁省锦州市",
"861328407", "黑龙江省佳木斯市",
"861587539", "广东省汕头市",
"861362746", "湖南省永州市",
"861337972", "新疆伊犁哈萨克自治州",
"86150835", "江西省南昌市",
"86151815", "四川省凉山彝族自治州",
"861582940", "陕西省宝鸡市",
"861503477", "内蒙古呼和浩特市",
"861801108", "四川省凉山彝族自治州",
"861360559", "安徽省芜湖市",
"861305319", "安徽省阜阳市",
"86147347", "广东省广州市",
"86185676", "河南省洛阳市",
"861700302", "广东省深圳市",
"861320549", "山东省东营市",
"86134839", "河北省邢台市",
"861839981", "新疆塔城地区",
"861369964", "四川省广安市",
"861828886", "云南省丽江市",
"861531472", "浙江省台州市",
"861368590", "福建省泉州市",
"861856939", "湖南省永州市",
"861583099", "河北省石家庄市",
"861777129", "湖北省宜昌市",
"861853444", "山西省晋中市",
"861333343", "山西省太原市",
"86188819", "四川省宜宾市",
"86145025", "河北省唐山市",
"861848914", "西藏林芝地区",
"861846225", "山东省聊城市",
"861884970", "云南省楚雄彝族自治州",
"861370917", "陕西省宝鸡市",
"86134312", "广东省东莞市",
"861589977", "广东省深圳市",
"861816910", "宁夏银川市",
"861770699", "福建省泉州市",
"86188332", "河北省保定市",
"86157629", "山东省临沂市",
"861818891", "湖南省常德市",
"861365819", "四川省乐山市",
"861335962", "黑龙江省大兴安岭地区",
"861502087", "山东省莱芜市",
"861538697", "山西省临汾市",
"861596572", "山东省济宁市",
"861877429", "湖南省郴州市",
"861367759", "新疆哈密地区",
"861351850", "贵州省贵阳市",
"861865686", "安徽省阜阳市",
"861897286", "湖北省荆门市",
"861530378", "河南省洛阳市",
"861572548", "山东省泰安市",
"861320823", "四川省南充市",
"861871878", "广东省深圳市",
"861820633", "山东省日照市",
"861560961", "安徽省安庆市",
"861393863", "河南省开封市",
"861333772", "江苏省南京市",
"861554084", "内蒙古乌海市",
"861450518", "吉林省通化市",
"861876245", "江苏省无锡市",
"861332998", "湖北省咸宁市",
"861337513", "江苏省徐州市",
"861319749", "湖北省荆州市",
"861862393", "河南省濮阳市",
"861335110", "黑龙江省哈尔滨市",
"861588145", "四川省达州市",
"861766642", "广东省东莞市",
"861520426", "辽宁省盘锦市",
"861591009", "山东省济南市",
"861301777", "浙江省嘉兴市",
"86133549", "云南省昆明市",
"861350762", "河南省平顶山市",
"86151810", "四川省德阳市",
"861539443", "福建省泉州市",
"86132337", "河南省平顶山市",
"861709860", "浙江省金华市",
"861811466", "江苏省徐州市",
"861800613", "江苏省苏州市",
"861700352", "山西省大同市",
"861308639", "四川省广安市",
"861302340", "江苏省南京市",
"861570555", "安徽省马鞍山市",
"861324774", "江西省抚州市",
"86145020", "河北省秦皇岛市",
"861339846", "四川省攀枝花市",
"861328941", "陕西省咸阳市",
"861779116", "陕西省延安市",
"861572424", "浙江省温州市",
"861567066", "河南省南阳市",
"861325167", "黑龙江省鸡西市",
"861311349", "广东省汕头市",
"861760852", "贵州省遵义市",
"861868329", "四川省成都市",
"861303685", "广西贵港市",
"861550430", "吉林省长春市",
"861367709", "江西省南昌市",
"861581681", "广东省东莞市",
"861500489", "内蒙古赤峰市",
"861536176", "广东省广州市",
"861510419", "辽宁省辽阳市",
"861534277", "湖北省武汉市",
"861771880", "广东省汕头市",
"861831677", "广东省东莞市",
"861357562", "浙江省舟山市",
"861880873", "云南省红河哈尼族彝族自治州",
"861332149", "吉林省白山市",
"861899449", "江苏省镇江市",
"861564246", "辽宁省葫芦岛市",
"861803672", "江苏省连云港市",
"86155405", "内蒙古通辽市",
"861764527", "黑龙江省双鸭山市",
"861318626", "陕西省咸阳市",
"861354991", "广东省中山市",
"861818836", "四川省凉山彝族自治州",
"861308726", "湖南省邵阳市",
"861572936", "河南省郑州市",
"861360151", "江苏省无锡市",
"861300029", "江苏省南京市",
"861302308", "安徽省合肥市",
"861780910", "陕西省西安市",
"861458650", "湖北省荆州市",
"861555527", "安徽省亳州市",
"861350254", "广东省梅州市",
"861822099", "陕西省商洛市",
"861500914", "陕西省商洛市",
"861582958", "陕西省西安市",
"86150494", "内蒙古鄂尔多斯市",
"861829513", "宁夏吴忠市",
"86395", "河南省漯河市",
"86180297", "广东省清远市",
"86155972", "青海省海东地区",
"861501415", "广东省广州市",
"861362808", "四川省绵阳市",
"861807583", "湖南省湘西土家族苗族自治州",
"861381238", "江苏省泰州市",
"861373474", "内蒙古乌兰察布市",
"861576659", "广东省惠州市",
"861328598", "福建省福州市",
"861839749", "湖南省永州市",
"861777521", "安徽省淮南市",
"861388657", "湖北省荆州市",
"861336162", "江西省南昌市",
"861300345", "江苏省镇江市",
"861571920", "陕西省西安市",
"86137200", "北京市",
"861313785", "河南省驻马店市",
"861881368", "广东省深圳市",
"861317996", "新疆巴音郭楞蒙古自治州",
"861572550", "山东省烟台市",
"861351848", "四川省内江市",
"861333059", "云南省保山市",
"861571774", "广西梧州市",
"861561987", "陕西省延安市",
"86139579", "浙江省金华市",
"86131896", "广东省佛山市",
"861383411", "山西省太原市",
"861770721", "湖北省荆门市",
"861320855", "贵州省黔东南苗族侗族自治州",
"861898792", "云南省普洱市",
"861372084", "福建省泉州市",
"861525907", "福建省宁德市",
"861513869", "河南省郑州市",
"861357640", "江西省景德镇市",
"861785836", "浙江省湖州市",
"861310036", "湖南省娄底市",
"861810713", "湖北省黄冈市",
"861399597", "湖北省黄石市",
"861318739", "湖南省邵阳市",
"861336910", "陕西省咸阳市",
"861360845", "河南省南阳市",
"861800783", "广西桂林市",
"86158540", "山东省菏泽市",
"861550776", "广西百色市",
"861569154", "陕西省宝鸡市",
"861589135", "陕西省咸阳市",
"861772033", "湖北省咸宁市",
"861558079", "湖南省邵阳市",
"861813343", "安徽省铜陵市",
"861529144", "陕西省商洛市",
"861477869", "广东省茂名市",
"861527122", "湖北省武汉市",
"861358710", "浙江省衢州市",
"861515445", "山东省潍坊市",
"861458600", "湖北省恩施土家族苗族自治州",
"86138434", "吉林省四平市",
"861380314", "河北省承德市",
"861393472", "山西省临汾市",
"861302427", "浙江省杭州市",
"861538433", "广东省珠海市",
"861319270", "广东省河源市",
"861317931", "江苏省常州市",
"861846203", "山东省青岛市",
"861309649", "四川省绵阳市",
"861708376", "河南省信阳市",
"861323735", "湖南省郴州市",
"861820497", "内蒙古通辽市",
"861889768", "广西钦州市",
"861370233", "广东省珠海市",
"861533766", "浙江省台州市",
"86188703", "江西省上饶市",
"861886824", "浙江省湖州市",
"861576609", "广东省茂名市",
"861386634", "安徽省淮南市",
"861459116", "广西桂林市",
"861338836", "四川省内江市",
"861366655", "浙江省丽水市",
"861329931", "甘肃省兰州市",
"861362858", "贵州省六盘水市",
"861595930", "福建省宁德市",
"861322848", "四川省乐山市",
"861705178", "浙江省杭州市",
"861570523", "江苏省淮安市",
"86138646", "山东省潍坊市",
"861326645", "广东省江门市",
"861785891", "浙江省丽水市",
"86177020", "广东省广州市",
"861328789", "山东省淄博市",
"861575690", "四川省乐山市",
"861863900", "河南省郑州市",
"861396566", "安徽省宣城市",
"86135028", "广东省深圳市",
"861572500", "山东省威海市",
"861534563", "安徽省宣城市",
"861893485", "广西玉林市",
"861572991", "新疆乌鲁木齐市",
"86187412", "辽宁省鞍山市",
"86137205", "陕西省西安市",
"861535976", "福建省福州市",
"861306577", "浙江省绍兴市",
"861311053", "福建省福州市",
"861360674", "浙江省宁波市",
"861520934", "甘肃省庆阳市",
"861330683", "浙江省嘉兴市",
"861331466", "黑龙江省齐齐哈尔市",
"861333009", "江西省南昌市",
"86156918", "陕西省西安市",
"861340797", "江西省赣州市",
"861580945", "甘肃省金昌市",
"861318492", "河北省秦皇岛市",
"861454580", "甘肃省兰州市",
"861831349", "云南省德宏傣族景颇族自治州",
"86189409", "辽宁省大连市",
"861565947", "福建省泉州市",
"861595556", "安徽省安庆市",
"861452819", "四川省达州市",
"861320805", "浙江省宁波市",
"861390413", "辽宁省抚顺市",
"861537927", "甘肃省张掖市",
"861332541", "陕西省榆林市",
"861314355", "广东省佛山市",
"861370371", "河南省郑州市",
"861591772", "广东省东莞市",
"86158545", "山东省烟台市",
"861568161", "四川省雅安市",
"861303422", "浙江省温州市",
"86151988", "云南省昆明市",
"861817156", "湖北省恩施土家族苗族自治州",
"861500757", "广东省佛山市",
"861306038", "陕西省西安市",
"861339279", "广东省佛山市",
"861392477", "广东省汕头市",
"861537966", "宁夏固原市",
"86155679", "吉林省白城市",
"861769239", "河北省石家庄市",
"861390264", "广东省东莞市",
"861867700", "广西防城港市",
"861338051", "广东省佛山市",
"861880433", "吉林省延边朝鲜族自治州",
"86147075", "广东省广州市",
"86150981", "山东省威海市",
"86187626", "江苏省无锡市",
"861313731", "河南省新乡市",
"861869146", "陕西省延安市",
"861587196", "湖北省襄樊市",
"861821943", "广东省湛江市",
"86152788", "广西柳州市",
"861331427", "辽宁省盘锦市",
"861333899", "江苏省连云港市",
"86189150", "江苏省常州市",
"861331358", "山西省吕梁市",
"861854509", "黑龙江省佳木斯市",
"861550870", "云南省昭通市",
"86156931", "甘肃省兰州市",
"861894884", "广东省韶关市",
"86158816", "四川省绵阳市",
"861525441", "山东省潍坊市",
"861786452", "山东省临沂市",
"861883069", "河北省石家庄市",
"861881406", "广东省中山市",
"861503288", "河北省邯郸市",
"861313242", "河北省衡水市",
"86183640", "山东省菏泽市",
"861308820", "四川省德阳市",
"861808630", "湖北省黄石市",
"86137633", "广东省广州市",
"861802349", "广东省广州市",
"86138010", "北京市",
"861459386", "贵州省黔西南布依族苗族自治州",
"861860991", "新疆乌鲁木齐市",
"861364341", "山西省太原市",
"861860500", "福建省泉州市",
"86151355", "山西省长治市",
"861856745", "河南省信阳市",
"861310801", "陕西省商洛市",
"861824929", "黑龙江省齐齐哈尔市",
"861313000", "辽宁省大连市",
"861896614", "浙江省台州市",
"861301541", "山西省运城市",
"861330452", "黑龙江省齐齐哈尔市",
"861366461", "黑龙江省哈尔滨市",
"861586389", "山东省德州市",
"861325260", "吉林省长春市",
"861893496", "广西河池市",
"861356383", "山东省泰安市",
"861862849", "陕西省宝鸡市",
"861811340", "四川省绵阳市",
"86134852", "江苏省盐城市",
"861840384", "黑龙江省七台河市",
"861561579", "山东省临沂市",
"861707168", "河南省郑州市",
"86158967", "河南省周口市",
"861302466", "浙江省金华市",
"861868788", "云南省楚雄彝族自治州",
"861890334", "河北省秦皇岛市",
"86188359", "山西省运城市",
"861771616", "四川省成都市",
"861814028", "四川省宜宾市",
"861778015", "四川省绵阳市",
"861369437", "吉林省辽源市",
"861776303", "湖北省孝感市",
"861339708", "江西省南昌市",
"861365062", "广东省汕尾市",
"861803143", "河北省秦皇岛市",
"861367487", "内蒙古赤峰市",
"86183197", "广东省茂名市",
"861857377", "湖南省衡阳市",
"861829972", "新疆乌鲁木齐市",
"861567844", "广西玉林市",
"861521481", "新疆乌鲁木齐市",
"861532415", "河北省唐山市",
"861569822", "山东省德州市",
"861860936", "甘肃省张掖市",
"861390079", "江西省南昌市",
"861511496", "陕西省汉中市",
"86136341", "浙江省杭州市",
"861459553", "青海省黄南藏族自治州",
"861853398", "河北省唐山市",
"861593340", "河北省唐山市",
"861867750", "广西贵港市",
"861869081", "新疆乌鲁木齐市",
"861538462", "陕西省榆林市",
"861331308", "河北省衡水市",
"86189155", "江苏省苏州市",
"861452268", "浙江省丽水市",
"861773918", "河南省新乡市",
"86189292", "广东省东莞市",
"861589046", "河南省濮阳市",
"861881456", "黑龙江省黑河市",
"861370262", "广东省佛山市",
"861470784", "广西梧州市",
"861310145", "福建省泉州市",
"861514747", "内蒙古乌兰察布市",
"86137289", "广东省深圳市",
"86186806", "广东省东莞市",
"861356556", "新疆伊犁哈萨克自治州",
"861819740", "青海省海南藏族自治州",
"861835119", "江苏省宿迁市",
"861377679", "江苏省徐州市",
"861335217", "辽宁省丹东市",
"861860550", "安徽省滁州市",
"861329985", "青海省海东地区",
"861324301", "河南省安阳市",
"86183645", "山东省烟台市",
"861820540", "山东省菏泽市",
"861313050", "辽宁省丹东市",
"861891218", "江苏省连云港市",
"861870332", "河北省保定市",
"861566052", "河南省周口市",
"861878868", "贵州省六盘水市",
"861347440", "陕西省延安市",
"861310851", "云南省昆明市",
"861595113", "江苏省苏州市",
"861815380", "湖南省岳阳市",
"86156171", "河南省新乡市",
"861313796", "河南省漯河市",
"861384979", "河南省南阳市",
"861533860", "贵州省贵阳市",
"861587131", "湖北省孝感市",
"861554973", "湖北省随州市",
"861316919", "广东省茂名市",
"861338730", "湖南省岳阳市",
"861317985", "新疆伊犁哈萨克自治州",
"861534532", "山东省青岛市",
"861305581", "福建省泉州市",
"861768924", "福建省漳州市",
"861809562", "安徽省铜陵市",
"86151783", "安徽省蚌埠市",
"861339758", "湖南省娄底市",
"861814916", "陕西省汉中市",
"861306989", "黑龙江省哈尔滨市",
"861308767", "陕西省咸阳市",
"861323781", "广西南宁市",
"861593275", "河北省邯郸市",
"861309801", "陕西省安康市",
"861563451", "山东省济宁市",
"861859823", "广东省江门市",
"861589639", "江苏省镇江市",
"861782823", "四川省成都市",
"861338510", "贵州省贵阳市",
"861450316", "河北省廊坊市",
"861308864", "浙江省台州市",
"861452959", "广东省中山市",
"861530576", "浙江省台州市",
"861555071", "山东省济宁市",
"861375165", "广东省揭阳市",
"861511307", "广东省汕头市",
"86183936", "甘肃省庆阳市",
"861534712", "湖北省恩施土家族苗族自治州",
"86150433", "吉林省延边朝鲜族自治州",
"861360793", "江西省上饶市",
"861334748", "陕西省榆林市",
"861771121", "四川省宜宾市",
"861453746", "湖南省永州市",
"861811113", "四川省绵阳市",
"861591380", "广东省东莞市",
"86137968", "黑龙江省齐齐哈尔市",
"861520557", "安徽省宿州市",
"861590956", "宁夏中卫市",
"861580698", "山东省聊城市",
"861560547", "山东省济宁市",
"861873542", "山西省晋中市",
"861781762", "广东省河源市",
"861570174", "甘肃省金昌市",
"861305422", "黑龙江省大庆市",
"861587128", "湖北省孝感市",
"861576841", "广东省广州市",
"861454829", "广东省汕尾市",
"861392203", "广东省茂名市",
"86188559", "安徽省黄山市",
"861362918", "陕西省咸阳市",
"861314487", "广东省东莞市",
"861300935", "辽宁省锦州市",
"861330640", "山东省济南市",
"861888255", "四川省遂宁市",
"861450195", "山西省朔州市",
"861470887", "云南省迪庆藏族自治州",
"861562942", "湖北省荆门市",
"861323260", "广东省河源市",
"861355825", "广西玉林市",
"861560304", "广东省汕头市",
"861522952", "陕西省榆林市",
"86153952", "安徽省蚌埠市",
"861345037", "广东省广州市",
"861700666", "山东省聊城市",
"861590530", "山东省菏泽市",
"861347568", "山东省潍坊市",
"861315000", "甘肃省张掖市",
"86133923", "广东省东莞市",
"86170812", "天津市",
"861777653", "广西南宁市",
"861820468", "黑龙江省鹤岗市",
"861889797", "江西省赣州市",
"861567747", "广西梧州市",
"861570601", "陕西省西安市",
"86189984", "广东省广州市",
"861893428", "广东省清远市",
"861454543", "新疆哈密地区",
"861321741", "湖南省长沙市",
"86176927", "河北省沧州市",
"861824081", "陕西省延安市",
"861813933", "新疆哈密地区",
"861511357", "广东省湛江市",
"86153801", "江苏省徐州市",
"861810608", "福建省厦门市",
"861336850", "贵州省贵阳市",
"861511428", "辽宁省葫芦岛市",
"861317341", "山东省淄博市",
"861333217", "辽宁省丹东市",
"861379654", "黑龙江省绥化市",
"861845481", "山东省泰安市",
"86185716", "湖北省武汉市",
"861309851", "贵州省贵阳市",
"861591933", "广东省广州市",
"86138493", "河南省新乡市",
"861320915", "陕西省安康市",
"861893544", "山西省晋中市",
"861584885", "内蒙古通辽市",
"861324437", "吉林省辽源市",
"861874293", "新疆乌鲁木齐市",
"861772190", "四川省绵阳市",
"861571693", "河北省张家口市",
"861868412", "贵州省黔南布依族苗族自治州",
"861858196", "四川省成都市",
"86151269", "云南省文山壮族苗族自治州",
"861814031", "四川省宜宾市",
"861835048", "福建省龙岩市",
"861301212", "河北省邢台市",
"861308977", "黑龙江省鹤岗市",
"861886766", "浙江省嘉兴市",
"861881397", "广东省梅州市",
"861810562", "安徽省铜陵市",
"861551952", "贵州省六盘水市",
"861533824", "广东省汕头市",
"861590906", "新疆阿勒泰地区",
"861768960", "福建省福州市",
"861595340", "山东省德州市",
"861321414", "辽宁省本溪市",
"861807540", "安徽省马鞍山市",
"861776729", "浙江省丽水市",
"861516060", "福建省三明市",
"861869929", "新疆塔城地区",
"861805143", "江苏省扬州市",
"861392253", "广东省东莞市",
"861804648", "福建省三明市",
"86188265", "广东省深圳市",
"861867028", "湖南省郴州市",
"861501248", "广东省深圳市",
"861337204", "江苏省宿迁市",
"861313511", "湖南省长沙市",
"861888205", "四川省凉山彝族自治州",
"861362026", "广东省揭阳市",
"861816848", "江苏省徐州市",
"86139799", "江西省萍乡市",
"861325781", "广西柳州市",
"861599780", "湖北省十堰市",
"861894787", "内蒙古鄂尔多斯市",
"86137763", "江苏省苏州市",
"861550927", "陕西省安康市",
"861535860", "江苏省镇江市",
"861858315", "四川省巴中市",
"861560354", "山西省晋中市",
"861829762", "安徽省淮南市",
"86152431", "吉林省长春市",
"86187782", "广西柳州市",
"861580335", "河北省秦皇岛市",
"861520344", "山西省晋中市",
"861328567", "安徽省亳州市",
"861340004", "江苏省无锡市",
"86183176", "河南省平顶山市",
"861339020", "辽宁省锦州市",
"861826247", "江苏省徐州市",
"861377464", "福建省南平市",
"861309145", "黑龙江省哈尔滨市",
"861777603", "广西南宁市",
"861315050", "云南省玉溪市",
"861780850", "贵州省贵阳市",
"861831939", "广东省肇庆市",
"861800740", "湖南省常德市",
"861778995", "西藏昌都地区",
"86151550", "安徽省滁州市",
"861813380", "河北省石家庄市",
"861587689", "广东省广州市",
"861803310", "广东省江门市",
"861510322", "河北省保定市",
"861479714", "山西省忻州市",
"861500854", "贵州省黔南布依族苗族自治州",
"861361701", "江西省鹰潭市",
"86134008", "福建省泉州市",
"861893307", "广东省潮州市",
"861781733", "广东省东莞市",
"861332212", "辽宁省抚顺市",
"861571964", "甘肃省庆阳市",
"861308798", "广西梧州市",
"861884044", "陕西省榆林市",
"861319345", "河南省许昌市",
"861768382", "湖北省黄冈市",
"86188001", "北京市",
"861803180", "河北省衡水市",
"861375474", "山东省临沂市",
"861779588", "陕西省渭南市",
"861897184", "湖北省荆门市",
"861338265", "江苏省徐州市",
"861398927", "四川省绵阳市",
"861556087", "内蒙古赤峰市",
"861300981", "黑龙江省大庆市",
"861550966", "宁夏吴忠市",
"861836545", "江西省上饶市",
"861582074", "广东省惠州市",
"861367355", "河南省周口市",
"861594703", "内蒙古呼和浩特市",
"861310911", "陕西省渭南市",
"861584896", "内蒙古赤峰市",
"861570465", "黑龙江省黑河市",
"861362067", "山西省吕梁市",
"861809713", "青海省黄南藏族自治州",
"861847134", "湖北省荆州市",
"861327345", "河北省邢台市",
"861567179", "湖北省随州市",
"861528449", "云南省丽江市",
"86158340", "山西省太原市",
"861364931", "甘肃省兰州市",
"861891445", "江苏省南京市",
"861378405", "河北省保定市",
"86185517", "江苏省南京市",
"861452297", "山西省吕梁市",
"861321263", "湖南省长沙市",
"86137694", "云南省红河哈尼族彝族自治州",
"861347483", "内蒙古呼和浩特市",
"861336706", "江西省吉安市",
"861319029", "辽宁省阜新市",
"861593506", "山西省晋城市",
"861534425", "内蒙古兴安盟",
"861820583", "浙江省嘉兴市",
"861887264", "湖北省孝感市",
"8613920", "天津市",
"861886727", "湖南省张家界市",
"861453840", "四川省甘孜藏族自治州",
"861509984", "广东省汕头市",
"861533152", "云南省保山市",
"861317928", "吉林省辽源市",
"861523907", "河南省驻马店市",
"861479907", "新疆巴音郭楞蒙古自治州",
"861833389", "河北省唐山市",
"861841907", "甘肃省酒泉市",
"86139379", "河南省洛阳市",
"86138935", "甘肃省武威市",
"861335059", "四川省德阳市",
"861787506", "广东省梅州市",
"861862651", "吉林省吉林市",
"861892302", "广东省梅州市",
"861329928", "广西河池市",
"861560490", "辽宁省铁岭市",
"86150990", "新疆乌鲁木齐市",
"861822641", "安徽省蚌埠市",
"861597836", "河南省信阳市",
"861357452", "湖南省郴州市",
"861364996", "新疆塔城地区",
"86189847", "贵州省毕节地区",
"861820356", "山西省晋城市",
"861810533", "山东省淄博市",
"861476229", "江苏省淮安市",
"861840922", "陕西省榆林市",
"861308589", "广东省中山市",
"86156011", "北京市",
"861524154", "辽宁省锦州市",
"861554732", "内蒙古包头市",
"861814806", "四川省绵阳市",
"861826108", "江苏省宿迁市",
"861339613", "湖北省咸宁市",
"861571877", "云南省玉溪市",
"861536274", "广东省中山市",
"861399483", "山西省吕梁市",
"861830377", "河南省南阳市",
"861872547", "云南省曲靖市",
"861846477", "山东省枣庄市",
"861345578", "山东省滨州市",
"861325735", "湖南省郴州市",
"861360469", "黑龙江省佳木斯市",
"861770738", "湖南省娄底市",
"861802088", "福建省福州市",
"861821980", "甘肃省临夏回族自治州",
"861367305", "河南省安阳市",
"861594753", "内蒙古通辽市",
"861336756", "广西百色市",
"861311745", "湖南省怀化市",
"861310649", "浙江省台州市",
"861889978", "广东省潮州市",
"861563665", "黑龙江省双鸭山市",
"861838111", "四川省广安市",
"861581531", "广东省汕头市",
"86158345", "吉林省通化市",
"861533102", "山西省太原市",
"861332434", "吉林省四平市",
"861317016", "安徽省池州市",
"861508216", "四川省绵阳市",
"861300270", "山东省淄博市",
"86133266", "广东省珠海市",
"861593556", "山西省运城市",
"861804015", "辽宁省朝阳市",
"861335009", "四川省成都市",
"861807497", "广西梧州市",
"861775067", "福建省三明市",
"86151413", "辽宁省抚顺市",
"86138930", "甘肃省白银市",
"861841957", "甘肃省白银市",
"861450186", "山西省长治市",
"861479957", "新疆博尔塔拉蒙古自治州",
"861326777", "广东省汕头市",
"861357402", "湖南省岳阳市",
"861336090", "广东省韶关市",
"861895485", "山东省泰安市",
"86150995", "新疆乌鲁木齐市",
"861304609", "山东省淄博市",
"861329016", "山东省日照市",
"861829733", "安徽省蚌埠市",
"861892352", "广东省潮州市",
"861862601", "江苏省徐州市",
"861533976", "甘肃省张掖市",
"861787556", "广东省阳江市",
"861537274", "浙江省衢州市",
"861304723", "湖南省株洲市",
"861313539", "湖南省邵阳市",
"861847477", "湖南省永州市",
"861786930", "云南省楚雄彝族自治州",
"861320577", "浙江省温州市",
"861302562", "广东省湛江市",
"861335816", "江苏省常州市",
"861390976", "青海省玉树藏族自治州",
"861370154", "江苏省苏州市",
"861366305", "河南省南阳市",
"861508907", "西藏昌都地区",
"861831911", "广东省汕头市",
"861521498", "新疆喀什地区",
"861317809", "福建省泉州市",
"861459338", "四川省内江市",
"86189615", "江苏省无锡市",
"861306805", "山西省晋城市",
"861869098", "新疆乌鲁木齐市",
"861302608", "安徽省马鞍山市",
"861363471", "内蒙古呼和浩特市",
"861351156", "江苏省连云港市",
"861340290", "陕西省延安市",
"861308515", "湖北省宜昌市",
"861458350", "山东省东营市",
"861359943", "福建省福州市",
"861330556", "安徽省安庆市",
"861535413", "河北省张家口市",
"861305598", "福建省南平市",
"861813643", "江苏省苏州市",
"861806497", "四川省成都市",
"861598162", "吉林省通化市",
"86139992", "新疆乌鲁木齐市",
"861323798", "江西省景德镇市",
"861337090", "山东省威海市",
"861520392", "河南省鹤壁市",
"861337756", "广东省珠海市",
"861303526", "湖北省十堰市",
"861760970", "青海省海北藏族自治州",
"861884802", "内蒙古通辽市",
"861319777", "广西钦州市",
"86170804", "广东省深圳市",
"861855945", "福建省龙岩市",
"861322972", "广东省云浮市",
"861816733", "浙江省绍兴市",
"86187327", "河北省沧州市",
"861804089", "新疆伊犁哈萨克自治州",
"861301749", "贵州省遵义市",
"861300645", "四川省德阳市",
"861330930", "甘肃省临夏回族自治州",
"861325726", "湖北省恩施土家族苗族自治州",
"861760724", "湖北省咸宁市",
"861329859", "湖南省郴州市",
"861818130", "四川省凉山彝族自治州",
"861315294", "山西省大同市",
"861534436", "吉林省长春市",
"86147895", "湖南省长沙市",
"861857893", "广西河池市",
"861557087", "湖南省长沙市",
"861804938", "陕西省宝鸡市",
"861837545", "山东省烟台市",
"861369849", "江西省萍乡市",
"861862437", "辽宁省大连市",
"861366355", "山西省长治市",
"861508957", "广东省阳江市",
"861539968", "安徽省阜阳市",
"861351972", "青海省海东地区",
"861809466", "浙江省绍兴市",
"861819158", "陕西省西安市",
"861331533", "河北省张家口市",
"86155301", "河北省石家庄市",
"861334833", "福建省三明市",
"861309349", "安徽省池州市",
"86134792", "江西省九江市",
"861880527", "江苏省扬州市",
"861873594", "山西省临汾市",
"861835128", "江苏省盐城市",
"86189610", "江苏省泰州市",
"861317859", "广东省湛江市",
"861771186", "宁夏固原市",
"861536870", "云南省昭通市",
"86137018", "上海市",
"861591643", "广东省阳江市",
"86138464", "黑龙江省七台河市",
"861330506", "福建省泉州市",
"861458300", "江西省鹰潭市",
"861390152", "江苏省无锡市",
"861773929", "河南省南阳市",
"861828478", "四川省遂宁市",
"861302658", "山东省济南市",
"861380614", "江苏省常州市",
"861306855", "广东省阳江市",
"86185040", "辽宁省沈阳市",
"861538566", "安徽省池州市",
"86155162", "河南省三门峡市",
"861589611", "江苏省连云港市",
"861871486", "安徽省淮南市",
"861870663", "山东省滨州市",
"861370671", "浙江省杭州市",
"861355730", "广西柳州市",
"861786506", "山东省临沂市",
"861881552", "安徽省蚌埠市",
"861323589", "浙江省金华市",
"861831649", "广东省佛山市",
"861830745", "湖南省怀化市",
"861892440", "广东省湛江市",
"861868791", "云南省昆明市",
"861850484", "内蒙古乌兰察布市",
"861899477", "江苏省常州市",
"861332177", "广西贵港市",
"861860988", "辽宁省沈阳市",
"861360374", "河南省许昌市",
"861884852", "贵州省铜仁地区",
"861505865", "浙江省金华市",
"86137794", "新疆阿克苏地区",
"861337706", "广西桂林市",
"861569233", "山东省淄博市",
"861316928", "广东省揭阳市",
"861328535", "山东省烟台市",
"861595402", "山东省日照市",
"861785888", "浙江省宁波市",
"861351513", "江苏省盐城市",
"86153303", "重庆市",
"861473060", "河北省唐山市",
"861314461", "黑龙江省哈尔滨市",
"861580326", "河北省廊坊市",
"861771195", "西藏昌都地区",
"861517060", "江西省赣州市",
"861308260", "山东省东营市",
"86188879", "云南省普洱市",
"861362035", "广东省肇庆市",
"861839541", "陕西省渭南市",
"861300018", "天津市",
"861570437", "吉林省辽源市",
"861336204", "浙江省衢州市",
"861337850", "贵州省贵阳市",
"861320989", "山西省运城市",
"861833185", "河北省邯郸市",
"861316341", "黑龙江省哈尔滨市",
"861575454", "黑龙江省佳木斯市",
"86187905", "河南省新乡市",
"86151875", "云南省保山市",
"861582580", "甘肃省天水市",
"861302533", "广东省汕头市",
"861457118", "湖北省荆门市",
"86133628", "浙江省宁波市",
"861824067", "河南省新乡市",
"86137374", "广西梧州市",
"861333906", "安徽省安庆市",
"861776603", "江苏省泰州市",
"861558152", "湖南省邵阳市",
"861390824", "四川省达州市",
"861890634", "山东省莱芜市",
"861323864", "云南省曲靖市",
"861301177", "山东省泰安市",
"861770529", "江苏省镇江市",
"861454908", "湖北省宜昌市",
"86182342", "山西省大同市",
"861355891", "四川省自贡市",
"861870994", "新疆昌吉回族自治州",
"86158937", "河南省许昌市",
"861587615", "广东省汕头市",
"86178028", "四川省成都市",
"861535079", "河北省沧州市",
"861868830", "广东省惠州市",
"861880566", "安徽省池州市",
"861500200", "广东省广州市",
"86139699", "山东省临沂市",
"861809427", "江苏省苏州市",
"861871495", "安徽省黄山市",
"861596051", "福建省莆田市",
"861572988", "四川省达州市",
"861333172", "吉林省吉林市",
"86137663", "江西省赣州市",
"861518221", "四川省眉山市",
"861867257", "湖北省荆州市",
"861802649", "广东省惠州市",
"861577105", "湖北省咸宁市",
"86187682", "浙江省湖州市",
"861324651", "广东省湛江市",
"861858389", "四川省攀枝花市",
"861364641", "山东省济南市",
"861780204", "广东省中山市",
"861827247", "湖北省襄樊市",
"861368479", "内蒙古锡林郭勒盟",
"861459686", "新疆石河子市",
"86184060", "辽宁省沈阳市",
"861347075", "安徽省芜湖市",
"861786275", "山东省枣庄市",
"861333530", "陕西省咸阳市",
"86157548", "内蒙古呼和浩特市",
"861855626", "江苏省宿迁市",
"861325767", "广东省茂名市",
"86158177", "广东省东莞市",
"861334862", "湖南省湘潭市",
"861355836", "广西百色市",
"861364919", "陕西省铜川市",
"861787640", "广东省江门市",
"861507644", "河北省保定市",
"861300926", "辽宁省抚顺市",
"86131756", "浙江省温州市",
"861458494", "山东省淄博市",
"861577841", "广西南宁市",
"861866916", "云南省昆明市",
"861328581", "浙江省杭州市",
"861593640", "河南省南阳市",
"861853698", "山西省忻州市",
"861337800", "湖南省岳阳市",
"861331562", "河北省廊坊市",
"861533220", "陕西省咸阳市",
"86151870", "云南省昭通市",
"861454958", "江苏省扬州市",
"861775035", "福建省莆田市",
"86130997", "青海省西宁市",
"861535264", "新疆和田地区",
"861346568", "山东省潍坊市",
"861338888", "云南省丽江市",
"861333956", "黑龙江省鸡西市",
"86131076", "福建省福州市",
"861332749", "山西省朔州市",
"861774940", "河南省安阳市",
"861566747", "陕西省汉中市",
"861319998", "新疆喀什地区",
"861317099", "江西省上饶市",
"861569262", "西藏日喀则地区",
"861870632", "山东省枣庄市",
"861323977", "新疆克拉玛依市",
"861563637", "黑龙江省牡丹江市",
"861330275", "广东省揭阳市",
"861370822", "四川省成都市",
"861539017", "四川省广安市",
"861350910", "陕西省咸阳市",
"861815680", "安徽省六安市",
"86184065", "山西省太原市",
"861329099", "河南省信阳市",
"861452828", "四川省眉山市",
"861778921", "陕西省渭南市",
"861780254", "江苏省宿迁市",
"861890992", "新疆乌鲁木齐市",
"861394342", "吉林省白山市",
"861857053", "湖南省娄底市",
"861327998", "新疆喀什地区",
"861322513", "江苏省南通市",
"861816972", "广西贵港市",
"861300149", "河北省石家庄市",
"861323820", "辽宁省营口市",
"861823630", "河南省周口市",
"861390860", "湖北省宜昌市",
"861531410", "山东省济南市",
"861527200", "湖北省孝感市",
"861369601", "四川省南充市",
"861592619", "湖北省十堰市",
"861580398", "河南省三门峡市",
"861376679", "黑龙江省大庆市",
"861573454", "黑龙江省佳木斯市",
"861778938", "甘肃省张掖市",
"861452831", "四川省资阳市",
"861366487", "内蒙古包头市",
"861550274", "湖北省孝感市",
"861457049", "广东省中山市",
"861894280", "四川省凉山彝族自治州",
"86150463", "黑龙江省牡丹江市",
"861824808", "内蒙古鄂尔多斯市",
"861342184", "广东省深圳市",
"861379304", "山东省菏泽市",
"861593402", "山西省大同市",
"861839434", "甘肃省平凉市",
"861814207", "浙江省温州市",
"861810358", "山西省吕梁市",
"86134572", "广西柳州市",
"86183966", "山东省烟台市",
"861572646", "山东省潍坊市",
"861810427", "辽宁省盘锦市",
"861779950", "新疆巴音郭楞蒙古自治州",
"861350756", "福建省三明市",
"861328422", "辽宁省大连市",
"861831801", "广东省广州市",
"861473024", "河北省沧州市",
"861893657", "江苏省连云港市",
"861317919", "吉林省通化市",
"861316985", "广东省中山市",
"86130136", "江苏省无锡市",
"861878742", "云南省曲靖市",
"861308224", "辽宁省葫芦岛市",
"861306915", "吉林省吉林市",
"861519042", "江苏省扬州市",
"861520875", "云南省保山市",
"861589167", "陕西省汉中市",
"861860925", "陕西省渭南市",
"86151683", "浙江省杭州市",
"861357930", "新疆喀什地区",
"861700366", "广东省东莞市",
"861517024", "江西省南昌市",
"861335172", "黑龙江省齐齐哈尔市",
"86183817", "四川省南充市",
"861333710", "内蒙古呼和浩特市",
"861454269", "西藏拉萨市",
"86136186", "湖北省武汉市",
"86147881", "河南省驻马店市",
"861533079", "吉林省白城市",
"861560604", "福建省漳州市",
"86183745", "湖南省怀化市",
"861318444", "浙江省宁波市",
"861325864", "黑龙江省大庆市",
"861350090", "吉林省吉林市",
"861335906", "安徽省阜阳市",
"861346440", "辽宁省朝阳市",
"86137574", "浙江省宁波市",
"86182542", "山东省青岛市",
"861527042", "江西省宜春市",
"861347302", "河北省邯郸市",
"861834990", "四川省成都市",
"861330340", "山西省太原市",
"861596510", "山东省济宁市",
"861458546", "河南省三门峡市",
"861508817", "广东省云浮市",
"86187726", "湖北省荆州市",
"86134215", "广东省汕尾市",
"861535220", "甘肃省酒泉市",
"861300998", "黑龙江省双鸭山市",
"86184402", "新疆乌鲁木齐市",
"86131097", "青海省西宁市",
"861861548", "山东省菏泽市",
"861369651", "安徽省合肥市",
"861562878", "山东省济南市",
"861566675", "山东省济宁市",
"861383439", "山西省运城市",
"861889290", "新疆克孜勒苏柯尔克孜自治州",
"861567240", "湖北省荆州市",
"861329641", "山东省济南市",
"861359980", "福建省宁德市",
"861816156", "宁夏石嘴山市",
"861307038", "新疆昌吉回族自治州",
"861318711", "湖南省永州市",
"861526804", "浙江省舟山市",
"861309939", "甘肃省嘉峪关市",
"861850545", "山东省烟台市",
"861571393", "河南省濮阳市",
"861864848", "内蒙古包头市",
"86155779", "广西北海市",
"861337133", "山东省滨州市",
"861779900", "新疆阿克苏地区",
"86157348", "内蒙古呼伦贝尔市",
"861317641", "山东省济南市",
"861779591", "陕西省西安市",
"861866700", "浙江省杭州市",
"861335530", "山东省菏泽市",
"861812029", "湖北省孝感市",
"861788906", "西藏那曲地区",
"861550069", "青海省海东地区",
"861390727", "湖北省襄樊市",
"861314159", "湖南省郴州市",
"861814257", "四川省自贡市",
"861380063", "山东省聊城市",
"861323767", "江西省赣州市",
"861388485", "山东省滨州市",
"86187404", "陕西省西安市",
"86137178", "北京市",
"861811402", "江苏省南京市",
"861319926", "黑龙江省伊春市",
"861521467", "黑龙江省鸡西市",
"861570351", "山西省太原市",
"861893607", "江苏省无锡市",
"861831851", "广东省广州市",
"861350706", "江西省九江市",
"86138547", "山东省济宁市",
"86158196", "广东省揭阳市",
"861394963", "河南省新乡市",
"861597237", "湖北省黄石市",
"861778089", "四川省眉山市",
"861813680", "江苏省镇江市",
"861478322", "河南省漯河市",
"861517192", "湖北省宜昌市",
"861770786", "广西百色市",
"86183740", "湖南省长沙市",
"86152461", "黑龙江省大庆市",
"861452896", "云南省昆明市",
"861580635", "山东省聊城市",
"86137733", "江苏省扬州市",
"861351733", "湖南省株洲市",
"861592941", "陕西省延安市",
"861898744", "云南省曲靖市",
"861520644", "山东省枣庄市",
"86182121", "贵州省遵义市",
"861812345", "四川省成都市",
"861773035", "安徽省阜阳市",
"861529192", "陕西省商洛市",
"861857745", "广西南宁市",
"861567002", "河南省安阳市",
"861887152", "湖北省咸宁市",
"86139601", "福建省漳州市",
"861335956", "黑龙江省牡丹江市",
"861843467", "山西省忻州市",
"861350850", "贵州省黔南布依族苗族自治州",
"86155399", "河南省南阳市",
"861843426", "山西省晋城市",
"861802145", "江苏省常州市",
"861365471", "内蒙古呼和浩特市",
"861567892", "广西南宁市",
"861533413", "湖北省黄冈市",
"86138746", "湖南省永州市",
"861327645", "山东省烟台市",
"861787683", "广东省河源市",
"861818853", "贵州省安顺市",
"861388496", "山东省青岛市",
"861870878", "云南省楚雄彝族自治州",
"861373137", "河北省衡水市",
"861359362", "湖北省恩施土家族苗族自治州",
"861700408", "广东省中山市",
"861333816", "江苏省常州市",
"861319645", "江苏省扬州市",
"861777595", "湖南省永州市",
"861538071", "江苏省泰州市",
"861454818", "广东省东莞市",
"861773146", "河北省唐山市",
"861316931", "广东省中山市",
"861888087", "四川省德阳市",
"861300777", "青海省西宁市",
"861820606", "福建省厦门市",
"861334150", "吉林省吉林市",
"861593683", "河南省安阳市",
"861539259", "山西省运城市",
"861592457", "内蒙古鄂尔多斯市",
"861760760", "广东省中山市",
"861832020", "广东省惠州市",
"861315539", "安徽省六安市",
"861323726", "湖北省随州市",
"861558727", "云南省大理白族自治州",
"86187527", "江苏省扬州市",
"861452885", "云南省保山市",
"861774983", "河北省沧州市",
"861304359", "福建省龙岩市",
"861369465", "黑龙江省哈尔滨市",
"861576723", "广东省梅州市",
"861305526", "福建省福州市",
"861830003", "广东省河源市",
"861354903", "西藏那曲地区",
"861571505", "福建省漳州市",
"861848415", "贵州省安顺市",
"861361559", "安徽省黄山市",
"861364859", "贵州省黔西南布依族苗族自治州",
"861325798", "江西省景德镇市",
"861530472", "内蒙古包头市",
"861324849", "浙江省金华市",
"861893419", "广东省云浮市",
"861303598", "云南省西双版纳傣族自治州",
"861835131", "江苏省南通市",
"861808940", "甘肃省甘南藏族自治州",
"861770795", "江西省宜春市",
"861338825", "四川省眉山市",
"861760827", "四川省巴中市",
"861556576", "河南省南阳市",
"861350800", "四川省德阳市",
"861551430", "河南省濮阳市",
"86156613", "内蒙古包头市",
"861816513", "陕西省渭南市",
"861380032", "山西省忻州市",
"86139284", "广东省深圳市",
"861773081", "河南省安阳市",
"861884573", "黑龙江省大兴安岭地区",
"861818803", "贵州省安顺市",
"861776521", "广东省珠海市",
"861770880", "云南省德宏傣族景颇族自治州",
"861319874", "四川省达州市",
"861452790", "新疆乌鲁木齐市",
"861867019", "江西省萍乡市",
"861700327", "河北省石家庄市",
"86155501", "山东省菏泽市",
"861339313", "河北省张家口市",
"861844975", "新疆伊犁哈萨克自治州",
"861582543", "浙江省温州市",
"861313294", "广西贺州市",
"861310025", "湖南省长沙市",
"861860646", "山东省东营市",
"861573390", "河北省邢台市",
"861785825", "浙江省台州市",
"86131116", "河北省保定市",
"861592407", "浙江省衢州市",
"861539209", "福建省泉州市",
"861598756", "云南省德宏傣族景颇族自治州",
"861820656", "山东省滨州市",
"861553462", "山西省晋城市",
"861568187", "四川省达州市",
"861810466", "黑龙江省大庆市",
"861304309", "福建省漳州市",
"861811683", "新疆博尔塔拉蒙古自治州",
"861539778", "四川省绵阳市",
"861351762", "广西柳州市",
"861800158", "江苏省南京市",
"861337910", "陕西省咸阳市",
"861764552", "黑龙江省绥化市",
"861361509", "福建省漳州市",
"861824098", "新疆乌鲁木齐市",
"861571555", "安徽省马鞍山市",
"861388431", "浙江省舟山市",
"861308735", "湖南省郴州市",
"861572925", "河南省濮阳市",
"861513070", "河北省石家庄市",
"861325589", "浙江省金华市",
"861872604", "安徽省马鞍山市",
"861313719", "河南省安阳市",
"861316996", "广东省佛山市",
"861563365", "河北省衡水市",
"861516144", "江苏省扬州市",
"861477070", "江西省南昌市",
"861459321", "四川省广安市",
"861310349", "山西省朔州市",
"861814999", "新疆伊犁哈萨克自治州",
"86158017", "上海市",
"861819922", "新疆巴音郭楞蒙古自治州",
"861899583", "湖北省荆州市",
"861558341", "四川省成都市",
"861313069", "辽宁省阜新市",
"86145488", "四川省成都市",
"861572884", "广东省深圳市",
"861346577", "山东省济宁市",
"861850702", "江西省九江市",
"86135675", "浙江省绍兴市",
"861860569", "安徽省芜湖市",
"861471533", "广东省佛山市",
"861302032", "辽宁省沈阳市",
"861803435", "河北省唐山市",
"861566686", "山东省德州市",
"861300797", "宁夏银川市",
"861776754", "新疆喀什地区",
"861859327", "广西桂林市",
"861339216", "广东省深圳市",
"861889935", "新疆喀什地区",
"861869954", "新疆吐鲁番地区",
"861500543", "山东省滨州市",
"861859458", "福建省龙岩市",
"861365491", "辽宁省大连市",
"86157280", "浙江省宁波市",
"861454804", "广东省汕头市",
"861886641", "山东省济南市",
"861818419", "贵州省黔西南布依族苗族自治州",
"861567872", "广西柳州市",
"861310433", "吉林省延边朝鲜族自治州",
"861808489", "四川省绵阳市",
"861772436", "广东省广州市",
"861388476", "山东省泰安市",
"861585047", "江苏省镇江市",
"861533859", "贵州省黔西南布依族苗族自治州",
"861580410", "辽宁省铁岭市",
"861379470", "广东省河源市",
"861530492", "辽宁省营口市",
"86155576", "浙江省台州市",
"861561516", "山东省东营市",
"86145033", "辽宁省沈阳市",
"861356221", "山东省枣庄市",
"861381340", "江苏省盐城市",
"861770775", "广西玉林市",
"861364413", "辽宁省抚顺市",
"861539589", "浙江省台州市",
"861512198", "宁夏银川市",
"861477706", "广西玉林市",
"861556531", "河南省许昌市",
"861761487", "内蒙古赤峰市",
"861771420", "江苏省南京市",
"861854560", "黑龙江省齐齐哈尔市",
"861555939", "新疆巴音郭楞蒙古自治州",
"861853832", "河南省郑州市",
"86181010", "北京市",
"861353622", "广东省江门市",
"86186793", "江西省上饶市",
"861850752", "广东省惠州市",
"861520005", "河北省保定市",
"861340345", "山西省太原市",
"861844995", "新疆伊犁哈萨克自治州",
"861301168", "山东省潍坊市",
"861881893", "广东省汕头市",
"861336445", "吉林省通化市",
"86186998", "新疆喀什地区",
"861311456", "黑龙江省黑河市",
"86133890", "天津市",
"861452770", "广西南宁市",
"861378746", "湖南省永州市",
"861708628", "山东省临沂市",
"861331063", "山东省日照市",
"861313274", "广西梧州市",
"86135670", "浙江省衢州市",
"861524336", "河北省承德市",
"861598070", "福建省福州市",
"861334365", "河南省开封市",
"861890733", "湖南省株洲市",
"861869904", "新疆克拉玛依市",
"861776704", "浙江省舟山市",
"861368973", "吉林省四平市",
"861470556", "安徽省安庆市",
"861707541", "福建省厦门市",
"861835902", "福建省莆田市",
"861825157", "江苏省无锡市",
"861365249", "广东省东莞市",
"861533809", "广东省广州市",
"861865147", "江苏省淮安市",
"861834235", "辽宁省葫芦岛市",
"861316976", "广东省茂名市",
"861522048", "广东省河源市",
"861384916", "河南省开封市",
"861530739", "湖南省邵阳市",
"861370325", "河北省唐山市",
"86158019", "上海市",
"861520886", "云南省怒江傈僳族自治州",
"861477090", "江西省赣州市",
"861379188", "山东省潍坊市",
"861394845", "内蒙古通辽市",
"861512949", "陕西省商洛市",
"861880851", "贵州省贵阳市",
"861539798", "江西省景德镇市",
"861847583", "广东省中山市",
"861877889", "广西北海市",
"861365436", "吉林省长春市",
"861320483", "内蒙古阿拉善盟",
"861895130", "江苏省南通市",
"861824078", "河南省商丘市",
"861470930", "甘肃省兰州市",
"861818657", "湖北省荆州市",
"861567621", "广西桂林市",
"861556585", "河南省周口市",
"861836047", "江苏省苏州市",
"86186551", "安徽省合肥市",
"861321627", "浙江省衢州市",
"861821837", "广东省湛江市",
"861362565", "安徽省合肥市",
"86139676", "浙江省台州市",
"861811238", "江苏省无锡市",
"861306302", "福建省漳州市",
"861476254", "江苏省苏州市",
"861514638", "黑龙江省哈尔滨市",
"861535641", "浙江省温州市",
"861471608", "广东省中山市",
"861870764", "广东省茂名市",
"861332168", "广西贵港市",
"861709545", "江苏省苏州市",
"861568548", "贵州省六盘水市",
"861477800", "广东省湛江市",
"86182084", "贵州省遵义市",
"861393444", "山西省忻州市",
"861345581", "山东省泰安市",
"861580378", "河南省开封市",
"861302063", "山东省枣庄市",
"86159781", "广西南宁市",
"861471562", "广东省佛山市",
"861348767", "湖南省益阳市",
"861346989", "湖北省黄冈市",
"861843143", "河北省保定市",
"861889981", "广东省中山市",
"86159575", "浙江省绍兴市",
"861510730", "湖南省岳阳市",
"86132708", "江苏省南京市",
"861533099", "辽宁省葫芦岛市",
"861870058", "陕西省西安市",
"861318061", "吉林省白城市",
"861553349", "河北省唐山市",
"861383343", "河北省承德市",
"86183819", "四川省达州市",
"861453455", "安徽省合肥市",
"861558016", "湖南省怀化市",
"861551615", "河南省郑州市",
"861550719", "湖北省黄冈市",
"861539977", "湖南省常德市",
"86183332", "河北省保定市",
"86152821", "四川省内江市",
"861472749", "贵州省黔西南布依族苗族自治州",
"861454122", "河北省保定市",
"861777206", "广西钦州市",
"861815847", "浙江省宁波市",
"86182660", "山东省枣庄市",
"861813411", "河北省石家庄市",
"861560618", "江苏省无锡市",
"861502635", "新疆阿克苏地区",
"861532940", "贵州省贵阳市",
"86539", "山东省临沂市",
"861773423", "河北省邯郸市",
"861518402", "辽宁省大连市",
"861360642", "山东省青岛市",
"861569946", "新疆喀什地区",
"861335192", "黑龙江省齐齐哈尔市",
"861825248", "江苏省南通市",
"861359291", "广东省揭阳市",
"861538851", "山西省太原市",
"861529956", "新疆哈密地区",
"861803481", "新疆喀什地区",
"861348820", "陕西省安康市",
"861571373", "河南省新乡市",
"861528662", "贵州省黔东南苗族侗族自治州",
"861459179", "内蒙古鄂尔多斯市",
"861830873", "云南省红河哈尼族彝族自治州",
"861586902", "浙江省杭州市",
"861860884", "云南省红河哈尼族彝族自治州",
"861330861", "湖北省荆州市",
"86180030", "广东省惠州市",
"861599344", "河南省商丘市",
"861333060", "四川省雅安市",
"861597322", "湖南省湘潭市",
"861872045", "江西省宜春市",
"861818607", "湖北省武汉市",
"861373442", "山东省泰安市",
"861327768", "湖北省武汉市",
"861760623", "山东省聊城市",
"861768819", "广东省珠海市",
"861880091", "四川省遂宁市",
"861303037", "河南省三门峡市",
"861306352", "江苏省徐州市",
"861316824", "广东省汕头市",
"861572569", "山东省枣庄市",
"861520780", "广西北海市",
"861341541", "广东省中山市",
"861898680", "湖北省宜昌市",
"8613714", "广东省深圳市",
"861319768", "广西河池市",
"861477850", "广东省河源市",
"861300978", "黑龙江省佳木斯市",
"861813744", "河南省商丘市",
"861810314", "河北省承德市",
"861889270", "四川省广安市",
"861354161", "四川省内江市",
"861366852", "贵州省遵义市",
"861566695", "山东省聊城市",
"861881677", "广东省惠州市",
"86181434", "浙江省杭州市",
"861513850", "河南省濮阳市",
"861708319", "河北省沧州市",
"86131099", "新疆乌鲁木齐市",
"861331032", "内蒙古鄂尔多斯市",
"861842025", "广东省梅州市",
"861524688", "黑龙江省双鸭山市",
"861821288", "贵州省黔西南布依族苗族自治州",
"861344155", "山东省菏泽市",
"861378840", "广西南宁市",
"861452876", "宁夏吴忠市",
"861536728", "湖南省娄底市",
"861811887", "江苏省无锡市",
"86186373", "河南省新乡市",
"861320568", "安徽省阜阳市",
"861458669", "湖南省郴州市",
"861517906", "江西省赣州市",
"861859366", "福建省福州市",
"861700263", "广东省江门市",
"861371718", "广东省东莞市",
"861590879", "云南省普洱市",
"86138549", "山东省临沂市",
"86186664", "广东省东莞市",
"861571231", "辽宁省沈阳市",
"861304624", "广东省湛江市",
"861874631", "黑龙江省牡丹江市",
"861595784", "浙江省丽水市",
"86182665", "山东省滨州市",
"861814587", "广东省东莞市",
"861589443", "云南省德宏傣族景颇族自治州",
"861529906", "新疆乌鲁木齐市",
"861395596", "安徽省黄山市",
"861576660", "广东省汕头市",
"861571742", "湖南省湘潭市",
"861390341", "山西省太原市",
"861335024", "四川省宜宾市",
"861539767", "四川省泸州市",
"861852734", "湖北省武汉市",
"861880911", "陕西省延安市",
"861804737", "内蒙古鄂尔多斯市",
"861536731", "湖南省长沙市",
"86178581", "浙江省绍兴市",
"861771175", "湖南省怀化市",
"861384856", "内蒙古赤峰市",
"861705181", "海南省海口市",
"861533641", "山东省济南市",
"861889345", "甘肃省兰州市",
"861314044", "河南省焦作市",
"86186351", "山西省太原市",
"861520261", "宁夏银川市",
"861593221", "河北省石家庄市",
"861457104", "江苏省扬州市",
"86188877", "云南省玉溪市",
"86130008", "广东省广州市",
"861875123", "江苏省连云港市",
"86153556", "浙江省台州市",
"861328201", "浙江省杭州市",
"861871475", "黑龙江省齐齐哈尔市",
"86145094", "江苏省无锡市",
"861805481", "福建省厦门市",
"861885785", "浙江省温州市",
"86139697", "山东省青岛市",
"861823248", "河北省廊坊市",
"86181935", "甘肃省武威市",
"861815411", "安徽省合肥市",
"861830668", "广东省茂名市",
"861813847", "广东省佛山市",
"861338322", "河北省保定市",
"861309462", "浙江省绍兴市",
"86180784", "广西桂林市",
"861855863", "福建省三明市",
"861360450", "黑龙江省哈尔滨市",
"861870720", "湖北省宜昌市",
"861504699", "黑龙江省黑河市",
"861325017", "广东省广州市",
"861301197", "河北省秦皇岛市",
"861889029", "湖南省衡阳市",
"861896308", "山东省济南市",
"861317264", "广东省肇庆市",
"861509001", "河南省安阳市",
"86183532", "山东省青岛市",
"861535099", "辽宁省辽阳市",
"861847540", "广东省阳江市",
"861830502", "浙江省衢州市",
"86159375", "河南省平顶山市",
"86158939", "河南省驻马店市",
"861890156", "江苏省苏州市",
"861370388", "河南省洛阳市",
"86182735", "湖南省郴州市",
"861860787", "广西柳州市",
"861555349", "山东省滨州市",
"861870974", "青海省海南藏族自治州",
"861779066", "黑龙江省牡丹江市",
"861362423", "辽宁省抚顺市",
"861853678", "山西省晋中市",
"861832957", "陕西省西安市",
"861769705", "青海省果洛藏族自治州",
"861340935", "河南省许昌市",
"86139140", "江苏省苏州市",
"86132872", "山东省济宁市",
"861390985", "辽宁省大连市",
"861594547", "黑龙江省牡丹江市",
"861564956", "河南省驻马店市",
"861568460", "山东省临沂市",
"861899540", "宁夏固原市",
"861780584", "浙江省宁波市",
"86158179", "广东省汕头市",
"861510510", "江苏省盐城市",
"861384806", "内蒙古赤峰市",
"861562826", "新疆伊犁哈萨克自治州",
"861318576", "浙江省台州市",
"861776097", "四川省德阳市",
"861347095", "安徽省马鞍山市",
"861380533", "山东省淄博市",
"861816012", "四川省广安市",
"861550539", "山东省临沂市",
"861334637", "山东省枣庄市",
"861506821", "浙江省嘉兴市",
"861375442", "河北省保定市",
"86134166", "广东省东莞市",
"861335060", "四川省宜宾市",
"861576624", "广东省湛江市",
"861886809", "浙江省衢州市",
"861500580", "浙江省舟山市",
"861811221", "江苏省徐州市",
"861336584", "湖南省张家界市",
"861366573", "浙江省湖州市",
"861514621", "黑龙江省齐齐哈尔市",
"86159438", "吉林省松原市",
"86184842", "贵州省遵义市",
"861479183", "陕西省西安市",
"861863208", "河北省邢台市",
"861323997", "新疆阿克苏地区",
"861328251", "浙江省金华市",
"861327978", "新疆巴音郭楞蒙古自治州",
"861358144", "湖北省襄樊市",
"861802566", "广东省中山市",
"861827384", "湖南省怀化市",
"861563862", "河南省信阳市",
"861890972", "青海省海东地区",
"861870867", "贵州省六盘水市",
"86178770", "广西南宁市",
"861316860", "广东省惠州市",
"861329079", "河南省安阳市",
"86155796", "江西省吉安市",
"86181930", "甘肃省临夏回族自治州",
"861364220", "广东省汕头市",
"86177814", "四川省成都市",
"861306075", "广东省佛山市",
"861809314", "甘肃省白银市",
"86186573", "浙江省嘉兴市",
"861507780", "江苏省徐州市",
"861887016", "江西省鹰潭市",
"86130999", "云南省昆明市",
"861764053", "辽宁省辽阳市",
"861300768", "河南省漯河市",
"861508279", "四川省南充市",
"861345422", "浙江省台州市",
"861317079", "云南省迪庆藏族自治州",
"861470340", "山西省忻州市",
"86182730", "湖南省岳阳市",
"861319978", "新疆塔城地区",
"861880649", "山东省滨州市",
"861830552", "安徽省蚌埠市",
"86159370", "河南省商丘市",
"861801441", "江苏省连云港市",
"861520743", "湖南省湘西土家族苗族自治州",
"861535859", "江苏省镇江市",
"861583047", "河北省沧州市",
"86135146", "黑龙江省齐齐哈尔市",
"861898643", "湖北省随州市",
"861521478", "浙江省台州市",
"861770965", "安徽省蚌埠市",
"861351634", "山东省莱芜市",
"86131260", "广东省茂名市",
"861833952", "河南省新乡市",
"861323209", "广东省韶关市",
"86188656", "山东省烟台市",
"861819114", "陕西省西安市",
"861770647", "浙江省宁波市",
"861767701", "广西南宁市",
"861325968", "宁夏银川市",
"861552180", "广东省广州市",
"86155597", "云南省昆明市",
"861869078", "贵州省安顺市",
"861523313", "河北省张家口市",
"861363491", "辽宁省朝阳市",
"861370636", "山东省东营市",
"86159411", "辽宁省大连市",
"86180910", "陕西省西安市",
"861893572", "新疆昌吉回族自治州",
"861312684", "内蒙古巴彦淖尔市",
"861354617", "山西省临汾市",
"861315069", "云南省昭通市",
"861894346", "吉林省白城市",
"861474100", "辽宁省铁岭市",
"861380658", "浙江省台州市",
"861390996", "新疆巴音郭楞蒙古自治州",
"861320597", "福建省龙岩市",
"8615928", "四川省成都市",
"861843478", "山西省临汾市",
"861886099", "江苏省无锡市",
"861760990", "新疆克拉玛依市",
"86170940", "辽宁省大连市",
"861319797", "江西省赣州市",
"861890513", "江苏省连云港市",
"86471", "内蒙古呼和浩特市",
"861760501", "福建省福州市",
"861398539", "贵州省黔西南布依族苗族自治州",
"861556444", "山东省淄博市",
"861565150", "江苏省无锡市",
"861567553", "安徽省芜湖市",
"861366912", "陕西省榆林市",
"861348589", "安徽省阜阳市",
"86159790", "江西省南昌市",
"861336869", "贵州省贵阳市",
"861527543", "山东省滨州市",
"861778517", "贵州省毕节地区",
"86187329", "河北省邢台市",
"861525140", "江苏省无锡市",
"861588552", "贵州省贵阳市",
"861516059", "福建省宁德市",
"861534471", "广东省广州市",
"861709484", "浙江省宁波市",
"861840846", "宁夏固原市",
"861806477", "浙江省温州市",
"861330286", "广东省珠海市",
"86155376", "河南省信阳市",
"86185862", "内蒙古呼和浩特市",
"86187987", "贵州省贵阳市",
"861519543", "江苏省盐城市",
"861537719", "湖北省咸宁市",
"86178390", "河南省商丘市",
"861589480", "内蒙古呼伦贝尔市",
"861309433", "云南省昭通市",
"861520372", "河南省安阳市",
"861323778", "广西河池市",
"861768959", "西藏拉萨市",
"861560703", "江西省上饶市",
"861599934", "新疆哈密地区",
"861356238", "山东省日照市",
"861779027", "四川省成都市",
"86131265", "北京市",
"861584682", "黑龙江省哈尔滨市",
"861506672", "山东省泰安市",
"86170766", "广东省广州市",
"861529816", "四川省宜宾市",
"861317413", "江苏省扬州市",
"861538911", "陕西省延安市",
"861536890", "云南省西双版纳傣族自治州",
"861380562", "安徽省宣城市",
"861316766", "安徽省阜阳市",
"861311397", "广东省广州市",
"86180915", "陕西省安康市",
"861315274", "山西省运城市",
"861833176", "河北省沧州市",
"86181493", "陕西省西安市",
"861351992", "新疆石河子市",
"861569391", "甘肃省兰州市",
"861893130", "河北省张家口市",
"861705311", "广东省深圳市",
"861760551", "安徽省合肥市",
"86170945", "黑龙江省哈尔滨市",
"861824954", "黑龙江省佳木斯市",
"861360394", "河南省周口市",
"861864944", "广西梧州市",
"861899497", "江苏省宿迁市",
"861832299", "江西省抚州市",
"861577982", "江西省景德镇市",
"861348798", "湖南省邵阳市",
"861454707", "浙江省温州市",
"861776857", "江苏省扬州市",
"861363436", "吉林省白城市",
"861453387", "内蒙古通辽市",
"861370691", "福建省南平市",
"861322634", "广东省惠州市",
"861868771", "云南省昆明市",
"861768909", "西藏拉萨市",
"861572787", "浙江省台州市",
"861532983", "贵州省安顺市",
"861471713", "甘肃省酒泉市",
"861459675", "新疆阿克苏地区",
"861390931", "甘肃省兰州市",
"861539726", "浙江省嘉兴市",
"86153757", "福建省泉州市",
"861807134", "湖北省恩施土家族苗族自治州",
"861856873", "河南省新乡市",
"861356861", "四川省南充市",
"861364152", "江苏省宿迁市",
"861533931", "甘肃省兰州市",
"861554620", "黑龙江省哈尔滨市",
"861859627", "山东省德州市",
"861329766", "湖北省黄石市",
"861525613", "安徽省淮北市",
"861882846", "四川省成都市",
"861586430", "山东省潍坊市",
"861557711", "广西崇左市",
"861812054", "湖北省仙桃市",
"86139596", "福建省漳州市",
"861306483", "江苏省盐城市",
"861558641", "湖北省襄樊市",
"86159147", "广东省汕头市",
"861375494", "山西省大同市",
"86177951", "宁夏银川市",
"861352366", "河南省南阳市",
"861308778", "广西河池市",
"861317766", "江西省抚州市",
"861812768", "广东省韶关市",
"86139377", "河南省南阳市",
"861844938", "新疆昌吉回族自治州",
"861550728", "湖北省十堰市",
"86182203", "陕西省渭南市",
"861560470", "内蒙古呼伦贝尔市",
"861459240", "四川省眉山市",
"86153657", "江苏省盐城市",
"861368416", "四川省宜宾市",
"861508313", "河南省新乡市",
"861473009", "河北省邢台市",
"861471466", "广东省惠州市",
"861771379", "四川省阿坝藏族羌族自治州",
"861801216", "江苏省连云港市",
"86130792", "辽宁省沈阳市",
"86185519", "江苏省常州市",
"861452277", "山西省临汾市",
"861524691", "黑龙江省伊春市",
"861567199", "湖北省鄂州市",
"861889149", "陕西省商洛市",
"861560629", "江苏省南通市",
"86159695", "云南省昆明市",
"861811286", "江苏省常州市",
"861535016", "江西省上饶市",
"861550511", "江苏省淮安市",
"861342658", "江西省九江市",
"861345598", "山东省菏泽市",
"861846497", "山东省日照市",
"861530585", "浙江省绍兴市",
"86901", "新疆塔城地区",
"861855410", "山东省烟台市",
"86181208", "福建省福州市",
"861593286", "江西省萍乡市",
"861334947", "黑龙江省大庆市",
"861830397", "河南省焦作市",
"861397349", "湖南省永州市",
"861847606", "广东省湛江市",
"861334665", "河南省安阳市",
"86180201", "江苏省南京市",
"861826114", "江苏省南京市",
"861518556", "贵州省黔东南苗族侗族自治州",
"861815439", "湖北省十堰市",
"861365563", "安徽省宣城市",
"861708328", "河北省沧州市",
"861343526", "广东省清远市",
"861569325", "甘肃省兰州市",
"861512135", "贵州省黔南布依族苗族自治州",
"861364976", "青海省玉树藏族自治州",
"86189849", "贵州省遵义市",
"861707177", "江西省鹰潭市",
"861340967", "湖北省黄冈市",
"86188756", "河北省廊坊市",
"861572761", "江西省吉安市",
"861779779", "河南省周口市",
"861879901", "新疆阿勒泰地区",
"861459052", "广东省深圳市",
"861340645", "山东省烟台市",
"861315870", "四川省达州市",
"861780070", "青海省海西蒙古族藏族自治州",
"861308259", "江苏省盐城市",
"861326797", "广东省珠海市",
"861392468", "广东省江门市",
"861880939", "甘肃省陇南市",
"861815246", "宁夏中卫市",
"861519958", "新疆石河子市",
"861333144", "吉林省通化市",
"861807477", "广西钦州市",
"861766030", "山东省菏泽市",
"861809063", "四川省成都市",
"861473059", "河北省邢台市",
"861533996", "山东省济南市",
"861362717", "湖北省荆州市",
"861505633", "安徽省宣城市",
"861336070", "广东省湛江市",
"861569049", "河北省邢台市",
"861887099", "江西省萍乡市",
"861559422", "陕西省榆林市",
"861598445", "四川省广元市",
"86135381", "广东省深圳市",
"861566553", "安徽省芜湖市",
"861869565", "福建省泉州市",
"861337869", "广东省广州市",
"861526543", "山东省滨州市",
"861371729", "广东省江门市",
"86158732", "湖南省湘潭市",
"861853223", "河北省保定市",
"861599875", "山东省德州市",
"861808248", "甘肃省平凉市",
"861817012", "江西省赣州市",
"861773078", "陕西省榆林市",
"861507821", "广西百色市",
"861530596", "福建省漳州市",
"86135595", "福建省泉州市",
"861770937", "甘肃省酒泉市",
"86150521", "江苏省无锡市",
"861593295", "江西省抚州市",
"861306602", "山东省济南市",
"861535341", "陕西省延安市",
"861818428", "贵州省六盘水市",
"861335879", "辽宁省抚顺市",
"86180065", "浙江省金华市",
"861818357", "云南省曲靖市",
"861361448", "吉林省松原市",
"861351944", "甘肃省兰州市",
"861321458", "黑龙江省伊春市",
"861390919", "陕西省铜川市",
"861392356", "广东省揭阳市",
"861360773", "广西桂林市",
"861860761", "广东省阳江市",
"861330784", "广西梧州市",
"861321327", "河南省安阳市",
"861518275", "四川省巴中市",
"861842911", "陕西省延安市",
"861360342", "河南省驻马店市",
"861864992", "福建省厦门市",
"861539781", "江西省九江市",
"861320352", "山西省大同市",
"861362904", "四川省泸州市",
"861340926", "河南省南阳市",
"861329860", "湖南省常德市",
"861812894", "广东省河源市",
"86182630", "山东省德州市",
"861584770", "内蒙古鄂尔多斯市",
"861363712", "安徽省池州市",
"861889777", "广西钦州市",
"861560318", "河北省衡水市",
"861538939", "陕西省汉中市",
"861882740", "湖北省武汉市",
"861551315", "山西省忻州市",
"861311502", "江苏省南京市",
"861867561", "广东省珠海市",
"861337584", "浙江省宁波市",
"861705167", "山西省太原市",
"861510888", "云南省丽江市",
"861300842", "陕西省西安市",
"86188557", "安徽省宿州市",
"86133383", "福建省漳州市",
"86183362", "河南省信阳市",
"861566638", "山东省东营市",
"861562835", "广东省东莞市",
"861479758", "青海省黄南藏族自治州",
"861500818", "四川省绵阳市",
"86189324", "湖南省长沙市",
"861512046", "甘肃省临夏回族自治州",
"861708941", "广东省肇庆市",
"861895476", "山东省菏泽市",
"861572243", "江苏省南通市",
"86151124", "广东省深圳市",
"861355984", "福建省南平市",
"861810614", "江苏省常州市",
"861365488", "内蒙古呼和浩特市",
"861881377", "广东省梅州市",
"861339817", "四川省成都市",
"861365532", "山东省青岛市",
"861308997", "黑龙江省绥化市",
"861303251", "江苏省常州市",
"861339534", "山东省德州市",
"86133075", "海南省海口市",
"861775904", "福建省福州市",
"861515254", "江苏省连云港市",
"861870881", "云南省临沧市",
"861375350", "山西省长治市",
"861800684", "浙江省宁波市",
"861537242", "浙江省杭州市",
"86135590", "福建省泉州市",
"86151267", "云南省文山壮族苗族自治州",
"861858176", "四川省资阳市",
"861392306", "广东省江门市",
"861571673", "河南省洛阳市",
"861528362", "四川省甘孜藏族自治州",
"86186853", "贵州省安顺市",
"861874273", "新疆哈密地区",
"861597622", "广东省惠州市",
"86150142", "广东省广州市",
"861772170", "江苏省常州市",
"861537731", "湖南省长沙市",
"861317727", "湖北省孝感市",
"861362954", "宁夏固原市",
"861459892", "广东省东莞市",
"861700549", "山东省青岛市",
"861352327", "河南省平顶山市",
"861320302", "湖南省岳阳市",
"861390641", "山东省济南市",
"861512181", "宁夏银川市",
"86130372", "江西省南昌市",
"861361524", "江苏省扬州市",
"861505508", "安徽省淮北市",
"861314852", "广东省中山市",
"861470452", "黑龙江省齐齐哈尔市",
"86186634", "山东省莱芜市",
"86182635", "山东省聊城市",
"861334401", "重庆市",
"861340018", "河北省邢台市",
"861555036", "山东省莱芜市",
"861534062", "山西省忻州市",
"8618200", "四川省成都市",
"861879447", "甘肃省临夏回族自治州",
"861530531", "山东省济南市",
"861782666", "江苏省苏州市",
"861453272", "山西省太原市",
"86152523", "江苏省淮安市",
"86139797", "江西省赣州市",
"861329727", "湖北省随州市",
"861311552", "黑龙江省黑河市",
"86186446", "上海市",
"861342533", "广东省汕头市",
"861479708", "青海省西宁市",
"861809032", "四川省内江市",
"86151328", "河北省衡水市",
"861843610", "河南省商丘市",
"861330238", "广东省广州市",
"861889967", "新疆巴音郭楞蒙古自治州",
"861333879", "江苏省常州市",
"861364727", "湖北省宜昌市",
"86159855", "贵州省黔东南苗族侗族自治州",
"861708385", "河南省安阳市",
"861308017", "河南省许昌市",
"861327842", "吉林省四平市",
"861367852", "贵州省遵义市",
"86182946", "甘肃省陇南市",
"861533341", "山西省太原市",
"861842036", "广东省阳江市",
"86150321", "河北省石家庄市",
"861890848", "湖南省长沙市",
"861818496", "西藏那曲地区",
"86155677", "吉林省长春市",
"861373300", "安徽省六安市",
"861339299", "广东省珠海市",
"861773954", "河南省漯河市",
"861326768", "广东省江门市",
"86181746", "湖南省永州市",
"861530528", "江苏省镇江市",
"861317824", "福建省莆田市",
"861803467", "甘肃省临夏回族自治州",
"861768885", "广东省广州市",
"861828481", "四川省乐山市",
"861319842", "四川省泸州市",
"861817634", "广西柳州市",
"861561599", "山东省临沂市",
"86158969", "河南省商丘市",
"86189524", "江苏省苏州市",
"861535985", "福建省泉州市",
"861893476", "广西来宾市",
"861555649", "安徽省合肥市",
"86180402", "辽宁省沈阳市",
"861370688", "浙江省温州市",
"86182765", "广西玉林市",
"86186871", "云南省昆明市",
"861896608", "浙江省绍兴市",
"861452682", "陕西省延安市",
"861822413", "四川省巴中市",
"86188357", "山西省临汾市",
"861537511", "安徽省芜湖市",
"861526580", "山东省菏泽市",
"861860971", "青海省西宁市",
"861760709", "江西省南昌市",
"861360963", "广东省云浮市",
"861571868", "贵州省六盘水市",
"86181965", "安徽省芜湖市",
"861347038", "辽宁省辽阳市",
"861830368", "河南省洛阳市",
"861846468", "山东省东营市",
"861365712", "湖北省孝感市",
"861537728", "湖北省随州市",
"861820082", "广东省河源市",
"861348781", "湖南省益阳市",
"861579400", "广东省广州市",
"86177398", "甘肃省兰州市",
"861334337", "河北省沧州市",
"861588406", "四川省甘孜藏族自治州",
"861361560", "安徽省合肥市",
"86134136", "广东省湛江市",
"861478510", "贵州省贵阳市",
"861311873", "云南省红河哈尼族彝族自治州",
"861346915", "湖南省常德市",
"861528943", "陕西省渭南市",
"86135390", "广东省东莞市",
"86137287", "广东省深圳市",
"86159681", "浙江省杭州市",
"861304360", "江苏省无锡市",
"86159850", "贵州省遵义市",
"861347989", "江西省九江市",
"861786887", "陕西省宝鸡市",
"861390099", "北京市",
"861566621", "山东省东营市",
"861315966", "吉林省吉林市",
"861829992", "新疆哈密地区",
"861331314", "河北省承德市",
"861810032", "河南省郑州市",
"861373350", "湖北省孝感市",
"861363488", "黑龙江省哈尔滨市",
"861502626", "新疆吐鲁番地区",
"861772712", "广东省佛山市",
"86139776", "广西百色市",
"861306440", "河南省安阳市",
"861511476", "内蒙古赤峰市",
"861339441", "吉林省吉林市",
"861892141", "江苏省南京市",
"861516530", "山东省菏泽市",
"861340149", "江苏省常州市",
"86153441", "内蒙古赤峰市",
"861808722", "云南省昭通市",
"861470640", "山东省济南市",
"861503662", "河南省新乡市",
"86182760", "广西玉林市",
"861330887", "云南省迪庆藏族自治州",
"861326004", "内蒙古呼和浩特市",
"861819684", "新疆喀什地区",
"861313776", "河南省平顶山市",
"861880349", "山西省朔州市",
"86130210", "北京市",
"861309527", "云南省曲靖市",
"861891204", "江苏省徐州市",
"861580863", "云南省昭通市",
"861350869", "湖北省孝感市",
"861896658", "陕西省延安市",
"861886996", "浙江省台州市",
"861768790", "江西省新余市",
"86152323", "河北省秦皇岛市",
"86147923", "安徽省合肥市",
"861539260", "山西省忻州市",
"861818431", "贵州省毕节地区",
"861894925", "安徽省阜阳市",
"86132608", "江苏省南京市",
"861768056", "湖南省常德市",
"86181960", "新疆吐鲁番地区",
"86132352", "江苏省扬州市",
"861302184", "河北省唐山市",
"861760759", "广东省湛江市",
"861501630", "广东省汕尾市",
"861354187", "四川省广安市",
"861374895", "河南省郑州市",
"861525708", "浙江省舟山市",
"86130572", "江苏省无锡市",
"861509237", "山东省临沂市",
"861550785", "广西玉林市",
"861362078", "吉林省长春市",
"861804230", "浙江省杭州市",
"86159468", "江西省上饶市",
"861562266", "广东省云浮市",
"861524049", "江苏省徐州市",
"861380358", "江西省赣州市",
"861769123", "陕西省西安市",
"861762546", "江苏省徐州市",
"861380427", "辽宁省盘锦市",
"861777704", "广西钦州市",
"861538025", "江苏省连云港市",
"861500908", "新疆阿克苏地区",
"861370336", "河北省保定市",
"861396649", "安徽省淮南市",
"861328578", "浙江省丽水市",
"861348735", "湖南省郴州市",
"86139396", "河南省驻马店市",
"861846306", "山东省潍坊市",
"861572280", "江苏省泰州市",
"861357784", "云南省楚雄彝族自治州",
"861812978", "广东省云浮市",
"861770347", "山西省临汾市",
"861535931", "福建省厦门市",
"861508140", "河北省邯郸市",
"861821865", "广东省深圳市",
"861362814", "四川省眉山市",
"86177778", "北京市",
"861365425", "辽宁省大连市",
"861450420", "辽宁省大连市",
"861875755", "浙江省杭州市",
"861309566", "浙江省绍兴市",
"861343789", "广东省湛江市",
"861362537", "山东省济宁市",
"861454200", "河南省郑州市",
"861822079", "陕西省汉中市",
"861314912", "陕西省榆林市",
"86135770", "云南省昆明市",
"861351334", "河北省秦皇岛市",
"861527269", "湖北省咸宁市",
"861350584", "浙江省宁波市",
"86185832", "四川省成都市",
"861876889", "河南省郑州市",
"861898772", "云南省玉溪市",
"861329976", "青海省西宁市",
"861338871", "云南省昆明市",
"86185319", "河北省邢台市",
"861374886", "河南省郑州市",
"861896533", "福建省三明市",
"861770504", "福建省莆田市",
"861532630", "吉林省长春市",
"861502945", "陕西省安康市",
"861538349", "山西省朔州市",
"86155443", "河南省信阳市",
"861768831", "广东省惠州市",
"861550796", "江西省吉安市",
"861317976", "江苏省扬州市",
"861329102", "江苏省徐州市",
"86135050", "福建省泉州市",
"861339957", "安徽省宿州市",
"861869423", "河北省石家庄市",
"861367092", "广东省佛山市",
"861314160", "湖南省湘西土家族苗族自治州",
"861371586", "广东省汕头市",
"861870266", "江西省吉安市",
"861889018", "湖南省邵阳市",
"861381452", "江苏省南京市",
"86139577", "浙江省温州市",
"861571794", "江西省抚州市",
"861310071", "湖北省武汉市",
"861810063", "江苏省南通市",
"861552023", "四川省雅安市",
"861887641", "福建省厦门市",
"861566872", "辽宁省盘锦市",
"861358060", "广东省肇庆市",
"861363563", "安徽省宣城市",
"861386156", "江苏省淮安市",
"861550731", "湖南省长沙市",
"861582914", "陕西省咸阳市",
"861500958", "宁夏银川市",
"861830456", "黑龙江省黑河市",
"861816944", "湖南省衡阳市",
"861774248", "陕西省渭南市",
"861514199", "辽宁省葫芦岛市",
"86797", "江西省赣州市",
"861347577", "山东省济宁市",
"861311697", "云南省红河哈尼族彝族自治州",
"861813439", "河北省邢台市",
"861303065", "安徽省亳州市",
"86135775", "云南省保山市",
"861820477", "内蒙古鄂尔多斯市",
"861708396", "河南省驻马店市",
"861853410", "山西省长治市",
"861875705", "浙江省温州市",
"861803426", "河北省廊坊市",
"861317152", "河北省唐山市",
"86189407", "辽宁省营口市",
"861318472", "河北省秦皇岛市",
"861591792", "广东省汕头市",
"861390859", "贵州省黔西南布依族苗族自治州",
"861452453", "黑龙江省牡丹江市",
"861453687", "陕西省宝鸡市",
"86145874", "广东省广州市",
"861370391", "河南省焦作市",
"861770554", "安徽省淮南市",
"86186693", "山东省威海市",
"861535996", "福建省南平市",
"861805498", "福建省龙岩市",
"861339907", "新疆博尔塔拉蒙古自治州",
"861329152", "浙江省嘉兴市",
"861359734", "广西南宁市",
"861572971", "四川省广安市",
"861705611", "浙江省杭州市",
"861340777", "广西河池市",
"861335144", "黑龙江省佳木斯市",
"861882783", "江西省宜春市",
"861360694", "福建省厦门市",
"861580832", "四川省内江市",
"861889926", "新疆和田地区",
"861813246", "河北省唐山市",
"861360489", "黑龙江省大庆市",
"861850379", "河南省洛阳市",
"861575944", "福建省福州市",
"861314426", "广东省汕头市",
"861802068", "福建省漳州市",
"861807425", "浙江省湖州市",
"861821960", "甘肃省临夏回族自治州",
"861332171", "广西南宁市",
"861899471", "江苏省泰州市",
"86157252", "山东省青岛市",
"861454524", "广西梧州市",
"861516705", "浙江省衢州市",
"861375196", "广东省梅州市",
"861512953", "陕西省咸阳市",
"861308569", "浙江省绍兴市",
"861535786", "安徽省阜阳市",
"861378398", "河南省三门峡市",
"861868797", "云南省丽江市",
"861514823", "内蒙古包头市",
"861581210", "云南省昆明市",
"861817245", "广西玉林市",
"861589617", "江苏省淮安市",
"861882993", "广东省惠州市",
"861304246", "辽宁省大连市",
"861370677", "浙江省温州市",
"861539346", "甘肃省酒泉市",
"861811363", "四川省眉山市",
"861325243", "浙江省宁波市",
"861804870", "四川省内江市",
"861559096", "黑龙江省鹤岗市",
"86139241", "广东省广州市",
"861880521", "江苏省徐州市",
"86183911", "陕西省延安市",
"86147987", "重庆市",
"861345019", "广东省肇庆市",
"8620", "广东省广州市",
"86184457", "黑龙江省哈尔滨市",
"861862431", "辽宁省沈阳市",
"861508951", "广东省汕尾市",
"861558738", "山东省烟台市",
"861304439", "吉林省白山市",
"86186392", "河南省鹤壁市",
"86151729", "湖北省恩施土家族苗族自治州",
"861536938", "河北省石家庄市",
"861502840", "河北省张家口市",
"861814065", "湖北省武汉市",
"861700695", "广东省东莞市",
"861563685", "黑龙江省鸡西市",
"861801570", "四川省自贡市",
"861370053", "山西省阳泉市",
"861557081", "湖南省娄底市",
"861318078", "吉林省松原市",
"8617801", "北京市",
"861518266", "四川省广安市",
"861310256", "河北省邢台市",
"861585679", "安徽省阜阳市",
"861533529", "江苏省苏州市",
"861354178", "四川省巴中市",
"861855661", "黑龙江省佳木斯市",
"861570485", "内蒙古兴安盟",
"86152416", "辽宁省锦州市",
"861700338", "河北省保定市",
"861319771", "广西南宁市",
"86185354", "山西省晋中市",
"861556067", "内蒙古呼伦贝尔市",
"861550986", "辽宁省大连市",
"861800973", "青海省黄南藏族自治州",
"861595942", "福建省莆田市",
"861760838", "四川省德阳市",
"861551350", "山西省忻州市",
"861313975", "新疆喀什地区",
"861893849", "广东省云浮市",
"861473574", "山西省朔州市",
"861806491", "四川省攀枝花市",
"861593363", "河北省廊坊市",
"861333239", "辽宁省葫芦岛市",
"861330878", "云南省楚雄彝族自治州",
"861520323", "河北省张家口市",
"861517574", "河北省保定市",
"861392190", "江苏省扬州市",
"861839490", "甘肃省武威市",
"861398995", "西藏昌都地区",
"861363477", "内蒙古鄂尔多斯市",
"861332654", "广东省清远市",
"861557146", "湖北省荆州市",
"86188720", "湖北省十堰市",
"861889412", "甘肃省定西市",
"861533843", "广东省佛山市",
"861355057", "四川省乐山市",
"86180278", "广东省肇庆市",
"861831917", "广东省茂名市",
"861878825", "云南省红河哈尼族彝族自治州",
"861859675", "福建省泉州市",
"86185731", "湖南省长沙市",
"86158363", "河南省安阳市",
"861805124", "江苏省苏州市",
"861500559", "安徽省黄山市",
"861510774", "广西梧州市",
"861304792", "江西省九江市",
"861887284", "湖北省咸宁市",
"861820563", "安徽省宣城市",
"861320571", "浙江省杭州市",
"86158674", "浙江省宁波市",
"861844719", "内蒙古兴安盟",
"86177799", "江西省萍乡市",
"861454448", "江西省景德镇市",
"861803912", "河南省焦作市",
"861321283", "黑龙江省牡丹江市",
"861347463", "陕西省汉中市",
"861847471", "湖南省怀化市",
"861598034", "福建省莆田市",
"861778927", "陕西省宝鸡市",
"861516080", "新疆塔城地区",
"861352375", "河南省平顶山市",
"861317775", "江西省赣州市",
"861363082", "河北省石家庄市",
"861862485", "河南省洛阳市",
"861370893", "山东省济南市",
"861561998", "陕西省商洛市",
"861324607", "广东省汕头市",
"861867201", "湖北省黄石市",
"861513520", "山西省大同市",
"861800512", "江苏省连云港市",
"861563631", "黑龙江省哈尔滨市",
"861323971", "新疆吐鲁番地区",
"861886786", "浙江省宁波市",
"861810582", "浙江省湖州市",
"861539011", "四川省巴中市",
"86130885", "内蒙古呼伦贝尔市",
"861810438", "吉林省松原市",
"861557035", "江西省南昌市",
"861584865", "内蒙古通辽市",
"861566741", "陕西省宝鸡市",
"861452734", "湖南省衡阳市",
"861316554", "河北省石家庄市",
"861472703", "浙江省宁波市",
"861329775", "广西玉林市",
"86133726", "重庆市",
"861502746", "河北省唐山市",
"861348550", "安徽省滁州市",
"861399588", "湖北省孝感市",
"861819499", "新疆和田地区",
"861550995", "新疆吐鲁番地区",
"86185718", "湖北省武汉市",
"861338296", "江苏省连云港市",
"86177379", "河南省洛阳市",
"861470720", "湖北省宜昌市",
"861357663", "江西省吉安市",
"86183733", "湖南省株洲市",
"86134006", "福建省厦门市",
"861362472", "内蒙古包头市",
"861379212", "山东省泰安市",
"861881325", "广东省梅州市",
"861817782", "广西百色市",
"86137740", "湖北省荆门市",
"86132653", "广东省广州市",
"861470974", "青海省海南藏族自治州",
"861347799", "湖北省十堰市",
"861310575", "浙江省绍兴市",
"86135439", "广东省揭阳市",
"861471475", "广东省茂名市",
"861829782", "安徽省池州市",
"861328587", "浙江省温州市",
"861303561", "四川省广元市",
"86183178", "河南省开封市",
"86152622", "江苏省扬州市",
"861353794", "广东省云浮市",
"861325761", "广东省汕尾市",
"861884023", "陕西省渭南市",
"861767908", "江西省南昌市",
"861867251", "湖北省黄冈市",
"861518227", "四川省乐山市",
"86131658", "浙江省温州市",
"861324657", "河北省石家庄市",
"86131302", "辽宁省沈阳市",
"861364647", "山东省东营市",
"86858", "贵州省六盘水市",
"861827241", "湖北省荆门市",
"861364965", "云南省曲靖市",
"86137966", "黑龙江省哈尔滨市",
"86130880", "四川省成都市",
"861368384", "河南省洛阳市",
"861809421", "江苏省南京市",
"861390738", "湖南省娄底市",
"861338373", "河南省新乡市",
"861889725", "青海省果洛藏族自治州",
"861589409", "新疆和田地区",
"861593332", "河北省保定市",
"861781782", "广东省广州市",
"86130651", "江西省南昌市",
"861596057", "福建省泉州市",
"861840320", "河北省邯郸市",
"861503909", "河南省郑州市",
"86147844", "广东省广州市",
"861882664", "广东省佛山市",
"861334676", "河南省信阳市",
"861318814", "辽宁省锦州市",
"861399799", "湖北省武汉市",
"861301171", "山东省济南市",
"861801163", "四川省泸州市",
"861553353", "河北省秦皇岛市",
"861819732", "青海省海东地区",
"861305076", "辽宁省辽阳市",
"861355897", "四川省遂宁市",
"861820488", "内蒙古赤峰市",
"86186772", "广西柳州市",
"86137745", "福建省福州市",
"86130168", "江苏省常州市",
"861820532", "山东省青岛市",
"86185913", "陕西省渭南市",
"861824061", "河南省安阳市",
"861385723", "浙江省舟山市",
"861869576", "福建省漳州市",
"861347432", "陕西省汉中市",
"861563696", "黑龙江省齐齐哈尔市",
"861870340", "山西省太原市",
"86131161", "天津市",
"861316347", "黑龙江省绥化市",
"861531840", "山东省济宁市",
"861372613", "广东省中山市",
"861347588", "山东省聊城市",
"86183574", "浙江省宁波市",
"861338742", "湖南省常德市",
"861323280", "广东省清远市",
"861559085", "黑龙江省哈尔滨市",
"861534540", "山东省济宁市",
"861537648", "山东省青岛市",
"861570431", "吉林省长春市",
"861839547", "陕西省宝鸡市",
"861356942", "河南省新乡市",
"861337612", "江苏省南通市",
"861314467", "黑龙江省鸡西市",
"861338231", "江苏省淮安市",
"861522494", "河南省驻马店市",
"861470867", "贵州省安顺市",
"861592665", "湖北省随州市",
"861370282", "广东省佛山市",
"861700199", "广东省深圳市",
"861780312", "河北省保定市",
"861539550", "安徽省滁州市",
"861880653", "浙江省杭州市",
"861309575", "浙江省绍兴市",
"86186808", "重庆市",
"861506551", "山东省威海市",
"86181472", "内蒙古包头市",
"861843461", "山西省晋城市",
"861315230", "陕西省咸阳市",
"86133900", "辽宁省大连市",
"861538482", "内蒙古兴安盟",
"861821876", "广东省广州市",
"861764049", "辽宁省营口市",
"861522546", "河南省开封市",
"861452288", "山西省吕梁市",
"861803852", "广东省河源市",
"861538538", "安徽省池州市",
"861592947", "陕西省咸阳市",
"861707629", "山东省济宁市",
"861871562", "安徽省铜陵市",
"861597231", "湖北省鄂州市",
"861868004", "广东省佛山市",
"861873530", "山西省阳泉市",
"861869061", "新疆阿勒泰地区",
"861398648", "湖北省孝感市",
"861871608", "河北省唐山市",
"861893601", "江苏省南京市",
"861597742", "广西桂林市",
"861570357", "山西省临汾市",
"861521461", "黑龙江省大庆市",
"861478393", "河南省濮阳市",
"861831857", "广东省广州市",
"861876254", "江苏省淮安市",
"861779597", "陕西省榆林市",
"861317647", "山东省东营市",
"861809582", "新疆喀什地区",
"861355794", "广西梧州市",
"861539936", "陕西省安康市",
"861814251", "四川省德阳市",
"861809438", "江苏省南通市",
"861390721", "湖北省荆州市",
"861308787", "贵州省遵义市",
"861571322", "河北省保定市",
"861323761", "江西省九江市",
"861330632", "山东省枣庄市",
"861562930", "湖北省襄樊市",
"861322670", "广东省佛山市",
"861318717", "湖南省邵阳市",
"861317965", "江苏省无锡市",
"861760672", "浙江省湖州市",
"861892716", "广东省云浮市",
"861590542", "山东省青岛市",
"861800499", "辽宁省辽阳市",
"861336312", "河北省保定市",
"861369657", "安徽省黄山市",
"861329647", "山东省东营市",
"861322429", "辽宁省葫芦岛市",
"861329965", "广西玉林市",
"86177579", "浙江省金华市",
"861853455", "山西省忻州市",
"861536348", "广东省惠州市",
"861454215", "河南省南阳市",
"86130673", "福建省福州市",
"861872749", "湖北省孝感市",
"861700948", "重庆市",
"861361042", "广东省惠州市",
"86139020", "天津市",
"861894864", "广东省东莞市",
"86158818", "四川省达州市",
"861528896", "山东省青岛市",
"861303076", "辽宁省盘锦市",
"861351429", "辽宁省葫芦岛市",
"861373185", "安徽省淮北市",
"861508811", "广东省江门市",
"861883089", "河北省邯郸市",
"86139442", "吉林省吉林市",
"861454173", "浙江省嘉兴市",
"861776566", "广东省茂名市",
"861505909", "福建省龙岩市",
"861511174", "青海省海南藏族自治州",
"86152786", "广西百色市",
"861579722", "湖北省恩施土家族苗族自治州",
"861881636", "山东省东营市",
"861328493", "黑龙江省鹤岗市",
"861589161", "陕西省延安市",
"861773472", "河南省许昌市",
"861817418", "广西桂林市",
"861859179", "陕西省西安市",
"861396595", "安徽省滁州市",
"861351670", "浙江省杭州市",
"861831807", "广东省揭阳市",
"861533795", "陕西省宝鸡市",
"86132671", "广东省深圳市",
"861807488", "广西玉林市",
"861868768", "云南省文山壮族苗族自治州",
"861814201", "浙江省杭州市",
"861770413", "辽宁省沈阳市",
"861570544", "山东省潍坊市",
"861882479", "广东省湛江市",
"861452514", "山东省烟台市",
"861886843", "浙江省杭州市",
"861810421", "辽宁省朝阳市",
"861364775", "广西玉林市",
"861366481", "内蒙古呼和浩特市",
"861452837", "四川省阿坝藏族羌族自治州",
"86133682", "重庆市",
"861312416", "辽宁省锦州市",
"8618523", "重庆市",
"86183663", "山东省潍坊市",
"861530146", "江苏省南通市",
"861882620", "广东省珠海市",
"861369607", "四川省眉山市",
"861772082", "福建省莆田市",
"861800732", "湖南省湘潭市",
"861470008", "福建省厦门市",
"861873906", "河南省洛阳市",
"86183374", "河南省许昌市",
"861551546", "河南省濮阳市",
"86159826", "四川省广安市",
"86184641", "山东省德州市",
"861459366", "贵州省黔东南苗族侗族自治州",
"861330994", "新疆昌吉回族自治州",
"861858669", "贵州省安顺市",
"861328769", "山东省潍坊市",
"86955", "宁夏中卫市",
"861459458", "陕西省汉中市",
"861459327", "四川省泸州市",
"861786663", "山东省青岛市",
"861825932", "福建省南平市",
"86135026", "广东省揭阳市",
"861874833", "内蒙古阿拉善盟",
"861533786", "海南省海口市",
"861894589", "黑龙江省伊春市",
"861346536", "山东省潍坊市",
"86138648", "山东省青岛市",
"861537995", "甘肃省甘南藏族自治州",
"861458430", "河南省许昌市",
"86183018", "上海市",
"861534306", "湖南省常德市",
"86753", "广东省梅州市",
"86185488", "北京市",
"861373196", "安徽省六安市",
"861889788", "广西钦州市",
"861528885", "山东省济南市",
"86156867", "陕西省榆林市",
"86132893", "陕西省西安市",
"861707318", "河北省石家庄市",
"861573944", "新疆乌鲁木齐市",
"861871533", "安徽省芜湖市",
"86181253", "广东省中山市",
"86183794", "江西省抚州市",
"861822554", "安徽省淮南市",
"86185661", "广东省东莞市",
"861843605", "河南省安阳市",
"861345148", "河北省石家庄市",
"861821924", "广东省深圳市",
"861862544", "河南省鹤壁市",
"861592401", "浙江省舟山市",
"86147529", "江苏省盐城市",
"861568181", "四川省甘孜藏族自治州",
"861372279", "河北省石家庄市",
"861454560", "四川省自贡市",
"861700321", "河北省邯郸市",
"861346950", "宁夏银川市",
"86186592", "福建省厦门市",
"861396303", "山东省日照市",
"86152587", "浙江省温州市",
"861558284", "山西省晋城市",
"861398015", "四川省广元市",
"861453832", "四川省德阳市",
"861368922", "陕西省榆林市",
"861331486", "内蒙古包头市",
"861373315", "河南省郑州市",
"861773087", "河南省许昌市",
"861302495", "福建省南平市",
"861776527", "广东省广州市",
"86158831", "四川省宜宾市",
"86156916", "陕西省汉中市",
"86185033", "河北省秦皇岛市",
"861347525", "山东省东营市",
"861879140", "陕西省西安市",
"861534583", "浙江省嘉兴市",
"861520709", "江西省萍乡市",
"861564574", "黑龙江省黑河市",
"861893465", "湖北省黄冈市",
"861348346", "河北省沧州市",
"861760821", "四川省资阳市",
"861820425", "辽宁省葫芦岛市",
"861888146", "四川省成都市",
"861370745", "湖南省怀化市",
"861323243", "广东省江门市",
"86155820", "山西省忻州市",
"861558518", "贵州省黔南布依族苗族自治州",
"861399525", "宁夏吴忠市",
"861768943", "福建省福州市",
"861880538", "山东省泰安市",
"861835137", "江苏省宿迁市",
"861335239", "辽宁省葫芦岛市",
"861519559", "江苏省扬州市",
"861459408", "云南省昭通市",
"861894798", "内蒙古乌海市",
"861583420", "山西省晋城市",
"861870556", "安徽省安庆市",
"861516043", "福建省泉州市",
"86891", "西藏拉萨市",
"861315975", "吉林省长春市",
"861527559", "山东省临沂市",
"86156429", "辽宁省葫芦岛市",
"861882013", "广东省广州市",
"861889599", "云南省丽江市",
"861534356", "山西省晋城市",
"861509920", "新疆伊犁哈萨克自治州",
"861862428", "辽宁省大连市",
"861576792", "广东省惠州市",
"861353673", "广东省梅州市",
"861535529", "浙江省舟山市",
"861366435", "吉林省通化市",
"861510964", "宁夏固原市",
"861800763", "广东省清远市",
"861380475", "内蒙古通辽市",
"861324592", "内蒙古巴彦淖尔市",
"861300771", "青海省西宁市",
"861888081", "四川省绵阳市",
"861472618", "四川省成都市",
"861592451", "内蒙古呼和浩特市",
"861819973", "新疆乌鲁木齐市",
"861319961", "黑龙江省鹤岗市",
"861477889", "广东省深圳市",
"861890690", "福建省福州市",
"861550648", "山东省烟台市",
"861367426", "辽宁省大连市",
"861346900", "湖南省株洲市",
"861372064", "陕西省榆林市",
"861335446", "山东省聊城市",
"861538077", "江苏省南京市",
"861350612", "江苏省常州市",
"861346591", "山东省济南市",
"861513889", "河南省安阳市",
"861870930", "甘肃省临夏回族自治州",
"861316937", "广东省云浮市",
"86133327", "广东省梅州市",
"861585464", "山东省威海市",
"861567823", "广西来宾市",
"86182258", "安徽省合肥市",
"86158563", "安徽省宣城市",
"861563319", "河北省邢台市",
"861373131", "河北省张家口市",
"861560749", "湖南省长沙市",
"861561645", "湖南省长沙市",
"86155825", "山西省长治市",
"86133989", "海南省海口市",
"861341188", "广东省深圳市",
"861365477", "内蒙古鄂尔多斯市",
"861313765", "河南省周口市",
"861866578", "广东省湛江市",
"861528056", "福建省三明市",
"861808394", "新疆石河子市",
"861881388", "广东省深圳市",
"861898659", "湖北省黄石市",
"861356332", "山东省日照市",
"861555595", "安徽省阜阳市",
"861877090", "江西省新余市",
"861321892", "江苏省宿迁市",
"861363203", "广东省潮州市",
"861520759", "广东省湛江市",
"861318423", "浙江省杭州市",
"861537921", "甘肃省平凉市",
"861553538", "山西省太原市",
"861332547", "陕西省西安市",
"861370377", "河南省南阳市",
"861821453", "云南省临沧市",
"861566549", "安徽省宿州市",
"861372183", "河南省南阳市",
"861860778", "广西河池市",
"861568167", "四川省巴中市",
"861529043", "河南省郑州市",
"86130111", "北京市",
"861399950", "新疆克拉玛依市",
"861367435", "吉林省通化市",
"861475755", "浙江省绍兴市",
"861343856", "四川省达州市",
"861565941", "福建省福州市",
"86132509", "浙江省宁波市",
"861769530", "宁夏吴忠市",
"861828092", "四川省内江市",
"861362576", "浙江省台州市",
"861557808", "广西崇左市",
"861518826", "河南省信阳市",
"861340791", "江西省南昌市",
"861572997", "新疆喀什地区",
"861532793", "湖北省襄樊市",
"861339570", "浙江省衢州市",
"861306571", "浙江省杭州市",
"86159027", "湖北省武汉市",
"861509555", "甘肃省庆阳市",
"861857262", "湖北省荆州市",
"861826973", "安徽省安庆市",
"861570592", "福建省厦门市",
"86138943", "吉林省延边朝鲜族自治州",
"861325569", "山东省济南市",
"861329937", "甘肃省酒泉市",
"861867578", "广东省惠州市",
"86133238", "河南省郑州市",
"861785897", "浙江省金华市",
"861399536", "宁夏石嘴山市",
"861477815", "广东省阳江市",
"861530918", "陕西省商洛市",
"861838455", "四川省广元市",
"861800416", "辽宁省锦州市",
"861476889", "山东省滨州市",
"861820491", "内蒙古鄂尔多斯市",
"861810486", "内蒙古呼和浩特市",
"861397353", "湖南省郴州市",
"86187266", "安徽省滁州市",
"861513815", "河南省三门峡市",
"861347900", "江西省新余市",
"861332304", "河北省石家庄市",
"861351782", "广西柳州市",
"861317937", "江苏省泰州市",
"861872434", "黑龙江省黑河市",
"861852403", "辽宁省辽阳市",
"861302421", "浙江省嘉兴市",
"861860209", "广东省东莞市",
"861898723", "云南省大理白族自治州",
"861593663", "河南省漯河市",
"861760780", "广西南宁市",
"861889153", "陕西省渭南市",
"861569003", "河北省邯郸市",
"861770727", "湖北省武汉市",
"861399591", "湖北省黄冈市",
"861453410", "辽宁省大连市",
"861399900", "新疆巴音郭楞蒙古自治州",
"861525901", "福建省龙岩市",
"861475705", "浙江省嘉兴市",
"861527193", "湖北省武汉市",
"861787663", "广东省揭阳市",
"861561981", "陕西省汉中市",
"86182479", "内蒙古锡林郭勒盟",
"861383417", "山西省临汾市",
"861820436", "吉林省白城市",
"861519193", "陕西省渭南市",
"861347536", "山东省潍坊市",
"861865483", "山东省枣庄市",
"861894515", "黑龙江省鸡西市",
"86138748", "湖南省长沙市",
"861700638", "山东省青岛市",
"861777527", "安徽省芜湖市",
"861388651", "湖北省咸宁市",
"861355742", "广西柳州市",
"861478774", "云南省文山壮族苗族自治州",
"861822775", "四川省自贡市",
"861346525", "山东省东营市",
"86132113", "广西南宁市",
"861892432", "广东省广州市",
"861369485", "江西省上饶市",
"861538729", "湖北省随州市",
"861555521", "安徽省宣城市",
"86183694", "山东省临沂市",
"861769906", "新疆阿勒泰地区",
"86185761", "广东省中山市",
"861838405", "四川省南充市",
"861348039", "广东省汕尾市",
"861340736", "湖南省常德市",
"861360157", "江苏省苏州市",
"861860259", "江苏省常州市",
"861390786", "广西南宁市",
"861452865", "青海省果洛藏族自治州",
"861332354", "宁夏固原市",
"861301490", "广西南宁市",
"86136865", "广东省佛山市",
"861816418", "湖北省荆州市",
"861550089", "宁夏银川市",
"861309704", "江西省抚州市",
"86132864", "广东省汕头市",
"861380083", "四川省泸州市",
"861808773", "云南省普洱市",
"861388465", "山东省烟台市",
"861323787", "广西来宾市",
"861308761", "陕西省渭南市",
"861359960", "福建省龙岩市",
"861857233", "湖北省恩施土家族苗族自治州",
"861705813", "广东省深圳市",
"861587137", "湖北省武汉市",
"861815624", "安徽省宿州市",
"861863440", "山西省太原市",
"861536986", "河北省衡水市",
"861315834", "贵州省黔南布依族苗族自治州",
"861305587", "福建省厦门市",
"861780034", "河北省唐山市",
"861839654", "福建省福州市",
"861310857", "云南省大理白族自治州",
"86187728", "湖北省十堰市",
"861320258", "广东省揭阳市",
"86131971", "湖北省襄樊市",
"86150445", "吉林省通化市",
"861356878", "四川省阿坝藏族羌族自治州",
"86152686", "浙江省金华市",
"861700553", "安徽省芜湖市",
"861865652", "安徽省马鞍山市",
"861324307", "河南省洛阳市",
"861576744", "广东省深圳市",
"861533284", "内蒙古鄂尔多斯市",
"861364554", "安徽省淮南市",
"86132051", "江苏省苏州市",
"861514741", "内蒙古乌海市",
"861335211", "辽宁省鞍山市",
"86130534", "山东省德州市",
"861843487", "山西省运城市",
"861324544", "山东省日照市",
"861390795", "江西省宜春市",
"861343750", "广东省汕尾市",
"86135469", "广东省东莞市",
"861332490", "云南省曲靖市",
"861559148", "陕西省汉中市",
"861311822", "四川省遂宁市",
"861314522", "江苏省徐州市",
"86136584", "重庆市",
"86153320", "天津市",
"861394983", "河南省许昌市",
"861774694", "河南省三门峡市",
"861813660", "江苏省扬州市",
"861869087", "新疆昌吉回族自治州",
"861887843", "广西桂林市",
"861770766", "广东省云浮市",
"861569893", "辽宁省抚顺市",
"861321844", "江苏省南通市",
"861879020", "河南省焦作市",
"861857371", "湖南省益阳市",
"86137176", "北京市",
"861521487", "新疆伊犁哈萨克自治州",
"861880729", "湖北省孝感市",
"861881625", "江苏省泰州市",
"861361854", "贵州省黔南布依族苗族自治州",
"86183763", "广西桂林市",
"861500701", "江西省鹰潭市",
"861572778", "江西省赣州市",
"861333542", "陕西省咸阳市",
"861369431", "吉林省长春市",
"861309754", "山西省大同市",
"861586474", "山东省青岛市",
"86183968", "山东省济南市",
"861787632", "广东省深圳市",
"86136860", "广东省东莞市",
"86151044", "吉林省长春市",
"861840479", "内蒙古锡林郭勒盟",
"861539925", "陕西省咸阳市",
"861366467", "黑龙江省鸡西市",
"861894260", "河北省邯郸市",
"861327579", "安徽省合肥市",
"861334376", "河南省信阳市",
"86137936", "山东省潍坊市",
"861775205", "甘肃省平凉市",
"861889516", "宁夏固原市",
"861310807", "四川省资阳市",
"861840620", "辽宁省本溪市",
"861301547", "山西省太原市",
"861340830", "四川省泸州市",
"861338673", "辽宁省葫芦岛市",
"86150022", "天津市",
"861875899", "浙江省衢州市",
"861595014", "江苏省无锡市",
"861396521", "安徽省铜陵市",
"861324428", "吉林省松原市",
"861897202", "湖北省宜昌市",
"861390880", "云南省昆明市",
"86133211", "北京市",
"861874748", "内蒙古乌兰察布市",
"86150440", "吉林省长春市",
"861319579", "青海省西宁市",
"861364347", "山西省太原市",
"861860997", "新疆阿克苏地区",
"861768633", "山东省日照市",
"861582524", "云南省红河哈尼族彝族自治州",
"861325884", "吉林省长春市",
"861337312", "河北省保定市",
"86135827", "河北省沧州市",
"86187923", "陕西省渭南市",
"861520010", "河北省邯郸市",
"861760886", "云南省怒江傈僳族自治州",
"861525447", "山东省淄博市",
"861320779", "广西北海市",
"861321675", "浙江省绍兴市",
"861454289", "辽宁省葫芦岛市",
"861313737", "河南省信阳市",
"861810495", "辽宁省丹东市",
"861537348", "河北省唐山市",
"861343700", "江西省南昌市",
"861559999", "新疆伊犁哈萨克自治州",
"861331421", "辽宁省朝阳市",
"861301304", "安徽省池州市",
"86130773", "湖南省长沙市",
"86132580", "山东省济宁市",
"861589187", "云南省曲靖市",
"861372313", "河南省信阳市",
"861338057", "广东省揭阳市",
"861782283", "贵州省黔东南苗族侗族自治州",
"86131131", "广东省东莞市",
"861870640", "山东省济南市",
"861700386", "河南省周口市",
"861811994", "安徽省马鞍山市",
"861550938", "甘肃省天水市",
"861500751", "广东省韶关市",
"861394330", "吉林省松原市",
"861568126", "四川省巴中市",
"861560434", "吉林省四平市",
"861580455", "黑龙江省绥化市",
"861392471", "广东省珠海市",
"861362255", "广东省潮州市",
"861844728", "内蒙古赤峰市",
"861322245", "江苏省盐城市",
"861841811", "甘肃省陇南市",
"86130138", "江苏省苏州市",
"861476564", "湖北省武汉市",
"861823642", "河南省郑州市",
"861361707", "江西省赣州市",
"861331438", "吉林省延边朝鲜族自治州",
"861871308", "河北省沧州市",
"861763313", "河北省张家口市",
"861893301", "广东省佛山市",
"861760743", "湖南省湘西土家族苗族自治州",
"861510393", "甘肃省张掖市",
"861885015", "福建省厦门市",
"86183289", "四川省凉山彝族自治州",
"861761478", "内蒙古巴彦淖尔市",
"861598312", "四川省宜宾市",
"861550921", "陕西省榆林市",
"861453223", "浙江省绍兴市",
"861303587", "广东省阳江市",
"861707329", "河北省石家庄市",
"861328561", "安徽省淮北市",
"86137197", "广东省韶关市",
"861813624", "江苏省扬州市",
"861386690", "安徽省滁州市",
"861329504", "河南省许昌市",
"861595994", "福建省南平市",
"861826241", "江苏省南通市",
"861770976", "青海省玉树藏族自治州",
"861395146", "江苏省徐州市",
"861313517", "湖南省益阳市",
"861880353", "山西省阳泉市",
"861837420", "湖南省益阳市",
"861458952", "广东省中山市",
"861373048", "河北省邢台市",
"861554108", "辽宁省葫芦岛市",
"861325787", "广西玉林市",
"86130751", "广东省梅州市",
"861894781", "内蒙古巴彦淖尔市",
"861889736", "青海省果洛藏族自治州",
"861559019", "吉林省四平市",
"861536648", "江苏省盐城市",
"86180100", "北京市",
"861359770", "湖北省黄石市",
"861532845", "四川省宜宾市",
"861308971", "黑龙江省哈尔滨市",
"861814037", "四川省绵阳市",
"861357942", "新疆乌鲁木齐市",
"861890454", "黑龙江省佳木斯市",
"861520990", "新疆克拉玛依市",
"861310704", "湖南省衡阳市",
"86186672", "浙江省湖州市",
"861322370", "河南省商丘市",
"861396538", "安徽省马鞍山市",
"861568949", "山东省威海市",
"86130071", "湖北省武汉市",
"86177992", "新疆乌鲁木齐市",
"861324431", "吉林省长春市",
"861569282", "四川省南充市",
"861304744", "山东省东营市",
"861891955", "四川省巴中市",
"861760372", "河南省安阳市",
"861888098", "四川省达州市",
"861528959", "广西玉林市",
"861801084", "安徽省宣城市",
"861707045", "浙江省金华市",
"861346432", "辽宁省锦州市",
"861511351", "广东省汕尾市",
"861874222", "辽宁省鞍山市",
"861597673", "广东省河源市",
"861317347", "山东省枣庄市",
"861535284", "内蒙古呼和浩特市",
"861338868", "浙江省绍兴市",
"861333211", "辽宁省鞍山市",
"861330332", "河北省保定市",
"861533738", "湖北省黄石市",
"861309857", "贵州省毕节地区",
"86131078", "福建省泉州市",
"861809495", "新疆阿克苏地区",
"861570607", "陕西省渭南市",
"861567741", "广西梧州市",
"861889791", "江西省南昌市",
"861530858", "贵州省六盘水市",
"861873899", "河南省开封市",
"861321747", "湖南省怀化市",
"86183854", "贵州省安顺市",
"861317554", "浙江省金华市",
"861575992", "福建省莆田市",
"861477955", "江西省宜春市",
"861824087", "陕西省宝鸡市",
"86133626", "浙江省台州市",
"861345031", "广东省韶关市",
"861320969", "宁夏银川市",
"861770152", "江苏省无锡市",
"861881336", "广东省茂名市",
"861372140", "河南省郑州市",
"861565115", "江苏省泰州市",
"861341136", "广东省珠海市",
"861351370", "河南省商丘市",
"861558529", "贵州省贵阳市",
"861861480", "内蒙古呼伦贝尔市",
"86159882", "浙江省绍兴市",
"861329554", "安徽省淮南市",
"861316775", "安徽省宣城市",
"861324496", "广东省东莞市",
"861862419", "辽宁省辽阳市",
"861358239", "河北省保定市",
"861369544", "山东省烟台市",
"861335542", "山东省青岛市",
"861555653", "安徽省合肥市",
"861785868", "浙江省台州市",
"861507010", "江西省鹰潭市",
"861476520", "河北省石家庄市",
"861314481", "广东省深圳市",
"861470881", "云南省西双版纳傣族自治州",
"861880303", "河北省张家口市",
"861556035", "内蒙古赤峰市",
"86180105", "四川省成都市",
"861576847", "广东省深圳市",
"861531244", "江苏省连云港市",
"861557026", "江西省宜春市",
"861518008", "江西省鹰潭市",
"861459666", "新疆昌吉回族自治州",
"861588371", "四川省达州市",
"86152722", "湖北省恩施土家族苗族自治州",
"861310754", "青海省海西蒙古族藏族自治州",
"861894224", "江西省南昌市",
"861520551", "安徽省合肥市",
"861558843", "山东省威海市",
"86132380", "辽宁省大连市",
"861305493", "山东省临沂市",
"861882320", "广东省深圳市",
"861879708", "青海省西宁市",
"86150944", "河北省邢台市",
"861560541", "山东省济南市",
"861572968", "四川省乐山市",
"861776433", "安徽省黄山市",
"861805044", "福建省福州市",
"861782892", "四川省巴中市",
"861356663", "浙江省宁波市",
"861528909", "西藏拉萨市",
"861771127", "四川省乐山市",
"86151922", "山东省烟台市",
"86158394", "河南省周口市",
"861300579", "广东省珠海市",
"8618526", "天津市",
"86183633", "山东省日照市",
"861378945", "内蒙古通辽市",
"861840664", "广东省茂名市",
"861880586", "浙江省台州市",
"861870452", "黑龙江省齐齐哈尔市",
"861532674", "内蒙古兴安盟",
"861360722", "湖北省武汉市",
"861563457", "山东省潍坊市",
"861511301", "广东省佛山市",
"861346799", "湖南省湘西土家族苗族自治州",
"861324485", "广东省深圳市",
"861889830", "广东省汕头市",
"86137016", "上海市",
"861584837", "内蒙古呼和浩特市",
"86312", "河北省保定市",
"861359876", "河南省开封市",
"861862607", "江苏省无锡市",
"861807491", "广西南宁市",
"861569745", "湖南省怀化市",
"861708748", "湖南省邵阳市",
"861841951", "甘肃省兰州市",
"861771166", "湖南省常德市",
"861831206", "广东省广州市",
"861782002", "广东省中山市",
"861326771", "广东省汕尾市",
"861859002", "陕西省宝鸡市",
"861584514", "黑龙江省哈尔滨市",
"861479951", "新疆阿克苏地区",
"861303979", "黑龙江省七台河市",
"861389479", "吉林省长春市",
"861506759", "浙江省金华市",
"861539988", "湖南省娄底市",
"861570419", "辽宁省辽阳市",
"861809486", "新疆吐鲁番地区",
"861538303", "河北省张家口市",
"861842718", "湖北省恩施土家族苗族自治州",
"861537089", "江苏省无锡市",
"86150887", "浙江省杭州市",
"861452449", "黑龙江省佳木斯市",
"861390843", "湖南省株洲市",
"861459627", "甘肃省张掖市",
"861838117", "四川省眉山市",
"861581537", "广东省惠州市",
"861880595", "福建省泉州市",
"86186979", "广西南宁市",
"861571871", "云南省昆明市",
"861850464", "黑龙江省七台河市",
"861860968", "安徽省亳州市",
"861830371", "河南省郑州市",
"861872541", "云南省玉溪市",
"861501674", "广东省深圳市",
"861330363", "黑龙江省牡丹江市",
"861894735", "内蒙古通辽市",
"86158861", "吉林省白城市",
"861512424", "辽宁省营口市",
"861846471", "山东省济宁市",
"861390529", "江苏省镇江市",
"861323569", "湖北省襄樊市",
"86188620", "江苏省盐城市",
"86183205", "广东省揭阳市",
"861396603", "安徽省芜湖市",
"861770824", "广东省潮州市",
"861322418", "辽宁省阜新市",
"861510555", "安徽省马鞍山市",
"861338794", "江西省抚州市",
"861522442", "山东省青岛市",
"861840993", "新疆石河子市",
"86185631", "山东省威海市",
"861524003", "安徽省合肥市",
"861538586", "安徽省芜湖市",
"861452236", "浙江省嘉兴市",
"861380252", "广东省广州市",
"861871466", "黑龙江省鹤岗市",
"861859240", "陕西省榆林市",
"861599298", "广东省韶关市",
"861808932", "甘肃省定西市",
"861366498", "广东省阳江市",
"861583379", "河北省沧州市",
"861863483", "山西省运城市",
"86134807", "广东省深圳市",
"86131314", "河北省承德市",
"86180459", "黑龙江省大庆市",
"861822647", "安徽省安庆市",
"861479901", "新疆石河子市",
"861529705", "青海省西宁市",
"861351418", "辽宁省阜新市",
"861888808", "江苏省泰州市",
"861361914", "陕西省商洛市",
"861816245", "湖北省黄冈市",
"861534656", "河南省郑州市",
"861841901", "甘肃省天水市",
"861817670", "广西柳州市",
"861814578", "广东省佛山市",
"861806425", "湖北省恩施土家族苗族自治州",
"861538353", "山西省阳泉市",
"861360415", "辽宁省丹东市",
"861302438", "湖南省邵阳市",
"861523901", "河南省焦作市",
"861595663", "安徽省池州市",
"86180189", "辽宁省大连市",
"861364937", "甘肃省酒泉市",
"861828912", "西藏日喀则地区",
"861452291", "山西省太原市",
"861817429", "湖南省常德市",
"861804069", "湖北省武汉市",
"861310917", "陕西省宝鸡市",
"861362061", "山西省太原市",
"861808694", "四川省攀枝花市",
"861881688", "广东省深圳市",
"86151629", "江苏省镇江市",
"861537938", "甘肃省天水市",
"861556081", "内蒙古呼和浩特市",
"86158533", "山东省淄博市",
"861398921", "四川省宜宾市",
"861539039", "四川省凉山彝族自治州",
"861314435", "吉林省通化市",
"861300987", "黑龙江省哈尔滨市",
"861350312", "河北省保定市",
"861396653", "安徽省亳州市",
"86183200", "广东省广州市",
"861802575", "广东省汕尾市",
"861394940", "河南省开封市",
"861550348", "山西省太原市",
"861890390", "河南省平顶山市",
"861507623", "河北省唐山市",
"861524053", "江苏省常州市",
"86132307", "河北省沧州市",
"86150889", "浙江省温州市",
"861813309", "安徽省阜阳市",
"861335705", "浙江省金华市",
"861362528", "江苏省苏州市",
"86189273", "广东省惠州市",
"861507866", "广西百色市",
"861321948", "四川省绵阳市",
"861361958", "宁夏银川市",
"861570853", "贵州省安顺市",
"861584508", "黑龙江省绥化市",
"861302040", "内蒙古呼伦贝尔市",
"861458185", "浙江省丽水市",
"861359896", "河南省许昌市",
"86170768", "广东省广州市",
"861599709", "青海省海东地区",
"861350955", "福建省宁德市",
"861362711", "湖北省武汉市",
"861332125", "甘肃省金昌市",
"861380438", "吉林省松原市",
"861834055", "辽宁省朝阳市",
"861860726", "湖北省恩施土家族苗族自治州",
"861326791", "广东省惠州市",
"861370456", "黑龙江省黑河市",
"861303999", "黑龙江省哈尔滨市",
"861577110", "湖北省襄樊市",
"861808151", "四川省达州市",
"86156312", "河北省保定市",
"861805655", "安徽省马鞍山市",
"861807471", "广西南宁市",
"861584662", "黑龙江省哈尔滨市",
"861368783", "广西桂林市",
"861338774", "广西贺州市",
"861532963", "贵州省安顺市",
"861839703", "青海省黄南藏族自治州",
"861879907", "新疆石河子市",
"86187115", "湖南省郴州市",
"861356720", "浙江省绍兴市",
"861812153", "江苏省无锡市",
"861708451", "黑龙江省哈尔滨市",
"861366478", "内蒙古呼和浩特市",
"861381332", "江苏省淮安市",
"861875144", "江苏省盐城市",
"861325039", "广东省茂名市",
"861840973", "青海省海东地区",
"861707171", "江西省吉安市",
"861340961", "湖北省荆门市",
"861824492", "广东省湛江市",
"861880575", "浙江省绍兴市",
"861779095", "辽宁省葫芦岛市",
"861309653", "山西省晋中市",
"861868345", "四川省凉山彝族自治州",
"861846491", "山东省临沂市",
"861830391", "河南省焦作市",
"861315938", "福建省三明市",
"861588688", "新疆喀什地区",
"861334941", "黑龙江省哈尔滨市",
"861853840", "河南省郑州市",
"86155435", "吉林省长春市",
"861315089", "内蒙古鄂尔多斯市",
"861389732", "青海省海东地区",
"861877445", "湖南省娄底市",
"861327725", "湖北省宜昌市",
"861813359", "河北省张家口市",
"861505924", "福建省漳州市",
"861550517", "江苏省徐州市",
"861334619", "浙江省杭州市",
"861811898", "江苏省镇江市",
"861857946", "广西南宁市",
"861831303", "云南省大理白族自治州",
"861550834", "四川省凉山彝族自治州",
"861351404", "福建省莆田市",
"861888814", "江苏省苏州市",
"861321199", "云南省普洱市",
"861700002", "北京市",
"861452271", "山西省太原市",
"861570803", "西藏山南地区",
"861361908", "四川省遂宁市",
"861524697", "黑龙江省黑河市",
"86150254", "重庆市",
"86180187", "广东省深圳市",
"861829690", "江西省萍乡市",
"861552160", "广东省广州市",
"861477182", "湖北省咸宁市",
"861333043", "云南省昆明市",
"861350905", "广东省韶关市",
"86134809", "广东省深圳市",
"861538206", "辽宁省朝阳市",
"861846436", "山东省滨州市",
"86188302", "河北省保定市",
"861303148", "河北省廊坊市",
"861588129", "四川省攀枝花市",
"861358123", "湖北省黄冈市",
"861571836", "广东省潮州市",
"861370406", "辽宁省锦州市",
"86188658", "山东省德州市",
"86155378", "河南省开封市",
"861558647", "湖北省荆州市",
"861323646", "江苏省淮安市",
"861802595", "广东省佛山市",
"86187110", "湖南省长沙市",
"861536765", "湖南省邵阳市",
"861879957", "新疆和田地区",
"861576643", "广东省深圳市",
"861890370", "河南省商丘市",
"861557717", "广西崇左市",
"86170963", "黑龙江省哈尔滨市",
"86182496", "黑龙江省大庆市",
"861330266", "广东省惠州市",
"86157749", "内蒙古赤峰市",
"861322454", "黑龙江省佳木斯市",
"861533937", "甘肃省酒泉市",
"86151627", "江苏省南通市",
"861309603", "四川省攀枝花市",
"86158421", "辽宁省朝阳市",
"861391213", "江苏省扬州市",
"861878871", "贵州省黔东南苗族侗族自治州",
"861859621", "山东省临沂市",
"861378863", "广西桂林市",
"861336889", "云南省玉溪市",
"861348569", "安徽省合肥市",
"86188161", "山东省淄博市",
"861337815", "四川省绵阳市",
"861352948", "云南省红河哈尼族彝族自治州",
"861362444", "吉林省四平市",
"861452333", "河南省南阳市",
"861895142", "江苏省南通市",
"861356867", "四川省甘孜藏族自治州",
"861552912", "陕西省榆林市",
"861470942", "甘肃省定西市",
"861572820", "广东省广州市",
"861317518", "浙江省宁波市",
"861327234", "湖南省衡阳市",
"861595974", "福建省南平市",
"861356826", "四川省绵阳市",
"86134168", "广东省东莞市",
"861335080", "四川省德阳市",
"861530814", "四川省攀枝花市",
"861387245", "湖北省宜昌市",
"861500560", "安徽省合肥市",
"861530537", "山东省济宁市",
"861879441", "甘肃省白银市",
"861329721", "湖北省黄石市",
"861517542", "河北省邯郸市",
"861881233", "云南省普洱市",
"861304680", "广东省汕头市",
"861770996", "新疆巴音郭楞蒙古自治州",
"861588336", "四川省乐山市",
"861390965", "安徽省蚌埠市",
"861850316", "河北省廊坊市",
"8614748", "广东省广州市",
"861364738", "湖南省娄底市",
"861568480", "新疆塔城地区",
"86189452", "黑龙江省齐齐哈尔市",
"861317721", "湖北省襄樊市",
"861529542", "江苏省无锡市",
"861352321", "河南省焦作市",
"861390647", "山东省东营市",
"861510373", "河南省新乡市",
"861569552", "安徽省蚌埠市",
"86147211", "上海市",
"861853746", "河南省平顶山市",
"861512187", "宁夏银川市",
"861586546", "山东省东营市",
"861760392", "河南省鹤壁市",
"861503382", "河北省保定市",
"861313348", "山西省吕梁市",
"861322390", "河南省商丘市",
"861537737", "湖南省益阳市",
"861567408", "湖南省郴州市",
"861821909", "广东省阳江市",
"86136924", "广东省湛江市",
"86132925", "河北省唐山市",
"861366310", "河北省邯郸市",
"861310718", "湖南省娄底市",
"861800320", "河北省邯郸市",
"861359790", "湖北省十堰市",
"861865989", "福建省三明市",
"861802586", "广东省佛山市",
"861552573", "山西省运城市",
"861700892", "山东省青岛市",
"861459549", "青海省海西蒙古族藏族自治州",
"861570093", "新疆哈密地区",
"861870887", "云南省迪庆藏族自治州",
"861520724", "湖北省咸宁市",
"861532932", "贵州省遵义市",
"861860820", "四川省南充市",
"861520970", "青海省海北藏族自治州",
"861504702", "内蒙古呼伦贝尔市",
"861360630", "山东省青岛市",
"861336564", "安徽省六安市",
"861328916", "陕西省汉中市",
"86159436", "吉林省白城市",
"861381363", "江苏省南通市",
"861339811", "四川省内江市",
"861881371", "广东省中山市",
"861308991", "黑龙江省大兴安岭地区",
"861303257", "江苏省扬州市",
"861345076", "广东省佛山市",
"861308500", "安徽省合肥市",
"861593008", "河北省承德市",
"861373430", "山东省日照市",
"86130006", "广东省广州市",
"861575106", "江苏省宿迁市",
"861867567", "广东省清远市",
"861862853", "陕西省渭南市",
"86155993", "贵州省毕节地区",
"861705161", "吉林省长春市",
"861334328", "河北省秦皇岛市",
"86145716", "上海市",
"861559769", "青海省西宁市",
"861852909", "广东省深圳市",
"861809475", "浙江省绍兴市",
"861889771", "广西钦州市",
"861569502", "宁夏石嘴山市",
"861842917", "陕西省宝鸡市",
"861826620", "山东省青岛市",
"861351390", "河南省濮阳市",
"861331040", "贵州省贵阳市",
"86134564", "浙江省台州市",
"861539787", "江西省赣州市",
"861880256", "广东省东莞市",
"861308936", "吉林省白城市",
"861834780", "内蒙古包头市",
"861572726", "湖北省恩施土家族苗族自治州",
"861300599", "广西北海市",
"861818351", "云南省昆明市",
"861378832", "广西柳州市",
"861860767", "广东省茂名市",
"861321321", "河南省郑州市",
"861840512", "江苏省常州市",
"861782872", "四川省成都市",
"861779086", "辽宁省沈阳市",
"861346779", "湖南省邵阳市",
"861327412", "辽宁省鞍山市",
"86132920", "河北省邯郸市",
"861508084", "湖南省娄底市",
"861821959", "广东省惠州市",
"861535347", "陕西省汉中市",
"861317284", "广东省揭阳市",
"861890418", "辽宁省阜新市",
"861770931", "甘肃省兰州市",
"861519448", "河南省信阳市",
"861309482", "浙江省宁波市",
"86151382", "河南省周口市",
"861507827", "广西柳州市",
"86138271", "广东省湛江市",
"861309538", "云南省文山壮族苗族自治州",
"861476034", "福建省三明市",
"861458315", "江西省宜春市",
"861308550", "安徽省滁州市",
"86187583", "浙江省宁波市",
"86150800", "福建省福州市",
"861571730", "湖南省岳阳市",
"861319412", "辽宁省鞍山市",
"86131720", "广东省广州市",
"86147626", "江苏省连云港市",
"861337955", "陕西省延安市",
"861354181", "四川省达州市",
"861454509", "湖南省衡阳市",
"861309718", "江西省景德镇市",
"86138253", "广东省河源市",
"861818437", "贵州省遵义市",
"861325925", "陕西省汉中市",
"861533554", "内蒙古鄂尔多斯市",
"861319788", "江西省抚州市",
"861800364", "黑龙江省哈尔滨市",
"861392436", "广东省东莞市",
"861321338", "河南省许昌市",
"861571510", "江苏省盐城市",
"861808793", "云南省西双版纳傣族自治州",
"86181648", "贵州省贵阳市",
"861761426", "辽宁省大连市",
"861572589", "山东省莱芜市",
"861520760", "广东省中山市",
"861898660", "湖北省黄石市",
"861840732", "湖南省长沙市",
"861336520", "江苏省泰州市",
"861592833", "四川省宜宾市",
"861573156", "四川省泸州市",
"861528682", "河南省郑州市",
"861890782", "广西来宾市",
"86136420", "天津市",
"861860864", "湖北省武汉市",
"861330881", "云南省西双版纳傣族自治州",
"861859503", "宁夏吴忠市",
"861309521", "云南省德宏傣族景颇族自治州",
"861333080", "四川省自贡市",
"861879534", "宁夏固原市",
"861822786", "四川省乐山市",
"861569873", "辽宁省阜新市",
"861453635", "江苏省无锡市",
"861318146", "山东省济宁市",
"861576680", "广东省汕头市",
"861500524", "江苏省宿迁市",
"861892147", "江苏省南通市",
"861339447", "吉林省长春市",
"861566627", "山东省日照市",
"861786881", "陕西省延安市",
"861332629", "山东省滨州市",
"861381942", "浙江省宁波市",
"86153980", "陕西省西安市",
"86187755", "广西玉林市",
"861320588", "浙江省丽水市",
"861458689", "湖南省岳阳市",
"861369476", "内蒙古赤峰市",
"861355505", "黑龙江省鸡西市",
"861372216", "内蒙古赤峰市",
"861320432", "吉林省吉林市",
"861521802", "广东省河源市",
"861509373", "河南省焦作市",
"861334331", "河北省石家庄市",
"861315348", "山东省德州市",
"861847532", "广东省汕尾市",
"861332470", "广西防城港市",
"861390775", "广西玉林市",
"861338693", "福建省龙岩市",
"861454559", "新疆阿克苏地区",
"861302083", "河北省邯郸市",
"861471582", "广东省惠州市",
"861582030", "广东省汕尾市",
"861346969", "宁夏银川市",
"861348787", "湖南省郴州市",
"861816454", "浙江省绍兴市",
"861870784", "广西梧州市",
"861573972", "新疆石河子市",
"861860977", "青海省海西蒙古族藏族自治州",
"861777649", "广西南宁市",
"861319599", "甘肃省金昌市",
"861899488", "江苏省扬州市",
"861844966", "新疆博尔塔拉蒙古自治州",
"861847170", "湖北省宜昌市",
"861533504", "江苏省宿迁市",
"861362585", "浙江省绍兴市",
"861840499", "山西省吕梁市",
"86139678", "浙江省宁波市",
"861458128", "安徽省六安市",
"861586494", "山东省聊城市",
"861537517", "安徽省宿州市",
"861572798", "浙江省衢州市",
"861310482", "广东省汕头市",
"861334396", "河南省驻马店市",
"861859553", "河南省周口市",
"861830946", "甘肃省兰州市",
"861537834", "四川省眉山市",
"861310538", "山东省泰安市",
"861327599", "福建省南平市",
"86153358", "湖北省恩施土家族苗族自治州",
"861453398", "内蒙古巴彦淖尔市",
"861375430", "浙江省衢州市",
"861311388", "河北省石家庄市",
"86137362", "浙江省台州市",
"86187383", "河南省新乡市",
"861805109", "江苏省苏州市",
"861771545", "江苏省常州市",
"861350815", "四川省乐山市",
"861329738", "湖南省娄底市",
"861303473", "内蒙古乌海市",
"861367610", "广东省汕头市",
"861803461", "甘肃省庆阳市",
"86151582", "浙江省绍兴市",
"861843852", "河南省安阳市",
"861806190", "江苏省无锡市",
"861301318", "安徽省安庆市",
"861368740", "广东省佛山市",
"861320799", "江西省萍乡市",
"861308011", "河南省濮阳市",
"861317738", "湖北省鄂州市",
"861521852", "广东省清远市",
"861352338", "河南省周口市",
"861517211", "湖北省黄石市",
"861886937", "云南省昆明市",
"861862572", "河南省周口市",
"861533347", "山西省临汾市",
"86153985", "云南省昆明市",
"861518632", "贵州省六盘水市",
"86135829", "河北省唐山市",
"861470332", "河北省保定市",
"861889961", "新疆石河子市",
"861826664", "山东省青岛市",
"861774845", "四川省绵阳市",
"861888904", "西藏林芝地区",
"86132706", "江苏省南通市",
"861570913", "陕西省渭南市",
"861361818", "四川省乐山市",
"861559979", "新疆昌吉回族自治州",
"861452943", "广东省韶关市",
"861364721", "湖北省武汉市",
"861810475", "内蒙古通辽市",
"86182643", "山东省淄博市",
"861773444", "河北省唐山市",
"861340771", "广西南宁市",
"861822880", "四川省广元市",
"861840763", "广东省清远市",
"861705617", "辽宁省沈阳市",
"861362596", "福建省泉州市",
"861869739", "河南省许昌市",
"861828072", "四川省自贡市",
"861892208", "广东省湛江市",
"861356764", "浙江省丽水市",
"861776939", "湖南省邵阳市",
"86159029", "陕西省西安市",
"861306900", "吉林省长春市",
"861339590", "福建省福州市",
"861339901", "新疆塔城地区",
"861572977", "四川省阿坝藏族羌族自治州",
"861860798", "江西省景德镇市",
"861331083", "广东省深圳市",
"861772656", "四川省内江市",
"861370397", "河南省商丘市",
"861333705", "内蒙古通辽市",
"861453681", "陕西省西安市",
"861311118", "山西省吕梁市",
"86138472", "内蒙古包头市",
"861528403", "四川省绵阳市",
"86135344", "广东省佛山市",
"861815309", "河南省新乡市",
"861571265", "浙江省台州市",
"86132507", "广东省广州市",
"86134891", "福建省福州市",
"861821819", "广东省肇庆市",
"861859638", "山东省临沂市",
"86186996", "新疆巴音郭楞蒙古自治州",
"86156270", "广东省揭阳市",
"861594749", "内蒙古鄂尔多斯市",
"861820471", "内蒙古呼和浩特市",
"861760875", "云南省保山市",
"86155174", "河南省周口市",
"861393423", "山西省太原市",
"86577", "浙江省温州市",
"861321686", "浙江省丽水市",
"861855840", "浙江省嘉兴市",
"861313938", "甘肃省天水市",
"861531405", "山东省威海市",
"861831729", "河南省焦作市",
"861847563", "广东省深圳市",
"861555754", "浙江省绍兴市",
"861311691", "云南省西双版纳傣族自治州",
"861347571", "山东省聊城市",
"86145317", "上海市",
"861389512", "宁夏石嘴山市",
"861570572", "浙江省湖州市",
"861356058", "广东省汕尾市",
"861530904", "四川省阿坝藏族羌族自治州",
"861550737", "湖南省益阳市",
"861397206", "湖北省襄樊市",
"861310077", "湖北省襄樊市",
"861862913", "陕西省渭南市",
"861887647", "福建省泉州市",
"861867598", "广东省湛江市",
"861332318", "河北省衡水市",
"86188502", "福建省漳州市",
"861892258", "广东省韶关市",
"861304643", "山东省威海市",
"861869492", "江苏省苏州市",
"86182477", "内蒙古鄂尔多斯市",
"861708337", "河北省石家庄市",
"86155934", "甘肃省庆阳市",
"861335043", "四川省眉山市",
"861323988", "新疆昌吉回族自治州",
"861339951", "安徽省合肥市",
"861536975", "河北省沧州市",
"861306950", "河南省许昌市",
"861311636", "贵州省六盘水市",
"861709420", "广东省惠州市",
"861318035", "河北省廊坊市",
"86153909", "广东省中山市",
"861505112", "江苏省镇江市",
"861860589", "浙江省金华市",
"861768837", "广东省广州市",
"861303019", "广东省湛江市",
"861566666", "山东省济南市",
"861768514", "贵州省黔南布依族苗族自治州",
"861527173", "湖北省荆州市",
"86156275", "广东省茂名市",
"861313089", "辽宁省铁岭市",
"861596555", "山东省青岛市",
"861308346", "安徽省淮南市",
"861572864", "广东省深圳市",
"861338877", "云南省玉溪市",
"861361269", "广东省东莞市",
"861316529", "山东省临沂市",
"861528453", "云南省昭通市",
"86152274", "河北省邯郸市",
"861813723", "河南省南阳市",
"861590574", "浙江省宁波市",
"861839045", "湖南省郴州市",
"861893142", "河北省承德市",
"861362531", "山东省济南市",
"861859395", "广西玉林市",
"861539569", "安徽省马鞍山市",
"861535937", "福建省泉州市",
"861770341", "山西省太原市",
"8618911", "北京市",
"861306536", "辽宁省辽阳市",
"861761467", "黑龙江省鸡西市",
"861812830", "广东省中山市",
"861530954", "宁夏固原市",
"86147412", "辽宁省鞍山市",
"861822795", "四川省广安市",
"861325646", "山东省潍坊市",
"861380421", "辽宁省沈阳市",
"86189251", "广东省广州市",
"861776088", "安徽省安庆市",
"861300725", "江西省九江市",
"861760644", "山东省济南市",
"861303085", "福建省莆田市",
"861373176", "河北省秦皇岛市",
"861802482", "广东省惠州市",
"861301703", "贵州省黔南布依族苗族自治州",
"86188971", "青海省西宁市",
"861860515", "江苏省盐城市",
"861558554", "吉林省白城市",
"861306525", "辽宁省盘锦市",
"861880857", "贵州省毕节地区",
"861313015", "辽宁省鞍山市",
"861317529", "浙江省绍兴市",
"86156869", "陕西省宝鸡市",
"861700747", "湖北省武汉市",
"861586442", "山东省菏泽市",
"861333574", "浙江省宁波市",
"861831653", "广东省中山市",
"861308039", "山西省朔州市",
"861373902", "湖南省湘西土家族苗族自治州",
"861800013", "江苏省宿迁市",
"861300736", "湖南省常德市",
"861329529", "江苏省宿迁市",
"861813609", "江苏省苏州市",
"861810083", "四川省成都市",
"861307950", "宁夏银川市",
"861470878", "云南省楚雄彝族自治州",
"861894259", "湖南省常德市",
"861310729", "湖南省邵阳市",
"86185125", "江苏省南京市",
"861532450", "安徽省阜阳市",
"861825151", "江苏省宿迁市",
"861364786", "广西桂林市",
"861707547", "福建省泉州市",
"861472654", "四川省内江市",
"861865141", "江苏省南通市",
"861778731", "云南省红河哈尼族彝族自治州",
"861830691", "云南省西双版纳傣族自治州",
"861591659", "广东省佛山市",
"861590755", "广东省深圳市",
"861589903", "新疆巴音郭楞蒙古自治州",
"861317843", "广东省韶关市",
"861855244", "江苏省苏州市",
"861569456", "黑龙江省黑河市",
"861303806", "山西省长治市",
"861459232", "四川省成都市",
"861309353", "安徽省淮北市",
"861372299", "河北省石家庄市",
"86147527", "江苏省扬州市",
"86152589", "浙江省金华市",
"861369853", "贵州省毕节地区",
"861814535", "黑龙江省鹤岗市",
"861329843", "河南省许昌市",
"861453945", "广东省江门市",
"861309586", "浙江省湖州市",
"86156427", "辽宁省盘锦市",
"861330826", "重庆市",
"861459414", "云南省西双版纳傣族自治州",
"861301753", "河南省新乡市",
"861556814", "吉林省白山市",
"861830636", "山东省潍坊市",
"861319516", "贵州省铜仁地区",
"861761481", "内蒙古呼和浩特市",
"861821885", "广东省梅州市",
"861576772", "广东省江门市",
"861353693", "广东省汕头市",
"86177776", "广西百色市",
"861530423", "辽宁省抚顺市",
"861779038", "四川省攀枝花市",
"861356227", "山东省东营市",
"861856129", "山东省威海市",
"86155858", "贵州省六盘水市",
"861831603", "广东省汕尾市",
"861840416", "辽宁省锦州市",
"86139398", "河南省三门峡市",
"861312364", "贵州省黔南布依族苗族自治州",
"861327516", "江苏省徐州市",
"861315995", "黑龙江省鸡西市",
"86153614", "广东省深圳市",
"861783505", "山西省临汾市",
"861334319", "河北省邢台市",
"861813659", "江苏省常州市",
"861589953", "广东省惠州市",
"861590705", "江西省宜春市",
"861890429", "辽宁省葫芦岛市",
"861585041", "江苏省连云港市",
"861359959", "福建省漳州市",
"861452633", "江苏省盐城市",
"86155460", "黑龙江省哈尔滨市",
"861766042", "山东省济南市",
"86185120", "广东省惠州市",
"861532400", "河北省邯郸市",
"861894209", "湖南省永州市",
"861321872", "江苏省泰州市",
"861859321", "广西玉林市",
"861518942", "江苏省南通市",
"861808374", "江苏省宿迁市",
"861569406", "四川省内江市",
"861303856", "陕西省延安市",
"861886647", "山东省东营市",
"861365497", "辽宁省沈阳市",
"86188131", "北京市",
"861890670", "浙江省衢州市",
"86170933", "河北省唐山市",
"861819993", "新疆石河子市",
"861380495", "辽宁省大连市",
"861300791", "宁夏石嘴山市",
"861527289", "湖北省随州市",
"86133329", "广东省深圳市",
"861350564", "安徽省六安市",
"861558347", "四川省凉山彝族自治州",
"861323346", "山西省晋城市",
"861363356", "山西省晋城市",
"861838883", "云南省临沧市",
"861346571", "山东省潍坊市",
"861528924", "陕西省商洛市",
"861369803", "江西省上饶市",
"861363468", "黑龙江省鹤岗市",
"861773739", "河南省三门峡市",
"86139778", "广西河池市",
"861325500", "福建省泉州市",
"861869444", "陕西省商洛市",
"861859948", "新疆喀什地区",
"861867422", "湖北省孝感市",
"861362519", "江苏省泰州市",
"86156504", "山东省临沂市",
"861390347", "山西省临汾市",
"861377752", "浙江省金华市",
"861478373", "河南省新乡市",
"861571237", "辽宁省大连市",
"861315986", "黑龙江省哈尔滨市",
"86153702", "江苏省无锡市",
"861874637", "黑龙江省佳木斯市",
"861303700", "山西省忻州市",
"861354339", "广东省茂名市",
"861319103", "山西省长治市",
"86139133", "江苏省南京市",
"861304380", "辽宁省阜新市",
"861336905", "新疆克拉玛依市",
"861868018", "广东省中山市",
"861332753", "山西省阳泉市",
"86145221", "浙江省宁波市",
"861314310", "广东省珠海市",
"86177396", "河南省驻马店市",
"861361580", "浙江省舟山市",
"861871614", "四川省泸州市",
"861821896", "广东省惠州市",
"86134138", "广东省肇庆市",
"86157024", "辽宁省沈阳市",
"86189126", "江苏省苏州市",
"861360330", "河北省邯郸市",
"861512409", "辽宁省朝阳市",
"861452558", "山东省青岛市",
"86187881", "云南省昆明市",
"861354167", "四川省自贡市",
"861551669", "河南省驻马店市",
"861380486", "黑龙江省绥化市",
"86187650", "山东省菏泽市",
"861800479", "内蒙古锡林郭勒盟",
"861836186", "江苏省盐城市",
"86159466", "黑龙江省鹤岗市",
"861881671", "广东省茂名市",
"861539280", "湖北省仙桃市",
"861827664", "广西百色市",
"861370552", "安徽省蚌埠市",
"86132606", "湖北省武汉市",
"861788123", "新疆哈密地区",
"861556078", "内蒙古巴彦淖尔市",
"861858546", "贵州省黔东南苗族侗族自治州",
"86177577", "浙江省温州市",
"86182743", "湖南省邵阳市",
"861302164", "山东省威海市",
"861880097", "四川省巴中市",
"861580883", "云南省临沧市",
"861303031", "河南省濮阳市",
"861882732", "湖北省咸宁市",
"861350889", "云南省玉溪市",
"861478742", "云南省曲靖市",
"861355774", "广西梧州市",
"861767122", "湖北省黄石市",
"861341547", "广东省佛山市",
"861815105", "江苏省扬州市",
"861760692", "云南省德宏傣族景颇族自治州",
"861313648", "浙江省台州市",
"861503682", "河南省周口市",
"861330867", "湖北省襄樊市",
"86181943", "甘肃省白银市",
"861807190", "湖北省宜昌市",
"861818601", "湖北省黄石市",
"861390504", "福建省莆田市",
"86181748", "广西玉林市",
"861327153", "河南省洛阳市",
"861396575", "安徽省亳州市",
"861325550", "山东省烟台市",
"861365540", "山东省菏泽市",
"861829404", "甘肃省平凉市",
"861538857", "山西省临汾市",
"861359297", "广东省茂名市",
"861803487", "新疆和田地区",
"861328473", "内蒙古乌海市",
"861367143", "广东省潮州市",
"86134534", "山西省太原市",
"861828461", "四川省乐山市",
"861337520", "江苏省淮安市",
"861815841", "浙江省杭州市",
"861335123", "黑龙江省牡丹江市",
"861334628", "山东省滨州市",
"861813417", "河北省石家庄市",
"861453626", "江苏省泰州市",
"86180741", "浙江省台州市",
"861533775", "江西省南昌市",
"861326788", "广东省湛江市",
"861332703", "内蒙古乌海市",
"861569368", "甘肃省张掖市",
"861817404", "江西省南昌市",
"861336955", "宁夏中卫市",
"861831482", "浙江省金华市",
"861528876", "山东省烟台市",
"861311946", "甘肃省酒泉市",
"861539971", "湖南省益阳市",
"86182948", "甘肃省白银市",
"861319153", "内蒙古通辽市",
"861525084", "江苏省无锡市",
"86151326", "河北省廊坊市",
"861889987", "广东省佛山市",
"861522669", "河北省廊坊市",
"861584980", "内蒙古兴安盟",
"861833600", "河南省郑州市",
"861388142", "四川省自贡市",
"861454193", "山西省朔州市",
"86156108", "河北省衡水市",
"861760934", "甘肃省庆阳市",
"86137532", "山西省大同市",
"861399969", "新疆吐鲁番地区",
"861780955", "宁夏中卫市",
"86187655", "山东省德州市",
"861820062", "广东省汕头市",
"861597276", "湖北省随州市",
"861330720", "湖北省宜昌市",
"861816923", "湖南省邵阳市",
"861348761", "湖南省邵阳市",
"861452508", "山东省威海市",
"861848773", "云南省玉溪市",
"861330974", "青海省海南藏族自治州",
"861588691", "新疆昌吉回族自治州",
"861830388", "河南省开封市",
"861345587", "山东省威海市",
"861501450", "广东省中山市",
"861364795", "江西省宜春市",
"86178544", "山东省聊城市",
"861452662", "江西省九江市",
"861470014", "江苏省无锡市",
"861331475", "内蒙古通辽市",
"861390554", "安徽省淮南市",
"861567627", "广西柳州市",
"861869528", "宁夏银川市",
"861818651", "湖北省武汉市",
"861836041", "江苏省无锡市",
"861770859", "贵州省黔西南布依族苗族自治州",
"86170711", "北京市",
"861809040", "四川省攀枝花市",
"861821831", "广东省揭阳市",
"861761435", "吉林省通化市",
"861835650", "安徽省合肥市",
"861570476", "内蒙古赤峰市",
"861508163", "河北省邯郸市",
"861347208", "河北省承德市",
"861768236", "浙江省宁波市",
"861801447", "江苏省南京市",
"86147905", "安徽省安庆市",
"861378410", "河北省唐山市",
"861327830", "吉林省松原市",
"861338276", "江苏省南京市",
"861538068", "江苏省连云港市",
"861550975", "青海省果洛藏族自治州",
"861857118", "湖北省襄樊市",
"861819479", "青海省西宁市",
"861332045", "云南省德宏傣族景颇族自治州",
"861313986", "新疆阿克苏地区",
"861318858", "辽宁省盘锦市",
"861870861", "贵州省铜仁地区",
"861317795", "江西省宜春市",
"861340579", "江苏省无锡市",
"861359819", "河南省洛阳市",
"861800664", "浙江省宁波市",
"861821828", "广东省东莞市",
"861352395", "河南省漯河市",
"861355964", "福建省泉州市",
"86152305", "河北省唐山市",
"861311129", "山西省运城市",
"861846712", "青海省海西蒙古族藏族自治州",
"86156304", "河北省石家庄市",
"861303916", "吉林省吉林市",
"861319830", "四川省达州市",
"861514627", "黑龙江省哈尔滨市",
"861323991", "新疆乌鲁木齐市",
"861323500", "福建省厦门市",
"861334631", "山东省威海市",
"861315648", "山东省青岛市",
"861353920", "广东省惠州市",
"861471495", "广东省汕头市",
"86186448", "吉林省四平市",
"86135437", "广东省东莞市",
"861534082", "山西省晋中市",
"861457003", "山东省德州市",
"86147682", "山东省临沂市",
"861573848", "河南省开封市",
"861776091", "四川省攀枝花市",
"861859686", "福建省厦门市",
"861458389", "福建省龙岩市",
"861515612", "安徽省马鞍山市",
"861362492", "辽宁省鞍山市",
"861556954", "新疆伊犁哈萨克自治州",
"861306214", "福建省莆田市",
"861308925", "吉林省松原市",
"861332329", "河北省唐山市",
"861594541", "黑龙江省佳木斯市",
"861526448", "山东省临沂市",
"861347779", "湖北省咸宁市",
"861310595", "福建省宁德市",
"861453335", "浙江省衢州市",
"861470994", "新疆昌吉回族自治州",
"86147900", "安徽省滁州市",
"86151526", "江苏省泰州市",
"861334696", "河南省南阳市",
"861453698", "陕西省渭南市",
"861860781", "广西南宁市",
"861305096", "辽宁省葫芦岛市",
"861325011", "广东省佛山市",
"861301191", "河北省保定市",
"861839318", "甘肃省天水市",
"861509007", "河南省新乡市",
"861399779", "湖北省恩施土家族苗族自治州",
"861316518", "山东省济宁市",
"861815417", "安徽省淮北市",
"86134071", "湖北省武汉市",
"861813841", "广东省深圳市",
"861583316", "河北省廊坊市",
"861535775", "安徽省马鞍山市",
"861810040", "辽宁省沈阳市",
"861386245", "江苏省镇江市",
"861323550", "湖北省随州市",
"861328207", "浙江省衢州市",
"861306432", "四川省达州市",
"86188314", "河北省承德市",
"861303028", "广东省云浮市",
"861338393", "河南省濮阳市",
"86152300", "河北省邯郸市",
"861516542", "山东省青岛市",
"861580746", "湖南省永州市",
"861805487", "福建省龙岩市",
"86134334", "广东省惠州市",
"861520267", "宁夏银川市",
"861470632", "山东省枣庄市",
"861814422", "四川省自贡市",
"861352638", "河南省驻马店市",
"861522474", "河南省信阳市",
"861356835", "四川省达州市",
"861337564", "山东省枣庄市",
"861867581", "广东省汕尾市",
"861510868", "云南省曲靖市",
"861518332", "四川省眉山市",
"86136296", "云南省昆明市",
"861457053", "新疆喀什地区",
"861533647", "山东省东营市",
"86137819", "河南省新乡市",
"861869596", "河南省南阳市",
"861329880", "吉林省延边朝鲜族自治州",
"861824444", "四川省达州市",
"861301618", "湖南省衡阳市",
"861362739", "湖南省邵阳市",
"861576933", "甘肃省平凉市",
"861536737", "湖南省益阳市",
"861566408", "河南省新乡市",
"861311688", "浙江省金华市",
"861539761", "四川省成都市",
"861596693", "山东省青岛市",
"861367310", "河北省邯郸市",
"861588325", "四川省内江市",
"861300153", "山东省潍坊市",
"861880917", "陕西省宝鸡市",
"861374970", "河南省南阳市",
"861323936", "甘肃省张掖市",
"861378378", "河南省开封市",
"861390937", "甘肃省酒泉市",
"861476182", "江苏省宿迁市",
"861310353", "山西省阳泉市",
"861320536", "山东省潍坊市",
"861475239", "江苏省无锡市",
"861877229", "湖北省黄石市",
"861335574", "浙江省宁波市",
"861365583", "浙江省嘉兴市",
"861453381", "内蒙古兴安盟",
"861882973", "陕西省渭南市",
"861770919", "陕西省铜川市",
"861309729", "江西省九江市",
"861375902", "云南省普洱市",
"861823845", "河南省周口市",
"861454701", "浙江省杭州市",
"861334685", "河南省周口市",
"861321503", "福建省三明市",
"861776851", "江苏省无锡市",
"861326725", "广东省东莞市",
"861850399", "河南省漯河市",
"861315015", "甘肃省武威市",
"861530565", "安徽省巢湖市",
"861524406", "山东省菏泽市",
"861760557", "安徽省宿州市",
"861305085", "辽宁省盘锦市",
"861705317", "湖北省武汉市",
"86181206", "福建省泉州市",
"861593266", "河北省石家庄市",
"861899491", "江苏省徐州市",
"861871063", "陕西省渭南市",
"861365306", "广东省阳江市",
"86130807", "辽宁省沈阳市",
"861776145", "四川省自贡市",
"86152389", "河南省三门峡市",
"861320950", "宁夏银川市",
"861337889", "云南省玉溪市",
"861332618", "浙江省湖州市",
"86184459", "黑龙江省哈尔滨市",
"861582559", "浙江省宁波市",
"861532642", "吉林省长春市",
"861827013", "江西省鹰潭市",
"861318098", "吉林省四平市",
"861700675", "浙江省宁波市",
"861351923", "宁夏中卫市",
"861801590", "江苏省南通市",
"861581929", "广东省肇庆市",
"861830325", "河北省沧州市",
"861559076", "吉林省辽源市",
"861571825", "广东省河源市",
"861538917", "陕西省宝鸡市",
"861880704", "江西省抚州市",
"861804890", "四川省绵阳市",
"861596964", "山东省德州市",
"861846425", "山东省滨州市",
"86152927", "新疆伊犁哈萨克自治州",
"86145045", "辽宁省大连市",
"861311391", "广东省中山市",
"861779021", "四川省乐山市",
"86184189", "重庆市",
"861328999", "新疆伊犁哈萨克自治州",
"861321386", "河南省信阳市",
"861812599", "广东省清远市",
"861839188", "陕西省宝鸡市",
"86147989", "海南省海口市",
"861819013", "四川省巴中市",
"861319736", "湖北省孝感市",
"86157649", "内蒙古包头市",
"861308646", "四川省乐山市",
"861313995", "新疆吐鲁番地区",
"861888210", "四川省资阳市",
"86134593", "福建省宁德市",
"861301045", "江苏省苏州市",
"861310303", "河北省张家口市",
"861352386", "河南省新乡市",
"861815659", "安徽省马鞍山市",
"861880068", "江苏省淮安市",
"861879216", "安徽省池州市",
"861862476", "河南省南阳市",
"861839470", "甘肃省酒泉市",
"861392170", "江苏省泰州市",
"861807033", "江西省上饶市",
"861330898", "西藏拉萨市",
"861806471", "浙江省台州市",
"861863805", "河南省周口市",
"86139598", "福建省泉州市",
"861823674", "河南省三门峡市",
"861361543", "山东省滨州市",
"861769879", "河南省漯河市",
"861562861", "山东省日照市",
"861329786", "广西玉林市",
"861354198", "四川省广安市",
"861454751", "浙江省台州市",
"861321553", "安徽省芜湖市",
"861867535", "广东省梅州市",
"861803305", "广东省深圳市",
"861350520", "江苏省徐州市",
"861339839", "四川省绵阳市",
"861458119", "安徽省阜阳市",
"861800993", "新疆石河子市",
"861839629", "福建省漳州市",
"861345769", "广西桂林市",
"861760507", "福建省厦门市",
"861528960", "广西柳州市",
"861319791", "江西省南昌市",
"861586600", "山东省泰安市",
"86177797", "江西省赣州市",
"861576962", "宁夏石嘴山市",
"861301329", "河北省邢台市",
"861450484", "辽宁省鞍山市",
"86133529", "广东省深圳市",
"86176431", "吉林省长春市",
"861514666", "黑龙江省齐齐哈尔市",
"861539243", "福建省宁德市",
"861320900", "新疆伊犁哈萨克自治州",
"861760344", "山西省晋中市",
"861320591", "福建省福州市",
"861338555", "贵州省黔东南苗族侗族自治州",
"861365356", "山西省晋城市",
"861510794", "江西省抚州市",
"861364529", "江苏省镇江市",
"861310586", "浙江省台州市",
"861801951", "安徽省芜湖市",
"861354611", "山西省太原市",
"861894968", "安徽省淮南市",
"861770641", "浙江省杭州市",
"861767707", "广西梧州市",
"86145040", "辽宁省沈阳市",
"861700844", "四川省成都市",
"861818849", "四川省自贡市",
"861860735", "湖南省郴州市",
"86188953", "安徽省芜湖市",
"861880754", "广东省汕头市",
"861312320", "福建省南平市",
"861363497", "辽宁省锦州市",
"861471486", "广东省深圳市",
"86145422", "重庆市",
"861357974", "新疆石河子市",
"861583041", "河北省石家庄市",
"861367478", "内蒙古呼和浩特市",
"861328148", "四川省成都市",
"861518363", "四川省凉山彝族自治州",
"861580840", "四川省南充市",
"861786898", "云南省昭通市",
"861332136", "甘肃省张掖市",
"861858348", "四川省遂宁市",
"861598390", "四川省广元市",
"861705280", "广东省广州市",
"861806885", "江苏省盐城市",
"861803323", "广东省佛山市",
"861816815", "江苏省连云港市",
"861841973", "甘肃省平凉市",
"861366743", "湖南省株洲市",
"861572949", "河南省三门峡市",
"861585284", "江苏省无锡市",
"861479973", "新疆乌鲁木齐市",
"861452356", "河南省驻马店市",
"861818505", "贵州省遵义市",
"861380332", "河北省唐山市",
"861817889", "广西河池市",
"86155531", "山东省济南市",
"861586648", "山东省烟台市",
"861319188", "河北省石家庄市",
"861874979", "河南省焦作市",
"861509142", "陕西省咸阳市",
"861332599", "浙江省金华市",
"861855146", "江苏省常州市",
"861309118", "河北省衡水市",
"861592916", "陕西省延安市",
"861590359", "山西省运城市",
"86158520", "江苏省徐州市",
"861573090", "甘肃省甘南藏族自治州",
"861310325", "河北省唐山市",
"861862730", "湖南省岳阳市",
"861520912", "陕西省榆林市",
"861379894", "广东省东莞市",
"861594777", "内蒙古乌兰察布市",
"861899770", "新疆伊犁哈萨克自治州",
"861774030", "河北省邢台市",
"861830353", "山西省阳泉市",
"861350454", "黑龙江省佳木斯市",
"861571853", "贵州省安顺市",
"861846453", "山东省烟台市",
"861320948", "甘肃省嘉峪关市",
"861384882", "内蒙古包头市",
"861381582", "江苏省扬州市",
"86151492", "内蒙古呼伦贝尔市",
"861352525", "河南省濮阳市",
"861812191", "四川省南充市",
"861351955", "宁夏吴忠市",
"861317616", "山东省聊城市",
"861501215", "云南省西双版纳傣族自治州",
"861366372", "河南省安阳市",
"86188289", "四川省宜宾市",
"861814685", "陕西省安康市",
"861318746", "云南省大理白族自治州",
"861310049", "广西柳州市",
"861785849", "浙江省金华市",
"861880262", "广东省惠州市",
"861500932", "甘肃省定西市",
"861536669", "江苏省连云港市",
"861893285", "河北省承德市",
"86134613", "河南省周口市",
"86188633", "山东省日照市",
"861830586", "浙江省台州市",
"861805278", "江苏省宿迁市",
"861575910", "福建省漳州市",
"861331266", "云南省红河哈尼族彝族自治州",
"861818555", "贵州省贵阳市",
"861452306", "河南省安阳市",
"861843235", "河北省唐山市",
"86139618", "江苏省无锡市",
"861458511", "河南省开封市",
"8614739", "广东省广州市",
"861709965", "浙江省台州市",
"861568968", "山东省聊城市",
"861884644", "黑龙江省哈尔滨市",
"861332788", "江苏省常州市",
"861869326", "甘肃省兰州市",
"861559401", "甘肃省平凉市",
"861538371", "河北省石家庄市",
"861588595", "贵州省黔西南布依族苗族自治州",
"861338849", "浙江省绍兴市",
"861709647", "山东省烟台市",
"861471942", "甘肃省兰州市",
"86158525", "江苏省无锡市",
"861778119", "四川省内江市",
"86137359", "浙江省丽水市",
"861575162", "江苏省镇江市",
"861810898", "西藏拉萨市",
"861822041", "陕西省延安市",
"861515245", "江苏省徐州市",
"861452583", "福建省宁德市",
"861304059", "新疆阿勒泰地区",
"861319470", "四川省雅安市",
"861770484", "内蒙古包头市",
"861335659", "广东省江门市",
"861354224", "广东省揭阳市",
"861846403", "山东省菏泽市",
"861370433", "吉林省延边朝鲜族自治州",
"861317138", "内蒙古锡林郭勒盟",
"86151280", "河北省邯郸市",
"861878419", "四川省广安市",
"86177422", "天津市",
"861839791", "江西省南昌市",
"861327470", "内蒙古呼伦贝尔市",
"861351905", "甘肃省武威市",
"861580858", "贵州省六盘水市",
"861554534", "黑龙江省哈尔滨市",
"861811120", "四川省泸州市",
"861819839", "贵州省六盘水市",
"86188854", "贵州省黔南布依族苗族自治州",
"86177040", "广东省广州市",
"861450641", "黑龙江省大庆市",
"861564982", "河南省许昌市",
"861319629", "吉林省四平市",
"861570836", "四川省甘孜藏族自治州",
"861879922", "新疆克拉玛依市",
"861329138", "江苏省扬州市",
"861312447", "福建省泉州市",
"861569566", "安徽省池州市",
"861840570", "浙江省衢州市",
"861524071", "广西南宁市",
"861898446", "贵州省毕节地区",
"861554817", "内蒙古乌兰察布市",
"861338523", "湖北省恩施土家族苗族自治州",
"861864520", "黑龙江省齐齐哈尔市",
"861367838", "四川省德阳市",
"86159848", "四川省南充市",
"861769246", "河北省秦皇岛市",
"861569527", "江苏省宿迁市",
"86184432", "吉林省吉林市",
"861867628", "广东省东莞市",
"86188205", "广东省清远市",
"86156210", "山东省青岛市",
"861591123", "云南省大理白族自治州",
"86138412", "辽宁省鞍山市",
"861804048", "四川省巴中市",
"861899876", "广东省河源市",
"861311718", "湖北省荆州市",
"861588586", "贵州省毕节地区",
"861820909", "新疆博尔塔拉蒙古自治州",
"861330252", "广东省阳江市",
"861470421", "辽宁省朝阳市",
"861814631", "青海省西宁市",
"861893296", "河北省邢台市",
"861346844", "山东省烟台市",
"861868541", "贵州省贵阳市",
"861598404", "四川省泸州市",
"861530387", "河南省洛阳市",
"861521724", "广东省东莞市",
"86151209", "海南省海口市",
"861871887", "广东省广州市",
"861311521", "江苏省徐州市",
"861836284", "江苏省连云港市",
"861562184", "山东省枣庄市",
"861363508", "广西梧州市",
"861596437", "山东省聊城市",
"86156572", "浙江省湖州市",
"861880371", "河南省郑州市",
"861302266", "浙江省台州市",
"861380363", "黑龙江省齐齐哈尔市",
"861318840", "辽宁省铁岭市",
"861521970", "广东省梅州市",
"861361630", "山东省威海市",
"861810008", "上海市",
"86153861", "湖南省常德市",
"861339479", "内蒙古锡林郭勒盟",
"861892179", "江苏省徐州市",
"861570051", "四川省广安市",
"861589988", "广东省深圳市",
"861870314", "河北省承德市",
"861573850", "河南省郑州市",
"86187434", "吉林省四平市",
"861818276", "黑龙江省七台河市",
"861807268", "浙江省金华市",
"861802336", "广东省云浮市",
"861564360", "吉林省长春市",
"861771996", "河南省商丘市",
"861323424", "辽宁省辽阳市",
"861869367", "甘肃省嘉峪关市",
"861308953", "黑龙江省七台河市",
"861531537", "山东省济宁市",
"861354735", "四川省泸州市",
"86182386", "河南省新乡市",
"861513418", "辽宁省锦州市",
"861850529", "江苏省徐州市",
"861839830", "四川省达州市",
"86145377", "广西南宁市",
"861339620", "山东省菏泽市",
"86187646", "山东省潍坊市",
"861534837", "湖南省益阳市",
"861876634", "山东省莱芜市",
"861376824", "广西梧州市",
"861860611", "江苏省泰州市",
"861454374", "山东省德州市",
"861503532", "山西省阳泉市",
"86139631", "山东省威海市",
"861595475", "山东省东营市",
"861511373", "广东省清远市",
"861833986", "河南省三门峡市",
"861362626", "江苏省镇江市",
"861809867", "安徽省淮南市",
"861812045", "湖北省襄樊市",
"861881206", "河北省廊坊市",
"861313442", "吉林省吉林市",
"86155114", "河北省石家庄市",
"861525241", "江苏省淮安市",
"861534514", "江苏省扬州市",
"861566440", "山东省德州市",
"861320321", "湖南省湘潭市",
"861893373", "广东省河源市",
"861773698", "河北省沧州市",
"861527773", "广西桂林市",
"86156215", "山东省泰安市",
"86188200", "广东省广州市",
"861301599", "福建省莆田市",
"86183625", "江苏省苏州市",
"861506044", "福建省福州市",
"861333155", "吉林省四平市",
"861802391", "广东省潮州市",
"861820959", "宁夏固原市",
"861364399", "河南省南阳市",
"861860949", "甘肃省兰州市",
"86137908", "广东省汕头市",
"861363558", "安徽省阜阳市",
"861312590", "黑龙江省哈尔滨市",
"861829564", "宁夏固原市",
"861500963", "宁夏吴忠市",
"861856077", "山东省济南市",
"861831688", "广东省湛江市",
"861806896", "江苏省南通市",
"861323548", "湖北省孝感市",
"861598454", "四川省雅安市",
"861570730", "湖南省岳阳市",
"861810058", "福建省莆田市",
"861558175", "山西省晋中市",
"86182417", "辽宁省营口市",
"861504727", "内蒙古巴彦淖尔市",
"861573800", "河南省濮阳市",
"861532215", "广东省云浮市",
"861570001", "浙江省衢州市",
"86155518", "安徽省滁州市",
"86136321", "广东省广州市",
"861344060", "上海市",
"861507852", "广西柳州市",
"861520573", "浙江省嘉兴市",
"861810764", "广东省揭阳市",
"861315600", "山东省济南市",
"8613871", "湖北省武汉市",
"861568017", "四川省雅安市",
"861845827", "浙江省湖州市",
"86147472", "内蒙古包头市",
"861809974", "新疆阿克苏地区",
"861377220", "陕西省汉中市",
"861452468", "黑龙江省鹤岗市",
"861533379", "河南省洛阳市",
"861893231", "江苏省淮安市",
"861890312", "河北省保定市",
"861577530", "四川省成都市",
"861818393", "云南省曲靖市",
"861457025", "江西省宜春市",
"861555104", "安徽省滁州市",
"8618917", "上海市",
"861370462", "黑龙江省齐齐哈尔市",
"861594998", "山东省日照市",
"861843281", "河北省石家庄市",
"861350390", "河南省南阳市",
"861335417", "辽宁省营口市",
"861559947", "贵州省铜仁地区",
"861333841", "福建省福州市",
"861567352", "湖南省郴州市",
"86156372", "河南省安阳市",
"86186866", "吉林省长春市",
"861868434", "吉林省四平市",
"861502954", "陕西省汉中市",
"861580918", "陕西省西安市",
"861858938", "云南省曲靖市",
"861453739", "湖南省常德市",
"861314287", "湖南省湘潭市",
"861323460", "黑龙江省齐齐哈尔市",
"861390420", "辽宁省鞍山市",
"861859950", "福建省三明市",
"861589646", "江苏省无锡市",
"861332725", "湖南省怀化市",
"861321432", "吉林省吉林市",
"861520802", "西藏日喀则地区",
"861458785", "湖南省衡阳市",
"861833648", "河南省安阳市",
"861335105", "黑龙江省双鸭山市",
"86187930", "甘肃省临夏回族自治州",
"86189213", "江苏省无锡市",
"861390679", "浙江省金华市",
"861893228", "江苏省盐城市",
"86138238", "广东省梅州市",
"861700571", "浙江省杭州市",
"86145396", "广东省广州市",
"861397262", "湖北省武汉市",
"86177221", "广东省汕头市",
"861365662", "浙江省嘉兴市",
"861771928", "河南省信阳市",
"861505532", "安徽省芜湖市",
"861334581", "浙江省杭州市",
"86180822", "陕西省西安市",
"861342663", "江西省上饶市",
"861387182", "湖北省鄂州市",
"861315442", "四川省广元市",
"861505488", "山东省济宁市",
"861320338", "湖南省郴州市",
"861570510", "江苏省盐城市",
"861859536", "河南省周口市",
"86186917", "陕西省宝鸡市",
"861452540", "山东省菏泽市",
"861459577", "陕西省咸阳市",
"861526642", "山东省枣庄市",
"861596301", "山东省青岛市",
"861362698", "福建省宁德市",
"861566652", "山东省青岛市",
"861479732", "山西省长治市",
"86182586", "浙江省台州市",
"861760426", "辽宁省大连市",
"861809008", "四川省成都市",
"861768134", "安徽省芜湖市",
"861313650", "浙江省湖州市",
"861816905", "宁夏中卫市",
"861479241", "安徽省宿州市",
"861329399", "山西省运城市",
"861572167", "山西省临汾市",
"861453492", "内蒙古锡林郭勒盟",
"861770545", "山东省烟台市",
"861567075", "河南省安阳市",
"861810974", "青海省海南藏族自治州",
"861303748", "湖南省永州市",
"861500342", "山西省大同市",
"861310388", "河南省许昌市",
"861366780", "广西柳州市",
"861810720", "湖北省十堰市",
"861336923", "陕西省汉中市",
"861365558", "安徽省阜阳市",
"861362335", "河北省秦皇岛市",
"861866457", "广东省深圳市",
"861325548", "山东省泰安市",
"861319125", "山西省长治市",
"861859591", "河南省郑州市",
"861534734", "湖南省衡阳市",
"861477782", "广西南宁市",
"861873847", "河南省驻马店市",
"86187935", "甘肃省武威市",
"861335155", "吉林省松原市",
"861338651", "浙江省杭州市",
"861316041", "江苏省扬州市",
"861520852", "贵州省遵义市",
"861320695", "黑龙江省鸡西市",
"861857586", "广东省佛山市",
"861321799", "江西省萍乡市",
"861529360", "甘肃省张掖市",
"861775698", "安徽省合肥市",
"861811475", "江苏省苏州市",
"861571913", "陕西省渭南市",
"861360818", "四川省成都市",
"861806828", "江苏省无锡市",
"861472987", "陕西省榆林市",
"861566568", "安徽省六安市",
"861511228", "广东省深圳市",
"861470582", "浙江省湖州市",
"861335841", "福建省三明市",
"861778615", "湖北省黄冈市",
"861470438", "吉林省松原市",
"861874493", "贵州省毕节地区",
"861352588", "河南省三门峡市",
"861324237", "广东省清远市",
"861367821", "四川省眉山市",
"861867631", "广东省清远市",
"861535379", "陕西省宝鸡市",
"861853035", "河南省三门峡市",
"861374044", "吉林省长春市",
"861586995", "湖南省永州市",
"861346747", "湖南省永州市",
"861829520", "宁夏银川市",
"861301412", "甘肃省张掖市",
"861479499", "内蒙古鄂尔多斯市",
"86136521", "天津市",
"861566602", "山东省淄博市",
"861887213", "湖北省恩施土家族苗族自治州",
"861575800", "云南省玉溪市",
"86139874", "云南省曲靖市",
"861780923", "陕西省渭南市",
"861850786", "广西百色市",
"861450859", "江苏省盐城市",
"861500773", "广西桂林市",
"861311538", "黑龙江省鹤岗市",
"86155318", "河北省衡水市",
"861831946", "广东省深圳市",
"86187170", "重庆市",
"861816955", "宁夏中卫市",
"861501448", "广东省揭阳市",
"861519963", "新疆克拉玛依市",
"86158320", "河北省邯郸市",
"861891245", "江苏省无锡市",
"86153198", "陕西省安康市",
"861528249", "四川省凉山彝族自治州",
"861320686", "黑龙江省牡丹江市",
"861568259", "四川省凉山彝族自治州",
"861821471", "安徽省芜湖市",
"861452497", "内蒙古赤峰市",
"861321463", "黑龙江省牡丹江市",
"861594645", "黑龙江省齐齐哈尔市",
"861529982", "新疆伊犁哈萨克自治州",
"861899960", "新疆巴音郭楞蒙古自治州",
"861365633", "山东省日照市",
"861898594", "贵州省六盘水市",
"861310691", "广东省肇庆市",
"86138782", "广西柳州市",
"861569071", "河南省平顶山市",
"861830729", "湖北省武汉市",
"861831625", "广东省肇庆市",
"861576009", "四川省宜宾市",
"861530405", "辽宁省丹东市",
"861334535", "新疆阿克苏地区",
"861329121", "江苏省无锡市",
"861595120", "江苏省常州市",
"861597523", "广东省揭阳市",
"861892675", "广东省深圳市",
"861311077", "福建省福州市",
"861382490", "广东省清远市",
"861575756", "浙江省台州市",
"861837529", "贵州省黔东南苗族侗族自治州",
"861332412", "辽宁省鞍山市",
"86187493", "河南省安阳市",
"861369825", "四川省自贡市",
"861803759", "河南省平顶山市",
"861479763", "青海省海东地区",
"861866941", "山东省青岛市",
"861527694", "新疆喀什地区",
"861779741", "青海省果洛藏族自治州",
"861565065", "安徽省安庆市",
"86176259", "江苏省南京市",
"86155754", "湖南省衡阳市",
"861850795", "江西省宜春市",
"861528436", "河北省廊坊市",
"861457088", "江苏省常州市",
"861802946", "广东省汕尾市",
"861532448", "安徽省合肥市",
"861359190", "辽宁省辽阳市",
"861554299", "辽宁省铁岭市",
"861519694", "四川省遂宁市",
"861377413", "湖北省随州市",
"861834478", "江苏省连云港市",
"861597849", "河南省驻马店市",
"861773667", "广西桂林市",
"861507160", "湖北省十堰市",
"861309325", "湖北省恩施土家族苗族自治州",
"861338465", "黑龙江省哈尔滨市",
"861861798", "河北省石家庄市",
"861773945", "河南省周口市",
"861537137", "江苏省宿迁市",
"861300188", "河北省石家庄市",
"861586986", "湖南省邵阳市",
"861813574", "河南省商丘市",
"861590723", "湖北省黄石市",
"861458796", "湖南省株洲市",
"861856718", "河南省南阳市",
"861539187", "安徽省宿州市",
"86181987", "广东省惠州市",
"86137559", "江西省抚州市",
"86158325", "河北省唐山市",
"861860339", "河北省秦皇岛市",
"861576059", "四川省南充市",
"861530455", "黑龙江省绥化市",
"861760467", "黑龙江省鸡西市",
"861332234", "辽宁省辽阳市",
"861771341", "四川省成都市",
"861532524", "浙江省绍兴市",
"861705761", "辽宁省大连市",
"861318883", "山东省潍坊市",
"861364616", "江苏省无锡市",
"861822699", "安徽省滁州市",
"86156792", "江西省九江市",
"861845235", "江苏省南京市",
"861847112", "湖北省十堰市",
"86182787", "广西钦州市",
"86153594", "福建省厦门市",
"861575706", "浙江省衢州市",
"861850880", "云南省昭通市",
"861803278", "河北省石家庄市",
"861301725", "湖南省常德市",
"861300629", "江西省萍乡市",
"861308813", "四川省南充市",
"861869398", "甘肃省酒泉市",
"861866619", "广东省中山市",
"861339993", "新疆石河子市",
"86477", "内蒙古鄂尔多斯市",
"861839516", "宁夏中卫市",
"86189827", "四川省泸州市",
"861558679", "湖北省咸宁市",
"86145056", "上海市",
"861503425", "山西省吕梁市",
"861888661", "四川省成都市",
"86176884", "广东省广州市",
"861388673", "湖北省宜昌市",
"861345365", "山西省临汾市",
"861342994", "湖北省孝感市",
"861864889", "广西柳州市",
"861552866", "四川省巴中市",
"861520092", "湖南省长沙市",
"861862510", "江苏省苏州市",
"861814319", "吉林省白山市",
"861556361", "山东省潍坊市",
"861879114", "陕西省延安市",
"861333659", "广东省阳江市",
"861536474", "山西省晋中市",
"86188968", "江苏省苏州市",
"861559337", "甘肃省天水市",
"861852471", "辽宁省阜新市",
"861568778", "云南省昆明市",
"86137260", "广东省中山市",
"861583518", "山西省吕梁市",
"861500394", "河南省周口市",
"861831691", "广东省河源市",
"861591755", "广东省湛江市",
"861806297", "湖北省荆州市",
"86156692", "浙江省宁波市",
"86185025", "江苏省南京市",
"861453444", "辽宁省辽阳市",
"861311729", "湖北省宜昌市",
"861307503", "安徽省亳州市",
"861866685", "广东省东莞市",
"861363333", "河北省秦皇岛市",
"861317195", "河北省邢台市",
"861586348", "山东省青岛市",
"861395117", "江苏省泰州市",
"861313546", "安徽省淮北市",
"86176330", "河北省唐山市",
"861812318", "四川省达州市",
"861880822", "四川省自贡市",
"861452656", "江西省吉安市",
"861560894", "西藏林芝地区",
"861380632", "山东省枣庄市",
"861820790", "江西省新余市",
"86187347", "山西省临汾市",
"861598690", "广东省揭阳市",
"861858648", "贵州省六盘水市",
"861302974", "黑龙江省齐齐哈尔市",
"861875246", "江苏省南通市",
"861819901", "新疆伊犁哈萨克自治州",
"861322564", "安徽省六安市",
"861503249", "河北省保定市",
"861476245", "江苏省常州市",
"861537474", "内蒙古乌兰察布市",
"861818964", "甘肃省张掖市",
"861700969", "浙江省宁波市",
"861850721", "湖北省荆州市",
"861814385", "西藏林芝地区",
"861855858", "福建省泉州市",
"86177317", "河北省沧州市",
"861843298", "河北省唐山市",
"861594981", "山东省泰安市",
"861872004", "江西省宜春市",
"861846960", "云南省丽江市",
"861884557", "黑龙江省哈尔滨市",
"861301736", "湖南省常德市",
"861353174", "广东省惠州市",
"861827901", "江西省宜春市",
"861335309", "广东省汕头市",
"861824698", "黑龙江省双鸭山市",
"86138900", "四川省自贡市",
"861329316", "河北省秦皇岛市",
"861340490", "云南省文山壮族苗族自治州",
"861309391", "陕西省汉中市",
"861535213", "甘肃省武威市",
"86170073", "湖南省长沙市",
"861513429", "辽宁省葫芦岛市",
"861850518", "江苏省连云港市",
"86187208", "江西省赣州市",
"861363980", "河南省平顶山市",
"861596523", "山东省聊城市",
"86185020", "广东省广州市",
"861332830", "福建省厦门市",
"861709347", "广东省深圳市",
"861593083", "河北省衡水市",
"86177156", "江苏省淮安市",
"861528425", "河北省唐山市",
"861591705", "广东省韶关市",
"86188374", "河南省许昌市",
"861370566", "安徽省池州市",
"861897878", "广西贵港市",
"861369836", "四川省广安市",
"861333723", "湖南省株洲市",
"861538671", "山西省朔州市",
"861380994", "新疆乌鲁木齐市",
"861319045", "辽宁省本溪市",
"86134011", "北京市",
"861869626", "湖北省鄂州市",
"861320872", "云南省大理白族自治州",
"861534449", "湖南省永州市",
"861301791", "浙江省湖州市",
"861321716", "湖北省荆州市",
"861399179", "陕西省延安市",
"861832479", "安徽省阜阳市",
"861569433", "吉林省延边朝鲜族自治州",
"861327045", "江苏省南京市",
"861872768", "湖北省恩施土家族苗族自治州",
"861309336", "安徽省阜阳市",
"861351564", "安徽省合肥市",
"861367055", "广东省揭阳市",
"861539161", "湖北省黄冈市",
"861315494", "四川省眉山市",
"861300753", "河南省郑州市",
"861331826", "广东省中山市",
"861348409", "浙江省金华市",
"861815043", "福建省莆田市",
"861534236", "湖北省黄冈市",
"861555262", "山东省德州市",
"861760481", "内蒙古呼和浩特市",
"86170958", "福建省泉州市",
"861896363", "江苏省南京市",
"861764068", "辽宁省鞍山市",
"861587986", "江西省鹰潭市",
"861374124", "广东省广州市",
"861804131", "辽宁省抚顺市",
"861836529", "安徽省滁州市",
"86138905", "四川省内江市",
"861818877", "广东省惠州市",
"861335359", "山西省运城市",
"86153818", "浙江省台州市",
"861576816", "广东省茂名市",
"861589991", "广东省东莞市",
"861708561", "安徽省合肥市",
"861453528", "山东省潍坊市",
"861324265", "广东省汕尾市",
"861323813", "辽宁省抚顺市",
"861393405", "山西省长治市",
"861334526", "山东省潍坊市",
"861894443", "江苏省南通市",
"861853067", "河南省南阳市",
"861880671", "浙江省杭州市",
"861853026", "河南省商丘市",
"861380663", "浙江省宁波市",
"861801479", "江苏省无锡市",
"861450928", "江苏省无锡市",
"861332791", "江苏省无锡市",
"861334567", "安徽省亳州市",
"861550669", "山东省聊城市",
"861551765", "河南省驻马店市",
"861508241", "四川省达州市",
"86134153", "广东省中山市",
"86182322", "河北省承德市",
"861317041", "湖南省长沙市",
"861361330", "河北省石家庄市",
"8618996", "重庆市",
"86139158", "江苏省常州市",
"861819447", "甘肃省陇南市",
"861303862", "云南省大理白族自治州",
"861354589", "湖北省武汉市",
"861530687", "浙江省温州市",
"861454101", "安徽省合肥市",
"861838146", "四川省宜宾市",
"861371552", "广东省佛山市",
"861304530", "黑龙江省牡丹江市",
"861325953", "宁夏吴忠市",
"86156999", "北京市",
"861340547", "山东省济宁市",
"86188794", "江西省抚州市",
"861329041", "河北省石家庄市",
"861595040", "江苏省无锡市",
"861590417", "辽宁省营口市",
"861814331", "湖南省永州市",
"861367780", "广西柳州市",
"861309129", "河北省邢台市",
"861518421", "辽宁省朝阳市",
"861572181", "云南省曲靖市",
"861331867", "广东省汕尾市",
"861391347", "江苏省徐州市",
"861319136", "内蒙古鄂尔多斯市",
"861897014", "江西省赣州市",
"861454674", "广东省珠海市",
"86139661", "安徽省淮北市",
"86758", "广东省肇庆市",
"861567602", "广西防城港市",
"861368708", "江西省南昌市",
"861338437", "吉林省辽源市",
"861839788", "江西省景德镇市",
"861362326", "河北省廊坊市",
"861556117", "内蒙古乌海市",
"861314261", "内蒙古包头市",
"861537165", "江苏省连云港市",
"861339320", "河北省秦皇岛市",
"861308460", "浙江省绍兴市",
"861304956", "贵州省铜仁地区",
"861554216", "辽宁省沈阳市",
"861860311", "河北省石家庄市",
"861342942", "浙江省嘉兴市",
"861856303", "山东省滨州市",
"861306321", "安徽省合肥市",
"861567568", "湖南省郴州市",
"861302826", "辽宁省锦州市",
"861565037", "山东省济宁市",
"861370527", "江苏省扬州市",
"861810881", "云南省昆明市",
"861315350", "山东省烟台市",
"86157124", "辽宁省沈阳市",
"861870614", "江苏省常州市",
"861866631", "广东省揭阳市",
"861360580", "浙江省杭州市",
"861800811", "四川省宜宾市",
"861829955", "新疆阿克苏地区",
"861587995", "江西省萍乡市",
"86187464", "黑龙江省哈尔滨市",
"861776745", "新疆石河子市",
"86188018", "上海市",
"861859525", "山东省济南市",
"861319191", "河北省张家口市",
"861535464", "吉林省四平市",
"861394854", "内蒙古通辽市",
"861474037", "辽宁省朝阳市",
"86183906", "湖南省常德市",
"861331720", "湖北省宜昌市",
"861845267", "江苏省泰州市",
"86153563", "浙江省台州市",
"861863414", "河北省邯郸市",
"86138989", "辽宁省葫芦岛市",
"861399747", "青海省海西蒙古族藏族自治州",
"861898542", "贵州省黔西南布依族苗族自治州",
"861355849", "广西北海市",
"86150403", "辽宁省沈阳市",
"861569462", "云南省丽江市",
"861570888", "云南省丽江市",
"861361983", "河南省安阳市",
"861331974", "新疆伊犁哈萨克自治州",
"861330475", "内蒙古通辽市",
"86139554", "安徽省淮南市",
"861778128", "四川省南充市",
"861374802", "内蒙古包头市",
"861576710", "广东省湛江市",
"861364699", "福建省莆田市",
"861500450", "黑龙江省哈尔滨市",
"861893673", "江苏省连云港市",
"861760435", "吉林省通化市",
"861317186", "河北省邯郸市",
"861874076", "陕西省汉中市",
"86138327", "河北省沧州市",
"86157528", "云南省大理白族自治州",
"861586921", "浙江省丽水市",
"861878428", "四川省南充市",
"861527642", "新疆昌吉回族自治州",
"861332736", "湖南省常德市",
"861812188", "四川省成都市",
"861567652", "广西百色市",
"861597301", "湖南省岳阳市",
"861328748", "山东省潍坊市",
"861802118", "江苏省无锡市",
"861880154", "江苏省苏州市",
"861336454", "吉林省长春市",
"861890612", "江苏省常州市",
"861818693", "湖北省武汉市",
"861369730", "湖北省荆州市",
"861324510", "内蒙古呼和浩特市",
"861327618", "江苏省镇江市",
"861340354", "山西省晋中市",
"861315300", "山东省济南市",
"861846382", "山东省德州市",
"861830538", "山东省泰安市",
"861575204", "云南省昆明市",
"861885137", "江苏省宿迁市",
"861877012", "江西省鹰潭市",
"861310946", "甘肃省天水市",
"861814396", "河南省驻马店市",
"861345337", "山西省运城市",
"861519642", "四川省乐山市",
"861309688", "贵州省六盘水市",
"861533420", "湖北省仙桃市",
"861304172", "江苏省常州市",
"861316399", "福建省厦门市",
"861319618", "吉林省通化市",
"861829905", "新疆吐鲁番地区",
"861830718", "湖北省恩施土家族苗族自治州",
"861372114", "安徽省淮南市",
"861390379", "河南省洛阳市",
"861576956", "宁夏中卫市",
"861365362", "山西省大同市",
"86138268", "广东省云浮市",
"861338301", "河北省石家庄市",
"861859463", "福建省漳州市",
"861593040", "河北省邯郸市",
"861450996", "新疆巴音郭楞蒙古自治州",
"861308424", "河南省开封市",
"861869381", "甘肃省天水市",
"861323953", "宁夏吴忠市",
"861878431", "四川省内江市",
"861363943", "山东省济宁市",
"861590841", "四川省资阳市",
"861833348", "河北省邢台市",
"86180886", "吉林省长春市",
"86187960", "江苏省镇江市",
"861332516", "山东省烟台市",
"861454469", "陕西省榆林市",
"861700147", "江苏省南通市",
"861884692", "黑龙江省哈尔滨市",
"861509022", "河南省濮阳市",
"86183725", "湖北省恩施土家族苗族自治州",
"861318244", "江苏省泰州市",
"861572639", "山东省青岛市",
"861816564", "广东省江门市",
"861830521", "江苏省徐州市",
"86188911", "陕西省延安市",
"861457036", "广东省江门市",
"861369510", "广东省揭阳市",
"861776677", "四川省成都市",
"861373776", "广西钦州市",
"861528488", "四川省广元市",
"861311595", "福建省泉州市",
"86182522", "江苏省盐城市",
"861805010", "福建省厦门市",
"861571476", "内蒙古赤峰市",
"861329699", "内蒙古巴彦淖尔市",
"861531210", "江苏省连云港市",
"861815080", "福建省福州市",
"86136823", "广东省深圳市",
"861832993", "陕西省西安市",
"861539617", "福建省三明市",
"861596601", "山东省泰安市",
"861362398", "河南省三门峡市",
"86156852", "贵州省遵义市",
"86131287", "广东省深圳市",
"861894480", "江苏省泰州市",
"861530361", "黑龙江省哈尔滨市",
"861768203", "安徽省六安市",
"861560978", "青海省西宁市",
"861320638", "山东省青岛市",
"861341579", "广东省肇庆市",
"861599487", "广东省江门市",
"861871861", "广东省揭阳市",
"861550474", "内蒙古乌兰察布市",
"861317699", "山东省临沂市",
"861458539", "河南省漯河市",
"861867115", "湖北省咸宁市",
"861839234", "陕西省渭南市",
"861593202", "河北省保定市",
"861778131", "四川省甘孜藏族自治州",
"861847682", "广东省湛江市",
"861519400", "山东省聊城市",
"861877992", "江西省萍乡市",
"861459141", "广西百色市",
"861376220", "湖南省湘潭市",
"861824667", "黑龙江省大庆市",
"861383446", "山西省运城市",
"861811202", "江苏省徐州市",
"861354726", "四川省达州市",
"861894178", "辽宁省葫芦岛市",
"861529660", "山西省忻州市",
"861367261", "广东省云浮市",
"861867273", "湖北省随州市",
"861895673", "安徽省阜阳市",
"861705569", "云南省昆明市",
"861576906", "新疆伊犁哈萨克自治州",
"86138527", "江苏省扬州市",
"861398165", "四川省巴中市",
"861825030", "福建省福州市",
"861521267", "安徽省淮南市",
"861709937", "浙江省丽水市",
"861306338", "安徽省阜阳市",
"861597437", "湖南省株洲市",
"86187965", "江苏省盐城市",
"861884934", "河北省承德市",
"861864955", "山西省长治市",
"86139354", "山西省晋中市",
"86155894", "山东省菏泽市",
"861323903", "新疆石河子市",
"861824945", "黑龙江省哈尔滨市",
"861856729", "河南省南阳市",
"861338351", "山西省太原市",
"861556405", "山东省滨州市",
"861366838", "四川省达州市",
"861362635", "山东省聊城市",
"861522975", "陕西省延安市",
"86183720", "湖北省武汉市",
"861331058", "湖北省荆州市",
"861866628", "广东省深圳市",
"861839412", "甘肃省甘南藏族自治州",
"86182141", "云南省玉溪市",
"861514568", "黑龙江省黑河市",
"8614767", "广东省广州市",
"861345401", "浙江省衢州市",
"861301153", "河北省邯郸市",
"861888272", "四川省自贡市",
"861778196", "四川省达州市",
"861500642", "山东省青岛市",
"861310688", "广东省东莞市",
"861473660", "云南省红河哈尼族彝族自治州",
"861843267", "河北省沧州市",
"861858995", "广西柳州市",
"861861781", "河北省秦皇岛市",
"861331764", "广西梧州市",
"86187746", "湖南省永州市",
"861535420", "河北省邯郸市",
"861475624", "河北省保定市",
"861802049", "江苏省镇江市",
"86137603", "广东省深圳市",
"86139731", "湖南省长沙市",
"861320116", "新疆阿克苏地区",
"861878496", "四川省自贡市",
"861380878", "云南省德宏傣族景颇族自治州",
"861313300", "山西省太原市",
"861889490", "河北省秦皇岛市",
"861803990", "河南省许昌市",
"861811040", "安徽省合肥市",
"861535679", "浙江省金华市",
"861583529", "山西省运城市",
"861314780", "辽宁省沈阳市",
"861587015", "贵州省安顺市",
"86134171", "广东省汕头市",
"861586089", "福建省三明市",
"861308548", "湖南省娄底市",
"86157328", "河北省衡水市",
"861508512", "贵州省遵义市",
"861457091", "江苏省淮安市",
"861814328", "西藏拉萨市",
"861776003", "四川省成都市",
"861304710", "湖北省荆州市",
"86187547", "山东省济宁市",
"861358105", "山东省临沂市",
"861302058", "山东省聊城市",
"861776893", "江苏省宿迁市",
"861322520", "江苏省连云港市",
"861361940", "云南省德宏傣族景颇族自治州",
"861305833", "广东省佛山市",
"861321950", "四川省宜宾市",
"861760522", "江苏省泰州市",
"861708076", "湖南省岳阳市",
"861778185", "四川省广元市",
"861800590", "福建省福州市",
"861332153", "吉林省通化市",
"861800901", "四川省凉山彝族自治州",
"861700779", "广东省东莞市",
"861350923", "广东省东莞市",
"861899453", "江苏省连云港市",
"861512971", "陕西省榆林市",
"861319703", "湖北省黄石市",
"861528563", "贵州省贵阳市",
"86155361", "山西省长治市",
"861310391", "河南省焦作市",
"861835938", "福建省宁德市",
"861537669", "山东省潍坊市",
"86134713", "广西桂林市",
"861365333", "河北省邢台市",
"861570825", "四川省遂宁市",
"86188733", "湖南省株洲市",
"861893219", "湖南省怀化市",
"861881704", "湖南省岳阳市",
"861831325", "云南省普洱市",
"861557687", "湖南省张家界市",
"861365271", "广东省江门市",
"861326470", "湖北省武汉市",
"86137235", "广东省东莞市",
"861311353", "内蒙古鄂尔多斯市",
"86138726", "湖北省宜昌市",
"861807790", "广西玉林市",
"86791", "江西省南昌市",
"861478142", "四川省宜宾市",
"861341987", "河南省新乡市",
"861355174", "四川省攀枝花市",
"861876944", "山东省烟台市",
"861379290", "山东省青岛市",
"861873439", "山西省忻州市",
"861309625", "四川省眉山市",
"861333309", "河北省邢台市",
"86139094", "甘肃省兰州市",
"86189439", "吉林省长春市",
"861302764", "河南省开封市",
"861459095", "广东省茂名市",
"861858986", "广西柳州市",
"861515670", "安徽省马鞍山市",
"861394914", "河南省郑州市",
"861772980", "四川省泸州市",
"861334789", "江苏省常州市",
"861320503", "福建省福州市",
"861869335", "甘肃省天水市",
"861370071", "河南省安阳市",
"861889354", "甘肃省武威市",
"861314055", "河南省濮阳市",
"861505249", "江苏省连云港市",
"861539459", "福建省三明市",
"861847403", "湖南省常德市",
"861354767", "四川省眉山市",
"861807056", "江西省吉安市",
"861301516", "内蒙古包头市",
"861357475", "湖南省岳阳市",
"86152202", "广东省深圳市",
"861321591", "福建省厦门市",
"861514483", "内蒙古通辽市",
"861889547", "安徽省宿州市",
"861319753", "广西贺州市",
"861364316", "河北省廊坊市",
"861800951", "宁夏银川市",
"861850738", "湖南省娄底市",
"861360829", "四川省宜宾市",
"861860639", "山东省临沂市",
"861375927", "云南省西双版纳傣族自治州",
"861335723", "湖南省湘西土家族苗族自治州",
"861346892", "陕西省西安市",
"861450985", "新疆阿勒泰地区",
"86170585", "北京市",
"861367743", "湖南省邵阳市",
"86188574", "浙江省宁波市",
"86136217", "上海市",
"861352536", "河南省平顶山市",
"86170771", "江西省南昌市",
"861559637", "陕西省商洛市",
"861354820", "四川省攀枝花市",
"861362681", "浙江省宁波市",
"861311303", "河北省石家庄市",
"86183243", "浙江省嘉兴市",
"86139913", "陕西省西安市",
"861855067", "江苏省盐城市",
"861374912", "河南省开封市",
"861857482", "湖南省娄底市",
"861300045", "北京市",
"861804689", "江西省鹰潭市",
"861367372", "河南省安阳市",
"861333359", "山西省运城市",
"861331898", "广东省珠海市",
"861814619", "福建省南平市",
"861560797", "江西省赣州市",
"86170864", "江苏省无锡市",
"861320553", "安徽省芜湖市",
"861310336", "河北省廊坊市",
"861334598", "浙江省宁波市",
"861337690", "福建省漳州市",
"861372384", "湖南省衡阳市",
"86853", "贵州省安顺市",
"861360543", "山东省滨州市",
"861352950", "云南省楚雄彝族自治州",
"861896942", "浙江省宁波市",
"861886420", "河南省漯河市",
"861813043", "安徽省安庆市",
"861539409", "甘肃省武威市",
"861889304", "甘肃省白银市",
"861351520", "江苏省南通市",
"861888840", "广西钦州市",
"861599124", "陕西省咸阳市",
"861879846", "贵州省六盘水市",
"86153286", "四川省乐山市",
"861310371", "河南省郑州市",
"861708750", "江西省抚州市",
"861588754", "云南省德宏傣族景颇族自治州",
"86185951", "宁夏银川市",
"861378492", "河北省邢台市",
"861501509", "广东省韶关市",
"861522986", "陕西省安康市",
"861899819", "广东省珠海市",
"86187549", "山东省临沂市",
"86170706", "辽宁省鞍山市",
"861776873", "江苏省泰州市",
"86181412", "辽宁省鞍山市",
"861512991", "陕西省渭南市",
"861800570", "浙江省衢州市",
"861700799", "江西省南昌市",
"861303365", "浙江省台州市",
"86131205", "上海市",
"861883442", "山西省忻州市",
"861820960", "宁夏银川市",
"86130613", "山东省青岛市",
"861372247", "河北省沧州市",
"861893920", "河南省南阳市",
"861459075", "广东省揭阳市",
"861471826", "广东省揭阳市",
"86189437", "吉林省延边朝鲜族自治州",
"86177519", "江苏省徐州市",
"861361489", "内蒙古锡林郭勒盟",
"861857857", "广东省汕尾市",
"861516609", "山东省滨州市",
"861590982", "辽宁省沈阳市",
"861370091", "四川省德阳市",
"861510523", "江苏省淮安市",
"861885650", "安徽省芜湖市",
"861555946", "新疆阿克苏地区",
"861707599", "福建省莆田市",
"861807770", "广西钦州市",
"861339416", "辽宁省锦州市",
"861365291", "广东省佛山市",
"861318117", "山东省日照市",
"861326490", "湖北省宜昌市",
"861308187", "河北省秦皇岛市",
"861808289", "新疆乌鲁木齐市",
"861362410", "辽宁省铁岭市",
"861377931", "新疆巴音郭楞蒙古自治州",
"861355194", "四川省广元市",
"861809942", "新疆伊犁哈萨克自治州",
"861374305", "广东省深圳市",
"861708700", "广西南宁市",
"861834435", "广东省惠州市",
"861564359", "吉林省吉林市",
"861524349", "河北省秦皇岛市",
"861380058", "浙江省杭州市",
"861344009", "四川省宜宾市",
"861379981", "福建省漳州市",
"861533195", "黑龙江省绥化市",
"861324871", "浙江省宁波市",
"86136219", "上海市",
"861824863", "浙江省绍兴市",
"861378739", "湖南省邵阳市",
"861538325", "河北省唐山市",
"861806453", "福建省三明市",
"861573869", "河南省许昌市",
"861830917", "陕西省宝鸡市",
"861370036", "河北省廊坊市",
"861775410", "安徽省阜阳市",
"861577144", "内蒙古乌兰察布市",
"861454773", "山东省济南市",
"861504859", "内蒙古巴彦淖尔市",
"861511774", "贵州省铜仁地区",
"86131200", "北京市",
"861511920", "广东省韶关市",
"861700432", "吉林省吉林市",
"861700588", "浙江省温州市",
"86158878", "云南省昆明市",
"861337670", "广东省湛江市",
"861847819", "湖南省益阳市",
"861872998", "陕西省西安市",
"861571485", "内蒙古通辽市",
"861533316", "河北省廊坊市",
"861334578", "浙江省丽水市",
"861453576", "福建省漳州市",
"861524025", "江苏省淮安市",
"861301961", "辽宁省鞍山市",
"861454342", "山东省青岛市",
"861558399", "四川省眉山市",
"861764538", "黑龙江省鹤岗市",
"861313474", "内蒙古兴安盟",
"861530746", "湖南省永州市",
"861538049", "江苏省常州市",
"861857807", "广东省肇庆市",
"861367392", "河南省鹤壁市",
"861805866", "浙江省绍兴市",
"861394958", "河南省驻马店市",
"861550350", "山西省忻州市",
"861853537", "山西省朔州市",
"861512936", "陕西省西安市",
"861560777", "广西钦州市",
"861365449", "吉林省吉林市",
"861880325", "河北省唐山市",
"86157783", "广西南宁市",
"861335660", "山东省东营市",
"861830704", "江西省抚州市",
"861850937", "甘肃省酒泉市",
"861587765", "陕西省西安市",
"861884672", "黑龙江省鸡西市",
"861340125", "江苏省盐城市",
"861867376", "湖南省常德市",
"861311575", "浙江省绍兴市",
"861592979", "陕西省榆林市",
"861562713", "广东省惠州市",
"861373796", "广西河池市",
"861889188", "陕西省渭南市",
"861777406", "浙江省金华市",
"861377985", "新疆昌吉回族自治州",
"861810332", "河北省保定市",
"861813211", "河北省石家庄市",
"861857097", "湖南省湘潭市",
"861373050", "河北省唐山市",
"861300654", "山东省东营市",
"861894949", "安徽省滁州市",
"861390399", "河南省许昌市",
"861533186", "黑龙江省牡丹江市",
"861370851", "贵州省遵义市",
"86157350", "山西省太原市",
"861366557", "安徽省宿州市",
"861307002", "新疆阿克苏地区",
"861518202", "四川省广安市",
"861778952", "甘肃省定西市",
"861328169", "四川省雅安市",
"861825448", "山东省枣庄市",
"861531929", "陕西省汉中市",
"861853078", "河南省商丘市",
"861450976", "新疆和田地区",
"861370145", "江苏省南京市",
"861329420", "湖北省荆州市",
"861879740", "湖南省湘潭市",
"861560998", "新疆喀什地区",
"861317679", "山东省济宁市",
"861550494", "辽宁省大连市",
"86131289", "广东省深圳市",
"861534943", "甘肃省白银市",
"861326304", "江西省上饶市",
"861580565", "安徽省合肥市",
"861811438", "江苏省南通市",
"86186290", "陕西省西安市",
"861891923", "甘肃省天水市",
"861811582", "江苏省南通市",
"861328337", "河北省承德市",
"861302878", "甘肃省临夏回族自治州",
"861553336", "河北省石家庄市",
"861509651", "云南省文山壮族苗族自治州",
"861571496", "新疆昌吉回族自治州",
"861569939", "新疆伊犁哈萨克自治州",
"861329679", "浙江省嘉兴市",
"861814882", "广东省珠海市",
"861317420", "湖南省怀化市",
"861362378", "河南省开封市",
"861872777", "湖北省咸宁市",
"861344899", "新疆乌鲁木齐市",
"861568781", "云南省楚雄彝族自治州",
"861332961", "贵州省贵阳市",
"861333624", "山东省威海市",
"861804812", "四川省乐山市",
"86183758", "重庆市",
"86130068", "广东省东莞市",
"861874028", "辽宁省大连市",
"86156136", "河北省廊坊市",
"861372158", "贵州省毕节地区",
"861576192", "贵州省贵阳市",
"861787582", "广东省深圳市",
"86183953", "安徽省宣城市",
"861830754", "广东省汕头市",
"861509174", "陕西省榆林市",
"861474567", "黑龙江省七台河市",
"861821488", "安徽省合肥市",
"861522995", "陕西省宝鸡市",
"861472791", "陕西省延安市",
"861308317", "安徽省安庆市",
"861569088", "河南省郑州市",
"861778176", "四川省甘孜藏族自治州",
"861700463", "上海市",
"86131061", "浙江省温州市",
"861888292", "四川省阿坝藏族羌族自治州",
"86185598", "福建省福州市",
"86157355", "山西省长治市",
"861571431", "吉林省长春市",
"86138529", "江苏省镇江市",
"861589243", "四川省南充市",
"861554140", "辽宁省本溪市",
"86150186", "广东省惠州市",
"861346621", "云南省昭通市",
"861368534", "山东省德州市",
"86131633", "湖北省武汉市",
"861890520", "江苏省徐州市",
"861336782", "广西柳州市",
"861778902", "西藏日喀则地区",
"861320375", "河南省南阳市",
"861865408", "安徽省宿州市",
"861855904", "福建省龙岩市",
"861478437", "河南省开封市",
"861326354", "黑龙江省哈尔滨市",
"861560149", "江苏省常州市",
"861373242", "浙江省金华市",
"861882447", "广东省梅州市",
"861366344", "山西省晋中市",
"861780782", "广西柳州市",
"861389839", "辽宁省锦州市",
"86186152", "山东省济南市",
"86181626", "湖北省武汉市",
"861803724", "河南省周口市",
"861579804", "江西省抚州市",
"86150843", "重庆市",
"86186295", "陕西省西安市",
"861762511", "江苏省镇江市",
"8613712", "广东省东莞市",
"861887138", "湖北省武汉市",
"861834481", "江苏省镇江市",
"861364464", "黑龙江省哈尔滨市",
"861354968", "湖南省长沙市",
"861523320", "河北省邯郸市",
"861376641", "江西省宜春市",
"861768306", "四川省甘孜藏族自治州",
"861830068", "河南省郑州市",
"861347338", "河北省石家庄市",
"861516417", "辽宁省锦州市",
"86157988", "云南省昆明市",
"861380898", "山东省青岛市",
"861300171", "山东省济南市",
"861812490", "广东省广州市",
"861331632", "广东省佛山市",
"861329464", "山西省晋城市",
"861570322", "河北省保定市",
"861566095", "河南省信阳市",
"861863458", "山西省吕梁市",
"861328401", "黑龙江省哈尔滨市",
"861831822", "广东省清远市",
"861394818", "内蒙古巴彦淖尔市",
"86156997", "北京市",
"861868197", "陕西省咸阳市",
"861478351", "河南省焦作市",
"86157550", "安徽省滁州市",
"861306747", "福建省泉州市",
"861816034", "新疆伊犁哈萨克自治州",
"86181782", "广西柳州市",
"861341412", "广东省广州市",
"861332771", "江苏省南京市",
"861317464", "河南省信阳市",
"861880691", "云南省西双版纳傣族自治州",
"861538388", "河北省秦皇岛市",
"861801499", "江苏省镇江市",
"861872645", "安徽省芜湖市",
"861834522", "黑龙江省鸡西市",
"861528062", "福建省漳州市",
"861335624", "山东省滨州市",
"861536442", "湖南省湘西土家族苗族自治州",
"86139125", "江苏省盐城市",
"861576060", "四川省广元市",
"861899909", "新疆喀什地区",
"861368714", "湖北省咸宁市",
"861870562", "安徽省铜陵市",
"86182605", "江苏省南通市",
"861874031", "陕西省延安市",
"861340318", "河北省衡水市",
"861869832", "福建省漳州市",
"861802154", "江苏省南京市",
"861558138", "湖南省永州市",
"861514989", "内蒙古通辽市",
"861336418", "辽宁省阜新市",
"861369622", "四川省南充市",
"861396688", "安徽省亳州市",
"861458069", "浙江省绍兴市",
"861555336", "山东省滨州市",
"861454694", "广东省佛山市",
"861534362", "甘肃省兰州市",
"861577879", "广西玉林市",
"861830857", "贵州省毕节地区",
"861571428", "辽宁省葫芦岛市",
"861571357", "山西省临汾市",
"861342835", "广东省佛山市",
"861811421", "江苏省南通市",
"861524939", "甘肃省天水市",
"861364679", "浙江省金华市",
"861368441", "四川省内江市",
"861346395", "河北省石家庄市",
"86184822", "四川省成都市",
"861863408", "河北省衡水市",
"861328451", "黑龙江省哈尔滨市",
"861802671", "广东省揭阳市",
"861571544", "山东省德州市",
"861330495", "辽宁省丹东市",
"861803760", "河南省信阳市",
"86138329", "河北省唐山市",
"861508620", "贵州省黔东南苗族侗族自治州",
"861595438", "山东省临沂市",
"86157555", "安徽省马鞍山市",
"861874096", "甘肃省庆阳市",
"861866676", "广东省云浮市",
"861852712", "湖北省荆州市",
"861550546", "山东省东营市",
"861847909", "江西省抚州市",
"861535041", "江西省南昌市",
"861364420", "辽宁省鞍山市",
"861590324", "河北省承德市",
"861319171", "河北省邯郸市",
"86152476", "内蒙古赤峰市",
"861553625", "山西省运城市",
"861331994", "新疆昌吉回族自治州",
"861858765", "广西南宁市",
"861504641", "黑龙江省七台河市",
"861507159", "湖北省十堰市",
"861801241", "江苏省南通市",
"861580423", "辽宁省辽阳市",
"86137656", "贵州省铜仁地区",
"861899959", "新疆伊犁哈萨克自治州",
"861350429", "辽宁省葫芦岛市",
"861814376", "甘肃省兰州市",
"86187824", "四川省成都市",
"861360042", "广东省深圳市",
"86158614", "江苏省无锡市",
"861327604", "福建省福州市",
"861454932", "江苏省连云港市",
"86182600", "江苏省南京市",
"861813542", "山西省吕梁市",
"861350670", "浙江省衢州市",
"861380826", "四川省遂宁市",
"861391284", "江苏省镇江市",
"861558616", "湖北省荆门市",
"86181211", "上海市",
"861880636", "山东省潍坊市",
"861319604", "吉林省长春市",
"861890564", "安徽省六安市",
"861818673", "湖北省武汉市",
"861318661", "江苏省连云港市",
"86180218", "江苏省盐城市",
"861315165", "江苏省苏州市",
"861805970", "福建省福州市",
"861571307", "河北省沧州市",
"861830807", "西藏阿里地区",
"861560874", "云南省曲靖市",
"861530883", "云南省临沧市",
"86181238", "广东省深圳市",
"86185778", "广西南宁市",
"861397049", "江西省新余市",
"861399948", "新疆塔城地区",
"86170920", "广东省广州市",
"861354997", "广东省佛山市",
"861452134", "河北省沧州市",
"861528033", "福建省宁德市",
"861390616", "江苏省无锡市",
"861302994", "黑龙江省黑河市",
"861566141", "内蒙古赤峰市",
"86187349", "山西省朔州市",
"861820770", "广西防城港市",
"861894339", "吉林省松原市",
"861534271", "湖北省十堰市",
"861365865", "山东省青岛市",
"861857704", "广西南宁市",
"861768540", "山东省济南市",
"861475723", "浙江省金华市",
"861330486", "黑龙江省大庆市",
"861500374", "河南省许昌市",
"861831671", "广东省揭阳市",
"861589280", "四川省乐山市",
"861318455", "江西省萍乡市",
"861371745", "广东省佛山市",
"86186281", "四川省成都市",
"861370649", "山东省威海市",
"861898705", "云南省昆明市",
"861396336", "山东省东营市",
"861581687", "广东省深圳市",
"861317175", "河北省邢台市",
"861598429", "四川省内江市",
"861521709", "广东省东莞市",
"861459352", "贵州省遵义市",
"86135126", "黑龙江省佳木斯市",
"861325161", "黑龙江省哈尔滨市",
"861824678", "黑龙江省大庆市",
"861509849", "山东省烟台市",
"861534333", "湖南省株洲市",
"861321066", "山东省临沂市",
"861323409", "辽宁省大连市",
"861521278", "安徽省合肥市",
"861328665", "广东省深圳市",
"86138844", "浙江省宁波市",
"86183118", "贵州省铜仁地区",
"861328947", "陕西省榆林市",
"861471898", "西藏拉萨市",
"861474598", "黑龙江省大庆市",
"861322612", "广东省潮州市",
"861529359", "甘肃省天水市",
"861347199", "广西梧州市",
"861890889", "云南省昆明市",
"861805235", "江苏省淮安市",
"861807112", "湖北省武汉市",
"861819570", "青海省海东地区",
"861376809", "广西北海市",
"861346503", "山东省菏泽市",
"861538636", "湖南省常德市",
"86158702", "贵州省黔东南苗族侗族自治州",
"861366692", "福建省莆田市",
"861817182", "湖北省荆州市",
"86177319", "河北省邢台市",
"861374072", "湖北省武汉市",
"861526845", "浙江省绍兴市",
"861340629", "山东省济宁市",
"861843278", "河北省衡水市",
"861840839", "四川省甘孜藏族自治州",
"861870533", "山东省淄博市",
"861850504", "福建省宁德市",
"861819132", "陕西省西安市",
"86170925", "江苏省南京市",
"861832499", "安徽省安庆市",
"861301771", "浙江省绍兴市",
"861381475", "江苏省常州市",
"861773410", "河北省邯郸市",
"861871930", "广东省云浮市",
"861566086", "河南省新乡市",
"861708916", "陕西省榆林市",
"861560967", "安徽省亳州市",
"8615840", "辽宁省沈阳市",
"861377928", "新疆和田地区",
"861380720", "湖北省宜昌市",
"861521759", "广东省惠州市",
"861459302", "四川省自贡市",
"861380974", "广东省河源市",
"861502081", "山东省泰安市",
"861538691", "山西省朔州市",
"861880388", "河南省商丘市",
"861898755", "云南省昆明市",
"861557840", "广西梧州市",
"861340188", "江苏省宿迁市",
"86132226", "江苏省镇江市",
"861560645", "山东省烟台市",
"861561749", "河南省许昌市",
"861370911", "陕西省西安市",
"861852425", "辽宁省丹东市",
"861323459", "黑龙江省大庆市",
"861589971", "广东省江门市",
"861587230", "湖北省襄樊市",
"861363449", "吉林省白山市",
"861881538", "山东省泰安市",
"861818897", "湖南省衡阳市",
"861879783", "江西省上饶市",
"861534980", "安徽省安庆市",
"861871556", "安徽省安庆市",
"861379345", "山东省德州市",
"861474789", "内蒙古呼和浩特市",
"861347948", "江西省赣州市",
"861529309", "甘肃省张掖市",
"861315474", "内蒙古乌兰察布市",
"861850554", "安徽省淮南市",
"86185973", "重庆市",
"861555129", "安徽省淮南市",
"861535316", "陕西省榆林市",
"861454963", "黑龙江省七台河市",
"86186712", "湖北省孝感市",
"861562608", "广东省韶关市",
"861772865", "广东省河源市",
"861863366", "河北省邯郸市",
"861376859", "广西南宁市",
"86158980", "辽宁省铁岭市",
"861325187", "吉林省辽源市",
"861567086", "河南省焦作市",
"861571592", "福建省福州市",
"861340753", "江苏省徐州市",
"861376928", "云南省楚雄彝族自治州",
"861308409", "安徽省宣城市",
"861303665", "四川省达州市",
"861852436", "辽宁省丹东市",
"861472788", "陕西省渭南市",
"861821491", "江西省鹰潭市",
"861452477", "黑龙江省哈尔滨市",
"861770702", "江西省九江市",
"861801416", "江苏省淮安市",
"861531918", "陕西省宝鸡市",
"861553388", "河北省唐山市",
"861569091", "内蒙古呼和浩特市",
"861350782", "广西柳州市",
"861882839", "四川省乐山市",
"861898574", "贵州省安顺市",
"861478849", "河南省新乡市",
"861399503", "宁夏吴忠市",
"861331942", "江西省南昌市",
"861811486", "江苏省无锡市",
"86136995", "江西省南昌市",
"86159264", "湖北省武汉市",
"861861778", "河北省保定市",
"861533138", "四川省成都市",
"861820453", "黑龙江省牡丹江市",
"861346948", "湖南省娄底市",
"861474715", "内蒙古通辽市",
"861524911", "陕西省延安市",
"861519674", "四川省内江市",
"861705011", "广东省深圳市",
"86153222", "广东省广州市",
"861475659", "河北省秦皇岛市",
"86130011", "北京市",
"861342867", "广东省深圳市",
"861550600", "吉林省长春市",
"861341791", "广东省珠海市",
"861367934", "甘肃省庆阳市",
"861453087", "安徽省铜陵市",
"861879158", "陕西省安康市",
"861554279", "辽宁省盘锦市",
"861478523", "贵州省黔东南苗族侗族自治州",
"86189467", "吉林省长春市",
"86176257", "江苏省苏州市",
"861850775", "广西玉林市",
"861777502", "安徽省六安市",
"861347386", "河北省石家庄市",
"861392268", "广东省揭阳市",
"86182789", "广西北海市",
"861769933", "新疆乌鲁木齐市",
"861308459", "河北省承德市",
"861856704", "河南省开封市",
"86181327", "河北省保定市",
"861340703", "江西省上饶市",
"861583347", "河北省唐山市",
"861815446", "湖北省孝感市",
"861887186", "湖北省武汉市",
"86158985", "湖南省湘潭市",
"861335982", "黑龙江省大庆市",
"861379777", "湖北省黄石市",
"861339973", "新疆塔城地区",
"861803298", "河北省唐山市",
"861838904", "西藏林芝地区",
"861869378", "甘肃省兰州市",
"86132013", "新疆乌鲁木齐市",
"861806960", "浙江省绍兴市",
"861594894", "吉林省白城市",
"861874019", "辽宁省阜新市",
"861535121", "四川省成都市",
"86185678", "河南省安阳市",
"861479013", "安徽省滁州市",
"86181989", "广东省广州市",
"861770752", "广东省惠州市",
"861557244", "湖北省恩施土家族苗族自治州",
"861458776", "湖南省湘西土家族苗族自治州",
"861538625", "湖南省怀化市",
"861300490", "福建省三明市",
"861321147", "广西贵港市",
"861821249", "贵州省铜仁地区",
"86136990", "四川省成都市",
"861527151", "湖北省宜昌市",
"861873643", "河南省漯河市",
"861809878", "安徽省六安市",
"861835975", "福建省福州市",
"861346199", "河南省鹤壁市",
"861536494", "山西省太原市",
"861890815", "四川省凉山彝族自治州",
"861707830", "云南省昭通市",
"861587517", "广东省阳江市",
"861806112", "江苏省徐州市",
"861521623", "江西省吉安市",
"861347503", "山东省菏泽市",
"861550650", "山东省聊城市",
"861567855", "广西贵港市",
"861475609", "河北省廊坊市",
"861345100", "湖北省鄂州市",
"861568798", "云南省普洱市",
"86158358", "山西省吕梁市",
"861815239", "宁夏中卫市",
"861315137", "江苏省连云港市",
"861388693", "湖北省荆门市",
"861767330", "湖南省郴州市",
"861892338", "广东省珠海市",
"861560981", "辽宁省沈阳市",
"861454642", "云南省普洱市",
"861310154", "黑龙江省黑河市",
"86189829", "四川省资阳市",
"861520072", "湖南省衡阳市",
"861777552", "四川省成都市",
"861533616", "陕西省宝鸡市",
"861337370", "河南省安阳市",
"861342974", "陕西省商洛市",
"861843623", "河南省焦作市",
"861583504", "山西省晋中市",
"861837965", "江西省抚州市",
"861865627", "安徽省蚌埠市",
"861580904", "新疆喀什地区",
"86132151", "广东省东莞市",
"861334251", "湖南省长沙市",
"861700591", "福建省福州市",
"861700900", "山西省太原市",
"861310822", "四川省德阳市",
"861810632", "山东省枣庄市",
"861772288", "广东省广州市",
"861300354", "江苏省淮安市",
"861566021", "湖南省岳阳市",
"861365514", "江苏省连云港市",
"861390699", "福建省泉州市",
"861398650", "湖北省孝感市",
"86158098", "辽宁省辽阳市",
"861335360", "河南省商丘市",
"861899828", "广东省茂名市",
"86132481", "上海市",
"861816312", "湖北省襄樊市",
"861320844", "黑龙江省大庆市",
"86159408", "辽宁省大连市",
"861333324", "河北省保定市",
"861569851", "山西省晋城市",
"861303401", "安徽省宿州市",
"861362678", "浙江省丽水市",
"861538946", "陕西省咸阳市",
"861529841", "江苏省无锡市",
"861350245", "广东省广州市",
"861515404", "山东省威海市",
"861329379", "山西省运城市",
"861314557", "安徽省宿州市",
"86132668", "广东省深圳市",
"861894135", "辽宁省大连市",
"861311857", "贵州省毕节地区",
"861593495", "内蒙古鄂尔多斯市",
"861872981", "陕西省延安市",
"86150541", "山东省济南市",
"861553636", "山西省晋中市",
"861809014", "四川省甘孜藏族自治州",
"861378596", "河北省邢台市",
"861361248", "广东省佛山市",
"86158714", "湖北省武汉市",
"86151548", "云南省普洱市",
"861857206", "湖北省襄樊市",
"861389590", "黑龙江省黑河市",
"86182700", "江西省赣州市",
"861580954", "宁夏固原市",
"861502918", "陕西省西安市",
"861560935", "甘肃省武威市",
"861320675", "黑龙江省哈尔滨市",
"861321779", "广西北海市",
"86131663", "上海市",
"861324322", "河南省濮阳市",
"861594768", "内蒙古乌兰察布市",
"861344956", "山东省德州市",
"861300304", "安徽省芜湖市",
"861330421", "辽宁省朝阳市",
"861811495", "江苏省连云港市",
"861512988", "陕西省西安市",
"861700950", "宁夏银川市",
"861869410", "甘肃省甘南藏族自治州",
"86136088", "云南省昆明市",
"861342826", "广东省江门市",
"861379149", "山东省菏泽市",
"861525664", "安徽省池州市",
"861889045", "湖南省邵阳市",
"861810994", "新疆昌吉回族自治州",
"861453472", "黑龙江省哈尔滨市",
"861308617", "江西省宜春市",
"86152543", "山东省滨州市",
"86130038", "福建省福州市",
"861555325", "山东省聊城市",
"861318687", "浙江省宁波市",
"861840811", "四川省成都市",
"861522089", "广东省中山市",
"861551938", "贵州省铜仁地区",
"86186426", "辽宁省大连市",
"86151144", "吉林省白城市",
"861572443", "辽宁省丹东市",
"861353142", "广东省佛山市",
"861363734", "湖南省衡阳市",
"861303451", "山东省淄博市",
"861569801", "山东省济南市",
"861479479", "内蒙古鄂尔多斯市",
"861450413", "辽宁省抚顺市",
"861576879", "广东省惠州市",
"861343862", "四川省广安市",
"861376341", "黑龙江省哈尔滨市",
"861700536", "山东省潍坊市",
"861500793", "江西省上饶市",
"86181905", "四川省宜宾市",
"861772837", "广东省中山市",
"861847828", "湖南省邵阳市",
"861889329", "甘肃省酒泉市",
"861508364", "江西省新余市",
"86183502", "福建省厦门市",
"861537442", "甘肃省定西市",
"861509301", "河南省南阳市",
"861452082", "安徽省蚌埠市",
"861510437", "吉林省辽源市",
"861311807", "四川省内江市",
"861504985", "内蒙古鄂尔多斯市",
"861325317", "河北省承德市",
"86182705", "江西省宜春市",
"861370088", "河南省郑州市",
"86180462", "福建省厦门市",
"86130483", "重庆市",
"861555049", "山东省临沂市",
"86135251", "河南省南阳市",
"861389951", "新疆石河子市",
"861586975", "湖南省益阳市",
"861523479", "山西省忻州市",
"861535399", "陕西省延安市",
"861874473", "贵州省安顺市",
"86158909", "河南省开封市",
"861830575", "浙江省绍兴市",
"861597022", "江西省吉安市",
"861571073", "广东省广州市",
"861866293", "江苏省南通市",
"861847831", "湖南省岳阳市",
"861893276", "河北省沧州市",
"861842049", "广东省河源市",
"86151207", "海南省海口市",
"861311704", "湖北省咸宁市",
"861337782", "湖北省十堰市",
"86135273", "重庆市",
"861521990", "广东省茂名市",
"861880391", "河南省焦作市",
"861538688", "山西省太原市",
"861891454", "江苏省泰州市",
"861306052", "广东省潮州市",
"861899896", "广东省汕头市",
"861890955", "宁夏中卫市",
"861598418", "四川省自贡市",
"861889703", "青海省西宁市",
"861352969", "云南省玉溪市",
"861348548", "山西省晋中市",
"86999", "新疆伊犁哈萨克自治州",
"861700716", "湖北省荆州市",
"861379926", "福建省厦门市",
"861332987", "湖北省襄樊市",
"861331332", "河北省保定市",
"861372783", "广东省茂名市",
"861568767", "云南省文山壮族苗族自治州",
"86132933", "河北省张家口市",
"861810014", "浙江省宁波市",
"861510351", "山西省太原市",
"861398442", "贵州省遵义市",
"861571657", "河南省信阳市",
"861588256", "四川省广安市",
"861809632", "四川省遂宁市",
"861870308", "新疆石河子市",
"861309822", "陕西省商洛市",
"86151348", "内蒙古鄂尔多斯市",
"861360707", "江西省赣州市",
"861377641", "江苏省南京市",
"861330438", "吉林省松原市",
"861319354", "河南省安阳市",
"861505062", "江苏省南通市",
"861896720", "浙江省舟山市",
"861346338", "河北省秦皇岛市",
"861330582", "浙江省湖州市",
"86145379", "新疆乌鲁木齐市",
"861831262", "广东省茂名市",
"861517417", "辽宁省丹东市",
"861760478", "内蒙古巴彦淖尔市",
"861511393", "广东省汕头市",
"861534662", "湖北省鄂州市",
"86182926", "陕西省汉中市",
"861555636", "安徽省阜阳市",
"861454394", "贵州省黔南布依族苗族自治州",
"861595495", "山东省烟台市",
"86150341", "山西省太原市",
"861340618", "山东省滨州市",
"86158991", "新疆乌鲁木齐市",
"861552551", "山西省晋城市",
"86137097", "青海省西宁市",
"861892199", "江苏省苏州市",
"861367344", "河南省周口市",
"861339499", "新疆伊犁哈萨克自治州",
"861305401", "湖南省郴州市",
"861855423", "山东省泰安市",
"86181726", "广西桂林市",
"861335324", "吉林省长春市",
"861390041", "辽宁省辽阳市",
"861803267", "河北省石家庄市",
"861303169", "山东省潍坊市",
"861534508", "福建省龙岩市",
"861881353", "广东省茂名市",
"861771976", "陕西省渭南市",
"861806876", "江苏省常州市",
"86131574", "浙江省宁波市",
"86153421", "天津市",
"861568820", "湖南省常德市",
"861845010", "福建省漳州市",
"861312570", "吉林省长春市",
"861530244", "广东省佛山市",
"861597194", "湖北省随州市",
"86180005", "四川省成都市",
"861862871", "吉林省松原市",
"861367557", "安徽省宿州市",
"86182419", "辽宁省辽阳市",
"861561541", "山东省济南市",
"861523664", "河南省新乡市",
"861521551", "安徽省合肥市",
"861304879", "河北省石家庄市",
"861378444", "河北省唐山市",
"861327547", "山东省济宁市",
"861311754", "湖南省衡阳市",
"861577024", "云南省怒江傈僳族自治州",
"861834467", "江苏省苏州市",
"861475105", "江苏省常州市",
"861709843", "浙江省金华市",
"86147943", "吉林省长春市",
"861301579", "福建省宁德市",
"861539460", "江苏省徐州市",
"861564841", "内蒙古巴彦淖尔市",
"861890905", "四川省内江市",
"861479664", "江西省吉安市",
"861773678", "河北省沧州市",
"861478601", "贵州省铜仁地区",
"861377919", "新疆和田地区",
"861319547", "安徽省淮南市",
"86189148", "江苏省徐州市",
"861364379", "河南省洛阳市",
"861322182", "浙江省杭州市",
"861509437", "江苏省扬州市",
"861871452", "黑龙江省齐齐哈尔市",
"861802371", "广东省清远市",
"861361722", "湖北省随州市",
"861380266", "广东省中山市",
"861818373", "云南省红河哈尼族彝族自治州",
"861318361", "四川省泸州市",
"861320747", "湖南省长沙市",
"861360757", "福建省漳州市",
"861512646", "云南省临沧市",
"861870427", "辽宁省盘锦市",
"86185814", "重庆市",
"861524145", "辽宁省大连市",
"861870358", "山西省吕梁市",
"861533399", "河南省许昌市",
"861571607", "福建省南平市",
"861566038", "新疆喀什地区",
"861474581", "黑龙江省哈尔滨市",
"861860480", "内蒙古呼伦贝尔市",
"86183302", "河北省保定市",
"861350370", "河南省商丘市",
"861594978", "山东省潍坊市",
"861558316", "四川省广元市",
"861538129", "浙江省湖州市",
"861880336", "河北省廊坊市",
"861321969", "四川省乐山市",
"86183658", "山东省聊城市",
"861339732", "湖南省湘潭市",
"861709529", "江苏省盐城市",
"861555118", "安徽省合肥市",
"861327304", "河南省开封市",
"861814676", "江西省吉安市",
"861306240", "福建省漳州市",
"861809994", "新疆昌吉回族自治州",
"861534558", "安徽省阜阳市",
"861886616", "山东省东营市",
"861311068", "福建省龙岩市",
"861339241", "广东省深圳市",
"861341103", "广东省佛山市",
"861365734", "湖南省衡阳市",
"861370349", "河南省洛阳市",
"861332579", "浙江省金华市",
"861874999", "河南省驻马店市",
"861555388", "山东省威海市",
"861780670", "广东省广州市",
"861881595", "福建省泉州市",
"861523993", "河南省商丘市",
"861340045", "河北省唐山市",
"861459652", "青海省海东地区",
"861888244", "四川省广元市",
"861524036", "江苏省盐城市",
"861386564", "安徽省六安市",
"861591239", "云南省玉溪市",
"86155423", "辽宁省大连市",
"861570871", "云南省昆明市",
"861514855", "内蒙古呼伦贝尔市",
"861536546", "江苏省连云港市",
"861780429", "辽宁省葫芦岛市",
"861305947", "广东省肇庆市",
"861390316", "河北省廊坊市",
"86135452", "湖北省武汉市",
"861519469", "河南省驻马店市",
"86180261", "广东省肇庆市",
"861334065", "四川省宜宾市",
"861598370", "四川省阿坝藏族羌族自治州",
"861587737", "陕西省宝鸡市",
"861309104", "河北省唐山市",
"861808173", "四川省攀枝花市",
"861558186", "山西省晋城市",
"861308161", "山东省烟台市",
"86181268", "广东省广州市",
"861305665", "四川省宜宾市",
"861884895", "河南省洛阳市",
"861850647", "山东省潍坊市",
"861841993", "甘肃省定西市",
"861538336", "河北省廊坊市",
"861585554", "安徽省阜阳市",
"861366392", "河南省鹤壁市",
"861370025", "陕西省安康市",
"861336429", "辽宁省葫芦岛市",
"861562427", "山东省德州市",
"861812171", "江苏省泰州市",
"861340329", "河北省邢台市",
"861518120", "四川省雅安市",
"861477390", "湖南省邵阳市",
"861708473", "内蒙古呼和浩特市",
"861322312", "河北省邯郸市",
"861840951", "宁夏银川市",
"861893505", "山西省临汾市",
"861760310", "河北省邯郸市",
"861705550", "上海市",
"86158154", "广东省惠州市",
"861572480", "江苏省镇江市",
"861834426", "广东省湛江市",
"86158484", "内蒙古乌兰察布市",
"861571419", "辽宁省辽阳市",
"861502858", "河北省秦皇岛市",
"861580814", "四川省雅安市",
"861337245", "浙江省宁波市",
"861343150", "广东省东莞市",
"861534633", "河南省濮阳市",
"861700810", "江苏省盐城市",
"861535138", "四川省成都市",
"861514141", "辽宁省本溪市",
"861580537", "山东省济宁市",
"861365225", "广东省珠海市",
"861359712", "广西柳州市",
"861328365", "山西省忻州市",
"861831233", "广东省茂名市",
"861454400", "福建省福州市",
"861538391", "河北省石家庄市",
"861880688", "浙江省丽水市",
"861520355", "山西省长治市",
"861459602", "宁夏石嘴山市",
"861560345", "山西省长治市",
"861558041", "湖南省郴州市",
"861313369", "江西省吉安市",
"861301987", "辽宁省阜新市",
"861452253", "浙江省绍兴市",
"86137357", "浙江省金华市",
"861533121", "河南省洛阳市",
"861471835", "广东省肇庆市",
"861812654", "广东省深圳市",
"861459568", "陕西省汉中市",
"861782027", "广东省揭阳市",
"861772225", "广东省揭阳市",
"861351312", "河北省保定市",
"861807403", "浙江省绍兴市",
"861551348", "山西省运城市",
"861333982", "湖北省襄樊市",
"861572178", "贵州省六盘水市",
"861813446", "河南省焦作市",
"861582694", "湖北省黄石市",
"861309154", "黑龙江省绥化市",
"861806770", "浙江省台州市",
"861818285", "黑龙江省绥化市",
"861500151", "新疆和田地区",
"861345833", "四川省巴中市",
"861339763", "湖南省湘西土家族苗族自治州",
"861705500", "广东省深圳市",
"861893555", "青海省西宁市",
"861840901", "新疆博尔塔拉蒙古自治州",
"861524091", "云南省临沧市",
"861808215", "江苏省盐城市",
"86132495", "广东省汕头市",
"861360914", "陕西省咸阳市",
"861350418", "辽宁省沈阳市",
"861361415", "辽宁省丹东市",
"861473609", "广西柳州市",
"86130713", "广东省东莞市",
"861319490", "四川省内江市",
"861478465", "黑龙江省绥化市",
"861813239", "河北省保定市",
"86182263", "安徽省阜阳市",
"86158558", "安徽省阜阳市",
"861810878", "云南省楚雄彝族自治州",
"861454450", "江西省鹰潭市",
"861458966", "广东省汕尾市",
"861575229", "云南省红河哈尼族彝族自治州",
"861800417", "辽宁省营口市",
"861366358", "山西省吕梁市",
"861310750", "青海省海东地区",
"861708371", "河南省郑州市",
"861894220", "江西省南昌市",
"861539965", "安徽省阜阳市",
"86139573", "浙江省嘉兴市",
"861532429", "河北省衡水市",
"861819155", "陕西省西安市",
"861805040", "福建省福州市",
"861531240", "江苏省南京市",
"86185244", "辽宁省沈阳市",
"861317936", "江苏省泰州市",
"861810487", "内蒙古巴彦淖尔市",
"86134578", "广西南宁市",
"861837548", "山东省泰安市",
"861532670", "内蒙古呼伦贝尔市",
"861396561", "安徽省马鞍山市",
"86150026", "甘肃省兰州市",
"86930", "甘肃省临夏回族自治州",
"861867145", "湖北省武汉市",
"861302655", "山东省潍坊市",
"861828475", "四川省遂宁市",
"86155447", "河北省邯郸市",
"861306858", "广东省河源市",
"861399537", "宁夏银川市",
"861785896", "浙江省金华市",
"861835125", "江苏省苏州市",
"861318799", "云南省怒江傈僳族自治州",
"86137932", "山东省青岛市",
"861520632", "山东省枣庄市",
"861533761", "浙江省杭州市",
"861459111", "广西来宾市",
"861840660", "广东省广州市",
"861338831", "四川省攀枝花市",
"861329936", "甘肃省武威市",
"861867851", "山东省聊城市",
"861518827", "河南省信阳市",
"861362577", "浙江省温州市",
"861372144", "河南省郑州市",
"861830748", "湖南省永州市",
"861351374", "河南省许昌市",
"861331461", "黑龙江省哈尔滨市",
"861861484", "内蒙古包头市",
"861831473", "湖北省黄石市",
"86151700", "江西省南昌市",
"861535971", "福建省宁德市",
"86130820", "河北省廊坊市",
"861317550", "浙江省金华市",
"861572996", "新疆昌吉回族自治州",
"861363913", "贵州省贵阳市",
"86182548", "山东省泰安市",
"861332546", "陕西省西安市",
"861370376", "河南省信阳市",
"861450639", "黑龙江省绥化市",
"861568166", "四川省巴中市",
"861328482", "内蒙古兴安盟",
"861476524", "山西省太原市",
"861507014", "江西省新余市",
"86156062", "江苏省苏州市",
"861316925", "广东省揭阳市",
"861328538", "山东省泰安市",
"861348775", "湖南省株洲市",
"861595551", "安徽省马鞍山市",
"861329550", "安徽省滁州市",
"861860985", "辽宁省大连市",
"861505868", "浙江省丽水市",
"86152900", "河南省周口市",
"861855199", "江苏省泰州市",
"861343857", "四川省达州市",
"861369540", "山东省菏泽市",
"861340737", "湖南省益阳市",
"861809593", "新疆伊犁哈萨克自治州",
"861890450", "黑龙江省哈尔滨市",
"861580872", "云南省大理白族自治州",
"861802019", "江苏省南通市",
"861520994", "新疆昌吉回族自治州",
"861310700", "湖南省株洲市",
"861769907", "新疆乌鲁木齐市",
"861366308", "河南省三门峡市",
"861592691", "湖北省黄石市",
"86139734", "湖南省衡阳市",
"86157342", "辽宁省鞍山市",
"861308721", "湖南省湘潭市",
"861858703", "云南省德宏傣族景颇族自治州",
"861572931", "河南省周口市",
"861360156", "江苏省苏州市",
"861359774", "湖北省黄石市",
"861390787", "广西钦州市",
"861306808", "山西省太原市",
"861869095", "新疆伊犁哈萨克自治州",
"861777526", "安徽省芜湖市",
"861302605", "安徽省淮北市",
"861535280", "内蒙古呼伦贝尔市",
"86186697", "山东省青岛市",
"86184408", "云南省昆明市",
"861308518", "湖北省荆门市",
"86134174", "广东省深圳市",
"86152682", "浙江省湖州市",
"86189403", "辽宁省抚顺市",
"861322374", "河南省新乡市",
"861521495", "新疆喀什地区",
"861459335", "四川省内江市",
"861304740", "山东省青岛市",
"861318432", "浙江省宁波市",
"861801080", "安徽省黄山市",
"861323795", "江西省宜春市",
"861820437", "吉林省辽源市",
"861383416", "山西省太原市",
"861311862", "广东省潮州市",
"86153671", "湖南省长沙市",
"861305595", "福建省泉州市",
"86139351", "山西省太原市",
"861506332", "山东省日照市",
"861315103", "江苏省无锡市",
"861317991", "新疆乌鲁木齐市",
"861538493", "新疆阿克苏地区",
"861813479", "河南省洛阳市",
"861347537", "山东省济宁市",
"86155891", "山东省德州市",
"86151705", "江西省宜春市",
"861805252", "江苏省常州市",
"861392142", "江苏省南京市",
"861839442", "甘肃省兰州市",
"86186145", "黑龙江省绥化市",
"861300648", "四川省绵阳市",
"861312723", "山东省枣庄市",
"861837424", "湖南省益阳市",
"861550771", "广西南宁市",
"86182144", "云南省曲靖市",
"861880769", "广东省东莞市",
"861596909", "云南省大理白族自治州",
"861310031", "湖南省长沙市",
"86152905", "河南省洛阳市",
"861314562", "安徽省铜陵市",
"861770726", "湖北省黄石市",
"861595990", "福建省南平市",
"861855948", "福建省泉州市",
"861813620", "江苏省泰州市",
"861500612", "江苏省常州市",
"861386694", "安徽省滁州市",
"861329500", "福建省泉州市",
"861778029", "四川省成都市",
"861768622", "山东省德州市",
"861770767", "广东省揭阳市",
"861869086", "新疆昌吉回族自治州",
"861330709", "江西省南昌市",
"861511491", "陕西省延安市",
"861347078", "安徽省阜阳市",
"861786278", "山东省日照市",
"861898763", "云南省文山壮族苗族自治州",
"861521486", "新疆伊犁哈萨克自治州",
"861520663", "山东省日照市",
"861860931", "甘肃省兰州市",
"861808690", "四川省南充市",
"86137639", "江西省赣州市",
"861356551", "新疆博尔塔拉蒙古自治州",
"861843486", "山西省运城市",
"861305303", "安徽省六安市",
"861881451", "黑龙江省哈尔滨市",
"861394944", "河南省开封市",
"861800659", "浙江省台州市",
"861890394", "河南省周口市",
"86188353", "山西省太原市",
"861515289", "江苏省南通市",
"861787623", "广东省河源市",
"861589041", "河南省南阳市",
"861321883", "江苏省南通市",
"861310856", "云南省大理白族自治州",
"861361910", "陕西省咸阳市",
"861380044", "吉林省通化市",
"861319995", "新疆吐鲁番地区",
"861817674", "广西河池市",
"86131607", "广东省惠州市",
"861880493", "内蒙古呼和浩特市",
"861454955", "江苏省徐州市",
"86155673", "吉林省吉林市",
"861324306", "河南省开封市",
"861775038", "福建省龙岩市",
"861338885", "云南省昆明市",
"861346565", "山东省潍坊市",
"861337509", "福建省龙岩市",
"861772853", "广东省江门市",
"861452825", "四川省遂宁市",
"861814911", "陕西省西安市",
"86155364", "山西省吕梁市",
"861556969", "甘肃省平凉市",
"861323786", "广西玉林市",
"861327995", "新疆吐鲁番地区",
"861893249", "湖南省永州市",
"861774923", "陕西省渭南市",
"861333839", "福建省龙岩市",
"861362989", "河南省周口市",
"861305586", "福建省龙岩市",
"861330278", "广东省梅州市",
"861576783", "广东省深圳市",
"861536987", "河北省衡水市",
"861538769", "四川省攀枝花市",
"861313791", "河南省焦作市",
"861587136", "湖北省武汉市",
"861850460", "黑龙江省哈尔滨市",
"86170774", "湖南省长沙市",
"861365853", "贵州省安顺市",
"86152989", "海南省海口市",
"861501670", "广东省深圳市",
"861325843", "四川省绵阳市",
"86188785", "广西玉林市",
"861512420", "辽宁省营口市",
"861362038", "广东省中山市",
"861300015", "山东省淄博市",
"861870392", "河南省鹤壁市",
"861338056", "广东省揭阳市",
"861814649", "新疆乌鲁木齐市",
"86170861", "山东省青岛市",
"861537961", "宁夏石嘴山市",
"861785885", "浙江省杭州市",
"86147927", "安徽省阜阳市",
"861318463", "江西省上饶市",
"861568127", "四川省攀枝花市",
"861817151", "湖北省武汉市",
"861771198", "西藏日喀则地区",
"861525446", "山东省东营市",
"861760887", "云南省迪庆藏族自治州",
"861800609", "福建省南平市",
"861881401", "广东省惠州市",
"861360513", "江苏省连云港市",
"86152327", "河北省唐山市",
"861457115", "湖北省鄂州市",
"86151789", "重庆市",
"861773021", "安徽省合肥市",
"861833188", "河北省邯郸市",
"861534592", "福建省厦门市",
"861313736", "河南省信阳市",
"861770820", "广东省汕头市",
"861869141", "陕西省商洛市",
"861338790", "江西省新余市",
"861355909", "福建省三明市",
"861587191", "湖北省武汉市",
"861582889", "四川省遂宁市",
"861325529", "江苏省南京市",
"861301546", "山西省长治市",
"861388712", "云南省昭通市",
"861889517", "宁夏银川市",
"861587618", "广东省汕头市",
"861584510", "黑龙江省哈尔滨市",
"861310806", "四川省泸州市",
"861363572", "湖北省十堰市",
"861889834", "广东省湛江市",
"861566863", "辽宁省锦州市",
"861459381", "贵州省六盘水市",
"861337559", "山东省淄博市",
"861860996", "新疆巴音郭楞蒙古自治州",
"861364346", "山西省太原市",
"861303729", "江西省九江市",
"861314533", "山东省淄博市",
"861810072", "湖北省武汉市",
"861806849", "江苏省徐州市",
"86137283", "广东省东莞市",
"86187262", "安徽省宿州市",
"861577108", "湖北省恩施土家族苗族自治州",
"861510403", "辽宁省沈阳市",
"861311833", "四川省凉山彝族自治州",
"861302461", "浙江省绍兴市",
"861771611", "四川省成都市",
"861328653", "广东省肇庆市",
"861514223", "辽宁省鞍山市",
"861367713", "湖北省黄冈市",
"861334377", "河南省南阳市",
"86145836", "山东省济南市",
"861366466", "黑龙江省大庆市",
"861572985", "四川省自贡市",
"861871498", "安徽省六安市",
"861893491", "广西贵港市",
"86188571", "浙江省杭州市",
"861861545", "山东省济南市",
"861858191", "四川省自贡市",
"861353959", "广东省珠海市",
"861566678", "山东省日照市",
"861598559", "贵州省六盘水市",
"861367533", "山东省淄博市",
"861303303", "安徽省芜湖市",
"861804345", "吉林省四平市",
"861300995", "黑龙江省鸡西市",
"861561069", "山东省泰安市",
"861309856", "贵州省铜仁地区",
"86152268", "河北省邢台市",
"861478770", "云南省文山壮族苗族自治州",
"86133387", "江苏省无锡市",
"86188553", "安徽省芜湖市",
"861317346", "山东省东营市",
"861304783", "广西贺州市",
"861316039", "江苏省南通市",
"861332350", "宁夏银川市",
"861813993", "甘肃省庆阳市",
"861595623", "安徽省池州市",
"861538979", "内蒙古锡林郭勒盟",
"861889737", "青海省玉树藏族自治州",
"861301494", "广西贺州市",
"861388488", "山东省临沂市",
"861584730", "内蒙古鄂尔多斯市",
"86155885", "山东省泰安市",
"861307035", "新疆伊犁哈萨克自治州",
"861814036", "四川省绵阳市",
"861556779", "吉林省松原市",
"861850548", "山东省泰安市",
"861321292", "黑龙江省哈尔滨市",
"861886761", "浙江省宁波市",
"861864845", "内蒙古兴安盟",
"861363803", "贵州省黔南布依族苗族自治州",
"861535243", "甘肃省临夏回族自治州",
"861590901", "新疆塔城地区",
"861835629", "安徽省铜陵市",
"861303586", "广东省阳江市",
"861335839", "福建省厦门市",
"861399904", "新疆吐鲁番地区",
"861453414", "辽宁省大连市",
"86150439", "吉林省白山市",
"861360733", "湖南省株洲市",
"861325786", "广西玉林市",
"861804029", "辽宁省朝阳市",
"861313516", "湖南省益阳市",
"861760784", "广西贺州市",
"861395147", "江苏省淮安市",
"861895249", "江苏省无锡市",
"861867649", "广东省珠海市",
"861302159", "山东省枣庄市",
"861770977", "青海省海西蒙古族藏族自治州",
"861362021", "广东省深圳市",
"861856862", "河南省三门峡市",
"861812348", "四川省雅安市",
"861361706", "江西省吉安市",
"86156489", "内蒙古乌兰察布市",
"861857748", "广西河池市",
"861597790", "广西河池市",
"86139998", "新疆乌鲁木齐市",
"861580638", "山东省烟台市",
"861705379", "吉林省长春市",
"861834683", "黑龙江省黑河市",
"861453741", "湖南省株洲市",
"861880587", "浙江省温州市",
"86137769", "江苏省南通市",
"861580395", "河南省漯河市",
"861771126", "四川省阿坝藏族羌族自治州",
"861530571", "浙江省杭州市",
"86137012", "北京市",
"861563456", "山东省潍坊市",
"86152527", "江苏省扬州市",
"86139793", "江西省上饶市",
"861450311", "河北省石家庄市",
"861303353", "江苏省徐州市",
"861459667", "新疆昌吉回族自治州",
"861810355", "山西省长治市",
"861332300", "河北省邯郸市",
"861557027", "江西省宜春市",
"861872430", "黑龙江省牡丹江市",
"861576846", "广东省惠州市",
"861831999", "广东省深圳市",
"861778935", "甘肃省武威市",
"861363853", "贵州省安顺市",
"861590951", "宁夏银川市",
"86155651", "河南省安阳市",
"861894413", "江苏省南京市",
"86155880", "山东省临沂市",
"861323843", "内蒙古呼和浩特市",
"86186857", "贵州省毕节地区",
"861306918", "吉林省吉林市",
"861330323", "河北省石家庄市",
"861520878", "云南省楚雄彝族自治州",
"861571633", "河南省安阳市",
"861860928", "陕西省西安市",
"861399954", "新疆昌吉回族自治州",
"86151263", "云南省红河哈尼族彝族自治州",
"86188371", "河南省郑州市",
"861324497", "广东省东莞市",
"86138499", "河南省洛阳市",
"86134014", "江苏省苏州市",
"861534419", "内蒙古锡林郭勒盟",
"861316988", "广东省中山市",
"861827609", "广西梧州市",
"861361090", "辽宁省铁岭市",
"86155168", "河南省驻马店市",
"861321746", "湖南省永州市",
"861824086", "陕西省汉中市",
"861339574", "浙江省宁波市",
"861891289", "江苏省南通市",
"861570606", "陕西省渭南市",
"861379902", "福建省三明市",
"861341137", "广东省珠海市",
"861769534", "宁夏吴忠市",
"861390569", "安徽省合肥市",
"861365572", "浙江省湖州市",
"861479239", "安徽省宿州市",
"861700661", "山东省青岛市",
"861326089", "湖南省邵阳市",
"861881337", "广东省茂名市",
"861882982", "陕西省榆林市",
"86133416", "上海市",
"861320929", "陕西省延安市",
"861814801", "四川省绵阳市",
"861897044", "江西省吉安市",
"861343704", "江西省抚州市",
"861558569", "吉林省通化市",
"86145067", "上海市",
"861834452", "广东省肇庆市",
"861301300", "安徽省滁州市",
"861871467", "黑龙江省鸡西市",
"861820351", "山西省太原市",
"861325880", "吉林省四平市",
"861582520", "云南省红河哈尼族彝族自治州",
"861452237", "浙江省嘉兴市",
"861802999", "广东省惠州市",
"86188410", "辽宁省铁岭市",
"861520014", "河北省邯郸市",
"861568702", "云南省昭通市",
"861771339", "黑龙江省大庆市",
"86133622", "浙江省湖州市",
"861581950", "广东省云浮市",
"861538587", "安徽省芜湖市",
"861364991", "新疆阿勒泰地区",
"861310028", "湖南省常德市",
"861560430", "吉林省长春市",
"861312309", "福建省龙岩市",
"861587703", "广西桂林市",
"86182207", "陕西省宝鸡市",
"861785828", "浙江省台州市",
"861394334", "吉林省通化市",
"861502283", "新疆博尔塔拉蒙古自治州",
"861476560", "湖北省武汉市",
"861879192", "陕西省榆林市",
"86153653", "江苏省苏州市",
"86139373", "河南省新乡市",
"86159886", "浙江省宁波市",
"861870644", "山东省临沂市",
"86157121", "广东省深圳市",
"861344384", "广西桂林市",
"86187461", "黑龙江省哈尔滨市",
"861811990", "安徽省宣城市",
"861367562", "安徽省合肥市",
"861844978", "新疆伊犁哈萨克自治州",
"86155809", "湖南省长沙市",
"861554439", "河南省南阳市",
"861824095", "新疆阿克苏地区",
"86139080", "四川省成都市",
"86159143", "广东省广州市",
"861894264", "河北省石家庄市",
"861507632", "河北省石家庄市",
"861571558", "安徽省阜阳市",
"861308738", "湖南省娄底市",
"861317011", "安徽省淮北市",
"861572928", "河南省周口市",
"861508211", "四川省资阳市",
"861809487", "新疆乌鲁木齐市",
"861472669", "四川省甘孜藏族自治州",
"861581536", "广东省惠州市",
"861309750", "山西省阳泉市",
"861586470", "山东省青岛市",
"861781793", "广东省梅州市",
"861336751", "广西南宁市",
"861539775", "四川省雅安市",
"861800155", "江苏省苏州市",
"861838116", "四川省眉山市",
"861563368", "河北省石家庄市",
"861329011", "山东省淄博市",
"861595010", "江苏省无锡市",
"861390884", "云南省昆明市",
"861862606", "江苏省无锡市",
"86188791", "江西省南昌市",
"861360762", "河南省平顶山市",
"861359877", "河南省开封市",
"861787551", "广东省梅州市",
"861533971", "甘肃省金昌市",
"861365913", "陕西省渭南市",
"86182348", "山西省吕梁市",
"861770589", "浙江省金华市",
"861584836", "内蒙古通辽市",
"861831207", "广东省河源市",
"861450181", "山西省吕梁市",
"861586629", "山东省淄博市",
"86151926", "山东省青岛市",
"861771167", "湖南省常德市",
"861806601", "江苏省扬州市",
"861840624", "辽宁省盘锦市",
"86178022", "天津市",
"861827417", "湖南省株洲市",
"861340834", "四川省凉山彝族自治州",
"861527612", "新疆喀什地区",
"861832043", "广东省湛江市",
"861834402", "广东省深圳市",
"861343754", "广东省汕尾市",
"861374332", "吉林省长春市",
"861332494", "云南省大理白族自治州",
"861870875", "云南省保山市",
"861581900", "广东省梅州市",
"861890642", "山东省青岛市",
"861364550", "安徽省滁州市",
"861581591", "广东省江门市",
"861533280", "内蒙古呼伦贝尔市",
"861802148", "江苏省镇江市",
"861327648", "山东省青岛市",
"86188415", "辽宁省丹东市",
"861324540", "山东省济南市",
"86157542", "辽宁省朝阳市",
"861877042", "江西省九江市",
"861321840", "江苏省徐州市",
"861879024", "河南省焦作市",
"861519612", "四川省广元市",
"861587753", "陕西省汉中市",
"861310916", "陕西省宝鸡市",
"861505673", "安徽省宿州市",
"861584891", "内蒙古呼和浩特市",
"861361850", "贵州省贵阳市",
"861312359", "广西北海市",
"861772913", "陕西省渭南市",
"861700405", "广东省东莞市",
"861509682", "云南省昭通市",
"861319648", "江苏省扬州市",
"861780701", "江西省鹰潭市",
"861880979", "青海省海西蒙古族藏族自治州",
"861777598", "湖南省张家界市",
"861300986", "黑龙江省哈尔滨市",
"861550961", "宁夏银川市",
"861774690", "河南省平顶山市",
"861766070", "山东省聊城市",
"861534073", "山西省大同市",
"861813664", "江苏省常州市",
"861454815", "广东省深圳市",
"861707369", "河南省南阳市",
"861369468", "黑龙江省牡丹江市",
"861370882", "云南省丽江市",
"861359964", "福建省龙岩市",
"861779739", "青海省海北藏族自治州",
"861815620", "安徽省铜陵市",
"861863444", "山西省晋中市",
"861571508", "福建省莆田市",
"861780030", "河北省邯郸市",
"861315830", "贵州省黔西南布依族苗族自治州",
"861848418", "贵州省安顺市",
"861810593", "福建省宁德市",
"861452888", "云南省丽江市",
"861336701", "江西省鹰潭市",
"861309700", "江西省新余市",
"861364936", "甘肃省张掖市",
"861355819", "广西南宁市",
"861874262", "新疆阿克苏地区",
"861822646", "安徽省安庆市",
"861303595", "云南省德宏傣族景颇族自治州",
"86139551", "安徽省合肥市",
"861597831", "河南省三门峡市",
"861838638", "贵州省黔西南布依族苗族自治州",
"861770798", "江西省景德镇市",
"861787501", "广东省湛江市",
"861815479", "广西桂林市",
"861576740", "广东省茂名市",
"861338828", "四川省泸州市",
"86177996", "新疆乌鲁木齐市",
"861350559", "安徽省芜湖市",
"861534657", "河南省郑州市",
"861580553", "安徽省芜湖市",
"861325795", "江西省宜春市",
"86186676", "浙江省台州市",
"861839650", "福建省福州市",
"861831257", "广东省河源市",
"861876042", "福建省福州市",
"86137962", "黑龙江省齐齐哈尔市",
"86187983", "贵州省毕节地区",
"861315412", "辽宁省鞍山市",
"861323738", "湖南省娄底市",
"861520332", "河北省保定市",
"861889765", "广西玉林市",
"861309473", "浙江省温州市",
"861809461", "浙江省嘉兴市",
"861534431", "吉林省长春市",
"861454889", "四川省绵阳市",
"861515448", "山东省潍坊市",
"861305482", "山东省莱芜市",
"86136128", "广东省深圳市",
"861518267", "四川省广安市",
"861570540", "山东省菏泽市",
"861452510", "山东省淄博市",
"861338959", "宁夏固原市",
"86131306", "辽宁省锦州市",
"861471852", "广东省河源市",
"86132520", "浙江省湖州市",
"861801123", "四川省达州市",
"861782883", "四川省自贡市",
"861559097", "黑龙江省鹤岗市",
"86180848", "四川省成都市",
"861539347", "甘肃省酒泉市",
"861330501", "福建省福州市",
"861330990", "新疆克拉玛依市",
"861572809", "浙江省舟山市",
"861366658", "浙江省舟山市",
"861553979", "河南省平顶山市",
"861362855", "贵州省黔东南苗族侗族自治州",
"861322845", "四川省南充市",
"861705175", "辽宁省沈阳市",
"861398579", "贵州省黔南布依族苗族自治州",
"861326648", "广东省江门市",
"861868796", "云南省丽江市",
"861511170", "青海省海北藏族自治州",
"861786501", "山东省菏泽市",
"86170818", "广东省东莞市",
"861524882", "内蒙古阿拉善盟",
"861535787", "安徽省阜阳市",
"861580948", "甘肃省陇南市",
"861804149", "辽宁省沈阳市",
"861304247", "辽宁省大连市",
"861589616", "江苏省淮安市",
"861893488", "广西玉林市",
"861313599", "湖北省武汉市",
"861871481", "安徽省合肥市",
"861380912", "陕西省榆林市",
"861894860", "广东省东莞市",
"861370676", "浙江省台州市",
"86186776", "广西百色市",
"861893532", "山西省阳泉市",
"861538561", "安徽省淮北市",
"86156032", "河北省保定市",
"861314358", "广东省佛山市",
"861340230", "四川省自贡市",
"861833618", "河南省驻马店市",
"861314427", "广东省汕头市",
"86150082", "四川省成都市",
"861875299", "江苏省苏州市",
"861375197", "广东省梅州市",
"861521582", "浙江省台州市",
"86177224", "广东省深圳市",
"861351674", "浙江省宁波市",
"861320808", "浙江省宁波市",
"861890963", "安徽省芜湖市",
"861390971", "青海省西宁市",
"861563873", "河南省洛阳市",
"861868731", "云南省昆明市",
"861322674", "广东省汕尾市",
"861356709", "浙江省丽水市",
"861582955", "陕西省西安市",
"861335811", "江苏省无锡市",
"861552582", "山西省吕梁市",
"86153753", "安徽省合肥市",
"861471802", "广东省梅州市",
"86137004", "海南省海口市",
"861355790", "广西柳州市",
"861776789", "吉林省长春市",
"861302305", "安徽省合肥市",
"861366562", "安徽省蚌埠市",
"861301442", "江西省上饶市",
"861330551", "安徽省合肥市",
"861328595", "福建省泉州市",
"861355056", "四川省乐山市",
"861557147", "湖北省荆州市",
"861363476", "内蒙古赤峰市",
"861887243", "湖北省荆门市",
"86132525", "吉林省吉林市",
"861569293", "四川省资阳市",
"86139871", "云南省昆明市",
"861501418", "广东省广州市",
"86133722", "江苏省常州市",
"861831916", "广东省茂名市",
"861381235", "江苏省镇江市",
"861572859", "广东省阳江市",
"861351845", "四川省宜宾市",
"86181497", "上海市",
"861525542", "安徽省淮南市",
"86188691", "云南省西双版纳傣族自治州",
"861331593", "河北省邢台市",
"861786551", "山东省济宁市",
"861500312", "河北省保定市",
"861300348", "江苏省盐城市",
"861587629", "广东省江门市",
"861539554", "安徽省淮南市",
"861705213", "江苏省常州市",
"861357623", "江西省九江市",
"861313788", "河南省许昌市",
"861881365", "广东省湛江市",
"86134002", "河北省保定市",
"861315234", "陕西省咸阳市",
"861530969", "安徽省合肥市",
"861589138", "陕西省宝鸡市",
"861560812", "四川省广元市",
"861506632", "山东省枣庄市",
"861810159", "江苏省南京市",
"861310257", "河北省邢台市",
"861876250", "江苏省盐城市",
"861325721", "湖北省荆州市",
"861320858", "贵州省毕节地区",
"861550987", "辽宁省沈阳市",
"86152626", "江苏省苏州市",
"861337751", "广东省韶关市",
"861868000", "广东省佛山市",
"861303521", "湖北省襄樊市",
"861339080", "江苏省淮安市",
"861873534", "山西省阳泉市",
"861360848", "河南省许昌市",
"861328586", "浙江省台州市",
"861372060", "陕西省西安市",
"861334003", "江西省上饶市",
"861868890", "广东省广州市",
"861346904", "湖南省长沙市",
"861332442", "吉林省吉林市",
"861853395", "河北省邯郸市",
"861870934", "甘肃省庆阳市",
"861850903", "新疆和田地区",
"861300921", "辽宁省丹东市",
"861866911", "云南省昆明市",
"861533569", "内蒙古锡林郭勒盟",
"861305603", "江苏省淮安市",
"861355831", "广西南宁市",
"86155751", "湖南省长沙市",
"861458212", "安徽省铜陵市",
"861532418", "河北省衡水市",
"861800359", "山西省运城市",
"861890694", "福建省漳州市",
"86152412", "辽宁省鞍山市",
"861592688", "湖北省襄樊市",
"861310148", "福建省宁德市",
"861593323", "河北省保定市",
"86136407", "广东省广州市",
"86134698", "湖北省宜昌市",
"861808390", "新疆石河子市",
"86137669", "黑龙江省哈尔滨市",
"861877094", "江西省抚州市",
"861585460", "山东省东营市",
"861768322", "四川省南充市",
"861860859", "贵州省黔西南布依族苗族自治州",
"861331305", "河北省唐山市",
"861773915", "河南省焦作市",
"86139693", "山东省淄博市",
"861478453", "黑龙江省牡丹江市",
"861583424", "山西省吕梁市",
"861891215", "江苏省连云港市",
"861878865", "贵州省安顺市",
"861477173", "湖北省孝感市",
"86188873", "云南省红河哈尼族彝族自治州",
"861328303", "河南省濮阳市",
"861329988", "青海省西宁市",
"861338297", "江苏省镇江市",
"861333951", "黑龙江省哈尔滨市",
"861502747", "河北省唐山市",
"861302593", "广西柳州市",
"861557258", "湖北省荆门市",
"861339755", "湖南省郴州市",
"861872812", "四川省内江市",
"861385241", "江苏省泰州市",
"861778926", "陕西省延安市",
"861536771", "湖南省益阳市",
"861347423", "陕西省榆林市",
"861510960", "宁夏银川市",
"861820523", "江苏省淮安市",
"861319089", "内蒙古通辽市",
"861893563", "青海省黄南藏族自治州",
"861317988", "新疆阿克苏地区",
"861509924", "新疆巴音郭楞蒙古自治州",
"861886787", "浙江省宁波市",
"861312841", "广东省潮州市",
"86157256", "山东省潍坊市",
"861317039", "湖南省邵阳市",
"861454564", "四川省绵阳市",
"86176650", "广东省广州市",
"861850953", "宁夏吴忠市",
"861508239", "四川省攀枝花市",
"861839546", "陕西省榆林市",
"861566223", "吉林省长春市",
"861346954", "宁夏固原市",
"861816469", "云南省楚雄彝族自治州",
"861334053", "福建省南平市",
"861558280", "山西省吕梁市",
"86186577", "浙江省温州市",
"861314466", "黑龙江省鸡西市",
"861306035", "陕西省咸阳市",
"861580321", "河北省石家庄市",
"861822550", "安徽省滁州市",
"861862540", "河南省平顶山市",
"861821920", "广东省深圳市",
"861557779", "广西来宾市",
"861305653", "四川省广安市",
"861564570", "黑龙江省大兴安岭地区",
"861879144", "陕西省榆林市",
"861877122", "湖北省恩施土家族苗族自治州",
"861475132", "江苏省泰州市",
"861329039", "山东省日照市",
"861368772", "广西柳州市",
"861476289", "江苏省南京市",
"861890932", "甘肃省定西市",
"861835703", "浙江省杭州市",
"861366533", "山东省淄博市",
"861308529", "湖北省襄樊市",
"861840982", "新疆喀什地区",
"861563697", "黑龙江省大庆市",
"861870692", "甘肃省甘南藏族自治州",
"861331355", "山西省长治市",
"861316346", "黑龙江省鹤岗市",
"861860809", "四川省绵阳市",
"861334677", "河南省开封市",
"861550579", "浙江省金华市",
"861884032", "陕西省榆林市",
"861856748", "河南省新乡市",
"861880561", "安徽省淮北市",
"861506663", "山东省德州市",
"861478403", "河南省驻马店市",
"861572099", "江西省抚州市",
"861458434", "河南省许昌市",
"861595709", "浙江省舟山市",
"861355896", "四川省宜宾市",
"861305077", "辽宁省辽阳市",
"861333901", "安徽省合肥市",
"861854800", "内蒙古鄂尔多斯市",
"861328353", "山西省阳泉市",
"861868785", "云南省楚雄彝族自治州",
"861573940", "新疆阿克苏地区",
"861364646", "山东省潍坊市",
"861814025", "四川省内江市",
"861778018", "四川省达州市",
"861459681", "新疆伊犁哈萨克自治州",
"861339705", "江西省宜春市",
"861518226", "四川省乐山市",
"861847142", "湖北省襄樊市",
"861324656", "广东省惠州市",
"861596056", "福建省泉州市",
"86153591", "福建省福州市",
"86186396", "河南省驻马店市",
"861707165", "河南省洛阳市",
"861308843", "内蒙古赤峰市",
"861457189", "浙江省台州市",
"86155978", "贵州省六盘水市",
"861329646", "山东省潍坊市",
"861520942", "甘肃省白银市",
"861805120", "江苏省常州市",
"861560952", "宁夏石嘴山市",
"861369656", "安徽省芜湖市",
"861807523", "安徽省黄山市",
"86151689", "山东省临沂市",
"861332650", "广东省湛江市",
"861780559", "安徽省黄山市",
"861391459", "江苏省镇江市",
"86135445", "广东省广州市",
"861320918", "陕西省渭南市",
"861788901", "西藏拉萨市",
"861539937", "陕西省安康市",
"861579733", "湖北省武汉市",
"861804645", "福建省泉州市",
"861862468", "辽宁省阜新市",
"861308786", "贵州省毕节地区",
"861867025", "湖南省邵阳市",
"861317646", "山东省潍坊市",
"861779596", "陕西省榆林市",
"86188685", "浙江省金华市",
"861501245", "广东省深圳市",
"861835045", "福建省龙岩市",
"861510770", "广西防城港市",
"861892717", "广东省云浮市",
"861887280", "湖北省恩施土家族苗族自治州",
"861785819", "浙江省丽水市",
"861816151", "宁夏银川市",
"861310019", "山西省运城市",
"861818033", "四川省乐山市",
"861318716", "湖南省衡阳市",
"861807849", "广西柳州市",
"861802031", "江苏省无锡市",
"861576108", "贵州省遵义市",
"861858318", "四川省绵阳市",
"861770781", "广西南宁市",
"861322793", "陕西省渭南市",
"861580338", "河北省衡水市",
"86136849", "广东省深圳市",
"861364039", "广东省梅州市",
"861705679", "重庆市",
"861572919", "河南省南阳市",
"861570356", "山西省晋城市",
"861888208", "四川省凉山彝族自治州",
"861831856", "广东省韶关市",
"861350701", "江西省鹰潭市",
"861816845", "江苏省徐州市",
"861800723", "湖北省黄石市",
"861319921", "黑龙江省双鸭山市",
"861335951", "黑龙江省哈尔滨市",
"861339043", "辽宁省抚顺市",
"861509112", "陕西省榆林市",
"861517570", "河北省沧州市",
"861392194", "江苏省扬州市",
"861867349", "湖南省邵阳市",
"861839494", "甘肃省陇南市",
"861386642", "安徽省马鞍山市",
"861592946", "陕西省咸阳市",
"861865492", "山东省济南市",
"861309148", "黑龙江省伊春市",
"861519182", "陕西省榆林市",
"86180129", "江苏省南京市",
"861336559", "安徽省黄山市",
"861821877", "广东省河源市",
"861778998", "西藏山南地区",
"861452891", "云南省西双版纳傣族自治州",
"861803164", "河北省唐山市",
"861551354", "山西省晋中市",
"861522547", "河南省开封市",
"861473570", "山西省临汾市",
"861369606", "四川省内江市",
"861551547", "河南省濮阳市",
"861560902", "四川省德阳市",
"861334745", "陕西省渭南市",
"861873907", "河南省洛阳市",
"861517132", "湖北省黄冈市",
"861530147", "江苏省南通市",
"861570583", "浙江省嘉兴市",
"861585548", "安徽省阜阳市",
"861786623", "湖北省襄樊市",
"861593278", "河北省邯郸市",
"861459367", "贵州省黔东南苗族侗族自治州",
"86135440", "广东省深圳市",
"861590839", "四川省宜宾市",
"861878449", "四川省内江市",
"861804874", "四川省凉山彝族自治州",
"861780509", "江苏省淮安市",
"86135022", "广东省惠州市",
"861375168", "广东省揭阳市",
"861374663", "黑龙江省绥化市",
"861502844", "河北省保定市",
"86186377", "河南省南阳市",
"861801574", "四川省泸州市",
"861572641", "山东省济南市",
"861587125", "湖北省随州市",
"861303653", "四川省宜宾市",
"86188851", "贵州省贵阳市",
"861312417", "辽宁省营口市",
"861452836", "四川省甘孜藏族自治州",
"861580695", "山东省聊城市",
"861351793", "江西省上饶市",
"86137739", "江苏省宿迁市",
"86153391", "陕西省西安市",
"861557969", "江西省上饶市",
"861355828", "广西河池市",
"861454520", "广西防城港市",
"861559068", "吉林省长春市",
"861331072", "贵州省遵义市",
"861372192", "山东省威海市",
"861881637", "山东省东营市",
"861383499", "山西省朔州市",
"86186596", "福建省漳州市",
"861700361", "广东省深圳市",
"86155138", "山西省太原市",
"861575940", "福建省福州市",
"861362915", "陕西省安康市",
"861350751", "福建省龙岩市",
"861300938", "辽宁省鞍山市",
"861831806", "广东省深圳市",
"861888258", "四川省遂宁市",
"861821964", "甘肃省庆阳市",
"861450198", "山西省朔州市",
"861820465", "黑龙江省齐齐哈尔市",
"86187418", "辽宁省阜新市",
"861303077", "辽宁省盘锦市",
"861828083", "四川省南充市",
"861581214", "云南省昆明市",
"861528897", "山东省青岛市",
"861893425", "广东省茂名市",
"861458541", "河南省漯河市",
"861335901", "安徽省合肥市",
"861830833", "四川省泸州市",
"86155773", "广西桂林市",
"861338819", "四川省成都市",
"861459139", "广西贵港市",
"861571333", "河北省张家口市",
"861532782", "湖北省咸宁市",
"861347565", "山东省潍坊市",
"861336509", "福建省南平市",
"86156912", "陕西省榆林市",
"861776567", "广东省茂名市",
"861870344", "山西省晋中市",
"861776526", "广东省广州市",
"861531844", "山东省枣庄市",
"86186797", "江西省赣州市",
"861344684", "广西百色市",
"861826105", "江苏省泰州市",
"86187431", "吉林省长春市",
"861773086", "河南省许昌市",
"861331487", "内蒙古呼和浩特市",
"86152782", "广西玉林市",
"861556571", "河南省安阳市",
"861388249", "四川省阿坝藏族羌族自治州",
"861888147", "四川省成都市",
"861558243", "山西省晋中市",
"86139446", "吉林省吉林市",
"86153585", "江苏省扬州市",
"861348347", "河北省秦皇岛市",
"861598751", "云南省保山市",
"861770735", "湖南省郴州市",
"861820651", "山东省枣庄市",
"86151982", "四川省成都市",
"861303482", "湖南省娄底市",
"861860641", "山东省威海市",
"86178086", "贵州省黔西南布依族苗族自治州",
"861837903", "江西省新余市",
"861522490", "河南省驻马店市",
"861367308", "河南省信阳市",
"86139634", "山东省莱芜市",
"86153051", "江苏省南京市",
"861323284", "广东省清远市",
"861589121", "陕西省宝鸡市",
"86145037", "辽宁省沈阳市",
"861534544", "山东省聊城市",
"86155111", "河北省石家庄市",
"861345575", "山东省枣庄市",
"861325738", "湖南省娄底市",
"861313412", "辽宁省鞍山市",
"86870", "云南省昭通市",
"861586329", "山东省潍坊市",
"861855553", "安徽省芜湖市",
"861373197", "安徽省六安市",
"861534307", "湖南省益阳市",
"861368380", "河南省郑州市",
"861840324", "河北省承德市",
"861804018", "辽宁省朝阳市",
"861311748", "湖南省娄底市",
"861501782", "广东省汕头市",
"861889975", "广东省广州市",
"861563668", "黑龙江省双鸭山市",
"86155393", "河南省濮阳市",
"861810461", "黑龙江省哈尔滨市",
"861310473", "广东省珠海市",
"861471573", "广东省江门市",
"861895488", "山东省泰安市",
"861315599", "江西省赣州市",
"861850813", "四川省自贡市",
"861459326", "四川省泸州市",
"861824989", "黑龙江省伊春市",
"861882660", "广东省清远市",
"861316991", "广东省深圳市",
"861533787", "湖南省怀化市",
"86153864", "湖南省长沙市",
"86518", "江苏省连云港市",
"861346537", "山东省济宁市",
"861318810", "辽宁省锦州市",
"861308795", "广西玉林市",
"861388491", "山东省东营市",
"861897573", "湖南省郴州市",
"861319348", "河南省鹤壁市",
"861470970", "青海省海北藏族自治州",
"861779585", "陕西省榆林市",
"86189298", "广东省肇庆市",
"861470724", "湖北省咸宁市",
"861528057", "福建省三明市",
"86136324", "广东省广州市",
"86153580", "江苏省无锡市",
"86132325", "广东省中山市",
"861843421", "山西省大同市",
"86181476", "内蒙古赤峰市",
"861365476", "内蒙古赤峰市",
"861367358", "河南省周口市",
"861353790", "广东省云浮市",
"861394992", "河南省商丘市",
"861367427", "辽宁省沈阳市",
"861890342", "山西省大同市",
"861570468", "黑龙江省鹤岗市",
"861569882", "辽宁省沈阳市",
"861820601", "福建省莆田市",
"861327348", "河北省邢台市",
"861330010", "北京市",
"861874822", "内蒙古兴安盟",
"861773141", "河北省石家庄市",
"861316936", "广东省肇庆市",
"861338268", "江苏省徐州市",
"861333811", "江苏省无锡市",
"861530779", "广西北海市",
"861809159", "陕西省西安市",
"861538076", "江苏省南京市",
"861335447", "山东省聊城市",
"861836548", "江西省宜春市",
"861597959", "江西省抚州市",
"861534428", "内蒙古巴彦淖尔市",
"861839350", "甘肃省天水市",
"861534357", "山西省临汾市",
"861380092", "北京市",
"861305521", "福建省厦门市",
"861855503", "安徽省芜湖市",
"861317925", "吉林省吉林市",
"861479542", "广西梧州市",
"861516084", "新疆吐鲁番地区",
"861598030", "福建省泉州市",
"86156619", "内蒙古鄂尔多斯市",
"861891448", "江苏省南京市",
"861378408", "河北省张家口市",
"861368933", "甘肃省平凉市",
"861323721", "湖北省黄冈市",
"861571362", "河南省商丘市",
"861306929", "吉林省通化市",
"861513524", "山西省大同市",
"861890773", "广西桂林市",
"861830862", "贵州省遵义市",
"861860919", "陕西省铜川市",
"861783959", "河南省平顶山市",
"861866851", "浙江省绍兴市",
"861348554", "安徽省淮南市",
"861329925", "广西玉林市",
"861453823", "四川省雅安市",
"861322469", "黑龙江省双鸭山市",
"861323518", "江苏省常州市",
"861835136", "江苏省徐州市",
"86151600", "福建省厦门市",
"861316550", "河北省邯郸市",
"861452730", "湖南省岳阳市",
"861870557", "安徽省宿州市",
"861522470", "河南省信阳市",
"86157635", "山东省聊城市",
"861334668", "河南省新乡市",
"861335163", "黑龙江省牡丹江市",
"861524331", "河北省廊坊市",
"861337560", "山东省聊城市",
"861596382", "山东省日照市",
"8615652", "北京市",
"861530588", "浙江省台州市",
"861311451", "黑龙江省哈尔滨市",
"86145039", "辽宁省沈阳市",
"861378741", "湖南省长沙市",
"86132980", "内蒙古通辽市",
"861828421", "四川省南充市",
"86150344", "山西省忻州市",
"861331802", "广东省湛江市",
"861530432", "吉林省吉林市",
"861478909", "西藏拉萨市",
"861853892", "河南省郑州市",
"861845252", "江苏省宿迁市",
"86186799", "江西省萍乡市",
"861522629", "宁夏吴忠市",
"861334502", "山东省青岛市",
"86158994", "新疆乌鲁木齐市",
"861340648", "山东省青岛市",
"86151322", "河北省保定市",
"861470551", "安徽省合肥市",
"861367314", "河北省承德市",
"861707546", "福建省泉州市",
"861318027", "河北省秦皇岛市",
"861374974", "河南省信阳市",
"861555999", "云南省曲靖市",
"861364787", "广西南宁市",
"861390011", "北京市",
"86187523", "江苏省淮安市",
"861569457", "黑龙江省大兴安岭地区",
"861303807", "山西省阳泉市",
"861329884", "吉林省通化市",
"861824440", "四川省凉山彝族自治州",
"861512138", "贵州省黔南布依族苗族自治州",
"861393810", "河南省三门峡市",
"861556591", "河南省漯河市",
"861302092", "浙江省温州市",
"86189541", "山东省济南市",
"861869602", "湖北省荆门市",
"861300737", "湖南省益阳市",
"861879899", "西藏日喀则地区",
"861842019", "广东省茂名市",
"861315579", "江西省赣州市",
"861471593", "广东省汕头市",
"861850459", "黑龙江省大庆市",
"86137536", "山西省晋城市",
"861316971", "广东省佛山市",
"861816963", "广西南宁市",
"861519955", "新疆哈密地区",
"861384911", "河南省郑州市",
"861524273", "辽宁省抚顺市",
"861346808", "山东省临沂市",
"861323554", "湖北省武汉市",
"861598448", "四川省达州市",
"861869568", "福建省厦门市",
"861373177", "河北省秦皇岛市",
"861370628", "江苏省南通市",
"86181401", "四川省成都市",
"861365431", "吉林省长春市",
"86188607", "云南省昆明市",
"861700746", "湖北省武汉市",
"861310493", "广东省湛江市",
"861880856", "贵州省铜仁地区",
"86183568", "安徽省阜阳市",
"861452622", "江苏省苏州市",
"861810044", "黑龙江省哈尔滨市",
"861383013", "甘肃省临夏回族自治州",
"86153706", "江苏省南通市",
"861566681", "山东省烟台市",
"861394972", "河南省濮阳市",
"86185811", "重庆市",
"86157630", "山东省潍坊市",
"861363357", "山西省临汾市",
"861331852", "广东省茂名市",
"861353924", "广东省惠州市",
"861530799", "江西省萍乡市",
"861323347", "山西省临汾市",
"861558346", "四川省凉山彝族自治州",
"861470990", "新疆克拉玛依市",
"861563282", "河北省唐山市",
"861334552", "安徽省蚌埠市",
"861772431", "广东省东莞市",
"861555148", "安徽省宿州市",
"861308775", "广西玉林市",
"861388471", "山东省潍坊市",
"861365496", "辽宁省锦州市",
"861886646", "山东省潍坊市",
"861556950", "新疆吐鲁番地区",
"861306210", "福建省三明市",
"861864400", "黑龙江省佳木斯市",
"861339211", "广东省广州市",
"861569407", "四川省泸州市",
"861303857", "陕西省延安市",
"86132602", "北京市",
"861327834", "吉林省延边朝鲜族自治州",
"861840417", "辽宁省营口市",
"861829642", "江西省上饶市",
"86153424", "湖北省宜昌市",
"86131571", "浙江省杭州市",
"861356226", "山东省东营市",
"861899301", "甘肃省临夏回族自治州",
"861537599", "福建省福州市",
"861812765", "广东省韶关市",
"861835654", "安徽省合肥市",
"861561511", "山东省威海市",
"86189122", "江苏省南通市",
"861850409", "辽宁省大连市",
"861844935", "新疆昌吉回族自治州",
"86159462", "黑龙江省齐齐哈尔市",
"861327517", "江苏省淮安市",
"861378414", "河北省唐山市",
"861881833", "广东省河源市",
"861550725", "湖北省黄冈市",
"86130578", "浙江省温州市",
"861330827", "重庆市",
"8614742", "四川省成都市",
"861830637", "山东省枣庄市",
"861808782", "云南省昆明市",
"861380072", "湖北省随州市",
"861355960", "福建省宁德市",
"861309587", "浙江省金华市",
"861817642", "广西桂林市",
"86934", "甘肃省庆阳市",
"861319834", "四川省眉山市",
"861323504", "福建省漳州市",
"861346858", "陕西省延安市",
"861342655", "江西省赣州市",
"861890793", "江西省上饶市",
"861319517", "贵州省毕节地区",
"861528693", "河南省濮阳市",
"861377949", "新疆喀什地区",
"86156617", "内蒙古鄂尔多斯市",
"861818712", "云南省昆明市",
"861477701", "广西南宁市",
"861800660", "浙江省嘉兴市",
"861304922", "广东省云浮市",
"861341546", "广东省佛山市",
"86177772", "广西柳州市",
"861880096", "四川省巴中市",
"861888799", "云南省曲靖市",
"861343729", "湖北省武汉市",
"861365485", "内蒙古兴安盟",
"86183813", "四川省自贡市",
"861450480", "辽宁省大连市",
"86158151", "广东省汕头市",
"861760340", "山西省忻州市",
"861320904", "新疆巴音郭楞蒙古自治州",
"861510790", "江西省新余市",
"861330866", "湖北省随州市",
"861362352", "山西省大同市",
"861380487", "黑龙江省七台河市",
"861876543", "山东省滨州市",
"861357970", "新疆伊犁哈萨克自治州",
"86151687", "浙江省温州市",
"86158481", "内蒙古呼和浩特市",
"861836187", "江苏省淮安市",
"861336289", "浙江省杭州市",
"861580844", "四川省南充市",
"861571449", "吉林省白山市",
"861335132", "黑龙江省齐齐哈尔市",
"861354166", "四川省自贡市",
"861302852", "陕西省渭南市",
"861858547", "贵州省毕节地区",
"861506898", "浙江省绍兴市",
"861700840", "贵州省贵阳市",
"861880750", "广东省江门市",
"8615821", "上海市",
"861312324", "河南省郑州市",
"861839474", "甘肃省酒泉市",
"861505505", "安徽省阜阳市",
"861392174", "江苏省泰州市",
"861370319", "河北省邢台市",
"861517901", "江西省上饶市",
"861859361", "福建省漳州市",
"861338403", "河南省郑州市",
"861777251", "河北省保定市",
"86131914", "内蒙古包头市",
"86158668", "山东省青岛市",
"861340015", "河北省邢台市",
"86150467", "黑龙江省哈尔滨市",
"861890469", "黑龙江省双鸭山市",
"861886925", "云南省文山壮族苗族自治州",
"861888214", "四川省资阳市",
"861452871", "宁夏银川市",
"861821897", "广东省茂名市",
"861865472", "山东省潍坊市",
"86180127", "江苏省苏州市",
"86185838", "四川省眉山市",
"861350524", "江苏省淮安市",
"861390346", "山西省太原市",
"86132714", "河南省平顶山市",
"861885153", "江苏省宿迁市",
"86136715", "上海市",
"861529901", "新疆伊犁哈萨克自治州",
"861479705", "青海省果洛藏族自治州",
"861395591", "安徽省铜陵市",
"861586604", "山东省泰安市",
"861823670", "河南省三门峡市",
"861874636", "黑龙江省佳木斯市",
"861816932", "湖南省长沙市",
"861571236", "辽宁省大连市",
"861315987", "黑龙江省哈尔滨市",
"861550412", "辽宁省鞍山市",
"861773075", "陕西省汉中市",
"86186379", "河南省洛阳市",
"861801594", "江苏省南通市",
"86157203", "河北省沧州市",
"861351773", "广西桂林市",
"861599878", "山东省德州市",
"86137737", "江苏省南通市",
"861320954", "宁夏固原市",
"861567626", "广西柳州市",
"861818425", "贵州省黔西南布依族苗族自治州",
"861597277", "湖北省随州市",
"861361445", "吉林省通化市",
"861329569", "安徽省合肥市",
"861321455", "黑龙江省绥化市",
"861552083", "四川省成都市",
"8618620", "广东省广州市",
"861867433", "湖南省湘西土家族苗族自治州",
"861596960", "山东省聊城市",
"861804894", "四川省乐山市",
"861880700", "江西省南昌市",
"861345586", "山东省威海市",
"86138543", "山东省滨州市",
"861879009", "河南省信阳市",
"861593298", "江西省抚州市",
"861302802", "山西省临汾市",
"861335570", "浙江省衢州市",
"861777201", "广西柳州市",
"86150829", "河南省商丘市",
"861338453", "黑龙江省牡丹江市",
"861558011", "湖南省岳阳市",
"861560315", "河北省唐山市",
"861884562", "黑龙江省哈尔滨市",
"861303097", "福建省泉州市",
"861311947", "甘肃省平凉市",
"861528877", "山东省烟台市",
"861518278", "四川省巴中市",
"861889986", "广东省梅州市",
"861882723", "湖北省鄂州市",
"861566635", "山东省聊城市",
"861538856", "山西省晋城市",
"861383479", "山西省长治市",
"861359296", "广东省茂名市",
"861562838", "广东省东莞市",
"861529951", "新疆喀什地区",
"861500815", "四川省绵阳市",
"861331092", "陕西省榆林市",
"86136710", "北京市",
"861533988", "甘肃省酒泉市",
"861803486", "新疆阿勒泰地区",
"86413", "辽宁省抚顺市",
"86131093", "甘肃省兰州市",
"861565053", "山东省济宁市",
"861351342", "河北省保定市",
"861569941", "新疆阿克苏地区",
"861551318", "山西省忻州市",
"861450178", "山西省晋中市",
"861453627", "江苏省泰州市",
"861510885", "云南省丽江市",
"8613533", "广东省广州市",
"861813416", "河北省唐山市",
"861564951", "河南省鹤壁市",
"861346918", "湖南省常德市",
"861808370", "江苏省泰州市",
"861379389", "山东省滨州市",
"861368439", "四川省阿坝藏族羌族自治州",
"86136409", "广东省深圳市",
"861860413", "辽宁省抚顺市",
"861342109", "广东省潮州市",
"861333132", "河北省张家口市",
"861532404", "河北省张家口市",
"861882309", "广东省佛山市",
"861598173", "新疆伊犁哈萨克自治州",
"861363485", "黑龙江省伊春市",
"861350560", "安徽省合肥市",
"861535039", "江西省新余市",
"86131410", "北京市",
"861528920", "陕西省咸阳市",
"86158933", "河南省南阳市",
"861562821", "新疆塔城地区",
"861859687", "福建省厦门市",
"861801239", "江苏省无锡市",
"861318571", "浙江省杭州市",
"861890674", "浙江省宁波市",
"86153248", "河南省郑州市",
"86145704", "广东省深圳市",
"861384801", "内蒙古包头市",
"86130798", "辽宁省大连市",
"861896655", "陕西省咸阳市",
"861364569", "安徽省合肥市",
"861313987", "新疆乌鲁木齐市",
"861802561", "广东省汕头市",
"861804797", "内蒙古鄂尔多斯市",
"861514626", "黑龙江省哈尔滨市",
"861303917", "吉林省吉林市",
"861560689", "浙江省金华市",
"861576922", "陕西省榆林市",
"861459410", "云南省西双版纳傣族自治州",
"86135805", "广东省广州市",
"861556810", "吉林省白山市",
"861518323", "四川省资阳市",
"861477193", "湖北省荆州市",
"861801446", "江苏省南京市",
"861475590", "安徽省淮北市",
"861374898", "河南省郑州市",
"861768237", "浙江省宁波市",
"861570477", "内蒙古鄂尔多斯市",
"861550788", "广西南宁市",
"861863472", "山西省临汾市",
"861362075", "吉林省吉林市",
"861887011", "江西省赣州市",
"86153307", "吉林省吉林市",
"861894928", "安徽省宣城市",
"86132991", "陕西省西安市",
"861338277", "江苏省南京市",
"861331912", "陕西省榆林市",
"861312360", "贵州省贵阳市",
"861361869", "湖北省宜昌市",
"861569385", "甘肃省兰州市",
"861309769", "山西省大同市",
"861708388", "河南省郑州市",
"861536736", "湖南省常德市",
"861368792", "江西省九江市",
"861869597", "河南省南阳市",
"861855240", "江苏省无锡市",
"861890845", "湖南省长沙市",
"861526889", "浙江省台州市",
"861330235", "广东省清远市",
"861882359", "广东省东莞市",
"861323937", "甘肃省酒泉市",
"861880916", "陕西省汉中市",
"861532454", "安徽省黄山市",
"861472650", "四川省乐山市",
"86155006", "青海省西宁市",
"861530525", "江苏省扬州市",
"861520266", "宁夏石嘴山市",
"861573489", "内蒙古鄂尔多斯市",
"861768888", "广东省广州市",
"86181202", "湖北省武汉市",
"861384851", "内蒙古呼和浩特市",
"861533646", "山东省潍坊市",
"86145919", "重庆市",
"861326765", "广东省江门市",
"86186579", "浙江省金华市",
"861559538", "宁夏银川市",
"861815416", "安徽省淮南市",
"861583317", "河北省沧州市",
"86135800", "广东省茂名市",
"861805486", "福建省漳州市",
"861580747", "湖南省永州市",
"861535988", "福建省厦门市",
"861354752", "四川省广安市",
"86159089", "山东省青岛市",
"861558550", "吉林省白城市",
"861328206", "浙江省衢州市",
"86158738", "湖南省娄底市",
"861370685", "浙江省绍兴市",
"861344783", "广西钦州市",
"861890151", "江苏省无锡市",
"861572079", "江苏省盐城市",
"861763530", "山西省阳泉市",
"861779061", "黑龙江省齐齐哈尔市",
"861307954", "宁夏固原市",
"861550599", "福建省南平市",
"861334697", "河南省南阳市",
"861571865", "贵州省黔东南苗族侗族自治州",
"861333570", "浙江省衢州市",
"861509006", "河南省新乡市",
"861476559", "湖北省武汉市",
"861305097", "辽宁省葫芦岛市",
"86158173", "广东省深圳市",
"861394733", "内蒙古乌海市",
"861846465", "山东省东营市",
"861567111", "湖北省孝感市",
"861537725", "湖北省十堰市",
"861330970", "青海省海北藏族自治州",
"86187323", "河北省张家口市",
"861848923", "西藏山南地区",
"861316761", "安徽省铜陵市",
"861559077", "吉林省吉林市",
"861529811", "四川省达州市",
"861500955", "宁夏中卫市",
"861538916", "陕西省汉中市",
"861319737", "湖北省孝感市",
"86151522", "江苏省无锡市",
"861760930", "甘肃省临夏回族自治州",
"861398599", "贵州省黔西南布依族苗族自治州",
"861855892", "福建省三明市",
"861562672", "广东省茂名市",
"861330724", "湖北省咸宁市",
"861322932", "河北省唐山市",
"861321387", "河南省信阳市",
"861886039", "河南省郑州市",
"861383993", "河南省驻马店市",
"861303068", "安徽省阜阳市",
"861309493", "江苏省淮安市",
"861390550", "安徽省滁州市",
"861583187", "河北省沧州市",
"861569396", "甘肃省白银市",
"861809044", "四川省巴中市",
"86159000", "广东省中山市",
"861365307", "广东省阳江市",
"861561242", "河北省廊坊市",
"86135889", "浙江省温州市",
"861807022", "江西省九江市",
"861875708", "浙江省温州市",
"86150544", "山东省潍坊市",
"861501454", "广东省韶关市",
"861774245", "陕西省榆林市",
"86158711", "湖北省黄石市",
"861333163", "吉林省延边朝鲜族自治州",
"861552040", "四川省南充市",
"861833171", "河北省廊坊市",
"861470010", "江苏省淮安市",
"861337524", "江苏省盐城市",
"861339542", "山东省青岛市",
"86158490", "内蒙古呼伦贝尔市",
"861363431", "吉林省长春市",
"86132154", "河北省廊坊市",
"86183368", "河南省焦作市",
"86136292", "陕西省西安市",
"861593267", "河北省石家庄市",
"86130435", "福建省福州市",
"861325554", "山东省烟台市",
"861365544", "山东省烟台市",
"861829400", "甘肃省临夏回族自治州",
"861705316", "湖北省武汉市",
"861760556", "安徽省安庆市",
"861524407", "山东省日照市",
"86137336", "河南省许昌市",
"861320537", "山东省济宁市",
"861833604", "河南省商丘市",
"861390936", "甘肃省张掖市",
"861817400", "江西省南昌市",
"86132484", "浙江省杭州市",
"861805495", "福建省三明市",
"861320814", "四川省阿坝藏族羌族自治州",
"861525080", "江苏省无锡市",
"861313579", "湖北省荆州市",
"861816342", "广东省珠海市",
"861353112", "广东省湛江市",
"861538028", "江苏省连云港市",
"861827660", "广西梧州市",
"861760383", "河南省新乡市",
"861569273", "贵州省安顺市",
"861572413", "广东省揭阳市",
"861500905", "新疆和田地区",
"861471487", "广东省深圳市",
"861363496", "辽宁省锦州市",
"86151141", "辽宁省丹东市",
"861328575", "浙江省绍兴市",
"861348738", "湖南省娄底市",
"861767706", "广西百色市",
"861302160", "山东省烟台市",
"861360334", "河北省承德市",
"861347081", "安徽省阜阳市",
"861380355", "江西省九江市",
"861332137", "甘肃省酒泉市",
"86157765", "黑龙江省大庆市",
"861893190", "河北省秦皇岛市",
"86150148", "广东省东莞市",
"861597682", "广东省湛江市",
"861365428", "辽宁省大连市",
"861875758", "浙江省杭州市",
"861365357", "山西省临汾市",
"861807194", "湖北省十堰市",
"861390500", "福建省福州市",
"861514667", "黑龙江省齐齐哈尔市",
"861894341", "吉林省通化市",
"861700883", "广东省广州市",
"861563893", "河南省郑州市",
"861390991", "新疆乌鲁木齐市",
"86135254", "河南省洛阳市",
"861370631", "山东省威海市",
"861355770", "广西防城港市",
"86186701", "江西省鹰潭市",
"861821868", "广东省茂名市",
"861310587", "浙江省舟山市",
"86157946", "天津市",
"86147686", "山东省潍坊市",
"861502948", "陕西省西安市",
"861536830", "云南省大理白族自治州",
"861303704", "山西省朔州市",
"86136150", "福建省福州市",
"861391953", "甘肃省平凉市",
"86158495", "内蒙古通辽市",
"861329787", "广西钦州市",
"861760506", "福建省厦门市",
"861334873", "湖南省湘西土家族苗族自治州",
"861869440", "陕西省宝鸡市",
"861325504", "福建省福州市",
"861872689", "安徽省淮北市",
"861302912", "吉林省长春市",
"861889015", "湖南省邵阳市",
"861314314", "广东省珠海市",
"861886988", "云南省曲靖市",
"861352387", "河南省新乡市",
"861351932", "甘肃省定西市",
"861569331", "甘肃省兰州市",
"861862477", "河南省南阳市",
"861379119", "山东省烟台市",
"861879217", "安徽省池州市",
"861308647", "四川省眉山市",
"861361584", "浙江省丽水市",
"86130378", "贵州省贵阳市",
"861871610", "四川省泸州市",
"861332369", "河南省南阳市",
"861840841", "宁夏银川市",
"861818170", "四川省宜宾市",
"86131371", "河南省郑州市",
"86136480", "四川省成都市",
"861304384", "辽宁省铁岭市",
"861536412", "湖南省岳阳市",
"861518551", "贵州省黔南布依族苗族自治州",
"861806194", "江苏省苏州市",
"861358132", "湖北省荆门市",
"861368744", "广东省佛山市",
"861520008", "河北省保定市",
"861593281", "江西省宜春市",
"861340348", "山西省运城市",
"861844998", "新疆石河子市",
"861301165", "山东省潍坊市",
"861811970", "安徽省蚌埠市",
"861336448", "吉林省长春市",
"86186601", "山东省济南市",
"8617833", "吉林省吉林市",
"861367614", "广东省汕头市",
"86145069", "上海市",
"861826660", "山东省潍坊市",
"861879906", "新疆哈密地区",
"861861752", "河北省唐山市",
"861364971", "青海省海东地区",
"86157665", "广东省湛江市",
"861334368", "河南省安阳市",
"861510909", "新疆博尔塔拉蒙古自治州",
"861567139", "湖北省荆州市",
"861770259", "江苏省徐州市",
"861802979", "广东省潮州市",
"861343521", "广东省湛江市",
"86185513", "江苏省常州市",
"86145712", "黑龙江省黑河市",
"861870780", "广西防城港市",
"861822569", "安徽省合肥市",
"86183538", "山东省泰安市",
"861533500", "江苏省常州市",
"861533991", "山东省日照市",
"861379185", "山东省潍坊市",
"861359897", "河南省许昌市",
"861452322", "河南省郑州市",
"861889089", "新疆昌吉回族自治州",
"861394848", "内蒙古乌兰察布市",
"861834238", "辽宁省葫芦岛市",
"861815241", "宁夏中卫市",
"861567367", "湖南省益阳市",
"8613690", "广东省佛山市",
"861396700", "浙江省衢州市",
"861522045", "广东省汕头市",
"861582034", "广东省阳江市",
"861370457", "黑龙江省七台河市",
"861860727", "湖北省襄樊市",
"861816450", "浙江省衢州市",
"861370328", "河北省保定市",
"861341442", "广东省东莞市",
"861537830", "四川省泸州市",
"86155807", "湖南省怀化市",
"861824075", "河南省商丘市",
"861781773", "广东省深圳市",
"861869302", "甘肃省临夏回族自治州",
"861539795", "江西省宜春市",
"861586490", "山东省聊城市",
"861507867", "广西百色市",
"86187821", "四川省成都市",
"861328704", "山东省聊城市",
"861533936", "甘肃省张掖市",
"861803438", "河北省衡水市",
"861360012", "广东省潮州市",
"861329761", "湖北省荆门市",
"86151417", "辽宁省营口市",
"861534093", "山西省吕梁市",
"86158611", "江苏省常州市",
"861500520", "江苏省徐州市",
"861576684", "广东省惠州市",
"861554343", "吉林省吉林市",
"861356866", "四川省凉山彝族自治州",
"861880999", "新疆伊犁哈萨克自治州",
"861352361", "河南省洛阳市",
"861879956", "新疆和田地区",
"861817773", "广西南宁市",
"861332474", "广西贺州市",
"861317761", "江西省吉安市",
"861362483", "内蒙古包头市",
"86132878", "山东省威海市",
"861323647", "江苏省镇江市",
"861558646", "湖北省十堰市",
"86181214", "上海市",
"861889938", "新疆克拉玛依市",
"861330267", "广东省汕尾市",
"861556463", "山东省潍坊市",
"861859455", "福建省莆田市",
"861887039", "江西省景德镇市",
"861882841", "四川省凉山彝族自治州",
"861510959", "宁夏固原市",
"86189456", "黑龙江省哈尔滨市",
"861774429", "四川省遂宁市",
"861581571", "广东省中山市",
"861815499", "新疆和田地区",
"861368411", "四川省资阳市",
"861770778", "广西河池市",
"861538207", "辽宁省朝阳市",
"861471461", "广东省东莞市",
"861533550", "内蒙古包头市",
"861800360", "黑龙江省哈尔滨市",
"861771443", "江苏省苏州市",
"861372059", "陕西省咸阳市",
"861370407", "辽宁省营口市",
"861571837", "广东省揭阳市",
"861345538", "山东省泰安市",
"861846437", "山东省滨州市",
"861535011", "江西省南昌市",
"861811281", "江苏省镇江市",
"861336524", "江苏省泰州市",
"861860860", "湖北省宜昌市",
"861550516", "江苏省徐州市",
"86184848", "贵州省黔西南布依族苗族自治州",
"861551329", "山西省太原市",
"861879530", "宁夏银川市",
"861363073", "吉林省白山市",
"861381323", "江苏省盐城市",
"86159432", "吉林省吉林市",
"861333084", "四川省资阳市",
"86189843", "贵州省贵阳市",
"861524696", "黑龙江省黑河市",
"861512195", "宁夏中卫市",
"861801211", "江苏省宿迁市",
"861869352", "甘肃省武威市",
"861520764", "广东省清远市",
"861769613", "山西省大同市",
"861857947", "广西南宁市",
"861810573", "浙江省嘉兴市",
"86157084", "四川省成都市",
"861870886", "云南省怒江傈僳族自治州",
"861509819", "山东省潍坊市",
"861538999", "新疆和田地区",
"861813973", "甘肃省武威市",
"86138841", "甘肃省庆阳市",
"86176923", "河北省保定市",
"861812834", "广东省揭阳市",
"861894809", "广东省江门市",
"861802587", "广东省佛山市",
"861590570", "浙江省衢州市",
"861328917", "陕西省宝鸡市",
"861345077", "广东省佛山市",
"861556799", "吉林省白山市",
"861303256", "江苏省扬州市",
"861864932", "山西省太原市",
"861872048", "江西省景德镇市",
"861327765", "湖北省荆门市",
"861537736", "湖南省常德市",
"861858171", "四川省南充市",
"861586547", "山东省淄博市",
"861392301", "广东省梅州市",
"861566698", "山东省德州市",
"861760640", "山东省济南市",
"861530950", "宁夏银川市",
"861319765", "广西玉林市",
"861596403", "山东省潍坊市",
"861348843", "陕西省渭南市",
"861378549", "河北省沧州市",
"861300975", "黑龙江省齐齐哈尔市",
"861397019", "江西省鹰潭市",
"861320565", "安徽省马鞍山市",
"86156487", "内蒙古鄂尔多斯市",
"861707442", "浙江省温州市",
"861850317", "河北省沧州市",
"861306954", "河南省许昌市",
"861588337", "四川省乐山市",
"861709424", "广东省江门市",
"861390646", "山东省潍坊市",
"861840309", "河北省邢台市",
"861842028", "广东省中山市",
"861512186", "宁夏石嘴山市",
"861853747", "河南省平顶山市",
"86185868", "贵州省贵阳市",
"861599942", "新疆阿克苏地区",
"861531503", "山东省东营市",
"861524685", "黑龙江省双鸭山市",
"861821285", "贵州省六盘水市",
"861536725", "湖南省郴州市",
"861898993", "西藏山南地区",
"861356827", "四川省绵阳市",
"861768510", "贵州省贵阳市",
"86150437", "吉林省辽源市",
"861572860", "广东省云浮市",
"861534803", "甘肃省平凉市",
"861810912", "陕西省榆林市",
"861782661", "江苏省淮安市",
"861371715", "广东省东莞市",
"861348529", "江苏省南通市",
"861370619", "江苏省无锡市",
"861378823", "广西桂林市",
"861859661", "福建省厦门市",
"861800982", "辽宁省朝阳市",
"861878633", "贵州省遵义市",
"861770997", "新疆阿克苏地区",
"861555031", "山东省淄博市",
"86182285", "四川省眉山市",
"861530536", "山东省潍坊市",
"861894859", "广东省惠州市",
"861507826", "广西柳州市",
"861362568", "安徽省阜阳市",
"861811235", "江苏省无锡市",
"861555750", "浙江省绍兴市",
"861514635", "黑龙江省大庆市",
"861470709", "江西省萍乡市",
"861471605", "广东省湛江市",
"861508043", "福建省泉州市",
"861556588", "河南省漯河市",
"861580375", "河南省平顶山市",
"861868069", "广东省深圳市",
"861779087", "辽宁省丹东市",
"861392351", "广东省潮州市",
"861362602", "福建省龙岩市",
"861860766", "广东省云浮市",
"861809092", "四川省达州市",
"86156316", "河北省廊坊市",
"86152529", "江苏省镇江市",
"861332165", "广西玉林市",
"861709548", "江苏省无锡市",
"861568545", "贵州省黔东南苗族侗族自治州",
"861535346", "陕西省咸阳市",
"86185455", "黑龙江省哈尔滨市",
"861530591", "福建省福州市",
"861530900", "四川省自贡市",
"861513509", "山西省太原市",
"861306904", "吉林省长春市",
"861529839", "江苏省南京市",
"861551618", "河南省郑州市",
"861340921", "河南省新乡市",
"861339594", "福建省莆田市",
"861822884", "四川省广元市",
"861880257", "广东省湛江市",
"861539786", "江西省吉安市",
"861380159", "江苏省南京市",
"861773440", "河北省石家庄市",
"861572727", "湖北省襄樊市",
"861532923", "贵州省安顺市",
"861308937", "吉林省白城市",
"861314063", "河南省许昌市",
"861531553", "山东省青岛市",
"861356760", "浙江省丽水市",
"861840359", "山西省运城市",
"861842916", "陕西省汉中市",
"861351642", "安徽省淮南市",
"861575107", "江苏省徐州市",
"861534853", "贵州省安顺市",
"861895471", "山东省烟台市",
"861537791", "福建省福州市",
"861825245", "江苏省宿迁市",
"86186859", "贵州省黔西南布依族苗族自治州",
"86182280", "四川省成都市",
"861560615", "江苏省无锡市",
"861502638", "新疆阿克苏地区",
"861867566", "广东省汕头市",
"861372217", "内蒙古鄂尔多斯市",
"861390988", "辽宁省沈阳市",
"861369477", "内蒙古赤峰市",
"861890374", "河南省许昌市",
"86133589", "辽宁省铁岭市",
"861827982", "江西省吉安市",
"861709460", "浙江省绍兴市",
"861769708", "青海省西宁市",
"861588401", "四川省凉山彝族自治州",
"86188506", "福建省南平市",
"861808429", "贵州省黔西南布依族苗族自治州",
"861340938", "河南省许昌市",
"861561539", "山东省临沂市",
"861339446", "吉林省白城市",
"861892146", "江苏省南通市",
"861564839", "内蒙古呼伦贝尔市",
"861318147", "山东省济宁市",
"861818249", "陕西省宝鸡市",
"861822787", "四川省乐山市",
"861502621", "新疆博尔塔拉蒙古自治州",
"861361229", "广东省江门市",
"861316569", "湖北省咸宁市",
"861882609", "广东省广州市",
"861572824", "广东省深圳市",
"86137637", "黑龙江省绥化市",
"861808670", "江苏省苏州市",
"861322450", "黑龙江省哈尔滨市",
"861594902", "江苏省徐州市",
"861760452", "黑龙江省齐齐哈尔市",
"861566626", "山东省威海市",
"861347098", "安徽省合肥市",
"861315961", "吉林省长春市",
"861362440", "吉林省长春市",
"861327975", "新疆伊犁哈萨克自治州",
"861888810", "江苏省盐城市",
"86136610", "北京市",
"861550830", "四川省泸州市",
"861351400", "福建省泉州市",
"861470323", "河北省张家口市",
"861829694", "江西省宜春市",
"861761427", "辽宁省盘锦市",
"861886991", "浙江省金华市",
"861500889", "云南省玉溪市",
"86185954", "河南省郑州市",
"861510819", "四川省泸州市",
"861313771", "河南省郑州市",
"861813763", "河南省驻马店市",
"861505920", "福建省漳州市",
"861573157", "四川省泸州市",
"861860152", "江苏省盐城市",
"861580002", "广东省广州市",
"861364243", "广东省阳江市",
"861880473", "内蒙古乌海市",
"861560389", "河南省许昌市",
"86131609", "广东省佛山市",
"861300765", "河南省焦作市",
"861301669", "广东省揭阳市",
"861380461", "黑龙江省哈尔滨市",
"861772419", "广东省珠海市",
"861336173", "江西省上饶市",
"861562261", "广东省清远市",
"861319975", "新疆克孜勒苏柯尔克孜自治州",
"861768051", "湖南省张家界市",
"861392437", "广东省东莞市",
"861306078", "广东省佛山市",
"86147416", "四川省成都市",
"861515559", "安徽省宣城市",
"861818436", "贵州省遵义市",
"861842031", "广东省湛江市",
"861533346", "山西省晋城市",
"86151787", "重庆市",
"861837187", "湖北省随州市",
"86152329", "河北省保定市",
"861337289", "辽宁省本溪市",
"861875140", "江苏省连云港市",
"861592822", "四川省广元市",
"861338770", "广西防城港市",
"86183311", "河北省保定市",
"86145290", "广东省广州市",
"861840723", "湖北省荆门市",
"861454312", "黑龙江省七台河市",
"861534572", "浙江省湖州市",
"86156516", "江苏省南京市",
"861882659", "广东省清远市",
"861870372", "河南省安阳市",
"861832542", "山东省青岛市",
"86138476", "内蒙古赤峰市",
"861591763", "广东省清远市",
"86177672", "浙江省杭州市",
"86152987", "江苏省徐州市",
"861853844", "河南省南阳市",
"861452984", "广东省江门市",
"861771178", "湖南省长沙市",
"861818491", "西藏拉萨市",
"861365419", "辽宁省辽阳市",
"86147929", "安徽省亳州市",
"861889348", "甘肃省兰州市",
"861830665", "广东省茂名市",
"861537516", "安徽省淮南市",
"861802493", "广东省佛山市",
"861377639", "江苏省常州市",
"861302044", "内蒙古鄂尔多斯市",
"861847523", "广东省梅州市",
"861893471", "广西南宁市",
"861871478", "黑龙江省伊春市",
"861320423", "辽宁省鞍山市",
"861870743", "湖南省湘西土家族苗族自治州",
"861830947", "甘肃省兰州市",
"861334397", "河南省信阳市",
"861885788", "浙江省杭州市",
"861823245", "河北省廊坊市",
"861577114", "湖北省荆州市",
"861348786", "湖南省郴州市",
"861370385", "河南省漯河市",
"86158768", "广东省潮州市",
"861810092", "陕西省西安市",
"861515509", "安徽省安庆市",
"861812737", "广东省韶关市",
"861390039", "辽宁省辽阳市",
"861860976", "青海省玉树藏族自治州",
"861896305", "山东省菏泽市",
"861898013", "四川省绵阳市",
"861844967", "新疆博尔塔拉蒙古自治州",
"861386151", "江苏省无锡市",
"861558039", "湖南省邵阳市",
"86155449", "河北省保定市",
"861550736", "湖南省常德市",
"861830451", "黑龙江省哈尔滨市",
"861591499", "广东省清远市",
"86185313", "河北省张家口市",
"861896593", "福建省宁德市",
"861534913", "陕西省渭南市",
"861508080", "湖南省娄底市",
"861317280", "广东省揭阳市",
"861532690", "内蒙古包头市",
"86131685", "广东省佛山市",
"861887646", "福建省泉州市",
"861356235", "山东省日照市",
"861346929", "湖南省邵阳市",
"861318779", "云南省丽江市",
"861310076", "湖北省恩施土家族苗族自治州",
"861397207", "湖北省襄樊市",
"861524189", "辽宁省阜新市",
"86153606", "广东省广州市",
"861476030", "福建省三明市",
"861308554", "安徽省淮南市",
"861321687", "浙江省丽水市",
"861571734", "湖南省衡阳市",
"861708391", "河南省焦作市",
"86157730", "湖南省岳阳市",
"861804842", "四川省内江市",
"861348795", "湖南省邵阳市",
"86151586", "浙江省温州市",
"861772657", "四川省乐山市",
"861773483", "河南省三门峡市",
"86183470", "内蒙古呼伦贝尔市",
"861370396", "河南省驻马店市",
"86137366", "浙江省台州市",
"86156845", "山东省威海市",
"86180293", "广东省佛山市",
"861803421", "河北省石家庄市",
"861373434", "山东省德州市",
"861583409", "山西省忻州市",
"86130465", "江苏省盐城市",
"86132702", "江苏省徐州市",
"861351394", "河南省濮阳市",
"861889921", "新疆阿克苏地区",
"861802769", "广东省佛山市",
"861705616", "山东省青岛市",
"861318208", "江苏省无锡市",
"861331044", "贵州省黔南布依族苗族自治州",
"861536599", "江苏省镇江市",
"861834784", "内蒙古包头市",
"861894919", "安徽省宿州市",
"861362597", "福建省泉州市",
"861572976", "四川省广元市",
"861537103", "江苏省南京市",
"861813732", "河南省开封市",
"861454182", "山西省晋中市",
"861535991", "福建省龙岩市",
"86874", "云南省曲靖市",
"861810852", "贵州省遵义市",
"861846301", "山东省威海市",
"86186699", "山东省临沂市",
"861325965", "宁夏中卫市",
"861366314", "河北省承德市",
"861591732", "广东省江门市",
"861869075", "贵州省贵阳市",
"861370331", "河北省石家庄市",
"861800324", "河北省承德市",
"86182291", "湖南省株洲市",
"86147622", "江苏省盐城市",
"86131851", "浙江省金华市",
"861521475", "浙江省台州市",
"861770968", "安徽省阜阳市",
"861762541", "江苏省泰州市",
"86131680", "广东省深圳市",
"861557900", "江西省新余市",
"861322394", "河南省周口市",
"861325647", "山东省东营市",
"861860824", "四川省达州市",
"861376611", "吉林省白城市",
"86157735", "湖南省郴州市",
"861520974", "青海省海南藏族自治州",
"861360634", "山东省青岛市",
"861336560", "安徽省合肥市",
"861380655", "浙江省温州市",
"861809573", "青海省黄南藏族自治州",
"861309561", "浙江省嘉兴市",
"861308504", "安徽省六安市",
"8613240", "北京市",
"861503693", "河南省驻马店市",
"861306537", "辽宁省辽阳市",
"861520720", "湖北省宜昌市",
"861554962", "湖北省孝感市",
"861535936", "福建省泉州市",
"861768836", "广东省茂名市",
"86183475", "内蒙古通辽市",
"861550791", "江西省南昌市",
"861566667", "山东省东营市",
"861374881", "黑龙江省牡丹江市",
"861327230", "湖南省衡阳市",
"861595970", "福建省龙岩市",
"861329971", "青海省西宁市",
"861338876", "云南省文山壮族苗族自治州",
"86188707", "江西省赣州市",
"861353453", "广东省揭阳市",
"86156840", "山东省烟台市",
"861865061", "福建省漳州市",
"861308347", "安徽省阜阳市",
"861500564", "安徽省六安市",
"861530810", "四川省德阳市",
"861370273", "广东省湛江市",
"861359219", "河南省平顶山市",
"861708336", "河北省石家庄市",
"861323775", "广西贵港市",
"861589213", "福建省宁德市",
"861311637", "贵州省六盘水市",
"861537153", "江苏省连云港市",
"861371581", "广东省潮州市",
"861813499", "山西省朔州市",
"861568484", "新疆伊犁哈萨克自治州",
"861317971", "江苏省徐州市",
"861538473", "内蒙古乌海市",
"861393432", "山西省晋城市",
"861559049", "吉林省松原市",
"861313304", "山西省晋中市",
"861389043", "四川省宜宾市",
"861301737", "湖南省益阳市",
"861884556", "黑龙江省哈尔滨市",
"861532815", "四川省凉山彝族自治州",
"86158509", "江苏省宿迁市",
"861569422", "辽宁省鞍山市",
"861539399", "云南省曲靖市",
"861889494", "河北省秦皇岛市",
"861557948", "江西省赣州市",
"861386559", "安徽省黄山市",
"86183902", "湖南省长沙市",
"861331760", "广西防城港市",
"861318052", "河北省邯郸市",
"861535424", "河北省承德市",
"861357912", "新疆阿克苏地区",
"861874482", "贵州省黔东南苗族侗族自治州",
"86131470", "广东省深圳市",
"861475620", "河北省保定市",
"861345129", "湖北省随州市",
"861329317", "河北省秦皇岛市",
"861333732", "湖南省湘潭市",
"861320661", "黑龙江省齐齐哈尔市",
"861893831", "广东省肇庆市",
"861871838", "广东省茂名市",
"861598773", "云南省玉溪市",
"861530338", "河北省衡水市",
"861304714", "湖北省武汉市",
"86181505", "福建省泉州市",
"861803994", "河南省商丘市",
"861811044", "安徽省宿州市",
"861778168", "四川省成都市",
"861524581", "黑龙江省齐齐哈尔市",
"861317317", "山东省济宁市",
"861314784", "辽宁省大连市",
"86137249", "广东省佛山市",
"861596532", "山东省青岛市",
"861838779", "云南省玉溪市",
"861585569", "安徽省淮南市",
"861884930", "河北省张家口市",
"861452657", "江西省赣州市",
"861453483", "内蒙古乌海市",
"86183685", "浙江省绍兴市",
"861856979", "湖南省怀化市",
"861531432", "山东省东营市",
"861529664", "山西省晋中市",
"861890701", "江西省鹰潭市",
"861875247", "江苏省南通市",
"861310451", "黑龙江省哈尔滨市",
"861825034", "福建省福州市",
"861598342", "四川省凉山彝族自治州",
"86147343", "重庆市",
"861471551", "广东省珠海市",
"861899393", "甘肃省陇南市",
"861473664", "云南省昭通市",
"861806296", "湖北省荆州市",
"86151743", "湖南省湘西土家族苗族自治州",
"861313547", "安徽省亳州市",
"861304299", "甘肃省平凉市",
"861395116", "江苏省泰州市",
"86130754", "重庆市",
"861373018", "河北省保定市",
"861536191", "广东省湛江市",
"861815084", "福建省福州市",
"861576817", "广东省茂名市",
"861803632", "江苏省盐城市",
"861303822", "四川省遂宁市",
"86186519", "江苏省常州市",
"861818876", "广东省惠州市",
"861387193", "湖北省孝感市",
"861334527", "山东省泰安市",
"861880833", "四川省乐山市",
"86189440", "江苏省南京市",
"861450968", "新疆克孜勒苏柯尔克孜自治州",
"861853066", "河南省南阳市",
"86131475", "广东省深圳市",
"86189022", "广东省广州市",
"861556503", "河南省商丘市",
"861318002", "河北省张家口市",
"861560511", "江苏省盐城市",
"86150941", "云南省红河哈尼族彝族自治州",
"861325379", "河南省周口市",
"86158391", "河南省焦作市",
"861337963", "贵州省黔东南苗族侗族自治州",
"861839230", "陕西省咸阳市",
"86181500", "福建省福州市",
"861518461", "黑龙江省七台河市",
"861534237", "湖北省黄冈市",
"861363322", "河北省保定市",
"861560728", "湖北省十堰市",
"861331827", "广东省中山市",
"86152748", "湖南省长沙市",
"861376224", "湖南省湘潭市",
"861806231", "湖北省孝感市",
"861894484", "江苏省泰州市",
"861806742", "浙江省宁波市",
"861550470", "内蒙古呼伦贝尔市",
"861587987", "江西省鹰潭市",
"861309169", "黑龙江省大庆市",
"861593044", "河北省唐山市",
"861537125", "江苏省扬州市",
"861339360", "广西来宾市",
"861308420", "河南省新乡市",
"861452607", "江苏省无锡市",
"86183851", "贵州省遵义市",
"861321717", "湖北省宜昌市",
"861372110", "安徽省合肥市",
"861310401", "黑龙江省哈尔滨市",
"861344183", "广西南宁市",
"861530695", "福建省泉州市",
"861330852", "贵州省遵义市",
"861309337", "安徽省亳州市",
"861565145", "江苏省宿迁市",
"861822459", "河南省新乡市",
"861308679", "广西北海市",
"861384745", "内蒙古通辽市",
"861366861", "山东省东营市",
"861304441", "山西省忻州市",
"861354152", "四川省内江市",
"861369514", "广东省揭阳市",
"861850243", "辽宁省大连市",
"861709346", "广东省深圳市",
"861862449", "辽宁省盘锦市",
"861514531", "黑龙江省齐齐哈尔市",
"861369837", "四川省眉山市",
"861869627", "湖北省黄石市",
"86132333", "山西省长治市",
"861318240", "江苏省无锡市",
"861370567", "安徽省阜阳市",
"861816560", "广东省珠海市",
"861507040", "江西省南昌市",
"861827239", "湖北省仙桃市",
"861565036", "山东省滨州市",
"861370526", "江苏省泰州市",
"861538833", "四川省宜宾市",
"861302827", "辽宁省铁岭市",
"86158771", "广西南宁市",
"86180027", "广东省东莞市",
"861354824", "四川省眉山市",
"861596563", "山东省济南市",
"86158864", "湖南省衡阳市",
"86177152", "江苏省南京市",
"86513", "江苏省南通市",
"861338436", "吉林省白城市",
"86177482", "内蒙古兴安盟",
"861352954", "云南省保山市",
"861479609", "广西玉林市",
"861362458", "黑龙江省伊春市",
"861556116", "内蒙古乌海市",
"861362327", "河北省沧州市",
"861319137", "内蒙古鄂尔多斯市",
"861391346", "江苏省徐州市",
"861889300", "甘肃省白银市",
"861322448", "吉林省松原市",
"861351524", "江苏省淮安市",
"861839975", "新疆克孜勒苏柯尔克孜自治州",
"86185634", "山东省莱芜市",
"861304957", "贵州省毕节地区",
"86183609", "江苏省淮安市",
"861816173", "陕西省渭南市",
"861554217", "辽宁省沈阳市",
"861337694", "福建省宁德市",
"861372380", "湖南省娄底市",
"861707648", "山东省临沂市",
"861590416", "辽宁省锦州市",
"861340546", "山东省东营市",
"861319369", "河南省南阳市",
"861331866", "广东省江门市",
"86185853", "贵州省遵义市",
"861569715", "湖北省武汉市",
"86158051", "江苏省南京市",
"861539121", "内蒙古包头市",
"861324225", "广东省揭阳市",
"861335973", "黑龙江省齐齐哈尔市",
"861318892", "山东省枣庄市",
"861327369", "河北省邢台市",
"861853027", "河南省商丘市",
"861390813", "四川省乐山市",
"861320405", "辽宁省大连市",
"861452419", "辽宁省辽阳市",
"861898839", "云南省普洱市",
"861334566", "安徽省池州市",
"861338249", "江苏省镇江市",
"861847505", "广东省梅州市",
"861838147", "四川省宜宾市",
"861775408", "安徽省安庆市",
"861470355", "山西省长治市",
"86158585", "浙江省温州市",
"861819446", "甘肃省陇南市",
"861530686", "浙江省台州市",
"861868902", "西藏日喀则地区",
"861355170", "四川省资阳市",
"861345336", "山西省运城市",
"861814397", "河南省郑州市",
"861310947", "甘肃省酒泉市",
"861876940", "山东省烟台市",
"861514585", "黑龙江省鹤岗市",
"861337932", "陕西省榆林市",
"861885136", "江苏省宿迁市",
"861326474", "湖北省武汉市",
"861556638", "辽宁省铁岭市",
"861310665", "广东省佛山市",
"861311769", "广西贵港市",
"861875158", "江苏省无锡市",
"86156696", "浙江省金华市",
"861889350", "甘肃省武威市",
"861350342", "河南省平顶山市",
"861840755", "广东省深圳市",
"861580208", "广东省汕头市",
"861332737", "湖南省益阳市",
"861501815", "广东省阳江市",
"861508723", "云南省楚雄彝族自治州",
"861362408", "辽宁省大连市",
"861303671", "湖南省邵阳市",
"861511885", "广东省江门市",
"861302760", "河南省郑州市",
"861880862", "湖北省武汉市",
"861394910", "河南省郑州市",
"861550318", "河北省衡水市",
"861772984", "四川省成都市",
"861565091", "青海省海南藏族自治州",
"86132594", "陕西省西安市",
"861800594", "福建省莆田市",
"861510033", "河北省张家口市",
"861846920", "云南省怒江傈僳族自治州",
"861705880", "广东省东莞市",
"861453652", "江苏省扬州市",
"86131311", "河北省石家庄市",
"861874077", "陕西省宝鸡市",
"861361944", "云南省曲靖市",
"861580779", "广西北海市",
"861321954", "四川省宜宾市",
"861850761", "广东省河源市",
"861886548", "山东省泰安市",
"861317187", "河北省保定市",
"861350773", "广西桂林市",
"861700929", "山东省青岛市",
"861320455", "黑龙江省绥化市",
"861845266", "江苏省扬州市",
"861518605", "贵州省毕节地区",
"861474036", "辽宁省朝阳市",
"861360445", "吉林省通化市",
"861513469", "黑龙江省绥化市",
"861470305", "河北省唐山市",
"861312542", "辽宁省沈阳市",
"861502588", "甘肃省张掖市",
"861881700", "湖南省岳阳市",
"861399746", "青海省玉树藏族自治州",
"861872050", "江西省宜春市",
"861452592", "福建省厦门市",
"861599486", "广东省江门市",
"861315490", "四川省攀枝花市",
"86152206", "广东省惠州市",
"861560785", "广西贵港市",
"86158958", "江苏省南京市",
"861561689", "湖南省湘西土家族苗族自治州",
"861477845", "广东省广州市",
"861709991", "广东省珠海市",
"861551788", "河南省三门峡市",
"861571477", "内蒙古鄂尔多斯市",
"861564993", "河南省商丘市",
"861530948", "甘肃省天水市",
"861471623", "广东省广州市",
"861760658", "浙江省宁波市",
"861539616", "福建省莆田市",
"861513845", "河南省郑州市",
"861330912", "陕西省榆林市",
"861360869", "河南省郑州市",
"861597491", "云南省临沧市",
"861858579", "贵州省安顺市",
"861556621", "辽宁省沈阳市",
"861773408", "河北省衡水市",
"861344140", "辽宁省葫芦岛市",
"861378855", "广西玉林市",
"861478471", "内蒙古呼和浩特市",
"861566519", "江苏省常州市",
"861700146", "江苏省南通市",
"861380990", "新疆哈密地区",
"861332517", "山东省济宁市",
"86158385", "河南省洛阳市",
"861786912", "云南省文山壮族苗族自治州",
"861333973", "湖北省荆州市",
"861776676", "四川省凉山彝族自治州",
"861373777", "广西钦州市",
"861353488", "广东省茂名市",
"861863378", "河北省廊坊市",
"861332834", "福建省漳州市",
"861457037", "广东省江门市",
"861351560", "安徽省合肥市",
"861532905", "贵州省黔东南苗族侗族自治州",
"861845835", "浙江省嘉兴市",
"861473013", "河北省张家口市",
"861536753", "湖南省永州市",
"861576957", "宁夏银川市",
"86136390", "贵州省贵阳市",
"861879643", "江苏省徐州市",
"861450997", "新疆阿克苏地区",
"861517013", "江西省新余市",
"861850971", "青海省西宁市",
"861580969", "宁夏固原市",
"861539138", "云南省普洱市",
"861528523", "贵州省遵义市",
"861334071", "四川省攀枝花市",
"861872000", "江西省鹰潭市",
"861355712", "广西柳州市",
"861370789", "广西北海市",
"861322560", "安徽省合肥市",
"861818960", "甘肃省张掖市",
"861537470", "内蒙古呼伦贝尔市",
"861308175", "辽宁省辽阳市",
"861760562", "安徽省铜陵市",
"861384893", "内蒙古通辽市",
"86159189", "广东省汕头市",
"861341995", "河南省信阳市",
"86185764", "广东省深圳市",
"861340494", "云南省文山壮族苗族自治州",
"86183691", "山东省菏泽市",
"86159459", "黑龙江省哈尔滨市",
"861597249", "湖北省咸宁市",
"861709550", "江苏省盐城市",
"861537629", "山东省滨州市",
"861708538", "山东省济宁市",
"861569535", "青海省果洛藏族自治州",
"861353170", "广东省惠州市",
"861320117", "新疆阿克苏地区",
"861708482", "河南省新乡市",
"861570865", "贵州省黔东南苗族侗族自治州",
"861878497", "四川省自贡市",
"861328233", "浙江省嘉兴市",
"861760608", "福建省三明市",
"86156677", "陕西省榆林市",
"86158380", "河南省郑州市",
"861380551", "安徽省合肥市",
"861818112", "四川省南充市",
"861477101", "湖北省鄂州市",
"861311979", "青海省海西蒙古族藏族自治州",
"861378805", "广西玉林市",
"861309665", "山西省晋城市",
"861500390", "河南省平顶山市",
"861843266", "河北省廊坊市",
"861309947", "云南省德宏傣族景颇族自治州",
"861534825", "四川省达州市",
"861328371", "河南省郑州市",
"86138722", "湖北省荆州市",
"861453440", "辽宁省沈阳市",
"861778197", "四川省绵阳市",
"861321078", "山东省枣庄市",
"861820794", "江西省抚州市",
"861576907", "新疆伊犁哈萨克自治州",
"861536703", "湖南省岳阳市",
"861508359", "江西省赣州市",
"861598694", "广东省肇庆市",
"861709936", "浙江省丽水市",
"861521266", "安徽省淮南市",
"861532955", "贵州省黔东南苗族侗族自治州",
"861302970", "黑龙江省哈尔滨市",
"861383447", "山西省运城市",
"861354727", "四川省资阳市",
"861824666", "黑龙江省鹤岗市",
"861531525", "山东省潍坊市",
"86972", "青海省海东地区",
"861388909", "西藏拉萨市",
"861597436", "湖南省岳阳市",
"861894545", "黑龙江省伊春市",
"861560890", "西藏拉萨市",
"861880150", "江苏省常州市",
"8615827", "湖北省武汉市",
"861336450", "吉林省长春市",
"861393395", "河北省秦皇岛市",
"861324514", "内蒙古兴安盟",
"861389755", "青海省果洛藏族自治州",
"861390903", "四川省眉山市",
"861309451", "四川省巴中市",
"861858987", "广西柳州市",
"861340350", "山西省忻州市",
"861856769", "河南省安阳市",
"861845881", "浙江省温州市",
"861367221", "江西省南昌市",
"861395621", "安徽省芜湖市",
"86131538", "山东省泰安市",
"861354766", "四川省眉山市",
"861807057", "江西省赣州市",
"861335732", "湖南省湘潭市",
"86181305", "安徽省安庆市",
"861802365", "广东省韶关市",
"861517479", "内蒙古兴安盟",
"861705529", "陕西省西安市",
"86184744", "湖南省张家界市",
"861868812", "广东省中山市",
"861533424", "湖北省襄樊市",
"861510190", "甘肃省庆阳市",
"861473620", "广西梧州市",
"86183873", "云南省红河哈尼族彝族自治州",
"861575200", "云南省昆明市",
"861808312", "贵州省黔南布依族苗族自治州",
"861866668", "广东省汕头市",
"861862865", "陕西省汉中市",
"861315304", "山东省济南市",
"861529479", "河南省周口市",
"861341986", "河南省新乡市",
"86158309", "河北省保定市",
"861816448", "安徽省合肥市",
"86132861", "广东省江门市",
"861331970", "新疆哈密地区",
"861394850", "内蒙古呼伦贝尔市",
"861535460", "吉林省吉林市",
"861322173", "浙江省舟山市",
"861575042", "内蒙古赤峰市",
"861479105", "陕西省西安市",
"861331724", "湖北省咸宁市",
"861807673", "广西柳州市",
"861863410", "河北省邯郸市",
"86132774", "湖北省武汉市",
"861557686", "湖南省张家界市",
"861554009", "内蒙古呼伦贝尔市",
"861373149", "河北省保定市",
"861318375", "四川省南充市",
"861560242", "广东省佛山市",
"861883045", "河北省秦皇岛市",
"861823034", "河北省廊坊市",
"861459472", "陕西省铜川市",
"861520252", "青海省海东地区",
"861814368", "吉林省松原市",
"861583569", "山西省晋城市",
"861576714", "广东省汕尾市",
"861708077", "湖南省岳阳市",
"861500454", "黑龙江省哈尔滨市",
"861806228", "湖北省黄石市",
"861560731", "湖南省长沙市",
"861339324", "河北省张家口市",
"861308464", "浙江省金华市",
"861337342", "河北省保定市",
"861390953", "宁夏吴忠市",
"861309401", "新疆昌吉回族自治州",
"86136050", "福建省漳州市",
"861389705", "青海省海西蒙古族藏族自治州",
"861310337", "河北省沧州市",
"86770", "广西防城港市",
"86180882", "云南省昆明市",
"861523841", "河南省三门峡市",
"861897010", "江西省赣州市",
"86181300", "安徽省合肥市",
"861826542", "山东省青岛市",
"861323379", "河南省洛阳市",
"861454670", "广东省深圳市",
"86158591", "福建省福州市",
"861866552", "广东省揭阳市",
"861365322", "河北省保定市",
"861537318", "河北省衡水市",
"861870610", "江苏省镇江市",
"861855066", "江苏省盐城市",
"86186832", "四川省内江市",
"861330573", "浙江省嘉兴市",
"861360584", "浙江省宁波市",
"861830561", "安徽省淮北市",
"861599495", "广东省潮州市",
"86182526", "江苏省泰州市",
"861559636", "陕西省商洛市",
"861581179", "广东省云浮市",
"86186319", "河北省邢台市",
"861454429", "江苏省盐城市",
"861305822", "广东省韶关市",
"861760533", "山东省淄博市",
"861383901", "河南省许昌市",
"861315354", "山东省烟台市",
"861560796", "江西省吉安市",
"861375926", "云南省西双版纳傣族自治州",
"86132533", "河南省郑州市",
"861304534", "黑龙江省牡丹江市",
"861885703", "浙江省衢州市",
"861569581", "浙江省台州市",
"86150048", "内蒙古兴安盟",
"861352537", "河南省平顶山市",
"861533548", "山东省泰安市",
"861361334", "河北省秦皇岛市",
"861373998", "内蒙古呼和浩特市",
"861571082", "广东省深圳市",
"861889546", "安徽省宿州市",
"861301517", "内蒙古鄂尔多斯市",
"861554059", "内蒙古呼伦贝尔市",
"861310169", "黑龙江省双鸭山市",
"86189944", "江苏省苏州市",
"861871821", "广东省湛江市",
"861530321", "河北省石家庄市",
"86156856", "贵州省铜仁地区",
"861595044", "江苏省无锡市",
"861364317", "河北省沧州市",
"861367784", "广西梧州市",
"86177281", "广东省广州市",
"86157588", "云南省文山壮族苗族自治州",
"861893959", "河南省漯河市",
"861317617", "山东省济宁市",
"86130361", "湖北省武汉市",
"861318747", "云南省临沧市",
"86131368", "黑龙江省大庆市",
"861530638", "山东省烟台市",
"861320361", "湖南省常德市",
"861820373", "河南省新乡市",
"861594776", "内蒙古呼伦贝尔市",
"861575804", "云南省玉溪市",
"861336342", "山西省大同市",
"861590512", "江苏省连云港市",
"861356092", "广东省肇庆市",
"861378021", "河北省石家庄市",
"861340442", "吉林省白城市",
"861829524", "宁夏固原市",
"861539699", "江苏省连云港市",
"861780773", "广西桂林市",
"861390548", "山东省泰安市",
"861500923", "陕西省渭南市",
"861780342", "山西省晋城市",
"861810724", "湖北省荆门市",
"861338532", "山东省青岛市",
"861377260", "陕西省咸阳市",
"861869408", "湖北省宜昌市",
"86147476", "内蒙古赤峰市",
"861708729", "江西省宜春市",
"861358973", "山东省滨州市",
"861338488", "内蒙古呼和浩特市",
"861534730", "湖南省岳阳市",
"86138929", "陕西省咸阳市",
"861502591", "甘肃省定西市",
"861810970", "青海省海北藏族自治州",
"861300165", "山东省威海市",
"861855147", "江苏省泰州市",
"861341348", "广东省清远市",
"861836761", "浙江省嘉兴市",
"861592917", "陕西省延安市",
"861366784", "广西梧州市",
"861336773", "广西桂林市",
"861787573", "广东省梅州市",
"861533953", "贵州省安顺市",
"861529364", "甘肃省甘南藏族自治州",
"861860752", "广东省惠州市",
"861370422", "辽宁省鞍山市",
"861598642", "广东省广州市",
"861565088", "安徽省阜阳市",
"861452357", "河南省驻马店市",
"861771259", "江苏省泰州市",
"861452428", "辽宁省大连市",
"86138387", "河南省南阳市",
"86183553", "安徽省芜湖市",
"861570514", "江苏省连云港市",
"861566531", "安徽省安庆市",
"861595802", "浙江省杭州市",
"861470461", "黑龙江省哈尔滨市",
"861771778", "河北省石家庄市",
"861452544", "山东省济南市",
"861314861", "广东省河源市",
"861867668", "广东省深圳市",
"86177612", "四川省成都市",
"86184436", "吉林省白城市",
"861569567", "安徽省亳州市",
"861565939", "福建省莆田市",
"861898447", "贵州省毕节地区",
"861554816", "内蒙古乌兰察布市",
"861863832", "河南省新乡市",
"861570837", "四川省阿坝藏族羌族自治州",
"861312446", "福建省泉州市",
"86138416", "辽宁省锦州市",
"861832982", "陕西省榆林市",
"861831337", "云南省普洱市",
"861380323", "河北省沧州市",
"86156576", "浙江省台州市",
"86183371", "河南省郑州市",
"861810281", "广东省广州市",
"861707921", "浙江省丽水市",
"861811573", "江苏省徐州市",
"861311561", "黑龙江省哈尔滨市",
"861847693", "广东省湛江市",
"86133499", "湖北省武汉市",
"86187257", "重庆市",
"861521764", "广东省佛山市",
"861803332", "广东省韶关市",
"861768130", "安徽省滁州市",
"861877983", "江西省景德镇市",
"861313654", "浙江省湖州市",
"861869327", "甘肃省兰州市",
"861323464", "黑龙江省齐齐哈尔市",
"861700918", "山东省济南市",
"861869458", "浙江省杭州市",
"861379728", "湖北省荆州市",
"861390424", "辽宁省本溪市",
"861859954", "福建省泉州市",
"86156397", "河南省郑州市",
"861881999", "广东省惠州市",
"861332975", "湖北省仙桃市",
"861308379", "河南省洛阳市",
"861709646", "山东省烟台市",
"861868430", "吉林省长春市",
"861502950", "陕西省咸阳市",
"861561048", "山东省青岛市",
"861884683", "黑龙江省哈尔滨市",
"861550045", "吉林省白山市",
"861830587", "浙江省温州市",
"861871895", "广东省梅州市",
"861528351", "四川省雅安市",
"861860702", "江西省九江市",
"86139428", "辽宁省大连市",
"861530395", "河南省漯河市",
"861580571", "浙江省杭州市",
"86187642", "山东省青岛市",
"86136675", "新疆巴音郭楞蒙古自治州",
"861850569", "安徽省合肥市",
"861368879", "云南省丽江市",
"861331267", "云南省红河哈尼族彝族自治州",
"861452307", "河南省新乡市",
"86132674", "广东省东莞市",
"8615995", "江苏省苏州市",
"86185664", "广东省佛山市",
"861345118", "湖北省荆门市",
"861329459", "山西省运城市",
"86183791", "江西省南昌市",
"861342990", "湖北省黄冈市",
"861458768", "广东省潮州市",
"861369449", "吉林省四平市",
"861321565", "安徽省合肥市",
"861862514", "江苏省苏州市",
"861534836", "湖南省常德市",
"861881207", "河北省沧州市",
"861809866", "安徽省芜湖市",
"861362627", "江苏省南通市",
"861833987", "河南省三门峡市",
"861524789", "内蒙古锡林郭勒盟",
"861530503", "福建省泉州市",
"861818277", "黑龙江省鸡西市",
"861318179", "山东省泰安市",
"861897709", "广西南宁市",
"861523309", "河北省承德市",
"861317459", "福建省龙岩市",
"861531536", "山东省潍坊市",
"86177704", "江西省抚州市",
"861536470", "山西省忻州市",
"861879110", "陕西省延安市",
"861771997", "河南省商丘市",
"861323213", "广东省云浮市",
"861589775", "湖北省黄石市",
"861802337", "广东省云浮市",
"861869366", "甘肃省庆阳市",
"861454782", "山东省济南市",
"861332230", "辽宁省营口市",
"861514492", "内蒙古兴安盟",
"861530386", "河南省洛阳市",
"861393199", "河北省石家庄市",
"861893297", "河北省邢台市",
"861871886", "广东省深圳市",
"861327669", "江苏省徐州市",
"861518355", "四川省南充市",
"861897278", "湖北省黄石市",
"861356852", "四川省内江市",
"861596436", "山东省聊城市",
"861552898", "四川省宜宾市",
"861320272", "广东省东莞市",
"861302267", "浙江省丽水市",
"861802169", "江苏省南通市",
"861899877", "广东省梅州市",
"861879962", "新疆博尔塔拉蒙古自治州",
"861376589", "贵州省毕节地区",
"861769247", "河北省沧州市",
"861338563", "安徽省宣城市",
"861505465", "山东省菏泽市",
"861836243", "江苏省连云港市",
"861569526", "江苏省南通市",
"861301975", "黑龙江省佳木斯市",
"861532520", "浙江省衢州市",
"861707348", "河北省唐山市",
"86183410", "辽宁省铁岭市",
"861896623", "浙江省宁波市",
"861319669", "江苏省扬州市",
"861375981", "陕西省汉中市",
"861890509", "福建省南平市",
"861588587", "贵州省毕节地区",
"861341921", "四川省广元市",
"861805942", "福建省宁德市",
"861359194", "辽宁省朝阳市",
"861335416", "辽宁省锦州市",
"861350642", "山东省青岛市",
"861855258", "江苏省扬州市",
"861530553", "安徽省芜湖市",
"861559946", "贵州省铜仁地区",
"86832", "四川省内江市\、资阳市",
"861527690", "新疆哈密地区",
"861521898", "广东省汕头市",
"861317409", "江苏省南京市",
"861556338", "山东省临沂市",
"861504726", "内蒙古巴彦淖尔市",
"861310365", "河南省平顶山市",
"861813570", "河南省商丘市",
"861845826", "浙江省湖州市",
"861568016", "四川省达州市",
"861519690", "四川省遂宁市",
"861386701", "浙江省衢州市",
"861590973", "青海省黄南藏族自治州",
"861507164", "湖北省随州市",
"861899964", "新疆喀什地区",
"861471709", "甘肃省酒泉市",
"861768913", "西藏山南地区",
"861898901", "西藏拉萨市",
"861558548", "吉林省白山市",
"861898590", "贵州省六盘水市",
"861806897", "江苏省南通市",
"861856076", "山东省济南市",
"861577957", "江西省南昌市",
"86145808", "浙江省宁波市",
"861534891", "西藏拉萨市",
"861830979", "青海省海西蒙古族藏族自治州",
"861882043", "广东省湛江市",
"86159278", "湖北省荆州市",
"861382494", "广东省清远市",
"861459061", "广东省肇庆市",
"861376798", "江西省南昌市",
"861572752", "江西省上饶市",
"861581375", "广东省江门市",
"861352565", "河南省南阳市",
"861890559", "安徽省黄山市",
"861583280", "河北省沧州市",
"861595124", "江苏省宿迁市",
"86133202", "重庆市",
"86151496", "内蒙古鄂尔多斯市",
"86183415", "辽宁省丹东市",
"861453352", "辽宁省大连市",
"861760427", "辽宁省盘锦市",
"861501889", "广东省江门市",
"861354220", "广东省揭阳市",
"861760358", "山西省吕梁市",
"861705518", "北京市",
"861459576", "陕西省铜川市",
"861572166", "山西省晋城市",
"861770480", "内蒙古呼和浩特市",
"861319474", "四川省巴中市",
"861821142", "广东省深圳市",
"861358241", "河北省张家口市",
"861356573", "新疆石河子市",
"861518072", "贵州省贵阳市",
"861840574", "浙江省宁波市",
"861700858", "贵州省六盘水市",
"861853208", "河北省邯郸市",
"861336932", "甘肃省定西市",
"861881473", "黑龙江省牡丹江市",
"861301765", "河南省郑州市",
"861327474", "内蒙古兴安盟",
"861859537", "河南省周口市",
"861554530", "黑龙江省牡丹江市",
"861504589", "黑龙江省大庆市",
"86156796", "江西省吉安市",
"861575914", "福建省漳州市",
"861582670", "湖北省恩施土家族苗族自治州",
"861780932", "甘肃省定西市",
"861593092", "河北省保定市",
"861373981", "河北省邢台市",
"861539195", "安徽省马鞍山市",
"861341938", "四川省遂宁市",
"861885125", "江苏省连云港市",
"861560539", "山东省临沂市",
"861772871", "广东省清远市",
"861508609", "贵州省遵义市",
"861314286", "江苏省泰州市",
"861806219", "湖北省随州市",
"861364409", "辽宁省大连市",
"861510471", "内蒙古呼和浩特市",
"861815132", "江苏省南通市",
"861761452", "黑龙江省齐齐哈尔市",
"861884640", "黑龙江省七台河市",
"861816289", "湖北省黄冈市",
"861589647", "江苏省无锡市",
"861569598", "福建省三明市",
"861365871", "云南省昆明市",
"861889442", "甘肃省酒泉市",
"861774034", "河北省邯郸市",
"861350450", "黑龙江省哈尔滨市",
"861377735", "浙江省杭州市",
"861830769", "广东省东莞市",
"861831665", "广东省揭阳市",
"861533813", "广东省江门市",
"86138786", "广西南宁市",
"86132818", "四川省成都市",
"86185734", "湖南省衡阳市",
"861871743", "陕西省渭南市",
"861831947", "广东省广州市",
"861379890", "广东省东莞市",
"861398703", "云南省临沧市",
"861321423", "辽宁省沈阳市",
"86183709", "江西省赣州市",
"861899774", "新疆喀什地区",
"861565349", "山东省聊城市",
"861317161", "河北省承德市",
"861850787", "广西钦州市",
"861870478", "内蒙古巴彦淖尔市",
"861826239", "江苏省盐城市",
"861845898", "浙江省绍兴市",
"861700808", "江苏省南通市",
"861454418", "福建省漳州市",
"861844749", "内蒙古阿拉善盟",
"86151477", "内蒙古鄂尔多斯市",
"86158671", "浙江省杭州市",
"8618019", "上海市",
"861346746", "湖南省永州市",
"861597563", "广东省广州市",
"861588493", "四川省广安市",
"861324236", "广东省惠州市",
"861803942", "河南省商丘市",
"861452485", "内蒙古巴彦淖尔市",
"861537045", "江苏省南通市",
"861585280", "江苏省无锡市",
"861857587", "广东省佛山市",
"861457201", "四川省成都市",
"861873846", "河南省驻马店市",
"861598394", "四川省广元市",
"861479723", "山西省大同市",
"861846505", "宁夏中卫市",
"86185351", "山西省太原市",
"861472986", "陕西省西安市",
"861369865", "山东省青岛市",
"861705284", "广东省深圳市",
"861565025", "山东省潍坊市",
"861370535", "山东省烟台市",
"861500690", "山东省日照市",
"861364459", "黑龙江省大庆市",
"861324449", "吉林省松原市",
"861530872", "云南省大理白族自治州",
"861590763", "广东省清远市",
"861573094", "甘肃省天水市",
"861568931", "山东省淄博市",
"861328671", "广东省河源市",
"861862734", "湖南省衡阳市",
"861338425", "辽宁省丹东市",
"861569789", "江西省赣州市",
"861309365", "安徽省蚌埠市",
"861866456", "广东省深圳市",
"861395948", "福建省龙岩市",
"86184029", "陕西省西安市",
"861505523", "安徽省六安市",
"861773666", "广西柳州市",
"861378989", "山东省淄博市",
"861344064", "上海市",
"861808612", "湖北省襄樊市",
"861810760", "广东省中山市",
"861315604", "山东省青岛市",
"861377224", "陕西省安康市",
"86152648", "山东省泰安市",
"861809970", "新疆克拉玛依市",
"861319165", "河北省保定市",
"861562478", "内蒙古巴彦淖尔市",
"861573804", "河南省濮阳市",
"861586987", "湖南省邵阳市",
"861537136", "江苏省宿迁市",
"86158893", "广东省深圳市",
"861824458", "河北省衡水市",
"861373935", "甘肃省金昌市",
"861768853", "广东省深圳市",
"861350394", "河南省周口市",
"861556199", "黑龙江省鸡西市",
"861802947", "广东省韶关市",
"86157388", "河南省郑州市",
"861577534", "四川省成都市",
"861555100", "安徽省滁州市",
"861528437", "河北省沧州市",
"86130561", "江苏省盐城市",
"861811802", "江苏省常州市",
"861367861", "山东省东营市",
"861800542", "山东省青岛市",
"861590499", "辽宁省辽阳市",
"86138587", "浙江省温州市",
"86183353", "山西省阳泉市",
"861539041", "四川省成都市",
"861311076", "福建省福州市",
"861318675", "浙江省丽水市",
"861575757", "浙江省绍兴市",
"861814668", "江西省赣州市",
"861361992", "新疆乌鲁木齐市",
"861559391", "甘肃省陇南市",
"861506040", "福建省福州市",
"861570734", "湖南省衡阳市",
"861320687", "黑龙江省牡丹江市",
"861452496", "内蒙古通辽市",
"861536125", "广东省广州市",
"861583243", "河北省承德市",
"861472995", "陕西省安康市",
"861829560", "宁夏银川市",
"861312594", "黑龙江省大庆市",
"861882080", "广东省广州市",
"861598450", "四川省雅安市",
"86132831", "河北省邯郸市",
"861564364", "吉林省长春市",
"861323420", "辽宁省铁岭市",
"861709988", "广东省深圳市",
"86156376", "河南省信阳市",
"861870310", "河北省邯郸市",
"861597488", "云南省昭通市",
"86136883", "四川省成都市",
"861503651", "河南省焦作市",
"86183571", "浙江省杭州市",
"861559336", "甘肃省白银市",
"861454370", "山东省济南市",
"861323679", "辽宁省葫芦岛市",
"861768803", "广东省东莞市",
"861532889", "四川省南充市",
"861338712", "湖北省黄冈市",
"861839517", "宁夏银川市",
"86145392", "广东省深圳市",
"861537618", "山东省济南市",
"861534510", "江苏省无锡市",
"861566444", "山东省泰安市",
"861865832", "浙江省台州市",
"861839834", "四川省攀枝花市",
"861337642", "山东省青岛市",
"861339624", "山东省威海市",
"861552867", "四川省巴中市",
"861370581", "浙江省杭州市",
"861876630", "山东省威海市",
"861538748", "湖南省长沙市",
"861783532", "山西省阳泉市",
"861376820", "广西南宁市",
"861590732", "湖南省湘潭市",
"861827211", "湖北省孝感市",
"861364617", "江苏省无锡市",
"86151643", "吉林省长春市",
"861864524", "黑龙江省大庆市",
"861771968", "陕西省西安市",
"861520475", "内蒙古通辽市",
"86130654", "辽宁省鞍山市",
"861590241", "辽宁省营口市",
"861535903", "福建省宁德市",
"861575707", "浙江省衢州市",
"86180826", "陕西省西安市",
"861388790", "云南省西双版纳傣族自治州",
"861305262", "辽宁省朝阳市",
"861361634", "山东省莱芜市",
"861539186", "安徽省宿州市",
"861521974", "广东省茂名市",
"861581892", "广东省茂名市",
"861458797", "湖南省长沙市",
"86183785", "广西玉林市",
"861318844", "辽宁省铁岭市",
"861346840", "山东省淄博市",
"861598400", "四川省泸州市",
"861814552", "黑龙江省黑河市",
"861521720", "广东省广州市",
"861562180", "山东省德州市",
"861836280", "江苏省南通市",
"86156597", "福建省福州市",
"861760466", "黑龙江省哈尔滨市",
"861353491", "广东省汕头市",
"86182582", "浙江省杭州市",
"861782078", "广东省深圳市",
"861453086", "安徽省芜湖市",
"861830473", "内蒙古乌海市",
"861860484", "内蒙古乌兰察布市",
"861350374", "河南省许昌市",
"861346361", "河北省廊坊市",
"861831748", "河南省濮阳市",
"861334088", "四川省绵阳市",
"861573818", "河南省平顶山市",
"8613718", "北京市",
"861594728", "内蒙古巴彦淖尔市",
"861809501", "四川省巴中市",
"861306244", "福建省厦门市",
"86186040", "辽宁省沈阳市",
"861809990", "新疆克拉玛依市",
"86156162", "湖南省长沙市",
"86186422", "辽宁省鞍山市",
"861365730", "湖南省岳阳市",
"861342866", "广东省深圳市",
"861769922", "新疆昌吉回族自治州",
"861366452", "黑龙江省齐齐哈尔市",
"861835599", "安徽省黄山市",
"861327300", "河南省周口市",
"861843632", "河南省开封市",
"861523660", "河南省新乡市",
"861378440", "河北省石家庄市",
"861452476", "黑龙江省哈尔滨市",
"861338062", "广东省珠海市",
"861311750", "湖南省岳阳市",
"861801417", "江苏省淮安市",
"86187365", "河南省南阳市",
"861811487", "江苏省无锡市",
"861530240", "广东省佛山市",
"861893682", "江苏省泰州市",
"861568824", "湖南省娄底市",
"861845014", "福建省漳州市",
"861312574", "吉林省长春市",
"861597190", "湖北省十堰市",
"861857148", "湖北省武汉市",
"861302759", "河南省安阳市",
"861590479", "内蒙古锡林郭勒盟",
"861833412", "贵州省安顺市",
"861786461", "山东省滨州市",
"861824741", "内蒙古乌兰察布市",
"861332015", "江西省宜春市",
"86138589", "浙江省金华市",
"861325186", "吉林省白城市",
"861567087", "河南省焦作市",
"86150126", "广东省深圳市",
"861359849", "河南省洛阳市",
"861846231", "山东省临沂市",
"861317903", "吉林省四平市",
"861577020", "云南省怒江傈僳族自治州",
"861852437", "辽宁省丹东市",
"86183506", "福建省漳州市",
"861539464", "江苏省连云港市",
"861521632", "山东省枣庄市",
"861855525", "安徽省宣城市",
"861361972", "青海省海东地区",
"861889369", "甘肃省张掖市",
"861479660", "江西省景德镇市",
"861318695", "浙江省杭州市",
"86153963", "福建省泉州市",
"861518852", "河南省许昌市",
"86156301", "河北省石家庄市",
"861310862", "云南省楚雄彝族自治州",
"861318338", "河南省驻马店市",
"861865945", "福建省莆田市",
"861323699", "辽宁省营口市",
"861454390", "贵州省贵阳市",
"86769", "广东省东莞市",
"86188193", "广东省广州市",
"861319350", "河南省安阳市",
"861533617", "陕西省宝鸡市",
"861569037", "河北省邢台市",
"861302278", "山东省潍坊市",
"86182044", "吉林省松原市",
"861880665", "广东省深圳市",
"861551771", "河南省南阳市",
"861899868", "广东省阳江市",
"861587516", "广东省阳江市",
"861335320", "吉林省长春市",
"86170991", "江西省南昌市",
"86159741", "湖南省长沙市",
"861366402", "内蒙古包头市",
"861315136", "江苏省盐城市",
"861344299", "新疆塔城地区",
"861880947", "甘肃省酒泉市",
"861835788", "浙江省丽水市",
"861804212", "浙江省温州市",
"861367340", "河南省周口市",
"86157723", "贵州省安顺市",
"861832659", "安徽省马鞍山市",
"861311700", "湖北省孝感市",
"861882542", "广东省佛山市",
"861521994", "广东省中山市",
"861458777", "湖南省怀化市",
"861891450", "江苏省泰州市",
"861478532", "贵州省毕节地区",
"861859098", "陕西省铜川市",
"861325041", "广东省湛江市",
"861453855", "甘肃省定西市",
"861329953", "宁夏吴忠市",
"861321146", "广西百色市",
"861839348", "甘肃省陇南市",
"86187360", "河南省郑州市",
"861857999", "广西南宁市",
"861583346", "河北省唐山市",
"861506582", "山东省泰安市",
"861887187", "湖北省武汉市",
"861316548", "山东省淄博市",
"861815447", "湖北省黄冈市",
"861387289", "湖北省随州市",
"861347387", "河北省石家庄市",
"861810010", "天津市",
"861370251", "广东省中山市",
"86188311", "河北省石家庄市",
"861800080", "广东省潮州市",
"861334939", "黑龙江省大庆市",
"86137752", "江苏省常州市",
"861363510", "广西梧州市",
"861538451", "陕西省延安市",
"861356305", "山东省滨州市",
"86134331", "广东省佛山市",
"861358013", "广东省韶关市",
"861317953", "江苏省常州市",
"861553637", "山西省晋中市",
"861705504", "广东省佛山市",
"861776115", "四川省广安市",
"861839921", "新疆阿克苏地区",
"86139313", "河北省保定市",
"861586599", "山东省日照市",
"861311856", "贵州省铜仁地区",
"861360910", "陕西省咸阳市",
"861806774", "浙江省台州市",
"861339359", "山西省运城市",
"861532612", "辽宁省沈阳市",
"861879792", "江西省上饶市",
"86138505", "福建省漳州市",
"861378597", "河北省邢台市",
"86188338", "河北省秦皇岛市",
"861857207", "湖北省荆州市",
"861538947", "陕西省咸阳市",
"861454454", "江西省抚州市",
"86157245", "辽宁省大连市",
"86188470", "内蒙古呼伦贝尔市",
"861568102", "四川省德阳市",
"861314556", "安徽省安庆市",
"861324333", "河南省许昌市",
"861319494", "四川省攀枝花市",
"861815951", "福建省泉州市",
"861331278", "云南省大理白族自治州",
"861533409", "湖北省孝感市",
"861819043", "四川省广元市",
"861575908", "福建省三明市",
"861331709", "江西省萍乡市",
"861812650", "广东省深圳市",
"861569578", "浙江省丽水市",
"861313753", "河南省平顶山市",
"861824263", "辽宁省铁岭市",
"861893403", "广东省湛江市",
"861830019", "广东省广州市",
"861336151", "山东省东营市",
"861800755", "广东省深圳市",
"861880451", "黑龙江省哈尔滨市",
"861865626", "安徽省蚌埠市",
"861315045", "新疆乌鲁木齐市",
"861309150", "黑龙江省鹤岗市",
"861582690", "湖北省武汉市",
"861308138", "辽宁省本溪市",
"861772891", "广东省东莞市",
"861320883", "云南省临沧市",
"861768073", "湖南省娄底市",
"861314930", "广东省珠海市",
"861311806", "四川省内江市",
"861510436", "吉林省白城市",
"86176434", "吉林省四平市",
"861518124", "四川省雅安市",
"861477394", "湖南省邵阳市",
"8613883", "重庆市",
"86151479", "内蒙古锡林郭勒盟",
"861572484", "江苏省盐城市",
"861760314", "河北省承德市",
"861705554", "四川省成都市",
"861357159", "陕西省铜川市",
"861585550", "安徽省马鞍山市",
"861811072", "安徽省宿州市",
"861587153", "湖北省鄂州市",
"861303625", "江西省上饶市",
"86138500", "福建省厦门市",
"861588473", "四川省达州市",
"861339309", "河北省邢台市",
"861358479", "江苏省盐城市",
"861376968", "云南省曲靖市",
"861700814", "江苏省南通市",
"861552663", "吉林省长春市",
"86188475", "内蒙古通辽市",
"861770611", "江苏省常州市",
"861816509", "陕西省西安市",
"861453095", "山西省太原市",
"861310833", "四川省乐山市",
"861454404", "福建省漳州市",
"861365891", "西藏拉萨市",
"861528142", "四川省宜宾市",
"861818819", "贵州省黔西南布依族苗族自治州",
"861817193", "湖北省黄石市",
"861808889", "广东省江门市",
"86183707", "江西省赣州市",
"861772836", "广东省中山市",
"861700537", "山东省济宁市",
"861343154", "广东省东莞市",
"861580810", "四川省攀枝花市",
"861328691", "广东省中山市",
"861888240", "四川省宜宾市",
"861301015", "山东省淄博市",
"861308616", "江西省吉安市",
"861331759", "湖北省随州市",
"861386560", "安徽省马鞍山市",
"861342827", "广东省江门市",
"86153226", "广东省江门市",
"86186616", "山东省青岛市",
"861325195", "浙江省绍兴市",
"861777628", "广西桂林市",
"86184027", "湖北省武汉市",
"861510249", "辽宁省辽阳市",
"861893453", "江苏省南通市",
"861780674", "广东省中山市",
"861364813", "四川省眉山市",
"861313703", "河南省商丘市",
"861318686", "浙江省宁波市",
"861309100", "河北省石家庄市",
"861478563", "贵州省黔南布依族苗族自治州",
"861361513", "江苏省徐州市",
"861459531", "西藏拉萨市",
"861800705", "江西省宜春市",
"861500429", "辽宁省葫芦岛市",
"861304313", "河北省秦皇岛市",
"861458149", "浙江省金华市",
"861856028", "山东省淄博市",
"861344957", "山东省青岛市",
"861598374", "四川省甘孜藏族自治州",
"861853432", "山西省运城市",
"861533161", "云南省临沧市",
"861550654", "山东省菏泽市",
"861459711", "山东省德州市",
"861361733", "湖南省株洲市",
"861345104", "湖北省黄石市",
"861535409", "河北省邢台市",
"861865111", "江苏省苏州市",
"861835725", "浙江省湖州市",
"861318199", "山东省东营市",
"861813951", "新疆伊犁哈萨克自治州",
"861317813", "福建省莆田市",
"861803266", "河北省石家庄市",
"861867745", "广西贺州市",
"861771977", "陕西省渭南市",
"861509491", "山东省威海市",
"861589795", "湖北省襄樊市",
"861536490", "山西省运城市",
"861707834", "云南省昭通市",
"861313329", "山西省运城市",
"861777631", "广西柳州市",
"861857473", "湖南省衡阳市",
"86138305", "甘肃省武威市",
"861367383", "河南省商丘市",
"86134518", "江苏省南京市",
"861337374", "河南省新乡市",
"86188538", "山东省泰安市",
"861588257", "四川省广安市",
"861571656", "河南省平顶山市",
"861342970", "陕西省西安市",
"861368009", "广东省韶关市",
"861360706", "江西省南昌市",
"861459528", "云南省文山壮族苗族自治州",
"861767334", "湖南省益阳市",
"861555637", "安徽省阜阳市",
"861517416", "辽宁省丹东市",
"861453915", "广东省清远市",
"861399405", "山西省忻州市",
"861310150", "黑龙江省哈尔滨市",
"861820555", "安徽省马鞍山市",
"86170985", "浙江省台州市",
"861838900", "西藏拉萨市",
"861855799", "浙江省嘉兴市",
"861899897", "广东省汕头市",
"86156779", "广西北海市",
"861806964", "浙江省绍兴市",
"861594890", "吉林省白城市",
"861860545", "山东省烟台市",
"861856700", "河南省开封市",
"861348175", "广西柳州市",
"861347455", "陕西省咸阳市",
"861379927", "福建省厦门市",
"861339723", "湖北省黄石市",
"861700717", "湖北省荆州市",
"861301995", "辽宁省盘锦市",
"861812442", "广东省湛江市",
"861568766", "云南省文山壮族苗族自治州",
"861332986", "湖北省襄樊市",
"861586412", "山东省济宁市",
"861300494", "福建省南平市",
"861514472", "内蒙古包头市",
"861893277", "河北省沧州市",
"861800043", "河北省保定市",
"861895403", "山东省东营市",
"861573908", "新疆博尔塔拉蒙古自治州",
"861478425", "河南省周口市",
"861552878", "四川省乐山市",
"861897298", "湖北省随州市",
"861557240", "湖北省恩施土家族苗族自治州",
"86132286", "重庆市",
"861813901", "新疆昌吉回族自治州",
"861535459", "吉林省白山市",
"861394869", "内蒙古赤峰市",
"861509249", "山东省枣庄市",
"861570633", "山东省日照市",
"861521878", "广东省东莞市",
"861331323", "河北省保定市",
"861318948", "广东省湛江市",
"861766012", "山东省济南市",
"861550604", "吉林省松原市",
"861508982", "广东省江门市",
"86134114", "广东省珠海市",
"861593305", "河北省唐山市",
"861590993", "新疆石河子市",
"861363891", "西藏拉萨市",
"861814677", "江西省赣州市",
"861886617", "山东省潍坊市",
"861519670", "四川省内江市",
"861308121", "辽宁省鞍山市",
"861870426", "辽宁省盘锦市",
"861360756", "福建省漳州市",
"861512647", "云南省临沧市",
"861571606", "福建省龙岩市",
"861476932", "云南省楚雄彝族自治州",
"861890289", "广东省佛山市",
"861328049", "山东省济宁市",
"861320746", "湖南省永州市",
"86138300", "甘肃省白银市",
"861880337", "河北省沧州市",
"861558317", "四川省广元市",
"861596471", "山东省德州市",
"861367930", "甘肃省白银市",
"861399455", "山西省晋中市",
"861512965", "陕西省西安市",
"86135456", "湖北省荆州市",
"861855588", "安徽省六安市",
"861834466", "江苏省南京市",
"86170980", "浙江省杭州市",
"861820505", "江苏省苏州市",
"86177866", "湖北省黄冈市",
"861380267", "广东省珠海市",
"861839938", "新疆和田地区",
"861509436", "江苏省扬州市",
"861856750", "河南省信阳市",
"861340369", "山西省太原市",
"861319546", "安徽省马鞍山市",
"861342281", "广东省中山市",
"861895453", "山东省济南市",
"861534871", "云南省昆明市",
"861898570", "贵州省安顺市",
"861806877", "江苏省常州市",
"861354099", "四川省阿坝藏族羌族自治州",
"86135843", "江苏省常州市",
"861592521", "云南省昆明市",
"86153611", "广东省湛江市",
"861327546", "山东省东营市",
"861367556", "安徽省安庆市",
"861809623", "四川省宜宾市",
"861830999", "新疆伊犁哈萨克自治州",
"861309833", "湖北省武汉市",
"861522961", "陕西省延安市",
"86187884", "云南省昆明市",
"861829701", "青海省海东地区",
"861570558", "安徽省阜阳市",
"861584803", "内蒙古乌兰察布市",
"861539679", "江苏省连云港市",
"861780793", "江西省上饶市",
"861363730", "湖南省岳阳市",
"861580536", "山东省潍坊市",
"861771589", "江苏省苏州市",
"861898163", "四川省雅安市",
"861538337", "河北省沧州市",
"861478712", "云南省大理白族自治州",
"861562426", "山东省德州市",
"861303688", "广西南宁市",
"861508360", "江西省新余市",
"861351509", "福建省南平市",
"861834427", "广东省茂名市",
"861364953", "宁夏固原市",
"86139450", "黑龙江省哈尔滨市",
"861820393", "河南省濮阳市",
"861324943", "广东省深圳市",
"861300300", "安徽省合肥市",
"861348464", "陕西省延安市",
"86183306", "河北省廊坊市",
"861587736", "陕西省汉中市",
"861322559", "安徽省黄山市",
"861362549", "山东省临沂市",
"86774", "广西梧州市",
"86156501", "山东省青岛市",
"861390317", "河北省沧州市",
"861321929", "四川省巴中市",
"861536547", "江苏省连云港市",
"861787593", "广东省梅州市",
"861580950", "宁夏银川市",
"861850646", "山东省东营市",
"861318321", "河南省漯河市",
"861888283", "四川省雅安市",
"861770339", "河北省邢台市",
"861558187", "山西省晋城市",
"861870467", "黑龙江省鸡西市",
"861358993", "山东省德州市",
"86187565", "安徽省合肥市",
"86155613", "内蒙古赤峰市",
"861336793", "江西省上饶市",
"861525660", "安徽省铜陵市",
"861781751", "广东省韶关市",
"861776619", "江苏省无锡市",
"861810990", "新疆克拉玛依市",
"86157021", "上海市",
"86138927", "陕西省宝鸡市",
"861801841", "江苏省南通市",
"861524037", "江苏省宿迁市",
"861515400", "山东省威海市",
"861869741", "内蒙古包头市",
"861829751", "安徽省芜湖市",
"861333320", "河北省邯郸市",
"86187259", "重庆市",
"861458967", "广东省汕尾市",
"861869232", "湖南省湘潭市",
"861801105", "四川省德阳市",
"861847673", "广东省湛江市",
"861568727", "云南省丽江市",
"86147401", "辽宁省铁岭市",
"861817751", "广西玉林市",
"86178541", "山东省济南市",
"861389594", "黑龙江省鸡西市",
"861330159", "江苏省南京市",
"86139455", "黑龙江省绥化市",
"861364903", "四川省宜宾市",
"861351559", "安徽省黄山市",
"861809010", "四川省雅安市",
"86170714", "北京市",
"861846228", "山东省聊城市",
"861530375", "河南省三门峡市",
"861782026", "广东省揭阳市",
"861572545", "山东省烟台市",
"861871875", "广东省中山市",
"861831222", "广东省广州市",
"861322509", "福建省莆田市",
"86182922", "陕西省榆林市",
"861534622", "河南省信阳市",
"86134531", "山西省太原市",
"861805881", "浙江省杭州市",
"861594731", "内蒙古呼和浩特市",
"861450515", "吉林省通化市",
"861300350", "江苏省徐州市",
"861365510", "江苏省盐城市",
"861818909", "西藏昌都地区",
"861813447", "河南省漯河市",
"861577708", "广西北海市",
"86180744", "湖南省张家界市",
"861580591", "福建省厦门市",
"861580900", "新疆克拉玛依市",
"861335364", "河南省安阳市",
"86181722", "广西柳州市",
"861588148", "四川省南充市",
"86187560", "安徽省合肥市",
"861303129", "新疆喀什地区",
"861320840", "黑龙江省佳木斯市",
"861876248", "江苏省南通市",
"861810551", "安徽省合肥市",
"861332995", "湖北省黄冈市",
"861301986", "辽宁省阜新市",
"861308399", "浙江省杭州市",
"861881979", "广东省韶关市",
"861781701", "广东省深圳市",
"861816751", "新疆阿克苏地区",
"861318116", "山东省日照市",
"861569201", "广东省广州市",
"861555947", "新疆阿克苏地区",
"861327600", "福建省泉州市",
"861339417", "辽宁省营口市",
"861324508", "江苏省苏州市",
"861555665", "安徽省淮北市",
"861837011", "江西省九江市",
"861874068", "陕西省榆林市",
"86156132", "河北省保定市",
"86158307", "河北省邯郸市",
"861348379", "河北省保定市",
"861529499", "河南省周口市",
"861782035", "广东省肇庆市",
"861378075", "山东省东营市",
"861308186", "河北省秦皇岛市",
"861319600", "吉林省长春市",
"861393375", "河北省张家口市",
"861471827", "广东省河源市",
"861890560", "安徽省合肥市",
"861477963", "江西省抚州市",
"861811109", "四川省眉山市",
"861805974", "福建省莆田市",
"861372246", "河北省廊坊市",
"861520438", "吉林省松原市",
"861350674", "浙江省宁波市",
"86130423", "重庆市",
"861391280", "江苏省镇江市",
"861520582", "浙江省湖州市",
"86155918", "陕西省西安市",
"861857856", "广东省肇庆市",
"86150182", "广东省揭阳市",
"861508624", "贵州省黔东南苗族侗族自治州",
"861522987", "陕西省宝鸡市",
"861803764", "河南省商丘市",
"861889669", "江苏省常州市",
"86186156", "山东省济南市",
"861309748", "云南省文山壮族苗族自治州",
"861318395", "四川省资阳市",
"86180436", "吉林省长春市",
"861509712", "甘肃省庆阳市",
"861470852", "贵州省遵义市",
"861314452", "黑龙江省齐齐哈尔市",
"861708097", "广东省佛山市",
"86158248", "河南省郑州市",
"861571540", "山东省菏泽市",
"861894702", "内蒙古呼伦贝尔市",
"86136028", "广东省广州市",
"861331990", "新疆克拉玛依市",
"861879847", "贵州省六盘水市",
"861450589", "辽宁省铁岭市",
"86187335", "河北省秦皇岛市",
"86137508", "浙江省杭州市",
"861893382", "广东省湛江市",
"861807693", "西藏山南地区",
"861590320", "河北省邯郸市",
"861808905", "西藏昌都地区",
"861576708", "广东省湛江市",
"86180644", "福建省厦门市",
"861327650", "江苏省淮安市",
"861330593", "福建省宁德市",
"861802150", "江苏省南京市",
"861816701", "浙江省金华市",
"861350845", "湖南省益阳市",
"861364548", "山东省泰安市",
"861805867", "浙江省绍兴市",
"861560776", "广西百色市",
"861335620", "山东省菏泽市",
"861576064", "四川省广安市",
"861529732", "河北省张家口市",
"861880365", "河南省驻马店市",
"861368710", "湖北省襄樊市",
"86186317", "河北省沧州市",
"861512937", "陕西省宝鸡市",
"861301348", "云南省玉溪市",
"861865367", "山东省济宁市",
"861453577", "福建省龙岩市",
"861308041", "河北省石家庄市",
"861531969", "陕西省安康市",
"861533317", "河北省沧州市",
"861361848", "湖南省长沙市",
"861570943", "甘肃省白银市",
"861530747", "湖南省衡阳市",
"861318638", "陕西省宝鸡市",
"861774815", "四川省绵阳市",
"861857806", "广东省韶关市",
"861818828", "贵州省六盘水市",
"861335479", "内蒙古锡林郭勒盟",
"86153738", "河北省石家庄市",
"861454690", "广东省广州市",
"861773263", "河北省廊坊市",
"861897827", "广西河池市",
"86396", "河南省驻马店市",
"861580525", "江苏省扬州市",
"86134361", "重庆市",
"86155713", "湖北省黄冈市",
"861391971", "甘肃省定西市",
"861459739", "湖南省长沙市",
"861329460", "山西省忻州市",
"861337793", "湖北省仙桃市",
"861894752", "内蒙古通辽市",
"861812494", "广东省广州市",
"861777619", "广西河池市",
"861314402", "广东省中山市",
"861593109", "河北省石家庄市",
"861347687", "湖北省咸宁市",
"861350151", "广东省广州市",
"861332921", "安徽省淮北市",
"861510532", "山东省青岛市",
"861839648", "福建省漳州市",
"86187330", "河北省沧州市",
"861300442", "江苏省常州市",
"861510488", "内蒙古呼伦贝尔市",
"86133343", "广东省佛山市",
"861577183", "陕西省渭南市",
"861816030", "新疆喀什地区",
"861380235", "广东省惠州市",
"861576758", "广东省湛江市",
"861370037", "河北省沧州市",
"861830916", "陕西省汉中市",
"861500418", "辽宁省阜新市",
"861808955", "四川省广元市",
"861562435", "山东省潍坊市",
"86155171", "河南省郑州市",
"861534984", "安徽省安庆市",
"861564973", "河南省濮阳市",
"861324633", "广东省佛山市",
"861594719", "内蒙古锡林郭勒盟",
"861809709", "青海省玉树藏族自治州",
"861571497", "新疆乌鲁木齐市",
"861573829", "河南省信阳市",
"861538365", "山西省长治市",
"861509425", "云南省昭通市",
"861502969", "陕西省榆林市",
"861567255", "湖北省咸宁市",
"861587234", "湖北省襄樊市",
"861596033", "福建省龙岩市",
"861815839", "浙江省金华市",
"861872776", "湖北省咸宁市",
"861850550", "安徽省滁州市",
"861389542", "宁夏石嘴山市",
"86189889", "广东省广州市",
"861452572", "福建省福州市",
"861822953", "湖南省湘西土家族苗族自治州",
"861519245", "山东省菏泽市",
"861553337", "河北省石家庄市",
"861556052", "内蒙古巴彦淖尔市",
"861328336", "河北省承德市",
"861370578", "浙江省温州市",
"861315470", "内蒙古呼伦贝尔市",
"86150273", "湖北省武汉市",
"86182729", "河南省驻马店市",
"861533187", "黑龙江省佳木斯市",
"861396665", "安徽省合肥市",
"861301921", "吉林省长春市",
"861573543", "山西省吕梁市",
"861773414", "河北省沧州市",
"86181387", "广东省广州市",
"861871934", "广东省梅州市",
"861857096", "湖南省郴州市",
"86158925", "四川省宜宾市",
"861803898", "广东省茂名市",
"86153711", "江苏省盐城市",
"861450977", "新疆和田地区",
"861524065", "广西南宁市",
"861366556", "安徽省安庆市",
"861380970", "广东省佛山市",
"861557844", "广西南宁市",
"861850936", "甘肃省张掖市",
"861868128", "四川省攀枝花市",
"861777407", "浙江省金华市",
"861821849", "广东省广州市",
"86135341", "广东省深圳市",
"861346405", "辽宁省朝阳市",
"861380724", "湖北省咸宁市",
"861870435", "吉林省通化市",
"861857750", "广西贵港市",
"861863398", "河北省唐山市",
"861330305", "河北省唐山市",
"861333993", "湖北省鄂州市",
"861373797", "广西河池市",
"861809759", "新疆博尔塔拉蒙古自治州",
"861768307", "四川省阿坝藏族羌族自治州",
"861881561", "安徽省淮北市",
"861773741", "河南省郑州市",
"861770311", "河北省石家庄市",
"861773232", "河北省唐山市",
"861562481", "内蒙古呼和浩特市",
"861517763", "广西百色市",
"861858788", "广西南宁市",
"861453989", "广东省东莞市",
"861380281", "广东省韶关市",
"861516416", "辽宁省锦州市",
"861595605", "安徽省合肥市",
"861567205", "湖北省恩施土家族苗族自治州",
"861810323", "河北省张家口市",
"861377259", "陕西省咸阳市",
"861334091", "四川省乐山市",
"86181416", "辽宁省锦州市",
"861882446", "广东省肇庆市",
"861478436", "河南省开封市",
"861850500", "福建省莆田市",
"861850991", "新疆乌鲁木齐市",
"861316813", "广东省湛江市",
"861779945", "新疆巴音郭楞蒙古自治州",
"861341975", "河南省开封市",
"86189254", "广东省东莞市",
"861884861", "贵州省毕节地区",
"861384873", "内蒙古包头市",
"86159187", "广东省广州市",
"86170702", "广东省广州市",
"861819574", "青海省海南藏族自治州",
"861304613", "广东省汕尾市",
"861452130", "河北省张家口市",
"861302990", "黑龙江省大庆市",
"861510563", "安徽省宣城市",
"861820774", "广西梧州市",
"861321098", "山东省德州市",
"861893960", "河南省周口市",
"861560870", "云南省昭通市",
"861557675", "湖南省永州市",
"86155931", "甘肃省兰州市",
"861335013", "四川省泸州市",
"861581321", "广东省汕尾市",
"861801309", "江苏省苏州市",
"861589284", "四川省乐山市",
"861761295", "陕西省宝鸡市",
"861891932", "甘肃省定西市",
"861303049", "内蒙古包头市",
"861311999", "新疆伊犁哈萨克自治州",
"861475973", "福建省福州市",
"861778177", "四川省攀枝花市",
"861308316", "安徽省安庆市",
"861812300", "四川省成都市",
"861330355", "山西省长治市",
"861328391", "河南省焦作市",
"861768544", "山东省青岛市",
"861857700", "广西防城港市",
"861841982", "甘肃省庆阳市",
"86152271", "河北省石家庄市",
"861500370", "河南省商丘市",
"861705775", "河南省郑州市",
"861555337", "山东省滨州市",
"861818885", "广东省深圳市",
"861787655", "广东省深圳市",
"861313470", "内蒙古呼伦贝尔市",
"861367683", "浙江省金华市",
"861337674", "广东省潮州市",
"86183607", "江苏省淮安市",
"861351701", "江西省鹰潭市",
"861808815", "云南省德宏傣族景颇族自治州",
"86152253", "河南省信阳市",
"861830856", "贵州省铜仁地区",
"86188568", "安徽省阜阳市",
"861571356", "山西省晋城市",
"861393892", "河南省商丘市",
"861388682", "湖北省十堰市",
"861570980", "青海省海北藏族自治州",
"86132222", "江苏省苏州市",
"861313629", "浙江省舟山市",
"861829509", "宁夏银川市",
"861588031", "福建省莆田市",
"861323138", "河北省秦皇岛市",
"861550354", "山西省晋中市",
"86180029", "广东省东莞市",
"861334911", "安徽省合肥市",
"861359351", "山西省临汾市",
"86153994", "陕西省西安市",
"861318872", "山东省临沂市",
"861335993", "黑龙江省黑河市",
"861337101", "山东省泰安市",
"861452853", "甘肃省平凉市",
"861321918", "四川省达州市",
"861390459", "黑龙江省大庆市",
"861859929", "新疆伊犁哈萨克自治州",
"861857028", "湖南省郴州市",
"861510425", "辽宁省铁岭市",
"861810709", "江西省南昌市",
"861362741", "湖南省长沙市",
"861511924", "广东省河源市",
"861804749", "内蒙古呼和浩特市",
"861301089", "广东省深圳市",
"861775414", "安徽省六安市",
"861580588", "浙江省丽水市",
"86170878", "江苏省徐州市",
"861577140", "内蒙古赤峰市",
"861858412", "四川省内江市",
"861580432", "吉林省吉林市",
"861868196", "陕西省渭南市",
"861511770", "贵州省铜仁地区",
"861303691", "广西南宁市",
"861380827", "四川省南充市",
"861880637", "山东省枣庄市",
"861558617", "湖北省荆门市",
"861787605", "广东省肇庆市",
"86139811", "四川省绵阳市",
"861571306", "河北省廊坊市",
"861820964", "宁夏固原市",
"861893924", "河南省郑州市",
"861830806", "西藏那曲地区",
"861576613", "广东省揭阳市",
"861351751", "广西南宁市",
"861392673", "广东省茂名市",
"861305325", "安徽省铜陵市",
"86155038", "河南省商丘市",
"861509563", "甘肃省金昌市",
"861829559", "宁夏银川市",
"861777115", "湖北省黄石市",
"861391243", "江苏省南通市",
"86158424", "辽宁省大连市",
"861846219", "山东省烟台市",
"861362414", "辽宁省本溪市",
"861355190", "四川省内江市",
"861306292", "江苏省镇江市",
"861337845", "广东省广州市",
"861821465", "云南省保山市",
"861814377", "甘肃省兰州市",
"86188164", "江西省赣州市",
"861807774", "广西玉林市",
"861865635", "安徽省合肥市",
"861826043", "江苏省苏州市",
"861895112", "江苏省苏州市",
"861550304", "河北省承德市",
"861569065", "河南省鹤壁市",
"861831833", "广东省韶关市",
"861326494", "湖北省鄂州市",
"861470912", "陕西省榆林市",
"861877415", "湖南省湘潭市",
"861588750", "云南省保山市",
"861571583", "浙江省绍兴市",
"86151258", "云南省楚雄彝族自治州",
"861550547", "山东省济宁市",
"861338471", "内蒙古呼和浩特市",
"861888844", "广西梧州市",
"861811655", "四川省雅安市",
"861774905", "陕西省榆林市",
"861810759", "广东省湛江市",
"861599120", "陕西省榆林市",
"86135122", "天津市",
"86176960", "山西省太原市",
"861390409", "辽宁省大连市",
"86150251", "云南省昆明市",
"861589738", "湖南省娄底市",
"861708754", "江西省抚州市",
"86155153", "河南省洛阳市",
"86158706", "江西省南昌市",
"861869823", "辽宁省铁岭市",
"861529973", "新疆博尔塔拉蒙古自治州",
"861369633", "山东省日照市",
"861771224", "江苏省连云港市",
"861800574", "浙江省宁波市",
"86153013", "北京市",
"861503142", "河北省沧州市",
"861866677", "广东省肇庆市",
"861350793", "江西省上饶市",
"861580799", "江西省萍乡市",
"861874097", "甘肃省庆阳市",
"8615011", "北京市",
"861313318", "山西省临汾市",
"861835153", "江苏省宿迁市",
"861803720", "河南省安阳市",
"861579800", "江西省抚州市",
"861515963", "福建省福州市",
"861598793", "云南省丽江市",
"861820693", "云南省西双版纳傣族自治州",
"861477342", "湖南省衡阳市",
"86137247", "广东省湛江市",
"86136921", "广东省深圳市",
"861326350", "黑龙江省哈尔滨市",
"861311473", "广西桂林市",
"861811461", "江苏省苏州市",
"861513342", "河北省廊坊市",
"861303388", "河南省鹤壁市",
"861310748", "湖南省长沙市",
"861500782", "广西柳州市",
"861302623", "江西省鹰潭市",
"86184826", "四川省广安市",
"861538637", "湖南省益阳市",
"861366340", "山西省朔州市",
"861539379", "河南省许昌市",
"861452093", "安徽省宣城市",
"861321067", "山东省淄博市",
"861858725", "云南省昆明市",
"86158507", "江苏省南京市",
"861388403", "甘肃省临夏回族自治州",
"86152472", "内蒙古包头市",
"861567061", "河南省郑州市",
"861470573", "浙江省嘉兴市",
"861459519", "云南省德宏傣族景颇族自治州",
"861779111", "陕西省宝鸡市",
"861364460", "黑龙江省哈尔滨市",
"861332938", "黑龙江省伊春市",
"861523324", "河北省承德市",
"861819123", "陕西省榆林市",
"861339841", "四川省南充市",
"861328946", "陕西省延安市",
"861899742", "青海省海东地区",
"861330487", "黑龙江省鸡西市",
"861317548", "浙江省台州市",
"861568220", "四川省广元市",
"861387215", "湖北省咸宁市",
"861385132", "江苏省盐城市",
"861396337", "山东省东营市",
"861581686", "广东省深圳市",
"861879411", "甘肃省陇南市",
"861536171", "广东省肇庆市",
"861350469", "黑龙江省佳木斯市",
"86187535", "山东省烟台市",
"861580463", "黑龙江省哈尔滨市",
"86137652", "贵州省遵义市",
"8618662", "江苏省苏州市",
"861830750", "广东省江门市",
"8615321", "北京市",
"861304279", "湖北省襄樊市",
"86137308", "四川省成都市",
"861316953", "广东省东莞市",
"861509170", "陕西省宝鸡市",
"86157623", "山东省日照市",
"861318621", "陕西省渭南市",
"861369558", "安徽省阜阳市",
"861595159", "江苏省宿迁市",
"861890524", "江苏省宿迁市",
"861850346", "山西省太原市",
"861354996", "广东省佛山市",
"861818831", "四川省巴中市",
"861564241", "辽宁省辽阳市",
"861855900", "福建省三明市",
"861770639", "山东省青岛市",
"861315125", "江苏省常州市",
"861329548", "山东省泰安市",
"86155011", "北京市",
"86188813", "四川省乐山市",
"86147214", "四川省成都市",
"861554144", "辽宁省铁岭市",
"861390617", "江苏省无锡市",
"861368530", "山东省菏泽市",
"86418", "辽宁省阜新市",
"861835103", "江苏省苏州市",
"861840542", "山东省青岛市",
"861775263", "湖南省湘西土家族苗族自治州",
"861831862", "广东省阳江市",
"861329424", "湖北省宜昌市",
"861863367", "河北省沧州市",
"861550490", "辽宁省铁岭市",
"861890448", "吉林省松原市",
"861879744", "湖南省湘西土家族苗族自治州",
"861535317", "陕西省榆林市",
"861475732", "浙江省宁波市",
"861367452", "黑龙江省齐齐哈尔市",
"861700565", "浙江省金华市",
"861326300", "江西省南昌市",
"861557179", "湖北省恩施土家族苗族自治州",
"861862980", "吉林省辽源市",
"861818896", "湖南省衡阳市",
"861333620", "山东省菏泽市",
"861304758", "江苏省宿迁市",
"86138274", "广东省深圳市",
"861871557", "安徽省宿州市",
"86181786", "广西南宁市",
"861458345", "江西省景德镇市",
"861828881", "云南省怒江傈僳族自治州",
"861319442", "福建省莆田市",
"861509488", "山东省淄博市",
"861317424", "湖南省张家界市",
"861707765", "云南省玉溪市",
"861870522", "江苏省徐州市",
"861369662", "安徽省安庆市",
"861708917", "陕西省榆林市",
"861566087", "河南省焦作市",
"861332089", "四川省绵阳市",
"861308699", "贵州省铜仁地区",
"861560966", "安徽省安庆市",
"861576020", "四川省广安市",
"861897281", "湖北省咸宁市",
"861335664", "山东省东营市",
"861865681", "安徽省宿州市",
"861830700", "江西省南昌市",
"86187530", "山东省菏泽市",
"861520421", "辽宁省朝阳市",
"861855950", "福建省南平市",
"861378302", "河南省鹤壁市",
"861571468", "黑龙江省鹤岗市",
"861838588", "贵州省铜仁地区",
"861891342", "江苏省镇江市",
"861595109", "江苏省宿迁市",
"861369508", "福建省南平市",
"861373054", "河北省保定市",
"861530675", "浙江省绍兴市",
"861300650", "山东省青岛市",
"861534322", "湖南省湘潭市",
"86134561", "浙江省宁波市",
"861868807", "广东省汕尾市",
"861450283", "内蒙古鄂尔多斯市",
"861771179", "湖南省邵阳市",
"861479640", "江西省赣州市",
"86185539", "山东省临沂市",
"861303966", "黑龙江省伊春市",
"861339887", "云南省迪庆藏族自治州",
"861365418", "辽宁省沈阳市",
"861537422", "江西省九江市",
"861398581", "贵州省黔东南苗族侗族自治州",
"861539444", "福建省泉州市",
"861300527", "广东省揭阳市",
"861889349", "甘肃省兰州市",
"861800614", "江苏省常州市",
"861324773", "江西省上饶市",
"861822597", "安徽省宿州市",
"861454871", "四川省成都市",
"86147023", "重庆市",
"86181060", "福建省福州市",
"861572423", "浙江省温州市",
"86139956", "湖北省武汉市",
"86151142", "辽宁省朝阳市",
"861374956", "河南省平顶山市",
"861338042", "广东省云浮市",
"861337288", "辽宁省本溪市",
"861316652", "河北省廊坊市",
"86177591", "福建省福州市",
"861523640", "河南省信阳市",
"861472677", "四川省宜宾市",
"861504695", "黑龙江省黑河市",
"861304852", "贵州省黔南布依族苗族自治州",
"861515508", "安徽省安庆市",
"861889025", "湖南省衡阳市",
"861390038", "辽宁省辽阳市",
"861535095", "辽宁省铁岭市",
"861564287", "辽宁省锦州市",
"861333557", "安徽省宿州市",
"86131372", "河南省驻马店市",
"861555345", "山东省烟台市",
"861515662", "安徽省淮南市",
"861871479", "黑龙江省黑河市",
"861880874", "云南省曲靖市",
"861820992", "新疆伊犁哈萨克自治州",
"861324342", "河南省郑州市",
"861364352", "山西省大同市",
"861885789", "浙江省杭州市",
"861346341", "河北省石家庄市",
"861302922", "辽宁省本溪市",
"861301552", "河南省郑州市",
"861377638", "江苏省常州市",
"861330441", "吉林省吉林市",
"861323576", "浙江省台州市",
"861807012", "江西省南昌市",
"861868857", "广东省云浮市",
"861347099", "安徽省合肥市",
"861470020", "安徽省六安市",
"861564838", "内蒙古呼伦贝尔市",
"861550535", "山东省烟台市",
"86134076", "山东省临沂市",
"861818248", "陕西省榆林市",
"861882608", "广东省广州市",
"861886805", "浙江省衢州市",
"861815467", "广西玉林市",
"861361228", "广东省江门市",
"861316568", "湖北省黄石市",
"861369963", "四川省绵阳市",
"861769709", "青海省海西蒙古族藏族自治州",
"86150528", "江苏省泰州市",
"861808428", "贵州省六盘水市",
"861529821", "四川省南充市",
"86181065", "浙江省杭州市",
"861561538", "山东省泰安市",
"861340939", "河南省许昌市",
"861325061", "广东省惠州市",
"861853443", "山西省太原市",
"861333344", "山西省晋中市",
"861848913", "西藏山南地区",
"861390989", "辽宁省葫芦岛市",
"861556726", "吉林省松原市",
"86151521", "江苏省徐州市",
"861882562", "广东省珠海市",
"861475287", "江苏省扬州市",
"861306079", "广东省佛山市",
"861880967", "宁夏银川市",
"8618640", "辽宁省沈阳市",
"861886086", "江苏省连云港市",
"861872691", "安徽省淮北市",
"861515558", "安徽省宣城市",
"861707377", "河南省南阳市",
"861570450", "黑龙江省哈尔滨市",
"861772418", "广东省珠海市",
"861508275", "四川省南充市",
"861348596", "安徽省六安市",
"861560388", "河南省许昌市",
"861301668", "广东省汕头市",
"861320824", "四川省甘孜藏族自治州",
"861820634", "山东省莱芜市",
"861317075", "云南省大理白族自治州",
"861393864", "河南省开封市",
"861554083", "内蒙古兴安盟",
"861804076", "新疆乌鲁木齐市",
"861880645", "山东省烟台市",
"861559890", "内蒙古呼伦贝尔市",
"861338250", "江苏省苏州市",
"861825657", "安徽省芜湖市",
"861510818", "四川省泸州市",
"861337514", "江苏省徐州市",
"861862394", "河南省周口市",
"861897247", "湖北省十堰市",
"861566041", "山东省济宁市",
"861337837", "四川省凉山彝族自治州",
"861301502", "内蒙古呼和浩特市",
"861705326", "广东省广州市",
"861310842", "四川省广安市",
"861500888", "云南省玉溪市",
"861329075", "河南省许昌市",
"861365370", "河南省商丘市",
"861593216", "河北省廊坊市",
"861472893", "西藏山南地区",
"861855480", "山东省东营市",
"86181201", "江苏省南京市",
"861705367", "浙江省杭州市",
"861315065", "云南省大理白族自治州",
"861379391", "山东省临沂市",
"86183869", "贵州省黔西南布依族苗族自治州",
"86180208", "福建省三明市",
"861355757", "广西南宁市",
"861864253", "辽宁省朝阳市",
"861521643", "山东省淄博市",
"861360142", "江苏省盐城市",
"861350734", "湖南省衡阳市",
"861770969", "安徽省合肥市",
"86135955", "贵州省黔东南苗族侗族自治州",
"861330907", "四川省南充市",
"861370703", "江西省上饶市",
"861323205", "广东省韶关市",
"861304092", "湖北省荆州市",
"86158604", "福建省泉州市",
"861508930", "广东省惠州市",
"861813498", "山西省临汾市",
"861516055", "福建省宁德市",
"861560691", "福建省福州市",
"861551396", "山西省晋城市",
"861535141", "四川省达州市",
"861786907", "云南省普洱市",
"861332502", "山东省青岛市",
"861818157", "四川省内江市",
"861567121", "湖北省十堰市",
"861537715", "湖北省咸宁市",
"861596914", "云南省曲靖市",
"861362787", "广西南宁市",
"861873623", "河南省周口市",
"861359218", "河南省平顶山市",
"861817477", "广西柳州市",
"861538967", "陕西省咸阳市",
"861392156", "江苏省镇江市",
"861805246", "江苏省无锡市",
"861839456", "甘肃省武威市",
"861321127", "广东省江门市",
"861559731", "青海省玉树藏族自治州",
"861768955", "西藏昌都地区",
"861886095", "江苏省南京市",
"861815426", "安徽省阜阳市",
"861570394", "河南省周口市",
"861583327", "河北省沧州市",
"861561077", "山东省威海市",
"861831894", "广东省东莞市",
"861357817", "云南省普洱市",
"861827063", "江西省宜春市",
"861398535", "贵州省毕节地区",
"861588197", "四川省泸州市",
"861829477", "甘肃省甘南藏族自治州",
"861336865", "贵州省黔东南苗族侗族自治州",
"861348585", "安徽省芜湖市",
"86135388", "广东省广州市",
"861775787", "浙江省宁波市",
"861390577", "浙江省温州市",
"861528910", "西藏拉萨市",
"861560636", "山东省潍坊市",
"861320976", "青海省海西蒙古族藏族自治州",
"86183427", "辽宁省盘锦市",
"861369932", "新疆和田地区",
"861778561", "贵州省贵阳市",
"861355707", "广西钦州市",
"861335934", "甘肃省庆阳市",
"861524188", "辽宁省阜新市",
"861344655", "山东省菏泽市",
"861476271", "江苏省徐州市",
"861559796", "贵州省毕节地区",
"861306413", "江西省南昌市",
"861561603", "湖南省长沙市",
"861860423", "辽宁省抚顺市",
"861330957", "宁夏银川市",
"861517672", "河北省唐山市",
"86135950", "贵州省贵阳市",
"861320102", "新疆昌吉回族自治州",
"861318778", "云南省曲靖市",
"861346928", "湖南省邵阳市",
"86159262", "湖北省武汉市",
"861473672", "云南省普洱市",
"861558038", "湖南省邵阳市",
"86153224", "广东省东莞市",
"861591498", "广东省清远市",
"86186614", "山东省青岛市",
"86177958", "陕西省西安市",
"86182615", "江苏省无锡市",
"861316483", "福建省漳州市",
"861888260", "四川省内江市",
"861386540", "安徽省芜湖市",
"861590392", "河南省鹤壁市",
"861587882", "广西河池市",
"861768905", "西藏昌都地区",
"861839406", "甘肃省临夏回族自治州",
"861508383", "江西省南昌市",
"861802768", "广东省佛山市",
"861368486", "江西省吉安市",
"861379336", "山东省威海市",
"861470613", "江苏省苏州市",
"861318209", "江苏省无锡市",
"861818107", "四川省南充市",
"861774431", "四川省绵阳市",
"861894918", "安徽省宿州市",
"861536598", "江苏省镇江市",
"861332552", "新疆喀什地区",
"861504686", "黑龙江省黑河市",
"861354661", "山西省晋城市",
"861458337", "江西省赣州市",
"861832295", "江西省抚州市",
"861801286", "江苏省南通市",
"861583408", "山西省忻州市",
"861550581", "浙江省杭州市",
"861300566", "广东省茂名市",
"861459420", "云南省普洱市",
"861535086", "河北省邢台市",
"861811216", "江苏省连云港市",
"861375150", "广东省佛山市",
"861303927", "吉林省吉林市",
"861576912", "陕西省榆林市",
"861538874", "云南省曲靖市",
"861372764", "广东省梅州市",
"861538777", "江西省吉安市",
"861889939", "新疆克拉玛依市",
"861510958", "宁夏银川市",
"861818415", "贵州省黔东南苗族侗族自治州",
"861887038", "江西省景德镇市",
"861774428", "四川省德阳市",
"861300071", "湖北省武汉市",
"861800063", "河北省唐山市",
"861582984", "陕西省西安市",
"861533855", "贵州省黔南布依族苗族自治州",
"861556977", "甘肃省酒泉市",
"861554202", "辽宁省锦州市",
"86130235", "江苏省南通市",
"861550422", "辽宁省朝阳市",
"861880998", "新疆喀什地区",
"86134357", "广东省中山市",
"861853480", "山西省晋中市",
"86158290", "陕西省西安市",
"861363370", "河南省商丘市",
"861860565", "安徽省合肥市",
"861309290", "陕西省宝鸡市",
"861806944", "浙江省杭州市",
"861803439", "河北省邢台市",
"86136492", "陕西省西安市",
"861539585", "浙江省绍兴市",
"861373100", "河北省邯郸市",
"861554040", "内蒙古乌兰察布市",
"861782047", "广东省湛江市",
"861839397", "甘肃省酒泉市",
"86135588", "四川省成都市",
"861534390", "河南省信阳市",
"861813426", "河北省廊坊市",
"861555935", "新疆伊犁哈萨克自治州",
"861308472", "内蒙古包头市",
"861822652", "安徽省芜湖市",
"861551328", "山西省太原市",
"861453617", "江苏省扬州市",
"861780291", "陕西省延安市",
"861868917", "西藏阿里地区",
"861576092", "陕西省榆林市",
"861345539", "山东省德州市",
"861355804", "广西梧州市",
"861587376", "湖南省邵阳市",
"861324932", "广东省惠州市",
"861564672", "山东省济宁市",
"861815498", "新疆伊犁哈萨克自治州",
"861316597", "浙江省杭州市",
"861870590", "福建省福州市",
"861770779", "广西北海市",
"861870901", "新疆塔城地区",
"861533141", "云南省文山壮族苗族自治州",
"861346931", "湖南省湘潭市",
"861775884", "黑龙江省大庆市",
"861705681", "湖北省黄冈市",
"861377872", "四川省遂宁市",
"86136280", "四川省成都市",
"861567138", "湖北省荆州市",
"861334369", "河南省南阳市",
"861510908", "新疆阿克苏地区",
"861532476", "河南省南阳市",
"861802978", "广东省潮州市",
"861770258", "江苏省徐州市",
"86158482", "内蒙古包头市",
"861327566", "安徽省池州市",
"861569470", "内蒙古呼伦贝尔市",
"861354387", "广东省珠海市",
"861572210", "贵州省贵阳市",
"861312314", "福建省宁德市",
"861840466", "黑龙江省哈尔滨市",
"86181299", "广东省深圳市",
"861533805", "广东省广州市",
"861450240", "河北省邢台市",
"861365245", "广东省东莞市",
"861871993", "新疆克孜勒苏柯尔克孜自治州",
"861831797", "江西省赣州市",
"861844999", "新疆石河子市",
"861340349", "山西省朔州市",
"86177771", "广西南宁市",
"861332873", "福建省龙岩市",
"861520009", "河北省保定市",
"861890606", "福建省漳州市",
"861333934", "黑龙江省双鸭山市",
"861522457", "广西钦州市",
"861319566", "安徽省池州市",
"861562447", "山东省日照市",
"861336449", "吉林省白山市",
"861380247", "广东省惠州市",
"86158152", "广东省汕头市",
"861458401", "河南省商丘市",
"861834446", "广东省汕尾市",
"861459464", "陕西省延安市",
"86177864", "湖北省武汉市",
"861773787", "河南省平顶山市",
"86145963", "甘肃省酒泉市",
"861346996", "湖北省武汉市",
"861518140", "四川省泸州市",
"861512945", "陕西省宝鸡市",
"861533086", "辽宁省本溪市",
"86135454", "湖北省孝感市",
"861596094", "福建省龙岩市",
"861846513", "宁夏吴忠市",
"861857197", "湖北省荆门市",
"861877885", "广西桂林市",
"861869243", "湖南省湘潭市",
"861551407", "河南省焦作市",
"861822602", "安徽省宿州市",
"861334137", "湖南省益阳市",
"861834239", "辽宁省葫芦岛市",
"861355854", "四川省达州市",
"861576124", "贵州省黔南布依族苗族自治州",
"861370329", "河北省石家庄市",
"861530735", "湖南省郴州市",
"86134116", "广东省中山市",
"861822568", "安徽省阜阳市",
"861870951", "宁夏银川市",
"86177051", "江苏省南京市",
"861394849", "内蒙古乌兰察布市",
"861888224", "四川省乐山市",
"861889088", "新疆昌吉回族自治州",
"861478580", "贵州省安顺市",
"861597250", "湖北省咸宁市",
"861565650", "安徽省马鞍山市",
"861301873", "广东省中山市",
"861709549", "江苏省无锡市",
"861337734", "广西桂林市",
"861357907", "新疆喀什地区",
"861314360", "广东省惠州市",
"86187143", "黑龙江省齐齐哈尔市",
"86145226", "浙江省台州市",
"861868068", "广东省深圳市",
"861576852", "广东省惠州市",
"861479452", "黑龙江省齐齐哈尔市",
"86159688", "浙江省杭州市",
"861854794", "内蒙古鄂尔多斯市",
"861556589", "河南省漯河市",
"861386583", "安徽省滁州市",
"861563442", "山东省威海市",
"86185812", "重庆市",
"861861361", "山东省德州市",
"861320727", "湖北省荆州市",
"861331384", "福建省厦门市",
"861850666", "广东省揭阳市",
"861506530", "山东省菏泽市",
"861361373", "河南省新乡市",
"861315251", "广西南宁市",
"861501476", "广东省东莞市",
"861362569", "安徽省芜湖市",
"861536567", "江苏省盐城市",
"861894858", "广东省惠州市",
"861786534", "山东省德州市",
"861304573", "浙江省嘉兴市",
"861348444", "陕西省榆林市",
"861804561", "黑龙江省黑河市",
"86183304", "河北省唐山市",
"861353914", "广东省河源市",
"861800032", "河北省保定市",
"861470708", "江西省景德镇市",
"861760574", "浙江省宁波市",
"861770147", "江苏省南通市",
"861508340", "河南省南阳市",
"861502639", "新疆阿克苏地区",
"861330817", "四川省成都市",
"861325576", "浙江省台州市",
"86153448", "广东省珠海市",
"861361742", "湖南省常德市",
"861898143", "四川省内江市",
"861330534", "山东省德州市",
"861513662", "河南省商丘市",
"861846972", "云南省红河哈尼族彝族自治州",
"861319527", "贵州省毕节地区",
"861809684", "新疆巴音郭楞蒙古自治州",
"861321752", "广东省惠州市",
"861380158", "江苏省南京市",
"861533095", "辽宁省铁岭市",
"861599192", "陕西省榆林市",
"861335557", "安徽省宿州市",
"86132601", "北京市",
"861840427", "辽宁省盘锦市",
"861553345", "河北省唐山市",
"861877896", "广西玉林市",
"86131572", "浙江省湖州市",
"86177113", "四川省成都市",
"861534404", "内蒙古鄂尔多斯市",
"861840358", "山西省吕梁市",
"861513508", "山西省太原市",
"861327527", "江苏省南通市",
"86159461", "黑龙江省绥化市",
"861808431", "贵州省安顺市",
"861551619", "河南省郑州市",
"861562951", "湖北省十堰市",
"861529838", "江苏省南京市",
"861550715", "湖北省荆州市",
"861522941", "陕西省延安市",
"861472745", "贵州省黔西南布依族苗族自治州",
"861561521", "山东省聊城市",
"861590644", "浙江省丽水市",
"86136209", "广东省深圳市",
"86180960", "贵州省贵阳市",
"861367324", "河北省承德市",
"861873990", "河南省郑州市",
"861357957", "新疆克孜勒苏柯尔克孜自治州",
"861318017", "河北省唐山市",
"861329352", "山西省大同市",
"861378548", "河北省沧州市",
"86151321", "河北省石家庄市",
"86176029", "陕西省西安市",
"861893630", "江苏省盐城市",
"86150328", "河北省石家庄市",
"861320860", "吉林省松原市",
"861566699", "山东省临沂市",
"861390021", "天津市",
"861335344", "山西省晋中市",
"861323061", "河北省保定市",
"861855443", "山东省济南市",
"861576802", "广东省清远市",
"861823073", "贵州省黔东南苗族侗族自治州",
"861708315", "河北省唐山市",
"861880777", "广西钦州市",
"861459175", "内蒙古包头市",
"86180746", "湖南省永州市",
"86177509", "福建省泉州市",
"861556798", "吉林省白山市",
"861813467", "安徽省安庆市",
"861309842", "湖北省荆门市",
"861872049", "江西省萍乡市",
"861529287", "新疆乌鲁木齐市",
"861509818", "山东省潍坊市",
"861768815", "广东省深圳市",
"861808496", "四川省宜宾市",
"861824280", "辽宁省辽阳市",
"861538998", "新疆塔城地区",
"861894808", "广东省江门市",
"861590875", "云南省保山市",
"861370618", "江苏省无锡市",
"861887577", "河北省沧州市",
"861555270", "山东省滨州市",
"86134097", "湖北省黄冈市",
"861321702", "江西省九江市",
"861452612", "江苏省无锡市",
"861708196", "福建省漳州市",
"861570642", "山东省青岛市",
"861863647", "山西省晋城市",
"86186878", "云南省昆明市",
"861379946", "福建省泉州市",
"861842029", "广东省湛江市",
"861534454", "黑龙江省佳木斯市",
"861840308", "河北省衡水市",
"861458947", "广东省中山市",
"861365782", "广西柳州市",
"861347641", "湖北省襄樊市",
"861539596", "福建省漳州市",
"86189542", "山东省青岛市",
"861779937", "新疆伊犁哈萨克自治州",
"86180965", "安徽省蚌埠市",
"861397018", "江西省鹰潭市",
"861384921", "河南省鹤壁市",
"861776961", "浙江省嘉兴市",
"861458665", "湖南省郴州市",
"861869761", "安徽省亳州市",
"861339784", "广西梧州市",
"861316352", "黑龙江省大庆市",
"86180646", "广东省佛山市",
"861563350", "河北省衡水市",
"86182485", "浙江省金华市",
"861860814", "四川省绵阳市",
"86151823", "四川省绵阳市",
"861358692", "浙江省宁波市",
"861339295", "广东省珠海市",
"861876831", "浙江省嘉兴市",
"861860537", "山东省济宁市",
"861879867", "贵州省遵义市",
"861899972", "新疆伊犁哈萨克自治州",
"861768889", "广东省深圳市",
"86181030", "广东省东莞市",
"861571560", "安徽省合肥市",
"861514186", "辽宁省铁岭市",
"861526888", "浙江省台州市",
"861366324", "河北省保定市",
"861356957", "河南省平顶山市",
"861882358", "广东省东莞市",
"861800314", "河北省承德市",
"861369400", "吉林省四平市",
"86185569", "江苏省苏州市",
"861708389", "河南省濮阳市",
"861309768", "山西省朔州市",
"86182155", "四川省成都市",
"861899106", "陕西省榆林市",
"861378953", "内蒙古赤峰市",
"861567699", "广西钦州市",
"86182292", "湖南省衡阳市",
"861839552", "安徽省宣城市",
"861803744", "河南省商丘市",
"86147621", "江苏省徐州市",
"861524191", "辽宁省本溪市",
"86156287", "山东省潍坊市",
"86131852", "浙江省湖州市",
"86185250", "辽宁省沈阳市",
"861760705", "江西省宜春市",
"861589223", "四川省自贡市",
"861596042", "福建省泉州市",
"861476558", "湖北省武汉市",
"86159983", "辽宁省沈阳市",
"861572078", "江苏省徐州市",
"861475780", "浙江省台州市",
"861847156", "湖北省武汉市",
"861550598", "福建省三明市",
"861890540", "山东省菏泽市",
"861535989", "福建省厦门市",
"861561595", "山东省烟台市",
"861555645", "安徽省合肥市",
"861351477", "内蒙古鄂尔多斯市",
"861389533", "宁夏吴忠市",
"861568244", "四川省南充市",
"861559539", "宁夏固原市",
"861343731", "广东省江门市",
"861530820", "四川省成都市",
"8613412", "广东省东莞市",
"861804587", "黑龙江省鹤岗市",
"861814834", "内蒙古呼和浩特市",
"861390095", "宁夏银川市",
"861801238", "江苏省无锡市",
"861320264", "广东省肇庆市",
"86182480", "内蒙古赤峰市",
"86186558", "安徽省阜阳市",
"861505133", "江苏省盐城市",
"86138297", "广东省广州市",
"861537567", "安徽省亳州市",
"861532853", "四川省遂宁市",
"861808657", "湖北省黄冈市",
"861322477", "内蒙古鄂尔多斯市",
"861300462", "浙江省绍兴市",
"861895330", "山东省日照市",
"861787534", "广东省广州市",
"861535038", "江西省景德镇市",
"861342108", "广东省潮州市",
"861824884", "江苏省南通市",
"861369450", "黑龙江省哈尔滨市",
"861336734", "湖南省衡阳市",
"861882308", "广东省江门市",
"861346919", "湖南省张家界市",
"861593534", "山西省临汾市",
"861343796", "江西省吉安市",
"861891943", "甘肃省白银市",
"861839502", "宁夏石嘴山市",
"861338707", "江西省赣州市",
"86159788", "河南省驻马店市",
"861368438", "四川省凉山彝族自治州",
"86182150", "甘肃省临夏回族自治州",
"861899156", "陕西省商洛市",
"861379388", "山东省滨州市",
"861347985", "江西省萍乡市",
"861879974", "新疆石河子市",
"861869787", "青海省海西蒙古族藏族自治州",
"861705626", "河南省郑州市",
"861476508", "北京市",
"861894929", "安徽省亳州市",
"861570963", "宁夏吴忠市",
"861530767", "广东省潮州市",
"861361868", "湖北省宜昌市",
"86132701", "江苏省无锡市",
"861760755", "广东省深圳市",
"861780734", "湖南省衡阳市",
"86185255", "辽宁省大连市",
"861364602", "福建省厦门市",
"861500730", "湖南省岳阳市",
"86152828", "四川省德阳市",
"861374899", "河南省郑州市",
"861550789", "广西南宁市",
"861380783", "广西桂林市",
"861808073", "四川省广元市",
"86131901", "辽宁省大连市",
"861820334", "河北省衡水市",
"861471740", "江西省南昌市",
"861560688", "浙江省温州市",
"861576044", "四川省宜宾市",
"861880345", "山西省长治市",
"861803411", "河北省石家庄市",
"861367660", "浙江省衢州市",
"861364568", "安徽省阜阳市",
"861350865", "湖北省黄冈市",
"861805847", "浙江省绍兴市",
"861524136", "辽宁省锦州市",
"86177671", "浙江省杭州市",
"86186991", "新疆乌鲁木齐市",
"86170045", "黑龙江省哈尔滨市",
"861821869", "广东省茂名市",
"861303274", "湖北省宜昌市",
"86134896", "福建省漳州市",
"861369394", "河南省周口市",
"861890497", "辽宁省营口市",
"861343785", "广东省湛江市",
"861875759", "浙江省杭州市",
"861365429", "辽宁省葫芦岛市",
"861335392", "河南省鹤壁市",
"861323472", "内蒙古包头市",
"861478074", "四川省南充市",
"861524045", "江苏省无锡市",
"861376872", "广西桂林市",
"861379691", "黑龙江省双鸭山市",
"861338914", "陕西省商洛市",
"861868256", "四川省成都市",
"861390086", "湖北省荆门市",
"86183839", "四川省广元市",
"861538029", "江苏省连云港市",
"861824569", "黑龙江省大庆市",
"861530726", "湖北省恩施土家族苗族自治州",
"861501853", "广东省深圳市",
"861399931", "新疆克拉玛依市",
"861365670", "浙江省衢州市",
"86183312", "河北省保定市",
"861396645", "安徽省淮南市",
"861348739", "湖南省邵阳市",
"861840713", "湖北省黄冈市",
"861454322", "内蒙古包头市",
"861705667", "天津市",
"861573563", "山西省太原市",
"861569703", "云南省红河哈尼族彝族自治州",
"861332368", "河南省南阳市",
"861384986", "河南省许昌市",
"861886989", "云南省保山市",
"861322082", "山东省威海市",
"861379118", "山东省烟台市",
"861306976", "黑龙江省佳木斯市",
"861898023", "四川省自贡市",
"861570694", "云南省玉溪市",
"861535577", "浙江省温州市",
"861511940", "广东省汕尾市",
"861337236", "浙江省台州市",
"861328870", "广东省云浮市",
"861527265", "湖北省咸宁市",
"861847513", "广东省梅州市",
"861872688", "安徽省淮北市",
"861876885", "河南省郑州市",
"861538345", "山西省长治市",
"861502949", "陕西省汉中市",
"861525556", "安徽省合肥市",
"861560391", "河南省焦作市",
"861320413", "辽宁省抚顺市",
"861502611", "新疆哈密地区",
"861514195", "辽宁省葫芦岛市",
"861572814", "广东省佛山市",
"861769501", "宁夏银川市",
"861310797", "福建省莆田市",
"86184549", "山东省临沂市",
"861813435", "河北省唐山市",
"861301406", "安徽省阜阳市",
"861566616", "山东省菏泽市",
"861303069", "安徽省亳州市",
"861337291", "辽宁省盘锦市",
"861775971", "福建省龙岩市",
"861875709", "浙江省温州市",
"861390141", "江苏省盐城市",
"861572537", "山东省济宁市",
"861471846", "广东省揭阳市",
"861398598", "贵州省黔西南布依族苗族自治州",
"861886038", "河南省郑州市",
"861700484", "广东省深圳市",
"861344355", "山东省菏泽市",
"861510543", "山东省滨州市",
"861348492", "陕西省西安市",
"861501803", "广东省中山市",
"861551631", "河南省三门峡市",
"861859166", "陕西省延安市",
"861561586", "山东省潍坊市",
"861816203", "山东省济宁市",
"86189256", "广东省揭阳市",
"861586376", "山东省德州市",
"861313578", "湖北省荆州市",
"861569753", "广东省梅州市",
"861364483", "内蒙古包头市",
"861771240", "江苏省南京市",
"861458637", "湖北省孝感市",
"861361794", "江西省抚州市",
"861379636", "黑龙江省佳木斯市",
"861470313", "河北省张家口市",
"861570932", "甘肃省定西市",
"86151217", "贵州省六盘水市",
"861342247", "广东省汕头市",
"861761417", "辽宁省营口市",
"86180010", "北京市",
"861599144", "陕西省安康市",
"861388630", "湖北省鄂州市",
"861888820", "山东省德州市",
"861881541", "广西玉林市",
"861390855", "贵州省黔东南苗族侗族自治州",
"861773761", "河南省郑州市",
"861582871", "四川省内江市",
"861306152", "山东省聊城市",
"861564886", "内蒙古巴彦淖尔市",
"861329597", "福建省福州市",
"861363670", "陕西省西安市",
"861577160", "陕西省榆林市",
"861452182", "吉林省吉林市",
"861881212", "河北省保定市",
"86158919", "云南省普洱市",
"86186714", "湖北省黄石市",
"861538981", "内蒙古呼和浩特市",
"86182715", "湖北省黄冈市",
"861890356", "山西省晋城市",
"861555149", "安徽省宿州市",
"861889851", "广东省茂名市",
"86180493", "陕西省榆林市",
"861333392", "河南省鹤壁市",
"861530798", "江西省景德镇市",
"861361897", "西藏阿里地区",
"861709741", "广东省广州市",
"861521962", "广东省揭阳市",
"861329483", "内蒙古阿拉善盟",
"861841930", "甘肃省陇南市",
"861872946", "陕西省汉中市",
"86183270", "湖北省武汉市",
"8613510", "广东省深圳市",
"861811907", "新疆阿克苏地区",
"861598291", "四川省德阳市",
"861771375", "四川省泸州市",
"861380740", "湖南省岳阳市",
"861377948", "新疆喀什地区",
"861705381", "湖北省武汉市",
"861889145", "陕西省安康市",
"861802842", "广东省湛江市",
"861567195", "湖北省孝感市",
"861561729", "河南省濮阳市",
"86134877", "湖南省岳阳市",
"861557820", "广西柳州市",
"861477333", "湖南省株洲市",
"861577912", "江西省抚州市",
"861346859", "陕西省延安市",
"861587676", "广东省汕尾市",
"861533577", "湖北省随州市",
"861340911", "陕西省延安市",
"861860904", "新疆喀什地区",
"861850408", "辽宁省大连市",
"861899733", "青海省西宁市",
"861505090", "江苏省连云港市",
"861774073", "西藏山南地区",
"861831290", "浙江省温州市",
"861842926", "陕西省汉中市",
"86155249", "辽宁省朝阳市",
"861886021", "河南省商丘市",
"861534690", "甘肃省临夏回族自治州",
"861471783", "山西省大同市",
"861572717", "湖北省宜昌市",
"861532913", "贵州省安顺市",
"861537598", "福建省莆田市",
"861473005", "河北省秦皇岛市",
"861539492", "云南省德宏傣族景颇族自治州",
"861512139", "贵州省黔南布依族苗族自治州",
"861581997", "广东省中山市",
"861340649", "山东省威海市",
"86182710", "湖北省荆州市",
"861503162", "河北省廊坊市",
"861779775", "河南省郑州市",
"861890306", "广东省广州市",
"861522628", "宁夏银川市",
"86158704", "重庆市",
"861895940", "福建省宁德市",
"861555998", "云南省曲靖市",
"861819184", "陕西省渭南市",
"86138842", "甘肃省白银市",
"861530589", "浙江省金华市",
"861836666", "山东省枣庄市",
"86159418", "辽宁省阜新市",
"861773971", "河南省三门峡市",
"861478908", "西藏拉萨市",
"861889801", "西藏拉萨市",
"861811957", "安徽省宿州市",
"861774607", "福建省福州市",
"861334669", "河南省许昌市",
"861550567", "安徽省亳州市",
"86183275", "湖北省襄樊市",
"86184349", "山西省吕梁市",
"861815435", "湖北省襄樊市",
"861812527", "广东省肇庆市",
"861338094", "广东省河源市",
"86181910", "陕西省西安市",
"861523506", "山西省朔州市",
"861887095", "江西省宜春市",
"861569045", "河北省唐山市",
"861345890", "四川省广安市",
"861890583", "浙江省嘉兴市",
"861327433", "吉林省延边朝鲜族自治州",
"861477980", "江西省景德镇市",
"861356817", "四川省达州市",
"861768520", "贵州省遵义市",
"861859702", "青海省海东地区",
"861826063", "江苏省镇江市",
"861593907", "河南省商丘市",
"861598449", "四川省达州市",
"861346809", "山东省临沂市",
"861865937", "福建省宁德市",
"861337865", "广东省深圳市",
"86188166", "上海市",
"861869569", "福建省厦门市",
"861378813", "广西桂林市",
"861881434", "广东省惠州市",
"861371725", "广东省江门市",
"861370629", "江苏省南通市",
"861344072", "湖北省黄冈市",
"861783914", "河南省许昌市",
"86158426", "辽宁省大连市",
"861840533", "山东省淄博市",
"86470", "内蒙古呼伦贝尔市",
"861309797", "广西钦州市",
"861308255", "江苏省南京市",
"861850458", "黑龙江省伊春市",
"861509543", "甘肃省兰州市",
"861860954", "宁夏固原市",
"86182491", "黑龙江省哈尔滨市",
"861709414", "广东省深圳市",
"861880935", "甘肃省武威市",
"861820944", "甘肃省庆阳市",
"861324394", "辽宁省营口市",
"861764541", "黑龙江省佳木斯市",
"861319433", "吉林省延边朝鲜族自治州",
"861473055", "河北省秦皇岛市",
"861879898", "西藏昌都地区",
"861315578", "江西省景德镇市",
"861816477", "云南省文山壮族苗族自治州",
"861842018", "广东省肇庆市",
"861370470", "内蒙古呼伦贝尔市",
"861479506", "宁夏中卫市",
"861785854", "浙江省绍兴市",
"86147216", "四川省成都市",
"861554164", "辽宁省锦州市",
"861310054", "广西贺州市",
"86185369", "山西省晋中市",
"861879008", "河南省信阳市",
"861593299", "江西省抚州市",
"861564261", "辽宁省铁岭市",
"861335875", "辽宁省锦州市",
"861329568", "安徽省阜阳市",
"861317602", "山东省济南市",
"86155957", "海南省海口市",
"861521933", "广东省汕尾市",
"861361673", "浙江省嘉兴市",
"861390915", "陕西省安康市",
"861344487", "云南省昭通市",
"861599879", "山东省德州市",
"861360022", "广东省肇庆市",
"861510580", "浙江省舟山市",
"861362243", "广东省清远市",
"86187822", "四川省成都市",
"861500510", "江苏省盐城市",
"861530864", "湖北省武汉市",
"861315037", "新疆伊犁哈萨克自治州",
"861780837", "四川省阿坝藏族羌族自治州",
"861520906", "新疆喀什地区",
"861308576", "广东省汕头市",
"86158612", "江苏省连云港市",
"86133160", "广东省广州市",
"861450179", "山西省晋中市",
"861771283", "江苏省镇江市",
"861592902", "陕西省榆林市",
"861551319", "山西省忻州市",
"861339861", "河北省石家庄市",
"861839873", "四川省自贡市",
"861899762", "新疆巴音郭楞蒙古自治州",
"86159431", "吉林省长春市",
"861590344", "山西省晋中市",
"861336514", "江苏省扬州市",
"861535021", "江西省九江市",
"86180930", "甘肃省临夏回族自治州",
"861364440", "吉林省长春市",
"861550526", "江苏省盐城市",
"861889091", "新疆吐鲁番地区",
"861769623", "山西省忻州市",
"861562839", "广东省东莞市",
"861511330", "广东省惠州市",
"861383478", "山西省长治市",
"861533989", "甘肃省白银市",
"861321047", "山东省枣庄市",
"861527051", "江西省上饶市",
"861770571", "浙江省杭州市",
"861597707", "广西桂林市",
"86186980", "天津市",
"861571524", "江苏省宿迁市",
"861366360", "山西省忻州市",
"861518279", "四川省巴中市",
"861572954", "宁夏固原市",
"861368421", "四川省达州市",
"861809384", "甘肃省酒泉市",
"861811441", "江苏省泰州市",
"861517780", "广西南宁市",
"861515943", "福建省宁德市",
"861519051", "江苏省常州市",
"861350236", "广东省汕尾市",
"861538935", "陕西省咸阳市",
"861814737", "内蒙古包头市",
"861506899", "浙江省绍兴市",
"861844700", "内蒙古呼伦贝尔市",
"861310004", "山西省朔州市",
"861389713", "青海省黄南藏族自治州",
"861530977", "青海省海西蒙古族藏族自治州",
"861570773", "广西桂林市",
"861317652", "山东省青岛市",
"861343511", "广东省韶关市",
"861585666", "安徽省滁州市",
"861593441", "山西省晋中市",
"861807334", "湖南省株洲市",
"861571448", "吉林省松原市",
"861863504", "山西省忻州市",
"861343728", "湖北省武汉市",
"861867517", "广东省韶关市",
"861536422", "湖南省长沙市",
"86131008", "黑龙江省哈尔滨市",
"861335644", "广东省江门市",
"861332397", "河南省信阳市",
"861867834", "山东省济南市",
"86186602", "山东省青岛市",
"86133165", "广东省深圳市",
"861345050", "广东省阳江市",
"861560946", "甘肃省庆阳市",
"861590557", "安徽省宿州市",
"861304044", "浙江省宁波市",
"861520956", "宁夏石嘴山市",
"861888798", "云南省曲靖市",
"86186358", "山西省吕梁市",
"861591522", "广东省佛山市",
"861320220", "广东省揭阳市",
"86180935", "甘肃省武威市",
"861805411", "甘肃省酒泉市",
"861575170", "江苏省宿迁市",
"861324400", "吉林省吉林市",
"861386656", "安徽省池州市",
"861592952", "陕西省安康市",
"86181784", "广西梧州市",
"86138276", "广东省阳江市",
"861347341", "河北省石家庄市",
"861527001", "江西省南昌市",
"861834542", "黑龙江省大庆市",
"861887141", "湖北省黄石市",
"861815481", "新疆乌鲁木齐市",
"861351253", "江苏省南京市",
"861890468", "黑龙江省鹤岗市",
"861826032", "江苏省盐城市",
"86182984", "甘肃省兰州市",
"861700545", "山东省威海市",
"861572904", "河南省焦作市",
"86145490", "湖北省荆州市",
"861831842", "广东省揭阳市",
"861325087", "浙江省温州市",
"861567186", "湖北省荆门市",
"86186985", "浙江省杭州市",
"861327462", "黑龙江省哈尔滨市",
"861532572", "浙江省湖州市",
"861570342", "山西省大同市",
"861863347", "河北省石家庄市",
"861840562", "安徽省铜陵市",
"861520530", "山东省菏泽市",
"861370318", "河北省衡水市",
"861391232", "江苏省常州市",
"86130756", "广东省珠海市",
"861310926", "陕西省安康市",
"86157541", "辽宁省锦州市",
"861802981", "广东省肇庆市",
"861780662", "广东省阳江市",
"861359706", "广西柳州市",
"861313567", "湖北省武汉市",
"861308596", "甘肃省嘉峪关市",
"861473644", "云南省保山市",
"861454825", "广东省湛江市",
"861772923", "陕西省安康市",
"861533440", "云南省丽江市",
"861589635", "江苏省镇江市",
"861593279", "河北省邯郸市",
"861452955", "广东省珠海市",
"861373401", "山西省太原市",
"861590838", "四川省达州市",
"86185367", "山西省临汾市",
"861777791", "广西北海市",
"861780508", "江苏省常州市",
"86150870", "云南省昆明市",
"861878448", "四川省内江市",
"861375169", "广东省揭阳市",
"861361693", "福建省三明市",
"86155959", "海南省海口市",
"861355543", "黑龙江省佳木斯市",
"861585549", "安徽省阜阳市",
"861357140", "陕西省铜川市",
"861535652", "浙江省温州市",
"861847012", "江西省上饶市",
"861459138", "广西贵港市",
"861338818", "四川省成都市",
"86189635", "山东省聊城市",
"86139552", "安徽省蚌埠市",
"861336508", "福建省龙岩市",
"861571701", "江西省鹰潭市",
"861390302", "广东省深圳市",
"861853181", "河北省廊坊市",
"861360651", "浙江省杭州市",
"861351356", "山西省晋城市",
"861538842", "四川省宜宾市",
"861848357", "四川省雅安市",
"861350980", "广东省东莞市",
"86186320", "河北省邯郸市",
"861331740", "湖南省岳阳市",
"861300939", "辽宁省鞍山市",
"861450199", "山西省朔州市",
"861888259", "四川省遂宁市",
"861787708", "广西河池市",
"861770591", "福建省福州市",
"861355829", "广西北海市",
"86159523", "江苏省淮安市",
"86156763", "广西桂林市",
"861559069", "吉林省四平市",
"86813", "四川省自贡市",
"861370354", "山西省晋中市",
"861383498", "山西省朔州市",
"861886483", "山东省泰安市",
"861370547", "山东省济宁市",
"861332377", "河南省南阳市",
"861310018", "山西省晋中市",
"861785818", "浙江省丽水市",
"861351583", "浙江省嘉兴市",
"861302846", "陕西省汉中市",
"86187462", "黑龙江省齐齐哈尔市",
"861862469", "辽宁省辽阳市",
"86137483", "内蒙古乌海市",
"861869925", "新疆哈密地区",
"861771503", "江苏省南通市",
"861848544", "贵州省黔南布依族苗族自治州",
"86157122", "天津市",
"861362346", "山西省太原市",
"861780558", "安徽省阜阳市",
"86150875", "云南省保山市",
"861774803", "四川省乐山市",
"86137153", "广东省深圳市",
"861391458", "江苏省镇江市",
"861373451", "黑龙江省双鸭山市",
"861320919", "陕西省铜川市",
"861312533", "江西省抚州市",
"861322356", "山西省晋城市",
"86133621", "浙江省杭州市",
"861770536", "山东省潍坊市",
"861584889", "内蒙古赤峰市",
"861457188", "浙江省台州市",
"861306341", "安徽省安庆市",
"861354883", "湖南省娄底市",
"861582510", "云南省曲靖市",
"861530997", "新疆阿克苏地区",
"861570793", "江西省上饶市",
"861339340", "山西省太原市",
"861336558", "安徽省阜阳市",
"861309149", "黑龙江省鹤岗市",
"861525861", "浙江省台州市",
"861778999", "西藏拉萨市",
"861831935", "广东省肇庆市",
"861771386", "四川省广安市",
"861329021", "山东省临沂市",
"86188792", "江西省九江市",
"861308531", "云南省普洱市",
"86178021", "上海市",
"861458100", "安徽省亳州市",
"861390352", "山西省大同市",
"861337943", "陕西省渭南市",
"861351306", "河北省唐山市",
"861335780", "江苏省南京市",
"861867348", "湖南省娄底市",
"861514679", "黑龙江省哈尔滨市",
"861571751", "湖南省长沙市",
"861888209", "四川省凉山彝族自治州",
"861572918", "河南省南阳市",
"861317021", "安徽省宿州市",
"861508221", "四川省乐山市",
"861575190", "甘肃省酒泉市",
"861896384", "新疆阿克苏地区",
"86186325", "河北省唐山市",
"861853046", "河南省焦作市",
"861350333", "河北省石家庄市",
"861807848", "广西柳州市",
"861370304", "广东省中山市",
"861580339", "河北省邢台市",
"861576109", "贵州省遵义市",
"861858319", "四川省绵阳市",
"861830434", "吉林省四平市",
"861364038", "广东省揭阳市",
"861705678", "浙江省杭州市",
"861770950", "宁夏银川市",
"861557017", "江西省新余市",
"861361877", "云南省玉溪市",
"861530778", "广西河池市",
"861598333", "四川省眉山市",
"861376283", "湖南省娄底市",
"861338269", "江苏省徐州市",
"861333372", "河南省安阳市",
"861836549", "江西省吉安市",
"861809158", "陕西省西安市",
"86155308", "河北省唐山市",
"86138060", "福建省厦门市",
"861367359", "河南省周口市",
"861305294", "江苏省镇江市",
"861334546", "新疆石河子市",
"861776234", "湖北省武汉市",
"861358287", "河北省唐山市",
"861570469", "黑龙江省双鸭山市",
"861327349", "河北省邢台市",
"86155652", "河南省新乡市",
"861763332", "河北省保定市",
"861780633", "山东省日照市",
"861558352", "四川省雅安市",
"861301377", "江苏省苏州市",
"861479286", "安徽省池州市",
"861331846", "广东省东莞市",
"861319349", "河南省鹤壁市",
"861364577", "浙江省温州市",
"861891236", "江苏省无锡市",
"86158917", "陕西省西安市",
"86182849", "四川省广元市",
"86137011", "北京市",
"861773936", "河南省濮阳市",
"861833385", "河北省唐山市",
"861769827", "河南省平顶山市",
"861533597", "湖北省十堰市",
"861335055", "四川省攀枝花市",
"86185636", "山东省潍坊市",
"861783958", "河南省平顶山市",
"861322468", "黑龙江省鹤岗市",
"861534670", "甘肃省临夏回族自治州",
"86155247", "辽宁省大连市",
"861831270", "广东省湛江市",
"861323519", "江苏省常州市",
"861310874", "云南省曲靖市",
"86188372", "河南省安阳市",
"86158866", "湖南省常德市",
"861528445", "云南省玉溪市",
"861567175", "湖北省黄石市",
"861891449", "江苏省南京市",
"86152690", "山东省菏泽市",
"861330313", "河北省张家口市",
"861306928", "吉林省四平市",
"861596543", "山东省滨州市",
"861378409", "河北省唐山市",
"861588434", "四川省眉山市",
"861860918", "陕西省榆林市",
"861832640", "安徽省宣城市",
"861850414", "辽宁省本溪市",
"861771395", "四川省乐山市",
"861869646", "湖北省荆州市",
"861842054", "广东省茂名市",
"861534429", "内蒙古巴彦淖尔市",
"861597958", "江西省抚州市",
"861319025", "辽宁省朝阳市",
"861373947", "四川省成都市",
"861586407", "山东省烟台市",
"861768034", "湖南省衡阳市",
"861312562", "辽宁省营口市",
"861399766", "湖北省宜昌市",
"861518907", "江苏省宿迁市",
"861325739", "湖南省邵阳市",
"861567213", "湖北省十堰市",
"861707552", "安徽省芜湖市",
"861338074", "广东省阳江市",
"861314723", "湖北省黄石市",
"861890253", "广东省珠海市",
"861572067", "江苏省苏州市",
"861360465", "黑龙江省大庆市",
"86184347", "山西省晋中市",
"861598980", "广东省汕头市",
"861335886", "辽宁省沈阳市",
"861367309", "河南省信阳市",
"861845246", "江苏省扬州市",
"861388248", "四川省阿坝藏族羌族自治州",
"861850741", "湖南省株洲市",
"861876112", "江苏省宿迁市",
"861831981", "广东省汕尾市",
"861558302", "四川省南充市",
"861539472", "内蒙古包头市",
"861308585", "广东省中山市",
"861538290", "广东省汕头市",
"861359850", "河南省焦作市",
"861824988", "黑龙江省伊春市",
"861335005", "四川省成都市",
"86130557", "福建省福州市",
"861880842", "四川省遂宁市",
"861700752", "广东省惠州市",
"861302740", "湖南省常德市",
"861776412", "湖北省武汉市",
"861370490", "辽宁省铁岭市",
"861304605", "山东省淄博市",
"861803643", "江苏省南通市",
"861315598", "江西省九江市",
"861895489", "山东省泰安市",
"861817606", "广西北海市",
"861310645", "浙江省台州市",
"861311749", "湖南省邵阳市",
"861306016", "四川省广元市",
"861563669", "黑龙江省双鸭山市",
"86156694", "浙江省杭州市",
"86152695", "山东省烟台市",
"861877277", "湖北省十堰市",
"861345870", "四川省泸州市",
"861313526", "湖南省怀化市",
"861309777", "广西钦州市",
"861586457", "山东省潍坊市",
"861586328", "山东省潍坊市",
"861310967", "陕西省延安市",
"861804019", "辽宁省朝阳市",
"861842004", "广东省汕尾市",
"861857212", "湖北省孝感市",
"861360523", "江苏省淮安市",
"86183837", "四川省阿坝藏族羌族自治州",
"86185940", "广东省广州市",
"861580611", "江苏省常州市",
"861501419", "广东省广州市",
"861376892", "广西桂林市",
"861572858", "广东省韶关市",
"861576655", "广东省清远市",
"861351540", "山东省潍坊市",
"861813023", "安徽省淮北市",
"861839745", "湖南省常德市",
"861397290", "湖北省荆门市",
"861365690", "福建省三明市",
"861330140", "江苏省淮安市",
"861890477", "内蒙古鄂尔多斯市",
"861586331", "山东省德州市",
"86155508", "山东省泰安市",
"861339383", "河南省开封市",
"861776788", "吉林省白城市",
"861300025", "江苏省南京市",
"861369374", "河南省许昌市",
"861525286", "江苏省宿迁市",
"861354840", "四川省甘孜藏族自治州",
"861892264", "广东省肇庆市",
"861515291", "江苏省镇江市",
"861323492", "黑龙江省大庆市",
"861822095", "陕西省商洛市",
"861560233", "广东省广州市",
"861335372", "河南省安阳市",
"86170862", "山东省青岛市",
"861777153", "湖北省咸宁市",
"861521792", "广东省广州市",
"861320859", "贵州省毕节地区",
"861882184", "湖南省衡阳市",
"861513865", "河南省郑州市",
"86187261", "安徽省安庆市",
"861360849", "河南省焦作市",
"861816306", "湖北省荆门市",
"861318735", "湖南省郴州市",
"861560371", "河南省郑州市",
"861800466", "黑龙江省哈尔滨市",
"86188572", "浙江省湖州市",
"861589139", "陕西省西安市",
"861530968", "安徽省阜阳市",
"861810158", "江苏省南京市",
"861877453", "湖南省张家界市",
"861367723", "湖北省荆门市",
"861477865", "广东省中山市",
"861889527", "宁夏银川市",
"861587628", "广东省江门市",
"861300349", "江苏省宿迁市",
"86188210", "上海市",
"861313789", "河南省许昌市",
"861506144", "江苏省徐州市",
"861362991", "新疆乌鲁木齐市",
"861362500", "福建省厦门市",
"86134230", "广东省东莞市",
"861812801", "广东省东莞市",
"861328890", "广东省清远市",
"861339506", "福建省泉州市",
"861306996", "黑龙江省绥化市",
"861570674", "浙江省嘉兴市",
"861333055", "云南省大理白族自治州",
"861399152", "陕西省安康市",
"861832452", "黑龙江省齐齐哈尔市",
"861576605", "广东省茂名市",
"861572808", "浙江省舟山市",
"861553978", "河南省平顶山市",
"861532657", "黑龙江省佳木斯市",
"861533483", "内蒙古阿拉善盟",
"861366659", "浙江省舟山市",
"861398578", "贵州省黔南布依族苗族自治州",
"861326649", "广东省江门市",
"86132396", "甘肃省兰州市",
"86139092", "陕西省西安市",
"861824646", "黑龙江省七台河市",
"861787613", "广东省湛江市",
"861348472", "内蒙古包头市",
"86187089", "海南省海口市",
"861521246", "安徽省黄山市",
"861515449", "山东省潍坊市",
"86184547", "山东省济宁市",
"861454888", "四川省绵阳市",
"861310777", "浙江省温州市",
"861453460", "黑龙江省大兴安岭地区",
"861843246", "河北省石家庄市",
"861338958", "宁夏银川市",
"861362936", "甘肃省张掖市",
"861309967", "云南省保山市",
"861333886", "江苏省扬州市",
"861339930", "甘肃省临夏回族自治州",
"861777103", "湖北省襄樊市",
"861309645", "四川省德阳市",
"861323739", "湖南省邵阳市",
"861306931", "河南省开封市",
"861478122", "四川省雅安市",
"861831345", "云南省文山壮族苗族自治州",
"861875298", "江苏省苏州市",
"861816356", "湖北省襄樊市",
"861826533", "山东省淄博市",
"861452815", "四川省绵阳市",
"861320809", "浙江省宁波市",
"861571193", "广东省广州市",
"861597269", "湖北省宜昌市",
"861337333", "河北省张家口市",
"86718", "湖北省恩施土家族苗族自治州",
"861329577", "浙江省温州市",
"861343870", "四川省乐山市",
"861314359", "广东省佛山市",
"86185766", "广东省深圳市",
"861582891", "四川省巴中市",
"861399976", "新疆博尔塔拉蒙古自治州",
"861833619", "河南省驻马店市",
"861590672", "浙江省湖州市",
"86134235", "广东省茂名市",
"861313598", "湖北省荆门市",
"861893489", "广西贵港市",
"861760542", "山东省青岛市",
"86132577", "广西南宁市",
"861804148", "辽宁省沈阳市",
"861362550", "安徽省滁州市",
"861322540", "山东省菏泽市",
"861818940", "甘肃省武威市",
"861707873", "云南省红河哈尼族彝族自治州",
"861371987", "广东省阳江市",
"861372332", "宁夏石嘴山市",
"861331783", "广西桂林市",
"86130357", "广东省梅州市",
"861361774", "广西梧州市",
"861333005", "江西省南昌市",
"861832402", "新疆喀什地区",
"861339556", "安徽省安庆市",
"861580949", "甘肃省陇南市",
"861317577", "浙江省丽水市",
"861308528", "湖北省襄樊市",
"86152681", "浙江省杭州市",
"861333895", "江苏省盐城市",
"861583549", "山西省朔州市",
"861860808", "四川省绵阳市",
"861811020", "安徽省蚌埠市",
"861854505", "黑龙江省大庆市",
"86152850", "贵州省贵阳市",
"861524171", "辽宁省铁岭市",
"861375401", "内蒙古呼和浩特市",
"86156289", "山东省济南市",
"861329038", "山东省莱芜市",
"861560262", "广东省惠州市",
"86185567", "江苏省苏州市",
"861883065", "河北省石家庄市",
"861382462", "广东省肇庆市",
"861476288", "江苏省南京市",
"861802029", "江苏省无锡市",
"861377844", "四川省泸州市",
"861475644", "河北省承德市",
"861536251", "广东省江门市",
"861339275", "广东省佛山市",
"861582001", "山东省济南市",
"861557778", "广西柳州市",
"861535440", "河北省邯郸市",
"861575062", "内蒙古乌兰察布市",
"861804257", "浙江省金华市",
"861308711", "内蒙古呼和浩特市",
"861317038", "湖南省娄底市",
"861328796", "山东省烟台市",
"861508238", "四川省攀枝花市",
"86147165", "广东省广州市",
"861816468", "云南省丽江市",
"861315567", "安徽省亳州市",
"86157341", "辽宁省大连市",
"861586385", "山东省临沂市",
"861351497", "安徽省合肥市",
"861398037", "四川省眉山市",
"861886597", "山东省东营市",
"861862845", "陕西省咸阳市",
"861803680", "江苏省泰州市",
"86159323", "河北省张家口市",
"861812036", "湖北省咸宁市",
"861837414", "湖南省娄底市",
"861561575", "山东省烟台市",
"861801402", "江苏省苏州市",
"861770716", "湖北省荆州市",
"861334350", "湖北省荆州市",
"86186520", "江苏省南京市",
"861778019", "四川省绵阳市",
"861387203", "湖北省黄冈市",
"86187000", "陕西省咸阳市",
"861802345", "广东省广州市",
"86184746", "湖南省永州市",
"861595708", "浙江省舟山市",
"861847634", "广东省广州市",
"86134603", "河南省郑州市",
"861839282", "陕西省渭南市",
"861383426", "山西省大同市",
"861550578", "浙江省丽水市",
"861824925", "黑龙江省佳木斯市",
"861856749", "河南省新乡市",
"86139608", "福建省福州市",
"86155892", "山东省枣庄市",
"86139352", "山西省大同市",
"861373337", "河北省保定市",
"861572098", "江西省九江市",
"861376052", "广东省江门市",
"861359162", "辽宁省铁岭市",
"86152855", "贵州省贵阳市",
"861860858", "贵州省六盘水市",
"861533602", "甘肃省庆阳市",
"86189946", "江苏省泰州市",
"861328000", "山东省济南市",
"861884982", "云南省保山市",
"861595064", "江苏省宿迁市",
"861592689", "湖北省襄樊市",
"861806972", "浙江省湖州市",
"861459121", "广西梧州市",
"861310149", "福建省三明市",
"861835115", "江苏省泰州市",
"861377675", "江苏省徐州市",
"861375451", "河北省石家庄市",
"86137931", "山东省济南市",
"861533568", "内蒙古巴彦淖尔市",
"861804207", "浙江省宁波市",
"86138299", "广东省惠州市",
"861800427", "辽宁省盘锦市",
"861582051", "广东省中山市",
"861390075", "海南省海口市",
"861800358", "山西省吕梁市",
"861532419", "河北省张家口市",
"86150683", "浙江省嘉兴市",
"861476514", "广东省广州市",
"861384975", "河南省信阳市",
"861319088", "内蒙古通辽市",
"861316915", "广东省阳江市",
"861317989", "新疆和田地区",
"861576461", "黑龙江省哈尔滨市",
"861821254", "贵州省铜仁地区",
"861557259", "湖北省荆门市",
"86131136", "广东省深圳市",
"861334300", "河北省邯郸市",
"86186525", "江苏省扬州市",
"861830541", "山东省济南市",
"861801452", "江苏省泰州市",
"861306985", "黑龙江省七台河市",
"861329989", "青海省海东地区",
"861890082", "广东省湛江市",
"86147888", "河南省郑州市",
"861518817", "云南省玉溪市",
"861328242", "浙江省杭州市",
"86187005", "陕西省安康市",
"86156633", "黑龙江省齐齐哈尔市",
"861333780", "江苏省南京市",
"861508887", "浙江省舟山市",
"861518534", "贵州省遵义市",
"861862674", "吉林省吉林市",
"861590821", "四川省绵阳市",
"861844561", "黑龙江省黑河市",
"861501496", "广东省惠州市",
"861831998", "广东省广州市",
"861361393", "河南省濮阳市",
"861590780", "广西防城港市",
"861367417", "辽宁省营口市",
"861869011", "新疆塔城地区",
"861333821", "福建省宁德市",
"861304593", "福建省宁德市",
"861820762", "广东省河源市",
"861802777", "广东省茂名市",
"861322606", "广东省中山市",
"861510707", "江西省赣州市",
"86185337", "河北省廊坊市",
"861300145", "河北省邢台市",
"86139903", "四川省眉山市",
"861809740", "青海省西宁市",
"861504747", "内蒙古通辽市",
"861843411", "山西省太原市",
"86147474", "内蒙古兴安盟",
"861845847", "浙江省温州市",
"861858941", "西藏那曲地区",
"861836232", "江苏省泰州市",
"861376675", "黑龙江省伊春市",
"861592615", "湖北省十堰市",
"861454265", "西藏昌都地区",
"861390568", "安徽省阜阳市",
"861303050", "江西省景德镇市",
"861370654", "浙江省台州市",
"861479238", "安徽省宿州市",
"861453813", "四川省成都市",
"861329915", "陕西省安康市",
"861300851", "陕西省铜川市",
"86156733", "湖南省株洲市",
"861805380", "山东省泰安市",
"86150350", "山西省运城市",
"861821800", "广东省佛山市",
"861815310", "贵州省贵阳市",
"861340462", "吉林省四平市",
"861891288", "江苏省南通市",
"86152570", "浙江省衢州市",
"86150783", "广西桂林市",
"861305511", "湖南省株洲市",
"861360351", "山西省太原市",
"861599906", "新疆博尔塔拉蒙古自治州",
"861317915", "吉林省延边朝鲜族自治州",
"861325596", "河南省郑州市",
"861819562", "青海省海东地区",
"861827608", "广西百色市",
"861316989", "广东省中山市",
"861804916", "陕西省汉中市",
"861318767", "云南省楚雄彝族自治州",
"861534418", "内蒙古锡林郭勒盟",
"861320341", "山西省太原市",
"861824991", "广西河池市",
"861760594", "福建省莆田市",
"86156178", "河南省郑州市",
"861520879", "云南省普洱市",
"861374060", "福建省漳州市",
"861332003", "江西省上饶市",
"861814986", "新疆巴音郭楞蒙古自治州",
"861306919", "吉林省通化市",
"861303796", "宁夏银川市",
"861860929", "陕西省延安市",
"861315581", "江西省南昌市",
"861477837", "广东省湛江市",
"861846992", "云南省文山壮族苗族自治州",
"861376844", "广西南宁市",
"861331247", "贵州省毕节地区",
"861306641", "广东省江门市",
"861556778", "吉林省松原市",
"86177507", "福建省泉州市",
"861339640", "山东省济南市",
"861309935", "甘肃省庆阳市",
"86151981", "四川省成都市",
"861850549", "山东省临沂市",
"861316038", "江苏省南通市",
"861566420", "河南省许昌市",
"86155112", "河北省保定市",
"86150988", "山东省济南市",
"861313422", "辽宁省沈阳市",
"861807156", "湖北省襄樊市",
"861362646", "山东省潍坊市",
"861510757", "广东省佛山市",
"861322656", "广东省清远市",
"861558483", "吉林省通化市",
"861538978", "内蒙古巴彦淖尔市",
"861569304", "甘肃省临夏回族自治州",
"861314155", "湖南省益阳市",
"861388489", "山东省临沂市",
"861589111", "陕西省延安市",
"861709666", "浙江省宁波市",
"861894537", "黑龙江省黑河市",
"861325531", "山东省济南市",
"861561068", "山东省临沂市",
"86187432", "吉林省吉林市",
"86152781", "广西南宁市",
"861873970", "河南省安阳市",
"861880797", "江西省赣州市",
"861882032", "广东省东莞市",
"861509804", "湖北省黄冈市",
"861363454", "黑龙江省佳木斯市",
"861566679", "山东省青岛市",
"861383435", "山西省吕梁市",
"861353958", "广东省珠海市",
"861303731", "湖南省长沙市",
"861478042", "四川省成都市",
"86176027", "湖北省武汉市",
"861894814", "广东省河源市",
"861355074", "四川省宜宾市",
"861844587", "黑龙江省哈尔滨市",
"86156938", "甘肃省天水市",
"861598558", "贵州省六盘水市",
"861580639", "山东省青岛市",
"86150355", "山西省长治市",
"861501431", "广东省汕头市",
"861300801", "山西省运城市",
"861350633", "山东省日照市",
"861459316", "四川省遂宁市",
"861370604", "福建省宁德市",
"861705378", "广东省东莞市",
"861311541", "黑龙江省哈尔滨市",
"861539576", "浙江省台州市",
"86183036", "河南省新乡市",
"86178623", "山东省日照市",
"86134703", "辽宁省阜新市",
"861512863", "河北省承德市",
"861346824", "山东省莱芜市",
"861521744", "广东省广州市",
"861818630", "湖北省襄樊市",
"861812349", "四川省成都市",
"86152575", "浙江省绍兴市",
"861369793", "江西省上饶市",
"861857749", "广西北海市",
"86139708", "江西省南昌市",
"861318820", "辽宁省本溪市",
"861473557", "山西省长治市",
"861821850", "广东省江门市",
"86156574", "浙江省宁波市",
"861312466", "贵州省黔南布依族苗族自治州",
"861840314", "河北省承德市",
"86138414", "辽宁省本溪市",
"861804028", "辽宁省朝阳市",
"861867648", "广东省珠海市",
"861895248", "江苏省无锡市",
"861302158", "山东省日照市",
"86134099", "湖北省黄冈市",
"86184434", "吉林省四平市",
"861898467", "贵州省铜仁地区",
"861390652", "浙江省杭州市",
"861351606", "辽宁省锦州市",
"861835628", "安徽省铜陵市",
"86189660", "浙江省金华市",
"861452564", "贵州省贵阳市",
"861335838", "福建省厦门市",
"861770463", "福建省泉州市",
"861778085", "四川省凉山彝族自治州",
"861332053", "云南省昆明市",
"86532", "山东省青岛市",
"861801340", "江苏省无锡市",
"861777599", "湖南省长沙市",
"861880978", "青海省西宁市",
"861319649", "江苏省扬州市",
"861450621", "黑龙江省齐齐哈尔市",
"86188852", "贵州省遵义市",
"861811140", "四川省凉山彝族自治州",
"861707368", "河南省南阳市",
"861338543", "山东省滨州市",
"861769267", "河北省邢台市",
"861301677", "江苏省南通市",
"861780333", "河北省秦皇岛市",
"861539255", "山西省长治市",
"861558652", "湖北省黄冈市",
"861776103", "四川省绵阳市",
"861363390", "河南省新乡市",
"861312427", "辽宁省大连市",
"861307931", "甘肃省嘉峪关市",
"861309270", "湖北省鄂州市",
"861457191", "浙江省台州市",
"861312358", "广西河池市",
"861315535", "安徽省马鞍山市",
"86134359", "广东省云浮市",
"861577605", "黑龙江省绥化市",
"86138030", "天津市",
"861802149", "江苏省镇江市",
"861895157", "江苏省无锡市",
"861538797", "江西省赣州市",
"861327649", "山东省济南市",
"86135021", "天津市",
"861346152", "河南省信阳市",
"861528070", "福建省三明市",
"861303890", "陕西省安康市",
"861883037", "河北省秦皇岛市",
"861786613", "甘肃省兰州市",
"861820733", "湖南省株洲市",
"861300091", "吉林省长春市",
"861354244", "广东省云浮市",
"861364855", "贵州省黔东南苗族侗族自治州",
"861350558", "安徽省阜阳市",
"861564692", "新疆伊犁哈萨克自治州",
"861884624", "黑龙江省鸡西市",
"861590886", "云南省怒江傈僳族自治州",
"861581224", "云南省丽江市",
"86177706", "江西省吉安市",
"861893415", "广东省东莞市",
"86156911", "陕西省延安市",
"86158836", "四川省德阳市",
"861301053", "广东省韶关市",
"861870570", "浙江省衢州市",
"861838639", "贵州省黔西南布依族苗族自治州",
"861770799", "江西省萍乡市",
"861778096", "四川省绵阳市",
"861338829", "四川省泸州市",
"861330613", "江苏省苏州市",
"861316577", "陕西省商洛市",
"861815478", "广西桂林市",
"861390483", "黑龙江省牡丹江市",
"861534370", "河南省商丘市",
"861839377", "甘肃省陇南市",
"861452889", "云南省曲靖市",
"861858407", "四川省成都市",
"861532431", "河北省邯郸市",
"86153392", "陕西省西安市",
"861809846", "安徽省六安市",
"861355818", "广西南宁市",
"861778750", "云南省保山市",
"861454510", "湖南省长沙市",
"861779738", "青海省海南藏族自治州",
"861362925", "陕西省安康市",
"861336333", "河北省衡水市",
"861780271", "湖北省武汉市",
"861369469", "黑龙江省鹤岗市",
"861555842", "浙江省宁波市",
"861308492", "广西柳州市",
"86185666", "广东省深圳市",
"861571509", "福建省莆田市",
"861361555", "安徽省马鞍山市",
"861848419", "贵州省安顺市",
"861510914", "陕西省商洛市",
"861332893", "福建省宁德市",
"86151494", "内蒙古鄂尔多斯市",
"861844979", "新疆伊犁哈萨克自治州",
"861861746", "河北省秦皇岛市",
"861785829", "浙江省舟山市",
"861312308", "福建省龙岩市",
"861310029", "湖南省常德市",
"861318726", "湖南省郴州市",
"861346976", "湖北省荆门市",
"861500984", "辽宁省营口市",
"861803772", "河南省商丘市",
"861539205", "福建省福州市",
"861778031", "四川省宜宾市",
"861856212", "山东省德州市",
"861470907", "新疆博尔塔拉蒙古自治州",
"861805110", "江苏省苏州市",
"861771338", "黑龙江省鹤岗市",
"861802998", "广东省惠州市",
"861775925", "福建省福州市",
"861575471", "内蒙古呼和浩特市",
"86181297", "广东省惠州市",
"861320928", "陕西省延安市",
"861886302", "山东省聊城市",
"861569490", "河北省承德市",
"861899944", "新疆哈密地区",
"861558568", "吉林省通化市",
"861509122", "陕西省榆林市",
"861325585", "浙江省绍兴市",
"861586628", "山东省淄博市",
"861829306", "甘肃省定西市",
"86469", "黑龙江省双鸭山市",
"86130896", "黑龙江省佳木斯市",
"861863843", "河南省商丘市",
"861563369", "河北省石家庄市",
"861561917", "陕西省宝鸡市",
"861814995", "新疆吐鲁番地区",
"861310345", "山西省长治市",
"861770432", "吉林省吉林市",
"861568272", "甘肃省武威市",
"861327911", "陕西省延安市",
"861770588", "浙江省嘉兴市",
"861778700", "云南省昆明市",
"861304305", "福建省三明市",
"861336980", "新疆昌吉回族自治州",
"861803343", "广东省深圳市",
"861810783", "广西桂林市",
"861309981", "云南省红河哈尼族彝族自治州",
"861564934", "河南省商丘市",
"861554438", "河南省南阳市",
"861571559", "安徽省黄山市",
"861572929", "河南省周口市",
"861308739", "湖南省邵阳市",
"861593140", "河北省承德市",
"861876453", "山东省滨州市",
"861472668", "四川省达州市",
"861305890", "浙江省湖州市",
"861317805", "福建省莆田市",
"861804806", "四川省达州市",
"861776830", "江苏省无锡市",
"86170832", "河北省保定市",
"861885037", "福建省福州市",
"861581260", "广东省珠海市",
"861586631", "山东省威海市",
"861339683", "浙江省嘉兴市",
"861369674", "安徽省滁州市",
"861529934", "新疆巴音郭楞蒙古自治州",
"861306809", "山西省大同市",
"86156018", "上海市",
"861308519", "湖北省恩施土家族苗族自治州",
"861800533", "山东省淄博市",
"86474", "内蒙古乌兰察布市",
"861867995", "江西省南昌市",
"861554421", "河南省洛阳市",
"86176882", "广东省佛山市",
"861864306", "吉林省长春市",
"861472873", "贵州省铜仁地区",
"861550201", "广东省深圳市",
"86134559", "山东省临沂市",
"861313535", "湖南省郴州市",
"861365390", "河南省新乡市",
"861821910", "广东省湛江市",
"86183867", "贵州省黔东南苗族侗族自治州",
"861379371", "山东省枣庄市",
"861522293", "安徽省芜湖市",
"861366309", "河南省平顶山市",
"861580311", "河北省石家庄市",
"861532307", "广东省惠州市",
"861518216", "四川省成都市",
"86188999", "上海市",
"86156794", "江西省抚州市",
"86152795", "江西省宜春市",
"861876277", "江苏省扬州市",
"861831874", "广东省肇庆市",
"861778028", "四川省成都市",
"861310270", "河北省沧州市",
"861532544", "浙江省舟山市",
"861855949", "福建省泉州市",
"861570374", "河南省许昌市",
"861804085", "新疆巴音郭楞蒙古自治州",
"861381441", "江苏省徐州市",
"861300649", "四川省绵阳市",
"861301745", "贵州省贵阳市",
"861858273", "四川省眉山市",
"861358261", "河北省石家庄市",
"86134260", "北京市",
"861508286", "四川省达州市",
"861524490", "四川省遂宁市",
"861596908", "云南省大理白族自治州",
"861317086", "江西省南昌市",
"861880768", "广东省潮州市",
"86153592", "福建省厦门市",
"861551376", "山西省晋中市",
"861320931", "甘肃省兰州市",
"861560671", "浙江省杭州市",
"861474137", "辽宁省营口市",
"861813478", "河南省洛阳市",
"861319091", "内蒙古赤峰市",
"86183916", "陕西省汉中市",
"86139246", "广东省深圳市",
"86150413", "辽宁省抚顺市",
"861329086", "福建省泉州市",
"861817497", "广西百色市",
"861816606", "江西省赣州市",
"86180349", "山西省朔州市",
"861591180", "云南省昭通市",
"86135928", "广东省汕头市",
"861565137", "江苏省宿迁市",
"861327036", "江苏省徐州市",
"861309345", "安徽省合肥市",
"861318798", "云南省迪庆藏族自治州",
"86135723", "陕西省渭南市",
"861332282", "广东省佛山市",
"861317855", "广东省湛江市",
"861813180", "河北省衡水市",
"861593313", "河北省张家口市",
"861590743", "湖南省湘西土家族苗族自治州",
"861324469", "黑龙江省大庆市",
"86188008", "四川省南充市",
"861768312", "四川省攀枝花市",
"861573471", "内蒙古呼和浩特市",
"861868653", "吉林省长春市",
"861306859", "广东省河源市",
"861773925", "河南省鹤壁市",
"861529692", "宁夏石嘴山市",
"86183429", "辽宁省葫芦岛市",
"861526871", "浙江省湖州市",
"861329855", "湖南省张家界市",
"861300911", "吉林省长春市",
"861866921", "云南省昆明市",
"861819713", "青海省西宁市",
"861390597", "福建省泉州市",
"861319036", "辽宁省葫芦岛市",
"861377283", "陕西省汉中市",
"861369845", "江西省赣州市",
"861837549", "山东省临沂市",
"861559776", "贵州省遵义市",
"861532357", "广东省肇庆市",
"861366359", "山西省运城市",
"861809783", "新疆阿克苏地区",
"861532428", "河北省衡水市",
"86152411", "辽宁省大连市",
"861560154", "江苏省苏州市",
"861310981", "辽宁省大连市",
"861855611", "江苏省泰州市",
"861384737", "内蒙古鄂尔多斯市",
"86155752", "湖南省永州市",
"861872822", "四川省阿坝藏族羌族自治州",
"861309029", "陕西省西安市",
"86152790", "江西省新余市",
"861505869", "浙江省丽水市",
"861329141", "浙江省杭州市",
"861595140", "江苏省镇江市",
"861855198", "江苏省南京市",
"861450638", "黑龙江省绥化市",
"861572081", "江苏省南京市",
"861820513", "江苏省连云港市",
"861328539", "山东省临沂市",
"861337633", "山东省日照市",
"861527984", "江西省吉安市",
"861317141", "内蒙古呼和浩特市",
"861590372", "河南省安阳市",
"861783543", "山西省晋中市",
"86185736", "湖南省常德市",
"86151990", "新疆乌鲁木齐市",
"861831967", "广东省广州市",
"861874952", "河南省商丘市",
"861831645", "广东省云浮市",
"861830749", "湖南省永州市",
"86138784", "广西梧州市",
"861323585", "浙江省绍兴市",
"86189498", "安徽省合肥市",
"861320985", "山西省长治市",
"861869550", "宁夏中卫市",
"861843847", "河南省洛阳市",
"861564557", "黑龙江省七台河市",
"861594946", "内蒙古呼伦贝尔市",
"861833189", "河北省邯郸市",
"86138915", "陕西省安康市",
"861829540", "宁夏银川市",
"86153808", "江苏省南京市",
"86133721", "江苏省苏州市",
"861339402", "福建省泉州市",
"861831926", "广东省梅州市",
"861800608", "福建省三明市",
"861780943", "甘肃省白银市",
"86152083", "四川省成都市",
"86139872", "云南省大理白族自治州",
"86132140", "内蒙古呼和浩特市",
"861815143", "江苏省扬州市",
"861814648", "新疆阿克苏地区",
"861817540", "安徽省马鞍山市",
"861895722", "浙江省舟山市",
"861506060", "福建省泉州市",
"86185537", "山东省济宁市",
"861539061", "甘肃省临夏回族自治州",
"861771199", "西藏拉萨市",
"861800562", "安徽省铜陵市",
"861324793", "江西省上饶市",
"861327851", "吉林省四平市",
"861536037", "广东省云浮市",
"861533352", "山西省大同市",
"861321484", "内蒙古鄂尔多斯市",
"861362039", "广东省中山市",
"861316021", "江苏省镇江市",
"861599710", "湖北省黄石市",
"861325711", "湖北省孝感市",
"861776736", "浙江省温州市",
"861820972", "青海省海东地区",
"861560822", "四川省成都市",
"861869936", "新疆昌吉回族自治州",
"861313581", "湖北省宜昌市",
"861871499", "安徽省合肥市",
"861509707", "甘肃省平凉市",
"861821133", "广东省广州市",
"861802645", "广东省惠州市",
"861323596", "福建省漳州市",
"861806848", "江苏省徐州市",
"861303511", "湖北省武汉市",
"861577109", "湖北省十堰市",
"86152438", "湖南省娄底市",
"861393997", "河南省安阳市",
"861368475", "内蒙古呼和浩特市",
"861337558", "山东省青岛市",
"861500322", "河北省保定市",
"861334650", "广东省韶关市",
"86189730", "湖南省岳阳市",
"861770525", "江苏省扬州市",
"86152370", "河南省商丘市",
"861510854", "贵州省黔南布依族苗族自治州",
"86188692", "云南省德宏傣族景颇族自治州",
"861582888", "四川省遂宁市",
"861325528", "江苏省南京市",
"861479784", "江西省抚州市",
"861773646", "河北省沧州市",
"861587619", "广东省汕头市",
"861705223", "天津市",
"861357613", "江西省南昌市",
"861810740", "湖南省岳阳市",
"861535075", "河北省沧州市",
"861477734", "广西桂林市",
"86138910", "陕西省咸阳市",
"861825093", "福建省宁德市",
"861760446", "吉林省白城市",
"86151433", "吉林省延边朝鲜族自治州",
"861801113", "四川省绵阳市",
"861776791", "吉林省吉林市",
"861338580", "浙江省舟山市",
"861587941", "江西省吉安市",
"861323531", "山东省济南市",
"861318864", "辽宁省辽阳市",
"861319801", "四川省内江市",
"861875970", "福建省三明市",
"861882614", "广东省广州市",
"861800658", "浙江省台州市",
"861339452", "黑龙江省齐齐哈尔市",
"861515288", "江苏省南通市",
"861892152", "江苏省无锡市",
"861356140", "山东省潍坊市",
"861590261", "贵州省贵阳市",
"86130656", "浙江省宁波市",
"861786279", "山东省日照市",
"861347079", "安徽省阜阳市",
"861315422", "辽宁省朝阳市",
"86180824", "甘肃省张掖市",
"861516644", "山东省日照市",
"86137961", "黑龙江省哈尔滨市",
"861364915", "陕西省安康市",
"86158067", "山东省菏泽市",
"861452520", "山东省济宁市",
"861533302", "山西省大同市",
"861330708", "江西省南昌市",
"861360437", "吉林省辽源市",
"861333838", "福建省龙岩市",
"861470817", "四川省眉山市",
"861862374", "河南省安阳市",
"861538768", "四川省阿坝藏族羌族自治州",
"861330279", "广东省潮州市",
"861314417", "广东省肇庆市",
"861362988", "河南省许昌市",
"861337662", "广东省阳江市",
"861851577", "四川省德阳市",
"861454836", "广东省东莞市",
"861329095", "福建省福州市",
"861889433", "甘肃省兰州市",
"861772404", "广东省广州市",
"861556968", "甘肃省平凉市",
"861470534", "山东省德州市",
"86147975", "青海省西宁市",
"861450503", "吉林省延边朝鲜族自治州",
"861304487", "湖北省荆门市",
"861871241", "安徽省安庆市",
"861835696", "安徽省合肥市",
"861707397", "河南省信阳市",
"86152375", "河南省平顶山市",
"861775039", "福建省南平市",
"861860146", "江苏省无锡市",
"861334600", "浙江省嘉兴市",
"86189735", "湖南省郴州市",
"86156374", "河南省许昌市",
"861803933", "河南省郑州市",
"86131166", "浙江省宁波市",
"861337508", "福建省龙岩市",
"861475557", "安徽省宣城市",
"861332745", "山西省长治市",
"86150555", "安徽省阜阳市",
"861804096", "新疆伊犁哈萨克自治州",
"861390440", "吉林省吉林市",
"861317095", "江西省宜春市",
"861380922", "广东省佛山市",
"861348576", "安徽省滁州市",
"861810064", "江苏省南通市",
"861536882", "云南省德宏傣族景颇族自治州",
"86147402", "辽宁省鞍山市",
"861552024", "四川省雅安市",
"86178542", "山东省青岛市",
"861700766", "广东省茂名市",
"861829558", "宁夏银川市",
"861363564", "安徽省六安市",
"861809020", "四川省巴中市",
"861321641", "浙江省衢州市",
"861846218", "山东省烟台市",
"861878342", "四川省凉山彝族自治州",
"861391302", "江苏省南京市",
"861350356", "山西省晋城市",
"861582913", "陕西省商洛市",
"861570701", "江西省鹰潭市",
"861595247", "江苏省无锡市",
"861567647", "广西百色市",
"861322271", "江苏省淮安市",
"861816943", "湖南省长沙市",
"861330740", "湖南省岳阳市",
"8613262", "上海市",
"861839145", "陕西省西安市",
"861392445", "广东省韶关市",
"86137534", "山西省晋中市",
"861519657", "四川省雅安市",
"861333310", "河北省邯郸市",
"861771900", "河南省商丘市",
"8618910", "北京市",
"861771591", "江苏省盐城市",
"861824460", "河北省邯郸市",
"861399752", "湖北省咸宁市",
"861312556", "辽宁省丹东市",
"861580798", "江西省景德镇市",
"861577501", "广东省深圳市",
"86170859", "福建省泉州市",
"861529467", "河南省安阳市",
"86137978", "湖北省十堰市",
"86181721", "广西柳州市",
"861868946", "广东省深圳市",
"861893200", "贵州省贵阳市",
"861705255", "北京市",
"86180728", "浙江省杭州市",
"861707566", "安徽省安庆市",
"861452454", "黑龙江省佳木斯市",
"86188270", "湖北省武汉市",
"861770553", "安徽省芜湖市",
"86158996", "广东省东莞市",
"86150346", "山西省晋中市",
"861570030", "四川省广安市",
"861810758", "广东省肇庆市",
"861534612", "河南省三门峡市",
"86182921", "陕西省延安市",
"86134532", "山西省晋中市",
"861450525", "吉林省辽源市",
"861365520", "江苏省徐州市",
"861782016", "广东省梅州市",
"861359733", "广西桂林市",
"861390408", "辽宁省大连市",
"861517467", "黑龙江省牡丹江市",
"861589739", "湖南省邵阳市",
"861831212", "广东省肇庆市",
"861453646", "江苏省苏州市",
"861876532", "山东省青岛市",
"861318135", "山东省德州市",
"861588981", "广东省潮州市",
"861315631", "山东省威海市",
"861882784", "江西省宜春市",
"861335143", "黑龙江省牡丹江市",
"861360693", "福建省厦门市",
"861337540", "山东省菏泽市",
"861323139", "河北省秦皇岛市",
"861823237", "河北省秦皇岛市",
"861552192", "广东省揭阳市",
"861478722", "云南省大理白族自治州",
"861769124", "陕西省西安市",
"861830935", "甘肃省武威市",
"861800640", "山东省济南市",
"861588270", "四川省巴中市",
"861777703", "广西钦州市",
"861570751", "广东省湛江市",
"861539410", "陕西省咸阳市",
"861834417", "广东省湛江市",
"861829508", "宁夏银川市",
"861310177", "河南省南阳市",
"86137138", "广东省深圳市",
"861313628", "浙江省舟山市",
"861355940", "福建省泉州市",
"861357783", "云南省楚雄彝族自治州",
"861894687", "青海省海西蒙古族藏族自治州",
"861599680", "江苏省镇江市",
"861325681", "山东省威海市",
"861762587", "江苏省徐州市",
"861812745", "广东省清远市",
"861347752", "湖北省武汉市",
"861362813", "四川省内江市",
"86145307", "上海市",
"861814600", "福建省宁德市",
"861519607", "四川省泸州市",
"861315696", "山东省潍坊市",
"86153426", "湖北省咸宁市",
"861351333", "河北省唐山市",
"861705205", "广东省佛山市",
"861893250", "河北省唐山市",
"861580589", "浙江省金华市",
"861898507", "贵州省黔南布依族苗族自治州",
"861350583", "浙江省嘉兴市",
"861886666", "山东省滨州市",
"861368881", "广东省深圳市",
"861399702", "青海省海东地区",
"861828906", "西藏那曲地区",
"86157022", "天津市",
"861896534", "福建省三明市",
"86188275", "湖北省襄樊市",
"861770503", "福建省宁德市",
"861322980", "广东省清远市",
"8614770", "广东省广州市",
"861345812", "四川省攀枝花市",
"86132517", "吉林省长春市",
"861511042", "山西省太原市",
"861301088", "广东省深圳市",
"861503992", "河南省周口市",
"861581167", "广东省珠海市",
"861390327", "河北省沧州市",
"861321919", "四川省达州市",
"861390458", "黑龙江省伊春市",
"861859928", "新疆喀什地区",
"861869424", "河北省石家庄市",
"861308381", "河南省新乡市",
"861857029", "湖南省郴州市",
"861866300", "山东省聊城市",
"861810708", "江西省南昌市",
"86151279", "河北省邢台市",
"861571793", "江西省上饶市",
"861340552", "江苏省泰州市",
"86155739", "湖南省邵阳市",
"861318311", "河南省新乡市",
"861771536", "江苏省苏州市",
"86139369", "黑龙江省大庆市",
"861308111", "河北省石家庄市",
"861509489", "山东省淄博市",
"861870416", "辽宁省锦州市",
"861328196", "四川省宜宾市",
"861557178", "湖北省恩施土家族苗族自治州",
"861334015", "江西省宜春市",
"861822741", "四川省资阳市",
"861311874", "云南省曲靖市",
"86180266", "广东省惠州市",
"861318181", "山东省泰安市",
"861528944", "陕西省宝鸡市",
"861304759", "江苏省宿迁市",
"861558327", "四川省资阳市",
"86132716", "河南省周口市",
"861315685", "山东省青岛市",
"861390366", "黑龙江省哈尔滨市",
"861850915", "陕西省安康市",
"861862751", "湖南省岳阳市",
"861770395", "河南省漯河市",
"861331313", "河北省张家口市",
"861766022", "山东省青岛市",
"861890449", "吉林省白山市",
"861454476", "陕西省汉中市",
"861360877", "云南省玉溪市",
"861858567", "贵州省黔南布依族苗族自治州",
"861819683", "新疆喀什地区",
"861356247", "山东省枣庄市",
"861709352", "河南省南阳市",
"861891203", "江苏省徐州市",
"861580864", "云南省昭通市",
"861342441", "广东省深圳市",
"861571469", "黑龙江省双鸭山市",
"861354146", "四川省甘孜藏族自治州",
"861376571", "贵州省六盘水市",
"861838589", "贵州省铜仁地区",
"861369509", "福建省南平市",
"861837805", "广西玉林市",
"86145920", "四川省成都市",
"861322362", "山西省大同市",
"861302183", "河北省廊坊市",
"861598306", "四川省遂宁市",
"861507792", "安徽省合肥市",
"861774051", "湖北省武汉市",
"861890236", "广东省肇庆市",
"861332088", "四川省绵阳市",
"861308698", "贵州省黔西南布依族苗族自治州",
"861769852", "河南省洛阳市",
"861332939", "黑龙江省大庆市",
"861308335", "安徽省淮北市",
"861582572", "浙江省嘉兴市",
"861705576", "黑龙江省大庆市",
"861351362", "山西省太原市",
"861539378", "河南省许昌市",
"861569961", "黑龙江省哈尔滨市",
"861459518", "云南省德宏傣族景颇族自治州",
"861865121", "江苏省常州市",
"861303389", "河南省鹤壁市",
"861868625", "内蒙古鄂尔多斯市",
"861773953", "河南省驻马店市",
"861310749", "湖南省长沙市",
"861311645", "贵州省黔东南苗族侗族自治州",
"86133276", "青海省西宁市",
"861313319", "山西省运城市",
"86156898", "山东省潍坊市",
"861317823", "福建省莆田市",
"861529426", "甘肃省定西市",
"861837141", "湖北省黄石市",
"861817633", "广西桂林市",
"861325635", "山东省聊城市",
"861853260", "河北省廊坊市",
"861780656", "广东省中山市",
"861328131", "四川省乐山市",
"861595158", "江苏省无锡市",
"861369559", "安徽省黄山市",
"861478415", "河南省信阳市",
"861822414", "四川省巴中市",
"861329549", "山东省临沂市",
"861361465", "黑龙江省大庆市",
"861770638", "山东省淄博市",
"861350468", "黑龙江省鸡西市",
"861360964", "广东省广州市",
"861598356", "四川省攀枝花市",
"861304278", "湖北省襄樊市",
"861573790", "河南省商丘市",
"86145925", "重庆市",
"861504066", "辽宁省鞍山市",
"861769802", "河南省许昌市",
"861379917", "福建省三明市",
"861700727", "山东省淄博市",
"861317549", "浙江省台州市",
"861580977", "青海省海西蒙古族藏族自治州",
"861452390", "西藏拉萨市",
"86131429", "江苏省南通市",
"861572244", "江苏省南通市",
"861318639", "陕西省宝鸡市",
"86145424", "海南省海口市",
"861361849", "湖南省长沙市",
"861312340", "广西防城港市",
"861355983", "福建省南平市",
"861335478", "内蒙古巴彦淖尔市",
"861810613", "江苏省苏州市",
"861818829", "贵州省六盘水市",
"861898692", "湖北省武汉市",
"861504571", "黑龙江省双鸭山市",
"86184895", "西藏拉萨市",
"861520792", "江西省九江市",
"861339533", "山东省淄博市",
"861777191", "湖北省十堰市",
"86150810", "河北省邯郸市",
"861775903", "福建省福州市",
"861580820", "四川省自贡市",
"861327377", "河南省南阳市",
"861515253", "江苏省连云港市",
"861801466", "江苏省盐城市",
"861800683", "浙江省嘉兴市",
"861896957", "浙江省丽水市",
"86137593", "云南省临沧市",
"861301349", "云南省玉溪市",
"86136729", "广东省江门市",
"86139569", "安徽省合肥市",
"861571674", "河南省周口市",
"861337356", "河北省廊坊市",
"861874274", "新疆塔城地区",
"861364549", "山东省临沂市",
"861319377", "河南省开封市",
"86139250", "广东省广州市",
"861576759", "广东省中山市",
"86145706", "江苏省苏州市",
"861362953", "宁夏中卫市",
"861500419", "辽宁省辽阳市",
"861366705", "江西省宜春市",
"861581611", "广东省湛江市",
"86155962", "陕西省延安市",
"861361523", "江苏省南通市",
"861388757", "云南省红河哈尼族彝族自治州",
"861889552", "安徽省阜阳市",
"861839649", "福建省漳州市",
"861854301", "吉林省长春市",
"861510489", "内蒙古呼伦贝尔市",
"861350540", "山东省济南市",
"861458750", "广东省江门市",
"861813672", "江苏省常州市",
"861342817", "广东省茂名市",
"861777618", "广西河池市",
"861593108", "河北省石家庄市",
"861379097", "广东省湛江市",
"861308626", "青海省西宁市",
"861705061", "江苏省常州市",
"861524961", "河南省安阳市",
"861342534", "广东省汕头市",
"861459738", "湖南省长沙市",
"86184890", "海南省海口市",
"861853224", "河北省保定市",
"861520439", "吉林省白山市",
"861846445", "山东省莱芜市",
"861571845", "广东省佛山市",
"861830345", "山西省长治市",
"86150747", "湖南省衡阳市",
"861355330", "广东省佛山市",
"861811108", "四川省眉山市",
"86150815", "河北省唐山市",
"861779041", "四川省广安市",
"861874069", "陕西省铜川市",
"861592242", "安徽省合肥市",
"861348378", "河北省保定市",
"861580767", "广东省揭阳市",
"861808891", "云南省玉溪市",
"861529498", "河南省周口市",
"861347127", "广西桂林市",
"861839911", "新疆喀什地区",
"861877436", "湖南省常德市",
"861337306", "河北省廊坊市",
"861351943", "甘肃省白银市",
"861345902", "福建省厦门市",
"861359156", "辽宁省抚顺市",
"861360774", "广西梧州市",
"861532622", "辽宁省锦州市",
"861330783", "广西桂林市",
"861370987", "辽宁省盘锦市",
"861324509", "江苏省苏州市",
"861569771", "广西南宁市",
"861362903", "四川省宜宾市",
"861576709", "广东省惠州市",
"86139255", "广东省东莞市",
"861450588", "辽宁省铁岭市",
"861889502", "宁夏石嘴山市",
"861812893", "广东省韶关市",
"861382456", "广东省梅州市",
"861856926", "湖南省益阳市",
"861560256", "广东省佛山市",
"861335180", "黑龙江省哈尔滨市",
"861337583", "浙江省嘉兴市",
"861311777", "广西钦州市",
"86187459", "黑龙江省大庆市",
"861889668", "江苏省常州市",
"861823825", "河南省信阳市",
"861890865", "湖北省武汉市",
"861598497", "四川省凉山彝族自治州",
"861323635", "江苏省镇江市",
"861309749", "云南省大理白族自治州",
"86130645", "浙江省温州市",
"861560575", "浙江省绍兴市",
"86170992", "浙江省湖州市",
"86137071", "湖北省武汉市",
"861346047", "河南省新乡市",
"861526307", "山东省泰安市",
"861853735", "河南省南阳市",
"86132486", "浙江省宁波市",
"861335310", "吉林省长春市",
"861588345", "四川省凉山彝族自治州",
"861804222", "浙江省金华市",
"86137334", "湖北省孝感市",
"861826113", "江苏省宿迁市",
"861501622", "广东省河源市",
"86159742", "湖南省长沙市",
"861800402", "辽宁省沈阳市",
"861771716", "河北省邯郸市",
"861856967", "湖南省怀化市",
"861858789", "广西南宁市",
"861365564", "安徽省安庆市",
"861770872", "云南省大理白族自治州",
"861453988", "广东省潮州市",
"861593247", "河北省石家庄市",
"861812003", "江苏省徐州市",
"861808730", "云南省红河哈尼族彝族自治州",
"861814442", "广东省湛江市",
"86187100", "北京市",
"86182028", "四川省成都市",
"861377258", "陕西省咸阳市",
"861533627", "陕西省安康市",
"861378971", "内蒙古通辽市",
"861859931", "新疆塔城地区",
"861857270", "湖北省襄樊市",
"861809758", "新疆石河子市",
"861339562", "安徽省铜陵市",
"86134819", "广西柳州市",
"861810020", "广东省广州市",
"861357846", "云南省怒江傈僳族自治州",
"861552060", "四川省宜宾市",
"861477082", "江西省赣州市",
"861333143", "吉林省辽源市",
"861363520", "福建省宁德市",
"861700976", "浙江省嘉兴市",
"861580726", "湖北省荆门市",
"861561262", "河北省廊坊市",
"86134332", "广东省佛山市",
"86188312", "河北省保定市",
"861311998", "新疆喀什地区",
"861505634", "安徽省宣城市",
"861303048", "内蒙古包头市",
"861864662", "黑龙江省齐齐哈尔市",
"861567775", "广西钦州市",
"861575831", "云南省楚雄彝族自治州",
"86137751", "江苏省常州市",
"86155669", "辽宁省大连市",
"861801308", "江苏省苏州市",
"861500657", "山东省济宁市",
"861586535", "山东省烟台市",
"861566554", "安徽省淮南市",
"86147065", "广东省广州市",
"861867600", "广东省中山市",
"861526544", "山东省潍坊市",
"861321099", "山东省德州市",
"861316741", "湖南省株洲市",
"86186421", "辽宁省朝阳市",
"861882887", "四川省自贡市",
"861370579", "浙江省金华市",
"861308945", "吉林省吉林市",
"861338630", "山东省威海市",
"861840861", "宁夏银川市",
"861313696", "黑龙江省鸡西市",
"86156161", "湖南省长沙市",
"86130640", "山东省济南市",
"861831541", "山东省济南市",
"861800452", "黑龙江省齐齐哈尔市",
"861769912", "新疆伊犁哈萨克自治州",
"861323681", "辽宁省鞍山市",
"861532871", "四川省内江市",
"861850141", "江苏省徐州市",
"861598540", "贵州省黔南布依族苗族自治州",
"861812053", "湖北省十堰市",
"861834841", "河南省郑州市",
"861815838", "浙江省金华市",
"861306484", "江苏省盐城市",
"861594718", "内蒙古包头市",
"861375493", "山西省大同市",
"861479032", "安徽省六安市",
"861573828", "河南省信阳市",
"86157944", "北京市",
"861809708", "青海省海南藏族自治州",
"86147684", "山东省潍坊市",
"861502968", "陕西省延安市",
"861832466", "黑龙江省伊春市",
"861821848", "广东省潮州市",
"861857981", "广西南宁市",
"861596330", "山东省淄博市",
"861863399", "河北省唐山市",
"861309177", "黑龙江省黑河市",
"861530480", "黑龙江省哈尔滨市",
"86156302", "河北省保定市",
"861811247", "江苏省无锡市",
"861808051", "四川省巴中市",
"86156658", "山东省济南市",
"861868129", "四川省绵阳市",
"861508314", "河南省新乡市",
"861855515", "安徽省合肥市",
"861879495", "甘肃省定西市",
"861803899", "广东省茂名市",
"86151830", "四川省泸州市",
"861590610", "江苏省镇江市",
"861568537", "贵州省安顺市",
"861505992", "福建省龙岩市",
"86132317", "河北省沧州市",
"861850855", "贵州省黔东南苗族侗族自治州",
"861700152", "江苏省无锡市",
"86181023", "重庆市",
"861826275", "江苏省连云港市",
"861859996", "四川省雅安市",
"861302140", "河北省保定市",
"86147060", "四川省成都市",
"861387291", "湖北省荆门市",
"861560704", "江西省萍乡市",
"861599933", "新疆哈密地区",
"861301851", "广东省阳江市",
"86432", "吉林省吉林市",
"861507847", "广西柳州市",
"861814350", "贵州省贵阳市",
"861537376", "河北省邯郸市",
"861317414", "江苏省徐州市",
"861872917", "陕西省宝鸡市",
"861890288", "广东省江门市",
"861823001", "河北省石家庄市",
"861328048", "山东省枣庄市",
"861820800", "西藏拉萨市",
"861321341", "河南省鹤壁市",
"861313407", "江西省吉安市",
"861878642", "贵州省黔东南苗族侗族自治州",
"861815261", "湖南省岳阳市",
"861889397", "甘肃省酒泉市",
"861315273", "山西省阳泉市",
"861567347", "湖南省永州市",
"861361351", "山西省太原市",
"86130740", "安徽省安庆市",
"861393480", "山西省大同市",
"861535327", "陕西省安康市",
"861319282", "广东省惠州市",
"861509248", "山东省枣庄市",
"861535458", "吉林省白山市",
"861768245", "浙江省宁波市",
"861394868", "内蒙古赤峰市",
"861898875", "广东省深圳市",
"861318949", "广东省湛江市",
"861521879", "广东省东莞市",
"861304551", "安徽省合肥市",
"861875852", "浙江省绍兴市",
"861354098", "四川省泸州市",
"861824953", "黑龙江省鹤岗市",
"861399047", "四川省甘孜藏族自治州",
"861864943", "广西崇左市",
"86150473", "内蒙古鄂尔多斯市",
"861360393", "河南省新乡市",
"86189588", "浙江省温州市",
"861830998", "新疆喀什地区",
"861315331", "山东省威海市",
"861572746", "湖南省常德市",
"861813895", "广东省江门市",
"861827275", "河南省南阳市",
"861534312", "河北省保定市",
"86183976", "湖南省邵阳市",
"86134562", "浙江省嘉兴市",
"861826640", "山东省菏泽市",
"861454572", "四川省广安市",
"861856981", "河南省信阳市",
"861588777", "云南省楚雄彝族自治州",
"861839939", "新疆阿克苏地区",
"861348832", "陕西省西安市",
"861340368", "山西省忻州市",
"861870512", "江苏省连云港市",
"861301145", "河北省邢台市",
"861322633", "广东省惠州市",
"861855589", "安徽省六安市",
"861532984", "贵州省黔南布依族苗族自治州",
"861471714", "甘肃省天水市",
"861369701", "江西省赣州市",
"86137885", "广西桂林市",
"861576010", "四川省乐山市",
"86156758", "湖南省长沙市",
"861807133", "湖北省恩施土家族苗族自治州",
"861520744", "湖南省张家界市",
"86183136", "云南省曲靖市",
"861310541", "山东省济南市",
"861898644", "湖北省随州市",
"861459529", "云南省文山壮族苗族自治州",
"861351633", "山东省日照市",
"861500431", "吉林省长春市",
"861858715", "云南省楚雄彝族自治州",
"861580735", "湖南省郴州市",
"86152471", "内蒙古呼和浩特市",
"861572292", "江苏省南京市",
"861819113", "陕西省西安市",
"861820850", "贵州省贵阳市",
"861894387", "吉林省吉林市",
"861805172", "江苏省盐城市",
"861368008", "广东省韶关市",
"861523314", "河北省承德市",
"861860840", "湖南省长沙市",
"86130745", "黑龙江省哈尔滨市",
"861313328", "山西省大同市",
"861313457", "黑龙江省大兴安岭地区",
"861510722", "湖北省武汉市",
"861586526", "山东省济南市",
"861854523", "黑龙江省大兴安岭地区",
"861800340", "山西省太原市",
"861770686", "浙江省台州市",
"861454130", "河北省邯郸市",
"861827113", "湖北省咸宁市",
"861535408", "河北省衡水市",
"86136922", "广东省深圳市",
"86159642", "山东省青岛市",
"861318198", "山东省东营市",
"861573909", "新疆博尔塔拉蒙古自治州",
"86155769", "湖南省湘西土家族苗族自治州",
"861508032", "福建省厦门市",
"861363955", "宁夏吴忠市",
"861552879", "四川省成都市",
"861315115", "江苏省苏州市",
"861840887", "云南省迪庆藏族自治州",
"861897299", "湖北省随州市",
"861397197", "湖北省孝感市",
"861323945", "甘肃省武威市",
"861556443", "山东省德州市",
"86181216", "江苏省淮安市",
"861587535", "广东省汕头市",
"861390627", "江苏省南通市",
"861567554", "安徽省淮南市",
"861332091", "四川省乐山市",
"861527544", "山东省东营市",
"86155012", "北京市",
"861317741", "湖北省咸宁市",
"861568210", "四川省成都市",
"86133123", "贵州省遵义市",
"861356846", "四川省巴中市",
"861709483", "浙江省宁波市",
"861476082", "江苏省泰州市",
"861519544", "江苏省镇江市",
"86176127", "湖北省武汉市",
"861855798", "浙江省宁波市",
"861879421", "甘肃省兰州市",
"861309434", "云南省红河哈尼族彝族自治州",
"86159257", "浙江省丽水市",
"86137651", "贵州省贵阳市",
"861362424", "辽宁省大连市",
"861330158", "江苏省南京市",
"861856935", "湖南省娄底市",
"86137809", "山东省烟台市",
"861777125", "湖北省宜昌市",
"861859641", "福建省厦门市",
"861846229", "山东省聊城市",
"861351558", "安徽省阜阳市",
"861572840", "广东省肇庆市",
"861770695", "福建省泉州市",
"861340406", "四川省眉山市",
"861365815", "四川省德阳市",
"861895122", "江苏省常州市",
"861312452", "黑龙江省齐齐哈尔市",
"861780583", "浙江省嘉兴市",
"86139812", "四川省广元市",
"861390666", "浙江省温州市",
"861892702", "广东省河源市",
"861380817", "四川省成都市",
"861819506", "宁夏固原市",
"86158448", "吉林省松原市",
"861558627", "湖北省武汉市",
"861579877", "云南省玉溪市",
"861829980", "新疆巴音郭楞蒙古自治州",
"861875092", "福建省厦门市",
"861360555", "安徽省马鞍山市",
"861305315", "安徽省淮北市",
"861380534", "山东省德州市",
"86150647", "山东省济宁市",
"861524987", "安徽省马鞍山市",
"861594586", "黑龙江省佳木斯市",
"861320545", "山东省烟台市",
"861576623", "广东省梅州市",
"861876249", "江苏省南通市",
"86130223", "重庆市",
"861336583", "湖南省湘西土家族苗族自治州",
"861855977", "福建省厦门市",
"861366574", "浙江省湖州市",
"861810140", "江苏省淮安市",
"861308398", "浙江省杭州市",
"861881978", "广东省韶关市",
"861319745", "湖北省武汉市",
"861479184", "陕西省西安市",
"861807162", "江苏省南通市",
"861586567", "山东省菏泽市",
"86152310", "河北省邯郸市",
"861358143", "湖北省襄樊市",
"861760660", "广东省汕尾市",
"861827383", "湖南省娄底市",
"861588149", "四川省南充市",
"861598606", "广东省佛山市",
"861303128", "新疆喀什地区",
"861820706", "江西省宜春市",
"861591005", "山东省潍坊市",
"861815372", "湖南省益阳市",
"861809313", "甘肃省白银市",
"861367755", "新疆石河子市",
"86138130", "江苏省南京市",
"861877425", "湖南省衡阳市",
"861764054", "辽宁省沈阳市",
"861577709", "广西北海市",
"861776136", "四川省成都市",
"861313941", "甘肃省陇南市",
"861301091", "吉林省长春市",
"86150252", "云南省文山壮族苗族自治州",
"861509107", "陕西省宝鸡市",
"86150195", "广东省中山市",
"861322508", "福建省厦门市",
"861818908", "西藏日喀则地区",
"861599110", "陕西省延安市",
"86135121", "上海市",
"861351508", "福建省南平市",
"861374792", "河南省信阳市",
"86132221", "江苏省南通市",
"861550882", "云南省曲靖市",
"86170799", "浙江省湖州市",
"861852733", "湖北省武汉市",
"86136629", "广东省东莞市",
"861771588", "江苏省苏州市",
"861340456", "吉林省松原市",
"861353630", "广东省惠州市",
"861334921", "安徽省芜湖市",
"861336356", "山西省晋城市",
"861560917", "陕西省宝鸡市",
"861311345", "河北省邢台市",
"861303689", "广西北海市",
"861868325", "四川省成都市",
"861351662", "广东省佛山市",
"861539678", "江苏省扬州市",
"861773460", "陕西省宝鸡市",
"861314043", "河南省焦作市",
"86187278", "湖北省咸宁市",
"861312402", "福建省福州市",
"861301036", "浙江省杭州市",
"861587581", "广东省肇庆市",
"861776191", "江苏省苏州市",
"861308635", "四川省甘孜藏族自治州",
"861338940", "甘肃省兰州市",
"861326377", "广西钦州市",
"861457103", "江苏省扬州市",
"861570559", "安徽省黄山市",
"861875124", "江苏省连云港市",
"861776618", "江苏省无锡市",
"861332145", "吉林省通化市",
"861452690", "陕西省咸阳市",
"861820756", "广东省珠海市",
"861858422", "四川省南充市",
"86156314", "河北省邯郸市",
"86152315", "河北省唐山市",
"861860746", "湖南省永州市",
"861855864", "福建省三明市",
"86147915", "陕西省安康市",
"861820090", "广东省韶关市",
"86138135", "江苏省常州市",
"861367705", "江西省宜春市",
"861770338", "河北省承德市",
"861580781", "广西南宁市",
"861819930", "新疆乌鲁木齐市",
"861471907", "甘肃省张掖市",
"861317263", "广东省肇庆市",
"861510415", "辽宁省丹东市",
"861322558", "安徽省阜阳市",
"86150190", "广东省东莞市",
"861509157", "陕西省宝鸡市",
"861321928", "四川省巴中市",
"861871132", "湖南省湘潭市",
"861362548", "山东省泰安市",
"861780356", "山西省晋城市",
"861804150", "辽宁省丹东市",
"861370961", "广东省江门市",
"861870973", "青海省黄南藏族自治州",
"861830777", "广西钦州市",
"861571374", "河南省许昌市",
"861830874", "云南省曲靖市",
"861453550", "安徽省蚌埠市",
"861303315", "安徽省铜陵市",
"86139539", "山东省临沂市",
"861860883", "云南省临沧市",
"861458207", "安徽省黄山市",
"861835789", "浙江省丽水市",
"861599343", "河南省商丘市",
"861337656", "广东省肇庆市",
"86147414", "辽宁省阜新市",
"86170701", "北京市",
"861760624", "山东省威海市",
"861352996", "云南省红河哈尼族彝族自治州",
"861899869", "广东省梅州市",
"861316823", "广东省汕尾市",
"861300745", "湖南省株洲市",
"861380441", "吉林省吉林市",
"861836141", "江苏省镇江市",
"861313385", "江西省宜春市",
"861327677", "浙江省温州市",
"861894455", "黑龙江省绥化市",
"861550376", "河南省信阳市",
"861321931", "四川省巴中市",
"861561671", "湖南省衡阳市",
"861363815", "贵州省毕节地区",
"861302279", "山东省临沂市",
"86185956", "河南省郑州市",
"861802177", "江苏省淮安市",
"861813743", "河南省驻马店市",
"861810313", "河北省张家口市",
"861318339", "河南省三门峡市",
"861575297", "云南省昆明市",
"861770321", "河北省石家庄市",
"861379206", "山东省东营市",
"861323698", "辽宁省丹东市",
"861315941", "福建省福州市",
"861362460", "黑龙江省哈尔滨市",
"861334938", "黑龙江省伊春市",
"861453936", "广东省佛山市",
"861303196", "河北省张家口市",
"861318167", "山东省潍坊市",
"86152272", "河北省秦皇岛市",
"861387288", "湖北省随州市",
"861316549", "山东省临沂市",
"861556480", "山东省泰安市",
"861308326", "安徽省芜湖市",
"861339466", "黑龙江省大庆市",
"861700264", "广东省深圳市",
"861859099", "陕西省铜川市",
"861529435", "甘肃省天水市",
"861551201", "河北省唐山市",
"86152510", "江苏省盐城市",
"86137447", "吉林省延边朝鲜族自治州",
"861304623", "广东省湛江市",
"86188504", "福建省福州市",
"861589444", "云南省德宏傣族景颇族自治州",
"861857998", "广西玉林市",
"861595783", "浙江省丽水市",
"861839349", "甘肃省陇南市",
"861832658", "安徽省马鞍山市",
"861368826", "四川省广安市",
"861800506", "福建省泉州市",
"861820910", "陕西省咸阳市",
"861335023", "四川省巴中市",
"86155932", "甘肃省定西市",
"861337606", "江苏省南京市",
"861844947", "新疆克拉玛依市",
"861340397", "河南省信阳市",
"861532322", "广东省揭阳市",
"861458257", "安徽省蚌埠市",
"861453500", "山东省青岛市",
"861835598", "安徽省黄山市",
"861336497", "新疆石河子市",
"861303131", "新疆伊犁哈萨克自治州",
"86137891", "湖南省邵阳市",
"861476253", "江苏省淮安市",
"861807090", "广西南宁市",
"861830967", "宁夏银川市",
"861870763", "广东省清远市",
"861787846", "广西南宁市",
"861573819", "河南省平顶山市",
"861370771", "广西南宁市",
"861855820", "浙江省湖州市",
"861823265", "河北省廊坊市",
"861836086", "江苏省南京市",
"861393443", "山西省忻州市",
"86155172", "河南省安阳市",
"861594729", "内蒙古锡林郭勒盟",
"861459795", "新疆巴音郭楞蒙古自治州",
"861302064", "山东省菏泽市",
"861800930", "甘肃省临夏回族自治州",
"861831749", "河南省濮阳市",
"861830645", "山东省烟台市",
"861334089", "四川省绵阳市",
"861519485", "河北省石家庄市",
"861843144", "河北省保定市",
"861815886", "安徽省合肥市",
"861889368", "甘肃省张掖市",
"861383344", "河北省廊坊市",
"861302758", "河南省焦作市",
"861590478", "内蒙古巴彦淖尔市",
"861394897", "内蒙古兴安盟",
"86135342", "广东省深圳市",
"86138474", "内蒙古乌兰察布市",
"861359848", "河南省洛阳市",
"86574", "浙江省宁波市",
"861854651", "黑龙江省哈尔滨市",
"86152515", "江苏省无锡市",
"861857149", "湖北省武汉市",
"861301911", "吉林省长春市",
"861773424", "河北省邯郸市",
"861800556", "安徽省安庆市",
"861311981", "广东省汕尾市",
"861836805", "浙江省舟山市",
"861803956", "河南省洛阳市",
"861533327", "河北省沧州市",
"861821972", "甘肃省定西市",
"861828217", "四川省攀枝花市",
"861808888", "广东省深圳市",
"861529481", "河南省信阳市",
"861881894", "广东省汕头市",
"861364232", "广东省广州市",
"86184070", "江西省南昌市",
"861331064", "山东省日照市",
"861459786", "新疆乌鲁木齐市",
"861315407", "陕西省商洛市",
"861364741", "湖南省长沙市",
"861816508", "陕西省商洛市",
"861519496", "河北省保定市",
"861818818", "贵州省六盘水市",
"861313273", "广西桂林市",
"86137673", "江西省上饶市",
"86152846", "贵州省毕节地区",
"861357158", "陕西省铜川市",
"861890734", "湖南省衡阳市",
"86189955", "湖北省武汉市",
"861869903", "新疆克拉玛依市",
"86137364", "浙江省嘉兴市",
"861376969", "云南省曲靖市",
"861378787", "湖南省常德市",
"861358478", "江苏省盐城市",
"861339308", "河北省衡水市",
"861776703", "浙江省舟山市",
"861368974", "吉林省四平市",
"861368720", "湖北省十堰市",
"861507411", "湖南省长沙市",
"861877170", "湖北省孝感市",
"861889456", "甘肃省甘南藏族自治州",
"86151584", "浙江省温州市",
"861866442", "广东省中山市",
"861804862", "四川省德阳市",
"861458148", "浙江省金华市",
"861856029", "山东省淄博市",
"861332911", "安徽省淮北市",
"861380907", "江苏省常州市",
"861321985", "四川省德阳市",
"86152183", "广东省茂名市",
"861778150", "四川省凉山彝族自治州",
"86155639", "山东省青岛市",
"861777470", "广西桂林市",
"86153604", "广东省广州市",
"861500357", "山西省临汾市",
"86151865", "贵州省黔西南布依族苗族自治州",
"861539832", "云南省玉溪市",
"861500428", "辽宁省锦州市",
"861510248", "辽宁省辽阳市",
"861300282", "四川省南充市",
"86134362", "重庆市",
"86184383", "河南省商丘市",
"861815895", "安徽省合肥市",
"861847584", "广东省清远市",
"861379575", "四川省遂宁市",
"86152453", "黑龙江省牡丹江市",
"861320484", "内蒙古鄂尔多斯市",
"861560857", "贵州省毕节地区",
"861331758", "湖北省荆州市",
"86188869", "贵州省黔西南布依族苗族自治州",
"861313331", "山西省晋中市",
"861777629", "广西桂林市",
"86189388", "广东省深圳市",
"861365905", "四川省南充市",
"861450591", "辽宁省朝阳市",
"861708870", "广东省江门市",
"861850577", "浙江省温州市",
"861899584", "湖北省荆州市",
"861331279", "云南省保山市",
"861572883", "广东省茂名市",
"861368867", "山东省烟台市",
"861882295", "广东省东莞市",
"861870732", "湖南省湘潭市",
"861471817", "广东省梅州市",
"861533408", "湖北省孝感市",
"861592539", "云南省普洱市",
"861311935", "甘肃省武威市",
"861324701", "江西省鹰潭市",
"861585086", "江苏省泰州市",
"861471534", "广东省东莞市",
"861315457", "黑龙江省大兴安岭地区",
"861581181", "广东省深圳市",
"861536676", "江苏省徐州市",
"861339358", "山西省吕梁市",
"861865041", "福建省莆田市",
"861776753", "新疆阿克苏地区",
"861700413", "辽宁省鞍山市",
"861869953", "新疆吐鲁番地区",
"861772905", "陕西省汉中市",
"861500544", "山东省滨州市",
"861308367", "河南省焦作市",
"861339427", "辽宁省盘锦市",
"861821156", "广东省深圳市",
"86189950", "宁夏银川市",
"861323381", "河南省新乡市",
"861454803", "广东省清远市",
"86155283", "四川省成都市",
"861318126", "山东省枣庄市",
"861310434", "吉林省四平市",
"861825051", "福建省莆田市",
"861768370", "湖北省宜昌市",
"861889406", "甘肃省张掖市",
"861391440", "江苏省泰州市",
"861352985", "云南省曲靖市",
"86156131", "河北省石家庄市",
"861313396", "江西省吉安市",
"861780540", "山东省菏泽市",
"861338330", "河北省邯郸市",
"861586598", "山东省东营市",
"861566647", "山东省东营市",
"861808237", "江苏省连云港市",
"861308139", "辽宁省本溪市",
"861380957", "福建省宁德市",
"86184755", "广东省深圳市",
"861761446", "吉林省白城市",
"861585805", "浙江省舟山市",
"861830018", "广东省湛江市",
"861309541", "安徽省阜阳市",
"861500307", "新疆喀什地区",
"861519431", "山东省威海市",
"861590310", "河北省邯郸市",
"861336540", "山东省菏泽市",
"861857777", "广西南宁市",
"861364414", "辽宁省本溪市",
"86158167", "广东省汕头市",
"861569579", "浙江省金华市",
"861576501", "黑龙江省牡丹江市",
"861325667", "山东省济南市",
"861303185", "河北省衡水市",
"86181621", "江西省赣州市",
"861373076", "四川省内江市",
"86188427", "辽宁省盘锦市",
"86180628", "湖北省黄冈市",
"861596630", "山东省济南市",
"861450950", "江苏省连云港市",
"861365955", "西藏昌都地区",
"861575909", "福建省三明市",
"861509722", "甘肃省酒泉市",
"861331708", "江西省赣州市",
"861361437", "吉林省辽源市",
"861315882", "四川省自贡市",
"861373031", "河北省张家口市",
"861369560", "安徽省合肥市",
"861848510", "贵州省贵阳市",
"861504799", "内蒙古呼和浩特市",
"86186831", "四川省宜宾市",
"86188916", "陕西省汉中市",
"861571400", "辽宁省沈阳市",
"861816514", "陕西省渭南市",
"861860687", "浙江省宁波市",
"861573682", "河南省许昌市",
"861528156", "四川省甘孜藏族自治州",
"861845899", "浙江省绍兴市",
"861826238", "江苏省盐城市",
"861877190", "湖北省鄂州市",
"861884574", "黑龙江省大兴安岭地区",
"861700809", "江苏省盐城市",
"861818804", "贵州省黔南布依族苗族自治州",
"86159365", "河南省新乡市",
"861844748", "内蒙古乌兰察布市",
"861454419", "福建省莆田市",
"861332566", "新疆石河子市",
"861568146", "四川省达州市",
"861319873", "四川省达州市",
"861819861", "贵州省贵阳市",
"86183999", "新疆昌吉回族自治州",
"861821992", "甘肃省定西市",
"861339314", "河北省承德市",
"86180650", "福建省福州市",
"861870479", "内蒙古锡林郭勒盟",
"861582544", "浙江省温州市",
"861565348", "山东省菏泽市",
"861313293", "广西桂林市",
"861537457", "湖北省咸宁市",
"861365312", "河北省保定市",
"861519476", "河北省保定市",
"861331441", "贵州省遵义市",
"861830768", "广东省潮州市",
"86158592", "福建省厦门市",
"861524412", "山东省泰安市",
"861301527", "内蒙古鄂尔多斯市",
"861379595", "四川省绵阳市",
"861840640", "山西省朔州市",
"861811684", "新疆石河子市",
"861569788", "江西省抚州市",
"861815875", "浙江省绍兴市",
"861395949", "福建省龙岩市",
"861302957", "内蒙古鄂尔多斯市",
"861364327", "河北省沧州市",
"861867165", "湖北省黄冈市",
"86188867", "贵州省毕节地区",
"861364458", "黑龙江省哈尔滨市",
"861871811", "广东省韶关市",
"861324448", "吉林省松原市",
"861530311", "河北省石家庄市",
"86150024", "辽宁省沈阳市",
"861396541", "安徽省宣城市",
"861872603", "安徽省马鞍山市",
"861336082", "广东省汕头市",
"86181160", "上海市",
"86151420", "辽宁省沈阳市",
"861333522", "山东省淄博市",
"86185246", "辽宁省营口市",
"861531260", "江苏省南通市",
"861536631", "江苏省连云港市",
"861516143", "江苏省扬州市",
"861596722", "浙江省湖州市",
"86155637", "山东省济宁市",
"86189928", "陕西省西安市",
"861304827", "广东省梅州市",
"861571450", "黑龙江省哈尔滨市",
"861768390", "湖北省襄樊市",
"861335481", "内蒙古呼伦贝尔市",
"861507680", "河北省沧州市",
"86189723", "湖北省荆州市",
"86186563", "安徽省宣城市",
"861533414", "湖北省黄冈市",
"861803192", "河北省石家庄市",
"86136582", "重庆市",
"861504588", "黑龙江省大庆市",
"861314542", "山东省青岛市",
"86184728", "湖南省长沙市",
"861313376", "江西省赣州市",
"861818854", "贵州省黔南布依族苗族自治州",
"861787684", "广东省梅州市",
"86159360", "河南省周口市",
"861808322", "贵州省铜仁地区",
"861839462", "甘肃省甘南藏族自治州",
"861700859", "贵州省黔西南布依族苗族自治州",
"861853209", "河北省邯郸市",
"86352", "山西省大同市",
"86180655", "福建省泉州市",
"861850597", "福建省龙岩市",
"861368632", "山东省枣庄市",
"861311842", "四川省资阳市",
"861501888", "广东省惠州市",
"861705519", "安徽省合肥市",
"861760359", "山西省运城市",
"861593684", "河南省安阳市",
"861395611", "安徽省六安市",
"86188429", "辽宁省葫芦岛市",
"861302907", "吉林省白山市",
"861774984", "河北省唐山市",
"861508562", "贵州省遵义市",
"861569599", "福建省南平市",
"86158169", "广东省佛山市",
"861816288", "湖北省黄冈市",
"861576724", "广东省清远市",
"861806218", "湖北省十堰市",
"861830004", "广东省深圳市",
"86134176", "广东省揭阳市",
"861354904", "西藏林芝地区",
"861334737", "湖南省益阳市",
"861374933", "河南省濮阳市",
"861364408", "辽宁省大连市",
"861825622", "安徽省六安市",
"86132862", "广东省惠州市",
"86182883", "云南省临沧市",
"86151425", "辽宁省沈阳市",
"861560538", "山东省泰安市",
"861341939", "四川省遂宁市",
"861554835", "内蒙古呼和浩特市",
"861508608", "贵州省遵义市",
"86139736", "湖南省常德市",
"861560482", "黑龙江省齐齐哈尔市",
"861857797", "广西南宁市",
"86183008", "贵州省贵阳市",
"86135498", "广东省中山市",
"861802197", "江苏省常州市",
"861772182", "四川省南充市",
"861561691", "湖南省郴州市",
"861384650", "黑龙江省黑河市",
"861550396", "河南省驻马店市",
"86183692", "山东省枣庄市",
"861538749", "湖南省长沙市",
"861327697", "福建省漳州市",
"861323678", "辽宁省盘锦市",
"861536685", "江苏省扬州市",
"861532888", "四川省南充市",
"861537619", "山东省济南市",
"86155366", "山西省太原市",
"861346545", "山东省烟台市",
"861597489", "云南省昭通市",
"861355722", "广西柳州市",
"861319697", "江苏省淮安市",
"86139537", "山东省济宁市",
"861596415", "山东省德州市",
"861526803", "浙江省舟山市",
"861571394", "河南省周口市",
"861882930", "陕西省西安市",
"861454657", "云南省怒江傈僳族自治州",
"861337134", "山东省滨州市",
"861709989", "广东省珠海市",
"861380064", "北京市",
"861352976", "云南省玉溪市",
"861348335", "河北省秦皇岛市",
"861354717", "四川省广元市",
"861531515", "山东省烟台市",
"861846706", "青海省海西蒙古族藏族自治州",
"861378039", "河北省邢台市",
"86137449", "吉林省长春市",
"861370736", "湖南省常德市",
"861859079", "陕西省铜川市",
"861303902", "吉林省四平市",
"861782079", "广东省深圳市",
"861453280", "山西省忻州市",
"861394964", "河南省新乡市",
"86177173", "上海市",
"861872482", "云南省怒江傈僳族自治州",
"861303176", "山东省莱芜市",
"86131270", "山东省青岛市",
"861560653", "浙江省杭州市",
"861331907", "新疆巴音郭楞蒙古自治州",
"861351734", "湖南省衡阳市",
"86135730", "山东省菏泽市",
"861771969", "陕西省安康市",
"861321152", "广西柳州市",
"86133915", "北京市",
"861898743", "云南省曲靖市",
"86189245", "广东省佛山市",
"861520643", "山东省日照市",
"86158808", "福建省泉州市",
"861533263", "陕西省榆林市",
"86177738", "湖南省娄底市",
"861770747", "湖南省益阳市",
"861865213", "江苏省连云港市",
"861534815", "四川省宜宾市",
"861366446", "吉林省白城市",
"86177933", "甘肃省平凉市",
"861304866", "江苏省连云港市",
"861506343", "山东省潍坊市",
"861370791", "江西省南昌市",
"861865175", "江苏省盐城市",
"861302441", "江苏省常州市",
"861824459", "河北省邢台市",
"861459775", "新疆昌吉回族自治州",
"861556198", "黑龙江省七台河市",
"861476306", "山东省滨州市",
"861573453", "黑龙江省牡丹江市",
"861572687", "浙江省温州市",
"861336477", "新疆乌鲁木齐市",
"861550273", "湖北省孝感市",
"861562479", "内蒙古锡林郭勒盟",
"861829865", "甘肃省甘南藏族自治州",
"861340377", "河南省南阳市",
"861364366", "山西省太原市",
"861342183", "广东省深圳市",
"861807070", "广西南宁市",
"861379303", "山东省菏泽市",
"861378988", "山东省青岛市",
"861839433", "甘肃省兰州市",
"861454607", "青海省海西蒙古族藏族自治州",
"861473023", "河北省沧州市",
"861568035", "四川省攀枝花市",
"861303952", "内蒙古呼和浩特市",
"861780477", "内蒙古鄂尔多斯市",
"861321976", "四川省眉山市",
"861518846", "河南省南阳市",
"861476583", "甘肃省兰州市",
"861858201", "四川省遂宁市",
"861308223", "辽宁省盘锦市",
"861866137", "山东省东营市",
"861517023", "江西省南昌市",
"861377900", "新疆吐鲁番地区",
"861458587", "山东省潍坊市",
"861335435", "吉林省通化市",
"86186818", "陕西省西安市",
"861379586", "四川省雅安市",
"86133910", "上海市",
"86189240", "广东省广州市",
"861332527", "山东省泰安市",
"86135735", "山东省烟台市",
"861814669", "江西省赣州市",
"861321102", "广东省汕尾市",
"861560603", "福建省泉州市",
"861537941", "甘肃省甘南藏族自治州",
"86131275", "上海市",
"861318443", "浙江省嘉兴市",
"861325863", "黑龙江省大庆市",
"861565921", "福建省泉州市",
"861394877", "内蒙古鄂尔多斯市",
"861374962", "河南省驻马店市",
"861786922", "云南省德宏傣族景颇族自治州",
"861850440", "吉林省长春市",
"861590498", "辽宁省阜新市",
"861375806", "浙江省嘉兴市",
"861507643", "河北省张家口市",
"861550457", "黑龙江省哈尔滨市",
"861458493", "山东省淄博市",
"86150649", "山东省临沂市",
"861867669", "广东省深圳市",
"861565938", "福建省福州市",
"861398941", "浙江省金华市",
"861871901", "广东省中山市",
"861771779", "河北省沧州市",
"861770675", "浙江省绍兴市",
"861504525", "黑龙江省七台河市",
"861871590", "河北省承德市",
"861886741", "湖南省长沙市",
"861864865", "内蒙古乌兰察布市",
"861850568", "安徽省亳州市",
"861535263", "新疆和田地区",
"861368878", "云南省丽江市",
"861329366", "山西省吕梁市",
"861815392", "甘肃省定西市",
"861301071", "湖北省武汉市",
"86131312", "河北省保定市",
"861881998", "广东省惠州市",
"861308378", "河南省开封市",
"861322837", "四川省泸州市",
"861804365", "吉林省白城市",
"861561049", "山东省青岛市",
"861566786", "陕西省安康市",
"861300697", "广西钦州市",
"861780253", "江苏省泰州市",
"861539335", "甘肃省酒泉市",
"861379729", "湖北省荆州市",
"861700919", "山东省济南市",
"861869459", "浙江省杭州市",
"861380020", "广东省广州市",
"861857054", "湖南省娄底市",
"861816225", "江西省九江市",
"861305902", "黑龙江省哈尔滨市",
"86135665", "浙江省宁波市",
"861322514", "江苏省扬州市",
"861700641", "浙江省杭州市",
"861351514", "江苏省盐城市",
"86133414", "吉林省长春市",
"861539698", "江苏省连云港市",
"861556126", "内蒙古包头市",
"861362317", "河北省沧州市",
"861390549", "山东省临沂市",
"861513656", "河南省驻马店市",
"861321766", "广东省云浮市",
"861326397", "江西省赣州市",
"861550407", "辽宁省营口市",
"861351837", "四川省泸州市",
"861336203", "浙江省衢州市",
"861530639", "山东省青岛市",
"86170797", "浙江省衢州市",
"86134016", "江苏省常州市",
"86158772", "广西柳州市",
"861575453", "黑龙江省牡丹江市",
"86177151", "江苏省苏州市",
"861893958", "河南省漯河市",
"861871951", "甘肃省甘南藏族自治州",
"861302534", "广东省汕头市",
"86136627", "广东省东莞市",
"86159947", "广东省深圳市",
"861853017", "河南省焦作市",
"861390823", "四川省成都市",
"861776604", "江苏省泰州市",
"861563921", "河南省鹤壁市",
"861452429", "辽宁省葫芦岛市",
"861890633", "山东省日照市",
"861823871", "河南省商丘市",
"861771258", "江苏省泰州市",
"861323863", "云南省临沧市",
"861324215", "广东省江门市",
"861820070", "广东省深圳市",
"861870993", "新疆石河子市",
"861830797", "江西省赣州市",
"861778637", "湖北省武汉市",
"861479466", "黑龙江省鸡西市",
"861576866", "广东省汕尾市",
"861459647", "甘肃省白银市",
"861565089", "安徽省宿州市",
"861381247", "江苏省泰州市",
"861874785", "内蒙古通辽市",
"86886", "云南省怒江傈僳族自治州",
"861590426", "辽宁省大连市",
"861341349", "广东省清远市",
"861506110", "江苏省常州市",
"86135660", "浙江省宁波市",
"861869409", "湖北省宜昌市",
"861780203", "广东省梅州市",
"861453761", "广西南宁市",
"861338489", "内蒙古呼和浩特市",
"861569725", "湖北省荆门市",
"861708728", "江西省宜春市",
"861363312", "河北省保定市",
"861889377", "甘肃省酒泉市",
"861378925", "湖南省娄底市",
"861331817", "广东省揭阳市",
"861315293", "山西省朔州市",
"861857894", "广西河池市",
"86158392", "河南省鹤壁市",
"861771147", "四川省宜宾市",
"86182670", "浙江省金华市",
"861358426", "江苏省苏州市",
"861317408", "江苏省南京市",
"861539381", "云南省西双版纳傣族自治州",
"861521899", "广东省汕头市",
"861523427", "山西省长治市",
"861556339", "山东省临沂市",
"861590467", "黑龙江省鸡西市",
"861331534", "河北省张家口市",
"861360742", "湖南省株洲市",
"861534905", "甘肃省武威市",
"86177013", "北京市",
"86152724", "湖北省荆州市",
"861334834", "福建省龙岩市",
"86178630", "山东省威海市",
"861855259", "江苏省扬州市",
"861355157", "四川省雅安市",
"861576827", "广东省深圳市",
"861510630", "山东省菏泽市",
"861303812", "四川省乐山市",
"86159565", "安徽省合肥市",
"86189021", "天津市",
"861591644", "广东省阳江市",
"861560521", "江苏省徐州市",
"861313882", "广东省东莞市",
"861334517", "山东省济宁市",
"861380613", "江苏省苏州市",
"861890558", "安徽省阜阳市",
"861367542", "山东省青岛市",
"861800861", "湖北省黄冈市",
"861327552", "安徽省蚌埠市",
"861870664", "山东省滨州市",
"86159884", "浙江省杭州市",
"861840452", "黑龙江省齐齐哈尔市",
"861476540", "山东省济南市",
"861833037", "河北省秦皇岛市",
"861373916", "江苏省苏州市",
"861376799", "江西省南昌市",
"861830978", "青海省西宁市",
"861850483", "内蒙古阿拉善盟",
"861319552", "安徽省蚌埠市",
"861500476", "内蒙古赤峰市",
"861360373", "河南省新乡市",
"86183852", "贵州省遵义市",
"861860361", "黑龙江省哈尔滨市",
"861321727", "湖北省宜昌市",
"861871447", "黑龙江省双鸭山市",
"861535232", "甘肃省定西市",
"861304281", "湖北省襄樊市",
"861471708", "甘肃省武威市",
"861569234", "山东省青岛市",
"861558549", "吉林省白山市",
"861318480", "广东省揭阳市",
"861874050", "陕西省西安市",
"861372120", "安徽省芜湖市",
"86182675", "浙江省绍兴市",
"861537273", "浙江省衢州市",
"86130819", "浙江省宁波市",
"861304724", "湖南省衡阳市",
"86145893", "广东省珠海市",
"8615736", "重庆市",
"861568929", "山东省淄博市",
"86186674", "浙江省宁波市",
"861318178", "山东省泰安市",
"861534955", "宁夏中卫市",
"861788522", "贵州省安顺市",
"861576760", "广东省汕尾市",
"861897708", "广西南宁市",
"86130332", "江西省赣州市",
"861571642", "河南省开封市",
"861523308", "河北省衡水市",
"861317327", "山东省淄博市",
"861822666", "安徽省滁州市",
"861370153", "江苏省无锡市",
"861317458", "福建省龙岩市",
"861320702", "江西省九江市",
"861532825", "四川省巴中市",
"861572272", "江苏省苏州市",
"861569412", "辽宁省鞍山市",
"861559196", "陕西省商洛市",
"861524788", "内蒙古锡林郭勒盟",
"86178635", "山东省聊城市",
"861594575", "黑龙江省牡丹江市",
"861475610", "河北省石家庄市",
"861345119", "湖北省荆门市",
"861458769", "广东省东莞市",
"861329458", "山西省吕梁市",
"86136382", "重庆市",
"861369448", "吉林省松原市",
"861856290", "山东省青岛市",
"861805192", "江苏省徐州市",
"86183901", "湖南省岳阳市",
"861359944", "福建省福州市",
"861535414", "河北省承德市",
"86186363", "山西省运城市",
"861360296", "广东省云浮市",
"861813644", "江苏省苏州市",
"861472911", "陕西省延安市",
"86134645", "辽宁省丹东市",
"861865420", "安徽省蚌埠市",
"861327502", "福建省厦门市",
"861707349", "河北省唐山市",
"861319668", "江苏省扬州市",
"861306047", "陕西省宝鸡市",
"861550941", "甘肃省甘南藏族自治州",
"861890508", "福建省泉州市",
"86159259", "浙江省金华市",
"861566795", "陕西省铜川市",
"861321860", "江苏省盐城市",
"861376588", "贵州省毕节地区",
"861837440", "湖南省张家界市",
"861395126", "江苏省淮安市",
"861818707", "云南省临沧市",
"861397177", "湖北省黄石市",
"861897279", "湖北省黄石市",
"861552899", "四川省宜宾市",
"861890662", "浙江省宁波市",
"861398457", "贵州省毕节地区",
"861802168", "江苏省南通市",
"861319502", "宁夏石嘴山市",
"861823622", "河南省漯河市",
"861528762", "云南省临沧市",
"861898780", "云南省楚雄彝族自治州",
"861816734", "浙江省绍兴市",
"861520680", "山东省临沂市",
"861393198", "河北省石家庄市",
"861332071", "四川省攀枝花市",
"861589205", "福建省莆田市",
"861760723", "湖北省黄石市",
"861839527", "宁夏银川市",
"86177226", "广东省深圳市",
"861365612", "江苏省常州市",
"86156620", "山东省泰安市",
"861537628", "山东省滨州市",
"861534520", "江苏省淮安市",
"861395135", "江苏省徐州市",
"861708539", "山东省临沂市",
"861810534", "山东省德州市",
"861770892", "西藏日喀则地区",
"86181975", "新疆阿克苏地区",
"861800887", "云南省迪庆藏族自治州",
"861760609", "福建省三明市",
"861898821", "云南省德宏傣族景颇族自治州",
"861338722", "湖北省襄樊市",
"861389506", "宁夏石嘴山市",
"861524153", "辽宁省锦州市",
"861376810", "广西防城港市",
"861597248", "湖北省咸宁市",
"861585597", "安徽省芜湖市",
"861378991", "湖北省武汉市",
"861373257", "浙江省嘉兴市",
"861339614", "湖北省宜昌市",
"86182775", "广西玉林市",
"861350477", "吉林省吉林市",
"861370788", "广西南宁市",
"861399484", "山西省吕梁市",
"861536273", "广东省中山市",
"861538541", "安徽省安庆市",
"861860387", "河南省周口市",
"861573382", "河北省保定市",
"861304267", "辽宁省锦州市",
"861560595", "福建省泉州市",
"861894840", "广东省江门市",
"86159335", "河北省保定市",
"861323410", "辽宁省铁岭市",
"861334230", "辽宁省营口市",
"861452782", "新疆伊犁哈萨克自治州",
"861539139", "云南省普洱市",
"861580968", "宁夏银川市",
"861531820", "山东省滨州市",
"86186861", "内蒙古包头市",
"861870320", "河北省邯郸市",
"861594754", "内蒙古巴彦淖尔市",
"861536331", "广东省肇庆市",
"861388908", "西藏拉萨市",
"86155667", "辽宁省葫芦岛市",
"861321079", "山东省济宁市",
"861508427", "辽宁省本溪市",
"861332433", "吉林省延边朝鲜族自治州",
"86181130", "四川省成都市",
"86182581", "浙江省杭州市",
"861590481", "内蒙古呼和浩特市",
"861508358", "江西省赣州市",
"861521710", "广东省东莞市",
"861861537", "山东省济宁市",
"861827221", "湖北省荆州市",
"861864837", "内蒙古鄂尔多斯市",
"861364627", "江苏省南通市",
"861569830", "山西省太原市",
"86131304", "辽宁省大连市",
"861530611", "江苏省常州市",
"861307047", "新疆伊犁哈萨克自治州",
"861328812", "广东省韶关市",
"861522789", "河北省承德市",
"861570560", "安徽省合肥市",
"861344990", "陕西省榆林市",
"861889745", "湖南省怀化市",
"861311978", "青海省西宁市",
"861809441", "江苏省常州市",
"861532836", "四川省自贡市",
"861380140", "江苏省淮安市",
"86152624", "江苏省苏州市",
"861760659", "浙江省宁波市",
"86133402", "重庆市",
"861781734", "广东省湛江市",
"861571963", "甘肃省平凉市",
"861360868", "河南省郑州市",
"861536396", "广东省珠海市",
"86181970", "青海省西宁市",
"861858578", "贵州省六盘水市",
"86185092", "陕西省西安市",
"86156625", "山东省潍坊市",
"86159478", "吉林省长春市",
"86180583", "浙江省温州市",
"861567880", "广西崇左市",
"861550685", "广西百色市",
"861551789", "河南省鹤壁市",
"86130562", "江苏省徐州市",
"86915", "陕西省安康市",
"861884043", "陕西省渭南市",
"861375473", "山东省临沂市",
"861530949", "甘肃省武威市",
"861501730", "广东省中山市",
"861313676", "黑龙江省哈尔滨市",
"861881345", "广东省茂名市",
"861897183", "湖北省荆门市",
"861561688", "湖南省长沙市",
"861308832", "四川省自贡市",
"861808622", "湖北省宜昌市",
"86182770", "广西防城港市",
"861470740", "湖南省长沙市",
"861582073", "广东省惠州市",
"861594704", "内蒙古乌兰察布市",
"86713", "湖北省黄冈市",
"861351865", "山东省济宁市",
"86186533", "山东省淄博市",
"861847133", "湖北省黄冈市",
"861809714", "青海省海南藏族自治州",
"861525562", "安徽省合肥市",
"861700931", "甘肃省兰州市",
"861812697", "广东省梅州市",
"86132319", "河北省邢台市",
"861398696", "湖北省荆门市",
"861321264", "湖南省张家界市",
"861347484", "内蒙古赤峰市",
"861879475", "甘肃省兰州市",
"861887263", "湖北省武汉市",
"861820584", "浙江省宁波市",
"86132832", "河北省沧州市",
"861387271", "湖北省恩施土家族苗族自治州",
"861389930", "新疆吐鲁番地区",
"861769305", "甘肃省武威市",
"861826295", "江苏省常州市",
"861772612", "湖南省湘潭市",
"86136526", "广东省东莞市",
"861509983", "广东省揭阳市",
"86181135", "四川省泸州市",
"861378936", "湖南省衡阳市",
"861513540", "山西省晋中市",
"861353489", "广东省茂名市",
"861366542", "山东省青岛市",
"861863379", "河北省廊坊市",
"86137006", "云南省昆明市",
"861505106", "江苏省盐城市",
"86134740", "陕西省西安市",
"861778947", "甘肃省酒泉市",
"861773409", "河北省邢台市",
"861568808", "贵州省六盘水市",
"86158139", "广东省肇庆市",
"861890943", "甘肃省白银市",
"861775161", "江苏省泰州市",
"861566518", "江苏省扬州市",
"861454428", "江苏省泰州市",
"86182390", "河南省焦作市",
"86158672", "浙江省宁波市",
"861454357", "山东省日照市",
"861379653", "黑龙江省黑河市",
"861893543", "山西省吕梁市",
"861591934", "广东省广州市",
"861555177", "安徽省马鞍山市",
"861874294", "新疆乌鲁木齐市",
"861510940", "甘肃省甘南藏族自治州",
"861571694", "河北省承德市",
"861521816", "广东省阳江市",
"86139567", "安徽省阜阳市",
"86136727", "广东省珠海市",
"861372202", "内蒙古呼伦贝尔市",
"861581178", "广东省云浮市",
"861536385", "广东省惠州市",
"861520772", "广西柳州市",
"861569736", "湖南省常德市",
"861898672", "湖北省荆州市",
"861323378", "河南省信阳市",
"861809907", "新疆阿克苏地区",
"861533823", "广东省汕头市",
"86155336", "河北省石家庄市",
"86180115", "四川省成都市",
"861594917", "江苏省淮安市",
"861537319", "河北省邢台市",
"861590435", "吉林省通化市",
"861321413", "辽宁省抚顺市",
"861550696", "福建省漳州市",
"861805144", "江苏省扬州市",
"861392254", "广东省东莞市",
"861359992", "福建省厦门市",
"861327397", "河南省信阳市",
"86147276", "贵州省毕节地区",
"861337203", "江苏省南京市",
"861777171", "湖北省宜昌市",
"861379077", "广东省惠州市",
"86177768", "海南省海口市",
"861813692", "江苏省泰州市",
"861452245", "浙江省宁波市",
"861519572", "江苏省连云港市",
"861338415", "辽宁省丹东市",
"86135760", "江西省南昌市",
"861373999", "内蒙古通辽市",
"861560353", "山西省阳泉市",
"861520343", "山西省太原市",
"861340003", "江苏省无锡市",
"861554058", "内蒙古呼伦贝尔市",
"861310168", "黑龙江省鹤岗市",
"861377463", "福建省南平市",
"861777604", "广西南宁市",
"861533549", "山东省临沂市",
"861383895", "河南省南阳市",
"861398685", "湖北省恩施土家族苗族自治州",
"861894746", "内蒙古赤峰市",
"861348635", "浙江省杭州市",
"86185608", "山东省淄博市",
"861500853", "贵州省安顺市",
"861479713", "山西省忻州市",
"861345131", "内蒙古呼和浩特市",
"86185352", "山西省晋中市",
"861826286", "江苏省盐城市",
"861899162", "陕西省汉中市",
"861332462", "陕西省榆林市",
"861859824", "广东省深圳市",
"86134223", "广东省广州市",
"861866669", "广东省清远市",
"861782824", "四川省成都市",
"86186394", "河南省周口市",
"861808871", "黑龙江省大庆市",
"861529478", "河南省周口市",
"861308863", "浙江省台州市",
"861857842", "广东省佛山市",
"861454307", "黑龙江省哈尔滨市",
"861560586", "浙江省台州市",
"86182395", "河南省漯河市",
"861847162", "湖北省宜昌市",
"861372252", "河北省唐山市",
"861360794", "江西省抚州市",
"861527130", "湖北省咸宁市",
"861573960", "新疆昌吉回族自治州",
"86139228", "广东省深圳市",
"861811114", "四川省宜宾市",
"861340677", "山东省德州市",
"861816236", "湖北省襄樊市",
"861334975", "湖北省荆州市",
"861760417", "辽宁省营口市",
"861809957", "新疆喀什地区",
"861572387", "广西玉林市",
"861571932", "甘肃省兰州市",
"861868371", "四川省成都市",
"861517478", "内蒙古兴安盟",
"861705528", "四川省成都市",
"861539326", "甘肃省酒泉市",
"861570173", "甘肃省陇南市",
"861894292", "湖北省武汉市",
"861513497", "内蒙古巴彦淖尔市",
"86145864", "湖北省武汉市",
"861345196", "江苏省镇江市",
"861392204", "广东省茂名市",
"86150749", "湖南省长沙市",
"861880541", "山东省济南市",
"861856768", "河南省安阳市",
"861583568", "山西省晋城市",
"86187457", "黑龙江省哈尔滨市",
"861311797", "江西省赣州市",
"861316366", "黑龙江省哈尔滨市",
"861806229", "湖北省黄石市",
"861373148", "河北省保定市",
"861554008", "内蒙古呼伦贝尔市",
"861597157", "湖北省咸宁市",
"861560303", "广东省东莞市",
"861598477", "四川省达州市",
"861563995", "河南省平顶山市",
"86135765", "江西省宜春市",
"861814369", "吉林省白山市",
"861300406", "安徽省芜湖市",
"861501836", "广东省汕头市",
"861569791", "江西省南昌市",
"861314446", "广东省潮州市",
"861777654", "广西南宁市",
"861816449", "安徽省六安市",
"861575770", "浙江省杭州市",
"861550631", "山东省威海市",
"861888611", "贵州省贵阳市",
"861887232", "湖北省武汉市",
"861454544", "新疆喀什地区",
"861839566", "河北省保定市",
"861813934", "新疆哈密地区",
"861504716", "内蒙古通辽市",
"861803144", "河北省石家庄市",
"861319456", "黑龙江省黑河市",
"861500572", "浙江省湖州市",
"861567843", "广西崇左市",
"861592966", "陕西省渭南市",
"861589087", "河南省南阳市",
"861386662", "安徽省安庆市",
"861309168", "黑龙江省大庆市",
"861812502", "广东省茂名市",
"861328902", "新疆哈密地区",
"861770375", "河南省平顶山市",
"861325378", "河南省周口市",
"861459554", "青海省海南藏族自治州",
"861568026", "四川省乐山市",
"86818", "四川省达州市",
"861560729", "湖北省孝感市",
"86155536", "山东省潍坊市",
"861328176", "四川省广安市",
"861367446", "吉林省白城市",
"86570", "浙江省衢州市",
"861450969", "新疆乌鲁木齐市",
"86139367", "黑龙江省大庆市",
"861341911", "四川省南充市",
"861816865", "江苏省扬州市",
"861327456", "黑龙江省绥化市",
"86182590", "福建省福州市",
"861470783", "广西桂林市",
"861840556", "安徽省安庆市",
"861335426", "辽宁省大连市",
"861477306", "湖南省常德市",
"861509940", "新疆伊犁哈萨克自治州",
"861539635", "福建省漳州市",
"86135635", "山东省聊城市",
"861536941", "河北省石家庄市",
"861822458", "河南省新乡市",
"861308678", "广西河池市",
"861317666", "山东省济南市",
"861393181", "河北省衡水市",
"861595114", "江苏省泰州市",
"861862448", "辽宁省朝阳市",
"861804665", "江西省宜春市",
"86145380", "四川省南充市",
"861890980", "辽宁省鞍山市",
"86147297", "陕西省宝鸡市",
"861554974", "湖北省随州市",
"861360897", "山东省青岛市",
"861768923", "福建省莆田市",
"861399545", "宁夏吴忠市",
"861358522", "江苏省南通市",
"861376900", "云南省丽江市",
"861840930", "甘肃省临夏回族自治州",
"861859727", "青海省海西蒙古族藏族自治州",
"861520962", "宁夏石嘴山市",
"861502977", "陕西省汉中市",
"861705531", "山东省济南市",
"861576226", "山东省青岛市",
"861347545", "山东省烟台市",
"861883396", "河北省廊坊市",
"861328952", "宁夏石嘴山市",
"861778169", "四川省成都市",
"861899756", "新疆昌吉回族自治州",
"861319406", "福建省泉州市",
"861811922", "新疆伊犁哈萨克自治州",
"861368942", "甘肃省天水市",
"861343196", "广东省清远市",
"861871839", "广东省广州市",
"861530339", "河北省邢台市",
"861390263", "广东省河源市",
"861888126", "四川省广元市",
"861370725", "湖北省黄冈市",
"861880434", "吉林省四平市",
"861860455", "黑龙江省绥化市",
"861890271", "广东省汕头市",
"861458561", "山东省枣庄市",
"861386558", "安徽省阜阳市",
"861821944", "广东省深圳市",
"861523533", "山西省阳泉市",
"861345128", "湖北省随州市",
"86183792", "江西省九江市",
"861326697", "广东省东莞市",
"861559048", "吉林省松原市",
"861537685", "山东省聊城市",
"861700341", "湖北省武汉市",
"861894883", "广东省韶关市",
"86145958", "陕西省西安市",
"861362617", "江苏省徐州市",
"86182595", "福建省泉州市",
"861557949", "江西省赣州市",
"861539398", "云南省德宏傣族景颇族自治州",
"86152049", "内蒙古呼伦贝尔市",
"861304298", "甘肃省天水市",
"861782860", "四川省甘孜藏族自治州",
"861569516", "江苏省徐州市",
"861815934", "福建省漳州市",
"861373019", "河北省保定市",
"861454431", "江苏省苏州市",
"86131427", "浙江省温州市",
"861850352", "山西省晋中市",
"861891306", "江苏省苏州市",
"861532510", "浙江省舟山市",
"861580997", "新疆阿克苏地区",
"861340745", "湖南省怀化市",
"861896613", "浙江省台州市",
"861856978", "湖南省怀化市",
"861356384", "山东省泰安市",
"861459347", "四川省凉山彝族自治州",
"861840383", "黑龙江省大庆市",
"861565995", "福建省龙岩市",
"861890333", "河北省秦皇岛市",
"861838778", "云南省玉溪市",
"861760155", "江苏省南京市",
"861585568", "安徽省淮南市",
"861776304", "湖北省黄冈市",
"861334765", "广西玉林市",
"861575112", "江苏省盐城市",
"861810957", "宁夏银川市",
"86183372", "河南省安阳市",
"86153866", "四川省绵阳市",
"86180755", "湖南省郴州市",
"861707911", "浙江省宁波市",
"861380313", "河北省张家口市",
"861813557", "山西省长治市",
"861818200", "湖南省岳阳市",
"861550319", "河北省邢台市",
"861538434", "广东省珠海市",
"861322291", "江苏省无锡市",
"861537696", "山东省烟台市",
"861846204", "山东省青岛市",
"861771571", "四川省泸州市",
"861599411", "河南省安阳市",
"861360057", "浙江省台州市",
"861580209", "广东省汕头市",
"86159535", "山东省烟台市",
"861370234", "广东省佛山市",
"861362409", "辽宁省大连市",
"861510330", "河北省邯郸市",
"861810441", "吉林省长春市",
"861556639", "辽宁省铁岭市",
"861886823", "浙江省湖州市",
"861539681", "江苏省徐州市",
"861386633", "安徽省淮南市",
"861343185", "广东省惠州市",
"861875159", "江苏省徐州市",
"861570524", "江苏省宿迁市",
"861311768", "广西河池市",
"861516610", "山东省德州市",
"861339032", "辽宁省鞍山市",
"861584670", "黑龙江省鸡西市",
"861363612", "湖北省黄冈市",
"86133684", "重庆市",
"861554826", "内蒙古乌海市",
"86132103", "山东省东营市",
"861534564", "安徽省六安市",
"861504810", "内蒙古呼伦贝尔市",
"861809817", "广东省佛山市",
"861565986", "福建省泉州市",
"861502589", "甘肃省张掖市",
"861311054", "福建省福州市",
"86139636", "山东省潍坊市",
"861520933", "甘肃省平凉市",
"861360673", "浙江省嘉兴市",
"861860661", "浙江省宁波市",
"86178084", "贵州省铜仁地区",
"861330684", "浙江省宁波市",
"86153917", "安徽省阜阳市",
"86187641", "山东省济南市",
"861819887", "广东省广州市",
"861513468", "黑龙江省黑河市",
"86139444", "吉林省四平市",
"86182381", "河南省南阳市",
"861348367", "河北省石家庄市",
"86170857", "江苏省连云港市",
"861580778", "广西河池市",
"861700928", "山东省青岛市",
"861390414", "辽宁省本溪市",
"861886549", "山东省临沂市",
"86133060", "福建省厦门市",
"861579742", "湖北省荆州市",
"861521906", "广东省肇庆市",
"861586065", "福建省宁德市",
"861475310", "山东省济南市",
"861524830", "内蒙古阿拉善盟",
"861813507", "山西省太原市",
"86186333", "河北省唐山市",
"861523562", "山西省晋城市",
"86180750", "安徽省六安市",
"861590522", "江苏省徐州市",
"861362459", "黑龙江省大庆市",
"861479608", "广西玉林市",
"861350253", "广东省梅州市",
"861536457", "山西省临汾市",
"861893580", "新疆塔城地区",
"86159530", "山东省菏泽市",
"861500913", "陕西省渭南市",
"861572405", "广东省广州市",
"86178665", "辽宁省大连市",
"861829514", "宁夏固原市",
"861322449", "吉林省白山市",
"861847800", "湖南省衡阳市",
"86180383", "广东省东莞市",
"861390741", "湖南省株洲市",
"861830842", "四川省德阳市",
"861807584", "湖南省湘西土家族苗族自治州",
"861373473", "内蒙古乌海市",
"861873461", "山西省晋城市",
"861317627", "山东省德州市",
"861310197", "江苏省无锡市",
"861827238", "湖北省仙桃市",
"861454485", "湖北省宜昌市",
"861521530", "山东省菏泽市",
"861390232", "广东省广州市",
"861843956", "河南省驻马店市",
"861899850", "广东省汕尾市",
"861338248", "江苏省南通市",
"861335467", "云南省玉溪市",
"861775409", "安徽省合肥市",
"861370412", "辽宁省鞍山市",
"861881981", "广东省广州市",
"861537631", "山东省日照市",
"861453569", "贵州省遵义市",
"861327368", "河北省邢台市",
"861515540", "安徽省淮南市",
"861559615", "陕西省咸阳市",
"861571773", "广西桂林市",
"86155737", "湖南省益阳市",
"861538212", "辽宁省沈阳市",
"861890362", "黑龙江省齐齐哈尔市",
"86151277", "河北省沧州市",
"861305430", "黑龙江省齐齐哈尔市",
"861898838", "云南省怒江傈僳族自治州",
"861452418", "辽宁省阜新市",
"861700016", "广东省广州市",
"86131108", "福建省泉州市",
"86181474", "内蒙古乌兰察布市",
"861372083", "福建省福州市",
"861810714", "湖北省黄石市",
"861344010", "四川省内江市",
"86136326", "广东省深圳市",
"861800784", "广西贺州市",
"861707649", "山东省烟台市",
"861772034", "湖北省咸宁市",
"861569153", "陕西省宝鸡市",
"861592927", "陕西省渭南市",
"861813344", "安徽省马鞍山市",
"861521956", "广东省江门市",
"861529143", "陕西省渭南市",
"86133065", "浙江省台州市",
"861319368", "河南省南阳市",
"861850681", "浙江省杭州市",
"861351476", "内蒙古赤峰市",
"861303029", "广东省云浮市",
"861881430", "广东省深圳市",
"861783910", "河南省商丘市",
"861575465", "黑龙江省黑河市",
"861810772", "广西柳州市",
"861554573", "黑龙江省鸡西市",
"861345894", "四川省乐山市",
"86458", "黑龙江省伊春市",
"861316519", "山东省济宁市",
"861804586", "黑龙江省双鸭山市",
"861768524", "贵州省遵义市",
"861534932", "甘肃省定西市",
"861317585", "浙江省台州市",
"86177325", "河北省唐山市",
"861839319", "甘肃省庆阳市",
"861399778", "湖北省恩施土家族苗族自治州",
"861370474", "内蒙古乌兰察布市",
"86151390", "河南省南阳市",
"861860950", "宁夏银川市",
"861709410", "广东省深圳市",
"861329585", "浙江省绍兴市",
"861820940", "甘肃省临夏回族自治州",
"86147790", "广东省广州市",
"861324390", "辽宁省葫芦岛市",
"861453699", "陕西省渭南市",
"861847157", "湖北省武汉市",
"861372267", "河北省邯郸市",
"861354321", "广东省梅州市",
"861303345", "山西省朔州市",
"861311689", "浙江省金华市",
"861514187", "辽宁省铁岭市",
"86147411", "辽宁省大连市",
"861895944", "福建省宁德市",
"86183487", "河北省邯郸市",
"861819180", "陕西省渭南市",
"861356956", "河南省平顶山市",
"8614728", "四川省成都市",
"861871982", "甘肃省兰州市",
"861566409", "河南省新乡市",
"861380411", "辽宁省大连市",
"86189252", "广东省深圳市",
"861362738", "湖南省娄底市",
"861899107", "陕西省榆林市",
"861301619", "湖南省衡阳市",
"861352639", "河南省驻马店市",
"861773721", "河南省周口市",
"861323855", "贵州省黔东南苗族侗族自治州",
"861510869", "云南省曲靖市",
"861535205", "甘肃省平凉市",
"861363845", "湖南省怀化市",
"861864803", "内蒙古鄂尔多斯市",
"861338090", "广东省湛江市",
"86183157", "山东省临沂市",
"861803783", "河南省驻马店市",
"861879866", "贵州省遵义市",
"861810343", "山西省太原市",
"861860536", "山东省潍坊市",
"86185017", "上海市",
"86188399", "河南省许昌市",
"861311128", "山西省大同市",
"861557824", "广西来宾市",
"861390472", "内蒙古包头市",
"861363101", "广东省潮州市",
"861318859", "辽宁省盘锦市",
"861524137", "辽宁省锦州市",
"861380744", "湖南省张家界市",
"861591713", "广东省汕尾市",
"86138471", "内蒙古呼和浩特市",
"861561979", "陕西省汉中市",
"861359818", "河南省洛阳市",
"861340578", "江苏省无锡市",
"861320735", "湖南省郴州市",
"861805846", "浙江省台州市",
"861821829", "广东省茂名市",
"86151395", "河南省漯河市",
"861530766", "广东省云浮市",
"861538069", "江苏省连云港市",
"861831294", "浙江省温州市",
"861573523", "山西省太原市",
"861819478", "青海省海南藏族自治州",
"861705627", "河北省石家庄市",
"861534694", "甘肃省庆阳市",
"861313091", "辽宁省盘锦市",
"861454362", "山东省青岛市",
"861857119", "湖北省襄樊市",
"86177320", "河北省邯郸市",
"86183316", "河北省廊坊市",
"861347209", "河北省承德市",
"861858893", "广东省广州市",
"861860591", "福建省福州市",
"861860900", "新疆乌鲁木齐市",
"861890485", "黑龙江省绥化市",
"861347778", "湖北省咸宁市",
"861327535", "山东省烟台市",
"861804353", "吉林省长春市",
"861899157", "陕西省宝鸡市",
"861780265", "江苏省徐州市",
"861862923", "陕西省渭南市",
"861333683", "浙江省湖州市",
"861363674", "陕西省咸阳市",
"861338706", "江西省抚州市",
"861332328", "河北省秦皇岛市",
"861869786", "青海省玉树藏族自治州",
"861840435", "吉林省通化市",
"861343797", "江西省赣州市",
"861526449", "山东省临沂市",
"861577164", "陕西省渭南市",
"86189190", "甘肃省兰州市",
"861589741", "湖南省怀化市",
"861535255", "新疆伊犁哈萨克自治州",
"861841934", "甘肃省武威市",
"861573849", "河南省平顶山市",
"86153859", "安徽省六安市",
"861319535", "安徽省宣城市",
"861356172", "山东省莱芜市",
"861393413", "山西省太原市",
"861458388", "福建省龙岩市",
"861315649", "山东省滨州市",
"861373371", "河南省许昌市",
"861537566", "安徽省池州市",
"861830615", "江苏省无锡市",
"861589232", "四川省资阳市",
"861808656", "湖北省黄冈市",
"861322476", "内蒙古通辽市",
"861458118", "安徽省阜阳市",
"861339838", "四川省绵阳市",
"861300422", "浙江省嘉兴市",
"861345768", "广西桂林市",
"861839628", "福建省漳州市",
"86151775", "广西玉林市",
"861332941", "黑龙江省哈尔滨市",
"861769878", "河南省驻马店市",
"861323095", "河北省邢台市",
"861525557", "安徽省宿州市",
"861320224", "广东省揭阳市",
"861883433", "山西省长治市",
"86147375", "广东省广州市",
"861324404", "吉林省吉林市",
"861354199", "四川省广安市",
"861575174", "江苏省苏州市",
"86153601", "广东省惠州市",
"861338850", "浙江省衢州市",
"861310731", "湖南省长沙市",
"861384987", "河南省许昌市",
"861365793", "江西省上饶市",
"861520534", "山东省德州市",
"86152975", "河北省邯郸市",
"86188779", "广西北海市",
"861809933", "新疆阿克苏地区",
"861330899", "西藏拉萨市",
"861580545", "山东省烟台市",
"861879760", "湖南省怀化市",
"861337237", "浙江省台州市",
"861553870", "河南省郑州市",
"861572900", "河南省三门峡市",
"861572591", "山东省济宁市",
"861815658", "安徽省芜湖市",
"861550071", "青海省黄南藏族自治州",
"861535576", "浙江省台州市",
"861310242", "河北省沧州市",
"861306977", "黑龙江省绥化市",
"861880069", "江苏省无锡市",
"861328149", "四川省成都市",
"861367479", "内蒙古锡林郭勒盟",
"86138310", "河北省邯郸市",
"861575601", "安徽省铜陵市",
"861308021", "内蒙古包头市",
"861807330", "湖南省株洲市",
"86156538", "山东省烟台市",
"861863500", "山西省忻州市",
"861390087", "云南省昆明市",
"861517221", "湖北省孝感市",
"861868257", "四川省内江市",
"861863991", "河南省焦作市",
"861786899", "云南省大理白族自治州",
"861894969", "安徽省淮南市",
"861364711", "湖北省鄂州市",
"861329531", "山东省济南市",
"861334125", "山东省淄博市",
"861705666", "北京市",
"861818848", "四川省成都市",
"861844704", "内蒙古呼和浩特市",
"861785800", "浙江省金华市",
"861310000", "山西省太原市",
"861530727", "湖北省襄樊市",
"861570923", "陕西省渭南市",
"8623", "重庆市",
"861350825", "四川省达州市",
"86150588", "浙江省宁波市",
"861867830", "山东省济南市",
"861364528", "江苏省镇江市",
"861529221", "湖南省株洲市",
"861850635", "山东省聊城市",
"861890496", "辽宁省锦州市",
"861585111", "江苏省盐城市",
"861304040", "浙江省宁波市",
"86137361", "浙江省宁波市",
"861301328", "河北省唐山市",
"861587745", "陕西省商洛市",
"861539302", "甘肃省临夏回族自治州",
"86151581", "浙江省杭州市",
"86184478", "内蒙古呼和浩特市",
"861305935", "广东省肇庆市",
"861335640", "广东省江门市",
"861800143", "江苏省泰州市",
"86151770", "广西百色市",
"861454333", "内蒙古呼和浩特市",
"861379637", "黑龙江省双鸭山市",
"861761416", "辽宁省锦州市",
"861342246", "广东省珠海市",
"861319581", "甘肃省天水市",
"861329596", "福建省漳州市",
"861564887", "内蒙古巴彦淖尔市",
"861309511", "新疆伊犁哈萨克自治州",
"861336510", "江苏省扬州市",
"861364444", "吉林省四平市",
"861850398", "河南省三门峡市",
"861590340", "山西省太原市",
"861586377", "山东省济南市",
"861599183", "陕西省汉中市",
"861309728", "江西省南昌市",
"861890431", "吉林省长春市",
"861770918", "陕西省西安市",
"86147438", "吉林省松原市",
"861861395", "湖南省长沙市",
"86131856", "浙江省台州市",
"861561587", "山东省济宁市",
"86182296", "湖南省常德市",
"861366364", "山西省晋中市",
"861378379", "河南省洛阳市",
"861571520", "江苏省徐州市",
"861458636", "湖北省黄石市",
"861325915", "陕西省安康市",
"861572950", "宁夏银川市",
"861877228", "湖北省黄石市",
"861475238", "江苏省无锡市",
"861840481", "内蒙古呼和浩特市",
"861328998", "新疆喀什地区",
"861839189", "陕西省宝鸡市",
"861812598", "广东省清远市",
"861471847", "广东省揭阳市",
"861577475", "内蒙古通辽市",
"86138315", "河北省唐山市",
"86134508", "广东省佛山市",
"861554160", "辽宁省锦州市",
"86150184", "广东省广州市",
"861310050", "广西南宁市",
"861785850", "浙江省绍兴市",
"86139503", "福建省福州市",
"861859167", "陕西省延安市",
"86151050", "福建省南平市",
"861313851", "广东省肇庆市",
"861530860", "湖北省宜昌市",
"86147083", "四川省成都市",
"861582558", "浙江省宁波市",
"861310796", "福建省莆田市",
"861318099", "吉林省长春市",
"861533061", "吉林省长春市",
"861898032", "四川省广安市",
"861581928", "广东省河源市",
"861337888", "云南省丽江市",
"861572536", "山东省潍坊市",
"861566617", "山东省济宁市",
"861510584", "浙江省宁波市",
"861332619", "浙江省温州市",
"861301407", "安徽省阜阳市",
"861320781", "广西南宁市",
"861539352", "甘肃省武威市",
"86156134", "河北省唐山市",
"861500734", "湖南省衡阳市",
"861560451", "黑龙江省哈尔滨市",
"861336001", "广东省广州市",
"861533576", "湖北省孝感市",
"861862690", "吉林省长春市",
"861334318", "河北省衡水市",
"861813658", "江苏省常州市",
"861856128", "山东省威海市",
"861534342", "山西省太原市",
"861779039", "四川省广安市",
"861572716", "湖北省荆州市",
"861842927", "陕西省宝鸡市",
"861554092", "内蒙古兴安盟",
"861780730", "湖南省岳阳市",
"86186606", "山东省潍坊市",
"861870542", "山东省青岛市",
"861471744", "江西省南昌市",
"861820330", "河北省沧州市",
"861311185", "四川省成都市",
"861587677", "广东省汕尾市",
"861581931", "广东省肇庆市",
"861536462", "山西省大同市",
"861576040", "四川省乐山市",
"861527288", "湖北省随州市",
"861528042", "福建省福州市",
"861787530", "广东省梅州市",
"86138272", "广东省东莞市",
"86156470", "内蒙古呼伦贝尔市",
"861303935", "吉林省松原市",
"861453195", "山西省晋城市",
"861361896", "西藏那曲地区",
"861832743", "湖北省恩施土家族苗族自治州",
"861872947", "陕西省宝鸡市",
"861319422", "辽宁省沈阳市",
"86150388", "河南省平顶山市",
"861811906", "新疆阿勒泰地区",
"86176089", "海南省海口市",
"861320260", "广东省肇庆市",
"861458325", "江西省吉安市",
"86183717", "湖北省宜昌市",
"8618480", "福建省福州市",
"861593530", "山西省大同市",
"861878612", "贵州省贵阳市",
"861309242", "江苏省常州市",
"861335452", "黑龙江省齐齐哈尔市",
"861534773", "广西桂林市",
"861879970", "新疆塔城地区",
"861890357", "山西省临汾市",
"861829093", "新疆阿勒泰地区",
"86138510", "江苏省盐城市",
"861824880", "江苏省无锡市",
"861369454", "黑龙江省佳木斯市",
"861309731", "江西省赣州市",
"861359958", "福建省漳州市",
"861890428", "辽宁省大连市",
"861865991", "福建省泉州市",
"861811172", "四川省泸州市",
"86156338", "河北省石家庄市",
"86170039", "河南省郑州市",
"861336730", "湖南省岳阳市",
"861810933", "甘肃省平凉市",
"861327422", "辽宁省朝阳市",
"861894208", "湖南省常德市",
"86184530", "山东省菏泽市",
"861813608", "江苏省苏州市",
"861475784", "浙江省台州市",
"86153699", "河北省邢台市",
"861315145", "江苏省无锡市",
"861329528", "江苏省宿迁市",
"861539075", "江西省上饶市",
"861336051", "广东省深圳市",
"861890544", "山东省德州市",
"861323915", "陕西省安康市",
"861470879", "云南省普洱市",
"86150950", "山东省聊城市",
"861318641", "江苏省南京市",
"861816476", "云南省文山壮族苗族自治州",
"86155879", "湖北省宜昌市",
"861811530", "江苏省南通市",
"86147212", "上海市",
"861479507", "宁夏银川市",
"861308038", "山西省吕梁市",
"861317711", "湖北省恩施土家族苗族自治州",
"861352311", "河南省周口市",
"861356816", "四川省达州市",
"861301331", "云南省昆明市",
"861530824", "四川省达州市",
"861593906", "河南省商丘市",
"861568240", "四川省南充市",
"861813562", "河南省漯河市",
"861814830", "内蒙古阿拉善盟",
"861317528", "浙江省绍兴市",
"861523507", "山西省朔州市",
"86158616", "江苏省无锡市",
"861329711", "湖北省荆州市",
"861364531", "山东省济南市",
"86134247", "广东省东莞市",
"861309796", "广西百色市",
"861360062", "浙江省宁波市",
"86137654", "贵州省黔南布依族苗族自治州",
"861865936", "福建省宁德市",
"86187826", "四川省广安市",
"861310511", "山东省枣庄市",
"861836667", "山东省枣庄市",
"861301273", "山东省威海市",
"86156475", "内蒙古通辽市",
"86152474", "内蒙古乌兰察布市",
"861504661", "黑龙江省绥化市",
"861858745", "广西百色市",
"861372298", "河北省石家庄市",
"861339821", "四川省宜宾市",
"861563354", "河北省衡水市",
"861583335", "河北省秦皇岛市",
"861812526", "广东省肇庆市",
"861819143", "陕西省渭南市",
"86159628", "江苏省南通市",
"861550566", "安徽省池州市",
"86137833", "河南省驻马店市",
"861860810", "四川省德阳市",
"861774606", "福建省南平市",
"861811956", "安徽省宿州市",
"861535061", "河北省保定市",
"861398527", "贵州省黔东南苗族侗族自治州",
"86185937", "甘肃省酒泉市",
"861518192", "四川省遂宁市",
"861477322", "湖南省湘潭市",
"86139303", "河北省秦皇岛市",
"861803740", "河南省驻马店市",
"861776015", "四川省巴中市",
"861315851", "四川省南充市",
"861810380", "河南省商丘市",
"86184535", "山东省烟台市",
"861302643", "陕西省延安市",
"861587003", "江西省南昌市",
"861366320", "河北省唐山市",
"861310728", "湖南省娄底市",
"861571564", "安徽省六安市",
"861894258", "湖南省永州市",
"861800310", "河北省邯郸市",
"861890307", "广东省广州市",
"861591658", "广东省佛山市",
"861581996", "广东省中山市",
"861590383", "河南省商丘市",
"861522668", "河北省廊坊市",
"861829853", "甘肃省武威市",
"861872401", "江苏省南京市",
"861597706", "广西玉林市",
"861771244", "江苏省徐州市",
"86135267", "河南省郑州市",
"861361790", "江西省新余市",
"861587893", "广西钦州市",
"861536433", "湖南省娄底市",
"861569369", "甘肃省白银市",
"861350237", "广东省梅州市",
"861309785", "广西玉林市",
"861358113", "山东省泰安市",
"861508392", "江西省赣州市",
"861537071", "江苏省泰州市",
"86151590", "福建省龙岩市",
"86188301", "河北省石家庄市",
"861327715", "湖北省咸宁市",
"861550527", "江苏省淮安市",
"861334629", "山东省滨州市",
"861522502", "河南省平顶山市",
"861814791", "内蒙古锡林郭勒盟",
"861326789", "广东省湛江市",
"861321046", "山东省聊城市",
"86139759", "湖南省邵阳市",
"861313911", "青海省海东地区",
"861365151", "江苏省扬州市",
"861599140", "陕西省商洛市",
"861388634", "湖北省鄂州市",
"86135124", "天津市",
"861573465", "黑龙江省大庆市",
"861509869", "山东省日照市",
"861888824", "山东省德州市",
"861869529", "宁夏银川市",
"861337825", "四川省泸州市",
"86136220", "天津市",
"86158040", "辽宁省沈阳市",
"861770858", "贵州省六盘水市",
"86158422", "辽宁省鞍山市",
"861810962", "安徽省蚌埠市",
"861325855", "黑龙江省双鸭山市",
"861572810", "广东省潮州市",
"861308577", "广东省汕头市",
"861809772", "新疆石河子市",
"861581985", "广东省惠州市",
"861520907", "新疆博尔塔拉蒙古自治州",
"861780836", "四川省甘孜藏族自治州",
"861315036", "新疆哈密地区",
"861530152", "江苏省无锡市",
"861847415", "湖南省娄底市",
"861830389", "河南省商丘市",
"861399968", "新疆哈密地区",
"861700480", "福建省泉州市",
"86138453", "黑龙江省牡丹江市",
"861452509", "山东省威海市",
"861316492", "浙江省温州市",
"861772845", "广东省湛江市",
"861325086", "浙江省台州市",
"861567187", "湖北省恩施土家族苗族自治州",
"861584701", "内蒙古呼伦贝尔市",
"861863346", "河北省石家庄市",
"861570690", "云南省西双版纳傣族自治州",
"861328874", "河北省石家庄市",
"861511944", "广东省汕尾市",
"861321181", "云南省文山壮族苗族自治州",
"861388992", "广东省佛山市",
"861813533", "山西省晋中市",
"861899415", "江苏省南通市",
"861872451", "黑龙江省哈尔滨市",
"861454943", "福建省厦门市",
"861354338", "广东省茂名市",
"86156311", "河北省石家庄市",
"86151595", "福建省泉州市",
"861360033", "广东省中山市",
"86183516", "江苏省苏州市",
"861577120", "内蒙古巴彦淖尔市",
"861868019", "广东省中山市",
"861864572", "黑龙江省大兴安岭地区",
"861780891", "西藏拉萨市",
"861386657", "安徽省池州市",
"861583381", "河北省唐山市",
"861773738", "河南省驻马店市",
"86188599", "福建省泉州市",
"861363469", "黑龙江省双鸭山市",
"861858282", "四川省达州市",
"861857048", "湖南省湘潭市",
"861859949", "新疆伊犁哈萨克自治州",
"861300535", "广东省清远市",
"861362518", "江苏省泰州市",
"861313649", "浙江省台州市",
"86131696", "广东省珠海市",
"861867516", "广东省佛山市",
"861332396", "河南省驻马店市",
"861560665", "浙江省温州市",
"861478070", "四川省泸州市",
"861520957", "宁夏银川市",
"861364585", "浙江省绍兴市",
"861533255", "陕西省延安市",
"861350888", "云南省丽江市",
"861369390", "河南省开封市",
"861303270", "湖北省宜昌市",
"861590556", "安徽省安庆市",
"861560947", "甘肃省嘉峪关市",
"861387431", "湖南省益阳市",
"861365674", "浙江省宁波市",
"861335683", "山东省东营市",
"861361885", "云南省红河哈尼族彝族自治州",
"861556079", "内蒙古呼和浩特市",
"861585945", "福建省泉州市",
"861814736", "内蒙古包头市",
"861338910", "陕西省咸阳市",
"861585667", "安徽省黄山市",
"861512408", "辽宁省朝阳市",
"861452559", "山东省青岛市",
"86156193", "陕西省西安市",
"861551668", "河南省驻马店市",
"861339672", "浙江省湖州市",
"861530976", "青海省玉树藏族自治州",
"861800478", "内蒙古巴彦淖尔市",
"861890592", "福建省厦门市",
"861327598", "福建省三明市",
"861310539", "山东省临沂市",
"861322913", "广东省江门市",
"861453399", "内蒙古巴彦淖尔市",
"861324690", "广东省揭阳市",
"861840498", "山西省晋中市",
"86156813", "四川省乐山市",
"861596090", "福建省龙岩市",
"861323577", "浙江省温州市",
"861350510", "江苏省盐城市",
"861458129", "安徽省六安市",
"861572799", "浙江省衢州市",
"861899489", "江苏省扬州市",
"861319598", "甘肃省酒泉市",
"861777648", "广西南宁市",
"861888220", "四川省乐山市",
"861390255", "广东省江门市",
"861360471", "内蒙古呼和浩特市",
"861860463", "黑龙江省牡丹江市",
"861355850", "四川省甘孜藏族自治州",
"861454558", "新疆巴音郭楞蒙古自治州",
"861333556", "安徽省安庆市",
"861576120", "贵州省黔南布依族苗族自治州",
"861346968", "宁夏银川市",
"86186507", "福建省福州市",
"861528122", "四川省攀枝花市",
"861361819", "四川省眉山市",
"861312310", "福建省泉州市",
"861331962", "湖南省常德市",
"861569474", "内蒙古乌兰察布市",
"861572214", "贵州省贵阳市",
"861450244", "河北省承德市",
"861317739", "湖北省鄂州市",
"861320798", "江西省景德镇市",
"861472676", "四川省资阳市",
"861352339", "河南省周口市",
"861334753", "广西桂林市",
"861535472", "吉林省延边朝鲜族自治州",
"861374957", "河南省平顶山市",
"861337891", "湖南省长沙市",
"861459460", "陕西省汉中市",
"861300526", "广东省揭阳市",
"861868806", "广东省揭阳市",
"861301319", "安徽省安庆市",
"861339886", "云南省怒江傈僳族自治州",
"861303967", "黑龙江省伊春市",
"861518144", "四川省绵阳市",
"86176432", "吉林省吉林市",
"861311389", "河北省石家庄市",
"86187027", "湖北省武汉市",
"861362880", "云南省西双版纳傣族自治州",
"861854831", "内蒙古巴彦淖尔市",
"861354621", "山西省晋城市",
"861303645", "四川省乐山市",
"861822596", "安徽省宿州市",
"861333930", "黑龙江省哈尔滨市",
"861599613", "江苏省连云港市",
"861329739", "湖南省邵阳市",
"861315025", "新疆巴音郭楞蒙古自治州",
"861897246", "湖北省十堰市",
"861780825", "四川省遂宁市",
"861519865", "云南省丽江市",
"861816853", "江苏省泰州市",
"861572432", "辽宁省朝阳市",
"861373104", "河北省邯郸市",
"861554044", "内蒙古乌兰察布市",
"861362795", "江西省宜春市",
"861572588", "山东省日照市",
"861337836", "四川省眉山市",
"861534394", "河南省周口市",
"861705327", "广东省广州市",
"861454662", "广东省广州市",
"86155001", "吉林省四平市",
"861319789", "江西省吉安市",
"861870594", "福建省莆田市",
"861707376", "河南省信阳市",
"861775880", "黑龙江省鸡西市",
"861880966", "宁夏吴忠市",
"861876285", "江苏省南通市",
"861886087", "江苏省镇江市",
"861321339", "河南省许昌市",
"8615320", "重庆市",
"861804077", "新疆乌鲁木齐市",
"861537433", "江西省上饶市",
"861536071", "广东省湛江市",
"861348597", "安徽省合肥市",
"861355800", "广西防城港市",
"861454508", "湖南省长沙市",
"861339055", "辽宁省沈阳市",
"861471792", "山西省临汾市",
"861309719", "江西省萍乡市",
"861582980", "陕西省咸阳市",
"861315349", "山东省德州市",
"86185340", "山西省长治市",
"861830315", "河北省唐山市",
"861571815", "广东省佛山市",
"861302933", "辽宁省锦州市",
"86158517", "江苏省淮安市",
"861819023", "四川省自贡市",
"861320589", "浙江省金华市",
"861372760", "广东省梅州市",
"861334703", "内蒙古呼伦贝尔市",
"861779011", "四川省德阳市",
"861458688", "湖南省湘潭市",
"861556727", "吉林省松原市",
"861332628", "山东省滨州市",
"861376272", "湖南省益阳市",
"861853484", "山西省晋中市",
"861868856", "广东省中山市",
"861806940", "浙江省杭州市",
"861363374", "河南省许昌市",
"861839941", "新疆阿克苏地区",
"861329492", "云南省昭通市",
"861815466", "广西玉林市",
"86133149", "福建省福州市",
"861503042", "河北省邯郸市",
"861313088", "辽宁省盘锦市",
"86153003", "北京市",
"861361268", "广东省东莞市",
"861316528", "山东省临沂市",
"861815427", "安徽省池州市",
"86158716", "湖北省宜昌市",
"861561076", "山东省威海市",
"86134072", "湖北省武汉市",
"861583326", "河北省承德市",
"8615010", "北京市",
"861860588", "浙江省杭州市",
"861829476", "甘肃省甘南藏族自治州",
"86137754", "江苏省连云港市",
"861588196", "四川省泸州市",
"861860432", "吉林省吉林市",
"861303018", "广东省湛江市",
"861323989", "新疆昌吉回族自治州",
"861881952", "广东省东莞市",
"861551397", "山西省运城市",
"861786906", "云南省普洱市",
"861526837", "浙江省宁波市",
"861339780", "广西南宁市",
"861538966", "陕西省宝鸡市",
"861534450", "黑龙江省哈尔滨市",
"861529861", "江苏省连云港市",
"861362786", "广西桂林市",
"861321126", "广东省江门市",
"861892259", "广东省韶关市",
"861839457", "甘肃省甘南藏族自治州",
"861392157", "江苏省镇江市",
"861805247", "江苏省无锡市",
"861304475", "河南省新乡市",
"861818156", "四川省内江市",
"86155265", "吉林省吉林市",
"861330906", "四川省遂宁市",
"861458391", "福建省三明市",
"861776089", "安徽省宣城市",
"861320864", "吉林省松原市",
"86182420", "辽宁省大连市",
"861893634", "江苏省盐城市",
"861777015", "江西省鹰潭市",
"861335340", "山西省忻州市",
"86152160", "江西省上饶市",
"861873994", "河南省郑州市",
"861367320", "河北省邯郸市",
"861532253", "广东省湛江市",
"861351572", "浙江省湖州市",
"861539568", "安徽省马鞍山市",
"861705366", "广东省广州市",
"861824284", "辽宁省辽阳市",
"861503200", "河北省邯郸市",
"861331933", "江西省吉安市",
"861886472", "河南省安阳市",
"861593217", "河北省保定市",
"861355756", "广西桂林市",
"86156568", "安徽省亳州市",
"86159728", "湖北省黄冈市",
"86147855", "贵州省贵阳市",
"861330530", "山东省菏泽市",
"861815308", "河南省信阳市",
"861458336", "江西省赣州市",
"86825", "四川省遂宁市",
"861821818", "广东省广州市",
"861859639", "山东省烟台市",
"8613445", "上海市",
"861801287", "江苏省南通市",
"86186706", "湖南省常德市",
"861771292", "江苏省泰州市",
"861504687", "黑龙江省黑河市",
"86159923", "广东省潮州市",
"861809680", "新疆巴音郭楞蒙古自治州",
"861760570", "浙江省衢州市",
"861303926", "吉林省吉林市",
"861860799", "江西省萍乡市",
"861855545", "安徽省六安市",
"861300567", "广东省茂名市",
"861508344", "河南省南阳市",
"861537462", "内蒙古呼伦贝尔市",
"861811217", "江苏省连云港市",
"861535087", "河北省秦皇岛市",
"861311119", "山西省运城市",
"861343842", "四川省资阳市",
"861376361", "黑龙江省牡丹江市",
"861590640", "浙江省丽水市",
"861850698", "福建省三明市",
"861818106", "四川省南充市",
"86155260", "湖南省邵阳市",
"861454633", "宁夏石嘴山市",
"861892209", "广东省湛江市",
"861839407", "甘肃省临夏回族自治州",
"861869738", "河南省许昌市",
"86151146", "黑龙江省哈尔滨市",
"861814234", "陕西省汉中市",
"861572463", "辽宁省鞍山市",
"861776938", "湖南省娄底市",
"861534400", "内蒙古鄂尔多斯市",
"861379337", "山东省威海市",
"861368487", "江西省赣州市",
"86152165", "山东省临沂市",
"86186424", "辽宁省本溪市",
"86151883", "河南省郑州市",
"86182425", "辽宁省丹东市",
"861867599", "广东省湛江市",
"861308915", "吉林省吉林市",
"861876231", "江苏省扬州市",
"861330956", "宁夏石嘴山市",
"861332319", "河北省邢台市",
"861876742", "浙江省台州市",
"861478584", "贵州省安顺市",
"861597254", "湖北省黄石市",
"861318985", "广东省江门市",
"861588131", "四川省自贡市",
"861356059", "广东省汕尾市",
"861337730", "广西桂林市",
"861889065", "湖南省怀化市",
"861314364", "河北省石家庄市",
"861320977", "青海省海西蒙古族藏族自治州",
"861560637", "山东省枣庄市",
"861302962", "新疆巴音郭楞蒙古自治州",
"861373822", "浙江省湖州市",
"861786530", "山东省菏泽市",
"861831728", "河南省焦作市",
"861775786", "浙江省宁波市",
"861348440", "陕西省咸阳市",
"861353910", "广东省河源市",
"861390576", "浙江省台州市",
"861854790", "内蒙古锡林郭勒盟",
"86147850", "贵州省贵阳市",
"861594748", "内蒙古巴彦淖尔市",
"861559797", "贵州省黔西南布依族苗族自治州",
"861355706", "广西百色市",
"861331380", "福建省三明市",
"86147681", "山东省临沂市",
"861506534", "山东省德州市",
"86183617", "江苏省徐州市",
"861313939", "甘肃省陇南市",
"86156227", "广东省广州市",
"86157941", "浙江省杭州市",
"861303149", "河北省廊坊市",
"861598730", "云南省怒江傈僳族自治州",
"861587377", "湖南省邵阳市",
"861320820", "四川省攀枝花市",
"861393860", "河南省开封市",
"861820630", "山东省德州市",
"861868916", "西藏那曲地区",
"861588128", "四川省攀枝花市",
"861338254", "江苏省苏州市",
"861390061", "江苏省无锡市",
"861316596", "浙江省杭州市",
"861380792", "江西省九江市",
"861372235", "河北省张家口市",
"861570454", "黑龙江省佳木斯市",
"861351853", "贵州省安顺市",
"861571955", "宁夏中卫市",
"861839396", "甘肃省陇南市",
"861361909", "四川省巴中市",
"86182924", "陕西省西安市",
"861321198", "云南省普洱市",
"861831242", "广东省广州市",
"86186925", "湖南省怀化市",
"861782046", "广东省清远市",
"861453616", "江苏省南通市",
"861315088", "内蒙古鄂尔多斯市",
"861337510", "江苏省徐州市",
"861813358", "河北省张家口市",
"861335113", "黑龙江省牡丹江市",
"861862390", "河南省南阳市",
"861811899", "江苏省南京市",
"861334618", "浙江省杭州市",
"861813427", "河北省沧州市",
"861470024", "安徽省六安市",
"861506299", "江苏省泰州市",
"861398462", "贵州省六盘水市",
"86668", "广东省茂名市",
"86184560", "安徽省阜阳市",
"86170712", "天津市",
"861523875", "河南省周口市",
"861556102", "内蒙古呼和浩特市",
"861308095", "陕西省延安市",
"861336888", "云南省丽江市",
"861348568", "安徽省阜阳市",
"861332685", "广东省东莞市",
"861582943", "陕西省渭南市",
"861352949", "云南省红河哈尼族彝族自治州",
"861384961", "河南省驻马店市",
"861884973", "云南省楚雄彝族自治州",
"861857131", "湖北省恩施土家族苗族自治州",
"861816913", "宁夏吴忠市",
"86137531", "山西省太原市",
"861576475", "内蒙古通辽市",
"861869721", "青海省海东地区",
"861458625", "湖北省黄冈市",
"861776921", "湖南省张家界市",
"861538776", "江西省吉安市",
"861887255", "湖北省襄樊市",
"861368593", "福建省泉州市",
"861350891", "山东省威海市",
"861529295", "新疆和田地区",
"861556976", "甘肃省酒泉市",
"86189546", "山东省东营市",
"861333340", "山西省太原市",
"861771883", "广东省揭阳市",
"861303998", "黑龙江省哈尔滨市",
"86188679", "浙江省金华市",
"861334136", "湖南省常德市",
"861355162", "四川省广安市",
"861550433", "吉林省延边朝鲜族自治州",
"861599708", "青海省西宁市",
"861859181", "陕西省榆林市",
"86145222", "浙江省温州市",
"861835282", "江苏省连云港市",
"861345842", "四川省甘孜藏族自治州",
"861857196", "湖北省荆门市",
"86133828", "江苏省常州市",
"86186920", "湖南省衡阳市",
"861321949", "四川省广元市",
"861867412", "湖北省襄樊市",
"861362529", "江苏省苏州市",
"861533087", "辽宁省本溪市",
"861584509", "黑龙江省绥化市",
"861361959", "宁夏银川市",
"861571905", "新疆和田地区",
"86151675", "浙江省绍兴市",
"86185816", "四川省雅安市",
"861813308", "安徽省阜阳市",
"861880870", "云南省昭通市",
"861590452", "黑龙江省齐齐哈尔市",
"861551406", "河南省鹤壁市",
"861318341", "四川省达州市",
"861883071", "河北省沧州市",
"86153701", "江苏省苏州市",
"861861321", "四川省成都市",
"861800610", "江苏省镇江市",
"861562446", "山东省日照市",
"861302343", "江苏省镇江市",
"86184565", "安徽省合肥市",
"861767112", "湖北省十堰市",
"861380246", "广东省佛山市",
"861890607", "福建省龙岩市",
"861588689", "新疆喀什地区",
"861315939", "福建省三明市",
"861319567", "安徽省亳州市",
"861346997", "湖北省武汉市",
"861335275", "广东省汕尾市",
"861452751", "湖南省长沙市",
"861316531", "山东省济南市",
"861834447", "广东省深圳市",
"861773786", "河南省濮阳市",
"861539440", "福建省福州市",
"861556152", "黑龙江省七台河市",
"861366479", "内蒙古锡林郭勒盟",
"861839331", "甘肃省平凉市",
"861532477", "河南省南阳市",
"8618044", "黑龙江省哈尔滨市",
"861327567", "安徽省亳州市",
"86777", "广西钦州市",
"86137863", "湖南省株洲市",
"861561561", "山东省济南市",
"861812715", "广东省佛山市",
"861523644", "河南省信阳市",
"861787899", "广西梧州市",
"861325038", "广东省佛山市",
"86155359", "山西省运城市",
"861831796", "江西省吉安市",
"86131576", "浙江省台州市",
"861840467", "黑龙江省鸡西市",
"861354386", "广东省珠海市",
"861840426", "辽宁省盘锦市",
"861328345", "河北省秦皇岛市",
"861877897", "广西南宁市",
"861530413", "辽宁省抚顺市",
"861350051", "安徽省合肥市",
"861335556", "安徽省安庆市",
"861334329", "河北省唐山市",
"86147695", "广东省广州市",
"861342411", "广东省广州市",
"861364492", "辽宁省鞍山市",
"861809643", "安徽省淮南市",
"861327526", "江苏省南通市",
"861559768", "青海省西宁市",
"861331772", "广西柳州市",
"86158486", "内蒙古包头市",
"861592541", "云南省西双版纳傣族自治州",
"861852908", "广东省深圳市",
"861330816", "四川省雅安市",
"861325577", "浙江省温州市",
"861459424", "云南省楚雄彝族自治州",
"861894571", "黑龙江省黑河市",
"86155703", "江西省宜春市",
"86158156", "广东省佛山市",
"861375154", "广东省佛山市",
"861538870", "云南省昭通市",
"861770146", "江苏省南通市",
"861319526", "贵州省铜仁地区",
"861593009", "河北省承德市",
"861332631", "山东省威海市",
"861590683", "浙江省嘉兴市",
"86189810", "四川省德阳市",
"861335930", "甘肃省金昌市",
"861305645", "四川省甘孜藏族自治州",
"861850667", "广东省茂名市",
"861866791", "浙江省杭州市",
"861320726", "湖北省十堰市",
"861501477", "广东省东莞市",
"861308141", "山东省东营市",
"861528914", "西藏林芝地区",
"861519449", "河南省信阳市",
"861334045", "福建省泉州市",
"861850945", "甘肃省金昌市",
"861536566", "江苏省盐城市",
"861309539", "云南省保山市",
"861331343", "山西省太原市",
"861357906", "新疆喀什地区",
"861802050", "江苏省无锡市",
"861346778", "湖南省邵阳市",
"861888264", "四川省内江市",
"861821958", "广东省佛山市",
"861386544", "安徽省六安市",
"861890419", "辽宁省辽阳市",
"861533472", "内蒙古包头市",
"861348483", "陕西省榆林市",
"861300598", "广西梧州市",
"86186307", "河北省沧州市",
"86134112", "广东省梅州市",
"861370369", "黑龙江省齐齐哈尔市",
"86185545", "山东省淄博市",
"861372281", "河北省衡水市",
"861839385", "甘肃省白银市",
"861350001", "广东省广州市",
"861779936", "新疆伊犁哈萨克自治州",
"861800023", "江西省九江市",
"86137518", "广东省广州市",
"861458946", "广东省中山市",
"861596910", "云南省曲靖市",
"861539597", "福建省龙岩市",
"861395152", "江苏省宿迁市",
"861508934", "广东省惠州市",
"861882435", "广东省东莞市",
"861322093", "山东省烟台市",
"861364739", "湖南省邵阳市",
"86147690", "云南省临沧市",
"861860525", "江苏省镇江市",
"861887576", "河北省邢台市",
"861570390", "河南省漯河市",
"861317519", "浙江省宁波市",
"861379947", "福建省泉州市",
"86189815", "四川省凉山彝族自治州",
"861339743", "湖南省湘西土家族苗族自治州",
"861831890", "广东省惠州市",
"861504272", "辽宁省营口市",
"86189747", "湖南省衡阳市",
"86153579", "安徽省合肥市",
"861708197", "福建省漳州市",
"861593059", "河北省秦皇岛市",
"86132137", "河南省南阳市",
"861813466", "安徽省阜阳市",
"861339372", "河南省郑州市",
"861365374", "河南省许昌市",
"861335383", "河南省开封市",
"861865988", "福建省三明市",
"861459548", "青海省西宁市",
"861529286", "新疆乌鲁木齐市",
"861500865", "宁夏中卫市",
"861808497", "四川省宜宾市",
"861889251", "贵州省安顺市",
"861510070", "河北省廊坊市",
"861821908", "广东省韶关市",
"861310719", "湖南省邵阳市",
"861318016", "河北省唐山市",
"861818733", "云南省红河哈尼族彝族自治州",
"861357956", "新疆克孜勒苏柯尔克孜自治州",
"861560365", "黑龙江省哈尔滨市",
"861300789", "贵州省安顺市",
"861880776", "广西百色市",
"861558061", "湖南省张家界市",
"861313349", "山西省朔州市",
"861378175", "河南省南阳市",
"86185540", "山东省烟台市",
"86158317", "河北省沧州市",
"861350730", "湖南省岳阳市",
"861867725", "广西来宾市",
"861567409", "湖南省郴州市",
"861477871", "广东省深圳市",
"86159115", "云南省昆明市",
"861804917", "陕西省宝鸡市",
"861318766", "云南省楚雄彝族自治州",
"861785869", "浙江省台州市",
"861325597", "福建省龙岩市",
"861599907", "新疆昌吉回族自治州",
"861477836", "广东省梅州市",
"861863569", "山西省朔州市",
"861814987", "新疆和田地区",
"861862418", "辽宁省阜新市",
"861800435", "吉林省通化市",
"861880731", "湖南省长沙市",
"861595144", "江苏省扬州市",
"861303797", "宁夏银川市",
"861358238", "河北省保定市",
"861320968", "宁夏银川市",
"861558528", "贵州省贵阳市",
"861399515", "宁夏吴忠市",
"861313433", "吉林省延边朝鲜族自治州",
"861873898", "河南省开封市",
"861530859", "贵州省黔西南布依族苗族自治州",
"861527980", "江西省吉安市",
"861331792", "江西省九江市",
"861364472", "内蒙古包头市",
"86132979", "湖北省武汉市",
"861775965", "福建省泉州市",
"861504746", "内蒙古通辽市",
"861346798", "湖南省湘西土家族苗族自治州",
"861528908", "西藏拉萨市",
"861890853", "贵州省安顺市",
"861773775", "河南省南阳市",
"861509162", "陕西省西安市",
"861300578", "广东省珠海市",
"86186309", "天津市",
"861813184", "河北省衡水市",
"861845846", "浙江省温州市",
"86157273", "北京市",
"861560150", "江苏省常州市",
"861367416", "辽宁省锦州市",
"861341941", "四川省乐山市",
"861501497", "广东省惠州市",
"861879709", "青海省西宁市",
"861579425", "江苏省苏州市",
"861572969", "四川省乐山市",
"861510706", "江西省吉安市",
"861518009", "江西省鹰潭市",
"861850832", "四川省内江市",
"861700135", "天津市",
"861322607", "广东省中山市",
"86181310", "河北省邯郸市",
"861802776", "广东省茂名市",
"861351607", "辽宁省丹东市",
"861898466", "贵州省铜仁地区",
"861521783", "广东省惠州市",
"861524494", "四川省遂宁市",
"861554109", "辽宁省葫芦岛市",
"861373049", "河北省唐山市",
"86159110", "北京市",
"861312467", "贵州省贵阳市",
"86188856", "贵州省铜仁地区",
"86189749", "湖南省长沙市",
"861831870", "广东省清远市",
"861707328", "河北省石家庄市",
"861896643", "浙江省丽水市",
"861532540", "浙江省衢州市",
"861570370", "河南省商丘市",
"861310274", "河北省沧州市",
"861539577", "浙江省温州市",
"861761479", "内蒙古锡林郭勒盟",
"861459317", "四川省遂宁市",
"861591184", "云南省临沧市",
"861473556", "山西省长治市",
"861322073", "山东省潍坊市",
"861575142", "江苏省泰州市",
"861331439", "吉林省长春市",
"861822061", "陕西省咸阳市",
"861871309", "河北省沧州市",
"861529930", "新疆吐鲁番地区",
"861369670", "安徽省宿州市",
"861527271", "湖北省咸宁市",
"861347515", "山东省德州市",
"861368912", "陕西省榆林市",
"861894536", "黑龙江省绥化市",
"861709667", "浙江省杭州市",
"861338869", "浙江省湖州市",
"861373325", "河北省唐山市",
"861471962", "甘肃省武威市",
"861597445", "湖南省湘潭市",
"861533739", "湖北省鄂州市",
"861396539", "安徽省马鞍山市",
"861844586", "黑龙江省哈尔滨市",
"861709945", "浙江省湖州市",
"861305894", "浙江省湖州市",
"86158319", "河北省石家庄市",
"861776834", "江苏省无锡市",
"861880796", "江西省吉安市",
"86177702", "江西省九江市",
"861581264", "广东省珠海市",
"861528958", "广西玉林市",
"86188443", "吉林省延边朝鲜族自治州",
"861760811", "四川省眉山市",
"861820415", "辽宁省丹东市",
"861888099", "四川省达州市",
"861821914", "广东省深圳市",
"861339392", "河南省周口市",
"861538785", "江西省赣州市",
"861331246", "贵州省六盘水市",
"86185662", "广东省深圳市",
"86132139", "河南省濮阳市",
"86181315", "河北省唐山市",
"861700311", "河北省石家庄市",
"861323483", "内蒙古鄂尔多斯市",
"861322657", "广东省清远市",
"86186591", "福建省福州市",
"861556985", "甘肃省白银市",
"861398025", "四川省泸州市",
"861559018", "吉林省四平市",
"861557919", "江西省上饶市",
"861807157", "湖北省宜昌市",
"861365394", "河南省周口市",
"861510756", "广东省珠海市",
"861362647", "山东省济宁市",
"86153396", "安徽省六安市",
"861536649", "江苏省盐城市",
"861809847", "安徽省马鞍山市",
"861313462", "山西省大同市",
"86155116", "河北省石家庄市",
"86180335", "河北省秦皇岛市",
"861772400", "广东省广州市",
"861470530", "山东省菏泽市",
"861550025", "吉林省白城市",
"861858406", "四川省成都市",
"861817428", "湖南省常德市",
"861839376", "甘肃省白银市",
"861862370", "河南省开封市",
"86187644", "山东省济南市",
"861700181", "广东省深圳市",
"861888809", "江苏省徐州市",
"861890093", "辽宁省沈阳市",
"861351419", "辽宁省辽阳市",
"861590887", "云南省迪庆藏族自治州",
"861887585", "浙江省丽水市",
"86139441", "吉林省长春市",
"861390444", "吉林省吉林市",
"86186385", "河南省郑州市",
"861818012", "四川省攀枝花市",
"861814579", "广东省佛山市",
"861869347", "甘肃省张掖市",
"86187436", "吉林省白城市",
"861579712", "湖北省十堰市",
"861311430", "湖北省荆州市",
"861583378", "河北省沧州市",
"861316576", "陕西省安康市",
"861380772", "广西柳州市",
"861778097", "四川省绵阳市",
"861334604", "浙江省绍兴市",
"861513001", "河北省邯郸市",
"86178555", "安徽省马鞍山市",
"861318860", "辽宁省辽阳市",
"861707941", "河南省洛阳市",
"861538796", "江西省吉安市",
"861550349", "山西省朔州市",
"861875974", "福建省三明市",
"861882610", "广东省广州市",
"861895156", "江苏省无锡市",
"861356144", "山东省潍坊市",
"861884993", "云南省西双版纳傣族自治州",
"861477730", "广西南宁市",
"86153776", "湖北省武汉市",
"861883036", "河北省秦皇岛市",
"86137423", "辽宁省抚顺市",
"861850863", "湖北省武汉市",
"861350871", "云南省昆明市",
"861346864", "陕西省汉中市",
"861868561", "贵州省遵义市",
"861338584", "浙江省宁波市",
"861368573", "浙江省宁波市",
"861537939", "甘肃省陇南市",
"861452524", "山东省临沂市",
"861810411", "辽宁省大连市",
"86375", "河南省平顶山市",
"861506279", "江苏省扬州市",
"861539038", "四川省自贡市",
"86133681", "重庆市",
"861804068", "湖北省荆门市",
"861516640", "山东省济宁市",
"861517275", "湖北省咸宁市",
"86133850", "福建省宁德市",
"861301676", "江苏省南通市",
"861509133", "陕西省西安市",
"861881689", "广东省广州市",
"86186958", "河南省郑州市",
"861880785", "广西玉林市",
"861473113", "河北省石家庄市",
"861538731", "湖南省长沙市",
"861820722", "湖北省武汉市",
"861598622", "广东省茂名市",
"861333861", "江苏省南京市",
"861893762", "河南省郑州市",
"861370442", "吉林省吉林市",
"861506758", "浙江省金华市",
"861556931", "新疆昌吉回族自治州",
"861389478", "吉林省长春市",
"861599714", "湖北省黄石市",
"861570418", "辽宁省阜新市",
"861539989", "湖南省娄底市",
"861452448", "黑龙江省佳木斯市",
"861842719", "湖北省十堰市",
"861537088", "江苏省无锡市",
"861538242", "浙江省宁波市",
"861559645", "陕西省咸阳市",
"861857902", "江西省景德镇市",
"861708749", "湖南省邵阳市",
"86181471", "内蒙古呼和浩特市",
"86188677", "浙江省温州市",
"861479780", "江西省新余市",
"861344040", "辽宁省丹东市",
"861839293", "陕西省商洛市",
"861303978", "黑龙江省黑河市",
"861810744", "湖南省张家界市",
"861780322", "河北省保定市",
"861829307", "甘肃省平凉市",
"861334654", "广东省清远市",
"86180478", "内蒙古巴彦淖尔市",
"86159583", "浙江省嘉兴市",
"861510850", "贵州省贵阳市",
"861561916", "陕西省汉中市",
"861340422", "江苏省苏州市",
"861895106", "江苏省宿迁市",
"861378041", "河北省石家庄市",
"86185969", "福建省莆田市",
"861470906", "新疆阿勒泰地区",
"861366499", "广东省阳江市",
"861599299", "广东省韶关市",
"861500943", "甘肃省白银市",
"861869554", "宁夏中卫市",
"861390528", "江苏省镇江市",
"86139897", "浙江省温州市",
"861323568", "湖北省襄樊市",
"861322419", "辽宁省辽阳市",
"86155357", "山西省临汾市",
"861829544", "宁夏固原市",
"861860969", "安徽省阜阳市",
"861514903", "内蒙古兴安盟",
"861571312", "河北省保定市",
"861374020", "天津市",
"861774253", "湖南省长沙市",
"861321480", "内蒙古兴安盟",
"861819522", "宁夏银川市",
"861506064", "福建省泉州市",
"861817544", "安徽省铜陵市",
"861861747", "河北省保定市",
"861346977", "湖北省荆门市",
"861318727", "湖南省郴州市",
"861390531", "山东省济南市",
"86150623", "江苏省苏州市",
"861474136", "辽宁省营口市",
"861318824", "辽宁省本溪市",
"861532583", "浙江省嘉兴市",
"861458233", "安徽省淮南市",
"861308352", "江苏省苏州市",
"861700639", "山东省青岛市",
"86153797", "甘肃省张掖市",
"86181846", "海南省海口市",
"861821854", "广东省深圳市",
"861781431", "内蒙古呼和浩特市",
"861551377", "山西省晋中市",
"861304495", "江西省宜春市",
"861816607", "江西省赣州市",
"86182584", "浙江省杭州市",
"861384791", "内蒙古锡林郭勒盟",
"861370600", "福建省南平市",
"861476237", "江苏省泰州市",
"861588902", "西藏日喀则地区",
"861346820", "山东省临沂市",
"86186585", "浙江省绍兴市",
"861817496", "广西百色市",
"861521740", "广东省佛山市",
"861329087", "福建省漳州市",
"861876276", "江苏省宿迁市",
"861368852", "贵州省遵义市",
"861452560", "贵州省黔南布依族苗族自治州",
"861511972", "广东省茂名市",
"861819481", "新疆乌鲁木齐市",
"861328842", "广东省佛山市",
"861518217", "四川省成都市",
"86159755", "广东省广州市",
"861510133", "甘肃省兰州市",
"861707385", "河南省许昌市",
"861801344", "江苏省镇江市",
"861567903", "江西省鹰潭市",
"861530641", "山东省济南市",
"861508287", "四川省达州市",
"861809411", "福建省三明市",
"861760951", "宁夏银川市",
"86180535", "山东省烟台市",
"861315462", "四川省资阳市",
"861317087", "江西省南昌市",
"861840310", "河北省邯郸市",
"861374279", "江西省南昌市",
"861347781", "湖北省荆州市",
"861860258", "江苏省常州市",
"861566424", "河南省信阳市",
"861397242", "湖北省恩施土家族苗族自治州",
"861365642", "山东省青岛市",
"861569300", "甘肃省临夏回族自治州",
"861351592", "福建省莆田市",
"861864307", "吉林省长春市",
"861376840", "广西南宁市",
"861538728", "湖北省恩施土家族苗族自治州",
"861532306", "广东省惠州市",
"861339644", "山东省济南市",
"861348038", "广东省汕尾市",
"861337622", "江苏省无锡市",
"861804807", "四川省德阳市",
"861538511", "安徽省马鞍山市",
"861885036", "福建省福州市",
"861509800", "湖北省黄冈市",
"861363450", "黑龙江省哈尔滨市",
"86186771", "广西南宁市",
"861355070", "四川省宜宾市",
"861894810", "广东省茂名市",
"861380962", "广东省东莞市",
"861354892", "湖南省岳阳市",
"86182865", "贵州省黔东南苗族侗族自治州",
"86130247", "浙江省温州市",
"861554655", "黑龙江省绥化市",
"86131162", "云南省昆明市",
"86181183", "江苏省常州市",
"861873974", "河南省安阳市",
"86186864", "吉林省长春市",
"861821804", "广东省茂名市",
"861876393", "山东省德州市",
"861831966", "广东省梅州市",
"861308302", "安徽省宿州市",
"861815314", "贵州省遵义市",
"86139876", "云南省昆明市",
"86159383", "河南省商丘市",
"86186580", "浙江省舟山市",
"861303054", "江西省吉安市",
"861557809", "广西南宁市",
"861370650", "浙江省杭州市",
"861805384", "山东省泰安市",
"86182458", "黑龙江省绥化市",
"86159750", "广东省江门市",
"861800522", "江苏省徐州市",
"861771272", "江苏省宿迁市",
"86178783", "广西玉林市",
"861525780", "浙江省丽水市",
"861399781", "湖北省十堰市",
"861818992", "西藏日喀则地区",
"861553539", "山西省太原市",
"861322592", "福建省厦门市",
"861566548", "安徽省宿州市",
"86180530", "山东省菏泽市",
"861760590", "福建省福州市",
"861539021", "四川省乐山市",
"861760901", "新疆塔城地区",
"861860779", "广西北海市",
"861890913", "陕西省渭南市",
"861319037", "辽宁省葫芦岛市",
"861390596", "福建省泉州市",
"86152621", "江苏省徐州市",
"861860208", "广东省东莞市",
"86183619", "江苏省苏州市",
"86156229", "广东省东莞市",
"861316061", "广东省潮州市",
"861816073", "江西省上饶市",
"861590784", "广西桂林市",
"861532356", "广东省肇庆市",
"861560862", "湖北省武汉市",
"861530919", "陕西省铜川市",
"861559777", "贵州省黔南布依族苗族自治州",
"861472685", "四川省广元市",
"861476888", "山东省滨州市",
"861325568", "山东省济南市",
"861867579", "广东省阳江市",
"861536851", "云南省文山壮族苗族自治州",
"861379222", "山东省德州市",
"861339875", "云南省保山市",
"861705263", "吉林省长春市",
"861327037", "江苏省常州市",
"861565136", "江苏省宿迁市",
"861341115", "广东省广州市",
"86155557", "安徽省宿州市",
"861500362", "青海省海东地区",
"861361682", "浙江省温州市",
"861769835", "河南省周口市",
"86188696", "云南省楚雄彝族自治州",
"861809744", "青海省西宁市",
"861770565", "安徽省合肥市",
"86182860", "贵州省贵阳市",
"86135870", "浙江省舟山市",
"861875898", "浙江省衢州市",
"861324429", "吉林省松原市",
"861881185", "广东省清远市",
"861874749", "内蒙古乌兰察布市",
"861319578", "青海省西宁市",
"861830952", "宁夏石嘴山市",
"861505543", "安徽省淮南市",
"86177878", "云南省楚雄彝族自治州",
"861773647", "河北省沧州市",
"861338445", "吉林省通化市",
"861343270", "广东省清远市",
"861315433", "吉林省延边朝鲜族自治州",
"861360491", "辽宁省鞍山市",
"86130959", "浙江省宁波市",
"861520313", "河北省张家口市",
"861564930", "河南省郑州市",
"861776737", "浙江省温州市",
"861347735", "湖北省荆门市",
"861509706", "甘肃省平凉市",
"861869937", "新疆阿克苏地区",
"861458262", "安徽省马鞍山市",
"86155756", "湖南省郴州市",
"861593144", "河北省石家庄市",
"861890572", "浙江省湖州市",
"861336984", "新疆克孜勒苏柯尔克孜自治州",
"861572779", "江西省萍乡市",
"861526633", "山东省日照市",
"861344083", "广西南宁市",
"861393996", "河南省平顶山市",
"861323597", "福建省龙岩市",
"861840478", "内蒙古巴彦淖尔市",
"861812251", "广东省河源市",
"861479743", "山西省吕梁市",
"861550939", "甘肃省陇南市",
"861844729", "内蒙古锡林郭勒盟",
"861479372", "甘肃省定西市",
"861380933", "甘肃省平凉市",
"861763501", "山西省忻州市",
"861500980", "辽宁省锦州市",
"861819435", "甘肃省天水市",
"861510910", "陕西省咸阳市",
"861309069", "内蒙古呼和浩特市",
"861536036", "广东省云浮市",
"86187029", "陕西省西安市",
"861454288", "辽宁省盘锦市",
"861390585", "浙江省绍兴市",
"861843846", "河南省平顶山市",
"861559998", "新疆喀什地区",
"861899940", "新疆乌鲁木齐市",
"861569494", "河北省承德市",
"861537349", "河北省唐山市",
"86186509", "福建省三明市",
"861594947", "内蒙古呼和浩特市",
"861889422", "甘肃省定西市",
"861318102", "山东省滨州市",
"861805114", "江苏省泰州市",
"86155076", "广东省中山市",
"861535492", "内蒙古鄂尔多斯市",
"861337871", "云南省昆明市",
"861831927", "广东省湛江市",
"861361453", "黑龙江省牡丹江市",
"86185732", "湖南省湘潭市",
"86181272", "广东省清远市",
"861320778", "广西河池市",
"861340535", "山东省烟台市",
"861830902", "新疆哈密地区",
"861320259", "广东省揭阳市",
"861475556", "安徽省马鞍山市",
"861356879", "四川省阿坝藏族羌族自治州",
"861707396", "河南省驻马店市",
"861870574", "浙江省宁波市",
"861835697", "安徽省芜湖市",
"86135875", "浙江省温州市",
"861860147", "江苏省无锡市",
"861884620", "黑龙江省齐齐哈尔市",
"861348577", "安徽省滁州市",
"861581220", "云南省大理白族自治州",
"86170836", "河南省洛阳市",
"861556341", "山东省莱芜市",
"861804097", "新疆阿克苏地区",
"861851576", "四川省德阳市",
"861454837", "广东省阳江市",
"861470816", "四川省眉山市",
"861314416", "广东省肇庆市",
"861812201", "广东省广州市",
"86145054", "黑龙江省哈尔滨市",
"861534374", "河南省许昌市",
"86176886", "广东省东莞市",
"861816419", "湖北省十堰市",
"861304486", "湖北省恩施土家族苗族自治州",
"861362775", "广西玉林市",
"861550088", "宁夏银川市",
"861885145", "江苏省宿迁市",
"861454514", "湖南省岳阳市",
"86157251", "山东省济南市",
"861857812", "广东省湛江市",
"86186391", "河南省焦作市",
"861705232", "重庆市",
"86181515", "江苏省无锡市",
"86153596", "福建省泉州市",
"861880728", "湖北省十堰市",
"861309274", "湖北省黄冈市",
"861363394", "河南省周口市",
"861399735", "青海省西宁市",
"861808203", "江苏省连云港市",
"861380380", "河南省新乡市",
"861329472", "内蒙古包头市",
"861500333", "河北省张家口市",
"861811144", "四川省乐山市",
"861474045", "辽宁省葫芦岛市",
"861771361", "四川省成都市",
"86158519", "江苏省常州市",
"861452173", "吉林省白城市",
"861528074", "福建省三明市",
"861559149", "陕西省安康市",
"861389143", "陕西省西安市",
"861354240", "广东省云浮市",
"861760447", "吉林省辽源市",
"861317472", "浙江省嘉兴市",
"861821122", "广东省广州市",
"861880511", "江苏省盐城市",
"86139242", "广东省广州市",
"86183912", "陕西省榆林市",
"86145861", "湖北省仙桃市",
"861318152", "山东省烟台市",
"861806415", "湖北省鄂州市",
"861360425", "辽宁省大连市",
"861870755", "广东省深圳市",
"861314763", "吉林省吉林市",
"861848356", "四川省雅安市",
"861343874", "四川省乐山市",
"861807489", "广西河池市",
"861530931", "甘肃省兰州市",
"861859178", "陕西省西安市",
"861312522", "江西省九江市",
"861817419", "广西桂林市",
"861568872", "山东省威海市",
"86139757", "湖南省郴州市",
"861361770", "广西防城港市",
"86135269", "河南省洛阳市",
"861846940", "云南省楚雄彝族自治州",
"861505908", "福建省龙岩市",
"861561019", "山东省潍坊市",
"861700949", "重庆市",
"861362554", "安徽省淮南市",
"861322544", "山东省德州市",
"861351357", "山西省临汾市",
"861883088", "河北省邯郸市",
"861818944", "甘肃省白银市",
"86177558", "安徽省阜阳市",
"861354675", "山西省长治市",
"86150245", "浙江省金华市",
"86186893", "广东省中山市",
"861350322", "河北省保定市",
"861332293", "广东省深圳市",
"861858668", "贵州省安顺市",
"861473683", "云南省楚雄彝族自治州",
"861470009", "福建省厦门市",
"861339934", "甘肃省庆阳市",
"861359707", "广西南宁市",
"861313566", "湖北省武汉市",
"861529683", "广西玉林市",
"861310927", "陕西省安康市",
"861349", "北京市",
"861398911", "四川省内江市",
"861868769", "云南省文山壮族苗族自治州",
"861882478", "广东省湛江市",
"861809792", "新疆哈密地区",
"861453464", "黑龙江省七台河市",
"861308597", "甘肃省天水市",
"861525672", "安徽省淮南市",
"861365932", "甘肃省兰州市",
"861364255", "广东省清远市",
"861894463", "黑龙江省哈尔滨市",
"861398649", "湖北省孝感市",
"861346735", "湖南省郴州市",
"861853047", "河南省焦作市",
"86155656", "河南省南阳市",
"861870705", "江西省宜春市",
"861871609", "河北省唐山市",
"861570429", "辽宁省葫芦岛市",
"861536025", "广东省河源市",
"861324245", "广东省佛山市",
"861882180", "湖南省衡阳市",
"861311902", "新疆哈密地区",
"861459617", "甘肃省庆阳市",
"86188597", "福建省泉州市",
"861764048", "辽宁省营口市",
"861771387", "四川省广安市",
"861328894", "广东省韶关市",
"861452289", "山西省朔州市",
"861570670", "浙江省嘉兴市",
"861538539", "安徽省池州市",
"861707628", "山东省济宁市",
"861700198", "广东省广州市",
"86133790", "陕西省西安市",
"861315071", "云南省昆明市",
"861351307", "河北省唐山市",
"861815063", "福建省福州市",
"861506140", "江苏省连云港市",
"861555242", "山东省淄博市",
"861539141", "云南省文山壮族苗族自治州",
"86133411", "北京市",
"861351544", "山东省德州市",
"861322428", "辽宁省大连市",
"861700611", "江苏省南京市",
"861322357", "山西省临汾市",
"861362347", "山西省太原市",
"861397294", "湖北省武汉市",
"861365694", "福建省宁德市",
"861536349", "广东省惠州市",
"86150240", "广东省东莞市",
"861872748", "湖北省孝感市",
"861327065", "湖南省郴州市",
"861330144", "江苏省扬州市",
"861898533", "贵州省铜仁地区",
"861530996", "新疆巴音郭楞蒙古自治州",
"861877505", "广西桂林市",
"861800498", "辽宁省阜新市",
"861848583", "贵州省毕节地区",
"861339692", "浙江省台州市",
"861336871", "云南省昆明市",
"861770537", "山东省济宁市",
"86185632", "山东省枣庄市",
"86132169", "浙江省台州市",
"86135555", "黑龙江省大庆市",
"861892260", "广东省清远市",
"861319065", "内蒙古乌兰察布市",
"861302847", "陕西省宝鸡市",
"861332376", "河南省信阳市",
"861370546", "山东省东营市",
"861369370", "河南省商丘市",
"86158862", "吉林省吉林市",
"86188376", "河南省信阳市",
"861809439", "江苏省南通市",
"861354844", "四川省绵阳市",
"861306968", "黑龙江省齐齐哈尔市",
"861535528", "浙江省台州市",
"86159650", "山东省潍坊市",
"861862429", "辽宁省葫芦岛市",
"861776765", "新疆巴音郭楞蒙古自治州",
"86187466", "黑龙江省大庆市",
"86159881", "浙江省杭州市",
"861334304", "河北省石家庄市",
"861476510", "天津市",
"861586406", "山东省烟台市",
"861527558", "山东省临沂市",
"861869647", "湖北省武汉市",
"861889598", "云南省曲靖市",
"861821250", "贵州省铜仁地区",
"861373946", "四川省成都市",
"861518530", "贵州省遵义市",
"861894799", "内蒙古锡林郭勒盟",
"861862670", "吉林省长春市",
"861533596", "湖北省十堰市",
"861537145", "江苏省苏州市",
"861769826", "河南省平顶山市",
"86133438", "河南省郑州市",
"861773937", "河南省濮阳市",
"861535711", "安徽省滁州市",
"86180365", "江苏省淮安市",
"861565125", "江苏省连云港市",
"861880539", "山东省临沂市",
"861558519", "贵州省黔南布依族苗族自治州",
"861335238", "辽宁省盘锦市",
"861314241", "内蒙古包头市",
"861333784", "江苏省宿迁市",
"861519558", "江苏省扬州市",
"861459409", "云南省昭通市",
"861879501", "宁夏银川市",
"861560748", "湖南省长沙市",
"861331847", "广东省珠海市",
"861866579", "广东省湛江市",
"861363342", "山西省大同市",
"861537851", "四川省凉山彝族自治州",
"861534793", "江西省上饶市",
"861341189", "广东省深圳市",
"861898658", "湖北省黄石市",
"861323352", "山西省大同市",
"861881389", "广东省肇庆市",
"861479287", "安徽省亳州市",
"861517402", "辽宁省本溪市",
"861301376", "江苏省苏州市",
"861520758", "广东省肇庆市",
"86151921", "山东省聊城市",
"86150928", "山东省泰安市",
"861865971", "福建省泉州市",
"861365963", "广西桂林市",
"86170037", "河南省郑州市",
"86135413", "四川省成都市",
"86188796", "江西省吉安市",
"861595060", "江苏省宿迁市",
"861329061", "河北省石家庄市",
"861891237", "江苏省无锡市",
"861563318", "河北省衡水市",
"861364576", "浙江省台州市",
"861829073", "新疆石河子市",
"861361876", "云南省文山壮族苗族自治州",
"861529402", "甘肃省张掖市",
"86152721", "湖北省宜昌市",
"86133083", "重庆市",
"861303842", "陕西省渭南市",
"861513888", "河南省安阳市",
"86183062", "江苏省苏州市",
"861557016", "江西省新余市",
"861472619", "四川省成都市",
"86183719", "湖北省十堰市",
"861358286", "河北省承德市",
"861508261", "四川省宜宾市",
"861317061", "云南省昆明市",
"861530985", "辽宁省沈阳市",
"86189024", "广东省深圳市",
"861380643", "山东省淄博市",
"86132808", "山东省青岛市",
"861550649", "山东省烟台市",
"861334547", "新疆克拉玛依市",
"861816431", "安徽省亳州市",
"861477888", "广东省深圳市",
"861334354", "湖北省宜昌市",
"861877276", "湖北省十堰市",
"861707319", "河北省石家庄市",
"861454865", "河南省焦作市",
"861550911", "陕西省延安市",
"861306017", "四川省绵阳市",
"861310966", "陕西省宝鸡市",
"861821200", "贵州省贵阳市",
"86133375", "海南省海口市",
"86130752", "广东省惠州市",
"861586456", "山东省潍坊市",
"861309776", "广西百色市",
"861313527", "湖南省永州市",
"861837410", "湖南省娄底市",
"861803684", "江苏省宿迁市",
"861889789", "广西柳州市",
"86134249", "广东省江门市",
"861815032", "福建省龙岩市",
"86150723", "湖北省武汉市",
"861593192", "河北省唐山市",
"861894588", "黑龙江省伊春市",
"861459459", "陕西省汉中市",
"861768193", "浙江省金华市",
"861598322", "四川省资阳市",
"861817607", "广西北海市",
"861328768", "山东省潍坊市",
"861847630", "广东省湛江市",
"86180360", "江苏省无锡市",
"86155877", "湖北省襄樊市",
"861520708", "江西省景德镇市",
"86186671", "浙江省杭州市",
"861537801", "甘肃省武威市",
"86130072", "江西省南昌市",
"86177991", "新疆乌鲁木齐市",
"861555785", "浙江省宁波市",
"861571612", "江苏省常州市",
"86139556", "安徽省安庆市",
"861811024", "安徽省蚌埠市",
"861518906", "江苏省宿迁市",
"861533531", "山东省济南市",
"86153145", "浙江省宁波市",
"861301293", "山东省济宁市",
"861450272", "内蒙古包头市",
"861399767", "湖北省宜昌市",
"861335887", "辽宁省沈阳市",
"861377840", "四川省德阳市",
"861345149", "河北省石家庄市",
"861845247", "江苏省泰州市",
"861475640", "河北省邯郸市",
"861324782", "江西省九江市",
"861572066", "江苏省苏州市",
"861535444", "河北省石家庄市",
"861372278", "河北省石家庄市",
"861856902", "湖南省衡阳市",
"861333238", "辽宁省盘锦市",
"861476051", "宁夏银川市",
"86151028", "四川省成都市",
"861459161", "广西南宁市",
"86188777", "广西钦州市",
"861458104", "安徽省亳州市",
"861522003", "广东省广州市",
"861330879", "云南省普洱市",
"861365773", "广西桂林市",
"861889526", "宁夏中卫市",
"861335784", "江苏省宿迁市",
"861306997", "黑龙江省齐齐哈尔市",
"861369782", "山东省东营市",
"861760839", "四川省广元市",
"86150021", "上海市",
"861396511", "安徽省合肥市",
"861530341", "山西省太原市",
"861572571", "山东省菏泽市",
"861339507", "福建省厦门市",
"861893848", "广东省茂名市",
"861871841", "广东省广州市",
"86189942", "江苏省南通市",
"861370300", "广东省珠海市",
"861386130", "江苏省苏州市",
"861830430", "吉林省长春市",
"861816307", "湖北省宜昌市",
"86186653", "广东省深圳市",
"861770954", "宁夏固原市",
"861585678", "安徽省阜阳市",
"861896380", "新疆乌鲁木齐市",
"861575194", "甘肃省兰州市",
"861533528", "江苏省苏州市",
"861354179", "四川省巴中市",
"861700339", "河北省邯郸市",
"861539915", "陕西省安康市",
"861800467", "黑龙江省鸡西市",
"861308652", "四川省内江市",
"86182835", "四川省雅安市",
"861525287", "江苏省宿迁市",
"861890476", "内蒙古赤峰市",
"861848540", "贵州省黔南布依族苗族自治州",
"86131132", "广东省东莞市",
"861458671", "湖南省娄底市",
"861776975", "浙江省金华市",
"861454449", "江西省萍乡市",
"861305842", "广东省广州市",
"861869775", "河南省焦作市",
"861844718", "内蒙古巴彦淖尔市",
"861590861", "湖北省武汉市",
"861363963", "河南省新乡市",
"861863971", "河南省许昌市",
"86180884", "云南省昆明市",
"861582514", "云南省玉溪市",
"861500558", "安徽省阜阳市",
"861337322", "河北省保定市",
"861859443", "福建省宁德市",
"861339344", "山西省晋中市",
"861844521", "黑龙江省齐齐哈尔市",
"861365342", "山西省大同市",
"861331411", "辽宁省大连市",
"861322485", "内蒙古包头市",
"861474318", "吉林省松原市",
"86177098", "辽宁省大连市",
"86180560", "安徽省合肥市",
"861861375", "河南省平顶山市",
"86553", "安徽省芜湖市",
"861476001", "福建省厦门市",
"861351485", "内蒙古通辽市",
"861339557", "安徽省宿州市",
"861806248", "湖北省随州市",
"861317576", "浙江省丽水市",
"861308568", "浙江省绍兴市",
"861804575", "黑龙江省鸡西市",
"86131972", "湖北省十堰市",
"861378399", "河南省开封市",
"861371986", "广东省阳江市",
"861771405", "江苏省苏州市",
"86183400", "山东省济南市",
"86133575", "浙江省绍兴市",
"861896933", "浙江省嘉兴市",
"861312435", "吉林省通化市",
"861816357", "湖北省襄樊市",
"861772342", "四川省达州市",
"861875881", "浙江省宁波市",
"861370350", "山西省朔州市",
"861350984", "广东省东莞市",
"861399977", "新疆博尔塔拉蒙古自治州",
"861360488", "黑龙江省哈尔滨市",
"861802069", "福建省漳州市",
"861850378", "河南省开封市",
"861331744", "湖南省张家界市",
"861360532", "山东省青岛市",
"861329576", "浙江省台州市",
"861846983", "云南省玉溪市",
"861473640", "云南省曲靖市",
"861362937", "甘肃省酒泉市",
"861536939", "河北省石家庄市",
"861843247", "河北省沧州市",
"861559981", "新疆昌吉回族自治州",
"861333887", "江苏省泰州市",
"861309966", "云南省普洱市",
"861554305", "吉林省吉林市",
"861318079", "吉林省长春市",
"86182830", "四川省泸州市",
"861454291", "辽宁省铁岭市",
"861533444", "云南省曲靖市",
"861310776", "浙江省温州市",
"861772773", "广东省东莞市",
"861558739", "山东省济宁市",
"861319251", "广东省汕尾市",
"861304438", "吉林省松原市",
"86152023", "重庆市",
"86177714", "湖北省武汉市",
"86155896", "山东省潍坊市",
"86132052", "江苏省无锡市",
"861359122", "辽宁省鞍山市",
"861345018", "广东省肇庆市",
"86139356", "山西省晋城市",
"861532656", "黑龙江省双鸭山市",
"861357144", "陕西省安康市",
"86184742", "湖南省长沙市",
"861398145", "四川省达州市",
"861311812", "四川省德阳市",
"861521247", "安徽省宿州市",
"861399798", "湖北省武汉市",
"861370494", "辽宁省大连市",
"861383427", "山西省阳泉市",
"861531545", "山东省烟台市",
"861580752", "广东省惠州市",
"861550145", "江苏省苏州市",
"861894525", "黑龙江省大庆市",
"861503908", "河南省郑州市",
"861322431", "吉林省长春市",
"861359854", "河南省焦作市",
"861538294", "广东省汕头市",
"861373336", "河北省保定市",
"861302744", "湖南省湘潭市",
"86132392", "陕西省榆林市",
"861810792", "江西省九江市",
"861886596", "山东省东营市",
"861812037", "湖北省神农架林区",
"861351496", "安徽省合肥市",
"861390739", "湖南省邵阳市",
"861520613", "江苏省苏州市",
"861398036", "四川省眉山市",
"861768701", "云南省昭通市",
"861842000", "广东省湛江市",
"861825253", "江苏省扬州市",
"861534845", "湖南省怀化市",
"861770717", "湖北省宜昌市",
"861309927", "甘肃省白银市",
"861865243", "江苏省苏州市",
"861371995", "广东省梅州市",
"861345874", "四川省宜宾市",
"861554593", "黑龙江省鹤岗市",
"861338070", "广东省清远市",
"861804256", "浙江省金华市",
"861538719", "湖北省黄冈市",
"86135783", "云南省丽江市",
"861332882", "福建省莆田市",
"861317255", "广东省潮州市",
"861598984", "广东省汕头市",
"861508055", "福建省三明市",
"86185762", "广东省中山市",
"861315566", "安徽省池州市",
"861768030", "湖南省岳阳市",
"861557985", "江西省赣州市",
"861314973", "辽宁省锦州市",
"86183159", "山东省德州市",
"861537649", "山东省滨州市",
"861328797", "山东省烟台市",
"86183489", "河北省保定市",
"861550851", "贵州省贵阳市",
"861528543", "贵州省铜仁地区",
"861346515", "山东省德州市",
"8615222", "天津市",
"86159890", "广东省广州市",
"861347589", "山东省聊城市",
"861348805", "陕西省汉中市",
"861596445", "山东省枣庄市",
"861476891", "山东省青岛市",
"861820489", "内蒙古呼和浩特市",
"861579491", "福建省福州市",
"86138406", "辽宁省锦州市",
"86177358", "山西省吕梁市",
"861707631", "山东省济宁市",
"861518816", "云南省玉溪市",
"861819498", "新疆和田地区",
"861399589", "湖北省孝感市",
"861534674", "甘肃省庆阳市",
"861580702", "江西省九江市",
"861831274", "广东省揭阳市",
"861310870", "云南省昆明市",
"861860571", "浙江省杭州市",
"861360563", "安徽省宣城市",
"861842050", "广东省汕头市",
"861768751", "广西南宁市",
"861390492", "辽宁省鞍山市",
"861318413", "山东省青岛市",
"86188397", "河南省安阳市",
"86170866", "山东省烟台市",
"861556641", "辽宁省大连市",
"861810439", "吉林省白山市",
"861300065", "山东省潍坊市",
"86131679", "重庆市",
"861308483", "陕西省榆林市",
"861561999", "陕西省商洛市",
"861535585", "浙江省绍兴市",
"86130112", "北京市",
"861850410", "辽宁省铁岭市",
"86135988", "河南省郑州市",
"861588430", "四川省眉山市",
"861832644", "安徽省宣城市",
"86188576", "浙江省台州市",
"861305290", "江苏省镇江市",
"861800426", "辽宁省大连市",
"86153857", "安徽省宿州市",
"861477825", "广东省肇庆市",
"861804206", "浙江省宁波市",
"861776230", "湖北省宜昌市",
"861767909", "江西省上饶市",
"861771661", "贵州省六盘水市",
"861373391", "河南省平顶山市",
"861471643", "广东省广州市",
"861348855", "内蒙古通辽市",
"861886531", "山东省济南市",
"86159895", "广东省深圳市",
"861351431", "吉林省长春市",
"861500633", "山东省日照市",
"861347798", "湖北省十堰市",
"861334961", "湖南省怀化市",
"861377918", "新疆哈密地区",
"86134767", "湖北省黄冈市",
"861364378", "河南省开封市",
"861868365", "四川省绵阳市",
"861854532", "黑龙江省鹤岗市",
"861588776", "云南省楚雄彝族自治州",
"861843140", "河北省邯郸市",
"861510733", "湖南省株洲市",
"861773679", "河北省沧州市",
"861577942", "江西省九江市",
"861383340", "河北省承德市",
"86186490", "天津市",
"861337592", "福建省厦门市",
"861340941", "河南省商丘市",
"86663", "广东省揭阳市",
"86155645", "山东省烟台市",
"861304878", "河北省石家庄市",
"861399046", "四川省甘孜藏族自治州",
"86131489", "广东省广州市",
"861572747", "湖南省株洲市",
"861532943", "贵州省安顺市",
"861773420", "河北省邯郸市",
"86147049", "广东省广州市",
"86177563", "安徽省宣城市",
"861889396", "甘肃省张掖市",
"861584642", "黑龙江省双鸭山市",
"861534559", "安徽省黄山市",
"861313406", "江西省吉安市",
"86130669", "广东省深圳市",
"861311069", "福建省莆田市",
"861807094", "广西南宁市",
"861801435", "江苏省南通市",
"861453504", "山东省德州市",
"861535326", "陕西省安康市",
"861555119", "安徽省合肥市",
"861537377", "河北省邯郸市",
"86155197", "贵州省毕节地区",
"861302060", "山东省东营市",
"861594979", "山东省泰安市",
"861800934", "甘肃省庆阳市",
"861852415", "辽宁省丹东市",
"861538128", "浙江省湖州市",
"861321968", "四川省乐山市",
"861507846", "广西柳州市",
"861477803", "广东省汕尾市",
"861330792", "江西省九江市",
"86145358", "福建省福州市",
"861890891", "西藏拉萨市",
"861882672", "广东省阳江市",
"861566039", "新疆克孜勒苏柯尔克孜自治州",
"861872916", "陕西省汉中市",
"861533398", "河南省三门峡市",
"861870359", "山西省运城市",
"861470962", "宁夏石嘴山市",
"861344266", "安徽省阜阳市",
"861889331", "甘肃省平凉市",
"861533635", "山东省聊城市",
"861569015", "河北省廊坊市",
"861556484", "山东省泰安市",
"861356847", "四川省巴中市",
"861700260", "广东省东莞市",
"861352968", "云南省红河哈尼族彝族自治州",
"861598419", "四川省自贡市",
"861362464", "黑龙江省七台河市",
"861777165", "湖北省恩施土家族苗族自治州",
"86186282", "四川省成都市",
"861378843", "广西桂林市",
"861348549", "山西省晋中市",
"861397196", "湖北省孝感市",
"86132039", "河南省焦作市",
"86145980", "湖北省十堰市",
"861840886", "云南省怒江傈僳族自治州",
"861707422", "浙江省杭州市",
"861538689", "山西省运城市",
"861576663", "广东省湛江市",
"861820914", "陕西省商洛市",
"861536745", "湖南省怀化市",
"86180232", "广东省汕头市",
"861599922", "新疆阿克苏地区",
"861842048", "广东省河源市",
"861589440", "云南省德宏傣族景颇族自治州",
"861760620", "山东省日照市",
"861355992", "福建省福州市",
"86138828", "四川省达州市",
"861586527", "山东省济南市",
"861807122", "湖北省黄冈市",
"861313456", "黑龙江省黑河市",
"861534509", "福建省龙岩市",
"861520783", "广西桂林市",
"861303168", "山东省潍坊市",
"861322622", "广东省湛江市",
"861898683", "湖北省宜昌市",
"861571370", "河南省商丘市",
"861378529", "河北省张家口市",
"861340619", "山东省滨州市",
"861348823", "陕西省西安市",
"861453554", "安徽省马鞍山市",
"861830870", "云南省昭通市",
"861770687", "浙江省温州市",
"861800692", "福建省福州市",
"861333063", "四川省遂宁市",
"861339498", "新疆阿克苏地区",
"861892198", "江苏省苏州市",
"86150256", "重庆市",
"861760479", "内蒙古锡林郭勒盟",
"861889273", "四川省广安市",
"86183679", "浙江省金华市",
"861513853", "河南省濮阳市",
"861870309", "新疆石河子市",
"861330439", "吉林省长春市",
"861524995", "安徽省阜阳市",
"861474791", "内蒙古锡林郭勒盟",
"861477853", "广东省惠州市",
"861346339", "河北省秦皇岛市",
"861894386", "吉林省吉林市",
"861381343", "江苏省盐城市",
"861705805", "上海市",
"86159434", "吉林省四平市",
"861855102", "江苏省连云港市",
"861551349", "山西省运城市",
"861840895", "西藏昌都地区",
"861397185", "湖北省荆门市",
"861368281", "广东省揭阳市",
"861572179", "贵州省黔西南布依族苗族自治州",
"861890051", "安徽省合肥市",
"861336544", "山东省德州市",
"861364410", "辽宁省铁岭市",
"861590314", "河北省承德市",
"861459569", "陕西省延安市",
"861776137", "四川省自贡市",
"861509106", "陕西省咸阳市",
"86184821", "四川省成都市",
"861450954", "江苏省连云港市",
"861596634", "山东省济南市",
"861854563", "黑龙江省哈尔滨市",
"861811411", "江苏省无锡市",
"86159646", "山东省菏泽市",
"861855976", "福建省厦门市",
"86136926", "广东省茂名市",
"861880689", "浙江省金华市",
"861598607", "广东省佛山市",
"861820707", "江西省赣州市",
"861852722", "湖北省荆门市",
"86189237", "广东省深圳市",
"861510762", "广东省河源市",
"861586566", "山东省菏泽市",
"861313368", "江西省吉安市",
"861380816", "四川省眉山市",
"861390667", "浙江省温州市",
"861898452", "贵州省安顺市",
"861579876", "云南省文山壮族苗族自治州",
"861471530", "广东省江门市",
"861558626", "湖北省武汉市",
"86181212", "上海市",
"861819507", "宁夏中卫市",
"861323627", "江苏省盐城市",
"86153156", "山东省菏泽市",
"86187848", "四川省达州市",
"86155016", "江苏省苏州市",
"86186933", "甘肃省平凉市",
"861897172", "湖北省黄冈市",
"861575228", "云南省红河哈尼族彝族自治州",
"861594587", "黑龙江省佳木斯市",
"861708874", "广东省江门市",
"861899580", "湖北省黄石市",
"861778671", "湖北省随州市",
"861775175", "江苏省南京市",
"861390945", "甘肃省武威市",
"861813238", "河北省保定市",
"861810879", "云南省普洱市",
"861806042", "福建省宁德市",
"861517562", "河北省唐山市",
"86180983", "安徽省滁州市",
"861391444", "江苏省泰州市",
"861580413", "辽宁省抚顺市",
"861780544", "山东省德州市",
"861379473", "广东省河源市",
"861350419", "辽宁省辽阳市",
"861338334", "河北省唐山市",
"861879461", "甘肃省平凉市",
"86181570", "浙江省衢州市",
"861500540", "山东省菏泽市",
"861340407", "四川省眉山市",
"86139545", "山东省烟台市",
"86153486", "贵州省遵义市",
"861768374", "湖北省荆州市",
"861310430", "吉林省长春市",
"861805441", "山东省潍坊市",
"861778154", "四川省成都市",
"861576632", "广东省揭阳市",
"861777474", "广西梧州市",
"86181781", "广西南宁市",
"861477093", "江西省赣州市",
"861893800", "广东省汕头市",
"86180788", "广东省广州市",
"861780428", "辽宁省丹东市",
"861509156", "陕西省商洛市",
"861830776", "广西百色市",
"861347311", "河北省石家庄市",
"861780357", "山西省临汾市",
"86153317", "云南省昆明市",
"861887111", "湖北省鄂州市",
"861519468", "河南省驻马店市",
"86186173", "广东省广州市",
"861700515", "江苏省盐城市",
"86182981", "安徽省阜阳市",
"861320480", "内蒙古呼和浩特市",
"861895133", "江苏省南通市",
"861452342", "河南省洛阳市",
"861591238", "云南省玉溪市",
"861570312", "河北省保定市",
"861470933", "甘肃省兰州市",
"861831812", "广东省湛江市",
"861874998", "河南省驻马店市",
"861332578", "浙江省丽水市",
"861370348", "河南省濮阳市",
"86135815", "北京市",
"861860747", "湖南省衡阳市",
"861573742", "河南省濮阳市",
"861555389", "山东省东营市",
"861820757", "广东省佛山市",
"861847580", "广东省清远市",
"86186738", "湖南省娄底市",
"861815221", "甘肃省定西市",
"86134566", "浙江省台州市",
"86183972", "湖南省郴州市",
"861535139", "四川省资阳市",
"861331060", "山东省德州市",
"86131400", "河南省郑州市",
"861318752", "云南省保山市",
"86145714", "上海市",
"861881890", "广东省广州市",
"861571418", "辽宁省阜新市",
"861301037", "浙江省宁波市",
"86158579", "浙江省金华市",
"861326376", "广西梧州市",
"861452773", "广西桂林市",
"861502859", "河北省秦皇岛市",
"86136419", "上海市",
"861322871", "江苏省宿迁市",
"861533681", "浙江省舟山市",
"861889385", "甘肃省白银市",
"861368724", "湖北省武汉市",
"8613268", "广东省东莞市",
"861867547", "广东省肇庆市",
"861560916", "陕西省汉中市",
"861336357", "山西省临汾市",
"86139540", "山东省菏泽市",
"861598073", "福建省福州市",
"861336428", "辽宁省丹东市",
"861372305", "河南省驻马店市",
"861369612", "四川省乐山市",
"861340457", "吉林省松原市",
"861890730", "湖南省岳阳市",
"861340328", "河北省衡水市",
"861368970", "吉林省延边朝鲜族自治州",
"86181575", "浙江省绍兴市",
"861565153", "江苏省宿迁市",
"861821248", "贵州省铜仁地区",
"86132919", "浙江省宁波市",
"861346611", "云南省曲靖市",
"861567550", "安徽省滁州市",
"861527540", "山东省菏泽市",
"861866604", "广东省汕尾市",
"861809879", "安徽省淮北市",
"861372072", "陕西省西安市",
"861525143", "江苏省无锡市",
"86136700", "广东省深圳市",
"861800507", "福建省泉州市",
"861707535", "山东省烟台市",
"861890510", "江苏省盐城市",
"861760993", "新疆石河子市",
"861368827", "四川省资阳市",
"861453937", "广东省湛江市",
"861519540", "江苏省淮安市",
"861558111", "湖南省常德市",
"86877", "云南省玉溪市",
"861869379", "甘肃省兰州市",
"861589483", "内蒙古鄂尔多斯市",
"861336431", "吉林省长春市",
"861303197", "河北省张家口市",
"861803299", "河北省邢台市",
"861309430", "云南省玉溪市",
"861340331", "河北省石家庄市",
"861874018", "辽宁省阜新市",
"861555615", "安徽省亳州市",
"86181083", "重庆市",
"861308327", "安徽省蚌埠市",
"861568214", "四川省成都市",
"861392269", "广东省汕尾市",
"861339467", "黑龙江省鸡西市",
"861571782", "湖北省荆门市",
"861826875", "浙江省绍兴市",
"86131062", "浙江省金华市",
"861308458", "河北省张家口市",
"861318166", "山东省潍坊市",
"86186481", "内蒙古赤峰市",
"861820854", "贵州省黔南布依族苗族自治州",
"861780431", "吉林省长春市",
"861475562", "安徽省合肥市",
"861550377", "河南省南阳市",
"861373482", "内蒙古兴安盟",
"86181370", "河南省商丘市",
"861802176", "江苏省徐州市",
"861327676", "浙江省台州市",
"86139345", "山西省太原市",
"861523310", "河北省邯郸市",
"861860844", "湖南省张家界市",
"861379207", "山东省东营市",
"861520740", "湖南省株洲市",
"861532271", "广东省潮州市",
"861898640", "湖北省鄂州市",
"861341581", "广东省茂名市",
"861892339", "广东省珠海市",
"8618621", "上海市",
"861800344", "山西省晋中市",
"86159930", "河南省新乡市",
"861454134", "河北省承德市",
"861475608", "河北省廊坊市",
"861337657", "广东省肇庆市",
"861510972", "青海省海东地区",
"861568799", "云南省普洱市",
"861458206", "安徽省黄山市",
"861815238", "宁夏中卫市",
"86180431", "吉林省长春市",
"861509762", "河北省廊坊市",
"861834732", "内蒙古鄂尔多斯市",
"861394831", "内蒙古呼和浩特市",
"861762521", "江苏省南通市",
"861352997", "云南省玉溪市",
"861591221", "云南省丽江市",
"86186151", "山东省淄博市",
"861553389", "河北省唐山市",
"861386825", "浙江省湖州市",
"861886635", "山东省聊城市",
"861882838", "四川省乐山市",
"861503330", "河北省保定市",
"861889941", "新疆克孜勒苏柯尔克孜自治州",
"861813221", "河北省石家庄市",
"861478848", "河南省新乡市",
"861826644", "山东省德州市",
"86185659", "广东省东莞市",
"861472789", "陕西省商洛市",
"861533367", "山西省临汾市",
"861893133", "河北省张家口市",
"861531919", "陕西省宝鸡市",
"86138149", "江苏省苏州市",
"861800557", "安徽省宿州市",
"861532980", "贵州省贵阳市",
"861816622", "湖南省怀化市",
"861471710", "甘肃省庆阳市",
"861564562", "黑龙江省大庆市",
"861880315", "河北省唐山市",
"86182433", "吉林省延边朝鲜族自治州",
"861558335", "四川省达州市",
"861815887", "安徽省合肥市",
"861576014", "四川省乐山市",
"86153517", "江苏省淮安市",
"861394896", "内蒙古赤峰市",
"861803441", "河北省秦皇岛市",
"861308408", "安徽省蚌埠市",
"861376929", "云南省楚雄彝族自治州",
"861360682", "浙江省台州市",
"861554278", "辽宁省盘锦市",
"861504081", "辽宁省抚顺市",
"861317410", "江苏省苏州市",
"86181375", "河南省驻马店市",
"861787847", "广西南宁市",
"861830966", "宁夏吴忠市",
"861556545", "河南省信阳市",
"861836087", "江苏省苏州市",
"861820804", "西藏林芝地区",
"861536893", "云南省西双版纳傣族自治州",
"861535681", "浙江省杭州市",
"861304632", "广东省中山市",
"861560700", "江西省赣州市",
"861814354", "贵州省黔南布依族苗族自治州",
"861879159", "陕西省商洛市",
"861856069", "山东省潍坊市",
"861378795", "湖南省张家界市",
"861458256", "安徽省蚌埠市",
"861393484", "山西省朔州市",
"861336496", "新疆伊犁哈萨克自治州",
"861345541", "山东省聊城市",
"861475658", "河北省衡水市",
"861801522", "江苏省南通市",
"861337607", "江苏省南京市",
"86159935", "河南省平顶山市",
"861340396", "河南省驻马店市",
"86158379", "河南省洛阳市",
"861844946", "新疆克拉玛依市",
"861595411", "山东省济南市",
"86182088", "云南省昆明市",
"861861779", "河北省保定市",
"861860675", "浙江省绍兴市",
"861857870", "广东省汕尾市",
"861346949", "湖南省娄底市",
"861533139", "四川省成都市",
"86183803", "四川省成都市",
"861840372", "河南省安阳市",
"861501980", "广东省惠州市",
"86159493", "广西河池市",
"861551939", "贵州省黔西南布依族苗族自治州",
"861522088", "广东省中山市",
"86156607", "广东省广州市",
"86187129", "河北省石家庄市",
"861379148", "山东省菏泽市",
"861394885", "内蒙古通辽市",
"861532362", "广东省珠海市",
"861560856", "贵州省铜仁地区",
"861452694", "陕西省商洛市",
"861380906", "江苏省苏州市",
"861700781", "广东省汕头市",
"861512989", "陕西省渭南市",
"861321778", "广西河池市",
"861820094", "广东省佛山市",
"861500356", "山西省晋城市",
"861502919", "陕西省咸阳市",
"861855860", "福建省福州市",
"861538315", "河北省唐山市",
"861890265", "广东省惠州市",
"861870723", "湖北省黄石市",
"861360453", "黑龙江省牡丹江市",
"861594769", "内蒙古赤峰市",
"861458575", "山东省菏泽市",
"861370089", "河南省许昌市",
"861336485", "新疆巴音郭楞蒙古自治州",
"861831952", "广东省河源市",
"86186994", "新疆昌吉回族自治州",
"861523478", "山西省忻州市",
"861378786", "湖南省常德市",
"861353634", "广东省惠州市",
"86135346", "广东省潮州市",
"861535398", "陕西省延安市",
"861340385", "河南省周口市",
"861389780", "辽宁省葫芦岛市",
"861390335", "河北省秦皇岛市",
"861361491", "辽宁省朝阳市",
"861889328", "甘肃省酒泉市",
"861889457", "甘肃省兰州市",
"861334771", "江苏省南京市",
"86181795", "江西省宜春市",
"861338944", "甘肃省兰州市",
"861524015", "安徽省六安市",
"861875120", "江苏省常州市",
"861803957", "河南省郑州市",
"861847829", "湖南省邵阳市",
"861828216", "四川省攀枝花市",
"861533326", "河北省保定市",
"861519497", "河北省保定市",
"86177363", "河北省张家口市",
"861459787", "新疆乌鲁木齐市",
"861479478", "内蒙古巴彦淖尔市",
"861773464", "陕西省安康市",
"861840743", "湖南省湘西土家族苗族自治州",
"861576878", "广东省惠州市",
"861315406", "陕西省商洛市",
"861572675", "西藏昌都地区",
"861373077", "四川省内江市",
"86180418", "辽宁省阜新市",
"861899829", "广东省广州市",
"861760664", "广东省佛山市",
"861884811", "内蒙古呼和浩特市",
"861816871", "江苏省苏州市",
"861325666", "山东省济南市",
"861316863", "广东省惠州市",
"861361436", "吉林省白城市",
"86134637", "河北省沧州市",
"861366570", "浙江省衢州市",
"861810144", "江苏省扬州市",
"86181411", "辽宁省大连市",
"86188617", "江苏省无锡市",
"861771210", "江苏省镇江市",
"861479180", "陕西省西安市",
"861761447", "吉林省辽源市",
"861470343", "山西省阳泉市",
"861772289", "广东省广州市",
"861808236", "江苏省泰州市",
"861599114", "陕西省安康市",
"861380956", "福建省宁德市",
"861390698", "福建省三明市",
"861770361", "黑龙江省哈尔滨市",
"861364223", "广东省汕头市",
"861857776", "广西南宁市",
"861538131", "浙江省衢州市",
"861893162", "河北省邯郸市",
"861764050", "辽宁省阜新市",
"86145484", "广东省广州市",
"861572844", "广东省东莞市",
"861361249", "广东省佛山市",
"861387001", "江西省鹰潭市",
"861318127", "山东省枣庄市",
"86152276", "河北省邢台市",
"861568463", "山东省临沂市",
"861821157", "广东省广州市",
"861308366", "河南省郑州市",
"861339426", "辽宁省丹东市",
"861899543", "宁夏固原市",
"861558381", "四川省德阳市",
"8615701", "北京市",
"861313397", "江西省赣州市",
"861362420", "辽宁省鞍山市",
"861566646", "山东省潍坊市",
"861889407", "甘肃省酒泉市",
"86130739", "福建省宁德市",
"861470772", "广西柳州市",
"861380530", "山东省菏泽市",
"861368866", "山东省烟台市",
"861829984", "新疆巴音郭楞蒙古自治州",
"861329378", "山西省吕梁市",
"861471816", "广东省湛江市",
"86155936", "甘肃省张掖市",
"861335063", "四川省南充市",
"86181790", "江西省新余市",
"861500583", "浙江省嘉兴市",
"861893910", "河南省许昌市",
"861850576", "浙江省台州市",
"86136789", "广东省广州市",
"861315456", "黑龙江省黑河市",
"861536677", "江苏省徐州市",
"861510513", "江苏省连云港市",
"861362679", "浙江省金华市",
"861804671", "江西省南昌市",
"861585087", "江苏省泰州市",
"86178647", "山东省济宁市",
"861569921", "新疆乌鲁木齐市",
"861782017", "广东省河源市",
"861351322", "河北省保定市",
"861329863", "湖南省衡阳市",
"861517466", "黑龙江省牡丹江市",
"861507158", "湖北省十堰市",
"861584773", "内蒙古呼伦贝尔市",
"861339435", "吉林省通化市",
"86151849", "云南省德宏傣族景颇族自治州",
"861847908", "江西省九江市",
"861453647", "江苏省南通市",
"861476572", "福建省福州市",
"861868947", "广东省深圳市",
"861595439", "山东省枣庄市",
"861817871", "广西桂林市",
"861529466", "河南省安阳市",
"861312557", "辽宁省丹东市",
"86134737", "河北省石家庄市",
"861364678", "浙江省丽水市",
"861524938", "甘肃省天水市",
"861335184", "黑龙江省大庆市",
"861882743", "湖北省武汉市",
"861367570", "浙江省衢州市",
"861863409", "河北省衡水市",
"86188717", "湖北省宜昌市",
"861707567", "安徽省阜阳市",
"861533111", "黑龙江省哈尔滨市",
"861572052", "安徽省蚌埠市",
"86132281", "四川省成都市",
"861355334", "广东省佛山市",
"861342172", "广东省湛江市",
"861550282", "四川省成都市",
"861361425", "辽宁省丹东市",
"861871755", "陕西省安康市",
"861818445", "贵州省遵义市",
"86136689", "广东省广州市",
"861519656", "四川省雅安市",
"861853220", "河北省保定市",
"8613241", "北京市",
"861700767", "广东省茂名市",
"861332251", "西藏拉萨市",
"861360770", "广西防城港市",
"861350357", "山西省临汾市",
"861595246", "江苏省无锡市",
"86177533", "山东省淄博市",
"861567646", "广西百色市",
"861350428", "辽宁省大连市",
"861899958", "新疆伊犁哈萨克自治州",
"861897059", "江西省萍乡市",
"86159347", "贵州省毕节地区",
"86130639", "江苏省常州市",
"86135451", "湖北省武汉市",
"86130283", "重庆市",
"86180262", "广东省广州市",
"861512915", "陕西省安康市",
"861390326", "河北省廊坊市",
"86132712", "河南省许昌市",
"861350544", "山东省德州市",
"861771537", "江苏省苏州市",
"861801498", "江苏省扬州市",
"861502985", "陕西省安康市",
"861538389", "河北省石家庄市",
"861886667", "山东省东营市",
"861838152", "四川省乐山市",
"861828907", "西藏山南地区",
"861898506", "贵州省黔南布依族苗族自治州",
"861342530", "广东省汕头市",
"861458754", "广东省汕头市",
"861389821", "辽宁省营口市",
"861581166", "广东省珠海市",
"861533335", "河北省秦皇岛市",
"861863459", "山西省运城市",
"861886945", "云南省红河哈尼族彝族自治州",
"861394819", "内蒙古呼和浩特市",
"86188840", "四川省成都市",
"86135181", "四川省成都市",
"861571429", "辽宁省葫芦岛市",
"861573897", "河南省信阳市",
"861580824", "四川省自贡市",
"86153616", "广东省深圳市",
"861894686", "青海省玉树藏族自治州",
"861762586", "江苏省扬州市",
"861315697", "山东省泰安市",
"861312344", "广西贵港市",
"861396689", "安徽省亳州市",
"861572240", "江苏省徐州市",
"861310902", "新疆昌吉回族自治州",
"861700820", "贵州省贵阳市",
"861519606", "四川省泸州市",
"861577878", "广西玉林市",
"86139937", "甘肃省酒泉市",
"86178810", "新疆喀什地区",
"861571670", "河南省开封市",
"86177774", "广西梧州市",
"861340319", "河北省邢台市",
"861772173", "江苏省盐城市",
"861589075", "河南省安阳市",
"861558139", "湖南省永州市",
"861823236", "河北省秦皇岛市",
"861874270", "新疆昌吉回族自治州",
"861770387", "河南省周口市",
"861370015", "辽宁省丹东市",
"861336419", "辽宁省辽阳市",
"861514988", "内蒙古通辽市",
"861800392", "河南省鹤壁市",
"861834416", "广东省梅州市",
"861310176", "河南省信阳市",
"861899908", "新疆喀什地区",
"861559541", "宁夏银川市",
"861322322", "河北省保定市",
"861317832", "福建省泉州市",
"861521758", "广东省惠州市",
"861880389", "河南省新乡市",
"861560473", "内蒙古乌海市",
"861598307", "四川省遂宁市",
"861530484", "黑龙江省哈尔滨市",
"861340189", "江苏省宿迁市",
"861459243", "四川省眉山市",
"861561748", "河南省许昌市",
"861508310", "河南省新乡市",
"861890237", "广东省云浮市",
"861768101", "安徽省宿州市",
"861361712", "湖北省孝感市",
"861596334", "山东省临沂市",
"861377929", "新疆和田地区",
"861858566", "贵州省黔南布依族苗族自治州",
"861302144", "河北省沧州市",
"861887635", "福建省泉州市",
"861356246", "山东省枣庄市",
"86133183", "广东省佛山市",
"86153422", "湖北省武汉市",
"861360876", "云南省德宏傣族景颇族自治州",
"861313502", "湖南省湘潭市",
"861553315", "河北省唐山市",
"86132604", "北京市",
"861550745", "湖南省怀化市",
"86185759", "广东省湛江市",
"86137820", "河南省南阳市",
"861832498", "安徽省安庆市",
"861590614", "江苏省常州市",
"861354147", "四川省甘孜藏族自治州",
"861522911", "陕西省延安市",
"861472715", "浙江省湖州市",
"861555128", "安徽省淮南市",
"86157026", "山西省晋城市",
"86937", "甘肃省酒泉市",
"861372655", "广东省韶关市",
"861525610", "安徽省淮北市",
"861301201", "河北省唐山市",
"861572892", "西藏日喀则地区",
"861376858", "广西南宁市",
"861347949", "江西省赣州市",
"861856870", "河南省新乡市",
"861474788", "内蒙古呼和浩特市",
"861454477", "陕西省宝鸡市",
"861338634", "山东省莱芜市",
"861529308", "甘肃省张掖市",
"861870417", "辽宁省营口市",
"861591295", "云南省普洱市",
"861328197", "四川省宜宾市",
"861894695", "广东省梅州市",
"861534751", "广东省揭阳市",
"861558326", "四川省资阳市",
"861586433", "山东省潍坊市",
"861339481", "内蒙古呼伦贝尔市",
"861323327", "山西省晋城市",
"861390367", "黑龙江省牡丹江市",
"861868401", "四川省成都市",
"861323458", "黑龙江省伊春市",
"861587071", "江西省赣州市",
"861363448", "吉林省松原市",
"86183301", "河北省石家庄市",
"861306480", "江苏省宿迁市",
"86186963", "湖北省武汉市",
"861881539", "山东省临沂市",
"861875252", "江苏省扬州市",
"861809060", "四川省成都市",
"861370648", "山东省青岛市",
"861504067", "辽宁省鞍山市",
"861598357", "四川省攀枝花市",
"86189528", "江苏省镇江市",
"86186768", "广东省潮州市",
"861505630", "安徽省宣城市",
"861521708", "广东省东莞市",
"861598428", "四川省内江市",
"861336073", "广东省茂名市",
"861813295", "河北省邯郸市",
"861810024", "广东省东莞市",
"861452642", "江苏省常州市",
"861894338", "吉林省松原市",
"861700726", "山东省烟台市",
"861379916", "福建省三明市",
"86178546", "山东省东营市",
"861768151", "浙江省绍兴市",
"861766033", "山东省菏泽市",
"861580976", "青海省玉树藏族自治州",
"861552064", "四川省宜宾市",
"86147406", "辽宁省辽阳市",
"861570612", "江苏省常州市",
"861313552", "安徽省蚌埠市",
"861780657", "广东省茂名市",
"861566550", "安徽省滁州市",
"861526540", "山东省菏泽市",
"861867604", "广东省东莞市",
"861348741", "湖南省湘西土家族苗族自治州",
"86137825", "河南省新乡市",
"861399949", "新疆塔城地区",
"861388162", "四川省雅安市",
"861376808", "广西河池市",
"861843279", "河北省邢台市",
"861340628", "山东省济宁市",
"86158992", "新疆乌鲁木齐市",
"86151324", "河北省保定市",
"86170977", "浙江省金华市",
"861840838", "四川省阿坝藏族羌族自治州",
"861533381", "河南省郑州市",
"861529427", "甘肃省定西市",
"86183599", "福建省南平市",
"861474599", "黑龙江省大庆市",
"861890888", "云南省丽江市",
"861347198", "广西梧州市",
"861529358", "甘肃省天水市",
"861708345", "山西省长治市",
"861855413", "山东省潍坊市",
"861335314", "吉林省长春市",
"861327882", "湖南省湘潭市",
"861534701", "湖北省恩施土家族苗族自治州",
"861857274", "湖北省孝感市",
"861815861", "浙江省台州市",
"861780073", "青海省海东地区",
"861315873", "四川省遂宁市",
"861309812", "陕西省渭南市",
"861471899", "西藏拉萨市",
"861365560", "安徽省合肥市",
"861824679", "黑龙江省大庆市",
"861509848", "山东省烟台市",
"861319882", "四川省南充市",
"861868451", "湖南省岳阳市",
"861502931", "陕西省延安市",
"861323408", "辽宁省大连市",
"861356792", "浙江省宁波市",
"861705577", "浙江省温州市",
"861808734", "云南省昆明市",
"861521279", "安徽省合肥市",
"861896530", "福建省三明市",
"861390681", "浙江省杭州市",
"861322984", "广东省清远市",
"861308627", "青海省西宁市",
"861532633", "吉林省延边朝鲜族自治州",
"861379096", "广东省湛江市",
"861342816", "广东省茂名市",
"861700589", "浙江省金华市",
"86188157", "安徽省池州市",
"861893254", "河北省石家庄市",
"861504858", "内蒙古巴彦淖尔市",
"861340631", "山东省威海市",
"86186638", "山东省烟台市",
"861324312", "河南省南阳市",
"86181850", "贵州省贵阳市",
"86132290", "广东省肇庆市",
"861378738", "湖南省娄底市",
"86188487", "云南省红河哈尼族彝族自治州",
"861709492", "浙江省金华市",
"861573868", "河南省南阳市",
"861868337", "四川省成都市",
"861869420", "河北省保定市",
"861564358", "吉林省吉林市",
"861346311", "河北省石家庄市",
"861344008", "四川省遂宁市",
"861524348", "河北省秦皇岛市",
"861380059", "福建省厦门市",
"861388756", "云南省红河哈尼族彝族自治州",
"861330411", "辽宁省大连市",
"861866304", "山东省日照市",
"861314163", "湖南省湘西土家族苗族自治州",
"86156306", "河北省廊坊市",
"861479610", "广西玉林市",
"861572283", "江苏省泰州市",
"861539414", "陕西省商洛市",
"86183501", "福建省福州市",
"861355944", "福建省福州市",
"86151128", "广东省东莞市",
"861365448", "吉林省延边朝鲜族自治州",
"861896956", "浙江省丽水市",
"861337357", "河北省唐山市",
"861319376", "河南省开封市",
"861800644", "山东省济南市",
"861394959", "河南省驻马店市",
"86159960", "江苏省泰州市",
"861769120", "陕西省西安市",
"861332065", "四川省宜宾市",
"86180461", "福建省漳州市",
"861770455", "黑龙江省绥化市",
"861588274", "四川省巴中市",
"861598431", "四川省眉山市",
"861558398", "四川省眉山市",
"861450423", "辽宁省抚顺市",
"861764539", "黑龙江省鹤岗市",
"861454203", "河南省郑州市",
"861512855", "河北省承德市",
"861538048", "江苏省常州市",
"861801467", "江苏省盐城市",
"86453", "黑龙江省牡丹江市",
"861334579", "浙江省金华市",
"861872999", "陕西省铜川市",
"861599684", "江苏省镇江市",
"861847818", "湖南省益阳市",
"861508143", "河北省张家口市",
"86177594", "福建省泉州市",
"861327376", "河南省信阳市",
"86139017", "上海市",
"861539741", "浙江省温州市",
"861311776", "广西百色市",
"861452450", "黑龙江省哈尔滨市",
"861700798", "江西省南昌市",
"861850472", "内蒙古包头市",
"86159746", "云南省曲靖市",
"861360382", "河南省郑州市",
"86152123", "安徽省马鞍山市",
"861816322", "广东省珠海市",
"861824464", "河北省衡水市",
"861899818", "广东省珠海市",
"86132482", "上海市",
"861880615", "江苏省无锡市",
"861893204", "贵州省黔南布依族苗族自治州",
"86182463", "黑龙江省牡丹江市",
"861598496", "四川省凉山彝族自治州",
"861539232", "福建省三明市",
"861558635", "湖北省宜昌市",
"861522091", "广东省中山市",
"86136294", "云南省昆明市",
"861815295", "新疆吐鲁番地区",
"86132152", "广东省东莞市",
"861501508", "广东省韶关市",
"861882780", "江西省吉安市",
"861897217", "湖北省武汉市",
"86132295", "广东省湛江市",
"86181855", "贵州省黔东南苗族侗族自治州",
"861337544", "山东省德州市",
"861382457", "广东省梅州市",
"861570034", "四川省广安市",
"861560257", "广东省湛江市",
"861566011", "河南省焦作市",
"861365524", "江苏省宿迁市",
"861380009", "广东省广州市",
"861856927", "湖南省益阳市",
"861310812", "四川省攀枝花市",
"861533945", "甘肃省金昌市",
"861350485", "黑龙江省双鸭山市",
"86150542", "山东省青岛市",
"861807042", "江西省九江市",
"861358063", "广东省肇庆市",
"86134336", "广东省东莞市",
"861580766", "广东省云浮市",
"861860375", "河南省平顶山市",
"861808288", "新疆乌鲁木齐市",
"861347126", "广西桂林市",
"861363560", "安徽省合肥市",
"861809024", "四川省阿坝藏族羌族自治州",
"86177198", "河南省郑州市",
"86188316", "河北省廊坊市",
"861359157", "辽宁省抚顺市",
"861707598", "福建省莆田市",
"861810060", "江苏省南京市",
"861370986", "辽宁省大连市",
"861877437", "湖南省常德市",
"86159965", "江苏省南通市",
"861552020", "四川省巴中市",
"861337307", "河北省沧州市",
"861813861", "广东省汕尾市",
"861516608", "山东省淄博市",
"86183399", "河南省郑州市",
"861535381", "陕西省宝鸡市",
"861304332", "吉林省长春市",
"861333314", "河北省承德市",
"861800875", "云南省保山市",
"861853413", "山西省临汾市",
"861771904", "河南省商丘市",
"861361532", "山东省青岛市",
"861330744", "湖南省张家界市",
"86133471", "内蒙古呼和浩特市",
"861361488", "内蒙古巴彦淖尔市",
"861309952", "宁夏石嘴山市",
"861500656", "山东省潍坊市",
"86155740", "湖南省岳阳市",
"861822410", "四川省巴中市",
"861865409", "安徽省宿州市",
"861537745", "湖南省怀化市",
"86183059", "福建省福州市",
"861853264", "河北省张家口市",
"861554551", "黑龙江省绥化市",
"861825291", "江苏省盐城市",
"86133310", "北京市",
"861569089", "河南省许昌市",
"861532662", "黑龙江省哈尔滨市",
"861452394", "西藏林芝地区",
"861357847", "云南省迪庆藏族自治州",
"861360960", "广东省广州市",
"861526583", "山东省日照市",
"861840672", "广西梧州市",
"861874029", "辽宁省葫芦岛市",
"861700977", "浙江省绍兴市",
"861372159", "贵州省毕节地区",
"861821489", "安徽省合肥市",
"861776165", "河南省焦作市",
"861836205", "江苏省南京市",
"861580727", "湖北省襄樊市",
"861593246", "河北省邯郸市",
"861568591", "贵州省毕节地区",
"86183779", "广西北海市",
"861856966", "湖南省邵阳市",
"861380899", "山东省青岛市",
"861572375", "广西玉林市",
"861530545", "山东省烟台市",
"861354969", "湖南省永州市",
"861843613", "河南省商丘市",
"861887139", "湖北省武汉市",
"861377035", "江苏省淮安市",
"86139196", "甘肃省天水市",
"861533626", "陕西省安康市",
"861347339", "河北省石家庄市",
"861830069", "河南省郑州市",
"861526306", "山东省泰安市",
"861389838", "辽宁省锦州市",
"861346046", "河南省郑州市",
"861890825", "重庆市",
"861390635", "山东省聊城市",
"861350496", "辽宁省大连市",
"861811792", "四川省达州市",
"861373303", "安徽省六安市",
"861370995", "新疆巴音郭楞蒙古自治州",
"861771717", "河北省保定市",
"86151407", "辽宁省营口市",
"861560148", "江苏省南通市",
"86158601", "福建省龙岩市",
"861340685", "山东省德州市",
"861568536", "贵州省安顺市",
"861580860", "云南省昭通市",
"861336592", "福建省厦门市",
"861535335", "陕西省安康市",
"861768793", "江西省上饶市",
"86155745", "湖南省怀化市",
"861583061", "河北省廊坊市",
"861328168", "四川省广安市",
"861309902", "山西省临汾市",
"861853079", "河南省商丘市",
"861825449", "山东省枣庄市",
"861470643", "山东省淄博市",
"861554501", "黑龙江省哈尔滨市",
"861390398", "河南省三门峡市",
"861894948", "安徽省滁州市",
"861554990", "湖北省咸宁市",
"861770661", "浙江省宁波市",
"861859997", "四川省雅安市",
"861309176", "黑龙江省黑河市",
"861501633", "广东省汕尾市",
"861592978", "陕西省咸阳市",
"861350431", "吉林省长春市",
"86134667", "北京市",
"861889189", "陕西省榆林市",
"861804233", "浙江省温州市",
"861539263", "山西省太原市",
"861811246", "江苏省无锡市",
"861383402", "山西省大同市",
"8613691", "北京市",
"861576942", "甘肃省定西市",
"861528940", "陕西省咸阳市",
"861362379", "河南省洛阳市",
"861311870", "云南省昭通市",
"861804371", "吉林省长春市",
"861304363", "湖南省娄底市",
"861329678", "浙江省嘉兴市",
"861569938", "新疆伊犁哈萨克自治州",
"861522851", "四川省广安市",
"861708935", "广东省肇庆市",
"861579403", "广东省广州市",
"861832467", "黑龙江省牡丹江市",
"861361563", "安徽省宣城市",
"86155966", "陕西省西安市",
"861478513", "贵州省安顺市",
"861811439", "江苏省宿迁市",
"861313697", "黑龙江省佳木斯市",
"861864871", "内蒙古呼和浩特市",
"861705021", "海南省海口市",
"861306443", "河南省安阳市",
"86130769", "广东省深圳市",
"861882886", "四川省甘孜藏族自治州",
"861879072", "河南省三门峡市",
"861302879", "甘肃省兰州市",
"861516533", "山东省淄博市",
"86186611", "江苏省常州市",
"86130012", "北京市",
"861317678", "山东省济宁市",
"861560999", "新疆伊犁哈萨克自治州",
"861558681", "湖北省咸宁市",
"861307046", "新疆克拉玛依市",
"86156791", "江西省南昌市",
"861864836", "内蒙古鄂尔多斯市",
"861311785", "江西省抚州市",
"861310689", "广东省东莞市",
"861814045", "四川省眉山市",
"861313003", "辽宁省大连市",
"861364626", "江苏省南通市",
"861532837", "四川省自贡市",
"861308823", "四川省内江市",
"861301715", "湖南省湘潭市",
"861366839", "四川省达州市",
"861870982", "安徽省合肥市",
"861331059", "湖北省荆州市",
"861866629", "广东省深圳市",
"861782864", "四川省广安市",
"86147515", "江苏省无锡市",
"861808633", "湖北省黄石市",
"861840692", "云南省德宏傣族景颇族自治州",
"861860503", "福建省三明市",
"861705602", "广东省广州市",
"86189095", "宁夏银川市",
"861776300", "湖北省武汉市",
"861804336", "吉林省延边朝鲜族自治州",
"861856728", "河南省南阳市",
"861317335", "山东省聊城市",
"861325263", "吉林省长春市",
"861861536", "山东省潍坊市",
"861356380", "山东省泰安市",
"861894179", "辽宁省葫芦岛市",
"861508426", "辽宁省本溪市",
"861705568", "云南省昆明市",
"861811343", "四川省乐山市",
"861306339", "安徽省亳州市",
"861895445", "山东省聊城市",
"861554281", "辽宁省锦州市",
"861304266", "辽宁省丹东市",
"861880430", "吉林省长春市",
"861867703", "广西防城港市",
"861350476", "吉林省吉林市",
"861877142", "湖北省随州市",
"861814329", "西藏拉萨市",
"86138570", "浙江省丽水市",
"861309131", "河北省张家口市",
"861535678", "浙江省丽水市",
"86151409", "辽宁省辽阳市",
"861583528", "山西省运城市",
"861586088", "福建省三明市",
"861308549", "湖南省娄底市",
"861314951", "黑龙江省哈尔滨市",
"861800886", "云南省怒江傈僳族自治州",
"861550873", "云南省红河哈尼族彝族自治州",
"86183777", "广西钦州市",
"861572395", "广西玉林市",
"861839526", "宁夏吴忠市",
"861585596", "安徽省芜湖市",
"86188405", "辽宁省丹东市",
"86156410", "辽宁省铁岭市",
"861821940", "广东省梅州市",
"861373256", "浙江省嘉兴市",
"861580341", "山西省太原市",
"861389507", "宁夏银川市",
"861802048", "江苏省镇江市",
"861505107", "江苏省盐城市",
"861313053", "辽宁省丹东市",
"861778946", "甘肃省陇南市",
"861347443", "陕西省延安市",
"861385221", "江苏省扬州市",
"86137698", "云南省曲靖市",
"861329111", "江苏省南通市",
"861815383", "湖南省郴州市",
"86134669", "山西省运城市",
"861528489", "四川省广元市",
"861595110", "江苏省苏州市",
"861787772", "湖南省衡阳市",
"861509944", "新疆伊犁哈萨克自治州",
"861860553", "安徽省芜湖市",
"861705652", "上海市",
"86158676", "浙江省台州市",
"861841435", "内蒙古赤峰市",
"861454468", "陕西省延安市",
"861572638", "山东省烟台市",
"861576835", "广东省湛江市",
"861820543", "山东省滨州市",
"861317111", "内蒙古通辽市",
"861398697", "湖北省荆门市",
"861523435", "山西省晋中市",
"861376904", "云南省保山市",
"86155819", "山西省运城市",
"861840934", "甘肃省庆阳市",
"861812696", "广东省梅州市",
"86147272", "重庆市",
"861336572", "安徽省蚌埠市",
"861833349", "河北省邢台市",
"861533863", "贵州省安顺市",
"86138781", "广西南宁市",
"861890984", "辽宁省大连市",
"861831615", "广东省阳江市",
"861830719", "湖北省十堰市",
"861378937", "湖南省衡阳市",
"861338733", "湖南省株洲市",
"861822681", "安徽省滁州市",
"861554970", "湖北省黄石市",
"861390378", "河南省开封市",
"86155332", "河北省保定市",
"86138575", "浙江省绍兴市",
"861459550", "青海省海北藏族自治州",
"861309315", "江苏省常州市",
"861879092", "河南省漯河市",
"86130767", "广东省广州市",
"861867753", "广西贵港市",
"861780572", "浙江省湖州市",
"861313677", "黑龙江省双鸭山市",
"861314901", "广东省清远市",
"861458482", "山东省青岛市",
"861317698", "山东省临沂市",
"861560979", "青海省海西蒙古族藏族自治州",
"861341578", "广东省肇庆市",
"861321735", "湖南省郴州市",
"861320639", "山东省青岛市",
"861458538", "河南省漯河市",
"861319385", "河南省信阳市",
"861804391", "吉林省长春市",
"861332422", "辽宁省鞍山市",
"861369815", "四川省泸州市",
"86558", "安徽省阜阳市",
"86185356", "山西省晋城市",
"861536397", "广东省珠海市",
"861362399", "河南省南阳市",
"861819743", "青海省黄南藏族自治州",
"861708842", "江西省萍乡市",
"861327385", "河南省许昌市",
"861861591", "山东省潍坊市",
"861329698", "内蒙古巴彦淖尔市",
"86156415", "辽宁省丹东市",
"86188400", "辽宁省沈阳市",
"861325741", "湖南省株洲市",
"861894747", "内蒙古鄂尔多斯市",
"861515544", "安徽省淮南市",
"861305434", "黑龙江省牡丹江市",
"861365751", "新疆喀什地区",
"861360828", "四川省泸州市",
"861571923", "陕西省渭南市",
"861303541", "安徽省阜阳市",
"861899854", "广东省茂名市",
"86151292", "陕西省西安市",
"861826287", "江苏省盐城市",
"861860638", "山东省淄博市",
"861327115", "河南省开封市",
"86151155", "湖南省郴州市",
"861572553", "山东省烟台市",
"861800780", "广西南宁市",
"861813340", "安徽省芜湖市",
"86182823", "四川省资阳市",
"861772030", "湖北省恩施土家族苗族自治州",
"861850739", "湖南省邵阳市",
"861379076", "广东省惠州市",
"861309185", "黑龙江省牡丹江市",
"861351825", "四川省达州市",
"861319115", "山西省长治市",
"86152030", "海南省海口市",
"861810710", "湖北省襄樊市",
"861357643", "江西省萍乡市",
"861537552", "安徽省蚌埠市",
"861344014", "四川省德阳市",
"861594916", "江苏省淮安市",
"861845441", "山东省淄博市",
"861893584", "新疆阿克苏地区",
"86189783", "广西桂林市",
"861829510", "宁夏银川市",
"861301422", "宁夏吴忠市",
"861809906", "新疆阿勒泰地区",
"861539408", "甘肃省张掖市",
"861569737", "湖南省益阳市",
"86139019", "上海市",
"861327396", "河南省驻马店市",
"86150665", "山东省德州市",
"861475314", "山东省济南市",
"861550697", "福建省龙岩市",
"861872979", "陕西省铜川市",
"861334599", "浙江省宁波市",
"861780913", "陕西省渭南市",
"861458653", "湖北省荆州市",
"861333358", "山西省吕梁市",
"861882875", "四川省泸州市",
"861778625", "湖北省随州市",
"861331899", "广东省河源市",
"861814618", "福建省南平市",
"861329381", "山西省太原市",
"861530752", "广东省惠州市",
"861324905", "广东省深圳市",
"861521534", "山东省德州市",
"861311731", "湖南省长沙市",
"861454356", "山东省枣庄市",
"861521817", "广东省阳江市",
"861847804", "湖南省衡阳市",
"861807580", "湖南省永州市",
"86156553", "安徽省芜湖市",
"861804688", "江西省鹰潭市",
"86137002", "陕西省西安市",
"861555176", "安徽省马鞍山市",
"861330680", "浙江省舟山市",
"861365701", "江西省鹰潭市",
"861314447", "广东省汕尾市",
"861356962", "河南省三门峡市",
"861815275", "湖南省郴州市",
"861522071", "广东省惠州市",
"86147453", "广东省广州市",
"861835939", "福建省宁德市",
"861504814", "内蒙古乌海市",
"861572503", "山东省日照市",
"861534560", "安徽省合肥市",
"861327331", "河北省衡水市",
"861537668", "山东省潍坊市",
"86151150", "湖南省岳阳市",
"861839567", "河北省保定市",
"861893218", "湖南省永州市",
"861871211", "安徽省宿州市",
"861533832", "广东省佛山市",
"86150084", "四川省成都市",
"861311050", "福建省福州市",
"86183576", "浙江省台州市",
"861846042", "江西省萍乡市",
"86158857", "贵州省安顺市",
"861700778", "广东省肇庆市",
"861850492", "内蒙古包头市",
"86151480", "内蒙古呼和浩特市",
"861311796", "江西省吉安市",
"86156371", "河南省郑州市",
"861316367", "黑龙江省哈尔滨市",
"861531860", "山东省淄博市",
"861598476", "四川省达州市",
"861302059", "山东省聊城市",
"861537502", "安徽省滁州市",
"861321781", "广西南宁市",
"861454583", "甘肃省白银市",
"861501837", "广东省汕头市",
"861332715", "内蒙古赤峰市",
"861300407", "安徽省蚌埠市",
"861390410", "辽宁省铁岭市",
"86189988", "广东省广州市",
"861597156", "湖北省咸宁市",
"861539458", "福建省三明市",
"861846200", "山东省青岛市",
"861572386", "广西百色市",
"861505248", "江苏省连云港市",
"861315282", "山西省大同市",
"861760416", "辽宁省锦州市",
"86943", "甘肃省白银市",
"861809956", "新疆喀什地区",
"861539327", "甘肃省陇南市",
"861800895", "西藏昌都地区",
"86183397", "河南省焦作市",
"861816237", "湖北省襄樊市",
"861510334", "河北省秦皇岛市",
"861458603", "湖北省鄂州市",
"861345197", "江苏省苏州市",
"861322825", "四川省南充市",
"861513496", "内蒙古巴彦淖尔市",
"86150660", "山东省东营市",
"861334788", "江苏省常州市",
"861319273", "广东省河源市",
"861538430", "广东省阳江市",
"861560587", "浙江省温州市",
"861454306", "黑龙江省哈尔滨市",
"861575693", "四川省雅安市",
"86745", "湖南省怀化市",
"861364945", "广西玉林市",
"861530702", "江西省九江市",
"861860395", "河南省漯河市",
"861873438", "山西省忻州市",
"861891431", "江苏省常州市",
"861863903", "河南省商丘市",
"86137964", "黑龙江省鸡西市",
"861876022", "福建省宁德市",
"861333308", "河北省衡水市",
"861595933", "福建省宁德市",
"861570520", "江苏省徐州市",
"861479481", "内蒙古呼和浩特市",
"861576881", "广东省河源市",
"861360896", "山东省青岛市",
"86137465", "黑龙江省黑河市",
"861389934", "新疆哈密地区",
"861872769", "湖北省恩施土家族苗族自治州",
"861820580", "浙江省舟山市",
"861329945", "广西玉林市",
"861453843", "四川省甘孜藏族自治州",
"861859726", "青海省海东地区",
"861832478", "安徽省阜阳市",
"861399178", "陕西省延安市",
"861502976", "陕西省汉中市",
"861321260", "湖南省湘西土家族苗族自治州",
"861590562", "安徽省铜陵市",
"861347480", "内蒙古呼和浩特市",
"86185757", "广东省佛山市",
"86189269", "广东省珠海市",
"861317945", "江苏省镇江市",
"861305541", "福建省福州市",
"861897879", "广西贵港市",
"861560493", "辽宁省抚顺市",
"861323232", "广东省梅州市",
"861534448", "湖南省常德市",
"861300396", "福建省漳州市",
"861811933", "甘肃省平凉市",
"86187293", "陕西省西安市",
"861323741", "湖南省长沙市",
"861317667", "山东省济南市",
"861567884", "广西崇左市",
"861597762", "广西百色市",
"861327457", "黑龙江省牡丹江市",
"861457015", "山东省威海市",
"861453529", "山东省济宁市",
"861328177", "四川省广安市",
"861803183", "河北省石家庄市",
"861367447", "吉林省白城市",
"861890322", "河北省保定市",
"861591275", "云南省玉溪市",
"861823362", "河北省廊坊市",
"86150730", "湖南省岳阳市",
"86156353", "山西省阳泉市",
"861501734", "广东省中山市",
"86189550", "安徽省滁州市",
"861781730", "广东省江门市",
"861335427", "辽宁省盘锦市",
"861836528", "安徽省滁州市",
"861332535", "陕西省安康市",
"861477307", "湖南省益阳市",
"861869041", "陕西省宝鸡市",
"861335358", "山西省吕梁市",
"861874842", "内蒙古乌兰察布市",
"861840557", "安徽省宿州市",
"86138795", "江西省宜春市",
"86156780", "广西柳州市",
"861594700", "内蒙古呼伦贝尔市",
"861592967", "陕西省渭南市",
"861589086", "河南省南阳市",
"861572872", "广东省佛山市",
"861866125", "江苏省连云港市",
"861871542", "安徽省安庆市",
"861504717", "内蒙古锡林郭勒盟",
"861764069", "辽宁省鞍山市",
"861319457", "黑龙江省大兴安岭地区",
"861809710", "青海省海北藏族自治州",
"861858911", "西藏拉萨市",
"861580931", "甘肃省兰州市",
"861568027", "四川省乐山市",
"86136322", "广东省广州市",
"861348408", "浙江省金华市",
"861310185", "江苏省扬州市",
"861470744", "湖南省张家界市",
"861459346", "四川省凉山彝族自治州",
"861858649", "贵州省黔东南苗族侗族自治州",
"861521714", "广东省东莞市",
"861300273", "山东省烟台市",
"861311511", "江苏省苏州市",
"86137460", "黑龙江省牡丹江市",
"861812319", "四川省达州市",
"861810956", "宁夏中卫市",
"86183376", "河南省信阳市",
"86156571", "浙江省杭州市",
"861375575", "江西省南昌市",
"861336093", "广东省清远市",
"86138411", "辽宁省大连市",
"861842902", "陕西省榆林市",
"861829730", "安徽省蚌埠市",
"861586349", "山东省菏泽市",
"861569517", "江苏省淮安市",
"86184431", "吉林省长春市",
"861524737", "内蒙古鄂尔多斯市",
"861380144", "江苏省扬州市",
"861580996", "新疆巴音郭楞蒙古自治州",
"861891307", "江苏省苏州市",
"861569834", "山西省太原市",
"861470411", "辽宁省大连市",
"861363701", "安徽省滁州市",
"861311728", "湖北省宜昌市",
"861570564", "安徽省六安市",
"86150735", "湖南省郴州市",
"861326696", "广东省深圳市",
"861376814", "广西梧州市",
"861338972", "青海省海东地区",
"861857294", "湖北省荆州市",
"86151984", "云南省西双版纳傣族自治州",
"861513428", "辽宁省葫芦岛市",
"861850519", "江苏省常州市",
"861339610", "湖北省襄樊市",
"86138790", "江西省新余市",
"861362616", "江苏省徐州市",
"861534524", "江苏省苏州市",
"861768932", "福建省厦门市",
"861589141", "陕西省延安市",
"861335308", "广东省汕头市",
"86139632", "山东省枣庄市",
"861810530", "山东省菏泽市",
"86189555", "安徽省马鞍山市",
"861824699", "黑龙江省双鸭山市",
"86170979", "浙江省温州市",
"86152784", "广西梧州市",
"861334234", "辽宁省辽阳市",
"861319407", "福建省厦门市",
"861343197", "广东省清远市",
"861843299", "河北省邢台市",
"861855859", "福建省泉州市",
"861899757", "新疆伊犁哈萨克自治州",
"861883397", "河北省秦皇岛市",
"861576227", "山东省青岛市",
"86137858", "河北省衡水市",
"861594750", "内蒙古鄂尔多斯市",
"861586025", "福建省福州市",
"861870324", "河北省承德市",
"861821983", "甘肃省平凉市",
"861399480", "山西省吕梁市",
"861566280", "吉林省延边朝鲜族自治州",
"861313282", "广西柳州市",
"861503248", "河北省保定市",
"861361062", "山西省大同市",
"861700968", "浙江省台州市",
"861323414", "辽宁省本溪市",
"861888127", "四川省广元市",
"86591", "福建省福州市",
"861894844", "广东省揭阳市",
"861817891", "江西省南昌市",
"861370765", "河南省新乡市",
"861323263", "广东省河源市",
"86158140", "广东省深圳市",
"861476592", "重庆市",
"86138083", "重庆市",
"861458521", "河南省焦作市",
"861893445", "贵州省黔南布依族苗族自治州",
"861348366", "河北省石家庄市",
"86188062", "江苏省苏州市",
"86188719", "湖北省十堰市",
"861521907", "广东省清远市",
"86156914", "陕西省西安市",
"861778129", "四川省南充市",
"861330643", "山东省淄博市",
"86134739", "河北省石家庄市",
"86152915", "陕西省安康市",
"861550552", "安徽省蚌埠市",
"861364698", "福建省莆田市",
"861565987", "福建省泉州市",
"861575774", "浙江省杭州市",
"861355848", "广西南宁市",
"861454540", "新疆阿克苏地区",
"861829891", "甘肃省白银市",
"861813930", "新疆吐鲁番地区",
"861809816", "广东省佛山市",
"861570889", "云南省丽江市",
"861332581", "浙江省杭州市",
"861862564", "河南省濮阳市",
"86151715", "湖北省武汉市",
"861590533", "山东省淄博市",
"861819886", "广东省广州市",
"861315003", "甘肃省陇南市",
"86151847", "内蒙古呼和浩特市",
"861777650", "广西桂林市",
"861316398", "福建省漳州市",
"861360790", "江西省新余市",
"861527134", "湖北省随州市",
"861319619", "吉林省白山市",
"86177421", "辽宁省朝阳市",
"861869195", "陕西省西安市",
"861573964", "新疆昌吉回族自治州",
"861591383", "广东省东莞市",
"86138438", "吉林省松原市",
"861811110", "四川省成都市",
"861782820", "四川省成都市",
"861830539", "山东省临沂市",
"861859820", "广东省潮州市",
"86130637", "江苏省苏州市",
"861554827", "内蒙古巴彦淖尔市",
"861338513", "贵州省安顺市",
"86189413", "辽宁省抚顺市",
"861879912", "新疆伊犁哈萨克自治州",
"861377565", "江苏省泰州市",
"861309689", "贵州省黔西南布依族苗族自治州",
"861802119", "江苏省无锡市",
"861813556", "山西省太原市",
"861392200", "广东省阳江市",
"861551527", "河南省漯河市",
"861334725", "湖南省郴州市",
"861327619", "江苏省镇江市",
"861819005", "四川省德阳市",
"861360056", "浙江省嘉兴市",
"861878429", "四川省南充市",
"861328749", "山东省菏泽市",
"861537697", "山东省烟台市",
"861812189", "四川省绵阳市",
"86136687", "云南省昆明市",
"86138370", "河南省商丘市",
"861535863", "江苏省泰州市",
"86158145", "广东省广州市",
"861837492", "湖南省岳阳市",
"861339023", "辽宁省辽阳市",
"861561665", "湖南省衡阳市",
"861700017", "广东省广州市",
"861300385", "福建省莆田市",
"861313745", "河南省周口市",
"861310315", "河北省唐山市",
"861550502", "安徽省六安市",
"86152910", "陕西省西安市",
"861367951", "广东省清远市",
"861599783", "湖北省十堰市",
"861521957", "广东省茂名市",
"861309128", "河北省邢台市",
"861592926", "陕西省渭南市",
"86156709", "河南省焦作市",
"861803313", "广东省江门市",
"861354588", "湖北省武汉市",
"861848291", "四川省成都市",
"861587801", "广西玉林市",
"861843957", "河南省驻马店市",
"861335466", "云南省玉溪市",
"861372044", "陕西省榆林市",
"861450929", "江苏省无锡市",
"861801478", "江苏省无锡市",
"861777600", "广西南宁市",
"861319941", "黑龙江省大庆市",
"861550668", "山东省聊城市",
"861780853", "贵州省安顺市",
"861315053", "云南省曲靖市",
"861816825", "江苏省徐州市",
"861800743", "湖南省湘西土家族苗族自治州",
"86151710", "湖北省恩施土家族苗族自治州",
"861813383", "河北省石家庄市",
"861800372", "河南省安阳市",
"861510944", "甘肃省甘南藏族自治州",
"861317626", "山东省德州市",
"861772193", "四川省南充市",
"861501225", "云南省昭通市",
"861874290", "新疆伊犁哈萨克自治州",
"861867045", "湖南省怀化市",
"861557702", "广西柳州市",
"86151491", "内蒙古赤峰市",
"861571690", "河北省邯郸市",
"861336853", "贵州省安顺市",
"861567569", "湖南省郴州市",
"861310196", "江苏省无锡市",
"86185556", "安徽省安庆市",
"861591930", "广东省广州市",
"861516063", "福建省三明市",
"861364335", "河北省秦皇岛市",
"861807543", "安徽省亳州市",
"861856242", "山东省济宁市",
"861392250", "广东省东莞市",
"861805140", "江苏省镇江市",
"861813506", "山西省忻州市",
"861860872", "云南省大理白族自治州",
"861301535", "山西省晋城市",
"86139939", "甘肃省陇南市",
"86138375", "河南省平顶山市",
"861536456", "山西省晋城市",
"861368709", "江西省南昌市",
"861768963", "福建省龙岩市",
"861595343", "山东省德州市",
"861839789", "江西省萍乡市",
"861850531", "山东省济南市",
"861588511", "贵州省黔东南苗族侗族自治州",
"861775699", "安徽省淮南市",
"861360819", "四川省成都市",
"861330962", "安徽省蚌埠市",
"861868833", "广东省惠州市",
"861806829", "江苏省无锡市",
"861458595", "山东省临沂市",
"861776600", "江苏省扬州市",
"861304826", "广东省梅州市",
"86151610", "江苏省泰州市",
"861820074", "广东省广州市",
"861321798", "江西省景德镇市",
"861317635", "山东省聊城市",
"861506114", "江苏省常州市",
"861302956", "内蒙古包头市",
"861365559", "安徽省芜湖市",
"861301526", "内蒙古包头市",
"861705302", "上海市",
"86152201", "广东省深圳市",
"861325549", "山东省临沂市",
"861840392", "河南省鹤壁市",
"861829825", "安徽省芜湖市",
"86170052", "江苏省苏州市",
"861500203", "广东省广州市",
"861329635", "山东省聊城市",
"861303749", "湖南省永州市",
"861364326", "河北省沧州市",
"861310389", "河南省焦作市",
"86187127", "河北省秦皇岛市",
"861517063", "江西省赣州市",
"861311539", "黑龙江省大庆市",
"861592935", "陕西省咸阳市",
"861450858", "江苏省盐城市",
"861308263", "山东省济宁市",
"861501449", "广东省云浮市",
"861580641", "山东省济南市",
"861839715", "青海省海东地区",
"861572695", "浙江省绍兴市",
"861473063", "河北省唐山市",
"861770840", "湖南省郴州市",
"861479498", "内蒙古鄂尔多斯市",
"861351510", "江苏省南京市",
"861537456", "湖北省黄冈市",
"86139288", "广东省广州市",
"861519477", "河北省保定市",
"861773041", "安徽省阜阳市",
"861374922", "河南省鹤壁市",
"861565961", "福建省三明市",
"861352589", "河南省三门峡市",
"861535378", "陕西省咸阳市",
"861582583", "甘肃省平凉市",
"861866045", "山东省潍坊市",
"86170772", "江西省赣州市",
"861302530", "广东省河源市",
"86158797", "江西省赣州市",
"861337853", "贵州省安顺市",
"861332567", "新疆克拉玛依市",
"861894892", "广东省河源市",
"861566569", "安徽省合肥市",
"861511229", "广东省深圳市",
"861334791", "江苏省无锡市",
"861568147", "四川省达州市",
"861528157", "四川省甘孜藏族自治州",
"861860686", "浙江省宁波市",
"861470439", "吉林省白山市",
"861361471", "内蒙古呼和浩特市",
"861774943", "河南省周口市",
"861570815", "四川省遂宁市",
"861893229", "江苏省盐城市",
"861390678", "浙江省丽水市",
"861831315", "云南省大理白族自治州",
"861389875", "辽宁省营口市",
"861302172", "山东省济南市",
"861452845", "甘肃省武威市",
"861853985", "河南省商丘市",
"86151615", "江苏省无锡市",
"861857796", "广西南宁市",
"86183696", "山东省潍坊市",
"861833649", "河南省周口市",
"861816891", "江苏省无锡市",
"861760512", "江苏省苏州市",
"861705352", "福建省厦门市",
"861857050", "湖南省岳阳市",
"861380024", "辽宁省沈阳市",
"861302906", "吉林省白城市",
"861322510", "江苏省无锡市",
"86188619", "江苏省盐城市",
"861334736", "湖南省常德市",
"861355762", "广西柳州市",
"861858939", "云南省昭通市",
"861366901", "湖北省鄂州市",
"861580919", "陕西省铜川市",
"861815683", "安徽省合肥市",
"861453738", "湖南省长沙市",
"861350913", "陕西省渭南市",
"861327685", "浙江省绍兴市",
"861850596", "福建省漳州市",
"861329398", "山西省朔州市",
"861889882", "广东省广州市",
"861333533", "陕西省渭南市",
"86178649", "山东省德州市",
"861809009", "四川省成都市",
"861362699", "福建省宁德市",
"86136787", "云南省昆明市",
"861589021", "河南省漯河市",
"861787643", "广东省广州市",
"861320339", "湖南省郴州市",
"861533223", "陕西省渭南市",
"861871594", "河北省承德市",
"861768642", "山东省济南市",
"861319685", "江苏省镇江市",
"86150203", "山东省临沂市",
"861771929", "河南省鹤壁市",
"861391205", "江苏省淮安市",
"861309615", "四川省资阳市",
"86130737", "河南省郑州市",
"861470792", "江西省九江市",
"861538952", "陕西省商洛市",
"861818162", "四川省内江市",
"861505489", "山东省青岛市",
"861337803", "湖南省株洲市",
"861313377", "江西省赣州市",
"861593643", "河南省南阳市",
"861337093", "山东省烟台市",
"86182142", "云南省昭通市",
"86152060", "福建省龙岩市",
"861837444", "湖南省张家界市",
"861869399", "甘肃省兰州市",
"86187408", "辽宁省阜新市",
"861300628", "江西省新余市",
"861803279", "河北省石家庄市",
"861303177", "山东省淄博市",
"861331906", "新疆阿勒泰地区",
"861866618", "广东省中山市",
"861808362", "贵州省贵阳市",
"861839422", "甘肃省天水市",
"861813640", "江苏省苏州市",
"861770746", "湖南省永州市",
"86156902", "河北省保定市",
"861826895", "浙江省衢州市",
"861822698", "安徽省池州市",
"861816730", "浙江省嘉兴市",
"861576058", "四川省南充市",
"861592981", "陕西省延安市",
"861372092", "山西省吕梁市",
"861802315", "广东省汕尾市",
"861898784", "云南省楚雄彝族自治州",
"861860338", "河北省秦皇岛市",
"861520684", "山东省临沂市",
"861370737", "湖南省益阳市",
"861330933", "甘肃省平凉市",
"861846707", "青海省海西蒙古族藏族自治州",
"861354716", "四川省广元市",
"86132917", "浙江省温州市",
"861350572", "浙江省湖州市",
"861856719", "河南省南阳市",
"861760973", "青海省黄南藏族自治州",
"86130536", "山东省潍坊市",
"861835801", "浙江省金华市",
"861395702", "浙江省衢州市",
"86134172", "广东省清远市",
"861786933", "云南省楚雄彝族自治州",
"861568779", "云南省昆明市",
"861576764", "广东省茂名市",
"861510992", "新疆伊犁哈萨克自治州",
"861319696", "江苏省淮安市",
"861583519", "山西省吕梁市",
"86156685", "辽宁省抚顺市",
"861814318", "吉林省松原市",
"861352977", "云南省玉溪市",
"861333658", "广东省阳江市",
"861304720", "湖南省岳阳市",
"8615000", "上海市",
"861454656", "云南省丽江市",
"861816001", "四川省成都市",
"86150635", "山东省聊城市",
"861475614", "河北省石家庄市",
"861340293", "陕西省咸阳市",
"861864888", "广西柳州市",
"861850585", "浙江省绍兴市",
"861327696", "福建省厦门市",
"861359940", "福建省福州市",
"861458353", "山东省东营市",
"861802196", "江苏省连云港市",
"861550397", "河南省驻马店市",
"861517032", "江西省萍乡市",
"861535410", "河北省邯郸市",
"861880952", "宁夏石嘴山市",
"86138690", "山东省威海市",
"861308741", "云南省大理白族自治州",
"86157344", "吉林省四平市",
"861558678", "湖北省咸宁市",
"86139732", "湖南省湘潭市",
"861317681", "山东省威海市",
"861509012", "河南省南阳市",
"86153519", "江苏省常州市",
"861316945", "广东省河源市",
"861476544", "山东省济南市",
"86131840", "山东省烟台市",
"861379587", "四川省遂宁市",
"86152065", "山东省聊城市",
"861332526", "山东省潍坊市",
"861892443", "广东省河源市",
"861319631", "陕西省咸阳市",
"86182521", "江苏省徐州市",
"861830511", "江苏省盐城市",
"86188912", "陕西省榆林市",
"861355733", "广西桂林市",
"861394876", "内蒙古赤峰市",
"861870660", "山东省滨州市",
"861874054", "陕西省商洛市",
"861569230", "山东省德州市",
"861327631", "山东省威海市",
"861318484", "广东省揭阳市",
"86158596", "福建省漳州市",
"861830728", "湖北省武汉市",
"861802131", "江苏省扬州市",
"861372124", "安徽省马鞍山市",
"861518847", "河南省南阳市",
"861576008", "四川省宜宾市",
"861780476", "内蒙古赤峰市",
"861321977", "陕西省汉中市",
"861330380", "河南省新乡市",
"861528248", "四川省凉山彝族自治州",
"861568258", "四川省凉山彝族自治州",
"861815402", "安徽省马鞍山市",
"861346480", "辽宁省辽阳市",
"86137578", "浙江省丽水市",
"86185657", "广东省深圳市",
"86158377", "河南省南阳市",
"86156680", "山东省烟台市",
"861340376", "河南省信阳市",
"861364367", "山西省阳泉市",
"86156851", "贵州省贵阳市",
"861300189", "河北省石家庄市",
"861336476", "新疆乌鲁木齐市",
"861378775", "湖南省郴州市",
"861331530", "河北省张家口市",
"861834479", "江苏省宿迁市",
"861454606", "青海省玉树藏族自治州",
"861818133", "四川省凉山彝族自治州",
"861597848", "河南省驻马店市",
"861835145", "江苏省南京市",
"861861799", "河北省石家庄市",
"861860695", "福建省泉州市",
"861591640", "广东省惠州市",
"861880902", "新疆哈密地区",
"861566884", "辽宁省丹东市",
"861536873", "云南省红河哈尼族彝族自治州",
"861458303", "江西省鹰潭市",
"861304867", "江苏省连云港市",
"861532449", "安徽省合肥市",
"861366447", "吉林省白城市",
"861457089", "江苏省淮安市",
"861554298", "辽宁省铁岭市",
"86150630", "山东省青岛市",
"861334830", "福建省莆田市",
"861837528", "贵州省黔东南苗族侗族自治州",
"861572686", "浙江省温州市",
"861586091", "福建省泉州市",
"861476307", "山东省滨州市",
"861803758", "河南省平顶山市",
"86151046", "黑龙江省哈尔滨市",
"861510634", "山东省莱芜市",
"861333562", "安徽省铜陵市",
"86138695", "山东省聊城市",
"861338848", "浙江省丽水市",
"861576720", "广东省广州市",
"861830000", "广东省深圳市",
"861813452", "安徽省合肥市",
"861322836", "陕西省榆林市",
"861778118", "四川省内江市",
"861833801", "河南省安阳市",
"86189239", "广东省汕头市",
"861332789", "江苏省常州市",
"861300696", "广西百色市",
"861568969", "山东省济南市",
"861566787", "陕西省安康市",
"861774980", "河北省邢台市",
"861509992", "广东省深圳市",
"861837531", "安徽省芜湖市",
"861572199", "陕西省铜川市",
"861329367", "山西省吕梁市",
"861863424", "山西省长治市",
"861840875", "云南省保山市",
"861357962", "新疆昌吉回族自治州",
"861808943", "甘肃省白银市",
"86156873", "云南省红河哈尼族彝族自治州",
"86136386", "湖北省武汉市",
"861536668", "江苏省连云港市",
"86137435", "吉林省通化市",
"861805279", "江苏省宿迁市",
"861329139", "江苏省扬州市",
"861787680", "广东省潮州市",
"861818850", "贵州省贵阳市",
"86157544", "吉林省吉林市",
"861768394", "湖北省十堰市",
"861350853", "贵州省安顺市",
"861571454", "黑龙江省佳木斯市",
"861328541", "山东省济南市",
"861580859", "贵州省黔西南布依族苗族自治州",
"861826261", "江苏省南京市",
"861533410", "湖北省随州市",
"861507684", "河北省衡水市",
"861819838", "贵州省六盘水市",
"861319628", "吉林省四平市",
"861368551", "安徽省合肥市",
"861577881", "广西河池市",
"861334153", "吉林省延边朝鲜族自治州",
"861897192", "湖北省十堰市",
"861335658", "广东省江门市",
"861593680", "河南省安阳市",
"86180323", "河北省张家口市",
"861375807", "浙江省嘉兴市",
"861760763", "广东省清远市",
"861317139", "内蒙古兴安盟",
"861570955", "宁夏中卫市",
"861878418", "四川省广安市",
"861810899", "西藏拉萨市",
"861304058", "新疆塔城地区",
"861528722", "云南省德宏傣族景颇族自治州",
"861550456", "黑龙江省黑河市",
"86150760", "河北省秦皇岛市",
"861830731", "湖南省长沙市",
"861590427", "辽宁省盘锦市",
"861590358", "山西省吕梁市",
"861309119", "河北省衡水市",
"861813402", "河北省保定市",
"861381246", "江苏省镇江市",
"86137378", "广西梧州市",
"86178024", "辽宁省沈阳市",
"861378965", "内蒙古通辽市",
"861811680", "新疆乌鲁木齐市",
"861840644", "山西省临汾市",
"86135749", "湖南省邵阳市",
"861518411", "辽宁省铁岭市",
"861332598", "浙江省温州市",
"861319189", "河北省承德市",
"861874978", "河南省焦作市",
"86158396", "河南省驻马店市",
"861337913", "陕西省渭南市",
"861586649", "山东省烟台市",
"86150946", "黑龙江省鸡西市",
"861560561", "安徽省淮北市",
"86182321", "河北省石家庄市",
"861572948", "河南省周口市",
"861477073", "江西省南昌市",
"861853016", "河南省焦作市",
"861817888", "广西河池市",
"861858349", "四川省巴中市",
"861459646", "甘肃省白银市",
"861830796", "江西省吉安市",
"861778636", "湖北省武汉市",
"861479467", "黑龙江省鸡西市",
"86137430", "吉林省长春市",
"861596972", "山东省临沂市",
"861576867", "广东省湛江市",
"861855931", "福建省厦门市",
"861816510", "陕西省西安市",
"861884570", "黑龙江省大兴安岭地区",
"861818800", "贵州省贵阳市",
"861335562", "安徽省铜陵市",
"86136417", "上海市",
"861785848", "浙江省温州市",
"861322891", "西藏拉萨市",
"861310048", "广西河池市",
"861770883", "云南省临沧市",
"861368501", "福建省福州市",
"861369564", "安徽省六安市",
"861848514", "贵州省贵阳市",
"861571404", "辽宁省盘锦市",
"861800821", "四川省泸州市",
"861551433", "河南省信阳市",
"861350803", "四川省泸州市",
"861573393", "河北省邢台市",
"861570905", "新疆吐鲁番地区",
"861362316", "河北省廊坊市",
"861556127", "内蒙古包头市",
"86189683", "浙江省宁波市",
"861320949", "甘肃省白银市",
"861833145", "河北省衡水市",
"861899042", "四川省阿坝藏族羌族自治州",
"86139662", "安徽省六安市",
"861316381", "福建省龙岩市",
"861860321", "河北省石家庄市",
"861326396", "江西省吉安市",
"861321767", "广东省潮州市",
"861452793", "新疆和田地区",
"86184688", "江苏省南京市",
"86183856", "贵州省黔南布依族苗族自治州",
"86150765", "河北省唐山市",
"861591452", "广东省广州市",
"861351836", "四川省遂宁市",
"86158577", "浙江省温州市",
"86133624", "浙江省宁波市",
"861550406", "辽宁省锦州市",
"861881870", "广东省深圳市",
"861513657", "河南省驻马店市",
"861339310", "河北省邯郸市",
"861582540", "浙江省温州市",
"861810059", "福建省莆田市",
"861871446", "黑龙江省双鸭山市",
"861377904", "新疆巴音郭楞蒙古自治州",
"861357933", "新疆喀什地区",
"861500477", "内蒙古鄂尔多斯市",
"861321726", "湖北省荆州市",
"861337572", "浙江省湖州市",
"86147047", "广东省广州市",
"86138681", "浙江省杭州市",
"861534289", "湖北省武汉市",
"861363559", "安徽省黄山市",
"86131487", "广东省深圳市",
"86138850", "贵州省贵阳市",
"861323549", "湖北省孝感市",
"861830785", "广西玉林市",
"861831689", "广东省云浮市",
"861350093", "吉林省白山市",
"861346443", "辽宁省抚顺市",
"861820958", "宁夏银川市",
"861528415", "四川省宜宾市",
"86134769", "湖北省咸宁市",
"861850444", "吉林省四平市",
"861860948", "甘肃省兰州市",
"861364398", "河南省三门峡市",
"86145325", "上海市",
"861330343", "山西省太原市",
"861834993", "四川省成都市",
"861874797", "内蒙古呼和浩特市",
"861322001", "陕西省延安市",
"861833036", "河北省秦皇岛市",
"861333713", "内蒙古兴安盟",
"861373917", "江苏省苏州市",
"861773699", "河北省沧州市",
"861301598", "福建省莆田市",
"861576826", "广东省惠州市",
"861760732", "湖南省湘潭市",
"861531413", "山东省日照市",
"861527203", "湖北省黄石市",
"861594999", "山东省日照市",
"861355156", "四川省雅安市",
"861322730", "湖北省孝感市",
"86155199", "贵州省黔西南布依族苗族自治州",
"861323823", "辽宁省盘锦市",
"861882692", "广东省珠海市",
"861334516", "山东省烟台市",
"861533378", "河南省开封市",
"861452469", "黑龙江省双鸭山市",
"861390863", "湖北省武汉市",
"861330772", "广西柳州市",
"861823633", "河南省周口市",
"861326385", "广西来宾市",
"861890871", "云南省昆明市",
"861771146", "四川省德阳市",
"861807074", "广西南宁市",
"86130667", "辽宁省沈阳市",
"861775041", "福建省福州市",
"861569765", "广东省揭阳市",
"861779953", "新疆阿克苏地区",
"861331816", "广东省梅州市",
"861889376", "甘肃省张掖市",
"861894283", "四川省甘孜藏族自治州",
"861523426", "山西省太原市",
"86138468", "黑龙江省鹤岗市",
"861358427", "江苏省苏州市",
"861590466", "黑龙江省鸡西市",
"861880812", "四川省广元市",
"861394960", "河南省新乡市",
"861453284", "山西省忻州市",
"861398456", "贵州省毕节地区",
"861818706", "云南省昆明市",
"861813683", "江苏省泰州市",
"861397176", "湖北省黄石市",
"861810009", "上海市",
"86138855", "贵州省黔东南苗族侗族自治州",
"861363509", "广西梧州市",
"861306046", "陕西省汉中市",
"86170808", "上海市",
"86156691", "浙江省宁波市",
"86145320", "浙江省杭州市",
"861311719", "湖北省荆州市",
"861360297", "广东省肇庆市",
"861820908", "新疆克孜勒苏柯尔克孜自治州",
"861362041", "广东省广州市",
"861367839", "四川省广元市",
"861351730", "湖南省岳阳市",
"861395127", "江苏省镇江市",
"861867629", "广东省中山市",
"861857511", "广东省茂名市",
"861804049", "四川省广元市",
"86155562", "安徽省宿州市",
"861322051", "山东省东营市",
"86183677", "浙江省温州市",
"861503489", "内蒙古鄂尔多斯市",
"861567243", "湖北省荆州市",
"861889293", "新疆塔城地区",
"861559197", "陕西省商洛市",
"86137993", "福建省福州市",
"861535223", "甘肃省陇南市",
"861513419", "辽宁省锦州市",
"861850528", "江苏省徐州市",
"861864825", "内蒙古包头市",
"861705075", "广东省佛山市",
"861384654", "黑龙江省黑河市",
"861524975", "河南省商丘市",
"861364635", "山东省聊城市",
"86185897", "重庆市",
"861882934", "陕西省西安市",
"861779903", "新疆和田地区",
"861337130", "山东省滨州市",
"861335533", "山东省淄博市",
"861866703", "浙江省杭州市",
"861318545", "浙江省湖州市",
"861822945", "湖南省永州市",
"861317326", "山东省淄博市",
"861551462", "河南省周口市",
"861892178", "江苏省徐州市",
"861359983", "福建省宁德市",
"861339478", "内蒙古巴彦淖尔市",
"86131316", "河北省廊坊市",
"861822667", "安徽省蚌埠市",
"861800672", "浙江省湖州市",
"861589989", "广东省深圳市",
"861807269", "浙江省金华市",
"861804325", "吉林省吉林市",
"861571390", "河南省焦作市",
"86187315", "河北省唐山市",
"861570756", "广东省湛江市",
"861368005", "广东省韶关市",
"86839", "四川省广元市",
"861559547", "宁夏中卫市",
"861366313", "河北省张家口市",
"861597690", "广东省汕头市",
"861506416", "山东省泰安市",
"861800323", "河北省张家口市",
"861836918", "山东省威海市",
"861893182", "河北省衡水市",
"861819759", "新疆博尔塔拉蒙古自治州",
"861399409", "山西省忻州市",
"861453919", "广东省江门市",
"861858718", "云南省丽江市",
"861322393", "河南省濮阳市",
"861580738", "湖南省娄底市",
"861860823", "四川省达州市",
"861521132", "湖南省常德市",
"861520973", "青海省黄南藏族自治州",
"861360633", "山东省日照市",
"861809574", "青海省海南藏族自治州",
"861535405", "河北省唐山市",
"861381360", "江苏省南通市",
"861308503", "安徽省六安市",
"861318195", "山东省东营市",
"861835729", "浙江省湖州市",
"86180416", "辽宁省锦州市",
"861503694", "河南省驻马店市",
"861589799", "湖北省襄樊市",
"861552570", "山西省运城市",
"861867749", "广西贺州市",
"861313325", "山西省长治市",
"861570090", "新疆阿勒泰地区",
"86155574", "浙江省宁波市",
"861389827", "辽宁省辽阳市",
"861339072", "江苏省盐城市",
"861587538", "广东省汕头市",
"861881230", "云南省普洱市",
"861886661", "山东省济南市",
"861368886", "广东省广州市",
"861478429", "河南省周口市",
"861828901", "西藏拉萨市",
"861363958", "宁夏银川市",
"861556679", "辽宁省朝阳市",
"861315118", "江苏省苏州市",
"861353454", "广东省揭阳市",
"86155938", "甘肃省天水市",
"861323948", "甘肃省张掖市",
"861500563", "安徽省宣城市",
"86189627", "江苏省南通市",
"861820559", "安徽省黄山市",
"861318316", "河南省安阳市",
"861771531", "江苏省无锡市",
"861855795", "浙江省宁波市",
"86177345", "河北省石家庄市",
"861510370", "河南省商丘市",
"861370274", "广东省佛山市",
"861860549", "山东省临沂市",
"861589214", "福建省宁德市",
"861348179", "广西柳州市",
"861537154", "江苏省连云港市",
"86152278", "河北省石家庄市",
"861841912", "甘肃省定西市",
"861568483", "新疆伊犁哈萨克自治州",
"861347459", "陕西省汉中市",
"861538474", "内蒙古乌兰察布市",
"861479912", "新疆喀什地区",
"861301999", "辽宁省葫芦岛市",
"861308386", "河南省安阳市",
"861361656", "浙江省宁波市",
"861350351", "山西省太原市",
"861890285", "广东省深圳市",
"861328045", "山东省聊城市",
"861896594", "福建省莆田市",
"86187310", "河北省邯郸市",
"861534914", "陕西省商洛市",
"861321646", "浙江省绍兴市",
"861399459", "山西省晋中市",
"861332257", "西藏阿里地区",
"861700761", "广东省中山市",
"861512969", "陕西省汉中市",
"861308553", "安徽省芜湖市",
"861771596", "江苏省常州市",
"861394865", "内蒙古通辽市",
"861768248", "浙江省杭州市",
"861535455", "吉林省延边朝鲜族自治州",
"861898878", "广东省深圳市",
"86151273", "河北省张家口市",
"86155733", "湖南省株洲市",
"861571733", "湖南省株洲市",
"861593309", "河北省邢台市",
"86137059", "福建省福州市",
"861813898", "广东省江门市",
"861827278", "河南省南阳市",
"861811359", "四川省德阳市",
"861862850", "陕西省渭南市",
"861773484", "河南省洛阳市",
"861533117", "辽宁省辽阳市",
"861707561", "安徽省芜湖市",
"861521570", "浙江省衢州市",
"86180387", "广东省佛山市",
"861354095", "四川省南充市",
"861868941", "广东省广州市",
"861373433", "山东省日照市",
"86153718", "江苏省苏州市",
"861312551", "辽宁省抚顺市",
"861577506", "广东省湛江市",
"861830995", "新疆吐鲁番地区",
"861817877", "广西钦州市",
"861588986", "广东省珠海市",
"861315636", "山东省青岛市",
"861351393", "河南省濮阳市",
"861826623", "山东省青岛市",
"86137779", "浙江省宁波市",
"861525092", "江苏省徐州市",
"861331043", "贵州省安顺市",
"861820509", "江苏省南京市",
"861834783", "内蒙古包头市",
"861453641", "江苏省镇江市",
"861782011", "广东省茂名市",
"861569927", "新疆巴音郭楞蒙古自治州",
"861336465", "吉林省辽源市",
"861347409", "陕西省咸阳市",
"861829877", "甘肃省白银市",
"861340365", "山西省晋中市",
"861537104", "江苏省南京市",
"861301148", "河北省廊坊市",
"861771585", "江苏省扬州市",
"861879522", "宁夏石嘴山市",
"861705571", "浙江省杭州市",
"861868457", "湖南省衡阳市",
"861502937", "陕西省宝鸡市",
"861311348", "广东省汕头市",
"861360662", "浙江省杭州市",
"861569966", "黑龙江省哈尔滨市",
"861840970", "青海省海北藏族自治州",
"861532960", "贵州省贵阳市",
"861534707", "湖北省武汉市",
"861511312", "广东省汕头市",
"861351505", "福建省泉州市",
"861368780", "广西柳州市",
"86147293", "陕西省渭南市",
"861840724", "湖北省荆门市",
"861839700", "青海省海北藏族自治州",
"861564582", "黑龙江省鸡西市",
"861333252", "湖南省湘潭市",
"861815867", "浙江省绍兴市",
"861812150", "江苏省无锡市",
"861529421", "甘肃省兰州市",
"861808828", "云南省文山壮族苗族自治州",
"861533387", "河南省周口市",
"861837146", "湖北省武汉市",
"861591764", "广东省清远市",
"861385942", "福建省三明市",
"861308638", "四川省遂宁市",
"861853843", "河南省郑州市",
"861301257", "山东省烟台市",
"861318041", "河北省唐山市",
"861558272", "山西省临汾市",
"861539675", "江苏省扬州市",
"861309650", "山西省阳泉市",
"861865126", "江苏省淮安市",
"861471542", "广东省清远市",
"861802494", "广东省佛山市",
"861348747", "湖南省永州市",
"861570850", "贵州省贵阳市",
"861304402", "山东省泰安市",
"861847524", "广东省揭阳市",
"861302043", "内蒙古包头市",
"861780651", "广东省惠州市",
"861328136", "四川省德阳市",
"861320424", "辽宁省抚顺市",
"861776615", "江苏省宿迁市",
"86187471", "内蒙古赤峰市",
"861870744", "湖南省张家界市",
"861899448", "江苏省镇江市",
"861332148", "吉林省松原市",
"86189382", "广东省东莞市",
"86182086", "贵州省黔西南布依族苗族自治州",
"861577113", "湖北省孝感市",
"861535661", "浙江省嘉兴市",
"861510418", "辽宁省阜新市",
"861322555", "安徽省马鞍山市",
"861321925", "四川省广安市",
"861362545", "山东省烟台市",
"86139674", "浙江省金华市",
"861500532", "山东省青岛市",
"861504061", "辽宁省大连市",
"861367708", "江西省南昌市",
"861500488", "内蒙古赤峰市",
"861770335", "河北省秦皇岛市",
"861598351", "四川省雅安市",
"86132428", "广东省广州市",
"861898014", "四川省绵阳市",
"861576640", "广东省湛江市",
"861339487", "内蒙古巴彦淖尔市",
"861571762", "河北省廊坊市",
"861770698", "福建省三明市",
"861868407", "四川省南充市",
"861390361", "黑龙江省哈尔滨市",
"861890373", "河南省新乡市",
"861822746", "四川省甘孜藏族自治州",
"861318186", "山东省东营市",
"861587077", "江西省抚州市",
"861365818", "四川省乐山市",
"861537822", "四川省绵阳市",
"861330155", "江苏省苏州市",
"861870411", "辽宁省大连市",
"861583098", "河北省石家庄市",
"861856938", "湖南省永州市",
"86151452", "黑龙江省齐齐哈尔市",
"861777128", "湖北省宜昌市",
"861534757", "广东省湛江市",
"861351555", "安徽省马鞍山市",
"86131423", "湖南省衡阳市",
"861305318", "安徽省亳州市",
"861360558", "安徽省阜阳市",
"861452330", "河南省信阳市",
"861454471", "陕西省延安市",
"86151182", "广东省东莞市",
"861320548", "山东省东营市",
"861572823", "广东省河源市",
"861378860", "广西南宁市",
"86155911", "陕西省延安市",
"861520512", "江苏省连云港市",
"861391210", "江苏省镇江市",
"861309600", "四川省自贡市",
"861815974", "福建省南平市",
"861301207", "河北省保定市",
"861801109", "四川省凉山彝族自治州",
"861831300", "云南省大理白族自治州",
"861376576", "贵州省黔南布依族苗族自治州",
"861304452", "福建省漳州市",
"861570800", "西藏拉萨市",
"861519712", "湖南省岳阳市",
"861470324", "河北省承德市",
"861342446", "广东省广州市",
"861522917", "陕西省宝鸡市",
"861829693", "江西省萍乡市",
"861303125", "新疆巴音郭楞蒙古自治州",
"861591008", "山东省济南市",
"861354141", "四川省遂宁市",
"86136021", "天津市",
"861813764", "河南省驻马店市",
"86158241", "浙江省杭州市",
"861308395", "浙江省杭州市",
"861332999", "湖北省咸宁市",
"861364244", "广东省汕尾市",
"861319748", "湖北省荆州市",
"861890231", "广东省深圳市",
"861893312", "广东省揭阳市",
"861880474", "内蒙古乌兰察布市",
"861572549", "山东省临沂市",
"861530379", "河南省洛阳市",
"86137501", "广东省清远市",
"861768107", "安徽省阜阳市",
"861336174", "江西省萍乡市",
"861871879", "广东省深圳市",
"861774056", "湖北省襄樊市",
"861322505", "福建省三明市",
"861818905", "西藏昌都地区",
"861450519", "吉林省通化市",
"861358120", "湖北省恩施土家族苗族自治州",
"861333040", "云南省红河哈尼族彝族自治州",
"861598301", "四川省泸州市",
"861373462", "青海省海东地区",
"861367758", "新疆哈密地区",
"861877428", "湖南省郴州市",
"861528642", "贵州省铜仁地区",
"861890742", "湖南省常德市",
"861779046", "四川省自贡市",
"861555369", "山东省烟台市",
"861815008", "福建省厦门市",
"861847560", "广东省深圳市",
"86186736", "湖南省常德市",
"861527532", "山东省青岛市",
"861508044", "福建省泉州市",
"861535387", "陕西省榆林市",
"861393420", "山西省太原市",
"86183825", "四川省遂宁市",
"861479802", "黑龙江省哈尔滨市",
"861835595", "安徽省黄山市",
"86180786", "广西百色市",
"861359151", "辽宁省丹东市",
"861459798", "新疆乌鲁木齐市",
"861830648", "山东省青岛市",
"861862910", "陕西省咸阳市",
"861877431", "湖南省湘西土家族苗族自治州",
"861813867", "广东省江门市",
"861337301", "河北省石家庄市",
"861335252", "黑龙江省齐齐哈尔市",
"861519488", "河北省保定市",
"861839916", "新疆和田地区",
"861823268", "河北省廊坊市",
"861327222", "湖南省张家界市",
"861826990", "安徽省池州市",
"861302755", "河南省新乡市",
"861382451", "广东省佛山市",
"861856921", "湖南省张家界市",
"861332019", "江西省抚州市",
"86153554", "浙江省杭州市",
"861306903", "吉林省四平市",
"861590475", "内蒙古通辽市",
"861566017", "河南省南阳市",
"861560251", "广东省茂名市",
"861339593", "福建省宁德市",
"861359845", "河南省洛阳市",
"861840760", "广东省中山市",
"861822883", "四川省广元市",
"861569776", "广西百色市",
"861522097", "广东省佛山市",
"861314064", "河南省周口市",
"861889365", "甘肃省庆阳市",
"861520732", "湖南省湘潭市",
"861855529", "安徽省池州市",
"861532924", "贵州省黔南布依族苗族自治州",
"861531554", "山东省青岛市",
"861318699", "浙江省杭州市",
"86156752", "湖南省湘潭市",
"861591720", "广东省揭阳市",
"861528400", "四川省绵阳市",
"861534854", "贵州省六盘水市",
"86139563", "安徽省蚌埠市",
"86136723", "广东省肇庆市",
"86189582", "浙江省宁波市",
"861836808", "浙江省舟山市",
"86134568", "浙江省杭州市",
"861331080", "广东省东莞市",
"861539747", "浙江省台州市",
"86137599", "陕西省西安市",
"861880669", "广东省茂名市",
"861450492", "辽宁省丹东市",
"861801461", "江苏省连云港市",
"861550671", "广西来宾市",
"861813974", "甘肃省武威市",
"861300748", "湖南省长沙市",
"861510782", "广西柳州市",
"861777196", "湖北省黄冈市",
"861812833", "广东省揭阳市",
"861503342", "河北省石家庄市",
"861313388", "江西省景德镇市",
"861887272", "湖北省黄冈市",
"861813720", "河南省焦作市",
"861504576", "黑龙江省鸡西市",
"861303318", "安徽省安庆市",
"861576452", "黑龙江省齐齐哈尔市",
"86183820", "四川省成都市",
"86159648", "山东省临沂市",
"86136928", "广东省惠州市",
"861337351", "河北省石家庄市",
"86153661", "江苏省南京市",
"861598437", "四川省乐山市",
"861323695", "辽宁省抚顺市",
"861865949", "福建省莆田市",
"8615618", "上海市",
"86187453", "黑龙江省牡丹江市",
"861894458", "黑龙江省大庆市",
"861868273", "四川省成都市",
"861363818", "贵州省毕节地区",
"861348844", "陕西省榆林市",
"861596404", "山东省潍坊市",
"861375462", "山东省威海市",
"861335040", "四川省南充市",
"86134164", "广东省广州市",
"861387285", "湖北省随州市",
"861346317", "河北省沧州市",
"861854306", "吉林省白城市",
"861476022", "福建省漳州市",
"86153488", "海南省海口市",
"861306953", "河南省许昌市",
"861302705", "山西省晋中市",
"861330417", "辽宁省营口市",
"861709423", "广东省惠州市",
"861304640", "山东省烟台市",
"861334935", "黑龙江省绥化市",
"861531504", "山东省东营市",
"861571972", "青海省海东地区",
"861356309", "山东省滨州市",
"861898994", "西藏林芝地区",
"861594567", "黑龙江省哈尔滨市",
"861527170", "湖北省鄂州市",
"861705066", "上海市",
"861534804", "甘肃省临夏回族自治州",
"861528450", "云南省昭通市",
"861524966", "河南省郑州市",
"861378824", "广西梧州市",
"861390687", "浙江省温州市",
"861529438", "甘肃省天水市",
"861808831", "云南省昆明市",
"861453859", "甘肃省酒泉市",
"861308621", "青海省海西蒙古族藏族自治州",
"86134227", "广东省江门市",
"86153158", "山东省德州市",
"861878634", "贵州省遵义市",
"86187846", "四川省宜宾市",
"86155018", "海南省海口市",
"861857995", "广西玉林市",
"86139818", "四川省成都市",
"861311938", "甘肃省天水市",
"861850146", "江苏省南通市",
"861377472", "福建省三明市",
"86136240", "辽宁省沈阳市",
"861831546", "山东省东营市",
"861558687", "湖北省随州市",
"86158442", "吉林省吉林市",
"86155374", "河南省许昌市",
"861323686", "辽宁省锦州市",
"861532876", "四川省眉山市",
"861569870", "辽宁省锦州市",
"861840866", "宁夏吴忠市",
"861534094", "山西省吕梁市",
"861705027", "吉林省长春市",
"861313691", "黑龙江省绥化市",
"861576683", "广东省惠州市",
"861554344", "吉林省四平市",
"861538669", "四川省德阳市",
"86134813", "广西桂林市",
"861882298", "广东省东莞市",
"861807559", "湖南省怀化市",
"861594526", "黑龙江省黑河市",
"861533405", "湖北省宜昌市",
"861776119", "四川省成都市",
"861522857", "四川省攀枝花市",
"861332473", "广西桂林市",
"861352988", "云南省曲靖市",
"861817774", "广西南宁市",
"861362484", "内蒙古呼和浩特市",
"861832461", "黑龙江省哈尔滨市",
"861399161", "陕西省汉中市",
"861339355", "山西省长治市",
"861772908", "陕西省西安市",
"861556464", "山东省潍坊市",
"861509370", "河南省焦作市",
"861808056", "四川省成都市",
"861539179", "安徽省马鞍山市",
"861830015", "广东省揭阳市",
"861800759", "广东省湛江市",
"861315049", "新疆乌鲁木齐市",
"86151251", "云南省大理白族自治州",
"861780849", "贵州省毕节地区",
"861771444", "江苏省苏州市",
"861571513", "江苏省连云港市",
"861350437", "吉林省辽源市",
"861857986", "广西玉林市",
"861585808", "浙江省舟山市",
"861592830", "四川省德阳市",
"861387296", "湖北省武汉市",
"861365958", "西藏山南地区",
"861336523", "江苏省泰州市",
"861770667", "浙江省温州市",
"861330609", "福建省泉州市",
"861331705", "江西省南昌市",
"861554507", "黑龙江省大兴安岭地区",
"861859991", "四川省南充市",
"861363074", "吉林省四平市",
"861333083", "四川省达州市",
"861859500", "宁夏中卫市",
"861381324", "江苏省盐城市",
"861708579", "江苏省淮安市",
"861808790", "云南省普洱市",
"86138826", "四川省广安市",
"861770945", "甘肃省武威市",
"861769614", "山西省临汾市",
"861520763", "广东省清远市",
"861303188", "河北省秦皇岛市",
"86135144", "吉林省长春市",
"861398671", "湖北省荆州市",
"861898663", "湖北省咸宁市",
"861810574", "浙江省宁波市",
"861806193", "江苏省苏州市",
"861453099", "山西省长治市",
"861816505", "陕西省安康市",
"861378102", "河南省三门峡市",
"861771711", "河北省石家庄市",
"86187272", "湖北省宜昌市",
"861368743", "广东省佛山市",
"861818815", "贵州省黔东南苗族侗族自治州",
"861595309", "山东省日照市",
"86158025", "湖南省长沙市",
"86188561", "安徽省淮北市",
"861808885", "广东省梅州市",
"861367613", "广东省汕头市",
"861303470", "内蒙古锡林郭勒盟",
"861570910", "陕西省西安市",
"86181029", "广东省东莞市",
"861378976", "内蒙古赤峰市",
"861452940", "广东省江门市",
"861550822", "四川省达州市",
"861859936", "新疆巴音郭楞蒙古自治州",
"861334981", "湖北省孝感市",
"861357155", "陕西省铜川市",
"861303629", "江西省萍乡市",
"86187510", "江苏省宿迁市",
"861358475", "江苏省盐城市",
"861339305", "河北省唐山市",
"86145356", "贵州省贵阳市",
"861700971", "青海省西宁市",
"861800709", "江西省南昌市",
"861347161", "广西河池市",
"86186537", "山东省济宁市",
"861580721", "湖北省荆州市",
"861500425", "辽宁省大连市",
"86135548", "广东省深圳市",
"861338690", "福建省莆田市",
"861302080", "河北省保定市",
"861458145", "浙江省温州市",
"861582033", "广东省清远市",
"861321988", "四川省德阳市",
"861357841", "云南省西双版纳傣族自治州",
"861301019", "北京市",
"861479092", "安徽省宿州市",
"86176402", "辽宁省沈阳市",
"86180587", "浙江省杭州市",
"861331755", "湖北省襄樊市",
"861554557", "黑龙江省哈尔滨市",
"861380542", "山东省青岛市",
"861316746", "江苏省南通市",
"861325199", "浙江省丽水市",
"861365908", "四川省南充市",
"861825297", "江苏省镇江市",
"861510245", "辽宁省丹东市",
"861368372", "河南省安阳市",
"861781774", "广东省清远市",
"861815898", "安徽省蚌埠市",
"861379578", "四川省甘孜藏族自治州",
"861311089", "福建省福州市",
"86170871", "湖北省武汉市",
"861760384", "河南省郑州市",
"861572414", "广东省茂名市",
"861569274", "贵州省贵阳市",
"861801072", "安徽省安庆市",
"86185325", "河北省唐山市",
"861325386", "河南省焦作市",
"861788120", "新疆阿勒泰地区",
"861829505", "宁夏中卫市",
"8617782", "陕西省西安市",
"861313625", "浙江省舟山市",
"861863046", "河北省秦皇岛市",
"86170080", "重庆市",
"86150479", "内蒙古锡林郭勒盟",
"861360333", "河北省沧州市",
"861500436", "吉林省白城市",
"861889169", "陕西省安康市",
"861830938", "甘肃省天水市",
"861310546", "山东省东营市",
"861535272", "新疆克拉玛依市",
"861787659", "广东省茂名市",
"861818889", "广东省东莞市",
"86176030", "广东省深圳市",
"861705779", "陕西省西安市",
"861807193", "湖北省恩施土家族苗族自治州",
"861770681", "浙江省杭州市",
"861324910", "广东省江门市",
"861700884", "广东省广州市",
"861563894", "河南省郑州市",
"861586521", "山东省滨州市",
"861812748", "广东省韶关市",
"861808819", "云南省德宏傣族景颇族自治州",
"861583081", "河北省沧州市",
"861478370", "河南省商丘市",
"861375071", "浙江省舟山市",
"861317746", "湖北省十堰市",
"861303703", "山西省朔州市",
"861804745", "内蒙古呼和浩特市",
"861391954", "甘肃省平凉市",
"861301085", "陕西省西安市",
"861332096", "四川省成都市",
"861705208", "北京市",
"861840298", "陕西省渭南市",
"861334874", "湖南省张家界市",
"86177017", "上海市",
"861325503", "福建省泉州市",
"861879426", "甘肃省定西市",
"861314313", "广东省珠海市",
"861361583", "浙江省嘉兴市",
"86155968", "陕西省西安市",
"861329746", "湖南省永州市",
"861898942", "浙江省金华市",
"861889337", "甘肃省酒泉市",
"861859925", "新疆吐鲁番地区",
"861390455", "黑龙江省绥化市",
"861852469", "辽宁省阜新市",
"861510429", "辽宁省葫芦岛市",
"861304383", "辽宁省铁岭市",
"861332750", "山西省忻州市",
"861810705", "江西省宜春市",
"861356841", "四川省德阳市",
"861360980", "辽宁省鞍山市",
"861777119", "湖北省黄石市",
"861829555", "宁夏中卫市",
"86185320", "河北省秦皇岛市",
"861848924", "西藏林芝地区",
"861846215", "山东省烟台市",
"861890897", "西藏阿里地区",
"86188074", "湖南省长沙市",
"861869545", "宁夏银川市",
"861821469", "云南省保山市",
"861823006", "河北省廊坊市",
"861337849", "广东省东莞市",
"86188331", "河北省石家庄市",
"861537371", "河北省衡水市",
"861569069", "河南省南阳市",
"861709717", "广东省佛山市",
"86155763", "湖南省娄底市",
"861330723", "湖北省黄石市",
"861370927", "陕西省宝鸡市",
"861317292", "广东省清远市",
"861532682", "内蒙古兴安盟",
"861848770", "云南省玉溪市",
"861323872", "云南省大理白族自治州",
"86134311", "广东省东莞市",
"861816920", "湖南省郴州市",
"861383994", "河南省驻马店市",
"861508092", "湖南省邵阳市",
"861309494", "江苏省淮安市",
"861304556", "安徽省安庆市",
"861809043", "四川省阿坝藏族羌族自治州",
"861787609", "广东省广州市",
"861815266", "湖南省常德市",
"861501453", "广东省中山市",
"861361356", "山西省晋城市",
"861305329", "安徽省池州市",
"861321346", "河南省驻马店市",
"861839148", "陕西省西安市",
"86133129", "广东省深圳市",
"861392448", "广东省梅州市",
"861337523", "江苏省盐城市",
"861335120", "黑龙江省哈尔滨市",
"86186367", "山西省临汾市",
"861572741", "湖南省怀化市",
"861327150", "河南省洛阳市",
"861340947", "河南省平顶山市",
"861580795", "江西省宜春市",
"861325553", "山东省烟台市",
"861572232", "青海省海西蒙古族藏族自治州",
"861315336", "山东省淄博市",
"861365543", "山东省滨州市",
"861328470", "内蒙古包头市",
"861705258", "北京市",
"861367140", "广东省潮州市",
"861877419", "湖南省株洲市",
"861584983", "内蒙古兴安盟",
"861318138", "山东省德州市",
"861833603", "河南省商丘市",
"861369706", "江西省吉安市",
"861454190", "山西省太原市",
"861810755", "广东省深圳市",
"861811659", "四川省成都市",
"861774909", "陕西省铜川市",
"86145897", "广东省深圳市",
"861334967", "湖南省郴州市",
"861332700", "内蒙古呼伦贝尔市",
"861397369", "湖南省益阳市",
"861450528", "吉林省辽源市",
"861319150", "内蒙古赤峰市",
"861320813", "四川省自贡市",
"861856986", "河南省郑州市",
"861336351", "山西省太原市",
"86182440", "吉林省长春市",
"861539375", "河南省三门峡市",
"86155694", "新疆喀什地区",
"861835521", "安徽省阜阳市",
"861317840", "广东省韶关市",
"861858729", "云南省德宏傣族景颇族自治州",
"86182022", "天津市",
"861340451", "吉林省通化市",
"86189326", "河北省保定市",
"861459515", "云南省保山市",
"861309350", "安徽省马鞍山市",
"861334926", "安徽省安庆市",
"861300862", "云南省楚雄彝族自治州",
"861308338", "安徽省亳州市",
"861533687", "浙江省杭州市",
"861532453", "安徽省芜湖市",
"86130229", "陕西省西安市",
"861589900", "新疆巴音郭楞蒙古自治州",
"861369850", "贵州省安顺市",
"86170998", "广东省汕头市",
"861587586", "广东省茂名市",
"861301031", "上海市",
"861776196", "江苏省南通市",
"861593417", "山西省晋城市",
"861329840", "河南省郑州市",
"861577452", "黑龙江省齐齐哈尔市",
"861868628", "内蒙古通辽市",
"861311648", "贵州省铜仁地区",
"861595155", "江苏省盐城市",
"86134470", "上海市",
"861860741", "湖南省株洲市",
"861820751", "广东省韶关市",
"861478418", "河南省信阳市",
"861815227", "甘肃省庆阳市",
"861361468", "黑龙江省鸡西市",
"861315129", "江苏省常州市",
"861770635", "山东省聊城市",
"861325638", "山东省烟台市",
"86137803", "河北省秦皇岛市",
"86185907", "陕西省宝鸡市",
"861301700", "贵州省铜仁地区",
"861583035", "河北省秦皇岛市",
"861508802", "广东省佛山市",
"861344784", "广西钦州市",
"861780351", "山西省太原市",
"861810080", "四川省成都市",
"861347317", "河北省沧州市",
"861370966", "广东省佛山市",
"861387219", "湖北省咸宁市",
"86139333", "河北省唐山市",
"861887117", "湖北省武汉市",
"861307953", "宁夏吴忠市",
"861350465", "黑龙江省大庆市",
"86134338", "广东省汕头市",
"861892459", "广东省深圳市",
"861580786", "广西百色市",
"861516582", "山东省聊城市",
"861363580", "湖北省襄樊市",
"861312709", "山东省日照市",
"861304275", "湖北省随州市",
"861831650", "广东省中山市",
"861394734", "内蒙古乌海市",
"861800010", "江苏省徐州市",
"86188318", "河北省衡水市",
"861334018", "江西省抚州市",
"86180686", "江苏省南通市",
"86186444", "上海市",
"861340401", "四川省绵阳市",
"861315688", "山东省青岛市",
"861505642", "安徽省六安市",
"861860414", "辽宁省本溪市",
"861850918", "陕西省榆林市",
"861589950", "广东省惠州市",
"861859646", "福建省泉州市",
"861458349", "江西省景德镇市",
"861884957", "河北省沧州市",
"861452630", "江苏省扬州市",
"861532403", "河北省张家口市",
"861879467", "甘肃省天水市",
"861827990", "江西省吉安市",
"861594581", "黑龙江省鹤岗市",
"861832072", "广东省广州市",
"861778677", "湖北省襄樊市",
"861838880", "云南省丽江市",
"861503450", "山西省长治市",
"861369800", "江西省南昌市",
"86186636", "山东省潍坊市",
"861526532", "山东省青岛市",
"861770398", "河南省三门峡市",
"861332806", "江苏省南通市",
"861390661", "浙江省宁波市",
"861890673", "浙江省嘉兴市",
"861819501", "宁夏银川市",
"861819990", "新疆乌鲁木齐市",
"861700569", "安徽省合肥市",
"86138027", "广东省广州市",
"861801487", "江苏省苏州市",
"861598601", "广东省河源市",
"861820701", "江西省鹰潭市",
"86159943", "广西南宁市",
"86136623", "广东省广州市",
"861837808", "广西桂林市",
"861353690", "广东省汕头市",
"861595105", "江苏省扬州市",
"86170793", "甘肃省兰州市",
"861530679", "浙江省金华市",
"861301750", "河南省焦作市",
"861811417", "江苏省常州市",
"861374732", "内蒙古乌海市",
"861518324", "四川省资阳市",
"861477194", "湖北省荆州市",
"861857921", "江西省九江市",
"861707769", "云南省玉溪市",
"861776131", "四川省成都市",
"861332085", "四川省德阳市",
"861313946", "甘肃省庆阳市",
"861351877", "云南省玉溪市",
"861301096", "新疆乌鲁木齐市",
"861308695", "贵州省黔东南苗族侗族自治州",
"861508852", "浙江省绍兴市",
"86156308", "河北省保定市",
"861530420", "辽宁省铁岭市",
"861831600", "广东省云浮市",
"861890057", "安徽省宿州市",
"861368287", "广东省汕头市",
"86151126", "广东省深圳市",
"86156652", "山东省枣庄市",
"861827010", "江西省鹰潭市",
"861393379", "河北省秦皇岛市",
"861896542", "福建省厦门市",
"861801593", "江苏省南通市",
"861811105", "四川省自贡市",
"861351920", "宁夏银川市",
"86155200", "重庆市",
"861351774", "广西梧州市",
"861320953", "宁夏吴忠市",
"861846448", "山东省莱芜市",
"861345547", "山东省济宁市",
"861303136", "新疆伊犁哈萨克自治州",
"861337601", "江苏省泰州市",
"861571848", "广东省深圳市",
"861595417", "山东省聊城市",
"861830348", "山西省吕梁市",
"861535687", "浙江省温州市",
"861819010", "四川省巴中市",
"86178548", "山东省泰安市",
"861552084", "四川省成都市",
"86147408", "辽宁省阜新市",
"861809080", "四川省遂宁市",
"861555669", "安徽省马鞍山市",
"861867434", "湖南省湘西土家族苗族自治州",
"861804893", "四川省乐山市",
"861348375", "河北省唐山市",
"861504087", "辽宁省朝阳市",
"861529495", "河南省周口市",
"861782039", "广东省深圳市",
"86189526", "江苏省泰州市",
"861787841", "广西梧州市",
"861370776", "广西百色市",
"861378079", "山东省东营市",
"861836081", "江苏省无锡市",
"861450585", "辽宁省辽阳市",
"861365580", "浙江省舟山市",
"861803447", "河北省沧州市",
"86134538", "山西省吕梁市",
"861319862", "四川省眉山市",
"861882970", "陕西省西安市",
"86181744", "湖南省张家界市",
"861338454", "黑龙江省佳木斯市",
"861815881", "安徽省芜湖市",
"861366758", "新疆和田地区",
"861562792", "广东省汕尾市",
"861808909", "西藏拉萨市",
"861310350", "山西省忻州市",
"861344238", "辽宁省沈阳市",
"86139533", "山东省淄博市",
"861823828", "河南省信阳市",
"861889665", "江苏省镇江市",
"86182944", "甘肃省兰州市",
"861890868", "湖北省鄂州市",
"861323638", "江苏省镇江市",
"861565054", "山东省济宁市",
"861800551", "安徽省合肥市",
"861327862", "云南省保山市",
"861318399", "四川省德阳市",
"861311986", "广东省佛山市",
"861321991", "四川省广元市",
"861321500", "福建省福州市",
"861301916", "吉林省吉林市",
"86180722", "浙江省绍兴市",
"861539052", "甘肃省定西市",
"861813227", "河北省唐山市",
"861889947", "新疆塔城地区",
"861854656", "黑龙江省黑河市",
"86155205", "四川省绵阳市",
"861762527", "江苏省宿迁市",
"861394837", "内蒙古鄂尔多斯市",
"86176910", "陕西省西安市",
"861325621", "山东省菏泽市",
"861380446", "吉林省长春市",
"861836146", "江苏省盐城市",
"861352991", "云南省红河哈尼族彝族自治州",
"861774819", "四川省达州市",
"861337651", "广东省揭阳市",
"861335475", "内蒙古通辽市",
"86153631", "广东省茂名市",
"861344887", "云南省昆明市",
"861320903", "新疆和田地区",
"861539240", "福建省南平市",
"861303618", "湖北省咸宁市",
"861770326", "河北省廊坊市",
"861379201", "山东省日照市",
"861876544", "山东省德州市",
"861518360", "四川省甘孜藏族自治州",
"861341587", "广东省东莞市",
"861580843", "四川省南充市",
"861350849", "湖南省长沙市",
"861550371", "河南省郑州市",
"861561676", "湖南省益阳市",
"861780437", "吉林省辽源市",
"861880369", "河南省郑州市",
"861807701", "广西梧州市",
"861503642", "河南省周口市",
"86137132", "广东省东莞市",
"861313688", "黑龙江省牡丹江市",
"861312323", "福建省宁德市",
"861308321", "安徽省芜湖市",
"861339461", "黑龙江省哈尔滨市",
"861392173", "江苏省泰州市",
"861839473", "甘肃省兰州市",
"861338404", "河南省郑州市",
"861390387", "河南省周口市",
"861807030", "江西省上饶市",
"86139774", "广西梧州市",
"861857089", "湖南省衡阳市",
"861380239", "广东省东莞市",
"861453931", "广东省深圳市",
"861562439", "山东省济南市",
"861808959", "四川省攀枝花市",
"861310300", "河北省邯郸市",
"861303191", "河北省邢台市",
"861366708", "江西省南昌市",
"861888213", "四川省资阳市",
"861814541", "黑龙江省七台河市",
"861336437", "吉林省辽源市",
"86139861", "湖北省武汉市",
"861315946", "福建省漳州市",
"861340337", "河北省沧州市",
"861800990", "新疆克拉玛依市",
"861350523", "江苏省淮安市",
"861800501", "福建省福州市",
"861867212", "湖北省荆州市",
"861580529", "江苏省镇江市",
"861865135", "江苏省徐州市",
"861885154", "江苏省盐城市",
"861868631", "吉林省吉林市",
"861528963", "广西柳州市",
"861811841", "江苏省镇江市",
"861459735", "湖南省郴州市",
"861368821", "四川省泸州市",
"861586603", "山东省泰安市",
"861346617", "云南省普洱市",
"861361540", "山东省菏泽市",
"86177937", "甘肃省酒泉市",
"86157028", "四川省成都市",
"861777615", "广西玉林市",
"861593105", "河北省石家庄市",
"861760922", "陕西省榆林市",
"861321550", "安徽省滁州市",
"861551206", "河北省秦皇岛市",
"861590252", "贵州省遵义市",
"861508912", "广东省汕头市",
"861457000", "山东省菏泽市",
"861581186", "广东省广州市",
"861536671", "江苏省泰州市",
"861324706", "江西省吉安市",
"861585081", "江苏省苏州市",
"861763522", "山西省大同市",
"861804677", "江西省赣州市",
"861519249", "山东省青岛市",
"861353923", "广东省惠州市",
"861518982", "江苏省南京市",
"861308948", "吉林省吉林市",
"861885822", "浙江省宁波市",
"86155061", "江苏省苏州市",
"861313391", "江西省南昌市",
"86188863", "贵州省铜仁地区",
"861594715", "内蒙古通辽市",
"861450531", "辽宁省营口市",
"861573825", "河南省信阳市",
"861809705", "青海省海东地区",
"861889401", "甘肃省兰州市",
"861533272", "内蒙古包头市",
"861502965", "陕西省渭南市",
"861509429", "云南省昭通市",
"861538369", "山西省运城市",
"861318121", "山东省临沂市",
"861825056", "福建省三明市",
"86152459", "黑龙江省大庆市",
"861387007", "江西省南昌市",
"861567259", "湖北省荆州市",
"861865046", "福建省福州市",
"861558387", "四川省自贡市",
"86184389", "河南省南阳市",
"861815835", "浙江省金华市",
"861821151", "广东省湛江市",
"861323386", "河南省商丘市",
"861519436", "山东省烟台市",
"861327833", "吉林省延边朝鲜族自治州",
"861538137", "浙江省宁波市",
"861309546", "安徽省马鞍山市",
"861855518", "安徽省亳州市",
"861508160", "河北省邯郸市",
"861821845", "广东省湛江市",
"861835653", "安徽省合肥市",
"861761441", "吉林省长春市",
"861346409", "辽宁省铁岭市",
"861870439", "吉林省白山市",
"861770367", "黑龙江省鸡西市",
"861881834", "广东省潮州市",
"861378413", "河北省邢台市",
"861330309", "河北省邢台市",
"86139394", "河南省周口市",
"861396669", "安徽省合肥市",
"861850858", "贵州省六盘水市",
"86979", "青海省海西蒙古族藏族自治州",
"861826278", "江苏省连云港市",
"861319833", "四川省宜宾市",
"861323503", "福建省漳州市",
"861879498", "甘肃省定西市",
"861890794", "江西省抚州市",
"861373071", "四川省绵阳市",
"861528694", "河南省濮阳市",
"861884817", "内蒙古通辽市",
"861524069", "广西南宁市",
"86153618", "广东省深圳市",
"861816877", "江苏省徐州市",
"861519491", "河北省邢台市",
"861335164", "黑龙江省佳木斯市",
"861588348", "四川省凉山彝族自治州",
"86159206", "广东省东莞市",
"861358202", "河北省石家庄市",
"861459781", "新疆阿克苏地区",
"861364746", "湖南省永州市",
"861457050", "新疆乌鲁木齐市",
"861303329", "江西省吉安市",
"861341979", "河南省开封市",
"861560578", "浙江省丽水市",
"861779949", "新疆伊犁哈萨克自治州",
"86182887", "云南省昆明市",
"86156892", "山东省潍坊市",
"861803951", "河南省郑州市",
"861853738", "河南省开封市",
"861458939", "广东省清远市",
"861529486", "河南省新乡市",
"861361497", "辽宁省营口市",
"861889451", "甘肃省金昌市",
"86188531", "山东省济南市",
"861809755", "新疆阿勒泰地区",
"861367313", "河北省石家庄市",
"861596690", "山东省青岛市",
"861334777", "江苏省镇江市",
"861507416", "湖南省郴州市",
"861374973", "河南省信阳市",
"861300150", "山东省淄博市",
"86185520", "江苏省无锡市",
"861453985", "广东省肇庆市",
"861329883", "吉林省松原市",
"861595609", "安徽省滁州市",
"861567209", "湖北省十堰市",
"861576930", "甘肃省庆阳市",
"861377255", "陕西省咸阳市",
"861761299", "陕西省榆林市",
"861528932", "陕西省榆林市",
"861311995", "新疆吐鲁番地区",
"861303045", "内蒙古锡林郭勒盟",
"861567778", "广西钦州市",
"861471594", "广东省中山市",
"861330359", "山西省运城市",
"861332916", "安徽省池州市",
"861870792", "江西省九江市",
"861816964", "广西南宁市",
"86170734", "河北省石家庄市",
"861524274", "辽宁省抚顺市",
"861313336", "山西省晋城市",
"861323553", "湖北省武汉市",
"861586538", "山东省泰安市",
"861338390", "河南省平顶山市",
"861450596", "辽宁省盘锦市",
"861504472", "内蒙古包头市",
"861557679", "湖南省永州市",
"861310494", "广东省江门市",
"861550262", "辽宁省大连市",
"861801305", "江苏省苏州市",
"861810043", "辽宁省大连市",
"86189727", "湖北省黄冈市",
"86186567", "安徽省亳州市",
"861550688", "广西玉林市",
"861477849", "广东省深圳市",
"861897574", "湖南省郴州市",
"861533292", "内蒙古包头市",
"861313371", "江西省抚州市",
"86184387", "河南省开封市",
"861513849", "河南省郑州市",
"861357660", "江西省吉安市",
"861470723", "湖北省黄石市",
"861360865", "河南省洛阳市",
"86152457", "黑龙江省大兴安岭地区",
"861815942", "福建省莆田市",
"861335486", "内蒙古包头市",
"861395616", "安徽省芜湖市",
"86182254", "重庆市",
"861536691", "江苏省扬州市",
"861884020", "陕西省西安市",
"861539872", "云南省大理白族自治州",
"861351868", "山东省泰安市",
"86186255", "河南省郑州市",
"861589027", "河南省三门峡市",
"861881348", "广东省惠州市",
"861560789", "广西北海市",
"86145801", "江苏省苏州市",
"861778502", "贵州省贵阳市",
"861336142", "山东省枣庄市",
"861769308", "甘肃省天水市",
"861366907", "湖北省宜昌市",
"861845839", "浙江省嘉兴市",
"861826298", "江苏省常州市",
"861855504", "安徽省淮南市",
"861532909", "贵州省黔西南布依族苗族自治州",
"861776812", "江苏省南京市",
"861877130", "湖北省咸宁市",
"861516083", "新疆吐鲁番地区",
"861816897", "江苏省苏州市",
"861370890", "山东省烟台市",
"86157395", "新疆乌鲁木齐市",
"861368934", "甘肃省庆阳市",
"861513523", "山西省大同市",
"861879478", "甘肃省兰州市",
"861890774", "广西梧州市",
"861348553", "安徽省芜湖市",
"86150496", "内蒙古赤峰市",
"861778668", "湖北省十堰市",
"861453824", "四川省雅安市",
"861568805", "贵州省黔东南苗族侗族自治州",
"86137677", "江西省赣州市",
"861566515", "江苏省盐城市",
"861821932", "广东省肇庆市",
"861472700", "浙江省金华市",
"861334797", "江苏省淮安市",
"861870343", "山西省太原市",
"861332561", "新疆乌鲁木齐市",
"861568141", "四川省内江市",
"861372610", "广东省中山市",
"861531843", "山东省枣庄市",
"861325892", "山东省菏泽市",
"861819866", "贵州省黔南布依族苗族自治州",
"861528151", "四川省阿坝藏族羌族自治州",
"86183798", "江西省赣州市",
"861361477", "内蒙古鄂尔多斯市",
"861344683", "广西百色市",
"861565967", "福建省漳州市",
"861537625", "山东省滨州市",
"861395138", "江苏省南通市",
"86158163", "广东省惠州市",
"861569539", "青海省海西蒙古族藏族自治州",
"861558244", "山西省长治市",
"861831369", "云南省文山壮族苗族自治州",
"86188423", "辽宁省沈阳市",
"861373036", "河北省廊坊市",
"861570869", "贵州省黔西南布依族苗族自治州",
"861385720", "浙江省舟山市",
"86186250", "江苏省苏州市",
"861580965", "宁夏中卫市",
"861837904", "江西省新余市",
"861331446", "贵州省铜仁地区",
"861811982", "安徽省淮北市",
"861370785", "广西玉林市",
"861308179", "辽宁省铁岭市",
"861808277", "云南省普洱市",
"861323283", "广东省清远市",
"861534543", "山东省滨州市",
"861580647", "山东省潍坊市",
"861341999", "河南省信阳市",
"861560598", "福建省三明市",
"861348386", "河北省承德市",
"86182889", "云南省昆明市",
"861871816", "广东省惠州市",
"861855554", "安徽省淮南市",
"861532959", "贵州省黔西南布依族苗族自治州",
"861530316", "河北省廊坊市",
"861396546", "安徽省六安市",
"861531529", "山东省泰安市",
"861338370", "河南省商丘市",
"861454712", "浙江省湖州市",
"861840323", "河北省张家口市",
"861778552", "贵州省黔南布依族苗族自治州",
"86186569", "安徽省合肥市",
"86138644", "山东省淄博市",
"861803132", "河北省唐山市",
"861388905", "西藏昌都地区",
"861310474", "广东省珠海市",
"86157390", "新疆伊犁哈萨克自治州",
"861504492", "内蒙古鄂尔多斯市",
"861894549", "黑龙江省七台河市",
"861471574", "广东省汕头市",
"861889748", "湖南省怀化市",
"861801160", "四川省绵阳市",
"861553350", "河北省秦皇岛市",
"861311975", "青海省海西蒙古族藏族自治州",
"861850814", "四川省广安市",
"861309669", "山西省大同市",
"861378809", "广西钦州市",
"86177632", "山东省枣庄市",
"861588517", "贵州省铜仁地区",
"861850537", "山东省济宁市",
"861534829", "四川省巴中市",
"861870772", "广西柳州市",
"86138436", "吉林省白城市",
"861331239", "贵州省六盘水市",
"861476301", "山东省济南市",
"861586097", "福建省南平市",
"861302446", "江苏省泰州市",
"861570584", "浙江省宁波市",
"861811360", "四川省德阳市",
"861862869", "陕西省榆林市",
"86137443", "吉林省延边朝鲜族自治州",
"861786624", "湖北省襄樊市",
"861394558", "黑龙江省七台河市",
"86183430", "吉林省长春市",
"861529475", "河南省周口市",
"861370796", "江西省吉安市",
"861804873", "四川省达州市",
"861366441", "吉林省长春市",
"861304861", "江苏省淮安市",
"861325240", "浙江省宁波市",
"861374664", "黑龙江省绥化市",
"861772042", "湖北省恩施土家族苗族自治州",
"861502843", "河北省保定市",
"861370050", "山西省太原市",
"861801573", "四川省泸州市",
"86183378", "河南省开封市",
"861303654", "四川省泸州市",
"861389759", "青海省海西蒙古族藏族自治州",
"861393399", "河北省张家口市",
"86157050", "内蒙古呼伦贝尔市",
"861334978", "湖北省宜昌市",
"861364361", "山西省太原市",
"861351794", "江西省抚州市",
"861705525", "江苏省南京市",
"861517475", "内蒙古兴安盟",
"861802369", "广东省韶关市",
"86182800", "四川省成都市",
"861318379", "四川省绵阳市",
"861772200", "广东省阳江市",
"861373145", "河北省石家庄市",
"861554005", "内蒙古通辽市",
"861566260", "山东省潍坊市",
"861883049", "河北省秦皇岛市",
"861313262", "广西柳州市",
"861858206", "四川省广元市",
"861361082", "辽宁省沈阳市",
"861563998", "河南省平顶山市",
"861512950", "陕西省宝鸡市",
"861583565", "山西省大同市",
"861327637", "山东省枣庄市",
"861802137", "江苏省徐州市",
"861561631", "湖南省衡阳市",
"86137856", "河北省廊坊市",
"861321971", "四川省乐山市",
"861821963", "甘肃省平凉市",
"861518841", "河南省漯河市",
"861828084", "四川省南充市",
"861501959", "广东省汕尾市",
"861581213", "云南省昆明市",
"86139421", "辽宁省朝阳市",
"861882501", "广东省中山市",
"861882990", "广东省东莞市",
"861565926", "福建省厦门市",
"861830834", "四川省泸州市",
"861537946", "甘肃省金昌市",
"86157770", "广西防城港市",
"861479109", "陕西省西安市",
"861571334", "河北省承德市",
"861325002", "广东省江门市",
"861379581", "四川省宜宾市",
"861319637", "陕西省汉中市",
"861514820", "内蒙古包头市",
"861308747", "云南省曲靖市",
"861340222", "山东省济南市",
"861317687", "山东省青岛市",
"861599499", "广东省潮州市",
"86157581", "云南省玉溪市",
"861581175", "广东省云浮市",
"861454425", "江苏省镇江市",
"861707999", "浙江省嘉兴市",
"86183435", "吉林省通化市",
"861533840", "广东省佛山市",
"861561696", "湖南省娄底市",
"86131361", "浙江省杭州市",
"861550391", "河南省焦作市",
"861590438", "吉林省松原市",
"861329687", "浙江省台州市",
"861579734", "湖北省黄冈市",
"861389709", "青海省海西蒙古族藏族自治州",
"861352971", "云南省楚雄彝族自治州",
"861321280", "黑龙江省哈尔滨市",
"861590582", "浙江省湖州市",
"861816007", "四川省泸州市",
"861347460", "陕西省咸阳市",
"861536388", "广东省惠州市",
"861872789", "湖北省鄂州市",
"861820560", "安徽省合肥市",
"861818034", "四川省凉山彝族自治州",
"86186804", "广东省广州市",
"861338418", "辽宁省阜新市",
"86131102", "重庆市",
"861322794", "陕西省咸阳市",
"861370242", "广东省佛山市",
"861835807", "浙江省舟山市",
"861800970", "青海省海北藏族自治州",
"861310165", "黑龙江省佳木斯市",
"86182805", "四川省德阳市",
"861592987", "陕西省咸阳市",
"861370731", "湖南省长沙市",
"861800724", "湖北省咸宁市",
"86177939", "甘肃省陇南市",
"861846701", "青海省西宁市",
"861452248", "浙江省金华市",
"861593360", "河北省石家庄市",
"861520320", "河北省邯郸市",
"861348638", "浙江省杭州市",
"861339044", "辽宁省本溪市",
"86185991", "新疆乌鲁木齐市",
"861839493", "甘肃省庆阳市",
"861392193", "江苏省扬州市",
"86157775", "广西玉林市",
"861303171", "山东省济南市",
"861479159", "陕西省西安市",
"861551353", "山西省阳泉市",
"861383898", "河南省南阳市",
"861398688", "湖北省十堰市",
"86130164", "湖北省武汉市",
"861860327", "河北省石家庄市",
"861321761", "广东省河源市",
"861454563", "四川省遂宁市",
"861850954", "宁夏固原市",
"861370728", "湖北省十堰市",
"861566224", "吉林省长春市",
"861860458", "黑龙江省伊春市",
"861346953", "宁夏吴忠市",
"861334054", "福建省三明市",
"861513651", "河南省安阳市",
"861396300", "山东省聊城市",
"861347548", "山东省泰安市",
"861452722", "湖北省随州市",
"861815332", "湖南省益阳市",
"861556121", "内蒙古兴安盟",
"861305654", "四川省广安市",
"861316387", "福建省福州市",
"861368507", "福建省宁德市",
"861534580", "浙江省舟山市",
"861879143", "陕西省渭南市",
"861537688", "山东省青岛市",
"861338782", "辽宁省朝阳市",
"861532819", "四川省成都市",
"861800827", "四川省巴中市",
"861323240", "广东省江门市",
"861539395", "云南省大理白族自治州",
"861871956", "甘肃省陇南市",
"861386555", "安徽省马鞍山市",
"861366534", "山东省德州市",
"861835704", "浙江省杭州市",
"861855937", "福建省宁德市",
"861370511", "江苏省盐城市",
"861345125", "湖北省十堰市",
"861322897", "西藏阿里地区",
"86150643", "山东省淄博市",
"86181826", "陕西省西安市",
"861506664", "山东省日照市",
"861479461", "黑龙江省哈尔滨市",
"861340748", "湖南省娄底市",
"861478404", "河南省驻马店市",
"861576861", "广东省惠州市",
"861458433", "河南省许昌市",
"861560567", "安徽省亳州市",
"861873562", "山西省晋城市",
"861304295", "甘肃省天水市",
"861786660", "山东省济南市",
"861781742", "广东省肇庆市",
"861817296", "江西省宜春市",
"861563926", "河南省郑州市",
"861874830", "内蒙古阿拉善盟",
"861823876", "河南省新乡市",
"861328354", "山西省晋中市",
"861871530", "安徽省芜湖市",
"861453766", "广西北海市",
"861760158", "江苏省苏州市",
"861876476", "山东省济宁市",
"861559329", "甘肃省酒泉市",
"861334768", "广西河池市",
"86147848", "广东省广州市",
"861518417", "辽宁省营口市",
"861856975", "湖南省怀化市",
"861315262", "广西柳州市",
"861590421", "辽宁省朝阳市",
"861861352", "山西省晋中市",
"861565998", "福建省厦门市",
"861308844", "内蒙古包头市",
"86152641", "山东省济南市",
"861325375", "河南省周口市",
"861334004", "江西省赣州市",
"861817742", "广西梧州市",
"861346903", "湖南省株洲市",
"861870933", "甘肃省平凉市",
"861830737", "湖南省益阳市",
"861860408", "辽宁省大连市",
"861850904", "新疆和田地区",
"861561628", "湖南省湘潭市",
"86138029", "广东省广州市",
"861800760", "广东省中山市",
"86156249", "北京市",
"861819970", "新疆克孜勒苏柯尔克孜自治州",
"861309165", "黑龙江省佳木斯市",
"861770378", "河南省郑州市",
"861890693", "福建省福州市",
"861328547", "山东省济宁市",
"861869752", "安徽省蚌埠市",
"861871906", "广东省深圳市",
"86183174", "河南省许昌市",
"861593324", "河北省保定市",
"861826267", "江苏省苏州市",
"86131561", "山东省济南市",
"861363200", "广东省潮州市",
"861368557", "安徽省宿州市",
"861398946", "浙江省杭州市",
"861877093", "江西省上饶市",
"861829742", "安徽省安庆市",
"86130568", "浙江省宁波市",
"861567820", "广西来宾市",
"861816868", "江苏省镇江市",
"861308675", "广西玉林市",
"861822455", "河南省新乡市",
"861583423", "山西省吕梁市",
"861478454", "黑龙江省佳木斯市",
"861301076", "河南省郑州市",
"861516040", "福建省泉州市",
"861477174", "湖北省黄冈市",
"861862445", "辽宁省阜新市",
"861804668", "江西省赣州市",
"861768940", "福建省福州市",
"861328304", "河南省开封市",
"861837537", "安徽省安庆市",
"861329361", "山西省忻州市",
"861810542", "山东省青岛市",
"861886746", "湖南省长沙市",
"861353670", "广东省梅州市",
"861302594", "广西桂林市",
"861537129", "江苏省扬州市",
"861599512", "江苏省扬州市",
"861566781", "陕西省榆林市",
"861347424", "陕西省渭南市",
"86132838", "河南省郑州市",
"861820524", "江苏省宿迁市",
"861882010", "广东省广州市",
"861893564", "青海省海南藏族自治州",
"861530699", "福建省福州市",
"861565149", "江苏省连云港市",
"861509923", "新疆巴音郭楞蒙古自治州",
"861399548", "宁夏银川市",
"861890964", "安徽省淮南市",
"861563874", "河南省洛阳市",
"861572408", "广东省河源市",
"86180274", "广东省广州市",
"861322673", "广东省佛山市",
"86185985", "重庆市",
"86178285", "四川省凉山彝族自治州",
"861839979", "新疆巴音郭楞蒙古自治州",
"86187049", "内蒙古巴彦淖尔市",
"861374013", "北京市",
"86132811", "四川省成都市",
"86158678", "浙江省宁波市",
"861827235", "湖北省随州市",
"861454488", "湖北省武汉市",
"86184587", "浙江省温州市",
"861801092", "安徽省滁州市",
"861813942", "新疆石河子市",
"861887244", "湖北省荆门市",
"86156