# Generated by default/object.tt
package Paws::SSM::DocumentReviewerResponseSource;
  use Moose;
  has Comment => (is => 'ro', isa => 'ArrayRef[Paws::SSM::DocumentReviewCommentSource]');
  has CreateTime => (is => 'ro', isa => 'Str');
  has Reviewer => (is => 'ro', isa => 'Str');
  has ReviewStatus => (is => 'ro', isa => 'Str');
  has UpdatedTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::DocumentReviewerResponseSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::DocumentReviewerResponseSource object:

  $service_obj->Method(Att1 => { Comment => $value, ..., UpdatedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::DocumentReviewerResponseSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Comment

=head1 DESCRIPTION

Information about a reviewer's response to a document review request.

=head1 ATTRIBUTES


=head2 Comment => ArrayRef[L<Paws::SSM::DocumentReviewCommentSource>]

The comment entered by a reviewer as part of their document review
response.


=head2 CreateTime => Str

The date and time that a reviewer entered a response to a document
review request.


=head2 Reviewer => Str

The user in your organization assigned to review a document request.


=head2 ReviewStatus => Str

The current review status of a new custom SSM document created by a
member of your organization, or of the latest version of an existing
SSM document.

Only one version of a document can be in the APPROVED state at a time.
When a new version is approved, the status of the previous version
changes to REJECTED.

Only one version of a document can be in review, or PENDING, at a time.


=head2 UpdatedTime => Str

The date and time that a reviewer last updated a response to a document
review request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

