# Generated by default/object.tt
package Paws::GlueDataBrew::PathOptions;
  use Moose;
  has FilesLimit => (is => 'ro', isa => 'Paws::GlueDataBrew::FilesLimit');
  has LastModifiedDateCondition => (is => 'ro', isa => 'Paws::GlueDataBrew::FilterExpression');
  has Parameters => (is => 'ro', isa => 'Paws::GlueDataBrew::PathParametersMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::PathOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::PathOptions object:

  $service_obj->Method(Att1 => { FilesLimit => $value, ..., Parameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::PathOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->FilesLimit

=head1 DESCRIPTION

Represents a set of options that define how DataBrew selects files for
a given Amazon S3 path in a dataset.

=head1 ATTRIBUTES


=head2 FilesLimit => L<Paws::GlueDataBrew::FilesLimit>

If provided, this structure imposes a limit on a number of files that
should be selected.


=head2 LastModifiedDateCondition => L<Paws::GlueDataBrew::FilterExpression>

If provided, this structure defines a date range for matching Amazon S3
objects based on their LastModifiedDate attribute in Amazon S3.


=head2 Parameters => L<Paws::GlueDataBrew::PathParametersMap>

A structure that maps names of parameters used in the Amazon S3 path of
a dataset to their definitions.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

