package Bio::Procedural;
$Bio::Procedural::VERSION = '1.7.4';
use utf8;
use strict;
use warnings;

1;

# ABSTRACT: Simple low-dependency procedural interfaces to BioPerl
# AUTHOR: See the individual modules for their authors.
# OWNER: many people (see the individual modules for their copyright holders)
# LICENSE: Perl_5

__END__

=pod

=encoding UTF-8

=head1 NAME

Bio::Procedural - Simple low-dependency procedural interfaces to BioPerl

=head1 VERSION

version 1.7.4

=head1 SYNOPSIS

See L<Bio::Perl> for examples.

=head1 DESCRIPTION

The code in this distribution focuses on simple low-dependency procedural
interfaces to BioPerl that don't require knowledge of BioPerl classes and
methods.

=head1 FEEDBACK

=head2 Mailing lists

User feedback is an integral part of the evolution of this and other
Bioperl modules. Send your comments and suggestions preferably to
the Bioperl mailing list.  Your participation is much appreciated.

  bioperl-l@bioperl.org               - General discussion
  https://bioperl.org/Support.html    - About the mailing lists

=head2 Support

Please direct usage questions or support issues to the mailing list:
I<bioperl-l@bioperl.org>
rather than to the module maintainer directly. Many experienced and
reponsive experts will be able look at the problem and quickly
address it. Please include a thorough description of the problem
with code and data examples if at all possible.

=head2 Reporting bugs

Report bugs to the Bioperl bug tracking system to help us keep track
of the bugs and their resolution. Bug reports can be submitted via the
web:

  https://github.com/bioperl/bio-procedural/issues

=head1 AUTHOR

See the individual modules for their authors.

=head1 COPYRIGHT

This software is copyright (c) by many people (see the individual modules for their copyright holders).

This software is available under the same terms as the perl 5 programming language system itself.

=cut
