package AnyEvent::Subprocess::Done::Delegate::CaptureHandle;
BEGIN {
  $AnyEvent::Subprocess::Done::Delegate::CaptureHandle::VERSION = '1.102911';
}
# ABSTRACT: store the output generated by a handle while the process was running

use Moose;

with 'AnyEvent::Subprocess::Done::Delegate';

has 'output' => ( is => 'ro', isa => 'Str', required => 1 );

__PACKAGE__->meta->make_immutable;

1;



=pod

=head1 NAME

AnyEvent::Subprocess::Done::Delegate::CaptureHandle - store the output generated by a handle while the process was running

=head1 VERSION

version 1.102911

=head1 ATTRIBUTES

=head2 output

The captured output, as a string.

=head1 AUTHOR

Jonathan Rockway <jrockway@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Jonathan Rockway.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

