/* Copyright (c) 2022-2023 hors<horsicq@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef XTIFF_H
#define XTIFF_H

#include "xbinary.h"

class XTiff : public XBinary {
    Q_OBJECT

#pragma pack(push)
#pragma pack(1)
    struct IFD_ENTRY {
        quint16 nTag;
        quint16 nType;
        quint32 nCount;
        quint32 nOffset;
    };
#pragma pack(pop)

public:
    struct CHUNK {
        quint32 nTag;
        qint64 nOffset;
        qint64 nSize;
    };

    explicit XTiff(QIODevice *pDevice = nullptr);
    ~XTiff();

    virtual bool isValid();
    static bool isValid(QIODevice *pDevice);
    virtual _MEMORY_MAP getMemoryMap(MAPMODE mapMode = MAPMODE_UNKNOWN, PDSTRUCT *pPdStruct = nullptr);
    virtual FT getFileType();
    virtual QString getFileFormatString();
    virtual QString getFileFormatExt();
    virtual qint64 getFileFormatSize();
    virtual bool isBigEndian();

    QList<CHUNK> getChunks(PDSTRUCT *pPdStruct = nullptr);
    static QList<CHUNK> _getChunksByTag(QList<CHUNK> *pListChunks, quint16 nTag);

    QString getCameraName(QList<CHUNK> *pListChunks);

private:
    qint32 getBaseTypeSize(quint16 nType);
};

#endif  // XTIFF_H
