/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nvu.
 *
 * The Initial Developer of the Original Code is
 * Lindows.com.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Daniel Glazman (glazman@disruptive-innovations.com), on behalf of Lindows.com
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const debug = true;

// cf. netwerk/bas/public/nsNetError.h
const ERROR_FTP_LOGIN  = 2152398869;
const ERROR_FTP_CWD    = 2152398870;
const ERROR_FTP_PASV   = 2152398871;
const ERROR_FTP_PWD    = 2152398872;
const ERROR_FTP_LIST   = 2152398873;

var gPublishSiteData;
var gDefaultSiteIndex = -1;
var gDefaultSiteName;

var gSiteListUpdated = false;
var gFirstFileEntry  = null;
var gCurrentFilter   = "all";

var gFTPpending      = false;

var gCurrentSiteURL  = null;
var gLastDirOpenOrClose = null;

var gRebuiltDirUrl = null;
var gDirIndex      = null;
var gDirArray      = null;

function GetCurrentEditorFromSidebar()
{
  // Get the active editor from the <editor> tag
  // XXX This will probably change if we support > 1 editor in main Composer window
  //      (e.g. a plaintext editor for HTMLSource)

  // For dialogs: Search up parent chain to find top window with editor
  var editor;
  try {
    var editorElement = window.top.document.getElementById("content-frame");
    editor = editorElement.getEditor(editorElement.contentWindow);

    // Do QIs now so editor users won't have to figure out which interface to use
    // Using "instanceof" does the QI for us.
    editor instanceof Components.interfaces.nsIPlaintextEditor;
    editor instanceof Components.interfaces.nsIHTMLEditor;
  } catch (e) { dump (e)+"\n"; }

  return editor;
}

// Dialog initialization code
function Startup()
{

  if (!GetCurrentEditorFromSidebar())
  {
    dump("Publish: No editor or return data object not supplied\n");
    window.close();
    return;
  }

  gDialog.SiteTree       = document.getElementById("SiteTree");
  gDialog.SiteDropDown   = document.getElementById("SiteDropDown");
  gDialog.SiteList       = document.getElementById("SiteList");
  gDialog.DirectoryList  = document.getElementById("DirectoryList");
  gDialog.FilterDropDown = document.getElementById("FilterDropDown");
  gDialog.treeViewCheckbox = document.getElementById("treeViewCheckbox");
  gDialog.dirHierarchy   = document.getElementById("dirHierarchy");
  gDialog.dirHierarchyPopup = document.getElementById("dirHierarchyPopup");

  gDialog.reloadButton    = document.getElementById("reloadButton");
  gDialog.createDirButton = document.getElementById("createDirButton");
  gDialog.removeFileOrDirButton = document.getElementById("removeFileOrDirButton");
  gDialog.stopButton      = document.getElementById("stopButton");

  gDialog.mainBox         = document.getElementById("mainBox");

  gPublishSiteData       = window.top.GetPublishSiteData();

  FillSiteList();

  var prefs = window.top.GetPrefs();
    DEBUG ( prefs.toString() );
  var treeView = false; // default is false
  try {
    treeView = prefs.getBoolPref("editor.nvu.sitemanager.treeView");
    DEBUG ( "prefs found" );
  }
  catch (e) {};

  DEBUG("treeView= " + treeView);

  UseTreeViewUI(treeView);

  SetWindowLocation();
}

function UseTreeViewUI(treeView)
{
  if (treeView)
  {
    gDialog.treeViewCheckbox.setAttribute("checked", "true");

    gDialog.dirHierarchy.setAttribute("disabled", "true");
    _removeAllChildren(gDialog.dirHierarchyPopup);
    var menuitem = document.createElementNS(XUL_NS, "menuitem");
    menuitem.setAttribute("label", " ");
    gDialog.dirHierarchyPopup.appendChild(menuitem);
  }
  else
  {
    gDialog.treeViewCheckbox.removeAttribute("checked");
    if (gCurrentSiteURL)
      gDialog.dirHierarchy.removeAttribute("disabled");
    else
      gDialog.dirHierarchy.setAttribute("disabled", "true");
  }
}


function ShowDirHierarchy(url)
{
  _removeAllChildren(gDialog.dirHierarchyPopup);

  var dirArray, orig;
  var isFileUrl = IsFileUrl(url);
  if(isFileUrl)
  {
    dirArray = url.split("/");
    orig = 0;
  }
  else
  {
    var URL = GetURLFromUrl(url);
    var path = URL.filePath;

    dirArray = path.split("/");
    orig = 1;
  }

  var menuitem = null, i, label = "", reconstructedUrl = "";

  menuitem = document.createElementNS(XUL_NS, "menuitem");
  menuitem.setAttribute("label", "/");
  menuitem.setAttribute("value", "/");
  gDialog.dirHierarchyPopup.insertBefore(menuitem, gDialog.dirHierarchyPopup.firstChild);

  for (i=orig; i< dirArray.length; i++)
  {
    reconstructedUrl += (i ? "/" : "") + dirArray[i];

    if (!isFileUrl ||
        (isFileUrl && reconstructedUrl.length > gCurrentSiteURL.length))
    {
      label += "/" + dirArray[i];
      menuitem = document.createElementNS(XUL_NS, "menuitem");
      menuitem.setAttribute("label", label);
      menuitem.setAttribute("value", label);
      menuitem.setAttribute("crop",  "start");
      gDialog.dirHierarchyPopup.insertBefore(menuitem, gDialog.dirHierarchyPopup.firstChild);
    }
  }
  if (menuitem)
    gDialog.dirHierarchy.selectedItem = menuitem;

  return;
}

function RemoveSubdirs(ti)
{
  _removeAllChildren(ti.lastChild);
}

function ResetFirstFileEntry()
{
  gFirstFileEntry = null;
}

function onTreeModified(aEvent)
{
  if (aEvent.attrName == "open") {
    var e = aEvent.target;
    gLastDirOpenOrClose = e;
    var url = e.getAttribute("value");
 
    DEBUG("dir open/close " + url);

    if (aEvent.newValue == "true")
    {
      if (!gDialog.treeViewCheckbox.getAttribute("checked"))
      {
        setTimeout("SwitchToOneDirView(\""+url+"\")", 500);
        return;
      }
      ResetFirstFileEntry();
      EnableAllUI(false);
      if (IsFileUrl(url))
      {
        SelectLocalHDSite(url, e);
      }
      else
      {
        var foo = new FTPDirParser(url, e,
                                   AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);
      }
    }
    else
    {
      if (!gDialog.treeViewCheckbox.getAttribute("checked"))
      {
        setTimeout("SwitchToOneDirView(\""+url+"\")", 500);
        return;
      }
      RemoveSubdirs(e);
    }
  }
}

function SelectDirectory(e)
{
  var url = gCurrentSiteURL + e.selectedItem.value;
  setTimeout("SwitchToOneDirView(\""+url+"\")", 500);
}

function SwitchToOneDirView(url)
{
  ShowDirHierarchy(url);
  RemoveSubdirs(gDialog.SiteTree);
  e = gDialog.SiteTree;
  ResetFirstFileEntry();
  if (IsFileUrl(url))
  {
    if (url != gCurrentSiteURL)
      AddLocalDirSubdirs(url, null, gDialog.SiteTree)
    SelectLocalHDSite(url, gDialog.SiteTree);
  }
  else
  {
    if (url != gCurrentSiteURL)
      AddFTPDirSubdirs(url, null, gDialog.SiteTree);
    var foo = new FTPDirParser(url, gDialog.SiteTree,
                               AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);
    AllowEvents(gDialog.SiteTree, false);
  }
}

function ErrorFtpRequest(url, status)
{
  var message = "";
  if (status == ERROR_FTP_LOGIN)
    message = _GetString("FtpLoginError");
  else if (status == ERROR_FTP_CWD)
    message = _GetString("FtpCwdError");
  else
    message = _GetString("FtpUnknownError");

  AlertWithTitle("FTP", message, window.top);

  EndFtpRequest();
}

function EndFtpRequest()
{
  window.document.documentElement.removeAttribute("style");
  ForgetAboutLastFtpRequest();
  EnableAllUI(true);
}

function StopNavigation()
{
  window.top.document.getElementById("tabeditor").stopWebNavigation(false);
  EndNavigation();
}
function EndNavigation()
{
  window.document.documentElement.removeAttribute("style");
  EnableAllUI(true);
}

function stopCallback()
{
  DropFtpConnection();
  ForgetAboutLastFtpRequest();
  StopNavigation();
}

function AddFTPDirSubdirs(url, dirEntry, treeitem)
{
  var tch = treeitem.lastChild;

  var ti             = document.createElementNS(XUL_NS, "treeitem");
  var tr             = document.createElementNS(XUL_NS, "treerow");
  var tcLocation     = document.createElementNS(XUL_NS, "treecell");
  var tcSize         = document.createElementNS(XUL_NS, "treecell");
  var tcLastModified = document.createElementNS(XUL_NS, "treecell");

  var createdUpperDirEntry = false;

  if (dirEntry)
  {
    var location = dirEntry.location;
    var size;
    if (dirEntry.type == cnsIDirIndex.TYPE_DIRECTORY)
      size = "";
    else
      size = dirEntry.size;
    var description = dirEntry.description;
    var newlocation = url + ( (url[url.length - 1] == "/") ?
                              "" : "/" )
                          + location;
    ti.setAttribute("value", newlocation);
    tcLocation.setAttribute("label", location);
  }
  else
  {
    var URL = GetURLFromUrl(url);
    var path = URL.filePath;
    if (path == "" || path == "/")
      return;

    // get rid of trailing slashes
    while (path.length && path[path.length - 1] == '/')
      path = path.substr(0, path.length - 1);

    // rely on nsIURL magic
    var dir = URL.directory;

    while (dir.length && dir[dir.length - 1] == '/')
      dir = dir.substr(0, dir.length - 1);

    URL.filePath = dir;

    size        = "";
    description = "";
    ti.setAttribute("value", URL.spec);
    tcLocation.setAttribute("label", "..");
    createdUpperDirEntry  = true;
  }

  tcSize.setAttribute("label", size);
  tcLastModified.setAttribute("label", description);
  
  tr.appendChild(tcLocation);
  tr.appendChild(tcSize);
  tr.appendChild(tcLastModified);
  ti.appendChild(tr);

  if (createdUpperDirEntry  ||
      (dirEntry &&
       dirEntry.type == cnsIDirIndex.TYPE_DIRECTORY))
  {
    ti.setAttribute("container", "true");
    var subtch = document.createElementNS(XUL_NS, "treechildren");
    ti.appendChild(subtch);

    tch.insertBefore(ti, gFirstFileEntry);
    gFirstFileEntry = ti.nextSibling;
    return ti;
  }

  tch.appendChild(ti);
  if (!gFirstFileEntry)
    gFirstFileEntry = ti;

  FilterEntry(gCurrentFilter, ti);
  return ti;
}

function FillSiteList()
{
  // Fill the site lists
  var count = 0;
  if (gPublishSiteData)
    count = gPublishSiteData.length;
  var i;

  if (!count)
  {
    var ti = document.createElementNS(XUL_NS, "menuitem");
    ti.setAttribute("label", "--");
    gDialog.SiteList.appendChild(ti);
    gDialog.SiteDropDown.setAttribute("disabled", true);
    gDialog.SiteDropDown.setAttribute("label", _GetString("NoSiteAvailable"));

    gDialog.FilterDropDown.setAttribute("disabled", true);
    return;
  }

  gDialog.SiteDropDown.removeAttribute("disabled");
  gDialog.SiteDropDown.removeAttribute("label");

  gDialog.FilterDropDown.removeAttribute("disabled");

  gDialog.SiteDropDown.removeAttribute("disabled");
  ti = document.createElementNS(XUL_NS, "menuitem");
  ti.setAttribute("label", "Choisir un site");
  ti.setAttribute("disabled", "true");
  gDialog.SiteList.appendChild(ti);
  gDialog.SiteDropDown.selectedItem = ti;

  var ts = document.createElementNS(XUL_NS, "menuseparator");
  gDialog.SiteList.appendChild(ts);
  
  for (i = 0; i < count; i++)
  {
    var name = gPublishSiteData[i].siteName;

    ti = document.createElementNS(XUL_NS, "menuitem");
    ti.setAttribute("label", name);
    ti.setAttribute("value", _GetUrlForPasswordManager(gPublishSiteData[i]));
    ti.setAttribute("oncommand", "SelectSite(this)");

    gDialog.SiteList.appendChild(ti);
  }
}

function CheckIfSiteListUpdated()
{
  if (gSiteListUpdated)
  {
    _removeAllChildren(gDialog.SiteList);
    gPublishSiteData = GetPublishSiteData();
    FillSiteList();
    gSiteListUpdated = false;
  }
}

function TweakSiteSettings()
{
  gSiteListUpdated = true;
  window.top.openDialog("chrome://editor/content/EditorPublishSettings.xul","_blank", "chrome,close,titlebar,modal", "");
  CheckIfSiteListUpdated();
}

function _removeAllChildren(e)
{
  if (e)
  {
    var child = e.lastChild;
    while (child)
    {
      var tmp = child.previousSibling;
      e.removeChild(child);
      child = tmp;
    }
  }
}

function SelectSite(e)
{
  DEBUG("Reinit site");
  EnableAllUI(false);
  gCurrentSiteURL = e.getAttribute("value");
  RemoveSubdirs(gDialog.SiteTree);

  ResetFirstFileEntry();
  if (IsFileUrl(gCurrentSiteURL))
    SelectLocalHDSite(gCurrentSiteURL, gDialog.SiteTree);
  else
    var foo = new FTPDirParser(gCurrentSiteURL, gDialog.SiteTree, AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);

  gDialog.DirectoryList.addEventListener("DOMAttrModified", onTreeModified, false);
}

function _GetUrlForPasswordManager(publishData)
{
  if (!publishData || !publishData.publishUrl)
    return false;

  var url;

  // For FTP, we must embed the username into the url for a site address
  // XXX Maybe we should we do this for HTTP as well???
  if (publishData.username && GetScheme(publishData.publishUrl) == "ftp")
    url = _InsertUsernameIntoUrl(publishData.publishUrl, publishData.username,
                                 window.top.GetSavedPassword(publishData));
  else
    url = publishData.publishUrl;

  // Strip off terminal "/"
  var len = url.length;
  if (len && url.charAt(len-1) == "\/")
    url = url.slice(0, len-1);
  
  return url;
}

function _InsertUsernameIntoUrl(urlspec, username, passwd)
{
  if (!urlspec || !username)
    return urlspec;

  try {
    var ioService = GetIOService();
    var URI = ioService.newURI(urlspec, GetCurrentEditorFromSidebar().documentCharacterSet, null);
    URI.username = username;
    URI.password = passwd;
    return URI.spec;
  } catch (e) {}

  return urlspec;
}

function _GetString(name)
{
  if (!gStringBundle)
  {
    try {
      var strBundleService =
          Components.classes["@mozilla.org/intl/stringbundle;1"].getService(); 
      strBundleService = 
          strBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);

      gStringBundle = strBundleService.createBundle("chrome://editor/locale/sitemanager.properties"); 

    } catch (ex) {}
  }
  if (gStringBundle)
  {
    try {
      return gStringBundle.GetStringFromName(name);
    } catch (e) {}
  }
  return null;
}

function FilterEntry(filter, item)
{
  var isDir = (item.lastChild.nodeName == "treechildren");
  if (!isDir)
  {
    if (filter == "all")
      item.removeAttribute("hidden");
    else
    {
      var cell = item.firstChild.firstChild;
      if (filter == "html")
        var re = /\.html?$/i ;
      else if (filter == "images")
        re = /\.gif$|\.png$|\.jpg$|\.jpeg$/i ;
      if (re.test(cell.getAttribute("label")))
        item.removeAttribute("hidden");
      else
        item.setAttribute("hidden", "true");
    }
  }
}

function ChangeFilter(filter)
{
  var nodeList = document.getElementsByTagName("treeitem");
  var count = nodeList.length, i;
  for (i=0; i<count; i++)
  {
    var item  = nodeList.item(i);
    FilterEntry(filter, item);
  }
}

function SelectsFilter(e)
{
  gCurrentFilter = e.value;
  ChangeFilter(gCurrentFilter);
}


function openFile(e)
{
  if (e.button != 0)
    return;

  var item = GetSelectedItem(gDialog.SiteTree);
  if (!item.getAttribute("container"))
  {
    var newTab = false; // default is false
    var prefs = window.top.GetPrefs()
    try {
      newTab = prefs.getBoolPref("editor.nvu.sitemanager.openInNewTab");
      DEBUG ( "prefs found" );
    }
    catch (e) {};
    EnableAllUI(false);
    window.top.document.getElementById("tabeditor").endNavigationCallback = EndNavigation;
    window.top.editPage(item.getAttribute("value"), window.top, true, newTab);
  }
}

function GetSelectedItem(tree)
{
  if (tree.treeBoxObject.selection.count == 1)
    return tree.contentView.getItemAtIndex(tree.currentIndex);
  else
    return null;
}

// * selects a entry in the tree
//   param XULElement aItem
function SelectTreeItem(tree, aItem)
{
  /* first make sure item's containers are open */
  if (!aItem) return;
  var tmp = aItem.parentNode;
  while (tmp && tmp.nodeName != "tree") {
    if (tmp.nodeName == "treeitem")
      tmp.setAttribute("open", "true");
    tmp = tmp.parentNode;
  }

  /* then select the item */
  var itemIndex = tree.contentView.getIndexOfItem(aItem);
  tree.treeBoxObject.selection.select(itemIndex);
  /* and make sure it is visible in the clipping area of the tree */
  tree.treeBoxObject.ensureRowIsVisible(itemIndex);
}

function ClearTreeSelection(tree) {
  if (tree)
    tree.treeBoxObject.selection.clearSelection();
}

function EnableAllUI(enabled)
{
  if (enabled)
  {
    AllowEvents(gDialog.SiteTree, false);
    gDialog.SiteDropDown.removeAttribute("disabled");
    gDialog.DirectoryList.removeAttribute("disabled");
    gDialog.FilterDropDown.removeAttribute("disabled");
    gDialog.treeViewCheckbox.removeAttribute("disabled");

    gDialog.reloadButton.removeAttribute("disabled");
    gDialog.createDirButton.removeAttribute("disabled");
    gDialog.removeFileOrDirButton.removeAttribute("disabled");

    UseTreeViewUI(gDialog.treeViewCheckbox.getAttribute("checked"));

    gDialog.stopButton.setAttribute("disabled", "true");

    gDialog.mainBox.style.removeProperty("cursor");
  }
  else
  {
    AllowEvents(gDialog.SiteTree, true);
    gDialog.SiteDropDown.setAttribute("disabled", "true");
    gDialog.DirectoryList.setAttribute("disabled", "true");
    gDialog.FilterDropDown.setAttribute("disabled", "true");
    gDialog.treeViewCheckbox.setAttribute("disabled", "true");

    gDialog.reloadButton.setAttribute("disabled", "true");
    gDialog.createDirButton.setAttribute("disabled", "true");
    gDialog.removeFileOrDirButton.setAttribute("disabled", "true");

    gDialog.stopButton.removeAttribute("disabled");

    gDialog.mainBox.style.setProperty("cursor", "wait", "");
  }
}

function AllowEvents(tree, enabled)
{
  if (enabled)
    tree.removeAttribute("allowevents");
  else
    tree.setAttribute("allowevents", false);
}

function ToggleTreeView(checkbox)
{
  var treeView = checkbox.getAttribute("checked");
  UseTreeViewUI(treeView);
  var prefs = window.top.GetPrefs()

  if (treeView)
  {
    try {
      prefs.setBoolPref("editor.nvu.sitemanager.treeView", true);
    }
    catch (e) {};

    var e = gDialog.SiteDropDown.selectedItem;
    SelectSite(e);
    return;
  }

  try {
    prefs.setBoolPref("editor.nvu.sitemanager.treeView", false);
  }
  catch (e) {};

  var item = GetSelectedItem(gDialog.SiteTree);

  if (item)
  {
    if (!item.getAttribute("container"))
    {
      var parentItem = item.parentNode.parentNode;
      if (parentItem.nodeName == "tree")
       var url = gCurrentSiteURL;
      else
        url = parentItem.getAttribute("value");
    }
    else
      url = item.getAttribute("value");
  }
  else if (gLastDirOpenOrClose)
    url = gLastDirOpenOrClose.getAttribute("value");
  else
    url = gDialog.SiteDropDown.selectedItem.getAttribute("value");

  // User wants a view of one directory only.... Let's switch
  // url contains the URL of the "current" directory
  RemoveSubdirs(gDialog.SiteTree);
  
  ResetFirstFileEntry();
  ShowDirHierarchy(url);
  if (IsFileUrl(url))
  {
    AddLocalDirSubdirs(url, null, gDialog.SiteTree)
    SelectLocalHDSite(url, gDialog.SiteTree);
  }
  else
  {
    AllowEvents(gDialog.SiteTree, false);
    AddFTPDirSubdirs(url, null, gDialog.SiteTree);
    var foo = new FTPDirParser(url, gDialog.SiteTree,
                               AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);
  }
}

function GetURLFromUrl(url)
{
  try {
    var URL = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);
    URL.spec = url;
    return URL;
  } catch (e) {
    return null;
  }
}

function DEBUG(foo)
{
  if (debug)
    dump( "SITEMANAGER: " + foo + "\n" );
}

function RemoveFileOrDir()
{
  // can we do that?
  var item = GetSelectedItem(gDialog.SiteTree);
  if (!gCurrentSiteURL || !item)
    return;

  if (item.getAttribute("container"))
    RemoveDir();
  else
    DeleteFile();
}

function DeleteFile()
{
  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  if (promptService.confirm(window, "Delete File : confirmation?",
                            "Are you sure you want to delete this file?"))
  {
    var item = GetSelectedItem(gDialog.SiteTree);
    var url  = item.getAttribute("value");
    if (IsFileUrl(url))
    {
      var localFile = GetLocalFileFromURLSpec(url);
      localFile.remove(false);
      DeleteSelectedItem();
    }
    else
    {
      deleteURLAsync(url);
      AllowEvents(gDialog.SiteTree, false);
    }
  }
}

function NewSubDir()
{
  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  var result = {value:null};
  if (promptService.prompt(window,
                           "Create a new directory?",
                           "Please enter a directory name",
                           result,
                           null,
                           {value:0}))
  {
    var treeView = gDialog.treeViewCheckbox.getAttribute("checked");
    var url;
    if (treeView)
    {
      var item = GetSelectedItem(gDialog.SiteTree);
      if (item)
      {
        url = item.getAttribute("value");
        if (!item.getAttribute("container"))
        {
          var URL = GetURLFromUrl(url);
          URL.fileName = "";
          url = URL.spec;
        }
      }
      else
        url = gCurrentSiteURL;
    }
    else if (gLastDirOpenOrClose)
      url = gLastDirOpenOrClose.getAttribute("value");
    else
      url = gCurrentSiteURL;

    if (IsFileUrl(url))
    {
      file = GetFileFromURLSpec(url);
      file.append(result.value);
      file.create(1, 755);
      url += "/" + result.value
      AppendNewDir(url, file.leafName);
    }
    else
    {
      url += "/" + result.value;
      createDirURLAsync(url, result.value);
      window.document.documentElement.setAttribute("style", "cursor: wait");
      AllowEvents(gDialog.SiteTree, false);
    }
  }
}

function RemoveDir()
{
  // can we do that?
  if (!gCurrentSiteURL)
    return;

  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  if (promptService.confirm(window, "Remove directory : confirmation?",
                            "Are you sure you want to remove this directory?"))
  {
    var item = GetSelectedItem(gDialog.SiteTree);
    var url  = item.getAttribute("value");
    if (IsFileUrl(url))
    {
      var localFile = GetLocalFileFromURLSpec(url);
      var dirEntries = localFile.directoryEntries;
      var removeAll = false;
      if (dirEntries.hasMoreElements())
      {
        while (dirEntries.hasMoreElements())
          var junk = dirEntries.getNext();

        if (promptService.confirm(window, "Remove directory : alert",
                                  "This directory is not empty. Do you want to delete its contents too?"))
          removeAll = true;
      }
      localFile.remove(removeAll);
      DeleteSelectedItem();
    }
    else
    {
      removeDirURLAsync(url);
      window.document.documentElement.setAttribute("style", "cursor: wait");
      AllowEvents(gDialog.SiteTree, false);
    }
  }
}

function RefreshDirView()
{
  // we act differently if we have a tree view or not...
  var treeView = gDialog.treeViewCheckbox.getAttribute("checked");
  if (treeView)
  {
    var item = GetSelectedItem(gDialog.SiteTree);
    var url;
    if (item)
    {
      if (!item.getAttribute("container"))
      {
        var parentItem = item.parentNode.parentNode;
        if (parentItem.nodeName == "tree")
        {
          url = gCurrentSiteURL;
        }
        else
        {
          url = parentItem.getAttribute("value");
        }
      }
      else
        url = item.getAttribute("value");
    }
    else if (gLastDirOpenOrClose)
      url = gLastDirOpenOrClose.getAttribute("value");
    else
      url = gCurrentSiteURL;

    // url is now the URL of the deepest directory to refresh
    // first redisplay the toplevel

    var URL = GetURLFromUrl(url);
    var path = URL.filePath;
    if (path == "" || path == "/")
      return;

    // get rid of trailing and leading slashes
    while (path.length && path[path.length - 1] == '/')
      path = path.substr(0, path.length - 1);
    while (path.length && path[0] == '/')
      path = path.substr(1, path.length - 1);

    gRebuiltDirUrl = gCurrentSiteURL;
    gDirIndex = -1;
    gDirArray = path.split("/");
    AllowEvents(gDialog.SiteTree, false);
    gDialog.DirectoryList.removeEventListener("DOMAttrModified", onTreeModified, false);
    var e = gDialog.SiteDropDown.selectedItem;
    RemoveSubdirs(gDialog.SiteTree);

    ResetFirstFileEntry();
    var foo = new FTPDirParser(gCurrentSiteURL, gDialog.SiteTree, AddFTPDirSubdirs, _autoOpenDir, ErrorFtpRequest);
  }
  else
  {
    // we don't use a tree view, it's much easier
    url = gCurrentSiteURL + gDialog.dirHierarchy.value;
    // User wants a view of one directory only.... Let's switch
    // url contains the URL of the "current" directory
    RemoveSubdirs(gDialog.SiteTree);
    
    ResetFirstFileEntry();
    ShowDirHierarchy(url);
    AddFTPDirSubdirs(url, null, gDialog.SiteTree);
    var foo = new FTPDirParser(url, gDialog.SiteTree,
                               AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);
    AllowEvents(gDialog.SiteTree, false);
  }
}

function _autoOpenDir()
{
  gDirIndex++;

  if (!gDirArray || gDirIndex >= gDirArray.length)
  {
    delete gDirArray;
    EndFtpRequest();
    gDialog.DirectoryList.addEventListener("DOMAttrModified", onTreeModified, false);
    return;
  }

  gRebuiltDirUrl += "/" + gDirArray[gDirIndex];
  var elements = gDialog.SiteTree.getElementsByAttribute("value", gRebuiltDirUrl);
  if (elements.length == 1)
  {
    ResetFirstFileEntry();
    elements[0].setAttribute("open", "true");
    gLastDirOpenOrClose = elements[0];
    DEBUG("now unfold" + gRebuiltDirUrl);
    var foo = new FTPDirParser(gRebuiltDirUrl, elements[0],
                               AddFTPDirSubdirs, _autoOpenDir, ErrorFtpRequest);
  }
}

function DeleteSelectedItem()
{
  var selected = GetSelectedItem(gDialog.SiteTree);
  selected.parentNode.removeChild(selected);
}

function AppendNewDir(aUrl, aDirName)
{
  var treeView = gDialog.treeViewCheckbox.getAttribute("checked");
  if (treeView)
  {
    var root = GetSelectedItem(gDialog.SiteTree) || gDialog.SiteTree;
  }
  else
    root = gDialog.SiteTree;

  var ti = AddFTPDirSubdirs(aUrl,
                            {type: cnsIDirIndex.TYPE_DIRECTORY,
                             location: aDirName,
                             size: 0,
                             description: ""},
                            root);
  SelectTreeItem(gDialog.SiteTree, ti);
}

