// Spell checking dictionary for Nvu
// Script written by rockstiff, modified by Thorsten Fritz. Dictionary from openoffice.org

const APP_DISPLAY_NAME	= "cs-CZ";
const APP_NAME		= "Dictionary";
const APP_PACKAGE		= "www.mozilla.nightrat.net/nvu";
const APP_VERSION		= "1.0";

var err = initInstall(APP_NAME, APP_PACKAGE, APP_VERSION);
if (err==SUCCESS) {

  // Copy files to Components/myspell
  var myspell_folder = getFolder("Components", "myspell");
  addFile(APP_NAME, "cs_CZ.dic", myspell_folder, "");
  addFile(APP_NAME, "cs_CZ.aff", myspell_folder, "");
  addFile(APP_NAME, "README_cs_CZ.txt", myspell_folder, "");

  err = performInstall();
  if(err == SUCCESS || err == 999) {
    alert(APP_DISPLAY_NAME+" (v "+APP_VERSION+") succesfully installed.\n\nDictionarys are not listed in the extension manager!");
  }
  else {
    alert("Installation failed.\n\nError: " + err);
    cancelInstall(err);
  }

}
else {
  cancelInstall(err);
}