/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2006 by HJ van Rantwijk.  All Rights Reserved.
  */

const MZ_TRUE = "true";
const MZ_FALSE = "false";

var gManager, gPreferences, gDialogManager, gTabbrowser, gDataCollection;
var gBackLabel, gBackImage, gForwardLabel, gForwardImage;
var gHistoryDataSource, gHistoryTree, gModified, gFileAsBookmark;
var gHistoryPropertiesToBeRemoved = new Array();

var gElementArray = new Array();
var gElementIDs = new Array("label", "custom", "firstpage", "image", "location", "interval", "selected",
                           "ordinal", "allowPlugins", "allowJavascript", "allowMetaRedirects", 
                           "allowSubframes", "allowImages", 
                           "interval-enabled", "allow-all", "block-all", "SelectedTabMenulist");

var defaultValues = [ "about:blank", "false", "about:blank", "", "about:blank", "0", "false", "0", "true", "true", "true", "true", "true" ];
var mzRDFStore = null;
var RDF = null;

function preLaunch()
{
  gManager = window.top;
  gPreferences = window.top.gPreferences;
  gManager.selectWindowStyling(document.documentElement);
  gDialogManager = gManager.frames['mainWindowFrame'];
  gBackImage = document.getElementById('BackImage');
  gBackLabel = document.getElementById('BackLabel');
  gForwardLabel = document.getElementById('ForwardLabel');
  gForwardImage = document.getElementById('ForwardImage');
  gHistoryDataSource = Components.classes['@mozilla.org/rdf/datasource;1?name=in-memory-datasource'].createInstance(Components.interfaces.nsIRDFDataSource);
  gHistoryTree = document.getElementById("TabHistoryTree");
  gFileAsBookmark = document.getElementById("FileAsBookmark");

  gHistoryTree.database.AddDataSource(gHistoryDataSource);
  gTabbrowser = gManager.getTabbrowser(true);
  gDialogManager.mzInitializeRDFStorageFile();

  for (i in gElementIDs) {
    if (i == 6) // skip 'selected'
      continue;
    gElementArray[i] = document.getElementById(gElementIDs[i]);
  }
  mzRDFStore = gDialogManager.mzRDFStore;
  RDF = gDialogManager.RDF;
}

function startup()
{
  gFileAsBookmark.setAttribute("disabled", "true");
  gElementArray[14].setAttribute("disabled", "true");
  gElementArray[15].setAttribute("disabled", "true");
  gModified = false;
  gDataCollection = null;
  setResource(0);
  initTabProperties();
  refreshFocus();
}

function initTabProperties()
{
  var dataCollection = gDialogManager.mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(gDialogManager.gResource));

  if (dataCollection) {
    activateSettings(dataCollection);
    var selectedTabIndex = dataCollection[14]; // selected tab index

    if (selectedTabIndex == -1) { // Do we have a selected tab?
      gElementArray[16].selectedIndex = 0;
      changeSelectedTabTo(gElementArray[16].firstChild.childNodes[0].getAttribute("resource"));
      // validate the properties of this tab session.
      var containerResource = gDialogManager.gResource.replace(/tab-\w*/, 'root');
      // gDialogManager.sessionTreeBuilderObserver._validateContainer(containerResource);
    }
    else {
      gElementArray[16].selectedIndex = selectedTabIndex;
    }
    initTabSelectorMenus();
    initHistoryTree(gDialogManager.gResource);
    // The returned array has 14 items [0-13] but we add two more here.
    dataCollection[14] = gElementArray[16].selectedIndex;
    dataCollection[15] = gHistoryTree.treeBoxObject.view.rowCount;

    if (gDataCollection == null)
      gDataCollection = dataCollection;

    // Initialize the 'Allow All' or 'Suppress All' buttons
    onProperty(null);
  }
  setBackForwardButtons();
  enableBookmarkButton();
  hasModifiedSettings();
}

function activateSettings(aDataCollection)
{
  gElementArray[0].value = aDataCollection[0]; // title
  gElementArray[1].checked = (aDataCollection[1] == MZ_TRUE); // custom
  gElementArray[2].value = aDataCollection[2]; // firstpage
  gElementArray[3].src = aDataCollection[3]; // favicon/site icon
  gElementArray[3].hidden = (aDataCollection[3] == "");
  gElementArray[4].value = aDataCollection[4]; // location

  var reloadInterval = aDataCollection[5]; // interval
  gElementArray[5].disabled = (reloadInterval == 0);
  gTabbrowser.initReloadPopup(document, gElementArray[5].firstChild, null, reloadInterval);
  gElementArray[13].checked = (reloadInterval > 0);

  // Tab Properties
  for (var i = 8; i < 13; i++) {
    gElementArray[i].checked = (aDataCollection[i] == MZ_TRUE);
  }  
}

function getDataCollection()
{
  var defaultScheme = "http://";
  var aDataCollection = new Array();
  // Data Collection buildup
  aDataCollection[0] = gElementArray[0].value; // title
  aDataCollection[1] = gElementArray[1].checked ? MZ_TRUE : MZ_FALSE; // custom
  // Check for missing scheme in 'firstpage' textbox.
  if (gElementArray[2].value.indexOf(":") < 0) // Add default scheme
    gElementArray[2].value = defaultScheme + gElementArray[2].value;
  if (gElementArray[2].value == defaultScheme)
    gElementArray[2].value = defaultValues[2];
  aDataCollection[2] = gElementArray[2].value; // firstpage
  aDataCollection[3] = gElementArray[3].value; // image
  // Check for missing scheme in 'location' textbox.
  if (gElementArray[4].value.indexOf(":") < 0) // Add default scheme
    gElementArray[4].value = defaultScheme + gElementArray[4].value;
  if (gElementArray[4].value == defaultScheme)
    gElementArray[4].value = defaultValues[4];
  aDataCollection[4] = gElementArray[4].value; // location
  aDataCollection[5] = gElementArray[5].value; // Reload interval

  // Tab Properties
  for (var i = 8; i < 13; i++) {
    aDataCollection[i] = gElementArray[i].checked ? MZ_TRUE : MZ_FALSE;
  }
  aDataCollection[14] = gElementArray[16].selectedIndex; // selected tab index
  aDataCollection[15] = gHistoryTree.treeBoxObject.view.rowCount;
  return aDataCollection;
}

function refreshReloadState()
{
  var disabled = !gElementArray[13].checked
  gElementArray[5].disabled = disabled;

  if (disabled) {
    gElementArray[5].value = 0;
    hasModifiedSettings();
  }
}

function onProperty(aElement)
{
  var id = aElement ? aElement.getAttribute("id") : "";
  var properties = 0;
  // Count number of checked property checkboxes
  for (var i = 8; i < 13; i++) {
    if (gElementArray[i].checked)
      properties++
  }
  // Called from the 'Allow All' or 'Suppress All' buttons
  if (id == gElementIDs[14] || id == gElementIDs[15]) {
    properties = (id == gElementIDs[14]) ? 5 : 0;
    for (i = 8; i < 13; i++)
      gElementArray[i].checked = (properties);
  }
  // Update button state
  gElementArray[14].disabled = (properties == 5);
  gElementArray[15].disabled = (properties == 0);

  if (aElement) // skipped at startup
    hasModifiedSettings();
}

function setReloadInterval(aMenuitem)
{
  gElementArray[5].value = (aMenuitem.getAttribute('value') * 1000);
  hasModifiedSettings();
}

function storeDataCollection()
{
  var MZ = "http://multizilla.mozdev.org/rdf#";
  var modifiedDataCollection = getDataCollection();
  var resource = RDF.GetResource(gDialogManager.gResource);

  try {
    for (var i = 0; i < 13; i++) {
      if (modifiedDataCollection[i] != undefined && gDataCollection[i] != modifiedDataCollection[i]) {
        var property = RDF.GetResource(MZ + gElementIDs[i]);
        var newValue = RDF.GetLiteral(modifiedDataCollection[i]);
        var currentValue = mzRDFStore.GetTarget(resource, property, true);

        if (modifiedDataCollection[i] == defaultValues[i])
          mzRDFStore.Unassert(resource, property, currentValue);
        else
          gDialogManager.mzAddOrChangeValue(mzRDFStore, resource, property, currentValue, newValue);
      }
    }
  } catch(ex) { 
    // die silently
  }
  // Are there pending history items for removal?
  if (gHistoryPropertiesToBeRemoved.length > 0) {
    /* for (i in gHistoryPropertiesToBeRemoved) {
      gDialogManager.mzRemoveHistoryByObjects(gHistoryPropertiesToBeRemoved[i]);
    } */
    gDialogManager.mzRemoveHistoryByObjects(gHistoryPropertiesToBeRemoved);
  }
  resource = gElementArray[16].firstChild.childNodes[gElementArray[16].selectedIndex].getAttribute("resource");

  if (resource && gElementArray[16].selectedIndex != gDataCollection[16])
    changeSelectedTabTo(resource);
  else 
    gDialogManager.mzFlushDataSource(mzRDFStore);

  gModified = false;
  modifiedDataCollection = null;
  gHistoryPropertiesToBeRemoved = new Array();
}

function hasModifiedSettings()
{
  // dump("\n\ntabProperties hasModifiedSettings()");
  var currentValues = getDataCollection();

  for (var i = 0; i < 16; i++) {
    // dump("\ni: " + i);
    if (currentValues[i] != undefined && gDataCollection[i] != currentValues[i]) {
      // dump("\ngDataCollection: " + gDataCollection[i]);
      // dump("\ncurrentValues  : " + currentValues[i]);
      gModified = true;
      break;
    }
  }
  if (i == 16 && gModified)
    gModified = false;
  // dump("\ngModified: " + gModified);
  gManager.gAcceptButton.disabled = !gModified;

  if (gModified)
    gManager.gCancelButton.removeAttribute('action');
  else
    gManager.gCancelButton.setAttribute('action', 'back');
  var buttonLabel = (gModified) ? "cancelButtonLabel" : "backButtonLabel";
  gManager.gCancelButton.label = gManager.gStringBundle.getString(buttonLabel);
}

function setBackForwardButtons()
{
  var tree = gDialogManager.tree;
  var row = tree.currentIndex;
  var disabled = (row > 0) ? tree.treeBoxObject.view.isContainer(row - 1) : false;

  gBackLabel.disabled = disabled;
  gBackImage.setAttribute('disabled', disabled ? 'true' : 'false');
  disabled = (tree.treeBoxObject.view.hasNextSibling(row, row) == false);
  gForwardLabel.disabled = disabled;
  gForwardImage.setAttribute('disabled', disabled ? 'true' : 'false');
}

function setResource(aDirection, aRow)
{
  var tree = gDialogManager.tree;
  tree.currentIndex = (aRow == undefined) ? (tree.currentIndex + aDirection) : aRow;
  gDialogManager.sessionManager.selectRows(tree, 'none');
  tree.treeBoxObject.ensureRowIsVisible(tree.currentIndex);

  var resource = tree.builderView.getResourceAtIndex(tree.currentIndex).Value;
  document.getElementById('TabSessionID').value = resource;
  gDialogManager.gResource = resource;
}

function refreshPropertyData(aDirection, aRow)
{
  // We need to check the disable state of the 'label' buttons!
  var canBack = gBackLabel.disabled;
  var canForward = gForwardLabel.disabled;

  if (aDirection == -1 && canBack ||
     aDirection == 1 && canForward || 
     aDirection == undefined && aRow == undefined)
    return;

  var prefString = "multizilla.session-manager.confirm.property-changes";
  var shouldSkip = gPreferences.readBoolean(prefString, false);
  // dump("\nshouldSkip: " + shouldSkip);
  var result = (gModified && shouldSkip) ? 0 : 1;
  // dump("\nresult: " + result);
  if (gModified && !shouldSkip) {
    var dialogTitle = gManager.gStringBundle.getString("tsmConfirmActionTitle");
    var dialogText = gManager.gStringBundle.getString("tsmConfirmStorageText");
    var checkboxText = gManager.gStringBundle.getString("tsmKeepStorageDecisionText");
    var checkbox = {checked:true}
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);
    result = promptService.confirmEx(gManager, dialogTitle, dialogText,
                                     (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                     (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                     null, null, null, checkboxText, checkbox);

    gPreferences.writeBool(prefString, checkbox.value);
  }
  if (result == 0) // Yes returns 0 and No, Esc and X on window returns 1
    storeDataCollection();
  else
    gModified = (result == 0);
  gDataCollection = null; // initProperties() must re-initialize!
  // dump("\ngModified: " + gModified);
  setResource(aDirection, aRow);
  initTabProperties();
}

function initTabSelectorMenus()
{
  addTabsToMenu(gElementArray[16]);
  addTabsToMenu(document.getElementById("TabsPopup")); // Init tab popup menu for ctrl+clicks on image buttons
}

function showTabSelectorMenu(aEvent)
{
  var xpos = (aEvent.type == "keyup") ? aEvent.target.boxObject.x : aEvent.clientX;
  var ypos = (aEvent.type == "keyup") ? aEvent.target.boxObject.y : aEvent.clientY;
  var tabsPopup = document.getElementById("TabsPopup");
  tabsPopup.setAttribute("callerID", aEvent.target.id);
  tabsPopup.showPopup(tabsPopup, xpos, ypos, "popup", "at_pointer");
  tabsPopup.focus();
}

function addTabsToMenu(aParent)
{
  var selectedResource = gDialogManager.gResource;
  var containerResource = selectedResource.replace(/tab-\w*/, 'root');
  var resourceList = gDialogManager.mzGetResourcesFromContainer(mzRDFStore, RDF.GetResource(containerResource));
  var selectedIndex = -1;
  var isMenulist = (aParent.localName == "menulist");
  var popupNode = isMenulist ? aParent.firstChild : aParent; // there's no <menupopup> for <popup>
  var children = popupNode.childNodes;
  var startIndex = -1;
  var resource;

  // Remove old menu items from the bottom up
  for (var i = children.length - 1; i >= 0; --i) {
    popupNode.removeChild(children[i]);
  }
  // The menu items for the tab selection popup need row numbers
  if (!isMenulist) {
    startIndex = gDialogManager.tree.currentIndex;
    // Adjust 'startIndex' to the first tab in this session
    for (i = 0; i < resourceList.length; i++) {
      resource = resourceList[i];
      // Is this the currently displayed tab?
      if (resource == selectedResource) {
        break;
      }
      startIndex--;
    }
  }
  // Add menu items
  for (rIndex in resourceList) {
    resource = resourceList[rIndex];
    var propertyValues = gDialogManager.mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(resource));
    // var menuitem = popupNode.appendItem(propertyValues[0]);
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("class", "menuitem-iconic");
    menuitem.setAttribute("label", propertyValues[0]);
    menuitem.setAttribute("src", propertyValues[3]);
    menuitem.setAttribute("resource", resource);

    if (isMenulist) {
      // Is this the selected tab?
      if (selectedIndex < 0 && propertyValues[6] == MZ_TRUE) {
        menuitem.selected = true;
        selectedIndex = Number(rIndex);
      }
    }
    else {
      var row = startIndex + Number(rIndex);
      menuitem.setAttribute("row", row);
    }
    // Disable the currently selected/displayed tab
    if (resource == selectedResource)
      menuitem.setAttribute("disabled", "true");

    popupNode.appendChild(menuitem);
  }
  if (isMenulist)
    aParent.selectedIndex = selectedIndex;
}

function refreshSelectTabMenulist(aMenupopup)
{
  var menuitems = aMenupopup.childNodes;
  var numberOfItems = menuitems.length;
  var selectedIndex = aMenupopup.parentNode.selectedIndex;

  for (var i = 0; i < numberOfItems; i++) {
    if (i == selectedIndex)
      menuitems[i].setAttribute("disabled", true);
    else if (menuitems[i].hasAttribute("disabled"))
      menuitems[i].removeAttribute("disabled");
  }
  hasModifiedSettings();
}

// We might want to rename this function and add it to multiviewsRDF.js for global use
function changeSelectedTabTo(aResource)
{
  var sessionContainerResource = aResource.replace(/tab-\w*/, 'root')
  var resourceList = gDialogManager.mzGetResourcesFromContainer(mzRDFStore, RDF.GetResource(sessionContainerResource));
  var selectedTabStyle = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");
  var mzRDF = "http://multizilla.mozdev.org/rdf#";
  var selected_property = RDF.GetResource(mzRDF + "selected");
  var selectedTabStyle_property = RDF.GetResource(mzRDF + "selectedTabStyle");

  for (i in resourceList) {
    var resource = RDF.GetResource(resourceList[i]);
    var isSelected = mzRDFStore.GetTarget(resource, selected_property, true);
    var hasStyle = mzRDFStore.GetTarget(resource, selectedTabStyle_property, true);

    if (resourceList[i] == aResource) {
      gDialogManager.mzAddOrChangeValue(mzRDFStore, resource, selected_property, isSelected, RDF.GetLiteral("true"));
      gDialogManager.mzAddOrChangeValue(mzRDFStore, resource, selectedTabStyle_property, hasStyle, RDF.GetLiteral(selectedTabStyle));
    }
    else {
      if (isSelected)
        mzRDFStore.Unassert(resource, selected_property, isSelected);
      if (hasStyle)
        mzRDFStore.Unassert(resource, selectedTabStyle_property, hasStyle);
    }
  }
  gDialogManager.mzFlushDataSource(mzRDFStore);
}

function doBackForward(aEvent, aDirection)
{
  // dump("\ndoBackForward()");
  if (aEvent.target.getAttribute("disabled") == "true")
    return;
  if (aEvent.ctrlKey) {
    showTabSelectorMenu(aEvent);
    return;
  }
  refreshPropertyData(aDirection);

  if (aEvent.type == "keyup") {
    if (aEvent.target.getAttribute("disabled") == "true") {
      if (aEvent.target.id == "BackImage")
        document.getElementById("ForwardImage").focus();
      else {
        document.getElementById("BackImage").focus();
      }
    }
    else {
      aEvent.target.focus();
    }
  }
  else {
    refreshFocus();
  }
}

function refreshFocus()
{
  // Focus 'Title' textbox or 'Custom Title' checkbox
  var focusedElement = Number(gElementArray[1].checked);
  focusedElement = gElementArray[focusedElement];
  // Select all text in the location field
  if (focusedElement.localName == "textbox") {
    focusedElement.setSelectionRange (0, focusedElement.value.length);
    focusedElement.select();
  }
  else {
    focusedElement.focus();
  }
}

function selectTab(aEvent)
{
  // dump("\nselectTab()");
  var menuitem = aEvent.originalTarget;
  var row = Number(menuitem.getAttribute("row"));

  refreshPropertyData(undefined, row);
  var tabsPopup = document.getElementById("TabsPopup");
  var callerID = tabsPopup.getAttribute("callerID");
  var closeTabSelectionMenu = gPreferences.readBoolean("multizilla.session-manager.tabselectionmenu-autoclose", true);
  // Some people might want to keep this menu open ;)
  if (closeTabSelectionMenu) {
    tabsPopup.hidePopup();

    if (callerID) {
      var targetButton = document.getElementById(callerID);

      if (targetButton.getAttribute("disabled") == "true")
        callerID = (callerID.match(/^Back/)) ? "ForwardImage" : "BackImage";
      else
        callerID = (callerID.match(/^Back/)) ? "BackImage" : "ForwardImage";

      setTimeout(refocusBackForwardButton, 0, callerID);
    }
  }
}

function refocusBackForwardButton(aButtonID)
{
  document.getElementById(aButtonID).focus();
}

function selectRows(aAction)
{
  var isDisabled = gHistoryTree.hasAttribute("disabled");

  if (isDisabled)
    return;

  if (aAction == 'none')
    gHistoryTree.currentIndex = -1;
  gDialogManager.sessionManager.selectRows(gHistoryTree, aAction);
}

function enableBookmarkButton()
{
  var bookmarks = Components.classes["@mozilla.org/rdf/datasource;1?name=bookmarks"].getService(Components.interfaces.nsIRDFDataSource);
  var URL_Property = RDF.GetResource("http://home.netscape.com/NC-rdf#URL");
  var URL_Literal = RDF.GetLiteral(gDataCollection[4]);
  var isBookmarked = bookmarks.GetSource(URL_Property, URL_Literal, true);
  gFileAsBookmark.disabled = (isBookmarked);
  // dump("\nswitchPage-end  : " + new Date().valueOf());
}

function fileAsBookmark()
{
  // Ctrl+Shift+D should not work when the 'File As Bookmark' button is disabled
  if (document.getElementById("FileAsBookmark").disabled)
    return;

  var url = gElementArray[4].value;
  var title = gElementArray[0].value;
  var characterSet = gManager.opener.document.characterSet;

  openDialog("chrome://communicator/content/bookmarks/addBookmark.xul", "",
             "centerscreen, chrome, dialog=yes,resizable=yes,dependent",
             title, url, null, characterSet, null, null);

  refreshFocus();
}

function initHistoryTree(aResource)
{
  var historyObj = gDialogManager.mzGetHistoryFromResource(mzRDFStore, aResource);
  var resource = "urn:history:root";

  if (historyObj) {
    gDialogManager.mzRemoveDataResources(gHistoryDataSource, resource);
    gHistoryTree.removeAttribute("disabled");
    var mzRDF = "http://multizilla.mozdev.org/rdf#";
    var historyContainer = gDialogManager.mzConstructRDFContainer(gHistoryDataSource, "seq", resource, false);

    for (hIndex in historyObj.tabHistoryEntries) {
      resource = "urn:history:entry-" + hIndex;
      gDialogManager.mzRemoveDataResources(gHistoryDataSource, resource);
      var entry = historyObj.tabHistoryEntries[hIndex];
      var title = entry.title || entry.uri.spec;
      var property = mzRDF + "titleOrURI";
      gHistoryDataSource.Assert(RDF.GetResource(resource), RDF.GetResource(property), RDF.GetLiteral(title), true);
      property = mzRDF + "index";
      gHistoryDataSource.Assert(RDF.GetResource(resource), RDF.GetResource(property), RDF.GetLiteral(entry.index), true);
      historyContainer.AppendElement(RDF.GetResource(resource));
      gDialogManager.mzFlushDataSource(gHistoryDataSource);
    }
    gHistoryTree.builder.rebuild();
    var historyIndex = Number(historyObj.tabHistoryIndex);

    if (historyIndex >= 0) {
      gHistoryTree.view.selection.clearSelection();
      gHistoryTree.view.selection.select(historyIndex);
      gHistoryTree.treeBoxObject.ensureRowIsVisible(historyIndex);
    }
    historyContainer = null;
  }
  else {
    gHistoryTree.setAttribute("disabled", "true");
  }
  historyObj = null;
}

function initHistoryContextMenu(aEvent)
{
  if (gHistoryTree.hasAttribute("disabled")) // No context menu for disabled trees!
    return false;

  var rowCount = gHistoryTree.treeBoxObject.view.rowCount;
  var targetRow = gDialogManager.sessionManager.getRowNumber(aEvent, gHistoryTree);
  var selectedRows = gDialogManager.sessionManager.getSelectedRows(gHistoryTree);
  // Context menu and menu items
  var contextMenu = document.getElementById("tsmHistoryContextMenu");
  var selectAll = document.getElementById("SelectAll");
  var undoSelection = document.getElementById("UndoSelection");
  var deleteSelectedItems = document.getElementById("DeleteSelectedItems");
  var clearAllItems = document.getElementById("ClearAllItems");
  // The following block needs to be changed/finished!
  if (rowCount >= 1) {
    if (selectedRows.length > 1) {
      selectAll.setAttribute("disabled", "true");
      undoSelection.removeAttribute("disabled");
      deleteSelectedItems.removeAttribute("disabled");
      clearAllItems.setAttribute("disabled", "true");
    }
    else { // No selection, enable "Select All" and disable "Deselect All"
      selectAll.removeAttribute("disabled");
      undoSelection.setAttribute("disabled", "true");

      if (selectedRows.length == 1)
        deleteSelectedItems.removeAttribute("disabled");
      else
        deleteSelectedItems.setAttribute("disabled", "true");
      clearAllItems.removeAttribute("disabled");
    }
  }
  return true;
}

function removeHistoryItems(aEvent)
{
  var action = aEvent.originalTarget.getAttribute("action");
  var selectedResource = gDialogManager.gResource;

  if (action == "all")
    gDialogManager.sessionManager.selectRows(gHistoryTree, action);

  var selectedRows = gDialogManager.sessionManager.getSelectedRows(gHistoryTree);
  gHistoryTree.view.selection.clearSelection();
  var columnID = "historyindex";
  columnID = ('columns' in gHistoryTree) ? gHistoryTree.columns[columnID] : columnID;
  var mzRDF = "http://multizilla.mozdev.org/rdf#";
  // Delete the selected row(s) from the bottom to the top
  for (var i = (selectedRows.length - 1); i > -1; i--) {
    var row = Number(selectedRows[i]);
    var index = gHistoryTree.view.getCellText(row, columnID);
    // Remove selected item from tree
    var resource = "urn:history:entry-" + index;
    gDialogManager.mzRemoveDataResources(gHistoryDataSource, resource);
    // Remove item from history container
    var historyContainer = gDialogManager.mzConstructRDFContainer(gHistoryDataSource, "seq", "urn:history:root", false);
    historyContainer.RemoveElement(RDF.GetResource(resource), true);
    // Construct object to remove item from multizilla.rdf
    var obj = new Object();
    obj.index = Number(index);
    obj.resource = selectedResource;
    obj.property = mzRDF + "history-" + obj.index;
    // Add item to pending removal queue (removal will be done in function storeDataCollection)
    gHistoryPropertiesToBeRemoved.push(obj);
  }
  // Are all items removed?
  if (historyContainer.GetCount() < 1) {
    // Yes, remove history container and disable tree
    gDialogManager.mzRemoveDataResources(gHistoryDataSource, "urn:history:root");
    gHistoryTree.setAttribute("disabled", "true");
  }
  gDialogManager.mzFlushDataSource(gHistoryDataSource);
  refreshFocus();
  hasModifiedSettings();
}

function shutdown()
{
  gHistoryTree.database.RemoveDataSource(gHistoryDataSource);
}

function onCancel(aEvent)
{
  if (gModified && gManager.gConfirmForID > 1) { // 1 = [Cancel] button
    if (gManager.getConfirmation('mzWizard', 'prefPanelConfirmCloseText'))
      storeDataCollection();
  }
  return (gManager.gConfirmForID > 2); // return true for Accel+W and Window[X]
}

function onAccept(aEvent)
{
  storeDataCollection();
  return false;
}

