var gFrame = null;
var gDragAndDrop = null;
var gConfirmCheckbox = false;
var gEscapeKeyPressed = false;
var gSettingsOnStartup = false;
var gIsMac, gConfirmForID = 0;
var gFrameElement, gMainWindowFrame, gPropertiesFrame, gSettingsFrame, gClassicStyle;
var gStringBundle, gDialogHeader, gAcceptButton, gAcceptButtonLabelID, gCancelButton, gHelpPages;
var gPreloadStatus = 3;
var gPreLoad_F3 = 2;
var gPreLoad_ALT = 3;
var gPreferences;

function startup()
{
  gPreferences = window.opener.gMultiZilla.prefs;
  selectWindowStyling(document.documentElement);
  gStringBundle = document.getElementById("properties");
  gDialogHeader = document.getElementById("header");
  gMainWindowFrame = document.getElementById("mainWindowFrame");
  gPropertiesFrame = document.getElementById("propertiesFrame");
  gSettingsFrame = document.getElementById("settingsFrame");
  gFrame = window.frames['mainWindowFrame'];
  gAcceptButton = document.documentElement.getButton('accept');
  gCancelButton = document.documentElement.getButton('cancel');
  gDragAndDrop  = window.opener.nsDragAndDrop;
  window.document.addEventListener("keydown", keydownHandler, false);
  window.document.addEventListener("keyup", keyupHandler, false);

  if ('extended_Startup' in window)
    extended_Startup();
  if (gSettingsOnStartup) {
    preLoad(1);
    setTimeout(switchPage, 0, "settingsFrame");
  }
}

function preLoad(aPreLoadType)
{
  if (gPreloadStatus == 0)
    return;
  // dump("\n\npreLoad: " + aPreLoadType);
  var target = "";
  var bitValue = 0;
  // dump("\ngPreloadStatus: " + gPreloadStatus);
  if ('extended_PreLoad' in window) 
    gPreloadStatus = extended_PreLoad(aPreLoadType);
  // dump("\ngPreloadStatus: " + gPreloadStatus);
  if ((gPreloadStatus & 2) && (aPreLoadType & 2)) {
    // dump("\npreLoad -> propertiesFrame");
    window.frames['propertiesFrame'].location = gCHROMEBASE + "properties/propertiesFrame.xul";
    bitValue = 2;
    gPreloadStatus &= ~bitValue;
  }
  if ((gPreloadStatus & 1) && (aPreLoadType & 1)) {
    // dump("\npreLoad -> settingsFrame");
    gSettingsFrame.setAttribute("src", gCHROMEBASE + "preferences/settingsFrame.xul");
    bitValue = 1;
    gPreloadStatus &= ~bitValue;

    if (!hPrefWindow) // Fixing breakage caused by mozilla bug 228904
      hPrefWindow = new nsPrefWindow('settingsFrame');
    if (!hPrefWindow)
      throw "MultiZilla: Manager failed to initialize settings frame!";
  }
  window.setCursor("default"); 
}

function switchPage(aType)
{
  var mainFrameCollapsed = true;
  var hideHeader = true;
  var acceptButtonLabel = "saveButtonLabel";
  var cancelButtonLabel = "backButtonLabel";

  switch(aType) {
    case "mainWindowFrame":
         gFrameElement = gMainWindowFrame;
         acceptButtonLabel = (gAcceptButtonLabelID) ? gAcceptButtonLabelID : "openButtonLabel";
         cancelButtonLabel = "closeButtonLabel";
         mainFrameCollapsed = false;
         break;

    case "propertiesFrame":
         gFrameElement = gPropertiesFrame;
         break;

    case "settingsFrame":
         hideHeader = false;
         gFrameElement = gSettingsFrame;
         break;

    default:
         gFrameElement = extended_switchPage(aType);
  }
  gFrame = window.frames[aType];

  if (gFrame.location == "about:blank")
    gFrame.location = gFrameElement.getAttribute("chromeURL");

  window.document.title = gFrameElement.getAttribute("windowTitle");

  if (gDialogHeader)
    gDialogHeader.hidden = gIsMac ? true : hideHeader;

  if ('startup' in gFrame)
    setTimeout(gFrame.startup, 0);

  var iframeElements = document.getElementsByTagName("iframe");

  for (var i = 0; i < iframeElements.length; i++) {
    iframeElements[i].collapsed = (iframeElements[i].id == aType) ? false : true;
  }
  gCancelButton.label = gStringBundle.getString(cancelButtonLabel);
  gAcceptButton.label = gStringBundle.getString(acceptButtonLabel);
  gAcceptButton.disabled = true;

  if (mainFrameCollapsed)
    gCancelButton.setAttribute('action', 'back');
  else {
    gCancelButton.removeAttribute('action');        

    if ('reFocus' in gFrame)
      setTimeout(gFrame.reFocus, 0);
  }
  gConfirmForID = 0;
}

function selectWindowStyling(aDocumentElement)
{
  const isLinux = /Linux/.test(navigator.platform);

  if (isLinux)
    aDocumentElement.setAttribute("extraStyling", "linux");
  if (gClassicStyle)
    aDocumentElement.removeAttribute("extraStyling");
  if (gIsMac)
    aDocumentElement.setAttribute("macStyling", "true");
}

function readMyPref(aPrefString, aPrefType, aDefaultValue)
{
  alert("YOU SHOULD NOT SEE THIS, PLEASE REPORT THIS BUG!");
  var navigatorWindow = getNavigatorWindow(true);

  try {
    if (gPreferences == undefined)
      gPreferences = navigatorWindow.gMultiZilla.prefs;
  }
  catch(ex) {
    // dump("\nreadMyPref ex: " + ex);
  }
  return navigatorWindow.gMultiZilla.prefs.readMyPref(aPrefString, aPrefType, aDefaultValue);
}

function writePref(aPrefType, aPrefString, aValue)
{
  alert("YOU SHOULD NOT SEE THIS, PLEASE REPORT THIS BUG!");
  var navigatorWindow = getNavigatorWindow(true);

  try {
    if (gPreferences == undefined)
      gPreferences = navigatorWindow.gMultiZilla.prefs;
  }
  catch(ex) {
    // dump("\nwritePref ex: " + ex);
  }
  return navigatorWindow.gMultiZilla.prefs.writePref(aPrefType, aPrefString, aValue);
}

function getNavigatorWindow(aOpenFlag)
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var navigatorWindow = windowManager.getMostRecentWindow("navigator:browser");

  if (!navigatorWindow) {
    if (!aOpenFlag)
      navigatorWindow = null;
    else {
      window.open();
      navigatorWindow = windowManager.getMostRecentWindow("navigator:browser");
    }
  }
  return navigatorWindow;
}

function getTabbrowser(aOpenFlag)
{
  var navigatorWindow = getNavigatorWindow(aOpenFlag);

  if (navigatorWindow)
    return navigatorWindow.getBrowser();
  return null;
}

function getBrowser()
{
  return getTabbrowser(true);
}

function getConfirmation(aTitle, aText, aCheckboxText)
{
  gConfirmCheckbox = false;
  var checkbox = {};
  var checkboxText = aCheckboxText ? gStringBundle.getString(aCheckboxText) : null;
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
  var result = promptService.confirmEx(window, gStringBundle.getString(aTitle), gStringBundle.getString(aText),
                                       (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                       (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                       null, null, null, checkboxText, checkbox);
  gConfirmCheckbox = checkbox.value;
  return (result == 0); // Yes returns 0 / No, Esc and X returns 1
}

function confirmClose(aConfirmForID)
{
  var shouldClose = true;
  var confirmPrefValue = 22
  var prefString = "multizilla.managers.confirm.quit";
  var confirmPrefValue = gPreferences.readInteger(prefString, confirmPrefValue);

  if (aConfirmForID)
    gConfirmForID = aConfirmForID;

  var confirmForValue = gConfirmForID;
  /***
    *  1 = Close/Cancel button / [Close] button for main frame only.
    *  2 = ESC key
    *  4 = Accel+W
    *  8 = Click on window[X]
    * 16 = Alt+F4
    */
  if (confirmPrefValue && (confirmPrefValue & confirmForValue) == confirmForValue) {
    var stringKey; // Confirmation's checkbox (remember me)
    // Yes, ask the users confirmation
    switch(confirmForValue)
    {
      case (confirmForValue & 1): stringKey = "CloseButton";
          break;
      case (confirmForValue & 2): stringKey = "EscapeKey";
          break;
      case (confirmForValue & 4): stringKey = "CtrlW";
          break;
      case (confirmForValue & 8): stringKey = "WindowX";
          break;
      case (confirmForValue & 16): stringKey = "AltF4";
          break;
    }
    shouldClose = getConfirmation("tmConfirmCloseTitle",
                                  "tsmConfirmCloseText",
                                  "managerSkipConfirmFor" + stringKey);

    if (gConfirmCheckbox && (confirmPrefValue >= aConfirmForID))
      gPreferences.writeInteger(prefString, (confirmPrefValue -= confirmForValue));
  }
  return shouldClose;
}
  
function onHelp()
{
  var pageAnchor = "";
  var helpPages = gStringBundle.getString(gHelpPages);
  var delimiter = gStringBundle.getString("helpDelimiter");

  if (!gSettingsFrame.collapsed) {
    var settingsTabs = window.frames['settingsFrame'].document.getElementById("SettingsTabs");
    pageAnchor = "SettingsTab-" + settingsTabs.childNodes[settingsTabs.selectedIndex].id;
  }
  else {
    var iframes = document.getElementsByTagName("iframe");

    for (var i = 0; i < iframes.length; i++) {
      if (!iframes[i].collapsed) {
        pageAnchor = iframes[i].getAttribute("helpAnchor");
        break;
      }
    }
  }
  var tabbrowser = getTabbrowser(true);
  var helpURL = (delimiter + pageAnchor == delimiter) ? helpPages : helpPages + delimiter + pageAnchor;
  tabbrowser.addOrGetTab(helpURL);
}

function onCancel(aEvent)
{
  var shouldClose = gFrame.onCancel(aEvent);

  if (shouldClose) {
    if (gConfirmForID == 0) // Enter key pressed (focused close button)
      gConfirmForID = 1;
    if (confirmClose(gConfirmForID) == false)
      return false;
  }
  else {
    switchPage("mainWindowFrame");
    return false;
  }
  shutdown();
  return true;
}

function onAccept(aEvent)
{
  if ('onAccept' in gFrame && gFrame.onAccept(aEvent) == false) {
    switchPage("mainWindowFrame");
    return false;
  }
  return true;
}

function shutdown()
{
  window.document.removeEventListener("keyup", keyupHandler, false);
  window.document.removeEventListener("keydown", keydownHandler, false);

  if ('extended_Shutdown' in window)
    extended_Shutdown();
}

function keydownHandler(aEvent)
{
  switch (aEvent.keyCode)
  {
    case aEvent.DOM_VK_ALT:
      if (aEvent.DOM_VK_F4)
        gConfirmForID = 16;
      else if (!gMainWindowFrame.collapsed && gPreloadStatus)
        preLoad(gPreloadStatus & gPreLoad_ALT);
     break;

    case aEvent.DOM_VK_F3:
      if (!gMainWindowFrame.collapsed && gPreloadStatus > 1)
        preLoad(gPreloadStatus & gPreLoad_F3);
      break;

    case aEvent.DOM_VK_W:
      if (aEvent.ctrlKey) {
        gConfirmForID = 4;

        if (onCancel(aEvent))
          window.close();
      }
      break;

    case aEvent.DOM_VK_ESCAPE:
      gConfirmForID = 2;
      gEscapeKeyPressed = true;
      break;

    case aEvent.DOM_VK_PERIOD:
      if (aEvent.metaKey && gIsMac)
        gConfirmForID = 4;
     break;
  }
}

function keyupHandler(aEvent)
{
  if (aEvent.keyCode == aEvent.DOM_VK_ESCAPE) {
    if (gMainWindowFrame.collapsed)
      switchPage("mainWindowFrame");
  }
  if (aEvent.keyCode == aEvent.DOM_VK_F1 || gIsMac && aEvent.keyCode == aEvent.DOM_VK_HELP) {
    onHelp();
  }
}

function mzRefreshPrefDialogButtons()
{
  var pageURL = window.frames["settingsFrame"].document.location;
  var pageData = hPrefWindow.wsm.dataManager.getPageData(pageURL);
  // dump("\npageData: " + hPrefWindow.wsm.dataManager.pageData);
  // for (var elementID in pageData) { // this only worked because of a bug!
  for each(var elementID in hPrefWindow.contentWindow._elementIDs) {
    dump("\nelementID: " + elementID);
    var element = window.frames["settingsFrame"].document.getElementById(elementID);

    if (element) {
       var prefString = element.getAttribute("prefstring");

      if (prefString) {
        // dump("\n\nprefString: " + prefString);
        var elementType = element.localName;
        var prefType = element.getAttribute("preftype");
        // dump("\nprefType-1: " + prefType);
        if (!prefType) {
          if (elementType == "textbox" || elementType == "colorpicker")
            prefType = "string";
          else if (elementType == "checkbox" || elementType == "listitem" || elementType == "button")
            prefType = "bool";
          else if (elementType == "menulist" || elementType == "radiogroup")
            prefType = "int";
        }
        // dump("\nprefType-2: " + prefType);
        var prefValue = hPrefWindow.getPref(prefType, prefString);
        // dump("\n" + elementID + ": " + prefValue);
        if (prefValue == "!/!ERROR_UNDEFINED_PREF!/!")
          element.getAttribute("prefdefval");
        dump("\nelementType: " + elementType);
        var get_Func = (elementType in hPrefWindow.wsm.handlers) ? hPrefWindow.wsm.handlers[elementType].get
                                                                 : hPrefWindow.wsm.handlers.default_handler.get;

        var widgetData = get_Func(elementID, pageData[elementID]);
        // dump("\nwidgetData: " + widgetData.checked);
        if (elementType == "checkbox" || elementType == "listitem" || elementType == "button")
          widgetData = widgetData.checked;
        else if (elementType == "colorpicker")
          widgetData = widgetData.color;
        else 
          widgetData = widgetData.value;
        // dump("\nelementID: " + prefValue + " != " + widgetData);
        var isModified = (prefValue != widgetData);
        // dump("\nisModified: " + isModified);
        frames["settingsFrame"].gModified = isModified;

        if (isModified)
          break;
      }
    }
  }
  gAcceptButton.disabled = !isModified;
  var cancelButton = gCancelButton;

  if (isModified) {
    cancelButton.removeAttribute('action');
    cancelButton.label = gStringBundle.getString('cancelButtonLabel');
  }
  else {
    cancelButton.setAttribute('action', 'back');
    cancelButton.label = gStringBundle.getString('backButtonLabel');
  }
}
