/*Copyright (C) 2006 The Mozile Team. See http://mozile.mozdev.org/ for details.*/

var mozileVersion="0.7.4";var XULNS="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";function mozileDebug(details,level,message){if(level>=mozile.getDebugLevel()||details["Status Message"]){var date=new Date();mozileDebugList.push([date.toLocaleString(),details,level,message]);}
return true;}
var mozileDebugList=new Array();function mozileHandleEvent(event){switch(event.type){case"focus":mozileHandleFocus(event);break;case"blur":mozileHandleBlur(event);break;case"keypress":mozileHandleKeypress(event);break;case"keyup":mozileHandleKeyup(event);break;case"mouseup":mozileHandleMouseup(event);break;}}
function mozileHandleFocus(event){try{mozile}catch(e){return;}
if(!mozile||!mozile.isEditable()){if(mozile.getOption("activateOnFocus")==true)mozile.startEditing();else return;}
mozile.showCaret();if(mozileInterface)mozile.showToolbars();if(event.target&&event.target.nodeType==1&&document.defaultView.getComputedStyle(event.target,'').getPropertyValue("-moz-user-modify").toLowerCase()=="read-write"){mozile.setCurrentEditor(event.target);mozileEditor.replaceAnchors();}
return;}
function mozileHandleBlur(event){mozile.hideCaret();if(mozileInterface)mozile.hideToolbars();mozileEditor.restoreAnchors();return true;}
function mozileHandleKeypress(event){var f=new Array();f["File"]="core/core.js";f["Function"]="mozileHandleKeypress()";if(event.keyCode>=112&&event.keyCode<=135){return true;}
var selection=window.getSelection();if(!selection.focusNode){return true;}
else{}
if(event.keyCode>=33&&event.keyCode<=40){if(event.keyCode==37||event.keyCode==39){if(selection.focusNode==mozileEditor.getLastNode()&&selection.focusOffset==mozileEditor.getLastOffset()&&event.keyCode==mozileEditor.getLastKeyCode()){var direction=null;if(event.keyCode==37&&selection.focusOffset==0){direction="previous";}
if(event.keyCode==39&&selection.focusOffset==selection.focusNode.textContent.length){direction="next";}
if(direction){var node=mozileEditor.seekTextNode(direction,selection.focusNode);if(direction=="next")selection.collapse(node,0);else selection.collapse(node,node.textContent.length);event.stopPropagation();event.preventDefault();}}
mozileEditor.setLastNode(selection.focusNode);mozileEditor.setLastOffset(selection.focusOffset);mozileEditor.setLastKeyCode(event.keyCode);return true;}
if(mozileInterface&&mozile.getOption("toolbarUpdateFrequency")==2){mozile.updateToolbars();}
return true;}
if(mozile.isEditable()==false)return false;if(!event.target||event.target.nodeType!=1||document.defaultView.getComputedStyle(event.target,'').getPropertyValue("-moz-user-modify").toLowerCase()!="read-write")return false;if((event.ctrlKey||event.metaKey)&&mozile.getOption("keyboardShortcuts")&&mozile.getAccelerators()!=null){var accel="";if(event.metaKey)accel=accel+"Meta-";if(event.ctrlKey)accel=accel+"Control-";if(event.altKey)accel=accel+"Alt-";if(event.shiftKey)accel=accel+"Shift-";accel=accel+String.fromCharCode(event.charCode).toUpperCase();if(mozile.getAccelerator(accel)){mozile.executeCommand(mozile.getAccelerator(accel).getId(),event);if(mozileInterface)mozile.updateToolbars();if(mozile.getAccelerator(accel).getId()=="Mozile-Copy")return true;event.stopPropagation();event.preventDefault();return true;}
else{return true;}}
if(selection.focusNode!=mozileEditor.getLastNode()){try{var userModify=document.defaultView.getComputedStyle(selection.focusNode.parentNode,'').getPropertyValue("-moz-user-modify").toLowerCase();var userInput=document.defaultView.getComputedStyle(selection.focusNode.parentNode,'').getPropertyValue("-moz-user-input").toLowerCase();if(userModify=="read-only"||userInput=="disabled"){mozile.debug(f,1,"Not user modifiable!");return true;}
else{}}catch(e){alert("Bad selection? "+e+"\n"+selection.focusNode);}}
mozileEditor.setLastNode(selection.focusNode);mozileEditor.setLastOffset(selection.focusOffset);mozileEditor.setLastKeyCode(event.keyCode);if(event.keyCode==event.DOM_VK_BACK_SPACE){mozileEditor.deletion("previous");event.stopPropagation();event.preventDefault();return true;}
if(event.keyCode==event.DOM_VK_DELETE){mozileEditor.deletion("next");event.stopPropagation();event.preventDefault();return true;}
if(!event.ctrlKey&&!event.metaKey&&event.keyCode!=event.DOM_VK_ENTER&&event.keyCode!=event.DOM_VK_RETURN&&event.keyCode!=event.DOM_VK_TAB){mozileEditor.insertString(String.fromCharCode(event.charCode));mozile.keyCounter++;if(mozile.keyCounter>mozile.getOption("maxKeyCount"))mozile.storeState("Typing");event.stopPropagation();event.preventDefault();return true;}
var whiteSpace=document.defaultView.getComputedStyle(selection.focusNode.parentNode,'').getPropertyValue("white-space").toLowerCase();if(event.keyCode==event.DOM_VK_ENTER||event.keyCode==event.DOM_VK_RETURN){if(whiteSpace=="pre"){mozileEditor.insertString("\n");}
else{mozileEditor.splitBlock();}
mozile.storeState("Enter Key");event.stopPropagation();return true;}
if(event.keyCode==event.DOM_VK_TAB){mozileEditor.insertString("\t");mozile.keyCounter++;if(mozile.keyCounter>mozile.getOption("maxKeyCount"))mozile.storeState("Typing");event.stopPropagation();event.preventDefault();return true;}
mozile.debug(f,1,"Keypress not handled");return true;}
function mozileHandleKeyup(event){var f=new Array();f["File"]="core/core.js";f["Function"]="mozileHandleKeyup()";if(!mozile.isEditable())return false;if(mozileInterface)mozile.showToolbars();if(event.keyCode>=33&&event.keyCode<=40){if(mozileInterface)mozile.updateToolbars();return true;}
if(event.keyCode==event.DOM_VK_BACK_SPACE){mozile.storeState("Backspace Key");return true;}
if(event.keyCode==event.DOM_VK_DELETE){mozile.storeState("Delete Key");return true;}
return true;}
function mozileHandleMouseup(event){var f=new Array();f["File"]="core/core.js";f["Function"]="mozileHandleMouseup()";mozile.debug(f,1,"Mouseup "+event);if(!mozile.isEditable())return false;mozile.showCaret();if(mozileInterface){mozile.showToolbars();if(mozile.getOption("toolbarUpdateFrequency")==2)mozile.updateToolbars();}
return true;}
function checkArgument(defaultValue,value){if(value){return String(value);}
else{return defaultValue;}}
function executeXPath(expression,node){if(!node)node=document.documentElement;var XP=new XPathEvaluator;var results=XP.evaluate(expression,node,XP.createNSResolver(node.ownerDocument.documentElement),0,null);var nodes=new Array();var result=results.iterateNext();while(result){nodes.push(result);result=results.iterateNext();}
return nodes;}
Document.prototype.isHTML=function(){if(document.documentElement.localName.toLowerCase()=="html")return true;else return false;}
Document.prototype.getHead=function(){var head=document.documentElement;if(this.isHTML())head=document.getElementsByTagName("head")[0];return head;}
Document.prototype.getBody=function(){var body=document.documentElement;if(this.isHTML())body=document.getElementsByTagName("body")[0];return body;}
Node.prototype.insertAfter=function(newNode,refNode){if(refNode.nextSibling){return this.insertBefore(newNode,refNode.nextSibling);}
else{return this.appendChild(newNode);}}
Node.prototype.isBlock=function(){if(!this._matchDisplayBlock)this._matchDisplayBlock=/(block|list\-item|table\-cell|\-moz\-box)/;if(this.nodeType==1){var display=document.defaultView.getComputedStyle(this,'').getPropertyValue("display").toLowerCase();if(this._matchDisplayBlock.test(display)){return true;}}
return false;}
Node.prototype.getParentBlock=function(){var thisNode=this;while(thisNode){if(thisNode.isBlock()){return thisNode;}
thisNode=thisNode.parentNode;}
return document.documentElement;}
Node.prototype.isAncestorOf=function(node){var thisNode=node;while(thisNode){if(thisNode==this){return true;}
thisNode=thisNode.parentNode;}
return false;}
Node.prototype.getXPath=function(){var nodeName;if(document.isHTML())nodeName=this.nodeName.toLowerCase();else if(this.nodeType==this.ATTRIBUTE_NODE)nodeName=this.nodeName;else if(this.prefix)nodeName=this.nodeName;else nodeName="xmlns:"+this.nodeName;if(this==document.documentElement)return"/"+nodeName;else if(this.nodeType==this.ELEMENT_NODE){var s=1;for(var c=0;c<this.parentNode.childNodes.length;c++){if(this.parentNode.childNodes[c]==this)break;else if(this.parentNode.childNodes[c].nodeName==this.nodeName)s++;}
return this.parentNode.getXPath()+"/"+nodeName+"["+s+"]";}
else if(this.nodeType==this.ATTRIBUTE_NODE){return this.ownerElement.getXPath()+"/@"+nodeName;}
else if(this.nodeType==this.TEXT_NODE){var s=1;for(var c=0;c<this.parentNode.childNodes.length;c++){if(this.parentNode.childNodes[c]==this)break;else if(this.parentNode.childNodes[c].nodeType==3)s++;}
return this.parentNode.getXPath()+"/text()["+s+"]";}
else return this.parentNode.getXPath();}
Selection.prototype.deleteContents=function(){var range=document.createRange();range.setStart(this.anchorNode,this.anchorOffset);if(range.comparePoint(this.focusNode,this.focusOffset)==-1){range.setStart(this.focusNode,this.focusOffset);range.setEnd(this.anchorNode,this.anchorOffset);this.collapseToStart();}
else{range.setEnd(this.focusNode,this.focusOffset);this.collapseToEnd();}
range.deleteContents();}
Selection.prototype.store=function(){if(!this.anchorNode)return null;var memento=new Object();memento.anchorPath=this.anchorNode.getXPath();memento.anchorOffset=this.anchorOffset;memento.focusPath=this.focusNode.getXPath();memento.focusOffset=this.focusOffset;return memento;}
Selection.prototype.restore=function(memento){try{var anchorNode=executeXPath(memento.anchorPath)[0];var focusNode=executeXPath(memento.focusPath)[0];if(!anchorNode.nodeType||!focusNode.nodeType)return;}
catch(e){return;}
var range=document.createRange();range.setStart(anchorNode,memento.anchorOffset);if(range.comparePoint(focusNode,memento.focusOffset)==-1){range.setStart(focusNode,memento.focusOffset);range.setEnd(anchorNode,memento.anchorOffset);}
else range.setEnd(focusNode,memento.focusOffset);this.removeAllRanges();this.addRange(range);}
Selection.prototype.createInsertionPoint=function(){if(!this.focusNode||this.focusOffset==undefined)return null;else return new InsertionPoint(this.focusNode,this.focusOffset);}
function InsertionPoint(node,offset){this._node=node;this._offset=offset;}
InsertionPoint.prototype._matchLeadingWS=/^(\s*)/;InsertionPoint.prototype._matchTrailingWS=/(\s*)$/;InsertionPoint.prototype._matchNonWS=/\S/;InsertionPoint.prototype.getNode=function(){return this._node;}
InsertionPoint.prototype.setNode=function(node){this._node=node;return node;}
InsertionPoint.prototype.getOffset=function(){return this._offset;}
InsertionPoint.prototype.setOffset=function(offset){this._offset=offset;return offset;}
InsertionPoint.prototype.select=function(){var selection=window.getSelection();var range=document.createRange();range.setStart(this.getNode(),this.getOffset());selection.removeAllRanges();selection.addRange(range);}
InsertionPoint.prototype.extend=function(){window.getSelection().extend(this.getNode(),this.getOffset());}
InsertionPoint.prototype.next=function(){this._seek("next");}
InsertionPoint.prototype.previous=function(){this._seek("previous");}
InsertionPoint.prototype._seek=function(direction){var content=this.getNode().textContent;if(direction=="next"&&this.getOffset()==content.length)this._seekTextNode("next");else if(direction=="previous"&&this.getOffset()==0)this._seekTextNode("previous");var substring,result;if(direction=="next"){substring=content.substring(this.getOffset(),content.length);result=this._matchLeadingWS(substring);}
else{substring=content.substring(0,this.getOffset());result=this._matchTrailingWS(substring);}
var moveBy=0;if(result[0].length<2)moveBy=1;else if(document.defaultView.getComputedStyle(startNode.parentNode,'').getPropertyValue("white-space").toLowerCase()=="pre")moveBy=1;else if(result[0].length<substring.length)moveBy=result[0].length;else if(result[0].length==substring.length){this._seekTextNode(direction);this._seek(direction);return;}
else throw Error("Unhandled case in InsertionPoint.seek()");if(direction=="next")this.setOffset(this.getOffset()+moveBy);else this.setOffset(this.getOffset()-moveBy);}
InsertionPoint.prototype._seekTextNode=function(direction){if(!mozile||!mozile.getCurrentEditor()||!mozile.getCurrentEditor().isAncestorOf(this.getNode()))return;var treeWalker=document.createTreeWalker(mozile.getCurrentEditor(),NodeFilter.SHOW_TEXT,null,false);while(treeWalker.currentNode!=this.getNode())treeWalker.nextNode();var checkNode;do{if(direction=="next")checkNode=treeWalker.nextNode();else checkNode=treeWalker.previousNode();if(this._matchNonWS.test(checkNode.textContent))break;if(document.defaultView.getComputedStyle(checkNode.parentNode,'').getPropertyValue("white-space").toLowerCase()=="pre")break;}while(checkNode);if(checkNode)this.setNode(checkNode);if(direction=="next")this.setOffset(0);else this.setOffset(checkNode.textContent.length);}
function MozileComponent(configString){this._configString=String(configString);}
MozileComponent.prototype.toString=function(){return"[object "+this.constructor.toString().match(/^function\s+(\w+)/)[1]+"]";}
MozileComponent.prototype.getName=function(){if(!this._name){var firstWord=/\s*(\w*)/;var name=firstWord.exec(this.getConfigString())[1];if(name){this._name=name;}
else{throw Error("Invalid configuration string.");}}
return this._name;}
MozileComponent.prototype.getConfigString=function(){return this._configString;}
MozileComponent.prototype.getOptions=function(){if(this._options)return this._options;else return this._parseOptions();}
MozileComponent.prototype.getOption=function(key,defaultValue){if(this.getOptions()[key]!=undefined)return this.getOptions()[key];else if(defaultValue!=undefined)return this.setOption(key,defaultValue);else return undefined;}
MozileComponent.prototype.setOption=function(key,value){this.getOptions()[key]=this._cleanOption(value);return value;}
MozileComponent.prototype._cleanOption=function(val){if(String(val).toLowerCase()=="false")val=false;else if(String(val).toLowerCase()=="true")val=true;else if(!isNaN(Number(val)))val=Number(val);return val;}
MozileComponent.prototype._parseOptions=function(){var options=new Object();this._options=options;if(this.getConfigString().indexOf(":")==-1){return this._options;}
var optionString=this.getConfigString().substring(this.getConfigString().indexOf(":")+1,this.getConfigString().length);var arrayPattern=/(\S+)=\[(.*?)\]/;var leading=/^\s*'?/;var trailing=/'?\s*$/;while(optionString.match(arrayPattern)){optionString=optionString.replace(arrayPattern,function(word){var whole=word.match(arrayPattern);if(whole.length==3){var results=new Array();var parts=whole[2].split(",");var part;for(var p=0;p<parts.length;p++){part=parts[p].replace(leading,'').replace(trailing,'');if(part!="")results.push(MozileComponent.prototype._cleanOption(part));}
options[whole[1]]=results;}
return"";});}
var optionArray=optionString.split(",");var parseOption=/(\S+)='(.+)'|(\S+)=(\S+)/;var option,arr;for(o in optionArray){option=optionArray[o];arr=parseOption.exec(option);if(arr){var key,val;if(!arr[1]&&!arr[2])key=arr[3],val=arr[4];else key=arr[1],val=arr[2];options[key]=this._cleanOption(val);}}
return this._options;}
function MozileModule(configString){this._configString=String(configString);}
MozileModule.prototype=new MozileComponent;MozileModule.prototype.constructor=MozileModule;MozileModule.prototype.getId=function(){if(!this._id)this._id="Mozile-"+this.getName()+"-"+this.getName()+".js";return this._id;}
MozileModule.prototype.getPath=function(){if(!this._path){var path="";if(this.getOption("remotePath"))path=this.getOption("remotePath");else path=mozile.getRoot()+"modules/";path=path+this.getName();if(this.getOption("remoteVersion"))path=path+"-"+this.getOption("remoteVersion");this._path=path+"/";}
return this._path;}
MozileModule.prototype.getSource=function(){if(!this._source)this._source=this.getPath()+this.getName()+".js";return this._source;}
MozileModule.prototype.load=function(){var script=new MozileScriptResource(this.getId(),this.getSource());script.load();mozile.addModule(this);this.setOption("version","Unknown Version");}
MozileModule.prototype.init=function(){}
function MozileMediator(configString){this._configString=String("MozileMediator: "+configString);this.keyCounter=0;this.changesSaved=true;this.getOption("mode","XHTML");this.getOption("toolbarPosition","absolute");this.getOption("maxKeyCount",20);this.getOption("toolbarUpdateFrequency",2);this.getOption("defaultInterval",100);this.getOption("keyboardShortcuts",true);this.getOption("preloaded",false);this.getOption("loadJIT",false);this.getOption("activateOnFocus",true);this.getOption("replaceAnchors",true);this.getOption("content","document");if(this.getOption("warnBeforeUnload",true)){window.onbeforeunload=function(){if(!mozile.changesSaved)return"There are unsaved changes in this document. Changes will be lost if you navigate away from this page.";else return null;}}
else{window.onbeforeunload=function(){return;}}
if(!this.isExtension()){this.setSharedData("enhancement","false");this.setSharedData("editable","false");this.setSharedData("activateOnFocus",this.getOption("activateOnFocus"));}
this._interfaces=new Array({name:"MozileAboutInterface",access:"mozile.getAboutInterface()",source:"core/about.xml"},{name:"MozileMessageInterface",access:"mozile.getMessageInterface()",source:"core/message.xml"},{name:"MozileSaveInterface",access:"mozile.getSaveInterface()",source:"core/save.xml"},{name:"MozileSourceInterface",access:"mozile.getSourceInterface()",source:"core/source.xml"},{name:"HTTPPostInterface",access:"mozile.getModule('HTTPPost').getInterface()",source:"modules/HTTPPost/savemsg.xml"});}
MozileMediator.prototype=new MozileComponent;MozileMediator.prototype.constructor=MozileMediator;MozileMediator.prototype.debug=mozileDebug;MozileMediator.prototype.getVersion=function(){return mozileVersion;}
MozileMediator.prototype.getRoot=function(){if(!this.getOption("root"))throw Error("Invalid configuration string.");return this.getOption("root");}
MozileMediator.prototype.isExtension=function(){if(this._extension==undefined){try{if(mozileExtension)this._extension=true;}
catch(e){this._extension=false;}}
return this._extension;}
MozileMediator.prototype.isEnhanced=function(name){if(this.getSharedData("enhancement")==undefined)return false;else if(name&&typeof(this.getSharedData("enhancement"))=="string"){var enhancements=this.getSharedData("enhancement").split(";");for(var i=0;i<enhancements.length;i++){if(enhancements[i]==name)return true;}
return false;}
else return this.getSharedData("enhancement");}
MozileMediator.prototype.getMode=function(){return this.getOption("mode");}
MozileMediator.prototype.getDebugLevel=function(){return this.getOption("debugLevel",4);}
MozileMediator.prototype.getSharedData=function(attribute){if(document.getElementById("Mozile-Core-core.js")&&document.getElementById("Mozile-Core-core.js").hasAttribute(attribute)){var value=document.getElementById("Mozile-Core-core.js").getAttribute(attribute);return this._cleanOption(unescape(value));}
else return undefined;}
MozileMediator.prototype.setSharedData=function(attribute,value){if(!document.getElementById("Mozile-Core-core.js"))return value;if(value=="")document.getElementById("Mozile-Core-core.js").removeAttribute(attribute);else document.getElementById("Mozile-Core-core.js").setAttribute(attribute,escape(value));return value;}
MozileMediator.prototype.watchSharedData=function(){if(!this._watches){this._watches=new Object();this._watches["editable"]={value:undefined,ontrue:"mozile.startEditing()",onfalse:"mozile.stopEditing()"};this._watches["activateOnFocus"]={value:undefined,onchange:"mozile.setOption('activateOnFocus', value)"};this._watches["serverRequest"]={value:undefined,onchange:"eval(value); this.setSharedData('serverRequest', '')"};}
var value;var watches=this._watches;for(key in watches){if(!watches[key])continue;value=this.getSharedData(key);if(value!=watches[key]["value"]){try{if(value==null){}
else if(value=="true"&&watches[key]["ontrue"])eval(watches[key]["ontrue"]);else if(value=="false"&&watches[key]["onfalse"])eval(watches[key]["onfalse"]);else if(watches[key]["onchange"])eval(watches[key]["onchange"]);}catch(e){}
if(watches[key])watches[key]["value"]=value;}}}
MozileMediator.prototype.clientRequest=function(requestCode,evalOnChange){if(!mozile.isEnhanced())return;this.clearRequest();this._watches["serverReply"]={value:"",onchange:"try{"+evalOnChange+"}catch(e){};mozile.clearRequest()"}
this.setSharedData("clientRequest",requestCode);}
MozileMediator.prototype.clearRequest=function(){mozile._watches["serverReply"]=undefined;mozile.setSharedData("serverReply","");mozile.setSharedData("clientRequest","");}
MozileMediator.prototype.getResources=function(){if(!this._resources)this._resources=new Object();return this._resources;}
MozileMediator.prototype.getResource=function(id){if(this.getResources()[id])return this.getResources()[id];else return undefined;}
MozileMediator.prototype.addResource=function(resource){if(resource.getId())this.getResources()[resource.getId()]=resource;else throw Error("Invalid resource.");return resource;}
MozileMediator.prototype.getModules=function(){if(!this._modules)this._modules=new Object();return this._modules;}
MozileMediator.prototype.getModule=function(name){if(this.getModules()[name])return this.getModules()[name];else return undefined;}
MozileMediator.prototype.addModule=function(module){if(module.getName())this.getModules()[module.getName()]=module;else throw Error("Invalid module.");return module;}
MozileMediator.prototype.getEditors=function(){if(!this._editors)this._editors=new Array();return this._editors;}
MozileMediator.prototype.isEditor=function(element){for(var i=0;i<this.getEditors().length;i++){if(this.getEditors()[i]==element)return true;}
return false;}
MozileMediator.prototype.addEditor=function(editor){this.getEditors().push(editor);return editor;}
MozileMediator.prototype.getCurrentEditor=function(){if(this._currentEditor)return this._currentEditor;else return undefined;}
MozileMediator.prototype.setCurrentEditor=function(element){this._currentEditor=element;return element;}
MozileMediator.prototype.getStyleSheet=function(){if(!this._styleSheet){var style=new MozileStyleResource("Mozile-Core-StyleSheet");style.load();this._styleSheet=style.getStylesheet();this._styleSheet.insertRule("mozileAnchorReplacement { color: blue; text-decoration: underline; }",this._styleSheet.cssRules.length);}
return this._styleSheet;}
MozileMediator.prototype.getOperatingSystem=function(){if(!this._operatingSystem){var userAgent=navigator.userAgent.toLowerCase();if(userAgent.indexOf("windows")>=0)this._operatingSystem="Windows";if(userAgent.indexOf("linux")>=0)this._operatingSystem="Linux";if(userAgent.indexOf("macintosh")>=0)this._operatingSystem="Mac";}
return this._operatingSystem;}
MozileMediator.prototype.getBrowserName=function(){if(!this._browserName){var userAgent=navigator.userAgent.toLowerCase();if(userAgent.indexOf("firefox")>=0)this._browserName="Firefox";else if(userAgent.indexOf("seamonkey")>=0)this._browserName="SeaMonkey";else this._browserName="Mozilla";}
return this._browserName;}
MozileMediator.prototype.getBrowserVersion=function(){if(!this._browserVersion){var userAgent=navigator.userAgent;if(this.getBrowserName()=="Firefox")this._browserVersion=userAgent.match(/Firefox\/(\S+)/)[1];else if(this.getBrowserName()=="SeaMonkey")this._browserVersion=userAgent.match(/SeaMonkey\/(\S+)/)[1];else this._browserVersion=this.getMozillaVersion();}
return this._browserVersion;}
MozileMediator.prototype.getGeckoVersion=function(){if(!this._geckoVersion){this._geckoVersion=navigator.userAgent.match(/Gecko\/(\S+)/)[1];}
return this._geckoVersion;}
MozileMediator.prototype.getMozillaVersion=function(){if(!this._mozillaVersion){this._mozillaVersion=navigator.userAgent.match(/rv\:(\S+)\)/)[1];}
return this._mozillaVersion;}
MozileMediator.prototype.isEditable=function(){return this.getSharedData("editable");}
MozileMediator.prototype.startEditing=function(){if(!this.isEditable()){this.setSharedData("editable","true");this.load();this.showCaret();this.showToolbars();this.storeState("Editing started");}}
MozileMediator.prototype.stopEditing=function(){if(this.isEditable()!=false){mozileEditor.restoreAnchors();this.hideCaret();this.hideToolbars();this.setSharedData("editable","false");}}
MozileMediator.prototype.status=function(details,level,message){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.status()";try{var value=false;if(arguments.length>3){value=arguments[3];}
var more=false;if(arguments.length>4){more=arguments[4];}
var g=new Array();for(key in details){g[key]=details[key];}
g["Status Message"]=true;var msg=message;if(value)msg=msg+" "+value+"%";this.debug(g,level,msg);var messageField=document.getElementById("mozileStatusMessage");var progressmeter=document.getElementById("mozileProgressmeter");var moreButton=document.getElementById("mozileMoreButton");if(!messageField||!progressmeter||!moreButton)return true;messageField.value=message;if(value!=false){progressmeter.value=value;progressmeter.collapsed=false;}
else{progressmeter.value=0;progressmeter.collapsed=true;}
if(more!=false){moreButton.setAttribute("onmousedown",more);moreButton.collapsed=false;}
else{moreButton.setAttribute("onmousedown","");moreButton.collapsed=true;}}
catch(e){alert(e);}
return true;}
MozileMediator.prototype.showCaret=function(){if(this.isExtension()){if(!this._mozilePrefs){netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');this._mozilePrefs=Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getBranch(null);}
this._mozilePrefs.setBoolPref('accessibility.browsewithcaret',true);return true;}
else{this.setSharedData("editing","true");return false;}}
MozileMediator.prototype.hideCaret=function(){if(this.isExtension()){if(!this._mozilePrefs){netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');this._mozilePrefs=Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getBranch(null);}
if(!this._mozilePrefs.getBoolPref("mozile.caretAlwaysOn")){this._mozilePrefs.setBoolPref('accessibility.browsewithcaret',false);}
return true;}
else{this.setSharedData("editing","false");return false;}}
MozileMediator.prototype.createEditor=function(id,options){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.createEditor()";this.debug(f,1,"Creating editor "+id+" "+options);var rule1="#"+id+" { -moz-binding: url("+this.getRoot()+"core/core.xml#editor); -moz-user-focus: normal; -moz-user-modify: read-write; -moz-user-input: auto; -moz-user-select: text; }";var rule2="#"+id+" * { -moz-user-focus: ignore; }";var rule3="#"+id+" input { -moz-user-focus: none; -moz-user-modify: read-only; -moz-user-input: auto; -moz-user-select: text; }";this.getStyleSheet().insertRule(rule1,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule2,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule3,this.getStyleSheet().cssRules.length);return true;}
MozileMediator.prototype.createEditors=function(selector,options){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.createEditors()";this.debug(f,1,"Creating editor "+selector+" "+options);var rule1=selector+" { -moz-binding: url("+this.getRoot()+"core/core.xml#editor); -moz-user-focus: normal; -moz-user-modify: read-write; -moz-user-input: auto; -moz-user-select: text; }";var rule2=selector+" * { -moz-user-focus: ignore; }";var rule3=selector+" input { -moz-user-focus: none; -moz-user-modify: read-only; -moz-user-input: auto; -moz-user-select: text; }";this.getStyleSheet().insertRule(rule1,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule2,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule3,this.getStyleSheet().cssRules.length);return true;}
MozileMediator.prototype.makeDocumentEditable=function(options){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.makeDocumentEditable()";this.debug(f,1,"Making document editable "+options);var events=["focus","blur","keydown","keypress","keyup","mousedown","click","mouseup","dblclick","select"];for(var e=0;e<events.length;e++){document.addEventListener(events[e],mozileHandleEvent,false);}
var rootNode=document.getBody();var rootName=rootNode.nodeName;var rule1=rootName+" { -moz-user-focus: normal; -moz-user-modify: read-write; -moz-user-input: auto; -moz-user-select: text; }";var rule2=rootName+" * { -moz-user-focus: ignore; }";var rule3=rootName+" input { -moz-user-focus: none; -moz-user-modify: read-only; -moz-user-input: auto; -moz-user-select: text; }";this.getStyleSheet().insertRule(rule1,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule2,this.getStyleSheet().cssRules.length);this.getStyleSheet().insertRule(rule3,this.getStyleSheet().cssRules.length);this.addEditor(rootNode);rootNode.setAttribute('tabindex',12345);return true;}
MozileMediator.prototype._cleanInterfaces=function(){var element;for(var i=0;i<this._interfaces.length;i++){try{eval(this._interfaces[i]["access"]+".hide()");}
catch(e){element=document.getElementById(this._interfaces[i]["name"]);if(element)element.parentNode.removeChild(element);}}}
MozileMediator.prototype._getXMLDeclaration=function(){var xmlDeclaration="";if(document.xmlVersion){xmlDeclaration='<?xml version="'+document.xmlVersion+'" encoding="'+document.xmlEncoding+'"?>\n'}
return xmlDeclaration;}
MozileMediator.prototype._getDoctypeDeclaration=function(){var doctypeDeclaration=""
if(document.doctype){var serializer=new XMLSerializer;doctypeDeclaration=serializer.serializeToString(document.doctype)+"\n";}
return doctypeDeclaration;}
MozileMediator.prototype._getProcessingInstructions=function(){var evaluator=new XPathEvaluator();var PIString="";var PIList=evaluator.evaluate("/processing-instruction()",document,null,XPathResult.ANY_TYPE,null);var PI=PIList.iterateNext();while(PI){PIString+="<?"+PI.target+" "+PI.data+"?>\n";PI=PIList.iterateNext();}
return PIString;}
MozileMediator.prototype._cleanDOM=function(element){for(var id in this.getResources()){this.getResource(id).unload(element);}
mozileEditor.restoreAnchors(element);var mozileToolbars=element.getElementsByTagName("mozileToolbar");while(mozileToolbars.length){mozileToolbars[0].parentNode.removeChild(mozileToolbars[0]);}
var treeWalker=document.createTreeWalker(element,NodeFilter.SHOW_ELEMENT,null,false);var current=treeWalker.firstChild();var removals=new Array();while(current){if(current.hasAttribute("class")&&current.getAttribute("class")=="mozileInterface")removals.push(current);else if(current.hasAttribute("id")&&current.getAttribute("id")=="MozileToolbar")removals.push(current);else if(current.hasAttribute("id")&&current.getAttribute("id")=="MozileStatusbar")removals.push(current);else if(current.getAttribute("tabindex")&&current.getAttribute("tabindex")=="12345")current.removeAttribute("tabindex");current=treeWalker.nextNode();}
while(removals.length){removals[0].parentNode.removeChild(removals[0]);removals.shift();}
if(element.getAttribute("tabindex")&&element.getAttribute("tabindex")=="12345"){element.removeAttribute("tabindex");}
return element;}
MozileMediator.prototype._htmlToXHTML=function(contents){if(!this._tagPattern)this._tagPattern=/<(\/*)(\w*)/g;return contents.replace(this._tagPattern,function(word){return word.toLowerCase();});}
MozileMediator.prototype._convertCharacterSet=function(contents,charset,attrList,entityList){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile._convertCharacterSet()";if(!charset)charset=this.getSaveOption("current","saveCharset",document.characterSet);var result="Charset: "+charset+"\n";result+="Conversion Attributes: "+this._getConversionAttributes()+"\n";result+="Entity Version: "+this._getEntityVersion()+"\n";this.status(f,1,result);try{var SAC=Components.classes["@mozilla.org/intl/saveascharset;1"].createInstance();SAC.QueryInterface(Components.interfaces.nsISaveAsCharset);SAC.Init(charset,this._getConversionAttributes(attrList),this._getEntityVersion(entityList));return SAC.Convert(contents);}catch(e){return contents;}}
MozileMediator.prototype._getConversionAttributes=function(attrList){if(!attrList)attrList=this.getSaveOption("current","saveConversion");if(!attrList&&this.getMode()!="XML")attrList=["entitybeforecharset","ignoreignorables","decimalncr"];var attr=0;if((attrList instanceof Object)&&(attrList instanceof Array)){var attributes=new Array();attributes=attributes.concat(attrList);while(attributes.length>0){switch(attributes.shift()){case"nofallback":attr&=~0xFF;break;case"questionmark":attr&=~0xFF;attr|=1;break;case"escapedunicode":attr&=~0xFF;attr|=2;break;case"decimalncr":attr&=~0xFF;attr|=3;break;case"hexncr":attr&=~0xFF;attr|=4;break;case"none":attr&=~0x300;break;case"entitybeforecharset":attr&=~0x300;attr|=0x100;break;case"entityaftercharset":attr&=~0x300;attr|=0x200;break;case"charsetfallback":attr|=0x400;break;case"ignoreignorables":attr|=0x800;break;}}}
return attr;}
MozileMediator.prototype._getEntityVersion=function(entityList){if(!entityList)entityList=this.getSaveOption("current","saveEntities");var version=0;if((entityList instanceof Object)&&(entityList instanceof Array)){var entities=new Array();entities=entities.concat(entityList);while(entities.length>0){switch(entities.shift()){case"none":entities=new Array();version=0;break;case"html40latin1":version|=1;break;case"html40symbols":version|=2;break;case"html40special":version|=4;break;case"transliterate":version|=8;break;case"mathml20":version|=16;break;}}}
return version;}
MozileMediator.prototype.documentToHTML=function(){var serializer=new XMLSerializer;var newDoc=document.documentElement.cloneNode(true);newDoc=this._cleanDOM(newDoc);var contents=this._getXMLDeclaration();contents+=this._getDoctypeDeclaration();contents+=this._getProcessingInstructions();contents+=serializer.serializeToString(newDoc);return contents;}
MozileMediator.prototype.documentToXML=function(){return this._htmlToXHTML(this.documentToHTML());}
MozileMediator.prototype.editorToHTML=function(){if(!this.getCurrentEditor()||this.getCurrentEditor()==null)throw Error("Error: No editor selected!");var serializer=new XMLSerializer;var editor=this.getCurrentEditor().cloneNode(true);editor=this._cleanDOM(editor);var contents=serializer.serializeToString(editor);return contents;}
MozileMediator.prototype.editorToXML=function(){return this._htmlToXHTML(this.editorToHTML());}
MozileMediator.prototype.content=function(){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.content()";this.debug(f,1,"Getting Mozile content.");var content=this.getSaveOption("current","content");var format=this.getSaveOption("current","format");if(format=="XHTML")format="XML";this.debug(f,1,"Saving "+content+"To"+format);var result;try{result=eval("this."+content+"To"+format+"()");}catch(e){this.debug(f,1,"Bad result: "+e);}
return result;}
MozileMediator.prototype.storeState=function(command){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.storeState()";this.debug(f,1,"Storing current state");if(this.changesSaved==true){this.status(f,1,"Editing");this.changesSaved=false;}
this.keyCounter=0;return true;}
MozileMediator.prototype.load=function(){if(this._loadComplete)return;if(mozileInterface){this.addResource(new MozileScriptResource("Mozile-Core-core.js",this.getRoot()+"core/core.js"));if(this.getOption("preloaded"))this.addResource(new MozileScriptResource("Mozile-Core-mozile.js",this.getRoot()+"core/mozile.js"));var link=new MozileLinkResource("Mozile-Core-interface.css",this.getRoot()+"core/interface.css")
link.load();var script=new MozileScriptResource("Mozile-Core-interface.js",this.getRoot()+"core/interface.js");if(this.getOption("preloaded"))this.addResource(script);else script.load();var mozileModule;for(var m=0;m<mozileModules.length;m++){mozileModule=new MozileModule(mozileModules[m]);if(this.getOption("preloaded")){this.addResource(new MozileScriptResource(mozileModule.getId(),mozileModule.getSource()));this.addModule(mozileModule);}
else mozileModule.load();}
var complete=new MozileScriptResource("Mozile-Core-loadComplete","");complete.setContent("mozile.loaded()");if(this.getOption("preloaded"))this.addResource(complete);else complete.load();}
this._loadComplete=true;}
MozileMediator.prototype.loaded=function(){if(this._loadedComplete)return;this._loadedComplete=true;if(this.isExtension())return;for(var name in this.getModules()){this.getModule(name).init();}
this.getToolbar();this._cleanInterfaces();var rootNode=document.getBody();if(this.isEditor(rootNode))this.startEditing();}
function MozileEditor(configString){this._configString=String(configString);}
MozileEditor.prototype=new MozileComponent;MozileEditor.prototype.constructor=MozileEditor;var mozileEditor=new MozileEditor("DefaultEditor");MozileEditor.prototype.getLastNode=function(){if(this._lastNode)return this._lastNode;else return undefined;}
MozileEditor.prototype.setLastNode=function(node){this._lastNode=node;return node;}
MozileEditor.prototype.getLastOffset=function(){if(this._lastOffset)return this._lastOffset;else return undefined;}
MozileEditor.prototype.setLastOffset=function(offset){this._lastOffset=offset;return offset;}
MozileEditor.prototype.getLastKeyCode=function(){if(this._lastKeyCode)return this._lastKeyCode;else return undefined;}
MozileEditor.prototype.setLastKeyCode=function(keyCode){this._lastKeyCode=keyCode;return keyCode;}
MozileEditor.prototype.replaceAnchors=function(element){if(!mozile.getOption("replaceAnchors"))return 0;var elements;if(arguments.length>0)elements=element.getElementsByTagName("a");else elements=mozile.getCurrentEditor().getElementsByTagName("a");var newElement;var range=document.createRange();var i=0,j=0;while(elements.length){newElement=document.createElement("mozileAnchorReplacement");for(i=0;i<elements[0].attributes.length;i++){newElement.setAttribute(elements[0].attributes[i].name,elements[0].attributes[i].value);}
range.selectNodeContents(elements[0]);newElement.appendChild(range.extractContents());elements[0].parentNode.replaceChild(newElement,elements[0]);j++}
return j;}
MozileEditor.prototype.restoreAnchors=function(element){if(!mozile.getOption("replaceAnchors"))return 0;var elements;if(arguments.length>0)elements=element.getElementsByTagName("mozileAnchorReplacement");else if(!mozile.getCurrentEditor())return 0;else elements=mozile.getCurrentEditor().getElementsByTagName("mozileAnchorReplacement");var newElement;var range=document.createRange();var i=0,j=0;while(elements.length){newElement=document.createElement("a");for(i=0;i<elements[0].attributes.length;i++){newElement.setAttribute(elements[0].attributes[i].name,elements[0].attributes[i].value);}
range.selectNodeContents(elements[0]);newElement.appendChild(range.extractContents());elements[0].parentNode.replaceChild(newElement,elements[0]);j++}
return j;}
MozileEditor.prototype.insertString=function(string){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.insertString()";mozile.debug(f,1,"Inserting string "+string);var selection=window.getSelection();if(!selection.isCollapsed){this.deletion("next");}
var focusNode=selection.focusNode;if(focusNode.nodeType!=3){selection.extend(focusNode.firstChild,0);focusNode=selection.focusNode;if(focusNode.nodeType!=3){mozile.debug(f,4,"This node is not a text node! "+focusNode);return false;}}
focusNode.insertData(selection.focusOffset,string);try{selection.extend(selection.focusNode,selection.focusOffset+string.length);}
catch(e){alert("Error in insertString when trying to extend selection: "+e);}
selection.collapseToEnd();return true;}
MozileEditor.prototype.insertFragment=function(fragment){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.insertFragment()";mozile.debug(f,1,"Inserting fragment "+fragment);var selection=window.getSelection();if(!selection.isCollapsed){this.deletion("next");}
var anchorNode=selection.anchorNode;if(anchorNode.nodeType!=3){mozile.debug(f,4,"This node is not a text node! "+anchorNode);return false;}
selection.anchorNode.splitText(selection.anchorOffset);var parent=selection.anchorNode.parentNode;var next=selection.anchorNode.nextSibling;var children;if(fragment.documentElement)children=fragment.documentElement.childNodes;else children=fragment.cloneNode(true).childNodes;var newNode;for(var i=0;i<children.length;i++){newNode=children[i].cloneNode(true);parent.insertBefore(newNode,next);}
selection.collapseToEnd();return true;}
MozileEditor.prototype.deletion=function(direction){var selection=window.getSelection();var collapsed=selection.isCollapsed;if(collapsed){var arr=this.seekIP(direction,selection.focusNode,selection.focusOffset,true);if(!arr||!arr[0])return false;if(!arr[2]){var userModify=document.defaultView.getComputedStyle(arr[0].parentNode,'').getPropertyValue("-moz-user-modify").toLowerCase();var userInput=document.defaultView.getComputedStyle(arr[0].parentNode,'').getPropertyValue("-moz-user-input").toLowerCase();if(userModify=="read-only"||userInput=="disabled")return false;}
try{selection.extend(arr[0],arr[1]);}
catch(e){return false;}}
var range=selection.getRangeAt(0).cloneRange();var startBlock=range.startContainer.getParentBlock();var endBlock=range.endContainer.getParentBlock();if(startBlock==endBlock||!collapsed){selection.deleteContents();}
else{if(direction=="previous"){range.setStart(range.startContainer,range.startOffset+1);}}
if(collapsed&&selection.anchorNode.nodeType==1){var text=document.createTextNode("");selection.anchorNode.appendChild(text);range.selectNode(text);range.collapse(true);selection.removeAllRanges();selection.addRange(range);}
if(startBlock!=endBlock){range.collapse(true);selection.removeAllRanges();selection.addRange(range);this.insertFragment(endBlock);endBlock.parentNode.removeChild(endBlock);}
return true;}
MozileEditor.prototype.splitBlock=function(){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.splitBlock()";mozile.debug(f,1,"Splitting block");var selection=window.getSelection();if(!selection.isCollapsed){selection.deleteContents();}
if(mozile.isEditor(selection.focusNode)||(selection.focusNode.nodeType==3&&mozile.isEditor(selection.focusNode.parentNode)))
return false;var range=selection.getRangeAt(0).cloneRange();var focusNode=selection.focusNode;var focusOffset=selection.focusOffset;var node=focusNode;var flag=false;var display;node=node.getParentBlock();if(node.parentNode){range.selectNodeContents(node);var nodeString=range.toString();range.setStart(focusNode,focusOffset);var newNode=node.cloneNode(false);var rangeString=range.toString();if(rangeString!=""){newNode.appendChild(range.extractContents());}
var textNode=null;switch(rangeString){case nodeString:newNode.appendChild(document.createTextNode(""));node.parentNode.insertAfter(newNode,node);textNode=focusNode;break;case"":textNode=document.createTextNode("");newNode.appendChild(textNode);node.parentNode.insertAfter(newNode,node);break;default:newNode.appendChild(range.extractContents());node.parentNode.insertAfter(newNode,node);textNode=this.seekTextNode("next",focusNode);break;}
try{selection.extend(textNode,0);selection.collapseToEnd();}
catch(e){mozile.debug(f,1,"Major error splitting block: "+e);}}
mozile.debug(f,1,"Done splitting block");return true;}
MozileEditor.prototype.seekIP=function(direction,startNode,startOffset,firstNode){var newNode;if(direction=="previous"&&startOffset==0){newNode=this.seekTextNode(direction,startNode);if(newNode)return this.seekIP(direction,newNode,newNode.textContent.length,false);else return false;}
var content=startNode.textContent;if(direction=="next"&&startOffset==content.length){newNode=this.seekTextNode(direction,startNode);if(newNode)return this.seekIP(direction,newNode,0,false);else return false;}
var arr=new Array();var substring,result;if(direction=="next"){substring=content.substring(startOffset,content.length);if(!this._matchLeadingWS)this._matchLeadingWS=/^(\s*)/;result=this._matchLeadingWS(substring);}
else{substring=content.substring(0,startOffset);if(!this._matchTrailingWS)this._matchTrailingWS=/(\s*)$/;result=this._matchTrailingWS(substring);}
if(result){if(result[0].length<2){arr[0]=startNode;if(direction=="next")arr[1]=startOffset+1;else arr[1]=startOffset-1;arr[2]=firstNode;return arr;}
else{var wsMode=document.defaultView.getComputedStyle(startNode.parentNode,'').getPropertyValue("white-space").toLowerCase();if(wsMode=="pre"){arr[0]=startNode;if(direction=="next")arr[1]=startOffset+1;else arr[1]=startOffset-1;arr[2]=firstNode;return arr;}
if(result[0].length<substring.length){arr[0]=startNode;if(direction=="next")arr[1]=startOffset+result[0].length;else arr[1]=startOffset-result[0].length;arr[2]=firstNode;return arr;}
else{newNode=this.seekTextNode(direction,startNode);if(newNode){if(direction=="next")return this.seekIP(direction,newNode,1,false);else return this.seekIP(direction,newNode,newNode.textContent.length,false);}
else{return false;}}}}
else{return false;}}
MozileEditor.prototype.seekTextNode=function(direction,startNode){var f=new Array();f["File"]="core/core.js";f["Function"]="Mozile.seekTextNode()";mozile.debug(f,1,"Seeking Text Node in direction "+direction+" starting at "+startNode);var treeWalker=document.createTreeWalker(mozile.getCurrentEditor(),NodeFilter.SHOW_TEXT,null,false);while(treeWalker.currentNode!=startNode){treeWalker.nextNode();}
var checkNode;if(direction=="next")checkNode=treeWalker.nextNode();else checkNode=treeWalker.previousNode();var wsMode;while(checkNode){if(!this._matchNonWS)this._matchNonWS=/\S/;if(this._matchNonWS.test(checkNode.textContent)){mozile.debug(f,1,"Returning text node: "+checkNode.textContent);return checkNode;}
wsMode=document.defaultView.getComputedStyle(checkNode.parentNode,'').getPropertyValue("white-space").toLowerCase();if(wsMode=="pre")return checkNode;if(direction=="next")checkNode=treeWalker.nextNode();else checkNode=treeWalker.previousNode();}
mozile.debug(f,3,"No editable text node in direction "+direction);return false;}
function MozileResource(category,id,type,namespace){this._category=String(category);this._id=String(id);this._type=checkArgument("",arguments[2]);this._namespace=checkArgument(XHTMLNS,arguments[3]);}
MozileResource.prototype.toString=function(){return"[object "+this.constructor.toString().match(/^function\s+(\w+)/)[1]+"]";}
MozileResource.prototype.getCategory=function(){return this._category;}
MozileResource.prototype.getId=function(){return this._id;}
MozileResource.prototype.getType=function(){return this._type;}
MozileResource.prototype.getNamespace=function(){return this._namespace;}
MozileResource.prototype.getElement=function(){if(!this._element){if(document.getElementById(this.getId()))this._element=document.getElementById(this.getId());else this._element=this.createElement();}
return this._element;}
MozileResource.prototype.getContent=function(){if(this._contentNode)return this._contentNode;else return undefined;}
MozileResource.prototype.setContent=function(content){this._contentNode=document.createTextNode(content);return this._contentNode;}
MozileResource.prototype.createElement=function(){this._element=document.createElementNS(this._namespace,this._category);this._element.setAttribute("id",this.getId());this._element.setAttribute("type",this.getType());if(this.getContent()&&this.getContent().nodeType==3){this._element.appendChild(this.getContent());}
return this._element;}
MozileResource.prototype.load=function(){if(this.getElement().parentNode)return;if(document.documentElement.tagName.toLowerCase()=="html"){document.getElementsByTagName("head")[0].appendChild(this.getElement());}
else{document.documentElement.insertBefore(this.getElement(),document.documentElement.firstChild);}
mozile.addResource(this);}
MozileResource.prototype.unload=function(element){if(arguments.length>0&&element){element=arguments[0];}
else{element=document;}
var elements=element.getElementsByTagName(this._category);var elementsRemoved=false;for(var i=0;i<elements.length;i++){if(elements[i].getAttribute("id")==this.getId()){elements[i].parentNode.removeChild(elements[i]);elementsRemoved=true;}}
return elementsRemoved;}
function MozileScriptResource(id,source,type,namespace){this._category="script";this._id=String(id);this._source=String(source);this._type=checkArgument("application/x-javascript",arguments[2]);this._namespace=checkArgument(XHTMLNS,arguments[3]);}
MozileScriptResource.prototype=new MozileResource;MozileScriptResource.prototype.constructor=MozileScriptResource;MozileScriptResource.prototype.getSource=function(){return this._source;}
MozileScriptResource.prototype.createElement=function(){this._element=document.createElementNS(this._namespace,this._category);this._element.setAttribute("id",this.getId());this._element.setAttribute("type",this.getType());if(this.getSource()!="")this._element.setAttribute("src",this.getSource());if(this.getContent()&&this.getContent().nodeType==3){this._element.appendChild(this.getContent());}
return this._element;}
function MozileLinkResource(id,source,relation,type,namespace){this._category="link";this._id=String(id);this._source=String(source);this._relation=checkArgument("stylesheet",arguments[2]);this._type=checkArgument("text/css",arguments[3]);this._namespace=checkArgument(XHTMLNS,arguments[4]);}
MozileLinkResource.prototype=new MozileResource;MozileLinkResource.prototype.constructor=MozileLinkResource;MozileLinkResource.prototype.getSource=function(){return this._source;}
MozileLinkResource.prototype.getRelation=function(){return this._relation;}
MozileLinkResource.prototype.getContent=function(){return undefined;}
MozileLinkResource.prototype.setContent=function(content){return undefined;}
MozileLinkResource.prototype.createElement=function(){this._element=document.createElementNS(this._namespace,this._category);this._element.setAttribute("id",this.getId());this._element.setAttribute("rel",this.getRelation());this._element.setAttribute("type",this.getType());this._element.setAttribute("href",this.getSource());return this._element;}
function MozileStyleResource(id,type,media,namespace){this._category="style";this._id=String(id);this._type=checkArgument("text/css",arguments[1]);this._media=checkArgument("",arguments[2]);this._namespace=checkArgument(XHTMLNS,arguments[3]);}
MozileStyleResource.prototype=new MozileResource;MozileStyleResource.prototype.constructor=MozileStyleResource;MozileStyleResource.prototype.getMedia=function(){return this._media;}
MozileStyleResource.prototype.getStylesheet=function(){if(!this._stylesheet){for(var i=0;i<document.styleSheets.length;i++){if(document.styleSheets.item(i).ownerNode==this.getElement()){this._stylesheet=document.styleSheets.item(i);return this._stylesheet;}}}
if(!this._stylesheet)return undefined;else return this._stylesheet;}
MozileStyleResource.prototype.createElement=function(){this._element=document.createElementNS(this._namespace,this._category);this._element.setAttribute("id",this.getId());this._element.setAttribute("type",this.getType());if(this._media!=""){this._element.setAttribute("media",this.getMedia());}
if(this.getContent()&&this.getContent().nodeType==3){this._element.appendChild(this.getContent());}
return this._element;}
MozileMediator.prototype.testFunction=function(){return 0;}
MozileMediator.prototype.testAlert=function(){try{netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect UniversalBrowserWrite ");alert("Mozile Server-Side Privileged! Extension: "+mozile.isExtension());}catch(e){alert("Mozile Server-Side Unprivileged! \n"+e);}}
var mozile=new MozileMediator("root='"+mozileScriptSource+"',"+mozileOptions);this._watchInterval=window.setInterval("mozile.watchSharedData()",mozile.getOption("defaultInterval"));mozileConfiguration();if(!mozile.getOption("loadJIT")){mozile.load();}
function dumpArray(arr){var s="Array Dump: ";for(key in arr){s=s+key+"=>"+arr[key]+"\n";}
alert(s);}
function printXML(XML){if(!XML||XML=="")return"Nothing to print!!";var objXMLSerializer=new XMLSerializer;var output=objXMLSerializer.serializeToString(XML);output=output.replace(/<(\/?)([A-Z]+)/g,function(output,p1,p2,offset,s){return'<'+p1+p2.toLowerCase();});return output;}