/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.mbs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.mozdev.mbs.MBS;
import org.mozdev.mbs.SwingWorker;

public class MBSGUI
extends JFrame {
    private static final long serialVersionUID = 13L;
    private JMenuItem aboutMenuItem;
    File bookmarkFile;
    private JFileChooser bookmarkFileChooser;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private ImageIcon icon;
    private URL iconURL;
    private ClassLoader loader;
    private JMenuBar mainMenuBar;
    private JMenuItem openMenuItem;
    JProgressBar sortProgressBar;

    public static void main(String[] stringArray) {
        new MBSGUI().setVisible(true);
    }

    public MBSGUI() {
        this.initComponents();
    }

    void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        this.loader = this.getClass().getClassLoader();
        this.iconURL = this.loader.getResource("icons/mbs64.gif");
        if (this.iconURL != null) {
            this.icon = new ImageIcon(this.iconURL);
            JOptionPane.showMessageDialog(this, "Mozilla Bookmark Sorter 1.3.2\nCopyright 2003-2005 Corey Taylor\nThis is free (GNU GPL) software\nhttp://www.versaqual.com/mbs/", "About", 1, this.icon);
        } else {
            JOptionPane.showMessageDialog(this, "Mozilla Bookmark Sorter 1.3.2\nCopyright 2003-2005 Corey Taylor\nThis is free (GNU GPL) software\nhttp://www.versaqual.com/mbs/", "About", 1, new ImageIcon("icons" + File.separator + "mbs64.gif"));
        }
    }

    void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    String getMBSError(Exception exception) {
        String string = exception.getMessage();
        exception.printStackTrace();
        return string;
    }

    private void initComponents() {
        this.bookmarkFileChooser = new JFileChooser();
        this.sortProgressBar = new JProgressBar();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setTitle("Mozilla Bookmark Sorter");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MBSGUI.this.exitForm(windowEvent);
            }
        });
        this.sortProgressBar.setBorder(new TitledBorder(null, "Open a bookmark file to start sorting", 0, 0, new Font("Dialog", 0, 12)));
        this.sortProgressBar.setPreferredSize(new Dimension(275, 55));
        this.getContentPane().add((Component)this.sortProgressBar, "Center");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open a Bookmark File...");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MBSGUI.this.openMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MBSGUI.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MBSGUI.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.loader = this.getClass().getClassLoader();
        this.iconURL = this.loader.getResource("icons/mbs16.gif");
        if (this.iconURL != null) {
            this.icon = new ImageIcon(this.iconURL);
            this.setIconImage(this.icon.getImage());
        } else {
            this.icon = new ImageIcon("icons" + File.separator + "mbs16.gif");
            this.setIconImage(this.icon.getImage());
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    void openMenuItemActionPerformed(ActionEvent actionEvent) {
        this.bookmarkFileChooser.setDialogTitle("Open a Bookmark File");
        if (this.bookmarkFileChooser.showOpenDialog(this) == 0) {
            this.bookmarkFile = this.bookmarkFileChooser.getSelectedFile();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    try {
                        ((TitledBorder)MBSGUI.this.sortProgressBar.getBorder()).setTitle("Sorting " + MBSGUI.this.bookmarkFile.getName() + "...");
                        MBSGUI.this.sortProgressBar.setIndeterminate(true);
                        MBSGUI.this.sortProgressBar.repaint();
                        new MBS(MBSGUI.this.bookmarkFile);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(MBSGUI.this, MBSGUI.this.getMBSError(exception), "Error", 0);
                        return exception;
                    }
                    return null;
                }

                public void finished() {
                    if (this.getValue() != null) {
                        MBSGUI.this.sortProgressBar.setIndeterminate(false);
                        MBSGUI.this.sortProgressBar.repaint();
                        ((TitledBorder)MBSGUI.this.sortProgressBar.getBorder()).setTitle("Open a bookmark file to start sorting");
                        return;
                    }
                    ((TitledBorder)MBSGUI.this.sortProgressBar.getBorder()).setTitle("Finished sorting " + MBSGUI.this.bookmarkFile.getName());
                    MBSGUI.this.sortProgressBar.setIndeterminate(false);
                    MBSGUI.this.sortProgressBar.repaint();
                }
            };
            swingWorker.start();
        }
    }
}

