/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.mbs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import org.mozdev.mbs.Bookmark;
import org.mozdev.mbs.MBS;

public class Folder
implements Comparable {
    private ArrayList bookmarks = new ArrayList();
    private Collator collator = Collator.getInstance();
    private String description = null;
    private String line;
    private Folder parent;
    private String separator;
    private ArrayList subFolders = new ArrayList();

    public Folder(String string, Folder folder) {
        this.line = string;
        this.parent = folder;
        this.separator = null;
    }

    public void addBookmark(Bookmark bookmark) {
        this.bookmarks.add(bookmark);
    }

    public void addSubFolder(Folder folder) {
        this.subFolders.add(folder);
    }

    public int compareTo(Object object) {
        return this.collator.compare(this.getName(), ((Folder)object).getName());
    }

    public Folder find(String string) {
        Folder folder = null;
        for (int i = 0; i < this.subFolders.size(); ++i) {
            folder = (Folder)this.subFolders.get(i);
            if (folder.line().equals(string)) {
                return folder;
            }
            if ((folder = folder.find(string)) == null) continue;
            return folder;
        }
        return folder;
    }

    public ArrayList getBookmarks() {
        return this.bookmarks;
    }

    public Bookmark getLastBookmark() {
        if (this.bookmarks.size() == 0) {
            return null;
        }
        return (Bookmark)this.bookmarks.get(this.bookmarks.size() - 1);
    }

    public String getName() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = n = this.line.indexOf("\">");
        n3 = n = this.line.indexOf("</H3>");
        String string = this.line.substring(n2 += 2, n3);
        return string;
    }

    public Folder getParent() {
        return this.parent;
    }

    public ArrayList getSubFolders() {
        return this.subFolders;
    }

    public int level() {
        return MBS.getFolderLevel(this.line);
    }

    public String line() {
        return this.line;
    }

    public void outputFolder(ArrayList arrayList) {
        int n;
        String string = "";
        for (n = 0; n < (this.level() + 1) * 4; ++n) {
            string = string + " ";
        }
        if (this.separator != null) {
            arrayList.add(this.separator);
        }
        arrayList.add(this.line);
        if (this.description != null) {
            arrayList.add(this.description);
        }
        arrayList.add(string.concat("<DL><p>"));
        for (n = 0; n < this.subFolders.size(); ++n) {
            ((Folder)this.subFolders.get(n)).outputFolder(arrayList);
        }
        for (n = 0; n < this.bookmarks.size(); ++n) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(n);
            if (bookmark.preSeparator() != null) {
                arrayList.add(bookmark.preSeparator());
            }
            arrayList.add(bookmark.line());
            if (bookmark.description() != null) {
                arrayList.add(bookmark.description());
            }
            if (bookmark.postSeparator() == null) continue;
            arrayList.add(bookmark.postSeparator());
        }
        arrayList.add(string.concat("</DL><p>"));
    }

    public String separator() {
        return this.separator;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void sortBookmarks() {
        Collections.sort(this.bookmarks);
    }

    public void sortSubFolders() {
        for (int i = 0; i < this.subFolders.size(); ++i) {
            Folder folder = (Folder)this.subFolders.get(i);
            folder.sortSubFolders();
        }
        if (this.subFolders.size() > 1) {
            Collections.sort(this.subFolders);
        }
    }

    public String toString() {
        int n;
        String string = "";
        for (n = 0; n < this.level() * 4; ++n) {
            string = string + " ";
        }
        string = string + "[" + this.getName() + "]\n";
        if (this.parent != null) {
            for (n = 0; n < this.level() * 4; ++n) {
                string = string + " ";
            }
            string = string + "Parent: " + this.parent.getName() + "\n";
        }
        for (n = 0; n < this.level() * 4; ++n) {
            string = string + " ";
        }
        string = string + "Bookmarks: ";
        for (n = 0; n < this.bookmarks.size(); ++n) {
            string = string + ((Folder)this.bookmarks.get(n)).getName();
            if (n + 1 == this.bookmarks.size()) continue;
            string = string + ", ";
        }
        string = string + "\n";
        if (this.subFolders.size() > 0) {
            for (n = 0; n < this.subFolders.size(); ++n) {
                string = string + this.subFolders.get(n).toString();
            }
        }
        return string;
    }
}

