/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.toolkit;

import javax.swing.ImageIcon;
import javax.swing.JButton;

public class MToolbarButton
extends JButton {
    private ImageIcon mLargeImage;
    private ImageIcon mSmallImage;
    private String mButtonTitle;
    private byte mButtonMode;
    private byte mPictureMode;
    public static final byte LARGE_PICTURE = 0;
    public static final byte SMALL_PICTURE = 1;
    public static final byte IMAGE_AND_TEXT = 0;
    public static final byte IMAGE_ONLY = 1;
    public static final byte TEXT_ONLY = 2;

    public MToolbarButton(String string) {
        this.mButtonMode = (byte)2;
        this.setText(string);
        this.updateButtonStatus();
    }

    public MToolbarButton(String string, String string2, String string3) {
        this.setSmallImg(string2);
        this.setLargeImg(string3);
        this.mButtonMode = 0;
        this.mPictureMode = 1;
        this.setText(string);
    }

    public void setPictureMode(byte by) {
        this.mPictureMode = by;
        this.updateButtonStatus();
    }

    public void setButtonMode(byte by) {
        this.mButtonMode = by;
        this.updateButtonStatus();
    }

    public void setLargeImg(String string) {
        try {
            this.mLargeImage = new ImageIcon(MToolbarButton.class.getResource(string), "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateButtonStatus();
    }

    public void setSmallImg(String string) {
        try {
            this.mSmallImage = new ImageIcon(MToolbarButton.class.getResource(string), "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateButtonStatus();
    }

    public void setText(String string) {
        this.mButtonTitle = string;
        super.setText(string);
        this.updateButtonStatus();
    }

    public String getText() {
        return this.mButtonTitle;
    }

    private void updateButtonStatus() {
        this.mButtonTitle = this.mButtonMode != 1 ? super.getText() : "";
        if (this.mButtonMode != 2) {
            if (this.mPictureMode != 0) {
                super.setIcon(this.mSmallImage);
            } else {
                super.setIcon(this.mLargeImage);
            }
        } else {
            super.setIcon(null);
        }
    }
}

