<?php
include_once('Field.class');
include_once('Row.class');
include_once('Preferences.class');
include_once('Form.class');
include_once('FormLabel.class');
include_once('FormRadio.class');
include_once('FormSelect.class');
include_once('FormInput.class');
include_once('FormPassword.class');
include_once('FormSubmit.class');
include_once('Column.class');
include_once('Database.class');
include_once('Preferences.class');
include_once('Transliterate_eo_EO.class');
include_once('Transliterate_cy_GB.class');
include_once('session.php');

$l10nzilla_login_lastLine = null;
$l10nzilla_login_lastRow = null;


l10nzilla_main();

// ------------------------------------------------
function l10nzilla_main()
{
global	$mySession;

	$preferences = & new Preferences();

	checkSession();

	$database = & new Database(
	$preferences->databaseServer,
	$preferences->databaseName,
	$preferences->databaseUser,
	$preferences->databasePassword);
	$form = & new Form("Login");

	Header("Content-type: text/html; charset=UTF-8");
	$mySession->ini_page();

	l10nzilla_login_processActions($form,$database);

	if ($mySession->translatorID == -1)
	{
		prologue_login();
		l10nzilla_login_form($form,$database);
		print $form->getHtml();
	}
	else
	{
		prologue_loggedin();
	}
	$mySession->end_page();
}
// ------------------------------------------------
function prologue_login()
{
	$message = _("Please enter your username and password");
	print "<p>$message</p>";
}
// ------------------------------------------------
function prologue_loggedin()
{
	$message = _("You have succesfully logged in.  Please use the menu to start working");
	print "<p>$message</p>";
}
// ------------------------------------------------
function l10nzilla_login_form(& $form,& $database)
{
	$gtl = & new Group(_("Translator Login"));

	$gtl->setExtraAttributes($gtl->buildAttribute("align","center"));

	// -----------------------------------
	$xrow = & new Row();

	$xfield = & new FormLabel(_("Translator"));
	$xrow->addColumn($xfield);
	$xfield = & new FormInput("translator_login");
	$xfield->useFormValueIfPresent();
	$xrow->addColumn($xfield);
	$xfield = & new FormLabel(_("Password"));
	$xrow->addColumn($xfield);
	$xfield = & new FormPassword("translator_password");
	$xfield->useFormValueIfPresent();
	$xrow->addColumn($xfield);

	$xfield = & new FormSubmit("Login",_("Login"));
	$xrow->addColumn($xfield);

	$gtl->addRow($xrow);
	// -----------------------------------
	$form->addGroup($gtl);
}
// ------------------------------------------------
function l10nzilla_login_processActions(& $form,& $database)
{
	// Don't do anything if "Login" was not pressed
	if ($form->getFormValue("Login") === FALSE)
		return;

	$translator_login = $form->getFormValue("translator_login");
	$translator_password = $form->getFormValue("translator_password");
	$sql = "select * from Translators where
	Translator_Login = '$translator_login' and
	Translator_Password = '$translator_password'";
//print $sql;
	$result = $database->query($sql);
	if (($therow = $database->getRow($result)) !== FALSE)
	{
	global $mySession;

		$mySession->translatorID = $therow["Translator_ID"];
		$mySession->translatorLanguage = $therow["Translator_Language"];

		$transliterationClass = "Transliterate_" .
		$mySession->translatorLanguage;

		if (file_exists($transliterationClass . ".class"))
		{
			$mySession->transliteration = & getInstanceOfClass(
			$transliterationClass);
		}

		$gok = & new Group();
		$gok->setExtraAttributes($gok->buildAttribute("align","center"));

		// -----------------------------------
		$xrow = & new Row();
		$xfield = & new FormLabel($therow["Translator_Name"]);
		$xrow->addColumn($xfield);
		$gok->addRow($xrow);

		$xrow = & new Row();
		$xfield = & new FormLabel(_("You are now logged in."));
		$xrow->addColumn($xfield);
		$gok->addRow($xrow);

		$xrow = & new Row();
		$xfield = & new FormLabel(_("Please use the menu to start translating."));
		$xrow->addColumn($xfield);
		$gok->addRow($xrow);
		// -----------------------------------
		$nform = & new Form("LoggedIn");
		$nform->addGroup($gok);

		$form =  $nform;
	}
	else
	{
		$gerr = & new Group();
		$gerr->setExtraAttributes($gerr->buildAttribute("align","center"));

		// -----------------------------------
		$xrow = & new Row();

		$xfield = & new FormLabel(
		"<h2>" . _("Invalid translator/password") . "</h2>");
		$xrow->addColumn($xfield);

		$gerr->addRow($xrow);
		// -----------------------------------
		$form->addGroup($gerr);
	}
}
// ------------------------------------------------
function        getInstanceOfClass($nameClass)
{
	if (class_exists($nameClass) == FALSE)
		include_once("$nameClass.class");

	$obj = & new $nameClass;

	return $obj;
}
?>
