#!/bin/bash
# batch script to convert files
# called by dtd2pot, pot2po, po2dtd
# syntax:
# batch.sh src dest
# needs envvars:
#  srcext      - source extension e.g. .dtd
#  destext     - dest extension e.g. .pot
#  scriptname  - calling script name e.g. dtd2pot
#  convertcmd  - the command to run to convert the files

# get the environment variables from the directory of this script
homedir=`dirname $0`
. $homedir/env.sh

# handle the required environment variables from calling script
if [[ $srcext == '' ]] ; then
 echo read build.sh - not being called properly - srcext not set
fi
if [[ $destext == '' ]] ; then
 echo read build.sh - not being called properly - destext not set
fi
if [[ $scriptname == '' ]] ; then
 echo read build.sh - not being called properly - scriptname not set
fi
if [[ $convertcmd == '' ]] ; then
 echo read build.sh - not being called properly - convertcmd not set
fi

echo $convertcmd

# handle the arguments

# check if enough arguments
if [[ $2 == '' ]] ; then
 echo syntax:   $scriptname src dest   where
 echo \ \ src is the source directory/file
 echo \ \ dest is the destination directory
 echo all .$srcext files in the src directory/subdirs will be 
 echo written as .$destext files in the same structure in the dest directory
 echo existing files will be overwritten
 exit
fi

# check src argument
if [[ -e $1 ]] ; then
 if [[ -d $1 ]] ; then
  inputdir=$1
  inputset=`find $1 -name \*.$srcext -printf %P\  `
 else
  inputdir=`dirname $1`
  inputset=`basename $1`
 fi
else
 echo cannot find src file/directory $1
 echo enter $scriptname without parameters for syntax/help
 exit
fi

# check dest argument
if [[ -d $2 ]] ; then
 outputdir=$2
else
 echo cannot find output directory $2
 echo please create the output directory
 echo enter $scriptname without parameters for syntax/help
 exit 
fi

echo $scriptname running...

# run the operations
for f in $inputset ; do
  inputfile=$inputdir/$f
  outputsubdir=$outputdir/`dirname $f`
  # create subdirs as neccessary
  if [[ ! -d $outputsubdir ]] ; then
    echo creating directory $outputsubdir ...
    mkdir -p $outputsubdir
  fi
  outputfile=$outputsubdir/`basename $inputfile .$srcext`.$destext
  # tell the user which file we're doing, and do it...
  echo $inputfile -\> $outputfile
  $convertcmd $inputfile $outputfile
done

