#!/usr/bin/perl

use File::Path;
use POSIX ":sys_wait_h";

$timeout = 60;

%{ENV}->{"MOZILLA_FIVE_HOME"}="/usr/lib/mozilla-1.0.0";
%{ENV}->{"LD_LIBRARY_PATH"}="/usr/lib/mozilla-1.0.0";

umask 022;

if ( -f "/usr/lib/mozilla-1.0.0/regxpcom" )
{
    # remove all of the old files
    rmtree("/usr/lib/mozilla-1.0.0/chrome/overlayinfo");
    unlink </usr/lib/mozilla-1.0.0/chrome/*.rdf>;
    unlink("/usr/lib/mozilla-1.0.0/component.reg");

    # crate a new clean path
    mkpath("/usr/lib/mozilla-1.0.0/chrome/overlayinfo");

    # run regxpcom
    $pid = fork();

    # I am the child.
    if ($pid == 0) {
	exec("/usr/lib/mozilla-1.0.0/regxpcom > /dev/null 2> /dev/null");
    }
    # I am the parent.
    else {
	my $timepassed = 0;
	do {
	    $kid = waitpid($pid, &WNOHANG);
	    sleep(1);
	    $timepassed++;
        } until $kid == -1 || $timepassed > $timeout;

	# should we kill?
	if ($timepassed > $timeout) {
	    kill (9, $pid);
	}
    }

    # and run regchrome for good measure
    $pid = fork();

    # I am the child.
    if ($pid == 0) {
	exec("/usr/lib/mozilla-1.0.0/regchrome > /dev/null 2> /dev/null");
    }
    # I am the parent.
    else {
	my $timepassed = 0;
	do {
	    $kid = waitpid($pid, &WNOHANG);
	    sleep(1);
	    $timepassed++;
        } until $kid == -1 || $timepassed > $timeout;

	# should we kill?
	if ($timepassed > $timeout) {
	    kill (9, $pid);
	}
    }

}

