/*$Id: fkStreamListener.h,v 1.11 2006/08/20 16:39:54 jwrobel Exp $*/

/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKSTREAMLISTENER_H
#define FKSTREAMLISTENER_H

#include "fkHttpChannel.h"
#include "fkSentence.h"
#include "nsISupports.h"
#include "nsISupportsUtils.h"
#include "nsWeakReference.h"
#include "nsIStreamListener.h"
#include "nsIRequestObserver.h"
#include "nsIHttpHeaderVisitor.h"

#include "nsEmbedString.h"

#include "ActiveRuleSet.h"

/*Intrusion Detection System operating mode*/
#define IDS_MODE 1

/*Intrusion Prevention System operating mode*/
#define IPS_MODE 2

#define BODY_INIT_SIZE    4096
#define HEADERS_INIT_SIZE 1024

class fkStreamListener : public nsIStreamListener
                       , public nsIHttpHeaderVisitor
{
public:
	fkStreamListener(nsIStreamListener *origListener, fkHttpChannel *channel, 
			 fkISentence *sentence, ActiveRuleSet *connRules);
	virtual ~fkStreamListener();

	NS_DECL_ISUPPORTS
        NS_DECL_NSISTREAMLISTENER
        NS_DECL_NSIREQUESTOBSERVER
        NS_DECL_NSIHTTPHEADERVISITOR

private:
	nsCOMPtr<nsIStreamListener> origListener;
	
	NS_IMETHODIMP checkBody(char *body, int bodylen);
	
	NS_IMETHODIMP do_OnDataAvailable(nsIRequest *request, nsISupports* acontext,
					 PRUint32 aSourceOffset);
	NS_IMETHODIMP do_OnDataAvailable(nsIRequest* request, nsISupports *aContext, 
					 PRUint32 aSourceOffset, char *buffer, PRUint32 aCount);
	
	NS_IMETHODIMP headers_append(const char *src, PRUint32 len);
	NS_IMETHODIMP expandBuf(char **buf, PRUint32 len, PRUint32 end, PRUint32 &max_size);
	
	void drawFlushPoint();
	void drawNoFlushPoint();
	const char* getURL();
	char *body;
	char *headers;
	nsEmbedCString url;
	
	PRUint32 body_len, headers_len, body_max, headers_max;
	PRUint32 offset;
	nsCOMPtr<fkISentence> sentence;
	fkHttpChannel *channel;	
	ActiveRuleSet *connRules;
	
	bool debugNoHeaders;
	PRUint32 flush_point;
	PRUint32 no_flush_point;
};

#endif
