/*$Id: fkHttpHandlerFactory.cpp,v 1.5 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

/* to make NS_IMPL_THREADSAFE_ISUPPORTS* work*/
#ifdef MOZILLA_STRICT_API
#undef MOZILLA_STRICT_API
#endif

#ifdef XPCOM_GLUE
#undef XPCOM_GLUE
#endif

#include "nsISupportsImpl.h"
#define MOZILLA_STRICT_API
#define XPCOM_GLUE

#include "fkHttpHandlerFactory.h"
#include "Error.h"

fkHttpHandlerFactory::fkHttpHandlerFactory(fkHttpHandler *httpHandler)
{
	TRACE("factory called");
	this->httpHandler = httpHandler;
}

fkHttpHandlerFactory::~fkHttpHandlerFactory()
{
}

NS_IMPL_THREADSAFE_ISUPPORTS1(fkHttpHandlerFactory, nsIFactory)


NS_IMETHODIMP
fkHttpHandlerFactory::CreateInstance(nsISupports *aOuter, const nsIID & iid, void * *result)
{
	TRACE("create instance called");
	if (!result)
		return NS_ERROR_INVALID_ARG;
	
	nsresult rv = httpHandler->QueryInterface(iid, result);

	if (NS_FAILED(rv)) {
		*result = nsnull;
	}

	return rv;
}


NS_IMETHODIMP
fkHttpHandlerFactory::LockFactory(PRBool lock)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

