/*$Id: fkHttpChannel.h,v 1.8 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKHTTPCHANNEL_H
#define FKHTTPCHANNEL_H

#include "nsISupports.h"
#include "nsISupportsUtils.h"
#include "nsWeakReference.h"

#include "nsIHttpChannel.h"
#include "nsIHttpChannelInternal.h"
#include "nsIStreamListener.h"
#include "nsICachingChannel.h"
#include "nsIUploadChannel.h"
#include "nsICacheListener.h"
#include "nsIEncodedChannel.h"
#include "nsITransport.h"
#include "nsIResumableChannel.h"
#include "nsISupportsPriority.h"
#include "nsIProtocolProxyCallback.h"
#include "nsIWritablePropertyBag.h"
#include "nsIWritablePropertyBag2.h"

#include "fkISentence.h"
#include "fkSentence.h"

#include "Rules.h"
#include "ActiveRuleSet.h"
#include "Error.h"

class fkHttpChannel : public nsIHttpChannel
                    , public nsIHttpChannelInternal
                    , public nsIStreamListener
                    , public nsICachingChannel
                    , public nsIUploadChannel
                    , public nsICacheListener
                    , public nsIEncodedChannel
                    , public nsITransportEventSink
                    , public nsIResumableChannel
                    , public nsISupportsPriority
                    , public nsIProtocolProxyCallback
		    , public nsIWritablePropertyBag
		    , public nsIWritablePropertyBag2
{
public:
//  NS_DECL_ISUPPORTS_INHERITED
    NS_DECL_ISUPPORTS

    NS_DECL_NSIREQUEST
    NS_DECL_NSICHANNEL
    NS_DECL_NSIHTTPCHANNEL
    NS_DECL_NSIREQUESTOBSERVER
    NS_DECL_NSISTREAMLISTENER
    NS_DECL_NSICACHINGCHANNEL
    NS_DECL_NSIUPLOADCHANNEL
    NS_DECL_NSICACHELISTENER
    NS_DECL_NSIENCODEDCHANNEL
    NS_DECL_NSIHTTPCHANNELINTERNAL
    NS_DECL_NSITRANSPORTEVENTSINK
    NS_DECL_NSIRESUMABLECHANNEL
    NS_DECL_NSISUPPORTSPRIORITY
    NS_DECL_NSIPROTOCOLPROXYCALLBACK

    NS_DECL_NSIPROPERTYBAG
    NS_DECL_NSIPROPERTYBAG2
    NS_DECL_NSIWRITABLEPROPERTYBAG
    NS_DECL_NSIWRITABLEPROPERTYBAG2


    fkHttpChannel(nsIChannel *origChannel, fkISentence *sentence, ActiveRuleSet *connRules);

 private:
    virtual ~fkHttpChannel();

    ActiveRuleSet *connRules;
    
    nsCOMPtr<fkISentence> sentence;
    
    nsCOMPtr<nsIRequest> origRequest;
    nsCOMPtr<nsIChannel> origChannel;
    nsCOMPtr<nsIHttpChannel> origHttpChannel;    
    nsCOMPtr<nsIRequestObserver> origRequestObserver;
    nsCOMPtr<nsIStreamListener> origStreamListener;
    nsCOMPtr<nsICachingChannel> origCachingChannel;
    nsCOMPtr<nsIUploadChannel> origUploadChannel;
    nsCOMPtr<nsICacheListener> origCacheListener;
    nsCOMPtr<nsIEncodedChannel> origEncodedChannel;
    nsCOMPtr<nsIHttpChannelInternal> origHttpChannelInternal;
    nsCOMPtr<nsITransportEventSink> origTransportEventSink;
    nsCOMPtr<nsIResumableChannel> origResumableChannel;
    nsCOMPtr<nsISupportsPriority> origSupportsPriority;
    nsCOMPtr<nsIProtocolProxyCallback> origProtocolProxyCallback;

    nsCOMPtr<nsIPropertyBag> origPropertyBag;
    nsCOMPtr<nsIPropertyBag2> origPropertyBag2;
    nsCOMPtr<nsIWritablePropertyBag> origWritablePropertyBag;
    nsCOMPtr<nsIWritablePropertyBag2> origWritablePropertyBag2;

    void checkResult(nsresult rv, const char *iname){
	    if (NS_FAILED(rv))
		    err_msg("Can't get reference to %s interface %d", iname, rv);    
    }
    
};


#endif
