/*$Id: Rules.h,v 1.3 2006/10/06 19:31:40 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULES_H
#define RULES_H

#include "Common.h"
#include "Rule.h"
#include "Error.h"
#include "str_search.h"



/*map action_id to set of rules with this action*/
typedef map<int, set<Rule *> > RuleSet;


#define URL_CONTENT     0
#define HEADERS_CONTENT 1
#define BODY_CONTENT    2

#define NACTIONS 3
extern const char *knownActions[];
/*TODO: more configurable*/

extern SearchAPI *searchAPI;


/*
  Holds all loaded rules. Every new HTTP channel creates its own ActiveRuleSet
  with Rules from this structure.
 */
class Rules
{
 private:	
	/*set of all rules (including these without any *_content options*/
	RuleSet ruleSet;
	
	/*
	  Set of rules that don't have any *_content options.	  
	 */
	RuleSet noContentRules;	
	

	/*Used to inform http channel that new rules are loaded 
	  and old ones shouldn't be used (to prevent access to freed Rule 
	  structures)*/
	unsigned int rulesVersion;

 public:
	Rules();
	int init();
	~Rules();
	
	RuleSet* getNoContentRuleSet();
	void addRule(Rule *);	
	void resetRules();	
	
	unsigned int getRulesVersion();
};

#endif
