unit MainForm;
{Main Form unit for Demo1, a simple demo of running JavaScript in SpiderMonkey }
{Part of the Mozilla-Delphi Project: http://delphi.mozdev.org/ }

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Bridge Demo1.
 *
 * The Initial Developer of the Original Code is
 * Theo Lustenberger <theo@theo.ch>.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Dave Murray <irongut@vodafone.net>
 *   Dominique Louis <dominique@savagesoftware.com.au>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)

interface

uses
  SysUtils, Variants, Classes, QGraphics, QForms, QControls, QStdCtrls,
  QExtCtrls, QComCtrls, QButtons, QDialogs, JSBrowser;

type
  TfrmMain = class(TForm)
    stbrStatus: TStatusBar;
    pnlLeft: TPanel;
    pnlMiddle: TPanel;
    pnlRight: TPanel;
    lblScript: TLabel;
    mmScript: TMemo;
    btnRun: TBitBtn;
    mmResult: TMemo;
    lblResult: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnRunClick(Sender: TObject);
  private
    { Private declarations }
    procedure OnStatus(Sender: TObject);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  Brws:TBrowserBase;

implementation

{$R *.xfm}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Brws := TBrowserBase.Create;
  Brws.OnStatus := OnStatus;
  Brws.WriteObj := mmResult.Lines;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  Brws.Free;
end;

procedure TfrmMain.BtnRunClick(Sender: TObject);
begin
  Brws.RunScript(mmScript.Text);
end;

procedure TfrmMain.OnStatus(Sender: TObject);
begin
  stbrStatus.SimpleText := Brws.Status;
end;

end.
