/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
/*
    nickcolors plugin for ChatZilla
    Copyright (C) 2004  John J Foerch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

var State = {
    styleSheets: new Array(),
    nicknames: new Object(),
    palette: ['#112ac6','#539be2','#161066','#40234c','#073f93','#2c6ccc','#265121','#04422c','#c40909','#d8d508','#ed6e00','#e80032','#8c0b0b','#e4aa04','#750000'],
    hashFunc: sumCharCodes
}
/*
State.nicknames is an object whose keys are nicknames
and whose values are hash codes for those nicknames.  By storing the
hash codes here, we can ensure that nick changes will not change the
display color of the nick.
*/




function initPlugin () {

    plugin.name = 'nickcolors';
    plugin.author = 'John J Foerch';
    plugin.major = 0;
    plugin.minor = 11;
    plugin.version = plugin.major + '.' + plugin.minor;
    plugin.description = 'colorizes nicknames with a hashing algorithm.';

    //create stylesheets for channels and queries
    for (var i = 0; i < client.viewsArray.length; ++i) {
        if ('source' in client.viewsArray[i] &&
            'TYPE' in client.viewsArray[i].source && 
            client.viewsArray[i].source.TYPE == 'IRCChannel' ||
            client.viewsArray[i].source.TYPE == 'IRCUser') {

            //create a stylesheet
            var m = createDynamicStyleSheet(client.viewsArray[i].source.frame,'nickcolors');
            if (m) {
                State.styleSheets.push (m);
            } else {
                display ('no stylesheet created');
            }
            //get all nicknames
            if (client.viewsArray[i].source.TYPE == 'IRCUser') {
                var user = client.viewsArray[i].source;
                var nick = ('unicodeName' in user ? user.unicodeName : user.properNick);
                State.nicknames[nick] = State.hashFunc(nick);
            } else {//channel
                var users = client.viewsArray[i].source.users;
                for (var j in users) {
                    var k = ('unicodeName' in users[j] ? users[j].unicodeName : users[j].properNick);
                    State.nicknames[k] = State.hashFunc(k);
                }
            }
        }
    }

    //add a timer to call back makeInitialStyleRules()
    setTimeout (makeInitialStyleRules,1000);


//note: only hook methods for adding new users to list;
//cannot delete users from list, because their nickname will still
//be in the message buffer.
//alternately, if we want to be memory conscious, we could
//set lightgray as the default color for nicknames,
//and do maintenence when people part and when channel windows close.
//then one could tell at a glance if an individual had parted.
//the nickname would be gray.


//setup notification for all new channel and query windows


//hook onjoin to add definitions for new users
//    client.eventPump.addHook ([{set:'channel', type:'join'}], colorizer_onJoin, 'colorizer-join-hook');
    client.eventPump.addHook([{set:"network", type:"nick"}], colorizer_onNick, "jgr-nick-change-hook");

//hook onquery



    display (replaceColorCodes ('%C06') +
             plugin.id + ' plugin version ' + plugin.version + ' loaded.');

}

function makeInitialStyleRules () {
    for (var u in State.nicknames) {
        individualUserRule(u);
    }
}

function individualUserRule (user) {
    var hashnum = State.nicknames[user];
    var pal_idx = State.nicknames[user] % State.palette.length;
    var k = State.palette[pal_idx];
    var selector = selectorForIndividual (user);
    var style = "{color: "+ k + " !important;}";
    var rule = selector + style;
    for (var i = 0; i < State.styleSheets.length; ++i)
        State.styleSheets[i].insertRule(rule,0);
}

function selectorForIndividual (user) {
    var selector = ".msg[msg-user^=\"" + user + "\"] .msg-user, .msg[msg-user^=\"" + user + "\"] .msg-user a";
    return selector;
}

function sumCharCodes (v) {
    var t=0;
    for (var a = 0; a < v.length; ++a) {
        t += v.charCodeAt(a);
    }
    return t;
}

//Parameters
// frame: frame to which to attach new stylesheet
// id: id string. this will be the id attribute in the <link> tag
// cssrules: a css string. this is optional.
//
//eg usage: r = getContentWindow (client.viewsArray[0].source.frame)
//
// /load file:///home/jjf/projects/chatzilla/scripts/dyncss/init.js
// m = createDynamicStyleSheet (client.viewsArray[0].source.frame,'test')
// dumpObject (m)
//
//important: include an id string.
createDynamicStyleSheet =
function createDynamicStyleSheet (frame,id,cssrules) {

    if (!frame) {return;}
    if (!id) {id = 'dynamic-style-sheet';}
    if (!cssrules) {cssrules = '';}

    var cwin = getContentWindow(frame);
    if (!cwin) { return; }
    var url = 'data:text/css,' + encodeURIComponent(cssrules);
    
    cwin.changeCSS(url, id);
    
    return frame.contentDocument.styleSheets[(frame.contentDocument.styleSheets.length - 1)];
}


function colorizer_onNick (e) {
    var newNick = ('unicodeName' in e.user ? e.user.unicodeName : e.user.properNick);
    if (e.oldNick in State.nicknames) {
        State.nicknames[newNick] = State.nicknames[e.oldNick];
    } else {
        State.nicknames[newNick] = State.hashFunc(e.oldNick);
    }
    display ('new: '+newNick +' old: '+e.oldNick);
    individualUserRule(newNick);
}


function colorizer_onJoin (e) {
    var nick = ('unicodeName' in e.user ? e.user.unicodeName : e.user.properNick);
    State.nicknames[nick] = State.hashFunc(nick);
    individualUserRule(nick);
}


var bright_colors = ['black','blue','blueviolet','brown','burlywood','cadetblue','chartreuse','chocolate','coral','cornflowerblue','crimson','darkblue','darkcyan','darkgoldenrod','darkgreen','darkmagenta','darkolivegreen','darkorange','darkorchid','darkred','darkseagreen','darkslateblue','darkslategray','darkturquoise','darkviolet','darkpink','deepskyblue','dimgray','dodgerblue','feldspar','firebrick','forestgreen','fuchsia','gold','goldenrod','gray','green','greenyellow','hotpink','indianred','indigo','lawngreen','lightblue','lightcoral','lightgreen','lightsalmon','lightseagreen','lightskyblue','lightslateblue','lightslategray','lightsteelblue','lime','limegreen','magenta','maroon','mediumaquamarine','mediumblue','mediumorchid','mediumpurple','mediumseagreen','mediumslateblue','mediumspringgreen','mediumturquoise','mediumvioletred','midnightblue','navy','olive','olivedrab','orange','orangered','orchid','palegreen','palevioletred','peru','pink','plum','purple','red','rosybrown','royalblue'];


var mirc_colors = ['#000000','#c8c8c8','#0000c8','#00c800','#c80000','#c8c800','#c800c8','#ffb000','#ffff00','#00ff00','#00c8c8','#00ffff','#0000ff','#ff00ff','#808080','#989898'];

var warm_and_cool = ['#112ac6','#539be2','#161066','#40234c','#073f93','#2c6ccc','#265121','#04422c','#c40909','#d8d508','#ed6e00','#e80032','#8c0b0b','#e4aa04','#750000'];
