/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal class DirectiveFile : NameValueFile
{

public DirectiveFile(string path) : base(path)
{
}

public override void LoadContent()
{
    m_content = this.LoadText();
}

public override Merge GetMerge()
{
    return new MergeDirective(this);
}

public override Dictionary<string, string> LoadHashtableLogged()
{
    string section = string.Empty;
    Dictionary<string, string> table = new Dictionary<string, string>();
    List<string> lines = Strings.SplitLines(m_content);

    for (int idx = 0; idx < lines.Count; idx++) {
        string[] keyValue = ParseDirectiveLine(lines[idx]);
        if (keyValue != null) {
            NameValueFile.AddToHashtable(table, keyValue[0], keyValue[1], m_path);
        }
    }

    return table;
}

public override Dictionary<string, string> LoadHashtable()
{
    string section = string.Empty;
    Dictionary<string, string> table = new Dictionary<string, string>();
    List<string> lines = Strings.SplitLines(m_content);
    for (int idx = 0; idx < lines.Count; idx++) {
        string[] keyValue = ParseDirectiveLine(lines[idx]);
        if (keyValue != null) {
            NameValueFile.AddToHashtable(table, keyValue[0], keyValue[1], null);
        }
    }

    return table;
}

/*
# Installer keys (don't translate strings in $$)
#define   SETUP_TITLE       $ProductShortName$ Setup
*/
public static string[] ParseDirectiveLine(string line)
{
    if (line == null) {
        return null;
    }

    line = line.TrimStart();

    Regex regex = new Regex(@"^#define\s+(\w+)\s*(.*)");
    MatchCollection translatedMatches = regex.Matches(line);
    if (translatedMatches.Count < 1) {
        return null;
    }

    GroupCollection groups = translatedMatches[0].Groups;
    return new string[] { groups[1].Value, groups[2].Value };
}

}//class
}//ns
