/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import mozilla_training_analyzer.AboutBox;
import mozilla_training_analyzer.Analyzer;
import mozilla_training_analyzer.RemoveTokenWindow;
import mozilla_training_analyzer.TableSorter;
import mozilla_training_analyzer.TrainingData;
import mozilla_training_analyzer.TrainingDataTableModel;

public class TableWindow
extends JFrame {
    private static final String WINDOW_TITLE = "Training Data Token Table";
    private static final int WINDOW_WIDTH = 600;
    private static final int WINDOW_HEIGHT = 500;
    private TrainingData parentTrainer = null;
    private String outputFilename = null;
    private TrainingDataTableModel tableModel;
    private JFileChooser fc = new JFileChooser();
    private String lastOpenDirectory = null;
    private String lastSaveDirectory = null;
    private String lastImportDirectory = null;
    private JLabel filenameLabel = null;
    private JLabel selectedTokens = new JLabel("0");
    private JLabel totalTokens = null;

    public TableWindow(TrainingData trainingData, String string) {
        super(WINDOW_TITLE);
        String string2;
        this.lastOpenDirectory = string2 = new File(string).getParent();
        this.lastSaveDirectory = string2;
        this.lastImportDirectory = string2;
        this.parentTrainer = trainingData;
        this.setSize(600, 500);
        this.tableModel = new TrainingDataTableModel(trainingData);
        final TableSorter tableSorter = new TableSorter(this.tableModel);
        this.tableModel.addTableModelListener(tableSorter);
        final JTable jTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(600, 500));
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (!defaultListSelectionModel.isSelectionEmpty()) {
                    TableWindow.this.getTableWindow().selectedTokens.setText(String.valueOf(defaultListSelectionModel.getMaxSelectionIndex() - defaultListSelectionModel.getMinSelectionIndex() + 1));
                } else {
                    TableWindow.this.getTableWindow().selectedTokens.setText("0");
                }
            }
        });
        defaultListSelectionModel.setSelectionMode(1);
        jTable.setSelectionModel(defaultListSelectionModel);
        TableColumn tableColumn = null;
        for (int i = 0; i < tableSorter.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(400);
                continue;
            }
            tableColumn.setPreferredWidth(50);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.addActionListener(new ActionListener(){
            private FileFilter saveFileFilter = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".xml") || file.getAbsolutePath().toLowerCase().endsWith(".dat");
                }

                public String getDescription() {
                    return "XML or Data file (*.xml, *.dat)";
                }
            };

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = TableWindow.this.getTableWindow().fc;
                jFileChooser.setDialogTitle("Select Mozilla Bayesian Filter Training File");
                jFileChooser.setCurrentDirectory(new File(TableWindow.this.getTableWindow().lastOpenDirectory));
                jFileChooser.resetChoosableFileFilters();
                jFileChooser.addChoosableFileFilter(this.saveFileFilter);
                File file = null;
                String string = null;
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    string = file.getAbsolutePath();
                    TableWindow.this.getTableWindow().lastOpenDirectory = file.getParent();
                    try {
                        TrainingData trainingData = Analyzer.parseTrainingFile(string, true);
                        if (trainingData == null && (trainingData = Analyzer.parseXMLTrainingFile(string, true)) == null) {
                            return;
                        }
                        TableWindow.this.tableModel.setNewTrainingData(trainingData);
                        TableWindow.this.getTableWindow().parentTrainer = trainingData;
                        TableWindow.this.getTableWindow().filenameLabel.setText(string);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                }
            }
        });
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem jMenuItem2 = new JMenuItem("Import and Merge...");
        jMenuItem2.addActionListener(new ActionListener(){
            private FileFilter importFileFilter = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".xml") || file.getAbsolutePath().toLowerCase().endsWith(".dat");
                }

                public String getDescription() {
                    return "XML or Data file (*.xml, *.dat)";
                }
            };

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = TableWindow.this.getTableWindow().fc;
                jFileChooser.setDialogTitle("Select Mozilla Bayesian Filter Training File");
                jFileChooser.setCurrentDirectory(new File(TableWindow.this.getTableWindow().lastImportDirectory));
                jFileChooser.resetChoosableFileFilters();
                jFileChooser.addChoosableFileFilter(this.importFileFilter);
                File file = null;
                String string = null;
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    string = file.getAbsolutePath();
                    TableWindow.this.getTableWindow().lastImportDirectory = file.getParent();
                    try {
                        System.out.println("Checking if " + string + " is a Mozilla token file...");
                        TrainingData trainingData = Analyzer.parseTrainingFile(string, true);
                        if (trainingData == null) {
                            System.out.println("Checking if " + string + " is an XML token file...");
                            trainingData = Analyzer.parseXMLTrainingFile(string, true);
                        }
                        if (trainingData == null) {
                            System.out.println(string + " was not a valid Mozilla token file or XML token file.");
                            return;
                        }
                        TrainingData trainingData2 = TableWindow.this.tableModel.getTrainingData();
                        trainingData.setGoodMessageCount(trainingData.getGoodMessageCount() + trainingData2.getGoodMessageCount());
                        trainingData.setBadMessageCount(trainingData.getBadMessageCount() + trainingData2.getBadMessageCount());
                        trainingData.setTokenSet(Analyzer.mergeTokenLists(trainingData.getTokenSet(), trainingData2.getTokenSet()));
                        TableWindow.this.tableModel.setNewTrainingData(trainingData);
                        TableWindow.this.getTableWindow().parentTrainer = trainingData;
                        System.out.println("Import complete!");
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        System.out.println(string + " was not a valid Mozilla token file or XML token file.");
                    }
                }
            }
        });
        jMenuItem2.setMnemonic(73);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        JMenuItem jMenuItem3 = new JMenuItem("Close Window");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWindow.this.wakeAll();
                TableWindow.this.getTableWindow().hide();
                TableWindow.this.getTableWindow().dispose();
            }
        });
        jMenuItem3.setMnemonic(87);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        JMenuItem jMenuItem4 = new JMenuItem("Save As...");
        jMenuItem4.addActionListener(new ActionListener(){
            private TrainingFileFilter xmlFileFilter = new TrainingFileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".xml");
                }

                public String getDescription() {
                    return "Output as XML (*.xml)";
                }

                public int getFilterOutputType() {
                    return 3;
                }
            };
            private TrainingFileFilter htmlFileFilter = new TrainingFileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".html") || file.getAbsolutePath().toLowerCase().endsWith(".htm");
                }

                public String getDescription() {
                    return "Output as HTML (*.htm, *.html)";
                }

                public int getFilterOutputType() {
                    return 2;
                }
            };
            private TrainingFileFilter datFileFilter = new TrainingFileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".dat");
                }

                public String getDescription() {
                    return "Output as data (*.dat)";
                }

                public int getFilterOutputType() {
                    return 4;
                }
            };
            private TrainingFileFilter textFileFilter = new TrainingFileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().toLowerCase().endsWith(".txt");
                }

                public String getDescription() {
                    return "Output as Plaintext (*.txt)";
                }

                public int getFilterOutputType() {
                    return 1;
                }
            };

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JFileChooser jFileChooser = TableWindow.this.getTableWindow().fc;
                jFileChooser.setDialogTitle("Choose Output Format and Filename");
                jFileChooser.setCurrentDirectory(new File(TableWindow.this.getTableWindow().lastSaveDirectory));
                jFileChooser.resetChoosableFileFilters();
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.addChoosableFileFilter(this.xmlFileFilter);
                jFileChooser.addChoosableFileFilter(this.htmlFileFilter);
                jFileChooser.addChoosableFileFilter(this.textFileFilter);
                jFileChooser.addChoosableFileFilter(this.datFileFilter);
                if (TableWindow.this.outputFilename != null) {
                    jFileChooser.setSelectedFile(new File(TableWindow.this.outputFilename));
                }
                if ((n = jFileChooser.showSaveDialog(TableWindow.this.getTableWindow())) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getAbsolutePath().toLowerCase();
                    TableWindow.this.getTableWindow().lastSaveDirectory = file.getParent();
                    TrainingFileFilter trainingFileFilter = (TrainingFileFilter)jFileChooser.getFileFilter();
                    switch (trainingFileFilter.getFilterOutputType()) {
                        case 4: {
                            if (string.endsWith(".dat")) break;
                            file = new File(file.getAbsolutePath() + ".dat");
                            break;
                        }
                        case 3: {
                            if (string.endsWith(".xml")) break;
                            file = new File(file.getAbsolutePath() + ".xml");
                            break;
                        }
                        case 2: {
                            if (string.endsWith(".htm") && string.endsWith(".html")) break;
                            file = new File(file.getAbsolutePath() + ".html");
                            break;
                        }
                        case 1: {
                            if (string.endsWith(".txt")) break;
                            file = new File(file.getAbsolutePath() + ".txt");
                        }
                    }
                    try {
                        Analyzer.writeOutput(file, TableWindow.this.getTableWindowTrainer(), trainingFileFilter.getFilterOutputType());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        });
        jMenuItem4.setMnemonic(83);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem jMenuItem5 = new JMenuItem("Add New Row");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(TableWindow.this.getTableWindow(), (Object)"Please enter a Token string");
                if (string != null) {
                    TableWindow.this.tableModel.addRow(string);
                }
            }
        });
        jMenuItem5.setMnemonic(78);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        JMenuItem jMenuItem6 = new JMenuItem("Remove Selected Rows");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.getSelectedRowCount() != 0) {
                    TableWindow.this.tableModel.removeRows(tableSorter.lookupRows(jTable.getSelectedRows()));
                } else {
                    JOptionPane.showMessageDialog(TableWindow.this.getTableWindow(), "No rows were selected.");
                }
            }
        });
        jMenuItem6.setMnemonic(82);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenuItem jMenuItem7 = new JMenuItem("Remove Tokens by Count...");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RemoveTokenWindow(TableWindow.this.getTableWindow()).show();
            }
        });
        jMenuItem7.setMnemonic(84);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        JMenuItem jMenuItem8 = new JMenuItem("About");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox.display(TableWindow.this.getTableWindow());
            }
        });
        jMenuItem8.setMnemonic(66);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenu2.add(jMenuItem5);
        jMenu2.add(jMenuItem6);
        jMenu2.addSeparator();
        jMenu2.add(jMenuItem7);
        jMenuBar.add(jMenu2);
        jMenu3.add(jMenuItem8);
        jMenuBar.add(jMenu3);
        jMenu.setMnemonic(70);
        jMenu2.setMnemonic(69);
        jMenu3.setMnemonic(72);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        this.filenameLabel = new JLabel(string);
        jPanel.add((Component)this.filenameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)this.selectedTokens, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)new JLabel("/"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.totalTokens = new JLabel(String.valueOf(this.parentTrainer.getTokenSet().size()));
        jPanel.add((Component)this.totalTokens, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)new JLabel(" tokens selected"), gridBagConstraints);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TableWindow.this.getTableWindow().totalTokens.setText(String.valueOf(TableWindow.this.tableModel.getRowCount()));
            }
        });
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TableWindow.this.wakeAll();
            }
        });
    }

    private TableWindow getTableWindow() {
        return this;
    }

    public TrainingData getTableWindowTrainer() {
        return this.parentTrainer;
    }

    public void setOutputFilename(String string) {
        this.outputFilename = string;
    }

    public void setNewTrainingData(TrainingData trainingData) {
        this.parentTrainer = trainingData;
        this.tableModel.setNewTrainingData(trainingData);
    }

    protected synchronized void wakeAll() {
        this.notifyAll();
    }

    public synchronized void waitForWindow() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private abstract class TrainingFileFilter
    extends FileFilter {
        private TrainingFileFilter() {
        }

        public abstract int getFilterOutputType();
    }
}

