/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TargetFactory {
    public static final int WINDOWS = 0;
    public static final int UNIX = 2;
    public static final int GENERIC = 3;
    public static final int STANDARD = 0;
    public static final int NT = 1;
    public static final int X = 2;
    public static final int X86 = 0;
    public static final int OTHER = 1;
    static final String[] LIBRARY_EXTENSION = new String[]{"dll", "so", "", ""};
    static final String[] CLASS_PREFIX = new String[]{"Win_", "Mac_", "Unix_", ""};
    static final String[] CLASS_FLAVOR_PREFIX = new String[]{"", "NT_", "X_"};
    static final String[] CLASS_ARCHITECTURE_PREFIX = new String[]{"X86_", "U_"};
    static final String[] INSTALL_PATH_FRAGMENT = new String[]{"Program Files" + File.separator, "/Applications" + File.separator, "/usr/local" + File.separator, File.separator + "apps" + File.separator};
    static final String[][] INSTALL_PATH_RESOURCE_KEY = new String[][]{{"TargetPanel.dir.windows", "TargetPanel.dir.windows", ""}, {"TargetPanel.dir.mac", "", "TargetPanel.dir.macosx"}, {"TargetPanel.dir.unix", "", ""}, {"TargetPanel.dir", "", ""}};
    private static final String VERSION_DELIMITER = ".-";
    private static TargetFactory me = null;
    private int os = -1;
    private int osFlavor = -1;
    private int architecture = -1;
    private String version = System.getProperty("os.version");

    private TargetFactory() {
        if (OsVersion.IS_WINDOWS) {
            this.os = 0;
            this.osFlavor = 0;
            this.architecture = 0;
            String osName = OsVersion.OS_NAME.toLowerCase();
            if (osName.indexOf("nt") > -1) {
                this.osFlavor = 1;
            } else if (osName.indexOf("2000") > -1) {
                this.osFlavor = 1;
            } else if (osName.indexOf("xp") > -1) {
                this.osFlavor = 1;
            }
        } else if (OsVersion.IS_OSX) {
            this.os = 2;
            this.osFlavor = 0;
            this.architecture = 1;
        } else {
            this.os = 2;
            this.osFlavor = 0;
            this.architecture = 1;
            String osName = OsVersion.OS_NAME.toLowerCase();
            if (osName.indexOf("x86") > -1) {
                this.architecture = 0;
            }
        }
    }

    public static TargetFactory getInstance() {
        if (me == null) {
            me = new TargetFactory();
        }
        return me;
    }

    public Object makeObject(String name) throws Exception {
        int nameStart = name.lastIndexOf(46) + 1;
        String packageName = name.substring(0, nameStart);
        String className = name.substring(nameStart, name.length());
        try {
            String actualName = packageName + CLASS_PREFIX[this.os] + CLASS_FLAVOR_PREFIX[this.osFlavor] + className;
            Class<?> temp = Class.forName(actualName);
            return temp.newInstance();
        }
        catch (Throwable exception1) {
            try {
                Class<?> temp = Class.forName(packageName + CLASS_PREFIX[this.os] + className);
                return temp.newInstance();
            }
            catch (Throwable exception2) {
                try {
                    String actualName = name;
                    Class<?> temp = Class.forName(actualName);
                    return temp.newInstance();
                }
                catch (Throwable exception3) {
                    throw new Exception("can not instantiate class " + name);
                }
            }
        }
    }

    public boolean versionIsHigher(String version) throws Exception {
        StringTokenizer targetVersion = new StringTokenizer(this.version, VERSION_DELIMITER);
        StringTokenizer compareVersion = new StringTokenizer(version, VERSION_DELIMITER);
        while (targetVersion.hasMoreTokens() && compareVersion.hasMoreTokens()) {
            int compare;
            int target;
            try {
                target = Integer.parseInt(targetVersion.nextToken());
                compare = Integer.parseInt(compareVersion.nextToken());
            }
            catch (Throwable exception) {
                throw new Exception("error in version string");
            }
            if (compare > target) {
                return true;
            }
            if (target <= compare) continue;
            return false;
        }
        return false;
    }

    public int getOS() {
        return this.os;
    }

    public int getOSFlavor() {
        return this.osFlavor;
    }

    public int getArchitecture() {
        return this.architecture;
    }

    public String getNativeLibraryExtension() {
        return LIBRARY_EXTENSION[this.os];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultInstallPath(String appName) {
        String path = null;
        String keyFragment = "/res/" + INSTALL_PATH_RESOURCE_KEY[3][0];
        InputStream input = this.getClass().getResourceAsStream("/res/" + INSTALL_PATH_RESOURCE_KEY[this.os][this.osFlavor]);
        if (input == null) {
            String key = OsVersion.OS_NAME.toLowerCase().replace(' ', '_');
            key = keyFragment + key.toLowerCase();
            input = TargetFactory.class.getResourceAsStream(key);
        }
        if (input == null) {
            input = TargetFactory.class.getResourceAsStream(keyFragment);
        }
        if (input != null) {
            BufferedReader reader = null;
            try {
                InputStreamReader streamReader = new InputStreamReader(input);
                reader = new BufferedReader(streamReader);
                String line = reader.readLine();
                while (line != null && "".equals(line = line.trim())) {
                    line = reader.readLine();
                }
                path = line;
            }
            catch (Throwable exception) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable exception) {}
            }
        }
        if (path == null || "".equals(path)) {
            path = "";
            if (this.os == 0) {
                String home = System.getProperty("user.home");
                path = home.substring(0, home.indexOf(File.separatorChar) + 1);
            }
            path = path + INSTALL_PATH_FRAGMENT[this.os] + appName;
        }
        return path;
    }

    public static String getCurrentOSPrefix() {
        String OSName = System.getProperty("os.name").toLowerCase();
        String OSArch = System.getProperty("os.arch").toLowerCase();
        int OS = 0;
        int OSFlavor = 0;
        boolean OSarchitecture = false;
        if (OSName.indexOf("windows") > -1) {
            OS = 0;
            OSFlavor = 0;
            OSarchitecture = false;
            if (OSName.indexOf("nt") > -1) {
                OSFlavor = 1;
            } else if (OSName.indexOf("2000") > -1) {
                OSFlavor = 1;
            } else if (OSName.indexOf("xp") > -1) {
                OSFlavor = 1;
            }
        } else if (OSName.indexOf("mac") > -1) {
            OS = 3;
            OSFlavor = 0;
            OSarchitecture = true;
            if (OSName.indexOf("macosx") > -1) {
                OSFlavor = 2;
            }
        } else {
            OS = 2;
            OSFlavor = 0;
            OSarchitecture = true;
            if (OSArch.indexOf("86") > -1) {
                OSarchitecture = false;
            }
        }
        return CLASS_PREFIX[OS] + CLASS_FLAVOR_PREFIX[OSFlavor];
    }
}

