.\"                        -*- nroff -*-
.ig /
groff_tmac.5

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000 Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de>

Last update: 17 May 2000

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
./
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.\" text lines in macro definitions or bracketed sections \{...\}
.de text
.  if 1 \&\\$*\&
..
.
.de BIR
.  ie (\\n[.$] < 3) \
.    BI \\$@
.  el \{\
.    ds @tmp@ \fB\\$1\fP\fI\\$2\fP
.    shift 2
.    text \\*[@tmp@]\fR\\$*\fP
.    rm @tmp@
.  \}
..
.
.de 'char
.  ds @tmp@ `\f(CB\\$1\fP'
.  shift
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de option
.  ds @tmp@ \f(CB\\$1\fP
.  shift 1
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.als shellcommand option
.
.de argument
.  ds @tmp@ \f(CI\\$1\fP
.  shift 1
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.de request
.  ds @tmp@ \f(CB\\$1\fP
.  shift 1
.  text \\*[@tmp@]\\$*
.  rm @tmp@
..
.
.\" --------------------------------------------------------------------
.\" Title
.\" --------------------------------------------------------------------
.TH GROFF_TMAC @MAN5EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_tmac \- macro files in the roff typesetting system
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
The
.BR roff (@MAN7EXT@)
type-setting system provides a set of macro packages suitable for
special kinds of documents.  Each macro package stores its macros and
definitions in a file called the package's
.BR "tmac file" .
The name is deduced from
.RB ` T roff
.BR MAC ros'.
.LP
The tmac files are normal roff source documents, except that they
usually contain only definitions and setup commands, but no text.  All
tmac files are kept in a single or a small number of directories, the
.B tmac
directories.
.\" --------------------------------------------------------------------
.SH NAMING
.\" --------------------------------------------------------------------
In classical roff systems, there was a funny naming scheme.
If the name of a macro package started with
.'char m
this letter was omitted, e.g., the macro package for the man pages
.I man
was called
.I an
and its macro file
.I tmac.an
(note that in recent versions of groff this file is called
.I an.tmac
instead).
.LP
By a similar reasoning, macro packages that did not start with an
.'char m
were often referred to by adding an
.'char m ,
e.g., the package corresponding to
.I tmac.doc
was called
.I mdoc
because the command-line for activating it reads
.RS
.LP
.BIR "troff\ \-m" doc .
.RE
.LP
Actual versions of
.BR groff (@MAN1EXT@)
provide both naming schemes for the inflicted macro packages, with and
without the leading
.'char m .
So in
.IR groff ,
the
.I man
macro package may be specified as
.RS
.LP
.BIR "groff\ \-m\ " man ,
.br
.BIR "groff\ \-m" an ,
.br
.BIR "groff\ \-m" man , or
.br
.BIR "groff\ \-m " an .
.RE
.LP
The easiest way to find out which macro packages are available on a
system is to check the contents of the
.I tmac
directories.
For example, a file called
.BI tmac. anything
or
.IB anything .tmac
determines a macro package named
.IR anything .
.LP
In
.IR groff ,
most macro packages are described in man pages called
.BR groff_<name> (@MAN7EXT@),
with a leading
.'char m
for the classical packages.
.\" --------------------------------------------------------------------
.SH INCLUSION
.\" --------------------------------------------------------------------
There are several ways to use a macro package in documents.  At
run-time, the groff option
.option \-m \ \c
.argument name
makes the definitions in the macro file
.IB name .tmac
available as described in the section
.BR NAMING .
If this file isn't found,
.BI tmac. name
will be searched.
.LP
It is also possible to include the macro file into the document by using
the groff requests
.request .so
or
.request .mso .
For
.request .so
the full filename of the macro file must be specified \(em including the
directory where it is kept.
If the macro file is stored in one of the tmac directories it is more
convenient to use
.request .mso
instead because it searches the tmac path for the filename.
Additionally, if the file name to be included has the form
.IB name .tmac
and it isn't found,
.request .mso
will try to open
.BI tmac. name
instead and vice versa.
.LP
Note that in order to resolve the
.request .so
and
.request .mso
requests the roff preprocessor
.shellcommand soelim
must be called if the files to be included needs preprocessing.
This can be done either directly by a pipeline on the command line or by
using the
.option \-s
option of
.shellcommand groff .
.LP
You can also supply the letter
.'char s
in the preprocessor word as described in section
.BR CONVENTION .
.LP
For example, suppose a macro file is stored as
.I @MACRODIR@/macros.tmac
and is used in some document called
.IR docu.roff .
.LP
At run-time, the formatter call for this is
.RS
.LP
.ft CR
.shellcommand "groff\ \-m"
.argument macros
.argument docu.roff
.ft P
.RE
.LP
To include the macro file directly in the document either
.RS
.ft CR
\&\.mso macros.tmac
.ft P
.RE
is used or
.RS
.ft CR
\&\.so @MACRODIR@/macros.tmac
.ft P
.RE
.LP
In both cases, the formatter is called with
.ft CR
.RS
groff\ \-s docu.roff
.RE
.ft P
.
.\" --------------------------------------------------------------------
.SH CONVENTION
.\" --------------------------------------------------------------------
.LP
There is a convention that is supported by many modern roff
type-setters: the
.B preprocessor word
described in the following.
.LP
If the first line in a document is a comment, the first word (after the
comment characters and a blank) constitutes the
.B preprocessor
.BR word .
That means that the letters of this word are interpreted as
abbreviations for those preprocessor commands that should be run
when formatting the document.  Mostly, only the letters corresponding to
the options for the preprocessors are recognized,
.'char e ,
.'char G ,
.'char g ,
.'char p ,
.'char R ,
.'char s , and
.'char t
(see
.BR roff (@MAN7EXT@)).
.LP
Besides being a good reminder for the user, some formatters (like the
.BR man (1)
program) are even able to automatically start the preprocessors
specified in the preprocessor word, but do not bet on this.
.\" --------------------------------------------------------------------
.SH "WRITING A MACRO FILE"
.\" --------------------------------------------------------------------
Writing a groff macro file is easy.  Design a set of macros, strings,
registers, etc.  Store them in a single file.  Documents that use the
macros include this macro file with the
.request .so
request as described in the
.B INCLUSION
section.
.LP
To use the tmac functionality, call the macro file
.IB whatever .tmac
(or
.BI tmac. whatever\c
) and put it in some directory of the tmac path, cf. section
.BR FILES .
Then documents can include it with the
.request .mso
request or the
.shellcommand "groff\ \-m"
option as described in the
.B INCLUSION
section.
.LP
If your macros might be of general usage contact the groff maintainers
to have them included in the groff
.I contrib
source directory.
.LP
Some general guidelines might be helpful in writing macros.
.IP \(bu 2m
Double all functional backslashes,
.'char \e
->
.'char \e\e .
.IP \(bu 2m
All printable backslashes must be written as
.'char \ee .
.IP \(bu 2m
Escape all dots,
.'char .
->
.'char \e. .
.IP \(bu 2m
Make ample use of the non-printable character
.'char \e&
in text parts, esp. before
.'char \e
and at the beginning of a line, but not before a delayed command.
.IP \(bu 2m
Use the character
.'char @
in temporary variable names.
.IP \(bu 2m
Test your macros for text and graphical devices, e.g.,
.I latin1
and
.IR ps .
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
All macro names must be named
.IB name .tmac
or
.BI tmac. name
to use the tmac mechanism.
.LP
The macro files are kept in the
.B tmac
.BR directories ,
all of which constitute the
.B tmac
.BR path.
.LP
The elements of the search path for macro files are (in that order):
.IP \(bu 4
the directories specified with troff's resp. groff's
.B \-M
command line option
.IP \(bu 4
the directories given in the
.B GROFF_TMAC_PATH
environment variable
.IP \(bu 4
the current directory (only if in unsafe mode using the
.B \-U
command line switch)
.IP \(bu 4
the home directory
.IP \(bu 4
a site-specific (platform-independent) directory, a platform-specific
directory, and the main tmac directory:
.IP "" 6
@LOCALMACRODIR@
.br
@SYSTEMMACRODIR@
.br
@MACRODIR@
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.TP
.B GROFF_TMAC_PATH
A colon separated list of additional tmac directories in which to search
for macro files.
See the previous section for a detailed description.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
The groff documentation is in evolution at the moment.  It is possible
that small inconsistencies between different documents exist
temporarily.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
This document is part of groff, the GNU roff distribution.  It was
written by Bernd Warken <bwarken@mayn.de>.
.LP
It is distributed under the terms of the FDL (GNU Free Documentation
License) version 1.1 or later.  You should have received a copy of the
FDL on your system, it is also available on-line under
.RS
.LP
.IR <http://www.gnu.org/copyleft/fdl.html> .
.RE
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
The authoritative source of information for all details of the groff
system is the groff
.BR info (1)
file.
.LP
For a groff overview, see
.BR roff (@MAN7EXT@)
and the file
.I README
in the groff source package.
.LP
The groff tmac macro packages are
.BR groff_man (@MAN7EXT@),
.BR groff_mwww (@MAN7EXT@),
.BR groff_mdoc (@MAN7EXT@),
.BR groff_mdoc.samples (@MAN7EXT@),
.BR groff_me (@MAN7EXT@),
.BR groff_mm (@MAN7EXT@),
.BR groff_mmroff (@MAN7EXT@),
and
.BR groff_ms (@MAN7EXT@).
.LP
The groff language is described in
.BR groff (@MAN7EXT@)
and the formatters in
.BR groff (@MAN1EXT@),
.BR troff (@MAN1EXT@).
.LP
The Filesystem Hierarchy Standard (FHS) is available at
.BR http://www.pathname.com/fhs/ .
