#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

"""Probe for a connected USRP and set sink_c and source_c to the appropriate classes"""

__all__ = [ 'sink_c', 'source_c', 'sink_s', 'source_s']


import usrp_prims
from gnuradio import usrp0              # usrp Rev 0
from gnuradio import usrp1              # usrp Rev 1 and later

d = usrp_prims.usrp_find_device (0)
if not d:
    raise RuntimeError, "Unable to find a connected USRP"

if usrp_prims.usrp_usrp0_p (d):
    print "usrp: found usrp rev0"
    sink_c = usrp0.sink_c
    source_c = usrp0.source_c
elif usrp_prims.usrp_usrp1_p (d):
    print "usrp: found usrp rev1"
    sink_c = usrp1.sink_c
    source_c = usrp1.source_c
    sink_s = usrp1.sink_s
    source_s = usrp1.source_s
elif usrp_prims.usrp_usrp2_p (d):
    print "usrp: found usrp rev2"
    sink_c = usrp1.sink_c
    source_c = usrp1.source_c
    sink_s = usrp1.sink_s
    source_s = usrp1.source_s
else:
    raise RuntimeError, "Hmmm, unknown usrp rev"

d = None
