/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IWorkStealing;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IStructure<T>
implements IWorkStealing {
    protected volatile boolean abort = false;

    public abstract void add(T var1);

    public void add(T item, int i) {
        this.add(item);
    }

    public abstract T remove();

    public T get(int i) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isEmpty();

    public void shutdown() {
        this.abort = true;
    }

    @Override
    public void registerThread() {
    }

    protected static class Backoff {
        private final int minDelay;
        private final int maxDelay;
        private int limit;
        private final Random random;

        public Backoff(int min, int max) {
            this.minDelay = min;
            this.maxDelay = max;
            this.limit = this.minDelay;
            this.random = new Random(System.currentTimeMillis());
        }

        public void backoff() throws InterruptedException {
            int delay = this.random.nextInt(this.limit);
            this.limit = Math.min(this.maxDelay, 2 * this.limit);
            Thread.sleep(delay);
        }
    }

    protected static class Node<T> {
        public T value;
        public AtomicReference<Node<T>> next = new AtomicReference<Object>(null);

        public Node(T value) {
            this.value = value;
        }
    }
}

