/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CalibreLVSErrors {
    private Cell cell;
    private BufferedReader in;
    private boolean noPopupMessages;
    private int lineno;
    private String filename;
    private String type;
    private ErrorLogger logger;
    private List<LVSErrorGroup> groups;
    private double scale;
    private static final String spaces = "[\\s\\t ]+";
    private static final String coordinates = "[\\s\\t(,)]+";

    public static int importErrors(String filename, Cell cell, String type, boolean noPopupMessages) {
        BufferedReader in;
        try {
            FileReader reader = new FileReader(filename);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Error importing " + type + " Errors: " + e.getMessage());
            return -1;
        }
        CalibreLVSErrors errors = new CalibreLVSErrors(cell, in, type, noPopupMessages);
        errors.filename = filename;
        errors.readErrors();
        return errors.done();
    }

    CalibreLVSErrors(Cell cell, BufferedReader in, String type, boolean noPopupMessages) {
        assert (in != null);
        this.cell = cell;
        this.in = in;
        this.lineno = 0;
        this.type = type;
        this.groups = new ArrayList<LVSErrorGroup>();
        this.scale = cell.getTechnology().getScale();
    }

    private String readLine() throws IOException {
        return this.readLine(false);
    }

    private String readLine(boolean errorOnEOF) throws IOException {
        if (this.in == null) {
            return null;
        }
        String line = this.in.readLine();
        if (line == null && errorOnEOF) {
            System.out.println("Unexpected End of File!");
            this.in = null;
            return null;
        }
        ++this.lineno;
        return line;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readErrors() {
        ArrayList<String> linesToAnalyze = new ArrayList<String>();
        int errorLine = -1;
        int stage = -1;
        String layName = null;
        String srcName = null;
        LVSErrorNet net = null;
        LVSErrorGroup grp = null;
        try {
            while (true) {
                String[] parts;
                String nextLine;
                if ((nextLine = this.readLine()) == null) {
                    return true;
                }
                if ((nextLine = nextLine.trim()).isEmpty()) {
                    if (stage != 3 || linesToAnalyze.size() <= 0) continue;
                    net.neterrors.add(new LVSNError(linesToAnalyze, errorLine));
                    linesToAnalyze = new ArrayList();
                    errorLine = -1;
                    continue;
                }
                if (nextLine.toUpperCase().contains("LAYOUT CELL NAME")) {
                    parts = nextLine.split(spaces);
                    assert (parts.length == 4);
                    layName = parts[3];
                    continue;
                }
                if (nextLine.toUpperCase().contains("SOURCE CELL NAME")) {
                    parts = nextLine.split(spaces);
                    assert (parts.length == 4);
                    srcName = parts[3];
                    grp = null;
                    continue;
                }
                if (nextLine.toUpperCase().contains("INCORRECT NETS")) {
                    stage = 0;
                    continue;
                }
                if (nextLine.toUpperCase().contains("INCORRECT INSTANCES") || nextLine.toUpperCase().contains("INSTANCES OF CELLS WITH NON-FLOATING EXTRA PINS")) {
                    stage = 4;
                    continue;
                }
                if (nextLine.startsWith("***")) {
                    if (stage == 1) {
                        stage = 2;
                        continue;
                    }
                    if (stage == 5) {
                        stage = 6;
                        continue;
                    }
                    if (stage != 3 && stage != 7) continue;
                    if (stage == 7 && linesToAnalyze.size() > 0) {
                        grp.insterrors.add(new LVSNError(linesToAnalyze, errorLine));
                        linesToAnalyze = new ArrayList();
                        errorLine = -1;
                    }
                    stage = -1;
                    continue;
                }
                if (nextLine.startsWith("DISC#")) {
                    if (stage == 0) {
                        stage = 1;
                    } else if (stage == 4) {
                        stage = 5;
                    }
                    if (stage != 1 && stage != 5 || grp != null) continue;
                    grp = new LVSErrorGroup(layName, srcName, this.cell);
                    this.groups.add(grp);
                    srcName = null;
                    layName = null;
                    continue;
                }
                if (nextLine.contains("---")) {
                    if (stage == 3) {
                        if (nextLine.toLowerCase().contains("devices on")) continue;
                        if (linesToAnalyze.size() > 0) {
                            String firstElem = (String)linesToAnalyze.get(0);
                            if (firstElem.startsWith("(")) {
                                net.neterrors.add(new LVSNError(linesToAnalyze, errorLine));
                                errorLine = -1;
                                linesToAnalyze = new ArrayList();
                                stage = 2;
                                assert (false);
                                continue;
                            }
                            if (linesToAnalyze.size() != 1) continue;
                            linesToAnalyze = new ArrayList();
                            continue;
                        }
                        if (net.neterrors.size() <= 0) continue;
                        stage = 2;
                        continue;
                    }
                    if (stage != 7) continue;
                    grp.insterrors.add(new LVSNError(linesToAnalyze, errorLine));
                    linesToAnalyze = new ArrayList();
                    errorLine = -1;
                    stage = 6;
                    continue;
                }
                if (stage == 2) {
                    parts = nextLine.split(spaces);
                    assert (parts.length >= 4);
                    try {
                        stage = 3;
                        net = new LVSErrorNet(parts[1] + "-" + parts[2] + "-" + parts[3], this.lineno);
                        grp.nets.add(net);
                        errorLine = this.lineno;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (stage == 6) {
                    parts = nextLine.split(spaces);
                    assert (parts.length >= 2);
                    try {
                        stage = 7;
                        Object tmp = "";
                        for (int i = 1; i < parts.length; ++i) {
                            tmp = (String)tmp + parts[i] + "\t";
                        }
                        tmp = (String)tmp + parts[parts.length - 1];
                        linesToAnalyze.add((String)tmp);
                        errorLine = this.lineno;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (stage != 3 && stage != 7) continue;
                linesToAnalyze.add(nextLine);
                if (errorLine != -1) continue;
                errorLine = this.lineno;
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            return false;
        }
    }

    private int done() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.groups == null || this.groups.isEmpty()) {
            System.out.println("No erros found in '" + this.filename + "'");
            return -1;
        }
        this.logger = ErrorLogger.newInst("Calibre " + this.type + " Errors");
        int sortKey = 0;
        int count = 0;
        for (LVSErrorGroup v : this.groups) {
            int localCount = 0;
            for (LVSErrorNet netError : v.nets) {
                String netName = "Net '" + netError.netName + "'";
                localCount += this.collectErrors(netError.neterrors, netName, v.cell, sortKey, false);
                if (netError.neterrors.size() != 0) continue;
                this.logger.logMessageWithLines(netName + ". Line=" + netError.errorLine + ": ", null, null, this.cell, sortKey, true);
                ++localCount;
            }
            this.logger.setGroupName(sortKey, "(" + (localCount += this.collectErrors(v.insterrors, "Instance", v.cell, sortKey, false)) + ") Lay: '" + v.layName + "', Source: '" + v.srcName + "'");
            ++sortKey;
            count += localCount;
        }
        System.out.println(this.type + " Imported " + count + " errors from " + this.filename);
        if (count == 0 && !this.noPopupMessages) {
            Job.getUserInterface().showInformationMessage(this.type + " Imported Zero Errors", this.type + " Import Complete");
        }
        this.logger.termLogging(!this.noPopupMessages);
        return this.logger.getNumErrors();
    }

    private int collectErrors(List<LVSNError> errors, String name, Cell cell, int sortKey, boolean reportAll) {
        int localCount = 0;
        for (LVSNError lvsError : errors) {
            Object errorDesc = "";
            ArrayList<EPoint> elist = new ArrayList<EPoint>();
            for (String s : lvsError.info) {
                String[] parts;
                errorDesc = (String)errorDesc + s + "\n";
                if (!s.contains("(") || (parts = s.split(coordinates)).length <= 2) continue;
                try {
                    double px = this.scale * Double.parseDouble(parts[1]);
                    double py = this.scale * Double.parseDouble(parts[2]);
                    elist.add(EPoint.fromLambda(px, py));
                }
                catch (NumberFormatException e) {}
            }
            if (!reportAll && (reportAll || elist.size() <= 0)) continue;
            this.logger.logMessageWithLines(name + ". Line=" + lvsError.errorLine + ": " + (String)errorDesc, elist, null, cell, sortKey, true);
            ++localCount;
        }
        return localCount;
    }

    private static class LVSErrorNet {
        private final String netName;
        private List<LVSNError> neterrors;
        private final int errorLine;

        private LVSErrorNet(String netName, int errorLine) {
            this.netName = netName;
            this.errorLine = errorLine;
            this.neterrors = new ArrayList<LVSNError>();
        }
    }

    private static class LVSNError {
        private final List<String> info;
        private final int errorLine;

        private LVSNError(List<String> list, int line) {
            this.info = list;
            this.errorLine = line;
        }
    }

    static class LVSErrorGroup {
        private final String layName;
        private final String srcName;
        private final Cell cell;
        private List<LVSErrorNet> nets;
        private List<LVSNError> insterrors;

        private LVSErrorGroup(String layName, String srcName, Cell cell) {
            this.layName = layName;
            this.srcName = srcName;
            this.cell = cell;
            this.nets = new ArrayList<LVSErrorNet>();
            this.insterrors = new ArrayList<LVSNError>();
        }
    }
}

