/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.browser.IBrowserViewerContribution;
import org.xmind.ui.internal.browser.BrowserPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserContributionManager
extends RegistryReader {
    private static final String EXT_POINT_ID = "browserViewerContributions";
    private static final BrowserContributionManager instance = new BrowserContributionManager();
    private List<IBrowserViewerContribution> contributions;

    private BrowserContributionManager() {
    }

    public List<IBrowserViewerContribution> getContributions() {
        this.ensureLoaded();
        return this.contributions;
    }

    private void ensureLoaded() {
        if (this.contributions != null) {
            return;
        }
        this.lazyLoad();
        if (this.contributions == null) {
            this.contributions = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui.browser", EXT_POINT_ID);
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("contribution".equals(name)) {
            this.readContribution(element);
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    private void readContribution(IConfigurationElement element) {
        if (BrowserContributionManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
            BrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension: (class missing)"));
            return;
        }
        try {
            Object obj = element.createExecutableExtension("class");
            if (obj instanceof IBrowserViewerContribution) {
                this.registerContribution((IBrowserViewerContribution)obj);
            }
        }
        catch (CoreException e) {
            BrowserPlugin.log(e);
        }
    }

    private void registerContribution(IBrowserViewerContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<IBrowserViewerContribution>();
        }
        this.contributions.add(contribution);
    }

    public static BrowserContributionManager getInstance() {
        return instance;
    }
}

