/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceDomainDirector;
import org.xmind.core.internal.command.remote.Messages;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public class DefaultCommandServiceDomainDirector
implements ICommandServiceDomainDirector {
    private ICommandServiceDomain domain;
    private int connectionCount = 0;
    private int status = 1;
    private Object statusLock = new Object();

    public void init(ICommandServiceDomain domain) {
        this.domain = domain;
    }

    public ICommandServiceDomain getDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus connect(IProgressMonitor monitor) {
        IStatus activated;
        boolean shouldWait = false;
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == 3) {
                ++this.connectionCount;
                monitor.done();
                return Status.OK_STATUS;
            }
            if (this.status == 1) {
                this.status = 2;
            } else if (this.status == 2) {
                shouldWait = true;
            } else {
                return Status.CANCEL_STATUS;
            }
        }
        monitor.beginTask(NLS.bind((String)Messages.DefaultCommandServiceDomainDirector_ConnectionRemoteCommand, (Object)this.getDomain().getName()), 1);
        if (shouldWait) {
            try {
                while (true) {
                    object = this.statusLock;
                    synchronized (object) {
                        if (this.status == 3) {
                            ++this.connectionCount;
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                        if (this.status == 1 || this.status == 4) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    Thread.sleep(5L);
                }
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
        }
        try {
            activated = this.activate((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable e) {
            activated = new Status(4, "org.xmind.core.command.remote", null, e);
        }
        if (activated != null && !activated.isOK()) {
            Object e = this.statusLock;
            synchronized (e) {
                this.status = 4;
            }
            try {
                this.deactivate((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable e2) {
                RemoteCommandPlugin.log("Failed to deactivate command service domain.", e2);
            }
            Object object2 = this.statusLock;
            synchronized (object2) {
                this.status = 1;
                return activated;
            }
        }
        Object object3 = this.statusLock;
        synchronized (object3) {
            this.status = 3;
            ++this.connectionCount;
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus disconnect(IProgressMonitor monitor) {
        IStatus deactivated;
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == 1 || this.status == 4) {
                monitor.done();
                return Status.OK_STATUS;
            }
            if (this.status == 2) {
                return Status.CANCEL_STATUS;
            }
            --this.connectionCount;
            if (this.connectionCount > 0) {
                return Status.OK_STATUS;
            }
            this.status = 4;
        }
        monitor.beginTask(NLS.bind((String)Messages.DefaultCommandServiceDomainDirector_DisconnectionRemoteCommand, (Object)this.getDomain().getName()), 1);
        try {
            deactivated = this.deactivate((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable e) {
            deactivated = new Status(4, "org.xmind.core.command.remote", null, e);
        }
        Object object2 = this.statusLock;
        synchronized (object2) {
            this.status = 1;
        }
        return deactivated;
    }

    private IStatus activate(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 40);
        IStatus activated = this.getDomain().getRemoteCommandServiceDiscoverer().activate((IProgressMonitor)subMonitor);
        if (activated != null && !activated.isOK()) {
            return activated;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        subMonitor = new SubProgressMonitor(monitor, 30);
        IStatus deployed = this.getDomain().getCommandServer().deploy((IProgressMonitor)subMonitor);
        if (deployed != null && !deployed.isOK()) {
            return deployed;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        this.getDomain().getCommandServerAdvertiser().setRegisteringInfo(this.getDomain().getCommandServer().getRegisteringInfo());
        subMonitor = new SubProgressMonitor(monitor, 30);
        IStatus registered = this.getDomain().getCommandServerAdvertiser().register((IProgressMonitor)subMonitor);
        if (registered != null && !registered.isOK()) {
            return registered;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus deactivate(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        IStatus unregistered = this.getDomain().getCommandServerAdvertiser().unregister((IProgressMonitor)subMonitor);
        if (unregistered != null && !unregistered.isOK()) {
            return unregistered;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        subMonitor = new SubProgressMonitor(monitor, 30);
        IStatus undeployed = this.getDomain().getCommandServer().undeploy((IProgressMonitor)subMonitor);
        if (undeployed != null && !undeployed.isOK()) {
            return undeployed;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        subMonitor = new SubProgressMonitor(monitor, 40);
        IStatus deactivated = this.getDomain().getRemoteCommandServiceDiscoverer().deactivate((IProgressMonitor)subMonitor);
        if (deactivated != null && !deactivated.isOK()) {
            return deactivated;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        subMonitor.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Object object = this.statusLock;
        synchronized (object) {
            return this.status;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

