/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IRotatable;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.draw2d.graphics.Path;

public class RotatableLineBorder
extends LineBorder
implements IRotatable {
    private static PrecisionRectangle rect = new PrecisionRectangle();
    private PrecisionRotator rotator = new PrecisionRotator();

    public RotatableLineBorder() {
    }

    public RotatableLineBorder(Color color, int width) {
        super(color, width);
    }

    public RotatableLineBorder(Color color) {
        super(color);
    }

    public RotatableLineBorder(int width) {
        super(width);
    }

    public double getRotationDegrees() {
        return this.rotator.getAngle();
    }

    public void setRotationDegrees(double degrees) {
        this.rotator.setAngle(degrees);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setAntialias(1);
        graphics.setLineStyle(1);
        if (!Geometry.isSameAngleDegree(this.getRotationDegrees(), 0.0, 1.0E-5)) {
            this.paintRotatedBorder(figure, graphics, insets);
            return;
        }
        super.paint(figure, graphics, insets);
    }

    private void paintRotatedBorder(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RotatableLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        tempRect.shrink(this.rotator.t(new PrecisionInsets(super.getInsets(figure))).toDraw2DInsets());
        rect.setBounds(tempRect);
        this.rotator.setOrigin(RotatableLineBorder.rect.x + RotatableLineBorder.rect.width / 2.0, RotatableLineBorder.rect.y + RotatableLineBorder.rect.height / 2.0);
        rect = this.rotator.r(rect);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        Path p = new Path((Device)Display.getCurrent());
        p.moveTo(this.rotator.t(rect.getTopLeft()));
        p.lineTo(this.rotator.t(rect.getTopRight()));
        p.lineTo(this.rotator.t(rect.getBottomRight()));
        p.lineTo(this.rotator.t(rect.getBottomLeft()));
        p.close();
        graphics.drawPath((org.eclipse.swt.graphics.Path)p);
        p.dispose();
    }
}

